; @NUL0x4C | @mrd0x : MalDevAcademy


.data

; All the below variables are used in "AsmCallFunction" only

String1     byte    '[i] AsmCallFunction => This is a string: "%s" | This is a dword: %d | This is a word: %d | This is a byte: 0x%0.2X', 10, 0          
String2     byte    'Hello World!', 0
DwordVar    dword   213483
WordVar     word    23
ByteVar     byte    10

; The following string is used in "AsmHelloWorld"

HelloStr    byte    'Hello World !', 10, 0

externdef printf:PROC                               ; Declaring an external value as a procedure (printf in C) - used in "AsmCallFunction" & "AsmHelloWorld"



.code

;
;   A function that demonstrate the push & pop instructions and there affect on the stacl
;
SimplePushPop PROC
    
    push 3              ; rsp - 8
    push 2              ; rsp - 8
    push 1              ; rsp - 8

    mov eax, [rsp]      ; eax = 1
    mov ebx, [rsp + 8]  ; ebx = 1
    mov ecx, [rsp + 16] ; ecx = 1

    add rsp, 24         ; This substitutes x3 pop instructions

    ret

SimplePushPop ENDP


;
;   A function that demonstrate passing more than 4 parameters (on the stack)
;
AsmFunc11Parms PROC


    ; RCX => Parm1
    ; RDX => Parm2
    ; R8  => Parm3
    ; R9  => Parm4

    mov rax, qword ptr [rsp + 40]  ; Parm5
    mov rax, qword ptr [rsp + 48]  ; Parm6
    mov rax, qword ptr [rsp + 56]  ; Parm7
    mov rax, qword ptr [rsp + 64]  ; Parm8
    mov rax, qword ptr [rsp + 72]  ; Parm9
    mov rax, qword ptr [rsp + 80]  ; Parm10
    mov rax, qword ptr [rsp + 88]  ; Parm11

    ret

AsmFunc11Parms ENDP


;
;   A function that demonstrate returning values
;
AddtwoNumbers PROC
    mov rax, rcx    ; Moving the 1st parmeter to RAX
    add rax, rdx    ; Add the 2nd parmeter to the value in RAX
    ret             ; Return (RAX here is RCX + RDX)
AddtwoNumbers ENDP


;
;   A function that demonstrate shadow space allocation & cleanup
; 
AsmCallFunction PROC

    push rbp                        ; Setting up AsmCallFunction's shadow space
    mov rbp, rsp
    sub rsp, 48                     ; 32 bytes (4 parameters) + 8 bytes (5th parameter) + 8 byte (return address of printf)
    
    lea rcx, String1                ; 1st parameter 
    lea rdx, String2                ; 2nd parameter
    
    xor r8, r8                      ; 3rd parameter
    mov r8d, DwordVar   
    
    xor r9, r9                      ; 4th parameter
    mov r9w, WordVar    
    
    xor rax, rax                    ; 5th parameter   
    mov ah, ByteVar      
    mov byte ptr [rsp + 32], ah     ; '32' represent the size of the stack reserved for the register parameters of "AsmCallFunction". Thus a 5th parameter will start at this offset from RSP

    call printf                     ; Calling printf

    leave                           ; "mov rsp, rbp" & "pop rbp"
	ret


AsmCallFunction ENDP




;
;   A function that calls printf to print "Hello World!"
;
AsmHelloWorld PROC

    push rbp                     ; Setting up AsmCallFunction's shadow space
    mov rbp, rsp
    sub rsp, 40                  ; 32 bytes (4 parameters) + 8 byte (return address of printf)    

    lea rcx, HelloStr            ; Calling printf    
    call printf

    mov rsp, rbp                 ; Can be "leave"
    pop rbp
    ret

AsmHelloWorld ENDP



end