#include <Windows.h>

#include "Common.h"
#include "Lzw.h"
#include "Debug.h"


//\
https://github.com/NUL0x4C/ManualRsrcDataFetching

BOOL GetResourceData(IN HMODULE hModule, IN WORD ResourceId, OUT PVOID* ppResourceRawData, OUT PDWORD psResourceDataSize) {

	CHAR*					pBaseAddr			= (CHAR*)hModule;
	PIMAGE_DOS_HEADER 		pImgDosHdr			= (PIMAGE_DOS_HEADER)pBaseAddr;
	PIMAGE_NT_HEADERS 		pImgNTHdr			= (PIMAGE_NT_HEADERS)(pBaseAddr + pImgDosHdr->e_lfanew);
	PIMAGE_OPTIONAL_HEADER 	pImgOptionalHdr		= (PIMAGE_OPTIONAL_HEADER)&pImgNTHdr->OptionalHeader;
	PIMAGE_DATA_DIRECTORY 	pDataDir			= (PIMAGE_DATA_DIRECTORY)&pImgOptionalHdr->DataDirectory[IMAGE_DIRECTORY_ENTRY_RESOURCE];

	PIMAGE_RESOURCE_DIRECTORY 		pResourceDir		= NULL, pResourceDir2		= NULL, pResourceDir3		= NULL;
	PIMAGE_RESOURCE_DIRECTORY_ENTRY pResourceEntry		= NULL, pResourceEntry2		= NULL, pResourceEntry3		= NULL;
	PIMAGE_RESOURCE_DATA_ENTRY 		pResource			= NULL;


	pResourceDir	= (PIMAGE_RESOURCE_DIRECTORY)(pBaseAddr + pDataDir->VirtualAddress);
	pResourceEntry	= (IMAGE_RESOURCE_DIRECTORY_ENTRY*)(pResourceDir + 1);

	for (DWORD i = 0; i < (pResourceDir->NumberOfNamedEntries + pResourceDir->NumberOfIdEntries); i++) {

		if (pResourceEntry[i].DataIsDirectory == 0)
			break;

		pResourceDir2		= (PIMAGE_RESOURCE_DIRECTORY)(pBaseAddr + pDataDir->VirtualAddress + (pResourceEntry[i].OffsetToDirectory & 0x7FFFFFFF));
		pResourceEntry2		= (PIMAGE_RESOURCE_DIRECTORY_ENTRY)(pResourceDir2 + 1);

		if (pResourceEntry2->DataIsDirectory == 1 && pResourceEntry2->Id == ResourceId) {

			pResourceDir3	= (PIMAGE_RESOURCE_DIRECTORY)(pBaseAddr + pDataDir->VirtualAddress + (pResourceEntry2->OffsetToDirectory & 0x7FFFFFFF));
			pResourceEntry3 = (PIMAGE_RESOURCE_DIRECTORY_ENTRY)(pResourceDir3 + 1);
			pResource		= (PIMAGE_RESOURCE_DATA_ENTRY)(pBaseAddr + pDataDir->VirtualAddress + (pResourceEntry3->OffsetToData & 0x7FFFFFFF));

			*ppResourceRawData	= (PVOID)(pBaseAddr + (pResource->OffsetToData));
			*psResourceDataSize = pResource->Size;

			break;
		}

	}

	if (*ppResourceRawData != NULL && *psResourceDataSize != NULL)
		return TRUE;

	return FALSE;
}

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*
	Fetches the packed PE file from the resource secttion using "GetResourceData" and unpack it using "LzwDecompressData". It takes:
		* hModule: Local exe handle
		* wResourceId: Resource ID of the packed pe (LZW_PE_PAYLOAD_ID in Resource.h)
		* ppDecompressedPe: Pointer to a PBYTE variable that will be set to the base address of the decompressed data
		* psDecompressedPeSize: Pointer to a SIZE_T variable that will be set to the size of the decompressed data

*/
BOOL GetDecompressedResourcePayload(IN HMODULE hModule, IN WORD wResourceId, OUT PBYTE* ppDecompressedPe, OUT PSIZE_T psDecompressedPeSize) {

	PBYTE	pCompressedPe			= NULL;
	SIZE_T	sCompressedPeSize		= NULL;

	// Fetching packed PE from .rsrc section
	if (!GetResourceData(hModule, wResourceId, &pCompressedPe, &sCompressedPeSize)) {
#ifdef DEBUG
		PRINT("[!] GetResourceData Failed To Fetch The Resource Packed PE File - %s.%d \n", GET_FILENAME(__FILE__), __LINE__);
#endif 
		return FALSE;
	}

#ifdef DEBUG
	PRINT("[i] Resource Packed PE Location: 0x%p \n", pCompressedPe);
	PRINT("[i] Resource Packed PE Size: %d \n", sCompressedPeSize);
#endif 

	// Retrieving the size of the raw PE
	*psDecompressedPeSize = *(PSIZE_T)(pCompressedPe + sCompressedPeSize - sizeof(SIZE_T));

#ifdef DEBUG
	PRINT("[i] Retrieved Raw PE Size: %d \n", *psDecompressedPeSize);
#endif 

	if (!(*ppDecompressedPe = LocalAlloc(LPTR, *psDecompressedPeSize))) 
		return FALSE;

	if (!LzwDecompressData(pCompressedPe, sCompressedPeSize, ppDecompressedPe, psDecompressedPeSize)) {
		LocalFree(*ppDecompressedPe);
		return FALSE;
	}

#ifdef DEBUG
	PRINT("[i] Decompressed PE Address: 0x%p \n", *ppDecompressedPe);
#endif 

	return TRUE;
}


