#pragma once

#include <Windows.h>

// https://learn.microsoft.com/en-us/windows/win32/api/libloaderapi/nf-libloaderapi-loadlibrarya
//
typedef HMODULE(WINAPI* fnLoadLibraryA)(IN LPCSTR lpLibFileName);


// https://learn.microsoft.com/en-us/windows/win32/api/errhandlingapi/nf-errhandlingapi-addvectoredexceptionhandler
//
typedef PVOID(WINAPI* fnAddVectoredExceptionHandler)(ULONG First, PVECTORED_EXCEPTION_HANDLER Handler);


// https://learn.microsoft.com/en-us/windows/win32/api/errhandlingapi/nf-errhandlingapi-removevectoredexceptionhandler
//
typedef ULONG(WINAPI* fnRemoveVectoredExceptionHandler)(PVOID Handle);


// https://source.winehq.org/WineAPI/SystemFunction032.html
//
typedef struct _USTRING {

	DWORD	Length;
	DWORD	MaximumLength;
	PVOID	Buffer;

} USTRING, * PUSTRING;

typedef NTSTATUS(NTAPI* fnSystemFunction032)(PUSTRING Data, PUSTRING Key);

/*
// https://learn.microsoft.com/en-us/windows/win32/api/memoryapi/nf-memoryapi-virtualprotect
//
typedef BOOL(WINAPI* fnVirtualProtect)(LPVOID lpAddress, SIZE_T dwSize, DWORD flNewProtect, PDWORD lpflOldProtect);
*/

// https://learn.microsoft.com/en-us/windows/win32/api/threadpoollegacyapiset/nf-threadpoollegacyapiset-createtimerqueuetimer
//
typedef BOOL(NTAPI* fnCreateTimerQueueTimer)(PHANDLE phNewTimer, HANDLE TimerQueue, WAITORTIMERCALLBACK Callback, PVOID Parameter, DWORD DueTime, DWORD Period, ULONG Flags);


// https://learn.microsoft.com/en-us/windows/win32/api/threadpoollegacyapiset/nf-threadpoollegacyapiset-createtimerqueue
//
typedef HANDLE(WINAPI* fnCreateTimerQueue)();


// https://learn.microsoft.com/en-us/windows/win32/api/winnt/nf-winnt-rtladdfunctiontable
// 
typedef BOOLEAN (WINAPI* fnRtlAddFunctionTable)(PRUNTIME_FUNCTION FunctionTable, DWORD EntryCount, DWORD64 BaseAddress);


// https://learn.microsoft.com/en-us/windows/win32/api/synchapi/nf-synchapi-initializecriticalsection
//
typedef void(WINAPI* fnInitializeCriticalSection)(LPCRITICAL_SECTION lpCriticalSection);

// https://learn.microsoft.com/en-us/windows/win32/api/synchapi/nf-synchapi-entercriticalsection
//
typedef void(WINAPI* fnEnterCriticalSection)(LPCRITICAL_SECTION lpCriticalSection);

// https://learn.microsoft.com/en-us/windows/win32/api/synchapi/nf-synchapi-leavecriticalsection
// 
typedef void(WINAPI* fnLeaveCriticalSection)(LPCRITICAL_SECTION lpCriticalSection);

