// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <stdio.h>

#include "lzw.h"


#define		NEW_NAME	"PeFileCompressed.lzw"


#define ALLOC(SIZE)				LocalAlloc(LPTR, (SIZE_T)SIZE)
#define FREE(BUFF)				LocalFree((LPVOID)BUFF)
#define REALLOC(BUFF, SIZE)		LocalReAlloc(BUFF, SIZE,  LMEM_MOVEABLE | LMEM_ZEROINIT)
#define GET_FILENAME(path)		(strrchr(path, '\\') ? strrchr(path, '\\') + 1 : path)

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL ReadPayloadFile(IN LPCSTR cFileName, OUT PBYTE* ppFileBuffer, OUT PDWORD pdwFileSize) {

	HANDLE		hFile					= INVALID_HANDLE_VALUE;
	PBYTE		pTmpReadBuffer			= NULL;
	DWORD		dwFileSize				= NULL,
				dwNumberOfBytesRead		= NULL;

	if (!pdwFileSize || !ppFileBuffer)
		return FALSE;

	if ((hFile = CreateFileA(cFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		printf("\t[!] CreateFileA Failed With Error: %d \n", GetLastError());
		return FALSE;
	}

	if ((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE) {
		printf("\t[!] GetFileSize Failed With Error: %d \n", GetLastError());
		goto _FUNC_CLEANUP;
	}

	if (!(pTmpReadBuffer = ALLOC(dwFileSize))) {
		printf("\t[!] LocalAlloc Failed With Error: %d \n", GetLastError());
		goto _FUNC_CLEANUP;
	}

	if (!ReadFile(hFile, pTmpReadBuffer, dwFileSize, &dwNumberOfBytesRead, NULL) || dwFileSize != dwNumberOfBytesRead) {
		printf("\t[!] ReadFile Failed With Error: %d \n", GetLastError());
		printf("\t[i] ReadFile Read %d Of %d Bytes \n", dwNumberOfBytesRead, dwFileSize);
		goto _FUNC_CLEANUP;
	}

	*ppFileBuffer	=	pTmpReadBuffer;
	*pdwFileSize	=	dwFileSize;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	if (pTmpReadBuffer && !*ppFileBuffer)
		FREE(pTmpReadBuffer);
	return *ppFileBuffer == NULL ? FALSE : TRUE;
}

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL WritePayloadFile(IN PBYTE pFileBuffer, IN DWORD dwFileSize) {

	HANDLE	hFile						= INVALID_HANDLE_VALUE;
	DWORD	dwNumberOfBytesWritten		= 0x00;

	if (!pFileBuffer || !dwFileSize)
		return FALSE;

	if ((hFile = CreateFileA(NEW_NAME, GENERIC_READ | GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		printf("\t[!] CreateFileA Failed With Error: %d \n", GetLastError());
		goto _FUNC_CLEANUP;
	}

	if (!WriteFile(hFile, pFileBuffer, dwFileSize, &dwNumberOfBytesWritten, NULL) || dwFileSize != dwNumberOfBytesWritten) {
		printf("\t[!] WriteFile Failed With Error: %d \n", GetLastError());
		printf("\t[i] WriteFile Wrote %d Of %d Bytes \n", dwNumberOfBytesWritten, dwFileSize);
		goto _FUNC_CLEANUP;
	}

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	return dwNumberOfBytesWritten == dwFileSize ? TRUE : FALSE;
}

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL VerifyPeFile(IN PBYTE pBuffer) {

	PIMAGE_NT_HEADERS pImgNtHdrs = (PIMAGE_NT_HEADERS)(pBuffer + ((PIMAGE_DOS_HEADER)pBuffer)->e_lfanew);
	if (pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		return FALSE;

	if (pImgNtHdrs->FileHeader.Characteristics & IMAGE_FILE_EXECUTABLE_IMAGE && pImgNtHdrs->OptionalHeader.Magic == IMAGE_NT_OPTIONAL_HDR64_MAGIC)
		return TRUE;

	return FALSE;
}

//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------------------------------------------------

int main(int argc, char* argv[]) {

	PBYTE	pRawData					= NULL,
			pCompressedData				= NULL, 
			pCompressedDataWithConf		= NULL;
	SIZE_T	sRawDataSize				= NULL,
			sCompressedDataSize			= NULL;


	if (argc != 2) {
		printf("[!] Please Input PE File Name To Compress\n");
		printf("\t> Example: %s mimikatz.exe \n", GET_FILENAME(argv[0]));
		return -1;
	}

	printf("[i] Reading %s From The Disk ... ", GET_FILENAME(argv[1]));
	if (!ReadPayloadFile(argv[1], &pRawData, &sRawDataSize)) 
		return -1;
	printf("[+] DONE\n");

	if (!VerifyPeFile(pRawData)) {
		printf("[!] Enter A Valid x64 PE File (EXE, DLL) \n");
		return -1;
	}

	printf("[i] Compressing Payload ... ");
	if (!LzwCompressData(pRawData, sRawDataSize, &pCompressedData, &sCompressedDataSize)) {
		printf("[!] LzwCompressData Failed \n");
		return -1;
	}

	if (!(pCompressedDataWithConf = REALLOC(pCompressedData, (sCompressedDataSize + sizeof(SIZE_T))))) {
		printf("[!] LocalReAlloc Failed With Error: %d \n", GetLastError());
		return -1;
	}

	*(PSIZE_T)(pCompressedDataWithConf + sCompressedDataSize) = (SIZE_T)sRawDataSize;
	printf("[+] DONE\n");

	printf("[*] Compressed Data: 0x%p \n", pCompressedDataWithConf);
	printf("[*] Compressed Data Size: %d [ Was: %d ]\n", (int)(sCompressedDataSize + sizeof(SIZE_T)), (int)sRawDataSize);
	printf("[*] Compression Ratio: %2.01f%% \n", (FLOAT)((1.0f - ((float)sCompressedDataSize / sRawDataSize)) * 100.0f));

	
	printf("[i] Writing \"%s\" To The Disk ... ", NEW_NAME);
	if (!WritePayloadFile(pCompressedDataWithConf, (sCompressedDataSize + sizeof(SIZE_T))))
		return -1;
	printf("[+] DONE \n");


	printf("[*] The Payload Is Ready To Go!\n");
	FREE(pCompressedDataWithConf);
	return 0;
}



