// @NUL0x4C | @mrd0x : MalDevAcademy

#include <Windows.h>
#include <winternl.h>
#include <stdio.h>

#define PRINT_WINAPI_ERR(cApiName) printf("[!] %s Failed With Error: %d\n", cApiName, GetLastError())


BOOL ReadFileFromDisk(IN LPCSTR cFileName, OUT PBYTE* ppBuffer, OUT PDWORD pdwFileSize) {

	HANDLE		hFile					= INVALID_HANDLE_VALUE;
	PBYTE		pBufer					= NULL;
	DWORD		dwFileSize				= 0x00,
				dwNumberOfBytesRead		= 0x00;

	if ((hFile = CreateFileA(cFileName, GENERIC_READ, 0x00, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
		PRINT_WINAPI_ERR("CreateFileA");
		goto _FUNC_CLEANUP;
	}

	if ((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE) {
		PRINT_WINAPI_ERR("GetFileSize");
		goto _FUNC_CLEANUP;
	}

	if ((pBufer = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, dwFileSize)) == NULL) {
		PRINT_WINAPI_ERR("HeapAlloc");
		goto _FUNC_CLEANUP;
	}

	if (!ReadFile(hFile, pBufer, dwFileSize, &dwNumberOfBytesRead, NULL) || dwFileSize != dwNumberOfBytesRead) {
		PRINT_WINAPI_ERR("ReadFile");
		goto _FUNC_CLEANUP;
	}

	*ppBuffer		= pBufer;
	*pdwFileSize	= dwFileSize;

_FUNC_CLEANUP:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);
	if (!*ppBuffer && pBufer)
		HeapFree(GetProcessHeap(), 0x00, pBufer);
	return ((*ppBuffer != NULL) && (*pdwFileSize != 0x00)) ? TRUE : FALSE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef struct _PE_HDRS
{
	PBYTE					pFileBuffer;
	DWORD					dwFileSize;

	PIMAGE_NT_HEADERS		pImgNtHdrs;
	PIMAGE_SECTION_HEADER	pImgSecHdr;

	PIMAGE_DATA_DIRECTORY	pEntryImportDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryBaseRelocDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryTLSDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExceptionDataDir;
	PIMAGE_DATA_DIRECTORY	pEntryExportDataDir;

	BOOL					bIsDLLFile;
}PE_HDRS, *PPE_HDRS;


BOOL InitializePeStruct(OUT PPE_HDRS pPeHdrs, IN PBYTE pFileBuffer, IN DWORD dwFileSize) {

	if (!pPeHdrs || !pFileBuffer || !dwFileSize)
		return FALSE;

	pPeHdrs->pFileBuffer			= pFileBuffer;
	pPeHdrs->dwFileSize				= dwFileSize;
	pPeHdrs->pImgNtHdrs				= (PIMAGE_NT_HEADERS)(pFileBuffer + ((PIMAGE_DOS_HEADER)pFileBuffer)->e_lfanew);

	if (pPeHdrs->pImgNtHdrs->Signature != IMAGE_NT_SIGNATURE)
		return FALSE;

	pPeHdrs->bIsDLLFile				= (pPeHdrs->pImgNtHdrs->FileHeader.Characteristics & IMAGE_FILE_DLL) ? TRUE : FALSE;
	pPeHdrs->pImgSecHdr				= IMAGE_FIRST_SECTION(pPeHdrs->pImgNtHdrs);
	pPeHdrs->pEntryImportDataDir	= &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT];
	pPeHdrs->pEntryBaseRelocDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_BASERELOC];
	pPeHdrs->pEntryTLSDataDir		= &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_TLS];
	pPeHdrs->pEntryExceptionDataDir = &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXCEPTION];
	pPeHdrs->pEntryExportDataDir	= &pPeHdrs->pImgNtHdrs->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_EXPORT];

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

BOOL FixImportAddressTable(IN PIMAGE_DATA_DIRECTORY pEntryImportDataDir, IN PBYTE pPeBaseAddress) {

	// Pointer to an import descriptor for a DLL
	PIMAGE_IMPORT_DESCRIPTOR	pImgDescriptor		= NULL;
 	// Iterate over the import descriptors
	for (SIZE_T i = 0; i < pEntryImportDataDir->Size; i += sizeof(IMAGE_IMPORT_DESCRIPTOR)) {
		// Get the current import descriptor
		pImgDescriptor = (PIMAGE_IMPORT_DESCRIPTOR)(pPeBaseAddress + pEntryImportDataDir->VirtualAddress + i);
		// If both thunks are NULL, we've reached the end of the import descriptors list
		if (pImgDescriptor->OriginalFirstThunk == NULL && pImgDescriptor->FirstThunk == NULL)
			break;

		// Retrieve information from the current import descriptor
		LPSTR		cDllName					= (LPSTR)(pPeBaseAddress + pImgDescriptor->Name);
		ULONG_PTR	uOriginalFirstThunkRVA		= pImgDescriptor->OriginalFirstThunk;
		ULONG_PTR	uFirstThunkRVA				= pImgDescriptor->FirstThunk;
		SIZE_T		ImgThunkSize				= 0x00;	// Used to move to the next function (iterating through the IAT and INT)
		HMODULE		hModule						= NULL;

		// If OriginalFirstThunk is NULL, fallback to FirstThunk
//		if (uOriginalFirstThunkRVA == NULL)
//			uOriginalFirstThunkRVA = uFirstThunkRVA;

		// Try to load the DLL referenced by the current import descriptor
		if (!(hModule = LoadLibraryA(cDllName))) {
			PRINT_WINAPI_ERR("LoadLibraryA");
			return FALSE;
		}

		// Iterate over the imported functions for the current DLL
		while (TRUE) {
			
			// Get pointers to the first thunk and original first thunk data
			PIMAGE_THUNK_DATA			pOriginalFirstThunk			= (PIMAGE_THUNK_DATA)(pPeBaseAddress + uOriginalFirstThunkRVA + ImgThunkSize);
			PIMAGE_THUNK_DATA			pFirstThunk					= (PIMAGE_THUNK_DATA)(pPeBaseAddress + uFirstThunkRVA + ImgThunkSize);
			PIMAGE_IMPORT_BY_NAME		pImgImportByName			= NULL;
			ULONG_PTR					pFuncAddress				= NULL;

			// At this point both 'pOriginalFirstThunk' & 'pFirstThunk' will have the same values
			// However, to populate the IAT (pFirstThunk), one should use the INT (pOriginalFirstThunk) to retrieve the 
			// functions addresses and patch the IAT (pFirstThunk->u1.Function) with the calculated address.
			if (pOriginalFirstThunk->u1.Function == NULL && pFirstThunk->u1.Function == NULL) {
				break;
			}

			// If the ordinal flag is set, import the function by its ordinal number
			if (IMAGE_SNAP_BY_ORDINAL(pOriginalFirstThunk->u1.Ordinal)) {
				if ( !(pFuncAddress = (ULONG_PTR)GetProcAddress(hModule, IMAGE_ORDINAL(pOriginalFirstThunk->u1.Ordinal))) ) {
					printf("[!] Could Not Import !%s#%d \n", cDllName, (int)pOriginalFirstThunk->u1.Ordinal);
					return FALSE;
				}
			}
			// Import function by name
			else {
				pImgImportByName = (PIMAGE_IMPORT_BY_NAME)(pPeBaseAddress + pOriginalFirstThunk->u1.AddressOfData);
				if ( !(pFuncAddress = (ULONG_PTR)GetProcAddress(hModule, pImgImportByName->Name)) ) {
					printf("[!] Could Not Import !%s.%s \n", cDllName, pImgImportByName->Name);
					return FALSE;
				}
			}

			// Install the function address in the IAT
			pFirstThunk->u1.Function = (ULONGLONG)pFuncAddress;

			// Move to the next function in the IAT/INT array
			ImgThunkSize += sizeof(IMAGE_THUNK_DATA);
		}
	}

	return TRUE;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------


typedef struct _BASE_RELOCATION_ENTRY {
	WORD	Offset	: 12;
	WORD	Type	: 4;
} BASE_RELOCATION_ENTRY, * PBASE_RELOCATION_ENTRY;



BOOL FixReloc(IN PIMAGE_DATA_DIRECTORY pEntryBaseRelocDataDir, IN ULONG_PTR pPeBaseAddress, IN ULONG_PTR pPreferableAddress) {

    // Pointer to the beginning of the base relocation block.
    PIMAGE_BASE_RELOCATION pImgBaseRelocation = (pPeBaseAddress + pEntryBaseRelocDataDir->VirtualAddress);

    // The difference between the current PE image base address and its preferable base address.
    ULONG_PTR uDeltaOffset = pPeBaseAddress - pPreferableAddress;

    // Pointer to individual base relocation entries.
    PBASE_RELOCATION_ENTRY pBaseRelocEntry = NULL;

    // Iterate through all the base relocation blocks.
    while (pImgBaseRelocation->VirtualAddress) {

        // Pointer to the first relocation entry in the current block.
        pBaseRelocEntry = (PBASE_RELOCATION_ENTRY)(pImgBaseRelocation + 1);

        // Iterate through all the relocation entries in the current block.
        while ((PBYTE)pBaseRelocEntry != (PBYTE)pImgBaseRelocation + pImgBaseRelocation->SizeOfBlock) {
            // Process the relocation entry based on its type.
            switch (pBaseRelocEntry->Type) {
	            case IMAGE_REL_BASED_DIR64:
	                // Adjust a 64-bit field by the delta offset.
	                *((ULONG_PTR*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += uDeltaOffset;
	                break;
	            case IMAGE_REL_BASED_HIGHLOW:
	                // Adjust a 32-bit field by the delta offset.
	                *((DWORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += (DWORD)uDeltaOffset;
	                break;
	            case IMAGE_REL_BASED_HIGH:
	                // Adjust the high 16 bits of a 32-bit field.
	                *((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += HIWORD(uDeltaOffset);
	                break;
	            case IMAGE_REL_BASED_LOW:
	                // Adjust the low 16 bits of a 32-bit field.
	                *((WORD*)(pPeBaseAddress + pImgBaseRelocation->VirtualAddress + pBaseRelocEntry->Offset)) += LOWORD(uDeltaOffset);
	                break;
	            case IMAGE_REL_BASED_ABSOLUTE:
	                // No relocation is required.
	                break;
	            default:
	                // Handle unknown relocation types.
	                printf("[!] Unknown relocation type: %d | Offset: 0x%08X \n", pBaseRelocEntry->Type, pBaseRelocEntry->Offset);
	                return FALSE;
            }
            // Move to the next relocation entry.
            pBaseRelocEntry++;
        }

        // Move to the next relocation block.
        pImgBaseRelocation = (PIMAGE_BASE_RELOCATION)pBaseRelocEntry;
    }

    return TRUE;
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------


BOOL FixMemPermissions(IN ULONG_PTR pPeBaseAddress, IN PIMAGE_NT_HEADERS pImgNtHdrs, IN PIMAGE_SECTION_HEADER pImgSecHdr) {

	// Loop through each section of the PE image.
	for (DWORD i = 0; i < pImgNtHdrs->FileHeader.NumberOfSections; i++) {

		// Variables to store the new and old memory protections.
		DWORD	dwProtection		= 0x00,
				dwOldProtection		= 0x00;

		// Skip the section if it has no data or no associated virtual address.
		if (!pImgSecHdr[i].SizeOfRawData || !pImgSecHdr[i].VirtualAddress)
			continue;

		// Determine memory protection based on section characteristics.
		// These characteristics dictate whether the section is readable, writable, executable, etc.
		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE)
			dwProtection = PAGE_WRITECOPY;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ)
			dwProtection = PAGE_READONLY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_READWRITE;

		if (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE)
			dwProtection = PAGE_EXECUTE;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE))
			dwProtection = PAGE_EXECUTE_WRITECOPY;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READ;

		if ((pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_EXECUTE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_WRITE) && (pImgSecHdr[i].Characteristics & IMAGE_SCN_MEM_READ))
			dwProtection = PAGE_EXECUTE_READWRITE;

		// Apply the determined memory protection to the section.
		if (!VirtualProtect((PVOID)(pPeBaseAddress + pImgSecHdr[i].VirtualAddress), pImgSecHdr[i].SizeOfRawData, dwProtection, &dwOldProtection)) {
			PRINT_WINAPI_ERR("VirtualProtect");
			return FALSE;
		}
	}

	return TRUE;
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

PVOID FetchExportedFunctionAddress(IN PIMAGE_DATA_DIRECTORY pEntryExportDataDir, IN ULONG_PTR pPeBaseAddress, IN LPCSTR cFuncName) {


	PIMAGE_EXPORT_DIRECTORY		pImgExportDir			= (PIMAGE_EXPORT_DIRECTORY)(pPeBaseAddress + pEntryExportDataDir->VirtualAddress);
	PDWORD						FunctionNameArray		= (PDWORD)(pPeBaseAddress + pImgExportDir->AddressOfNames);
	PDWORD						FunctionAddressArray	= (PDWORD)(pPeBaseAddress + pImgExportDir->AddressOfFunctions);
	PWORD						FunctionOrdinalArray	= (PWORD)(pPeBaseAddress + pImgExportDir->AddressOfNameOrdinals);

	for (DWORD i = 0; i < pImgExportDir->NumberOfFunctions; i++) {

		CHAR*	pFunctionName		= (CHAR*)(pPeBaseAddress + FunctionNameArray[i]);
		PVOID	pFunctionAddress	= (PVOID)(pPeBaseAddress + FunctionAddressArray[FunctionOrdinalArray[i]]);

		if (strcmp(cFuncName, pFunctionName) == 0) {
			return pFunctionAddress;
		}
	}

	return NULL;
}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

typedef BOOL(WINAPI* DLLMAIN)(HINSTANCE, DWORD, LPVOID);
typedef BOOL(WINAPI* MAIN)();


VOID FixArguments(IN LPCSTR cArgumentsToPass);


BOOL LocalPeExec(IN PPE_HDRS pPeHdrs, IN OPTIONAL LPCSTR cExportedFuncName, IN OPTIONAL LPCSTR cArguments) {

	if (!pPeHdrs)
		return FALSE;

	PBYTE			pPeBaseAddress			= NULL;
	PVOID			pEntryPoint				= NULL;
	PVOID			pExportedFuncAddress	= NULL;

	// Allocating memory for the PE
	if ((pPeBaseAddress = VirtualAlloc(NULL, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfImage, MEM_RESERVE | MEM_COMMIT, PAGE_READWRITE)) == NULL) {
		PRINT_WINAPI_ERR("VirtualAlloc");
		return FALSE;
	}

	// Copying PE headers - IOC
	// memcpy(pPeBaseAddress, pPeHdrs->pFileBuffer, pPeHdrs->pImgNtHdrs->OptionalHeader.SizeOfHeaders);

	for (int i = 0; i < pPeHdrs->pImgNtHdrs->FileHeader.NumberOfSections; i++) {
		memcpy(
			(PVOID)(pPeBaseAddress + pPeHdrs->pImgSecHdr[i].VirtualAddress),
			(PVOID)((ULONG_PTR)pPeHdrs->pFileBuffer + pPeHdrs->pImgSecHdr[i].PointerToRawData),
			pPeHdrs->pImgSecHdr[i].SizeOfRawData
		);
	}

	// Fixing the IAT 
	if (!FixImportAddressTable(pPeHdrs->pEntryImportDataDir, pPeBaseAddress))
		return FALSE;

	// Applying relocations
	if (!FixReloc(pPeHdrs->pEntryBaseRelocDataDir, pPeBaseAddress, pPeHdrs->pImgNtHdrs->OptionalHeader.ImageBase))
		return FALSE;

	// Setting up suitable memory permissions
	if (!FixMemPermissions(pPeBaseAddress, pPeHdrs->pImgNtHdrs, pPeHdrs->pImgSecHdr))
		return FALSE;

	// Fetch exported function if 'cExportedFuncName' is passed
	if (pPeHdrs->pEntryExportDataDir->Size && pPeHdrs->pEntryExportDataDir->VirtualAddress && cExportedFuncName)
		pExportedFuncAddress = FetchExportedFunctionAddress(pPeHdrs->pEntryExportDataDir, pPeBaseAddress, cExportedFuncName);

	// Fixing arguments
	FixArguments(cArguments);

	// Set exception handlers of the injected PE (if exists)
	if (pPeHdrs->pEntryExceptionDataDir->Size) {
		// Retrieve the function table entry
		PIMAGE_RUNTIME_FUNCTION_ENTRY pImgRuntimeFuncEntry = (PIMAGE_RUNTIME_FUNCTION_ENTRY)(pPeBaseAddress + pPeHdrs->pEntryExceptionDataDir->VirtualAddress);
		// Register the function table
		if (!RtlAddFunctionTable(pImgRuntimeFuncEntry, (pPeHdrs->pEntryExceptionDataDir->Size / sizeof(IMAGE_RUNTIME_FUNCTION_ENTRY)), pPeBaseAddress)) {
			PRINT_WINAPI_ERR("RtlAddFunctionTable");
		}
	}

	// Execute TLS callbacks (if exists)
	if (pPeHdrs->pEntryTLSDataDir->Size) {
		// Retrieve the address of the TLS Directory.
		PIMAGE_TLS_DIRECTORY	pImgTlsDirectory	= (PIMAGE_TLS_DIRECTORY)(pPeBaseAddress + pPeHdrs->pEntryTLSDataDir->VirtualAddress);
		// Get the address of the TLS Callbacks from the TLS Directory.
		PIMAGE_TLS_CALLBACK*	pImgTlsCallback		= (PIMAGE_TLS_CALLBACK*)(pImgTlsDirectory->AddressOfCallBacks);
		CONTEXT					pCtx				= { 0x00 };

		/*
		if (!GetThreadContext((HANDLE)-2, &pCtx)) {
			PRINT_WINAPI_ERR("GetThreadContext");
		}
		*/

		// Iterate through and invoke each TLS Callback until a NULL callback is encountered.
		for (int i = 0; pImgTlsCallback[i] != NULL; i++){
			pImgTlsCallback[i]((LPVOID)pPeBaseAddress, DLL_PROCESS_ATTACH, &pCtx);
		}
		
	}

	// Execute EP
	pEntryPoint = (PVOID)(pPeBaseAddress + pPeHdrs->pImgNtHdrs->OptionalHeader.AddressOfEntryPoint);

	// If DLL
	if (pPeHdrs->bIsDLLFile) {

		DLLMAIN		pDllMain	= (DLLMAIN)pEntryPoint;
		HANDLE		hThread		= NULL;

		// Execute DllMain:
		pDllMain((HINSTANCE)pPeBaseAddress, DLL_PROCESS_ATTACH, NULL);
		// Execute Exported Function (if exists):
		if (pExportedFuncAddress)
			hThread = CreateThread(NULL, 0x00, pExportedFuncAddress, NULL, 0x00, NULL);
		if (hThread)
			WaitForSingleObject(hThread, INFINITE);
	}
	// If EXE
	else {
		MAIN pMain = (MAIN)pEntryPoint;
		return pMain();
	}
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

VOID HandleCmdLineArgs(int argc, char* argv[], char** ppe_arg, char** pfptr_arg, char** pparm_arg) {


	char*	pe_arg					= NULL;
	char*	fptr_arg				= NULL;
	char*	parm_arg				= NULL;
	char	parm_buffer[1024 * 2]	= { 0 };


	for (int i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-pe") == 0 && i + 1 < argc) {
			pe_arg = argv[++i];
		}
		else if (strcmp(argv[i], "-fptr") == 0 && i + 1 < argc) {
			fptr_arg = argv[++i];
		}
		else if (strcmp(argv[i], "-parm") == 0 && i + 1 < argc) {
			parm_arg = parm_buffer;
			strcpy(parm_arg, argv[++i]);
			while (i + 1 < argc && argv[i + 1][0] != '-') {
				strcat(parm_arg, " ");
				strcat(parm_arg, argv[++i]);
			}
		}
	}

	*ppe_arg	= pe_arg;
	*pfptr_arg	= fptr_arg;
	*pparm_arg	= parm_arg;
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//\
https://github.com/vxunderground/VX-API/blob/main/VX-API/CharStringToWCharString.cpp

SIZE_T CharStringToWCharString(_Inout_ PWCHAR Destination, _In_ PCHAR Source, SIZE_T _In_ MaximumAllowed)
{
	INT Length = (INT)MaximumAllowed;

	while (--Length >= 0)
	{
		if (!(*Destination++ = *Source++))
			return MaximumAllowed - Length - 1;
	}

	return MaximumAllowed - Length;
}


VOID FixArguments(IN OPTIONAL LPCSTR cArgumentsToPass) {

	PRTL_USER_PROCESS_PARAMETERS	pParam				= ((PPEB)__readgsqword(0x60))->ProcessParameters;

	RtlSecureZeroMemory(pParam->CommandLine.Buffer, pParam->CommandLine.Length * sizeof(WCHAR));

	if (cArgumentsToPass) {

		WCHAR*					wNewCommand				= NULL;
		WCHAR*					wArgumentsToPass		= NULL;
		INT						iWideCharSize			= 0x00;

		// char => wchar
		if (!(wArgumentsToPass = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, (strlen(cArgumentsToPass) * sizeof(WCHAR) + sizeof(WCHAR))))) {
			PRINT_WINAPI_ERR("HeapAlloc");
			return;
		}

		CharStringToWCharString(wArgumentsToPass, cArgumentsToPass, (strlen(cArgumentsToPass) * sizeof(WCHAR) + sizeof(WCHAR)));
		
		// Construct the new commandline 
		if (!(wNewCommand = HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, ((wcslen(wArgumentsToPass) + pParam->ImagePathName.Length) * sizeof(WCHAR) + sizeof(WCHAR))))) {
			PRINT_WINAPI_ERR("HeapAlloc"); 
			return;
		}
		
		wsprintfW(wNewCommand, L"\"%s\" %s", pParam->ImagePathName.Buffer, wArgumentsToPass);
		
		// Overwrite the old one
		lstrcpyW(pParam->CommandLine.Buffer, wNewCommand);
		pParam->CommandLine.Length = pParam->CommandLine.MaximumLength = wcslen(pParam->CommandLine.Buffer) * sizeof(WCHAR) + sizeof(WCHAR);
		pParam->CommandLine.MaximumLength += sizeof(WCHAR);

		HeapFree(GetProcessHeap(), 0x00, wArgumentsToPass);
		HeapFree(GetProcessHeap(), 0x00, wNewCommand);

		return;
	}

	// No arguments: overwrite with image name only
	lstrcpyW(pParam->CommandLine.Buffer, pParam->ImagePathName.Buffer);
	pParam->CommandLine.Length = pParam->CommandLine.MaximumLength = wcslen(pParam->CommandLine.Buffer) * sizeof(WCHAR) + sizeof(WCHAR);
	pParam->CommandLine.MaximumLength += sizeof(WCHAR);
}


//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------


#define GET_FILENAME(path) (strrchr(path, '\\') ? strrchr(path, '\\') + 1 : path)

int main(int argc, char* argv[]) {


	char*	pe_arg					= NULL;
	char*	fptr_arg				= NULL;
	char*	parm_arg				= NULL;

	HandleCmdLineArgs(argc, argv, &pe_arg, &fptr_arg, &parm_arg);

	if (!pe_arg) {
		printf("[!] Usage: %s -pe <Input PE> -fptr <*optional*: Exported function> -parm <*optional*: Arguments to pass> \n", GET_FILENAME(argv[0]));
		printf("\t<i> e.g. %s -pe DllMsgBox.dll -fptr HelloWorld \n", GET_FILENAME(argv[0]));
		printf("\t<i> e.g. %s -pe DllMsgBox.dll \n", GET_FILENAME(argv[0]));
		printf("\t<i> e.g. %s -pe ExeMsgBox.exe \n", GET_FILENAME(argv[0]));
		printf("\t<i> e.g. %s -pe ExeArgs.exe -parm this is a command line arg\n", GET_FILENAME(argv[0]));
		printf("\n\n");
		return -1;
	}

	PBYTE		pFileBuffer		= NULL;
	DWORD		dwFileSize		= 0x00;
	PE_HDRS		PeHdrStruct		= { 0 };

	if (!ReadFileFromDisk(pe_arg, &pFileBuffer, &dwFileSize))
		return -1;

	if (!InitializePeStruct(&PeHdrStruct, pFileBuffer, dwFileSize))
		return -1;

	LocalPeExec(&PeHdrStruct, fptr_arg, parm_arg);

	return 0;
}


