// @NUL0x4C | @mrd0x : MalDevAcademy


// https://github.com/kevinalmansa/TLS_Examples/tree/master/TLS_Examples/TLS_Static

#include <Windows.h>
#include <stdio.h>


#pragma comment (linker, "/INCLUDE:_tls_used")
#pragma comment (linker, "/INCLUDE:tls_callback_func")

void	tls_callback1(PVOID hModule, DWORD dwReason, PVOID pContext);

#pragma const_seg(".CRT$XLB")
EXTERN_C const
PIMAGE_TLS_CALLBACK tls_callback_func = (PIMAGE_TLS_CALLBACK)tls_callback1;
#pragma const_seg()


/*****************************************************************************
First TLS Callback
Set above to segment CRT$XLB
******************************************************************************/
void	tls_callback1(PVOID hModule, DWORD dwReason, PVOID pContext)
{
	if (dwReason == DLL_THREAD_ATTACH) {
		// This will be loaded in each DLL thread attach
		MessageBox(0, TEXT("TLS Callback 1: Thread Attach Triggered"), TEXT("TLS"), 0);
	}

	if (dwReason == DLL_PROCESS_ATTACH) {
		MessageBox(0, TEXT("TLS Callback 1: Process Attach Triggered"), TEXT("TLS"), 0);
		// DEBUG - Help understand how this is being stored in memory.
		printf("TLS Callback Addresses:\n    Function Address: %p\n    CRT Callback Address: %p\n",
			tls_callback1, &tls_callback_func);
	}
}

/*****************************************************************************
The actual main()
Code in the TLS Callbacks set above will execute BEFORE the main.
Setting a breakpoint here will not stop the callbacks from executing first.
******************************************************************************/
int main()
{
	printf("Main():\n    Hello World\n");
	system("pause");
	return 0;
}