//SI5351_vfoCWtx + LCD + Output Clk0

#include "si5351.h"
#include "Wire.h"
#include <LiquidCrystal.h>
#include <EEPROM.h>
//#include <JTEncode.h>

Si5351 si5351;
LiquidCrystal lcd(2, 3, 4, 5, 6, 7);

//#define WSPR_TONE_SPACING       146           // ~1.46 Hz
//#define WSPR_CTC                10672         // CTC value for WSPR
//#define WSPR_DEFAULT_FREQ       14097200UL
//#define DEFAULT_MODE           MODE_WSPR   

uint8_t cw_code[69] = {69,84,73,65,78,77,83,85,82,87,68,75,71,79,72,86,70,0,76,0,80,74,66,88,67,89,90,81,0,0,53,52,0,51,0,0,0,50,0,0,43,0,0,0,0,49,54,61,47,0,0,0,40,0,55,0,0,0,56,0,57,48};

/* 
  Code(2) = 69                                              ' "E",      . , 00000010, ASCII 69
  Code(3) = 84                                              ' "T",      - , 00000011, ASCII 84
  Code(4) = 73                                              ' "I",     .. , 00000100, ASCII 73
  Code(5) = 65                                              ' "A",     .- , 00000101, ASCII 65
  Code(6) = 78                                              ' "N",     -. , 00000110, ASCII 78
  Code(7) = 77                                              ' "M",     -- , 00000111, ASCII 77
  Code(8) = 83                                              ' "S",    ... , 00001000, ASCII 83
  Code(9) = 85                                              ' "U",    ..- , 00001001, ASCII 85
  Code(10) = 82                                             ' "R",    .-. , 00001010, ASCII 82
  Code(11) = 87                                             ' "W",    .-- , 00001011, ASCII 87
  Code(12) = 68                                             ' "D",    -.. , 00001100, ASCII 68
  Code(13) = 75                                             ' "K",    -.- , 00001101, ASCII 75
  Code(14) = 71                                             ' "G",    --. , 00001110, ASCII 71
  Code(15) = 79                                             ' "O",    --- , 00001111, ASCII 79
  Code(16) = 72                                             ' "H",   .... , 00010000, ASCII 72
  Code(17) = 86                                             ' "V",   ...- , 00010001, ASCII 86
  Code(18) = 70                                             ' "F",   ..-. , 00010010, ASCII 70
  Code(20) = 76                                             ' "L",   .-.. , 00010100, ASCII 76
  Code(22) = 80                                             ' "P",   .--. , 00010110, ASCII 80
  Code(23) = 74                                             ' "J",   .--- , 00010111, ASCII 74
  Code(24) = 66                                             ' "B",   -... , 00011000, ASCII 66
  Code(25) = 88                                             ' "X",   -..- , 00011001, ASCII 88
  Code(26) = 67                                             ' "C",   -.-. , 00011010, ASCII 67
  Code(27) = 89                                             ' "Y",   -.-- , 00011011, ASCII 89
  Code(28) = 90                                             ' "Z",   --.. , 00011100, ASCII 90
  Code(29) = 81                                             ' "Q",   --.- , 00011101, ASCII 81
  Code(32) = 53                                             ' "5",  ..... , 00100000, ASCII 53
  Code(33) = 52                                             ' "4",  ....- , 00100001, ASCII 52
  Code(35) = 51                                             ' "3",  ...-- , 00100011, ASCII 51
  Code(39) = 50                                             ' "2",  ..--- , 00100111, ASCII 50
  Code(42) = 43                                             ' "+"   .-.-. , 00101010  ASCII 43
  Code(47) = 49                                             ' "1",  .---- , 00101111, ASCII 49
  Code(48) = 54                                             ' "6",  -.... , 00110000, ASCII 54
  Code(49) = 61                                             ' "=" 
  Code(50) = 47                                            ' "/"   -..-. , 00110010, ASCII 47
  Code(54) = 40                                             ' "("
  Code(56) = 55                                             ' "7",  --... , 00111000, ASCII 55
  Code(60) = 56                                             ' "8",  ---.. , 00111100, ASCII 56
  Code(62) = 57                                             ' "9",  ----. , 00111110, ASCII 57
  Code(63) = 48                                             ' "0",  ----- , 00111111, ASCII 48

 */

const int key = 8;
const int buz = 9;
const int txOn = 10;
const int keyOut = 11;
uint16_t ctc, tone_spacing;
//DK7JD, JO31, 2 W
uint8_t tx_buffer[255] = {1,3,0,0,2,2,2,0,1,2,2,0,1,3,1,0,2,0,1,2,0,1,0,3,1,1,1,2,2,0,2,2,2,0,1,0,2,3,2,1,2,2,2,0,0,2,1,0,1,3,0,0,1,3,2,3,2,2,0,1,3,2,3,2,2,2,0,3,3,0,3,0,1,0,3,0,1,0,2,3,2,2,3,2,3,3,0,0,0,1,1,0,1,0,1,2,2,0,1,2,2,0,0,2,3,2,2,1,2,2,3,3,3,2,1,1,0,0,1,1,0,3,2,2,2,1,3,3,0,2,0,2,2,1,0,3,2,0,3,1,0,0,0,0,0,0,2,3,1,2,3,2,3,1,0,2,0,1,3,2,0,2};
#define BUTTON                  12
#define LED_PIN                 13
#define WSPR_SYMBOL_COUNT                   162
volatile bool proceed = false;

#define WSPR_BIT_COUNT                      162
unsigned long  freq;
unsigned long  freqTX;
unsigned long  freqRX;
unsigned long  freqZF;
unsigned long  wsprfreq;
uint8_t symbol_count;
int32_t cal_factor;
int defauld_cal = 1600;
int old_cal;
int new_cal;
int pot;
long fstep;
long fstepOld;
int band;
int timeTune;
double unf;
double unf_max;
int timeUnf; 
int wspr;
long ticks;

// Timer interrupt vector.  This toggles the variable we use to gate
// each column of output to ensure accurate timing.  Called whenever
// Timer1 hits the count set below in setup().
ISR(TIMER1_COMPA_vect)
{
    proceed = true;
     ticks++;
}

void setup(void)
{
  pinMode(A0, INPUT_PULLUP);
  pinMode(A1, INPUT_PULLUP);
  pinMode(8, INPUT_PULLUP);  //Tx an
  pinMode(9, INPUT_PULLUP);  //Taste
  pinMode(10, OUTPUT);       //TX/RX
  pinMode(11, OUTPUT);       //Key Out
  pinMode(BUTTON, INPUT_PULLUP);  //wspr start
  band = 5;
  freq= 7038600;
  freqTX= 7037800;
  wsprfreq = 7040100;
  wspr = 1;
  symbol_count = WSPR_SYMBOL_COUNT; // From the library defines
  int defauld_cal = 1600;
  old_cal = cal_factor;
  old_cal = eepromReadInt (0);
  if ((old_cal<-3000)|(old_cal>3000))  eepromWriteInt (0,defauld_cal);
  cal_factor = 100 * int32_t(eepromReadInt (0));
  Serial.begin(9600);
  Serial.println("Si5351 Clockgen"); Serial.println("");
  si5351.init(SI5351_CRYSTAL_LOAD_8PF, 0, 0);  
  si5351.set_correction(cal_factor, SI5351_PLL_INPUT_XO);
  Serial.println(7038600);  
  si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);
  si5351.set_freq(freq*400ULL, SI5351_CLK1);
  si5351.output_enable(SI5351_CLK1, 1);
  si5351.set_freq((wsprfreq+1500)*100ULL, SI5351_CLK2);
  si5351.output_enable(SI5351_CLK1, 1);
  si5351.drive_strength(SI5351_CLK2, SI5351_DRIVE_8MA);
  si5351.output_enable(SI5351_CLK2, 0);
  lcd.begin(16, 2);
  lcd.print(freq);
  
  // Set CLK0 output
  si5351.drive_strength(SI5351_CLK2, SI5351_DRIVE_8MA); // Set for max power if desired
  si5351.output_enable(SI5351_CLK2, 0); // Disable the clock initially
}

static void flush_input(void)
{
  while (Serial.available() > 0)
  Serial.read();
}

void eepromWriteInt(int adr, int wert) {
byte low, high;
  low=wert&0xFF;
  high=(wert>>8)&0xFF;
  EEPROM.write(adr, low); // dauert 3,3ms 
  EEPROM.write(adr+1, high);
  return;
} //eepromWriteInt

int eepromReadInt(int adr) {
byte low, high;
  low=EEPROM.read(adr);
  high=EEPROM.read(adr+1);
  return low + ((high << 8)&0xFF00);
} //eepromReadInt



void cq(void){
 uint8_t  c;
 char cwCall[64]  = "CQ CQ CQ DE DK7JD DK7JD DK7JD PSE K";
 digitalWrite (txOn,1);  //Relais 
 lcd.setCursor(0, 0);
 lcd.print(freqTX);
 lcd.print ("   ");
 delay (20);
  si5351.output_enable(SI5351_CLK2, 1);   //TX on
  si5351.output_enable(SI5351_CLK1, 0);   //RX off
 for(int pos = 0; pos < 35; pos++)  {
   c = cwCall[pos];
   if (c == 32){
   delay (300);
   }
   else {
    uint8_t  morse = 1;
    uint8_t  morseBit =0;
    for(int i = 0; i < 69; i++)  
    {
        if ( c == cw_code[i]) morse = i + 2;
    }
    int bitPos = 7;
    int startBit = 0; 
     for(int i = 0; i < 8; i++){  
      if (morse >= 128) morseBit = 1; else morseBit = 0; 
      if (startBit == 1) {
        if (morseBit == 1){
          analogWrite(buz, 2);
          digitalWrite (keyOut,1);  //keyOut
          delay (300); 
          analogWrite(buz, 0);
          digitalWrite (keyOut,0);  //keyOut
          delay (100); 
        }
        else {
          analogWrite(buz, 2);
          digitalWrite (keyOut,1);  //keyOut
          delay (100); 
          analogWrite(buz, 0);
          digitalWrite (keyOut,0);  //keyOut
          delay (100); 
        }
         if (digitalRead(key) == 0) break;
      }
      if (morseBit == 1) startBit = 1;
      morse = (morse << 1);
    }
    if (digitalRead(key) == 0)  break;
    delay (300);
    if (digitalRead(key) == 0)  break;
   }
  }
  si5351.output_enable(SI5351_CLK2, 0);
  digitalWrite (txOn,0);  //Relais 
  si5351.output_enable(SI5351_CLK1, 1);
}



void morseKey(void)
{
  int timeTx = 100;
  digitalWrite (txOn,1);  //Relais 
  delay (20);
  si5351.output_enable(SI5351_CLK2, 1);
   si5351.output_enable(SI5351_CLK1, 0);
  while (timeTx > 0){
    if (digitalRead(key) == 0) {
      timeTx = 100;  
      digitalWrite (keyOut,1);  //keyOut
      analogWrite(buz, 2);
      delay (5); 
    }
    if (digitalRead(key) == 1) {
      digitalWrite (keyOut,0);  //keyOut
      analogWrite(buz, 0);
      delay (5);
      timeTx--;   
    }
  }
  si5351.output_enable(SI5351_CLK2, 0);
   si5351.output_enable(SI5351_CLK1, 1);
  digitalWrite (txOn,0);  //Relais 
}


void encode()
{
  uint8_t i;
   // Set up Timer1 for interrupts every symbol period.
  noInterrupts();          // Turn off interrupts.
  TCCR1A = 0;              // Set entire TCCR1A register to 0; disconnects
                           //   interrupt output pins, sets normal waveform
                           //   mode.  We're just using Timer1 as a counter.
  TCNT1  = 0;              // Initialize counter value to 0.
  TCCR1B = (1 << CS12) |   // Set CS12 and CS10 bit to set prescale
    (1 << CS10) |          //   to /1024
    (1 << WGM12);          //   turn on CTC
                           //   which gives, 64 us ticks
  TIMSK1 = (1 << OCIE1A);  // Enable timer compare interrupt.
  OCR1A = 10679;             // Set up interrupt trigger count;
  interrupts();            // Re-enable interrupts.
  lcd.setCursor(0, 0);
  lcd.print(wsprfreq);
  lcd.print ("   ");
while(1){ 
  ticks=0; 
  digitalWrite (txOn,1);  //Relais 
  digitalWrite (keyOut,1);  //keyOut
  delay (20);
  si5351.output_enable(SI5351_CLK2, 1);
   si5351.output_enable(SI5351_CLK1, 0);   //RX off
  for(i = 0; i < 162; i++)  
  {
      si5351.set_freq(((wsprfreq+1500) * 100) + (tx_buffer[i] * 146), SI5351_CLK2);
      proceed = false;
      while(!proceed);
      if (digitalRead(key) == 0)  break;    //Abbruck mit Morsetaste
      if (Serial.available()) break;
  }
  // Turn off the output
  si5351.output_enable(SI5351_CLK2, 0);
   si5351.output_enable(SI5351_CLK1, 1);   //RX on
  digitalWrite (keyOut,0);  //keyOut
  digitalWrite (txOn,0);  //Relais 
  delay(5000);
  while (ticks<1054) { //  12min, 350,4 min, 
    lcd.setCursor(4, 1);
    lcd.print(1054-ticks);
    lcd.print("   ");   
    if (digitalRead(A1) == 0){
      ticks=0;
      break;
    }  
    if (digitalRead(key) == 0)  break;    //Abbruck mit Morsetaste     
    if (Serial.available()) break;
  }
  if (ticks=0) break;
  if (digitalRead(key) == 0)  break;    //Abbruck mit Morsetaste     
  if (Serial.available()) break; 
  }  
    lcd.setCursor(4, 1);
    lcd.print("   ");       
    TCCR1A = 1;            
    TCCR1B = 3; 
}


// Loop through the string, transmitting one character at a time.
void encodexxx()
{
  uint8_t i;
  // Reset the tone to the base frequency and turn on the output
  si5351.output_enable(SI5351_CLK2, 1);
  digitalWrite(LED_PIN, HIGH);
 // for(i = 0; i < WSPR_SYMBOL_COUNT; i++)
 for(i = 0; i < 162; i++)
  {
      si5351.set_freq((wsprfreq * 100)+ 150000 + (tx_buffer[i] * tone_spacing),SI5351_CLK2);
     // Serial.print (tx_buffer[i]);  Serial.print (","); 
      proceed = false;
      while(!proceed);
  }
  // Turn off the output
  si5351.output_enable(SI5351_CLK2, 0);
  digitalWrite(LED_PIN, LOW);
}

void loop(void)
{ 
  si5351.update_status();
  if (si5351.dev_status.SYS_INIT == 1) {
     setup();
     delay(500);
  }

  pot = analogRead(A3);
  fstep = 0;
  if (pot < 200) fstep = 1000;
  if (pot > 200) fstep = 200;
  if (pot > 300) fstep = 50;
  if (pot > 400) fstep = 20;
  if (pot > 500) fstep = 0;
  if (pot > 600) fstep = -20;
  if (pot > 700) fstep = -50;
  if (pot > 800) fstep = -200;
  if (pot > 900) fstep = -1000;

  if (fstep != fstepOld) {
    lcd.setCursor(1, 1);
    lcd.print(fstep);
    lcd.print ("   ");
  }
  fstepOld = fstep;

    if (fstep != 0) {
    freq = freq + fstep;
    lcd.setCursor(0, 0);
    lcd.print(freq);
    lcd.print ("   ");
    si5351.set_freq(freq*400ULL, SI5351_CLK1); 
    freqTX = freq - 800;
    si5351.set_freq(freqTX*100ULL, SI5351_CLK2); 
    delay (50);
    wspr = 0;
  }
    if (digitalRead(A0) == 0) {
  
    band = band + 1;
    if (band > 11) band=1;
    if (band == 1) freq = 502400;
    if (band == 2) freq = 1836600;
    if (band == 3) freq = 3568600;
    if (band == 4) freq = 5364700;
    if (band == 5) freq = 7038600;
    if (band == 6) freq = 10138700;
    if (band == 7) freq = 14095600;
    if (band == 8) freq = 18104600;
    if (band == 9) freq = 21094600;
    if (band == 10) freq = 24924600;
    if (band == 11) freq = 28124600;  
    wsprfreq = freq;
    lcd.setCursor(0, 0);
    lcd.print(freq);
    lcd.print ("   ");
    si5351.set_freq(freq*400ULL, SI5351_CLK1); 
    freqTX = freq - 800;
    si5351.set_freq(freqTX*100ULL, SI5351_CLK2); 
    delay (500);
    wspr = 1;
  }

  if (digitalRead(A1) == 0) {
     if (wspr == 1) encode(); else cq();
  }
  
  if (Serial.available()) {
    int ch = Serial.read();
    freq = Serial.parseInt();
    Serial.println (freq);
    int ch2 = Serial.read();
    delay(1);
    ch2 = Serial.read();

    if (ch == 67) {                                                   // C, Cal
      old_cal = eepromReadInt (0);
      new_cal = old_cal - freq;
      eepromWriteInt (0,new_cal);
    }
    
   if (ch == 119) {                                                   // w, Start wspr
      if (wspr = 1) encode();
    } 
    
    if (freq> 8){
      lcd.setCursor(0, 0);
      lcd.print(freq);
      lcd.print("     ");
    //  if (ch == 32) si5351.set_freq(freq*400000ULL, SI5351_PLL_FIXED, SI5351_CLK1);  //" "
      if (ch == 70) si5351.set_freq(freq*400000ULL, SI5351_CLK1);  //F
      if (ch == 102) {                                                               //f
          freqRX = freq;
          wsprfreq = freq; 
          wspr = 0;
          si5351.set_freq(freqRX*400ULL, SI5351_CLK1);    
      }

      if (ch == 65) si5351.set_freq(freq*100000ULL, SI5351_CLK0);  //A
      if (ch == 97) si5351.set_freq(freq*100ULL, SI5351_CLK0);     //a
      if (ch == 66) si5351.set_freq(freq*100000ULL, SI5351_CLK2);  //B
      if (ch == 98) si5351.set_freq(freq*100ULL, SI5351_CLK2);     //b
      
      if (ch == 99){                                                                 //c         
          freqZF = freq;
          freqTX= freqRX + freqZF;
          si5351.set_freq(freqTX*100ULL, SI5351_CLK2);
          timeTune = 1000;
          delay(50);
          si5351.output_enable(SI5351_CLK2, 1);
          lcd.setCursor(0, 0);
          lcd.print(freqTX);
          lcd.print("     ");
          wspr = 0;
      }   
    } 
    if (freq==0){
      if (ch == 65) si5351.output_enable(SI5351_CLK0, 0);
      if (ch == 66) si5351.output_enable(SI5351_CLK2, 0);
      if (ch == 70) si5351.output_enable(SI5351_CLK1, 0);
    }
    if (freq==1){
      if (ch == 65) si5351.output_enable(SI5351_CLK0, 1);
      if (ch == 66) si5351.output_enable(SI5351_CLK2, 1);
      if (ch == 70) si5351.output_enable(SI5351_CLK1, 1);
    }
  }
  if (digitalRead(key) < 1) morseKey();
  timeTune--;
  if (timeTune < 1) si5351.output_enable(SI5351_CLK2, 0);

  
  unf = unf+ analogRead(A2);
  unf=unf * 0.95;
  if (unf > unf_max) unf_max = unf;
  timeUnf++;
  if (timeUnf > 500){
    timeUnf=0;
    if (unf_max<1) unf_max=1;
    int s = 20 * log10(unf_max/4)/6;   
    lcd.setCursor(6, 1);
    lcd.print(s);
    lcd.print (" ");
    unf_max = 0;
  }
      

}


