// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject
// to the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
// ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
// CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

#include <si5351.h>
#include <JTEncode.h>
#include <rs_common.h>
#include <int.h>
#include <string.h>
#include "Wire.h"
#include <EEPROM.h>

// Mode defines

#define WSPR_TONE_SPACING       146           // ~1.46 Hz
#define WSPR_CTC                10672         // CTC value for WSPR
#define WSPR_DEFAULT_FREQ       14097200UL
#define DEFAULT_MODE           MODE_WSPR   
// Hardware defines
#define BUTTON                  12
#define LED_PIN                 13





// Class instantiation
Si5351 si5351;
JTEncode jtencode;

// Global variables
unsigned long  freq;
unsigned long  wsprfreq;
unsigned long  number;
int32_t cal_factor;
int old_cal;
int new_cal;
char message[] = "DK7JD JO31";
char call[] = "DK7JD";  //das Rufzeichen
char loc[] = "JO31";    //der Lacotor wie z.B. JO31";
uint8_t dbm = 23;       //10 mW, 30 für 1W, 37 für 5 W
uint8_t tx_buffer[255];

uint8_t symbol_count;
uint16_t ctc, tone_spacing;
//10mW
//uint8_t tx_buffer2[255] = {1,3,0,2,2,2,2,2,1,0,2,0,1,3,1,0,2,0,1,2,0,1,0,1,1,1,1,0,2,0,2,2,2,0,1,0,2,1,2,3,2,0,2,2,0,2,1,0,1,3,0,0,1,3,2,3,2,2,0,3,3,2,3,0,2,2,0,1,3,2,3,0,1,0,3,2,1,0,2,1,2,0,3,0,3,3,0,0,0,1,1,2,1,2,1,2,2,0,1,0,2,0,0,2,3,2,2,1,2,0,3,3,3,0,1,1,0,0,1,3,0,1,2,0,2,3,3,1,0,2,0,2,2,3,0,1,2,0,3,3,0,0,0,2,0,2,2,1,1,2,3,0,3,3,0,0,0,1,3,2,0,2};
//2W:
uint8_t tx_buffer2[255] = {1,3,0,0,2,2,2,0,1,2,2,0,1,3,1,0,2,0,1,2,0,1,0,3,1,1,1,2,2,0,2,2,2,0,1,0,2,3,2,1,2,2,2,0,0,2,1,0,1,3,0,0,1,3,2,3,2,2,0,1,3,2,3,2,2,2,0,3,3,0,3,0,1,0,3,0,1,0,2,3,2,2,3,2,3,3,0,0,0,1,1,0,1,0,1,2,2,0,1,2,2,0,0,2,3,2,2,1,2,2,3,3,3,2,1,1,0,0,1,1,0,3,2,2,2,1,3,3,0,2,0,2,2,1,0,3,2,0,3,1,0,0,0,0,0,0,2,3,1,2,3,2,3,1,0,2,0,1,3,2,0,2};
// Global variables used in ISRs
volatile bool proceed = false;

// Timer interrupt vector.  This toggles the variable we use to gate
// each column of output to ensure accurate timing.  Called whenever
// Timer1 hits the count set below in setup().
ISR(TIMER1_COMPA_vect)
{
    proceed = true;
}

// Loop through the string, transmitting one character at a time.
void encode()
{
  uint8_t i;
  // Clear out the old transmit buffer
 memset(tx_buffer, 0, 255);
 jtencode.wspr_encode(call, loc, dbm, tx_buffer);
 //tx_buffer =  tx_buffer2;
  // Reset the tone to the base frequency and turn on the output
  si5351.output_enable(SI5351_CLK0, 1);
  digitalWrite(LED_PIN, HIGH);
  for(i = 0; i < symbol_count; i++)
  {
      si5351.set_freq((wsprfreq * 100)+ 150000 + (tx_buffer[i] * tone_spacing), SI5351_PLL_FIXED, SI5351_CLK0);
     // Serial.print (tx_buffer[i]);  Serial.print (","); 
      proceed = false;
      while(!proceed);
  }
  // Turn off the output
  si5351.output_enable(SI5351_CLK0, 0);
  digitalWrite(LED_PIN, LOW);
}


void setup()
{
  int defauld_cal = 1600;
  old_cal = cal_factor;
  old_cal = eepromReadInt (0);
  if ((old_cal<-3000)|(old_cal>3000))  eepromWriteInt (0,defauld_cal);
  cal_factor = 100 * int32_t(eepromReadInt (0));
  Serial.begin(9600);
  Serial.println("Si5351 Clockgen"); Serial.println("");
  si5351.set_correction(cal_factor); 
  si5351.init(SI5351_CRYSTAL_LOAD_8PF, 0);  
  Serial.println(10138700);  
  si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);
  si5351.set_freq(40554800ULL, SI5351_PLL_FIXED, SI5351_CLK1);
  si5351.output_enable(SI5351_CLK1, 1);
  freq = 10138700;
  // Use the Arduino's on-board LED as a keying indicator.
  pinMode(LED_PIN, OUTPUT);
  digitalWrite(LED_PIN, LOW);
  // Use a button connected to pin 12 as a transmit trigger
  pinMode(BUTTON, INPUT_PULLUP);
  // Set the proper frequency, tone spacing, symbol count, and
  // timer CTC depending on mode
    freq = WSPR_DEFAULT_FREQ;
    ctc = WSPR_CTC;
    symbol_count = WSPR_SYMBOL_COUNT; // From the library defines
    tone_spacing = WSPR_TONE_SPACING;


  // Initialize the Si5351
  // Change the 2nd parameter in init if using a ref osc other
  // than 25 MHz

  // Set CLK0 output
  si5351.drive_strength(SI5351_CLK0, SI5351_DRIVE_8MA); // Set for max power if desired
  si5351.output_enable(SI5351_CLK0, 0); // Disable the clock initially

  // Set up Timer1 for interrupts every symbol period.
  noInterrupts();          // Turn off interrupts.
  TCCR1A = 0;              // Set entire TCCR1A register to 0; disconnects
                           //   interrupt output pins, sets normal waveform
                           //   mode.  We're just using Timer1 as a counter.
  TCNT1  = 0;              // Initialize counter value to 0.
  TCCR1B = (1 << CS12) |   // Set CS12 and CS10 bit to set prescale
    (1 << CS10) |          //   to /1024
    (1 << WGM12);          //   turn on CTC
                           //   which gives, 64 us ticks
  TIMSK1 = (1 << OCIE1A);  // Enable timer compare interrupt.
  OCR1A = ctc;             // Set up interrupt trigger count;
  interrupts();            // Re-enable interrupts.
}




static void flush_input(void)
{
  while (Serial.available() > 0)
  Serial.read();
}

void eepromWriteInt(int adr, int wert) {
byte low, high;
  low=wert&0xFF;
  high=(wert>>8)&0xFF;
  EEPROM.write(adr, low); // dauert 3,3ms 
  EEPROM.write(adr+1, high);
  return;
} //eepromWriteInt


int eepromReadInt(int adr) {
byte low, high;
  low=EEPROM.read(adr);
  high=EEPROM.read(adr+1);
  return low + ((high << 8)&0xFF00);
} //eepromReadInt




void loop(void)
{
  si5351.update_status();
  if (si5351.dev_status.SYS_INIT == 1) {
     setup();
     delay(500);
  }

   // Debounce the button and trigger WSPR TX on push
  if(digitalRead(BUTTON) == LOW)
  {
    delay(50);   // delay to debounce
    if (digitalRead(BUTTON) == LOW)
    {
      encode();
      delay(5000); //delay to avoid extra triggers
    }
  }
  
  if (Serial.available()) {
    int ch = Serial.read();
    freq = Serial.parseInt();
    Serial.println (freq);
    int ch2 = Serial.read();
    delay(1);
    ch2 = Serial.read();
    flush_input();
   
    if (ch == 67) {                                                   // C, Cal
      old_cal = eepromReadInt (0);
      new_cal = old_cal - freq;
      eepromWriteInt (0,new_cal);
    }
    
    if (ch == 119) {                                                   // w, Start wspr
      dbm = freq;
      encode();
    } 
    
    if (freq> 5000){
      if (ch == 102) {                                                               //f 
        si5351.set_freq(freq*400ULL, SI5351_PLL_FIXED, SI5351_CLK1); 
        wsprfreq = freq;   
      }
    
      if (ch == 65) si5351.set_freq(freq*100000ULL, SI5351_PLL_FIXED, SI5351_CLK0);  //A
      if (ch == 97) si5351.set_freq(freq*100ULL, SI5351_PLL_FIXED, SI5351_CLK0);     //a
      if (ch == 66) si5351.set_freq(freq*100000ULL, SI5351_PLL_FIXED, SI5351_CLK2);  //B
      if (ch == 98) si5351.set_freq(freq*100ULL, SI5351_PLL_FIXED, SI5351_CLK2);     //b
    } 
    if (freq==0){
      if (ch == 65) si5351.output_enable(SI5351_CLK0, 0);
      if (ch == 66) si5351.output_enable(SI5351_CLK2, 0);
      if (ch == 70) si5351.output_enable(SI5351_CLK1, 0);
    }
     if (freq==1){
      if (ch == 65) si5351.output_enable(SI5351_CLK0, 1);
      if (ch == 66) si5351.output_enable(SI5351_CLK2, 1);
      if (ch == 70) si5351.output_enable(SI5351_CLK1, 1);
    }
  }
}





