//SI5351_vfo2.1 + LCD + Output Clk0/Clk2 

#include "si5351.h"
#include "Wire.h"
#include <LiquidCrystal.h>
#include <EEPROM.h>

Si5351 si5351;
LiquidCrystal lcd(2, 3, 4, 5, 6, 7);

unsigned long  freq;
int32_t cal_factor;
int defauld_cal = 1600;
int old_cal;
int new_cal;
int pot;
long fstep;
long fstepOld;
int band;

void setup(void)
{
  pinMode(A0, INPUT_PULLUP);
  pinMode(A1, INPUT_PULLUP);
  freq= 7038600;

  int defauld_cal = 1600;
  old_cal = cal_factor;
  old_cal = eepromReadInt (0);
  if ((old_cal<-3000)|(old_cal>3000))  eepromWriteInt (0,defauld_cal);
  cal_factor = 100 * int32_t(eepromReadInt (0));
  Serial.begin(9600);
  Serial.println("Si5351 Clockgen"); Serial.println("");
  si5351.set_correction(cal_factor); 
 
  si5351.init(SI5351_CRYSTAL_LOAD_8PF, 0);  
  Serial.println(7038600);  
  si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);
  si5351.set_freq(freq*400ULL, SI5351_PLL_FIXED, SI5351_CLK1);
  si5351.output_enable(SI5351_CLK1, 1);
  lcd.begin(16, 2);
  lcd.print(freq);
}

static void flush_input(void)
{
  while (Serial.available() > 0)
  Serial.read();
}

void eepromWriteInt(int adr, int wert) {
byte low, high;
  low=wert&0xFF;
  high=(wert>>8)&0xFF;
  EEPROM.write(adr, low); // dauert 3,3ms 
  EEPROM.write(adr+1, high);
  return;
} //eepromWriteInt


int eepromReadInt(int adr) {
byte low, high;
  low=EEPROM.read(adr);
  high=EEPROM.read(adr+1);
  return low + ((high << 8)&0xFF00);
} //eepromReadInt

void loop(void)
{ 
  
  si5351.update_status();
  if (si5351.dev_status.SYS_INIT == 1) {
     setup();
     delay(500);
  }

  pot = analogRead(A3);
  fstep = 0;
  if (pot < 200) fstep = 1000;
  if (pot > 200) fstep = 200;
  if (pot > 300) fstep = 50;
  if (pot > 400) fstep = 20;
  if (pot > 500) fstep = 0;
  if (pot > 600) fstep = -20;
  if (pot > 700) fstep = -50;
  if (pot > 800) fstep = -200;
  if (pot > 900) fstep = -1000;

  if (fstep != fstepOld) {
    lcd.setCursor(1, 1);
    lcd.print(fstep);
    lcd.print ("   ");
  }
  fstepOld = fstep;

    if (fstep != 0) {
    freq = freq + fstep;
    lcd.setCursor(0, 0);
    lcd.print(freq);
    si5351.set_freq(freq*400ULL, SI5351_PLL_FIXED, SI5351_CLK1); 
    lcd.print ("   ");
    delay (50);
  }
    if (digitalRead(A0) == 0) {
  
    band = band + 1;
    if (band > 11) band=1;
    if (band == 1) freq = 502400;
    if (band == 2) freq = 1836600;
    if (band == 3) freq = 3568600;
    if (band == 4) freq = 5364700;
    if (band == 5) freq = 7038600;
    if (band == 6) freq = 10138700;
    if (band == 7) freq = 14095600;
    if (band == 8) freq = 18104600;
    if (band == 9) freq = 21094600;
    if (band == 10) freq = 24924600;
    if (band == 11) freq = 28124600;  
    lcd.setCursor(0, 0);
    lcd.print(freq);
    si5351.set_freq(freq*400ULL, SI5351_PLL_FIXED, SI5351_CLK1); 
    lcd.print ("   ");
    delay (500);
  }
  
  if (Serial.available()) {
    int ch = Serial.read();
    freq = Serial.parseInt();
    Serial.println (freq);
    int ch2 = Serial.read();
    delay(1);
    ch2 = Serial.read();

    if (ch == 67) {                                                   // C, Cal
      old_cal = eepromReadInt (0);
      new_cal = old_cal - freq;
      eepromWriteInt (0,new_cal);
    }
   
    if (freq> 8){
      lcd.setCursor(0, 0);
      lcd.print(freq);
      lcd.print("     ");
      if (ch == 32) si5351.set_freq(freq*400000ULL, SI5351_PLL_FIXED, SI5351_CLK1);  //" "
      if (ch == 70) si5351.set_freq(freq*400000ULL, SI5351_PLL_FIXED, SI5351_CLK1);  //F
      if (ch == 102) si5351.set_freq(freq*400ULL, SI5351_PLL_FIXED, SI5351_CLK1);    //f 
    
      if (ch == 65) si5351.set_freq(freq*100000ULL, SI5351_PLL_FIXED, SI5351_CLK0);  //A
      if (ch == 97) si5351.set_freq(freq*100ULL, SI5351_PLL_FIXED, SI5351_CLK0);     //a
      if (ch == 66) si5351.set_freq(freq*100000ULL, SI5351_PLL_FIXED, SI5351_CLK2);  //B
      if (ch == 98) si5351.set_freq(freq*100ULL, SI5351_PLL_FIXED, SI5351_CLK2);     //b
    } 
    if (freq==0){
      if (ch == 65) si5351.output_enable(SI5351_CLK0, 0);
      if (ch == 66) si5351.output_enable(SI5351_CLK2, 0);
      if (ch == 70) si5351.output_enable(SI5351_CLK1, 0);
    }
     if (freq==1){
      if (ch == 65) si5351.output_enable(SI5351_CLK0, 1);
      if (ch == 66) si5351.output_enable(SI5351_CLK2, 1);
      if (ch == 70) si5351.output_enable(SI5351_CLK1, 1);
    }
  }
}


