//SI5351_vfo + LCD + TX output Clk2 
//RX/TX offset = -800 Hz
//RX/TX offset -20...+20 kHz
//S1 Band, WSPR 600m ...10m

#include "si5351.h"
#include "Wire.h"
#include <LiquidCrystal.h>

Si5351 si5351;
LiquidCrystal lcd(2, 3, 4, 5, 6, 7);
 int r;
unsigned long freq = 10100;
unsigned long  freqHz;
int d[512];
int snr;
int u;

void setup(void)

{

  Serial.begin(9600);
  Serial.println("Si5351 Clockgen"); Serial.println("");

  // Start serial and initialize the Si5351
  si5351.init(SI5351_CRYSTAL_LOAD_10PF, 25002127);  //Quarz 2,1 kHz über 25 MHz

  // Set CLK0 to output 14 MHz with a fixed PLL frequency
  si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);
  si5351.set_freq(1010100000ULL, SI5351_PLL_FIXED, SI5351_CLK0);
  si5351.set_freq(4040000000ULL, SI5351_PLL_FIXED, SI5351_CLK1);
  si5351.set_freq(10000ULL, SI5351_PLL_FIXED, SI5351_CLK2);
  si5351.output_enable(SI5351_CLK0, 1);
  si5351.output_enable(SI5351_CLK1, 1);
  si5351.output_enable(SI5351_CLK2, 0);
  lcd.begin(16, 2);
  pinMode(A0, INPUT_PULLUP);
  pinMode(A1, INPUT_PULLUP);
  pinMode(8, INPUT_PULLUP);  //Tx an
  pinMode(9, INPUT_PULLUP);  //Taste
  pinMode(10, OUTPUT);       //TX/RX
  pinMode(11, OUTPUT);       //Key Out
  analogReference(INTERNAL);
}



void uac(void)
{
  long uac =0;
  for (int i=0; i <= 200; i++){
    uac = uac+ analogRead(A2);
  }
  u = uac/50;
  Serial.println (u); 
}


void loop(void)
{
   Serial.println (0); 
   for (int i=1; i <= 500; i++){
      int f= i * 50;
      //Serial.print (f); Serial.print ("  ");
      si5351.set_freq(f*100000, SI5351_PLL_FIXED, SI5351_CLK0); 
      delay(10);
      si5351.set_freq((f+5)*400000, SI5351_PLL_FIXED, SI5351_CLK1); 
      if (i== 1) delay (500);
      delay(10);
      lcd.setCursor(0, 0);
      lcd.print (f);
      lcd.print ("  ");
      delay(20);
      uac();
   }
   while ( (digitalRead(A1) == 1));
}



