(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 231*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1621785,      60460]*)
(*NotebookOutlinePosition[   1622659,      60490]*)
(*  CellTagsIndexPosition[   1622615,      60486]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[""], "Input"],

Cell["KAPPA TAU CURVES", "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
by Rudy Rucker
Copyright \[Copyright] 1994\
\>", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Mathematical Background", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\

     One can associate a trihedron of unit vectors with each point 
of a

space curve.  The tangent vector lies on the striaght  line that best

matches the curve and can be thought of as determined by two

\"consecutive\" points of the curve.  The normal vector points in the

direction in which the tip of the tangent vector is moving,  If one

takes three \"consecutive\" points of the curve one gets a plane, known as

the osculating or \"kissing\" plane which best fits the curve at that

point.  The tangent and the normal vectors lie in the osculating plane

and the binormal vector is perpendicular to the osculating plane.

     For each point of a space curve one can also define the quantities

known as curvature and torsion.  The curve's curvature measures its

tendency to bendaway from its tangent line, and the curve's torsion

measures the tendency of the curve  to twist  out of the osculating

plane.  A theorem of differential geometry states that  a space curve's

shape  is uniquely characterized  by the functions kappa and tau which

give the curves curvature and torsion as functions of the arclength

along the curve.

     In this notebook, I state and use an algorithm for \"kappa tau

curves,\" which are space curves defined in terms of functions for

curvature and torsion.  The algorithm is based on a set of three

formulas known as \"Frenet's formlas for the moving trihedron of a space

curve.\"  These formulas were published by the French mathematicians

Serret and Frenet in 1852.

     Suppose that s parametrizes the arclength along a space curve, and

that kappa and tau are functions of s which give the curvature and the

torsion of the curve.  Suppose also that T, N, and B are vector functions

giving the tangent, normal, and binormal as functions of s.  Then the

Frenet formulas are as follows: 
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open]],

Cell["\<\

dT/ds =             kappa * N

dN/ds = -kappa * T            + tau * B

dB/ds =             -tau * N 
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\

       You can get an intuitive feel for the truth of the Frenet 
formulas

by trying to \"fly\" your hand around as if it were the moving trihedron

of a space curve.  Make a fist with your right hand and then extend your

index finger, middle finger, and thumb so that they are at right angles

to each other.  These fingers play the role of tangent, normal, and

binormal.

     There seem to be three intrinsic ways your hand can rotate: around

your thumb, your middle finger, or your index finger.  To cystallize

what is meant, try grabbing these with your left hand and performing an

\"unscrewing\" motion on each.  These produce motions that are also called

yaw, pitch, and roll.

     If your hand moves along an imaginary space curve so that your

index is always pointing in the direction of motion and your middle

finger is always pointing in the direction in which the index finger is

turning, then there will not actually be any \"pitch\" or \"middle finger

unscrewing\" motion.  The reason is that all the turning of the index

finger or tangent vector is in the direction of the middle finger or

normal.  This is all \"thumb unscrewing\" motion.  The only other motion

allowed is motion which does not move the index finger: this is the

\"index finger unscrewing\" motion.

     The \"thumb unscrewing\" motion is summarized in the first of the

Frenet formulae: the change of the tangent is in the direction of the

normal with a magnitude corresponding to the curvature.  The \"index

finger unscrewing\" motion appears in the third Frenet formula: the

change of the binormal is in the reverse direction of the normal and

with a magnitude corresponding to the torsion.  The second of the Frenet

formulas captures the \"back effects\" of the first and third formulas: As

the tangent turns towards the normal, the normal turns away from the

tangent; and as the binormal turns away from the normal, the normal

turns towards the binormal.

     Our algorithm performs a simple \"Euler-style\" numerical integration

to compute the successive points and trihedra of a space curve given by

a kappa and a tau function.  The curve is displayed as a ribbon by

letting rungs stick out along the normal vectors and by connecting these

rungs to make paved tiles.



     
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Usage and Limitations", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
First select and evaluate the cell containing the Algorithm.  Then 
create  and evaluate a cell of this form: 
 
clear; 
top = <Integer constant.   This measures the number of steps the 
computation goes through.  Values  larger than 200 are likely to cause 
Mathematica to run out of memory and  crash by locking up and destroying 
the active notebook.>; 
kappa[s_] =  <Real number expression in s.>; 
tau[s_] = <Real number expression in s.>; 
 width = <Real number measuring the width of the ribbon.  Mathematica 
scales  the curve to fit in a fixed box, so if you have a large curve 
length you  may want a larger width, and conversely.>; 
ds = <Real number for the step  size.  The total arclength will be top 
times ds.>; 
pribbonfrenet 
 
The  most significant limitation is that when Mathematica runs out of 
memory it  does not issue a warning, instead it crashes by locking up the 
machine and  commonly destroying the active notebook.  Values of top over 
300 reliably  crash a machine with 12 Meg of RAM.  It is good practice to 
save a backup  copy of this notebook under a different name from the 
working copy. 
 
A  second limitation is that we are using the crude \"Euler style\" method 
of  numerical integration instead of a more accurate \"Runge Kutte\" style 
 method.  This can in priciple be changed if there is sufficient need.
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open]],

Cell[CellGroupData[{

Cell["Algorithm to Display a Kappa-Tau Space Curve as a Ribbon", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(clear := 
      Clear[ds, width, kappa, tau, top, point, tangent, normal, binormal, 
        curve, ncurve, tiles]; \)\), 
    \(\(normalize[vector_] := vector\/\@\(vector.vector\); \)\), 
    \(\(cross[u_, v_] := {
        u\[LeftDoubleBracket]2\[RightDoubleBracket]v\[LeftDoubleBracket]3
              \[RightDoubleBracket] - 
          u\[LeftDoubleBracket]3\[RightDoubleBracket]v\[LeftDoubleBracket]2
              \[RightDoubleBracket], 
        u\[LeftDoubleBracket]3\[RightDoubleBracket]v\[LeftDoubleBracket]1
              \[RightDoubleBracket] - 
          u\[LeftDoubleBracket]1\[RightDoubleBracket]v\[LeftDoubleBracket]3
              \[RightDoubleBracket], 
        u\[LeftDoubleBracket]1\[RightDoubleBracket]v\[LeftDoubleBracket]2
              \[RightDoubleBracket] - 
          u\[LeftDoubleBracket]2\[RightDoubleBracket]v\[LeftDoubleBracket]1
              \[RightDoubleBracket]}; \)\), 
    \(pribbonfrenet := 
      \((point = {0., 0., 0.}; edgepoint = {0., width, 0.}; 
        tangent = 
          If[kappa[0] \[NotEqual] 0. || tau[0] \[NotEqual] 0, 
            normalize[{kappa[0], 0., tau[0]}], {1., 0., 0.}]; 
        normal = {0., 1., 0.}; binormal = cross[tangent, normal]; 
        curve = {point}; edgecurve = {edgepoint}; tiles = {}; 
        rungs = {Line[{point, edgepoint}]}; 
        Do[newpoint = point + ds\ tangent; 
          newtangent = normalize[tangent + kappa[n\ ds]\ normal\ ds]; 
          newnormal = 
            normalize[
              normal + 
                \((tau[n\ ds]\ binormal - kappa[n\ ds]\ tangent)\)\ ds]; 
          newedgepoint = newpoint + width\ newnormal; 
          AppendTo[curve, newpoint]; AppendTo[edgecurve, newedgepoint]; 
          AppendTo[tiles, 
            Polygon[{point, edgepoint, newedgepoint, newpoint}]]; 
          AppendTo[rungs, Line[{newpoint, newedgepoint}]]; 
          tangent = newtangent; normal = newnormal; 
          binormal = cross[tangent, normal]; point = newpoint; 
          \(edgepoint = newedgepoint; \), {n, 1, top, 1}]; 
        Show[Graphics3D[{Thickness[.006], Line[curve]}], 
          Graphics3D[{Thickness[.003], RGBColor[1, 0, 0], Line[edgecurve]}], 
          Graphics3D[{RGBColor[1, 1, 0], EdgeForm[], tiles}], 
          Graphics3D[{GrayLevel[0.25], rungs}], BoxRatios \[Rule] {1, 1, 1}])
        \)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1"\( : \ 
        \)"Possible spelling error: new symbol name \"\!\(top\)\" is similar \
to existing symbol \"\!\(Top\)\"."\)], "Message"]
}, Open]]
}, Open]],

Cell[BoxData[
    \(General::"spell1"\( : \ 
        \)"Possible spelling error: new symbol name \"\!\(point\)\" is \
similar to existing symbol \"\!\(Point\)\"."\)], "Message"],

Cell[BoxData[
    \(General::"spell1"\( : \ 
        \)"Possible spelling error: new symbol name \"\!\(normal\)\" is \
similar to existing symbol \"\!\(Normal\)\"."\)], "Message"],

Cell[BoxData[
    \(General::"stop"\( : \ 
        \)"Further output of \!\(General :: \"spell1\"\) will be suppressed \
during this calculation."\)], "Message"],

Cell[BoxData[
    \(General::"spell1"\( : \ 
        \)"Possible spelling error: new symbol name \"\!\(cross\)\" is \
similar to existing symbol \"\!\(Cross\)\"."\)], "Message"],

"\!\(Cross\)\"."\)], "Message"],

aluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

->True],

Cell[CellGroupData[{

stant.", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 60; kappa[s_] = 1.; tau[s_] = 1.; width = .3; ds = .1; \), 
  
    \(pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 0 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5538 .71891 m .54563 .6391 L .51505 .72847 L .824 .893 .891 r
F
.5538 .71891 m .56212 .62826 L .54563 .6391 L F
.59219 .70649 m .56212 .62826 L .5538 .71891 L .824 .861 .874 r
F
.59219 .70649 m .57809 .61614 L .56212 .62826 L F
.25 g
.5 Mabswid
.5538 .71891 m
.56212 .62826 L
s
.62966 .69122 m .57809 .61614 L .59219 .70649 L .819 .831 .858 r
F
0 g
.006 w
.5538 .71891 m
.59219 .70649 L
s
.51505 .72847 m .52892 .64864 L .47647 .73521 L .814 .924 .908 r
F
.51505 .72847 m .54563 .6391 L .52892 .64864 L F
0 g
.51505 .72847 m
.5538 .71891 L
s
.62966 .69122 m .59325 .60277 L .57809 .61614 L .819 .831 .858 r
F
.25 g
.5 Mabswid
.57809 .61614 m
.59219 .70649 L
s
.66564 .67314 m .59325 .60277 L .62966 .69122 L .811 .802 .843 r
F
0 g
.006 w
.59219 .70649 m
.62966 .69122 L
s
.47647 .73521 m .51228 .65689 L .43864 .73917 L .792 .951 .923 r
F
.47647 .73521 m .52892 .64864 L .51228 .65689 L F
0 g
.47647 .73521 m
.51505 .72847 L
s
.25 g
.5 Mabswid
.47647 .73521 m
.47811 .73251 L
s
.51505 .72847 m
.54478 .64159 L
s
.54478 .64159 m
.54563 .6391 L
s
.66564 .67314 m .60732 .58821 L .59325 .60277 L .811 .802 .843 r
F
.69958 .65229 m .60732 .58821 L .66564 .67314 L .8 .776 .831 r
F
.25 g
.62852 .68846 m
.62966 .69122 L
s
0 g
.006 w
.62966 .69122 m
.66564 .67314 L
s
.43864 .73917 m .49602 .66388 L .4021 .74042 L .752 .969 .93 r
F
.43864 .73917 m .51228 .65689 L .49602 .66388 L F
.25 g
.5 Mabswid
.52746 .65105 m
.52892 .64864 L
s
0 g
.006 w
.43864 .73917 m
.47647 .73521 L
s
.25 g
.5 Mabswid
.43864 .73917 m
.44094 .73659 L
s
.69958 .65229 m .62003 .57254 L .60732 .58821 L .8 .776 .831 r
F
.25 g
.60732 .58821 m
.60894 .59057 L
s
.73092 .62879 m .62003 .57254 L .69958 .65229 L .788 .752 .82 r
F
.25 g
.62852 .68845 m
.62852 .68846 L
s
.66382 .67048 m
.66564 .67314 L
s
0 g
.006 w
.66564 .67314 m
.69958 .65229 L
s
.4021 .74042 m .48043 .66965 L .36743 .73906 L .688 .97 .926 r
F
.4021 .74042 m .49602 .66388 L .48043 .66965 L F
.25 g
.5 Mabswid
.52635 .65289 m
.52746 .65105 L
s
.51024 .65918 m
.51228 .65689 L
s
0 g
.006 w
.4021 .74042 m
.43864 .73917 L
s
.25 g
.5 Mabswid
.4021 .74042 m
.40507 .738 L
s
.73092 .62879 m .63114 .55585 L .62003 .57254 L .788 .752 .82 r
F
.25 g
.62003 .57254 m
.62392 .57643 L
s
.59325 .60277 m
.62852 .68845 L
s
.75908 .60275 m .63114 .55585 L .73092 .62879 L .775 .73 .811 r
F
.25 g
.66381 .67047 m
.66382 .67048 L
s
.69708 .64979 m
.69958 .65229 L
s
0 g
.006 w
.69958 .65229 m
.73092 .62879 L
s
.36743 .73906 m .46581 .67427 L .3352 .73522 L .6 .949 .906 r
F
.36743 .73906 m .48043 .66965 L .46581 .67427 L F
.25 g
.5 Mabswid
.50868 .66092 m
.51024 .65918 L
s
.49343 .666 m
.49602 .66388 L
s
0 g
.006 w
.36743 .73906 m
.4021 .74042 L
s
.25 g
.5 Mabswid
.36984 .73758 m
.37102 .73686 L
s
.36743 .73906 m
.36984 .73758 L
s
.47811 .73251 m
.52495 .65519 L
s
.52495 .65519 m
.52635 .65289 L
s
.75908 .60275 m .6404 .53826 L .63114 .55585 L .775 .73 .811 r
F
.25 g
.63114 .55585 m
.63598 .55939 L
s
.7835 .57437 m .6404 .53826 L .75908 .60275 L .762 .711 .804 r
F
.25 g
.60894 .59057 m
.66381 .67047 L
s
.62392 .57643 m
.69707 .64978 L
s
.69707 .64978 m
.69708 .64979 L
s
.72777 .62648 m
.73092 .62879 L
s
0 g
.006 w
.73092 .62879 m
.75908 .60275 L
s
.3352 .73522 m .45243 .67782 L .30599 .72905 L .492 .904 .87 r
F
.3352 .73522 m .46581 .67427 L .45243 .67782 L F
.25 g
.5 Mabswid
.50672 .6631 m
.50868 .66092 L
s
.49144 .66762 m
.49343 .666 L
s
.47732 .67156 m
.48043 .66965 L
s
0 g
.006 w
.3352 .73522 m
.36743 .73906 L
s
.25 g
.5 Mabswid
.338 .73392 m
.33937 .73328 L
s
.3352 .73522 m
.338 .73392 L
s
.7835 .57437 m .64762 .51992 L .6404 .53826 L .762 .711 .804 r
F
.80365 .54388 m .64762 .51992 L .7835 .57437 L .748 .693 .799 r
F
.25 g
.63598 .55939 m
.72775 .62647 L
s
.72775 .62647 m
.72777 .62648 L
s
.75531 .6007 m
.75908 .60275 L
s
0 g
.006 w
.75908 .60275 m
.7835 .57437 L
s
.80365 .54388 m .65263 .50099 L .64762 .51992 L .748 .693 .799 r
F
.25 g
.5 Mabswid
.6404 .53826 m
.64924 .54307 L
s
.819 .51158 m .65263 .50099 L .80365 .54388 L .734 .677 .795 r
F
.25 g
.64924 .54307 m
.75529 .60069 L
s
.75529 .60069 m
.75531 .6007 L
s
.65768 .52395 m
.77916 .57263 L
s
.77916 .57263 m
.7835 .57437 L
s
.64762 .51992 m
.65768 .52395 L
s
0 g
.006 w
.7835 .57437 m
.80365 .54388 L
s
.30599 .72905 m .44056 .68041 L .28037 .72076 L .372 .839 .824 r
F
.30599 .72905 m .45243 .67782 L .44056 .68041 L F
.25 g
.5 Mabswid
.48896 .66964 m
.49144 .66762 L
s
.47494 .67303 m
.47732 .67156 L
s
.46223 .67594 m
.46581 .67427 L
s
0 g
.006 w
.30599 .72905 m
.3352 .73522 L
s
.25 g
.5 Mabswid
.30914 .72795 m
.31069 .72741 L
s
.30599 .72905 m
.30914 .72795 L
s
.44094 .73659 m
.50435 .66576 L
s
.50435 .66576 m
.50672 .6631 L
s
1 0 0 r
.003 w
.56212 .62826 m
.57809 .61614 L
s
.57809 .61614 m
.59325 .60277 L
s
.54563 .6391 m
.56212 .62826 L
s
.59325 .60277 m
.60732 .58821 L
s
.52892 .64864 m
.54563 .6391 L
s
.819 .51158 m .65528 .48164 L .65263 .50099 L .734 .677 .795 r
F
.82908 .47781 m .65528 .48164 L .819 .51158 L .72 .662 .792 r
F
.25 g
.5 Mabswid
.65983 .50303 m
.7988 .5425 L
s
.7988 .5425 m
.80365 .54388 L
s
.65263 .50099 m
.65983 .50303 L
s
0 g
.006 w
.80365 .54388 m
.819 .51158 L
s
.25 g
.5 Mabswid
.65967 .48245 m
.819 .51158 L
s
1 0 0 r
.003 w
.60732 .58821 m
.62003 .57254 L
s
.51228 .65689 m
.52892 .64864 L
s
.62003 .57254 m
.63114 .55585 L
s
.28037 .72076 m .43047 .68215 L .25893 .71055 L .255 .765 .776 r
F
.28037 .72076 m .44056 .68041 L .43047 .68215 L F
.25 g
.5 Mabswid
.40507 .738 m
.48593 .6721 L
s
.48593 .6721 m
.48896 .66964 L
s
.37102 .73686 m
.47197 .67485 L
s
.47197 .67485 m
.47494 .67303 L
s
.33937 .73328 m
.45949 .67722 L
s
.45949 .67722 m
.46223 .67594 L
s
.44844 .67922 m
.45243 .67782 L
s
0 g
.006 w
.28037 .72076 m
.30599 .72905 L
s
.25 g
.5 Mabswid
.28384 .71988 m
.28555 .71945 L
s
.28037 .72076 m
.28384 .71988 L
s
.44022 .6805 m
.44056 .68041 L
s
1 0 0 r
.003 w
.49602 .66388 m
.51228 .65689 L
s
.63114 .55585 m
.6404 .53826 L
s
.6404 .53826 m
.64762 .51992 L
s
.48043 .66965 m
.49602 .66388 L
s
.64762 .51992 m
.65263 .50099 L
s
.82908 .47781 m .65548 .46209 L .65528 .48164 L .72 .662 .792 r
F
.25 g
.5 Mabswid
.65528 .48164 m
.65967 .48245 L
s
.83346 .44301 m .65548 .46209 L .82908 .47781 L .706 .649 .791 r
F
0 g
.006 w
.819 .51158 m
.82908 .47781 L
s
1 0 0 r
.003 w
.46581 .67427 m
.48043 .66965 L
s
.34465 .16296 m .43665 .27531 L .45062 .27594 L .408 .613 .933 r
F
1 0 0 r
.65263 .50099 m
.65528 .48164 L
s
.45243 .67782 m
.46581 .67427 L
s
.25893 .71055 m .42238 .68318 L .24223 .69873 L .15 .692 .735 r
F
.25893 .71055 m .43047 .68215 L .42238 .68318 L F
.25 g
.5 Mabswid
.31069 .72741 m
.44539 .68029 L
s
.44539 .68029 m
.44844 .67922 L
s
.28555 .71945 m
.43624 .6815 L
s
.43624 .6815 m
.44022 .6805 L
s
0 g
.006 w
.25893 .71055 m
.28037 .72076 L
s
.25 g
.5 Mabswid
.25893 .71055 m
.26451 .70963 L
s
.38283 .15452 m .45062 .27594 L .46619 .27793 L .435 .601 .915 r
F
.25 g
.43436 .27251 m
.43665 .27531 L
s
.34465 .16296 m .45062 .27594 L .38283 .15452 L .408 .613 .933 r
F
1 0 0 r
.003 w
.43665 .27531 m
.45062 .27594 L
s
.83346 .44301 m .65318 .44253 L .65548 .46209 L .706 .649 .791 r
F
1 0 0 r
.65528 .48164 m
.65548 .46209 L
s
.25 g
.5 Mabswid
.65548 .46209 m
.82908 .47781 L
s
1 0 0 r
.003 w
.44056 .68041 m
.45243 .67782 L
s
.83181 .40766 m .65318 .44253 L .83346 .44301 L .691 .637 .791 r
F
0 g
.006 w
.82908 .47781 m
.83346 .44301 L
s
.42477 .14999 m .46619 .27793 L .48307 .28143 L .462 .593 .897 r
F
.25 g
.5 Mabswid
.44894 .27292 m
.45062 .27594 L
s
.4326 .27036 m
.43436 .27251 L
s
.38283 .15452 m .46619 .27793 L .42477 .14999 L .435 .601 .915 r
F
1 0 0 r
.003 w
.45062 .27594 m
.46619 .27793 L
s
.83181 .40766 m .64838 .4232 L .65318 .44253 L .691 .637 .791 r
F
1 0 0 r
.65318 .44253 m
.65548 .46209 L
s
.25 g
.5 Mabswid
.65318 .44253 m
.83346 .44301 L
s
1 0 0 r
.003 w
.43047 .68215 m
.44056 .68041 L
s
.82392 .37231 m .64838 .4232 L .83181 .40766 L .676 .627 .792 r
F
0 g
.006 w
.83181 .40766 m
.83346 .44301 L
s
.82392 .37231 m .64113 .40431 L .64838 .4232 L .676 .627 .792 r
F
1 0 0 r
.003 w
.64838 .4232 m
.65318 .44253 L
s
.25 g
.5 Mabswid
.64838 .4232 m
.83181 .40766 L
s
.46948 .14977 m .48307 .28143 L .5009 .28655 L .488 .588 .88 r
F
.42477 .14999 m .48307 .28143 L .46948 .14977 L .462 .593 .897 r
F
1 0 0 r
.003 w
.46619 .27793 m
.48307 .28143 L
s
.25 g
.5 Mabswid
.42477 .14999 m
.42622 .15448 L
s
.42622 .15448 m
.46619 .27793 L
s
.38283 .15452 m
.44894 .27292 L
s
.34465 .16296 m
.4326 .27036 L
s
.8097 .33754 m .64113 .40431 L .82392 .37231 L .661 .617 .794 r
F
.8097 .33754 m .63155 .38609 L .64113 .40431 L F
1 0 0 r
.003 w
.64113 .40431 m
.64838 .4232 L
s
.24223 .69873 m .41649 .68365 L .23081 .68559 L .065 .628 .709 r
F
.24223 .69873 m .42238 .68318 L .41649 .68365 L F
.25 g
.5 Mabswid
.26451 .70963 m
.42587 .68291 L
s
.42587 .68291 m
.43047 .68215 L
s
0 g
.006 w
.24223 .69873 m
.25893 .71055 L
s
.25 g
.5 Mabswid
.24811 .69822 m
.42238 .68318 L
s
.24223 .69873 m
.24811 .69822 L
s
.51585 .15411 m .5009 .28655 L .5193 .29337 L .512 .584 .864 r
F
.46948 .14977 m .5009 .28655 L .51585 .15411 L .488 .588 .88 r
F
1 0 0 r
.003 w
.48307 .28143 m
.5009 .28655 L
s
.25 g
.5 Mabswid
.46948 .14977 m
.48307 .28143 L
s
.78923 .30401 m .63155 .38609 L .8097 .33754 L .645 .609 .798 r
F
.25 g
.81779 .37338 m
.82392 .37231 L
s
.78923 .30401 m .6198 .36876 L .63155 .38609 L .645 .609 .798 r
F
.25 g
.64113 .40431 m
.81779 .37338 L
s
1 0 0 r
.003 w
.63155 .38609 m
.64113 .40431 L
s
.25 g
.5 Mabswid
.63155 .38609 m
.63612 .38484 L
s
0 g
.006 w
.82392 .37231 m
.83181 .40766 L
s
1 0 0 r
.003 w
.42238 .68318 m
.43047 .68215 L
s
.56267 .16314 m .5193 .29337 L .53788 .30191 L .535 .583 .85 r
F
.51585 .15411 m .5193 .29337 L .56267 .16314 L .512 .584 .864 r
F
1 0 0 r
.5009 .28655 m
.5193 .29337 L
s
.25 g
.5 Mabswid
.5009 .28655 m
.51585 .15411 L
s
.76276 .27236 m .6198 .36876 L .78923 .30401 L .629 .601 .803 r
F
.25 g
.80368 .33918 m
.8097 .33754 L
s
.76276 .27236 m .6061 .35254 L .6198 .36876 L .629 .601 .803 r
F
1 0 0 r
.003 w
.6198 .36876 m
.63155 .38609 L
s
.25 g
.5 Mabswid
.6198 .36876 m
.62411 .36711 L
s
.60872 .17683 m .53788 .30191 L .55625 .31217 L .556 .584 .837 r
F
.25 g
.5193 .29337 m
.52037 .29015 L
s
.56267 .16314 m .53788 .30191 L .60872 .17683 L .535 .583 .85 r
F
1 0 0 r
.003 w
.5193 .29337 m
.53788 .30191 L
s
.25 g
.5 Mabswid
.53788 .30191 m
.54476 .28977 L
s
.73074 .24324 m .6061 .35254 L .76276 .27236 L .612 .595 .809 r
F
.25 g
.78345 .30622 m
.78923 .30401 L
s
.80365 .33919 m
.80368 .33918 L
s
.73074 .24324 m .59072 .33759 L .6061 .35254 L .612 .595 .809 r
F
.25 g
.63612 .38484 m
.80365 .33919 L
s
1 0 0 r
.003 w
.6061 .35254 m
.6198 .36876 L
s
.25 g
.5 Mabswid
.6061 .35254 m
.6131 .34895 L
s
.65281 .19498 m .55625 .31217 L .57398 .3241 L .576 .586 .826 r
F
.25 g
.52037 .29015 m
.5212 .28768 L
s
.60872 .17683 m .55625 .31217 L .65281 .19498 L .556 .584 .837 r
F
.25 g
.5212 .28768 m
.56267 .16314 L
s
1 0 0 r
.003 w
.53788 .30191 m
.55625 .31217 L
s
.25 g
.5 Mabswid
.75913 .27422 m
.76276 .27236 L
s
.55625 .31217 m
.56565 .30076 L
s
.60624 .18121 m
.60872 .17683 L
s
.69381 .21727 m .59072 .33759 L .73074 .24324 L .594 .59 .817 r
F
.25 g
.72747 .24544 m
.73074 .24324 L
s
.72587 .24652 m
.72747 .24544 L
s
.75738 .27511 m
.75913 .27422 L
s
.78342 .30623 m
.78345 .30622 L
s
.69381 .21727 m .57398 .3241 L .59072 .33759 L .594 .59 .817 r
F
1 0 0 r
.003 w
.59072 .33759 m
.6061 .35254 L
s
.25 g
.5 Mabswid
.59072 .33759 m
.60033 .33112 L
s
.65281 .19498 m .57398 .3241 L .69381 .21727 L .576 .586 .826 r
F
.25 g
.57398 .3241 m
.58216 .3168 L
s
.68962 .221 m
.69381 .21727 L
s
.58216 .3168 m
.68962 .221 L
s
1 0 0 r
.003 w
.57398 .3241 m
.59072 .33759 L
s
.55625 .31217 m
.57398 .3241 L
s
.25 g
.5 Mabswid
.60033 .33112 m
.72587 .24652 L
s
.56565 .30076 m
.64944 .19907 L
s
.6131 .34895 m
.75735 .27513 L
s
.75735 .27513 m
.75738 .27511 L
s
.54476 .28977 m
.60624 .18121 L
s
.62411 .36711 m
.78342 .30623 L
s
.64944 .19907 m
.65281 .19498 L
s
0 g
.006 w
.8097 .33754 m
.82392 .37231 L
s
.23081 .68559 m .41649 .68365 L .41299 .68374 L 0 0 0 r
F
.23081 .68559 m .41299 .68374 L .22515 .67153 L F
.25 g
.5 Mabswid
.41233 .6837 m
.41649 .68365 L
s
0 g
.006 w
.23081 .68559 m
.24223 .69873 L
s
1 0 0 r
.003 w
.41649 .68365 m
.42238 .68318 L
s
0 g
.006 w
.78923 .30401 m
.8097 .33754 L
s
.22515 .67153 m .41299 .68374 L .41201 .68362 L 0 .544 .712 r
F
1 0 0 r
.003 w
.41299 .68374 m
.41649 .68365 L
s
.22515 .67153 m .41201 .68362 L .22569 .65696 L 0 .544 .712 r
F
0 g
.006 w
.22515 .67153 m
.23081 .68559 L
s
.25 g
.5 Mabswid
.22515 .67153 m
.41299 .68374 L
s
0 g
.006 w
.34465 .16296 m
.38283 .15452 L
s
.22569 .65696 m .41201 .68362 L .41364 .68348 L 0 .526 .741 r
F
1 0 0 r
.003 w
.41201 .68362 m
.41299 .68374 L
s
0 g
.006 w
.76276 .27236 m
.78923 .30401 L
s
.23275 .64236 m .41364 .68348 L .41792 .68353 L 0 .52 .783 r
F
.25 g
.5 Mabswid
.40719 .68293 m
.41201 .68362 L
s
.22569 .65696 m .41364 .68348 L .23275 .64236 L 0 .526 .741 r
F
.25 g
.22569 .65696 m
.40719 .68293 L
s
1 0 0 r
.003 w
.41201 .68362 m
.41364 .68348 L
s
0 g
.006 w
.22515 .67153 m
.22569 .65696 L
s
.38283 .15452 m
.42477 .14999 L
s
.73074 .24324 m
.76276 .27236 L
s
.24654 .62825 m .41792 .68353 L .42485 .68397 L 0 .525 .831 r
F
.25 g
.5 Mabswid
.409 .68243 m
.41364 .68348 L
s
.23275 .64236 m .41792 .68353 L .24654 .62825 L 0 .52 .783 r
F
1 0 0 r
.003 w
.41364 .68348 m
.41792 .68353 L
s
0 g
.006 w
.22569 .65696 m
.23275 .64236 L
s
.25 g
.5 Mabswid
.23275 .64236 m
.23887 .64375 L
s
0 g
.006 w
.42477 .14999 m
.46948 .14977 L
s
.69381 .21727 m
.73074 .24324 L
s
.65281 .19498 m
.69381 .21727 L
s
.46948 .14977 m
.51585 .15411 L
s
.2671 .61517 m .42485 .68397 L .43436 .68498 L .033 .534 .876 r
F
.25 g
.5 Mabswid
.41356 .68213 m
.41792 .68353 L
s
.40543 .68162 m
.409 .68243 L
s
.24654 .62825 m .42485 .68397 L .2671 .61517 L 0 .525 .831 r
F
.25 g
.23887 .64375 m
.40543 .68162 L
s
1 0 0 r
.003 w
.41792 .68353 m
.42485 .68397 L
s
.25 g
.5 Mabswid
.24654 .62825 m
.25239 .63013 L
s
0 g
.006 w
.60872 .17683 m
.65281 .19498 L
s
.51585 .15411 m
.56267 .16314 L
s
.56267 .16314 m
.60872 .17683 L
s
.2943 .60369 m .43436 .68498 L .44631 .68678 L .097 .545 .91 r
F
.25 g
.5 Mabswid
.42087 .68223 m
.42485 .68397 L
s
.41021 .68105 m
.41356 .68213 L
s
.2671 .61517 m .43436 .68498 L .2943 .60369 L .033 .534 .876 r
F
1 0 0 r
.003 w
.42485 .68397 m
.43436 .68498 L
s
.25 g
.5 Mabswid
.2671 .61517 m
.27256 .61755 L
s
0 g
.006 w
.23275 .64236 m
.24654 .62825 L
s
.3278 .5944 m .44631 .68678 L .46051 .68954 L .166 .554 .93 r
F
.25 g
.5 Mabswid
.43085 .68295 m
.43436 .68498 L
s
.41781 .6809 m
.42087 .68223 L
s
.40601 .67969 m
.41021 .68105 L
s
.2943 .60369 m .44631 .68678 L .3278 .5944 L .097 .545 .91 r
F
1 0 0 r
.003 w
.43436 .68498 m
.44631 .68678 L
s
.25 g
.5 Mabswid
.2943 .60369 m
.29758 .6056 L
s
.29758 .6056 m
.29918 .60653 L
s
.36704 .58782 m .46051 .68954 L .47672 .69343 L .234 .56 .935 r
F
.25 g
.44336 .68448 m
.44631 .68678 L
s
.42815 .68138 m
.43085 .68295 L
s
.41398 .67922 m
.41781 .6809 L
s
.40088 .67803 m
.40601 .67969 L
s
.3278 .5944 m .46051 .68954 L .36704 .58782 L .166 .554 .93 r
F
.25 g
.25239 .63013 m
.40088 .67803 L
s
1 0 0 r
.003 w
.44631 .68678 m
.46051 .68954 L
s
.25 g
.5 Mabswid
.3278 .5944 m
.3306 .59657 L
s
.3306 .59657 m
.33196 .59764 L
s
0 g
.006 w
.24654 .62825 m
.2671 .61517 L
s
.89673 .85636 m .69764 .88576 L .8956 .88937 L .692 .653 .807 r
F
.41122 .58445 m .47672 .69343 L .49462 .69858 L .298 .563 .93 r
F
.25 g
.5 Mabswid
.4582 .68703 m
.46051 .68954 L
s
.44109 .68272 m
.44336 .68448 L
s
.42477 .67942 m
.42815 .68138 L
s
.40928 .67717 m
.41398 .67922 L
s
.36704 .58782 m .47672 .69343 L .41122 .58445 L .234 .56 .935 r
F
.25 g
.27256 .61755 m
.40928 .67717 L
s
1 0 0 r
.003 w
.46051 .68954 m
.47672 .69343 L
s
.25 g
.5 Mabswid
.36704 .58782 m
.36925 .59023 L
s
.36925 .59023 m
.37033 .5914 L
s
.89673 .85636 m .69333 .86601 L .69764 .88576 L .692 .653 .807 r
F
.25 g
.69764 .88576 m
.8956 .88937 L
s
.45935 .5847 m .49462 .69858 L .51385 .70511 L .354 .566 .918 r
F
.25 g
.47511 .69074 m
.47672 .69343 L
s
.41122 .58445 m .49462 .69858 L .45935 .5847 L .298 .563 .93 r
F
1 0 0 r
.003 w
.47672 .69343 m
.49462 .69858 L
s
.25 g
.5 Mabswid
.41122 .58445 m
.41278 .58704 L
s
.41278 .58704 m
.41354 .58831 L
s
.37033 .5914 m
.4582 .68703 L
s
.33196 .59764 m
.44109 .68272 L
s
.29918 .60653 m
.42477 .67942 L
s
.89096 .82302 m .69333 .86601 L .89673 .85636 L .674 .639 .808 r
F
0 g
.006 w
.8956 .88937 m
.89673 .85636 L
s
.89096 .82302 m .68626 .84654 L .69333 .86601 L .674 .639 .808 r
F
1 0 0 r
.003 w
.69333 .86601 m
.69764 .88576 L
s
.25 g
.5 Mabswid
.69333 .86601 m
.89673 .85636 L
s
.51023 .58889 m .51385 .70511 L .53401 .71311 L .403 .568 .903 r
F
.45935 .5847 m .51385 .70511 L .51023 .58889 L .354 .566 .918 r
F
1 0 0 r
.003 w
.49462 .69858 m
.51385 .70511 L
s
.25 g
.5 Mabswid
.45935 .5847 m
.4606 .58875 L
s
.4606 .58875 m
.49462 .69858 L
s
.41354 .58831 m
.47511 .69074 L
s
.87812 .78987 m .68626 .84654 L .89096 .82302 L .655 .627 .81 r
F
.87812 .78987 m .67653 .82754 L .68626 .84654 L F
1 0 0 r
.003 w
.68626 .84654 m
.69333 .86601 L
s
0 g
.006 w
.89096 .82302 m
.89673 .85636 L
s
.2671 .61517 m
.2943 .60369 L
s
.85816 .75743 m .67653 .82754 L .87812 .78987 L .636 .616 .814 r
F
.25 g
.5 Mabswid
.88411 .82381 m
.89096 .82302 L
s
.85816 .75743 m .6643 .80921 L .67653 .82754 L .636 .616 .814 r
F
.25 g
.68626 .84654 m
.88411 .82381 L
s
1 0 0 r
.003 w
.67653 .82754 m
.68626 .84654 L
s
.25 g
.5 Mabswid
.67653 .82754 m
.68171 .82657 L
s
.56257 .59719 m .53401 .71311 L .55467 .72261 L .445 .571 .887 r
F
.51023 .58889 m .53401 .71311 L .56257 .59719 L .403 .568 .903 r
F
1 0 0 r
.003 w
.51385 .70511 m
.53401 .71311 L
s
.25 g
.5 Mabswid
.51023 .58889 m
.51385 .70511 L
s
.83128 .7263 m .6643 .80921 L .85816 .75743 L .615 .607 .819 r
F
.25 g
.8713 .79114 m
.87812 .78987 L
s
.83128 .7263 m .64979 .79175 L .6643 .80921 L .615 .607 .819 r
F
1 0 0 r
.003 w
.6643 .80921 m
.67653 .82754 L
s
.25 g
.5 Mabswid
.6643 .80921 m
.66924 .80789 L
s
.61495 .60965 m .55467 .72261 L .57537 .73363 L .482 .574 .871 r
F
.25 g
.53401 .71311 m
.53471 .71027 L
s
.56257 .59719 m .55467 .72261 L .61495 .60965 L .445 .571 .887 r
F
.25 g
.53471 .71027 m
.56257 .59719 L
s
1 0 0 r
.003 w
.53401 .71311 m
.55467 .72261 L
s
.79788 .69705 m .64979 .79175 L .83128 .7263 L .593 .598 .826 r
F
.25 g
.5 Mabswid
.85155 .7592 m
.85816 .75743 L
s
.87127 .79115 m
.8713 .79114 L
s
.79788 .69705 m .63328 .77531 L .64979 .79175 L .593 .598 .826 r
F
.25 g
.68171 .82657 m
.87127 .79115 L
s
1 0 0 r
.003 w
.64979 .79175 m
.6643 .80921 L
s
.25 g
.5 Mabswid
.64979 .79175 m
.65789 .78883 L
s
.66596 .62616 m .57537 .73363 L .59566 .74614 L .515 .579 .857 r
F
.25 g
.55467 .72261 m
.55615 .71984 L
s
.61495 .60965 m .57537 .73363 L .66596 .62616 L .482 .574 .871 r
F
1 0 0 r
.003 w
.55467 .72261 m
.57537 .73363 L
s
.25 g
.5 Mabswid
.57537 .73363 m
.58411 .72326 L
s
.61282 .61364 m
.61495 .60965 L
s
.75858 .67027 m .63328 .77531 L .79788 .69705 L .57 .591 .835 r
F
.25 g
.79403 .69888 m
.79788 .69705 L
s
.82504 .72855 m
.83128 .7263 L
s
.85152 .75921 m
.85155 .7592 L
s
.75858 .67027 m .61511 .76007 L .63328 .77531 L .57 .591 .835 r
F
1 0 0 r
.003 w
.63328 .77531 m
.64979 .79175 L
s
.25 g
.5 Mabswid
.63328 .77531 m
.64057 .77185 L
s
.71425 .64648 m .59566 .74614 L .61511 .76007 L .544 .584 .845 r
F
.25 g
.55615 .71984 m
.55728 .71771 L
s
.66596 .62616 m .59566 .74614 L .71425 .64648 L .515 .579 .857 r
F
.25 g
.55728 .71771 m
.61282 .61364 L
s
1 0 0 r
.003 w
.57537 .73363 m
.59566 .74614 L
s
.25 g
.5 Mabswid
.79214 .69978 m
.79403 .69888 L
s
.59566 .74614 m
.60368 .7394 L
s
.66277 .62995 m
.66596 .62616 L
s
.71425 .64648 m .61511 .76007 L .75858 .67027 L .544 .584 .845 r
F
.25 g
.61511 .76007 m
.62486 .75396 L
s
.75355 .67342 m
.75858 .67027 L
s
.62486 .75396 m
.75355 .67342 L
s
1 0 0 r
.003 w
.59566 .74614 m
.61511 .76007 L
s
.25 g
.5 Mabswid
.71007 .65 m
.71425 .64648 L
s
.60368 .7394 m
.71007 .65 L
s
.64057 .77185 m
.79214 .69978 L
s
.58411 .72326 m
.66277 .62995 L
s
.65789 .78883 m
.82501 .72856 L
s
.82501 .72856 m
.82504 .72855 L
s
.66924 .80789 m
.85152 .75921 L
s
1 0 0 r
.003 w
.61511 .76007 m
.63328 .77531 L
s
0 g
.006 w
.87812 .78987 m
.89096 .82302 L
s
.2943 .60369 m
.3278 .5944 L
s
.85816 .75743 m
.87812 .78987 L
s
.3278 .5944 m
.36704 .58782 L
s
.83128 .7263 m
.85816 .75743 L
s
.36704 .58782 m
.41122 .58445 L
s
.79788 .69705 m
.83128 .7263 L
s
.41122 .58445 m
.45935 .5847 L
s
.75858 .67027 m
.79788 .69705 L
s
.45935 .5847 m
.51023 .58889 L
s
.71425 .64648 m
.75858 .67027 L
s
.51023 .58889 m
.56257 .59719 L
s
.66596 .62616 m
.71425 .64648 L
s
.56257 .59719 m
.61495 .60965 L
s
.61495 .60965 m
.66596 .62616 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000181000`40O003h00Oogoo2Woo002`Ool2
001GOol00:ioo`800003Ool0000005Ioo`00Zgoo0`000goo0P00EWoo002YOol20006Ool00`00Ool0
001EOol00:Moo`8000Qoo`03001oo`0005Eoo`00Y7oo0`002Woo00@007ooOol005Aoo`00XWoo0P00
3Goo00D007ooOomoo`0005=oo`00Wgoo0`003goo00D007ooOomoo`0005=oo`00WGoo0P004Woo00<0
07ooOol00Woo00<007ooOol0D7oo002KOol2000EOol00`00Oomoo`02Ool00`00Oomoo`1?Ool009Qo
o`<001Moo`03001oogoo009oo`03001oogoo04moo`00UWoo0P006Woo00<007ooOol00goo00<007oo
Ool0CWoo002COol3000LOol00`00Oomoo`03Ool00`00Oomoo`1>Ool0095oo`8001moo`03001oogoo
00Aoo`03001oogoo04eoo`00Sgoo0P008Goo00<007ooOol01Goo00<007ooOol0C7oo002<Ool3000S
Ool00`00Oomoo`05Ool00`00Oomoo`1<Ool008Yoo`8002Ioo`03001oogoo00Ioo`03001oogoo04]o
o`00Qgoo0`00:7oo00<007ooOol01goo00<007ooOol0BWoo0025Ool2000[Ool00`00Oomoo`07Ool0
0`00Oomoo`1:Ool008=oo`8002eoo`03001oogoo00Qoo`03001oogoo04Uoo`00P7oo0`00;goo00<0
07ooOol027oo00<007ooOol0BGoo001nOol2000bOol00`00Oomoo`09Ool00`00Oomoo`18Ool007]o
o`<003Aoo`03001oogoo00Yoo`03001oogoo04Moo`00NGoo0P00=goo00<007ooOol02Woo00<007oo
Ool0Agoo001gOol2000iOol00`00Oomoo`0;Ool00`00Oomoo`16Ool007Aoo`<003]oo`03001oogoo
00aoo`03001oogoo04Eoo`00LWoo0P00?goo00<007ooOol02goo00<007ooOol0AGoo001_Ool30011
Ool00`00Oomoo`0<Ool00`00Oomoo`14Ool006eoo`8004Aoo`03001oogoo00aoo`03001oogoo04Ao
o`00Jgoo0P00AWoo00<007ooOol03Goo00<007ooOol0@goo001XOol30018Ool00`00Oomoo`0>Ool0
0`00Oomoo`12Ool006Ioo`8004]oo`03001oogoo00ioo`03001oogoo049oo`00Hgoo0`00CGoo00<0
07ooOol03goo00<007ooOol0@Goo001QOol2001@Ool00`00Oomoo`0@Ool00`00Oomoo`10Ool005io
o`<0059oo`03001oogoo011oo`03001oogoo041oo`00G7oo0P00EGoo00<007ooOol04Goo00<007oo
Ool0?goo001JOol2001GOol00`00Oomoo`0AOol00`00Oomoo`0oOol005Moo`<005Uoo`03001oogoo
019oo`03001oogoo03ioo`00EGoo0P00G7oo00<007ooOol04goo00<007ooOol0?Goo001BOol3000F
OolG000aOol00`00Oomoo`0COol00`00Oomoo`0mOol0051oo`80019oo`L0000G=U`fOC9L=WdfG1cW
=U/jG3IK>U`fFcYL=U/jG3IK>U`fFacW>U/nG3YK?U/jF`08000YOol00`00Oomoo`0DOol00`00Oomo
o`0lOol004ioo`80015oo`<0008bO@037>LfG3IL00LfG0037>LjG3YK00<jG00D>U/jG3YL>U`jFcYL
7>LnFcYK?U/jFciK>U/nFcYK?U/jFciK7>M2F`@002Eoo`03001oogoo01Eoo`03001oogoo03]oo`00
Bgoo0`003goo100002dbO39m<W`bOC9l7>LbG3Im=U`fOC9L=WdfG3Im<U`fOAcW>U`fFcYL=U/jG3IK
>U`fFcYL=U/LicYK?U/jFciL>U/nFcYK?U`jFciK>U/LiciJ@U/nFT9K?UX010008Goo00<007ooOol0
5Goo00<007ooOol0>goo0019Ool2000@Ool2000:<Wd00acW=U`fG007=U`011cW>U`jG3YK0cYL014j
FcYL>U`jG1cW?U/jFciK>U/nFcYK?U/jFciK>U/nFacW008nF`07@U/nFSiK?U]2FciJ?U/010007Woo
00<007ooOol05Goo00<007ooOol0>Woo0016Ool3000COol0>QcW<W`bOC9l<WdbO39m<W`bOC9l<WdL
icIm<U`fOCIL=WdbG3Im=U`fOAcW>U`fFcYL=U/jG3IK>U`fFcYL=U/LicYK?U`jFciK>U/nG3YK?U/j
FciL>U/LiciJ@U/nFT9K?UY2FciJ@U/nFT9K?UXLid9J10006Woo00<007ooOol05Goo00<007ooOol0
>Woo0014Ool2000GOol00acW<WdbO@08<Wd00acW=U`fG007=U`01AcW>U`jG3YL>U/00cYL014jFcYL
>U`LicYK?U/jFciK>U/nFcYK?U/jFacW?U]2FciJ008nF`07@U/nFSiK?U]2FciJ7>L01T9J10005Woo
00<007ooOol05Woo00<007ooOol0>Goo0012Ool2000IOol0>1cW<WdbO39m<W`bOC9l<WdbO39m<W`L
icIL=WdbG3Im=U`fOC9L=WdfG1cW=U/jG3IK>U`fFcYL=U/jG3IK>U`LiciK>U/nG3YK?U/jFciL>U/n
FacW@U/nFT9K?UY2FciJ@U/nFT9K?UY2FacW@U/3@UX01T9K@UY2FT9J@U]2FP@0019oo`03001oogoo
01Moo`03001oogoo03Qoo`00?goo0`0077oo00<Lic9m<Wd0239m00<LicIL=U`01SIL00<LicYL>U/0
0cYL014jFcYL>U`jG3YK7>LjFciK>U/nFcYK?U/jFciK>U/LiciJ008nF`06@U/nFSiK?U]2FciJ0SiK
00<Lid9J@UX02D9J00=6FQcWAUX00P0047oo00<007ooOol05goo00<007ooOol0>7oo000mOol2000P
Ool0=1cW<WdbO39m<W`bOC9l<WdbO39m7>LfOCIL=WdbG3Im=U`fOC9L=WdLicYL=U/jG3IK>U`fFcYL
=U/jG1cW?U`jFciK>U/nG3YK?U/jFciL7>M2FciJ@U/nFT9K?UY2FciJ@U/nFQcW0d9J00E2Fd9J@UY2
FT9K00=2FP06@U/LidIJ@UU6FT9I0P003Woo00<007ooOol067oo00<007ooOol0=goo000jOol3000S
Ool00acW<WdbO@07<Wd00acW=U`fG006=U`011cW>U`jG3YK0cYL014jFcYL>U`LicYK?U/jFciK>U/n
FcYK?U/jFacW?U]2FciJ008nF`06@U/nFSiK?U]2FacW2d9J00=6FQcWAUX01DIJ0`002goo00<007oo
Ool06Goo00<007ooOol0=Woo000hOol2000WOol0=1cW<WdbO39m<W`bOC9l<WdbO1cW<U`fOCIL=Wdb
G3Im=U`fOAcW>U`fFcYL=U/jG3IK>U`fFcYL7>LnFcYK?U`jFciK>U/nG3YK?U/Lid9K?UY2FciJ@U/n
FT9K?UY2FciJ7>M2FT9K0d9J0152Fd9J@UY2FT9K@UXLid9IAUY2FDIJ@UU6FT9IAUY2FDIJ008000Uo
o`03001oogoo01Uoo`03001oogoo03Ioo`00=Woo0P00:Woo00<Lic9m<Wd01S9m00<LicIL=U`01SIL
00DLicYL>U`jG3YK00<jG00=>U/LicYK?U/jFciK>U/nFcYK?U/jFacW?UX00SiK00M2FciJ?U/nFd9K
?UXLi`0;@UX00dIJ7>M6FP0;AUX20007Ool00`00Oomoo`0JOol00`00Oomoo`0eOol003=oo`<002ao
o`0a7>LbO39m<W`bOC9l<WdbO39m7>LfOC9L=WdfG3Im<U`fOCIL7>LfFcYL=U/jG3IK>U`fFcYL7>Ln
G3YK?U/jFciL>U/nFcYK?U`Lid9K?UY2FciJ@U/nFT9K?UY2FacW@U/00d9J00E2Fd9J@UY2FT9K0092
FP0@7>M6FT9IAUY2FDIJ@UU6FT9IAUY2FDIJ@UU6FQcWBUX20005Ool00`00Oomoo`0JOol00`00Oomo
o`0eOol0035oo`80031oo`037>LbOC9m00HbO@037>LfG3IL00DfG0037>LjG3YK00<jG00A>U/jG3YL
7>LjFciK>U/nFcYK?U/jFciK>U/LiciK@U/nFP02?U/01D9K?UXnFciK7>L02T9J00<LidIJAUX02dIJ
00DLidIIAUU:FTII008000=oo`03001oogoo01]oo`03001oogoo03Aoo`00;Woo0`00<goo02dLic9l
<WdbO39m<W`bOC9l7>LfG3Im<U`fOCIL=WdbG3Im7>LjG3IK>U`fFcYL=U/jG1cW?U/jFciL>U/nFcYK
?U`jFacW?UY2FciJ@U/nFT9K?UY2FciJ7>L00d9J00E2Fd9J@UY2FT9K00=2FP0E7>M2FDIJ@UU6FT9I
AUY2FDIJ@UU6FT9IAUXLidYJAUU:FTIIBUY6FDYJ00800003Ool007oo01eoo`03001oogoo03=oo`00
;7oo0P00=goo00<Lic9m<Wd01C9m00<LicIL=U`01CIL00@LicYL>U`jF`<jG00=>U/LicYK?U/jFciK
>U/nFcYK?U/Lid9K?UX00SiK00I2FciJ?U/nFd9K7>L:@UX00acWAUY6FP0;AUX00acWAUU:FP03AUT0
14YJAUU6FDII0P007Woo00<007ooOol0<goo000ZOol2000jOol0;AcW<W`bOC9l<WdbO39m<W`LicIL
=WdbG3Im=U`fOAcW>U`fFcYL=U/jG3IK>U`LiciL>U/nFcYK?U`jFciK>U/LiciJ@U/nFT9K?UY2FciJ
@U/nFQcW@UY2F`03@UX07T9K@UY2FT9J@U/LidIJ@UU6FT9IAUY2FDIJ@UU6FT9IAUY2FAcWAUU:FTII
BUY6FDYJAUU:FTIIBUY6F@<001eoo`03001oogoo039oo`009goo0`00?Goo00<Lic9m<Wd0139m00<L
icIL=U`01CIL00DLicYL>U`jG3YK00<jG0097>LnFcYK?U/jFciK>U/nFacW008nF`07@U/nFSiK?U]2
FciJ7>L02T9J00<LidIJAUX02TIJ00<LidIIBUX00dII00E:FTIIAUU6FDYJ0096F@04001:FTII000M
Ool00`00Oomoo`0aOol002Eoo`80041oo`0Z7>LbOC9l<WdbO39m<W`bOAcW=WdfG3Im<U`fOCIL7>Lf
FcYL=U/jG3IK>U`fFacW>U/nG3YK?U/jFciL>U/LiciJ@U/nFT9K?UY2FciJ@U/Lid9K0d9J02A2Fd9J
@UY2FT9K@UTLid9IAUY2FDIJ@UU6FT9IAUY2FDIJ@UTLidIIBUY6FDYJAUU:FTIIBUY6FDYJAUU:FTII
0016FAcWBUT2000KOol00`00Oomoo`0aOol0029oo`<004=oo`037>LbOC9m00@bO@037>LfG3IL00@f
G0037>LjG3YK00<jG00=>U/jG1cW?U/jFciK>U/nFcYK?U/Lid9K?UX00SiK00E2FciJ?U/nFacW00U2
FP037>M6FTIJ00U6FP037>M6FDYJ00=6F@05BUY6FDIIAUU:FP03AUT00dYJ000Li`04BUT00`00Oomo
o`0IOol00`00Oomoo`0`Ool0021oo`8004Moo`0V7>LbOC9l<WdbO39m<W`Lic9L=WdfG3Im<U`fOAcW
>U`fFcYL=U/jG3IK7>LjFciK>U/nG3YK?U/jFacW?UY2FciJ@U/nFT9K?UXLi`=2FP0U@U]2FT9J@UY2
Fd9J7>M2FDIJ@UU6FT9IAUY2FDIJ@UU6FT9I7>M6FDYJAUU:FTIIBUY6FDYJAUU:FTIIBUY6FDYJAUTL
i`00BUX00dYI00=:FP00Ool06Goo00<007ooOol0<7oo000NOol2001:Ool00acW<WdbO@03<Wd00acW
=U`fG004=U`011cW>U`jG3YK0cYL00TLiciK>U/nFcYK?U/jFciK7>L00SiK00I2FciJ?U/nFd9K7>L9
@UX00acWAUY6FP09AUX00acWBUY6F@02AUT01DYJAUU6FDIIBUX00dII00E:FQcW7>M:F@0000I:F@80
01Uoo`03001oogoo02moo`006goo0`00CGoo02HLic9m<W`bOC9l<WdLicIm<U`fOCIL=WdLicYL=U/j
G3IK>U`fFacW>U/nG3YK?U/jFciL7>M2FciJ@U/nFT9K?UY2FciJ7>M2FT9K0d9J01i2Fd9J@UXLidIJ
@UU6FT9IAUY2FDIJ@UU6FT9IAUXLidYJAUU:FTIIBUY6FDYJAUU:FTIIBUY6FDYJ7>L2BUT01DYJ001:
FDYIBUX00dYI00=:FTYI00006Goo00<007ooOol0;Woo000IOol2001@Ool00acW<WdbO@03<Wd00acW
=U`fG004=U`04AcW>U`jG3YL>U/jG1cW?U/jFciK>U/nFcYK7>LnFd9K?UX00SiK00=2FciJ7>L02D9J
00<LidIJAUX024IJ00<LidYJAUT00TII00E:FTIIAUU6FDYJ00=6F@03BUXLidYI00=:F@03001:FDYI
00M:F@8001Moo`03001oogoo02ioo`005goo0P00Dgoo02<Lic9l<WdbO39m<W`LicIL=WdbG3Im=U`L
icIK>U`fFcYL=U/LicYK?U/jFciL>U/nFacW@U/nFT9K?UY2FciJ@U/Lid9K00=2FP0N@U]2FT9J@UXL
id9IAUY2FDIJ@UU6FT9IAUY2FDIJ7>M:FTIIBUY6FDYJAUU:FTIIBUY6FDYJAUU:FQcW0TYI00E:FTYI
BUT004YJ00=:F@08BUY:FDYIBUU:FTYI7>L001Moo`03001oogoo02eoo`005goo0P00E7oo00<Lic9m
<Wd00S9m00<LicIL=U`00cIL00<LicYL>U/00cYL00TLiciK>U/nFcYK?U/jFacW?UX00SiK00E2FciJ
?U/nFacW00M2FP037>M6FTIJ00Q6FP037>M:FTII0096F@05BUY6FDIIAUU:FP03AUT00dYJ7>M:F@05
BUT00`00BUU:F@07BUT011cWBUU>F@005goo00<007ooOol0;7oo000GOol00`00Ool0001DOol07acW
<W`bOC9l<WdLicIm=U`fOC9L=WdLicYL=U/jG3IK7>LjFciL>U/nFcYK?U`Lid9K?UY2FciJ@U/nFQcW
00=2FP0N@U]2FT9J@UY2FacWAUY2FDIJ@UU6FT9IAUY2FDIJ@UTLidIIBUY6FDYJAUU:FTIIBUY6FDYJ
AUU:FQcW0TYI00I:FTYIBUU:FDYJ0002BUT01DYJBUU:FDYIBUX00QcW00E:F4iIBUU>F@0001Ioo`03
001oogoo02aoo`005goo00@007ooOol005Aoo`057>LbOC9m<WdLi`05=U`041cW>U`jG3YK>U`LiciK
>U/nFcYK?U/jFacW?U]2FciJ0SiK00=2FacW@UX01T9J00<LidIJAUX024IJ00DLidIIAUU6FDYJ00=6
F@04BUY6FDIIAUT27>L8BUT00`00BUU:F@04BUT02AcWCUU:FDiIBUU>FDYICUT0000FOol00`00Oomo
o`0[Ool001Ioo`03001oogoo009oo`03001oogoo059oo`0O7>LbO39m<W`Lic9L=WdfG3Im7>LjG3IK
>U`fFacW>U/nFcYK?U`jFciK7>M2FciJ@U/nFT9K?UXLid9J@U/00d9J01U2Fd9J7>M2FDIJ@UU6FT9I
AUY2FDIJ@UTLidIIBUY6FDYJAUU:FTIIBUY6FDYJAUTLi`03BUT01DYJBUU:FDYIBUX00TYI00<004YJ
BUT00TYI0QcW00Y>FDYHCUU:FDiIBUQ>FDYICUT001Eoo`03001oogoo02]oo`005Woo00<007ooOol0
0goo00<007ooOol0DGoo00DLic9m<WdbOAcW00DfG00=7>LjG3YL>U`jFacW>U/nFcYK?U/jFacW?UX0
0SiK00=2FciJ7>L01d9J00<LidIJAUX01dIJ00DLidIIAUU6FDYJ00=6F@05BUY6FDIIAUTLi`0;BUT0
4P00BUU:FDYI7>M:FDiIBUU>FDYICUU:FDiIBUU>FDYICUT001Eoo`03001oogoo02Yoo`005Woo00<0
07ooOol017oo00<007ooOol0DGoo01`Lic9m<W`bOAcW=WdbG3Im=U`LicIK>U`fFcYL7>LnG3YK?U/j
FciL7>M2FciJ@U/nFT9K7>M2F`=2FP0I@U]2FT9J7>M6FT9IAUY2FDIJ@UU6FT9I7>M6FDYJAUU:FTII
BUY6FDYJAUU:FTII7>L00dYI00E:FTYIBUU:FDYJ00=:F@03BUX004YI008Li`0?BUU>FDYHCUU:FDiI
BUQ>FDYICUU:F4iIBUU>F@0001Eoo`03001oogoo02Uoo`005Woo00<007ooOol01Goo00<007ooOol0
DGoo00@Lic9m<WdLi`@fG0037>LjG3YK008jG0067>LjFciK>U/nFacW0SiK00E2FciJ?U/nFacW00I2
FP037>M6FTIJ00M6FP047>M6FDIIBUX3AUT01DYJAUU6FDII7>L03DYI01@001cWCUU:FDiIBUU>FDYI
CUU:FDiIBUU>FDYICUU:FDiIBUU>F@0057oo00<007ooOol0:Goo000FOol00`00Oomoo`06Ool00`00
Oomoo`1@Ool01AcWO01l07`07>L00W`0018bG3Im7>LjG3IK>U`LiciK>U/nG3YK7>LnFT9K?UY2FciJ
7>L3@UX06D9K@UY2FQcWAUY2FDIJ@UU6FT9IAUY2FDIJ7>M:FTIIBUY6FDYJAUU:FTIIBUY6FAcW00=:
F@05BUY:FDYIBUU:FP03BUT064YJBUTLi`00CUU:FDiIBUQ>FDYICUU:F4iIBUU>FDYHCUU:FDiIBUQ>
FDYI7>L001Aoo`03001oogoo02Qoo`005Woo00<007ooOol01goo00<007ooOol0EWoo0W`000`Lig`0
>U`jFacW>U/nFcYK?U/Lid9K?UX2?U/00d9K7>M2FP05@UX00acWAUY6FP06AUX011cWAUU6FDYJ0dII
00E:FTIIAUU6FAcW00e:F@0C7>M:F@00BUU>FDYICUU:FDiIBUU>FDYICUU:FDiIBUU>FDYICUT00QcW
0TiI00<007ooOol04Woo00<007ooOol09goo000EOol00`00Oomoo`09Ool00`00Oomoo`1IOol2O000
3QcWO01l03iK>U/LiciJ@U/nFT9K?UXLid9J@U/3@UX04acW@UU6FT9IAUY2FDIJ@UU6FQcWBUY6FDYJ
AUU:FTIIBUY6FDYJ008Li`=:F@05BUY:FDYIBUU:FP03BUT054YJ7>LLidYHCUT004iIBUQ>FDYICUU:
F4iIBUU>FDYHCUU:FDiIBUP27>L01TiiCUQBNDiHCWT001=oo`03001oogoo02Moo`005Goo00<007oo
Ool02Woo00<007ooOol0GGoo0W`000HLig`0?U]2FciJ7>L6@UX00acWAUY6FP05AUX011cWAUU6FDYJ
0dII00A:FTIIAUTLi`e:F@0B7>M>FDYICUU:F@00BUU>FDYICUU:FDiIBUU>FDYICUU:FDiI0QcW00E>
F4iICUU>FDiH00=>F@03001oogoo015oo`03001oogoo02Ioo`005Goo00<007ooOol02goo00<007oo
Ool0H7oo0W`000=2FacW@U/00d9J01E2FacWAUY2FDIJ@UU6FT9IAUXLidYJAUU:FTIIBUY6FDYJAUU:
FQcWBUX00dYI00E:FTYIBUU:FDYJ00=:F@8Li`0@CUU:F4iIBUU>F@00CUU:FDiIBUQ>FDYICUU:F4iI
BUT27>L0359iCUQ>NDiHDWU>F4iiCUQBNDiHCWT0019oo`03001oogoo02Ioo`005Goo00<007ooOol0
37oo00<007ooOol0HGoo0g`0149J00<LidIJAUX01DIJ00<LidIIBUX00dII00A:FTIIAUTLi`a:F@0A
7>M:FDiIBUU>FDYICUU:FDiI001>FDYICUU:FDiIBUU>F@027>L2CUT01DiHCUU>FDiICUP00diI00A>
F4iICUT001=oo`03001oogoo02Eoo`005Goo00<007ooOol03Goo00<007ooOol0Hgoo0W`001A2FQcW
@UU6FT9IAUY2FDIJ@UTLidIIBUY6FDYJAUU:FTIIBUXLidYJ0dYI00E:FTYIBUU:FDYJ009:F@8Li`0?
BUU>FDYHCUU:FDiIBUQ>FDYI001:F4iIBUU>FDYH008Li`0ACWU>F59iCUQ>NDiHDWU>F4iiCUQBNDiH
CWU>F59iCUP0000COol00`00Oomoo`0TOol001Eoo`03001oogoo00ioo`03001oogoo06Aoo`9l00I6
FP037>M6FDYJ00=6F@04BUY6FDII7>L;BUT041cWCUU:FDiIBUU>FDYICUU:FDiIBUU>F@00CUU:FDiI
0QcW00E>F4iICUU>FDiH00=>F@05CUQ>FDiICUU>F003CUT014iHCUU>F@004Woo00<007ooOol097oo
000EOol00`00Oomoo`0?Ool00`00Oomoo`1UOol2O0002d9IAUY2FAcWAUU:FTIIBUY6FDYJAUT00QcW
00E:FTYIBUU:FDYJ00=:F@0BBUY:FAcW7>M>FDYICUU:F4iIBUU>FDYHCUU:FDiIBUP004YI0QcW01AB
NDiHCWU>F59iCUQ>NDiHDWU>F4iiCUQBNDiHCWU>F59iCUQ>NDiH0QcW00<007ooOol047oo00<007oo
Ool08goo000DOol00`00Oomoo`0AOol00`00Oomoo`1VOol2O0000dIJ7>M:FP03AUT00dYJAUTLi`0;
BUT04AcWBUU>FDYICUU:FDiIBUU>FDYICUU:FDiIBUU>F@007>L00TiI00E>F4iICUU>FDiH00=>F@05
CUQ>FDiICUU>F003CUT024iHCUTLiacWCWQBNE9h000BOol00`00Oomoo`0ROol001Aoo`03001oogoo
019oo`03001oogoo06Moo`0:O01:FTIIBUY6FDYJAUTLidYIBUX3BUT01DYJBUU:FDYIBUX00QcW029:
F4iIBUU>FDYHCUU:FDiIBUQ>FDYICUU:F4iI7>L004iHDWU>F4iiCUQBNDiHCWU>F59iCUQ>NDiHDWU>
F4iiCUQBN@<Li`06DWU>F59iCUQBN@004Woo00<007ooOol08Woo000DOol00`00Oomoo`0COol00`00
Oomoo`1WOol01W`0AUU6FDYJAUTLi`Y:F@0?7>M>FDYICUU:FDiIBUU>FDYICUU:FDiIBUU>FDYI008L
i`04CUT004iICUP3CUT01DiHCUU>FDiICUP00diI00=>F4iICUT00QcW00YBNE9hDWU>N59iDWQBNDih
DWT0019oo`03001oogoo025oo`0057oo00<007ooOol057oo00<007ooOol0Igoo0W`000A6FAcWBUU:
FP=:F@04BUY:FDYIBUT27>L03DiIBUQ>FDYICUU:F4iIBUU>FDYHCUU:FDiI008Li`0ACUQ>NDiH001>
F4iiCUQBNDiHCWU>F59iCUQ>NDiHDWU>F0037>L03DiHDWU>F59iCUQBNDiHDWU>F59iCUQBN@00015o
o`03001oogoo025oo`0057oo00<007ooOol05Goo00<007ooOol0J7oo00=l04YIBUT01dYI00hLidYI
CUU:FDiIBUU>FDYICUU:FDiIBUU>FDYI0QcW00=>FDiHCUT00TiI00D004iICUU>FDiH00=>F@04CUQ>
FDiICUT27>L0459hDWU>N59iDWQBNDihDWUBN59iCWQBNE9hDWU>N0004Woo00<007ooOol087oo000D
Ool00`00Oomoo`0FOol00`00Oomoo`1XOol01G`0BUU:FDYIBUX00TYI0QcW00a:FDiIBUQ>FDYICUU:
F4iIBUU>FDYHCUT27>L044iHDWU>F4iiCUQBNDiH001>F59iCUQ>NDiHDWU>F4ii0acW01=BNDiHDWU>
F59iCUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUP0000BOol00`00Oomoo`0OOol001=oo`03001oogoo
01Moo`03001oogoo06Uoo`9l00=:F@0=7>M>FDYICUU:FDiIBUU>FDYICUU:FDiIBUT00QcW0diI00U>
F4iICUU>FDiHCUT004iICUP00diI01Y>F1cW7>MBNDihDWUBN59iCWQBNE9hDWU>N59iDWQBNDihDWUB
N59iCWQBNE9hDWU>N0004Goo00<007ooOol07goo000COol00`00Oomoo`0HOol00`00Oomoo`1ZOol0
3W`0BUTLidiIBUU>FDYHCUU:FDiIBUQ>FDYICUT27>L03diHCWU>F59iCUQ>NDiHDWU>F4iiCUP004iH
CWU>F0037>L06DiHDWU>F59iCUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUQBN@00
019oo`03001oogoo01ioo`004goo00<007ooOol06Goo00<007ooOol0JWoo00]l04iIBUU>FDYICUU:
FDiIBUU>FDYI008Li`03CUU>F4iI009>F@05CUQ>FDiICUU>F003CUT07@007>LLiacWCWQBNE9hDWU>
N59iDWQBNDihDWUBN59iCWQBNE9hDWU>N59iDWQBNDihDWUBN59iCWP00acW00<007ooOol047oo00<0
07ooOol07Goo000COol00`00Oomoo`0JOol00`00Oomoo`1ZOol027`0CUU:F4iIBUU>FDYHCUT27>L0
:4iHDWU>F4iiCUQBNDiHCWU>F59iCUQ>NDiHDWTLi`00CUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUQB
NDiHDWU>F59iCUQBNDiHDWU>F59i11cW00A>F5IiDWP0019oo`03001oogoo01eoo`004goo00<007oo
Ool06goo00<007ooOol0JWoo00El04iIBUU>FDYI008Li`=>F@05CUQ>FDiICUU>F003CUT00diHCUTL
i`027>L05U9i001BNDihDWUBN59iCWQBNE9hDWU>N59iDWQBNDihDWUBN59iCWQBNE9h11cW00EBNE9h
DWQBN59i00=BN003001oogoo011oo`03001oogoo01aoo`004goo00<007ooOol077oo00<007ooOol0
JWoo015l04iIBUPLidiHCWU>F59iCUQ>NDiHDWU>F4iiCUQBNDiH008Li`0FDWU>F59iCUP004iHDWU>
F59iCUQBNDiHDWU>F59iCUQBNDiHDWU>F59iCUP37>L03DiHDWUBN5IiDWQBNE9hEWUBN59iDWQFN@00
019oo`03001oogoo01aoo`004Woo00<007ooOol07Woo00<007ooOol0JWoo00=l01cWCUP00diI00E>
F4iICUU>FDiH009>F@<Li`0DDWQBNDihDWUBN59i001BNE9hDWU>N59iDWQBNDihDWUBN59iCWQBN@@L
i`03DWQBNE9h009BN005DWUBN59hDWQBN@03DWP00e9iDWP0000COol00`00Oomoo`0KOol0019oo`03
001oogoo01moo`03001oogoo06Yoo`0:O01>NDiHDWU>F4iiCUQBNDiHCWT27>L04diHDWU>F59iCUQB
NDiHDWU>F000CUQBNDiHDWU>F59iCUQBNDiH00@Li`0EDWUBN59iDWQFNE9hDWUBN5IiDWQBNE9hEWUB
N59iDWQFNE9hDWUBN00001=oo`03001oogoo01Yoo`004Woo00<007ooOol087oo00<007ooOol0JWoo
00=l04iICUP00diI0acW019BNDihDWUBN59iCWQBNE9hDWU>N59iDWP004ihDWUBN59iCWP37>L014ih
DWQBN59i0e9h00EBNE9hDWQBN59i00=BN005DWUBN59hDWQBN@03DWP00e9i001oo`0BOol00`00Oomo
o`0JOol0019oo`03001oogoo025oo`03001oogoo06Uoo`04O01>F4iiCUP27>L04E9iCUQBNDiHDWU>
F59iCUQBNDiHDWU>F59iCUQBN@00DWT011cW01aBN5IiDWQBNE9hEWUBN59iDWQFNE9hDWUBN5IiDWQB
NE9hEWUBN59iDWQFNE9hDWUBN5IiDWP001Aoo`03001oogoo01Uoo`004Woo00<007ooOol08Woo00<0
07ooOol0JGoo019l01cW7>M>N59iDWQBNDihDWUBN59iCWQBNE9hDWU>N59iDWP27>L00`007>MBN@03
DWP01E9iDWQBN59hDWT00e9h00EBNE9hDWQBN59i00=BN005DWUBN59hDWQBN@03DWP01E9iDWQBN59h
000057oo00<007ooOol067oo000BOol00`00Oomoo`0SOol00`00Oomoo`1YOol03W`0CUQBNDiHDWU>
F59iCUQBNDiHDWU>F59iCUP37>L08DiHDWT005IiDWQBNE9hEWUBN59iDWQFNE9hDWUBN5IiDWQBNE9h
EWUBN59iDWQFNE9hDWUBN5IiDWQBNE9hEWUBN0037>L00`00Oomoo`0BOol00`00Oomoo`0HOol0019o
o`03001oogoo02Aoo`03001oogoo06Qoo`0:O01BNE9hDWU>N59iDWQBNDihDWT47>L00e9hDWUBN002
DWP01@00DWQBN59hDWT00e9h00EBNE9hDWQBN59i00=BN005DWUBN59hDWQBN@03DWP00e9i7>LLi`04
7>L2EWP00e9h001oo`0DOol00`00Oomoo`0GOol0015oo`03001oogoo02Ioo`03001oogoo06Qoo`05
O01BNDiHDWU>F0047>L0759iDWQBNE9hEWUBN59iDWQFN@00DWUBN5IiDWQBNE9hEWUBN59iDWQFNE9h
DWUBN5IiDWQBNE9h1QcW00YFNE9hEWUBN5IiDWQFNE9hEWT001Eoo`03001oogoo01Moo`004Goo00<0
07ooOol09goo00<007ooOol0Igoo00=l04ihDWT00QcW00A>N59hDWQBN@=BN009DWUBN59hDWQBNE9h
001BN59i00=BN005DWUBN59hDWQBN@02DWP67>L01E9hEWQFN5IhDWP00eIh00EBN5IhEWQFN59h00=F
N003001oogoo01=oo`03001oogoo01Ioo`004Goo00<007ooOol0:7oo00<007ooOol0Igoo01Ql01cW
EWUBN59iDWQFNE9hDWUBN5IiDWQBNE9hEWUBN59i001FNE9hDWUBN5IiDWP67>L05eIiDWQFNE9hEWUB
N5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWQFNE9h00005Woo00<007ooOol05Goo000AOol00`00
Oomoo`0YOol00`00Oomoo`1WOol01G`0DWQBN59hDWT00e9h00EBNE9hDWQBN59i00=BN003000LiacW
00@Li`9FN005DWQFN5IhEWQBN003EWP01E9hEWQFN5IhDWP00eIh00EBN5IhEWQFN59h00=FN003DWQF
N00001Ioo`03001oogoo01Eoo`004Goo00<007ooOol0:Woo00<007ooOol0Igoo00Yl059hEWUBN59i
DWQFNE9hDWUBN0DLi`0T001FNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUB
N5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN0005goo00<007ooOol057oo000AOol00`00Oomoo`0[Ool0
0`00Oomoo`1VOol017`0DWUBN59h1QcW00IBN5IhEWQFN59h0002EWP01E9hEWQFN5IhDWP00eIh00EB
N5IhEWQFN59h00=FN005DWQFN5IhEWQBN003EWP01E9hEWQFN5IhDWP00eIh00=BN000Ool05Woo00<0
07ooOol04goo000@Ool00`00Oomoo`0]Ool00`00Oomoo`1VOol0<g`07>LLieIiDWQFNE9hEWUBN5Ii
DWQFNE9hEWT005IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN5Ii
DWQFNE9hEWUBN5IiDWQFNE9hEWT0000GOol00`00Oomoo`0COol0011oo`03001oogoo02ioo`03001o
ogoo06Eoo`04O01FN5IhDWP3EWP01E9hEWQFN5IhDWP00UIh00<0059hEWP00UIh00EBN5IhEWQFN59h
00=FN005DWQFN5IhEWQBN003EWP01E9hEWQFN5IhDWP00eIh00=BN5Ih7>L011cW00<007ooOol05Woo
00<007ooOol04Woo000@Ool00`00Oomoo`0_Ool00`00Oomoo`1UOol087`0DWQFNE9hEWUBN5IiDWQF
NE9hEWUBN5Ii001FNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWQFNE9hEWUBN5IiDWP<7>L01UJIEWQFVEIh
EYT001Qoo`03001oogoo019oo`0047oo00<007ooOol0<7oo00<007ooOol0I7oo00El05IhEWQFN59h
00=FN006DWQFN5IhEWQBN0000UIh00ABN5IhEWQFN0`Lia5FV003001oogoo01Ioo`8001=oo`0047oo
00<007ooOol0<Goo00<007ooOol0I7oo00Ml05IiDWQFNE9hEWUBN0057>L00`007>LLi`047>L07UJI
EWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYT001Eo
o`<00003Ool007oo019oo`0047oo00<007ooOol0<Woo00<007ooOol0Hgoo00=l01cW7>L011cW1EJH
00<005JHEYP08EJH00<007ooOol047oo0`0017oo00<007ooOol04Goo000@Ool00`00Oomoo`0cOol0
0`00Oomoo`1ROol0<W`0EYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIh001FN5JIEWQFVEIhEYUFN5JIEWQF
VEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIh000>Ool30007
Ool00`00Oomoo`0AOol000moo`03001oogoo03Eoo`03001oogoo065oo`03O01FV5JH00YFV003001F
V5JH025FV003001oogoo00Uoo`<000]oo`03001oogoo011oo`003goo00<007ooOol0=Woo00<007oo
Ool0HGoo035l05IhEYUFN5JIEWQFVEIhEYUFN5JIEWP005IhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIh
EYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWP00008Ool3000>Ool00`00
Oomoo`0@Ool000moo`03001oogoo03Moo`03001oogoo061oo`03O01FV5JH00UFV003001FV5JH025F
V003001oogoo00=oo`<0015oo`03001oogoo011oo`003goo00<007ooOol0>7oo00<007ooOol0Ggoo
039l05IhEYUFN5JIEWQFVEIhEYUFN5JIEWP005IhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JI
EWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWQFVEIhEYUFN5JIEWP007oo100057oo00<007ooOol047oo
000?Ool00`00Oomoo`0iOol00`00Oomoo`1NOol00g`07>LLi`097>L00`007>LLi`0Q7>L2000HOol0
0`00Oomoo`0@Ool000moo`03001oogoo03Yoo`03001oogoo05eoo`0aO01FV5ZIEYQJVEJHFYUFV5ZI
EYQJVEJH001FV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZI
EYQJVEJHFYUFV5ZIEYQJVEJH00006Goo00<007ooOol047oo000>Ool00`00Oomoo`0lOol00`00Oomo
o`1LOol0<G`0FYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV000FYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQF
V5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV00001Uoo`03001oogoo011o
o`003Woo00<007ooOol0?Goo00<007ooOol0G7oo031l05ZIEYQJVEJHFYUFV5ZIEYQJVEJH001FV5ZI
EYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZI
EYQJVEJH000IOol00`00Oomoo`0@Ool000ioo`03001oogoo03ioo`03001oogoo05]oo`0`O01FV5ZH
EYQJV5JHFYQFV5ZHEYQJV000FYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZH
EYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV0006Woo00<007ooOol03goo000>Ool00`00Oomoo`0o
Ool00`00Oomoo`1JOol00g`07>LLi`037>L0:EJHFYUFV5ZIEYP005JHFYUFV5ZIEYQJVEJHFYUFV5ZI
EYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZI00006goo00<007oo
Ool03goo000>Ool00`00Oomoo`10Ool00`00Oomoo`1IOol00g`0FYQJV003FYP57>L00`007>LLi`04
7>L07EZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JHFYQFV5ZHEYQJV5JH
00006goo00<007ooOol03goo000>Ool00`00Oomoo`11Ool00`00Oomoo`1HOol04W`0F[UJV5ZiFYQJ
^EZHF[UJV5ZiFYP005ZHF[UJV5ZiFYQJ^@/Li`0BFYUFV5ZIEYQJVEJHFYUFV5ZIEYQJVEJHFYUFV5ZI
EYQJV@006goo00<007ooOol03goo000>Ool00`00Oomoo`12Ool00`00Oomoo`1GOol00g`0FYQJV008
FYP00`00FYQJV00?FYP<7>L01UJHFYQFV5ZHEYP001]oo`03001oogoo00moo`003Goo00<007ooOol0
A7oo00<007ooOol0EWoo02Ul05ZiFYQJ^EZHF[UJV5ZiFYQJ^EZH001JV5ZiFYQJ^EZHF[UJV5ZiFYQJ
^EZHF[UJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZH00DLi`03001oogoo01Uoo`03001o
ogoo00moo`003Goo00<007ooOol0AGoo00<007ooOol0EGoo00Al01cW7>LLi`MJV003001JV5ZH021J
V003001oogoo01Uoo`03001oogoo00moo`003Goo00<007ooOol0AWoo00<007ooOol0E7oo00Al05ji
F[QJ^@DLi`0UF[UJV000FYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJ
V5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZH00007Goo00<007ooOol03Woo000=Ool00`00Oomoo`17Ool00`00
Oomoo`1COol01G`0F[QJ^5ZhG[T00eZh00EN^AcW7>LLi`00008LiaiJV003001oogoo01]oo`03001o
ogoo00ioo`003Goo00<007ooOol0B7oo00<007ooOol0DGoo011l05ZhG[UJ^5jiF[QN^EZhG[UJ^5ji
F[QN^@00G[UJV0DLi`0JFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJ
V5ZiFYP001eoo`03001oogoo00ioo`003Goo00<007ooOol0B7oo00<007ooOol0DGoo00Al05ZhF[QN
^@=J^009G[UJ^5ZhF[QN^EZh001J^5ji00=J^003G[UJV1cW00@Lia=JV003001oogoo01aoo`03001o
ogoo00ioo`0037oo00<007ooOol0BWoo00<007ooOol0D7oo01Yl01cW7>LLiejiF[QN^EZhG[UJ^5ji
F[QN^@00G[UJ^5jiF[QN^EZhG[UJ^5jiF[QN^EZh1AcW00mJV5ZiFYQJ^EZHF[UJV5ZiFYQJ^EZHF[UJ
V5Zi00007Woo00<007ooOol03Woo000<Ool00`00Oomoo`1;Ool00`00Oomoo`1=Ool2000017`0G[UJ
^5Zh11cW00=J^5jiF[P00UZh00D005ZhF[QJ^5ji00=J^005G[UJ^5ZhF[QN^@03F[P00ejiF[PLi`05
7>L8FYP00`00Oomoo`0LOol00`00Oomoo`0>Ool000aoo`03001oogoo04aoo`03001oogoo04Uoo`<0
009oo`08O01N^5kIF[QNfEjhG[UJ^0<Li`0JF[QN^@00G[UJ^5jiF[QN^EZhG[UJ^5jiF[QN^EZhG[UJ
^5jiF[QN^EZhG[UJ^5jiF[QJ^@DLi`03F[UJV00001moo`03001oogoo00ioo`0037oo00<007ooOol0
CGoo00<007ooOol0AGoo0`0017oo00al05jhG[UN^5jiG[QN^EjhG[UN^5jiF[P27>L00`00F[QN^@03
F[P01EjiF[QJ^5ZhG[T00eZh00EN^EZhF[QJ^5ji00=J^005G[UJ^5ZhF[QN^@02F[P27>L00`00Oomo
o`0NOol00`00Oomoo`0=Ool000aoo`03001oogoo04ioo`03001oogoo045oo`<000Moo`0?O01NfEZh
G]UN^5kIF[QNfEjhG]UJ^5kIG[QNf@0000@Li`0JG[UJ^5jiF[QN^EZhG[UJ^5jiF[QN^EZhG[UJ^5ji
F[QN^EZhG[UJ^5jiF[QN^EZhG[T0025oo`03001oogoo00eoo`0037oo00<007ooOol0Cgoo00<007oo
Ool0?Goo0`002Woo01=l05jhG[UN^5jiG[QN^EjhG[UN^5jiG[QN^Ejh001N^5jiG[QN^@037>L01Eji
F[QJ^5ZhG[T00eZh00EN^EZhF[QJ^5ji00=J^007G[UJ^5ZhF[QN^EZh00008Goo00<007ooOol03Goo
000;Ool00`00Oomoo`1AOol00`00Oomoo`0iOol3000=Ool05W`07>LLiacWF[QNfEjhG]UJ^5kIG[QN
fEZhG]T005kIF[QNfEjhG]UJ^5kI0acW01=N^EZhG[UJ^5jiF[QN^EZhG[UJ^5jiF[QN^EZhG[UJ^5ji
F[P0000ROol00`00Oomoo`0=Ool000]oo`03001oogoo059oo`03001oogoo03Eoo`<000moo`03O01R
fEkH009Nf@8Li`0CG[UN^5jiG[QN^EjhG[UN^000G[QN^EjhG[UN^5jiG[QN^EjhG[T011cW0eZh00EN
^EZhF[QJ^5ji00=J^004G[UJ^5Zh000ROol00`00Oomoo`0=Ool000]oo`03001oogoo05=oo`03001o
ogoo035oo`<0019oo`07O01Nf6;IG]QRfEkHH]T00acW01ANfEZhG]UN^5kI001NfEjhG]UJ^5kIG[QN
fEZhG]UN^5kIF[QNfEjh0acW00]J^5jiF[QN^EZhG[UJ^5jiF[QN^@0002=oo`03001oogoo00eoo`00
2goo00<007ooOol0E7oo00<007ooOol0;Goo0`0057oo00Il05kHG]UNfF;IG]P2G]T00f;IG]QNf@02
7>L05EjhG[UN^000G[QN^EjhG[UN^5jiG[QN^EjhG[UN^5jiG[QN^EjhG[UN^0037>L3F[P01EjiF[QJ
^5Zh00008goo00<007ooOol03Goo000;Ool00`00Oomoo`1EOol00`00Oomoo`0YOol3000GOol03G`0
H]UNf6;IG]QRfEkHH]UNf6;IG]QRfEkH00<Li`0E001NfEZhG]UN^5kIF[QNfEjhG]UJ^5kIG[QNfEZh
G]UN^5kIF[QNfEjh00@Li`03G[UJ^00002Aoo`03001oogoo00eoo`002goo00<007ooOol0EWoo00<0
07ooOol09Goo0`006Goo00El06;i7>LLiekH009Nf@06H]UNf5kIG]URfEkH0UkI01]RfEkH000Lieji
G[QN^EjhG[UN^5jiG[QN^EjhG[UN^5jiG[QN^EjhG[UN^5jiG[QN^EjhG[T00QcW00<007ooOol08goo
00<007ooOol037oo000;Ool00`00Oomoo`1GOol00`00Oomoo`0QOol3000KOol01G`0H_UNf6;iG]T0
0QcW00eRfEkHH]UNf6;IG]QRfEkHH]UNf6;I001Rf@027>L05eZhG]UN^5kIF[QNfEjhG]UJ^5kIG[QN
fEZhG]UN^5kIF[QNfEjhG]UJ^5kI00009Woo00<007ooOol037oo000:Ool00`00Oomoo`1IOol00`00
Oomoo`0MOol3000NOol01g`0H]URnF;IH_URfF;i008Li`03G]URfEkH009Nf@06H]UNf5kIG]T005kH
0UkI0acW01AN^5jiG[QN^EjhG[UN^5jiG[QN^EjhG[UN^5jiG[QN^EjhG[UN^0009Woo00<007ooOol0
37oo000:Ool00`00Oomoo`1JOol00`00Oomoo`0HOol4000POol02W`0G]QRnEkIH_UNf6;iG]URnEkH
0QcW00iRfEkHH]UNf6;IG]QRfEkH001Nf6;IG]QRfEkH0QcW015NfEZhG]UN^5kIF[QNfEjhG]UJ^5kI
G[QNfEZhG]UN^00002Moo`03001oogoo00aoo`002Woo00<007ooOol0Fgoo00<007ooOol057oo0`00
8goo00el06;i7>LLif;iH]URnF;IH_URfF;iH]URn@027>L02EkHG]UNfF;IG]QNf@00H]UNf002G]T0
0f;IG]QNf@037>L03EjiG[QN^EjhG[UN^5jiG[QN^EjhG[UN^00002Qoo`03001oogoo00aoo`002Woo
00<007ooOol0G7oo00<007ooOol047oo0`009Woo00ml06KjH_URnAcWH_UNfF;iG]QRnEkIH_UNf6;i
G]T00QcW00mRfEkHH]UNf000G]QRfEkHH]UNf6;IG]QRfEkHH]T00QcW00]N^5kIF[QNfEjhG]UJ^5kI
G[QNf@0002Qoo`03001oogoo00aoo`002Woo00<007ooOol0GGoo00<007ooOol037oo0`00:7oo00=l
06;iH_T00f;i0QcW00QRfF;iH]URnF;IH_URfF;i0V;I0QcW00=NfF;I00000UkI00IRfEkHG]UNfF;I
G]P2G]T00f;IG]PLi`027>L01ejhG[UN^5jiG[QN^@0002Uoo`03001oogoo00aoo`002Woo00<007oo
Ool0GWoo00<007ooOol027oo0`00:goo00El06;iH_URnFKj009Rn@0OG]PLiekIH_UNf6;iG]URnEkH
H_UNfF;iG]PLiekH001Nf6;IG]QRfEkHH]UNf6;IG]QRfEkHH]UNf6;IG]P00QcW00ENfEjhG]UJ^000
02Yoo`03001oogoo00]oo`002Goo00<007ooOol0H7oo00<007ooOol017oo0`00;Goo00=l06;iH_T0
1f;i010Lif;IH_URfF;iH]URnF;IH_URfF;iH]TLi`00H]UNf09Nf@06H]UNf5kIG]URfEkH0UkI00ER
fEkHG]UNfF;I00<Li`03001oogoo02Uoo`03001oogoo00]oo`002Goo00<007ooOol0HGoo00<007oo
Ool00`00;goo00El06<I7>MRnFKj00=Rn@04I_YRnF;iH_T27>L02f;iG]QRnEkIH_UNf6;iG]URnEkH
00000QcW019Nf6;IG]QRfEkHH]UNf6;IG]QRfEkHH]UNf6;IG]QRfEkH000/Ool00`00Oomoo`0;Ool0
00Uoo`03001oogoo069oo`80035oo`05O01S6FLJHaTLi`0:H_T03AcWH_URfF;iH]URnF;IH_URfF;i
001RnF;I008Li`9Nf@06H]UNf5kIG]URfEkH0UkI00ERfEkHG]UNf@0002eoo`03001oogoo00]oo`00
2Goo00<007ooOol0Fgoo6@008Goo00Ql06LJHaUW6V<I7>MRnFKj0f;i00eVnV;iH_URnFKj7>MRnEkH
H_UNfF;iG]QRn@02000015kHH_UNfF;I0QcW00aNf6;IG]QRfEkHH]UNf6;IG]QRfEkH000^Ool00`00
Oomoo`0;Ool000Uoo`03001oogoo05=oo`P0000E7SdJ?AXm6SdN?AXm7>LR?BHm8SdV?B8m9SdR?BHm
8SdV?B8m7>LZ?2Xm00<Z?003:Sd0000000P001Ioo`08O01W6V<IIaYS6FLJHaTLi`YRn@8Li`03H]UR
n@0000800008H_URf@00H]URnF;IH_UNf08Li`06H]UNf5kIG]URfEkH0UkI00<007ooOol0;Goo00<0
07ooOol02goo0009Ool00`00Oomoo`1=Ool60000:a8l5SdLiahm6SdN?AXl7SdJ?Ahm6S`N?AXm7SdR
?1cW8S`V?B8l9SdR?2Hm8S`V?B8l9SdLibhm:S`^?BXl;SdZ?2hm:S`^?BXl;SdZ?1cW<S`bG2hk00L0
00ioo`0<O00Lif<IIaYS6FLJHaUW6V<I7>MRnFKj0f;i00AVnV;iH_URn@@0000=H_UNfF;iG]QRnEkI
001Nf6;iG]URnEkHH]T00QcW00MNf6;IG]QRfEkHH]T0000_Ool00`00Oomoo`0;Ool000Uoo`03001o
ogoo04Qoo`D000TB?@047>LJ?AXm7Sd36Sd04Qhm6SdJ?AXm7SdLibHm8SdV?B8m9SdR?BHm8SdV?B8m
9SdLi`8Z?005:SdZ?2Xl:S`Z?@03:S`00bXm7>Lb?009<S`50008Ool037`0IcYW>QcWHaUW6V<IIaYS
6FLJHaTLi`ERn@<000=Rn@0@7>MRfF;iH]URnF;IH_T006;iH]URnF;IH_URfF;iG]T27>L2G]T00f;I
001oo`0_Ool00`00Oomoo`0;Ool000Qoo`03001oogoo04Eoo`@000122S`:70Xl7>LF?A8l5SdB?1Hm
4S`F?A8l5SdB?1Hm7>LN?AXm7SdJ?1hm6SdN?AXl7SdJ?BHm7>LV?B8l9SdR?2Hm8S`V?B8l9SdR?1cW
:S`^?BXl;SdZ?2hm:S`^?BXl;SdZ?1cW;S/bG38l<U`^>c9L<S`bG2hk<U`b?39L;S/LicHk10000goo
00ml06LjHcUW>QcWIaYS6FLJHaUW6V<IIaYS6AcWH_T00`0000=RnFKjH_T00V;i01IVnV;i7>LLif;i
G]URnEkHH_T006;iG]QRnEkIH_UNf6;iG]URfAcWH]T0039oo`03001oogoo00Yoo`0027oo00<007oo
Ool0@Goo100020Xl00<Lia8m4Sd02A8m00@LiaXm6SdN?@<J?@0A7SdJ?AXm6SdLib8m9SdR?BHm8SdV
?B8m9SdR?BHm7>LZ?@03:S`01BXm:S`Z?2Xl:Sd00RXl00<Lic8l<S`02c8l00HLicIK=S/fG3Hk=U/3
0005IcX01acWIaYS6FLJHaUW6V<I00<000aRn@0A7>MRnF;IH_URfF;i001RnF;IH_URfF;iH]URnF;I
H_T0000cOol00`00Oomoo`0:Ool000Qoo`03001oogoo03moo`8000866`8Li`092S`:70Xl2Q`:?0XL
2S`:70Xl008Li`124S`F?A8l5SdB?1Hm4S`F?A8l5SdLiahm6SdN?AXl7SdJ?Ahm6S`N?AXm7>LR?2Hm
8S`V?B8l9SdR?2Hm8S`V?AcW;SdZ?2hm:S`^?BXl;SdZ?2hm:S`Lic8l<U`^>c9L<S`bG2hk<U`b?39L
;S/bG1cW=U`f>cYL=S/fG3Hk>U`f>cIL100000ES>FLj7>MW6V<I00<00006HaUW6V<I7>MRnFKj0f;i
00EVnV;iH_URnFKj009Rn@0?7>MRnEkIH_UNf6;i001RnEkHH_UNfF;iG]QRn@0003Aoo`03001oogoo
00Yoo`0027oo00<007ooOol0?Goo0P001PHK0QcW2@Xl00<Lia8m4Sd0218m00@LiaXm6SdN?@<J?@0A
7SdJ?AXm8SdLib8m9SdR?BHm8SdV?B8m9SdR?AcW:S`Z?@03:S`01RXm:S`Z?2Xl:SdLi``b?00>7>Lf
>cIL=S/fFcHk=U`f>cIK=S/fG3Hk=U/f>`D00008HaUW6V<IIaYS6FLJHaTLi`aRn@8Li`0;H]URnF;I
H_T006;iH]URnF;IH_T0000eOol00`00Oomoo`0:Ool000Qoo`03001oogoo03]oo`8000X66`8Li`1;
2S`:70Xl2Q`:?0XL2S`:71cW4S`F?A8l5SdB?1Hm4S`F?A8l5SdLiahm6SdN?AXl7SdJ?Ahm6S`N?AcW
9SdR?2Hm8S`V?B8l9SdR?2Hm7>L^?BXl;SdZ?2hm:S`^?BXl;SdZ?1cW;S/bG38l<U`^>c9L<S`bG2hk
<U`b?39L7>LjG3Hk=U`f>cYL=S/fG3Hk>U`f>cIL00<00003?U/j>P0000<00006IaYS6FLJHaUW6V<I
0QcW00EVnV;iH_URnFKj00=Rn@0>I_YRnF;iG]PLiekIH_UNf6;i001RnEkHH_T003Ioo`03001oogoo
00Yoo`0027oo00<007ooOol0>Woo00<0008I7>L00QcW2@HK00<:?1cW7>L01`Xl0QcW2A8m00@LiaXm
6SdN?@<J?@0=7SdJ?AXm7>LV?B8m9SdR?BHm8SdV?B8m7>L00bXl00DZ?BXl:S`Z?2Xm008Z?0037>Lb
?38l00Xb?0097>Lf>cIK=S/fG3Hk=U/f>cIL00<00009=U`LicYK>S/nFcXk>U/j>ciK00<00006IaYS
6FLJHaURnAcW36;i00PLif;IH_URf@00H]URn@00=goo00<007ooOol02Woo0007Ool00`00Oomoo`0i
Ool200001@8I0QX26@8J0QT00QcW2@HK04@:71cW2Q`:?0XL2S`:70Xl2Q`:?1cW5SdB?1Hm4S`F?A8l
5SdB?1Hm7>LN?AXm7SdJ?1hm6SdN?AXl7>LR?2Hm8S`V?B8l9SdR?2Hm8S`LibXl;SdZ?2hm:S`^?BXl
;SdZ?1cW<S`bG2hk<U`b?39L;S/bG38l<U`^>acW=S/fG3Hk>U`f>cIL0`0000lfG3Hk>U`f>acW>SXn
FcXj?U/j>SiK>SXnFcXj?U/0100000AS6F;i7>MVnP=Rn@05I_YRnF;iH_UVnP03H_T27>L016;iG]P0
0000>7oo00<007ooOol02Woo0007Ool00`00Oomoo`0hOol02P000QX26@8J0QT26P8I0QX26@8J0QcW
2@HK0QcW1`Xl00<Lia8m4Sd01a8m00@LiaXm6SdN?@<J?@0=7SdJ?AcW8SdV?B8m9SdR?BHm8SdV?AcW
:Sd00bXl00HZ?BXl:S`Z?2Xm7>L;<S`011cW=U/f>cIL0`0001HfG3Hk=U/f>cIL=S/LicXk?U/j>cYK
>S/nFcXk>U/j>ciK>S/jFcXk?U/j>`<000037>MRnF;i00]Rn@047>MRn@00000iOol00`00Oomoo`09
Ool000Moo`03001oogoo03Moo`0=000LiacW0QX26@8J0QT26P8I0QX26@8J0QT00QcW20HK00T:?1cW
7>L:70Xl2Q`:?0XL2S`00QcW02lB?1Hm4S`F?A8l5SdB?1Hm7>LN?AXm7SdJ?1hm6SdN?B8l7>LR?2Hm
8S`V?B8l9SdR?1cW:S`^?BXl;SdZ?2hm:S`^?BXl7>L^>c9L<S`bG2hk<U`b?39L;S/bG38l00@0000L
=U`f>cYL=S/fG3Hk>U`f>cIL7>LnFcXj?U/j>SiK>SXnFcXj?U/j>SiK>SXnFcXj?U/Lid9K?UX20000
1FKjH_URnF;iI_X00f;i00IVnV;iH_URnFKj0002Ool00`00Oomoo`0fOol00`00Oomoo`09Ool000Mo
o`03001oogoo03Ioo`040002608H0QX37>L02@8J0QT26P8I0QX26@8J0QT26P037>L71Q/00`Xl7>LL
i`062S`00acW4SdB?@064Sd011cW6SdJ?Ahm0aXm00dN?AcW9SdR?BHm8SdV?B8m9SdR?AcW:S`Z?@03
:S`012Xm:S`Z?1cW238l0`0001hLicIL=S/fFcHk=U`f>cIK=S/fG3Hk=U/LiciK>S/jFcXk?U/j>cYK
>S/nFcXk>U/j>ciK>S/jFacW@U/3?UX00d9K00000009H_T20004Ool00`00Oomoo`0eOol00`00Oomo
o`09Ool000Moo`03001oogoo03Aoo`8000H2600=0QXLiacW7>L26P8I0QX26@8J0QT26P8I0QX00QcW
1`HK030:?1cW2S`:70Xl2Q`:?0XL7>LB?1Hm4S`F?A8l5SdB?1Hm7>LN?AXm7SdJ?1hm6SdN?AcW9SdR
?2Hm8S`V?B8l9SdLibhm:S`^?BXl;SdZ?2hm:S`Lic8l<U`^>c9L<S`300009c8l<U`LicYL=S/fG3Hk
>U`f>cIL=S/jG3Hk=U`f>acW>SXnFcXj?U/j>SiK>SXnFcXj?U/j>SiK>SXnFacW@U/nFT9K?UY2FciJ
@U/nFP0300000f;iI_YRn@02H_T00`00Oomoo`04Ool00`00Oomoo`0eOol00`00Oomoo`09Ool000Mo
o`03001oogoo03=oo`030002608H00X260<Li`080QX26@8J0QT26P8I0QX26@8Li`H66`032S`LiacW
00D:?08Li`HB?@057>LJ?AXm6SdN?@036Sd02AcW8SdV?B8m9SdR?BHm8SdLi`03:S`01RXm:S`Z?2Xl
:SdLi`8b?0<000Db?00M7>Lf>cIK=S/fG3Hk=U/f>cIL=S/fFcHk7>Lj>cYK>S/nFcXk>U/j>ciK>S/j
FcXk?U/j>cYK7>M2F`03?UX01D9K?UXnFSiJ@U/00ciJ0P0000=Rn@00000027oo00<007ooOol0=7oo
00<007ooOol02Goo0007Ool00`00Oomoo`0bOol00`000QHLi`037>L;0QP37>L01`8J0QT26P8I0QX2
6@8J008Li`H66`0W2Q`LiacW2S`:70Xl2Q`:?1cW5SdB?1Hm4S`F?A8l7>LJ?1hm6SdN?AXl7SdJ?AcW
8S`V?B8l9SdR?2Hm8S`LibXl;SdZ?2hm:S`^?BXl00<0000b<S`bG2hk<U`b?39L;S/bG1cW=U`f>cYL
=S/fG3Hk>U`f>cIL=S/jG1cW?U/j>SiK>SXnFcXj?U/j>SiK>SXnFcXj?U/j>QcW?UY2FciJ@U/nFT9K
?UY2FciJ@U/nFT9K?UY2F`8000Yoo`03001oogoo03=oo`03001oogoo00Uoo`001Woo00<007ooOol0
<goo00H0008G0QL25`8F0QL47>L:0QP37>L01P8J0QT26P8I0QX26@<Li`D66`032S`Li`Xl00@:?003
7>LB?A8m00@B?@057>LJ?AXm6SdN?@026Sd02QcW9SdR?BHm8SdV?B8m9SdLibXm0RXl100000<Z?1cW
<S`0238l01/LicHk=U`f>cIK=S/fG3Hk=U/f>cIL7>LjFcXk?U/j>cYK>S/nFcXk>U/j>ciK>S/jFcXk
7>L00ciJ00E2FciJ?UXnFT9K00<nFP06@U/nFSiJ?UXLid9J0P002Goo00<007ooOol0<Woo00<007oo
Ool02Goo0006Ool00`00Oomoo`0bOol02`000QL25P8G0QH25`8F0QL25P8G0QH011cW2@8H0acW00H2
6P8I0QX26@8J0QT27>L51Q/27>L010XL2S`:70Xl0QcW01@B?1Hm4S`F?A8l7>LJ?1hm6SdN?AXl7SdL
ibHm8S`V?B8l9SdR?1cW0`0003d^?BXl;SdZ?2hm7>LbG2hk<U`b?39L;S/bG38l7>Lf>cYL=S/fG3Hk
>U`f>cIL=S/jG3Hk7>Lj>SiK>SXnFcXj?U/j>SiK>SXnFcXj?U/j>QcW?UY2FciJ@U/nFT9K?UY2FciJ
@U/nFT9K?UY2FciJ7>M2FTIJ@UY6FP020008Ool00`00Oomoo`0aOol00`00Oomoo`09Ool000Ioo`03
001oogoo039oo`04000LiacW7>L30QL01@8F0QL25`8G0QH00`8G1AcW1`8H0acW00D26P8I0QX26@8J
008Li`@66`032S`LiacW00@:?0037>LB?A8m00<B?@057>LJ?AXm6SdN?@026Sd011cW9SdR?BHm0`00
00<LibXl:Sd00bXl00<Z?BXl7>L0238l01XLicIL=S/fFcHk=U`f>cIK=S/fG3Hk7>Lj>ciK>S/jFcXk
?U/j>cYK>S/nFcXk>U/j>acW0ciJ00E2FciJ?UXnFT9K00<nFP05@U/nFSiJ?UXLi`03@UX01DIJ@UY2
FT9J00001goo00<007ooOol0<Woo00<007ooOol027oo0006Ool00`00Oomoo`0bOol010000SH25@8f
1acW00T25`8F0QL25P8G0QH25`8F0QL011cW1P8H0acW00@26P8I0QX26@8Li`@66`0C2S`LiacW2Q`:
?0XL7>LB?1Hm4S`F?A8l7>LJ?1hm6SdN?AXl7>L00`0003/V?B8l9SdLibhm:S`^?BXl;SdZ?2hm7>Lb
G38l<U`^>c9L<S`bG2hk7>Lf>cIL=S/jG3Hk=U`f>cYL=S/fG1cW?U/j>SiK>SXnFcXj?U/j>SiK>SXn
FcXj7>LnFT9K?UY2FciJ@U/nFT9K?UY2FciJ@U/nFT9K008Li`09@UY6FT9JAUY2FTIJ@UY6FT9J0080
00Ioo`03001oogoo035oo`03001oogoo00Qoo`001Woo00<007ooOol0<Woo00<0008f0SH0208f1acW
0`8G00<25P8G0QL01AcW108H0acW00<26P8I0QX00acW0`HK00<:?1cW2S`00PXl0QcW118m00<LiaXm
6Sd00`0000LLib8m9SdR?BHm8SdLi`03:S`01BXm:S`Z?2Xl7>L0238l01PLicIK=S/fG3Hk=U/f>cIL
=S/fFacW?U/j>cYK>S/nFcXk>U/j>ciK>S/jFcXk7>L3?UX01D9K?UXnFSiJ@U/00ciJ00E2FciJ?UXL
idIJ00=2FP05AUY2FT9J@UY6FP03@UX00dIJ00000005Ool00`00Oomoo`0`Ool00`00Oomoo`08Ool0
00Ioo`03001oogoo039oo`0B0002=P8E0SH25@8f0QD2=P8E0SH25@8f0QD2=P8E0SH25@8f1QcW00D2
5P8G0QH25`8F00@Li`<260<Li`030QX26@8J008Li`866`092Q`LiacW2S`:71Hm7>LF?A8l00@0001@
7SdJ?Ahm7>LV?B8l9SdR?2Hm8S`LibXl;SdZ?2hm:S`^?AcW<U`^>c9L<S`bG2hk<U`b?1cW=S/jG3Hk
=U`f>cYL=S/fG3Hk7>Lj>SiK>SXnFcXj?U/j>SiK>SXnFcXj?U/Lid9K?UY2FciJ@U/nFT9K?UY2FciJ
@U/nFT9K7>M6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FP8000Aoo`03001oogoo02moo`03
001oogoo00Qoo`001Goo00<007ooOol0<goo00<001cW7>L01QcW3`8f1acW00<25P8G7>L00acW0P8H
0acW00@26P8I7>LLi`866`042S`LiacW2S`300034Sd03AcW6SdJ?AXm7SdLibHm8SdV?B8m9SdLibXm
00<Z?003:SdZ?1cW00Lb?00H7>Lf>cIL=S/fFcHk=U`f>cIK=S/LicXk>U/j>ciK>S/jFcXk?U/j>cYK
>S/nFacW0SiJ00E2FciJ?UXnFT9K00<nFP05@U/nFSiJ7>M6FP03@UX01DIJ@UY2FT9JAUX00d9J00E6
FT9J@UY2FTIJ0092FP03001oogoo009oo`03001oogoo02ioo`03001oogoo00Qoo`001Goo00<007oo
Ool0=7oo200041cW00H2=P8E0SH25@8f0QD>7>L0108J7>LLi`HK0`0005XLi`Xl7>LLia8l5SdJ?AcW
6S`N?AXm7SdLibHm8S`V?B8l7>LZ?2hm:S`^?BXl;SdLic9L<S`bG2hk<U`b?39L7>LjG3Hk=U`f>cYL
=S/fG3Hk>U`LiciK>SXnFcXj?U/j>SiK>SXnFcXj?U/Lid9K?UY2FciJ@U/nFT9K?UY2FciJ@U/nFT9K
7>M6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FQcWBUX20003Ool00`00Oomoo`0]
Ool00`00Oomoo`08Ool000Eoo`03001oogoo03AooaP001DLi`<0008Li`8:?0047>L:?18m7>L24Sd0
0aXm7>LJ?@026Sd01QcW8SdV?B8m9SdLi`8Z?005:SdZ?2Xl:S`Li`07<S`05QcW=S/fFcHk=U`f>cIK
=S/fG1cW>U/j>ciK>S/jFcXk?U/j>cYK>S/nFacW0SiJ00E2FciJ?UXnFT9K00<nFP05@U/nFSiJ7>M6
FP03@UX01DIJ@UY2FT9JAUX00d9J00I6FT9J@UY2FTIJ@UX27>L01DIJAUU6FTIJ00000Woo00<007oo
Ool0;Goo00<007ooOol027oo0005Ool00`00Oomoo`0eOolX000011cW000000001acW00Al01cW2S`:
708Li`0j5SdJ?AcW6S`N?AXm7>LR?2Hm8S`V?AcW;SdZ?2hm:S`^?AcW<U`^>c9L<S`bG2hk<U`LicIL
=S/jG3Hk=U`f>cYL=S/LicXj?U/j>SiK>SXnFcXj?U/j>SiK7>M2FciJ@U/nFT9K?UY2FciJ@U/nFT9K
?UX27>L04DIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUX00QcW00Q6FDYJAUU6FTIIBUY6
F@000Woo00<007ooOol0;Goo00<007ooOol01goo0005Ool00`00Oomoo`0eOol00`001WD6MP021WH0
1@Ie1WH6MPIf1WD00`If00D6M@If1WH6MPIe00<6MP051WD6MPIf1WH6M@031WH010Ie1WH6MPIf11cW
10001acW00@O61cW7>LLi`Il00034SdJ?AcW008J?@067>LV?B8m9SdR?AcW0bXl00<Z?BXl7>L01S8l
01DLicIK=S/fG3Hk=U/f>cIL=S/LicXk?U/j>cYK>S/nFcXk>U/j>ciK7>L00SiJ00E2FciJ?UXnFT9K
00<nFP05@U/nFQcW@UY6FP03@UX01DIJ@UY2FT9JAUX00d9J00I6FT9J@UY2FTIJ7>L3AUX01DIIAUY6
FTIJAUT00TIJ0P0000=oo`00Ool0;Goo00<007ooOol01goo0005Ool00`00Oomoo`0fOol05@001WD6
MPIe1WH6M@If1WD6MPIe1WH6M@If1WD6MPIe1WH6M@If1WD6MP0;7>L011;G000000001AcW00<Nmb<H
7_L01AcW00<kVSnK>iX00QcW00=?g1cW7>L01G`004@N?AcW9SdR?2Hm7>L^?BXl;SdZ?2hm7>LbG38l
<U`^>c9L<S`LicHk>U`f>cIL=S/jG3Hk=U`LiciK>SXnFcXj?U/j>SiK>SXnFciJ7>LnFT9K?UY2FciJ
@U/nFT9K?UY2FciJ7>M2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9J0QcW0116FTIIBUY6
FDIJAUU:FTIIAUY6FDYJAUU6FP00Ool002eoo`03001oogoo00Moo`001Goo00<007ooOol0=goo00<0
00Ie1WH00PIf00<6M@If1WH031cW00TB]a:f4[LB]Q:g4[HB]a:f7>L00`000QcW1AlH1QcW00<kVcnK
?i/00acW00=;_4_L7>L00eOM00AGg1cWGmeOg@Al00048SdV?AcW:Sd3:S`00acW<S`b?004<S`05QcW
=U`f>cIK=S/fG3Hk=U/LiciK>S/jFcXk?U/j>cYK>S/nFcXk7>LnFT9K0ciJ00U2FciJ?UXnFT9K?UXL
id9JAUX00d9J00E6FT9J@UY2FTIJ00=2FP06AUY2FT9JAUXLidII0dIJ00E6FDIJAUY6FTII00=6FP04
AUU6FTIJAUX3000/Ool00`00Oomoo`07Ool000Aoo`03001oogoo03Uoo`03000LiacW00@Li`0>3[HB
e`jf4]L>]Q;G3[HBe`jf4]L>]Q;G3[HBe`@Li`<000067aPNmb<H7_LO61kg11cW00L_FQcW7>LkVSnK
>iXoV`027>L00d^lBma;^`027>L035OMEmaGgEOL7>MOg5oMGmaOgAcWImeS_09l000k7>Ml02hm:S`^
?AcW<U`^>c9L<S`bG2hk7>Lf>cIL=S/jG3Hk=U`f>acW>SXnFcXj?U/j>SiK>SXnFcXj7>LnFT9K?UY2
FciJ@U/nFT9K?UY2FciJ7>M2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FP027>L054IIAUY6
FDYJAUU6FTIIBUY6FDIJAUU:FTIIAUY6FDYJAUU6FQcW000/Ool00`00Oomoo`07Ool000Aoo`03001o
ogoo03Yoo`0>000B]Q:g4[HB]a:f4[LB]Q:g4[HB]a:f4[LB]PHLi`@000DO60@Li`8_F@<Li`<oV`06
>i/LiacWBma;_4_L0QcW00IGg5OMEmeGgEOL7>L4Gmd021cWHmeSg6?MHm`006Nl7>L2O0000bXl7>Lb
?004<S`05AcW=S/fFcHk=U`f>cIK=S/LicXk>U/j>ciK>S/jFcXk?U/j>acW?UY2F`03?UX02D9K?UXn
FSiJ@U/nFQcW@UY6FP03@UX01DIJ@UY2FT9JAUX00d9J00I6FT9J7>LLidIJAUT3AUX01DIIAUY6FTIJ
AUT00dIJ00I6FDIJAUY6FTIIAUX27>L00dYI001oo`0ZOol00`00Oomoo`07Ool000Aoo`03001oogoo
03]oo`8000054]L>]Q;G3[HBe`067>L00akg8aPNm`0300001Akg7aPNmb<H7_L011cW00<_FR]I;eX0
0acW00@oVc^J?i/kVP<Li`0:Bk]?g4^lBm`LieOMEmaGgEOLEmd27>L035oLGmeOg5oMHk`Lif>lImeS
_6OM000Li`=W_00SO00Lig`0<S`bG2hk<U`LicIL=S/jG3Hk=U`f>cYL7>LnFcXj?U/j>SiK>SXnFcXj
7>LnFT9K?UY2FciJ@U/nFT9K?UY2F`027>L08d9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY6FAcW
AUU:FTIIAUY6FDYJAUU6FTIIBUY6FDIJAUU:FTIIAUY6FDYJAUT00QcW00E:NTYIBWY6F@0002Yoo`03
001oogoo00Moo`0017oo00<007ooOol0?Goo00<001cW7>L00QcW1QlH0`0011lH11cW1BmI0QcW0cnK
00TkVcnK7>LLid^lBma;_4_LBk`00QcW00=GgEOLEmd00UOM00<LieoMGmd00eoM00USg1cWHmaSgF?L
Hmd006Nl7>L01VNl0g`001@b?1cW=S/fG3Hk=U/f>cIL7>LjFcXk?U/j>cYK>S/nFcXk7>LnFT9K0ciJ
00I2FciJ?UXnFT9K7>L2@UX01DIJ@UY2FT9JAUX00d9J00E6FT9J@UY2FTIJ008Li`96FP05AUU6FTIJ
AUY6F@03AUX01DIIAUY6FTIJAUT00dIJ0QcW00=:FDYJBUT00TYI00=:FTYI0000:Woo00<007ooOol0
1Woo0004Ool00`00Oomoo`0nOol200001Akg7aPNmb<H7_L00`0000<NmalH7_L011cW00H_FRmI;eX[
FBmJ;eT37>L01C^J?i/kVSnK>iX00QcW00E?g4^lBma;^doL008Li`0EEmaGgEOLEmeGg5OM7>MOgEoL
GmeOg5oMHk`Lif>lImeS_6OMHk`001cW00MW_0037>M[W6NK009l000l>U`f>cIL=S/jG3Hk7>Lj>SiK
>SXnFcXj?U/j>T9K7>M2FciJ@U/nFT9K?UY2FciJ@U/LidIJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ
@UY:FQcWAUY6FDYJAUU6FTIIBUY6FDIJAUU:FTIIAUY6FDYJAUU6FTII0QcW00Y:NTIIBWY:FDYjAUU:
NTYIBWY6F@8002Qoo`03001oogoo00Ioo`0017oo00<007ooOol0@7oo1@000QlH11cW1bmI0acW0SnK
00@kVcnK?i/oV`8Li`07Bka;g4^lBma;_4_L7>L00eOM00EGg5OMEmeGgAcW00EOg@09Hm`Lif?LHmeS
g6?MHm`001cW00QW_0057>MWVfNLIi]WW002O0003SHk=U`f>acW>S/nFcXk>U/j>ciK>S/nFQcW@U/3
?UX01T9K?UXnFSiJ@U/Li`92FP05AUY2FT9J@UY6FP03@UX014IJ@UY2FTIJ0QcW0dIJ00E6FDIJAUY6
FTII00=6FP06AUU6FTIJAUY6FDIJ0QcW0dYI00E:FTYIBUU:FDYJ00=:F@04BUX004YI000WOol00`00
Oomoo`06Ool000=oo`03001oogoo03moo`H000<Li`09;eX[FBmJ;eT_FR]I;eX_FBmJ008Li`06>iXo
Vc^J?i/kVSnK0acW00I;g4^kCma;_4_LBk/27>L05eOMEmaGgEOLEmeGg5oM7>MOgEoLGmeOg5oMGm`L
if>lImeS_6OMHkaWgFNl7>L026Nl00LLif^LIi][W6NKJiaWV`02O0008AcW>SXnFcXj?U/j>SiK>SXn
FacW@U/nFT9K?UY2FciJ@U/nFT9K7>M6FT9JAUY2FTIJ@UY6FT9JAUY2FTIJ@UY6FP027>L04DIIAUY6
FDYJAUU6FTIIBUY6FDIJAUU:FTIIAUY6FDYJAUT00QcW019:NTYIBWY6FDYjBUU:NTIIBWY:FDYjAUU:
NTYIBWX004Yj000VOol00`00Oomoo`06Ool000=oo`03001oogoo03aoo`<000Moo`<000D_F@<Li`03
?i/kVcnK008oV`0=>i/LiacWBma;_4_LBka;g4^lBma;_1cWEm`00eOM00EGg5OMEmeOgAcW00IOg@09
7>MSg6?MHmaSgF?LHmd001cW00QW_0037>MWW6NK00D0009oo`9l0008>S/jFcXk?U/j>cYK7>M2F`<n
FP06@U/nFSiJ?UY2FacW0T9J00E6FT9J@UY2FTIJ00=2FP06AUY2FTIJ7>M6FTII0dIJ00E6FDIJAUY6
FTII00=6FP04AUU6FTIJAUX27>L00dYIBUY:F@02BUT01DYJBUU:FDYIBUX00dYI00Q:FTYIBUU:FDYJ
001:F@009Goo00<007ooOol01Woo0003Ool00`00Oomoo`0iOol3000=Ool200037>L01cnK>iXoVc^J
?i/kVSnK008Li`08Bk]?g4^lBma;^doLBka;g08Li`07EmaGgEOLEmeGg5OMEm`00QcW011OgEoLGmeO
g5oMGm`Lif>lImeS_6OMHkaWgF>lIk`Li`IW_08000037>L0000000Uoo`=l000;>SXnFacW@U/nFT9K
?UY2FciJ@U/nFP027>L034IJ@UY6FT9JAUY2FTIJ@UY6FT9JAUY2FP8Li`0@BUY6FDIJAUU:FTIIAUY6
FDYJAUU6FTIIBUY6FDIJAUT27>L064YjAUU:NTYIBWY6FDYjBUU:NTIIBWY:FDYjAUU:NTYIBWY6FDYj
BUU:NP007>L002Aoo`03001oogoo00Ioo`000goo00<007ooOol0=Woo0`004goo100000<kVcnK?i/0
0QcW00Q;g4^lBma;_4_LBka;g4^l0QcW00=GgEOLEmd00UOM00AGg5OMEmdLi`MOg@0;7>MSg6?MHmaS
gF?LHmeSg0007>MW_006000AOol2O0001D9K?UXnFSiJ@U/00ciJ00DLid9J@UY2FTIJ00=2FP05AUY2
FT9J@UY6FP027>L2AUX01DIIAUY6FTIJAUT00dIJ00I6FDIJAUY6FTIIBUT27>L3BUT01DYJBUU:FDYI
BUX00dYI00E:FTYIBUU:FDYJ00=:F@08BUXLiacW7>M>N@00CWT002=oo`03001oogoo00Ioo`000goo
00<007ooOol0<goo0`006Woo0`0000PLi`00000004^lBma;^doL0QcW01IGg5OMEmaGgEOLEmeGg5OM
Gm`LieoLGmeOg5oMGmaOgEoL7>MS_6OMHkaWg@L001Uoo`0UO012FciJ@U/nFT9K?UXLid9JAUY2FTIJ
@UY6FT9JAUY2FTIJ@UY:FQcWAUY6FDYJAUU6FTIIBUY6FDIJAUU:FTIIAUY6FDYJBUT00QcW01=:NTYI
BWY6FDYjBUU:NTIIBWY:FDYjAUU:NTYIBWY6FDYjBUU:NP037>L024iiBUU>NTYICWT004ij000ROol0
0`00Oomoo`06Ool000=oo`03001oogoo02moo`@002Aoo`h000037>L0000000/0025oo`9l00<nFP05
7>M2FT9J@UY6FP03@UX014IJ@UY2FT9J0QcW0dIJ00E6FDIJAUY6FTII00=6FP03AUU6FTIJ00<Li`03
BUU:FTYI009:F@05BUY:FDYIBUU:FP03BUT01TYJBUU:FDYIBUY:F@8Li`03CWU:NDii009>N@07BWU>
NDii001:NDii00008Woo00<007ooOol01Goo0002Ool00`00Oomoo`0]Ool3000gOol00`00Oomoo`0]
Ool07G`0?UXLid9JAUY2FTIJ@UY6FT9JAUY2FTIJAUTLidIIAUY6FDYJAUU6FTIIBUY6FDIJAUU:FTII
AUX00QcW01=:FDYjAUU:NTYIBWY6FDYjBUU:NTIIBWY:FDYjAUU:NTYIBWY6F@037>L03dYICWY:FDii
BUU>NTYICWU:FDijBUT004YICWX0000QOol00`00Oomoo`05Ool0009oo`03001oogoo02Yoo`<003Yo
o`03001oogoo02ioo`05O012FT9J@UY6FP03@UX00dIJ@UY6FP027>L01DIIAUY6FTIJAUT00dIJ00E6
FDIJAUY6FTII008Li`05BUY:FDYIBUU:FP03BUT01DYJBUU:FDYIBUX00dYI00=:FTYI7>L00QcW00E:
NDiiCWU>NDYi00=>N@05BWU>NDiiCWU:N@02CWT00`00BWT0000QOol00`00Oomoo`05Ool0009oo`03
001oogoo02Moo`<003eoo`03001oogoo02moo`9l0006AUY2FTIJ@UY6FT9J0QcW00e:FTIIAUY6FDYJ
AUU6FTIIBUY6FDIJAUU:NP027>L04DIIBWY:FDYjAUU:NTYIBWY6FDYjBUU:NTIIBWY:FDYjAUT00acW
01I:FDijBUU>NDYICWY:FDiiBUU>NTYICWU:FDijBUU>NDYICWY:F@00BUT0021oo`03001oogoo00Eo
o`000Woo00<007ooOol097oo0`00@7oo00<007ooOol0<Goo0W`000A2FTIJ7>LLi`96FP05AUU6FTIJ
AUY6F@03AUX00dIIAUY:F@027>L2BUT01DYJBUU:FDYIBUX00dYI00I:FTYIBUU:FDYJBUT37>L01DYi
CWU>NDiiBWT00dii00E:NDiiCWU>NDYi00=>N@05BWU>NDiiCWU:N@02CWT00`00BWT0000OOol00`00
Oomoo`05Ool0009oo`03001oogoo021oo`@004=oo`03001oogoo03=oo`0?O00LidIJAUU:FTIIAUY6
FDYJAUU6FTIIBUY6FDYj008Li`0@BUU:NTIIBWY:FDYjAUU:NTYIBWY6FDYjBUU:NTIIBWX27>L06dYI
CWY:FDiiBUU>NTYICWU:FDijBUU>NDYICWY:FDiiBUU>NTYICWU:FDijBUU>NDYICWX000027>L00`00
Oomoo`0LOol00`00Oomoo`05Ool0009oo`03001oogoo01eoo`<004Moo`03001oogoo03Aoo`04O016
FTIJAUT3AUX01DIIAUY6FTIJBUT00QcW00E:FTYIBUU:FDYJ00=:F@05BUY:FDYIBUU:FP02BUT37>L3
CWT01DYiCWU>NDiiBWT00dii00E:NDiiCWU>NDYi00=>N@06BWU>NDiiCWU:NDii11cW00@004iiCWT0
01eoo`03001oogoo00Eoo`000Woo00<007ooOol06Woo0`00BWoo00<007ooOol0=Goo0W`000M6FTII
BUY6FDIJAUU:NP027>L03TIIBWY:FDYjAUU:NTYIBWY6FDYjBUU:NTIIBWX37>L064ijBUU>NDYICWY:
FDiiBUU>NTYICWU:FDijBUU>NDYICWY:FDiiBUU>NTYICWU:F@@Li`09DWU>NE9iCWUBN@00DWU>N@00
01eoo`03001oogoo00Aoo`0000=oo`00Ool06Goo0`00CGoo00<007ooOol0=goo00El04IJAUU6FTYI
008Li`9:F@05BUY:FDYIBUU:FP03BUT00dYJBUU:F@037>L3CWT01DYiCWU>NDiiBWT00dii00E:NDii
CWU>NDYi00=>N@04BWU>NDiiCWT47>L:CWT00`00CWT0000MOol00`00Oomoo`04Ool00003Ool007oo
01Ioo`<0051oo`03001oogoo03Qoo`0@O00LiacW7>M:FDYjAUU:NTYIBWY6FDYjBUU:NTIIBWX37>L0
5dijBUU>NDYICWY:FDiiBUU>NTYICWU:FDijBUU>NDYICWY:FDiiBUU>NTYICWT00acW019BNDiiDWU>
NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWT0059i000LOol00`00Oomoo`04Ool00003Ool007oo019oo`@0
05=oo`03001oogoo03Uoo`03O01:FTYI009:F@05BUY:FDYIBUU:FP03BUT27>L3CWT01DYiCWU>NDii
BWT00dii00E:NDiiCWU>NDYi00=>N@03BWU>NDii00@Lia9>N@04001>NDii000KOol00`00Oomoo`04
Ool00003Ool007oo00moo`<005Moo`03001oogoo03Yoo`09O01:NTIIBWY:FDYjAUU:NTYI00<Li`0D
BUU>NDYICWY:FDiiBUU>NTYICWU:FDijBUU>NDYICWY:FDiiBUU>NP@Li`0KCWUBNDiiDWU>NE9iCWUB
NDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>N@00CWUBN@0001Yoo`03001oogoo00Aoo`0000=o
o`00Ool037oo0`00FWoo00<007ooOol0>Woo00=l04YIBUX00dYI0acW0Tii00E:NDiiCWU>NDYi00=>
N@05BWU>NDiiCWU:N@03CWT00dYi7>LLi`027>LLCWT00`00CWT0000JOol00`00Oomoo`04Ool00003
Ool007oo00Uoo`<005eoo`03001oogoo03]oo`03O01:FDYj008Li`0BBUU>NDYICWY:FDiiBUU>NTYI
CWU:FDijBUU>NDYICWY:FDii11cW02A>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>
NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWT004ii000IOol00`00Oomoo`04Ool00003001oogoo
00Ioo`<0061oo`03001oogoo03aoo`04O00LidiiBWT3CWT01DYiCWU>NDiiBWT00dii00A:NDiiCWU>
N@<Lib=>N@<Li`8001Uoo`03001oogoo00Aoo`0000<007ooOol00Woo1000Hgoo00<007ooOol0?Goo
00il04YICWU:FDijBUU>NDYICWY:FDiiBUU>NTYI11cW021BNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUB
NDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDii1QcW0e9i00=>N00000006Goo00<0
07ooOol00goo00000`00Ool00002001WOol00`00Oomoo`0nOol017`0CWU>NDYi0dii00=:NDii7>L0
0acW7dii1AcW2U9i0P006Goo00<007ooOol00goo0002001ZOol00`00Oomoo`0oOol017`0BUU>NDYI
11cW01eBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDiiDWU>
NE9i00HLi`05CWQBNE9iDWU>N003DWT01DihDWUBNE9iCWP00e9i00<007ooOol05goo00<007ooOol0
0goo00000goo0000001YOol00`00Oomoo`10Ool00g`07>LLi`0LCWT57>LGDWT00`00Oomoo`0FOol0
0`00Oomoo`03Ool000=oo`03001oogoo06Ioo`03001oogoo045oo`0HO01>NE9iCWUBNDiiDWU>NE9i
CWUBNDiiDWU>NE9iCWUBNDiiDWU>NE9iCWUBNDii1QcW00=BNDihDWT00U9i00E>N59iDWUBNDih00=B
N@05CWQBNE9iDWU>N003DWT01DihDWUBNE9iCWP00U9i0P005goo00<007ooOol00goo0004Ool00`00
Oomoo`1UOol00`00Oomoo`11Ool00g`0CWU>N@0?CWT67>LRDWT00`00Ool0000FOol00`00Oomoo`03
Ool000Eoo`8006Eoo`03001oogoo049oo`0<O01BNDiiDWU>NE9iCWUBNDiiDWU>NE9i1AcW0e9i00E>
N59iDWUBNDih00=BN@05CWQBNE9iDWU>N003DWT01DihDWUBNE9iCWP00e9i00E>N59iDWUBNDih00=B
N@06CWQBNE9iDWU>N59i0P005Woo00<007ooOol00goo0007Ool00`00Oomoo`1ROol00`00Oomoo`12
Ool00g`0CWU>N@03CWT67>LXDWT67>L00`00Ool0000FOol00`00Oomoo`02Ool000Qoo`80069oo`03
001oogoo04=oo`03O00LiacW008Li`05CWQBNE9iDWU>N003DWT01DihDWUBNE9iCWP00e9i00E>N59i
DWUBNDih00=BN@05CWQBNE9iDWU>N003DWT01TihDWUBNE9iCWQBN@PLi`07DWUFVE9hEYUBN5JI0000
0Woo00<007ooOol04goo00<007ooOol00Woo000:Ool00`00Oomoo`1OOol00`00Oomoo`14Ool00g`0
DWUBN@0NDWT97>L03eJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYT00003Ool00`00Oomoo`0BOol0
0`00Oomoo`02Ool000]oo`8005ioo`03001oogoo04Eoo`03O01BNDih00=BN@05CWQBNE9iDWU>N003
DWT01DihDWUBNE9iCWP00e9i00=>N59i7>L021cW01UFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h
EYUBN5JIDWQFVE9hEYUBN5JIDWP00003Ool00`00Oomoo`0AOol00`00Oomoo`02Ool000eoo`03001o
ogoo05]oo`03001oogoo04Ioo`03O01BNE9i00aBN@PLi`0REYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:I
EYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJI0003Ool00`00Oomoo`0AOol0
0`00Oomoo`02Ool000ioo`03001oogoo05Yoo`03001oogoo04Ioo`04O01BNE9iCWP2DWT97>L0:U9h
EYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h
EYUBN5JIDWQFVE9hEYUBN5JIDWP000Aoo`03001oogoo011oo`03001oogoo009oo`003goo0P00FWoo
00<007ooOol0Agoo00=l01cW7>L00QcW03=BVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:I
EYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:I
EYUBVEJI00001Goo00<007ooOol03goo00<007ooOol00Woo000AOol00`00Oomoo`1GOol00`00Oomo
o`17Ool0>G`0EYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUB
N5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYT0
0005Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool0019oo`8005Moo`03001oogoo04Qoo`0hO01FVE:I
EYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:I
EYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVEJIDYT000Ioo`03001oogoo00io
o`03001oogoo005oo`0057oo00<007ooOol0E7oo00<007ooOol0B7oo02Yl059hEYUBN5JIDWQFVE9h
EYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9hEYUBN5JIDWQFVE9h
EYUBN5JIDWP=7>L00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`01Ool001Eoo`03001oogoo
05=oo`03001oogoo04Uoo`0>O01BVEJIDYUFVE:IEYUBVEJIDYUFVE:IEYUBVA/Li`eFV@03001oogoo
00Eoo`03001oogoo00eoo`03001oogoo005oo`005Woo0P00Dgoo00<007ooOol0BGoo00=l01cW7>L0
2acW02UFV5ZIEYQFVEJHFYUFV5JIEYQJVEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJVEJHEYUFV5ZIEYQF
VEJHFYUFV5JIEYQJVEJHEYUFV5ZIEYQFV@0000Qoo`03001oogoo00aoo`03001oogoo005oo`0067oo
00<007ooOol0D7oo00<007ooOol0BGoo00=l05JIEYT0<eJI00<007ooOol01goo00<007ooOol02goo
00<007ooOol00Goo000IOol2001@Ool00`00Oomoo`19Ool0=g`0FYUFV5JIEYQJVEJHEYUFV5ZIEYQF
VEJHFYUFV5JIEYQJVEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJVEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJ
VEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJV@0000Yoo`03001oogoo00Yoo`03001oogoo005oo`006goo
00<007ooOol0CGoo00<007ooOol0BWoo00=l05JIEYT0<EJI00<007ooOol02Woo00<007ooOol02Goo
00<007ooOol00Goo000LOol2001=Ool00`00Oomoo`1:Ool0=G`0EYQJVEJHEYUFV5ZIEYQFVEJHFYUF
V5JIEYQJVEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJVEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJVEJHEYUF
V5ZIEYQFVEJHFYUFV5JIEYQJVEJH000037oo00<007ooOol02Woo0@000Goo0Goo000NOol00`00Oomo
o`1:Ool00`00Oomoo`1:Ool00g`0EYUFV@0aEYT00`00Oomoo`0;Ool00`00Oomoo`09Ool10001Ool1
Ool001moo`03001oogoo04Uoo`03001oogoo04Yoo`03O00LiacW01LLi`0KEYUFV5ZIEYQFVEJHFYUF
V5JIEYQJVEJHEYUFV5ZIEYQFVEJHFYUFV5JIEYQJVEJHEYUFV00000ioo`03001oogoo00Qoo`40005o
o`5oo`0087oo0P00BGoo00<007ooOol0I7oo6QcW00<007ooOol03Goo00<007ooOol01goo0@000Goo
0Goo000ROol00`00Oomoo`16Ool00`00Oomoo`2?Ool00`00Oomoo`06Ool10001Ool1Ool002=oo`80
04Ioo`03001oogoo08moo`03001oogoo00Ioo`40005oo`5oo`009Goo00<007ooOol0@goo00<007oo
Ool0T7oo00<007ooOol01Goo0@000Goo0Goo000VOol20013Ool00`00Oomoo`2AOol00`00Oomoo`05
Ool10001Ool002Qoo`03001oogoo041oo`03001oogoo099oo`03001oogoo00Aoo`40005oo`00:Goo
00<007ooOol0?goo00<007ooOol0Tgoo00<007ooOol00goo0@000Goo000ZOol2000oOol00`00Oomo
o`2DOol00`00Oomoo`02Ool10001Ool002aoo`03001oogoo03aoo`03001oogoo09Aoo`03001oogoo
009oo`40005oo`00;Goo0P00?7oo00<007ooOol0UGoo00D007ooOomoo`00005oo`00;goo00<007oo
Ool0>Goo00<007ooOol0UWoo00@007ooOol0005oo`00<7oo00<007ooOol0>7oo00<007ooOol0Ugoo
00<007oo00000Goo000aOol2000gOol00`00Oomoo`2IOol10001Ool1000003=oo`03001oogoo03Ao
o`03001oogoo09Uoo`40005oo`400000=7oo0P00=7oo00<007ooOol0VWoo0P00000fOol00`00Oomo
o`0aOol00`00Oomoo`2IOol3000003Moo`80035oo`03001oogoo09Eoo`@000=oo`00>Goo00<007oo
Ool0;Woo00<007ooOol0T7oo1@001goo000jOol00`00Oomoo`0]Ool00`00Oomoo`2<Ool4000<Ool0
03]oo`8002eoo`03001oogoo08Qoo`@0011oo`00?Goo00<007ooOol0:Woo00<007ooOol0Pgoo1@00
57oo000nOol2000ZOol00`00Oomoo`1oOol4000IOol0041oo`03001oogoo02Moo`03001oogoo07Yo
o`D001eoo`00@Goo00<007ooOol09Woo00<007ooOol0MWoo10008Woo0012Ool2000VOol00`00Oomo
o`1bOol4000VOol004Aoo`03001oogoo02=oo`03001oogoo06eoo`D002Yoo`00AGoo0P008goo00<0
07ooOol0JGoo1000;goo0017Ool00`00Oomoo`0POol00`00Oomoo`1TOol5000cOol004Qoo`80021o
o`03001oogoo061oo`@003Qoo`00BWoo00<007ooOol07Goo00<007ooOol0Fgoo1@00?7oo001;Ool0
0`00Oomoo`0LOol00`00Oomoo`1GOol40011Ool004aoo`8001aoo`03001oogoo05=oo`@004Eoo`00
CWoo00<007ooOol06Goo00<007ooOol0CWoo1@00BGoo001?Ool2000IOol00`00Oomoo`1:Ool4001>
Ool0055oo`03001oogoo01Ioo`03001oogoo04Eoo`D0059oo`00DWoo0P005Woo00<007ooOol0@Goo
1000Egoo001DOol00`00Oomoo`0COol00`00Oomoo`0mOol4001KOol005Eoo`03001oogoo019oo`03
001oogoo03Qoo`D005moo`00EWoo0P004Goo00<007ooOol0=Goo1000I7oo001HOol00`00Oomoo`0>
Ool00`00Oomoo`0`Ool5001XOol005Uoo`8000ioo`03001oogoo02aoo`@006eoo`00Fgoo00<007oo
Ool02goo00<007ooOol09goo1@00LGoo001LOol00`00Oomoo`0:Ool00`00Oomoo`0SOol4001fOol0
05eoo`8000Yoo`03001oogoo01moo`@007Yoo`00Ggoo00<007ooOol01goo00<007ooOol06Woo1@00
OWoo001POol20007Ool00`00Oomoo`0FOol40023Ool0069oo`03001oogoo00Aoo`03001oogoo015o
o`D008Moo`00Hgoo0P0017oo00<007ooOol03Goo1000S7oo001UOol01@00Oomoogoo00002goo1000
T7oo001VOol01000Oomoo`001Woo1@00U7oo001WOol30002Ool4002IOol006Uoo`<009eoo`00
\>"],
  ImageRangeCache->{{{0, 264.313}, {287, 0}} -> {0.0486402, -0.000148683, 
  0.00324458, 0.00324458}}]
}, Open]]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

utput"],

Cell[CellGroupData[{

t, Tau periodic.", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

lse,
  AspectRatioFixed->True],

l stitch if tau is Sin and kappa is 1.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 125; kappa[s_] = 1; tau[s_] := Sin[s]; width = .3; 
    ds = .1; \), 
    \(pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.11022e-016 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.42591 .62314 m .42162 .60783 L .41589 .60061 L .835 .672 .13 r
F
.42591 .62314 m .42199 .62721 L .42162 .60783 L F
.43555 .64579 m .42199 .62721 L .42591 .62314 L .984 .792 .389 r
F
.41589 .60061 m .42126 .58839 L .40577 .57825 L 0 0 .213 r
F
.41589 .60061 m .42162 .60783 L .42126 .58839 L F
0 g
.006 w
.41589 .60061 m
.42174 .61375 L
s
.25 g
.5 Mabswid
.41589 .60061 m
.42162 .60783 L
s
.43555 .64579 m .42228 .64649 L .42199 .62721 L .984 .792 .389 r
F
.25 g
.42199 .62721 m
.42591 .62314 L
s
.44453 .6685 m .42228 .64649 L .43555 .64579 L .996 .798 .519 r
F
0 g
.006 w
.42591 .62314 m
.43555 .64579 L
s
.40577 .57825 m .42094 .56897 L .39583 .55614 L 0 0 .466 r
F
.40577 .57825 m .42126 .58839 L .42094 .56897 L F
0 g
.40577 .57825 m
.41589 .60061 L
s
.25 g
.5 Mabswid
.40577 .57825 m
.42126 .58839 L
s
.44453 .6685 m .42244 .66561 L .42228 .64649 L .996 .798 .519 r
F
.25 g
.42228 .64649 m
.43555 .64579 L
s
.45262 .69119 m .42244 .66561 L .44453 .6685 L .97 .77 .579 r
F
0 g
.006 w
.43555 .64579 m
.44453 .6685 L
s
.39583 .55614 m .42075 .54962 L .38638 .5343 L .148 .145 .597 r
F
.39583 .55614 m .42094 .56897 L .42075 .54962 L F
0 g
.39583 .55614 m
.40577 .57825 L
s
.25 g
.5 Mabswid
.39583 .55614 m
.42094 .56897 L
s
.45262 .69119 m .42237 .68451 L .42244 .66561 L .97 .77 .579 r
F
.25 g
.42244 .66561 m
.44453 .6685 L
s
.45958 .71378 m .42237 .68451 L .45262 .69119 L .938 .737 .605 r
F
0 g
.006 w
.44453 .6685 m
.45262 .69119 L
s
.38638 .5343 m .42076 .53039 L .37769 .51279 L .305 .28 .665 r
F
.38638 .5343 m .42075 .54962 L .42076 .53039 L F
0 g
.38638 .5343 m
.39583 .55614 L
s
.25 g
.5 Mabswid
.38638 .5343 m
.42075 .54962 L
s
.45958 .71378 m .42198 .70309 L .42237 .68451 L .938 .737 .605 r
F
.25 g
.42237 .68451 m
.45262 .69119 L
s
.4652 .73617 m .42198 .70309 L .45958 .71378 L .91 .707 .615 r
F
0 g
.006 w
.45262 .69119 m
.45958 .71378 L
s
.37769 .51279 m .42105 .51135 L .37008 .49165 L .407 .369 .704 r
F
.37769 .51279 m .42076 .53039 L .42105 .51135 L F
0 g
.37769 .51279 m
.38638 .5343 L
s
.25 g
.5 Mabswid
.37769 .51279 m
.42076 .53039 L
s
.4652 .73617 m .42117 .72128 L .42198 .70309 L .91 .707 .615 r
F
.25 g
.42198 .70309 m
.45958 .71378 L
s
.46929 .75827 m .42117 .72128 L .4652 .73617 L .887 .679 .616 r
F
0 g
.006 w
.45958 .71378 m
.4652 .73617 L
s
.37008 .49165 m .42173 .49258 L .36381 .47093 L .476 .432 .729 r
F
.37008 .49165 m .42105 .51135 L .42173 .49258 L F
0 g
.37008 .49165 m
.37769 .51279 L
s
.46929 .75827 m .41982 .73898 L .42117 .72128 L .887 .679 .616 r
F
.25 g
.5 Mabswid
.42117 .72128 m
.4652 .73617 L
s
.47169 .77994 m .41982 .73898 L .46929 .75827 L .869 .655 .611 r
F
0 g
.006 w
.4652 .73617 m
.46929 .75827 L
s
.36381 .47093 m .42294 .47414 L .35917 .45066 L .526 .481 .748 r
F
.36381 .47093 m .42173 .49258 L .42294 .47414 L F
0 g
.36381 .47093 m
.37008 .49165 L
s
.25 g
.5 Mabswid
.36381 .47093 m
.36574 .47165 L
s
.41835 .51031 m
.42105 .51135 L
s
.37008 .49165 m
.41835 .51031 L
s
.47169 .77994 m .41783 .75607 L .41982 .73898 L .869 .655 .611 r
F
.47227 .80107 m .41783 .75607 L .47169 .77994 L .855 .634 .602 r
F
.25 g
.46794 .75774 m
.46929 .75827 L
s
0 g
.006 w
.46929 .75827 m
.47169 .77994 L
s
.35917 .45066 m .4248 .45612 L .35638 .43089 L .564 .52 .764 r
F
.35917 .45066 m .42294 .47414 L .4248 .45612 L F
0 g
.35917 .45066 m
.36381 .47093 L
s
.25 g
.5 Mabswid
.35917 .45066 m
.36132 .45145 L
s
.4182 .49126 m
.42173 .49258 L
s
.36574 .47165 m
.4182 .49126 L
s
.47227 .80107 m .41509 .77243 L .41783 .75607 L .855 .634 .602 r
F
.25 g
.41982 .73898 m
.42286 .74016 L
s
.42286 .74016 m
.46794 .75774 L
s
.47091 .82151 m .41509 .77243 L .47227 .80107 L .845 .615 .591 r
F
.25 g
.47029 .77933 m
.47169 .77994 L
s
0 g
.006 w
.47169 .77994 m
.47227 .80107 L
s
1 0 0 r
.003 w
.42162 .60783 m
.42199 .62721 L
s
.42199 .62721 m
.42228 .64649 L
s
.42126 .58839 m
.42162 .60783 L
s
.42228 .64649 m
.42244 .66561 L
s
.42094 .56897 m
.42126 .58839 L
s
.42237 .68451 m
.42244 .66561 L
s
.42075 .54962 m
.42094 .56897 L
s
.42198 .70309 m
.42237 .68451 L
s
.42075 .54962 m
.42076 .53039 L
s
.42117 .72128 m
.42198 .70309 L
s
.42076 .53039 m
.42105 .51135 L
s
.35638 .43089 m .42748 .43862 L .35568 .41167 L .594 .553 .778 r
F
.35638 .43089 m .4248 .45612 L .42748 .43862 L F
0 g
.006 w
.35638 .43089 m
.35917 .45066 L
s
.25 g
.5 Mabswid
.35638 .43089 m
.35872 .43176 L
s
.41849 .4725 m
.42294 .47414 L
s
.36132 .45145 m
.41849 .4725 L
s
1 0 0 r
.003 w
.42105 .51135 m
.42173 .49258 L
s
.47091 .82151 m .41151 .78793 L .41509 .77243 L .845 .615 .591 r
F
.25 g
.5 Mabswid
.41783 .75607 m
.42215 .75799 L
s
.42215 .75799 m
.47029 .77933 L
s
.46754 .8411 m .41151 .78793 L .47091 .82151 L .839 .599 .577 r
F
.25 g
.47089 .80038 m
.47227 .80107 L
s
0 g
.006 w
.47091 .82151 m
.47227 .80107 L
s
1 0 0 r
.003 w
.41982 .73898 m
.42117 .72128 L
s
.42173 .49258 m
.42294 .47414 L
s
.41783 .75607 m
.41982 .73898 L
s
.42294 .47414 m
.4248 .45612 L
s
.35568 .41167 m .43114 .42173 L .35725 .39305 L .617 .582 .791 r
F
.35568 .41167 m .42748 .43862 L .43114 .42173 L F
0 g
.006 w
.35568 .41167 m
.35638 .43089 L
s
.25 g
.5 Mabswid
.35568 .41167 m
.35818 .41261 L
s
.35818 .41261 m
.42748 .43862 L
s
.41936 .45411 m
.4248 .45612 L
s
.35872 .43176 m
.41936 .45411 L
s
1 0 0 r
.003 w
.41509 .77243 m
.41783 .75607 L
s
.46754 .8411 m .40703 .80242 L .41151 .78793 L .839 .599 .577 r
F
.25 g
.5 Mabswid
.41509 .77243 m
.42137 .77558 L
s
.42137 .77558 m
.47089 .80038 L
s
.46209 .85966 m .40703 .80242 L .46754 .8411 L .836 .587 .561 r
F
.25 g
.41151 .78793 m
.46967 .82081 L
s
.46967 .82081 m
.47091 .82151 L
s
0 g
.006 w
.46754 .8411 m
.47091 .82151 L
s
1 0 0 r
.003 w
.4248 .45612 m
.42748 .43862 L
s
.41151 .78793 m
.41509 .77243 L
s
.35725 .39305 m .43593 .40556 L .36125 .37509 L .636 .608 .804 r
F
.35725 .39305 m .43114 .42173 L .43593 .40556 L F
0 g
.006 w
.35568 .41167 m
.35725 .39305 L
s
.25 g
.5 Mabswid
.35725 .39305 m
.43114 .42173 L
s
1 0 0 r
.003 w
.42748 .43862 m
.43114 .42173 L
s
.46209 .85966 m .40159 .81574 L .40703 .80242 L .836 .587 .561 r
F
1 0 0 r
.40703 .80242 m
.41151 .78793 L
s
.45456 .87702 m .40159 .81574 L .46209 .85966 L .838 .578 .545 r
F
.25 g
.5 Mabswid
.40703 .80242 m
.46668 .84055 L
s
.46668 .84055 m
.46754 .8411 L
s
0 g
.006 w
.46209 .85966 m
.46754 .8411 L
s
.36125 .37509 m .43593 .40556 L .44199 .39022 L .651 .631 .818 r
F
1 0 0 r
.003 w
.43114 .42173 m
.43593 .40556 L
s
.36125 .37509 m .44199 .39022 L .36779 .35786 L .651 .631 .818 r
F
0 g
.006 w
.35725 .39305 m
.36125 .37509 L
s
.25 g
.5 Mabswid
.36125 .37509 m
.43593 .40556 L
s
.45456 .87702 m .3952 .82775 L .40159 .81574 L .838 .578 .545 r
F
1 0 0 r
.003 w
.40159 .81574 m
.40703 .80242 L
s
.44496 .89297 m .3952 .82775 L .45456 .87702 L .844 .573 .529 r
F
.25 g
.5 Mabswid
.40159 .81574 m
.46209 .85966 L
s
0 g
.006 w
.45456 .87702 m
.46209 .85966 L
s
.36779 .35786 m .44199 .39022 L .44944 .37582 L .661 .653 .832 r
F
1 0 0 r
.003 w
.43593 .40556 m
.44199 .39022 L
s
.36779 .35786 m .44944 .37582 L .37694 .34142 L .661 .653 .832 r
F
0 g
.006 w
.36125 .37509 m
.36779 .35786 L
s
.25 g
.5 Mabswid
.36779 .35786 m
.44199 .39022 L
s
.37694 .34142 m .44944 .37582 L .45837 .36248 L .668 .673 .846 r
F
1 0 0 r
.003 w
.44199 .39022 m
.44944 .37582 L
s
.44496 .89297 m .38788 .83831 L .3952 .82775 L .844 .573 .529 r
F
1 0 0 r
.3952 .82775 m
.40159 .81574 L
s
.25 g
.5 Mabswid
.3952 .82775 m
.45456 .87702 L
s
.43335 .90731 m .38788 .83831 L .44496 .89297 L .853 .573 .513 r
F
0 g
.006 w
.44496 .89297 m
.45456 .87702 L
s
.38873 .32587 m .45837 .36248 L .46883 .35033 L .67 .69 .86 r
F
.25 g
.5 Mabswid
.43665 .36975 m
.44944 .37582 L
s
.37694 .34142 m .45837 .36248 L .38873 .32587 L .668 .673 .846 r
F
.25 g
.37694 .34142 m
.43665 .36975 L
s
1 0 0 r
.003 w
.44944 .37582 m
.45837 .36248 L
s
0 g
.006 w
.36779 .35786 m
.37694 .34142 L
s
.43335 .90731 m .3797 .84728 L .38788 .83831 L .853 .573 .513 r
F
1 0 0 r
.003 w
.38788 .83831 m
.3952 .82775 L
s
.25 g
.5 Mabswid
.38788 .83831 m
.44496 .89297 L
s
.40314 .31129 m .46883 .35033 L .48082 .33947 L .668 .704 .874 r
F
.25 g
.44263 .35421 m
.45837 .36248 L
s
.38873 .32587 m .46883 .35033 L .40314 .31129 L .67 .69 .86 r
F
1 0 0 r
.003 w
.45837 .36248 m
.46883 .35033 L
s
0 g
.006 w
.37694 .34142 m
.38873 .32587 L
s
.25 g
.5 Mabswid
.38873 .32587 m
.3915 .32732 L
s
.41981 .91982 m .3797 .84728 L .43335 .90731 L .866 .579 .501 r
F
0 g
.006 w
.43335 .90731 m
.44496 .89297 L
s
.41981 .91982 m .37078 .85454 L .3797 .84728 L .866 .579 .501 r
F
1 0 0 r
.003 w
.3797 .84728 m
.38788 .83831 L
s
.25 g
.5 Mabswid
.3797 .84728 m
.43335 .90731 L
s
.4201 .29779 m .48082 .33947 L .49431 .33002 L .662 .714 .887 r
F
.25 g
.44807 .33799 m
.46883 .35033 L
s
.4285 .34678 m
.44263 .35421 L
s
.40314 .31129 m .48082 .33947 L .4201 .29779 L .668 .704 .874 r
F
.25 g
.3915 .32732 m
.4285 .34678 L
s
1 0 0 r
.003 w
.46883 .35033 m
.48082 .33947 L
s
.25 g
.5 Mabswid
.40314 .31129 m
.40589 .31293 L
s
0 g
.006 w
.38873 .32587 m
.40314 .31129 L
s
.4045 .9303 m .37078 .85454 L .41981 .91982 L .882 .593 .493 r
F
0 g
.41981 .91982 m
.43335 .90731 L
s
.4045 .9303 m .36125 .86001 L .37078 .85454 L .882 .593 .493 r
F
1 0 0 r
.003 w
.37078 .85454 m
.3797 .84728 L
s
.25 g
.5 Mabswid
.37078 .85454 m
.41981 .91982 L
s
.43949 .28549 m .49431 .33002 L .5092 .32208 L .651 .719 .898 r
F
.4201 .29779 m .49431 .33002 L .43949 .28549 L .662 .714 .887 r
F
.25 g
.40589 .31293 m
.42548 .32457 L
s
.42548 .32457 m
.44807 .33799 L
s
1 0 0 r
.003 w
.48082 .33947 m
.49431 .33002 L
s
.25 g
.5 Mabswid
.4201 .29779 m
.42304 .29981 L
s
.89561 .52453 m .87046 .54056 L .89765 .55159 L .942 .619 .395 r
F
.89561 .52453 m .86273 .52167 L .87046 .54056 L F
.89232 .49755 m .86273 .52167 L .89561 .52453 L .909 .608 .463 r
F
.89232 .49755 m .85376 .50303 L .86273 .52167 L F
.25 g
.86273 .52167 m
.89561 .52453 L
s
.88758 .47086 m .85376 .50303 L .89232 .49755 L .872 .595 .515 r
F
0 g
.006 w
.89232 .49755 m
.89561 .52453 L
s
.89765 .55159 m .87696 .55956 L .89863 .57852 L .961 .626 .309 r
F
.89765 .55159 m .87046 .54056 L .87696 .55956 L F
0 g
.89561 .52453 m
.89765 .55159 L
s
.25 g
.5 Mabswid
.87046 .54056 m
.89765 .55159 L
s
.88758 .47086 m .84359 .48477 L .85376 .50303 L .872 .595 .515 r
F
.25 g
.85376 .50303 m
.89232 .49755 L
s
.88121 .44471 m .84359 .48477 L .88758 .47086 L .838 .585 .556 r
F
0 g
.006 w
.88758 .47086 m
.89232 .49755 L
s
.43949 .28549 m .5092 .32208 L .46115 .2745 L .651 .719 .898 r
F
.4549 .27644 m .49561 .32669 L .51288 .32055 L .659 .724 .897 r
F
1 0 0 r
.003 w
.49431 .33002 m
.5092 .32208 L
s
.25 g
.5 Mabswid
.44826 .31712 m
.48082 .33947 L
s
.89863 .57852 m .88225 .5785 L .89873 .60511 L .951 .621 .209 r
F
.89863 .57852 m .87696 .55956 L .88225 .5785 L F
0 g
.006 w
.89765 .55159 m
.89863 .57852 L
s
.88121 .44471 m .83224 .46701 L .84359 .48477 L .838 .585 .556 r
F
.25 g
.5 Mabswid
.84359 .48477 m
.88758 .47086 L
s
.87305 .41932 m .83224 .46701 L .88121 .44471 L .807 .577 .589 r
F
0 g
.006 w
.88121 .44471 m
.88758 .47086 L
s
.25 g
.5 Mabswid
.50904 .32192 m
.5092 .32208 L
s
.43949 .28549 m
.44256 .28798 L
s
.42304 .29981 m
.44826 .31712 L
s
0 g
.006 w
.40314 .31129 m
.4201 .29779 L
s
.89873 .60511 m .88636 .59719 L .89813 .63115 L .907 .602 .11 r
F
.89873 .60511 m .88225 .5785 L .88636 .59719 L F
0 g
.89863 .57852 m
.89873 .60511 L
s
.25 g
.5 Mabswid
.89814 .60415 m
.89873 .60511 L
s
.8798 .56204 m
.89863 .57852 L
s
.87696 .55956 m
.8798 .56204 L
s
.48029 .26668 m .51288 .32055 L .53113 .31612 L .647 .715 .898 r
F
.4549 .27644 m .51288 .32055 L .48029 .26668 L .659 .724 .897 r
F
.25 g
.48499 .31358 m
.49561 .32669 L
s
1 0 0 r
.003 w
.49561 .32669 m
.51288 .32055 L
s
.87305 .41932 m .81979 .44984 L .83224 .46701 L .807 .577 .589 r
F
.86295 .39492 m .81979 .44984 L .87305 .41932 L .78 .571 .617 r
F
.25 g
.5 Mabswid
.87959 .44545 m
.88121 .44471 L
s
0 g
.006 w
.87305 .41932 m
.88121 .44471 L
s
.38758 .93853 m .36125 .86001 L .4045 .9303 L .9 .613 .491 r
F
0 g
.4045 .9303 m
.41981 .91982 L
s
.38758 .93853 m .35128 .86363 L .36125 .86001 L .9 .613 .491 r
F
1 0 0 r
.003 w
.36125 .86001 m
.37078 .85454 L
s
.25 g
.5 Mabswid
.36125 .86001 m
.4045 .9303 L
s
.89813 .63115 m .88933 .61544 L .89699 .65646 L .841 .578 .034 r
F
.89813 .63115 m .88636 .59719 L .88933 .61544 L F
0 g
.006 w
.89813 .63115 m
.89873 .60511 L
s
.25 g
.5 Mabswid
.89769 .62989 m
.89813 .63115 L
s
.88483 .58266 m
.89814 .60415 L
s
.88225 .5785 m
.88483 .58266 L
s
.50717 .25861 m .53113 .31612 L .55016 .31343 L .636 .701 .893 r
F
.48029 .26668 m .53113 .31612 L .50717 .25861 L .647 .715 .898 r
F
1 0 0 r
.003 w
.51288 .32055 m
.53113 .31612 L
s
.25 g
.5 Mabswid
.48029 .26668 m
.48312 .27135 L
s
.48312 .27135 m
.48347 .27193 L
s
.44256 .28798 m
.49431 .33002 L
s
.4549 .27644 m
.48499 .31358 L
s
.86295 .39492 m .80629 .43333 L .81979 .44984 L .78 .571 .617 r
F
.25 g
.81979 .44984 m
.82271 .44816 L
s
.83224 .46701 m
.87959 .44545 L
s
.85079 .37174 m .80629 .43333 L .86295 .39492 L .756 .567 .642 r
F
.25 g
.8713 .42032 m
.87305 .41932 L
s
0 g
.006 w
.86295 .39492 m
.87305 .41932 L
s
.5352 .25238 m .55016 .31343 L .56976 .3125 L .627 .684 .884 r
F
.50717 .25861 m .55016 .31343 L .5352 .25238 L .636 .701 .893 r
F
1 0 0 r
.003 w
.53113 .31612 m
.55016 .31343 L
s
.25 g
.5 Mabswid
.50717 .25861 m
.50758 .2596 L
s
.50758 .2596 m
.5131 .27285 L
s
.5131 .27285 m
.53113 .31612 L
s
.48347 .27193 m
.51288 .32055 L
s
0 g
.006 w
.4201 .29779 m
.43949 .28549 L
s
.85079 .37174 m .79182 .41755 L .80629 .43333 L .756 .567 .642 r
F
.25 g
.5 Mabswid
.80629 .43333 m
.80894 .43153 L
s
.82271 .44816 m
.8713 .42032 L
s
.8365 .35001 m .79182 .41755 L .85079 .37174 L .734 .566 .664 r
F
.25 g
.8611 .39617 m
.86295 .39492 L
s
0 g
.006 w
.85079 .37174 m
.86295 .39492 L
s
.89699 .65646 m .89122 .63307 L .89547 .68084 L .781 .566 0 r
F
.89699 .65646 m .88933 .61544 L .89122 .63307 L F
0 g
.89699 .65646 m
.89813 .63115 L
s
.25 g
.5 Mabswid
.8967 .65488 m
.89699 .65646 L
s
.88863 .60374 m
.89769 .62989 L
s
.88636 .59719 m
.88863 .60374 L
s
.3693 .94432 m .35128 .86363 L .38758 .93853 L .919 .641 .497 r
F
0 g
.006 w
.38758 .93853 m
.4045 .9303 L
s
.3693 .94432 m .34107 .86537 L .35128 .86363 L .919 .641 .497 r
F
1 0 0 r
.003 w
.35128 .86363 m
.36125 .86001 L
s
.25 g
.5 Mabswid
.35128 .86363 m
.38758 .93853 L
s
.56403 .24813 m .56976 .3125 L .58971 .31333 L .623 .666 .871 r
F
.5352 .25238 m .56976 .3125 L .56403 .24813 L .627 .684 .884 r
F
1 0 0 r
.003 w
.55016 .31343 m
.56976 .3125 L
s
.25 g
.5 Mabswid
.5352 .25238 m
.55016 .31343 L
s
.5933 .24598 m .58971 .31333 L .60983 .31589 L .622 .648 .855 r
F
.56403 .24813 m .58971 .31333 L .5933 .24598 L .623 .666 .871 r
F
1 0 0 r
.003 w
.56976 .3125 m
.58971 .31333 L
s
.25 g
.5 Mabswid
.56403 .24813 m
.56976 .3125 L
s
.8365 .35001 m .77647 .40256 L .79182 .41755 L .734 .566 .664 r
F
.25 g
.79182 .41755 m
.79414 .41574 L
s
.82004 .32993 m .77647 .40256 L .8365 .35001 L .716 .566 .684 r
F
.25 g
.84888 .37323 m
.85079 .37174 L
s
0 g
.006 w
.8365 .35001 m
.85079 .37174 L
s
.62265 .24603 m .60983 .31589 L .62994 .32011 L .624 .631 .838 r
F
.5933 .24598 m .60983 .31589 L .62265 .24603 L .622 .648 .855 r
F
1 0 0 r
.003 w
.58971 .31333 m
.60983 .31589 L
s
.25 g
.5 Mabswid
.58971 .31333 m
.5933 .24598 L
s
.89547 .68084 m .89207 .64987 L .89368 .70409 L .749 .575 0 r
F
.89547 .68084 m .89122 .63307 L .89207 .64987 L F
.25 g
.88933 .61544 m
.89125 .62575 L
s
0 g
.006 w
.89547 .68084 m
.89699 .65646 L
s
.25 g
.5 Mabswid
.89529 .67889 m
.89547 .68084 L
s
.65169 .24838 m .62994 .32011 L .64988 .32591 L .629 .616 .819 r
F
.62265 .24603 m .62994 .32011 L .65169 .24838 L .624 .631 .838 r
F
1 0 0 r
.003 w
.60983 .31589 m
.62994 .32011 L
s
.25 g
.5 Mabswid
.60983 .31589 m
.62265 .24603 L
s
0 g
.006 w
.43949 .28549 m
.45561 .27731 L
s
.82004 .32993 m .7603 .38842 L .77647 .40256 L .716 .566 .684 r
F
.25 g
.5 Mabswid
.77647 .40256 m
.78022 .39928 L
s
.80894 .43153 m
.8611 .39617 L
s
.80141 .3117 m .7603 .38842 L .82004 .32993 L .699 .568 .704 r
F
.25 g
.83456 .35171 m
.8365 .35001 L
s
0 g
.006 w
.82004 .32993 m
.8365 .35001 L
s
.68007 .25308 m .64988 .32591 L .66953 .3332 L .636 .603 .799 r
F
.65169 .24838 m .64988 .32591 L .68007 .25308 L .629 .616 .819 r
F
.25 g
.5 Mabswid
.62994 .32011 m
.65169 .24838 L
s
1 0 0 r
.003 w
.62994 .32011 m
.64988 .32591 L
s
.34992 .94748 m .34107 .86537 L .3693 .94432 L .937 .674 .513 r
F
0 g
.006 w
.3693 .94432 m
.38758 .93853 L
s
.34992 .94748 m .33081 .86524 L .34107 .86537 L .937 .674 .513 r
F
1 0 0 r
.003 w
.34107 .86537 m
.35128 .86363 L
s
.25 g
.5 Mabswid
.34107 .86537 m
.3693 .94432 L
s
.70744 .26016 m .66953 .3332 L .68879 .34188 L .646 .592 .78 r
F
.68007 .25308 m .66953 .3332 L .70744 .26016 L .636 .603 .799 r
F
.25 g
.64988 .32591 m
.67915 .25528 L
s
1 0 0 r
.003 w
.64988 .32591 m
.66953 .3332 L
s
.25 g
.5 Mabswid
.67915 .25528 m
.68007 .25308 L
s
.73351 .26962 m .68879 .34188 L .70756 .35184 L .657 .583 .76 r
F
.70744 .26016 m .68879 .34188 L .73351 .26962 L .646 .592 .78 r
F
.25 g
.66953 .3332 m
.70628 .26241 L
s
1 0 0 r
.003 w
.66953 .3332 m
.68879 .34188 L
s
.25 g
.5 Mabswid
.70628 .26241 m
.70744 .26016 L
s
.75801 .28142 m .70756 .35184 L .72578 .36298 L .67 .576 .742 r
F
.73351 .26962 m .70756 .35184 L .75801 .28142 L .657 .583 .76 r
F
1 0 0 r
.003 w
.68879 .34188 m
.70756 .35184 L
s
.25 g
.5 Mabswid
.73212 .27187 m
.73351 .26962 L
s
.7807 .29548 m .72578 .36298 L .74338 .3752 L .683 .571 .723 r
F
.25 g
.70756 .35184 m
.7077 .35165 L
s
.68879 .34188 m
.68914 .34132 L
s
.75801 .28142 m .72578 .36298 L .7807 .29548 L .67 .576 .742 r
F
.25 g
.81815 .33178 m
.82004 .32993 L
s
.68914 .34132 m
.73212 .27187 L
s
1 0 0 r
.003 w
.70756 .35184 m
.72578 .36298 L
s
.25 g
.5 Mabswid
.72578 .36298 m
.72906 .35895 L
s
.75642 .28364 m
.75801 .28142 L
s
.80141 .3117 m .74338 .3752 L .7603 .38842 L .699 .568 .704 r
F
.25 g
.7077 .35165 m
.70853 .35049 L
s
.7603 .38842 m
.76338 .3854 L
s
.7807 .29548 m .74338 .3752 L .80141 .3117 L .683 .571 .723 r
F
.25 g
.79414 .41574 m
.84888 .37323 L
s
0 g
.006 w
.80141 .3117 m
.82004 .32993 L
s
.25 g
.5 Mabswid
.78022 .39928 m
.83456 .35171 L
s
.76338 .3854 m
.81812 .33181 L
s
.81812 .33181 m
.81815 .33178 L
s
.70853 .35049 m
.75642 .28364 L
s
.72906 .35895 m
.77895 .29763 L
s
1 0 0 r
.003 w
.72578 .36298 m
.74338 .3752 L
s
.25 g
.5 Mabswid
.74766 .37051 m
.79956 .31373 L
s
.79956 .31373 m
.7996 .31368 L
s
.7996 .31368 m
.80141 .3117 L
s
.74338 .3752 m
.74766 .37051 L
s
.77901 .29756 m
.7807 .29548 L
s
.77895 .29763 m
.77901 .29756 L
s
1 0 0 r
.003 w
.74338 .3752 m
.7603 .38842 L
s
.7603 .38842 m
.77647 .40256 L
s
0 g
.006 w
.7807 .29548 m
.80141 .3117 L
s
1 0 0 r
.003 w
.77647 .40256 m
.79182 .41755 L
s
.79182 .41755 m
.80629 .43333 L
s
.89368 .70409 m .89194 .66566 L .89173 .72604 L .752 .61 .041 r
F
.89368 .70409 m .89207 .64987 L .89194 .66566 L F
.25 g
.5 Mabswid
.89275 .65035 m
.89529 .67889 L
s
.89122 .63307 m
.89275 .65035 L
s
0 g
.006 w
.89368 .70409 m
.89547 .68084 L
s
.25 g
.5 Mabswid
.89207 .64987 m
.8936 .70151 L
s
.8936 .70151 m
.89368 .70409 L
s
.89301 .63513 m
.8967 .65488 L
s
.89125 .62575 m
.89301 .63513 L
s
1 0 0 r
.003 w
.80629 .43333 m
.81979 .44984 L
s
.81979 .44984 m
.83224 .46701 L
s
.83224 .46701 m
.84359 .48477 L
s
0 g
.006 w
.4549 .27644 m
.48029 .26668 L
s
1 0 0 r
.003 w
.84359 .48477 m
.85376 .50303 L
s
.85376 .50303 m
.86273 .52167 L
s
0 g
.006 w
.75801 .28142 m
.7807 .29548 L
s
.32976 .94788 m .33081 .86524 L .34992 .94748 L .952 .712 .538 r
F
0 g
.34992 .94748 m
.3693 .94432 L
s
.32976 .94788 m .32072 .8633 L .33081 .86524 L .952 .712 .538 r
F
1 0 0 r
.003 w
.33081 .86524 m
.34107 .86537 L
s
.25 g
.5 Mabswid
.33081 .86524 m
.34992 .94748 L
s
1 0 0 r
.003 w
.86273 .52167 m
.87046 .54056 L
s
.87046 .54056 m
.87696 .55956 L
s
0 g
.006 w
.48029 .26668 m
.50717 .25861 L
s
.73351 .26962 m
.75801 .28142 L
s
.89173 .72604 m .89087 .68027 L .88971 .74649 L .788 .665 .114 r
F
.89173 .72604 m .89194 .66566 L .89087 .68027 L F
0 g
.89173 .72604 m
.89368 .70409 L
s
.25 g
.5 Mabswid
.89173 .72604 m
.89174 .72264 L
s
.89174 .72264 m
.89194 .66566 L
s
1 0 0 r
.003 w
.87696 .55956 m
.88225 .5785 L
s
0 g
.006 w
.70744 .26016 m
.73351 .26962 L
s
.50717 .25861 m
.5352 .25238 L
s
1 0 0 r
.003 w
.88225 .5785 m
.88636 .59719 L
s
.30918 .9454 m .32072 .8633 L .32976 .94788 L .963 .752 .571 r
F
0 g
.006 w
.32976 .94788 m
.34992 .94748 L
s
.30918 .9454 m .31099 .85963 L .32072 .8633 L .963 .752 .571 r
F
1 0 0 r
.003 w
.32072 .8633 m
.33081 .86524 L
s
.25 g
.5 Mabswid
.32072 .8633 m
.32976 .94788 L
s
0 g
.006 w
.68007 .25308 m
.70744 .26016 L
s
.5352 .25238 m
.56403 .24813 L
s
1 0 0 r
.003 w
.88636 .59719 m
.88933 .61544 L
s
0 g
.006 w
.65169 .24838 m
.68007 .25308 L
s
.56403 .24813 m
.5933 .24598 L
s
.88971 .74649 m .88887 .69355 L .88766 .76525 L .846 .731 .207 r
F
.88971 .74649 m .89087 .68027 L .88887 .69355 L F
0 g
.88971 .74649 m
.89173 .72604 L
s
.25 g
.5 Mabswid
.88971 .74649 m
.89087 .68027 L
s
0 g
.006 w
.62265 .24603 m
.65169 .24838 L
s
.5933 .24598 m
.62265 .24603 L
s
1 0 0 r
.003 w
.88933 .61544 m
.89122 .63307 L
s
.28854 .93997 m .31099 .85963 L .30918 .9454 L .967 .79 .612 r
F
.28854 .93997 m .3018 .85434 L .31099 .85963 L F
1 0 0 r
.31099 .85963 m
.32072 .8633 L
s
.25 g
.5 Mabswid
.30918 .9454 m
.31099 .85963 L
s
0 g
.006 w
.30918 .9454 m
.32976 .94788 L
s
1 0 0 r
.003 w
.89122 .63307 m
.89207 .64987 L
s
.88766 .76525 m .88596 .70536 L .88561 .78212 L .909 .789 .307 r
F
.88766 .76525 m .88887 .69355 L .88596 .70536 L F
0 g
.006 w
.88766 .76525 m
.88971 .74649 L
s
.25 g
.5 Mabswid
.88766 .76525 m
.88887 .69355 L
s
.26828 .93158 m .3018 .85434 L .28854 .93997 L .964 .825 .658 r
F
.26828 .93158 m .2933 .84757 L .3018 .85434 L F
1 0 0 r
.003 w
.3018 .85434 m
.31099 .85963 L
s
.89194 .66566 m
.89207 .64987 L
s
0 g
.006 w
.28854 .93997 m
.30918 .9454 L
s
1 0 0 r
.003 w
.89087 .68027 m
.89194 .66566 L
s
.24879 .92028 m .2933 .84757 L .26828 .93158 L .953 .853 .705 r
F
.25 g
.5 Mabswid
.28854 .93997 m
.28901 .93696 L
s
.24879 .92028 m .28562 .83946 L .2933 .84757 L .953 .853 .705 r
F
.25 g
.28901 .93696 m
.3018 .85434 L
s
1 0 0 r
.003 w
.2933 .84757 m
.3018 .85434 L
s
.25 g
.5 Mabswid
.2915 .85361 m
.2933 .84757 L
s
.88561 .78212 m .88215 .71562 L .88358 .7969 L .959 .826 .396 r
F
.88561 .78212 m .88596 .70536 L .88215 .71562 L F
0 g
.006 w
.88561 .78212 m
.88766 .76525 L
s
.25 g
.5 Mabswid
.88561 .78212 m
.88596 .70536 L
s
0 g
.006 w
.26828 .93158 m
.28854 .93997 L
s
1 0 0 r
.003 w
.88887 .69355 m
.89087 .68027 L
s
.23051 .90615 m .28562 .83946 L .24879 .92028 L .935 .874 .752 r
F
.25 g
.5 Mabswid
.26828 .93158 m
.26915 .92866 L
s
.23051 .90615 m .27886 .83018 L .28562 .83946 L .935 .874 .752 r
F
.25 g
.26915 .92866 m
.2915 .85361 L
s
1 0 0 r
.003 w
.28562 .83946 m
.2933 .84757 L
s
.25 g
.5 Mabswid
.28331 .84453 m
.28562 .83946 L
s
1 0 0 r
.003 w
.88596 .70536 m
.88887 .69355 L
s
0 g
.006 w
.24879 .92028 m
.26828 .93158 L
s
.88358 .7969 m .8774 .72424 L .88151 .8094 L .989 .837 .462 r
F
.88358 .7969 m .88215 .71562 L .8774 .72424 L F
0 g
.88358 .7969 m
.88561 .78212 L
s
.25 g
.5 Mabswid
.88215 .71562 m
.88358 .7969 L
s
.21383 .88938 m .27886 .83018 L .23051 .90615 L .911 .885 .795 r
F
.25 g
.24879 .92028 m
.25006 .9175 L
s
.21383 .88938 m .27311 .81986 L .27886 .83018 L .911 .885 .795 r
F
.25 g
.25006 .9175 m
.28331 .84453 L
s
1 0 0 r
.003 w
.27886 .83018 m
.28562 .83946 L
s
.25 g
.5 Mabswid
.27623 .83432 m
.27886 .83018 L
s
1 0 0 r
.003 w
.88215 .71562 m
.88596 .70536 L
s
0 g
.006 w
.23051 .90615 m
.24879 .92028 L
s
.19914 .87018 m .27311 .81986 L .21383 .88938 L .881 .888 .833 r
F
.25 g
.5 Mabswid
.23051 .90615 m
.23215 .90357 L
s
.19914 .87018 m .26841 .80865 L .27311 .81986 L .881 .888 .833 r
F
.25 g
.23215 .90357 m
.27623 .83432 L
s
1 0 0 r
.003 w
.27311 .81986 m
.27886 .83018 L
s
.25 g
.5 Mabswid
.27033 .82312 m
.27311 .81986 L
s
.88151 .8094 m .87171 .73121 L .87936 .81943 L 1 .826 .502 r
F
.88151 .8094 m .8774 .72424 L .87171 .73121 L F
0 g
.006 w
.88151 .8094 m
.88358 .7969 L
s
.25 g
.5 Mabswid
.8774 .72424 m
.88151 .8094 L
s
1 0 0 r
.003 w
.8774 .72424 m
.88215 .71562 L
s
0 g
.006 w
.21383 .88938 m
.23051 .90615 L
s
.18678 .84883 m .26841 .80865 L .19914 .87018 L .847 .882 .865 r
F
.25 g
.5 Mabswid
.21383 .88938 m
.21583 .88704 L
s
.18678 .84883 m .26483 .79668 L .26841 .80865 L .847 .882 .865 r
F
.25 g
.21583 .88704 m
.27033 .82312 L
s
1 0 0 r
.003 w
.26841 .80865 m
.27311 .81986 L
s
.25 g
.5 Mabswid
.26567 .81109 m
.26841 .80865 L
s
0 g
.006 w
.19914 .87018 m
.21383 .88938 L
s
.87936 .81943 m .86504 .73651 L .87702 .82679 L .997 .798 .517 r
F
.87936 .81943 m .87171 .73121 L .86504 .73651 L F
0 g
.87936 .81943 m
.88151 .8094 L
s
.25 g
.5 Mabswid
.87171 .73121 m
.87936 .81943 L
s
1 0 0 r
.003 w
.87171 .73121 m
.8774 .72424 L
s
.17705 .82566 m .26483 .79668 L .18678 .84883 L .81 .868 .89 r
F
.25 g
.5 Mabswid
.19914 .87018 m
.20145 .86813 L
s
.17705 .82566 m .26242 .78407 L .26483 .79668 L .81 .868 .89 r
F
.25 g
.20145 .86813 m
.26567 .81109 L
s
1 0 0 r
.003 w
.26483 .79668 m
.26841 .80865 L
s
.25 g
.5 Mabswid
.26228 .79839 m
.26483 .79668 L
s
0 g
.006 w
.18678 .84883 m
.19914 .87018 L
s
.17018 .80103 m .26242 .78407 L .17705 .82566 L .772 .847 .908 r
F
.25 g
.5 Mabswid
.18678 .84883 m
.18935 .84711 L
s
.17018 .80103 m .26122 .77091 L .26242 .78407 L .772 .847 .908 r
F
.25 g
.18935 .84711 m
.26228 .79839 L
s
1 0 0 r
.003 w
.26242 .78407 m
.26483 .79668 L
s
.25 g
.5 Mabswid
.26022 .78514 m
.26242 .78407 L
s
.87702 .82679 m .85737 .74017 L .87437 .83132 L .986 .762 .513 r
F
.87702 .82679 m .86504 .73651 L .85737 .74017 L F
0 g
.006 w
.87702 .82679 m
.87936 .81943 L
s
.25 g
.5 Mabswid
.86504 .73651 m
.87702 .82679 L
s
1 0 0 r
.003 w
.86504 .73651 m
.87171 .73121 L
s
0 g
.006 w
.17705 .82566 m
.18678 .84883 L
s
.16638 .77532 m .26122 .77091 L .17018 .80103 L .733 .82 .918 r
F
.25 g
.5 Mabswid
.17705 .82566 m
.17983 .8243 L
s
.17983 .8243 m
.26022 .78514 L
s
.16638 .77532 m .26132 .75733 L .26122 .77091 L .733 .82 .918 r
F
1 0 0 r
.003 w
.26122 .77091 m
.26242 .78407 L
s
.25 g
.5 Mabswid
.25951 .77148 m
.26122 .77091 L
s
0 g
.006 w
.17018 .80103 m
.17705 .82566 L
s
.87437 .83132 m .85737 .74017 L .84868 .74226 L .972 .72 .494 r
F
1 0 0 r
.003 w
.85737 .74017 m
.86504 .73651 L
s
.87437 .83132 m .84868 .74226 L .87126 .83287 L .972 .72 .494 r
F
0 g
.006 w
.87437 .83132 m
.87702 .82679 L
s
.25 g
.5 Mabswid
.85737 .74017 m
.87437 .83132 L
s
.16576 .74895 m .26132 .75733 L .16638 .77532 L .696 .788 .922 r
F
.25 g
.16638 .77532 m
.26021 .75754 L
s
.17018 .80103 m
.17312 .80005 L
s
.17312 .80005 m
.25951 .77148 L
s
.16576 .74895 m .26278 .74342 L .26132 .75733 L .696 .788 .922 r
F
1 0 0 r
.003 w
.26122 .77091 m
.26132 .75733 L
s
.25 g
.5 Mabswid
.26021 .75754 m
.26132 .75733 L
s
0 g
.006 w
.16638 .77532 m
.17018 .80103 L
s
.87126 .83287 m .84868 .74226 L .83894 .74285 L .955 .673 .461 r
F
1 0 0 r
.003 w
.84868 .74226 m
.85737 .74017 L
s
.16839 .72232 m .26278 .74342 L .16576 .74895 L .66 .753 .919 r
F
0 g
.006 w
.16576 .74895 m
.16638 .77532 L
s
.16839 .72232 m .26569 .72931 L .26278 .74342 L .66 .753 .919 r
F
1 0 0 r
.003 w
.26132 .75733 m
.26278 .74342 L
s
.25 g
.5 Mabswid
.16576 .74895 m
.26278 .74342 L
s
.8675 .83134 m .83894 .74285 L .82815 .74204 L .937 .621 .414 r
F
.87126 .83287 m .83894 .74285 L .8675 .83134 L .955 .673 .461 r
F
.25 g
.84868 .74226 m
.87126 .83287 L
s
1 0 0 r
.003 w
.83894 .74285 m
.84868 .74226 L
s
0 g
.006 w
.87126 .83287 m
.87437 .83132 L
s
.17427 .69586 m .26569 .72931 L .16839 .72232 L .628 .716 .91 r
F
0 g
.16576 .74895 m
.16839 .72232 L
s
.17427 .69586 m .27017 .71513 L .26569 .72931 L .628 .716 .91 r
F
1 0 0 r
.003 w
.26278 .74342 m
.26569 .72931 L
s
.25 g
.5 Mabswid
.16839 .72232 m
.26569 .72931 L
s
.86289 .82667 m .82815 .74204 L .81632 .73992 L .914 .56 .352 r
F
.8675 .83134 m .82815 .74204 L .86289 .82667 L .937 .621 .414 r
F
.25 g
.83894 .74285 m
.86663 .82865 L
s
1 0 0 r
.003 w
.82815 .74204 m
.83894 .74285 L
s
0 g
.006 w
.8675 .83134 m
.87126 .83287 L
s
.25 g
.5 Mabswid
.86663 .82865 m
.8675 .83134 L
s
.18336 .66995 m .27017 .71513 L .17427 .69586 L .601 .679 .896 r
F
0 g
.006 w
.16839 .72232 m
.17427 .69586 L
s
.18336 .66995 m .2763 .70105 L .27017 .71513 L .601 .679 .896 r
F
1 0 0 r
.003 w
.26569 .72931 m
.27017 .71513 L
s
.25 g
.5 Mabswid
.17427 .69586 m
.27017 .71513 L
s
.77642 .72835 m .7896 .73215 L .77476 .72667 L .773 .271 .003 r
F
.85719 .81885 m .81691 .74105 L .80367 .7369 L .885 .487 .268 r
F
.80367 .7369 m .81632 .73992 L .80347 .73659 L F
.81691 .74105 m .81632 .73992 L .80367 .7369 L F
.85719 .81885 m .80577 .74012 L .85019 .80795 L F
.80577 .74012 m .80443 .73806 L .80587 .74026 L F
.80577 .74012 m .80587 .74026 L .85019 .80795 L F
.80443 .73806 m .8046 .73832 L .85019 .80795 L F
.80367 .7369 m .8038 .7371 L .85019 .80795 L F
.75561 .71894 m .75896 .72026 L .75487 .71848 L .478 0 0 r
F
.85019 .80795 m .80594 .74036 L .79113 .73406 L .842 .395 .156 r
F
.85019 .80795 m .79113 .73406 L .84164 .79411 L F
.79113 .73406 m .8038 .7371 L .7896 .73215 L F
.80443 .73806 m .80367 .7369 L .8046 .73832 L .885 .487 .268 r
F
.80594 .74036 m .8038 .7371 L .79113 .73406 L .842 .395 .156 r
F
.79113 .73406 m .7896 .73215 L .79145 .73434 L F
.79113 .73406 m .79145 .73434 L .84164 .79411 L F
.84054 .79301 m .80382 .74913 L .7859 .73791 L .773 .271 .003 r
F
.80382 .74913 m .79144 .73434 L .7859 .73791 L F
.7859 .73791 m .79144 .73434 L .77642 .72835 L F
.79144 .73434 m .78078 .72972 L .77642 .72835 L F
.83993 .79208 m .78999 .73261 L .84054 .79301 L F
.78999 .73261 m .7896 .73215 L .77642 .72835 L F
.84164 .79411 m .83993 .79208 L .84054 .79301 L F
.84164 .79411 m .77551 .72743 L .83132 .77757 L F
.77551 .72743 m .77476 .72667 L .77596 .72775 L F
.77551 .72743 m .77596 .72775 L .83132 .77757 L F
.82975 .77633 m .77595 .72775 L .75896 .72026 L .66 .105 0 r
F
.82948 .77591 m .77476 .72667 L .82975 .77633 L F
.83132 .77757 m .82948 .77591 L .82975 .77633 L F
.83132 .77757 m .75896 .72026 L .81904 .75862 L F
.81773 .75784 m .75487 .71848 L .74235 .71304 L .478 0 0 r
F
.81783 .7579 m .8177 .75782 L .81773 .75784 L F
.8177 .75782 m .75487 .71848 L .81773 .75784 L F
.77595 .72775 m .77476 .72667 L .75896 .72026 L .66 .105 0 r
F
.81728 .75756 m .75947 .72058 L .75561 .71894 L .478 0 0 r
F
.81783 .7579 m .81725 .75753 L .81728 .75756 L F
.81725 .75753 m .75947 .72058 L .81728 .75756 L F
.75947 .72058 m .75896 .72026 L .75561 .71894 L F
.80367 .7369 m .80347 .73659 L .8038 .7371 L .885 .487 .268 r
F
.8038 .7371 m .80347 .73659 L .7896 .73215 L .842 .395 .156 r
F
.79144 .73434 m .78999 .73261 L .78078 .72972 L .773 .271 .003 r
F
.74235 .71304 m .75487 .71848 L .74223 .71297 L .478 0 0 r
F
.81904 .75862 m .81776 .7578 L .81783 .7579 L F
.81776 .7578 m .75896 .72026 L .81783 .7579 L F
1 0 0 r
.003 w
.81748 .74012 m
.82815 .74204 L
s
.25 g
.5 Mabswid
.82815 .74204 m
.82825 .74227 L
s
.82825 .74227 m
.82901 .74413 L
s
.82901 .74413 m
.83014 .74688 L
s
.86289 .82667 m .81632 .73992 L .85719 .81885 L .914 .56 .352 r
F
.25 g
.83014 .74688 m
.86181 .82404 L
s
1 0 0 r
.003 w
.81632 .73992 m
.81748 .74012 L
s
.25 g
.5 Mabswid
.8559 .81635 m
.85719 .81885 L
s
.81935 .74577 m
.8559 .81635 L
s
.81792 .74301 m
.81935 .74577 L
s
.81691 .74105 m
.81792 .74301 L
s
.81632 .73992 m
.81691 .74105 L
s
0 g
.006 w
.86289 .82667 m
.8675 .83134 L
s
.25 g
.5 Mabswid
.86181 .82404 m
.86289 .82667 L
s
1 0 0 r
.003 w
.80347 .73659 m
.81632 .73992 L
s
.19558 .64498 m .2763 .70105 L .18336 .66995 L .579 .644 .879 r
F
0 g
.006 w
.17427 .69586 m
.18336 .66995 L
s
.19558 .64498 m .28417 .68726 L .2763 .70105 L .579 .644 .879 r
F
1 0 0 r
.003 w
.27017 .71513 m
.2763 .70105 L
s
.25 g
.5 Mabswid
.18336 .66995 m
.2763 .70105 L
s
.80403 .73744 m
.80464 .73839 L
s
.80464 .73839 m
.80594 .74036 L
s
.80594 .74036 m
.81706 .75736 L
s
.80347 .73659 m
.8038 .7371 L
s
.8038 .7371 m
.80403 .73744 L
s
1 0 0 r
.003 w
.7896 .73215 m
.80347 .73659 L
s
0 g
.006 w
.85719 .81885 m
.86289 .82667 L
s
.21079 .62131 m .28417 .68726 L .19558 .64498 L .563 .611 .859 r
F
0 g
.18336 .66995 m
.19558 .64498 L
s
.21079 .62131 m .29385 .67396 L .28417 .68726 L .563 .611 .859 r
F
1 0 0 r
.003 w
.2763 .70105 m
.28417 .68726 L
s
.25 g
.5 Mabswid
.19558 .64498 m
.28417 .68726 L
s
.78999 .73261 m
.79035 .73303 L
s
.79035 .73303 m
.79145 .73434 L
s
.79145 .73434 m
.8035 .7487 L
s
.7896 .73215 m
.78999 .73261 L
s
1 0 0 r
.003 w
.77476 .72667 m
.7896 .73215 L
s
.22884 .59928 m .29385 .67396 L .21079 .62131 L .553 .583 .838 r
F
0 g
.006 w
.19558 .64498 m
.21079 .62131 L
s
.22884 .59928 m .30538 .66138 L .29385 .67396 L .553 .583 .838 r
F
1 0 0 r
.003 w
.28417 .68726 m
.29385 .67396 L
s
.25 g
.5 Mabswid
.21079 .62131 m
.29385 .67396 L
s
0 g
.006 w
.85019 .80795 m
.85719 .81885 L
s
.25 g
.5 Mabswid
.77495 .72684 m
.77596 .72775 L
s
.77596 .72775 m
.78881 .73932 L
s
.77476 .72667 m
.77495 .72684 L
s
1 0 0 r
.003 w
.75896 .72026 m
.77476 .72667 L
s
.24953 .5792 m .30538 .66138 L .22884 .59928 L .549 .56 .818 r
F
0 g
.006 w
.21079 .62131 m
.22884 .59928 L
s
.24953 .5792 m .31878 .64975 L .30538 .66138 L .549 .56 .818 r
F
1 0 0 r
.003 w
.29385 .67396 m
.30538 .66138 L
s
.25 g
.5 Mabswid
.22884 .59928 m
.30538 .66138 L
s
.75896 .72026 m
.75948 .72059 L
s
.27265 .56135 m .31878 .64975 L .24953 .5792 L .551 .544 .8 r
F
0 g
.006 w
.22884 .59928 m
.24953 .5792 L
s
.27265 .56135 m .33401 .63932 L .31878 .64975 L .551 .544 .8 r
F
1 0 0 r
.003 w
.30538 .66138 m
.31878 .64975 L
s
.25 g
.5 Mabswid
.24953 .5792 m
.31878 .64975 L
s
0 g
.006 w
.84164 .79411 m
.85019 .80795 L
s
.29797 .54599 m .33401 .63932 L .27265 .56135 L .558 .534 .785 r
F
0 g
.24953 .5792 m
.27265 .56135 L
s
.29797 .54599 m .35099 .6303 L .33401 .63932 L .558 .534 .785 r
F
1 0 0 r
.003 w
.31878 .64975 m
.33401 .63932 L
s
.25 g
.5 Mabswid
.27265 .56135 m
.33401 .63932 L
s
.80464 .73767 m .74223 .71297 L .72458 .70491 L 0 .342 .7 r
F
.25 g
.75948 .72059 m
.76064 .72133 L
s
.81904 .75862 m .74223 .71297 L .80464 .73767 L .478 0 0 r
F
.25 g
.74223 .71297 m
.74229 .713 L
s
.32525 .53333 m .35099 .6303 L .29797 .54599 L .568 .531 .773 r
F
0 g
.006 w
.27265 .56135 m
.29797 .54599 L
s
.32525 .53333 m .36961 .62289 L .35099 .6303 L .568 .531 .773 r
F
1 0 0 r
.003 w
.33401 .63932 m
.35099 .6303 L
s
.25 g
.5 Mabswid
.29797 .54599 m
.35099 .6303 L
s
.78799 .71517 m .72458 .70491 L .70603 .69617 L .039 .534 .88 r
F
.25 g
.74229 .713 m
.74439 .71383 L
s
.80464 .73767 m .72458 .70491 L .78799 .71517 L 0 .342 .7 r
F
1 0 0 r
.003 w
.72458 .70491 m
.74223 .71297 L
s
.25 g
.5 Mabswid
.80327 .73713 m
.80464 .73767 L
s
.80253 .73683 m
.80327 .73713 L
s
.80251 .73683 m
.80253 .73683 L
s
0 g
.006 w
.83132 .77757 m
.84164 .79411 L
s
.35421 .52359 m .36961 .62289 L .32525 .53333 L .581 .533 .766 r
F
0 g
.29797 .54599 m
.32525 .53333 L
s
.35421 .52359 m .38971 .61727 L .36961 .62289 L .581 .533 .766 r
F
1 0 0 r
.003 w
.35099 .6303 m
.36961 .62289 L
s
.25 g
.5 Mabswid
.32525 .53333 m
.36961 .62289 L
s
.76906 .69166 m .70603 .69617 L .68659 .68688 L .257 .649 .964 r
F
.78799 .71517 m .70603 .69617 L .76906 .69166 L .039 .534 .88 r
F
1 0 0 r
.003 w
.70603 .69617 m
.72458 .70491 L
s
.25 g
.5 Mabswid
.78581 .71482 m
.78799 .71517 L
s
.72458 .70491 m
.78581 .71482 L
s
.74439 .71383 m
.80251 .73683 L
s
.3846 .51691 m .38971 .61727 L .35421 .52359 L .595 .54 .763 r
F
0 g
.006 w
.32525 .53333 m
.35421 .52359 L
s
.3846 .51691 m .4111 .61356 L .38971 .61727 L .595 .54 .763 r
F
1 0 0 r
.003 w
.36961 .62289 m
.38971 .61727 L
s
.74782 .66768 m .68659 .68688 L .66627 .67719 L .408 .702 .982 r
F
.76906 .69166 m .68659 .68688 L .74782 .66768 L .257 .649 .964 r
F
1 0 0 r
.68659 .68688 m
.70603 .69617 L
s
.25 g
.5 Mabswid
.70603 .69617 m
.76906 .69166 L
s
0 g
.006 w
.81904 .75862 m
.83132 .77757 L
s
.41612 .51342 m .4111 .61356 L .3846 .51691 L .609 .552 .765 r
F
.25 g
.5 Mabswid
.35421 .52359 m
.38971 .61727 L
s
.41612 .51342 m .43356 .61181 L .4111 .61356 L .609 .552 .765 r
F
1 0 0 r
.003 w
.38971 .61727 m
.4111 .61356 L
s
.25 g
.5 Mabswid
.3846 .51691 m
.4111 .61356 L
s
0 g
.006 w
.35421 .52359 m
.3846 .51691 L
s
.72436 .64381 m .66627 .67719 L .64511 .6673 L .505 .717 .967 r
F
.25 g
.5 Mabswid
.68659 .68688 m
.69004 .68579 L
s
.74782 .66768 m .66627 .67719 L .72436 .64381 L .408 .702 .982 r
F
.25 g
.69004 .68579 m
.74782 .66768 L
s
1 0 0 r
.003 w
.66627 .67719 m
.68659 .68688 L
s
.44848 .5132 m .43356 .61181 L .41612 .51342 L .622 .566 .771 r
F
.44848 .5132 m .45684 .61205 L .43356 .61181 L F
1 0 0 r
.4111 .61356 m
.43356 .61181 L
s
.25 g
.5 Mabswid
.41612 .51342 m
.43356 .61181 L
s
.6988 .62064 m .64511 .6673 L .62315 .65745 L .567 .713 .94 r
F
.25 g
.66627 .67719 m
.67004 .67502 L
s
.72436 .64381 m .64511 .6673 L .6988 .62064 L .505 .717 .967 r
F
1 0 0 r
.003 w
.64511 .6673 m
.66627 .67719 L
s
.25 g
.5 Mabswid
.72231 .645 m
.72436 .64381 L
s
0 g
.006 w
.3846 .51691 m
.41612 .51342 L
s
.48136 .51629 m .45684 .61205 L .44848 .5132 L .633 .584 .781 r
F
.48136 .51629 m .4807 .6142 L .45684 .61205 L F
1 0 0 r
.003 w
.43356 .61181 m
.45684 .61205 L
s
.25 g
.5 Mabswid
.44848 .5132 m
.45684 .61205 L
s
.67132 .59869 m .62315 .65745 L .60046 .64788 L .605 .701 .911 r
F
.25 g
.64511 .6673 m
.64911 .66383 L
s
.67004 .67502 m
.67295 .67335 L
s
.6988 .62064 m .62315 .65745 L .67132 .59869 L .567 .713 .94 r
F
.25 g
.67295 .67335 m
.72231 .645 L
s
1 0 0 r
.003 w
.62315 .65745 m
.64511 .6673 L
s
.25 g
.5 Mabswid
.69688 .6223 m
.6988 .62064 L
s
0 g
.006 w
.80464 .73767 m
.81904 .75862 L
s
.51443 .52268 m .4807 .6142 L .48136 .51629 L .641 .603 .795 r
F
.51443 .52268 m .5049 .61816 L .4807 .6142 L F
1 0 0 r
.003 w
.45684 .61205 m
.4807 .6142 L
s
.25 g
.5 Mabswid
.4807 .6142 m
.48136 .51629 L
s
.64215 .57847 m .60046 .64788 L .57714 .63888 L .629 .683 .882 r
F
.25 g
.62315 .65745 m
.62728 .65241 L
s
.67132 .59869 m .60046 .64788 L .64215 .57847 L .605 .701 .911 r
F
1 0 0 r
.003 w
.60046 .64788 m
.62315 .65745 L
s
.25 g
.5 Mabswid
.66954 .60085 m
.67132 .59869 L
s
.64911 .66383 m
.69688 .6223 L
s
.54738 .53227 m .5049 .61816 L .51443 .52268 L .646 .623 .812 r
F
.54738 .53227 m .52918 .62375 L .5049 .61816 L F
1 0 0 r
.003 w
.4807 .6142 m
.5049 .61816 L
s
.25 g
.5 Mabswid
.5049 .61816 m
.51443 .52268 L
s
.61157 .56043 m .57714 .63888 L .55333 .63075 L .641 .664 .856 r
F
.25 g
.60046 .64788 m
.60459 .641 L
s
.64215 .57847 m .57714 .63888 L .61157 .56043 L .629 .683 .882 r
F
1 0 0 r
.003 w
.57714 .63888 m
.60046 .64788 L
s
.25 g
.5 Mabswid
.64063 .58101 m
.64215 .57847 L
s
.62728 .65241 m
.66954 .60085 L
s
.57987 .54493 m .52918 .62375 L .54738 .53227 L .647 .643 .832 r
F
.57987 .54493 m .55333 .63075 L .52918 .62375 L F
1 0 0 r
.003 w
.5049 .61816 m
.52918 .62375 L
s
.25 g
.5 Mabswid
.52918 .62375 m
.54738 .53227 L
s
.61157 .56043 m .55333 .63075 L .57987 .54493 L .641 .664 .856 r
F
.25 g
.57887 .54817 m
.57987 .54493 L
s
.55333 .63075 m
.57887 .54817 L
s
1 0 0 r
.003 w
.52918 .62375 m
.55333 .63075 L
s
.55333 .63075 m
.57714 .63888 L
s
.25 g
.5 Mabswid
.57714 .63888 m
.58113 .62979 L
s
.58113 .62979 m
.61029 .56334 L
s
.61029 .56334 m
.61157 .56043 L
s
.60459 .641 m
.64063 .58101 L
s
0 g
.006 w
.41612 .51342 m
.44848 .5132 L
s
.78799 .71517 m
.80464 .73767 L
s
.44848 .5132 m
.48136 .51629 L
s
.48136 .51629 m
.51443 .52268 L
s
.76906 .69166 m
.78799 .71517 L
s
.51443 .52268 m
.54738 .53227 L
s
.74782 .66768 m
.76906 .69166 L
s
.54738 .53227 m
.57987 .54493 L
s
.72436 .64381 m
.74782 .66768 L
s
.57987 .54493 m
.61157 .56043 L
s
.6988 .62064 m
.72436 .64381 L
s
.61157 .56043 m
.64215 .57847 L
s
.67132 .59869 m
.6988 .62064 L
s
.64215 .57847 m
.67132 .59869 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open]]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[%, ViewPoint \[Rule] {3, \(-.4\), .8}, Boxed \[Rule] False]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.04084 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.143646 1.17891 0 1.17891 [
[ 0 0 0 0 ]
[ 1 1.04084 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.04084 L
0 1.04084 L
closepath
clip
newpath
.59816 .41337 m .56178 .43501 L .57284 .39701 L .917 .616 .459 r
F
.59816 .41337 m .57542 .45392 L .56178 .43501 L F
.62247 .43117 m .57542 .45392 L .59816 .41337 L .893 .635 .541 r
F
.57284 .39701 m .5476 .41666 L .54686 .382 L .927 .571 .332 r
F
.57284 .39701 m .56178 .43501 L .5476 .41666 L F
0 g
.006 w
.57284 .39701 m
.59816 .41337 L
s
.25 g
.5 Mabswid
.56178 .43501 m
.57284 .39701 L
s
.62247 .43117 m .58841 .47337 L .57542 .45392 L .893 .635 .541 r
F
.64549 .45047 m .58841 .47337 L .62247 .43117 L .866 .64 .595 r
F
.25 g
.59744 .41465 m
.59816 .41337 L
s
0 g
.006 w
.59816 .41337 m
.62247 .43117 L
s
.54686 .382 m .53297 .39895 L .52052 .36821 L .895 .473 .133 r
F
.54686 .382 m .5476 .41666 L .53297 .39895 L F
0 g
.54686 .382 m
.57284 .39701 L
s
.25 g
.5 Mabswid
.54686 .382 m
.5476 .41666 L
s
.64549 .45047 m .60068 .49331 L .58841 .47337 L .866 .64 .595 r
F
.25 g
.58841 .47337 m
.58922 .47237 L
s
.57542 .45392 m
.59744 .41465 L
s
.6669 .4713 m .60068 .49331 L .64549 .45047 L .838 .638 .632 r
F
.25 g
.62141 .43249 m
.62247 .43117 L
s
0 g
.006 w
.62247 .43117 m
.64549 .45047 L
s
.52052 .36821 m .51803 .3819 L .49416 .35552 L .772 .294 0 r
F
.52052 .36821 m .53297 .39895 L .51803 .3819 L F
0 g
.52052 .36821 m
.54686 .382 L
s
.25 g
.5 Mabswid
.52052 .36821 m
.53297 .39895 L
s
.6669 .4713 m .61211 .51369 L .60068 .49331 L .838 .638 .632 r
F
.25 g
.60068 .49331 m
.60141 .4926 L
s
.68642 .49367 m .61211 .51369 L .6669 .4713 L .812 .631 .657 r
F
.25 g
.58922 .47237 m
.62141 .43249 L
s
.60141 .4926 m
.64409 .4518 L
s
.64409 .4518 m
.64549 .45047 L
s
0 g
.006 w
.64549 .45047 m
.6669 .4713 L
s
.68642 .49367 m .62261 .53449 L .61211 .51369 L .812 .631 .657 r
F
.25 g
.5 Mabswid
.61211 .51369 m
.61366 .51249 L
s
.70379 .51752 m .62261 .53449 L .68642 .49367 L .787 .62 .674 r
F
.25 g
.61366 .51249 m
.66521 .47261 L
s
.66521 .47261 m
.6669 .4713 L
s
0 g
.006 w
.6669 .4713 m
.68642 .49367 L
s
.49416 .35552 m .50291 .36556 L .4681 .34377 L .53 .041 0 r
F
.49416 .35552 m .51803 .3819 L .50291 .36556 L F
0 g
.49416 .35552 m
.52052 .36821 L
s
.70379 .51752 m .63204 .55567 L .62261 .53449 L .787 .62 .674 r
F
.25 g
.5 Mabswid
.62261 .53449 m
.62266 .53446 L
s
.71877 .54278 m .63204 .55567 L .70379 .51752 L .764 .608 .685 r
F
.25 g
.62266 .53446 m
.68447 .49491 L
s
.68447 .49491 m
.68642 .49367 L
s
0 g
.006 w
.68642 .49367 m
.70379 .51752 L
s
.4681 .34377 m .48777 .34995 L .44264 .3328 L 0 .207 .712 r
F
.4681 .34377 m .50291 .36556 L .48777 .34995 L F
0 g
.4924 .35473 m
.49416 .35552 L
s
.25 g
.5 Mabswid
.4681 .34377 m
.46925 .34449 L
s
.51656 .38027 m
.51803 .3819 L
s
.49416 .35552 m
.51656 .38027 L
s
.71877 .54278 m .64026 .57718 L .63204 .55567 L .764 .608 .685 r
F
.73116 .56934 m .64026 .57718 L .71877 .54278 L .742 .594 .692 r
F
.25 g
.63204 .55567 m
.70162 .51867 L
s
.70162 .51867 m
.70379 .51752 L
s
0 g
.006 w
.70379 .51752 m
.71877 .54278 L
s
.44264 .3328 m .47282 .33511 L .4181 .32244 L .008 .388 .847 r
F
.44264 .3328 m .48777 .34995 L .47282 .33511 L F
0 g
.44264 .3328 m
.4681 .34377 L
s
.25 g
.5 Mabswid
.44264 .3328 m
.44416 .33337 L
s
.50044 .36401 m
.50291 .36556 L
s
.46925 .34449 m
.50044 .36401 L
s
.73116 .56934 m .64712 .59899 L .64026 .57718 L .742 .594 .692 r
F
.74077 .59703 m .64712 .59899 L .73116 .56934 L .722 .579 .694 r
F
.25 g
.64026 .57718 m
.71643 .54381 L
s
.71643 .54381 m
.71877 .54278 L
s
0 g
.006 w
.71877 .54278 m
.73116 .56934 L
s
.74077 .59703 m .65247 .62102 L .64712 .59899 L .722 .579 .694 r
F
.74747 .62568 m .65247 .62102 L .74077 .59703 L .703 .563 .693 r
F
.25 g
.5 Mabswid
.64712 .59899 m
.7287 .57021 L
s
.7287 .57021 m
.73116 .56934 L
s
0 g
.006 w
.73116 .56934 m
.74077 .59703 L
s
.4181 .32244 m .45826 .32103 L .39476 .31253 L .183 .507 .911 r
F
.4181 .32244 m .47282 .33511 L .45826 .32103 L F
0 g
.4181 .32244 m
.44264 .3328 L
s
.25 g
.5 Mabswid
.4181 .32244 m
.41996 .32287 L
s
.41996 .32287 m
.47282 .33511 L
s
.48411 .34856 m
.48777 .34995 L
s
.44416 .33337 m
.48411 .34856 L
s
1 0 0 r
.003 w
.63204 .55567 m
.64026 .57718 L
s
.64026 .57718 m
.64712 .59899 L
s
.62261 .53449 m
.63204 .55567 L
s
.74747 .62568 m .65615 .64319 L .65247 .62102 L .703 .563 .693 r
F
1 0 0 r
.64712 .59899 m
.65247 .62102 L
s
.25 g
.5 Mabswid
.65247 .62102 m
.74077 .59703 L
s
1 0 0 r
.003 w
.61211 .51369 m
.62261 .53449 L
s
.75114 .65505 m .65615 .64319 L .74747 .62568 L .686 .546 .689 r
F
0 g
.006 w
.74077 .59703 m
.74747 .62568 L
s
.75114 .65505 m .658 .66538 L .65615 .64319 L .686 .546 .689 r
F
1 0 0 r
.003 w
.65247 .62102 m
.65615 .64319 L
s
.25 g
.5 Mabswid
.65615 .64319 m
.74747 .62568 L
s
1 0 0 r
.003 w
.60068 .49331 m
.61211 .51369 L
s
.75171 .68489 m .658 .66538 L .75114 .65505 L .672 .529 .682 r
F
0 g
.006 w
.74747 .62568 m
.75114 .65505 L
s
.75171 .68489 m .65789 .68748 L .658 .66538 L .672 .529 .682 r
F
1 0 0 r
.003 w
.65615 .64319 m
.658 .66538 L
s
.25 g
.5 Mabswid
.658 .66538 m
.75114 .65505 L
s
1 0 0 r
.003 w
.58841 .47337 m
.60068 .49331 L
s
.74914 .71492 m .65789 .68748 L .75171 .68489 L .66 .514 .674 r
F
.74914 .71492 m .65572 .7093 L .65789 .68748 L F
1 0 0 r
.65789 .68748 m
.658 .66538 L
s
.25 g
.5 Mabswid
.65789 .68748 m
.75171 .68489 L
s
1 0 0 r
.003 w
.57542 .45392 m
.58841 .47337 L
s
.74344 .74484 m .65572 .7093 L .74914 .71492 L .652 .499 .664 r
F
.74344 .74484 m .65141 .73068 L .65572 .7093 L F
1 0 0 r
.65572 .7093 m
.65789 .68748 L
s
.25 g
.5 Mabswid
.65572 .7093 m
.74914 .71492 L
s
0 g
.006 w
.75114 .65505 m
.75171 .68489 L
s
.73465 .77433 m .65141 .73068 L .74344 .74484 L .647 .488 .653 r
F
.73465 .77433 m .64493 .75142 L .65141 .73068 L F
1 0 0 r
.003 w
.65141 .73068 m
.65572 .7093 L
s
.25 g
.5 Mabswid
.65141 .73068 m
.74344 .74484 L
s
1 0 0 r
.003 w
.56178 .43501 m
.57542 .45392 L
s
.72284 .80307 m .64493 .75142 L .73465 .77433 L .646 .479 .643 r
F
.72284 .80307 m .63629 .7713 L .64493 .75142 L F
1 0 0 r
.64493 .75142 m
.65141 .73068 L
s
.39476 .31253 m .44435 .30771 L .37292 .30291 L .303 .586 .942 r
F
.39476 .31253 m .45826 .32103 L .44435 .30771 L F
0 g
.006 w
.39476 .31253 m
.4181 .32244 L
s
.25 g
.5 Mabswid
.39476 .31253 m
.45826 .32103 L
s
1 0 0 r
.003 w
.5476 .41666 m
.56178 .43501 L
s
.70812 .83072 m .63629 .7713 L .72284 .80307 L .65 .475 .634 r
F
.70812 .83072 m .62554 .79014 L .63629 .7713 L F
.25 g
.5 Mabswid
.64493 .75142 m
.73465 .77433 L
s
1 0 0 r
.003 w
.63629 .7713 m
.64493 .75142 L
s
0 g
.006 w
.74914 .71492 m
.75171 .68489 L
s
.69063 .85696 m .62554 .79014 L .70812 .83072 L .657 .476 .628 r
F
.25 g
.5 Mabswid
.70889 .79795 m
.72284 .80307 L
s
.69063 .85696 m .61278 .80772 L .62554 .79014 L .657 .476 .628 r
F
.25 g
.63629 .7713 m
.70889 .79795 L
s
1 0 0 r
.003 w
.62554 .79014 m
.63629 .7713 L
s
.53297 .39895 m
.5476 .41666 L
s
.67056 .88146 m .61278 .80772 L .69063 .85696 L .668 .482 .624 r
F
.25 g
.5 Mabswid
.67247 .84547 m
.69063 .85696 L
s
.70321 .82831 m
.70812 .83072 L
s
.67056 .88146 m .59815 .82388 L .61278 .80772 L .668 .482 .624 r
F
1 0 0 r
.003 w
.61278 .80772 m
.62554 .79014 L
s
.6481 .90393 m .59815 .82388 L .67056 .88146 L .681 .493 .625 r
F
.25 g
.5 Mabswid
.66051 .87347 m
.67056 .88146 L
s
.70308 .82825 m
.70321 .82831 L
s
.6481 .90393 m .58182 .83847 L .59815 .82388 L .681 .493 .625 r
F
.25 g
.62554 .79014 m
.70308 .82825 L
s
1 0 0 r
.003 w
.59815 .82388 m
.61278 .80772 L
s
0 g
.006 w
.74344 .74484 m
.74914 .71492 L
s
1 0 0 r
.003 w
.51803 .3819 m
.53297 .39895 L
s
.62349 .92409 m .58182 .83847 L .6481 .90393 L .696 .508 .628 r
F
.25 g
.5 Mabswid
.62575 .84582 m
.66051 .87347 L
s
.62349 .92409 m .56399 .85138 L .58182 .83847 L .696 .508 .628 r
F
.25 g
.61278 .80772 m
.67247 .84547 L
s
.59815 .82388 m
.62575 .84582 L
s
1 0 0 r
.003 w
.58182 .83847 m
.59815 .82388 L
s
.59699 .9417 m .56399 .85138 L .62349 .92409 L .712 .526 .636 r
F
.25 g
.5 Mabswid
.59983 .89518 m
.62349 .92409 L
s
.64541 .90128 m
.6481 .90393 L
s
.61503 .87127 m
.64541 .90128 L
s
.59882 .85525 m
.61503 .87127 L
s
.59699 .9417 m .54487 .86257 L .56399 .85138 L .712 .526 .636 r
F
.25 g
.58182 .83847 m
.59882 .85525 L
s
1 0 0 r
.003 w
.56399 .85138 m
.58182 .83847 L
s
0 g
.006 w
.73465 .77433 m
.74344 .74484 L
s
.37292 .30291 m .43133 .29514 L .35284 .29343 L .386 .642 .958 r
F
.37292 .30291 m .44435 .30771 L .43133 .29514 L F
0 g
.37292 .30291 m
.39476 .31253 L
s
.25 g
.5 Mabswid
.37292 .30291 m
.44435 .30771 L
s
1 0 0 r
.003 w
.50291 .36556 m
.51803 .3819 L
s
.56887 .95656 m .54487 .86257 L .59699 .9417 L .728 .548 .647 r
F
.25 g
.5 Mabswid
.58529 .87742 m
.59983 .89518 L
s
.57553 .86549 m
.58529 .87742 L
s
.56887 .95656 m .52469 .87199 L .54487 .86257 L .728 .548 .647 r
F
.25 g
.56399 .85138 m
.57553 .86549 L
s
1 0 0 r
.003 w
.54487 .86257 m
.56399 .85138 L
s
0 g
.006 w
.72284 .80307 m
.73465 .77433 L
s
.53943 .96851 m .52469 .87199 L .56887 .95656 L .743 .572 .662 r
F
.25 g
.5 Mabswid
.59502 .93872 m
.59699 .9417 L
s
.55947 .88473 m
.59502 .93872 L
s
.54487 .86257 m
.55947 .88473 L
s
.53943 .96851 m .50367 .87969 L .52469 .87199 L .743 .572 .662 r
F
1 0 0 r
.003 w
.52469 .87199 m
.54487 .86257 L
s
.25 g
.5 Mabswid
.52469 .87199 m
.53486 .89145 L
s
1 0 0 r
.003 w
.48777 .34995 m
.50291 .36556 L
s
0 g
.006 w
.70812 .83072 m
.72284 .80307 L
s
.50896 .97744 m .50367 .87969 L .53943 .96851 L .757 .597 .68 r
F
.25 g
.5 Mabswid
.56724 .95345 m
.56887 .95656 L
s
.53486 .89145 m
.56724 .95345 L
s
.50896 .97744 m .48203 .88573 L .50367 .87969 L .757 .597 .68 r
F
1 0 0 r
.003 w
.50367 .87969 m
.52469 .87199 L
s
.25 g
.5 Mabswid
.50367 .87969 m
.50763 .88953 L
s
0 g
.006 w
.69063 .85696 m
.70812 .83072 L
s
.47778 .98332 m .48203 .88573 L .50896 .97744 L .768 .624 .7 r
F
.25 g
.5 Mabswid
.48461 .89451 m
.50896 .97744 L
s
.53814 .96531 m
.53943 .96851 L
s
.50763 .88953 m
.53814 .96531 L
s
.47778 .98332 m .45997 .89021 L .48203 .88573 L .768 .624 .7 r
F
1 0 0 r
.003 w
.48203 .88573 m
.50367 .87969 L
s
.25 g
.5 Mabswid
.48203 .88573 m
.48461 .89451 L
s
0 g
.006 w
.67056 .88146 m
.69063 .85696 L
s
1 0 0 r
.003 w
.47282 .33511 m
.48777 .34995 L
s
.44619 .98613 m .45997 .89021 L .47778 .98332 L .778 .652 .723 r
F
.44619 .98613 m .43765 .89325 L .45997 .89021 L F
1 0 0 r
.45997 .89021 m
.48203 .88573 L
s
.41449 .98595 m .43765 .89325 L .44619 .98613 L .785 .68 .748 r
F
0 g
.006 w
.44619 .98613 m
.47778 .98332 L
s
.41449 .98595 m .41525 .895 L .43765 .89325 L .785 .68 .748 r
F
.25 g
.5 Mabswid
.43765 .89325 m
.44619 .98613 L
s
.38295 .9829 m .41525 .895 L .41449 .98595 L .788 .709 .776 r
F
0 g
.006 w
.41449 .98595 m
.44619 .98613 L
s
.25 g
.5 Mabswid
.45997 .89021 m
.47778 .98332 L
s
0 g
.006 w
.47778 .98332 m
.50896 .97744 L
s
.38295 .9829 m .39289 .89559 L .41525 .895 L .788 .709 .776 r
F
.25 g
.5 Mabswid
.41449 .98595 m
.41525 .895 L
s
.35184 .97714 m .39289 .89559 L .38295 .9829 L .787 .738 .807 r
F
0 g
.006 w
.38295 .9829 m
.41449 .98595 L
s
.50896 .97744 m
.53943 .96851 L
s
.6481 .90393 m
.67056 .88146 L
s
.35284 .29343 m .41947 .2833 L .3348 .28395 L .444 .685 .967 r
F
.35284 .29343 m .43133 .29514 L .41947 .2833 L F
0 g
.35284 .29343 m
.37292 .30291 L
s
.25 g
.5 Mabswid
.35284 .29343 m
.43133 .29514 L
s
0 g
.006 w
.53943 .96851 m
.56887 .95656 L
s
.35184 .97714 m .37068 .89517 L .39289 .89559 L .787 .738 .807 r
F
.25 g
.5 Mabswid
.38295 .9829 m
.39289 .89559 L
s
.32142 .96889 m .37068 .89517 L .35184 .97714 L .78 .767 .841 r
F
0 g
.006 w
.35184 .97714 m
.38295 .9829 L
s
.62349 .92409 m
.6481 .90393 L
s
.56887 .95656 m
.59699 .9417 L
s
1 0 0 r
.003 w
.43765 .89325 m
.45997 .89021 L
s
0 g
.006 w
.59699 .9417 m
.62349 .92409 L
s
.32142 .96889 m .34873 .89386 L .37068 .89517 L .78 .767 .841 r
F
.25 g
.5 Mabswid
.35184 .97714 m
.37068 .89517 L
s
.2919 .95839 m .34873 .89386 L .32142 .96889 L .765 .796 .878 r
F
0 g
.006 w
.32142 .96889 m
.35184 .97714 L
s
1 0 0 r
.003 w
.45826 .32103 m
.47282 .33511 L
s
.41525 .895 m
.43765 .89325 L
s
.2919 .95839 m .32711 .89177 L .34873 .89386 L .765 .796 .878 r
F
.26349 .94595 m .32711 .89177 L .2919 .95839 L .739 .822 .916 r
F
.25 g
.5 Mabswid
.32142 .96889 m
.32231 .96646 L
s
0 g
.006 w
.2919 .95839 m
.32142 .96889 L
s
.26349 .94595 m .30592 .889 L .32711 .89177 L .739 .822 .916 r
F
.25 g
.5 Mabswid
.32592 .89402 m
.32711 .89177 L
s
.32231 .96646 m
.34873 .89386 L
s
.23634 .93186 m .30592 .889 L .26349 .94595 L .694 .841 .954 r
F
.25 g
.2919 .95839 m
.29303 .95626 L
s
0 g
.006 w
.26349 .94595 m
.2919 .95839 L
s
1 0 0 r
.003 w
.39289 .89559 m
.41525 .895 L
s
.44435 .30771 m
.45826 .32103 L
s
.3348 .28395 m .40901 .27219 L .31903 .27436 L .485 .721 .975 r
F
.3348 .28395 m .41947 .2833 L .40901 .27219 L F
0 g
.006 w
.3348 .28395 m
.35284 .29343 L
s
.25 g
.5 Mabswid
.3348 .28395 m
.41947 .2833 L
s
.23634 .93186 m .28524 .88561 L .30592 .889 L .694 .841 .954 r
F
.25 g
.30479 .89051 m
.30592 .889 L
s
.29303 .95626 m
.32592 .89402 L
s
.21062 .91647 m .28524 .88561 L .23634 .93186 L .622 .848 .985 r
F
.25 g
.26349 .94595 m
.26483 .94415 L
s
0 g
.006 w
.23634 .93186 m
.26349 .94595 L
s
1 0 0 r
.003 w
.37068 .89517 m
.39289 .89559 L
s
.43133 .29514 m
.44435 .30771 L
s
.34873 .89386 m
.37068 .89517 L
s
.21062 .91647 m .26517 .88167 L .28524 .88561 L .622 .848 .985 r
F
.25 g
.5 Mabswid
.28429 .88651 m
.28524 .88561 L
s
.18644 .90011 m .26517 .88167 L .21062 .91647 L .514 .829 1 r
F
.25 g
.23634 .93186 m
.23787 .93042 L
s
0 g
.006 w
.21062 .91647 m
.23634 .93186 L
s
1 0 0 r
.003 w
.32711 .89177 m
.34873 .89386 L
s
.18644 .90011 m .24582 .87724 L .26517 .88167 L .514 .829 1 r
F
.25 g
.5 Mabswid
.26337 .88281 m
.26517 .88167 L
s
.26483 .94415 m
.30479 .89051 L
s
.16391 .88313 m .24582 .87724 L .18644 .90011 L .362 .772 .981 r
F
.25 g
.23787 .93042 m
.28429 .88651 L
s
.21062 .91647 m
.2123 .9154 L
s
0 g
.006 w
.18644 .90011 m
.21062 .91647 L
s
1 0 0 r
.003 w
.41947 .2833 m
.43133 .29514 L
s
.31903 .27436 m .40021 .2618 L .30577 .26455 L .511 .751 .982 r
F
.31903 .27436 m .40901 .27219 L .40021 .2618 L F
0 g
.006 w
.31903 .27436 m
.3348 .28395 L
s
.25 g
.5 Mabswid
.31903 .27436 m
.40901 .27219 L
s
1 0 0 r
.003 w
.30592 .889 m
.32711 .89177 L
s
.16391 .88313 m .22731 .8724 L .24582 .87724 L .362 .772 .981 r
F
.25 g
.5 Mabswid
.24452 .87774 m
.24582 .87724 L
s
.14312 .86587 m .22731 .8724 L .16391 .88313 L .173 .667 .918 r
F
.25 g
.2123 .9154 m
.26337 .88281 L
s
.18644 .90011 m
.18825 .89941 L
s
.18825 .89941 m
.24452 .87774 L
s
0 g
.006 w
.16391 .88313 m
.18644 .90011 L
s
.25 g
.5 Mabswid
.16391 .88313 m
.22667 .87251 L
s
1 0 0 r
.003 w
.40901 .27219 m
.41947 .2833 L
s
.28524 .88561 m
.30592 .889 L
s
.30577 .26455 m .39329 .25212 L .29526 .25448 L .525 .776 .989 r
F
.30577 .26455 m .40021 .2618 L .39329 .25212 L F
0 g
.006 w
.30577 .26455 m
.31903 .27436 L
s
.25 g
.5 Mabswid
.30577 .26455 m
.40021 .2618 L
s
.14312 .86587 m .20978 .86722 L .22731 .8724 L .173 .667 .918 r
F
.25 g
.22667 .87251 m
.22731 .8724 L
s
.12415 .84869 m .20978 .86722 L .14312 .86587 L 0 .525 .813 r
F
0 g
.006 w
.14312 .86587 m
.16391 .88313 L
s
1 0 0 r
.003 w
.26517 .88167 m
.28524 .88561 L
s
.40021 .2618 m
.40901 .27219 L
s
.24582 .87724 m
.26517 .88167 L
s
.12415 .84869 m .1934 .8618 L .20978 .86722 L 0 .525 .813 r
F
.25 g
.5 Mabswid
.14312 .86587 m
.20978 .86722 L
s
.10706 .8319 m .1934 .8618 L .12415 .84869 L 0 .373 .691 r
F
0 g
.006 w
.12415 .84869 m
.14312 .86587 L
s
.29526 .25448 m .38844 .24319 L .2877 .24409 L .525 .796 .995 r
F
.29526 .25448 m .39329 .25212 L .38844 .24319 L F
0 g
.29526 .25448 m
.30577 .26455 L
s
.25 g
.5 Mabswid
.29526 .25448 m
.39329 .25212 L
s
1 0 0 r
.003 w
.39329 .25212 m
.40021 .2618 L
s
.22731 .8724 m
.24582 .87724 L
s
.10706 .8319 m .17832 .85625 L .1934 .8618 L 0 .373 .691 r
F
.09192 .81583 m .17832 .85625 L .10706 .8319 L .352 0 0 r
F
.25 g
.5 Mabswid
.12415 .84869 m
.12616 .84907 L
s
0 g
.006 w
.10706 .8319 m
.12415 .84869 L
s
1 0 0 r
.003 w
.20978 .86722 m
.22731 .8724 L
s
.2877 .24409 m .38582 .23503 L .28328 .23339 L .511 .809 .999 r
F
.2877 .24409 m .38844 .24319 L .38582 .23503 L F
0 g
.006 w
.2877 .24409 m
.29526 .25448 L
s
.25 g
.5 Mabswid
.2877 .24409 m
.38844 .24319 L
s
1 0 0 r
.003 w
.38844 .24319 m
.39329 .25212 L
s
.1934 .8618 m
.20978 .86722 L
s
.38582 .23503 m
.38844 .24319 L
s
.09192 .81583 m .16473 .85071 L .17832 .85625 L .352 0 0 r
F
.25 g
.5 Mabswid
.19102 .86135 m
.1934 .8618 L
s
.07878 .80079 m .16473 .85071 L .09192 .81583 L .452 0 0 r
F
.25 g
.12616 .84907 m
.19102 .86135 L
s
.10706 .8319 m
.10908 .83259 L
s
0 g
.006 w
.09192 .81583 m
.10706 .8319 L
s
.27993 .23821 m .38159 .24343 L .38378 .23475 L .533 .812 .997 r
F
0 g
.28539 .23849 m
.2877 .24409 L
s
1 0 0 r
.003 w
.17832 .85625 m
.1934 .8618 L
s
.27993 .23821 m .38378 .23475 L .28244 .22433 L .533 .812 .997 r
F
.25 g
.5 Mabswid
.27993 .23821 m
.38159 .24343 L
s
.38372 .23499 m
.38582 .23503 L
s
.07878 .80079 m .1528 .84533 L .16473 .85071 L .452 0 0 r
F
.25 g
.17521 .85518 m
.17832 .85625 L
s
.06773 .78707 m .1528 .84533 L .07878 .80079 L .513 0 0 r
F
.25 g
.10908 .83259 m
.17521 .85518 L
s
.09192 .81583 m
.09393 .8168 L
s
.09393 .8168 m
.15006 .84368 L
s
0 g
.006 w
.07878 .80079 m
.09192 .81583 L
s
.28244 .22433 m .38378 .23475 L .38836 .227 L .495 .805 1 r
F
1 0 0 r
.003 w
.38159 .24343 m
.38378 .23475 L
s
.16473 .85071 m
.17832 .85625 L
s
.28244 .22433 m .38836 .227 L .2885 .21032 L .495 .805 1 r
F
0 g
.006 w
.27993 .23821 m
.28244 .22433 L
s
.25 g
.5 Mabswid
.28244 .22433 m
.38378 .23475 L
s
.2885 .21032 m .38836 .227 L .39531 .22029 L .448 .786 .998 r
F
1 0 0 r
.003 w
.38378 .23475 m
.38836 .227 L
s
.06773 .78707 m .14272 .84028 L .1528 .84533 L .513 0 0 r
F
1 0 0 r
.1528 .84533 m
.16473 .85071 L
s
.05884 .77493 m .14272 .84028 L .06773 .78707 L .539 0 0 r
F
.25 g
.5 Mabswid
.07878 .80079 m
.08075 .80198 L
s
.08075 .80198 m
.13328 .83358 L
s
0 g
.006 w
.06773 .78707 m
.07878 .80079 L
s
.29817 .19638 m .39531 .22029 L .40453 .21473 L .399 .758 .994 r
F
.2885 .21032 m .39531 .22029 L .29817 .19638 L .448 .786 .998 r
F
.25 g
.5 Mabswid
.2885 .21032 m
.38836 .227 L
s
1 0 0 r
.003 w
.38836 .227 m
.39531 .22029 L
s
0 g
.006 w
.28244 .22433 m
.2885 .21032 L
s
.05884 .77493 m .13466 .83573 L .14272 .84028 L .539 0 0 r
F
1 0 0 r
.003 w
.14272 .84028 m
.1528 .84533 L
s
.05219 .76461 m .13466 .83573 L .05884 .77493 L .533 0 0 r
F
.25 g
.5 Mabswid
.06773 .78707 m
.06961 .7884 L
s
.06961 .7884 m
.122 .82558 L
s
0 g
.006 w
.05884 .77493 m
.06773 .78707 L
s
.31148 .18271 m .40453 .21473 L .41591 .21044 L .354 .722 .987 r
F
.29817 .19638 m .40453 .21473 L .31148 .18271 L .399 .758 .994 r
F
.25 g
.5 Mabswid
.30037 .19692 m
.39531 .22029 L
s
1 0 0 r
.003 w
.39531 .22029 m
.40453 .21473 L
s
0 g
.006 w
.2885 .21032 m
.29817 .19638 L
s
.25 g
.5 Mabswid
.29817 .19638 m
.30037 .19692 L
s
.32842 .16961 m .41591 .21044 L .42928 .2075 L .318 .683 .978 r
F
.31148 .18271 m .41591 .21044 L .32842 .16961 L .354 .722 .987 r
F
1 0 0 r
.003 w
.40453 .21473 m
.41591 .21044 L
s
0 g
.006 w
.29817 .19638 m
.31148 .18271 L
s
.25 g
.5 Mabswid
.31148 .18271 m
.31386 .18353 L
s
.05219 .76461 m .12879 .83183 L .13466 .83573 L .533 0 0 r
F
1 0 0 r
.003 w
.13466 .83573 m
.14272 .84028 L
s
.25 g
.5 Mabswid
.05884 .77493 m
.11808 .82243 L
s
.04788 .75636 m .12879 .83183 L .05219 .76461 L .494 0 0 r
F
0 g
.006 w
.05219 .76461 m
.05884 .77493 L
s
.3489 .15736 m .42928 .2075 L .44445 .20602 L .295 .644 .967 r
F
.32842 .16961 m .42928 .2075 L .3489 .15736 L .318 .683 .978 r
F
.25 g
.5 Mabswid
.31386 .18353 m
.40453 .21473 L
s
1 0 0 r
.003 w
.41591 .21044 m
.42928 .2075 L
s
.25 g
.5 Mabswid
.42484 .20474 m
.42928 .2075 L
s
.32842 .16961 m
.33082 .17073 L
s
0 g
.006 w
.31148 .18271 m
.32842 .16961 L
s
.04788 .75636 m .12527 .82873 L .12879 .83183 L .494 0 0 r
F
1 0 0 r
.003 w
.12879 .83183 m
.13466 .83573 L
s
.25 g
.5 Mabswid
.05219 .76461 m
.12879 .83183 L
s
.04602 .75036 m .12527 .82873 L .04788 .75636 L 0 .064 .571 r
F
0 g
.006 w
.04788 .75636 m
.05219 .76461 L
s
.37277 .14633 m .44445 .20602 L .46122 .20605 L .287 .606 .953 r
F
.3489 .15736 m .44445 .20602 L .37277 .14633 L .295 .644 .967 r
F
.25 g
.5 Mabswid
.33082 .17073 m
.41591 .21044 L
s
1 0 0 r
.003 w
.42928 .2075 m
.44445 .20602 L
s
.25 g
.5 Mabswid
.44136 .20345 m
.44445 .20602 L
s
.3489 .15736 m
.35094 .15864 L
s
.35094 .15864 m
.35121 .15881 L
s
.04602 .75036 m .12424 .82654 L .12527 .82873 L 0 .064 .571 r
F
1 0 0 r
.003 w
.12527 .82873 m
.12879 .83183 L
s
.25 g
.5 Mabswid
.04788 .75636 m
.12527 .82873 L
s
0 g
.006 w
.32842 .16961 m
.3489 .15736 L
s
.39981 .13687 m .46122 .20605 L .47938 .20762 L .293 .572 .935 r
F
.37277 .14633 m .46122 .20605 L .39981 .13687 L .287 .606 .953 r
F
1 0 0 r
.003 w
.44445 .20602 m
.46122 .20605 L
s
.25 g
.5 Mabswid
.45914 .2037 m
.46122 .20605 L
s
.37277 .14633 m
.37471 .14794 L
s
.37471 .14794 m
.37491 .14811 L
s
.04674 .74677 m .12424 .82654 L .04602 .75036 L 0 .129 .644 r
F
0 g
.006 w
.04602 .75036 m
.04788 .75636 L
s
.04674 .74677 m .12581 .82534 L .12424 .82654 L 0 .129 .644 r
F
1 0 0 r
.003 w
.12424 .82654 m
.12527 .82873 L
s
.25 g
.5 Mabswid
.04602 .75036 m
.12424 .82654 L
s
.42971 .12935 m .47938 .20762 L .49873 .21075 L .31 .541 .913 r
F
.39981 .13687 m .47938 .20762 L .42971 .12935 L .293 .572 .935 r
F
1 0 0 r
.003 w
.46122 .20605 m
.47938 .20762 L
s
.25 g
.5 Mabswid
.47598 .20226 m
.47938 .20762 L
s
.39981 .13687 m
.40155 .13883 L
s
.40155 .13883 m
.40169 .13898 L
s
.35121 .15881 m
.42484 .20474 L
s
0 g
.006 w
.3489 .15736 m
.37277 .14633 L
s
.4621 .12415 m .49873 .21075 L .51905 .21545 L .334 .516 .886 r
F
.42971 .12935 m .49873 .21075 L .4621 .12415 L .31 .541 .913 r
F
1 0 0 r
.003 w
.47938 .20762 m
.49873 .21075 L
s
.25 g
.5 Mabswid
.49799 .209 m
.49873 .21075 L
s
.42971 .12935 m
.43117 .13165 L
s
.43117 .13165 m
.43126 .13179 L
s
.40169 .13898 m
.45914 .2037 L
s
.37491 .14811 m
.44136 .20345 L
s
.05016 .74571 m .12581 .82534 L .04674 .74677 L 0 .205 .714 r
F
0 g
.006 w
.04602 .75036 m
.04674 .74677 L
s
.05016 .74571 m .13007 .82514 L .12581 .82534 L 0 .205 .714 r
F
1 0 0 r
.003 w
.12424 .82654 m
.12581 .82534 L
s
.25 g
.5 Mabswid
.04674 .74677 m
.12581 .82534 L
s
0 g
.006 w
.37277 .14633 m
.39981 .13687 L
s
.49653 .12163 m .51905 .21545 L .54016 .2217 L .363 .495 .858 r
F
.4621 .12415 m .51905 .21545 L .49653 .12163 L .334 .516 .886 r
F
1 0 0 r
.003 w
.49873 .21075 m
.51905 .21545 L
s
.25 g
.5 Mabswid
.51871 .21407 m
.51905 .21545 L
s
.4621 .12415 m
.46327 .1269 L
s
.43126 .13179 m
.47598 .20226 L
s
.05641 .74727 m .13007 .82514 L .05016 .74571 L 0 .283 .775 r
F
0 g
.006 w
.04674 .74677 m
.05016 .74571 L
s
.05641 .74727 m .13708 .82594 L .13007 .82514 L 0 .283 .775 r
F
1 0 0 r
.003 w
.12581 .82534 m
.13007 .82514 L
s
.25 g
.5 Mabswid
.05016 .74571 m
.13007 .82514 L
s
0 g
.006 w
.39981 .13687 m
.42971 .12935 L
s
.53249 .12209 m .54016 .2217 L .56188 .22949 L .393 .479 .829 r
F
.49653 .12163 m .54016 .2217 L .53249 .12209 L .363 .495 .858 r
F
1 0 0 r
.003 w
.51905 .21545 m
.54016 .2217 L
s
.25 g
.5 Mabswid
.49653 .12163 m
.49726 .12465 L
s
.49726 .12465 m
.51871 .21407 L
s
.46327 .1269 m
.49799 .209 L
s
.56942 .1258 m .56188 .22949 L .58404 .23879 L .425 .467 .801 r
F
.53249 .12209 m .56188 .22949 L .56942 .1258 L .393 .479 .829 r
F
1 0 0 r
.003 w
.54016 .2217 m
.56188 .22949 L
s
.25 g
.5 Mabswid
.53249 .12209 m
.54016 .2217 L
s
.06564 .75146 m .13708 .82594 L .05641 .74727 L 0 .356 .825 r
F
0 g
.006 w
.05016 .74571 m
.05641 .74727 L
s
.06564 .75146 m .14685 .82764 L .13708 .82594 L 0 .356 .825 r
F
1 0 0 r
.003 w
.13007 .82514 m
.13708 .82594 L
s
0 g
.006 w
.42971 .12935 m
.4621 .12415 L
s
.60673 .13297 m .58404 .23879 L .60647 .24961 L .456 .459 .773 r
F
.56942 .1258 m .58404 .23879 L .60673 .13297 L .425 .467 .801 r
F
1 0 0 r
.003 w
.56188 .22949 m
.58404 .23879 L
s
.25 g
.5 Mabswid
.56188 .22949 m
.56942 .1258 L
s
.07796 .75825 m .14685 .82764 L .06564 .75146 L .031 .423 .865 r
F
.25 g
.05641 .74727 m
.06 .75077 L
s
.07796 .75825 m .15936 .83012 L .14685 .82764 L .031 .423 .865 r
F
.25 g
.06 .75077 m
.13708 .82594 L
s
1 0 0 r
.003 w
.13708 .82594 m
.14685 .82764 L
s
.25 g
.5 Mabswid
.1228 .80509 m
.14685 .82764 L
s
0 g
.006 w
.05641 .74727 m
.06564 .75146 L
s
.4621 .12415 m
.49653 .12163 L
s
.64382 .14371 m .60647 .24961 L .62897 .26195 L .486 .455 .748 r
F
.25 g
.5 Mabswid
.58404 .23879 m
.58459 .23623 L
s
.60673 .13297 m .60647 .24961 L .64382 .14371 L .456 .459 .773 r
F
.25 g
.58459 .23623 m
.60673 .13297 L
s
1 0 0 r
.003 w
.58404 .23879 m
.60647 .24961 L
s
0 g
.006 w
.49653 .12163 m
.53249 .12209 L
s
.68011 .15806 m .62897 .26195 L .65134 .27582 L .516 .453 .724 r
F
.25 g
.5 Mabswid
.60647 .24961 m
.60763 .24632 L
s
.64382 .14371 m .62897 .26195 L .68011 .15806 L .486 .455 .748 r
F
.25 g
.60763 .24632 m
.64257 .14724 L
s
1 0 0 r
.003 w
.60647 .24961 m
.62897 .26195 L
s
.25 g
.5 Mabswid
.64257 .14724 m
.64382 .14371 L
s
.09347 .76751 m .15936 .83012 L .07796 .75825 L .082 .482 .894 r
F
.25 g
.06564 .75146 m
.06901 .75462 L
s
.09347 .76751 m .17453 .8332 L .15936 .83012 L .082 .482 .894 r
F
.25 g
.06901 .75462 m
.1228 .80509 L
s
1 0 0 r
.003 w
.14685 .82764 m
.15936 .83012 L
s
.25 g
.5 Mabswid
.1419 .81471 m
.15936 .83012 L
s
.71505 .176 m .65134 .27582 L .67336 .29124 L .546 .454 .703 r
F
.25 g
.62897 .26195 m
.63091 .25799 L
s
.68011 .15806 m .65134 .27582 L .71505 .176 L .516 .453 .724 r
F
1 0 0 r
.003 w
.62897 .26195 m
.65134 .27582 L
s
.25 g
.5 Mabswid
.6784 .16155 m
.68011 .15806 L
s
0 g
.006 w
.53249 .12209 m
.56942 .1258 L
s
.06564 .75146 m
.07796 .75825 L
s
.11225 .77906 m .17453 .8332 L .09347 .76751 L .112 .532 .914 r
F
.25 g
.5 Mabswid
.07796 .75825 m
.0812 .76111 L
s
.11225 .77906 m .19224 .83666 L .17453 .8332 L .112 .532 .914 r
F
1 0 0 r
.003 w
.15936 .83012 m
.17453 .8332 L
s
.25 g
.5 Mabswid
.16092 .82218 m
.17453 .8332 L
s
.74812 .19739 m .67336 .29124 L .69478 .30823 L .575 .458 .683 r
F
.25 g
.65134 .27582 m
.65423 .27128 L
s
.63091 .25799 m
.63262 .25452 L
s
.71505 .176 m .67336 .29124 L .74812 .19739 L .546 .454 .703 r
F
.25 g
.63262 .25452 m
.6784 .16155 L
s
1 0 0 r
.003 w
.65134 .27582 m
.67336 .29124 L
s
.25 g
.5 Mabswid
.7129 .17937 m
.71505 .176 L
s
0 g
.006 w
.56942 .1258 m
.60673 .13297 L
s
.77888 .22205 m .69478 .30823 L .71532 .3268 L .604 .465 .665 r
F
.25 g
.5 Mabswid
.67336 .29124 m
.67733 .28625 L
s
.65423 .27128 m
.65663 .26753 L
s
.74812 .19739 m .69478 .30823 L .77888 .22205 L .575 .458 .683 r
F
.25 g
.65663 .26753 m
.7129 .17937 L
s
1 0 0 r
.003 w
.67336 .29124 m
.69478 .30823 L
s
.25 g
.5 Mabswid
.74557 .20059 m
.74812 .19739 L
s
0 g
.006 w
.60673 .13297 m
.64382 .14371 L
s
.1343 .79261 m .19224 .83666 L .11225 .77906 L .117 .57 .918 r
F
.25 g
.5 Mabswid
.09347 .76751 m
.09661 .77005 L
s
.0812 .76111 m
.08136 .76125 L
s
.1343 .79261 m .21234 .84027 L .19224 .83666 L .117 .57 .918 r
F
.25 g
.08136 .76125 m
.1419 .81471 L
s
1 0 0 r
.003 w
.17453 .8332 m
.19224 .83666 L
s
.25 g
.5 Mabswid
.17267 .82257 m
.18127 .82876 L
s
.18127 .82876 m
.19224 .83666 L
s
0 g
.006 w
.64382 .14371 m
.68011 .15806 L
s
.80697 .24972 m .71532 .3268 L .73469 .34693 L .633 .474 .649 r
F
.25 g
.5 Mabswid
.69478 .30823 m
.69995 .30293 L
s
.67733 .28625 m
.68051 .28227 L
s
.77888 .22205 m .71532 .3268 L .80697 .24972 L .604 .465 .665 r
F
1 0 0 r
.003 w
.69478 .30823 m
.71532 .3268 L
s
.25 g
.5 Mabswid
.77598 .22502 m
.77888 .22205 L
s
.89916 .42163 m .80359 .46801 L .90726 .46014 L .772 .561 .614 r
F
.89916 .42163 m .79444 .44157 L .80359 .46801 L F
.88757 .38399 m .79444 .44157 L .89916 .42163 L .747 .539 .614 r
F
.90726 .46014 m .80998 .49513 L .9119 .49917 L .794 .585 .617 r
F
.90726 .46014 m .80359 .46801 L .80998 .49513 L F
0 g
.006 w
.89916 .42163 m
.90726 .46014 L
s
.25 g
.5 Mabswid
.80359 .46801 m
.90726 .46014 L
s
.88757 .38399 m .78273 .41605 L .79444 .44157 L .747 .539 .614 r
F
.25 g
.79444 .44157 m
.89916 .42163 L
s
.87249 .34761 m .78273 .41605 L .88757 .38399 L .72 .519 .618 r
F
0 g
.006 w
.88757 .38399 m
.89916 .42163 L
s
.87249 .34761 m .76869 .39166 L .78273 .41605 L .72 .519 .618 r
F
.85396 .31285 m .76869 .39166 L .87249 .34761 L .691 .501 .625 r
F
.25 g
.5 Mabswid
.8838 .38514 m
.88757 .38399 L
s
0 g
.006 w
.87249 .34761 m
.88757 .38399 L
s
.9119 .49917 m .81348 .52266 L .91315 .53835 L .813 .608 .625 r
F
.9119 .49917 m .80998 .49513 L .81348 .52266 L F
0 g
.90726 .46014 m
.9119 .49917 L
s
.25 g
.5 Mabswid
.80998 .49513 m
.9119 .49917 L
s
0 g
.006 w
.68011 .15806 m
.71505 .176 L
s
.07796 .75825 m
.09347 .76751 L
s
.85396 .31285 m .75258 .36858 L .76869 .39166 L .691 .501 .625 r
F
.25 g
.5 Mabswid
.71532 .3268 m
.72679 .31716 L
s
.76869 .39166 m
.78003 .38685 L
s
.78273 .41605 m
.8838 .38514 L
s
.83206 .2801 m .75258 .36858 L .85396 .31285 L .662 .486 .636 r
F
.25 g
.86881 .34917 m
.87249 .34761 L
s
0 g
.006 w
.85396 .31285 m
.87249 .34761 L
s
.25 g
.5 Mabswid
.85033 .31485 m
.85396 .31285 L
s
.91315 .53835 m .814 .5503 L .91106 .57735 L .826 .63 .637 r
F
.91315 .53835 m .81348 .52266 L .814 .5503 L F
0 g
.006 w
.9119 .49917 m
.91315 .53835 L
s
.25 g
.5 Mabswid
.81348 .52266 m
.91315 .53835 L
s
.83206 .2801 m .73469 .34693 L .75258 .36858 L .662 .486 .636 r
F
.25 g
.69995 .30293 m
.70398 .2988 L
s
.75258 .36858 m
.76211 .36334 L
s
.78003 .38685 m
.86881 .34917 L
s
.68051 .28227 m
.68462 .27711 L
s
.80697 .24972 m .73469 .34693 L .83206 .2801 L .633 .474 .649 r
F
.25 g
.68462 .27711 m
.74557 .20059 L
s
1 0 0 r
.003 w
.71532 .3268 m
.73469 .34693 L
s
.25 g
.5 Mabswid
.72679 .31716 m
.80377 .25241 L
s
.76211 .36334 m
.85033 .31485 L
s
.70398 .2988 m
.77598 .22502 L
s
0 g
.006 w
.83206 .2801 m
.85396 .31285 L
s
.25 g
.5 Mabswid
.74263 .34149 m
.82863 .28246 L
s
.73469 .34693 m
.74263 .34149 L
s
.82863 .28246 m
.82971 .28172 L
s
.82971 .28172 m
.83206 .2801 L
s
.80377 .25241 m
.80697 .24972 L
s
0 g
.006 w
.80697 .24972 m
.83206 .2801 L
s
.71505 .176 m
.74812 .19739 L
s
.77888 .22205 m
.80697 .24972 L
s
.74812 .19739 m
.77888 .22205 L
s
1 0 0 r
.003 w
.73469 .34693 m
.75258 .36858 L
s
.91106 .57735 m .8115 .57776 L .90572 .61584 L .835 .648 .651 r
F
.91106 .57735 m .814 .5503 L .8115 .57776 L F
0 g
.006 w
.91106 .57735 m
.91315 .53835 L
s
.25 g
.5 Mabswid
.814 .5503 m
.91106 .57735 L
s
.1596 .80781 m .21234 .84027 L .1343 .79261 L .094 .591 .899 r
F
.25 g
.11225 .77906 m
.11528 .78124 L
s
.09661 .77005 m
.09674 .77016 L
s
.16101 .80867 m .23462 .84376 L .21234 .84027 L .094 .591 .899 r
F
.16065 .80845 m .16138 .8088 L .16101 .80867 L F
.16138 .8088 m .23462 .84376 L .16101 .80867 L F
.16236 .80913 m .23462 .84376 L .16065 .80845 L F
.1596 .80781 m .16236 .80913 L .16065 .80845 L F
.18805 .82421 m .23462 .84376 L .1596 .80781 L .038 .583 .84 r
F
.18805 .82421 m .25885 .84689 L .23462 .84376 L F
.25365 .85851 m .28183 .8503 L .21949 .8413 L .164 0 0 r
F
.21949 .8413 m .25705 .84664 L .18805 .82421 L 0 .532 .725 r
F
.25705 .84664 m .25885 .84689 L .25283 .84496 L F
.25705 .84664 m .25283 .84496 L .18805 .82421 L F
.21949 .8413 m .28477 .84944 L .25885 .84689 L F
.28183 .8503 m .28477 .84944 L .27626 .84838 L .164 0 0 r
F
.28183 .8503 m .27626 .84838 L .21949 .8413 L F
.25 g
.09674 .77016 m
.16092 .82218 L
s
.11528 .78124 m
.11539 .78132 L
s
.11539 .78132 m
.17267 .82257 L
s
1 0 0 r
.003 w
.19224 .83666 m
.21234 .84027 L
s
.25 g
.5 Mabswid
.1343 .79261 m
.13721 .79439 L
s
.13721 .79439 m
.1373 .79444 L
s
.1373 .79444 m
.19645 .83056 L
s
.19645 .83056 m
.21234 .84027 L
s
1 0 0 r
.003 w
.21234 .84027 m
.21974 .84142 L
s
.75258 .36858 m
.76869 .39166 L
s
.90572 .61584 m .80597 .60475 L .8972 .65349 L .837 .662 .666 r
F
.90572 .61584 m .8115 .57776 L .80597 .60475 L F
0 g
.006 w
.90572 .61584 m
.91106 .57735 L
s
1 0 0 r
.003 w
.76869 .39166 m
.78273 .41605 L
s
.8972 .65349 m .79747 .63098 L .88557 .68999 L .834 .671 .68 r
F
.8972 .65349 m .80597 .60475 L .79747 .63098 L F
0 g
.006 w
.8972 .65349 m
.90572 .61584 L
s
.25 g
.5 Mabswid
.88739 .64824 m
.8972 .65349 L
s
.8115 .57776 m
.90572 .61584 L
s
1 0 0 r
.003 w
.78273 .41605 m
.79444 .44157 L
s
.25 g
.5 Mabswid
.1596 .80781 m
.16236 .80913 L
s
.16236 .80913 m
.20547 .82979 L
s
.88557 .68999 m .78608 .6562 L .87091 .72503 L .826 .673 .693 r
F
.88557 .68999 m .79747 .63098 L .78608 .6562 L F
0 g
.006 w
.88557 .68999 m
.8972 .65349 L
s
.25 g
.5 Mabswid
.80597 .60475 m
.88739 .64824 L
s
1 0 0 r
.003 w
.79444 .44157 m
.80359 .46801 L
s
0 g
.006 w
.09347 .76751 m
.11225 .77906 L
s
1 0 0 r
.003 w
.80359 .46801 m
.80998 .49513 L
s
.87091 .72503 m .77194 .68019 L .85327 .75831 L .814 .668 .702 r
F
.87091 .72503 m .78608 .6562 L .77194 .68019 L F
0 g
.006 w
.87091 .72503 m
.88557 .68999 L
s
.25 g
.5 Mabswid
.86988 .7242 m
.87091 .72503 L
s
.18805 .82421 m
.19063 .82504 L
s
.19063 .82504 m
.24236 .84161 L
s
.24236 .84161 m
.25535 .84577 L
s
1 0 0 r
.003 w
.80998 .49513 m
.81348 .52266 L
s
.81348 .52266 m
.814 .5503 L
s
.85327 .75831 m .75519 .70277 L .83273 .78952 L .798 .657 .707 r
F
.85327 .75831 m .77194 .68019 L .75519 .70277 L F
0 g
.006 w
.85327 .75831 m
.87091 .72503 L
s
.25 g
.5 Mabswid
.85252 .75758 m
.85327 .75831 L
s
.85163 .75673 m
.85252 .75758 L
s
.77194 .68019 m
.78659 .69426 L
s
.79747 .63098 m
.88557 .68999 L
s
1 0 0 r
.003 w
.8115 .57776 m
.814 .5503 L
s
.25 g
.5 Mabswid
.21949 .8413 m
.27626 .84838 L
s
.25365 .85851 m .31214 .85121 L .28477 .84944 L .164 0 0 r
F
.25 g
.27626 .84838 m
.28477 .84944 L
s
1 0 0 r
.003 w
.80597 .60475 m
.8115 .57776 L
s
0 g
.006 w
.11225 .77906 m
.1343 .79261 L
s
.83273 .78952 m .73603 .72378 L .80935 .81835 L .781 .641 .707 r
F
.83273 .78952 m .75519 .70277 L .73603 .72378 L F
.25 g
.5 Mabswid
.78608 .6562 m
.86988 .7242 L
s
.78659 .69426 m
.85163 .75673 L
s
0 g
.006 w
.83273 .78952 m
.85327 .75831 L
s
.25 g
.5 Mabswid
.8314 .78803 m
.83273 .78952 L
s
.83088 .78744 m
.8314 .78803 L
s
.75519 .70277 m
.76416 .7128 L
s
1 0 0 r
.003 w
.79747 .63098 m
.80597 .60475 L
s
.29023 .87523 m .31214 .85121 L .25365 .85851 L .278 0 0 r
F
.29023 .87523 m .34067 .85202 L .31214 .85121 L F
1 0 0 r
.28477 .84944 m
.31214 .85121 L
s
.78608 .6562 m
.79747 .63098 L
s
.77194 .68019 m
.78608 .6562 L
s
.32883 .89085 m .34067 .85202 L .29023 .87523 L .376 0 0 r
F
.25 g
.5 Mabswid
.25365 .85851 m
.25574 .85825 L
s
.25574 .85825 m
.31214 .85121 L
s
.32883 .89085 m .37011 .85177 L .34067 .85202 L .376 0 0 r
F
1 0 0 r
.003 w
.31214 .85121 m
.34067 .85202 L
s
.25 g
.5 Mabswid
.33785 .85332 m
.34067 .85202 L
s
.80935 .81835 m .71467 .74314 L .78322 .84452 L .763 .62 .701 r
F
.80935 .81835 m .73603 .72378 L .71467 .74314 L F
.25 g
.76416 .7128 m
.83088 .78744 L
s
0 g
.006 w
.80935 .81835 m
.83273 .78952 L
s
.25 g
.5 Mabswid
.8078 .81634 m
.80935 .81835 L
s
.80744 .81589 m
.8078 .81634 L
s
.75149 .74373 m
.80744 .81589 L
s
.73603 .72378 m
.75149 .74373 L
s
1 0 0 r
.003 w
.75519 .70277 m
.77194 .68019 L
s
.369 .90476 m .37011 .85177 L .32883 .89085 L .45 0 .048 r
F
.25 g
.5 Mabswid
.32883 .89085 m
.36812 .85366 L
s
.29023 .87523 m
.29201 .87441 L
s
.29201 .87441 m
.33785 .85332 L
s
.369 .90476 m .40023 .85035 L .37011 .85177 L .45 0 .048 r
F
1 0 0 r
.003 w
.34067 .85202 m
.37011 .85177 L
s
.25 g
.5 Mabswid
.36812 .85366 m
.37011 .85177 L
s
1 0 0 r
.003 w
.73603 .72378 m
.75519 .70277 L
s
0 g
.006 w
.1343 .79261 m
.1596 .80781 L
s
.41027 .9164 m .40023 .85035 L .369 .90476 L .505 .092 .19 r
F
.25 g
.5 Mabswid
.369 .90476 m
.39894 .8526 L
s
.41027 .9164 m .43079 .84771 L .40023 .85035 L .505 .092 .19 r
F
1 0 0 r
.003 w
.37011 .85177 m
.40023 .85035 L
s
.25 g
.5 Mabswid
.39894 .8526 m
.40023 .85035 L
s
.78322 .84452 m .69132 .7608 L .75443 .86774 L .744 .595 .691 r
F
.78322 .84452 m .71467 .74314 L .69132 .7608 L F
0 g
.006 w
.78322 .84452 m
.80935 .81835 L
s
.25 g
.5 Mabswid
.71467 .74314 m
.78322 .84452 L
s
1 0 0 r
.003 w
.71467 .74314 m
.73603 .72378 L
s
.45213 .92528 m .43079 .84771 L .41027 .9164 L .546 .182 .302 r
F
.45213 .92528 m .46157 .84379 L .43079 .84771 L F
1 0 0 r
.40023 .85035 m
.43079 .84771 L
s
.25 g
.5 Mabswid
.41027 .9164 m
.43079 .84771 L
s
.75443 .86774 m .69132 .7608 L .66623 .77673 L .725 .567 .675 r
F
1 0 0 r
.003 w
.69132 .7608 m
.71467 .74314 L
s
.49407 .93099 m .46157 .84379 L .45213 .92528 L .578 .257 .389 r
F
.49407 .93099 m .49237 .83855 L .46157 .84379 L F
1 0 0 r
.43079 .84771 m
.46157 .84379 L
s
.25 g
.5 Mabswid
.45213 .92528 m
.46157 .84379 L
s
.7231 .88775 m .66623 .77673 L .63964 .79095 L .706 .535 .655 r
F
.75443 .86774 m .66623 .77673 L .7231 .88775 L .725 .567 .675 r
F
1 0 0 r
.003 w
.66623 .77673 m
.69132 .7608 L
s
0 g
.006 w
.75443 .86774 m
.78322 .84452 L
s
.53562 .9332 m .49237 .83855 L .49407 .93099 L .605 .32 .458 r
F
.53562 .9332 m .523 .83196 L .49237 .83855 L F
1 0 0 r
.003 w
.46157 .84379 m
.49237 .83855 L
s
.25 g
.5 Mabswid
.49237 .83855 m
.49407 .93099 L
s
.6894 .90431 m .63964 .79095 L .61179 .80353 L .687 .501 .629 r
F
.7231 .88775 m .63964 .79095 L .6894 .90431 L .706 .535 .655 r
F
1 0 0 r
.003 w
.63964 .79095 m
.66623 .77673 L
s
.25 g
.5 Mabswid
.63964 .79095 m
.64113 .79434 L
s
.72142 .88446 m
.7231 .88775 L
s
.69132 .7608 m
.75443 .86774 L
s
.5763 .9317 m .523 .83196 L .53562 .9332 L .628 .374 .514 r
F
.5763 .9317 m .55325 .82397 L .523 .83196 L F
1 0 0 r
.003 w
.49237 .83855 m
.523 .83196 L
s
.25 g
.5 Mabswid
.523 .83196 m
.53562 .9332 L
s
0 g
.006 w
.7231 .88775 m
.75443 .86774 L
s
.65353 .91724 m .61179 .80353 L .58292 .81451 L .668 .463 .598 r
F
.6894 .90431 m .61179 .80353 L .65353 .91724 L .687 .501 .629 r
F
1 0 0 r
.003 w
.61179 .80353 m
.63964 .79095 L
s
.25 g
.5 Mabswid
.61179 .80353 m
.61275 .80614 L
s
.68789 .90086 m
.6894 .90431 L
s
.66623 .77673 m
.72142 .88446 L
s
.61573 .92639 m .55325 .82397 L .5763 .9317 L .649 .421 .56 r
F
.61573 .92639 m .58292 .81451 L .55325 .82397 L F
1 0 0 r
.003 w
.523 .83196 m
.55325 .82397 L
s
.25 g
.5 Mabswid
.55325 .82397 m
.5763 .9317 L
s
.65353 .91724 m .58292 .81451 L .61573 .92639 L .668 .463 .598 r
F
.25 g
.58292 .81451 m
.58348 .81642 L
s
.58348 .81642 m
.61469 .92284 L
s
.61469 .92284 m
.61573 .92639 L
s
1 0 0 r
.003 w
.55325 .82397 m
.58292 .81451 L
s
.58292 .81451 m
.61179 .80353 L
s
.25 g
.5 Mabswid
.61275 .80614 m
.65223 .9137 L
s
.65223 .9137 m
.65353 .91724 L
s
.64113 .79434 m
.68789 .90086 L
s
0 g
.006 w
.1596 .80781 m
.18805 .82421 L
s
.6894 .90431 m
.7231 .88775 L
s
.65353 .91724 m
.6894 .90431 L
s
.18805 .82421 m
.21949 .8413 L
s
.61573 .92639 m
.65353 .91724 L
s
.21949 .8413 m
.25365 .85851 L
s
.5763 .9317 m
.61573 .92639 L
s
.25365 .85851 m
.29023 .87523 L
s
.53562 .9332 m
.5763 .9317 L
s
.29023 .87523 m
.32883 .89085 L
s
.49407 .93099 m
.53562 .9332 L
s
.32883 .89085 m
.369 .90476 L
s
.45213 .92528 m
.49407 .93099 L
s
.41027 .9164 m
.45213 .92528 L
s
.369 .90476 m
.41027 .9164 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{276.688, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 125; kappa[s_] = 1; tau[s_] := Sin[s]; width = 1.0; 
    ds = .1; \), 
    \(pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 0 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.45486 .63609 m .4231 .62595 L .44548 .61385 L .489 .902 .836 r
F
.4231 .62595 m .42293 .6259 L .42317 .62577 L F
.4231 .62595 m .42317 .62577 L .44548 .61385 L F
.44548 .61385 m .42317 .62577 L .44521 .61586 L 0 0 0 r
F
.42317 .62577 m .42293 .6259 L .44521 .61586 L F
.44548 .61385 m .44521 .61586 L .43565 .59169 L F
.43579 .59175 m .44521 .61586 L .46766 .60517 L F
.43565 .59169 m .43574 .5919 L .43579 .59175 L F
.43574 .5919 m .44521 .61586 L .43579 .59175 L F
.25 g
.5 Mabswid
.42317 .62577 m
.4446 .61432 L
s
.43565 .59169 m .46766 .60517 L .42565 .56968 L 0 0 0 r
F
.25 g
.43565 .59169 m
.43574 .5919 L
s
.45486 .63609 m .40142 .6353 L .42293 .6259 L .489 .902 .836 r
F
.25 g
.42293 .6259 m
.42317 .62577 L
s
.46357 .65833 m .40142 .6353 L .45486 .63609 L .619 .948 .937 r
F
0 g
.006 w
.44614 .61542 m
.45486 .63609 L
s
.42565 .56968 m .48965 .59383 L .41572 .54788 L .202 0 0 r
F
.42565 .56968 m .46766 .60517 L .48965 .59383 L F
.25 g
.5 Mabswid
.44511 .6156 m
.44521 .61586 L
s
0 g
.006 w
.42565 .56968 m
.43565 .59169 L
s
.25 g
.5 Mabswid
.42565 .56968 m
.42601 .56999 L
s
.46357 .65833 m .38118 .64409 L .40142 .6353 L .619 .948 .937 r
F
.25 g
.40142 .6353 m
.45486 .63609 L
s
.47137 .68051 m .38118 .64409 L .46357 .65833 L .68 .933 .968 r
F
0 g
.006 w
.45486 .63609 m
.46357 .65833 L
s
.41572 .54788 m .51058 .58184 L .40615 .52635 L .356 0 .107 r
F
.41572 .54788 m .48965 .59383 L .51058 .58184 L F
.25 g
.5 Mabswid
.4672 .60479 m
.46766 .60517 L
s
0 g
.006 w
.41572 .54788 m
.42565 .56968 L
s
.25 g
.5 Mabswid
.41637 .54828 m
.41638 .54829 L
s
.41572 .54788 m
.41637 .54828 L
s
.4451 .6156 m
.44511 .6156 L
s
.43574 .5919 m
.4451 .6156 L
s
.47137 .68051 m .36262 .65228 L .38118 .64409 L .68 .933 .968 r
F
.47805 .70252 m .36262 .65228 L .47137 .68051 L .704 .897 .966 r
F
.25 g
.46289 .65822 m
.46357 .65833 L
s
0 g
.006 w
.46357 .65833 m
.47137 .68051 L
s
.47805 .70252 m .346 .65988 L .36262 .65228 L .704 .897 .966 r
F
.25 g
.5 Mabswid
.36262 .65228 m
.36362 .65254 L
s
.38118 .64409 m
.46289 .65822 L
s
.48343 .72428 m .346 .65988 L .47805 .70252 L .708 .857 .953 r
F
.25 g
.47048 .68028 m
.47137 .68051 L
s
0 g
.006 w
.47137 .68051 m
.47805 .70252 L
s
.40615 .52635 m .52991 .56927 L .39722 .50515 L .462 .087 .241 r
F
.40615 .52635 m .51058 .58184 L .52991 .56927 L F
.25 g
.5 Mabswid
.48885 .59333 m
.48965 .59383 L
s
0 g
.006 w
.40615 .52635 m
.41572 .54788 L
s
.25 g
.5 Mabswid
.40615 .52635 m
.40709 .52685 L
s
.40709 .52685 m
.40709 .52685 L
s
.4672 .60478 m
.4672 .60479 L
s
.42601 .56999 m
.4672 .60478 L
s
.48343 .72428 m .33146 .66686 L .346 .65988 L .708 .857 .953 r
F
.48734 .74568 m .33146 .66686 L .48343 .72428 L .703 .818 .936 r
F
.25 g
.47699 .70218 m
.47805 .70252 L
s
0 g
.006 w
.47805 .70252 m
.48343 .72428 L
s
.39722 .50515 m .5472 .55621 L .38918 .48433 L .535 .192 .333 r
F
.39722 .50515 m .52991 .56927 L .5472 .55621 L F
.25 g
.5 Mabswid
.48884 .59332 m
.48885 .59333 L
s
.50946 .58124 m
.51058 .58184 L
s
0 g
.006 w
.39722 .50515 m
.40615 .52635 L
s
.25 g
.5 Mabswid
.39722 .50515 m
.39843 .50574 L
s
.39843 .50574 m
.39843 .50574 L
s
.48734 .74568 m .31903 .67316 L .33146 .66686 L .703 .818 .936 r
F
.48963 .7666 m .31903 .67316 L .48734 .74568 L .694 .782 .919 r
F
.25 g
.48223 .72383 m
.48343 .72428 L
s
0 g
.006 w
.48343 .72428 m
.48734 .74568 L
s
.38918 .48433 m .56216 .54279 L .38231 .46395 L .589 .271 .397 r
F
.38918 .48433 m .5472 .55621 L .56216 .54279 L F
.25 g
.5 Mabswid
.50946 .58124 m
.50946 .58124 L
s
.52852 .5686 m
.52991 .56927 L
s
0 g
.006 w
.38918 .48433 m
.39722 .50515 L
s
.25 g
.5 Mabswid
.38918 .48433 m
.39016 .48478 L
s
.39016 .48478 m
.39066 .48501 L
s
.41638 .54829 m
.48884 .59332 L
s
.48963 .7666 m .30865 .67871 L .31903 .67316 L .694 .782 .919 r
F
.49019 .78692 m .30865 .67871 L .48963 .7666 L .682 .748 .901 r
F
.25 g
.48605 .74512 m
.48734 .74568 L
s
0 g
.006 w
.48734 .74568 m
.48963 .7666 L
s
.38231 .46395 m .57466 .52916 L .37686 .44405 L .631 .332 .444 r
F
.38231 .46395 m .56216 .54279 L .57466 .52916 L F
.25 g
.5 Mabswid
.5285 .56859 m
.52852 .5686 L
s
.54559 .55548 m
.5472 .55621 L
s
0 g
.006 w
.38231 .46395 m
.38918 .48433 L
s
.25 g
.5 Mabswid
.38231 .46395 m
.38347 .46445 L
s
.38347 .46445 m
.38404 .46471 L
s
.49019 .78692 m .30019 .68339 L .30865 .67871 L .682 .748 .901 r
F
.48891 .80649 m .30019 .68339 L .49019 .78692 L .669 .717 .884 r
F
.25 g
.4883 .76595 m
.48963 .7666 L
s
0 g
.006 w
.48963 .7666 m
.49019 .78692 L
s
.37686 .44405 m .5847 .51554 L .37306 .4247 L .666 .381 .479 r
F
.37686 .44405 m .57466 .52916 L .5847 .51554 L F
.25 g
.5 Mabswid
.54556 .55547 m
.54559 .55548 L
s
.56041 .54202 m
.56216 .54279 L
s
0 g
.006 w
.37686 .44405 m
.38231 .46395 L
s
.25 g
.5 Mabswid
.37686 .44405 m
.37686 .44405 L
s
.37686 .44405 m
.37819 .44462 L
s
.37819 .44462 m
.37882 .44489 L
s
.40709 .52685 m
.50946 .58124 L
s
.43719 .28615 m .53796 .37101 L .45579 .27626 L .9 .674 .586 r
F
.53796 .37101 m .55463 .38505 L .51653 .33783 L F
.55463 .38505 m .5464 .36812 L .51653 .33783 L F
.53796 .37101 m .51653 .33783 L .45579 .27626 L F
.42071 .2974 m .55991 .39681 L .43719 .28615 L .88 .64 .571 r
F
.55991 .39681 m .56716 .40199 L .55482 .38627 L F
.56716 .40199 m .56477 .39473 L .55482 .38627 L F
.55991 .39681 m .55482 .38627 L .43719 .28615 L F
.40649 .30991 m .54512 .39561 L .42071 .2974 L .857 .614 .569 r
F
.55918 .4133 m .57851 .43575 L .56592 .42177 L .966 .667 .409 r
F
.55337 .40599 m .55909 .41276 L .55918 .4133 L F
.55909 .41276 m .57851 .43575 L .55918 .4133 L F
.55325 .40538 m .57851 .43575 L .55337 .40599 L F
.54507 .39539 m .57851 .43575 L .54512 .39561 L F
.56592 .42177 m .57851 .43575 L .57806 .43687 L F
.54512 .39561 m .53182 .37887 L .42071 .2974 L .857 .614 .569 r
F
.53178 .37876 m .57851 .43575 L .53206 .3797 L .966 .667 .409 r
F
.56229 .43217 m .56645 .43438 L .56097 .42416 L .812 .564 .564 r
F
.42071 .2974 m .53182 .37887 L .53102 .37618 L .88 .64 .571 r
F
.50572 .34622 m .57851 .43575 L .50634 .34772 L .966 .667 .409 r
F
.54512 .39561 m .55325 .40538 L .55337 .40599 L F
.54209 .3918 m .54507 .39539 L .54512 .39561 L F
.40649 .30991 m .54619 .40012 L .54512 .39561 L .857 .614 .569 r
F
.54512 .39561 m .5527 .40029 L .53182 .37887 L F
.53206 .3797 m .54209 .3918 L .56592 .42177 L .966 .667 .409 r
F
.54523 .39606 m .57731 .43593 L .55626 .40231 L F
.57731 .43593 m .57806 .43687 L .57725 .43558 L F
.57731 .43593 m .57725 .43558 L .55626 .40231 L F
.5527 .40029 m .54584 .38916 L .53182 .37887 L .857 .614 .569 r
F
.54512 .39561 m .54788 .39756 L .5527 .40029 L F
.56139 .41336 m .56454 .41544 L .5649 .41905 L .982 .697 .387 r
F
.56454 .41544 m .57771 .43631 L .5649 .41905 L F
.55658 .40456 m .55645 .40363 L .54512 .39561 L .857 .614 .569 r
F
.54619 .40012 m .55695 .40707 L .54512 .39561 L F
.55419 .40439 m .55658 .40456 L .54512 .39561 L F
.55695 .40707 m .55678 .40591 L .55419 .40439 L F
.55678 .40591 m .55658 .40456 L .55419 .40439 L F
.54523 .39606 m .55626 .40231 L .54957 .39172 L .966 .667 .409 r
F
.55626 .40231 m .56095 .40974 L .55626 .40232 L .982 .697 .387 r
F
.56095 .40974 m .57806 .43687 L .56095 .40975 L F
.56095 .40974 m .56095 .40975 L .55626 .40232 L F
.55552 .41687 m .56229 .42079 L .55427 .41057 L .835 .589 .567 r
F
.55678 .40591 m .56113 .41125 L .56139 .41336 L .982 .697 .387 r
F
.56113 .41125 m .56454 .41544 L .56139 .41336 L F
.55626 .40232 m .56454 .41544 L .56409 .41489 L F
.55629 .40251 m .56409 .41489 L .55678 .40591 L F
.55626 .40232 m .56409 .41489 L .55629 .40251 L F
.54523 .39606 m .54957 .39172 L .53827 .38396 L .966 .667 .409 r
F
.5527 .40029 m .55629 .40251 L .54584 .38916 L .857 .614 .569 r
F
.54957 .39172 m .55626 .40231 L .54958 .39172 L .982 .697 .387 r
F
.53102 .37618 m .54928 .39008 L .54911 .38909 L .88 .64 .571 r
F
.55626 .40231 m .55626 .40232 L .54958 .39174 L .982 .697 .387 r
F
.54851 .39098 m .54928 .39008 L .53102 .37618 L .88 .64 .571 r
F
.54961 .39192 m .54957 .39172 L .54851 .39098 L F
.54957 .39172 m .54928 .39008 L .54851 .39098 L F
.50634 .34772 m .53178 .37876 L .53206 .3797 L .966 .667 .409 r
F
.43719 .28615 m .5046 .34352 L .50422 .3426 L .9 .674 .586 r
F
.45017 .27791 m .50572 .34622 L .50634 .34772 L .966 .667 .409 r
F
.56092 .40538 m .56377 .40714 L .56076 .40398 L .857 .614 .569 r
F
.55626 .40231 m .54958 .39174 L .54958 .39172 L .982 .697 .387 r
F
.50422 .3426 m .53812 .37165 L .53796 .37101 L .9 .674 .586 r
F
.53182 .37887 m .54961 .39192 L .53102 .37618 L .88 .64 .571 r
F
.5046 .34352 m .53824 .37215 L .50422 .3426 L .9 .674 .586 r
F
.53824 .37215 m .55482 .38627 L .53812 .37165 L F
.55482 .38627 m .55477 .38592 L .53812 .37165 L F
.53796 .37101 m .5547 .38548 L .55463 .38505 L F
.5649 .41905 m .57771 .43631 L .57728 .43908 L .982 .697 .387 r
F
.57728 .43908 m .57771 .43631 L .57772 .43979 L F
.56139 .41336 m .57708 .43875 L .56672 .41592 L F
.57708 .43875 m .57708 .43862 L .56672 .41592 L F
.57728 .43908 m .57722 .4387 L .56672 .41592 L F
.56645 .43438 m .57281 .43775 L .56575 .42748 L .812 .564 .564 r
F
.57366 .43805 m .57747 .44437 L .57728 .45044 L .952 .706 .249 r
F
.57266 .43464 m .57359 .43653 L .57366 .43805 L F
.57359 .43653 m .57747 .44437 L .57366 .43805 L F
.56927 .42606 m .57772 .43979 L .57747 .44437 L .983 .712 .332 r
F
.56719 .42141 m .56888 .4207 L .56927 .42606 L F
.57708 .43875 m .57728 .43908 L .57708 .43862 L .982 .697 .387 r
F
.57728 .43908 m .57772 .43979 L .57722 .4387 L F
.56888 .4207 m .57772 .43979 L .56927 .42606 L .983 .712 .332 r
F
.56673 .41605 m .57772 .43979 L .56673 .41606 L F
.53812 .37165 m .55477 .38592 L .53796 .37101 L .9 .674 .586 r
F
.55477 .38592 m .55473 .3857 L .53796 .37101 L F
.56475 .39447 m .56474 .39436 L .55472 .38563 L F
.55473 .3857 m .55472 .38563 L .53796 .37101 L F
.56475 .39447 m .55472 .38563 L .55473 .3857 L F
.56473 .3943 m .56471 .39414 L .5547 .38548 L F
.57145 .40022 m .5547 .38548 L .55472 .38563 L F
.55477 .38592 m .56475 .39447 L .55473 .3857 L F
.55629 .40251 m .55033 .39305 L .54584 .38916 L .857 .614 .569 r
F
.54956 .3917 m .55626 .40232 L .55571 .40159 L .982 .697 .387 r
F
.55033 .39305 m .54961 .39192 L .54584 .38916 L .857 .614 .569 r
F
.54941 .39161 m .55571 .40159 L .54686 .38985 L .982 .697 .387 r
F
.54956 .3917 m .55571 .40159 L .54941 .39161 L F
.56866 .4089 m .56738 .40495 L .54961 .39192 L .857 .614 .569 r
F
.5687 .40904 m .54961 .39192 L .55033 .39305 L F
.57328 .41301 m .56866 .4089 L .5687 .40904 L F
.56866 .4089 m .54961 .39192 L .5687 .40904 L F
.56377 .40714 m .56184 .40307 L .55033 .39305 L F
.55678 .40591 m .56139 .41336 L .56407 .41016 L .982 .697 .387 r
F
.56139 .41336 m .56672 .41592 L .56407 .41016 L F
.54961 .39192 m .56025 .39972 L .54928 .39008 L .88 .64 .571 r
F
.56025 .39972 m .56009 .39831 L .54928 .39008 L F
.55472 .38563 m .5547 .38548 L .53796 .37101 L .9 .674 .586 r
F
.56673 .41605 m .56673 .41606 L .56409 .41035 L .983 .712 .332 r
F
.5527 .40029 m .56389 .40837 L .56377 .40714 L .857 .614 .569 r
F
.54788 .39756 m .56395 .40895 L .5527 .40029 L F
.56395 .40895 m .56932 .41275 L .56389 .40837 L F
.56932 .41275 m .56929 .41225 L .56389 .40837 L F
.57656 .41504 m .60615 .43884 L .60582 .43313 L F
.56917 .41047 m .57332 .41428 L .57328 .41301 L F
.56377 .40714 m .56922 .41121 L .56917 .41047 L F
.56922 .41121 m .57332 .41428 L .56917 .41047 L F
.56389 .40837 m .57335 .41519 L .56377 .40714 L F
.57335 .41519 m .57334 .41489 L .56377 .40714 L F
.57658 .41751 m .57657 .41671 L .56377 .40714 L F
.56395 .40895 m .56389 .40837 L .5527 .40029 L F
.56673 .41605 m .56409 .41034 L .56409 .41034 L .983 .712 .332 r
F
.56673 .41605 m .56409 .41035 L .56409 .41034 L F
.56025 .39972 m .57253 .40872 L .56009 .39831 L .88 .64 .571 r
F
.57253 .40872 m .57647 .41161 L .57249 .40775 L F
.57647 .41161 m .57647 .41078 L .57249 .40775 L F
.57335 .41519 m .57658 .41751 L .57334 .41489 L .857 .614 .569 r
F
.57328 .41301 m .57657 .41671 L .57656 .41504 L F
.57332 .41428 m .57657 .41671 L .57328 .41301 L F
.56932 .41275 m .60615 .43884 L .56929 .41225 L F
.57253 .40872 m .57249 .40775 L .56009 .39831 L .88 .64 .571 r
F
.55399 .39931 m .55626 .40232 L .55678 .40591 L .982 .697 .387 r
F
.56092 .40538 m .56076 .40398 L .55033 .39305 L .857 .614 .569 r
F
.55629 .40251 m .56092 .40538 L .55033 .39305 L F
.54911 .38909 m .56004 .39791 L .55991 .39681 L .88 .64 .571 r
F
.54928 .39008 m .56009 .39831 L .54911 .38909 L F
.56009 .39831 m .56004 .39791 L .54911 .38909 L F
.57345 .41772 m .57337 .41562 L .56395 .40895 L .857 .614 .569 r
F
.56405 .40993 m .56395 .40895 L .55645 .40363 L F
.57345 .41772 m .56395 .40895 L .56405 .40993 L F
.56673 .41605 m .56409 .41034 L .56409 .41034 L .983 .712 .332 r
F
.5641 .41042 m .55645 .40363 L .55658 .40456 L .857 .614 .569 r
F
.56409 .41033 m .56673 .41605 L .56409 .41034 L .983 .712 .332 r
F
.56405 .40993 m .55645 .40363 L .5641 .41042 L .857 .614 .569 r
F
.55695 .40707 m .56423 .41177 L .55658 .40456 L F
.56407 .41016 m .56672 .41592 L .56409 .41033 L .983 .712 .332 r
F
.56672 .41592 m .57772 .43979 L .56673 .41605 L F
.56672 .41592 m .56673 .41605 L .56409 .41033 L F
.56166 .41565 m .56701 .41932 L .56153 .41452 L .835 .589 .567 r
F
.39464 .32357 m .56685 .41742 L .40649 .30991 L F
.56673 .41606 m .56843 .41973 L .56754 .41892 L .983 .712 .332 r
F
.56673 .41606 m .56754 .41892 L .56685 .41742 L F
.56685 .41742 m .56423 .41177 L .40649 .30991 L .835 .589 .567 r
F
.56701 .41932 m .56693 .41836 L .56153 .41452 L F
.56423 .41177 m .5641 .41042 L .55658 .40456 L .857 .614 .569 r
F
.55678 .40591 m .56407 .41016 L .49605 .26253 L .982 .697 .387 r
F
.5672 .42162 m .56701 .41932 L .56166 .41565 L .835 .589 .567 r
F
.56153 .41452 m .56693 .41836 L .56685 .41742 L F
.56125 .40815 m .56673 .41606 L .56719 .42141 L .983 .712 .332 r
F
.56062 .40286 m .56673 .41606 L .56125 .40815 L F
.5789 .42399 m .60615 .43884 L .57922 .42145 L .835 .589 .567 r
F
.57103 .42209 m .60616 .44624 L .57098 .42124 L F
.57771 .43631 m .57806 .43687 L .57772 .43979 L .982 .697 .387 r
F
.57686 .4399 m .60565 .45517 L .57682 .43516 L .812 .564 .564 r
F
.57647 .41161 m .60582 .43313 L .57647 .41078 L .88 .64 .571 r
F
.57658 .41751 m .60615 .43884 L .57657 .41671 L .857 .614 .569 r
F
.57657 .41671 m .60615 .43884 L .57656 .41504 L F
.56719 .42141 m .5771 .44356 L .5711 .42337 L .983 .712 .332 r
F
.5771 .44356 m .5771 .44335 L .5711 .42337 L F
.57728 .44395 m .57747 .44437 L .57721 .44352 L F
.57728 .44395 m .57721 .44352 L .5711 .42337 L F
.57283 .42918 m .57747 .44437 L .57674 .44235 L .952 .706 .249 r
F
.57283 .42918 m .57674 .44235 L .57351 .43332 L F
.57252 .43009 m .57351 .43332 L .57244 .43032 L F
.57283 .42918 m .57351 .43332 L .57252 .43009 L F
.3852 .33828 m .57241 .42975 L .39464 .32357 L .812 .564 .564 r
F
.57283 .42918 m .57244 .43032 L .57235 .42855 L .952 .706 .249 r
F
.57241 .42975 m .57125 .42599 L .39464 .32357 L .812 .564 .564 r
F
.57111 .42356 m .57283 .42918 L .57132 .42719 L .952 .706 .249 r
F
.56685 .41742 m .5789 .42399 L .56423 .41177 L .835 .589 .567 r
F
.56843 .41973 m .56888 .4207 L .56693 .41836 L .983 .712 .332 r
F
.56701 .41932 m .57103 .42209 L .56693 .41836 L .835 .589 .567 r
F
.57103 .42209 m .57098 .42124 L .56693 .41836 L F
.5789 .42399 m .57922 .42145 L .56423 .41177 L F
.56685 .41742 m .56754 .41892 L .56693 .41836 L .983 .712 .332 r
F
.56693 .41836 m .56888 .4207 L .56719 .42141 L F
.56423 .41177 m .57345 .41772 L .5641 .41042 L .857 .614 .569 r
F
.57345 .41772 m .56405 .40993 L .5641 .41042 L F
.56009 .39831 m .56834 .40459 L .56004 .39791 L .88 .64 .571 r
F
.57125 .42599 m .57103 .42209 L .56701 .41932 L .835 .589 .567 r
F
.57125 .42599 m .56701 .41932 L .5672 .42162 L F
.55482 .38627 m .57146 .40043 L .55477 .38592 L .9 .674 .586 r
F
.57146 .40043 m .57634 .40458 L .57146 .40036 L F
.57146 .40043 m .57146 .40036 L .55477 .38592 L F
.57634 .40458 m .57634 .40454 L .57146 .40032 L F
.57146 .40036 m .57146 .40032 L .55477 .38592 L F
.57634 .40458 m .57146 .40032 L .57146 .40036 L F
.58015 .40782 m .58016 .40768 L .57634 .40441 L F
.57146 .40032 m .57145 .40022 L .55477 .38592 L F
.58019 .40657 m .60531 .42924 L .60473 .42724 L F
.5714 .39917 m .57634 .40398 L .57633 .40333 L F
.55463 .38505 m .57143 .39969 L .5714 .39917 L F
.57143 .39969 m .57634 .40398 L .5714 .39917 L F
.5547 .38548 m .57634 .40419 L .55463 .38505 L F
.57634 .40419 m .60531 .42924 L .57634 .40398 L F
.57634 .40419 m .57634 .40398 L .55463 .38505 L F
.56377 .40714 m .57328 .41301 L .56184 .40307 L .857 .614 .569 r
F
.55991 .39681 m .56834 .40459 L .57646 .41 L .88 .64 .571 r
F
.57645 .40862 m .57646 .41 L .60531 .42924 L F
.55991 .39681 m .57646 .41 L .57645 .40862 L F
.57229 .42728 m .57747 .44437 L .5723 .42743 L .952 .706 .249 r
F
.57691 .44238 m .60434 .46543 L .60565 .45517 L .79 .54 .559 r
F
.57258 .4332 m .57334 .43493 L .57266 .43464 L .952 .706 .249 r
F
.57569 .4403 m .57747 .44437 L .57579 .44099 L F
.56943 .42829 m .57245 .43053 L .57241 .42975 L .812 .564 .564 r
F
.5771 .44356 m .57728 .44395 L .5771 .44335 L .983 .712 .332 r
F
.57281 .43775 m .57253 .43218 L .56575 .42748 L .812 .564 .564 r
F
.57253 .43218 m .57245 .43053 L .56943 .42829 L F
.57132 .42719 m .57244 .43032 L .57153 .43078 L .952 .706 .249 r
F
.57244 .43032 m .57747 .44437 L .57258 .4332 L F
.56956 .43012 m .57253 .43218 L .56943 .42829 L .812 .564 .564 r
F
.57244 .43032 m .57258 .4332 L .57153 .43078 L .952 .706 .249 r
F
.57253 .43218 m .5749 .43382 L .57245 .43053 L .812 .564 .564 r
F
.5749 .43382 m .57485 .43232 L .57245 .43053 L F
.57245 .43053 m .57485 .43232 L .57241 .42975 L F
.57485 .43232 m .60565 .45517 L .57483 .4316 L F
.57485 .43232 m .57483 .4316 L .57241 .42975 L F
.57266 .43464 m .57728 .45044 L .57495 .43561 L .952 .706 .249 r
F
.56004 .39791 m .56834 .40459 L .55991 .39681 L .88 .64 .571 r
F
.57089 .41962 m .57414 .42348 L .57407 .42136 L .835 .589 .567 r
F
.56685 .41742 m .57096 .42084 L .57089 .41962 L F
.57096 .42084 m .57414 .42348 L .57089 .41962 L F
.56693 .41836 m .57098 .42124 L .56685 .41742 L F
.57098 .42124 m .57414 .42348 L .57096 .42084 L F
.57098 .42124 m .57096 .42084 L .56685 .41742 L F
.57229 .42728 m .5723 .42743 L .57111 .42356 L .952 .706 .249 r
F
.55463 .38505 m .5714 .39917 L .5464 .36812 L .9 .674 .586 r
F
.5714 .39917 m .57103 .39709 L .5464 .36812 L F
.57633 .40333 m .57621 .39833 L .57016 .39219 L F
.57103 .39709 m .57016 .39219 L .5464 .36812 L F
.57633 .40333 m .57016 .39219 L .57103 .39709 L F
.57102 .42333 m .5711 .42337 L .57095 .42286 L .983 .712 .332 r
F
.57102 .42333 m .57095 .42286 L .53847 .31562 L F
.56719 .42141 m .57102 .42333 L .53847 .31562 L F
.57111 .42347 m .57111 .42356 L .56973 .41901 L .952 .706 .249 r
F
.57229 .42728 m .57111 .42356 L .57111 .42347 L F
.56971 .41877 m .5711 .42337 L .57107 .42335 L F
.5711 .42337 m .57229 .42728 L .57111 .42347 L F
.5711 .42337 m .57111 .42347 L .57107 .42335 L F
.56971 .41877 m .57107 .42335 L .56973 .41901 L F
.57241 .42975 m .60616 .44624 L .57125 .42599 L .812 .564 .564 r
F
.57241 .42975 m .60565 .45517 L .60616 .44624 L F
.57235 .42855 m .57244 .43032 L .57132 .42719 L .952 .706 .249 r
F
.56973 .41901 m .57111 .42356 L .57002 .42356 L F
.56229 .42079 m .57125 .42599 L .56685 .42125 L .835 .589 .567 r
F
.57111 .42356 m .57132 .42719 L .57002 .42356 L .952 .706 .249 r
F
.57266 .43464 m .5743 .43534 L .57253 .43218 L .812 .564 .564 r
F
.57378 .44098 m .57552 .44238 L .57551 .44175 L .79 .54 .559 r
F
.37819 .35396 m .57551 .44175 L .3852 .33828 L F
.57496 .43579 m .57543 .43879 L .57528 .44034 L .87 .667 .139 r
F
.57496 .43579 m .57528 .44034 L .57505 .43894 L F
.57543 .43879 m .57728 .45044 L .57555 .4435 L F
.57551 .44175 m .57505 .43894 L .3852 .33828 L .79 .54 .559 r
F
.57418 .45057 m .57576 .45135 L .57378 .44098 L F
.57543 .43865 m .57728 .45044 L .57543 .43865 L .87 .667 .139 r
F
.57796 .45243 m .60434 .46543 L .57807 .44442 L .79 .54 .559 r
F
.57686 .4399 m .57682 .43516 L .5749 .43382 L .812 .564 .564 r
F
.57498 .43655 m .5749 .43382 L .57253 .43218 L F
.57495 .43561 m .57728 .45044 L .57496 .43579 L .87 .667 .139 r
F
.57495 .43561 m .57543 .43865 L .57495 .43561 L F
.57686 .4399 m .5749 .43382 L .57498 .43655 L .812 .564 .564 r
F
.57328 .41301 m .57253 .40872 L .56738 .40495 L .857 .614 .569 r
F
.57328 .41301 m .56738 .40495 L .56866 .4089 L F
.57145 .40022 m .57144 .39995 L .56471 .39414 L .9 .674 .586 r
F
.57145 .40022 m .56471 .39414 L .56473 .3943 L F
.57153 .43078 m .57258 .4332 L .57266 .43464 L .952 .706 .249 r
F
.57125 .42599 m .60616 .44624 L .57103 .42209 L .835 .589 .567 r
F
.56475 .39447 m .57145 .40022 L .56474 .39436 L .9 .674 .586 r
F
.56834 .40459 m .60582 .43313 L .60542 .43004 L .88 .64 .571 r
F
.56834 .40459 m .60542 .43004 L .60531 .42924 L F
.56716 .40199 m .57645 .40862 L .56477 .39473 L F
.57645 .40862 m .60531 .42924 L .57634 .40458 L F
.57645 .40862 m .57634 .40458 L .56477 .39473 L F
.57796 .45243 m .57807 .44442 L .57692 .4435 L .79 .54 .559 r
F
.57694 .44825 m .57692 .4435 L .57552 .44238 L F
.57266 .43464 m .57495 .43561 L .54679 .25606 L .952 .706 .249 r
F
.57443 .4323 m .57495 .43561 L .57444 .43253 L .87 .667 .139 r
F
.57495 .43561 m .57496 .43579 L .57444 .43253 L F
.57576 .45135 m .57552 .44238 L .57378 .44098 L .79 .54 .559 r
F
.57608 .45057 m .57728 .45044 L .57717 .45777 L .87 .667 .139 r
F
.57523 .44488 m .576 .44699 L .57608 .45057 L F
.576 .44699 m .57728 .45044 L .57608 .45057 L F
.57514 .44181 m .57728 .45044 L .57523 .44488 L F
.57567 .4478 m .57608 .45057 L .57696 .44826 L F
.57608 .45057 m .57717 .45777 L .57702 .45082 L F
.57608 .45057 m .57702 .45082 L .57696 .44826 L F
.57696 .44826 m .57702 .45082 L .57696 .44826 L .729 .587 .013 r
F
.57702 .45082 m .57717 .45777 L .57702 .45082 L F
.57702 .45082 m .57702 .45082 L .57696 .44826 L F
.57771 .45448 m .58907 .46497 L .60434 .46543 L .768 .514 .55 r
F
.58907 .46497 m .60192 .47684 L .60359 .46894 L F
.58907 .46497 m .60359 .46894 L .60434 .46543 L F
.57543 .43865 m .57543 .43865 L .57495 .43561 L .87 .667 .139 r
F
.57543 .43879 m .57544 .43915 L .5754 .43913 L F
.57544 .43915 m .57555 .4435 L .5754 .43913 L F
.5754 .43913 m .57555 .4435 L .57514 .44181 L F
.57505 .43894 m .57686 .4399 L .57498 .43655 L .812 .564 .564 r
F
.57576 .45135 m .57699 .45195 L .57639 .44806 L .79 .54 .559 r
F
.57567 .4478 m .57639 .44806 L .57552 .44238 L F
.57576 .45135 m .57639 .44806 L .57567 .4478 L F
.57699 .45195 m .57696 .44832 L .57552 .44238 L F
.57551 .44175 m .60565 .45517 L .57505 .43894 L F
.57551 .44175 m .57692 .4435 L .57691 .44238 L F
.57552 .44238 m .57692 .4435 L .57551 .44175 L F
.5714 .39917 m .57633 .40333 L .57103 .39709 L .9 .674 .586 r
F
.5749 .43382 m .60565 .45517 L .57485 .43232 L .812 .564 .564 r
F
.57634 .40454 m .57634 .40441 L .57145 .40022 L .9 .674 .586 r
F
.57634 .40454 m .57145 .40022 L .57146 .40032 L F
.57145 .40022 m .60531 .42924 L .57144 .39995 L F
.57407 .42136 m .60616 .44624 L .60615 .43884 L .835 .589 .567 r
F
.57414 .42348 m .60616 .44624 L .57407 .42136 L F
.57345 .41772 m .60615 .43884 L .57337 .41562 L .857 .614 .569 r
F
.57328 .41301 m .60582 .43313 L .57253 .40872 L F
.57567 .4478 m .57696 .44826 L .57272 .25344 L .87 .667 .139 r
F
.57677 .43973 m .57702 .45082 L .57677 .43973 L .729 .587 .013 r
F
.57702 .45082 m .57717 .45777 L .57702 .45082 L F
.57702 .45082 m .57702 .45082 L .57677 .43973 L F
.5764 .46495 m .57712 .46529 L .57616 .45384 L .768 .514 .55 r
F
.57712 .46529 m .57704 .45464 L .57616 .45384 L F
.57616 .45384 m .57704 .45464 L .57704 .45421 L F
.37356 .37051 m .57704 .45421 L .37819 .35396 L F
.57704 .45421 m .57704 .45414 L .37819 .35396 L F
.57696 .44832 m .57696 .44826 L .57694 .44825 L .79 .54 .559 r
F
.57677 .43973 m .57717 .45777 L .57708 .45569 L .729 .587 .013 r
F
.57677 .43973 m .57708 .45569 L .57682 .44445 L F
.57771 .45448 m .57796 .45243 L .57699 .45195 L .768 .514 .55 r
F
.57704 .45414 m .57699 .45195 L .37819 .35396 L F
.57771 .45448 m .57699 .45195 L .57704 .45414 L F
.57682 .44445 m .57708 .45569 L .57688 .4512 L .729 .587 .013 r
F
.57688 .4512 m .57708 .45569 L .57719 .46604 L F
.57708 .45569 m .57717 .45777 L .57717 .45992 L F
.57708 .45569 m .57717 .45992 L .57719 .46604 L F
.57704 .45421 m .57771 .45448 L .57704 .45414 L .768 .514 .55 r
F
.5771 .46169 m .57719 .46604 L .57762 .46183 L .729 .587 .013 r
F
.57762 .4619 m .57719 .46604 L .57758 .46526 L 0 0 .108 r
F
.57758 .4655 m .60192 .47684 L .5777 .45522 L .768 .514 .55 r
F
.57785 .45963 m .57762 .46183 L .57785 .45973 L 0 0 .108 r
F
.57762 .46183 m .57719 .46604 L .57762 .4619 L F
.57762 .46183 m .57762 .4619 L .57785 .45973 L F
.57736 .46736 m .60192 .47684 L .57758 .4655 L .745 .486 .539 r
F
.57736 .46736 m .59806 .48914 L .60192 .47684 L F
.57736 .46736 m .57719 .46604 L .57725 .46828 L 0 0 .108 r
F
.57726 .47985 m .59806 .48914 L .57736 .46736 L .745 .486 .539 r
F
.57762 .4652 m .57725 .46828 L .57745 .47494 L 0 0 .108 r
F
.37125 .38786 m .57726 .47985 L .57736 .46736 L .745 .486 .539 r
F
.57762 .4652 m .57738 .46567 L .57736 .46736 L 0 0 .108 r
F
.57738 .46567 m .57719 .46604 L .57736 .46736 L F
.57859 .46327 m .57762 .4652 L .57745 .47494 L F
.37125 .38786 m .57736 .46736 L .37356 .37051 L .745 .486 .539 r
F
.57736 .46736 m .57758 .4655 L .37356 .37051 L F
.57712 .46529 m .57758 .4655 L .57704 .45464 L .768 .514 .55 r
F
.57758 .4655 m .5777 .45522 L .57704 .45464 L F
.57704 .45421 m .57771 .45481 L .57771 .45448 L F
.57771 .45481 m .60192 .47684 L .57771 .45448 L F
.57704 .45464 m .60192 .47684 L .57704 .45421 L F
.57696 .44826 m .57692 .4435 L .57694 .44825 L .79 .54 .559 r
F
.57796 .45243 m .57692 .4435 L .57696 .44832 L F
.57344 .28752 m .5767 .43634 L .57681 .44798 L .729 .587 .013 r
F
.57341 .28639 m .57345 .28787 L .57344 .28752 L F
.57345 .28787 m .5767 .43634 L .57344 .28752 L F
.5769 .44563 m .57696 .44826 L .5769 .44563 L F
.57696 .44826 m .57696 .44826 L .5769 .44563 L F
.57699 .45195 m .57796 .45243 L .57696 .44832 L .79 .54 .559 r
F
.57771 .45448 m .60434 .46543 L .57796 .45243 L .768 .514 .55 r
F
.57664 .43358 m .57664 .43358 L .5736 .29395 L .729 .587 .013 r
F
.5736 .29395 m .5736 .29395 L .57274 .25439 L F
.57664 .43358 m .5736 .29395 L .5736 .29395 L F
.57633 .40333 m .60473 .42724 L .57621 .39833 L .9 .674 .586 r
F
.57274 .25439 m .5736 .29394 L .57341 .28639 L .729 .587 .013 r
F
.5736 .29394 m .5767 .43634 L .57341 .28639 L F
.57692 .4435 m .60434 .46543 L .57691 .44238 L .79 .54 .559 r
F
.57681 .44798 m .57677 .43973 L .57688 .4512 L .729 .587 .013 r
F
.5767 .43634 m .57677 .43973 L .57681 .44798 L F
.57677 .43973 m .57677 .43973 L .57664 .43358 L F
.57664 .43358 m .57664 .43358 L .57274 .25439 L F
.57677 .43973 m .57664 .43358 L .57664 .43358 L F
.57275 .25471 m .57664 .43358 L .57274 .25439 L F
.57664 .43358 m .57677 .43973 L .57664 .43358 L F
.57633 .40333 m .58017 .40731 L .58019 .40657 L .9 .674 .586 r
F
.57634 .40398 m .58017 .40731 L .57633 .40333 L F
.58017 .40731 m .60531 .42924 L .58019 .40657 L F
.58015 .40782 m .57634 .40441 L .57634 .40454 L F
.5767 .43633 m .5767 .43633 L .57664 .43358 L .729 .587 .013 r
F
.57664 .43357 m .57664 .43358 L .57273 .25383 L F
.5767 .43633 m .57664 .43358 L .57664 .43357 L F
.57273 .254 m .57664 .43357 L .57273 .25383 L F
.57664 .43357 m .5767 .43633 L .57664 .43357 L F
.57664 .43357 m .57664 .43357 L .57273 .25383 L F
.57634 .40458 m .58015 .40782 L .57634 .40454 L .9 .674 .586 r
F
.58015 .40782 m .60531 .42924 L .58016 .40768 L F
.5767 .43633 m .5769 .44563 L .5767 .43633 L .729 .587 .013 r
F
.5769 .44563 m .5769 .44563 L .5767 .43633 L F
.57273 .25383 m .57275 .25471 L .57274 .25439 L F
.57272 .25344 m .57273 .254 L .57273 .25383 L F
.57272 .25344 m .5771 .46169 L .5991 .25455 L F
.5771 .46169 m .57762 .46183 L .5991 .25455 L F
.579 .44878 m .57762 .4619 L .57859 .46327 L 0 0 .108 r
F
.57762 .4619 m .57758 .46526 L .57859 .46327 L F
.37356 .37051 m .5764 .46495 L .57616 .45384 L .768 .514 .55 r
F
.57281 .43775 m .57505 .43894 L .5743 .43534 L .812 .564 .564 r
F
.57419 .43799 m .57514 .44181 L .57523 .44488 L .87 .667 .139 r
F
.57505 .43894 m .57498 .43655 L .5743 .43534 L .812 .564 .564 r
F
.57505 .43894 m .57528 .44034 L .57514 .44181 L .87 .667 .139 r
F
.57245 .41965 m .57245 .41965 L .55324 .29723 L F
.57266 .43464 m .54679 .25606 L .54677 .25607 L .952 .706 .249 r
F
.55324 .29723 m .55324 .29723 L .54676 .25588 L .87 .667 .139 r
F
.57245 .41965 m .55324 .29723 L .55324 .29723 L F
.54679 .25606 m .55325 .29726 L .54676 .25588 L F
.55325 .29726 m .57245 .41965 L .55324 .29723 L F
.55325 .29726 m .55324 .29723 L .54676 .25588 L F
.57245 .41965 m .57245 .41965 L .55324 .29722 L F
.55324 .29723 m .55324 .29722 L .54676 .25588 L F
.57245 .41965 m .55324 .29722 L .55324 .29723 L F
.57385 .42883 m .57493 .4356 L .57409 .43525 L F
.57493 .4356 m .57496 .43579 L .57409 .43525 L F
.57281 .43775 m .5743 .43534 L .57266 .43464 L .812 .564 .564 r
F
.57409 .43525 m .57496 .43579 L .57419 .43799 L .87 .667 .139 r
F
.57496 .43579 m .57514 .44181 L .57419 .43799 L F
.57384 .42855 m .57495 .43561 L .57384 .42855 L F
.57495 .43561 m .57495 .43561 L .57384 .42855 L F
.57297 .42993 m .57385 .42883 L .57419 .43799 L F
.55245 .29371 m .57247 .4201 L .57297 .42993 L F
.57247 .4201 m .57385 .42883 L .57297 .42993 L F
.54677 .25607 m .54679 .25606 L .54653 .25445 L .952 .706 .249 r
F
.57384 .42855 m .57384 .42855 L .57245 .41965 L .87 .667 .139 r
F
.57384 .42855 m .57245 .41965 L .57245 .41965 L F
.57245 .41965 m .57384 .42855 L .57245 .41965 L F
.57317 .42432 m .57317 .42454 L .57247 .4201 L F
.57246 .41986 m .57247 .4201 L .55245 .29371 L F
.57317 .42432 m .57247 .4201 L .57246 .41986 L F
.57385 .4286 m .57385 .42883 L .57317 .42454 L F
.57385 .4286 m .57317 .42454 L .57317 .42432 L F
.57443 .4323 m .57444 .43253 L .57385 .42883 L F
.57443 .4323 m .57385 .42883 L .57385 .4286 L F
.54673 .25569 m .54679 .25606 L .54671 .25559 L F
.54679 .25606 m .54676 .25588 L .54671 .25559 L F
.54657 .2547 m .54673 .25569 L .54656 .25462 L F
.54673 .25569 m .54671 .25559 L .54656 .25462 L F
.55484 .3074 m .57245 .41965 L .55245 .29371 L F
.57245 .41965 m .57443 .4323 L .57246 .41986 L F
.57245 .41965 m .57246 .41986 L .55245 .29371 L F
.54656 .25462 m .55484 .3074 L .55245 .29371 L F
.54653 .25445 m .54657 .2547 L .54656 .25462 L F
.54653 .25445 m .57567 .4478 L .57275 .25522 L F
.54653 .25445 m .57275 .25522 L .57272 .25344 L F
.58743 .37338 m .579 .44878 L .57859 .46327 L 0 0 .108 r
F
.59473 .29909 m .58333 .40754 L .58743 .37338 L F
.58333 .40754 m .579 .44878 L .58743 .37338 L F
.57901 .44845 m .57785 .45963 L .579 .44878 L F
.57785 .45963 m .57785 .45973 L .579 .44878 L F
.59342 .30943 m .57901 .44845 L .59473 .29909 L F
.57901 .44845 m .579 .44878 L .59473 .29909 L F
.5991 .25455 m .59342 .30943 L .59473 .29909 L F
.55576 .39211 m .56407 .41016 L .56399 .41011 L .983 .712 .332 r
F
.56407 .41016 m .56409 .41033 L .56399 .41011 L F
.55576 .39211 m .56399 .41011 L .55581 .39244 L F
.55581 .39244 m .56409 .41033 L .55581 .39246 L F
.56409 .41033 m .56409 .41034 L .55581 .39246 L F
.56409 .41034 m .56062 .40285 L .56062 .40285 L F
.56409 .41034 m .56062 .40285 L .56409 .41034 L F
.56062 .40285 m .55581 .39247 L .55581 .39246 L F
.56062 .40285 m .55581 .39247 L .56062 .40285 L F
.56594 .4066 m .56973 .41901 L .5667 .41425 L .952 .706 .249 r
F
.56973 .41901 m .57002 .42356 L .5667 .41425 L F
.5659 .40619 m .56971 .41877 L .56594 .4066 L F
.56971 .41877 m .56973 .41901 L .56594 .4066 L F
.53699 .31457 m .53847 .31562 L .52087 .25752 L .983 .712 .332 r
F
.56409 .41034 m .56062 .40286 L .56062 .40285 L F
.56409 .41034 m .56062 .40286 L .56409 .41034 L F
.56409 .41034 m .56398 .41011 L .56398 .41011 L F
.56409 .41034 m .56409 .41035 L .56398 .41011 L F
.56719 .42141 m .53847 .31562 L .53699 .31457 L F
.5659 .40619 m .56594 .4066 L .53346 .30015 L .952 .706 .249 r
F
.53359 .30056 m .53346 .30015 L .53043 .29021 L F
.5659 .40619 m .53346 .30015 L .53359 .30056 L F
.53482 .30357 m .53847 .31562 L .53043 .29021 L F
.53847 .31562 m .5659 .40619 L .53359 .30056 L F
.53847 .31562 m .53359 .30056 L .53043 .29021 L F
.5667 .41425 m .57132 .42719 L .57153 .43078 L F
.53043 .29021 m .56594 .4066 L .5667 .41425 L F
.52087 .25752 m .53482 .30357 L .53043 .29021 L F
.52087 .25752 m .57266 .43464 L .54677 .25607 L F
.52087 .25752 m .54677 .25607 L .54653 .25445 L F
.54686 .38985 m .55399 .39931 L .55678 .40591 L .982 .697 .387 r
F
.56398 .41011 m .56398 .41011 L .56062 .40286 L .983 .712 .332 r
F
.56062 .40285 m .56062 .40286 L .55581 .39247 L F
.55581 .39246 m .55581 .39247 L .50777 .28871 L F
.5084 .29001 m .55581 .39244 L .50777 .28871 L F
.55581 .39244 m .55581 .39246 L .50777 .28871 L F
.51322 .2998 m .55576 .39211 L .50702 .28703 L F
.55576 .39211 m .55581 .39244 L .50702 .28703 L F
.51573 .30591 m .55581 .39247 L .51109 .29611 L F
.55581 .39247 m .56062 .40286 L .55582 .3925 L F
.55581 .39247 m .55582 .3925 L .51109 .29611 L F
.55669 .39796 m .56062 .40286 L .56125 .40815 L F
.51109 .29611 m .55582 .3925 L .55669 .39796 L F
.55582 .3925 m .56062 .40286 L .55669 .39796 L F
.50777 .28871 m .51573 .30591 L .51109 .29611 L F
.50702 .28703 m .5084 .29001 L .50777 .28871 L F
.49605 .26253 m .51322 .2998 L .50702 .28703 L F
.49605 .26253 m .56719 .42141 L .52087 .25752 L F
.56205 .41885 m .56685 .42125 L .56166 .41565 L .835 .589 .567 r
F
.56229 .42079 m .56685 .42125 L .56205 .41885 L F
.37819 .35396 m .57418 .45057 L .57378 .44098 L .79 .54 .559 r
F
.53824 .37215 m .53812 .37165 L .50422 .3426 L .9 .674 .586 r
F
.53827 .38396 m .54957 .39172 L .47239 .26937 L .966 .667 .409 r
F
.53981 .37845 m .54956 .3917 L .54686 .38985 L .982 .697 .387 r
F
.47413 .27218 m .53891 .37483 L .53981 .37845 L F
.53891 .37483 m .54956 .3917 L .53981 .37845 L F
.54958 .39172 m .54958 .39174 L .53891 .37483 L F
.53891 .37482 m .53891 .37483 L .47413 .27218 L F
.54958 .39172 m .53891 .37483 L .53891 .37482 L F
.45017 .27791 m .53206 .3797 L .47602 .27568 L .966 .667 .409 r
F
.53206 .3797 m .54523 .39606 L .53827 .38396 L F
.53206 .3797 m .53827 .38396 L .47602 .27568 L F
.56229 .42079 m .56166 .41565 L .55427 .41057 L .835 .589 .567 r
F
.47567 .27457 m .54957 .39172 L .47413 .27218 L .982 .697 .387 r
F
.54957 .39172 m .54958 .39172 L .47413 .27218 L F
.47239 .26937 m .47567 .27457 L .47413 .27218 L F
.47239 .26937 m .55678 .40591 L .49605 .26253 L F
.55427 .41057 m .56166 .41565 L .56153 .41452 L .835 .589 .567 r
F
.47219 .26945 m .47602 .27568 L .47239 .26937 L .966 .667 .409 r
F
.45017 .27791 m .47602 .27568 L .47219 .26945 L F
.56645 .43438 m .56575 .42748 L .56097 .42416 L .812 .564 .564 r
F
.56097 .42416 m .56956 .43012 L .56943 .42829 L F
.3852 .33828 m .56229 .43217 L .56097 .42416 L F
.39464 .32357 m .55552 .41687 L .55427 .41057 L .835 .589 .567 r
F
.48891 .80649 m .29351 .68711 L .30019 .68339 L .669 .717 .884 r
F
.48572 .82516 m .29351 .68711 L .48891 .80649 L .656 .687 .867 r
F
.25 g
.48888 .7862 m
.49019 .78692 L
s
0 g
.006 w
.48891 .80649 m
.49019 .78692 L
s
.37306 .4247 m .59242 .50212 L .37113 .40595 L .695 .421 .505 r
F
.25 g
.5 Mabswid
.57305 .52847 m
.57466 .52916 L
s
.37306 .4247 m .5847 .51554 L .59242 .50212 L .695 .421 .505 r
F
.25 g
.56035 .54199 m
.56041 .54202 L
s
.37882 .44489 m
.41023 .45841 L
s
.57283 .52838 m
.57305 .52847 L
s
0 g
.006 w
.37306 .4247 m
.37686 .44405 L
s
.25 g
.5 Mabswid
.37306 .4247 m
.3731 .42471 L
s
.3731 .42471 m
.37454 .42533 L
s
.37454 .42533 m
.37523 .42563 L
s
.40264 .43739 m
.41844 .44417 L
s
.39198 .43282 m
.40264 .43739 L
s
.38575 .43014 m
.39198 .43282 L
s
.37523 .42563 m
.38575 .43014 L
s
.57648 .51201 m
.57788 .51261 L
s
.57788 .51261 m
.5847 .51554 L
s
.39843 .50574 m
.5285 .56859 L
s
1 0 0 r
.003 w
.60473 .42724 m
.60531 .42924 L
s
.25 g
.5 Mabswid
.43719 .28615 m
.44001 .28855 L
s
.44001 .28855 m
.44015 .28867 L
s
.44015 .28867 m
.49939 .33909 L
s
1 0 0 r
.003 w
.60531 .42924 m
.60582 .43313 L
s
.25 g
.5 Mabswid
.60366 .43155 m
.60582 .43313 L
s
.42071 .2974 m
.42335 .29934 L
s
.42335 .29934 m
.42352 .29946 L
s
.42352 .29946 m
.53079 .37812 L
s
1 0 0 r
.003 w
.60582 .43313 m
.60615 .43884 L
s
.25 g
.5 Mabswid
.60461 .43785 m
.60615 .43884 L
s
.60266 .43659 m
.60461 .43785 L
s
.40649 .30991 m
.4091 .31159 L
s
.4091 .31159 m
.40926 .31169 L
s
.40926 .31169 m
.5018 .37145 L
s
1 0 0 r
.003 w
.60615 .43884 m
.60616 .44624 L
s
.25 g
.5 Mabswid
.6047 .44539 m
.60616 .44624 L
s
.60377 .44485 m
.6047 .44539 L
s
.60131 .44342 m
.60377 .44485 L
s
.47188 .36836 m
.49257 .38036 L
s
.39464 .32357 m
.39724 .32508 L
s
.39724 .32508 m
.47188 .36836 L
s
1 0 0 r
.003 w
.60565 .45517 m
.60616 .44624 L
s
.48572 .82516 m .28848 .68973 L .29063 .68861 L .656 .687 .867 r
F
.48438 .82976 m .28848 .68973 L .48572 .82516 L .644 .658 .849 r
F
.48059 .84277 m .47346 .83709 L .48438 .82976 L F
.47346 .83709 m .28848 .68973 L .48438 .82976 L F
.42629 .90844 m .40875 .88049 L .44074 .89894 L .55 .51 .765 r
F
.48059 .84277 m .46755 .83267 L .28848 .68973 L .644 .658 .849 r
F
.46755 .83267 m .28497 .69115 L .28643 .69056 L F
.46755 .83267 m .28643 .69056 L .28848 .68973 L F
.47349 .85915 m .46292 .84973 L .48059 .84277 L .639 .632 .827 r
F
.46292 .84973 m .28497 .69115 L .46755 .83267 L F
.46292 .84973 m .46755 .83267 L .48059 .84277 L F
.47349 .85915 m .2829 .69129 L .28497 .69115 L F
.46444 .8741 m .2829 .69129 L .47349 .85915 L .52 .579 .855 r
F
.46143 .87106 m .28227 .69012 L .2829 .69129 L F
.4614 .87103 m .28227 .69012 L .46143 .87106 L F
.4613 .87093 m .46122 .87084 L .46181 .87145 L F
.46122 .87084 m .28227 .69012 L .4614 .87103 L F
.46122 .87084 m .4614 .87103 L .46181 .87145 L F
.46181 .87145 m .4614 .87103 L .46143 .87106 L F
.46444 .8741 m .4613 .87093 L .46181 .87145 L F
.4535 .88743 m .28227 .69012 L .46444 .8741 L .573 .568 .809 r
F
.4535 .88743 m .28309 .68766 L .28227 .69012 L F
.44074 .89894 m .28507 .69031 L .45288 .88671 L .563 .54 .787 r
F
.28507 .69031 m .2836 .68834 L .28675 .69204 L F
.28507 .69031 m .28675 .69204 L .45288 .88671 L F
.2836 .68834 m .28309 .68766 L .28382 .68851 L F
.2836 .68834 m .28382 .68851 L .4535 .88743 L F
.44074 .89894 m .28543 .68397 L .28309 .68766 L F
.28654 .68575 m .28689 .68599 L .29112 .69184 L .55 .51 .765 r
F
.29043 .69112 m .29112 .69184 L .44074 .89894 L F
.28654 .68575 m .29112 .69184 L .29043 .69112 L F
.40875 .88049 m .28892 .68953 L .4213 .87207 L F
.28892 .68953 m .28654 .68575 L .29043 .69112 L F
.28892 .68953 m .29043 .69112 L .4213 .87207 L F
.45242 .8884 m .45288 .88671 L .4535 .88743 L .563 .54 .787 r
F
.44074 .89894 m .45288 .88671 L .45242 .8884 L F
.40875 .88049 m .4213 .87207 L .44074 .89894 L .55 .51 .765 r
F
.28654 .68575 m .28543 .68397 L .28689 .68599 L F
.48379 .82377 m .29063 .68861 L .29351 .68711 L .656 .687 .867 r
F
.48572 .82516 m .29063 .68861 L .48379 .82377 L F
.25 g
.5 Mabswid
.29068 .69124 m
.2907 .69125 L
s
.2907 .69125 m
.48492 .82461 L
s
.48492 .82461 m
.48572 .82516 L
s
0 g
.006 w
.48572 .82516 m
.48891 .80649 L
s
.25 g
.5 Mabswid
.29351 .68711 m
.29541 .68827 L
s
.29541 .68827 m
.2955 .68832 L
s
.2955 .68832 m
.47677 .79907 L
s
.47677 .79907 m
.48773 .80577 L
s
.48773 .80577 m
.48891 .80649 L
s
.48319 .78311 m
.48888 .7862 L
s
.48462 .76417 m
.4883 .76595 L
s
.48401 .74424 m
.48605 .74512 L
s
.48172 .72364 m
.48223 .72383 L
s
0 g
.006 w
.48059 .84277 m
.48572 .82516 L
s
.62534 .25786 m .57745 .47494 L .57762 .4774 L 0 0 .203 r
F
.57658 .48127 m .59806 .48914 L .57699 .47973 L .721 .456 .524 r
F
.37113 .40595 m .59242 .50212 L .59806 .48914 L F
.58593 .44661 m .57762 .4774 L .57811 .48409 L 0 0 .203 r
F
.62534 .25786 m .57762 .4774 L .58593 .44661 L F
.37113 .40595 m .57658 .48127 L .37125 .38786 L .721 .456 .524 r
F
.57658 .48127 m .57699 .47973 L .37125 .38786 L F
.25 g
.5 Mabswid
.37346 .40696 m
.39284 .41538 L
s
.39284 .41538 m
.39973 .41838 L
s
.39973 .41838 m
.41173 .42359 L
s
.41173 .42359 m
.42989 .43148 L
s
.42989 .43148 m
.45494 .44237 L
s
.45494 .44237 m
.48707 .45633 L
s
.48707 .45633 m
.57591 .49494 L
s
.37274 .40665 m
.37346 .40696 L
s
.3712 .40598 m
.37274 .40665 L
s
.37113 .40595 m
.3712 .40598 L
s
.49257 .38036 m
.53954 .4076 L
s
.53954 .4076 m
.55552 .41687 L
s
.55552 .41687 m
.56229 .42079 L
s
.56229 .42079 m
.56738 .42375 L
s
.56738 .42375 m
.5699 .42521 L
s
.58166 .43203 m
.58632 .43473 L
s
.58819 .43581 m
.60131 .44342 L
s
.5018 .37145 m
.53974 .39596 L
s
.53974 .39596 m
.54619 .40012 L
s
.54619 .40012 m
.55695 .40707 L
s
.55695 .40707 m
.56232 .41053 L
s
.58249 .42356 m
.588 .42712 L
s
.58977 .42826 m
.60266 .43659 L
s
.54584 .38916 m
.54691 .38994 L
s
.58319 .41654 m
.58934 .42105 L
s
.59102 .42228 m
.60366 .43155 L
s
.58374 .41088 m
.59034 .41649 L
s
.59194 .41785 m
.60531 .42924 L
s
.58418 .40641 m
.58424 .40647 L
s
.58424 .40647 m
.59103 .41336 L
s
.59256 .4149 m
.60473 .42724 L
s
0 g
.006 w
.37113 .40595 m
.37306 .4247 L
s
.25 g
.5 Mabswid
.41844 .44417 m
.43977 .45333 L
s
.43977 .45333 m
.46658 .46484 L
s
.46658 .46484 m
.57648 .51201 L
s
.57272 .52833 m
.57283 .52838 L
s
.4514 .47612 m
.57272 .52833 L
s
.41023 .45841 m
.4514 .47612 L
s
.38404 .46471 m
.56035 .54199 L
s
.39066 .48501 m
.54556 .55547 L
s
.57591 .49494 m
.57682 .49534 L
s
.57682 .49534 m
.59242 .50212 L
s
0 g
.006 w
.37113 .40595 m
.37125 .38786 L
s
.25 g
.5 Mabswid
.60347 .45401 m
.60565 .45517 L
s
.58069 .44193 m
.58431 .44385 L
s
.58629 .4449 m
.60347 .45401 L
s
.57281 .43775 m
.57427 .43853 L
s
.56645 .43438 m
.57281 .43775 L
s
.56229 .43217 m
.56645 .43438 L
s
.54407 .42252 m
.56229 .43217 L
s
.49097 .39436 m
.54407 .42252 L
s
.4628 .37943 m
.49097 .39436 L
s
.44877 .37199 m
.4628 .37943 L
s
.3852 .33828 m
.38779 .33966 L
s
.38779 .33966 m
.44877 .37199 L
s
1 0 0 r
.003 w
.60434 .46543 m
.60565 .45517 L
s
.25 g
.5 Mabswid
.37819 .35396 m
.37838 .35405 L
s
.60276 .46466 m
.60434 .46543 L
s
.57576 .45135 m
.57689 .4519 L
s
.57958 .45323 m
.58198 .45441 L
s
.58409 .45545 m
.60276 .46466 L
s
.5675 .44727 m
.57576 .45135 L
s
.5511 .43919 m
.5675 .44727 L
s
.49585 .41196 m
.5511 .43919 L
s
.46121 .39488 m
.49585 .41196 L
s
.44085 .38485 m
.46121 .39488 L
s
.43008 .37954 m
.44085 .38485 L
s
.37838 .35405 m
.43008 .37954 L
s
1 0 0 r
.003 w
.60192 .47684 m
.60434 .46543 L
s
.25 g
.5 Mabswid
.57762 .46183 m
.57785 .45963 L
s
.47763 .84048 m
.48059 .84277 L
s
.46755 .83267 m
.47763 .84048 L
s
.2978 .7011 m
.46755 .83267 L
s
0 g
.006 w
.47349 .85915 m
.48059 .84277 L
s
.25 g
.5 Mabswid
.37125 .38786 m
.37135 .38791 L
s
.37135 .38791 m
.37297 .38863 L
s
.37297 .38863 m
.37372 .38897 L
s
.57468 .4787 m
.57699 .47973 L
s
.57699 .47973 m
.57782 .4801 L
s
.57885 .48056 m
.59806 .48914 L
s
.57453 .47864 m
.57468 .4787 L
s
.51558 .45231 m
.57453 .47864 L
s
.47562 .43447 m
.51558 .45231 L
s
.4453 .42093 m
.47562 .43447 L
s
.42396 .4114 m
.4453 .42093 L
s
.41021 .40526 m
.42396 .4114 L
s
.40249 .40181 m
.41021 .40526 L
s
.37372 .38897 m
.40249 .40181 L
s
0 g
.006 w
.37125 .38786 m
.37356 .37051 L
s
.25 g
.5 Mabswid
.37356 .37051 m
.37371 .37058 L
s
.37371 .37058 m
.37537 .37135 L
s
.57712 .46529 m
.57758 .4655 L
s
.57834 .46586 m
.57935 .46632 L
s
.5816 .46737 m
.60192 .47684 L
s
.57158 .46271 m
.57712 .46529 L
s
.50495 .43168 m
.57158 .46271 L
s
.46616 .41362 m
.50495 .43168 L
s
.43999 .40144 m
.46616 .41362 L
s
.42373 .39387 m
.43999 .40144 L
s
.41482 .38972 m
.42373 .39387 L
s
.37537 .37135 m
.41482 .38972 L
s
1 0 0 r
.003 w
.59806 .48914 m
.60192 .47684 L
s
.5991 .25455 m .57745 .47494 L .62534 .25786 L 0 0 .108 r
F
1 0 0 r
.57733 .47097 m
.57745 .47494 L
s
.25 g
.5 Mabswid
.57785 .45963 m
.57901 .44845 L
s
1 0 0 r
.003 w
.57745 .47494 m
.57762 .4774 L
s
.59242 .50212 m
.59806 .48914 L
s
.25 g
.5 Mabswid
.46811 .85441 m
.47349 .85915 L
s
.46462 .85134 m
.46811 .85441 L
s
.30439 .71022 m
.46462 .85134 L
s
0 g
.006 w
.46444 .8741 m
.47349 .85915 L
s
.37356 .37051 m
.37819 .35396 L
s
1 0 0 r
.003 w
.5847 .51554 m
.59242 .50212 L
s
.65112 .26342 m .57811 .48409 L .5794 .49312 L 0 0 .268 r
F
.25 g
.5 Mabswid
.57745 .47494 m
.57777 .47346 L
s
.62534 .25786 m .57811 .48409 L .65112 .26342 L 0 0 .203 r
F
1 0 0 r
.003 w
.57762 .4774 m
.57811 .48409 L
s
.25 g
.5 Mabswid
.62489 .25989 m
.62534 .25786 L
s
1 0 0 r
.003 w
.57466 .52916 m
.5847 .51554 L
s
.25 g
.5 Mabswid
.4613 .87093 m
.46444 .8741 L
s
.46122 .87084 m
.4613 .87093 L
s
.3104 .71853 m
.46122 .87084 L
s
0 g
.006 w
.4535 .88743 m
.46444 .8741 L
s
.37819 .35396 m
.3852 .33828 L
s
.67612 .27123 m .5794 .49312 L .58158 .50164 L 0 0 .305 r
F
.25 g
.5 Mabswid
.57811 .48409 m
.57865 .48246 L
s
.57777 .47346 m
.57784 .47316 L
s
.65112 .26342 m .5794 .49312 L .67612 .27123 L 0 0 .268 r
F
.25 g
.57784 .47316 m
.5869 .4321 L
s
1 0 0 r
.003 w
.57811 .48409 m
.5794 .49312 L
s
.25 g
.5 Mabswid
.65048 .26536 m
.65112 .26342 L
s
.65042 .26551 m
.65048 .26536 L
s
1 0 0 r
.003 w
.56216 .54279 m
.57466 .52916 L
s
0 g
.006 w
.3852 .33828 m
.39464 .32357 L
s
.25 g
.5 Mabswid
.45112 .88464 m
.4535 .88743 L
s
.31578 .72598 m
.45112 .88464 L
s
0 g
.006 w
.44074 .89894 m
.4535 .88743 L
s
.70007 .28127 m .58158 .50164 L .58496 .50933 L .049 0 .321 r
F
.25 g
.5 Mabswid
.5794 .49312 m
.58017 .49135 L
s
.57865 .48246 m
.57873 .4822 L
s
.67612 .27123 m .58158 .50164 L .70007 .28127 L 0 0 .305 r
F
1 0 0 r
.003 w
.5794 .49312 m
.58158 .50164 L
s
.25 g
.5 Mabswid
.67562 .27237 m
.67612 .27123 L
s
.67525 .27323 m
.67562 .27237 L
s
.67519 .27335 m
.67525 .27323 L
s
.84744 .48002 m .71974 .51874 L .85257 .50578 L .053 0 0 r
F
.71974 .51874 m .72037 .5188 L .7205 .51879 L F
.72018 .5187 m .7205 .51879 L .85257 .50578 L F
.71974 .51874 m .7205 .51879 L .72018 .5187 L F
.85257 .50578 m .72037 .5188 L .73907 .51675 L .086 .644 .714 r
F
.72037 .5188 m .71914 .51893 L .73907 .51675 L F
.85257 .50578 m .73994 .51667 L .85634 .53176 L F
.73994 .51667 m .73985 .51668 L .73997 .51669 L F
.73994 .51667 m .73997 .51669 L .85634 .53176 L F
.73992 .51669 m .74026 .5169 L .85634 .53176 L F
.73985 .51668 m .74 .51676 L .73992 .51669 L F
.74 .51676 m .74026 .5169 L .73992 .51669 L F
.79317 .51383 m .77645 .51398 L .7929 .51355 L .443 .792 .998 r
F
.73985 .51668 m .73907 .51675 L .74026 .5169 L .086 .644 .714 r
F
.85585 .53167 m .73907 .51675 L .75835 .51506 L .231 .742 .877 r
F
.85522 .53161 m .73907 .51675 L .85585 .53167 L F
.85634 .53176 m .85522 .53161 L .85585 .53167 L F
.85634 .53176 m .75927 .51522 L .85889 .55776 L F
.75927 .51522 m .75929 .51525 L .85889 .55776 L F
.75917 .5152 m .75945 .51553 L .85889 .55776 L F
.77702 .51429 m .75835 .51506 L .77645 .51398 L .354 .787 .968 r
F
.85831 .55746 m .75946 .51553 L .77702 .51429 L F
.75927 .51522 m .75917 .5152 L .75929 .51525 L .231 .742 .877 r
F
.75917 .5152 m .75835 .51506 L .75945 .51553 L F
.75946 .51553 m .75835 .51506 L .77702 .51429 L .354 .787 .968 r
F
.85789 .55734 m .75835 .51506 L .85831 .55746 L F
.85889 .55776 m .85789 .55734 L .85831 .55746 L F
.85889 .55776 m .77743 .51451 L .86038 .58358 L F
.77743 .51451 m .77721 .51439 L .77749 .51462 L F
.77743 .51451 m .77749 .51462 L .86038 .58358 L F
.77721 .51439 m .77728 .5145 L .86038 .58358 L F
.77702 .51429 m .77732 .5147 L .77747 .51483 L F
.77728 .5145 m .77747 .51483 L .86038 .58358 L F
.77702 .51429 m .77747 .51483 L .77728 .5145 L F
.85989 .58308 m .83649 .56369 L .83383 .55603 L .443 .792 .998 r
F
.83649 .56369 m .77732 .5147 L .83383 .55603 L F
.83383 .55603 m .77732 .5147 L .79317 .51383 L F
.77721 .51439 m .77702 .51429 L .77728 .5145 L .354 .787 .968 r
F
.77702 .51429 m .77645 .51398 L .77732 .5147 L F
.77732 .5147 m .77645 .51398 L .79317 .51383 L .443 .792 .998 r
F
.85953 .58288 m .77645 .51398 L .85989 .58308 L F
.86038 .58358 m .85953 .58288 L .85989 .58308 L F
.86038 .58358 m .79427 .51497 L .86097 .60902 L F
.79427 .51497 m .794 .5147 L .79428 .51509 L F
.79427 .51497 m .79428 .51509 L .86097 .60902 L F
.794 .5147 m .79409 .51497 L .86097 .60902 L F
.79362 .5143 m .79385 .51489 L .86097 .60902 L F
.80852 .51586 m .7929 .51355 L .80732 .51373 L .503 .776 .993 r
F
.86065 .60846 m .79433 .51557 L .80852 .51586 L F
.794 .5147 m .79362 .5143 L .79409 .51497 L .443 .792 .998 r
F
.79362 .5143 m .7929 .51355 L .79385 .51489 L F
.79433 .51557 m .7929 .51355 L .80852 .51586 L .503 .776 .993 r
F
.86047 .60832 m .7929 .51355 L .86065 .60846 L F
.83982 .81164 m .80622 .52636 L .79577 .52845 L .66 .567 .739 r
F
.80351 .59793 m .79577 .52845 L .79184 .52924 L F
.83982 .81164 m .79577 .52845 L .80351 .59793 L F
.86097 .60902 m .86047 .60832 L .86065 .60846 L .503 .776 .993 r
F
.86097 .60902 m .80926 .51717 L .86081 .6339 L F
.80926 .51717 m .80952 .51833 L .86081 .6339 L F
.80804 .51502 m .80813 .51537 L .80829 .51572 L F
.80827 .51554 m .80829 .51572 L .86081 .6339 L F
.80804 .51502 m .80829 .51572 L .80827 .51554 L F
.80774 .51448 m .80794 .51512 L .80826 .51585 L F
.80813 .51537 m .80826 .51585 L .86081 .6339 L F
.80774 .51448 m .80826 .51585 L .80813 .51537 L F
.81958 .5149 m .80732 .51373 L .81941 .5144 L .544 .752 .973 r
F
.80926 .51717 m .80804 .51502 L .80952 .51833 L .503 .776 .993 r
F
.86048 .63296 m .80794 .51512 L .81958 .5149 L .544 .752 .973 r
F
.80804 .51502 m .80774 .51448 L .80813 .51537 L .503 .776 .993 r
F
.80774 .51448 m .80732 .51373 L .80794 .51512 L F
.80794 .51512 m .80732 .51373 L .81958 .5149 L .544 .752 .973 r
F
.86055 .63315 m .86043 .63289 L .86048 .63296 L F
.86043 .63289 m .80732 .51373 L .86048 .63296 L F
.86077 .63379 m .86042 .63299 L .86055 .63315 L F
.86042 .63299 m .80732 .51373 L .86055 .63315 L F
.86081 .6339 m .86075 .63378 L .86077 .63379 L F
.86075 .63378 m .80732 .51373 L .86077 .63379 L F
.86081 .6339 m .82056 .51773 L .86004 .65803 L F
.82056 .51773 m .82077 .51897 L .86004 .65803 L F
.8198 .51554 m .8199 .51603 L .81999 .51637 L F
.81998 .51616 m .81999 .51637 L .86004 .65803 L F
.8198 .51554 m .81999 .51637 L .81998 .51616 L F
.81958 .5149 m .81974 .51558 L .81997 .5164 L F
.8199 .51603 m .81997 .5164 L .86004 .65803 L F
.81958 .5149 m .81997 .5164 L .8199 .51603 L F
.8597 .65684 m .81941 .5144 L .85972 .65688 L .572 .727 .947 r
F
.82056 .51773 m .8198 .51554 L .82077 .51897 L .544 .752 .973 r
F
.85982 .65706 m .81974 .51558 L .82895 .51544 L .572 .727 .947 r
F
.8198 .51554 m .81958 .5149 L .8199 .51603 L .544 .752 .973 r
F
.81958 .5149 m .81941 .5144 L .81974 .51558 L F
.81974 .51558 m .81941 .5144 L .82895 .51544 L .572 .727 .947 r
F
.85972 .65688 m .81941 .5144 L .85982 .65706 L F
.85998 .65784 m .8597 .65684 L .86 .65786 L F
.8597 .65684 m .85972 .65688 L .86 .65786 L F
.86 .65786 m .85972 .65688 L .85982 .65706 L F
.86004 .65803 m .85998 .65784 L .86 .65786 L F
.85888 .65272 m .82953 .51812 L .85724 .67267 L F
.82953 .51812 m .82977 .51999 L .85878 .68123 L F
.85888 .65272 m .85724 .67267 L .85878 .68123 L F
.82953 .51812 m .82895 .51544 L .82977 .51999 L F
.85856 .6797 m .82895 .51544 L .8358 .51668 L .592 .703 .92 r
F
.85853 .67961 m .82895 .51544 L .85856 .6797 L F
.85859 .67995 m .82895 .51544 L .8586 .67998 L F
.85848 .67952 m .82895 .51544 L .85862 .68012 L F
.85872 .68094 m .82895 .51544 L .85874 .68097 L F
.84913 .77136 m .83514 .52161 L .84826 .77699 L .654 .64 .824 r
F
.85073 .76114 m .8504 .75601 L .84913 .77136 L F
.8504 .75601 m .83514 .52161 L .84913 .77136 L F
.86004 .65803 m .85888 .65272 L .85878 .68123 L .572 .727 .947 r
F
.8586 .67998 m .85853 .67961 L .85856 .6797 L .592 .703 .92 r
F
.85862 .68012 m .85859 .67995 L .8586 .67998 L F
.85874 .68097 m .85848 .67952 L .85862 .68012 L F
.85878 .68123 m .85872 .68094 L .85874 .68097 L F
.85878 .68123 m .83601 .51823 L .85713 .70332 L F
.83601 .51823 m .8358 .51668 L .83619 .52011 L F
.83601 .51823 m .83619 .52011 L .85713 .70332 L F
.85695 .70131 m .8358 .51668 L .83986 .51799 L .604 .678 .894 r
F
.85698 .70168 m .85693 .70122 L .85695 .70131 L F
.85693 .70122 m .8358 .51668 L .85695 .70131 L F
.85692 .70144 m .85685 .70082 L .85693 .7015 L F
.85685 .70082 m .8358 .51668 L .85687 .70092 L F
.85685 .70082 m .85687 .70092 L .85693 .7015 L F
.85708 .70287 m .85692 .70144 L .8571 .70291 L F
.85692 .70144 m .85693 .7015 L .8571 .70291 L F
.8571 .70291 m .85693 .7015 L .85698 .70168 L F
.85693 .7015 m .8358 .51668 L .85698 .70168 L F
.85713 .70332 m .85708 .70287 L .8571 .70291 L F
.85713 .70332 m .83986 .51799 L .8552 .72412 L F
.85502 .72165 m .85496 .72083 L .85503 .72169 L .589 .638 .867 r
F
.85496 .72083 m .83986 .51799 L .85497 .72091 L F
.85496 .72083 m .85497 .72091 L .85503 .72169 L F
.84564 .79081 m .82805 .52283 L .82066 .52397 L .658 .602 .781 r
F
.83529 .68977 m .82066 .52397 L .81836 .52433 L F
.84564 .79081 m .82066 .52397 L .83529 .68977 L F
.85515 .72342 m .85502 .72165 L .85516 .72344 L .589 .638 .867 r
F
.85502 .72165 m .85503 .72169 L .85516 .72344 L F
.85504 .72167 m .83986 .51799 L .84109 .51926 L F
.85516 .72344 m .85499 .72115 L .85504 .72167 L F
.85499 .72115 m .83986 .51799 L .85504 .72167 L F
.84284 .80242 m .81836 .52433 L .80933 .52584 L .66 .585 .76 r
F
.82025 .63212 m .80933 .52584 L .80622 .52636 L F
.84284 .80242 m .80933 .52584 L .82025 .63212 L F
.8552 .72412 m .85515 .72342 L .85516 .72344 L .589 .638 .867 r
F
.71974 .51874 m .71914 .51893 L .72037 .5188 L .053 0 0 r
F
0 g
.006 w
.85634 .53176 m
.85889 .55776 L
s
.85257 .50578 m
.85634 .53176 L
s
1 0 0 r
.003 w
.5472 .55621 m
.56216 .54279 L
s
0 g
.006 w
.85889 .55776 m
.86038 .58358 L
s
.84744 .48002 m .69913 .52138 L .71914 .51893 L .053 0 0 r
F
.84078 .45471 m .69913 .52138 L .84744 .48002 L .159 0 0 r
F
0 g
.84744 .48002 m
.85257 .50578 L
s
.25 g
.5 Mabswid
.80783 .54001 m
.80806 .5402 L
s
0 g
.006 w
.86038 .58358 m
.86097 .60902 L
s
.84078 .45471 m .67961 .52382 L .69913 .52138 L .159 0 0 r
F
.83247 .43005 m .67961 .52382 L .84078 .45471 L .229 0 0 r
F
.25 g
.5 Mabswid
.84604 .48041 m
.84744 .48002 L
s
0 g
.006 w
.84078 .45471 m
.84744 .48002 L
s
.25 g
.5 Mabswid
.82087 .55278 m
.82134 .55345 L
s
.83094 .56691 m
.83107 .56709 L
s
0 g
.006 w
.86081 .6339 m
.86097 .60902 L
s
.39464 .32357 m
.40649 .30991 L
s
1 0 0 r
.003 w
.52991 .56927 m
.5472 .55621 L
s
.83247 .43005 m .66113 .52593 L .67961 .52382 L .229 0 0 r
F
.8224 .40628 m .66113 .52593 L .83247 .43005 L .267 0 .01 r
F
.25 g
.5 Mabswid
.84603 .48041 m
.84604 .48041 L
s
.83927 .45536 m
.84078 .45471 L
s
0 g
.006 w
.83247 .43005 m
.84078 .45471 L
s
.25 g
.5 Mabswid
.29112 .69184 m
.42131 .87206 L
s
.28958 .68972 m
.29112 .69184 L
s
.42131 .87206 m
.44074 .89894 L
s
.72271 .2935 m .58496 .50933 L .58983 .51588 L .129 0 .32 r
F
.25 g
.58158 .50164 m
.58258 .49978 L
s
.58017 .49135 m
.58026 .49114 L
s
.70007 .28127 m .58496 .50933 L .72271 .2935 L .049 0 .321 r
F
1 0 0 r
.003 w
.58158 .50164 m
.58496 .50933 L
s
.25 g
.5 Mabswid
.69943 .28246 m
.70007 .28127 L
s
.69898 .28329 m
.69943 .28246 L
s
.69893 .28339 m
.69898 .28329 L
s
1 0 0 r
.003 w
.28227 .69012 m
.2829 .69129 L
s
.28227 .69012 m
.28309 .68766 L
s
0 g
.006 w
.86004 .65803 m
.86081 .6339 L
s
1 0 0 r
.003 w
.29063 .68861 m
.29351 .68711 L
s
.28928 .68931 m
.29063 .68861 L
s
.8224 .40628 m .64415 .52737 L .66113 .52593 L .267 0 .01 r
F
.81047 .3836 m .64415 .52737 L .8224 .40628 L .282 0 .111 r
F
0 g
.006 w
.8224 .40628 m
.83247 .43005 L
s
.25 g
.5 Mabswid
.83926 .45536 m
.83927 .45536 L
s
.83087 .43095 m
.83247 .43005 L
s
.42532 .9069 m .28939 .67923 L .28543 .68397 L .55 .51 .765 r
F
.42464 .90568 m .28939 .67923 L .42532 .9069 L F
.42629 .90844 m .42464 .90568 L .42532 .9069 L F
.41031 .91572 m .28939 .67923 L .42629 .90844 L .535 .48 .741 r
F
.40923 .91361 m .29506 .67367 L .28939 .67923 L F
.40914 .91337 m .29506 .67367 L .40923 .91361 L F
.40897 .9129 m .29506 .67367 L .40953 .91419 L F
.40953 .91419 m .40914 .91337 L .40923 .91361 L F
.41031 .91572 m .40897 .9129 L .40953 .91419 L F
.39302 .92061 m .29541 .67454 L .41031 .91572 L .521 .449 .715 r
F
.29541 .67454 m .29587 .67536 L .41031 .91572 L F
.29541 .67454 m .29506 .67367 L .29587 .67536 L F
.39218 .9185 m .30254 .66761 L .29506 .67367 L F
.39302 .92061 m .39195 .91761 L .39218 .9185 L F
.39195 .91761 m .30254 .66761 L .39218 .9185 L F
.37466 .92295 m .37422 .92141 L .39302 .92061 L .508 .417 .687 r
F
.37422 .92141 m .30279 .6685 L .39195 .91761 L F
.37422 .92141 m .39195 .91761 L .39302 .92061 L F
.30279 .6685 m .30317 .66937 L .39302 .92061 L F
.30279 .6685 m .30254 .66761 L .30317 .66937 L F
.37406 .92083 m .31185 .66143 L .30254 .66761 L F
.37466 .92295 m .37393 .91992 L .37406 .92083 L F
.37393 .91992 m .31185 .66143 L .37406 .92083 L F
.3555 .92259 m .35524 .92105 L .37466 .92295 L .497 .385 .657 r
F
.35524 .92105 m .31212 .66302 L .37393 .91992 L F
.35524 .92105 m .37393 .91992 L .37466 .92295 L F
.31212 .66302 m .31243 .66381 L .37466 .92295 L F
.31212 .66302 m .31185 .66143 L .31243 .66381 L F
.35515 .92049 m .32298 .65555 L .31185 .66143 L F
.3555 .92259 m .35513 .91955 L .35515 .92049 L F
.35513 .91955 m .32298 .65555 L .35515 .92049 L F
.33588 .91944 m .33581 .91792 L .3555 .92259 L .487 .354 .624 r
F
.33581 .91792 m .32306 .65713 L .35513 .91955 L F
.33581 .91792 m .35513 .91955 L .3555 .92259 L F
.32306 .65713 m .32327 .65793 L .3555 .92259 L F
.32306 .65713 m .32298 .65555 L .32327 .65793 L F
.33578 .91737 m .33581 .65043 L .32298 .65555 L F
.33588 .91944 m .33588 .91643 L .33578 .91737 L F
.33588 .91643 m .33581 .65043 L .33578 .91737 L F
.31614 .91345 m .31626 .91195 L .33588 .91944 L .481 .323 .589 r
F
.31626 .91195 m .33569 .65199 L .33588 .91643 L F
.31626 .91195 m .33588 .91643 L .33588 .91944 L F
.33569 .65199 m .33581 .65282 L .33588 .91944 L F
.33569 .65199 m .33581 .65043 L .33581 .65282 L F
.3163 .91142 m .35013 .64653 L .33581 .65043 L F
.31614 .91345 m .31652 .91051 L .3163 .91142 L F
.31652 .91051 m .35013 .64653 L .3163 .91142 L F
.29666 .90461 m .29696 .90317 L .31614 .91345 L .477 .294 .553 r
F
.29696 .90317 m .34981 .64806 L .31652 .91051 L F
.29696 .90317 m .31652 .91051 L .31614 .91345 L F
.34981 .64806 m .34983 .6489 L .31614 .91345 L F
.34981 .64806 m .35013 .64653 L .34983 .6489 L F
.29706 .90266 m .36564 .64425 L .35013 .64653 L F
.29666 .90461 m .29741 .90178 L .29706 .90266 L F
.29741 .90178 m .36564 .64425 L .29706 .90266 L F
.27781 .89298 m .2783 .8916 L .29666 .90461 L .478 .267 .515 r
F
.2783 .8916 m .36511 .64574 L .29741 .90178 L F
.2783 .8916 m .29741 .90178 L .29666 .90461 L F
.36511 .64574 m .36502 .64658 L .29666 .90461 L F
.36511 .64574 m .36564 .64425 L .36502 .64658 L F
.27847 .89113 m .38193 .64394 L .36564 .64425 L F
.27781 .89298 m .27893 .89031 L .27847 .89113 L F
.27893 .89031 m .38193 .64394 L .27847 .89113 L F
.25999 .87865 m .26066 .87738 L .27781 .89298 L .483 .244 .476 r
F
.26066 .87738 m .38118 .64537 L .27893 .89031 L F
.26066 .87738 m .27893 .89031 L .27781 .89298 L F
.38118 .64537 m .38098 .6462 L .27781 .89298 L F
.38118 .64537 m .38193 .64394 L .38098 .6462 L F
.26088 .87694 m .39852 .64585 L .38193 .64394 L F
.25999 .87865 m .26146 .8762 L .26088 .87694 L F
.26146 .8762 m .39852 .64585 L .26088 .87694 L F
.24357 .86182 m .2444 .86066 L .25999 .87865 L .493 .226 .438 r
F
.2444 .86066 m .39756 .64718 L .26145 .87619 L F
.2444 .86066 m .26145 .87619 L .25999 .87865 L F
.39756 .64718 m .39725 .64799 L .25999 .87865 L F
.39756 .64718 m .39852 .64585 L .39725 .64799 L F
.24468 .86027 m .41489 .6501 L .39852 .64585 L F
.24357 .86182 m .24535 .85961 L .24468 .86027 L F
.24535 .85961 m .41489 .6501 L .24468 .86027 L F
.2289 .84269 m .22988 .84167 L .24357 .86182 L .508 .214 .402 r
F
.22988 .84167 m .41373 .65131 L .24535 .85961 L F
.22988 .84167 m .24535 .85961 L .24357 .86182 L F
.41373 .65131 m .41329 .65207 L .24357 .86182 L F
.41373 .65131 m .41489 .6501 L .41329 .65207 L F
.2302 .84134 m .4305 .65669 L .41489 .6501 L F
.2289 .84269 m .23096 .84078 L .2302 .84134 L F
.23096 .84078 m .4305 .65669 L .2302 .84134 L F
.2163 .82155 m .21741 .82069 L .2289 .84269 L .528 .208 .369 r
F
.21741 .82069 m .42915 .65774 L .23096 .84078 L F
.21741 .82069 m .23096 .84078 L .2289 .84269 L F
.42915 .65774 m .4286 .65845 L .2289 .84269 L F
.42915 .65774 m .4305 .65669 L .4286 .65845 L F
.21777 .82042 m .44483 .66547 L .4305 .65669 L F
.2163 .82155 m .2186 .81998 L .21777 .82042 L F
.2186 .81998 m .44483 .66547 L .21777 .82042 L F
.20605 .79872 m .20727 .79804 L .2163 .82155 L .553 .209 .34 r
F
.20727 .79804 m .44331 .66633 L .2186 .81998 L F
.20727 .79804 m .2186 .81998 L .2163 .82155 L F
.44331 .66633 m .44266 .66696 L .2163 .82155 L F
.44331 .66633 m .44483 .66547 L .44266 .66696 L F
.20765 .79783 m .45743 .67617 L .44483 .66547 L F
.20605 .79872 m .20854 .79751 L .20765 .79783 L F
.20854 .79751 m .45743 .67617 L .20765 .79783 L F
.19839 .77456 m .19969 .77407 L .20605 .79872 L .583 .219 .316 r
F
.19969 .77407 m .45576 .67681 L .20854 .79751 L F
.19969 .77407 m .20854 .79751 L .20605 .79872 L F
.45576 .67681 m .45502 .67735 L .20605 .79872 L F
.45576 .67681 m .45743 .67617 L .45502 .67735 L F
.20009 .77392 m .46793 .6884 L .45743 .67617 L F
.19839 .77456 m .20101 .77373 L .20009 .77392 L F
.20101 .77373 m .46793 .6884 L .20009 .77392 L F
.1935 .74945 m .19485 .74915 L .19839 .77456 L .615 .235 .299 r
F
.19485 .74915 m .46616 .6888 L .20101 .77372 L F
.19485 .74915 m .20101 .77372 L .19839 .77456 L F
.46616 .6888 m .46534 .68923 L .19839 .77456 L F
.46616 .6888 m .46793 .6884 L .46534 .68923 L F
.19524 .74907 m .4761 .7017 L .46793 .6884 L F
.1935 .74945 m .19618 .749 L .19524 .74907 L F
.19618 .749 m .4761 .7017 L .19524 .74907 L F
.19149 .7238 m .19285 .7237 L .1935 .74945 L .65 .258 .288 r
F
.19285 .7237 m .47427 .70185 L .19618 .749 L F
.19285 .7237 m .19618 .749 L .1935 .74945 L F
.47427 .70185 m .47339 .70216 L .1935 .74945 L F
.47427 .70185 m .4761 .7017 L .47339 .70216 L F
.19324 .72367 m .48185 .71557 L .4761 .7017 L F
.19149 .7238 m .19417 .72373 L .19324 .72367 L F
.19417 .72373 m .48185 .71557 L .19324 .72367 L F
.19243 .69801 m .19378 .69809 L .19149 .7238 L .686 .287 .285 r
F
.19378 .69809 m .47999 .71546 L .19417 .72373 L F
.19378 .69809 m .19417 .72373 L .19149 .7238 L F
.47999 .71546 m .47908 .71565 L .19149 .7238 L F
.47999 .71546 m .48185 .71557 L .47908 .71565 L F
.19415 .69811 m .48523 .72949 L .48185 .71557 L F
.19243 .69801 m .19506 .69829 L .19415 .69811 L F
.19506 .69829 m .48523 .72949 L .19415 .69811 L F
.19634 .67248 m .19765 .67274 L .19243 .69801 L .723 .321 .287 r
F
.19765 .67274 m .4834 .72913 L .19506 .69829 L F
.19765 .67274 m .19506 .69829 L .19243 .69801 L F
.4834 .72913 m .48247 .72919 L .19243 .69801 L F
.4834 .72913 m .48523 .72949 L .48247 .72919 L F
.19634 .67248 m .48643 .743 L .48523 .72949 L F
.20318 .64759 m .48467 .7424 L .19634 .67248 L .758 .358 .295 r
F
.48467 .7424 m .48375 .74234 L .19634 .67248 L F
.48467 .7424 m .48643 .743 L .48375 .74234 L F
.20443 .64801 m .48578 .75569 L .48643 .743 L F
.20318 .64759 m .20574 .64857 L .20443 .64801 L F
.20574 .64857 m .48578 .75569 L .20443 .64801 L F
.21288 .62372 m .48412 .75488 L .20318 .64759 L .792 .398 .308 r
F
.48412 .75488 m .48323 .75471 L .20318 .64759 L F
.48412 .75488 m .48578 .75569 L .48323 .75471 L F
.21404 .62428 m .48367 .76725 L .48578 .75569 L F
.21288 .62372 m .21527 .62498 L .21404 .62428 L F
.21527 .62498 m .48367 .76725 L .21404 .62428 L F
.22532 .60121 m .48272 .76664 L .21288 .62372 L .824 .44 .326 r
F
.48272 .76664 m .48169 .7662 L .21288 .62372 L F
.48272 .76664 m .48367 .76725 L .48169 .7662 L F
.22637 .60189 m .48057 .77749 L .48367 .76725 L F
.22532 .60121 m .2275 .60272 L .22637 .60189 L F
.2275 .60272 m .48057 .77749 L .22637 .60189 L F
.24037 .58039 m .47975 .77682 L .22532 .60121 L .854 .482 .346 r
F
.47975 .77682 m .47884 .7763 L .22532 .60121 L F
.47975 .77682 m .48057 .77749 L .47884 .7763 L F
.27312 .60727 m .47695 .78631 L .48057 .77749 L F
.51821 .52471 m .47812 .80188 L .4889 .51457 L .977 .919 .622 r
F
.47812 .80188 m .47725 .80788 L .47751 .8013 L F
.47812 .80188 m .47751 .8013 L .4889 .51457 L F
.24129 .58115 m .29337 .62649 L .27312 .60727 L .854 .482 .346 r
F
.29337 .62649 m .47695 .78631 L .27312 .60727 L F
.24037 .58039 m .2423 .58208 L .24129 .58115 L F
.2423 .58208 m .47695 .78631 L .24129 .58115 L F
.25784 .56155 m .47626 .78561 L .24037 .58039 L .881 .525 .369 r
F
.47626 .78561 m .47548 .78503 L .24037 .58039 L F
.47626 .78561 m .47695 .78631 L .47548 .78503 L F
.26964 .57365 m .47325 .79371 L .47695 .78631 L F
.27841 .58368 m .47325 .79371 L .26964 .57365 L F
.2595 .56334 m .47325 .79371 L .25861 .56234 L F
.25861 .56234 m .27841 .58368 L .26964 .57365 L F
.25784 .56155 m .2595 .56334 L .25861 .56234 L F
.27756 .54496 m .47269 .79301 L .25784 .56155 L .905 .567 .394 r
F
.47269 .79301 m .47325 .79371 L .47204 .7924 L F
.47269 .79301 m .47204 .7924 L .25784 .56155 L F
.46296 .78063 m .46988 .79975 L .47325 .79371 L F
.27882 .54656 m .46336 .79111 L .46296 .78063 L F
.46336 .79111 m .46988 .79975 L .46296 .78063 L F
.27945 .54743 m .46988 .79975 L .27882 .54656 L F
.27889 .54672 m .46988 .79975 L .27816 .54571 L F
.27816 .54571 m .27945 .54743 L .27882 .54656 L F
.27756 .54496 m .27889 .54672 L .27816 .54571 L F
.29932 .53084 m .46945 .79907 L .27756 .54496 L .927 .608 .418 r
F
.46945 .79907 m .46891 .79847 L .27756 .54496 L F
.46945 .79907 m .46988 .79975 L .46891 .79847 L F
.2997 .53145 m .46716 .80454 L .46988 .79975 L F
.29932 .53084 m .30023 .53234 L .2997 .53145 L F
.30023 .53234 m .46716 .80454 L .2997 .53145 L F
.32289 .51942 m .46684 .80391 L .30023 .53234 L .947 .649 .441 r
F
.32289 .51942 m .30023 .53234 L .29932 .53084 L F
.46684 .80391 m .46716 .80454 L .46642 .80333 L F
.46684 .80391 m .46642 .80333 L .29932 .53084 L F
.32296 .51957 m .46534 .80821 L .46716 .80454 L F
.3231 .51984 m .46534 .80821 L .32296 .51957 L F
.32289 .51942 m .3231 .51984 L .32296 .51957 L F
.45235 .77528 m .46512 .80765 L .32289 .51942 L .966 .688 .456 r
F
.34805 .51086 m .45235 .77528 L .32289 .51942 L F
.46512 .80765 m .46481 .80713 L .32289 .51942 L F
.34805 .51086 m .46457 .81083 L .46261 .80127 L F
.37456 .5053 m .46445 .81041 L .34805 .51086 L .958 .662 .232 r
F
.46445 .81041 m .46457 .81083 L .46425 .81 L F
.46445 .81041 m .46425 .81 L .34805 .51086 L F
.46512 .80765 m .46534 .80821 L .46481 .80713 L .966 .688 .456 r
F
.46261 .80127 m .46457 .81083 L .46534 .80821 L F
.46404 .80902 m .46483 .8121 L .46457 .81083 L .958 .662 .232 r
F
.46483 .8121 m .46493 .81247 L .46457 .81083 L F
.37456 .5053 m .46406 .80951 L .46404 .80902 L F
.46406 .80951 m .46493 .81247 L .46404 .80902 L F
.4596 .5075 m .46891 .80911 L .4306 .50358 L .992 .847 .595 r
F
.46891 .80911 m .46901 .81267 L .4685 .80856 L F
.46891 .80911 m .4685 .80856 L .4306 .50358 L F
.4889 .51457 m .47291 .8061 L .4596 .5075 L .99 .885 .611 r
F
.47291 .8061 m .47265 .81099 L .47241 .80552 L F
.47291 .8061 m .47241 .80552 L .4596 .5075 L F
0 g
.006 w
.42629 .90844 m
.44074 .89894 L
s
.25 g
.5 Mabswid
.39808 .72214 m
.40387 .72495 L
s
.48427 .764 m
.48462 .76417 L
s
.36801 .72034 m
.43924 .75916 L
s
.48101 .78191 m
.48319 .78311 L
s
.46489 .67883 m
.46699 .67937 L
s
1 0 0 r
.003 w
.51058 .58184 m
.52991 .56927 L
s
.25 g
.5 Mabswid
.42464 .90568 m
.42629 .90844 L
s
.42455 .90553 m
.42464 .90568 L
s
.33603 .75732 m
.42455 .90553 L
s
.81941 .5144 m
.82036 .51775 L
s
.82036 .51775 m
.82205 .52376 L
s
0 g
.006 w
.85878 .68123 m
.86004 .65803 L
s
.40649 .30991 m
.42071 .2974 L
s
.81047 .3836 m .62903 .52783 L .64415 .52737 L .282 0 .111 r
F
.79664 .36222 m .62903 .52783 L .81047 .3836 L .279 0 .186 r
F
.25 g
.5 Mabswid
.83086 .43096 m
.83087 .43095 L
s
.80732 .51373 m
.80857 .51655 L
s
.80857 .51655 m
.81247 .52531 L
s
.82072 .40742 m
.8224 .40628 L
s
0 g
.006 w
.81047 .3836 m
.8224 .40628 L
s
.25 g
.5 Mabswid
.40897 .9129 m
.41031 .91572 L
s
.40891 .91277 m
.40897 .9129 L
s
.33584 .75931 m
.40891 .91277 L
s
0 g
.006 w
.41031 .91572 m
.42629 .90844 L
s
1 0 0 r
.003 w
.50989 .58224 m
.51058 .58184 L
s
.74383 .30784 m .58983 .51588 L .5965 .52109 L .189 0 .307 r
F
.25 g
.5 Mabswid
.58496 .50933 m
.58619 .5074 L
s
.58258 .49978 m
.58267 .49962 L
s
.72271 .2935 m .58983 .51588 L .74383 .30784 L .129 0 .32 r
F
.25 g
.57901 .44845 m
.59342 .30943 L
s
1 0 0 r
.003 w
.58496 .50933 m
.58983 .51588 L
s
.25 g
.5 Mabswid
.58983 .51588 m
.58994 .51575 L
s
.72194 .29471 m
.72271 .2935 L
s
.72143 .2955 m
.72194 .29471 L
s
.72138 .29558 m
.72143 .2955 L
s
.79664 .36222 m .616 .52703 L .62903 .52783 L .279 0 .186 r
F
.25 g
.58994 .51575 m
.5909 .51445 L
s
.62903 .52783 m
.62914 .52774 L
s
.64415 .52737 m
.64438 .52721 L
s
.7809 .34235 m .616 .52703 L .79664 .36222 L .263 0 .241 r
F
.25 g
.7929 .51355 m
.79433 .51557 L
s
.79433 .51557 m
.80255 .52709 L
s
0 g
.006 w
.79664 .36222 m
.81047 .3836 L
s
.25 g
.5 Mabswid
.80876 .38496 m
.81047 .3836 L
s
.79555 .36321 m
.79664 .36222 L
s
.39199 .91773 m
.39302 .92061 L
s
.39195 .91761 m
.39199 .91773 L
s
.33584 .76073 m
.39195 .91761 L
s
.82895 .51544 m
.82959 .51901 L
s
0 g
.006 w
.85713 .70332 m
.85878 .68123 L
s
1 0 0 r
.003 w
.48441 .59653 m
.48567 .59588 L
s
0 g
.006 w
.42071 .2974 m
.43719 .28615 L
s
.25 g
.5 Mabswid
.37395 .92002 m
.37466 .92295 L
s
.33588 .76149 m
.37395 .92002 L
s
.7809 .34235 m .60517 .52481 L .616 .52703 L .263 0 .241 r
F
.25 g
.616 .52703 m
.61604 .527 L
s
.61604 .527 m
.61725 .5259 L
s
.61725 .5259 m
.61785 .52535 L
s
.5909 .51445 m
.59133 .51386 L
s
.62914 .52774 m
.63031 .52681 L
s
.63031 .52681 m
.63089 .52634 L
s
.64438 .52721 m
.64545 .52649 L
s
.64545 .52649 m
.64598 .52612 L
s
.66244 .5252 m
.66289 .52494 L
s
.66113 .52593 m
.66244 .5252 L
s
.76327 .32417 m .60517 .52481 L .7809 .34235 L .233 0 .28 r
F
.25 g
.77645 .51398 m
.77713 .51455 L
s
.77713 .51455 m
.7777 .51502 L
s
.7777 .51502 m
.79426 .52876 L
s
.79493 .36378 m
.79555 .36321 L
s
0 g
.006 w
.7809 .34235 m
.79664 .36222 L
s
.25 g
.5 Mabswid
.77925 .34406 m
.77985 .34343 L
s
.77985 .34343 m
.7809 .34235 L
s
1 0 0 r
.003 w
.46269 .60754 m
.46388 .60697 L
s
.25 g
.5 Mabswid
.8358 .51668 m
.8362 .52022 L
s
1 0 0 r
.003 w
.42293 .6259 m
.44459 .61614 L
s
0 g
.006 w
.39302 .92061 m
.41031 .91572 L
s
.25 g
.5 Mabswid
.35514 .91964 m
.3555 .92259 L
s
.35513 .91955 m
.35514 .91964 L
s
.33584 .76114 m
.35513 .91955 L
s
.76327 .32417 m .5965 .52109 L .60517 .52481 L .233 0 .28 r
F
.25 g
.60517 .52481 m
.60518 .5248 L
s
.60518 .5248 m
.60637 .52357 L
s
.60637 .52357 m
.60694 .52297 L
s
.58619 .5074 m
.58626 .50728 L
s
.68127 .52311 m
.68196 .52281 L
s
.67961 .52382 m
.68127 .52311 L
s
.74383 .30784 m .5965 .52109 L .76327 .32417 L .189 0 .307 r
F
1 0 0 r
.003 w
.58983 .51588 m
.5965 .52109 L
s
.25 g
.5 Mabswid
.75835 .51506 m
.7592 .51542 L
s
.7592 .51542 m
.75937 .5155 L
s
.70065 .52095 m
.70416 .51997 L
s
.70055 .52098 m
.70065 .52095 L
s
.69913 .52138 m
.70055 .52098 L
s
.72037 .5188 m
.74 .51687 L
s
.71914 .51893 m
.72037 .5188 L
s
.74011 .51688 m
.77236 .52101 L
s
.73907 .51675 m
.74011 .51688 L
s
.5869 .4321 m
.62489 .25989 L
s
.57873 .4822 m
.65042 .26551 L
s
.58026 .49114 m
.67519 .27335 L
s
.58267 .49962 m
.69893 .28339 L
s
.58626 .50728 m
.72138 .29558 L
s
.64598 .52612 m
.82072 .40742 L
s
.63089 .52634 m
.80876 .38496 L
s
.59133 .51386 m
.74235 .30984 L
s
.61785 .52535 m
.79493 .36378 L
s
.60694 .52297 m
.77922 .34409 L
s
.77922 .34409 m
.77925 .34406 L
s
0 g
.006 w
.76327 .32417 m
.7809 .34235 L
s
.25 g
.5 Mabswid
.59815 .51913 m
.76167 .32605 L
s
.59763 .51974 m
.59815 .51913 L
s
.76167 .32605 m
.76171 .32601 L
s
.59654 .52104 m
.59763 .51974 L
s
.5965 .52109 m
.59654 .52104 L
s
.76171 .32601 m
.76229 .32532 L
s
.76229 .32532 m
.76327 .32417 L
s
.74295 .30903 m
.74383 .30784 L
s
.7424 .30978 m
.74295 .30903 L
s
.74235 .30984 m
.7424 .30978 L
s
.59342 .30943 m
.5991 .25455 L
s
0 g
.006 w
.74383 .30784 m
.76327 .32417 L
s
1 0 0 r
.003 w
.41155 .63087 m
.42293 .6259 L
s
.5965 .52109 m
.60517 .52481 L
s
0 g
.006 w
.43719 .28615 m
.45093 .27885 L
s
.72271 .2935 m
.74383 .30784 L
s
.25 g
.5 Mabswid
.33588 .9165 m
.33588 .91944 L
s
.33588 .91643 m
.33588 .9165 L
s
.33584 .75878 m
.33588 .91643 L
s
.8552 .72412 m .84109 .51926 L .85305 .74346 L .589 .638 .867 r
F
0 g
.006 w
.8552 .72412 m
.85713 .70332 L
s
.70007 .28127 m
.72271 .2935 L
s
.45017 .27791 m
.47239 .26937 L
s
.37466 .92295 m
.39302 .92061 L
s
.25 g
.5 Mabswid
.31614 .91345 m
.31651 .91056 L
s
.31651 .91056 m
.31652 .91051 L
s
.31652 .91051 m
.33634 .75483 L
s
1 0 0 r
.003 w
.60517 .52481 m
.616 .52703 L
s
0 g
.006 w
.67612 .27123 m
.70007 .28127 L
s
.47239 .26937 m
.49605 .26253 L
s
.85305 .74346 m .83951 .52045 L .85073 .76114 L .662 .669 .847 r
F
.85305 .74346 m .84109 .51926 L .83951 .52045 L F
0 g
.85305 .74346 m
.8552 .72412 L
s
.25 g
.5 Mabswid
.85269 .73661 m
.85277 .73813 L
s
.85277 .73813 m
.85286 .73975 L
s
.85286 .73975 m
.85299 .74223 L
s
.85299 .74223 m
.85305 .74346 L
s
.70416 .51997 m
.84603 .48041 L
s
.83986 .51799 m
.84001 .52008 L
s
0 g
.006 w
.65112 .26342 m
.67612 .27123 L
s
.49605 .26253 m
.52087 .25752 L
s
.25 g
.5 Mabswid
.29666 .90461 m
.2974 .90182 L
s
.2974 .90182 m
.29741 .90178 L
s
.29741 .90178 m
.33768 .74977 L
s
0 g
.006 w
.62534 .25786 m
.65112 .26342 L
s
.3555 .92259 m
.37466 .92295 L
s
.52087 .25752 m
.54653 .25445 L
s
.5991 .25455 m
.62534 .25786 L
s
.54653 .25445 m
.57272 .25344 L
s
.57272 .25344 m
.5991 .25455 L
s
1 0 0 r
.003 w
.616 .52703 m
.62903 .52783 L
s
.25 g
.5 Mabswid
.27781 .89298 m
.27892 .89033 L
s
.27892 .89033 m
.27893 .89031 L
s
.27893 .89031 m
.34005 .74412 L
s
.85073 .76114 m .83951 .52045 L .83514 .52161 L .654 .64 .824 r
F
.25 g
.85059 .75825 m
.85073 .76114 L
s
.85026 .75108 m
.85059 .75825 L
s
0 g
.006 w
.85073 .76114 m
.85305 .74346 L
s
.25 g
.5 Mabswid
.84109 .51926 m
.84112 .51972 L
s
.84112 .51972 m
.84119 .52107 L
s
.8362 .52022 m
.83632 .52129 L
s
0 g
.006 w
.33588 .91944 m
.3555 .92259 L
s
.25 g
.5 Mabswid
.25999 .87865 m
.26145 .87621 L
s
.26145 .87621 m
.26146 .8762 L
s
.26146 .8762 m
.34347 .73836 L
s
1 0 0 r
.003 w
.62903 .52783 m
.64415 .52737 L
s
.84826 .77699 m .82805 .52283 L .84564 .79081 L .656 .62 .802 r
F
.84826 .77699 m .83514 .52161 L .82805 .52283 L F
.25 g
.5 Mabswid
.83951 .52045 m
.83955 .5213 L
s
.83955 .5213 m
.83963 .52311 L
s
.82959 .51901 m
.83021 .52246 L
s
0 g
.006 w
.84826 .77699 m
.85073 .76114 L
s
.25 g
.5 Mabswid
.83514 .52161 m
.83525 .52392 L
s
.84821 .77609 m
.84826 .77699 L
s
.68196 .52281 m
.83926 .45536 L
s
.84119 .52107 m
.84122 .5217 L
s
0 g
.006 w
.31614 .91345 m
.33588 .91944 L
s
.25 g
.5 Mabswid
.24357 .86182 m
.24535 .85961 L
s
.24535 .85961 m
.34786 .73293 L
s
1 0 0 r
.003 w
.41755 .65122 m
.4305 .65669 L
s
.64415 .52737 m
.66113 .52593 L
s
.84564 .79081 m .81836 .52433 L .84284 .80242 L .658 .602 .781 r
F
.25 g
.5 Mabswid
.84246 .74238 m
.84553 .78923 L
s
.84553 .78923 m
.84564 .79081 L
s
.82805 .52283 m
.82818 .52479 L
s
0 g
.006 w
.84564 .79081 m
.84826 .77699 L
s
.25 g
.5 Mabswid
.66289 .52494 m
.83086 .43096 L
s
0 g
.006 w
.29666 .90461 m
.31614 .91345 L
s
.25 g
.5 Mabswid
.2289 .84269 m
.23097 .84077 L
s
.23097 .84077 m
.35301 .72818 L
s
1 0 0 r
.003 w
.4305 .65669 m
.44483 .66547 L
s
.66113 .52593 m
.67961 .52382 L
s
0 g
.006 w
.27781 .89298 m
.29666 .90461 L
s
.25 g
.5 Mabswid
.81836 .52433 m
.8185 .52585 L
s
.84284 .80242 m .80622 .52636 L .83982 .81164 L .66 .585 .76 r
F
.25 g
.84142 .78627 m
.84267 .80047 L
s
.84267 .80047 m
.84284 .80242 L
s
0 g
.006 w
.84284 .80242 m
.84564 .79081 L
s
.25 g
.5 Mabswid
.84122 .5217 m
.85269 .73661 L
s
.2163 .82155 m
.21862 .81996 L
s
.21862 .81996 m
.35867 .72432 L
s
1 0 0 r
.003 w
.44483 .66547 m
.45141 .67106 L
s
.67961 .52382 m
.69913 .52138 L
s
0 g
.006 w
.25999 .87865 m
.27781 .89298 L
s
.25 g
.5 Mabswid
.20605 .79872 m
.20858 .79749 L
s
.20858 .79749 m
.36457 .72144 L
s
1 0 0 r
.003 w
.46508 .68508 m
.46735 .68773 L
s
.69913 .52138 m
.71914 .51893 L
s
.83982 .81164 m .79184 .52924 L .8365 .81829 L .66 .567 .739 r
F
.25 g
.5 Mabswid
.83377 .76025 m
.83956 .80943 L
s
.83956 .80943 m
.83961 .80984 L
s
.83961 .80984 m
.83975 .81106 L
s
.83975 .81106 m
.83982 .81164 L
s
0 g
.006 w
.83982 .81164 m
.84284 .80242 L
s
.25 g
.5 Mabswid
.83963 .52311 m
.85026 .75108 L
s
.83074 .66498 m
.84142 .78627 L
s
0 g
.006 w
.24357 .86182 m
.25999 .87865 L
s
1 0 0 r
.003 w
.71914 .51893 m
.73907 .51675 L
s
.80298 .79766 m .67554 .58117 L .65464 .59694 L .597 .383 .56 r
F
.81099 .80855 m .67554 .58117 L .80298 .79766 L .617 .421 .593 r
F
.81099 .80855 m .69665 .56741 L .67554 .58117 L F
.25 g
.5 Mabswid
.80622 .52636 m
.80623 .52644 L
s
.80298 .79766 m .65555 .59819 L .79358 .78397 L .597 .383 .56 r
F
.65555 .59819 m .65565 .59831 L .79358 .78397 L F
.65537 .59793 m .65586 .59859 L .79358 .78397 L F
.65531 .59785 m .65539 .59796 L .65537 .59793 L F
.65539 .59796 m .65586 .59859 L .65537 .59793 L F
.65555 .59819 m .65531 .59785 L .65565 .59831 L F
.65531 .59785 m .65464 .59694 L .65586 .59859 L F
.79358 .78397 m .65464 .59694 L .6343 .61449 L .571 .337 .523 r
F
.79358 .78397 m .63528 .61553 L .78264 .76767 L F
.63528 .61553 m .6343 .61449 L .63564 .61587 L F
.63528 .61553 m .63564 .61587 L .78264 .76767 L F
.61559 .63404 m .6343 .61449 L .61483 .63343 L .535 .283 .479 r
F
.78174 .76695 m .63563 .61587 L .61559 .63404 L F
.63563 .61587 m .6343 .61449 L .61559 .63404 L F
.78106 .76604 m .6343 .61449 L .78174 .76695 L F
.78264 .76767 m .78106 .76604 L .78174 .76695 L F
.78264 .76767 m .61585 .63425 L .76999 .74906 L F
.61585 .63425 m .61594 .63431 L .76999 .74906 L F
.6156 .63406 m .6162 .63446 L .76999 .74906 L F
.61559 .63404 m .61561 .63406 L .6156 .63406 L F
.61561 .63406 m .6162 .63446 L .6156 .63406 L F
.76874 .74837 m .6162 .63446 L .59644 .65333 L .488 .216 .427 r
F
.76833 .74783 m .61483 .63343 L .76874 .74837 L F
.76999 .74906 m .76833 .74783 L .76874 .74837 L F
.76999 .74906 m .59749 .65391 L .75553 .72852 L F
.59749 .65391 m .59644 .65333 L .59785 .65399 L F
.59749 .65391 m .59785 .65399 L .75553 .72852 L F
.75378 .72769 m .59785 .65399 L .75452 .72819 L .423 .131 .363 r
F
.59785 .65399 m .59644 .65333 L .59785 .654 L F
.59785 .65399 m .59785 .654 L .75452 .72819 L F
.75424 .72811 m .59644 .65333 L .57933 .67367 L F
.75412 .728 m .59644 .65333 L .75424 .72811 L F
.7544 .72798 m .75378 .72769 L .75459 .72822 L F
.75378 .72769 m .75452 .72819 L .75459 .72822 L F
.75459 .72822 m .75412 .728 L .75424 .72811 L F
.75553 .72852 m .7544 .72798 L .75459 .72822 L F
.75553 .72852 m .58037 .67399 L .73919 .70647 L F
.58037 .67399 m .58046 .67398 L .73919 .70647 L F
.58015 .67392 m .58071 .67395 L .73919 .70647 L F
.5801 .67391 m .58017 .67391 L .58015 .67392 L F
.58017 .67391 m .58071 .67395 L .58015 .67392 L F
.73787 .70638 m .58071 .67395 L .56357 .6939 L .334 .024 .282 r
F
.73741 .70611 m .57933 .67367 L .73787 .70638 L F
.73919 .70647 m .73741 .70611 L .73787 .70638 L F
.73919 .70647 m .5646 .69397 L .72092 .68342 L F
.5646 .69397 m .56357 .6939 L .56492 .69381 L F
.5646 .69397 m .56492 .69381 L .72092 .68342 L F
.71915 .68353 m .56492 .69381 L .71994 .68359 L .213 0 .178 r
F
.56492 .69381 m .56357 .6939 L .56492 .69381 L F
.56492 .69381 m .56492 .69381 L .71994 .68359 L F
.71961 .68365 m .56357 .6939 L .54921 .7135 L F
.71949 .68362 m .56357 .6939 L .71961 .68365 L F
.71975 .68349 m .71915 .68353 L .71994 .68359 L F
.71915 .68353 m .71994 .68359 L .71994 .68359 L F
.71994 .68359 m .71949 .68362 L .71961 .68365 L F
.72092 .68342 m .71975 .68349 L .71994 .68359 L F
.72092 .68342 m .5502 .71332 L .70077 .65988 L F
.5502 .71332 m .55029 .71325 L .70077 .65988 L F
.54993 .71337 m .55046 .71306 L .70077 .65988 L F
.69949 .66044 m .55046 .71306 L .53623 .73198 L .05 0 .047 r
F
.54993 .71337 m .54921 .7135 L .55046 .71306 L .213 0 .178 r
F
.69904 .66049 m .54921 .7135 L .69949 .66044 L .05 0 .047 r
F
.70077 .65988 m .69904 .66049 L .69949 .66044 L F
.70077 .65988 m .53623 .73198 L .67879 .6364 L F
.67785 .63708 m .53623 .73198 L .67786 .63707 L 0 0 0 r
F
.67716 .63749 m .53623 .73198 L .67785 .63708 L F
.67757 .63729 m .53623 .73198 L .52457 .74891 L F
.67746 .63734 m .53623 .73198 L .67757 .63729 L F
.67767 .63714 m .67716 .63749 L .67785 .63708 L F
.67786 .63707 m .67746 .63734 L .67757 .63729 L F
.67879 .6364 m .67767 .63714 L .67786 .63707 L F
.67879 .6364 m .52457 .74891 L .65511 .61352 L F
.65397 .61473 m .52457 .74891 L .51413 .76398 L F
.65511 .61352 m .65358 .61511 L .65397 .61473 L F
.65358 .61511 m .52457 .74891 L .65397 .61473 L F
.5502 .71332 m .54993 .71337 L .55029 .71325 L .213 0 .178 r
F
.55046 .71306 m .54921 .7135 L .53623 .73198 L .05 0 .047 r
F
.58037 .67399 m .5801 .67391 L .58046 .67398 L .423 .131 .363 r
F
.5801 .67391 m .57933 .67367 L .58071 .67395 L F
.58071 .67395 m .57933 .67367 L .56357 .6939 L .334 .024 .282 r
F
.61585 .63425 m .61559 .63404 L .61594 .63431 L .535 .283 .479 r
F
.61559 .63404 m .61483 .63343 L .6162 .63446 L F
.6162 .63446 m .61483 .63343 L .59644 .65333 L .488 .216 .427 r
F
.25 g
.65464 .59694 m
.65586 .59859 L
s
.65586 .59859 m
.65589 .59864 L
s
1 0 0 r
.003 w
.65464 .59694 m
.67554 .58117 L
s
.25 g
.5 Mabswid
.67554 .58117 m
.67664 .58305 L
s
.67664 .58305 m
.67669 .58313 L
s
1 0 0 r
.003 w
.6343 .61449 m
.65464 .59694 L
s
.8178 .81647 m .69665 .56741 L .81099 .80855 L .632 .453 .622 r
F
.8178 .81647 m .7176 .5558 L .69665 .56741 L F
.25 g
.5 Mabswid
.80623 .52644 m
.80641 .52793 L
s
1 0 0 r
.003 w
.67554 .58117 m
.69665 .56741 L
s
.25 g
.5 Mabswid
.65589 .59864 m
.70548 .66538 L
s
.69665 .56741 m
.69762 .56945 L
s
.69762 .56945 m
.69769 .56959 L
s
.19839 .77456 m
.20106 .77371 L
s
.20106 .77371 m
.3705 .71955 L
s
.6343 .61449 m
.63562 .61585 L
s
.63562 .61585 m
.63564 .61587 L
s
.63564 .61587 m
.64426 .62477 L
s
1 0 0 r
.003 w
.61483 .63343 m
.6343 .61449 L
s
.82358 .82139 m .7176 .5558 L .8178 .81647 L .643 .481 .648 r
F
.82358 .82139 m .73798 .54635 L .7176 .5558 L F
.25 g
.5 Mabswid
.8185 .52585 m
.81855 .5265 L
s
.80641 .52793 m
.8065 .52871 L
s
1 0 0 r
.003 w
.69665 .56741 m
.7176 .5558 L
s
.25 g
.5 Mabswid
.7176 .5558 m
.7185 .55815 L
s
1 0 0 r
.003 w
.73907 .51675 m
.75835 .51506 L
s
.82852 .82328 m .73798 .54635 L .82358 .82139 L .651 .506 .673 r
F
.82852 .82328 m .75739 .53892 L .73798 .54635 L F
.25 g
.5 Mabswid
.82818 .52479 m
.82822 .52548 L
s
.81855 .5265 m
.81859 .52691 L
s
.81679 .61611 m
.83377 .76025 L
s
.8065 .52871 m
.80652 .5289 L
s
1 0 0 r
.003 w
.7176 .5558 m
.73798 .54635 L
s
.25 g
.5 Mabswid
.73798 .54635 m
.73862 .54843 L
s
.73862 .54843 m
.73874 .5488 L
s
.61483 .63343 m
.6162 .63446 L
s
.6162 .63446 m
.61621 .63447 L
s
.61621 .63447 m
.62709 .64258 L
s
1 0 0 r
.003 w
.59644 .65333 m
.59702 .65271 L
s
.59702 .65271 m
.61483 .63343 L
s
0 g
.006 w
.2289 .84269 m
.24357 .86182 L
s
.83277 .82222 m .75739 .53892 L .82852 .82328 L .656 .528 .696 r
F
.83277 .82222 m .77546 .53332 L .75739 .53892 L F
.25 g
.5 Mabswid
.82822 .52548 m
.82823 .52555 L
s
.67669 .58313 m
.76278 .72937 L
s
.69769 .56959 m
.77042 .72298 L
s
.7185 .55815 m
.75889 .66323 L
s
.73874 .5488 m
.76338 .62798 L
s
1 0 0 r
.003 w
.73798 .54635 m
.75739 .53892 L
s
.25 g
.5 Mabswid
.75739 .53892 m
.75802 .54142 L
s
.75802 .54142 m
.76348 .56326 L
s
1 0 0 r
.003 w
.75739 .53892 m
.76212 .53746 L
s
.8365 .81829 m .77546 .53332 L .83277 .82222 L .659 .548 .718 r
F
.25 g
.5 Mabswid
.82787 .82071 m
.82852 .82328 L
s
.82283 .81897 m
.82358 .82139 L
s
.82278 .81881 m
.82283 .81897 L
s
.8365 .81829 m .79184 .52924 L .77546 .53332 L .659 .548 .718 r
F
.25 g
.83525 .52392 m
.83528 .52436 L
s
.83528 .52436 m
.84821 .77609 L
s
0 g
.006 w
.8365 .81829 m
.83982 .81164 L
s
.25 g
.5 Mabswid
.82823 .52555 m
.84246 .74238 L
s
.81859 .52691 m
.83074 .66498 L
s
.80652 .5289 m
.81679 .61611 L
s
.76278 .72937 m
.80168 .79546 L
s
.80168 .79546 m
.80172 .79553 L
s
.80172 .79553 m
.80221 .79636 L
s
.80221 .79636 m
.80298 .79766 L
s
.77042 .72298 m
.80985 .80615 L
s
.80985 .80615 m
.8099 .80625 L
s
.8099 .80625 m
.81034 .80717 L
s
.81034 .80717 m
.81099 .80855 L
s
.75889 .66323 m
.81683 .81395 L
s
.81683 .81395 m
.81688 .81408 L
s
.81688 .81408 m
.81726 .81508 L
s
.81726 .81508 m
.8178 .81647 L
s
.76338 .62798 m
.82278 .81881 L
s
.7858 .65249 m
.82787 .82071 L
s
.76348 .56326 m
.7858 .65249 L
s
1 0 0 r
.003 w
.76212 .53746 m
.77546 .53332 L
s
.25 g
.5 Mabswid
.83636 .81739 m
.8365 .81829 L
s
.83618 .81622 m
.83636 .81739 L
s
.83613 .8159 m
.83618 .81622 L
s
.82177 .72294 m
.83613 .8159 L
s
.80096 .58829 m
.82177 .72294 L
s
.79223 .53174 m
.80096 .58829 L
s
.79216 .53128 m
.79223 .53174 L
s
.79198 .53013 m
.79216 .53128 L
s
.79184 .52924 m
.79198 .53013 L
s
.75937 .5155 m
.75939 .5155 L
s
.75939 .5155 m
.79177 .52926 L
s
0 g
.006 w
.83277 .82222 m
.8365 .81829 L
s
1 0 0 r
.003 w
.75835 .51506 m
.77645 .51398 L
s
.25 g
.5 Mabswid
.80552 .68483 m
.83277 .82222 L
s
.7832 .57234 m
.80552 .68483 L
s
.77546 .53332 m
.7758 .535 L
s
.7758 .535 m
.77594 .53572 L
s
.77594 .53572 m
.77595 .5358 L
s
.77595 .5358 m
.7832 .57234 L
s
1 0 0 r
.003 w
.78004 .53218 m
.79184 .52924 L
s
.77546 .53332 m
.78004 .53218 L
s
.25 g
.5 Mabswid
.59644 .65333 m
.5965 .65336 L
s
.5965 .65336 m
.59784 .65399 L
s
.59784 .65399 m
.59785 .65399 L
s
.59785 .65399 m
.61038 .65992 L
s
1 0 0 r
.003 w
.57933 .67367 m
.58067 .67207 L
s
.58067 .67207 m
.59644 .65333 L
s
.79577 .52845 m
.80622 .52636 L
s
.79184 .52924 m
.79577 .52845 L
s
.77645 .51398 m
.7929 .51355 L
s
.80933 .52584 m
.81836 .52433 L
s
.80622 .52636 m
.80933 .52584 L
s
.82066 .52397 m
.82805 .52283 L
s
.81836 .52433 m
.82066 .52397 L
s
.25 g
.5 Mabswid
.57933 .67367 m
.57946 .67369 L
s
.57946 .67369 m
.5803 .67386 L
s
.5803 .67386 m
.58071 .67395 L
s
.58071 .67395 m
.58072 .67395 L
s
.58072 .67395 m
.59418 .67671 L
s
1 0 0 r
.003 w
.56357 .6939 m
.57933 .67367 L
s
.25 g
.5 Mabswid
.1935 .74945 m
.19626 .74899 L
s
.19626 .74899 m
.37633 .71856 L
s
1 0 0 r
.003 w
.47834 .70711 m
.481 .71352 L
s
0 g
.006 w
.2163 .82155 m
.2289 .84269 L
s
1 0 0 r
.003 w
.7929 .51355 m
.80732 .51373 L
s
.82964 .52256 m
.83514 .52161 L
s
.82805 .52283 m
.82964 .52256 L
s
.83612 .52135 m
.83951 .52045 L
s
.83514 .52161 m
.83612 .52135 L
s
.80732 .51373 m
.81941 .5144 L
s
.83997 .52011 m
.84109 .51926 L
s
.83951 .52045 m
.83997 .52011 L
s
.81941 .5144 m
.82895 .51544 L
s
.83986 .51799 m
.84109 .51926 L
s
.82895 .51544 m
.8358 .51668 L
s
.8358 .51668 m
.83986 .51799 L
s
.25 g
.5 Mabswid
.56357 .6939 m
.56455 .69383 L
s
.56455 .69383 m
.5649 .69381 L
s
.5649 .69381 m
.56492 .69381 L
s
.56492 .69381 m
.57858 .6929 L
s
1 0 0 r
.003 w
.54921 .7135 m
.56357 .6939 L
s
0 g
.006 w
.82852 .82328 m
.83277 .82222 L
s
.20605 .79872 m
.2163 .82155 L
s
.25 g
.5 Mabswid
.19149 .7238 m
.19428 .72372 L
s
.19428 .72372 m
.38206 .7184 L
s
.54921 .7135 m
.55046 .71306 L
s
.55046 .71306 m
.5505 .71304 L
s
.5505 .71304 m
.56363 .7084 L
s
1 0 0 r
.003 w
.53623 .73198 m
.54921 .7135 L
s
0 g
.006 w
.19839 .77456 m
.20605 .79872 L
s
.25 g
.5 Mabswid
.53623 .73198 m
.53737 .73122 L
s
.53737 .73122 m
.54943 .72313 L
s
1 0 0 r
.003 w
.52457 .74891 m
.53623 .73198 L
s
0 g
.006 w
.82358 .82139 m
.82852 .82328 L
s
.25 g
.5 Mabswid
.19243 .69801 m
.19519 .69831 L
s
.19519 .69831 m
.38777 .71901 L
s
0 g
.006 w
.1935 .74945 m
.19839 .77456 L
s
.19149 .7238 m
.1935 .74945 L
s
.25 g
.5 Mabswid
.19634 .67248 m
.19902 .67313 L
s
.19902 .67313 m
.39362 .72043 L
s
1 0 0 r
.003 w
.48578 .75569 m
.48632 .74517 L
s
0 g
.006 w
.8178 .81647 m
.82358 .82139 L
s
.62989 .59177 m .51413 .76398 L .50482 .77698 L .609 .826 .432 r
F
.25 g
.5 Mabswid
.52457 .74891 m
.52557 .74787 L
s
.65511 .61352 m .51413 .76398 L .62989 .59177 L 0 0 0 r
F
0 g
.006 w
.19149 .7238 m
.19243 .69801 L
s
.25 g
.5 Mabswid
.20318 .64759 m
.20574 .64857 L
s
.20574 .64857 m
.39982 .72281 L
s
1 0 0 r
.003 w
.48367 .76725 m
.48578 .75569 L
s
0 g
.006 w
.19243 .69801 m
.19634 .67248 L
s
.60335 .57162 m .50482 .77698 L .49653 .78781 L .777 .918 .538 r
F
.25 g
.5 Mabswid
.51413 .76398 m
.51498 .76272 L
s
.62989 .59177 m .50482 .77698 L .60335 .57162 L .609 .826 .432 r
F
1 0 0 r
.003 w
.50482 .77698 m
.51413 .76398 L
s
.25 g
.5 Mabswid
.62986 .59182 m
.62989 .59177 L
s
.62895 .59317 m
.62986 .59182 L
s
.62852 .5938 m
.62895 .59317 L
s
0 g
.006 w
.81099 .80855 m
.8178 .81647 L
s
.19634 .67248 m
.20318 .64759 L
s
.25 g
.5 Mabswid
.21288 .62372 m
.21527 .62498 L
s
.21527 .62498 m
.40656 .72638 L
s
1 0 0 r
.003 w
.48263 .7707 m
.48367 .76725 L
s
.57571 .55349 m .49653 .78781 L .4892 .79649 L .885 .95 .597 r
F
.25 g
.5 Mabswid
.50482 .77698 m
.50552 .77553 L
s
.51498 .76272 m
.5151 .76255 L
s
.60335 .57162 m .49653 .78781 L .57571 .55349 L .777 .918 .538 r
F
1 0 0 r
.003 w
.49653 .78781 m
.50482 .77698 L
s
.25 g
.5 Mabswid
.6033 .57171 m
.60335 .57162 L
s
.60253 .57332 m
.6033 .57171 L
s
.60217 .57407 m
.60253 .57332 L
s
0 g
.006 w
.20318 .64759 m
.21288 .62372 L
s
.25 g
.5 Mabswid
.22532 .60121 m
.2275 .60272 L
s
.2275 .60272 m
.41396 .73149 L
s
1 0 0 r
.003 w
.47695 .78631 m
.47823 .78318 L
s
0 g
.006 w
.80298 .79766 m
.81099 .80855 L
s
.54724 .53776 m .4892 .79649 L .48278 .80312 L .946 .944 .62 r
F
.25 g
.5 Mabswid
.49653 .78781 m
.49707 .78621 L
s
.50552 .77553 m
.50564 .77527 L
s
.57571 .55349 m .4892 .79649 L .54724 .53776 L .885 .95 .597 r
F
1 0 0 r
.003 w
.4892 .79649 m
.49653 .78781 L
s
.25 g
.5 Mabswid
.57566 .55365 m
.57571 .55349 L
s
.57504 .55549 m
.57566 .55365 L
s
.57475 .55633 m
.57504 .55549 L
s
0 g
.006 w
.21288 .62372 m
.22532 .60121 L
s
.25 g
.5 Mabswid
.24037 .58039 m
.2423 .58208 L
s
.2423 .58208 m
.42205 .73853 L
s
1 0 0 r
.003 w
.47364 .79293 m
.47695 .78631 L
s
.51821 .52471 m .48278 .80312 L .47725 .80788 L .977 .919 .622 r
F
.25 g
.5 Mabswid
.4892 .79649 m
.48959 .79477 L
s
.49707 .78621 m
.49721 .78582 L
s
.50564 .77527 m
.50568 .7752 L
s
.54724 .53776 m .48278 .80312 L .51821 .52471 L .946 .944 .62 r
F
.25 g
.5151 .76255 m
.62852 .5938 L
s
.50568 .7752 m
.60217 .57407 L
s
.49721 .78582 m
.57475 .55633 L
s
.48959 .79477 m
.54652 .54095 L
s
1 0 0 r
.003 w
.48278 .80312 m
.4892 .79649 L
s
.25 g
.5 Mabswid
.51776 .52822 m
.51789 .52723 L
s
.51789 .52723 m
.51817 .52502 L
s
.51817 .52502 m
.51821 .52471 L
s
.48278 .80312 m
.48371 .79581 L
s
.54719 .53798 m
.54724 .53776 L
s
.54673 .54002 m
.54719 .53798 L
s
.54652 .54095 m
.54673 .54002 L
s
0 g
.006 w
.22532 .60121 m
.24037 .58039 L
s
.79358 .78397 m
.80298 .79766 L
s
.25 g
.5 Mabswid
.25784 .56155 m
.2595 .56334 L
s
.2595 .56334 m
.27896 .58431 L
s
.27896 .58431 m
.43073 .74788 L
s
1 0 0 r
.003 w
.46988 .79975 m
.472 .79595 L
s
.4889 .51457 m .47725 .80788 L .47265 .81099 L .99 .885 .611 r
F
.25 g
.5 Mabswid
.47725 .80788 m
.47751 .8013 L
s
.48876 .5182 m
.4889 .51457 L
s
.47751 .8013 m
.48876 .5182 L
s
1 0 0 r
.003 w
.47725 .80788 m
.48278 .80312 L
s
.25 g
.5 Mabswid
.48371 .79581 m
.51776 .52822 L
s
0 g
.006 w
.24037 .58039 m
.25784 .56155 L
s
.25 g
.5 Mabswid
.27756 .54496 m
.27889 .54672 L
s
.27889 .54672 m
.28002 .54821 L
s
.4596 .5075 m .47265 .81099 L .46901 .81267 L .992 .847 .595 r
F
.25 g
.47241 .80552 m
.47265 .81099 L
s
1 0 0 r
.003 w
.46716 .80454 m
.46785 .80332 L
s
.47265 .81099 m
.47725 .80788 L
s
0 g
.006 w
.25784 .56155 m
.27756 .54496 L
s
.25 g
.5 Mabswid
.29932 .53084 m
.30023 .53234 L
s
.4306 .50358 m .46901 .81267 L .46642 .81311 L .987 .808 .577 r
F
.25 g
.4685 .80856 m
.46901 .81267 L
s
1 0 0 r
.003 w
.46534 .80821 m
.46576 .80737 L
s
.46901 .81267 m
.47265 .81099 L
s
0 g
.006 w
.78264 .76767 m
.79358 .78397 L
s
.25 g
.5 Mabswid
.32289 .51942 m
.3231 .51984 L
s
.3231 .51984 m
.32803 .52984 L
s
.40216 .50286 m .46642 .81311 L .46493 .81247 L .973 .768 .569 r
F
.4306 .50358 m .46642 .81311 L .40216 .50286 L .987 .808 .577 r
F
1 0 0 r
.003 w
.46642 .81311 m
.46901 .81267 L
s
.46457 .81083 m
.46459 .81078 L
s
.25 g
.5 Mabswid
.46568 .80953 m
.46642 .81311 L
s
.3511 .51872 m
.35425 .52683 L
s
.34805 .51086 m
.3511 .51872 L
s
.40216 .50286 m .46493 .81247 L .37456 .5053 L .973 .768 .569 r
F
.25 g
.46487 .81225 m
.46493 .81247 L
s
.46406 .80951 m
.46487 .81225 L
s
.37456 .5053 m
.37647 .5118 L
s
.37647 .5118 m
.37654 .51205 L
s
.37654 .51205 m
.46406 .80951 L
s
.46366 .80849 m
.46405 .8095 L
s
.35425 .52683 m
.46366 .80849 L
s
1 0 0 r
.003 w
.46493 .81247 m
.46642 .81311 L
s
.25 g
.5 Mabswid
.40216 .50286 m
.40316 .50769 L
s
.40316 .50769 m
.40322 .50796 L
s
.40322 .50796 m
.46568 .80953 L
s
.32803 .52984 m
.45692 .79114 L
s
.28002 .54821 m
.43972 .7598 L
s
.46181 .55872 m
.47241 .80552 L
s
.4596 .5075 m
.46181 .55872 L
s
.30023 .53234 m
.44862 .77432 L
s
.4306 .50358 m
.43168 .51226 L
s
.43168 .51226 m
.4685 .80856 L
s
0 g
.006 w
.27756 .54496 m
.29932 .53084 L
s
.29932 .53084 m
.32289 .51942 L
s
.76999 .74906 m
.78264 .76767 L
s
.32289 .51942 m
.34805 .51086 L
s
.75553 .72852 m
.76999 .74906 L
s
.34805 .51086 m
.37456 .5053 L
s
.37456 .5053 m
.40216 .50286 L
s
.73919 .70647 m
.75553 .72852 L
s
.40216 .50286 m
.4306 .50358 L
s
.72092 .68342 m
.73919 .70647 L
s
.4306 .50358 m
.4596 .5075 L
s
.4596 .5075 m
.4889 .51457 L
s
.70077 .65988 m
.72092 .68342 L
s
.4889 .51457 m
.51821 .52471 L
s
.67879 .6364 m
.70077 .65988 L
s
.51821 .52471 m
.54724 .53776 L
s
.65511 .61352 m
.67879 .6364 L
s
.54724 .53776 m
.57571 .55349 L
s
.62989 .59177 m
.65511 .61352 L
s
.57571 .55349 m
.60335 .57162 L
s
.60335 .57162 m
.62989 .59177 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[%, ViewPoint \[Rule] {\(-0.120\), \(-1.153\), 3.179}]\)], "Input",

  
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08226 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.112363 1.17234 -0.0900796 1.17234 [
[ 0 0 0 0 ]
[ 1 1.08226 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15213 0 m
.04127 .1616 L
s
.04127 .1616 m
0 1.00512 L
s
0 1.00512 m
.11111 .65945 L
s
.11111 .65945 m
.15213 0 L
s
.86642 .07429 m
.76554 .72169 L
s
.76554 .72169 m
.8539 1.08226 L
s
.8539 1.08226 m
1 .2591 L
s
1 .2591 m
.86642 .07429 L
s
.15213 0 m
.04127 .1616 L
s
.04127 .1616 m
1 .2591 L
s
1 .2591 m
.86642 .07429 L
s
.86642 .07429 m
.15213 0 L
s
.11111 .65945 m
.76554 .72169 L
s
.76554 .72169 m
.8539 1.08226 L
s
.8539 1.08226 m
0 1.00512 L
s
0 1.00512 m
.11111 .65945 L
s
0 0 m
1 0 L
1 1.08226 L
0 1.08226 L
closepath
clip
newpath
.46752 .41783 m .47001 .44628 L .47933 .36118 L .985 .793 .393 r
F
.47152 .46347 m .47254 .47509 L .47847 .4472 L F
.47254 .47509 m .47762 .53297 L .4783 .46464 L F
.47254 .47509 m .4783 .46464 L .47847 .4472 L F
.47254 .47509 m .47744 .53499 L .47762 .53297 L F
.4644 .46468 m .46647 .47583 L .46557 .46095 L .975 .735 .315 r
F
.46647 .47583 m .47133 .46441 L .46985 .44727 L F
.46557 .46095 m .46985 .44727 L .4528 .25009 L F
.46647 .47583 m .46985 .44727 L .46557 .46095 L F
.51311 .30911 m .51092 .31622 L .51937 .28919 L 0 0 .098 r
F
.47001 .44628 m .47133 .46441 L .47152 .46347 L .985 .793 .393 r
F
.42561 .25554 m .4644 .46468 L .4528 .25009 L .975 .735 .315 r
F
.4644 .46468 m .46557 .46095 L .4528 .25009 L F
.46647 .47583 m .47714 .53793 L .47744 .53499 L F
.4644 .46468 m .46641 .47623 L .46647 .47583 L F
.46641 .47623 m .47714 .53793 L .46647 .47583 L F
.4574 .46852 m .46036 .47895 L .46115 .45032 L .974 .692 .29 r
F
.53237 .32108 m .52362 .34228 L .53979 .30372 L 0 0 .103 r
F
.46251 .48649 m .47714 .53793 L .46617 .47783 L .974 .692 .29 r
F
.46434 .46521 m .46635 .47664 L .4644 .46468 L .975 .735 .315 r
F
.46635 .47664 m .47714 .53793 L .46641 .47623 L F
.46635 .47664 m .46641 .47623 L .4644 .46468 L F
.45637 .46167 m .46009 .44451 L .45615 .42293 L .974 .692 .29 r
F
.45298 .45299 m .45404 .45696 L .45597 .46352 L F
.4535 .47814 m .45165 .48909 L .45475 .48122 L 0 0 .132 r
F
.45165 .48909 m .44496 .52861 L .45271 .4911 L F
.45165 .48909 m .45271 .4911 L .45475 .48122 L F
.45298 .45336 m .44795 .50057 L .45597 .46352 L F
.44795 .50057 m .44496 .52861 L .45597 .46352 L F
.44959 .48509 m .44471 .52898 L .44795 .50057 L F
.45725 .49126 m .4592 .49691 L .45924 .49642 L .966 .648 .269 r
F
.45717 .49249 m .4591 .49795 L .45725 .49126 L F
.4591 .49795 m .47606 .54592 L .4592 .49691 L F
.4591 .49795 m .4592 .49691 L .45725 .49126 L F
.45924 .49642 m .46603 .51639 L .4767 .54165 L F
.4592 .49691 m .47606 .54592 L .45924 .49642 L F
.45902 .49874 m .45659 .50463 L .45902 .49879 L 0 0 .103 r
F
.45707 .49383 m .4459 .53051 L .45902 .49874 L 0 0 .098 r
F
.45659 .50463 m .45658 .50471 L .45901 .49886 L 0 0 .103 r
F
.45659 .50463 m .45901 .49886 L .45902 .49879 L F
.45707 .49383 m .45486 .5005 L .45482 .50121 L 0 0 .098 r
F
.45717 .4924 m .44534 .52918 L .45707 .49383 L F
.46016 .48117 m .45731 .49041 L .45901 .48556 L F
.45725 .49126 m .4767 .54165 L .46008 .48209 L .966 .648 .269 r
F
.46008 .48209 m .45901 .48556 L .46003 .48265 L 0 0 .098 r
F
.46016 .48117 m .45901 .48556 L .46008 .48209 L F
.45731 .49041 m .44534 .52918 L .45717 .4924 L F
.45099 .47179 m .44956 .4844 L .44959 .48509 L 0 0 .132 r
F
.45298 .45299 m .45098 .47133 L .45099 .47179 L F
.45098 .47133 m .44956 .4844 L .45099 .47179 L F
.45597 .46352 m .4535 .47814 L .4574 .46837 L F
.4535 .47814 m .45475 .48122 L .4574 .46837 L F
.45298 .45237 m .45098 .47093 L .45298 .45299 L F
.45098 .47093 m .44471 .52898 L .45098 .47133 L F
.45098 .47093 m .45098 .47133 L .45298 .45299 L F
.45617 .42214 m .44954 .48393 L .45615 .42293 L F
.44954 .48393 m .44471 .52898 L .44955 .48413 L F
.44954 .48393 m .44955 .48413 L .45615 .42293 L F
.44956 .4844 m .44471 .52898 L .44959 .48509 L F
.45731 .49038 m .45499 .49792 L .45731 .49039 L 0 0 .098 r
F
.45726 .47097 m .44534 .52918 L .46018 .481 L 0 0 .096 r
F
.45499 .49792 m .45498 .49795 L .46016 .48117 L 0 0 .098 r
F
.46018 .481 m .46098 .48376 L .46025 .48018 L .974 .692 .29 r
F
.46008 .48209 m .46098 .48376 L .46018 .481 L F
.46215 .48951 m .46233 .48795 L .46025 .48018 L F
.46251 .48649 m .4767 .54165 L .47714 .53793 L F
.46245 .48696 m .4767 .54165 L .46251 .48649 L F
.46029 .47979 m .4767 .54165 L .46036 .47895 L F
.46215 .48951 m .4767 .54165 L .46233 .48795 L F
.46115 .45032 m .46416 .46678 L .46351 .46252 L .975 .735 .315 r
F
.46116 .45016 m .46351 .46252 L .46132 .4481 L F
.46115 .45032 m .46351 .46252 L .46116 .45016 L F
.46416 .46678 m .46434 .46521 L .46132 .4481 L F
.46036 .47895 m .46416 .46678 L .46115 .45032 L .974 .692 .29 r
F
.46132 .4481 m .46434 .46521 L .4644 .46468 L .975 .735 .315 r
F
.46712 .42134 m .4574 .46838 L .46674 .42467 L 0 0 .096 r
F
.45895 .49951 m .47606 .54592 L .4591 .49795 L .966 .648 .269 r
F
.46185 .49199 m .45901 .49886 L .4615 .49494 L 0 0 .103 r
F
.45648 .5061 m .45784 .50932 L .45787 .50893 L .951 .6 .244 r
F
.45886 .50037 m .46035 .50431 L .45895 .49951 L .966 .648 .269 r
F
.46035 .50431 m .47606 .54592 L .46044 .50356 L F
.46035 .50431 m .46044 .50356 L .45895 .49951 L F
.46025 .48018 m .4767 .54165 L .46029 .47979 L .974 .692 .29 r
F
.46416 .46678 m .47714 .53793 L .46434 .46521 L .975 .735 .315 r
F
.46647 .47583 m .47744 .53499 L .47133 .46441 L F
.45901 .49886 m .4459 .53051 L .45422 .51156 L 0 0 .103 r
F
.45901 .49886 m .45653 .50542 L .45886 .50037 L F
.45653 .50542 m .45422 .51156 L .45648 .5061 L F
.45653 .50542 m .45648 .5061 L .45886 .50037 L F
.45648 .5061 m .45787 .50893 L .45886 .50037 L .951 .6 .244 r
F
.45787 .50893 m .47606 .54592 L .46035 .50431 L F
.45787 .50893 m .46035 .50431 L .45886 .50037 L F
.55395 .32735 m .50209 .42655 L .56137 .31387 L 0 0 .105 r
F
.45638 .50755 m .45771 .51061 L .45645 .50657 L .951 .6 .244 r
F
.45771 .51061 m .47511 .55047 L .4578 .50973 L F
.45771 .51061 m .4578 .50973 L .45645 .50657 L F
.45787 .50893 m .46501 .52612 L .47606 .54592 L F
.45784 .50932 m .47511 .55047 L .45787 .50893 L F
.45645 .50657 m .4578 .50973 L .45648 .5061 L F
.4578 .50973 m .47511 .55047 L .45784 .50932 L F
.4578 .50973 m .45784 .50932 L .45648 .5061 L F
.45373 .52741 m .4737 .55495 L .45574 .52436 L .901 .487 .167 r
F
.45592 .52234 m .45382 .52564 L .45538 .52839 L 0 0 .099 r
F
.45184 .5361 m .46847 .56231 L .47158 .55902 L .865 .418 .11 r
F
.45184 .53616 m .46847 .56231 L .45184 .5361 L F
.45187 .53451 m .45012 .53679 L .45089 .53728 L 0 0 .083 r
F
.45184 .5361 m .45089 .53728 L .45181 .53786 L F
.45187 .53451 m .45089 .53728 L .45184 .5361 L F
.45166 .52901 m .44809 .53459 L .45167 .53155 L 0 0 .099 r
F
.45422 .52809 m .46235 .54257 L .4737 .55495 L .901 .487 .167 r
F
.4542 .52825 m .47158 .55902 L .45422 .52809 L F
.45353 .53134 m .45168 .5343 L .45392 .53183 L 0 0 .099 r
F
.45168 .5343 m .45012 .53679 L .45187 .53451 L F
.45168 .5343 m .45187 .53451 L .45392 .53183 L F
.45168 .5343 m .45015 .53284 L .45012 .53679 L F
.45184 .5361 m .47158 .55902 L .45377 .53371 L .865 .418 .11 r
F
.45392 .53183 m .45187 .53451 L .45341 .5384 L 0 0 .083 r
F
.45344 .53323 m .47158 .55902 L .45373 .52741 L .901 .487 .167 r
F
.45353 .53134 m .45167 .53155 L .45168 .5343 L 0 0 .099 r
F
.45538 .52839 m .4536 .5299 L .45353 .53134 L F
.4536 .5299 m .45167 .53155 L .45353 .53134 L F
.45167 .53155 m .45015 .53284 L .45168 .5343 L F
.45015 .53284 m .44809 .53459 L .44861 .53516 L F
.45015 .53284 m .44861 .53516 L .45012 .53679 L F
.45532 .51712 m .44676 .5324 L .45441 .51927 L 0 0 .105 r
F
.4554 .51594 m .44676 .5324 L .45532 .51712 L F
.45761 .51164 m .44676 .5324 L .45761 .51173 L F
.45627 .50902 m .44676 .5324 L .45761 .51164 L 0 0 .103 r
F
.45529 .51761 m .45618 .51943 L .45621 .51914 L .93 .547 .211 r
F
.45506 .521 m .44809 .53459 L .45592 .52234 L 0 0 .105 r
F
.45493 .52299 m .4737 .55495 L .4634 .53407 L .93 .547 .211 r
F
.45506 .521 m .4634 .53407 L .45529 .51761 L F
.45493 .52299 m .4634 .53407 L .45506 .521 L F
.45621 .51914 m .4737 .55495 L .47511 .55047 L F
.45618 .51943 m .4737 .55495 L .45621 .51914 L F
.45529 .51761 m .47511 .55047 L .45743 .51358 L F
.45761 .51173 m .4554 .51594 L .45532 .51712 L 0 0 .105 r
F
.45761 .51173 m .45441 .51927 L .45743 .51358 L F
.45886 .50037 m .45648 .5061 L .45879 .50112 L 0 0 .103 r
F
.45648 .5061 m .45422 .51156 L .45646 .50644 L F
.45648 .5061 m .45646 .50644 L .45879 .50112 L F
.45475 .48123 m .44496 .52861 L .45472 .48204 L 0 0 .096 r
F
.4615 .49494 m .45646 .50644 L .46141 .49571 L 0 0 .103 r
F
.45646 .50644 m .4459 .53051 L .45643 .5069 L F
.45646 .50644 m .45643 .5069 L .46141 .49571 L F
.45618 .51034 m .47511 .55047 L .45638 .50755 L .951 .6 .244 r
F
.45858 .50335 m .4459 .53051 L .44676 .5324 L 0 0 .103 r
F
.45874 .50171 m .4459 .53051 L .45858 .50335 L F
.45659 .50463 m .4459 .53051 L .45658 .50471 L F
.45452 .5075 m .45614 .51089 L .45455 .50688 L .951 .6 .244 r
F
.45614 .51089 m .47511 .55047 L .45618 .51034 L F
.45614 .51089 m .45618 .51034 L .45455 .50688 L F
.45499 .49792 m .44534 .52918 L .45498 .49795 L 0 0 .098 r
F
.45482 .50121 m .44534 .52918 L .4459 .53051 L F
.45486 .5005 m .44534 .52918 L .45482 .50121 L F
.45267 .49341 m .44615 .52298 L .44534 .52918 L 0 0 .096 r
F
.45735 .46933 m .46025 .48018 L .45737 .46896 L .974 .692 .29 r
F
.46025 .48018 m .46029 .47979 L .45738 .46882 L F
.4574 .46838 m .45475 .48123 L .45734 .46954 L 0 0 .096 r
F
.4574 .46852 m .46029 .47979 L .46036 .47895 L .974 .692 .29 r
F
.4574 .46837 m .45475 .48122 L .4574 .46838 L 0 0 .096 r
F
.45475 .48122 m .45271 .4911 L .45475 .48122 L F
.45475 .48122 m .45475 .48122 L .4574 .46838 L F
.45499 .49792 m .46016 .48117 L .46016 .48115 L 0 0 .098 r
F
.46036 .47895 m .46245 .48696 L .46251 .48649 L .974 .692 .29 r
F
.46036 .47895 m .46251 .48649 L .46416 .46678 L F
.46391 .46887 m .45732 .49029 L .46389 .46904 L 0 0 .098 r
F
.45732 .49029 m .44534 .52918 L .45731 .49037 L F
.45732 .49029 m .45731 .49037 L .46389 .46904 L F
.45895 .49951 m .4591 .49795 L .45717 .49249 L .966 .648 .269 r
F
.45731 .49037 m .45499 .49792 L .45731 .49037 L 0 0 .098 r
F
.46251 .48649 m .46617 .47783 L .46416 .46678 L .974 .692 .29 r
F
.46985 .44727 m .47133 .46441 L .47001 .44628 L .985 .793 .393 r
F
.47001 .44628 m .47152 .46347 L .47876 .41844 L F
.47152 .46347 m .47847 .4472 L .47876 .41844 L F
.45499 .49792 m .45499 .49792 L .51863 .29165 L 0 0 .098 r
F
.45708 .49375 m .4546 .48523 L .45457 .48603 L .966 .648 .269 r
F
.45895 .49951 m .4571 .49344 L .45708 .49375 L F
.4571 .49344 m .4546 .48523 L .45708 .49375 L F
.51799 .29366 m .45731 .49037 L .51863 .29165 L 0 0 .098 r
F
.45731 .49037 m .45731 .49037 L .51863 .29165 L F
.45499 .49792 m .44534 .52918 L .45499 .49792 L F
.45618 .51034 m .45638 .50755 L .4547 .50371 L .951 .6 .244 r
F
.45462 .50537 m .4547 .50371 L .45256 .49881 L F
.45618 .51034 m .4547 .50371 L .45462 .50537 L F
.4571 .49344 m .45717 .49249 L .4546 .48523 L .966 .648 .269 r
F
.45895 .49951 m .45717 .49249 L .4571 .49344 L F
.45463 .48446 m .45717 .49249 L .45725 .49126 L F
.45271 .4911 m .45271 .49111 L .4574 .46838 L 0 0 .096 r
F
.46752 .41783 m .46985 .44727 L .47001 .44628 L .985 .793 .393 r
F
.4674 .41888 m .46985 .44727 L .46752 .41783 L F
.47001 .44628 m .47876 .41844 L .47933 .36118 L F
.4574 .46838 m .4574 .46838 L .50202 .25232 L 0 0 .096 r
F
.45271 .4911 m .4574 .46838 L .4574 .46838 L F
.45731 .49038 m .45731 .49039 L .46016 .48115 L 0 0 .098 r
F
.45731 .49038 m .46016 .48115 L .46017 .48114 L F
.46017 .48113 m .45731 .49038 L .46017 .48114 L F
.45726 .47102 m .46008 .48209 L .45793 .47327 L .974 .692 .29 r
F
.45466 .48367 m .45269 .49203 L .45267 .49341 L 0 0 .096 r
F
.45726 .47097 m .45469 .48282 L .45466 .48367 L F
.45469 .48282 m .45269 .49203 L .45466 .48367 L F
.4573 .47022 m .4547 .48252 L .45726 .47097 L F
.4547 .48252 m .45269 .49203 L .45469 .48282 L F
.4547 .48252 m .45469 .48282 L .45726 .47097 L F
.45704 .49433 m .45708 .49375 L .45457 .48603 L .966 .648 .269 r
F
.45738 .46882 m .46029 .47979 L .4574 .46852 L .974 .692 .29 r
F
.46025 .48018 m .45738 .46882 L .45737 .46896 L F
.45734 .46954 m .44496 .52861 L .4573 .47022 L 0 0 .096 r
F
.45475 .48123 m .45472 .48204 L .45734 .46954 L F
.46008 .48209 m .46025 .48018 L .45298 .45299 L .974 .692 .29 r
F
.46103 .45194 m .45734 .46954 L .46095 .45296 L 0 0 .096 r
F
.45734 .46954 m .4573 .47022 L .46095 .45296 L F
.45298 .45629 m .45726 .47097 L .45298 .45299 L .974 .692 .29 r
F
.45726 .47097 m .45793 .47327 L .45728 .47061 L F
.45726 .47097 m .45728 .47061 L .45298 .45299 L F
.45456 .4864 m .45457 .48603 L .45106 .47522 L .966 .648 .269 r
F
.45704 .49433 m .45457 .48603 L .45456 .4864 L F
.45112 .47828 m .45452 .48749 L .45106 .47522 L F
.45452 .48749 m .45704 .49433 L .45456 .4864 L F
.45452 .48749 m .45456 .4864 L .45106 .47522 L F
.45298 .45667 m .45721 .47182 L .45726 .47102 L .974 .692 .29 r
F
.45721 .47182 m .46008 .48209 L .45726 .47102 L F
.45106 .47522 m .4546 .48523 L .45463 .48446 L .966 .648 .269 r
F
.4546 .48523 m .45717 .49249 L .45463 .48446 L F
.45597 .46352 m .45738 .46882 L .4574 .46852 L .974 .692 .29 r
F
.50121 .25622 m .4574 .46837 L .50202 .25232 L 0 0 .096 r
F
.4574 .46837 m .4574 .46838 L .50202 .25232 L F
.45271 .4911 m .44496 .52861 L .45271 .49111 L F
.45269 .49203 m .44615 .52298 L .45267 .49341 L F
.45254 .50012 m .45256 .49881 L .44987 .49264 L .951 .6 .244 r
F
.45618 .51034 m .45256 .49881 L .45254 .50012 L F
.45737 .46896 m .45738 .46882 L .45597 .46352 L .974 .692 .29 r
F
.46095 .45296 m .4573 .47022 L .45726 .47097 L 0 0 .096 r
F
.45004 .49734 m .45249 .50252 L .44987 .49264 L .951 .6 .244 r
F
.45249 .50252 m .45618 .51034 L .45254 .50012 L F
.45249 .50252 m .45254 .50012 L .44987 .49264 L F
.47233 .47597 m .47744 .53499 L .47254 .47509 L .985 .793 .393 r
F
.58207 .27354 m .4571 .51703 L .60612 .28752 L 0 0 .105 r
F
.4571 .51703 m .45506 .521 L .45733 .51749 L F
.4571 .51703 m .45733 .51749 L .60612 .28752 L F
.45506 .521 m .45592 .52234 L .60612 .28752 L F
.4571 .51703 m .44676 .5324 L .44809 .53459 L F
.45737 .51418 m .44676 .5324 L .4571 .51703 L F
.44795 .50057 m .44471 .52898 L .44496 .52861 L 0 0 .132 r
F
.44615 .52298 m .44496 .52861 L .44498 .52865 L 0 0 .096 r
F
.44615 .52298 m .44498 .52865 L .44534 .52918 L F
.43839 .52048 m .45171 .54221 L .45169 .53592 L .865 .418 .11 r
F
.28673 .34437 m .40213 .48276 L .43839 .52048 L F
.40213 .48276 m .45171 .54221 L .43839 .52048 L F
.60612 .28752 m .45353 .53134 L .62859 .30401 L 0 0 .099 r
F
.45353 .53134 m .45392 .53183 L .62859 .30401 L F
.46235 .54257 m .47158 .55902 L .47305 .5562 L .901 .487 .167 r
F
.46235 .54257 m .47305 .5562 L .4737 .55495 L F
.45373 .52741 m .4542 .52825 L .45422 .52809 L F
.45171 .54221 m .45171 .54221 L .45169 .53592 L .865 .418 .11 r
F
.45171 .54221 m .46847 .56231 L .45184 .53616 L F
.45171 .54221 m .45184 .53616 L .45169 .53592 L F
.45341 .5384 m .45187 .53451 L .45316 .53872 L 0 0 .083 r
F
.46603 .51639 m .47606 .54592 L .47652 .54283 L .966 .648 .269 r
F
.46603 .51639 m .47652 .54283 L .4767 .54165 L F
.62859 .30401 m .45392 .53183 L .45341 .5384 L 0 0 .083 r
F
.28673 .34437 m .45184 .5361 L .30594 .32359 L .865 .418 .11 r
F
.45187 .53451 m .45181 .53786 L .45316 .53872 L 0 0 .083 r
F
.45166 .52901 m .45167 .53155 L .4536 .5299 L 0 0 .099 r
F
.45184 .5361 m .45377 .53371 L .30594 .32359 L .865 .418 .11 r
F
.45169 .53592 m .45184 .53616 L .45184 .5361 L F
.45382 .52564 m .45166 .52901 L .4536 .5299 L 0 0 .099 r
F
.45382 .52564 m .4536 .5299 L .45538 .52839 L F
.30594 .32359 m .45344 .53323 L .45373 .52741 L .901 .487 .167 r
F
.30594 .32359 m .45373 .52741 L .32696 .30497 L F
.45373 .52741 m .45574 .52436 L .32696 .30497 L F
.60612 .28752 m .45592 .52234 L .45538 .52839 L 0 0 .099 r
F
.45743 .51358 m .45441 .51927 L .45737 .51418 L 0 0 .105 r
F
.32696 .30497 m .45493 .52299 L .45529 .51761 L .93 .547 .211 r
F
.32696 .30497 m .45529 .51761 L .34963 .28869 L F
.45615 .42293 m .45298 .45237 L .45298 .45299 L 0 0 .132 r
F
.39918 .26385 m .45597 .46352 L .42561 .25554 L .974 .692 .29 r
F
.45597 .46352 m .45637 .46167 L .42561 .25554 L F
.45637 .46167 m .45615 .42293 L .45385 .44475 L F
.45614 .42368 m .45298 .45336 L .46116 .45016 L 0 0 .132 r
F
.45298 .45336 m .4574 .46837 L .46116 .45016 L F
.4562 .42049 m .46115 .45032 L .46132 .4481 L .975 .735 .315 r
F
.45615 .42293 m .46115 .45032 L .4562 .42049 L F
.46223 .36647 m .46074 .37957 L .44795 .50057 L 0 0 .132 r
F
.46252 .36089 m .4674 .41888 L .46752 .41783 L .985 .793 .393 r
F
.46247 .36189 m .4674 .41888 L .46252 .36089 L F
.4528 .25009 m .46752 .41783 L .48046 .24758 L F
.46643 .32706 m .4623 .36513 L .46223 .36647 L 0 0 .132 r
F
.4623 .36513 m .46074 .37957 L .46223 .36647 L F
.4528 .25009 m .46247 .36189 L .46252 .36089 L .985 .793 .393 r
F
.45529 .51761 m .45743 .51358 L .34963 .28869 L .93 .547 .211 r
F
.46001 .50715 m .45761 .51173 L .45963 .5103 L 0 0 .105 r
F
.45761 .51173 m .45737 .51418 L .45963 .5103 L F
.50209 .42655 m .45761 .51164 L .51012 .41161 L F
.45761 .51164 m .45761 .51173 L .51012 .41161 L F
.50209 .42655 m .51012 .41161 L .56137 .31387 L F
.4547 .50371 m .45638 .50755 L .45476 .50259 L .951 .6 .244 r
F
.45638 .50755 m .45645 .50657 L .45476 .50259 L F
.34963 .28869 m .45648 .5061 L .37377 .27494 L F
.45648 .5061 m .45886 .50037 L .37377 .27494 L F
.46911 .48979 m .46001 .50715 L .46747 .49683 L 0 0 .105 r
F
.46001 .50715 m .45963 .5103 L .46747 .49683 L F
.47152 .46347 m .47233 .47597 L .47254 .47509 L .985 .793 .393 r
F
.47133 .46441 m .47233 .47597 L .47152 .46347 L F
.55668 .26221 m .45627 .50902 L .58207 .27354 L 0 0 .103 r
F
.45627 .50902 m .45761 .51164 L .58207 .27354 L F
.46501 .52612 m .47511 .55047 L .47579 .54722 L .951 .6 .244 r
F
.46501 .52612 m .47579 .54722 L .47606 .54592 L F
.46747 .49683 m .45737 .51418 L .4571 .51703 L 0 0 .105 r
F
.45901 .49886 m .45879 .50112 L .4615 .49494 L 0 0 .103 r
F
.45697 .49534 m .45886 .50037 L .45704 .49433 L .966 .648 .269 r
F
.45886 .50037 m .45895 .49951 L .45704 .49433 L F
.45457 .48603 m .4546 .48523 L .45106 .47522 L F
.4574 .46838 m .45734 .46954 L .46674 .42467 L 0 0 .096 r
F
.45404 .45696 m .45735 .46933 L .45597 .46352 L .974 .692 .29 r
F
.45735 .46933 m .45737 .46896 L .45597 .46352 L F
.46017 .48114 m .46016 .48115 L .51532 .3025 L 0 0 .098 r
F
.46956 .47338 m .46185 .49199 L .4684 .4792 L 0 0 .103 r
F
.46185 .49199 m .4615 .49494 L .4684 .4792 L F
.51062 .31758 m .46017 .48113 L .51532 .3025 L 0 0 .098 r
F
.46017 .48113 m .46017 .48114 L .51532 .3025 L F
.46016 .48115 m .46016 .48117 L .51532 .3025 L F
.45298 .45667 m .45793 .47327 L .45298 .45629 L .974 .692 .29 r
F
.50293 .24791 m .45726 .47097 L .5302 .25363 L 0 0 .096 r
F
.45726 .47097 m .46018 .481 L .5302 .25363 L F
.46008 .48209 m .46215 .48951 L .46098 .48376 L .974 .692 .29 r
F
.46476 .48752 m .4615 .49494 L .46461 .48853 L 0 0 .103 r
F
.4615 .49494 m .46141 .49571 L .46461 .48853 L F
.45115 .47995 m .45697 .49534 L .45112 .47828 L .966 .648 .269 r
F
.45697 .49534 m .45704 .49433 L .45112 .47828 L F
.45008 .49824 m .45452 .5075 L .45004 .49734 L .951 .6 .244 r
F
.45452 .5075 m .45455 .50688 L .45004 .49734 L F
.47516 .2451 m .46825 .30951 L .46643 .32706 L 0 0 .132 r
F
.46825 .30951 m .46074 .37957 L .46643 .32706 L F
.37377 .27494 m .45106 .47522 L .39918 .26385 L .966 .648 .269 r
F
.45106 .47522 m .45725 .49126 L .45167 .46938 L F
.45106 .47522 m .45167 .46938 L .39918 .26385 L F
.38536 .36323 m .45008 .49824 L .39889 .38893 L .951 .6 .244 r
F
.45008 .49824 m .45004 .49734 L .39889 .38893 L F
.4106 .37252 m .45115 .47995 L .42717 .4133 L .966 .648 .269 r
F
.45115 .47995 m .45112 .47828 L .42717 .4133 L F
.45731 .49041 m .45717 .4924 L .46345 .47288 L 0 0 .098 r
F
.45725 .49126 m .46008 .48209 L .39918 .26385 L .966 .648 .269 r
F
.46389 .46911 m .46016 .48117 L .46345 .47288 L 0 0 .098 r
F
.46016 .48117 m .46003 .48265 L .46345 .47288 L F
.45704 .49433 m .45895 .49951 L .45708 .49375 L .966 .648 .269 r
F
.45902 .49879 m .45901 .49886 L .46533 .48358 L 0 0 .103 r
F
.46536 .48338 m .45902 .49874 L .46533 .48358 L F
.45902 .49874 m .45902 .49879 L .46533 .48358 L F
.5302 .25363 m .45707 .49383 L .55668 .26221 L 0 0 .098 r
F
.45707 .49383 m .45902 .49874 L .55668 .26221 L F
.46461 .48853 m .45874 .50171 L .45858 .50335 L 0 0 .103 r
F
.45476 .50259 m .45645 .50657 L .45648 .5061 L .951 .6 .244 r
F
.44987 .49264 m .4547 .50371 L .45476 .50259 L F
.46345 .47288 m .45717 .4924 L .45707 .49383 L 0 0 .098 r
F
.42717 .4133 m .45112 .47828 L .45106 .47522 L .966 .648 .269 r
F
.39889 .38893 m .45004 .49734 L .44987 .49264 L .951 .6 .244 r
F
.34963 .28869 m .38536 .36323 L .39889 .38893 L F
.37377 .27494 m .4106 .37252 L .42717 .4133 L .966 .648 .269 r
F
.45597 .46352 m .4574 .46852 L .45637 .46167 L .974 .692 .29 r
F
.39918 .26385 m .45298 .45667 L .45298 .45299 L F
.46074 .37957 m .45617 .42214 L .45615 .42293 L 0 0 .132 r
F
.42561 .25554 m .45615 .42293 L .4562 .42049 L .975 .735 .315 r
F
.45385 .44475 m .45615 .42293 L .42561 .25554 L .974 .692 .29 r
F
.4574 .46852 m .46115 .45032 L .46009 .44451 L F
.4574 .46852 m .46009 .44451 L .45637 .46167 L F
.46752 .41783 m .47933 .36118 L .48046 .24758 L .985 .793 .393 r
F
.47516 .2451 m .45614 .42368 L .50152 .25319 L 0 0 .132 r
F
.50267 .24788 m .50152 .25319 L .50293 .24791 L F
.47516 .2451 m .50152 .25319 L .50267 .24788 L F
.45614 .42368 m .46116 .45016 L .50293 .24791 L F
.51532 .3025 m .46389 .46911 L .46345 .47288 L 0 0 .098 r
F
.52362 .34228 m .46536 .48338 L .53264 .32099 L 0 0 .103 r
F
.46536 .48338 m .46533 .48358 L .53264 .32099 L F
.52362 .34228 m .53264 .32099 L .53979 .30372 L F
.51863 .29165 m .51062 .31758 L .51532 .3025 L 0 0 .098 r
F
.4684 .4792 m .46476 .48752 L .46461 .48853 L 0 0 .103 r
F
.46908 .45208 m .46391 .46887 L .46904 .45235 L 0 0 .098 r
F
.46391 .46887 m .46389 .46904 L .46904 .45235 L F
.46674 .42467 m .46103 .45194 L .46095 .45296 L 0 0 .096 r
F
.50202 .25232 m .46712 .42134 L .46674 .42467 L F
.51092 .31622 m .46908 .45208 L .51799 .29366 L 0 0 .098 r
F
.46908 .45208 m .46904 .45235 L .51799 .29366 L F
.51092 .31622 m .51799 .29366 L .51937 .28919 L F
.51937 .28919 m .51799 .29366 L .51863 .29165 L F
.53896 .30576 m .46956 .47338 L .4684 .4792 L 0 0 .103 r
F
.53979 .30372 m .53845 .30694 L .53896 .30576 L F
.53845 .30694 m .46956 .47338 L .53896 .30576 L F
.56137 .31387 m .46911 .48979 L .46747 .49683 L 0 0 .105 r
F
.58207 .27354 m .55395 .32735 L .56137 .31387 L F
.55668 .26221 m .53237 .32108 L .53979 .30372 L 0 0 .103 r
F
.5302 .25363 m .51311 .30911 L .51937 .28919 L 0 0 .098 r
F
.50293 .24791 m .50121 .25622 L .50202 .25232 L 0 0 .096 r
F
.25 g
.5 Mabswid
.47762 .53297 m
.47789 .50564 L
s
1 0 0 r
.003 w
.47744 .53499 m
.47762 .53297 L
s
.25 g
.5 Mabswid
.4528 .25009 m
.4532 .25471 L
s
.4532 .25471 m
.45322 .25495 L
s
.47521 .50923 m
.47744 .53499 L
s
1 0 0 r
.003 w
.47714 .53793 m
.47744 .53499 L
s
.25 g
.5 Mabswid
.46116 .45016 m
.46712 .42131 L
s
.50121 .25622 m
.50293 .24791 L
s
.47652 .53453 m
.47714 .53793 L
s
.42561 .25554 m
.42574 .25625 L
s
.42574 .25625 m
.42618 .25866 L
s
.42618 .25866 m
.42637 .2597 L
s
.46009 .44451 m
.46115 .45032 L
s
.47255 .51279 m
.47652 .53453 L
s
1 0 0 r
.003 w
.4767 .54165 m
.47714 .53793 L
s
.25 g
.5 Mabswid
.46391 .46887 m
.46908 .45208 L
s
.46018 .481 m
.46391 .46887 L
s
.47608 .53946 m
.4767 .54165 L
s
.47531 .53667 m
.47608 .53946 L
s
.45298 .45667 m
.45721 .47182 L
s
.45721 .47182 m
.46008 .48209 L
s
.46971 .51659 m
.47531 .53667 L
s
.39918 .26385 m
.39933 .26437 L
s
.39933 .26437 m
.39995 .26662 L
s
.39995 .26662 m
.40023 .2676 L
s
1 0 0 r
.003 w
.47606 .54592 m
.4767 .54165 L
s
.25 g
.5 Mabswid
.46536 .48338 m
.46962 .47308 L
s
.45902 .49874 m
.46536 .48338 L
s
.47533 .54401 m
.47606 .54592 L
s
.47366 .53957 m
.47533 .54401 L
s
.45115 .47995 m
.45697 .49534 L
s
.45697 .49534 m
.45886 .50037 L
s
.46657 .52079 m
.47366 .53957 L
s
.37377 .27494 m
.37472 .27744 L
s
.37472 .27744 m
.37507 .27837 L
s
1 0 0 r
.003 w
.47511 .55047 m
.47606 .54592 L
s
.25 g
.5 Mabswid
.58103 .27554 m
.58207 .27354 L
s
.34963 .28869 m
.35114 .29185 L
s
.45614 .51089 m
.45743 .51358 L
s
.46311 .52542 m
.47511 .55047 L
s
1 0 0 r
.003 w
.4737 .55495 m
.47511 .55047 L
s
.21976 .47228 m .43936 .56236 L .22927 .44437 L .354 0 0 r
F
.21976 .47228 m .42636 .55851 L .43936 .56236 L F
.21205 .50081 m .42636 .55851 L .21976 .47228 L 0 .446 .742 r
F
.22927 .44437 m .44982 .56465 L .24068 .41735 L .533 0 0 r
F
.22927 .44437 m .43936 .56236 L .44982 .56465 L F
0 g
.006 w
.21976 .47228 m
.22927 .44437 L
s
.25 g
.5 Mabswid
.22927 .44437 m
.23129 .4455 L
s
.21341 .50117 m .41069 .5533 L .42636 .55851 L 0 .446 .742 r
F
.21308 .50108 m .21353 .5012 L .21341 .50117 L F
.21353 .5012 m .41069 .5533 L .21341 .50117 L F
.21389 .50129 m .41069 .5533 L .21308 .50108 L F
.21205 .50081 m .21389 .50129 L .21308 .50108 L F
.20602 .52966 m .41069 .5533 L .21205 .50081 L .106 .618 .892 r
F
.20728 .5298 m .39238 .54702 L .41069 .5533 L F
.20602 .52966 m .20771 .52981 L .20728 .5298 L F
.20771 .52981 m .39238 .54702 L .20728 .5298 L F
.2015 .55855 m .20238 .55849 L .20602 .52966 L .309 .73 .974 r
F
.20238 .55849 m .39135 .54708 L .20771 .52981 L F
.20238 .55849 m .20771 .52981 L .20602 .52966 L F
.39135 .54708 m .3904 .54684 L .20602 .52966 L F
.39135 .54708 m .39238 .54702 L .3904 .54684 L F
.20265 .55848 m .37161 .54007 L .39238 .54702 L F
.2015 .55855 m .20301 .55838 L .20265 .55848 L F
.20301 .55838 m .37161 .54007 L .20265 .55848 L F
.19832 .5872 m .19909 .58699 L .2015 .55855 L .459 .785 .999 r
F
.19909 .58699 m .37035 .54041 L .20301 .55838 L F
.19909 .58699 m .20301 .55838 L .2015 .55855 L F
.37035 .54041 m .36978 .54027 L .2015 .55855 L F
.37035 .54041 m .37161 .54007 L .36978 .54027 L F
.19933 .58693 m .34873 .53289 L .37161 .54007 L F
.19832 .5872 m .19962 .58673 L .19933 .58693 L F
.19962 .58673 m .34873 .53289 L .19933 .58693 L F
.19626 .61536 m .19693 .615 L .19832 .5872 L .559 .803 .99 r
F
.19693 .615 m .34762 .5335 L .19962 .58673 L F
.19693 .615 m .19962 .58673 L .19832 .5872 L F
.34762 .5335 m .3471 .53348 L .19832 .5872 L F
.34762 .5335 m .34873 .53289 L .3471 .53348 L F
.19713 .61489 m .32421 .52594 L .34873 .53289 L F
.19626 .61536 m .19735 .6146 L .19713 .61489 L F
.19735 .6146 m .32421 .52594 L .19713 .61489 L F
.19512 .64275 m .19567 .64225 L .19626 .61536 L .623 .799 .966 r
F
.19567 .64225 m .32327 .5268 L .19735 .6146 L F
.19567 .64225 m .19735 .6146 L .19626 .61536 L F
.32327 .5268 m .32282 .52692 L .19626 .61536 L F
.32327 .5268 m .32421 .52594 L .32282 .52692 L F
.19583 .6421 m .29863 .51965 L .32421 .52594 L F
.19512 .64275 m .19598 .64172 L .19583 .6421 L F
.19598 .64172 m .29863 .51965 L .19583 .6421 L F
.19467 .66913 m .19511 .6685 L .19512 .64275 L .664 .785 .938 r
F
.19511 .6685 m .29788 .52073 L .19598 .64173 L F
.19511 .6685 m .19598 .64173 L .19512 .64275 L F
.29788 .52073 m .29751 .52098 L .19512 .64275 L F
.29788 .52073 m .29863 .51965 L .29751 .52098 L F
.19523 .66833 m .27263 .51435 L .29863 .51965 L F
.19467 .66913 m .19531 .66787 L .19523 .66833 L F
.19531 .66787 m .27263 .51435 L .19523 .66833 L F
.19469 .69427 m .19501 .69353 L .19467 .66913 L .69 .766 .91 r
F
.19501 .69353 m .27207 .51564 L .19531 .66787 L F
.19501 .69353 m .19531 .66787 L .19467 .66913 L F
.27207 .51564 m .2718 .516 L .19467 .66913 L F
.27207 .51564 m .27263 .51435 L .2718 .516 L F
.1951 .69333 m .24686 .51028 L .27263 .51435 L F
.19469 .69427 m .19511 .6928 L .1951 .69333 L F
.19511 .6928 m .24686 .51028 L .1951 .69333 L F
.19496 .71794 m .19517 .7171 L .19469 .69427 L .706 .746 .883 r
F
.19517 .7171 m .2465 .51173 L .19511 .6928 L F
.19517 .7171 m .19511 .6928 L .19469 .69427 L F
.2465 .51173 m .24632 .5122 L .19469 .69427 L F
.2465 .51173 m .24686 .51028 L .24632 .5122 L F
.19496 .71794 m .22195 .50754 L .24686 .51028 L F
.19526 .73993 m .22177 .50911 L .19496 .71794 L .716 .726 .858 r
F
.22177 .50911 m .22168 .50967 L .19496 .71794 L F
.22177 .50911 m .22195 .50754 L .22168 .50967 L F
.19526 .73993 m .19845 .50608 L .22195 .50754 L F
.1954 .76004 m .19843 .50775 L .19526 .73993 L .721 .705 .835 r
F
.19843 .50775 m .19845 .50608 L .19842 .50837 L F
.19843 .50775 m .19842 .50837 L .19526 .73993 L F
.25 g
.21205 .50081 m
.21389 .50129 L
s
.23129 .4455 m
.23131 .44551 L
s
.21976 .47228 m
.22171 .4731 L
s
0 g
.006 w
.21205 .50081 m
.21976 .47228 L
s
.21079 .50685 m
.21164 .50278 L
s
.21164 .50278 m
.21205 .50081 L
s
.24068 .41735 m .45794 .56535 L .25405 .3915 L .662 .107 0 r
F
.24068 .41735 m .44982 .56465 L .45794 .56535 L F
.25 g
.5 Mabswid
.45761 .51164 m
.46917 .48953 L
s
.45008 .49824 m
.45614 .51089 L
s
0 g
.006 w
.22927 .44437 m
.24068 .41735 L
s
.25 g
.5 Mabswid
.21389 .50129 m
.24944 .51069 L
s
.24068 .41735 m
.24274 .4188 L
s
.60483 .28955 m
.60612 .28752 L
s
.25405 .3915 m .46405 .56451 L .26941 .36709 L .752 .235 0 r
F
.25405 .3915 m .45794 .56535 L .46405 .56451 L F
0 g
.006 w
.24068 .41735 m
.25405 .3915 L
s
.25 g
.5 Mabswid
.45592 .52234 m
.46792 .50358 L
s
.25405 .3915 m
.25614 .39327 L
s
.73369 .50209 m .55409 .52852 L .73704 .53151 L 0 0 0 r
F
.55409 .52852 m .55376 .52857 L .55426 .52857 L F
.55409 .52852 m .55426 .52857 L .73704 .53151 L F
.55379 .52857 m .55475 .52874 L .73704 .53151 L F
.55376 .52857 m .5538 .52857 L .55379 .52857 L F
.5538 .52857 m .55475 .52874 L .55379 .52857 L F
.60297 .52398 m .57664 .5259 L .60224 .52378 L .313 .769 .952 r
F
.55376 .52857 m .55278 .52871 L .55475 .52874 L 0 0 0 r
F
.73704 .53151 m .55278 .52871 L .57664 .5259 L .208 .73 .852 r
F
.73704 .53151 m .5778 .52594 L .73851 .56111 L F
.5778 .52594 m .57664 .5259 L .57837 .52628 L F
.5778 .52594 m .57837 .52628 L .73851 .56111 L F
.73789 .56094 m .57837 .52628 L .60297 .52398 L .313 .769 .952 r
F
.57837 .52628 m .57664 .5259 L .60297 .52398 L F
.73705 .56079 m .57664 .5259 L .73789 .56094 L F
.73851 .56111 m .73705 .56079 L .73789 .56094 L F
.73851 .56111 m .60323 .52405 L .73828 .59062 L F
.60323 .52405 m .60335 .52417 L .73828 .59062 L F
.60305 .52402 m .60368 .52449 L .73828 .59062 L F
.60297 .52398 m .60308 .52406 L .60305 .52402 L F
.60308 .52406 m .60368 .52449 L .60305 .52402 L F
.73761 .5902 m .60368 .52449 L .62897 .52269 L .399 .772 .993 r
F
.60323 .52405 m .60297 .52398 L .60335 .52417 L .313 .769 .952 r
F
.60297 .52398 m .60224 .52378 L .60368 .52449 L F
.60368 .52449 m .60224 .52378 L .62897 .52269 L .399 .772 .993 r
F
.73705 .59001 m .60224 .52378 L .73761 .5902 L F
.73828 .59062 m .73705 .59001 L .73761 .5902 L F
.73828 .59062 m .62975 .52318 L .73658 .6198 L F
.62975 .52318 m .62897 .52269 L .6301 .52372 L F
.62975 .52318 m .6301 .52372 L .73658 .6198 L F
.7362 .61934 m .62897 .52269 L .7362 .61934 L .462 .753 .993 r
F
.73559 .61891 m .62897 .52269 L .7362 .61934 L F
.73607 .61919 m .62897 .52269 L .65612 .52289 L F
.73595 .61912 m .62897 .52269 L .73607 .61919 L F
.73592 .6192 m .73559 .61891 L .7362 .61934 L F
.7362 .61934 m .73595 .61912 L .73607 .61919 L F
.73658 .6198 m .73592 .6192 L .7362 .61934 L F
.73658 .6198 m .65668 .52358 L .73362 .64841 L F
.65668 .52358 m .65675 .52375 L .73362 .64841 L F
.65664 .52358 m .65689 .52415 L .73362 .64841 L F
.65652 .52338 m .65669 .52374 L .65664 .52358 L F
.65669 .52374 m .65689 .52415 L .65664 .52358 L F
.7333 .64762 m .65689 .52415 L .68297 .52453 L .507 .728 .972 r
F
.7329 .64724 m .65612 .52289 L .7333 .64762 L F
.73362 .64841 m .7329 .64724 L .7333 .64762 L F
.73362 .64841 m .68332 .52539 L .72968 .67623 L F
.68332 .52539 m .68297 .52453 L .68345 .52609 L F
.68332 .52539 m .68345 .52609 L .72968 .67623 L F
.72956 .67547 m .68345 .52609 L .72958 .67549 L .54 .702 .944 r
F
.68345 .52609 m .68297 .52453 L .68345 .52609 L F
.68345 .52609 m .68345 .52609 L .72958 .67549 L F
.72924 .67481 m .68297 .52453 L .72956 .67547 L F
.72955 .67526 m .68297 .52453 L .70885 .52764 L F
.72947 .67514 m .68297 .52453 L .72955 .67526 L F
.72938 .67525 m .72924 .67481 L .72956 .67547 L F
.72958 .67549 m .72947 .67514 L .72955 .67526 L F
.72968 .67623 m .72938 .67525 L .72958 .67549 L F
.72968 .67623 m .70899 .52866 L .72501 .70304 L F
.70899 .52866 m .709 .5289 L .72501 .70304 L F
.70894 .52833 m .70899 .52924 L .72501 .70304 L F
.72507 .7019 m .709 .52924 L .73315 .5321 L .566 .679 .915 r
F
.72486 .70135 m .70885 .52764 L .72507 .7019 L F
.72501 .70304 m .72486 .70135 L .72507 .7019 L F
.72501 .70304 m .73315 .5321 L .71989 .72866 L F
.72006 .72759 m .73315 .5321 L .72008 .72764 L .587 .659 .887 r
F
.71998 .72732 m .72001 .72676 L .72006 .72759 L F
.72001 .72676 m .73315 .5321 L .72006 .72759 L F
.72013 .72734 m .73315 .5321 L .7554 .53772 L F
.72008 .72764 m .72011 .7272 L .72013 .72734 L F
.72011 .7272 m .73315 .5321 L .72013 .72734 L F
.71989 .72866 m .71998 .72732 L .72008 .72764 L F
.71989 .72866 m .7554 .53772 L .71457 .75289 L F
.715 .75141 m .7554 .53772 L .77523 .54417 L .605 .643 .862 r
F
.71457 .75289 m .71498 .75071 L .715 .75141 L F
.71498 .75071 m .7554 .53772 L .715 .75141 L F
.70899 .52866 m .70894 .52833 L .709 .5289 L .54 .702 .944 r
F
.70894 .52833 m .70885 .52764 L .70899 .52924 L F
.709 .52924 m .70885 .52764 L .73315 .5321 L .566 .679 .915 r
F
.65668 .52358 m .65652 .52338 L .65675 .52375 L .462 .753 .993 r
F
.65652 .52338 m .65612 .52289 L .65689 .52415 L F
.65689 .52415 m .65612 .52289 L .68297 .52453 L .507 .728 .972 r
F
.73369 .50209 m .53118 .53183 L .55278 .52871 L 0 0 0 r
F
.72829 .4731 m .53118 .53183 L .73369 .50209 L F
0 g
.006 w
.73369 .50209 m
.73704 .53151 L
s
.73704 .53151 m
.73712 .53311 L
s
.25 g
.5 Mabswid
.32696 .30497 m
.3286 .30776 L
s
1 0 0 r
.003 w
.47158 .55902 m
.4737 .55495 L
s
.72829 .4731 m .5122 .53487 L .53118 .53183 L 0 0 0 r
F
.72073 .4448 m .5122 .53487 L .72829 .4731 L .054 0 0 r
F
.25 g
.5 Mabswid
.73186 .50236 m
.73369 .50209 L
s
0 g
.006 w
.72829 .4731 m
.73369 .50209 L
s
.26941 .36709 m .46847 .56231 L .28673 .34437 L .817 .336 .035 r
F
.25 g
.5 Mabswid
.3286 .30776 m
.32866 .30787 L
s
.46247 .36189 m
.46254 .36274 L
s
.26941 .36709 m .46405 .56451 L .46847 .56231 L .817 .336 .035 r
F
.25 g
.37507 .27837 m
.4106 .37252 L
s
.46074 .37957 m
.46232 .36483 L
s
.40023 .2676 m
.43567 .39462 L
s
.45617 .42214 m
.46074 .37957 L
s
.43567 .39462 m
.45298 .45667 L
s
.35114 .29185 m
.45008 .49824 L
s
.4106 .37252 m
.45115 .47995 L
s
.4387 .56198 m
.43936 .56236 L
s
.43774 .56144 m
.4387 .56198 L
s
.43733 .56122 m
.43774 .56144 L
s
.43726 .56117 m
.43733 .56122 L
s
.23131 .44551 m
.43726 .56117 L
s
.42424 .55763 m
.42428 .55764 L
s
.22171 .4731 m
.42424 .55763 L
s
.42594 .55833 m
.42636 .55851 L
s
.42481 .55786 m
.42594 .55833 L
s
.42428 .55764 m
.42481 .55786 L
s
.44777 .56322 m
.44789 .5633 L
s
.29558 .45602 m
.44777 .56322 L
s
.24274 .4188 m
.29558 .45602 L
s
.31836 .44633 m
.45003 .55861 L
s
.25614 .39327 m
.31836 .44633 L
s
.45616 .56383 m
.45794 .56535 L
s
.45003 .55861 m
.45616 .56383 L
s
0 g
.006 w
.25405 .3915 m
.26941 .36709 L
s
.25 g
.5 Mabswid
.32866 .30787 m
.44952 .51377 L
s
.44952 .51377 m
.4526 .51901 L
s
.4526 .51901 m
.45574 .52436 L
s
.45933 .53047 m
.4737 .55495 L
s
.37127 .4704 m
.45046 .55073 L
s
.26941 .36709 m
.27082 .36852 L
s
.27082 .36852 m
.27145 .36916 L
s
.27145 .36916 m
.37127 .4704 L
s
.45046 .55073 m
.45079 .55106 L
s
.45079 .55106 m
.46405 .56451 L
s
.44789 .5633 m
.44812 .56346 L
s
.44812 .56346 m
.44982 .56465 L
s
0 g
.006 w
.26941 .36709 m
.28673 .34437 L
s
.72073 .4448 m .49601 .53751 L .5122 .53487 L .054 0 0 r
F
.71093 .41747 m .49601 .53751 L .72073 .4448 L .087 0 0 r
F
.25 g
.5 Mabswid
.72635 .47365 m
.72829 .4731 L
s
0 g
.006 w
.72073 .4448 m
.72829 .4731 L
s
.19626 .61536 m
.19712 .60363 L
s
.25 g
.5 Mabswid
.40213 .48276 m
.45171 .54221 L
s
.28673 .34437 m
.28681 .34447 L
s
.28681 .34447 m
.28809 .34601 L
s
.28809 .34601 m
.28869 .34673 L
s
.28869 .34673 m
.40213 .48276 L
s
.45171 .54221 m
.46847 .56231 L
s
0 g
.006 w
.28673 .34437 m
.30594 .32359 L
s
.71093 .41747 m .48264 .53947 L .49601 .53751 L .087 0 0 r
F
.69885 .39136 m .48264 .53947 L .71093 .41747 L .095 0 0 r
F
.25 g
.5 Mabswid
.71871 .44563 m
.72073 .4448 L
s
0 g
.006 w
.71093 .41747 m
.72073 .4448 L
s
.25 g
.5 Mabswid
.45392 .53183 m
.45591 .52924 L
s
.69885 .39136 m .47195 .54058 L .48264 .53947 L .095 0 0 r
F
.6845 .36673 m .47195 .54058 L .69885 .39136 L .085 0 0 r
F
.25 g
.70888 .41856 m
.71093 .41747 L
s
0 g
.006 w
.69885 .39136 m
.71093 .41747 L
s
.25 g
.5 Mabswid
.45591 .52924 m
.4975 .47499 L
s
.43977 .51381 m
.45377 .53371 L
s
.30594 .32359 m
.30605 .32374 L
s
.30605 .32374 m
.30724 .32544 L
s
.30724 .32544 m
.3078 .32623 L
s
.3078 .32623 m
.43977 .51381 L
s
.4553 .53587 m
.47158 .55902 L
s
0 g
.006 w
.30594 .32359 m
.32696 .30497 L
s
.25 g
.5 Mabswid
.19626 .61536 m
.19694 .61488 L
s
.19694 .61488 m
.19697 .61486 L
s
0 g
.006 w
.19512 .64275 m
.19606 .62016 L
s
.19606 .62016 m
.19626 .61536 L
s
1 0 0 r
.003 w
.46847 .56231 m
.47158 .55902 L
s
.6845 .36673 m .46371 .54079 L .47195 .54058 L .085 0 0 r
F
.66793 .34381 m .46371 .54079 L .6845 .36673 L .059 0 .017 r
F
.25 g
.5 Mabswid
.6812 .40296 m
.69682 .39269 L
s
.69682 .39269 m
.69885 .39136 L
s
0 g
.006 w
.6845 .36673 m
.69885 .39136 L
s
.25 g
.5 Mabswid
.66102 .38523 m
.6845 .36673 L
s
0 g
.006 w
.32696 .30497 m
.34963 .28869 L
s
.66793 .34381 m .45757 .54012 L .46371 .54079 L .059 0 .017 r
F
.25 g
.5 Mabswid
.47195 .54058 m
.47246 .54025 L
s
.64925 .32283 m .45757 .54012 L .66793 .34381 L .019 0 .057 r
F
0 g
.006 w
.66793 .34381 m
.6845 .36673 L
s
.25 g
.5 Mabswid
.65612 .52289 m
.65689 .52415 L
s
.64078 .36915 m
.66793 .34381 L
s
0 g
.006 w
.34963 .28869 m
.37377 .27494 L
s
.25 g
.5 Mabswid
.19512 .64275 m
.19565 .64212 L
s
.19565 .64212 m
.19598 .64172 L
s
.19598 .64172 m
.19601 .64169 L
s
.19601 .64169 m
.19661 .64098 L
s
0 g
.006 w
.19467 .66913 m
.19512 .64275 L
s
.64925 .32283 m .45316 .53872 L .45757 .54012 L .019 0 .057 r
F
.25 g
.5 Mabswid
.46371 .54079 m
.46582 .53912 L
s
.47246 .54025 m
.4737 .53943 L
s
.4737 .53943 m
.4742 .53911 L
s
.48264 .53947 m
.48295 .5393 L
s
.62859 .30401 m .45316 .53872 L .64925 .32283 L 0 0 .083 r
F
.25 g
.42637 .2597 m
.45615 .42293 L
s
1 0 0 r
.003 w
.45181 .53786 m
.45316 .53872 L
s
.25 g
.5 Mabswid
.45322 .25495 m
.46247 .36189 L
s
.46908 .45208 m
.51092 .31622 L
s
.53118 .53183 m
.53334 .53151 L
s
.53334 .53151 m
.73186 .50236 L
s
.46917 .48953 m
.55248 .33016 L
s
.55278 .52871 m
.55475 .52874 L
s
.55475 .52874 m
.59231 .52931 L
s
.5122 .53487 m
.51377 .53442 L
s
.51377 .53442 m
.51448 .53422 L
s
.51448 .53422 m
.72635 .47365 L
s
.46962 .47308 m
.53057 .32545 L
s
.57664 .5259 m
.57837 .52628 L
s
.57837 .52628 m
.57837 .52628 L
s
.57837 .52628 m
.57837 .52628 L
s
.57837 .52628 m
.63032 .53758 L
s
.46792 .50358 m
.57048 .34325 L
s
.49601 .53751 m
.49617 .53744 L
s
.49617 .53744 m
.49766 .53682 L
s
.49834 .53654 m
.71871 .44563 L
s
.49766 .53682 m
.49834 .53654 L
s
.46712 .42131 m
.50121 .25622 L
s
.60224 .52378 m
.60368 .52449 L
s
.60368 .52449 m
.60368 .52449 L
s
.60368 .52449 m
.60369 .5245 L
s
.60369 .5245 m
.66356 .55391 L
s
.48496 .53823 m
.70888 .41856 L
s
.48436 .53855 m
.48496 .53823 L
s
.48295 .5393 m
.48436 .53855 L
s
.62897 .52269 m
.63008 .5237 L
s
.63008 .5237 m
.6301 .52372 L
s
.6301 .52372 m
.69 .57777 L
s
.4975 .47499 m
.59752 .34453 L
s
.4742 .53911 m
.6812 .40296 L
s
.46582 .53912 m
.48793 .52169 L
s
.48793 .52169 m
.66102 .38523 L
s
.59752 .34453 m
.59868 .34302 L
s
.46232 .36483 m
.47516 .2451 L
s
.4595 .53832 m
.49086 .50905 L
s
.45928 .53853 m
.4595 .53832 L
s
.45757 .54012 m
.45928 .53853 L
s
.49086 .50905 m
.61631 .39198 L
s
.61631 .39198 m
.64078 .36915 L
s
.59868 .34302 m
.62707 .30599 L
s
.5763 .33416 m
.60483 .28955 L
s
.57503 .33613 m
.5763 .33416 L
s
.57048 .34325 m
.57503 .33613 L
s
.55395 .32735 m
.58103 .27554 L
s
.55248 .33016 m
.55395 .32735 L
s
.53057 .32545 m
.53237 .32108 L
s
0 g
.006 w
.64925 .32283 m
.66793 .34381 L
s
.25 g
.5 Mabswid
.46321 .52766 m
.61556 .35992 L
s
.4546 .53714 m
.46321 .52766 L
s
.45316 .53872 m
.4546 .53714 L
s
.61556 .35992 m
.61953 .35555 L
s
.61953 .35555 m
.64754 .32471 L
s
.64754 .32471 m
.64925 .32283 L
s
.62707 .30599 m
.62859 .30401 L
s
.53237 .32108 m
.55668 .26221 L
s
.51311 .30911 m
.5302 .25363 L
s
.51092 .31622 m
.51311 .30911 L
s
1 0 0 r
.003 w
.45435 .5391 m
.45757 .54012 L
s
.45316 .53872 m
.45435 .5391 L
s
0 g
.006 w
.62859 .30401 m
.64925 .32283 L
s
.25 g
.5 Mabswid
.68297 .52453 m
.68342 .52599 L
s
0 g
.006 w
.37377 .27494 m
.39918 .26385 L
s
.60612 .28752 m
.62859 .30401 L
s
1 0 0 r
.003 w
.46405 .56451 m
.46847 .56231 L
s
0 g
.006 w
.39918 .26385 m
.42561 .25554 L
s
.58207 .27354 m
.60612 .28752 L
s
.25 g
.5 Mabswid
.70885 .52764 m
.70899 .52924 L
s
.70899 .52924 m
.70901 .52941 L
s
.19467 .66913 m
.19505 .66837 L
s
.19505 .66837 m
.19531 .66787 L
s
.19531 .66787 m
.19533 .66782 L
s
.19533 .66782 m
.19627 .66596 L
s
0 g
.006 w
.19467 .66913 m
.19469 .69427 L
s
.42561 .25554 m
.4528 .25009 L
s
.55668 .26221 m
.58207 .27354 L
s
.4528 .25009 m
.47464 .24811 L
s
.47464 .24811 m
.47484 .24809 L
s
.5302 .25363 m
.55668 .26221 L
s
1 0 0 r
.003 w
.45968 .54035 m
.46371 .54079 L
s
.45757 .54012 m
.45968 .54035 L
s
0 g
.006 w
.50293 .24791 m
.5302 .25363 L
s
.47516 .2451 m
.50293 .24791 L
s
1 0 0 r
.003 w
.45794 .56535 m
.46405 .56451 L
s
.25 g
.5 Mabswid
.73304 .53382 m
.73315 .5321 L
s
.19469 .69427 m
.19513 .69272 L
s
.19513 .69272 m
.19594 .68985 L
s
0 g
.006 w
.19469 .69427 m
.19496 .71794 L
s
1 0 0 r
.003 w
.46371 .54079 m
.47195 .54058 L
s
.71457 .75289 m .77523 .54417 L .70931 .77557 L .605 .643 .862 r
F
.25 g
.5 Mabswid
.71457 .75289 m
.71458 .7528 L
s
.71458 .7528 m
.71485 .75137 L
s
.71485 .75137 m
.71498 .75071 L
s
.19496 .71794 m
.19518 .7162 L
s
.19518 .7162 m
.19563 .71269 L
s
0 g
.006 w
.19496 .71794 m
.19526 .73993 L
s
1 0 0 r
.003 w
.44982 .56465 m
.45794 .56535 L
s
.47195 .54058 m
.48264 .53947 L
s
.70931 .77557 m .79239 .55108 L .70437 .79652 L .62 .63 .839 r
F
.70931 .77557 m .77523 .54417 L .79239 .55108 L F
.25 g
.5 Mabswid
.75507 .5395 m
.7554 .53772 L
s
.73302 .53407 m
.73304 .53382 L
s
0 g
.006 w
.70931 .77557 m
.71457 .75289 L
s
.25 g
.5 Mabswid
.7098 .77387 m
.71 .77315 L
s
.70935 .77542 m
.7098 .77387 L
s
.70931 .77557 m
.70935 .77542 L
s
1 0 0 r
.003 w
.43936 .56236 m
.44982 .56465 L
s
.48264 .53947 m
.49601 .53751 L
s
.70437 .79652 m .80676 .55804 L .69999 .81559 L .634 .619 .817 r
F
.70437 .79652 m .79239 .55108 L .80676 .55804 L F
.25 g
.5 Mabswid
.755 .53986 m
.75507 .5395 L
s
.77471 .54599 m
.77523 .54417 L
s
0 g
.006 w
.70437 .79652 m
.70931 .77557 L
s
.25 g
.5 Mabswid
.70505 .79463 m
.70533 .79386 L
s
.70445 .79631 m
.70505 .79463 L
s
.70437 .79652 m
.70445 .79631 L
s
.1954 .76004 m .17682 .50577 L .19845 .50608 L .721 .705 .835 r
F
.19518 .77807 m .17682 .50577 L .1954 .76004 L .722 .685 .813 r
F
1 0 0 r
.003 w
.42636 .55851 m
.43936 .56236 L
s
.49601 .53751 m
.5122 .53487 L
s
.69636 .83262 m .82592 .5726 L .69371 .84747 L .658 .601 .779 r
F
.82592 .5726 m .82695 .57052 L .82573 .57307 L F
.82592 .5726 m .82573 .57307 L .69371 .84747 L F
.69371 .84747 m .83243 .57613 L .69218 .85998 L .669 .592 .761 r
F
.83243 .57613 m .83282 .57536 L .83231 .5764 L F
.83243 .57613 m .83231 .5764 L .69218 .85998 L F
.69371 .84747 m .82695 .57052 L .83282 .57536 L F
.69218 .85998 m .83595 .5789 L .69194 .87001 L .677 .583 .742 r
F
.69218 .85998 m .83282 .57536 L .83595 .5789 L F
.69194 .87001 m .83636 .581 L .69308 .87741 L .671 .557 .717 r
F
.69194 .87001 m .83595 .5789 L .83636 .581 L F
.69308 .87741 m .83609 .58156 L .83409 .58161 L .722 .599 .719 r
F
.83609 .58156 m .83636 .581 L .83409 .58161 L F
.82993 .58172 m .83409 .58161 L .83026 .58098 L .721 .58 .696 r
F
.76954 .71702 m .83321 .58347 L .70194 .86848 L .722 .599 .719 r
F
.83321 .58347 m .83312 .58369 L .70194 .86848 L F
.76954 .71702 m .70194 .86848 L .69569 .88203 L F
.69308 .87741 m .76954 .71702 L .69569 .88203 L F
.83321 .58347 m .83354 .58277 L .83312 .58369 L F
.83354 .58277 m .83386 .58211 L .8334 .58309 L F
.83354 .58277 m .8334 .58309 L .69569 .88203 L F
.83386 .58211 m .83409 .58161 L .83364 .58259 L F
.83386 .58211 m .83364 .58259 L .8333 .58333 L F
.8334 .58309 m .8333 .58333 L .69569 .88203 L F
.83386 .58211 m .8333 .58333 L .8334 .58309 L F
.82988 .58184 m .83409 .58161 L .82993 .58172 L .721 .58 .696 r
F
.70191 .86854 m .8333 .58333 L .82988 .58184 L F
.8333 .58333 m .83409 .58161 L .82988 .58184 L F
.69569 .88203 m .70191 .86854 L .82915 .58079 L F
.70191 .86854 m .83026 .58098 L .82915 .58079 L F
.69569 .88203 m .82828 .58275 L .69982 .88373 L F
.82828 .58275 m .82857 .58209 L .82821 .58295 L F
.82828 .58275 m .82821 .58295 L .69982 .88373 L F
.82857 .58209 m .82845 .58242 L .69982 .88373 L F
.82888 .58141 m .82863 .582 L .82833 .58271 L F
.82845 .58242 m .82833 .58271 L .69982 .88373 L F
.82888 .58141 m .82833 .58271 L .82845 .58242 L F
.82314 .57943 m .82915 .58079 L .82325 .57916 L .728 .57 .676 r
F
.70002 .88322 m .82863 .582 L .82314 .57943 L F
.82857 .58209 m .82888 .58141 L .82845 .58242 L .721 .58 .696 r
F
.82888 .58141 m .82915 .58079 L .82863 .582 L F
.82863 .582 m .82915 .58079 L .82314 .57943 L .728 .57 .676 r
F
.7003 .88259 m .82915 .58079 L .70002 .88322 L F
.69636 .83262 m .81827 .56465 L .82695 .57052 L .658 .601 .779 r
F
.70504 .87065 m .82325 .57916 L .82155 .57868 L .728 .57 .676 r
F
.69982 .88373 m .82325 .57916 L .70504 .87065 L F
.69982 .88373 m .7003 .88259 L .70002 .88322 L F
.69982 .88373 m .82075 .58068 L .70545 .88237 L F
.82075 .58068 m .82069 .58085 L .70545 .88237 L F
.82098 .5801 m .82076 .58074 L .70545 .88237 L F
.70573 .88154 m .81373 .57628 L .74748 .76053 L .736 .56 .654 r
F
.70562 .88188 m .70575 .88149 L .70573 .88154 L F
.70575 .88149 m .81373 .57628 L .70573 .88154 L F
.70545 .88237 m .70564 .88182 L .70562 .88188 L F
.70564 .88182 m .81373 .57628 L .70562 .88188 L F
.82075 .58068 m .82098 .5801 L .82069 .58085 L .728 .57 .676 r
F
.82098 .5801 m .82155 .57868 L .82076 .58074 L F
.70564 .88182 m .82155 .57868 L .81373 .57628 L .736 .56 .654 r
F
.70545 .88237 m .70579 .88148 L .70564 .88182 L F
.70579 .88148 m .82155 .57868 L .70564 .88182 L F
.69999 .81559 m .81676 .56785 L .69636 .83262 L .647 .609 .797 r
F
.81676 .56785 m .81657 .5684 L .69636 .83262 L F
.69999 .81559 m .80676 .55804 L .81827 .56465 L F
.74748 .76053 m .81373 .57628 L .81129 .57553 L .736 .56 .654 r
F
.70545 .88237 m .8106 .57752 L .71254 .87782 L F
.8106 .57752 m .81057 .57766 L .71254 .87782 L F
.81077 .57702 m .81069 .57733 L .71254 .87782 L F
.81102 .57632 m .81079 .57706 L .81059 .57769 L F
.81069 .57733 m .81059 .57769 L .71254 .87782 L F
.81102 .57632 m .81059 .57769 L .81069 .57733 L F
.71307 .87618 m .81129 .57553 L .71306 .87621 L .744 .549 .631 r
F
.8106 .57752 m .81077 .57702 L .81057 .57766 L .736 .56 .654 r
F
.71281 .87685 m .81079 .57706 L .79843 .57162 L .744 .549 .631 r
F
.81077 .57702 m .81102 .57632 L .81069 .57733 L .736 .56 .654 r
F
.81102 .57632 m .81129 .57553 L .81079 .57706 L F
.81079 .57706 m .81129 .57553 L .79843 .57162 L .744 .549 .631 r
F
.71306 .87621 m .81129 .57553 L .71281 .87685 L F
.71256 .87775 m .71307 .87618 L .71255 .87777 L F
.71307 .87618 m .71306 .87621 L .71255 .87777 L F
.71255 .87777 m .71306 .87621 L .71281 .87685 L F
.71254 .87782 m .71256 .87775 L .71255 .87777 L F
.71254 .87782 m .79788 .57358 L .72099 .86998 L F
.79788 .57358 m .79799 .57318 L .79786 .57368 L F
.79788 .57358 m .79786 .57368 L .72099 .86998 L F
.79799 .57318 m .79793 .57348 L .72099 .86998 L F
.79818 .57249 m .79799 .57329 L .79785 .57385 L F
.79793 .57348 m .79785 .57385 L .72099 .86998 L F
.79818 .57249 m .79785 .57385 L .79793 .57348 L F
.72124 .86874 m .79799 .57329 L .78304 .56732 L .75 .536 .605 r
F
.72122 .86883 m .72126 .86869 L .72124 .86874 L F
.72126 .86869 m .79843 .57162 L .72124 .86874 L F
.72108 .86954 m .72148 .868 L .72122 .86883 L F
.72148 .868 m .79843 .57162 L .72122 .86883 L F
.72099 .86998 m .72116 .86933 L .72108 .86954 L F
.72116 .86933 m .79843 .57162 L .72108 .86954 L F
.72099 .86998 m .78265 .5692 L .73064 .85878 L F
.78265 .5692 m .78265 .56927 L .73064 .85878 L F
.78271 .56892 m .78268 .5692 L .73064 .85878 L F
.78285 .56826 m .78272 .56909 L .78263 .56958 L F
.78268 .5692 m .78263 .56958 L .73064 .85878 L F
.78285 .56826 m .78263 .56958 L .78268 .5692 L F
.73093 .85694 m .78272 .56909 L .73093 .85694 L .756 .519 .574 r
F
.73105 .85654 m .73111 .85619 L .73093 .85694 L F
.73111 .85619 m .78304 .56732 L .73093 .85694 L F
.73082 .8578 m .73105 .85654 L .73072 .8581 L F
.73105 .85654 m .73093 .85694 L .73072 .8581 L F
.78265 .5692 m .78271 .56892 L .78265 .56927 L .75 .536 .605 r
F
.78271 .56892 m .78285 .56826 L .78268 .5692 L F
.78285 .56826 m .78304 .56732 L .78272 .56909 L F
.73081 .85737 m .78304 .56732 L .76527 .56298 L .756 .519 .574 r
F
.73072 .8581 m .73093 .85694 L .73081 .85737 L F
.73093 .85694 m .78304 .56732 L .73081 .85737 L F
.73064 .85878 m .73082 .8578 L .73072 .8581 L F
.73064 .85878 m .76506 .56476 L .7413 .84416 L F
.76506 .56476 m .76507 .56479 L .7413 .84416 L F
.76508 .5646 m .76508 .56485 L .7413 .84416 L F
.76516 .56397 m .76511 .56483 L .76508 .56524 L F
.76508 .56485 m .76508 .56524 L .7413 .84416 L F
.76516 .56397 m .76508 .56524 L .76508 .56485 L F
.75143 .72507 m .76527 .56298 L .75143 .72502 L .759 .498 .538 r
F
.75143 .72507 m .75143 .72502 L .75029 .73834 L F
.75029 .73846 m .75143 .72507 L .75029 .73834 L F
.75029 .73846 m .75029 .73834 L .7414 .84229 L F
.74144 .84212 m .75029 .73846 L .7414 .84229 L F
.7415 .84182 m .74153 .84155 L .74144 .84212 L F
.74153 .84155 m .76527 .56298 L .74144 .84212 L F
.7414 .843 m .7415 .84182 L .74131 .84333 L F
.7415 .84182 m .7414 .84229 L .74131 .84333 L F
.76506 .56476 m .76508 .5646 L .76507 .56479 L .756 .519 .574 r
F
.76508 .5646 m .76516 .56397 L .76508 .56485 L F
.76516 .56397 m .76527 .56298 L .76511 .56483 L F
.74132 .84267 m .76527 .56298 L .74533 .56057 L .759 .498 .538 r
F
.74533 .56057 m .76527 .56298 L .74535 .55897 L F
.74131 .84333 m .7414 .84229 L .74132 .84267 L F
.7414 .84229 m .76527 .56298 L .74132 .84267 L F
.7413 .84416 m .7414 .843 L .74131 .84333 L F
.7413 .84416 m .74533 .56061 L .7527 .82614 L F
.74533 .56061 m .74533 .56062 L .7527 .82614 L F
.74533 .56057 m .74541 .56117 L .7527 .82614 L F
.74533 .56061 m .74533 .56057 L .74533 .56062 L F
.74533 .56057 m .74535 .55897 L .74541 .56117 L F
.75254 .82462 m .74535 .55897 L .72359 .55559 L .759 .471 .495 r
F
.73421 .65434 m .72375 .55715 L .74517 .68712 L F
.72375 .55715 m .72382 .55733 L .74517 .68712 L F
.75258 .82428 m .74535 .55897 L .75256 .82447 L F
.75256 .82447 m .74535 .55897 L .75254 .82462 L F
.75267 .82488 m .74535 .55897 L .7526 .82523 L F
.73421 .65434 m .74517 .68712 L .76453 .80477 L F
.75259 .82453 m .75258 .82428 L .75257 .82489 L F
.75258 .82428 m .75256 .82447 L .75257 .82489 L F
.75257 .82489 m .75256 .82447 L .75254 .82462 L F
.7526 .82523 m .75259 .82453 L .75257 .82489 L F
.7527 .82614 m .75267 .82488 L .7526 .82523 L F
.7527 .82614 m .73421 .65434 L .76453 .80477 L F
.7237 .55662 m .72389 .55744 L .72393 .55769 L F
.72382 .55733 m .72393 .55769 L .76453 .80477 L F
.7237 .55662 m .72393 .55769 L .72382 .55733 L F
.76415 .80327 m .72389 .55744 L .70037 .55308 L .755 .435 .443 r
F
.72375 .55715 m .7237 .55662 L .72382 .55733 L .759 .471 .495 r
F
.7237 .55662 m .72359 .55559 L .72389 .55744 L F
.72389 .55744 m .72359 .55559 L .70037 .55308 L .755 .435 .443 r
F
.76432 .80347 m .76415 .80247 L .76429 .80383 L F
.76415 .80247 m .72359 .55559 L .76415 .80297 L F
.76415 .80247 m .76415 .80297 L .76429 .80383 L F
.76429 .80383 m .76415 .80297 L .76415 .80327 L F
.76415 .80297 m .72359 .55559 L .76415 .80327 L F
.76453 .80477 m .76432 .80347 L .76429 .80383 L F
.76453 .80477 m .70075 .55456 L .77642 .78018 L F
.70075 .55456 m .70084 .55471 L .77642 .78018 L F
.70075 .55447 m .70096 .55486 L .77642 .78018 L F
.70063 .55409 m .70084 .55458 L .70075 .55447 L F
.70084 .55458 m .70096 .55486 L .70075 .55447 L F
.77593 .77905 m .77578 .7786 L .7758 .77876 L .744 .388 .378 r
F
.70063 .55409 m .70037 .55308 L .70096 .55486 L .755 .435 .443 r
F
.77578 .7786 m .70037 .55308 L .7758 .77876 L .744 .388 .378 r
F
.77602 .77925 m .77588 .77884 L .77593 .77905 L F
.77588 .77884 m .70037 .55308 L .77593 .77905 L F
.77642 .78018 m .776 .77891 L .77602 .77925 L F
.776 .77891 m .70037 .55308 L .77602 .77925 L F
.77642 .78018 m .67677 .55297 L .78799 .75255 L F
.67677 .55297 m .67617 .55161 L .67715 .55336 L F
.67677 .55297 m .67715 .55336 L .78799 .75255 L F
.78692 .75066 m .67715 .55336 L .78704 .75102 L .722 .325 .296 r
F
.67715 .55336 m .67617 .55161 L .67714 .55336 L F
.67715 .55336 m .67714 .55336 L .78704 .75102 L F
.78684 .75048 m .67617 .55161 L .78692 .75066 L F
.70075 .55456 m .70063 .55409 L .70084 .55471 L .755 .435 .443 r
F
.73553 .65828 m .70037 .55308 L .67617 .55161 L .744 .388 .378 r
F
.78711 .75125 m .67617 .55161 L .65152 .55121 L .722 .325 .296 r
F
.78704 .75102 m .67617 .55161 L .78711 .75125 L F
.78689 .75057 m .78684 .75048 L .78692 .75066 L F
.78733 .75136 m .78689 .75057 L .7874 .75168 L F
.78689 .75057 m .78704 .75102 L .7874 .75168 L F
.7874 .75168 m .78704 .75102 L .78711 .75125 L F
.78799 .75255 m .78733 .75136 L .7874 .75168 L F
.78799 .75255 m .65234 .55242 L .79881 .72215 L F
.65234 .55242 m .65247 .5525 L .79881 .72215 L F
.65221 .5522 m .65276 .55265 L .79881 .72215 L F
.6521 .55207 m .65228 .55223 L .65221 .5522 L F
.65228 .55223 m .65276 .55265 L .65221 .5522 L F
.79766 .72102 m .65276 .55265 L .62698 .55182 L .683 .239 .191 r
F
.6521 .55207 m .65152 .55121 L .65276 .55265 L .722 .325 .296 r
F
.79732 .72042 m .65152 .55121 L .79766 .72102 L .683 .239 .191 r
F
.79881 .72215 m .79732 .72042 L .79766 .72102 L F
.79881 .72215 m .62802 .55285 L .80844 .68931 L F
.62802 .55285 m .62698 .55182 L .62859 .55305 L F
.62802 .55285 m .62859 .55305 L .80844 .68931 L F
.80652 .68785 m .62859 .55305 L .80729 .68853 L .619 .126 .058 r
F
.62859 .55305 m .62698 .55182 L .62859 .55305 L F
.62859 .55305 m .62859 .55305 L .80729 .68853 L F
.80704 .68838 m .62698 .55182 L .60313 .55329 L F
.8069 .68824 m .62698 .55182 L .80704 .68838 L F
.80728 .68843 m .80652 .68785 L .80746 .68866 L F
.80652 .68785 m .80729 .68853 L .80746 .68866 L F
.80746 .68866 m .8069 .68824 L .80704 .68838 L F
.80844 .68931 m .80728 .68843 L .80746 .68866 L F
.80844 .68931 m .60438 .55411 L .81647 .65442 L F
.60438 .55411 m .60455 .55413 L .81647 .65442 L F
.6041 .55392 m .60501 .55418 L .81647 .65442 L F
.60405 .5539 m .60412 .55392 L .6041 .55392 L F
.60412 .55392 m .60501 .55418 L .6041 .55392 L F
.81483 .65373 m .60501 .55418 L .58053 .55534 L .52 0 0 r
F
.60405 .5539 m .60313 .55329 L .60501 .55418 L .619 .126 .058 r
F
.81424 .65336 m .60313 .55329 L .81483 .65373 L .52 0 0 r
F
.81647 .65442 m .81424 .65336 L .81483 .65373 L F
.81647 .65442 m .58197 .55594 L .82249 .61794 L F
.58197 .55594 m .58053 .55534 L .58271 .5559 L F
.58197 .55594 m .58271 .5559 L .82249 .61794 L F
.81989 .61727 m .58271 .5559 L .82101 .6176 L .375 0 0 r
F
.58271 .5559 m .58053 .55534 L .58271 .5559 L F
.58271 .5559 m .58271 .5559 L .82101 .6176 L F
.82063 .61751 m .58053 .55534 L .55969 .55764 L F
.82043 .61745 m .58053 .55534 L .82063 .61751 L F
.82084 .61751 m .81989 .61727 L .82115 .61763 L F
.81989 .61727 m .82101 .6176 L .82115 .61763 L F
.82115 .61763 m .82043 .61745 L .82063 .61751 L F
.82249 .61794 m .82084 .61751 L .82115 .61763 L F
.82249 .61794 m .56089 .55792 L .82614 .58034 L F
.56089 .55792 m .55969 .55764 L .56208 .55785 L F
.56089 .55792 m .56208 .55785 L .82614 .58034 L F
.8241 .5802 m .56208 .55785 L .54104 .55984 L .19 0 0 r
F
.82614 .58034 m .82329 .5801 L .8241 .5802 L F
.82329 .5801 m .55969 .55764 L .8241 .5802 L F
.79799 .57318 m .79818 .57249 L .79793 .57348 L .744 .549 .631 r
F
.79818 .57249 m .79843 .57162 L .79799 .57329 L F
.79799 .57329 m .79843 .57162 L .78304 .56732 L .75 .536 .605 r
F
.81676 .56785 m .81827 .56465 L .81657 .5684 L .647 .609 .797 r
F
.82614 .58034 m .54104 .55984 L .82711 .54215 L .19 0 0 r
F
.82509 .54227 m .82402 .54234 L .8255 .54225 L 0 0 0 r
F
.82402 .54234 m .54104 .55984 L .82544 .54226 L F
.82402 .54234 m .82544 .54226 L .8255 .54225 L F
.56208 .55785 m .55969 .55764 L .54104 .55984 L .19 0 0 r
F
.82492 .54229 m .54104 .55984 L .52487 .56153 L 0 0 0 r
F
.8255 .54225 m .82469 .5423 L .82492 .54229 L F
.82469 .5423 m .54104 .55984 L .82492 .54229 L F
.82711 .54215 m .82509 .54227 L .8255 .54225 L F
.60438 .55411 m .60405 .5539 L .60455 .55413 L .619 .126 .058 r
F
.60501 .55418 m .60313 .55329 L .58053 .55534 L .52 0 0 r
F
.65234 .55242 m .6521 .55207 L .65247 .5525 L .722 .325 .296 r
F
.65276 .55265 m .65152 .55121 L .62698 .55182 L .683 .239 .191 r
F
.25 g
.5 Mabswid
.69999 .81559 m
.7001 .81531 L
s
.7001 .81531 m
.70086 .81349 L
s
.73916 .7211 m
.74094 .71681 L
s
.70956 .7925 m
.73916 .7211 L
s
.70119 .81267 m
.70956 .7925 L
s
.70086 .81349 m
.70119 .81267 L
s
0 g
.006 w
.69999 .81559 m
.70437 .79652 L
s
.25 g
.5 Mabswid
.72204 .74727 m
.73831 .7019 L
s
.70856 .78485 m
.72204 .74727 L
s
.70533 .79386 m
.70856 .78485 L
s
.73096 .69958 m
.73452 .68706 L
s
.71787 .74553 m
.73096 .69958 L
s
.71057 .77114 m
.71787 .74553 L
s
.71 .77315 m
.71057 .77114 L
s
.68342 .52599 m
.68456 .52969 L
s
.68456 .52969 m
.68562 .53316 L
s
.68562 .53316 m
.6894 .54541 L
s
.6894 .54541 m
.69098 .55057 L
s
.70901 .52941 m
.70959 .53574 L
s
.70959 .53574 m
.70966 .53647 L
s
.70966 .53647 m
.70995 .53957 L
s
.70995 .53957 m
.70995 .53957 L
s
.70995 .53957 m
.7102 .54231 L
s
.7102 .54231 m
.71036 .54411 L
s
.71036 .54411 m
.71085 .54934 L
s
.72038 .65281 m
.72067 .6559 L
s
.72067 .6559 m
.72299 .68111 L
s
.72299 .68111 m
.72305 .68176 L
s
.733 .53445 m
.73302 .53407 L
s
.73246 .54245 m
.733 .53445 L
s
.73244 .54268 m
.73246 .54245 L
s
.73237 .54373 m
.73244 .54268 L
s
.73223 .54575 m
.73237 .54373 L
s
.73223 .54575 m
.73223 .54575 L
s
.73214 .54712 m
.73223 .54575 L
s
.73212 .54743 m
.73214 .54712 L
s
.73212 .54743 m
.73212 .54743 L
s
.73208 .54802 m
.73212 .54743 L
s
.72216 .69501 m
.72441 .6616 L
s
.72055 .71879 m
.72216 .69501 L
s
.72028 .72276 m
.72055 .71879 L
s
.75489 .54041 m
.755 .53986 L
s
.75468 .54152 m
.75489 .54041 L
s
.7537 .54669 m
.75468 .54152 L
s
.72405 .70292 m
.72963 .6735 L
s
.71804 .73459 m
.72405 .70292 L
s
.71498 .75071 m
.71804 .73459 L
s
.65689 .52415 m
.65726 .52474 L
s
.65726 .52474 m
.67068 .54648 L
s
.67068 .54648 m
.67382 .55157 L
s
0 g
.006 w
.69878 .82126 m
.69999 .81559 L
s
.69636 .83262 m
.69878 .82126 L
s
.19518 .77807 m .15743 .50633 L .17682 .50577 L .722 .685 .813 r
F
.19445 .79384 m .15743 .50633 L .19518 .77807 L .722 .665 .793 r
F
.25 g
.5 Mabswid
.19525 .758 m
.1954 .76004 L
s
0 g
.006 w
.19518 .77807 m
.1954 .76004 L
s
1 0 0 r
.003 w
.41069 .5533 m
.42636 .55851 L
s
.5122 .53487 m
.53118 .53183 L
s
.25 g
.5 Mabswid
.69654 .83224 m
.69743 .83028 L
s
.69743 .83028 m
.69782 .82942 L
s
.71981 .78107 m
.74249 .73123 L
s
.69821 .82856 m
.71981 .78107 L
s
.69782 .82942 m
.69821 .82856 L
s
.69636 .83262 m
.69654 .83224 L
s
0 g
.006 w
.69371 .84747 m
.69636 .83262 L
s
.19445 .79384 m .14054 .50744 L .15743 .50633 L .722 .665 .793 r
F
.25 g
.5 Mabswid
.17682 .50577 m
.17693 .50732 L
s
.19306 .80716 m .14054 .50744 L .19445 .79384 L .72 .645 .773 r
F
.25 g
.19488 .77594 m
.19518 .77807 L
s
0 g
.006 w
.19445 .79384 m
.19518 .77807 L
s
1 0 0 r
.003 w
.39238 .54702 m
.41069 .5533 L
s
.53118 .53183 m
.55278 .52871 L
s
.25 g
.5 Mabswid
.69371 .84747 m
.69396 .84695 L
s
.69396 .84695 m
.69498 .84483 L
s
.69498 .84483 m
.69542 .84391 L
s
.82636 .57176 m
.82695 .57052 L
s
.70097 .83236 m
.7427 .74563 L
s
.69542 .84391 m
.70097 .83236 L
s
0 g
.006 w
.69218 .85998 m
.69371 .84747 L
s
1 0 0 r
.003 w
.37161 .54007 m
.39238 .54702 L
s
.19306 .80716 m .12635 .50876 L .14054 .50744 L .72 .645 .773 r
F
.25 g
.5 Mabswid
.15743 .50633 m
.1577 .50831 L
s
.17693 .50732 m
.17699 .50805 L
s
.17699 .50805 m
.17699 .50815 L
s
.19089 .81785 m .12635 .50876 L .19306 .80716 L .716 .625 .754 r
F
.25 g
.19404 .79167 m
.19445 .79384 L
s
0 g
.006 w
.19306 .80716 m
.19445 .79384 L
s
1 0 0 r
.003 w
.55278 .52871 m
.57664 .5259 L
s
.34873 .53289 m
.37161 .54007 L
s
.25 g
.5 Mabswid
.69218 .85998 m
.69254 .85926 L
s
.69254 .85926 m
.69369 .85693 L
s
.69369 .85693 m
.69419 .85591 L
s
.83231 .5764 m
.83282 .57536 L
s
.69419 .85591 m
.7424 .75835 L
s
.83041 .58025 m
.83231 .5764 L
s
.83006 .58094 m
.83041 .58025 L
s
0 g
.006 w
.69194 .87001 m
.69218 .85998 L
s
1 0 0 r
.003 w
.57664 .5259 m
.60224 .52378 L
s
.19089 .81785 m .11496 .50993 L .11975 .50943 L .716 .625 .754 r
F
.18786 .82576 m .11496 .50993 L .19089 .81785 L .712 .605 .735 r
F
.18786 .82576 m .10645 .51063 L .11009 .51033 L F
.1871 .82248 m .11009 .51033 L .11496 .50993 L F
.18786 .82576 m .11009 .51033 L .1871 .82248 L F
.18391 .83072 m .10645 .51063 L .18786 .82576 L .709 .586 .716 r
F
.18391 .83072 m .1782 .80872 L .10645 .51063 L F
.1782 .80872 m .10085 .51062 L .10318 .51062 L F
.1782 .80872 m .10318 .51062 L .10645 .51063 L F
.17904 .83258 m .1745 .81389 L .18391 .83072 L .71 .569 .694 r
F
.1745 .81389 m .10085 .51062 L .1782 .80872 L F
.1745 .81389 m .1782 .80872 L .18391 .83072 L F
.17904 .83258 m .09821 .50973 L .10085 .51062 L F
.17325 .83119 m .09821 .50973 L .17904 .83258 L .641 .508 .685 r
F
.17195 .82564 m .09855 .50789 L .09821 .50973 L F
.17212 .82635 m .17194 .82559 L .17195 .82564 L F
.17194 .82559 m .09855 .50789 L .17195 .82564 L F
.17196 .82564 m .17189 .82533 L .17212 .82635 L F
.17189 .82533 m .09855 .50789 L .17194 .82559 L F
.17189 .82533 m .17194 .82559 L .17212 .82635 L F
.17295 .82988 m .17191 .82539 L .17295 .82991 L F
.17191 .82539 m .09855 .50789 L .17196 .82564 L F
.17191 .82539 m .17196 .82564 L .17295 .82991 L F
.17295 .82991 m .17196 .82564 L .17212 .82635 L F
.17325 .83119 m .17295 .82988 L .17295 .82991 L F
.16662 .82645 m .09855 .50789 L .17325 .83119 L .672 .509 .656 r
F
.16591 .82315 m .10187 .50514 L .09855 .50789 L F
.10204 .50611 m .10213 .50646 L .10334 .51245 L .667 .486 .631 r
F
.16587 .82271 m .10187 .50514 L .16591 .82315 L .672 .509 .656 r
F
.10213 .50646 m .10213 .50647 L .10334 .51245 L .667 .486 .631 r
F
.10334 .51245 m .10213 .50647 L .10341 .5128 L F
.10319 .51182 m .10341 .5128 L .16662 .82645 L F
.10204 .50611 m .10341 .5128 L .10319 .51182 L F
.16662 .82645 m .16587 .82271 L .16591 .82315 L .672 .509 .656 r
F
.15926 .81825 m .13648 .67704 L .16637 .82523 L .667 .486 .631 r
F
.10256 .50891 m .10204 .50611 L .10319 .51182 L F
.10256 .50891 m .10319 .51182 L .16637 .82523 L F
.10204 .50611 m .10187 .50514 L .10213 .50647 L F
.15874 .81545 m .10818 .50163 L .10187 .50514 L F
.15872 .81493 m .10818 .50163 L .15874 .81545 L F
.15926 .81825 m .15872 .81493 L .15874 .81545 L F
.10973 .5115 m .10997 .51271 L .15926 .81825 L .659 .459 .603 r
F
.15132 .80654 m .1092 .50882 L .15926 .81825 L F
.1092 .50882 m .10973 .5115 L .15926 .81825 L F
.10851 .50393 m .10864 .50446 L .10997 .51271 L F
.10851 .50393 m .10997 .51271 L .10973 .5115 L F
.1092 .50882 m .10851 .50393 L .10973 .5115 L F
.10851 .50393 m .10818 .50163 L .10864 .50446 L F
.15096 .80406 m .11747 .49757 L .10818 .50163 L F
.15132 .80654 m .15098 .80352 L .15096 .80406 L F
.15098 .80352 m .11747 .49757 L .15096 .80406 L F
.143 .79131 m .14276 .78854 L .15132 .80654 L .649 .43 .572 r
F
.14276 .78854 m .11777 .50103 L .15098 .80351 L F
.14276 .78854 m .15098 .80351 L .15132 .80654 L F
.13457 .77259 m .13454 .77075 L .143 .79131 L .639 .396 .535 r
F
.11777 .50103 m .11792 .50165 L .15132 .80654 L .649 .43 .572 r
F
.17914 .76157 m .11975 .50943 L .12635 .50876 L .716 .625 .754 r
F
.19089 .81785 m .11975 .50943 L .17914 .76157 L F
.11777 .50103 m .11747 .49757 L .11792 .50165 L .649 .43 .572 r
F
.14281 .78908 m .12967 .49327 L .11747 .49757 L F
.143 .79131 m .14288 .78853 L .14281 .78908 L F
.14288 .78853 m .12967 .49327 L .14281 .78908 L F
.13454 .77075 m .12989 .50581 L .14283 .78746 L .639 .396 .535 r
F
.13454 .77075 m .14283 .78746 L .143 .79131 L F
.12989 .50581 m .13027 .50869 L .143 .79131 L F
.12973 .4966 m .12988 .49798 L .143 .79131 L F
.12989 .50581 m .12973 .4966 L .13027 .50869 L F
.12973 .4966 m .12967 .49327 L .12988 .49798 L F
.13453 .77057 m .14467 .48907 L .12967 .49327 L F
.13457 .77259 m .13466 .77005 L .13453 .77057 L F
.13466 .77005 m .14467 .48907 L .13453 .77057 L F
.12631 .75048 m .12647 .74819 L .13457 .77259 L .626 .358 .492 r
F
.12647 .74819 m .14451 .49144 L .13466 .77004 L F
.12647 .74819 m .13466 .77004 L .13457 .77259 L F
.11854 .72515 m .11881 .72364 L .12631 .75048 L .612 .314 .44 r
F
.14451 .49144 m .14455 .49247 L .13457 .77259 L .626 .358 .492 r
F
.14451 .49144 m .14467 .48907 L .14455 .49247 L F
.12643 .74867 m .1623 .48533 L .14467 .48907 L F
.12631 .75048 m .12662 .74817 L .12643 .74867 L F
.12662 .74817 m .1623 .48533 L .12643 .74867 L F
.11881 .72364 m .16196 .4872 L .12675 .74721 L .612 .314 .44 r
F
.11881 .72364 m .12675 .74721 L .12631 .75048 L F
.16196 .4872 m .16193 .48806 L .12631 .75048 L F
.16196 .4872 m .1623 .48533 L .16193 .48806 L F
.11891 .72309 m .18229 .48241 L .1623 .48533 L F
.11854 .72515 m .11931 .7222 L .11891 .72309 L F
.11931 .7222 m .18229 .48241 L .11891 .72309 L F
.11161 .69683 m .11205 .69551 L .11854 .72515 L .596 .263 .377 r
F
.11205 .69551 m .1818 .48389 L .11931 .7222 L F
.11205 .69551 m .11931 .7222 L .11854 .72515 L F
.1818 .48389 m .18171 .48463 L .11854 .72515 L F
.1818 .48389 m .18229 .48241 L .18171 .48463 L F
.1122 .69503 m .20431 .48058 L .18229 .48241 L F
.11161 .69683 m .11272 .69424 L .1122 .69503 L F
.11272 .69424 m .20431 .48058 L .1122 .69503 L F
.1059 .66584 m .2037 .48175 L .11269 .6943 L .575 .202 .297 r
F
.2037 .48175 m .20354 .48238 L .11161 .69683 L F
.2037 .48175 m .20431 .48058 L .20354 .48238 L F
.10671 .66432 m .22795 .48009 L .20431 .48058 L F
.1059 .66584 m .10734 .66365 L .10671 .66432 L F
.10734 .66365 m .22795 .48009 L .10671 .66432 L F
.22722 .48097 m .22715 .48116 L .10734 .66365 L .549 .129 .197 r
F
.10734 .66365 m .10734 .66365 L .1059 .66584 L F
.22722 .48097 m .10734 .66365 L .10734 .66365 L F
.22715 .48116 m .22694 .48162 L .1059 .66584 L F
.10176 .63257 m .22722 .48097 L .1059 .66584 L F
.22715 .48116 m .22702 .48151 L .22694 .48162 L F
.22722 .48097 m .22795 .48009 L .22702 .48151 L F
.10278 .63134 m .25272 .48103 L .22795 .48009 L F
.10176 .63257 m .10352 .6308 L .10278 .63134 L F
.10352 .6308 m .25272 .48103 L .10278 .63134 L F
.09954 .59745 m .10045 .59677 L .10176 .63257 L .513 .041 .072 r
F
.10045 .59677 m .25186 .48168 L .10352 .6308 L F
.10045 .59677 m .10352 .6308 L .10176 .63257 L F
.25186 .48168 m .25146 .48229 L .10176 .63257 L F
.25186 .48168 m .25272 .48103 L .25146 .48229 L F
.10076 .59653 m .2781 .48342 L .25272 .48103 L F
.09954 .59745 m .10159 .59614 L .10076 .59653 L F
.10159 .59614 m .2781 .48342 L .10076 .59653 L F
.09957 .56099 m .10061 .56054 L .09954 .59745 L .465 0 0 r
F
.10061 .56054 m .27708 .48386 L .10159 .59614 L F
.10061 .56054 m .10159 .59614 L .09954 .59745 L F
.27708 .48386 m .27659 .48438 L .09954 .59745 L F
.27708 .48386 m .2781 .48342 L .27659 .48438 L F
.10096 .56039 m .30352 .48715 L .2781 .48342 L F
.09957 .56099 m .10188 .56016 L .10096 .56039 L F
.10188 .56016 m .30352 .48715 L .10096 .56039 L F
.10212 .52372 m .10327 .52351 L .09957 .56099 L .401 0 0 r
F
.10327 .52351 m .30235 .48736 L .10188 .56015 L F
.10327 .52351 m .10188 .56015 L .09957 .56099 L F
.30235 .48736 m .30176 .48778 L .09957 .56099 L F
.30235 .48736 m .30352 .48715 L .30176 .48778 L F
.10365 .52344 m .32842 .49199 L .30352 .48715 L F
.10212 .52372 m .10463 .52337 L .10365 .52344 L F
.10463 .52337 m .32842 .49199 L .10365 .52344 L F
.1074 .48619 m .10864 .48622 L .10212 .52372 L .32 0 0 r
F
.10864 .48622 m .32712 .49196 L .10463 .52336 L F
.10864 .48622 m .10463 .52336 L .10212 .52372 L F
.32712 .49196 m .32645 .49227 L .10212 .52372 L F
.32712 .49196 m .32842 .49199 L .32645 .49227 L F
.1074 .48619 m .35229 .49763 L .32842 .49199 L F
.11557 .44894 m .35087 .49734 L .1074 .48619 L .233 0 0 r
F
.35087 .49734 m .35229 .49763 L .35011 .49753 L F
.35087 .49734 m .35011 .49753 L .1074 .48619 L F
.11557 .44894 m .37463 .50369 L .35229 .49763 L F
.1267 .41252 m .37312 .50313 L .11557 .44894 L 0 .42 .738 r
F
.37312 .50313 m .37463 .50369 L .37229 .50319 L F
.37312 .50313 m .37229 .50319 L .11557 .44894 L F
.1059 .66584 m .11269 .6943 L .11161 .69683 L .575 .202 .297 r
F
.166 .82575 m .16637 .82523 L .16662 .82645 L .667 .486 .631 r
F
.15926 .81825 m .16637 .82523 L .166 .82575 L F
.25 g
.5 Mabswid
.14406 .62796 m
.18605 .79823 L
s
.18605 .79823 m
.19042 .81595 L
s
.19042 .81595 m
.19089 .81785 L
s
0 g
.006 w
.19089 .81785 m
.19306 .80716 L
s
.25 g
.5 Mabswid
.14893 .60978 m
.17592 .7305 L
s
.17592 .7305 m
.19258 .80505 L
s
.19258 .80505 m
.19306 .80716 L
s
.15649 .59215 m
.17017 .66485 L
s
.17017 .66485 m
.18743 .75655 L
s
.18743 .75655 m
.19404 .79167 L
s
.16673 .57326 m
.19442 .77257 L
s
.19442 .77257 m
.19488 .77594 L
s
.18032 .5537 m
.19525 .758 L
s
0 g
.006 w
.18786 .82576 m
.19089 .81785 L
s
1 0 0 r
.003 w
.32421 .52594 m
.34873 .53289 L
s
.60224 .52378 m
.62897 .52269 L
s
.25 g
.5 Mabswid
.69194 .87001 m
.69246 .86895 L
s
.69246 .86895 m
.69379 .86627 L
s
.69379 .86627 m
.69439 .86504 L
s
.83554 .57972 m
.83595 .5789 L
s
.69439 .86504 m
.74092 .77099 L
s
.83468 .58145 m
.83554 .57972 L
s
0 g
.006 w
.69194 .87001 m
.69308 .87741 L
s
1 0 0 r
.003 w
.29863 .51965 m
.32421 .52594 L
s
.62897 .52269 m
.65612 .52289 L
s
.25 g
.5 Mabswid
.14081 .64364 m
.18752 .82443 L
s
.18752 .82443 m
.18786 .82576 L
s
0 g
.006 w
.18391 .83072 m
.18786 .82576 L
s
1 0 0 r
.003 w
.65612 .52289 m
.68297 .52453 L
s
.27263 .51435 m
.29863 .51965 L
s
.68297 .52453 m
.70885 .52764 L
s
.26968 .51388 m
.27263 .51435 L
s
.24686 .51028 m
.26968 .51388 L
s
.70885 .52764 m
.73315 .5321 L
s
.25 g
.5 Mabswid
.83609 .58156 m
.83636 .581 L
s
.83568 .58242 m
.83609 .58156 L
s
.83528 .58323 m
.83568 .58242 L
s
.83491 .58401 m
.83528 .58323 L
s
.83457 .5847 m
.83491 .58401 L
s
.82349 .60763 m
.83457 .5847 L
s
0 g
.006 w
.69308 .87741 m
.69569 .88203 L
s
1 0 0 r
.003 w
.73315 .5321 m
.7554 .53772 L
s
.7554 .53772 m
.76409 .54055 L
s
.76409 .54055 m
.77523 .54417 L
s
.24132 .50967 m
.24686 .51028 L
s
.83409 .58161 m
.83475 .58144 L
s
.83475 .58144 m
.83636 .581 L
s
.83595 .5789 m
.83636 .581 L
s
.83282 .57536 m
.83595 .5789 L
s
.25 g
.5 Mabswid
.83364 .58259 m
.83409 .58161 L
s
.8333 .58333 m
.83364 .58259 L
s
.83297 .58405 m
.8333 .58333 L
s
.83267 .5847 m
.83297 .58405 L
s
.83245 .58518 m
.83267 .5847 L
s
.83234 .58542 m
.83245 .58518 L
s
.82386 .60382 m
.83234 .58542 L
s
1 0 0 r
.003 w
.82915 .58079 m
.83409 .58161 L
s
.82695 .57052 m
.83282 .57536 L
s
.25 g
.5 Mabswid
.82833 .58271 m
.82915 .58079 L
s
.82806 .58334 m
.82833 .58271 L
s
.82786 .58382 m
.82806 .58334 L
s
.82776 .58405 m
.82786 .58382 L
s
.8252 .59006 m
.82776 .58405 L
s
1 0 0 r
.003 w
.82615 .57996 m
.82915 .58079 L
s
.8264 .57015 m
.82695 .57052 L
s
.77523 .54417 m
.77779 .5452 L
s
.25 g
.5 Mabswid
.18261 .82571 m
.18391 .83072 L
s
.1782 .80872 m
.18261 .82571 L
s
.13894 .6574 m
.1782 .80872 L
s
0 g
.006 w
.17904 .83258 m
.18391 .83072 L
s
.25 g
.5 Mabswid
.15089 .80262 m
.15132 .80654 L
s
.15086 .80241 m
.15089 .80262 L
s
.13842 .68881 m
.15086 .80241 L
s
.15858 .81403 m
.15926 .81825 L
s
.15853 .81378 m
.15858 .81403 L
s
.13851 .68964 m
.15853 .81378 L
s
1 0 0 r
.003 w
.10187 .50514 m
.10498 .50341 L
s
.25 g
.5 Mabswid
.14284 .78764 m
.143 .79131 L
s
.14283 .78747 m
.14284 .78764 L
s
.13794 .67808 m
.14283 .78747 L
s
.16568 .82177 m
.16637 .82523 L
s
.16562 .82148 m
.16568 .82177 L
s
.13829 .68586 m
.16562 .82148 L
s
.16637 .82523 m
.16662 .82645 L
s
1 0 0 r
.003 w
.09855 .50789 m
.10187 .50514 L
s
.25 g
.5 Mabswid
.17191 .82539 m
.17325 .83119 L
s
.17188 .82524 m
.17191 .82539 L
s
.13795 .67844 m
.17188 .82524 L
s
1 0 0 r
.003 w
.09821 .50973 m
.09855 .50789 L
s
.25 g
.5 Mabswid
.17514 .81703 m
.17904 .83258 L
s
.13824 .66962 m
.17514 .81703 L
s
.13457 .77259 m
.13469 .76916 L
s
.13469 .76916 m
.1347 .76903 L
s
.1347 .76903 m
.13858 .66006 L
s
.12631 .75048 m
.12673 .74732 L
s
.12673 .74732 m
.12675 .74721 L
s
.12675 .74721 m
.14174 .63682 L
s
.11854 .72515 m
.11929 .72228 L
s
.11929 .72228 m
.11931 .7222 L
s
.11931 .7222 m
.14869 .61033 L
s
0 g
.006 w
.69569 .88203 m
.69982 .88373 L
s
.25 g
.5 Mabswid
.11161 .69683 m
.1127 .6943 L
s
.1127 .6943 m
.11272 .69424 L
s
.11272 .69424 m
.16056 .58265 L
s
.1059 .66584 m
.10731 .66369 L
s
.10731 .66369 m
.10734 .66365 L
s
.10734 .66365 m
.17814 .5559 L
s
1 0 0 r
.003 w
.65152 .55121 m
.67455 .55158 L
s
0 g
.006 w
.17325 .83119 m
.17904 .83258 L
s
.25 g
.5 Mabswid
.10176 .63257 m
.10349 .63083 L
s
.10349 .63083 m
.10352 .6308 L
s
.10352 .6308 m
.2018 .53215 L
s
.65152 .55121 m
.65276 .55265 L
s
.65276 .55265 m
.65282 .55272 L
s
.65282 .55272 m
.65299 .55291 L
s
1 0 0 r
.003 w
.62698 .55182 m
.62782 .5518 L
s
.62782 .5518 m
.65152 .55121 L
s
.25 g
.5 Mabswid
.09954 .59745 m
.10158 .59616 L
s
.10158 .59616 m
.10159 .59614 L
s
0 g
.006 w
.69982 .88373 m
.70545 .88237 L
s
.25 g
.5 Mabswid
.09957 .56099 m
.10187 .56016 L
s
.62698 .55182 m
.62704 .55187 L
s
.62704 .55187 m
.62855 .55301 L
s
.62855 .55301 m
.62859 .55305 L
s
.62859 .55305 m
.62859 .55305 L
s
.62859 .55305 m
.63027 .55432 L
s
1 0 0 r
.003 w
.60313 .55329 m
.62698 .55182 L
s
0 g
.006 w
.16662 .82645 m
.17325 .83119 L
s
.25 g
.5 Mabswid
.10212 .52372 m
.10463 .52337 L
s
.60313 .55329 m
.60443 .5539 L
s
.60443 .5539 m
.60501 .55418 L
s
.60501 .55418 m
.60504 .55419 L
s
.60504 .55419 m
.60819 .55568 L
s
1 0 0 r
.003 w
.58053 .55534 m
.60313 .55329 L
s
0 g
.006 w
.70545 .88237 m
.71254 .87782 L
s
.25 g
.5 Mabswid
.1074 .48619 m
.11008 .48631 L
s
0 g
.006 w
.15926 .81825 m
.16662 .82645 L
s
.25 g
.5 Mabswid
.58053 .55534 m
.58269 .5559 L
s
.58269 .5559 m
.58271 .5559 L
s
.58271 .5559 m
.58695 .557 L
s
1 0 0 r
.003 w
.55969 .55764 m
.58053 .55534 L
s
.1267 .41252 m .39505 .50972 L .37463 .50369 L 0 .42 .738 r
F
.25 g
.5 Mabswid
.37457 .50367 m
.37463 .50369 L
s
.37305 .50335 m
.37457 .50367 L
s
.37229 .50319 m
.37305 .50335 L
s
0 g
.006 w
.71254 .87782 m
.72099 .86998 L
s
.25 g
.5 Mabswid
.55969 .55764 m
.56208 .55785 L
s
.56208 .55785 m
.56676 .55825 L
s
.55969 .55764 m
.55969 .55764 L
s
1 0 0 r
.003 w
.54104 .55984 m
.55969 .55764 L
s
0 g
.006 w
.15132 .80654 m
.15926 .81825 L
s
.14082 .37741 m .39505 .50972 L .1267 .41252 L 0 .435 .808 r
F
.25 g
.5 Mabswid
.11557 .44894 m
.11835 .44953 L
s
.14082 .37741 m .41326 .51529 L .39505 .50972 L 0 .435 .808 r
F
1 0 0 r
.003 w
.37463 .50369 m
.39505 .50972 L
s
.25 g
.5 Mabswid
.3926 .50883 m
.3934 .50912 L
s
.3934 .50912 m
.39503 .50971 L
s
.39503 .50971 m
.39505 .50972 L
s
0 g
.006 w
.72099 .86998 m
.73064 .85878 L
s
.143 .79131 m
.15132 .80654 L
s
.15786 .34406 m .41326 .51529 L .14082 .37741 L 0 .422 .838 r
F
.25 g
.5 Mabswid
.1267 .41252 m
.12953 .41354 L
s
.15786 .34406 m .42908 .52002 L .41326 .51529 L 0 .422 .838 r
F
1 0 0 r
.003 w
.39505 .50972 m
.41326 .51529 L
s
.25 g
.5 Mabswid
.41075 .51402 m
.41154 .51442 L
s
.41154 .51442 m
.41321 .51527 L
s
.41321 .51527 m
.41326 .51529 L
s
.82517 .50387 m .52487 .56153 L .51139 .56237 L .211 .736 .79 r
F
.25 g
.54104 .55984 m
.54359 .55968 L
s
.82711 .54215 m .52487 .56153 L .82517 .50387 L 0 0 0 r
F
0 g
.006 w
.73064 .85878 m
.7413 .84416 L
s
.13457 .77259 m
.143 .79131 L
s
.17771 .31285 m .42908 .52002 L .15786 .34406 L 0 .389 .838 r
F
.25 g
.5 Mabswid
.14082 .37741 m
.14363 .37883 L
s
.17771 .31285 m .44244 .52357 L .42908 .52002 L 0 .389 .838 r
F
1 0 0 r
.003 w
.41326 .51529 m
.42908 .52002 L
s
.25 g
.5 Mabswid
.42655 .51838 m
.4273 .51887 L
s
.4273 .51887 m
.42893 .51993 L
s
.42893 .51993 m
.42908 .52002 L
s
.82014 .46602 m .51139 .56237 L .50063 .56208 L .376 .842 .862 r
F
.25 g
.52487 .56153 m
.52752 .56102 L
s
.82517 .50387 m .51139 .56237 L .82014 .46602 L .211 .736 .79 r
F
1 0 0 r
.003 w
.51139 .56237 m
.52487 .56153 L
s
.25 g
.5 Mabswid
.82302 .50429 m
.82517 .50387 L
s
.82192 .5045 m
.82302 .50429 L
s
0 g
.006 w
.7413 .84416 m
.7527 .82614 L
s
.12631 .75048 m
.13457 .77259 L
s
.20019 .28411 m .44244 .52357 L .17771 .31285 L 0 .342 .819 r
F
.25 g
.5 Mabswid
.15786 .34406 m
.16059 .34583 L
s
.20019 .28411 m .4534 .52573 L .44244 .52357 L 0 .342 .819 r
F
1 0 0 r
.003 w
.42908 .52002 m
.44244 .52357 L
s
.25 g
.5 Mabswid
.44062 .52213 m
.44214 .52333 L
s
.43997 .52161 m
.44062 .52213 L
s
.44214 .52333 m
.44244 .52357 L
s
0 g
.006 w
.7527 .82614 m
.76453 .80477 L
s
.81195 .42907 m .50063 .56208 L .49251 .56045 L .507 .91 .894 r
F
.25 g
.5 Mabswid
.51139 .56237 m
.51407 .56154 L
s
.52752 .56102 m
.52757 .56101 L
s
.82014 .46602 m .50063 .56208 L .81195 .42907 L .376 .842 .862 r
F
1 0 0 r
.003 w
.50063 .56208 m
.51139 .56237 L
s
.25 g
.5 Mabswid
.81791 .46672 m
.82014 .46602 L
s
.8168 .46707 m
.81791 .46672 L
s
0 g
.006 w
.11854 .72515 m
.12631 .75048 L
s
.2251 .2581 m .4534 .52573 L .20019 .28411 L 0 .285 .785 r
F
.25 g
.5 Mabswid
.17771 .31285 m
.18031 .31492 L
s
.2251 .2581 m .46212 .52639 L .4534 .52573 L 0 .285 .785 r
F
1 0 0 r
.003 w
.44244 .52357 m
.4534 .52573 L
s
.25 g
.5 Mabswid
.45291 .52526 m
.4534 .52573 L
s
.45158 .52399 m
.45291 .52526 L
s
.45104 .52348 m
.45158 .52399 L
s
0 g
.006 w
.76453 .80477 m
.77642 .78018 L
s
.11161 .69683 m
.11854 .72515 L
s
.80058 .39346 m .49251 .56045 L .48681 .55742 L .609 .953 .898 r
F
.25 g
.5 Mabswid
.50063 .56208 m
.50327 .56095 L
s
.51407 .56154 m
.51415 .56151 L
s
.81195 .42907 m .49251 .56045 L .80058 .39346 L .507 .91 .894 r
F
1 0 0 r
.003 w
.49251 .56045 m
.50063 .56208 L
s
.25 g
.5 Mabswid
.80967 .43005 m
.81195 .42907 L
s
.80857 .43052 m
.80967 .43005 L
s
.25218 .23501 m .46212 .52639 L .2251 .2581 L 0 .218 .741 r
F
.25 g
.20019 .28411 m
.20261 .28642 L
s
.10159 .59614 m
.23134 .51328 L
s
.25218 .23501 m .46886 .52562 L .46212 .52639 L 0 .218 .741 r
F
1 0 0 r
.003 w
.4534 .52573 m
.46212 .52639 L
s
.25 g
.5 Mabswid
.46143 .52561 m
.46212 .52639 L
s
.46033 .52437 m
.46143 .52561 L
s
.45994 .52392 m
.46033 .52437 L
s
0 g
.006 w
.77642 .78018 m
.78799 .75255 L
s
.1059 .66584 m
.11161 .69683 L
s
.47898 .1627 m .48412 .50749 L .44463 .16328 L 0 0 .111 r
F
.47898 .1627 m .4846 .50608 L .48412 .50749 L F
.5132 .16534 m .4846 .50608 L .47898 .1627 L 0 0 .003 r
F
.5132 .16534 m .48477 .50607 L .4846 .50608 L F
.54702 .17118 m .48477 .50607 L .5132 .16534 L 0 0 .21 r
F
0 g
.47898 .1627 m
.5132 .16534 L
s
.44463 .16328 m .48329 .51004 L .41045 .1671 L 0 0 .231 r
F
.44463 .16328 m .48412 .50749 L .48329 .51004 L F
0 g
.44463 .16328 m
.47898 .1627 L
s
.25 g
.5 Mabswid
.44463 .16328 m
.44484 .16505 L
s
.54702 .17118 m .48464 .5076 L .48477 .50607 L 0 0 .21 r
F
.58013 .1802 m .48464 .5076 L .54702 .17118 L .893 .853 .401 r
F
0 g
.006 w
.5132 .16534 m
.54702 .17118 L
s
.78608 .35958 m .48681 .55742 L .4832 .55304 L .687 .979 .884 r
F
.25 g
.5 Mabswid
.50327 .56095 m
.50342 .56089 L
s
.49251 .56045 m
.49504 .55908 L
s
.80058 .39346 m .48681 .55742 L .78608 .35958 L .609 .953 .898 r
F
1 0 0 r
.003 w
.48681 .55742 m
.49251 .56045 L
s
.25 g
.5 Mabswid
.80054 .39348 m
.80058 .39346 L
s
.79829 .3947 m
.80054 .39348 L
s
.79722 .39528 m
.79829 .3947 L
s
.41045 .1671 m .48204 .51336 L .37672 .17419 L 0 0 .346 r
F
.41045 .1671 m .48329 .51004 L .48204 .51336 L F
0 g
.006 w
.41045 .1671 m
.44463 .16328 L
s
.25 g
.5 Mabswid
.41045 .1671 m
.41093 .16936 L
s
.58013 .1802 m .48421 .51067 L .48464 .5076 L .893 .853 .401 r
F
.25 g
.48681 .55742 m
.49208 .55393 L
s
.61227 .19235 m .48421 .51067 L .58013 .1802 L .883 .895 .474 r
F
0 g
.006 w
.54702 .17118 m
.58013 .1802 L
s
.25 g
.5 Mabswid
.51179 .18227 m
.5132 .16534 L
s
.54575 .17803 m
.54702 .17118 L
s
.37672 .17419 m .48021 .51703 L .34374 .18454 L 0 0 .45 r
F
.37672 .17419 m .48204 .51336 L .48021 .51703 L F
0 g
.006 w
.37672 .17419 m
.41045 .1671 L
s
.25 g
.5 Mabswid
.37672 .17419 m
.37733 .17615 L
s
.37733 .17615 m
.3775 .17669 L
s
.61227 .19235 m .48351 .51517 L .48421 .51067 L .883 .895 .474 r
F
.64314 .20761 m .48351 .51517 L .61227 .19235 L .884 .936 .563 r
F
.25 g
.57876 .18494 m
.58013 .1802 L
s
0 g
.006 w
.58013 .1802 m
.61227 .19235 L
s
.25 g
.5 Mabswid
.47898 .1627 m
.47917 .17431 L
s
.60894 .20069 m
.61227 .19235 L
s
0 g
.006 w
.10176 .63257 m
.1059 .66584 L
s
.78799 .75255 m
.79881 .72215 L
s
.34374 .18454 m .47759 .52059 L .31179 .19816 L 0 0 .542 r
F
.25 g
.5 Mabswid
.2251 .2581 m
.22629 .25945 L
s
.34374 .18454 m .48021 .51703 L .47759 .52059 L 0 0 .542 r
F
0 g
.006 w
.34374 .18454 m
.37672 .17419 L
s
.25 g
.5 Mabswid
.34374 .18454 m
.3441 .18543 L
s
.3441 .18543 m
.34465 .18677 L
s
.34465 .18677 m
.34481 .18717 L
s
.47899 .51406 m
.47916 .51447 L
s
.47916 .51447 m
.47964 .51564 L
s
.47964 .51564 m
.48021 .51703 L
s
.28117 .215 m .46886 .52562 L .25218 .23501 L 0 .141 .686 r
F
.25 g
.25318 .23635 m
.25399 .23744 L
s
.25218 .23501 m
.25318 .23635 L
s
.22629 .25945 m
.2273 .26059 L
s
.10187 .56016 m
.26594 .50075 L
s
.28117 .215 m .47391 .52358 L .46886 .52562 L 0 .141 .686 r
F
1 0 0 r
.003 w
.46212 .52639 m
.46886 .52562 L
s
.25 g
.5 Mabswid
.46799 .52444 m
.46886 .52562 L
s
.46714 .52331 m
.46799 .52444 L
s
.46689 .52297 m
.46714 .52331 L
s
.64314 .20761 m .48262 .52084 L .48351 .51517 L .884 .936 .563 r
F
.67245 .22592 m .48262 .52084 L .64314 .20761 L .877 .967 .644 r
F
.25 g
.57868 .18521 m
.57876 .18494 L
s
0 g
.006 w
.61227 .19235 m
.64314 .20761 L
s
.31179 .19816 m .47391 .52358 L .28117 .215 L 0 .056 .62 r
F
.25 g
.5 Mabswid
.25399 .23744 m
.25413 .23762 L
s
.10463 .52337 m
.30421 .49539 L
s
.31179 .19816 m .47759 .52059 L .47391 .52358 L 0 .056 .62 r
F
0 g
.006 w
.31179 .19816 m
.34374 .18454 L
s
.25 g
.5 Mabswid
.11008 .48631 m
.3442 .49726 L
s
.11835 .44953 m
.37229 .50319 L
s
.12953 .41354 m
.3926 .50883 L
s
.18031 .31492 m
.43997 .52161 L
s
.16059 .34583 m
.42655 .51838 L
s
.14363 .37883 m
.41075 .51402 L
s
.2273 .26059 m
.45994 .52392 L
s
.20261 .28642 m
.45104 .52348 L
s
.34481 .18717 m
.47899 .51406 L
s
.25413 .23762 m
.46689 .52297 L
s
1 0 0 r
.003 w
.46886 .52562 m
.47391 .52358 L
s
.25 g
.5 Mabswid
.31179 .19816 m
.31237 .19929 L
s
.31237 .19929 m
.31301 .20054 L
s
.31301 .20054 m
.31317 .20084 L
s
.31317 .20084 m
.47615 .51779 L
s
.47615 .51779 m
.47616 .5178 L
s
.47616 .5178 m
.47651 .51849 L
s
.47651 .51849 m
.47731 .52004 L
s
.47731 .52004 m
.47759 .52059 L
s
0 g
.006 w
.28117 .215 m
.31179 .19816 L
s
.67245 .22592 m .48168 .52733 L .48262 .52084 L .877 .967 .644 r
F
.69991 .24721 m .48168 .52733 L .67245 .22592 L .86 .987 .713 r
F
.25 g
.5 Mabswid
.64125 .2113 m
.64314 .20761 L
s
0 g
.006 w
.64314 .20761 m
.67245 .22592 L
s
.25 g
.5 Mabswid
.66065 .24456 m
.67245 .22592 L
s
.4729 .52196 m
.47391 .52358 L
s
.47231 .52101 m
.4729 .52196 L
s
.47219 .52083 m
.47231 .52101 L
s
.28117 .215 m
.28197 .21627 L
s
.28197 .21627 m
.2827 .21744 L
s
.2827 .21744 m
.28284 .21768 L
s
.28284 .21768 m
.47219 .52083 L
s
0 g
.006 w
.25218 .23501 m
.28117 .215 L
s
.09954 .59745 m
.10176 .63257 L
s
.69991 .24721 m .48094 .53424 L .48168 .52733 L .86 .987 .713 r
F
.72526 .27138 m .48094 .53424 L .69991 .24721 L .833 .997 .771 r
F
.25 g
.5 Mabswid
.61799 .25669 m
.64114 .21151 L
s
.64114 .21151 m
.64125 .2113 L
s
0 g
.006 w
.67245 .22592 m
.69991 .24721 L
s
.25 g
.5 Mabswid
.69394 .25504 m
.69991 .24721 L
s
0 g
.006 w
.79881 .72215 m
.80844 .68931 L
s
.2251 .2581 m
.25218 .23501 L
s
.76857 .32776 m .4832 .55304 L .4813 .5475 L .748 .994 .857 r
F
.25 g
.5 Mabswid
.49504 .55908 m
.49527 .55896 L
s
.78608 .35958 m .4832 .55304 L .76857 .32776 L .687 .979 .884 r
F
1 0 0 r
.003 w
.4832 .55304 m
.48681 .55742 L
s
.25 g
.5 Mabswid
.4832 .55304 m
.49013 .54757 L
s
.786 .35963 m
.78608 .35958 L
s
.78383 .36107 m
.786 .35963 L
s
.7828 .36174 m
.78383 .36107 L
s
.72526 .27138 m .48068 .54111 L .48094 .53424 L .833 .997 .771 r
F
.74823 .29828 m .48068 .54111 L .72526 .27138 L .796 .999 .819 r
F
.25 g
.66251 .29624 m
.69394 .25504 L
s
0 g
.006 w
.69991 .24721 m
.72526 .27138 L
s
.25 g
.5 Mabswid
.72453 .27219 m
.72507 .27159 L
s
.6995 .29979 m
.72453 .27219 L
s
.72507 .27159 m
.72526 .27138 L
s
0 g
.006 w
.20019 .28411 m
.2251 .2581 L
s
.09954 .59745 m
.09957 .56099 L
s
1 0 0 r
.003 w
.47391 .52358 m
.47759 .52059 L
s
0 g
.006 w
.17771 .31285 m
.20019 .28411 L
s
.80844 .68931 m
.81647 .65442 L
s
.74823 .29828 m .4813 .5475 L .48068 .54111 L .796 .999 .819 r
F
.25 g
.5 Mabswid
.48068 .54111 m
.481 .54075 L
s
.3775 .17669 m
.48108 .51026 L
s
.48108 .51026 m
.48111 .51037 L
s
.76857 .32776 m .4813 .5475 L .74823 .29828 L .748 .994 .857 r
F
1 0 0 r
.003 w
.4813 .5475 m
.4832 .55304 L
s
.25 g
.5 Mabswid
.48213 .53267 m
.4832 .53127 L
s
.48094 .53424 m
.48213 .53267 L
s
.48168 .52733 m
.48308 .52512 L
s
.41093 .16936 m
.48258 .50669 L
s
.48258 .50669 m
.48265 .50702 L
s
.48265 .50702 m
.48286 .50802 L
s
.48183 .51269 m
.48204 .51336 L
s
.48134 .51112 m
.48183 .51269 L
s
.48111 .51037 m
.48134 .51112 L
s
.48286 .50802 m
.48326 .50988 L
s
.48326 .50988 m
.48329 .51004 L
s
.48411 .50748 m
.48412 .50749 L
s
.48388 .50543 m
.48411 .50748 L
s
.48375 .50428 m
.48388 .50543 L
s
.48464 .5076 m
.48469 .50734 L
s
.48458 .50471 m
.4846 .50608 L
s
.49527 .55896 m
.79722 .39528 L
s
.50342 .56089 m
.80857 .43052 L
s
.48477 .50607 m
.51179 .18227 L
s
.51415 .56151 m
.8168 .46707 L
s
.52757 .56101 m
.82192 .5045 L
s
.48469 .50734 m
.54575 .17803 L
s
.49208 .55393 m
.7828 .36174 L
s
.48456 .50384 m
.48458 .50471 L
s
.48421 .51067 m
.48476 .50878 L
s
.48476 .50878 m
.57868 .18521 L
s
.48455 .50303 m
.48456 .50384 L
s
.48351 .51517 m
.4844 .51294 L
s
.48499 .51146 m
.60894 .20069 L
s
.4844 .51294 m
.48499 .51146 L
s
.48454 .50235 m
.48455 .50303 L
s
.47917 .17431 m
.48454 .50235 L
s
.4837 .50382 m
.48375 .50428 L
s
.48262 .52084 m
.48384 .51846 L
s
.48384 .51846 m
.48454 .51709 L
s
.48533 .51555 m
.61799 .25669 L
s
.48454 .51709 m
.48533 .51555 L
s
.44484 .16505 m
.4837 .50382 L
s
.60591 .33105 m
.66065 .24456 L
s
.48308 .52512 m
.48397 .52372 L
s
.48582 .5208 m
.60591 .33105 L
s
.48397 .52372 m
.48582 .5208 L
s
.4832 .53127 m
.48415 .53002 L
s
.48649 .52695 m
.66251 .29624 L
s
.48415 .53002 m
.48649 .52695 L
s
.49013 .54757 m
.75938 .33501 L
s
.481 .54075 m
.4822 .53943 L
s
.4822 .53943 m
.48328 .53824 L
s
.4874 .5337 m
.6995 .29979 L
s
.48328 .53824 m
.4874 .5337 L
s
0 g
.006 w
.72526 .27138 m
.74823 .29828 L
s
.25 g
.5 Mabswid
.73094 .31443 m
.74615 .30023 L
s
.69169 .35107 m
.73094 .31443 L
s
.4813 .5475 m
.4821 .54676 L
s
.48859 .5407 m
.69169 .35107 L
s
.48328 .54565 m
.48859 .5407 L
s
.4821 .54676 m
.48328 .54565 L
s
.74615 .30023 m
.74807 .29843 L
s
.74807 .29843 m
.74823 .29828 L
s
.76845 .32786 m
.76857 .32776 L
s
.76639 .32948 m
.76845 .32786 L
s
.76543 .33024 m
.76639 .32948 L
s
.75938 .33501 m
.76543 .33024 L
s
0 g
.006 w
.74823 .29828 m
.76857 .32776 L
s
.09957 .56099 m
.10212 .52372 L
s
.15786 .34406 m
.17771 .31285 L
s
.76857 .32776 m
.78608 .35958 L
s
.14082 .37741 m
.15786 .34406 L
s
1 0 0 r
.003 w
.48068 .54111 m
.4813 .5475 L
s
0 g
.006 w
.10212 .52372 m
.1074 .48619 L
s
.81647 .65442 m
.82249 .61794 L
s
.78608 .35958 m
.80058 .39346 L
s
.1267 .41252 m
.14082 .37741 L
s
.1074 .48619 m
.11557 .44894 L
s
.11557 .44894 m
.1267 .41252 L
s
1 0 0 r
.003 w
.47759 .52059 m
.48021 .51703 L
s
0 g
.006 w
.82249 .61794 m
.82614 .58034 L
s
.80058 .39346 m
.81195 .42907 L
s
.81195 .42907 m
.82014 .46602 L
s
.82614 .58034 m
.82711 .54215 L
s
.82014 .46602 m
.82517 .50387 L
s
.82517 .50387 m
.82711 .54215 L
s
1 0 0 r
.003 w
.48068 .54111 m
.48094 .53424 L
s
.481 .51544 m
.48204 .51336 L
s
.48021 .51703 m
.481 .51544 L
s
.48094 .53424 m
.48168 .52733 L
s
.48256 .51197 m
.48329 .51004 L
s
.48204 .51336 m
.48256 .51197 L
s
.48168 .52733 m
.48262 .52084 L
s
.48363 .50901 m
.48412 .50749 L
s
.48329 .51004 m
.48363 .50901 L
s
.48262 .52084 m
.48351 .51517 L
s
.48431 .50692 m
.4846 .50608 L
s
.48412 .50749 m
.48431 .50692 L
s
.48351 .51517 m
.48421 .51067 L
s
.48467 .50608 m
.48477 .50607 L
s
.4846 .50608 m
.48467 .50608 L
s
.48421 .51067 m
.48464 .5076 L
s
.48464 .5076 m
.48477 .50607 L
s
0 g
.25 Mabswid
.15213 0 m
.04127 .1616 L
s
.04127 .1616 m
1 .2591 L
s
1 .2591 m
.86642 .07429 L
s
.86642 .07429 m
.15213 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{266.063, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004:000181000`40O003h00Oogoo2goo000XOol5
003MOol002Moo`8000Aoo`X00==oo`009goo0P003Woo2P00bGoo000VOol00`00Ool0000HOol:002o
Ool002Eoo`04001oogoo000ROol:002eOol002Aoo`05001oogooOol0000/Ool:002[Ool002Aoo`05
001oogooOol0000fOol:002QOol002=oo`03001oogoo009oo`03001oogoo03ioo`X009Moo`008Woo
00<007ooOol00Woo00<007ooOol0BGoo2P00SGoo000ROol00`00Oomoo`02Ool00`00Oomoo`1COol:
0023Ool0025oo`03001oogoo00=oo`03001oogoo05eoo`X007Uoo`0087oo00<007ooOol017oo00<0
07ooOol0Igoo2P00Kgoo000OOol00`00Oomoo`05Ool00`00Oomoo`1aOol:001UOol001moo`03001o
ogoo00Eoo`03001oogoo07]oo`X005]oo`007Woo00<007ooOol01Woo00<007ooOol0QGoo2P00DGoo
000MOol00`00Oomoo`07Ool00`00Oomoo`2?Ool:0017Ool001eoo`03001oogoo00Moo`03001oogoo
09Uoo`X003eoo`0077oo00<007ooOol027oo00<007ooOol0Xgoo2P00<goo000KOol00`00Oomoo`09
Ool00`00Oomoo`2]Ool:000YOol001Yoo`03001oogoo00Yoo`03001oogoo0;Moo`D002Aoo`006Woo
00<007ooOol02Woo00<007ooOol0^goo0P008goo000IOol00`00Oomoo`0;Ool00`00Oomoo`2kOol2
000SOol001Qoo`03001oogoo00aoo`03001oogoo0;]oo`03001oo`00029oo`0067oo00<007ooOol0
37oo00<007ooOol0^Woo00D007ooOomoo`00025oo`005goo00<007ooOol037oo00<007ooOol0^goo
00<007ooOol00Woo00<007ooOol07Woo000FOol00`00Oomoo`0=Ool00`00Oomoo`2kOol00`00Oomo
o`02Ool00`00Oomoo`0NOol001Eoo`03001oogoo00ioo`03001oogoo0;]oo`03001oogoo00=oo`03
001oogoo01eoo`005Goo00<007ooOol03Woo00<007ooOol0^goo00<007ooOol017oo00<007ooOol0
77oo000DOol00`00Oomoo`0?Ool00`00Oomoo`2kOol00`00Oomoo`05Ool00`00Oomoo`0KOol001=o
o`03001oogoo011oo`03001oogoo0;Yoo`03001oogoo00Ioo`03001oogoo01]oo`004goo00<007oo
Ool047oo00<007ooOol0^Woo00<007ooOol01goo00<007ooOol06Woo000BOol00`00Oomoo`0AOol0
0`00Oomoo`2jOol00`00Oomoo`08Ool00`00Oomoo`0IOol0015oo`03001oogoo019oo`03001oogoo
0;Yoo`03001oogoo00Uoo`03001oogoo01Qoo`0047oo00<007ooOol04goo00<007ooOol0^Woo00<0
07ooOol02Goo00<007ooOol067oo000@Ool00`00Oomoo`0COol00`00Oomoo`2jOol00`00Oomoo`0:
Ool00`00Oomoo`0GOol000moo`03001oogoo01Aoo`03001oogoo0;Uoo`03001oogoo00aoo`03001o
ogoo01Ioo`003Woo00<007ooOol05Goo00<007ooOol0^Goo00<007ooOol037oo00<007ooOol05Woo
000>Ool00`00Oomoo`0EOol00`00Oomoo`2iOol00`00Oomoo`0=Ool00`00Oomoo`0EOol000eoo`03
001oogoo01Ioo`03001oogoo0;Uoo`03001oogoo00ioo`03001oogoo01Aoo`0037oo00<007ooOol0
5goo00<007ooOol0^Goo00<007ooOol03goo00<007ooOol04goo000;Ool00`00Oomoo`0GOol00`00
Oomoo`2jOol00`00Oomoo`0?Ool00`00Oomoo`0COol000]oo`03001oogoo01Moo`03001oogoo0;Yo
o`03001oogoo011oo`03001oogoo019oo`002Woo1@005Woo00<007ooOol0^Goo00<007ooOol04Woo
00<007ooOol04Goo000:Ool00`00Oomoo`02Ool:000<Ool00`00Oomoo`19Ool400000acW00000006
00000acW0000000700000acW001oo`1FOol00`00Oomoo`0COol00`00Oomoo`0@Ool000Yoo`03001o
ogoo00aoo`X0009oo`03001oogoo049oo`8000037>L000000080000>00H01`0600LLi`0300800`02
00<00P03008Li`T000037>L01@0000<005=oo`03001oogoo01=oo`03001oogoo011oo`002Woo00<0
07ooOol05Woo2P00>Goo10000P0:00<Li`0700H00P0600l01`0600H01QcW00800`0200<00P030080
0`007>L0200000<Li`0600D00`060P0000<Li`000000CWoo00<007ooOol057oo00<007ooOol03goo
000:Ool00`00Oomoo`0HOol00`00Oomoo`05Ool:000[Ool200000acW00002P0500X051cW00H01`06
00L01P0700H01acW00<00P0300800`0200<00P007>L7000031cW00H01@0600D01P0500H01AcWKd]c
K0@004Yoo`03001oogoo01Eoo`03001oogoo00ioo`002Woo00<007ooOol067oo00<007ooOol03goo
2@007Woo100000<03@0:7>L0200:00<Li`0600L00`0600d01`067>L00P0300800`0200<00P03000L
i`0700000acW00D01P0200H02`0500H01P067>McK6m<Lfa_C7=/Kd`01000AWoo00<007ooOol05Woo
00<007ooOol03Goo000:Ool00`00Oomoo`0HOol00`00Oomoo`0HOol:000@Ool40000200>00d03P0=
00h03@0:7>L700X04acW00L01P0700H01`0600L01QcW00800`0200<00P03008001cW00L0000D7>L0
1P0500H01@0600D01Vm;7>M_Bg=/Kd]cK6m;Lfa_Bg=/7>McS`8004=oo`03001oogoo01Moo`03001o
ogoo00eoo`002Woo00<007ooOol067oo00<007ooOol08Woo2P0017oo0P0000@041cW00d03P<03@05
00h03@0=00XLi`0700X01AcW00H01P0600L00`0600/01acW00<00P0300800`0200<001cW00L00004
7>L01P0600D300H03005Lf`Lig=/KdacK6m<Lfa_C7=/KhhLi`=_SP80045oo`03001oogoo01Qoo`03
001oogoo00aoo`002Woo00<007ooOol067oo00<007ooOol0;7oo2P0000P03P0=00h03@0>00d02QcW
1`0:01<Li`0700H01`0600L01P0700HLi`0200<00P0300800`02000Li`07000061cW00H01@0600D0
1P0500HLig=/Kd]cK6m;Lfa_Bg=/Kd]cSacWLhi_SW>?KhicSP8003moo`03001oogoo01Uoo`03001o
ogoo00]oo`002Woo00<007ooOol067oo00<007ooOol0;7oo0P001P0@00<Li`0=00002@001@0:00<L
i`0600L00`0600d01`0600HLi`0300800`0200<00P03000Li`0700000acW00D01P0200H03@0500H0
1QcWKdacK6m<Lfa_C7=/KdacK1cW00Q_SP8003eoo`03001oogoo01Yoo`03001oogoo00Yoo`002Woo
00<007ooOol067oo00<007ooOol0:Woo0P0001@04@0@0140400A01004@0@7>L03@0>00d03P0=00h0
3@0>00XLi`0:2@0000l01P0700H01`067>L00P0300800`0200<00P007>L01`0001`Li`0600D01P05
00H01@067>McK6m;Lfa_Bg=/Kd]cK6m;7>M_SW>?KhicSVn>Lhm_SW>>7>Mc/@8003]oo`03001oogoo
01Yoo`03001oogoo00Yoo`002Woo00<007ooOol067oo00<007ooOol0:7oo0P000QcW2@0@00DLi`0=
00d03@0>00<03@0300XLi`0:00H02P037>L01P0600X0000500<00P03000Li`07000011cW00H01P05
0`0600/01AcWKdacK6m<Lfa_C7=/Kda_SQcW00Q_SP047>M_/FnaKk42000iOol00`00Oomoo`0KOol0
0`00Oomoo`09Ool000Uoo`03001oogoo01Uoo`03001oogoo02Moo`0H0000<`0b03<041cW01004@0@
0140400A01004AcW00h03@0>00d03P0=00h02QcW1`0:00dLi`0600L01P0700H01`067>L00P030080
0`0<000081cW00H01@0600D01P05Lf`Lig=/Kd]cK6m;Lfa_Bg=/KhhLifn>Lhi_SW>?KhicSVn>LhlL
ig>aKk5c/FnaLk42000gOol00`00Oomoo`0LOol00`00Oomoo`08Ool000Uoo`03001oogoo01Uoo`03
001oogoo02Eoo`8000D0<`037>L0400@00H040037>L03@0>00<03@0500h03@0=00XLi`0600X00acW
00L01P0200H03@0700H01QcW00<00P0300800`0200<001cW00l000097>M_C7=/KdacK6m<Lfa_C1cW
00Q_SP037>M_/Fna00I_/@8003Aoo`03001oogoo01eoo`03001oogoo00Qoo`002Goo00<007ooOol0
67oo00<007ooOol097oo0P0001/0<P0c0380<`0b03<0<P0A7>L04@0@0140400A01004@0@7>L03@0>
00d03P0=00h03@0:7>L01`0:014Li`0700H01`0600L01P077>L00`0200<00P03008001cW00H00009
7>L01@0600D01P0500H01AcW00X0000BKhicSfn>Lhi_SW>?KhhLifnaLk5_/G>aKk5c/FnaLk4LifoD
0P00<Woo00<007ooOol07Woo00<007ooOol01goo0009Ool00`00Oomoo`0HOol00`00Oomoo`0SOol0
0`0003<0<`0803<00acW01004006010011cW00d03@0>0`0=00<03P0:7>L01`0:00<Li`0600L00`06
00/01`067>L00P0300800`0200<001cW00H000057>L01P0600H01@0300H02acWLfa_C7=/KdacK6m<
Lfa_SQcWKhh02P001Fna00DLifoDKm=_e6oC0080031oo`03001oogoo01moo`03001oogoo00Ioo`00
2Goo00<007ooOol067oo00<007ooOol08Goo0P0001l0UAcW03<0<P0c0380<`0b03<0<P0c010Li`0@
0140400A01004@0@014Li`0>00d03P0=00h03@0>00XLi`0600X04AcW00L01P0700H01`0600LLi`03
00800`0200<00P007>L01P0001dLi`0500H01@0600D01P057>M_Bg=/Kd]cK6m;Lfa_BacWKhicSfn>
Lhi_SW>?KhicSQcWLk5_/G>a00T00003KmA_dfoD008002ioo`03001oogoo021oo`03001oogoo00Eo
o`002Goo00<007ooOol067oo00<007ooOol087oo00D0002E09D0UAcW00X0<`037>L0400@00H04005
7>L03@0=00d03P0300d00`0:7>L02P0500X01AcW00H01P0600L00`0600TLi`0200<00P0300800`00
7>L01P0000<Li`0600D00`0600/01G=/7>McK6m<Lfa_C7=/KdacK1cW00Q_SP037>M_/Fna00E_/@05
7>M_dfoDKm=_e00:000YOol00`00Oomoo`0POol00`00Oomoo`05Ool000Uoo`03001oogoo01Qoo`03
001oogoo01ioo`800080U@0P09@0U@2E7>L0<P0c0380<`0b03<0<P0c03804AcW0140400A01004@0@
014Li`0>00d03P0=00h03@0>00XLi`H02P0A7>L01`0600L01P0700H01acW00<00P0300800`02000L
i`060000;QcW00D01P0500H01@06Kd/Lifm;Lfa_Bg=/Kd]cK6n>7>M_SW>>KhicSfn>Lhi_SQcWKk5c
/FnaLk5_/G>aKk5c/AcWKmA_dfoDKm=_e6oCKmA_dfoD7>M_mP000Woo2P007goo00<007ooOol08Goo
00<007ooOol017oo0009Ool00`00Oomoo`0HOol00`00Oomoo`0LOol2000809D00acW03<0<`0703<0
0acW0100400601000acW00h03@0200d01@0>00d03@0:7>L01P0:00<Li`0700H00P0600/01`067>L0
0P0300800`0200<001cW00H000057>L01P0600H01@0200H02AcWKdacK6m<Lfa_C7=/Kd`Li`08Khh0
0acWKk5_/@05Kk403acWKmA_dfoDKm=_e6oCKmA_dfoDKm<Lif_fKoH0000;Ool:000DOol00`00Oomo
o`0SOol00`00Oomoo`03Ool000Uoo`03001oogoo01Qoo`03001oogoo01]oo`03000Li`2E0080U@0S
09@0U@2E09D0U02E7>L0<`0b03<0<P0c0380<`0b03<041cW01004@0@0140400A010Li`0=00h03@0>
00d03P0=00XLi`0600X041cW00H01`0600L01P077>L00`0200<00P03008001cW1P0002lLi`0500H0
1@0600D01QcWLfa_Bg=/Kd]cK6m;Lf`Lig>>KhicSfn>Lhi_SW>?7>Mc/FnaLk5_/G>aKk5c/Fna7>M_
dfoDKm=_e6oCKmA_dfoDKm<Lif_eKoI[mFof008001=oo`X000Yoo`03001oogoo02Aoo`03001oogoo
009oo`002Goo00<007ooOol067oo00<007ooOol06Woo00<0003G7>L02P2E00<Li`0c03<01`0c00<L
i`0@01001P0@00<Li`0=00h00`0=00<03P0:7>L01P0:00@Li`0600H01`<01P097>L00P0300800`02
00<001cW00H000037>L01P0500<01P0:00DLifm<Lfa_C7=/KdacK6n>7>L7Khh00acWKk5_/@05Kk40
4acWKm=_e6oCKmA_dfoDKm=_e6oCKoHLifofJoI_mV_fKoI[mP0001aoo`T00003Ool007oo02Eoo`03
001oogoo009oo`002Goo00<007ooOol067oo00<007ooOol06Goo00H0003F0=L0eQcW09@309D08@2D
09D0U@2E09@Li`0b03<0<P0c0380<`0b03<0<P0A7>L04@0@0140400A01004AcW00h03@0>00d03P0=
00hLi`0600X041cW00H01`0600L01P0700HLi`0200<00P03008001cW1P0003<Li`0500H01@0600D0
1QcWLfa_Bg=/Kd]cK6m;LhhLig>?KhicSVn>Lhm_SW>>7>Mc/FnaLk5_/G>aKk5c/AcWKmA_dfoDKm=_
e6oCKmA_dfoD7>M_mV_eKoI[mFofJoE_mV_e000097oo2P007goo00<007ooOol00Goo0009Ool00`00
Oomoo`0HOol00`00Oomoo`0GOol200020=L00`3F0=LLi`0:09D00acW03<0<`0703<00acW01004005
01001AcW00d03@0=00h00`0=00<02QcW00X0100:00<Li`0700H00P0600/01`0600HLi`0300800`02
00<001cW00H0000?7>L01P0600H01@06Kd`Lifm<Lfa_C7=/KdacK1cW00M_SP037>M_/Fna00E_/@0F
7>M_e6oCKmA_dfoDKm=_e6oCKm@LifofJoI_mV_fKoI[mVofJoI_mV_f000TOol00`00Oomoo`06Ool:
000FOol10001Ool1Ool000Uoo`03001oogoo01Qoo`03001oogoo01Ioo`0;0000e`3F0=L0eP3G0=H0
eacW09D0U00309D0802D09D0U@2E09@Li`0b03<0<P0c0380<`0b03<041cW01004@0@0140400A010L
i`0=00h03@0>00d03P0:7>L600X03acW00L01P0700H01`067>L00P0300800`0200<Li`060000=AcW
00D01P0500H01G=/7>McK6m;Lfa_Bg=/Kd/Lifn>Lhi_SW>?KhicSVn>7>M_/G>aKk5c/FnaLk5_/AcW
Km=_e6oCKmA_dfoDKm=_e6oC7>M[mFofJoE_mV_eKoI[mFofJoDLifOg00008goo00<007ooOol047oo
2P003Goo0@000Goo0009Ool00`00Oomoo`0HOol00`00Oomoo`0EOol01@000=L0e`3G0=H00`3G00<0
eP3G7>L02@2E00<Li`0c03<01`0c00<Li`0@01001@0@00<Li`0>00d00P0=00@03P0=00dLi`H02P03
7>L01P0700<01P0900LLi`0300800`0200<00QcW00D000047>L01P0600D300H02AcWLfa_C7=/Kdac
K6m<KhhLi`06Khh00acWKk5_/@05Kk405QcWKm=_e6oCKmA_dfoDKm=_e6oC7>M[mVofJoI_mV_fKoI[
mVofJoHLifOg0V_h00<007ooOol07goo00<007ooOol06goo2P000goo0@000Goo0009Ool00`00Oomo
o`0HOol00`00Oomoo`0DOol03`000=L0eP3G0=H0e`3F0=L0eP3G0=H0eacW09D0U00309D07`2D09D0
U@2E7>L0<`0b03<0<P0c0380<`0b014Li`0A01004@0@0140400A7>L03P0=00h03@0>00d02QcW00D0
2P0?7>L01`0600L01P0700HLi`0200<00P0300800acW00D0000g7>L01P0500H01@0600DLifm;Lfa_
Bg=/Kd]cK1cWLhi_SW>?KhicSVn>LhlLig>aKk5c/FnaLk5_/G>a7>M_e6oCKmA_dfoDKm=_e6oC7>M[
mFofJoE_mV_eKoI[mFofJoDLifOgJoQWmf_hIoL00P007goo00<007ooOol09Goo1@000009Ool00`00
Oomoo`0HOol00`00Oomoo`0COol01@000APLi`3G0=H00`3G00H0eP3G0=L0e`3F7>L:09D00acW03<0
<`0603<00acW0100400501000acW00d03P0300d00`0>00XLi`0500X01AcW00H01P0600L00P0600PL
i`0300800`0200<00QcW1@0000<Li`0500H00P0600X01@067>McK6m<Lfa_C7=/Kd`Li`M_SP037>M_
/Fna00A_/@0E7>M_e6oCKmA_dfoDKm=_e6oCKm@LifofJoI_mV_fKoI[mVofJoI_mQcW00=[n005IoM[
n6_hJoP0000NOol00`00Oomoo`0YOol1000000Uoo`03001oogoo01Qoo`03001oogoo019oo`0@0001
604H0APLi`3G0=H0e`3F0=L0eP3G0=H0e`3F7>L209D01@2D09D0U@2E09@00P2E01XLi`0b03<0<P0c
0380<`0b03<041cW01004@0@0140400A7>L03P0=00h03@0>00d02QcW1@0:00lLi`0700H01`0600L0
1QcW00800`0200<00P037>L01@0003/Li`0600D01P0500H01AcWKd]cK6m;Lfa_Bg>>7>McSfn>Lhi_
SW>?KhhLifnaLk5_/G>aKk5c/Fna7>M_dfoDKm=_e6oCKmA_dfoD7>M_mV_eKoI[mFofJoE_mV_eKoHL
if_hIoM[n6OgJoQWmf_hIoM[n00001eoo`03001oogoo02Uoo`4000002Goo00<007ooOol067oo00<0
07ooOol04Goo00<0004H0AP00`4H00<Li`3G0=H00`3G00H0eP3G0=L0e`3F7>L909D00acW03<0<`06
03<00acW01004005010011cW00d03@0>0`0=00<02QcW00X0100:00<Li`0700H00P0600T01acW00<0
0P0300800`027>L01@0000@Li`0600H01@801P09Lf`Lig=/KdacK6m<Lfa_SQcW00I_SP037>M_/Fna
00A_/@0D7>M_dfoDKm=_e6oCKmA_dfoD7>M_mV_fKoI[mVofJoI_mV_fKoHLi`=[n005IoM[n6_hJoQW
m`03JoP00`00Oomoo`0JOol00`00Oomoo`0XOol10001Ool000Uoo`03001oogoo01Moo`03001oogoo
019oo`030001604H00@1600<7>L0e`3F0=L0eP3G0=H0e`3F0=L0eQcW0P2E0200U02E09D0U@2D09DL
i`0c0380<`0b03<0<P0c03804AcW0140400A01004@0@7>L03@0>00d03P0=00h02QcW1@0:00hLi`06
00L01P0700H01acW00<00P0300800acW1@0003dLi`0600D01P0500HLig=/Kd]cK6m;Lfa_BacWKhic
SVn>Lhm_SW>>7>Mc/FnaLk5_/G>aKk5c/AcWKmA_dfoDKm=_e6oCKmA_dacWJoE_mV_eKoI[mFofJoE_
mQcWJoQWmf_hIoM[n6OgJoQWmf_hIoM[n6?i7>L0000KOol00`00Oomoo`0XOol10001Ool000Uoo`03
001oogoo01Moo`03001oogoo015oo`030001604H00D160040=LLi`3G0=H30=L01@3F0=L0e`3G7>L0
2@2E00<Li`0c03<01P0c00<Li`0@01001@0@00PLi`0=00d03@0>00d02QcW1@0:00@Li`0600H01`<0
1P077>L00P0300800`027>L01@0000<Li`0500H00P0600T01AcWKdacK6m<Lfa_C7=/7>L01Vn>00<L
ifnaKk4016na01@LifoDKm=_e6oCKmA_dfoDKm<Lif_fKoI[mVofJoI_mV_fKoI[mQcW0V_h00EWmf_h
JoQ[n6Og00=[n005HoTLif?iIoT0000JOol00`00Oomoo`0XOol10001Ool000Uoo`03001oogoo01Mo
o`03001oogoo011oo`030001604H00L1600<7>L0eP3G0=H0e`3F0=L0eP3G0=H0eacW0`2E01h0U02E
09D0U@2D09DLi`0c0380<`0b03<0<P0c010Li`0@0140400A01004AcW00h03@0>00d03P0=7>L500X0
3QcW00H01`0600L01P077>L00`0200<00P037>L50000?QcW00H01@0600D01QcWLfa_Bg=/Kd]cK6n>
7>M_SW>?KhicSVn>LhlLig>aKk5c/FnaLk5_/AcWKm=_e6oCKmA_dfoDKm<Lif_eKoI[mFofJoE_mV_e
KoI[mAcWIoM[n6OgJoQWmf_hIoM[n6OgJoQSnAcWHoUWnV?i000IOol00`00Oomoo`0YOol10001Ool0
00Uoo`03001oogoo01Moo`03001oogoo00moo`030001604H00T160047>L0e`3G0=H30=L01@3F0=L0
e`3G7>L0202E00<Li`0c03<01P0c00<Li`0@0100100@00<Li`0=00h00`0=00<03P0:7>L01@0:00dL
i`0600H01P0700HLi`0200<00P03008Li`05000011cW00H01P050P0600LLifm<Lfa_C7=/Kd`Li`06
Khh00acWKk5_/@04Kk404acWKm=_e6oCKmA_dfoDKm=_e1cWKoI[mVofJoI_mV_fKoI[mQcW009[n005
IoM[n6_hJoQWm`03JoP016?i7>MSnFOi0f?i00<007ooOol05Woo00<007ooOol0:Goo0@000Goo0008
Ool00`00Oomoo`0HOol00`00Oomoo`0>Ool00`000ETLi`0;0AP031cW0=H0e`3F0=L0eP3G0=H0e`3F
0=LLi`<0U@0M09@0U@2E09D0U1cW0380<`0b03<0<P0c03804AcW0140400A01004@0@7>L03@0>00d0
3P0=00XLi`0500X03AcW00L01P0700H01acW00<00P0300800acW00D000107>L01P0500H01G=/7>Mc
K6m;Lfa_Bg=/7>McSfn>Lhi_SW>?KhhLifnaLk5_/G>aKk5c/AcWKmA_dfoDKm=_e6oCKm@LifofJoE_
mV_eKoI[mFofJoDLifOgJoQWmf_hIoM[n6OgJoQWmf_hHoTLif?iIoYSnFOiHoUWnV?i000GOol00`00
Oomoo`0YOol10001Ool000Qoo`03001oogoo01Qoo`03001oogoo00eoo`050001F@5I0ETLi`0;0AP0
11cW0=L0e`3F0`3G00@0eP3G0=LLi`T0U@037>L0<`0c00D0<`037>L0400@00@040047>L03@0=00h3
00d00acW00X02P0300X00acW00H01`0300H01acW00800`0200<00QcW00D000037>L01@0600801P08
7>McK6m<Lfa_C7=/KhhLi`E_SP037>M_/Fna00A_/@0E7>M_e6oCKmA_dfoDKm=_e6oC7>M[mVofJoI_
mV_fKoI[mVof7>M[n6Og00=[n008IoM[n6_hJoQWmacWHoUWn@=Sn@05IoUSnF?iHoT0000FOol00`00
Oomoo`0XOol10001Ool1Ool000Qoo`03001oogoo01Qoo`03001oogoo00aoo`030001F@5J00<1F@03
7>L1604H00T1600<7>L0eP3G0=H0e`3F0=L0eP3G0=HLi`2D0`2E01`0U02E09D0UAcW03<0<P0c0380
<`0b03<041cW01004@0@0140400A7>L03P0=00h03@0>00XLi`@02P0=7>L01`0600L01P077>L00`02
00<00P037>L01@00044Li`0600D01P057>M_Bg=/Kd]cK6m;7>M_SW>>KhicSfn>LhhLig>aKk5c/Fna
Lk5_/AcWKm=_e6oCKmA_dfoDKm<Lif_eKoI[mFofJoE_mV_eKoHLif_hIoM[n6OgJoQWmf_hIoM[n6Og
7>MSnFOjHoUWnF?iIoYSnFOiHoUWnP0001Ioo`03001oogoo02Qoo`40005oo`5oo`0027oo00<007oo
Ool067oo00<007ooOol037oo00<0005I0ET0105I00<Li`4H0AP02@4H00@Li`3G0=L0eP<0e`040=H0
e`3G7>L809D00acW03<0<`0503<00acW01004004010021cW00d03@0=00h03@0:7>L400X03AcW00H0
1P0600L01QcW00800`0200<00QcW00@0000=7>L01P0600H01@067>McK6m<Lfa_C7=/7>L01Vn>00<L
ifnaKk400fna01@LifoCKmA_dfoDKm=_e6oC7>M[mVofJoI_mV_fKoI[mVof7>M[n6Og0f_h00QWmf_h
JoQ[n6Og7>MSnFOi0f?i00QWnF?iHoUSnFOiHoTLi`005Goo00<007ooOol0:7oo0@000Goo0Goo0008
Ool00`00Oomoo`0HOol00`00Oomoo`0;Ool00`000EX1F@020ET01@5J0ET1F@5I7>L02`4H00`Li`3F
0=L0eP3G0=H0e`3F0=L0eQcW09@309D06P2D09D0UAcW0380<`0b03<0<P0c03804AcW0140400A0100
4AcW00h03@0>00d03P0=7>L500X031cW00H01`0600L00QcW00800`0200<Li`@000147>L01@0600D0
1P057>M_Bg=/Kd]cK6m;7>M_SW>?KhicSVn>7>M_/G>aKk5c/FnaLk4LifoDKm=_e6oCKmA_dfoD7>M_
mV_eKoI[mFofJoE_mQcWJoQWmf_hIoM[n6OgJoQWmf_hIoLLif?iIoYSnFOiHoUWnV?iIoUSnFOjHoTL
ie_jGo/001=oo`03001oogoo02Uoo`40005oo`5oo`0027oo00<007ooOol067oo00<007ooOol02Woo
00<0005I0ET0205I00<Li`4H0AP02@4H00@Li`3G0=L0eP<0e`030=H0eacW00P0U@037>L0<`0c00D0
<`037>L0400@00@040037>L03P0=00803@0300h02QcW00@02P037>L01`0600801P0700LLi`030080
0`027>L0100000<Li`0600D00`0600LLig=/KdacK6m<KhhLi`05Khh00acWKk5_/@03Kk404acWKmA_
dfoDKm=_e6oCKm@LifofJoI_mV_fKoI[mVofJoHLifOg00=[n008IoM[n6_hJoQWmacWHoUWn@=Sn@0;
IoUSnF?iHoUWnF?i7>MOnUokGoX0000COol00`00Oomoo`0YOol10001Ool1Ool000Qoo`03001oogoo
01Qoo`03001oogoo00Uoo`030001FP5I0081F@050EX1F@5I0ET1FP030ET00acW0AP160080AP03AcW
0=L0eP3G0=H0e`3F0=L0eP3G7>L0U@2D00<0U@0I09@0U@2E7>L0<P0c0380<`0b03<041cW01004@0@
014041cW00d03P0=00h03@0:7>L0100:00`Li`0600L01P0700HLi`0200<00P037>L40000AAcW00D0
1P0500I_BacWKd]cK6m;Lf`Lig>?KhicSVn>LhlLig>aKk5c/FnaLk5_/AcWKm=_e6oCKmA_dfoD7>M_
mV_eKoI[mFofJoE_mV_e7>MWmf_hIoM[n6OgJoQWmf_hIoLLif?iIoYSnFOiHoUWnV?iIoUSnFOjHoTL
ie_jGo]OnUokFoX0000BOol00`00Oomoo`0XOol00`00Oomoo`01Ool000Qoo`03001oogoo01Qoo`03
001oogoo00Qoo`03000Li`5I00`1F@037>L1604H00P160057>L0e`3G0=L0eP030=L00`3F0=LLi`07
09D00acW03<0<`0503<00acW0100400401000acW00d03P0300d00acW00X02P0200X011cW00H01P07
0P0600HLi`0300800`027>L4000031cW00H01P0600DLifm<Lfa_C7=/Kd`Li`E_SP037>M_/Fna00=_
/@0B7>M_dfoDKm=_e6oCKmA_dacWJoI_mV_fKoI[mVofJoHLifOg0f_h00QWmf_hJoQ[n6Og7>MSnFOi
0f?i00UWnF?iHoUSnFOiHoTLieojGo/00eoj00=Oneoj00004Goo00<007ooOol0:7oo00<007ooOol0
0Goo0008Ool00`00Oomoo`0HOol00`00Oomoo`08Ool01@000GTLi`5I0EX00`5I00D1FP5I0ET1F@5J
00<1F@037>L1604H00P1600=7>L0e`3F0=L0eP3G0=H0e`3F0=LLi`2E09@00`2E01P0U02E7>L0<`0b
03<0<P0c03804AcW0140400A01004AcW00h03@0>00d03P0:7>L300X031cW00H01`0600L01QcW0080
0`0200<Li`@000177>L01@0600D01QcWLfa_Bg=/Kd]cSacWLhi_SW>?KhicSQcWLk5_/G>aKk5c/AcW
KmA_dfoDKm=_e6oC7>M[mFofJoE_mV_eKoI[mAcWIoM[n6OgJoQWmf_hIoM[n6Og7>MSnFOjHoUWnF?i
IoYSnFOiHoUWnV?i7>MKnUokGoYOne_jGo]OnUokFoX0000@Ool00`00Oomoo`0XOol00`00Oomoo`01
Ool000Qoo`03001oogoo01Qoo`03001oogoo00Moo`040001VP6J0IX27>L<0ET00acW0AP160080AP0
1AcW0=L0e`3G0=H00`3G00<0eQcW09D01`2E00<Li`0c03<0100c00<Li`0@01000`0@00PLi`0=00d0
3@0>00d02QcW100:00/Li`0600H01P077>L00`0200<00QcW00@000037>L01P0500801P067>M_C7=/
KdacK1cW1Fn>00<LifnaKk400fna014LifoDKm=_e6oCKmA_dacWJoI_mV_fKoI[mVofJoI_mQcW00=[
n008IoM[n6_hJoQWmf?i7>MWn@=Sn@09IoUSnF?iHoUWnF?i7>MOnUok00=OnP06Go]OnUojGoYOn`00
47oo00<007ooOol0:7oo00<007ooOol00Goo0008Ool00`00Oomoo`0HOol00`00Oomoo`06Ool02@00
0GT1VP5i0IX1N@6J7>L1FP030ET01@5J0ET1F@5I0EX00`5I0QcW2@4H00XLi`3G0=H0e`3F0=L0eP3G
0=HLi`80U@0J09@0U@2E09D0U1cW0380<`0b03<0<P0c010Li`0@0140400A010Li`0=00h03@0>00XL
i`@02P0;7>L01`0600L01QcW00800`0200<Li`040000B1cW00D01P0500HLig=/Kd]cK6m;7>M_SW>?
KhicSVn>7>M_/G>aKk5c/Fna7>M_dfoDKm=_e6oCKm@LifofJoE_mV_eKoI[mFof7>M[n6OgJoQWmf_h
IoM[n6OgIoTLifOjHoUWnF?iIoYSnFOiHoUWnV?i7>MKnUokGoYOne_jGo]OnUokFoYOneojGo/000io
o`03001oogoo02Uoo`03001oogoo005oo`0027oo00<007ooOol05goo00<007ooOol01goo00<0006J
0IX01@6J00<Li`5I0ET02`5I00<Li`4H0AP01`4H00DLi`3G0=L0e`3F00<0e`030=HLi`2E00H0U@03
7>L0<`0c00@0<`037>L0400@00<040037>L03P0=00803@0300hLi`0:00<02P037>L01P0700801P06
7>L00`0200<00QcW100000/Li`0600H01Vm<7>M_C7=/KdacK1cW00A_SP037>M_/Fna00=_/@0@7>M_
dfoDKm=_e6oCKm@LifofJoI_mV_fKoI[mVof7>L3JoP026OgJoQ[n6_hIoM[n1cWIoT3HoT02FOiHoUS
nF?iIoUSnAcWGoYOn`03GoX01EokGoYOnUojGo/00Uoj0QcW00<007ooOol02goo00<007ooOol0:Goo
00<007ooOol00Goo0008Ool00`00Oomoo`0GOol00`00Oomoo`06Ool030000IX1N@6J0GT1VP5i0IX1
N@6J7>L1FP<1F@050EX1F@5I0ET1FP030ET00`5J7>L160080AP02QcW0=L0eP3G0=H0e`3F0=L0eQcW
0P2E01T0U02E09D0U@2D7>L0<P0c0380<`0b014Li`0A01004@0@014Li`0>00d03P0=00XLi`0300X0
2acW00L01P0700H00acW00<00P037>L0100004TLi`0500H01AcWKd]cK6m;Lfa_SQcWKhicSVn>LhlL
ig>aKk5c/FnaLk4LifoDKm=_e6oCKm@LifofJoE_mV_eKoI[mFof7>M[n6OgJoQWmf_hIoM[n6OgJoPL
ifOjHoUWnF?iIoYSnFOiHoUWnV?i7>MKnUokGoYOne_jGo]OnUokFoYOneojGo/LieOlEm/0000=Ool0
0`00Oomoo`0XOol00`00Oomoo`02Ool000Qoo`03001oogoo01Moo`03001oogoo00Eoo`030001VP6J
00T1VP8Li``1F@037>L1604H00L160057>L0e`3G0=L0eP030=L00acW09D0U@0509D00acW03<0<`04
03<00acW0100400301000acW00d03P0200d00`0:7>L02P0300X02QcW00H01P0700HLi`0200<00QcW
100000XLi`0600D01QcWLfa_C7=/Kd`Li`E_SP037>M_/Fna009_/@0@7>M_e6oCKmA_dfoDKm<Lif_f
KoI[mVofJoI_mV_f7>L2JoP026OgJoQ[n6_hIoM[n1cWIoT3HoT02FOiHoUSnF?iIoUSnAcWGoYOn`03
GoX03EokGoYOnUojGo]OnUOk7>MGneOKEo]Gf`0000aoo`03001oogoo02Qoo`03001oogoo009oo`00
27oo00<007ooOol05goo00<007ooOol01Goo00l0005i0IX1N@6J0GT1VP5i0IX1N@6J0GT1VP5i7>L0
0`5I00D1FP5I0ET1F@5J00<1F@030EXLi`4H00P160097>L0e`3F0=L0eP3G0=H0eacW00<0U@0G09@0
U@2E09DLi`0c0380<`0b03<041cW01004@0@014Li`0>00d03P0=00hLi`0400X02acW00H01`0600LL
i`0300800`007>L00`00048Li`0500H01AcWKd]cK6m;Lf`Lig>>KhicSfn>7>M_/G>aKk5c/Fna7>M_
dfoDKm=_e6oC7>M[mFofJoE_mV_eKoI[mAcWIoM[n6OgJoQWmf_hIoM[n1cWIoYSnFOiHoUWnV?iIoUS
nFOjHoTLie_jGo]OnUokFoYOneojGo]KnUokGoX27>L01UOlEm]Go5?KEo`000aoo`03001oogoo02Qo
o`03001oogoo009oo`0027oo00<007ooOol05goo00<007ooOol017oo00<001cW0IX03@6J00<Li`5I
0ET02P5I00<Li`4H0AP01P4H00<Li`3F0=L00P3G00D0eP3G0=L0eacW00H0U@037>L0<`0c00@0<`03
7>L0400@00<040077>L03@0=00h03@0:7>L00`0:00<Li`0700H00P0600HLi`0200<00P007>L20000
0acW00D01P0200H01QcWLfa_C7=/Kd`Li`A_SP037>M_/Fna009_/@0?7>M_dfoDKm=_e6oC7>M[mVof
JoI_mV_fKoI[mQcW009[n008IoM[n6_hJoQWmf_h7>MWn@=Sn@09IoUSnF?iHoUWnF?i7>MOnUok00=O
nP0@Go]OnUojGoYOneoj7>MGfeOkEm]GneOKEo]GfeOk000;Ool00`00Oomoo`0XOol00`00Oomoo`02
Ool000Qoo`03001oogoo01Moo`03001oogoo00Aoo`0B0001VQcW7>L1N@6J0GT1VP5i0IX1N@6J0GT1
VP5i0IX1NAcW0`5I00D1FP5I0ET1F@5J00<1F@030EXLi`4H00L1600:7>L0eP3G0=H0e`3F0=L0eP3G
7>L309D05P2D09D0UAcW0380<`0b03<0<P0A7>L04@0@014041cW00d03P0=00h02QcW0`0:00/Li`06
00L01P077>L00`0200<001cW0080001<7>L01P0500H01AcWKd]cK6m;7>M_SW>?KhicSQcWLk5_/G>a
Kk5c/AcWKmA_dfoDKm=_e1cWKoI[mFofJoE_mV_e7>MWmf_hIoM[n6OgJoQWmf_h7>MWnV?iIoUSnFOj
HoUWnF?iIoYSnAcWFoYOneojGo]KnUokGoYOne_jGo]OnQcWDm]Go5OKEoaCfeOlEm]Go5?K000;Ool0
0`00Oomoo`0XOol00`00Oomoo`02Ool000Qoo`03001oogoo01Moo`03001oogoo00=oo`060001^P6j
0KX1VQcW3@6J0QcW2`5I00<Li`4H0AP01P4H00<Li`3F0=L00P3G00@0eP3G0=LLi`L0U@037>L0<`0c
00<0<`037>L0400@00<040067>L03@0=00d03QcW0`0:00/Li`0600H01`067>L00P03008001cW0080
000:7>L01P0600EcK1cWLfa_C7=/7>L4Khh00acWKk5_/@02Kk403QcWKmA_dfoDKm=_e1cWKoI[mVof
JoI_mV_f7>L2JoP026OgJoQ[n6_hIoM[n1cWIoT3HoT02FOiHoUSnF?iIoUSnAcWGoYOn`03GoX04eok
GoYOnUojGo]GfacWEm]GneOKEo]GfeOkEm]GneOKEo]Gf`0000Uoo`03001oogoo02Uoo`03001oogoo
009oo`0027oo00<007ooOol05goo00<007ooOol00goo00H0006i0KX1^@6j0GT27>L03P6J0GT1VP5i
0IX1N@6J0GT1VP5i0IX1N@6J7>L20ET01@5J0ET1F@5I0EX00`5I00<1FQcW0AP01`4H00XLi`3F0=L0
eP3G0=H0e`3F7>L0U0<0U@0E09@0UAcW03<0<P0c0380<`0@7>L0400A01004AcW00h03@0>00d02QcW
00<02P0:7>L01`0600LLi`0300800`007>L20000?QcW00H01@067>McK6m;Lfa_BacWKhicSVn>7>M_
/G>aKk5c/Fna7>M_dfoDKm=_e6oC7>M[mFofJoE_mV_eKoHLif_hIoM[n6OgJoQWmf_h7>MWnV?iIoUS
nFOjHoUWnF?iIoYSnAcWFoYOneojGo]KnUokGoYOne_jGo/27>L03E?KEoaGfeOlDm]Go5OKEoaCfeOl
Em]Go00000Uoo`03001oogoo02Qoo`03001oogoo00=oo`0027oo00<007ooOol05goo00<007ooOol0
0Woo00<0006j0KX01@6j00<1VQcW0IX0306J00<Li`5I0ET02@5I00<Li`4H0AP01P4H00<Li`3F0=L0
0P3G00@0eP3G0=LLi`H0U@037>L0<`0c00<0<`03010Li`0@00<040067>L03P0=00d02QcW0`0:00XL
i`0600H01QcW00800`02000Li`8000097>L01@0600HLifm<Lfa_C1cW00A_SP037>M_/Fna009_/@0@
7>M_dfoDKm=_e6oC7>M[mVofJoI_mV_fKoHLif_hIoL3JoP016OgJoQSnAcW0f?i00UWnF?iHoUSnFOi
HoTLieojGo/00eoj01IOneojGoYOnUok7>MGneOKEo]GfeOkEm]GneOKEo]GfeOkEm]GneOK7>L000Qo
o`03001oogoo02Qoo`03001oogoo00=oo`0027oo00<007ooOol05goo00<007ooOol00Woo00X0006j
0KT1^P6i0KX1^@6j0KT1^P8Li`0=0GT1VP5i0IX1N@6J0GT1VP5i0IX1N@6J7>L00P5I00D1FP5I0ET1
F@5J00<1F@030EXLi`4H00L1600:7>L0eP3G0=H0e`3F0=L0eQcW09@309D04`2D09DLi`0c0380<`0b
03<Li`0A01004@0@7>L03@0>00d03QcW00<02P0:7>L01`0600LLi`0300800`007>L20000BQcW00H0
1@067>McK6m;Lf`Lig>>KhicSfn>7>M_/G>aKk5c/AcWKmA_dfoDKm<Lif_eKoI[mFofJoE_mQcWJoQW
mf_hIoM[n6OgJoQSnAcWHoUWnF?iIoYSnFOiHoUWnV?i7>MKnUokGoYOne_jGo]OnUokFoYOnacWEoaC
feOlEm]Go5?KEoaGfeOlDm]Go5OKEo`27>L00d^k001oo`07Ool00`00Oomoo`0XOol00`00Oomoo`03
Ool000Qoo`03001oogoo01Moo`05001oogooOol0000;0KX00`6J7>LLi`0;0IX27>L:0ET00acW0AP1
60060AP00acW0=H0e`020=L00`3F0=LLi`0609D00acW03<0<`0303<00`0@7>L0400201001QcW00d0
3@0>00dLi`<02P037>L01P0700801P057>L00`02000Li`0200002AcW00H01P057>M_C7=/Kd`Li`03
Khh00acWKk5_/@02Kk403acWKmA_dfoDKm=_e1cWKoI[mVofJoI_mQcWJoQWm`03JoP016OgJoQ[n1cW
0f?i00UWnF?iHoUSnFOiHoTLieojGo/00eoj01IOneojGoYOnUOk7>MGneOKEo]GfeOkEm]GneOKEo]G
feOkEm]GnacWCma;f`9;g003001oogoo00Eoo`03001oogoo02Qoo`03001oogoo00=oo`001goo00<0
07ooOol067oo02<007ooOomoo`000KT1^P6i0KX1^@6j0KT1^P6i0KX1^@6j0KT1VQcW0IX1N@6J0GT1
VP5i0IX1N@6J0GT1VP5i7>L1F@5J00<1F@060EX1F@5I0ET1FQcW204H00XLi`3F0=L0eP3G0=H0eacW
09D0U0<0U@0B09@Li`0b03<0<P0c038Li`0@0140400A7>L03P0=00h02QcW0P0:00XLi`0700H01`06
7>L00P03000Li`80000i7>L01P05Lf`Lig=/Kd]cK1cWLhm_SW>>7>Mc/FnaLk5_/AcWKm=_e6oCKm@L
ifofJoE_mV_eKoI[mAcWIoM[n6OgJoQWmf_hIoLLif?iIoUSnFOjHoUWnF?iIoYSnAcWFoYOneojGo]K
nUokGoYOne_j008Li`0<EoaCfeOlEm]Go5?KEoaGfeOlDm]Go5OK0QcW00I?g4^kCma;^doL0007Ool0
0`00Oomoo`0XOol00`00Oomoo`03Ool000Moo`03001oogoo01Qoo`04001oogoo000?0KX00`6J7>LL
i`0;0IX00acW0ET1F@080ET00acW0AP160060AP00acW0=H0e`020=L00`3F0=LLi`0509D00acW03<0
<`0303<00`0@7>L0400201001QcW00d03@0=00XLi`<02P097>L01P0600LLi`03008001cW00800008
7>L01@067>McK6m<Lf`Li`=_SP037>M_/Fna009_/@0>7>M_dfoDKm=_e1cWKoI[mVofJoI_mV_f7>MW
m`=[n004IoM[n6_h7>L3HoT01FOiHoUSnF?iIoT00QcW00=OnUokGoX00Uoj01IOneojGoYOnQcWEm]G
neOKEo]GfeOkEm]GneOKEo]GfeOkEm/Lid_LCma;f`9;g004Cma;fd_L0005Ool00`00Oomoo`0XOol0
0`00Oomoo`04Ool000Moo`03001oogoo01Qoo`0U001oogoo000Li`6i0KX1^@6j0KT1^P6i0KX1^@6j
0KT1^P6i0KX1^@6j0GTLi`5i0IX1N@6J0GT1VP5i0IX1N@6J0GTLi`5I0EX00`5I00H1FP5I0ET1F@5J
7>L70AP02acW0=L0eP3G0=H0e`3F0=LLi`2E09@00`2E010Li`0c0380<`0b03<Li`0A01004@0@7>L0
3@0>00dLi`<02P097>L01P0700HLi`0200<001cW008000147>L01P057>M_Bg=/Kd/Lifn>Lhi_SQcW
Kk5c/FnaLk4LifoDKm=_e6oC7>M[mFofJoE_mV_e7>MWmf_hIoM[n6OgJoQWmacWHoUWnF?iIoYSnFOi
HoUWnQcWGo]KnUokGoYOne_jGo]OnUokFoXLieOKEoaCfeOlEm]Go5?KEoaGfeOlDm]Go08Li`0:Bk]?
g4^kCma;^doLBk]?g4^k0005Ool00`00Oomoo`0XOol00`00Oomoo`04Ool000Moo`03001oogoo01Qo
o`05001oogoo0001^@027>L?0KX00`6J7>LLi`0:0IX27>L90ET00acW0AP160050AP00acW0=L0eP03
0=L00`3F7>L0U@0509D00acW03<0<`0203<00`0@7>L0400201001QcW00h03@0=00XLi`802P097>L0
1`0600HLi`03008001cW008000087>L01P067>McK6m<Lf`Li`=_SP0A7>M_/FnaKk4LifoDKm=_e6oC
7>M[mVofJoI_mV_f7>MWm`03JoP016OgJoQ[n1cW0f?i00IWnF?iHoUSnFOi7>L2GoX01EokGoYOnUoj
Go/00Uoj0QcW00eGfeOkEm]GneOKEo]GfeOkEm]GneOKEo/Li`02Bm`01ToLBm];g4_LCma;f`9;g003
Cma;f`0000Aoo`03001oogoo02Qoo`03001oogoo00Aoo`001goo00<007ooOol067oo00L007oo0001
^06i0KP1^@027>L07P6i0KX1^@6j0KT1^P6i0KX1^@6j0KT1^P6i0KX1^@6J7>L1VP5i0IX1N@6J0GT1
VP5i0IX1N@6J7>L1FP<1F@060EX1F@5I0ET1FQcW1`4H00PLi`3G0=H0e`3F0=L0eQcW0P2E01<0U02E
09DLi`0b03<0<P0c038Li`0@014041cW00d03P0=00XLi`0200X02AcW00H01`067>L00P03000Li`02
0000@AcW00H01AcWKd]cK1cWLhi_SW>?7>Mc/FnaLk4LifoDKm=_e6oCKm@LifofJoE_mV_eKoHLif_h
IoM[n6OgJoQWmacWHoUWnF?iIoYSnFOiHoUWnQcWGo]KnUokGoYOne_jGo]OnUok7>MGo5OKEoaCfeOl
Em]Go5?KEoaGfeOlDm/00QcW00i?g4^kCma;^doLBk]?g4^kCma;^doLBk]?g00017oo00<007ooOol0
:7oo00<007ooOol017oo0007Ool00`00Oomoo`0GOol01000Oomoo`001P6i0QcW3`6j0QcW2P6J00<L
i`5I0ET01`5I00<Li`4H0AP01@4H00<Li`3G0=H00`3G00<0eQcW09D0102E00<Li`0c03<00P0c00<0
41cW01000P0@00DLi`0=00h03AcW00802P097>L01P0600LLi`03008001cW008000077>L01@067>Mc
K6m<7>L00fn>010LifnaKk5_/AcWKm=_e6oCKm@LifofJoI_mV_fKoHLi`=[n004IoM[n6_h7>L3HoT0
1VOiHoUSnF?iIoTLi`9OnP05Go]OnUojGoYOn`02GoX03acWEo]GfeOkEm]GneOKEo]GfeOkEm]GneOK
7>M;f`02Bm`01ToLBm];g4_LCma;f`9;g006Cma;fd_LBma?g0000goo00<007ooOol0:7oo00<007oo
Ool017oo0007Ool00`00Oomoo`0GOol03000Ool0006i0KP1^@6h0KT1^06i0KP1^@8Li`0L0KT1^P6i
0KX1^@6j0KT1^P6i0KX1^@6j0KT1^P5i7>L1N@6J0GT1VP5i0IX1N@6J0GT1VQcW0EX30ET01P5J0ET1
F@5I0EXLi`L160087>L0e`3F0=L0eP3G0=HLi`80U@0B09@0U@2E7>L0<P0c0380<acW0140400A7>L0
3P0=00h02QcW0P0:04PLi`0700HLi`0200<001cW000Li`0500I_BacWKd]cK1cWLhm_SQcWKk5c/Fna
7>M_dfoDKm=_e1cWKoI[mFofJoE_mQcWJoQWmf_hIoM[n6Og7>MSnFOiHoUWnV?iIoUSnFOj7>MOne_j
Go]OnUokFoYOneojGo/LieOlEm]Go5?KEoaGfeOlDm]Go5OKEo`27>L04T^kCma;^doLBk]?g4^kCma;
^doLBk]?g4^kCma;^doL7>L000=oo`03001oogoo02Qoo`03001oogoo00Aoo`001goo00<007ooOol0
5goo00<007oo00002`6i0QcW3P6j0QcW2@6J0QcW205I00<Li`4H0AP01@4H00<Li`3G0=H00`3G00<L
i`2E09D00`2E00<Li`0c03<00P0c00<041cW01000P0@00DLi`0=00d02QcW00802P0:7>L01P06008L
i`02000Li`007>L200H01AcWKdacK6m<7>L00Vn>00lLifnaKk5_/AcWKmA_dfoDKm<Lif_fKoI[mVof
7>L00f_h00EWmf_hJoQWnAcW009Sn@06IoUSnF?iHoUWnAcW0Uoj00IOneojGoYOnUokGoX27>L03UOk
Em]GneOKEo]GfeOkEm]GneOKEo/LidoLBm/2Bm`01ToLBm];g4_LCma;f`9;g004Cma;fd_LBm`27>L0
1CnL001oogoo0000:Woo00<007ooOol01Goo0007Ool00`00Oomoo`0GOol200003P6h0KT1^06i0KP1
^@6h0KT1^06i0KP1^@6h0KT27>L06P6i0KX1^@6j0KT1^P6i0KX1^@6j0KT1^P6i0IXLi`6J0GT1VP5i
0IX1N@6J0GT1VP5i7>L30ET01P5J0ET1F@5I0EXLi`L160077>L0e`3F0=L0eP3G7>L00`2E0100U02E
7>L0<`0b03<0<QcW01004@0@7>L03@0>00dLi`802P157>L01`0600LLi`03000Li`007>L01@067>Mc
K6m;7>M_SW>>KhhLifnaLk4LifoDKm=_e6oC7>M[mFofJoE_mQcWJoQWmf_hIoM[n6OgIoXLifOiHoUW
nV?iIoUSnFOj7>MOne_jGo]OnUokFoYOneoj7>MCfeOlEm]Go5?KEoaGfeOlDm]Go5OK008Li`0?Cma;
^doLBk]?g4^kCma;^doLBk]?g4^kCma;^doL008Li`07?i/oW3nK@i`007oo0000:Woo00<007ooOol0
1Goo0007Ool00`00Oomoo`0GOol2000@0KT27>L=0KX27>L90IX00acW0ET1F@060ET27>L60AP00acW
0=L0eP030=L00acW09D0U@0209D00acW03<0<`0203<01P0@7>L0400@7>L03P803@0C00XLi`0:7>L0
1P0700HLi`02000Li`007>L01P057>M_C7=/7>L00Vn>00lLifnaKk5_/AcWKm=_e6oC7>M[mVofJoI_
mV_f7>L00V_h00EWmf_hJoQ[n1cW009Sn@06IoUSnF?iHoUWnAcW0Uoj01IOneojGoYOnUokGoXLieOK
Eo]GfeOkEm]GneOKEo]GfeOkEm/Lid_LCma;f`9;g006Cma;fd_LBma?g4_K0T_L00e?g4_K7>LLicnL
?i/oW3nK?i`oV`00Ool0000ZOol00`00Oomoo`05Ool000Moo`03001oogoo01Moo`0D0001^@6h0KT1
^06i0KP1^@6h0KT1^06i0KP1^@6h0KT1^06i0KP1^@8Li`0=0KT1^P6i0KX1^@6j0KT1^P6i0KX1^@6j
0GT00QcW00T1VP5i0IX1N@6J0GT1VP5i7>L00`5I00L1FP5I0ET1F@5J0ETLi`050AP021cW0=H0e`3F
0=L0eP3G7>L309D03`2D7>L0<P0c0380<acW0140400A7>L03P0=00XLi`0200X0@AcW00H01acW00<0
01cW000Li`0500HLig=/Kd/Lifn>LhlLig>aKk4LifoCKmA_dfoD7>M_mV_eKoI[mAcWIoM[n6OgJoQW
mf_h7>MWnF?iIoYSnFOiHoUWnQcWGo]KnUokGoYOne_jGo]OnQcWDm]Go5OKEoaCfeOlEm]Go5?KEo`0
0QcW00i;^doLBk]?g4^kCma;^doLBk]?g4^kCma;^doL0QcW00/oVd>L?i/oW3nK@i`oVcnL001oo`00
02Yoo`03001oogoo00Eoo`001goo00<007ooOol05goo00<001cW7>L04`6i0QcW306j00<1VQcW0IX0
1`6J0QcW205I00<Li`4H0AP00`4H00@Li`3G0=L0eP80e`037>L0U@2E00<0U@067>L0<`0c03<041cW
0P0@00DLi`0=00h03AcW00802P0>7>L01P067>L00P007>L001cW00I_C1cWKd`Li`9_SP0>7>M_/Fna
Kk4LifoDKm=_e1cWKoI[mVofJoHLi`9[n005IoM[n6_hJoPLi`02HoT01VOiHoUSnF?iIoTLi`9OnP05
Go]OnUojGoYOn`027>L02eOKEo]GfeOkEm]GneOKEo]GfeOk7>L00T_L00I?g4_KBma;g4oLBm/2Bm`0
4DoLBm];g4_LCm`LicnL?i/oW3nK?i`oVcnL?i/oW3nK?i`00P00:Woo00<007ooOol01Goo0007Ool0
0`00Oomoo`0GOol00`000KL1^0037>L04P6h0KT1^06i0KP1^@6h0KT1^06i0KP1^@6h0KT1^06i0KP1
^@8Li`0<0KT1^P6i0KX1^@6j0KT1^P6i0KX1^@6J0QcW00T1N@6J0GT1VP5i0IX1N@6J7>L00P5I00L1
FP5I0ET1F@5J0ETLi`050AP021cW0=H0e`3F0=L0eQcW09@309D03AcW03<0<P0c038Li`0@014041cW
00d03QcW00802P0n7>L01P077>L00`007>L001cW00DLifm;Lf`Lig>?KhhLifnaLk4LifoDKm=_e6_e
7>M[mFofJoDLifOgJoQWmf_hIoM[n1cWIoUSnFOjHoUWnF?iIoXLieokFoYOneojGo]KnUok7>MGo5?K
EoaGfeOlDm]Go5OKEoaCf`8Li`0>Cma;^doLBk]?g4^kCma;^doLBk]?g4^kCma;^`8Li`0<?i`oVd>L
?i/oW3nK@i`oVcnL?i]3W3nK0P00:Goo00<007ooOol01Woo0007Ool00`00Oomoo`0FOol01`000KL1
]P6g0KH1]`6i008Lia81^@8Li`/1^P030IXLi`6J00L1VP037>L1F@5I00H1F@037>L1604H00<16004
7>L0e`3G0=H20=L00acW09D0U@0209D01QcW03<0<`0c010Li`80400D7>L03@0=00XLi`0:7>L01`06
7>L00P007>L001cW00HLig=/Kd`Li`9_SP0?7>M_/Fna7>M_dfoDKm<Lif_fKoI[mVof7>M[n6Og00=[
n0047>MSnF?iIoT3HoT01FOi7>MOnUojGo/00eoj00iOnacWEo]GfeOkEm]GneOKEo]GfeOkEm/Lid_K
0T_L00I?g4_KBma;g4oLBm/2Bm`00doLBm];g0027>L03SnK?i`oVcnL?i/oW3nK?i`oVcnL?i/oW3nK
?i`2000YOol00`00Oomoo`06Ool000Moo`03001oogoo01Ioo`090001UP6g0IH1]`6F0KL1UP6i00<L
i`0A0KT1^06i0KP1^@6h0KT1^06i0KP1^@6h0KT1^06i0KP1^@027>L02`6i0KX1^@6j0KT1^P6i0KX1
^@6j0KT00QcW00L1VP5i0IX1N@6J0GT1VP027>L00`5I0EX1F@020ET00`5J0ETLi`050AP021cW0=H0
e`3F0=L0eQcW09@309D0=AcW03<0<P0c7>L04@0@7>L03@0>00dLi`0:7>L01P077>L00`027>L001cW
00DLifm;7>M_SW>>7>Mc/Fna7>M_dfoDKm<Lif_eKoI[mFof7>M[n6OgJoQWmf_h7>MWnF?iIoYSnFOi
HoT00QcW015One_jGo]OnUokFoYOnacWEoaCfeOlEm]Go5?KEoaGfeOl008Li`0=Bk]?g4^kCma;^doL
Bk]?g4^kCma;^doLBk/00QcW0193W3nK?i`oVd>L?i/oW3nK@i`oVcnL?i]3W3nK?i`oVd>L000YOol0
0`00Oomoo`06Ool000Moo`03001oogoo01Ioo`0<0001]`6f0KL1]P6g0KH1]`6f0KL1]P6i0acW406i
0QcW2P6j00<1VQcW0IX01`6J00<Li`5I0ET01@5I00<Li`4H0AP00`4H00HLi`3G0=L0eP3G7>L409D0
1QcW03<0<`0c010Li`8040047>L03@0=7>L200X031cW00H00acW00<Li`007>L01QcWLf`Li`9_SP0>
7>M_/Fna7>M_e6oCKm@LifofJoI_mQcWJoQWm`=[n0047>MSnF?iIoT3HoT01AcWGoYOnUojGo/00eoj
0QcW00aGneOKEo]GfeOkEm]GneOKEo/LidoLBm/2Bm`01ToLBm];g4_LCma;f`9;g00GCm`LiacW?i/o
W3nK?i`oVcnL?i/oW3nK?i`oVcnL?i/oW3nK?i`oVcnL?i/0000YOol00`00Oomoo`06Ool000Moo`03
001oogoo01Eoo`0@0001]`6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KT37>L03`6i0KP1^@6h0KT1
^06i0KP1^@6h0KT1^06i0KP1^@027>L02P6i0KX1^@6j0KT1^P6i0KX1^@6j0QcW00X1N@6J0GT1VP5i
0IX1NAcW0ET1FP<1F@030EX1FAcW00D160087>L0eP3G0=H0eacW09D0U080U@147>L0<P0c038Li`0@
014Li`0>00d02QcW00XLi`0700HLi`027>L001cW00DLifm;7>M_SQcWKk5c/AcWKmA_dfoD7>M_mV_e
KoHLif_hIoM[n6OgJoPLifOiHoUWnV?iIoUSnAcWGoYOne_jGo]OnUokFoXLieOKEoaCfeOlEm]Go5?K
EoaGf`8Li`0<Cma;^doLBk]?g4^kCma;^doLBk]?g4^k0QcW01<oW3nK@i`oVcnL?i]3W3nK?i`oVd>L
?i/oW3nK@i`oVcnL?i]3W0027>L00`00Oomoo`0WOol00`00Oomoo`06Ool000Moo`03001oogoo01Eo
o`0C0001]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0KH1]goo0KT00acW3P6i0QcW2@6j00<1VQcW
0IX01P6J00<Li`5I0ET01@5I00<Li`4H0AP00`4H00HLi`3G0=L0eP3G7>L409D01AcW03<0<`0@7>L0
0P0@00HLi`0>00XLi`0:7>L200H011cW00<Li`000QcW00E_C7=/7>M_SQcW009_/@0:7>M_dfoD7>M_
mV_fKoHLif_hIoL3JoP011cWHoUSnFOi0f?i00DLieojGoYOnUok00=OnP0>7>MGfeOkEm]GneOKEo]G
feOkEm/Lid_LCma;f`9;g006Cma;fd_LBma?g4_K0T_L01@LicnK?i`oVcnL?i/oW3nK?i`oVcnL?i/o
W3nK?i`oVcnL?i/oW3nK0QcW00<_FbmJ0000:Goo00<007ooOol01Woo0007Ool00`00Oomoo`0EOol0
5P000KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1^06i0QcW00h1^06i0KP1^@6h
0KT1^06i0KP1^@6h0KT1^06i0QcW00T1^@6j0KT1^P6i0KX1^@6j0KT00QcW00H1VP5i0IX1N@6J0GT2
7>L01`5J0ET1F@5I0EX1FAcW00D1600J7>L0eP3G0=H0eacW09D0U02E7>L0<`0b03<Li`0A010Li`0=
00hLi`0:7>L01`067>L00P8Li`0]00HLig=/7>McSfn>7>M_/AcWKm=_e6oC7>M[mFofJoDLifOgJoQW
mf_hHoTLif?iIoYSnFOiHoTLieojGo]KnUokGoYOne_j7>MGfeOlDm]Go5OKEoaCfeOl008Li`0<Bk]?
g4^kCma;^doLBk]?g4^kCma;^doL0QcW018oVcnL?i]3W3nK?i`oVd>L?i/oW3nK@i`oVcnL?i]3W3nK
?i`27>L01RmJ;e/_FRmK;eX002Moo`03001oogoo00Moo`001goo00<007ooOol05Goo01P0006f0KL1
]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0KT37>L=0KT27>L80KX00`6J7>L1
VP060IX00acW0ET1F@040ET00acW0AP160020AP01QcW0=L0e`3G0=HLi`@0U@077>L0<`0c010Li`0@
7>L00P0=00L02QcW7>L01P077>L00`027>L01P057>M_C1cWKhhLi`9_/@097>M_e6oC7>M[mVofJoHL
ifOg00=[n004HoTLif?iIoT3HoT01AcWGoYOnUojGo/00Uoj0QcW00UGfeOkEm]GneOKEo]GfeOk7>L0
0T_L00I?g4_KBma;g4oLBm/2Bm`05DoLBm/LiacW?i`oVcnL?i/oW3nK?i`oVcnL?i/oW3nK?i`oVcnL
?i/oW0037>L022mK;eX_FbmJ;e/_FRmK000WOol00`00Oomoo`07Ool000Moo`03001oogoo01Aoo`0L
0001UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g0KP37>L0
5P6h0KT1^06i0KP1^@6h0KT1^06i0KP1^AcW0KX1^@6j0KT1^P6i0KX1^@6j0QcW00P1N@6J0GT1VP5i
0IXLi`5J0`5I00<1FP5I7>L0104H00HLi`3G0=H0e`3F7>L209D04@2D7>L0<P0c038Li`0@014Li`0>
00XLi`0:7>L01QcW00800QcW02X01QcWLf`Lig>>7>Mc/AcWKmA_dfof7>M_mV_e7>MWmf_hIoM[n6Og
7>MSnFOjHoUWnF?i7>MOnUokFoYOneojGo/LieOlEm]Go5?KEoaGfeOlDm/27>L02doLBk]?g4^kCma;
^doLBk]?g4^kCm`00QcW014oVd>L?i/oW3nK@i`oVcnL?i]3W3nK?i`oVd>L?i/oW3nK008Li`0;;e/_
FRmK;eX_FbmJ;e/_FRmK;eX0000WOol00`00Oomoo`07Ool000Moo`03001oogoo01Aoo`0M000LiacW
7>L1]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P020KT37>L:
0KT27>L90KX00acW0IX1VP040IX00acW0ET1F@040ET00acW0AP160020AP01QcW0=L0e`3G0=HLi`<0
U@077>L0<`0c010Li`0@7>L00P0=00HLi`0:7>L01QcW00<27>L01@067>LLifn>7>L00Vna00PLifoC
Km@LifofJoHLifOg0f_h00AWmacWHoUWn@=Sn@057>MOnUojGoYOn`02GoX02acWEo]GfeOkEm]GneOK
Eo]GfacWBm/00T_L00I?g4_KBma;g4oLBm/2Bm`27>L043nL?i/oW3nK?i`oVcnL?i/oW3nK?i`oVcnL
?i/oW3nK0acW00d_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/0000WOol00`00Oomoo`07Ool000Moo`03
001oogoo01Aoo`04000H01`00IH57>L06@6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1
]`6F0KL1UP6g0IH1^@6h00<Li`090KP1^@6h0KT1^06i0KP1^@6h008Li`080KX1^@6j0KT1^P6i0KX1
^@8Li`050IX1N@6J0GT1VP027>L30ET00`5J0ETLi`040AP01QcW0=L0eP3G0=HLi`80U@0?09@Li`0b
03<Li`0A010Li`0=7>L02QcW00HLi`02008Li`0N00HLiacWKhhLifna7>M_dfoD7>M_mV_eKoHLif_h
IoM[n6Og7>MSnFOjHoUWnF?i7>MOnUokFoYOneoj0QcW00MGo5OKEoaCfeOlEm]Go0027>L074^kCma;
^doLBk]?g4^kCma;^doLBk/LicnK?i`oVd>L?i/oW3nK@i`oVcnL?i]3W3nK?i`oVd>L0QcW010_FRmK
;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX002Moo`03001oogoo00Moo`001Woo00<007ooOol05Goo
00@001P0600L00<H00037001]QcW00<Li`0F0KL1]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0KH1
]`6f0KL1]P6g0KH20KT27>L90KT27>L80KX27>L50IX00acW0ET1F@030ET00acW0AP160020AP01AcW
0=L0e`3G7>L00`2E00TLi`0c03<041cW010Li`0>00X00QcW00<01`027>L00acW00acK1cWKhhLifna
7>M_e6_f7>M[mVof7>L3JoP016Og7>MSnFOi0f?i00hLieojGoYOnUokGoXLieOKEo]GfeOkEm]GneOK
0QcW00I?g4_KBma;g4oLBm/2Bm`00doLBm];g0027>L03cnK?i`oVcnL?i/oW3nK?i`oVcnL?i/oW3nK
?i`oV`027>L04bmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FP0002Ioo`03001oogoo
00Moo`001Woo00<007ooOol057oo00h001`0600L01P0700H01`0600L01P0700H01`01AcW01D1]`6F
0KL1UP6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g0IH1]bP00KT00acW00P1^@6h0KT1^06i0KP1^@6h
0QcW00l1^P6i0KX1^@6j0KT1^P5i7>L1N@6J0GT1VP5i7>L00`5I00<1FP5I7>L0104H00DLi`3G0=H0
eacW00<0U@087>L0<`0b7>L041cW00d03P8Li`0300H01acW00<Li`0_Kd/LiacWLk4LifoDKm<Lif_e
KoHLif_hIoM[n6Og7>MSnFOjHoUWnF?i7>MOnUokFoYOneoj7>MCfeOlEm]Go5?KEoaGfacWBk]?g4^k
Cma;^doLBk]?g4^kCma;^`027>L03T>L?i/oW3nK@i`oVcnL?i]3W3nK?i`oVd>L?i/37>L05BmJ;e/_
FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/0000UOol00`00Oomoo`08Ool000Ioo`03
001oogoo01Aoo`03000H01`000<H0005700H01P0600L000360001A`0600H01P070001AcW0141]`6f
0KL1]P6g0KH1]`6f0KL1]P6g0KH1]`6f0KL1]P6g0081^@<Li`L1^@8Li`L1^P8Li`@1VP037>L1F@5I
00<1F@037>L1604H008160057>L0e`3G0=LLi`0309D02acW03<041cW010Li`0=7>L02QcW00H01AcW
00U_SQcWKk4LifoC7>M[mVof7>L00f_h00AWmacWHoUWn@=Sn@0=7>MOnUojGoYOneoj7>MGfeOkEm]G
neOKEo/00QcW00=;g4oLBm/00T_L00E?g4_KBma;g4oL008Li`0>?i/oW3nK?i`oVcnL?i/oW3nK?i`o
VcnL?i/oW08Li`0E;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ008Li`03
001oogoo02=oo`03001oogoo00Qoo`001Woo00<007ooOol057oo01P001`0600L01P0700H01`0600L
01P0700H01`0600L01P0700H01`0600L01P00KL57>L04@6g0IH1]`6F0KL1UP6g0IH1]`6F0KL1UP6g
0IH1]`6h0KT00acW00H1^@6h0KT1^06i0KP27>L0306j0KT1^P6i0KX1^@6J7>L1VP5i0IX1N@8Li`81
F@030EX1FAcW00@160057>L0e`3F0=LLi`0209D021cW0380<acW014Li`0>00X27>L00`077>LLi`04
7>L046na7>M_dfoD7>M_mV_e7>MWmf_hIoLLif?iIoYSnFOi0QcW00AOnUokFoYOn`8Li`0ADm]Go5OK
EoaCfeOl7>M?g4^kCma;^doLBk]?g4^kCma;^`027>L03CnL?i]3W3nK?i`oVd>L?i/oW3nK@i`oVcnL
00<Li`0D;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FP<Li`035_PJn@0002Eo
o`03001oogoo00Qoo`001Woo00<007ooOol057oo00D001P0600H01`000<H0005700H01P0600L0003
60001A`0600H01P070000aP000DL01P0600H006g00DLi`0=0KL1]P6g0KH1]`6f0KL1]P6g0KH1]`6f
@0000P6i0acW1@6i0QcW1P6j0QcW106J00<Li`5I0ET00P5I00<Li`4H0AP00P4H00@Li`3G0=LLi`<0
U@077>L0<`0@7>L041cW00d00QcW00<01QcW7>L011cW00M_/AcWKm@LifofJoHLi`02JoP016Og7>MS
nFOi0V?i00<LieokGoX00Uoj00QOnacWEo]GfeOkEm]GneOK0QcW0T_L00M?g4_KBma;g4oLBm];g002
7>L03CnK?i`oVcnL?i/oW3nK?i`oVcnL?i/oW3nK008Li`0D;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ
;e/_FRmK;eX_FbmJ;e/_FP<Li`DJn003001oogoo02=oo`03001oogoo00Qoo`001Woo00<007ooOol0
4goo02<001P0700H01`0600L01P0700H01`0600L01P0700H01`0600L01P0700H01`0600L01P0700H
01`0600L01P0700H006g00@Li`0>0IH1]`6F0KL1UP6g0IH1]`6F0KL1UT000KP1^@8Li`050KP1^@6h
0KT1^0027>L0306j0KT1^P6i0KX1^AcW0GT1VP5i0IXLi`81F@030EX1FAcW00<1600>7>L0eP3G0=HL
i`2D09DLi`0c038Li`0@7>L03@8Li`0300LLiacW008Li`0fKhhLiacWKmA[mAcWJoDLifOgJoQWmfOi
7>MWnV?iIoTLieokGoYOne_jGo/LieOlDm]Go5OKEoaCfacWBk]?g4^kCma;^doLBk]?g4^kCm`Lid>L
?i/oW3nK@i`oVcnL?i]3W3nK?i`oVd>L0QcW018_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_
FbmJ;e/47>L02AKh6_TFn1[i5_PJnAKh6_T0000UOol00`00Oomoo`08Ool000Ioo`03001oogoo01=o
o`04000H01P0700360001A`0600H01P070000aP000DL01P0600H01`000<H0005700H01P0600L0003
60001A`0600H01P070000aP01AcW00T1]P6g0KH1]`6f0KL1]P6g0KH00P6i0acW106i0QcW1@6j0QcW
0`6J00<Li`5I0ET00P5I00HLi`4H0AP161cW0=H20=L01QcW09D0UAcW03<0408Li`0300h02QcW00HL
i`06Kk4LifoC7>M[mQcW0V_h00AWmf?i7>MWn@9Sn@037>MOneoj009OnP07Go/LieOkEm]GneOKEo/0
0QcW00E;fd_LBma?g4_K009;g00?Cma;facW7>LoW3nK?i`oVcnL?i/oW3nK?i`oVcnL00<Li`0A;e/_
FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_F`037>L<6_P00`00Oomoo`0ROol00`00Oomoo`09
Ool000Ioo`03001oogoo01=oo`03000LiacW00TLi`0P700H01`0600L01P0700H01`0600L01P0700H
01`0600L01P0700H01`0600L01P0700H01`0600L01P0700H00DLi`090IH1]`6F0KL1UP6g0IH1^@6h
00<Li`030KP1^@6h008Li`090KX1^@6j0KT1^QcW0IX1N@6J008Li`030ET1FP5I008Li`81600=7>L0
eP3G0=HLi`2D09DLi`0c7>L04AcW00h021cW015_dacWJoDLifOgJoQWmf_h7>MWnV?iIoTLieokGoYO
ne_j008Li`0?EoaCfeOlEm]Go1cWCma;^doLBk]?g4^kCma;^doL008Li`0;?i]3W3nK?i`oVd>L?i/o
W3nK@i`oV`027>L04BmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/00acW014JnAKh6_TF
n1[i5_PJnAKh6_TFn1[i5_PJnAKh6_TFn00002=oo`03001oogoo00Uoo`001Woo00<007ooOol04goo
00<002@0900022@000<H01cW7>L04QcW00<H01`060000QP000DL01P0600H01`000<H0004700H01P0
60057>L01@6f0KL1]P6g@0000P6i0acW0P6i0QcW106j0QcW0`6J00<Li`5I0ET00P5I00LLi`4H0APL
i`3F0=LLi`0209D00acW03<040027>L0100=7>LLi`030acW00]_/AcWKoHLifof7>M[n6OgJoPLifOi
009Sn@037>MOneoj009OnP067>MGfeOkEm]GneOK0QcW00I?g4_KBma;g4oLBm/2Bm`27>L02cnL?i/o
W3nK?i`oVcnL?i/oW3nK?i`00QcW010_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX_F`<Lia<J
n003001oogoo025oo`03001oogoo00Uoo`001Woo00<007ooOol04goo00D002@0900T02P000<T0005
:00T02@0900X000390001BP0900T02@0:0000b@000DX02@0900T02P000<T01DLi`03600LiacW00<L
i`050IH1]`6h0KT1^0037>L03P6h7>LLi`6j0KT1^P6i7>L1N@6J0GTLi`5I0EX20ET03AcW0AP161cW
0=H0eacW09D0U1cW038Li`0@00<Li`0300HLiacW008Li`0OKm@Lifof7>M[n6OgJoPLifOjHoUWnAcW
Go]OnUokFoXLieOKEoaCfeOlEm/Lid^kCma;^doLBk]?g4^kCm`00QcW00XoVcnL?i]3W3nK?i`oVd>L
?i/oW0<Li`0?;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK00<Li`0G6_TFn1[i5_PJnAKh6_TF
n1[i5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_P0000SOol00`00Oomoo`09Ool000Ioo`03001oogoo
01=oo`03000T02@002hT00lLi`<1^@8Li`030KTLiacW00<1^P8Li`81VP037>L1F@5I0081F@077>L1
604H7>L0eP3G7>L00P2E00LLi`0@7>LLi`0:7>L01`057>L01fof7>M[n6OgJoPLifOi009Sn@037>MO
neoj009OnP057>MGfeOkEm]Gn`027>L00d_LCma;f`02Bm`03ToLBm];g1cW?i`oVcnL?i/oW3nK?i`o
VcnL?i/27>L03RmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FRmK;eX47>LI6_P00`00Oomoo`0QOol00`00
Oomoo`09Ool000Ioo`03001oogoo01=oo`03000T02P000<T0005:00T02@0900X000390001BP0900T
02@0:0000b@000DX02@0900T02P000<T0005:00T02@0900X000390000bP0900T00087>L02BP0;00X
02`0:00/02P0;00X00027>L3@0057>L00`6i7>LLi`037>L00`6j0KT1^P027>L0105i7>LLi`5J0P5I
00XLi`4H0APLi`3F0=LLi`2E7>L0<`8Li`0300dLiacW00<Li`0>JoDLiacWJoQWmf_h7>MWnV?iIoTL
ieokGoYOn`8Li`0=Em]Go5?KEo`LidoLBk]?g4^kCma;^doLBk/00QcW00Q3W3nK?i`oVd>L?i/oW3nK
0acW00d_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FP037>L07RmJ6_TFn1[i5_PJnAKh6_TFn1[i5_PJ
nAKh6_TFn1[i5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_P002=oo`03001oogoo00Uoo`001Woo00<0
07ooOol04Woo00<002@0900082@01acW00P`006f0ML1]`7G0KH1ebP00QcW2BP000<Lid00@0001D00
0acW00=l01cW7>L00QcW0P6j00D1VQcW0IX1VQcW00<1F@067>L1604H7>L0eQcW0P2E00<Li`0@7>L0
1acW00I[mQcWIoM[n1cWIoT2HoT02AcWGo]OnUoj7>MGneOKEo]Gf`027>L2Bm`01DoLBm];g4_LCm`0
0QcW00PoVcnL?i/oW3nK?i`oVcnL0QcW00d_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ;e/_FP037>L00bmJ
6_PJn00J6_P37>L00`00Oomoo`0POol00`00Oomoo`0:Ool000Ioo`03001oogoo015oo`03O00002P0
00<T0005:00T02@0900X000390001BP0900T02@0:0000b@000HX02@0900T02P090087>L04C00;00L
iacW<001]P7G0KH1e`6f0ML1]P7G0KH1e`6f0ML00acW00L/02P0;00X02`0:00/00027>L6@00011cW
D61@@06i0W`00acW00L1^P6i7>LLi`6J7>L1FP020ET02AcW0APLi`3G0=HLi`2E7>L0<P027>L01@0:
7>Ml01cWKoH00QcW01MWmf_h7>MWnV?iIoTLieokGoYOnacWEoaGfeOlDm/Lid^kCma;^doLBk]?g4^k
008Li`08?i`oVd>L?i/oW3nK@i`oV`8Li`0<;e/_FRmK;eX_FbmJ;e/_FRmK;eX_FbmJ0acW01/Fn1[i
5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_P01AcW10008Woo
00<007ooOol02Woo0006Ool00`00Oomoo`0AOol00g`0000T000A90087>L7<0037>L4O0003P6f0ML1
]`7G0KH1e`6g0ML1]P7G0KL1e`6f:0027>L7:0027>L5@0027>L3D603O0027>L20KX00acW0IXLi`03
0ET02AcW0APLi`3G0=HLi`2E7>L040027>L2O0037>L016OgJoPLifOi0V?i00PLieokGoYOnQcWEo]G
feOk0QcW00I;fd_LBma?g4_KBm`27>L01cnK?i`oVcnL?i/oW3nK00<Li`0;;eX_FbmJ;e/_FRmK;eX_
FbmJ;e/_FP037>LI6_P57>L9000ROol00`00Oomoo`0:Ool000Ioo`03001oogoo015oo`05EQ@002@0
900X000390001BP0900T02@0:0001acW00``02`0<00/0300;00`02`0<00/0300;0047>L00e[lE_]J
o003Ea`8O000207G0KH1e`6f0ML1]P7G0KH37>L01RP0;00X02`0:00/008Li`E000097>M@@5APD41@
H1cWG>1l01cW009l00@Li`81F@077>L161cW0=L0eQcW09D00acW0W`00QcW00UWmf_hHoTLif?iIoTL
ieokGoX00QcW00YGo5OKEo`LidoLBk]?g4^kCma;^`8Li`07@i`oVcnL?i]3W3nK?i`00QcW00X_FRmK
;eX_FbmJ;e/_FRmK;eX_F`@Li`0F5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_PJnAKh6_TFn1[i5_PJ
nAKh6_T67>L>000ROol00`00Oomoo`0:Ool000Ioo`03001oogoo015oo`03COD002@0008T00PLia4`
008Li`06<00LiacWF_]Fne[k25LL15<M1G`000H1e`6f0ML1]`7G:0027>L6:0027>L4@0027>L3D600
1AcWG>1Lh5cP7>L00W`000<Lig`07>L00P5I00XLi`4H7>L0eacW09DLi`0@7>Ml00<Li`04JoQSnAcW
HoT27>L01UokGoXLieOKEo]Gf`8Li`0>Cma;fd_LBma?g4_K7>LoVcnL?i/oW3nK?i`oV`8Li`09;e/_
FRmK;eX_FbmJ;e/_FRmK00<Li`03;e/Jn1[h018Jn0DLia@0029oo`03001oogoo00Yoo`001Woo00<0
07ooOol04Woo01X001cW7>LLib`0<00/0300;00`02`0<00/0300;00`02`0<00/0300;00`02`0<00/
03000acW0SP000HLieKkF_aFne[lE_/7Ea`00e<MEaeC7@02Dad01ELMDae??T/mCch00g`000D1e`6f
0ML1]R`000<Li`06;00X02`0:01001cW1D0000DLieAPD41@H1cW00=Lh0067>MY@FE1ID5l01cW0W`0
00HLi`4H7>L0eacW09D3O0027>L04f_hIoLLif?i7>MKnUokGoXLie?KEoaGfacWBk]?g4^kCma;^doL
008Li`05?i]3W3nK?i`oV`037>L022mJ;e/_FRmK;eX_FbmJ;e/37>L04bmK5_PJnAKh6_TFn1[i5_PJ
nAKh6_TFn1[i5_PJnAKh6_TFn1[i00DLiaX0021oo`03001oogoo00]oo`001Woo00<007ooOol04Woo
00<00300<00053000acW0cP00QcW00IFne[kE_]JneKkF_/7Ea`7Dad6Cch3O0001@7G0KH1e`6g:000
0QcW12P00QcW140000@Lie1PD61@H08Li`9Lh0077>MU@FE1ID4LiffS7>L01W`000@40@@0O00Li`9[
n0057>MSnAcWGoYOn`027>L01eOKEo/LiacWBma?g4_K009;g08Li`05?i`oVcnL?i/oW0027>L022mJ
;e/_FRmK;eX_FbmJ;e/37>L00bmK6_PJn00>6_P57>LO000POol00`00Oomoo`0;Ool000Ioo`03001o
ogoo019oo`0E000`02`0<00/0300;00`02`0<00/0300;00`02`0<00/0300;00`02`0008Li`<h000;
=00LiacWF_]Fne[lE_]Jo5KkF_aFn`06Ea`01ELMDaeC7E<MEad00U<M00E;?DlnCci??T/m009??P03
Acm3?TLo00Al00030KH1ebP000<Li`03:00/02P0008Li`=0008Li`04D41@H5107>L2G>001QcWJD5U
@AcWJH9]X`<Li`0G104Li`@1100Lig`07>MWmacWHoTLie_jGo/LieOlDm]Go1cWCma;^doLBk]?g002
7>L013nK?i`oVd>L0acW00L_FbmJ;e/_FRmK;eX_F`037>L03a[i5_PJnAKh6_TFn1[i5_PJnAKh6_TF
n1[i5_PJn@057>LT000POol00`00Oomoo`0;Ool000Ioo`03001oogoo019oo`03000`030000l`00<L
i`Dh000:7>MJfU[JF]YJneKkF_]Fne[kE_/7Ea`6Dad7Cch3Acl01DLnAcm7?dLoAch00g`000<1]P7G
:0000QcW0bP00QcW0d0000DLie1PD61@H1cW009Lh0067>MU@FE17>MYXVfS0acW00h40AcW7>LLig`0
JoPLif?i7>MOnUok7>MGneOK0QcW0T_L00Q?g4_K7>LLicnL?i/oW3nK0QcW00H_FbmJ;e/_FRmK;eX4
7>L<6_P67>LY000POol00`00Oomoo`0;Ool000Ioo`03001oogoo019oo`0?000`02`0<00/0300;00`
02`0<00/0300;00`02`000<Li`8h0004=00h03P0>0027>L02U[JF_]FfU[kE_]Jo5KkF_aFne[l1ULL
0e<M00AG7E<MDaeC7@=??P0?Bce??TlnAcm3?TLoAci7?d<nAcm7?TLo=alk7cLO00=l00070KH/01cW
7>LX02`0@0000QcW0T000QcW00=@H5107>L00UcP00@LifU1ID4Li`9l000J7>L40AcW200Li`P0O00L
if?i7>MKnUok7>MGo5?K7>M;^doLBk]?g4^k7>LoVd>L?i/oW08Li`05;eX_FbmJ;e/_FP037>L02bmJ
6_TFn1[i5_PJnAKh6_TFn1[i5_P01AcW;`0087oo00<007ooOol02goo0005Ool00`00Oomoo`0BOol0
0`00<00`000;<0027>L8>0027>L3F]X025[KF]YJneKkF_]Fne[kE_/6Ea`6Dad6Cch3Acl01DLnAcm7
?dLoAch00c/O00Dg7c/O>alk7cLO00=l0007:00LiacW7>LX04007>L00d0000@Lie1PD60Li`9Lh005
7>MU@FE17>MYXP07O0000f?i7>MOnP027>L015Ok7>LLid_K0T_L00E?g1cW7>LoVcnL00<Li`04;e/_
FRmK;eX37>L00bmJ6_PJn0066_P57>Ld000POol00`00Oomoo`0;Ool000Eoo`03001oogoo019oo`0;
000/0300;00`02`0<00/0300;00`00037>L00cP0=00h0002>0000c@0>00h00037>L035[IF_]FfU[k
F]YJneKkF_aFne[lE_]Jo0EG709C7@04EaeC7E<MDad3Cch05d/mCci??TLo@ci7?dLnAcm3?TLo=alk
7cLO>alg7c/O=alk7cLO9_hRgRKo9]h00g`000@X01cW7>L/008Li`9000047>M@H5107>L2G>001AcW
JD5U@AcWJH800QcW00if9QcWO01l01cWFoXLieOKEo`LidoLBk]?g4^k0QcW00PoW3nK7>LLibmK;eX_
FbmJ0acW00L_FQ[i5_PJnAKh6_TFn0057>L_00000goo500D000650000`00Oomoo`0MOol00`00Oomo
o`0<Ool000Eoo`03001oogoo019oo`03000`030000D`00<Li`Th008Li`03F]XLie[I009JfP09F]]J
fU[JF]YJneKkF_]Fne[k00IG70EC7@E??P05Aci7?dLoAcm7?P02Acl00c/O=alk7`02>al03CLO>alV
gRKn9]hVoRKN9_hVgRKn9]hVoRKN00=l00DLi`04@00LiacWD6027>L01UcP7>MU@FE17>MYXP8Li`06
O01oog`0GoXLieOK0QcW00=?g4_KBm`00QcW00LoVacW7>LLibmJ;e/_FP037>L00bmJ6_PJn0026_P5
7>LT00000acWBY/D000F50000`00Oomoo`0MOol00`00Oomoo`0<Ool000Eoo`03001oogoo019oo`06
000/0300;00`02`00QcW00<h03@0>0000SP000Pd03P0>00h03@0>00Lid0R0QcW00eJfE[JF]UJne[J
F_]FfU[kE_]Jo5KkF_aFn`06Ea`01ELMDaeC7E<MEad00Tln01A;?DlnAci7?d<nAcm7?TLo=alk7cLO
>alg7bKo9]hVoR;N9_lVgRKn2Woo00<1]W`0O0000W`00acW00U001cWD41DH1cWG>0LifU1ID400acW
00Ul07ooOoml05OK7>M;^doLBk/00QcW00E3W1cW7>LoVbmK00@Li`03;eXJnAcW00DLiaT00003O000
01@0008D00037>LD01@0024D0003001oogoo01eoo`03001oogoo00aoo`001Goo00<007ooOol04Woo
00<00300<0000acW2cP00QcW00@l8C`17>MJf@IJfP07F]]JfU[kE_]JneKkF_/01ELL1E<M14ln00E7
?TLoAcm7?dLn00<k7aQoo`040KH1eg`0O0047>L2D6001QcWG>0LifE17>M]X`8Li`=oo`03O01;g4oL
008Li`04?i/LiacW;e/37>L00bmK7>LLi`037>LB000f50000`00Oomoo`0MOol00`00Oomoo`0<Ool0
00Eoo`03001oogoo019oo`04000LiacW=003>0001C@0>00h03P0=0000cP000Dd01cW?0508S`1008L
i`0>F]YJfE[JF]UJneKJF_]JfU[kE_]Jo5KkF_aFn`EG70=C7@0:Eae??TlnBce??TLnAcm3?TLoAchP
Ool3O0037>L00eAP7>MLh0037>L00ffSO01oo`03Ool00g`07>LoW0027>L012mJ7>LLig`00acW00@0
01cW7>Ml00<D008Lid<D0003001oogoo01ioo`03001oogoo00aoo`001Goo00<007ooOol04Woo00<0
03P0>0002cP00QcW00<l0C`Q?0400acW0U[J00AJfE[JF]YJf`9JfP05E_]JneKkF_]Fn`05Ea`5Dad3
Cch014LnAcm7?dLo9Goo2W`01Woo1g`03Goo@a@000<007ooOol07Woo00<007ooOol037oo0005Ool0
0`00Oomoo`0BOol00`00=00h0002>0001C@0>00h03P0=0000SP00QcW00A08S`1@28l0@8Li`0?F[TL
ie[JF]UJfU[IF_]JfU[kE]YJo5KkF_aFne[l00EG709C7@08EaeC7DlnBce??TLnAcm3?U=oo`05:00/
02`0;00X0002;00d50000`00Oomoo`0MOol00`00Oomoo`0=Ool000Eoo`03001oogoo019oo`03000h
03P000Ph00067>Ll0D0Q?04l8C`10QcW0UZi00<Lie[IF]X01E[J00IJfeKkF_]Fne[kE_/4Ea`4Dad3
Cch00dLnAcmoo`1GOol2@00A;00U50000`00O01oo`0MOol00`00Oomoo`0=Ool000Eoo`03001oogoo
019oo`04000h03P0=003>00033@0>00LiacW?0508S`1@28l0AcW@6DLi`9J^@0>7>MJfU[IF]YJfE[k
E]YJne[JF_aFne[lE_]Jo0AG7007DaeG7E<MDae;?DlnAch0G7oo00I003`0@00l02`0:003;0001BP0
;00/02`0:0000b`000DX02`0;00/02P000</0005:00/02`0;00X0002;00F50000`00DUMl000MOol0
0`00Oomoo`0=Ool000Eoo`03001oogoo019oo`03000h03P000Dh00097>Ll8C`1@24l0C`Q?04Lid1U
008Li`9J^@04F]XLie[JF]T2F]X01e[KF]YJfUKkF_]Fne[k00AG70AC7@9??P03Acioogoo05ioo`=0
0003?01002`002d/0004001BEacWO00LOol00`00Oomoo`0=Ool000Eoo`03001oogoo019oo`03000d
03P0008h000>=00LiacW@28l0D0R?0508S`17>M0IAcWFYPLi`9J^@0=F]TLie[IF]YJfE[kF]YJneKJ
F_aFne[lE_/015LL00EG7E<MDae;?Dln06Aoo`08?01003`0@00l0400?010008/0005:00/02`0;00X
0003;0001BP0;00/02`0:0000b`000DX02`0;00/02P000</0005:00/02`0;00X0003;0001BP0;00/
02`0:0000R`000@007`0O01l01aoo`03001oogoo00eoo`001Goo00<007ooOol04Woo00@003P0>00h
008Li`0=?04l8C`1@24l0C`Q?04Lid1UA6DLieZi7>L00eZi00<Lie[JF]X015[J00EJfeKkF_]Fne[k
00AG709C7@03Ccioogoo06Ioo`03@00l040000900005?0100400@00l000U;0001000FUDLiacW6goo
00<007ooOol03Woo0005Ool00`00Oomoo`0BOol05000>00h01cW@28l0D0R?0508S`1@28l0AcW@6E4
QQcWF[UJV5Zi7>L2F[T031cWF]UJfU[IF_]FfU[kF]YJo5KkF_aFn`=G70=C7Faoo`0<@00l0400?010
03`0@00l0400?01002P00b`000DX02`0;00/02P000</0005:00/02`0;00X0003;0001BP0;00/02`0
:0000b`000PX02`0;00/02P0001BEQcW77oo00<007ooOol03Woo0005Ool00`00Oomoo`0BOol03P00
7>LLid0Q?04l8C`1@24l0C`Q?04Lid1UA6D27>L015ZHF[QJ^AcW0UZi00<Lie[JF]T00U[J00IJfe[J
F_]Fne[kE_/4Ea`2Dae^Ool014aQ@01003`00d0000Dl0400@01003`0009001d/0003000LiacW01ao
o`03001oogoo00ioo`001Goo00<007ooOol04Woo00h003`1@28l0D0R?0508S`1@28l0AcW@6E4QT1U
0QcW00AJ^EZHF[TLi`9J^@0;7>MJfE[JF]UJne[JF_]Fne[lE_]Jo003Ea`2DaeaOol04dQQC64l0400
?01003`0@00l0400?01003`0@00l0400?00/02P000</0005:00/02`0;00X0003;0001BP0;00/02`0
:0000b`000DX02`0;00001cW01eoo`03001oogoo00ioo`001Goo00<007ooOol04Woo00d0040Q?04l
8C`1@24l0C`Q?04Lid1UA6E0I@037>L015ZHF[UJ^AcW0UZi00<Lie[JF]X015[J00AJneKkF_]Fn`=G
709C7G9oo`=<H@=00005?0100400@00l0003@0001S`0@0100400?01001@/0003000Ligoo01aoo`03
001oogoo00ioo`001Goo00<007ooOol04Woo00`003`1@28l0D0R?0508S`17>M0IDB6@6D27>L01UZH
FYLLieZHF[TLi`9J^@0;7>MJfE[JF]T005KJF_]Fne[lE_]Jo002Ea`00e<MEaeoo`1dOol05TaQB65<
HC`0@00l0400?01003`0@00l0400?01003`0@00l0400?01003`00b`000DX02`0;00/02P000</0006
:00/02`0;00X00007Woo00<007ooOol03Woo0005Ool00`00Oomoo`0BOol03P00?24l0D0Q?04l8C`1
7>M0IDAU@6DLidC87>L2FYP011cWF[QJV1cW0UZi00XLie[JF]UJfP00F]]JfU[kE_]Jn`=G7003Daeo
ogoo07Eoo`E<H@05?0100400@00l0003@0001C`0@0100400?0000d0000Dl0400@01003`000//0003
001oogoo01]oo`03001oogoo00moo`001Goo00<007ooOol04Woo01@003`1@28l0D0R?04Lid1UA8I0
IDB67>M92acWFYQJUacWFYQJ^AcW0UZi00XLie[IF]YJfAcWF]YJneKkF_aFn`9G7003EaeC7Goo07Mo
o`0NE>E8HDaQB65<HDQQ@00l0400?01003`0@00l0400?01003`0@00l0400?01003`0@00l0400?010
02P00b`000@X02`0;00001eoo`03001oogoo00moo`001Goo00<007ooOol04Woo00`0040Q?04l8C`1
7>M0IDAU@6E4IAcWA<T27>L01UZGFYPLieZiFYPLi`9J^@057>MJfU[JF]X00002F]X00e[kE_]Jn`02
Ea`00e<MOomoo`1hOol00eCUC65<H@04C642@0001C`0@0100400?0000d0000Dl0400@01003`000=0
0005?0100400@00l0003@0000c`0@000000MOol00`00Oomoo`0?Ool000Eoo`03001oogoo019oo`0B
000l0D0R?04Lid1UA8I0IDB67>M8bDS[7>MJMacWFYLLieZH0UZi00hLieZi7>MJfE[JF]UJneKJF_]F
ne[lE_]G75<MO7oo02=DiE3UC658HDaQB65<HDQQC64l0400?01003`0@00l0400?01003`0@00l0400
?01003`0@00l0400?01003`0@00l000001eoo`03001oogoo00moo`001Goo00<007ooOol04Woo00/0
03`Q?04Lid1UA6E0IDAU@6DLidC8008Li`0<FWLLieZHFYLLieZHF[TLieZi7>MJfU[I0U[J00AJfe[J
F_]Fn`9G77ioo`9Di@Q<H@=00005?0100400@00l0003@0001C`0@0100400?0000d0000Dl0400@010
000001eoo`03001oogoo00moo`0017oo00<007ooOol04goo00/003`17>M0IDB6@6E4QT1U7>M4Z4S9
008Li`05EWLLieZGFYPLi`02F[T02acWF[TLie[IF]YJfE[kF]YJo5KkF_`00ULLOgoo021DiE3UE>E8
HDaQB65<HDQQC658HDaQB65003`0@00l0400?01003`0@00l0400?01003`0@00l0400?01000007Goo
00<007ooOol047oo0004Ool00`00Oomoo`0COol02P007>M0IDAU@6E4ID1U7>M4b4S90acW00]JMacW
FYQJV1cWFYQJ^1cWF[UJfAcW00AJfP04E_]JneKkEab0Ool015U8E>EDiECU2TaQ00Dl0400@01003`0
00=00005?0100400@00l0003@0000c`0001oo`0LOol00`00Oomoo`0@Ool000Aoo`03001oogoo01=o
o`0:0010IDB6@6E4QT1UA8HLidS9A:P37>L2FWL01QcWFYPLieZiFYPLi`9J^@097>MJfP00F_]FfU[l
E_]Jo5LL085oo`0OFBQDiE3UE>E@iDaQB65<HDQQC658HDaQB65<HDQQ@00l0400?01003`0@00l0400
?01003`0@00l040000007Goo00<007ooOol047oo0004Ool00`00Oomoo`0COol05@00A6E0IDAU@6E4
IAcWB<U4b1cWB@/LieYg7>MJMacWFYMJ^1cWF[TLi`02F[T021cWF]T001cWF]]Fne[kEab3Ool00eU8
E>EDi@02E>D<C6400d00?0100002@0001C`0@0100400?0000T0000<007ooOol06goo00<007ooOol0
47oo0004Ool00`00Oomoo`0DOol05000A8I0IDB67>M8bDBXB<TLidT;7>MJMacWFWPLieZHFYLLieZH
7>L2F[T021cWF]X005[kF]YJo5KkEab3Ool07UU9FBQDiE3UE>E@iECUB65<HDQQC658HDaQB65<HDQQ
C658HDaQ?01003`0@00l0400?01003`0@00001eoo`03001oogoo011oo`0017oo00<007ooOol057oo
00P0041UA6E0IAcWA<Q4bDT;0acW00AJEQcWFWLLi`9JV0087>MJ^5Zi7>MJ^AcWF]X0009JfP03E_]J
ngoo08Aoo`9IB0EDi@m<H@03@00l040000900003001oogoo01aoo`03001oogoo011oo`0017oo00<0
07ooOol057oo00/004B6@6DLidBXB<U4Z1cWB>/LieIF008Li`0@FWLLieZHFYLLieZHF[TLieZi7>MJ
fP00F_]FfU[lE_^6Ool06eU9FBQDiE3UE>E@iECUD>E<HDQQC658HDaQB65<HDQQC658HDaQB65<HDQQ
C64l0400?000000MOol00`00Oomoo`0AOol000Aoo`03001oogoo01Aoo`0B0010IAcWA<Q4bDC8B<TL
idT;7>MJEQcWFWLLieYg7>MJV1cW0UZi00PLieZi7>MJf@00F]YJfeKkQgoo0QcW00=IB5CUE>D015CU
4DaQ00<007ooOol06goo00<007ooOol04Goo0004Ool00`00Oomoo`0EOol06`007>M8bDBXB<TLidT;
B>/LieIF7>MFEQcWFWLLieZGF[TLieZi7>MJ^AcWF]X005[kF]YJo028Ool06QcWFDUI:5CUD>EDiE3U
E>E@iECUB65<HDQQC658HDaQB65<HDQQC658HDaQB65<HDQQ000MOol00`00Oomoo`0AOol000Aoo`03
001oogoo01Eoo`070014bDC8B<U4b1cWB@/00QcW019JEQcWFWLLieYg7>MJV5ZG7>MJV1cWF[TLie[J
001JfU[kE_^8Ool27>L2FDP7E>D>C6400`00Oomoo`0KOol00`00Oomoo`0AOol000Aoo`03001oogoo
01Eoo`070014Z4S9A:PLidS[B@/00acW015JMacW7>MFMacWFYMJV1cWF[TLieZi7>MJfP007>MFne[l
08Qoo`8Li`0GFBQIBETXE>E@iECUD>EDiE3UE>E@iDaQB65<HDQQC658HDaQB65<HDQQC640000NOol0
0`00Oomoo`0AOol000Aoo`03001oogoo01Eoo`050018bDC8A<TLi`02B@/37>L04EIF7>MJMacWFWLL
ieZH7>MJV1cWF[TLie[I001JfU[kOol02P00OWoo0QcW00AIBEU8FDQIB0QDi@Y<H@03001oogoo01]o
o`03001oogoo019oo`0017oo00<007ooOol05Goo00P004BXB<U4Z1cWB>/LidT]0QcW00QJEQcWFWLL
ieYg7>MJV1cW0UZi0QcW00AJfP00F_]Fn`]oo`X007Aoo`<Li`0FFDUI:5U9FBQDiE3UE>E@iECUD>ED
iE3UE>E8HDaQB65<HDQQC658HDaQ000MOol00`00Oomoo`0BOol000Aoo`03001oogoo01Aoo`800003
A<U4b1cW00992`0>7>M=KacW7>MJEQcWFUHLieYg7>MJUeZh7>MJ^@8Li`04F]X005[JF_/EOol:001Z
Ool37>L00eU8FDUIB002FDP9E>D7C6400`00Oomoo`0KOol00`00Oomoo`0BOol000Aoo`03001oogoo
01Aoo`07001oo`00B<TLidT;B>/01AcW00EFEQcW7>MJN1cW009JV0087>MJ^AcWF]TLi`00F_]Fnamo
o`/005moo`8Li`0FBYYMReTXFDUI:5U9FBQDiE3UE>E@iECUD>EDiE3UE>E@iECUB65<HDQQ000NOol0
0`00Oomoo`0BOol000Aoo`03001oogoo01Aoo`04001oo`007>L3B@/57>L00eYF7>MJM`027>L2FYP0
1acWF[PLieZi7>L005[J02]oo`X005Eoo`8Li`05BY]MRef;FDQIB@03FDP:E>D3C6400`00Oomoo`0L
Ool00`00Oomoo`0BOol000Aoo`03001oogoo01=oo`09001oogoo000LidS[B@/Lidd]00@Li`0;EUDL
ieIF7>MFMacWFYLLieZH7>MJ^@027>L00e[kOomoo`0cOol:001;Ool27>L05TZJ7>MIJeU9FBQIBETX
FDUI:5CUD>EDiE3UE>E@iECUD>EDiE3UE>E@i@007Woo00<007ooOol04Woo0004Ool00`00Oomoo`0C
Ool01@00Oomoo`007>L00TT;00<LidT]7>L00acW00]JEQcWFWLLieYg7>MJV1cWF[TLieZi008Li`03
E_]oogoo03eoo`X0045oo`8Li`04BY/Lief;GH/2FDP015U9FDQIB5U82eCU00<007ooOol06goo00<0
07ooOol04goo0004Ool00`00Oomoo`0COol02@00Oomoo`00B@]8jdT;7>M=;@057>L03EYg7>LLieYg
7>MJUacWFYPLieZi7>L005[l04Uoo`X003Moo`0G7>M>VacWCYYIJef;FF]IBETXFDUI:5U9FBQDiE3U
E>E@iECUD>EDiE3UE>D0000NOol00`00Oomoo`0COol000Aoo`03001oogoo01=oo`04001oogoo0003
B@/00acWBBdLi`047>L00eYF7>MJM`027>L2FYP27>L00eZi7>L0001DOol;000/Ool01AcWBYXLidij
GJd00Uf;0eU800AIBEU8FDQIB0QDi@03001oogoo01aoo`03001oogoo01=oo`0017oo00<007ooOol0
4Woo00<007ooOol00Woo00D004S[7>M9;Dd]00DLi`03FUHLieYg008Li`04FYMJV1cWF[T27>L00`00
Oomoo`1MOol:000QOol064ZL7>M>VacWCYXLief;FF]MReTXFDUI:5U9FBQIBETXE>E@iECUD>EDiE3U
E>D001ioo`03001oogoo01=oo`0017oo00<007ooOol04Woo00<007ooOol00Woo00H004T;7>M=;AcW
CFl67>L01eYF7>MJMacWFYPLieZi008Li`03001oogoo06Moo`X001Moo`<Li`9>NP037>MM[Ef;009M
R`=IB004FDUIB5U8FDP5E>D00`00Oomoo`0MOol00`00Oomoo`0COol000=oo`03001oogoo01=oo`03
001oogoo009oo`060018jacWBBdLide>1AcW00QFEQcW7>MJMacWFYPLieZi0acWLgoo2P003Goo0acW
01A:NAcWCWUM[EU[GH]IJef;FBQIBETXFDUI:5U9FBQDiE3UE>E@i@007goo00<007ooOol04goo0003
Ool00`00Oomoo`0BOol00`00Oomoo`03Ool01000B@/Lidd]1acW00=JEQcWFWL00QcW00=JUacWFYP0
0acWOGoo2P000goo0acW00=>NQcWCWT00Uf]0ef;00EIBEU8FDQIB5U900=IB0=Di@03001oogoo01ao
o`03001oogoo01Aoo`000goo00<007ooOol04Woo00<007ooOol017oo00<004d]BBd01acW00=FEQcW
EUH00QcW00=JV1cWF[T00QcW00<007ooOol0QGoo0`0001HLidZJ7>M:NAcWCWTLief]GH]IJef;FF]I
BETXFDUI:5U9FBQIBETXE>D001moo`03001oogoo01Aoo`000goo00<007ooOol04Woo00<007ooOol0
17oo00<004T]CBd02AcW00EJMacWFWLLieZH00<Li`03001oogoo08Qoo`8Li`04CWXLidii7>L3GJd4
GH/01EU9FDQIB5U8FDT00eU800<007ooOol07Goo00<007ooOol057oo0003Ool00`00Oomoo`0AOol0
0`00Oomoo`05Ool00`00CBe9;@087>L01UYg7>LLieIg7>MJU`<Li`03001oogoo08Qoo`8Li`0DCYXL
ie9j7>MQcef]HJiIJef;FF]MReTXFDUI:5U9FBQIBETXFDT001moo`03001oogoo01Aoo`000goo00<0
07ooOol04Goo00<007ooOol01Goo00<004T]CBd021cW00=FEQcWFWL00QcW00EJV1cWF[TLi`0008Yo
o`8Li`05CWXLiacWDWTLi`02GJd5GH/00eU8FDUIB002FDP00eU9001oo`0OOol00`00Oomoo`0DOol0
00=oo`03001oogoo015oo`03001oogoo00Ioo`050019;AcW7>MA/P047>L015He7>LLieYg0QcW00=J
UacWF[T00QcWRWoo0acW00A>NAcWCUPLi`=M[@0;GH]IJef;FF]MReTXFDUI:5U9FBP0000OOol00`00
Oomoo`0EOol000=oo`03001oogoo011oo`03001oogoo00Moo`05000Lide_7>MA/@077>L00eYF7>MJ
M`027>L00eZi7>LLi`2:Ool011cWCWXLidii0QcW00AMcef]GJeM[@EMR`9IB003FDUIB000021oo`03
001oogoo01Eoo`000goo00<007ooOol047oo00<007ooOol01goo00L001cWCFlLie6@7>MAd`047>L0
15IF7>LLieYh0QcW00=JV1cW7>L0RWoo00TLidYi7>LLie9i7>L005g>HJh00Uf]00UIJef;FF]MReU[
FDUI:5U9000087oo00<007ooOol05Goo0003Ool00`00Oomoo`0@Ool00`00Oomoo`08Ool01000CFhL
idf@1QcW00=JEQcWFWL00QcW00AJV1cW7>LLihUoo`<Li`06CWTLiacWDUPLieg?0ef]1Uf;0UU800<0
07ooOol07Woo00<007ooOol05Goo0003Ool00`00Oomoo`0?Ool00`00Oomoo`09Ool01000CFlLie6@
1AcW00AJEAcW7>MFEP8Li`04FYPLiacW7>N9Ool47>L01DiH7>MooacWGLh00Uf]00UQ[Uf]GH]IJef;
FF]MReTX00008Goo00<007ooOol05Goo0003Ool00`00Oomoo`0?Ool00`00Oomoo`09Ool01000CFlL
idf@21cW00=JMacWFWL011cWRGoo00<Lidii7>L00QcW00ABF1cW001Mc`AM[@IMR`03001oogoo01mo
o`03001oogoo01Eoo`000goo00<007ooOol03goo00<007ooOol02Woo00<001cWDI001acW00AJMacW
7>MJM`@LihUoo`8Li`08CUPLiacWDWPLi`00GLiQc`=M[@07GH]IJef;FF]MReU[000087oo00<007oo
Ool05Woo0003Ool00`00Oomoo`0>Ool00`00Oomoo`0;Ool00`007>M=T0077>L00eYF7>MJM`037>L0
0eZi7>Moo`28Ool37>L01E9h7>LLie9G7>L00Ug?15f]15f;00<007ooOol07goo00<007ooOol05Woo
0003Ool00`00Oomoo`0>Ool00`00Oomoo`0;Ool00`007>MAT0027>L01E7B7>LLiacWESD00QcW00IJ
MacW7>LLieZi7>N8Ool00`007>MBN@027>L0259H7>MBEacWGLiQcef]HJh2GJd01EU[GH]IJef;0000
8Goo00<007ooOol05Woo0003Ool00`00Oomoo`0>Ool00`00Oomoo`0<Ool01`00CI0LiacWDM8Lie8E
00@Li`03FUHLieYg00<LihQoo`8Li`07DWPLiacW7>MBEacW00000Ug?1Ef]0Uf;00<007ooOol087oo
00<007ooOol05Woo0003Ool00`00Oomoo`0>Ool00`00Oomoo`0<Ool01`00DI0LiacWDM8Lidgd00<L
i`04EUHLiacWFWL37>N8Ool47>L00e9h7>MFF0027>L00eg>HLmMcP02GJd01F6^GJeMReU[00008Woo
00<007ooOol05Woo0003Ool00`00Oomoo`0=Ool00`00Oomoo`0=Ool01@00CI0LiacWDM8011cW00AJ
=AcW7>MJM`@LihQoo`037>MBNAcW008Li`04EULLie8f7>L3GLl5GJd2000QOol00`00Oomoo`0GOol0
00=oo`03001oogoo00eoo`03001oogoo00ioo`04000LiacWDM847>L015YF7>LLieIF0acW00<007oo
Ool0QWoo0acW00=BEacWDUL00QcW0P0000=Qceg>HJh00ef]00=Q[P0000008Goo00<007ooOol05goo
0003Ool00`00Oomoo`0=Ool00`00Oomoo`0>Ool01@007>MA/AcWDM800QcW00MB5AcW7>LLieYg7>MJ
V0027>N7Ool00acWCWTLi`027>L0159G7>MB=QcW0P000Ug?1Ef]0P008Goo00<007ooOol05goo0003
Ool00`00Oomoo`0<Ool00`00Oomoo`0@Ool01P00DK8Lie7C7>MB5@<Li`04FWLLiacWEWL27>N7Ool0
0acWDWTLi`027>L015IH7>LLiehA0P0000UQceg>HLmM[F6^GJd007oo00008Goo00<007ooOol05goo
0003Ool00`00Oomoo`0<Ool00`00Oomoo`0@Ool01P00DK4Lie7B7>MAm08Li`04FSDLiacWFWL37>N6
Ool00acW000Li`027>L01E9G7>MF=QcWGQ400P000eg?0ef]00@007ooOol0021oo`03001oogoo01Mo
o`000Woo00<007ooOol03Goo00<007ooOol04Goo00<001cWDM<011cW00AF=AcW7>MJM`8Li`03001o
ogoo08Aoo`037>M>F1cW008Li`05DULLiacW001N4@0200000f7?GLiQc`02GJd01@00Oomoogoo0000
87oo00<007ooOol05goo0002Ool00`00Oomoo`0<Ool00`00Oomoo`0COol00`00DM8Li`027>L024ge
7>LLiacWFUHLieZH7>N6Ool02P007>LLiacWDULLie8f7>L005hA0P000eg?0Uf]00D007ooOomoo`00
01moo`03001oogoo01Qoo`000Woo00<007ooOol037oo00<007ooOol04goo00D001cW7>LLidge00<L
i`05EUHLiacWFWPLi`26Ool01@007>LLiacWEUP00QcW00=J<`00GQ400P0000EQceg>HLmMcP0000Ao
o`03001oogoo01eoo`03001oogoo01Qoo`000Woo00<007ooOol037oo00<007ooOol057oo00@0057B
7>MB5@8Li`06ESDLiacW7>MJMacWQWoo00X001cW7>MFEacWDSHLi`00GQ9N4@8000AMc`03001oogoo
00=oo`03001oogoo01aoo`03001oogoo01Qoo`000Woo00<007ooOol02goo00<007ooOol05Woo00<0
01cWDO<00QcW00AJEAcW7>MFEP8LihEoo`05000LiacW7>MBE`027>L015iE001N<ehA0P0000AQceg>
HLl000Ioo`03001oogoo01aoo`03001oogoo01Qoo`000Woo00<007ooOol02goo00<007ooOol05Woo
00D001cW7>LLie8E00<Li`03FWL007oo08Eoo`09001BF1cWDULLie8f7>MJ=000009N4@<0009Mc`03
001oogoo00Aoo`03001oogoo01aoo`03001oogoo01Qoo`000Woo00<007ooOol02goo00<007ooOol0
5goo00<001cWDQD00QcW00AFEQcW7>L008Ioo`04000LiacWEUP27>L01EYFGS@0068BGQ400`0000=M
cP00Ool01Woo00<007ooOol077oo00<007ooOol067oo0002Ool00`00Oomoo`0:Ool00`00Oomoo`0I
Ool01@00CODLiacWFSD00QcWQgoo00L001cWDULLieHf7>MJ=@020002GQ4300000eg?001oo`07Ool0
0`00Oomoo`0JOol00`00Oomoo`0IOol0009oo`03001oogoo00Yoo`03001oogoo01Uoo`04000LiacW
DQD27>L00`00Oomoo`25Ool27>L01U9G7>LLieYfFS<0009N4P03GQ400000008000Uoo`03001oogoo
01Yoo`03001oogoo01Uoo`000Woo00<007ooOol02Woo00<007ooOol06Woo00<001cWCOD00QcWQgoo
0QcW00QBEacWDSHLieXeGS@005hB0UhA10002Goo00<007ooOol06Woo00<007ooOol06Goo0002Ool0
0`00Oomoo`09Ool00`00Oomoo`0LOol40027Ool00`007>MFF0027>L01eYFGUD00000FQ9R4UhA00<0
00Yoo`03001oogoo01Yoo`03001oogoo01Uoo`000Woo00<007ooOol02Goo00<007ooOol0Ygoo00L0
01cW7>MB=QcWFUEJ=00200000ehBGQ5N4@02000<Ool00`00Oomoo`0IOol00`00Oomoo`0IOol0009o
o`03001oogoo00Uoo`03001oogoo0:Ioo`03000Lie9G008Li`03FWIJ=5hd0080009N4P03GQ400000
00aoo`03001oogoo01Qoo`03001oogoo01Yoo`000Woo00<007ooOol02Goo00<007ooOol0YWoo00X0
01cW7>MB=QcWFUEJ=EXd001N4P=N4@03001oogoo00]oo`03001oogoo01Qoo`03001oogoo01Yoo`00
0Woo00<007ooOol027oo00<007ooOol0Ygoo00L005IH7>LLieYFGUEJ<`02000015hcGQ5R4P003Woo
00<007ooOol067oo00<007ooOol06Woo0002Ool00`00Oomoo`08Ool00`00Oomoo`2WOol01`007>MF
=QcWFUIJ=Ehd00800003GQ9N4@00011oo`03001oogoo01Moo`03001oogoo01Yoo`000Woo00<007oo
Ool027oo00<007ooOol0Ygoo00L001cW7>MJMUYEGSAJ=00200000ehcGQ40000@Ool00`00Oomoo`0G
Ool00`00Oomoo`0JOol0009oo`03001oogoo00Moo`03001oogoo0:Qoo`067>MB=QcWFUIJ=EXd0`00
00=N4P00Ool047oo00<007ooOol05goo00<007ooOol06Woo0002Ool00`00Oomoo`07Ool00`00Oomo
o`2XOol01P007>MJEUYFFSAN=0800003GQ8007oo015oo`03001oogoo01Ioo`03001oogoo01]oo`00
0Woo00<007ooOol01goo00<007ooOol0Z7oo0QcW00AJEUXdGSAJ=0800003GQ8007oo019oo`03001o
ogoo01Eoo`03001oogoo01]oo`000Woo00<007ooOol01Woo00<007ooOol0ZGoo00H005YfFUENEEXc
GS@3000DOol00`00Oomoo`0EOol00`00Oomoo`0KOol0009oo`03001oogoo00Ioo`03001oogoo0:Uo
o`05001JEUYEFSEN=003000EOol00`00Oomoo`0EOol00`00Oomoo`0KOol0009oo`03001oogoo00Io
o`03001oogoo0:Uoo`06001JEUYEGSAJ=0005goo00<007ooOol05Goo00<007ooOol06goo00000goo
001oo`07Ool00`00Oomoo`2[Ool01000FSD000006Goo00<007ooOol04goo00<007ooOol077oo0000
0goo001oo`07Ool00`00Oomoo`2/Ool00`00Oomoo`0IOol00`00Oomoo`0COol00`00Oomoo`0LOol0
0003Ool007oo00Moo`03001oogoo0<Qoo`03001oogoo01=oo`03001oogoo01aoo`0000=oo`00Ool0
1Woo00<007ooOol0bGoo00<007ooOol04goo00<007ooOol077oo00000goo001oo`06Ool00`00Oomo
o`3:Ool00`00Oomoo`0BOol00`00Oomoo`0LOol00003Ool007oo00Ioo`03001oogoo0<Yoo`03001o
ogoo019oo`03001oogoo01aoo`0000=oo`00Ool01Woo00<007ooOol0bWoo00<007ooOol04Goo00<0
07ooOol07Goo00000goo001oo`05Ool00`00Oomoo`3;Ool00`00Oomoo`0AOol00`00Oomoo`0MOol0
0003Ool007oo00Eoo`03001oogoo0<aoo`03001oogoo011oo`03001oogoo01eoo`0000=oo`00Ool0
1Goo00<007ooOol0c7oo00<007ooOol047oo00<007ooOol07Goo00000goo001oo`04Ool00`00Oomo
o`3=Ool00`00Oomoo`0@Ool00`00Oomoo`0MOol00003Ool007oo00Aoo`03001oogoo0<eoo`03001o
ogoo011oo`03001oogoo01eoo`0000=oo`00Ool017oo00<007ooOol0cWoo00<007ooOol03Woo00<0
07ooOol07Woo00000goo001oo`03Ool00`00Oomoo`3?Ool00`00Oomoo`0>Ool00`00Oomoo`0NOol0
0003Ool007oo00=oo`03001oogoo0<moo`03001oogoo00ioo`03001oogoo01ioo`0000=oo`00Ool0
0goo00<007ooOol0cgoo00<007ooOol03Woo00<007ooOol07Woo00000goo001oo`02Ool00`00Oomo
o`3AOol00`00Oomoo`0=Ool00`00Oomoo`0NOol00003Ool007oo009oo`03001oogoo0=5oo`03001o
ogoo00aoo`03001oogoo01moo`0000=oo`00Ool00Woo00<007ooOol0dGoo00<007ooOol037oo00<0
07ooOol07goo00001Goo001oogoo0000e7oo00<007ooOol037oo00<007ooOol07goo00001Goo001o
ogoo0000eGoo00<007ooOol02goo00<007ooOol07goo00001Goo001oogoo0000eGoo00<007ooOol0
2goo00<007ooOol07goo00001000Oomoo`00eWoo00<007ooOol02goo00<007ooOol07goo00001000
Oomoo`00eWoo00<007ooOol02Woo00<007ooOol087oo00001000Oomoo`00egoo00<007ooOol02Goo
00<007ooOol087oo00001000Oomoo`00egoo00<007ooOol02Goo00<007ooOol087oo00000`00Ool0
003HOol00`00Oomoo`09Ool00`00Oomoo`0POol00003001oo`000=Qoo`03001oogoo00Uoo`03001o
ogoo021oo`0000<007oo0000fGoo00<007ooOol01goo00<007ooOol08Goo0002003JOol00`00Oomo
o`07Ool00`00Oomoo`0QOol000800=Yoo`03001oogoo00Moo`03001oogoo025oo`000P00fWoo00<0
07ooOol01goo00<007ooOol08Goo00000`00Oomoo`3JOol00`00Oomoo`06Ool00`00Oomoo`0QOol0
00H00=Moo`03001oogoo00Ioo`03001oogoo025oo`001Woo2`00c7oo00<007ooOol01Goo00<007oo
Ool08Woo000AOol<0030Ool00`00Oomoo`05Ool00`00Oomoo`0ROol001eoo`/00;Ioo`03001oogoo
00Aoo`03001oogoo029oo`00:7oo2`00Zgoo00<007ooOol017oo00<007ooOol08Woo000cOol<002O
Ool00`00Oomoo`04Ool00`00Oomoo`0ROol003moo`/009Aoo`03001oogoo00Aoo`03001oogoo029o
o`00BWoo2`00RWoo00<007ooOol00Woo00<007ooOol08goo001EOol<001nOol00`00Oomoo`02Ool0
0`00Oomoo`0SOol0065oo`/007=oo`03001oogoo009oo`03001oogoo02=oo`00K7oo2`00J7oo00<0
07ooOol00Woo00<007ooOol08goo001gOol;001NOol01@00Oomoogoo00009Goo0022Ool<001BOol0
1000Oomoo`009Woo002>Ool;0017Ool01000Oomoo`009Woo002IOol;000lOol01000Oomoo`009Woo
002TOol<000aOol00`00Ool0000VOol00;1oo`/002Ioo`03001oo`0002Ioo`00^goo2`006goo00<0
07oo00009Woo0036Ool<000?Ool2000WOol00=9oo`/000Eoo`03001oogoo02Eoo`00gGoo1P009goo
0000
\>"],
  ImageRangeCache->{{{0, 265.063}, {287, 0}} -> {0.0958408, 0.0766181, 
  0.00321812, 0.00321812}}]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell["If you use Cos instead of Sine it doesn't work out.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 125; kappa[s_] = 1; tau[s_] := Cos[s]; width = .5; 
    ds = .1; \), 
    \(pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.11022e-016 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.53102 .6777 m .54036 .70497 L .55238 .68083 L .253 0 .076 r
F
.53102 .6777 m .52712 .71206 L .54036 .70497 L F
.50966 .67538 m .52712 .71206 L .53102 .6777 L .391 .042 .248 r
F
.50966 .67538 m .51415 .71881 L .52712 .71206 L F
.25 g
.5 Mabswid
.52712 .71206 m
.53102 .6777 L
s
.48843 .67403 m .51415 .71881 L .50966 .67538 L .478 .163 .354 r
F
0 g
.006 w
.50966 .67538 m
.53102 .6777 L
s
.55238 .68083 m .55383 .69756 L .57363 .68462 L .023 0 0 r
F
.55238 .68083 m .54036 .70497 L .55383 .69756 L F
0 g
.53102 .6777 m
.55238 .68083 L
s
.25 g
.5 Mabswid
.54036 .70497 m
.55238 .68083 L
s
.48843 .67403 m .50148 .72523 L .51415 .71881 L .478 .163 .354 r
F
.25 g
.50966 .67538 m
.51415 .71881 L
s
.46747 .67378 m .50148 .72523 L .48843 .67403 L .537 .247 .421 r
F
0 g
.006 w
.48843 .67403 m
.50966 .67538 L
s
.57363 .68462 m .56753 .6899 L .59464 .68886 L 0 0 0 r
F
.57363 .68462 m .55383 .69756 L .56753 .6899 L F
0 g
.55238 .68083 m
.57363 .68462 L
s
.46747 .67378 m .48918 .73134 L .50148 .72523 L .537 .247 .421 r
F
.44691 .67472 m .48918 .73134 L .46747 .67378 L .581 .307 .466 r
F
.25 g
.5 Mabswid
.48843 .67403 m
.48865 .67488 L
s
0 g
.006 w
.46747 .67378 m
.48843 .67403 L
s
.59464 .68886 m .58144 .68205 L .6153 .69336 L .593 .949 .858 r
F
.59464 .68886 m .56753 .6899 L .58144 .68205 L F
0 g
.57363 .68462 m
.57603 .6851 L
s
.25 g
.5 Mabswid
.59415 .68888 m
.59464 .68886 L
s
.55383 .69756 m
.57363 .68462 L
s
.44691 .67472 m .47732 .73718 L .48918 .73134 L .581 .307 .466 r
F
.25 g
.50105 .72354 m
.50148 .72523 L
s
.48865 .67488 m
.50105 .72354 L
s
.4269 .67695 m .47732 .73718 L .44691 .67472 L .616 .351 .494 r
F
.25 g
.46747 .67378 m
.46782 .6747 L
s
0 g
.006 w
.44691 .67472 m
.46747 .67378 L
s
.6153 .69336 m .59555 .67412 L .63551 .6979 L .721 .956 .948 r
F
.6153 .69336 m .58144 .68205 L .59555 .67412 L F
0 g
.59464 .68886 m
.6153 .69336 L
s
.25 g
.5 Mabswid
.61468 .69315 m
.6153 .69336 L
s
.56753 .6899 m
.56762 .68989 L
s
.56762 .68989 m
.59415 .68888 L
s
.4269 .67695 m .46599 .74282 L .47732 .73718 L .616 .351 .494 r
F
.25 g
.48825 .72887 m
.48918 .73134 L
s
.46782 .6747 m
.48825 .72887 L
s
.40757 .68051 m .46599 .74282 L .4269 .67695 L .645 .384 .509 r
F
.25 g
.44691 .67472 m
.44738 .67568 L
s
0 g
.006 w
.4269 .67695 m
.44691 .67472 L
s
.63551 .6979 m .60982 .6662 L .65516 .70223 L .752 .895 .942 r
F
.63551 .6979 m .59555 .67412 L .60982 .6662 L F
.25 g
.5 Mabswid
.58144 .68205 m
.58173 .68215 L
s
0 g
.006 w
.6153 .69336 m
.63551 .6979 L
s
.25 g
.5 Mabswid
.63476 .69745 m
.63551 .6979 L
s
.40757 .68051 m .4553 .7483 L .46599 .74282 L .645 .384 .509 r
F
.25 g
.4756 .73365 m
.47732 .73718 L
s
.38907 .68544 m .4553 .7483 L .40757 .68051 L .67 .407 .514 r
F
.25 g
.4269 .67695 m
.42746 .67789 L
s
0 g
.006 w
.40757 .68051 m
.4269 .67695 L
s
.65516 .70223 m .62423 .65841 L .67417 .70614 L .75 .828 .912 r
F
.65516 .70223 m .60982 .6662 L .62423 .65841 L F
.25 g
.5 Mabswid
.59555 .67412 m
.5961 .67444 L
s
0 g
.006 w
.63551 .6979 m
.65516 .70223 L
s
.25 g
.5 Mabswid
.65432 .70156 m
.65516 .70223 L
s
.65431 .70155 m
.65432 .70156 L
s
.58173 .68215 m
.58207 .68226 L
s
.58207 .68226 m
.61468 .69315 L
s
.38907 .68544 m .44535 .75365 L .4553 .7483 L .67 .407 .514 r
F
.25 g
.46294 .73768 m
.46599 .74282 L
s
.47289 .72808 m
.4756 .73365 L
s
.44738 .67568 m
.47289 .72808 L
s
.37157 .69175 m .44535 .75365 L .38907 .68544 L .692 .421 .509 r
F
.25 g
.40757 .68051 m
.40817 .68137 L
s
0 g
.006 w
.38907 .68544 m
.40757 .68051 L
s
.67417 .70614 m .6387 .65081 L .69244 .70937 L .736 .77 .88 r
F
.67417 .70614 m .62423 .65841 L .6387 .65081 L F
.25 g
.5 Mabswid
.60982 .6662 m
.61068 .66688 L
s
0 g
.006 w
.65516 .70223 m
.67417 .70614 L
s
.25 g
.5 Mabswid
.67322 .70523 m
.67417 .70614 L
s
.67321 .70522 m
.67322 .70523 L
s
.5961 .67444 m
.59659 .67474 L
s
.59659 .67474 m
.63476 .69745 L
s
.37157 .69175 m .43627 .75892 L .44535 .75365 L .692 .421 .509 r
F
.25 g
.44966 .7403 m
.4553 .7483 L
s
.45768 .72881 m
.46294 .73768 L
s
.35522 .69942 m .43627 .75892 L .37157 .69175 L .709 .425 .492 r
F
.25 g
.38907 .68544 m
.38958 .68606 L
s
0 g
.006 w
.37157 .69175 m
.38907 .68544 L
s
.69244 .70937 m .65317 .64346 L .7099 .7117 L .72 .721 .85 r
F
.69244 .70937 m .6387 .65081 L .65317 .64346 L F
.25 g
.5 Mabswid
.61068 .66688 m
.61136 .66742 L
s
.62423 .65841 m
.62543 .65955 L
s
0 g
.006 w
.67417 .70614 m
.69244 .70937 L
s
.25 g
.5 Mabswid
.6914 .70824 m
.69244 .70937 L
s
.6914 .70824 m
.6914 .70824 L
s
.35522 .69942 m .42817 .76408 L .43627 .75892 L .709 .425 .492 r
F
.25 g
.43263 .73823 m
.44535 .75365 L
s
.4376 .72316 m
.44966 .7403 L
s
.44747 .71162 m
.45768 .72881 L
s
.42746 .67789 m
.44747 .71162 L
s
.34018 .70841 m .42817 .76408 L .35522 .69942 L .722 .417 .461 r
F
.25 g
.40817 .68137 m
.4376 .72316 L
s
0 g
.006 w
.35522 .69942 m
.37157 .69175 L
s
.34018 .70841 m .42113 .76911 L .42817 .76408 L .722 .417 .461 r
F
.32662 .71864 m .42113 .76911 L .34018 .70841 L .728 .394 .414 r
F
.25 g
.5 Mabswid
.38958 .68606 m
.43263 .73823 L
s
.35522 .69942 m
.3671 .70995 L
s
0 g
.006 w
.34018 .70841 m
.35522 .69942 L
s
.7099 .7117 m .66752 .63639 L .72648 .71291 L .703 .679 .824 r
F
.7099 .7117 m .65317 .64346 L .66752 .63639 L F
.25 g
.5 Mabswid
.62543 .65955 m
.62631 .6604 L
s
.6387 .65081 m
.64027 .65252 L
s
0 g
.006 w
.69244 .70937 m
.7099 .7117 L
s
.25 g
.5 Mabswid
.70916 .71081 m
.7099 .7117 L
s
.70878 .71035 m
.70916 .71081 L
s
.61136 .66742 m
.61223 .66812 L
s
.61223 .66812 m
.65431 .70155 L
s
.32662 .71864 m .41523 .77395 L .42113 .76911 L .728 .394 .414 r
F
.31469 .73002 m .41523 .77395 L .32662 .71864 L .721 .35 .346 r
F
.25 g
.37157 .69175 m
.38753 .70832 L
s
.34018 .70841 m
.34311 .71061 L
s
0 g
.006 w
.32662 .71864 m
.34018 .70841 L
s
.25 g
.5 Mabswid
.33187 .72192 m
.34233 .72845 L
s
.32662 .71864 m
.33187 .72192 L
s
.72648 .71291 m .68163 .62956 L .74213 .71277 L .685 .641 .8 r
F
.72648 .71291 m .66752 .63639 L .68163 .62956 L F
.25 g
.64027 .65252 m
.64139 .65374 L
s
.65317 .64346 m
.65513 .64582 L
s
0 g
.006 w
.7099 .7117 m
.72648 .71291 L
s
.25 g
.5 Mabswid
.72569 .71187 m
.72648 .71291 L
s
.72529 .71136 m
.72569 .71187 L
s
.62631 .6604 m
.62744 .66148 L
s
.62744 .66148 m
.67321 .70522 L
s
1 0 0 r
.003 w
.48918 .73134 m
.50148 .72523 L
s
.47732 .73718 m
.48918 .73134 L
s
.50148 .72523 m
.51415 .71881 L
s
.46599 .74282 m
.47732 .73718 L
s
.51415 .71881 m
.52712 .71206 L
s
.4553 .7483 m
.46599 .74282 L
s
.52712 .71206 m
.54036 .70497 L
s
.54036 .70497 m
.55383 .69756 L
s
.44535 .75365 m
.4553 .7483 L
s
.55383 .69756 m
.56753 .6899 L
s
.43627 .75892 m
.44535 .75365 L
s
.56753 .6899 m
.58144 .68205 L
s
.31469 .73002 m .41052 .77852 L .41523 .77395 L .721 .35 .346 r
F
.30455 .74241 m .41052 .77852 L .31469 .73002 L .697 .28 .251 r
F
.25 g
.5 Mabswid
.38753 .70832 m
.43627 .75892 L
s
.3671 .70995 m
.42817 .76408 L
s
.34311 .71061 m
.34315 .71064 L
s
0 g
.006 w
.31469 .73002 m
.32662 .71864 L
s
.25 g
.5 Mabswid
.31469 .73002 m
.32508 .73528 L
s
1 0 0 r
.003 w
.58144 .68205 m
.59555 .67412 L
s
.42817 .76408 m
.43627 .75892 L
s
.59555 .67412 m
.60982 .6662 L
s
.74213 .71277 m .69536 .62292 L .75678 .71111 L .667 .607 .778 r
F
.74213 .71277 m .68163 .62956 L .69536 .62292 L F
.25 g
.5 Mabswid
.65513 .64582 m
.65651 .64748 L
s
.65651 .64748 m
.70878 .71035 L
s
.66752 .63639 m
.66989 .63946 L
s
.66989 .63946 m
.72529 .71136 L
s
0 g
.006 w
.72648 .71291 m
.74213 .71277 L
s
.25 g
.5 Mabswid
.74128 .71161 m
.74213 .71277 L
s
.74088 .71106 m
.74128 .71161 L
s
.64139 .65374 m
.64281 .65528 L
s
.64281 .65528 m
.6914 .70824 L
s
1 0 0 r
.003 w
.60982 .6662 m
.62423 .65841 L
s
.42113 .76911 m
.42817 .76408 L
s
.62423 .65841 m
.6387 .65081 L
s
.6387 .65081 m
.65317 .64346 L
s
.30455 .74241 m .40699 .78271 L .41052 .77852 L .697 .28 .251 r
F
.29635 .75566 m .40699 .78271 L .30455 .74241 L .644 .176 .127 r
F
.25 g
.5 Mabswid
.34315 .71064 m
.42113 .76911 L
s
.34233 .72845 m
.41523 .77395 L
s
.32508 .73528 m
.37946 .7628 L
s
0 g
.006 w
.30455 .74241 m
.31469 .73002 L
s
.25 g
.5 Mabswid
.31078 .74486 m
.36323 .76549 L
s
.30455 .74241 m
.31078 .74486 L
s
1 0 0 r
.003 w
.41523 .77395 m
.42113 .76911 L
s
.65317 .64346 m
.66752 .63639 L
s
.66752 .63639 m
.68163 .62956 L
s
.75678 .71111 m .70857 .61639 L .77039 .70777 L .648 .574 .758 r
F
.75678 .71111 m .69536 .62292 L .70857 .61639 L F
.25 g
.5 Mabswid
.68163 .62956 m
.68444 .63343 L
s
.68444 .63343 m
.74088 .71106 L
s
0 g
.006 w
.74213 .71277 m
.75678 .71111 L
s
.25 g
.5 Mabswid
.7555 .70928 m
.75678 .71111 L
s
.69536 .62292 m
.7555 .70928 L
s
1 0 0 r
.003 w
.41052 .77852 m
.41523 .77395 L
s
.68163 .62956 m
.69536 .62292 L
s
.29635 .75566 m .40461 .78641 L .40699 .78271 L .644 .176 .127 r
F
.29022 .76958 m .40461 .78641 L .29635 .75566 L .553 .034 0 r
F
.25 g
.5 Mabswid
.37946 .7628 m
.41052 .77852 L
s
.38623 .77454 m
.40699 .78271 L
s
.36323 .76549 m
.38623 .77454 L
s
0 g
.006 w
.29635 .75566 m
.30455 .74241 L
s
.25 g
.5 Mabswid
.29635 .75566 m
.37406 .77773 L
s
1 0 0 r
.003 w
.40699 .78271 m
.41052 .77852 L
s
.77039 .70777 m .70857 .61639 L .72109 .60985 L .627 .543 .74 r
F
1 0 0 r
.69536 .62292 m
.70857 .61639 L
s
.48613 .30904 m .49442 .32317 L .46382 .3163 L .348 0 0 r
F
.48613 .30904 m .50766 .32463 L .49442 .32317 L F
.50877 .30222 m .50766 .32463 L .48613 .30904 L .527 0 0 r
F
.50877 .30222 m .5212 .32726 L .50766 .32463 L F
.5316 .29604 m .5212 .32726 L .50877 .30222 L .653 .159 .064 r
F
0 g
.006 w
.48613 .30904 m
.50877 .30222 L
s
.46382 .3163 m .48158 .32288 L .44197 .32384 L .153 0 0 r
F
.46382 .3163 m .49442 .32317 L .48158 .32288 L F
0 g
.46382 .3163 m
.48613 .30904 L
s
.25 g
.5 Mabswid
.46382 .3163 m
.4645 .31645 L
s
.48613 .30904 m
.505 .3227 L
s
.505 .3227 m
.50766 .32463 L
s
.77039 .70777 m .72109 .60985 L .78294 .7026 L .627 .543 .74 r
F
0 g
.006 w
.75678 .71111 m
.77039 .70777 L
s
.25 g
.5 Mabswid
.70857 .61639 m
.77039 .70777 L
s
.78294 .7026 m .72109 .60985 L .73277 .60319 L .604 .512 .723 r
F
1 0 0 r
.003 w
.70857 .61639 m
.72109 .60985 L
s
.5316 .29604 m .53491 .33107 L .5212 .32726 L .653 .159 .064 r
F
.25 g
.5 Mabswid
.50877 .30222 m
.5212 .32726 L
s
.5545 .29067 m .53491 .33107 L .5316 .29604 L .725 .299 .238 r
F
0 g
.006 w
.50877 .30222 m
.5316 .29604 L
s
.44197 .32384 m .46929 .32372 L .42071 .33151 L 0 0 0 r
F
.44197 .32384 m .48158 .32288 L .46929 .32372 L F
0 g
.44197 .32384 m
.46382 .3163 L
s
.25 g
.5 Mabswid
.44197 .32384 m
.44289 .32382 L
s
.4645 .31645 m
.48955 .32207 L
s
.48955 .32207 m
.49442 .32317 L
s
.79438 .69551 m .73277 .60319 L .74345 .59627 L .578 .48 .707 r
F
.25 g
.72109 .60985 m
.72555 .61654 L
s
.78294 .7026 m .73277 .60319 L .79438 .69551 L .604 .512 .723 r
F
1 0 0 r
.003 w
.72109 .60985 m
.73277 .60319 L
s
0 g
.006 w
.77039 .70777 m
.78294 .7026 L
s
.5545 .29067 m .5487 .336 L .53491 .33107 L .725 .299 .238 r
F
.25 g
.5 Mabswid
.5316 .29604 m
.53491 .33107 L
s
.57733 .28632 m .5487 .336 L .5545 .29067 L .76 .397 .367 r
F
0 g
.006 w
.5316 .29604 m
.5545 .29067 L
s
.42071 .33151 m .45767 .32564 L .40017 .33917 L 0 0 0 r
F
.42071 .33151 m .46929 .32372 L .45767 .32564 L F
0 g
.42071 .33151 m
.44197 .32384 L
s
.25 g
.5 Mabswid
.42071 .33151 m
.42192 .33131 L
s
.44289 .32382 m
.47278 .32309 L
s
.47278 .32309 m
.48158 .32288 L
s
.29022 .76958 m .40331 .78951 L .40461 .78641 L .553 .034 0 r
F
1 0 0 r
.003 w
.40461 .78641 m
.40699 .78271 L
s
.28629 .78395 m .40331 .78951 L .29022 .76958 L .418 0 0 r
F
.25 g
.5 Mabswid
.37406 .77773 m
.40461 .78641 L
s
0 g
.006 w
.29022 .76958 m
.29635 .75566 L
s
.25 g
.5 Mabswid
.29022 .76958 m
.39032 .78722 L
s
.8047 .68645 m .74345 .59627 L .75299 .589 L .547 .447 .692 r
F
.25 g
.73277 .60319 m
.73801 .61104 L
s
.72555 .61654 m
.72887 .62152 L
s
.79438 .69551 m .74345 .59627 L .8047 .68645 L .578 .48 .707 r
F
.25 g
.72887 .62152 m
.78294 .7026 L
s
1 0 0 r
.003 w
.73277 .60319 m
.74345 .59627 L
s
.25 g
.5 Mabswid
.79302 .69347 m
.79438 .69551 L
s
.57733 .28632 m .56252 .34197 L .5487 .336 L .76 .397 .367 r
F
.25 g
.5487 .336 m
.5545 .29067 L
s
.59996 .28319 m .56252 .34197 L .57733 .28632 L .774 .463 .461 r
F
0 g
.006 w
.5545 .29067 m
.57733 .28632 L
s
.40017 .33917 m .44684 .32858 L .38049 .34671 L 0 0 0 r
F
.40017 .33917 m .45767 .32564 L .44684 .32858 L F
.25 g
.5 Mabswid
.45143 .32658 m
.46929 .32372 L
s
0 g
.006 w
.40017 .33917 m
.42071 .33151 L
s
.25 g
.5 Mabswid
.40017 .33917 m
.40179 .33879 L
s
0 g
.006 w
.78294 .7026 m
.79438 .69551 L
s
.81388 .67538 m .75299 .589 L .76125 .5813 L .512 .413 .68 r
F
.25 g
.5 Mabswid
.74345 .59627 m
.74973 .60552 L
s
.73801 .61104 m
.74205 .61709 L
s
.8047 .68645 m .75299 .589 L .81388 .67538 L .547 .447 .692 r
F
1 0 0 r
.003 w
.74345 .59627 m
.75299 .589 L
s
.25 g
.5 Mabswid
.80326 .68432 m
.8047 .68645 L
s
.59996 .28319 m .5763 .34886 L .56252 .34197 L .774 .463 .461 r
F
.62225 .28147 m .5763 .34886 L .59996 .28319 L .776 .508 .531 r
F
.25 g
.57703 .28744 m
.57733 .28632 L
s
0 g
.006 w
.57733 .28632 m
.59996 .28319 L
s
.38049 .34671 m .43692 .33251 L .36181 .35403 L 0 0 0 r
F
.38049 .34671 m .44684 .32858 L .43692 .33251 L F
0 g
.38049 .34671 m
.40017 .33917 L
s
.25 g
.5 Mabswid
.383 .34603 m
.38303 .34602 L
s
.38049 .34671 m
.383 .34603 L
s
.42192 .33131 m
.45143 .32658 L
s
.28629 .78395 m .40297 .79192 L .40331 .78951 L .418 0 0 r
F
1 0 0 r
.003 w
.40331 .78951 m
.40461 .78641 L
s
.25 g
.5 Mabswid
.39032 .78722 m
.40331 .78951 L
s
.28464 .79854 m .40297 .79192 L .28629 .78395 L .245 0 0 r
F
0 g
.006 w
.28629 .78395 m
.29022 .76958 L
s
.82188 .66234 m .76125 .5813 L .76813 .5731 L .47 .378 .67 r
F
.25 g
.5 Mabswid
.75299 .589 m
.76078 .60006 L
s
.74973 .60552 m
.75483 .61303 L
s
.74205 .61709 m
.74762 .62544 L
s
.81388 .67538 m .76125 .5813 L .82188 .66234 L .512 .413 .68 r
F
1 0 0 r
.003 w
.75299 .589 m
.76125 .5813 L
s
.25 g
.5 Mabswid
.81239 .67327 m
.81388 .67538 L
s
.62225 .28147 m .59001 .35654 L .5763 .34886 L .776 .508 .531 r
F
.25 g
.5763 .34886 m
.57753 .34545 L
s
.56252 .34197 m
.57703 .28744 L
s
.64406 .28135 m .59001 .35654 L .62225 .28147 L .772 .541 .585 r
F
.25 g
.59948 .2845 m
.59996 .28319 L
s
0 g
.006 w
.59996 .28319 m
.62225 .28147 L
s
.82871 .64738 m .76813 .5731 L .77351 .5644 L .421 .344 .664 r
F
.25 g
.5 Mabswid
.76078 .60006 m
.76766 .60982 L
s
.75483 .61303 m
.76227 .62397 L
s
.74762 .62544 m
.75555 .63732 L
s
.82188 .66234 m .76813 .5731 L .82871 .64738 L .47 .378 .67 r
F
.25 g
.75555 .63732 m
.79302 .69347 L
s
.76125 .5813 m
.77152 .59502 L
s
1 0 0 r
.003 w
.76125 .5813 m
.76813 .5731 L
s
.25 g
.5 Mabswid
.82033 .66026 m
.82075 .66082 L
s
.82075 .66082 m
.82188 .66234 L
s
.36181 .35403 m .42798 .33736 L .34428 .36106 L .005 0 0 r
F
.36181 .35403 m .43692 .33251 L .42798 .33736 L F
0 g
.006 w
.36181 .35403 m
.38049 .34671 L
s
.25 g
.5 Mabswid
.36181 .35403 m
.36775 .35233 L
s
0 g
.006 w
.79438 .69551 m
.8047 .68645 L
s
.28464 .79854 m .40344 .79354 L .40297 .79192 L .245 0 0 r
F
1 0 0 r
.003 w
.40297 .79192 m
.40331 .78951 L
s
.25 g
.5 Mabswid
.28629 .78395 m
.40297 .79192 L
s
.83433 .6306 m .77351 .5644 L .77734 .55522 L .368 .313 .664 r
F
.25 g
.76227 .62397 m
.77379 .64093 L
s
.82871 .64738 m .77351 .5644 L .83433 .6306 L .421 .344 .664 r
F
.25 g
.77379 .64093 m
.80326 .68432 L
s
.76766 .60982 m
.77873 .62553 L
s
1 0 0 r
.003 w
.76813 .5731 m
.77351 .5644 L
s
.25 g
.5 Mabswid
.82705 .64534 m
.82748 .64587 L
s
.82748 .64587 m
.82847 .64709 L
s
.82847 .64709 m
.82871 .64738 L
s
.64406 .28135 m .60366 .36484 L .59001 .35654 L .772 .541 .585 r
F
.25 g
.59001 .35654 m
.59145 .35319 L
s
.57753 .34545 m
.59948 .2845 L
s
.66527 .28301 m .60366 .36484 L .64406 .28135 L .764 .564 .628 r
F
.25 g
.62161 .28296 m
.62225 .28147 L
s
0 g
.006 w
.62225 .28147 m
.64406 .28135 L
s
.28533 .81307 m .40344 .79354 L .28464 .79854 L .056 0 0 r
F
0 g
.28464 .79854 m
.28629 .78395 L
s
.83873 .61216 m .77734 .55522 L .77956 .54562 L .315 .291 .673 r
F
.25 g
.5 Mabswid
.80289 .63694 m
.82033 .66026 L
s
.83433 .6306 m .77734 .55522 L .83873 .61216 L .368 .313 .664 r
F
.25 g
.77152 .59502 m
.78202 .60906 L
s
.80454 .61774 m
.82705 .64534 L
s
.76813 .5731 m
.78329 .59169 L
s
1 0 0 r
.003 w
.77351 .5644 m
.77734 .55522 L
s
.25 g
.5 Mabswid
.83251 .62862 m
.83296 .62911 L
s
.83296 .62911 m
.83401 .63026 L
s
.83401 .63026 m
.83433 .6306 L
s
.77873 .62553 m
.81239 .67327 L
s
.34428 .36106 m .4201 .34313 L .32806 .36772 L .143 0 0 r
F
.34428 .36106 m .42798 .33736 L .4201 .34313 L F
0 g
.006 w
.34428 .36106 m
.36181 .35403 L
s
.25 g
.5 Mabswid
.34428 .36106 m
.34435 .36104 L
s
.34435 .36104 m
.35642 .35762 L
s
.40179 .33879 m
.45767 .32564 L
s
.28533 .81307 m .40454 .79433 L .40344 .79354 L .056 0 0 r
F
1 0 0 r
.003 w
.40297 .79192 m
.40344 .79354 L
s
.25 g
.5 Mabswid
.28464 .79854 m
.40344 .79354 L
s
.84188 .59223 m .77956 .54562 L .78014 .53568 L .272 .285 .692 r
F
.83873 .61216 m .77956 .54562 L .84188 .59223 L .315 .291 .673 r
F
1 0 0 r
.003 w
.77734 .55522 m
.77956 .54562 L
s
.25 g
.5 Mabswid
.83658 .61016 m
.83711 .61066 L
s
.83711 .61066 m
.83828 .61174 L
s
.83828 .61174 m
.83873 .61216 L
s
.80312 .59663 m
.83251 .62862 L
s
.78202 .60906 m
.80289 .63694 L
s
.66527 .28301 m .61722 .37359 L .60366 .36484 L .764 .564 .628 r
F
.25 g
.60366 .36484 m
.6052 .36166 L
s
.68573 .28658 m .61722 .37359 L .66527 .28301 L .754 .582 .663 r
F
.25 g
.6216 .28298 m
.62161 .28296 L
s
.64326 .283 m
.64406 .28135 L
s
0 g
.006 w
.64406 .28135 m
.66527 .28301 L
s
.8047 .68645 m
.81388 .67538 L
s
.84377 .57103 m .78014 .53568 L .77909 .5255 L .248 .301 .721 r
F
.84188 .59223 m .78014 .53568 L .84377 .57103 L .272 .285 .692 r
F
1 0 0 r
.003 w
.77956 .54562 m
.78014 .53568 L
s
.25 g
.5 Mabswid
.8383 .58954 m
.83881 .58993 L
s
.83881 .58993 m
.83969 .59059 L
s
.83969 .59059 m
.84117 .59169 L
s
.84117 .59169 m
.84188 .59223 L
s
.78329 .59169 m
.80454 .61774 L
s
.84435 .5488 m .77909 .5255 L .77644 .51521 L .253 .338 .757 r
F
.84377 .57103 m .77909 .5255 L .84435 .5488 L .248 .301 .721 r
F
1 0 0 r
.003 w
.77909 .5255 m
.78014 .53568 L
s
.25 g
.5 Mabswid
.80675 .55046 m
.83899 .56838 L
s
.83899 .56838 m
.84377 .57103 L
s
.77734 .55522 m
.83658 .61016 L
s
.77351 .5644 m
.78788 .58004 L
s
.78788 .58004 m
.80312 .59663 L
s
.32806 .36772 m .41329 .34977 L .3133 .37399 L .275 0 .087 r
F
.32806 .36772 m .4201 .34313 L .41329 .34977 L F
0 g
.006 w
.32806 .36772 m
.34428 .36106 L
s
.25 g
.5 Mabswid
.32806 .36772 m
.32811 .36771 L
s
.32811 .36771 m
.33525 .3658 L
s
.40198 .34797 m
.4201 .34313 L
s
.38303 .34602 m
.44684 .32858 L
s
.2884 .82726 m .40454 .79433 L .28533 .81307 L 0 0 0 r
F
0 g
.006 w
.28464 .79854 m
.28533 .81307 L
s
.2884 .82726 m .40609 .7943 L .40454 .79433 L 0 0 0 r
F
1 0 0 r
.003 w
.40344 .79354 m
.40454 .79433 L
s
.25 g
.5 Mabswid
.28533 .81307 m
.40454 .79433 L
s
.84359 .52583 m .77644 .51521 L .77223 .50491 L .286 .39 .795 r
F
.84435 .5488 m .77644 .51521 L .84359 .52583 L .253 .338 .757 r
F
1 0 0 r
.003 w
.77644 .51521 m
.77909 .5255 L
s
.25 g
.5 Mabswid
.84392 .54865 m
.84435 .5488 L
s
.80137 .53346 m
.84392 .54865 L
s
.78014 .53568 m
.80675 .55046 L
s
.77956 .54562 m
.8383 .58954 L
s
.68573 .28658 m .6307 .38263 L .61722 .37359 L .754 .582 .663 r
F
.25 g
.61722 .37359 m
.61986 .36862 L
s
.59145 .35319 m
.6216 .28298 L
s
.70532 .29219 m .6307 .38263 L .68573 .28658 L .743 .596 .693 r
F
.25 g
.64326 .28301 m
.64326 .283 L
s
.66432 .28479 m
.66527 .28301 L
s
0 g
.006 w
.66527 .28301 m
.68573 .28658 L
s
.84147 .5024 m .77223 .50491 L .76655 .4947 L .339 .448 .826 r
F
.84359 .52583 m .77223 .50491 L .84147 .5024 L .286 .39 .795 r
F
1 0 0 r
.003 w
.77223 .50491 m
.77644 .51521 L
s
.25 g
.5 Mabswid
.84276 .5257 m
.84359 .52583 L
s
.78571 .51668 m
.84276 .5257 L
s
.77644 .51521 m
.78571 .51668 L
s
.77909 .5255 m
.80137 .53346 L
s
.83796 .47884 m .76655 .4947 L .7595 .48465 L .401 .502 .847 r
F
.84147 .5024 m .76655 .4947 L .83796 .47884 L .339 .448 .826 r
F
1 0 0 r
.003 w
.76655 .4947 m
.77223 .50491 L
s
.25 g
.5 Mabswid
.77223 .50491 m
.84147 .5024 L
s
0 g
.006 w
.81388 .67538 m
.82188 .66234 L
s
.83302 .45546 m .7595 .48465 L .75121 .47482 L .461 .545 .856 r
F
.83796 .47884 m .7595 .48465 L .83302 .45546 L .401 .502 .847 r
F
.25 g
.5 Mabswid
.76655 .4947 m
.83796 .47884 L
s
1 0 0 r
.003 w
.7595 .48465 m
.76655 .4947 L
s
.29383 .84082 m .40609 .7943 L .2884 .82726 L .286 .766 .667 r
F
0 g
.006 w
.28533 .81307 m
.2884 .82726 L
s
.29383 .84082 m .40789 .79345 L .40609 .7943 L .286 .766 .667 r
F
1 0 0 r
.003 w
.40454 .79433 m
.40584 .7943 L
s
.25 g
.5 Mabswid
.2884 .82726 m
.40538 .79449 L
s
.82662 .43258 m .75121 .47482 L .74181 .46522 L .516 .577 .855 r
F
.83302 .45546 m .75121 .47482 L .82662 .43258 L .461 .545 .856 r
F
1 0 0 r
.003 w
.75121 .47482 m
.7595 .48465 L
s
.25 g
.5 Mabswid
.83175 .45596 m
.83302 .45546 L
s
.3133 .37399 m .40754 .35727 L .30018 .37985 L .382 .027 .233 r
F
.3133 .37399 m .41329 .34977 L .40754 .35727 L F
0 g
.006 w
.3133 .37399 m
.32806 .36772 L
s
.25 g
.5 Mabswid
.3133 .37399 m
.31411 .37379 L
s
.31411 .37379 m
.31461 .37367 L
s
.40244 .35239 m
.41329 .34977 L
s
.36775 .35233 m
.43692 .33251 L
s
.81876 .41051 m .74181 .46522 L .73147 .45583 L .562 .599 .848 r
F
.82662 .43258 m .74181 .46522 L .81876 .41051 L .516 .577 .855 r
F
.25 g
.7595 .48465 m
.83175 .45596 L
s
1 0 0 r
.003 w
.74181 .46522 m
.75121 .47482 L
s
.25 g
.5 Mabswid
.74181 .46522 m
.74383 .46379 L
s
.82528 .43333 m
.82662 .43258 L
s
.70532 .29219 m .6441 .39182 L .6307 .38263 L .743 .596 .693 r
F
.25 g
.6307 .38263 m
.63323 .37822 L
s
.6052 .36166 m
.64326 .28301 L
s
.72392 .29992 m .6441 .39182 L .70532 .29219 L .73 .606 .719 r
F
.25 g
.66432 .28479 m
.66432 .28479 L
s
.68465 .28846 m
.68573 .28658 L
s
0 g
.006 w
.68573 .28658 m
.70532 .29219 L
s
.80943 .38957 m .73147 .45583 L .72032 .44661 L .6 .613 .836 r
F
.81876 .41051 m .73147 .45583 L .80943 .38957 L .562 .599 .848 r
F
1 0 0 r
.003 w
.73147 .45583 m
.74181 .46522 L
s
.25 g
.5 Mabswid
.73147 .45583 m
.73542 .45247 L
s
.81747 .41143 m
.81876 .41051 L
s
.81735 .41151 m
.81747 .41143 L
s
.79863 .37 m .72032 .44661 L .70852 .43751 L .632 .62 .82 r
F
.80943 .38957 m .72032 .44661 L .79863 .37 L .6 .613 .836 r
F
1 0 0 r
.003 w
.72032 .44661 m
.73147 .45583 L
s
.25 g
.5 Mabswid
.72032 .44661 m
.72335 .44365 L
s
.80807 .39072 m
.80943 .38957 L
s
.80798 .3908 m
.80807 .39072 L
s
.78638 .35207 m .70852 .43751 L .69621 .42844 L .658 .623 .803 r
F
.79863 .37 m .70852 .43751 L .78638 .35207 L .632 .62 .82 r
F
.25 g
.75121 .47482 m
.82528 .43333 L
s
1 0 0 r
.003 w
.70852 .43751 m
.72032 .44661 L
s
.25 g
.5 Mabswid
.70852 .43751 m
.71287 .43273 L
s
.79782 .3708 m
.79863 .37 L
s
.79723 .37137 m
.79782 .3708 L
s
.79715 .37145 m
.79723 .37137 L
s
.77273 .33596 m .69621 .42844 L .68353 .41936 L .68 .623 .784 r
F
.78638 .35207 m .69621 .42844 L .77273 .33596 L .658 .623 .803 r
F
1 0 0 r
.003 w
.69621 .42844 m
.70852 .43751 L
s
.25 g
.5 Mabswid
.69621 .42844 m
.69933 .42468 L
s
.78554 .353 m
.78638 .35207 L
s
.78496 .35363 m
.78554 .353 L
s
.7849 .3537 m
.78496 .35363 L
s
.75772 .32184 m .68353 .41936 L .67056 .41023 L .699 .62 .764 r
F
.77273 .33596 m .68353 .41936 L .75772 .32184 L .68 .623 .784 r
F
.25 g
.70456 .29344 m
.70532 .29219 L
s
.74383 .46379 m
.81735 .41151 L
s
1 0 0 r
.003 w
.68353 .41936 m
.69621 .42844 L
s
.25 g
.5 Mabswid
.68665 .41526 m
.68733 .41436 L
s
.68353 .41936 m
.68665 .41526 L
s
.77186 .33701 m
.77273 .33596 L
s
.77131 .33768 m
.77186 .33701 L
s
.77126 .33774 m
.77131 .33768 L
s
0 g
.006 w
.82188 .66234 m
.82871 .64738 L
s
.30155 .85344 m .40789 .79345 L .29383 .84082 L .419 .84 .68 r
F
0 g
.2884 .82726 m
.29383 .84082 L
s
.30155 .85344 m .40978 .79187 L .40789 .79345 L .419 .84 .68 r
F
.25 g
.5 Mabswid
.29383 .84082 m
.40459 .79482 L
s
.74142 .30981 m .67056 .41023 L .6574 .40104 L .715 .614 .743 r
F
.75772 .32184 m .67056 .41023 L .74142 .30981 L .699 .62 .764 r
F
.25 g
.70414 .29412 m
.70456 .29344 L
s
1 0 0 r
.003 w
.67056 .41023 m
.68353 .41936 L
s
.25 g
.5 Mabswid
.67056 .41023 m
.67314 .40658 L
s
.75685 .32298 m
.75772 .32184 L
s
.75632 .32367 m
.75685 .32298 L
s
.75629 .32372 m
.75632 .32367 L
s
.72392 .29992 m .6574 .40104 L .6441 .39182 L .73 .606 .719 r
F
.25 g
.6441 .39182 m
.6464 .38808 L
s
.74142 .30981 m .6574 .40104 L .72392 .29992 L .715 .614 .743 r
F
0 g
.006 w
.70532 .29219 m
.72392 .29992 L
s
.25 g
.5 Mabswid
.61986 .36862 m
.66432 .28479 L
s
.63323 .37822 m
.68465 .28846 L
s
.6464 .38808 m
.70413 .29414 L
s
.70413 .29414 m
.70414 .29412 L
s
.72335 .44365 m
.79715 .37145 L
s
.71287 .43273 m
.7849 .3537 L
s
.69933 .42468 m
.77126 .33774 L
s
.68733 .41436 m
.75629 .32372 L
s
.67314 .40658 m
.74005 .31175 L
s
1 0 0 r
.003 w
.6574 .40104 m
.67056 .41023 L
s
.25 g
.5 Mabswid
.66052 .3963 m
.72263 .30189 L
s
.72263 .30189 m
.72265 .30186 L
s
.72265 .30186 m
.72311 .30116 L
s
.72311 .30116 m
.72392 .29992 L
s
.6574 .40104 m
.66052 .3963 L
s
.74057 .31101 m
.74142 .30981 L
s
.74007 .31171 m
.74057 .31101 L
s
.74005 .31175 m
.74007 .31171 L
s
.73542 .45247 m
.80798 .3908 L
s
0 g
.006 w
.72392 .29992 m
.74142 .30981 L
s
1 0 0 r
.003 w
.6441 .39182 m
.6574 .40104 L
s
.30018 .37985 m .40279 .36564 L .28886 .3853 L .465 .143 .335 r
F
.30018 .37985 m .40754 .35727 L .40279 .36564 L F
0 g
.006 w
.30018 .37985 m
.3133 .37399 L
s
.25 g
.5 Mabswid
.30018 .37985 m
.30044 .37979 L
s
.30044 .37979 m
.3014 .37959 L
s
.3014 .37959 m
.30177 .37951 L
s
.39973 .35892 m
.40754 .35727 L
s
.38647 .3617 m
.39973 .35892 L
s
.38034 .35775 m
.40244 .35239 L
s
.35642 .35762 m
.42798 .33736 L
s
1 0 0 r
.003 w
.6307 .38263 m
.6441 .39182 L
s
.61722 .37359 m
.6307 .38263 L
s
.60366 .36484 m
.61722 .37359 L
s
.59001 .35654 m
.60366 .36484 L
s
.5763 .34886 m
.59001 .35654 L
s
.56252 .34197 m
.5763 .34886 L
s
.5487 .336 m
.56252 .34197 L
s
.53491 .33107 m
.5487 .336 L
s
.5212 .32726 m
.53491 .33107 L
s
.50766 .32463 m
.5212 .32726 L
s
.49442 .32317 m
.50766 .32463 L
s
.48158 .32288 m
.49442 .32317 L
s
.46929 .32372 m
.48158 .32288 L
s
.31147 .86484 m .40978 .79187 L .30155 .85344 L .525 .884 .659 r
F
0 g
.006 w
.29383 .84082 m
.30155 .85344 L
s
.31251 .86407 m .41161 .78965 L .40978 .79187 L .525 .884 .659 r
F
.31351 .86331 m .41161 .78965 L .31251 .86407 L F
.31147 .86484 m .31351 .86331 L .31251 .86407 L F
.32343 .87472 m .41161 .78965 L .31147 .86484 L .607 .9 .611 r
F
.32435 .87383 m .41327 .78691 L .41161 .78965 L F
.32343 .87472 m .32524 .87295 L .32435 .87383 L F
.32524 .87295 m .41327 .78691 L .32435 .87383 L F
.33721 .88282 m .41209 .7884 L .32343 .87472 L .667 .892 .538 r
F
.41209 .7884 m .41327 .78691 L .41054 .78957 L F
.41209 .7884 m .41054 .78957 L .32343 .87472 L F
.338 .88183 m .4147 .78378 L .41327 .78691 L F
.33721 .88282 m .33876 .88083 L .338 .88183 L F
.33876 .88083 m .4147 .78378 L .338 .88183 L F
.35259 .8889 m .41391 .78513 L .33721 .88282 L .703 .858 .443 r
F
.41391 .78513 m .4147 .78378 L .41276 .78627 L F
.41391 .78513 m .41276 .78627 L .33721 .88282 L F
.35322 .88783 m .4159 .78037 L .4147 .78378 L F
.35259 .8889 m .35384 .88674 L .35322 .88783 L F
.35384 .88674 m .4159 .78037 L .35322 .88783 L F
.36926 .89276 m .41542 .78153 L .35259 .8889 L .715 .799 .326 r
F
.41542 .78153 m .4159 .78037 L .41463 .78256 L F
.41542 .78153 m .41463 .78256 L .35259 .8889 L F
.36973 .89163 m .41688 .77679 L .4159 .78037 L F
.36926 .89276 m .3702 .89048 L .36973 .89163 L F
.3702 .89048 m .41688 .77679 L .36973 .89163 L F
.38692 .89425 m .41665 .77769 L .36926 .89276 L .7 .713 .187 r
F
.41665 .77769 m .41688 .77679 L .41616 .77855 L F
.41665 .77769 m .41616 .77855 L .36926 .89276 L F
.38692 .89425 m .41772 .77308 L .41688 .77679 L F
.40522 .89326 m .41765 .77371 L .38692 .89425 L 0 0 0 r
F
.41765 .77371 m .41772 .77308 L .4174 .77432 L F
.41765 .77371 m .4174 .77432 L .38692 .89425 L F
.25 g
.5 Mabswid
.30155 .85344 m
.3038 .85217 L
s
.3038 .85217 m
.40512 .79452 L
s
0 g
.006 w
.74142 .30981 m
.75772 .32184 L
s
.82871 .64738 m
.83433 .6306 L
s
1 0 0 r
.003 w
.45767 .32564 m
.46929 .32372 L
s
.44684 .32858 m
.45767 .32564 L
s
.28886 .3853 m .39896 .37485 L .2795 .39039 L .53 .231 .404 r
F
.28886 .3853 m .40279 .36564 L .39896 .37485 L F
0 g
.006 w
.28886 .3853 m
.30018 .37985 L
s
.25 g
.5 Mabswid
.28886 .3853 m
.28944 .3852 L
s
.28944 .3852 m
.29038 .38504 L
s
.29038 .38504 m
.29066 .38499 L
s
.38731 .36831 m
.40279 .36564 L
s
.31461 .37367 m
.38034 .35775 L
s
.33525 .3658 m
.40198 .34797 L
s
1 0 0 r
.003 w
.43692 .33251 m
.44684 .32858 L
s
0 g
.006 w
.30155 .85344 m
.31147 .86484 L
s
.75772 .32184 m
.77273 .33596 L
s
.25 g
.5 Mabswid
.31147 .86484 m
.31351 .86331 L
s
.31351 .86331 m
.31352 .8633 L
s
.31352 .8633 m
.40668 .79334 L
s
0 g
.006 w
.83433 .6306 m
.83873 .61216 L
s
1 0 0 r
.003 w
.42798 .33736 m
.43692 .33251 L
s
.4201 .34313 m
.42798 .33736 L
s
0 g
.006 w
.77273 .33596 m
.78638 .35207 L
s
.83873 .61216 m
.84188 .59223 L
s
1 0 0 r
.003 w
.41329 .34977 m
.4201 .34313 L
s
.2795 .39039 m .39593 .38489 L .27228 .39516 L .582 .299 .452 r
F
.2795 .39039 m .39896 .37485 L .39593 .38489 L F
.25 g
.5 Mabswid
.29066 .38499 m
.38731 .36831 L
s
0 g
.006 w
.2795 .39039 m
.28886 .3853 L
s
.25 g
.5 Mabswid
.2795 .39039 m
.28126 .39016 L
s
.28126 .39016 m
.28149 .39013 L
s
.39418 .37547 m
.39896 .37485 L
s
.30177 .37951 m
.38647 .3617 L
s
.32343 .87472 m
.32524 .87295 L
s
.32524 .87295 m
.32524 .87294 L
s
.32524 .87294 m
.40896 .79112 L
s
0 g
.006 w
.31147 .86484 m
.32343 .87472 L
s
.78638 .35207 m
.79863 .37 L
s
1 0 0 r
.003 w
.40754 .35727 m
.41329 .34977 L
s
0 g
.006 w
.84188 .59223 m
.84377 .57103 L
s
1 0 0 r
.003 w
.40279 .36564 m
.40754 .35727 L
s
.25 g
.5 Mabswid
.33721 .88282 m
.33876 .88083 L
s
.33876 .88083 m
.41159 .78776 L
s
0 g
.006 w
.79863 .37 m
.80943 .38957 L
s
.32343 .87472 m
.33721 .88282 L
s
.84377 .57103 m
.84435 .5488 L
s
.27228 .39516 m .39355 .39573 L .26733 .39969 L .626 .353 .485 r
F
.27228 .39516 m .39593 .38489 L .39355 .39573 L F
0 g
.27228 .39516 m
.2795 .39039 L
s
.25 g
.5 Mabswid
.27228 .39516 m
.27421 .39499 L
s
.39214 .38521 m
.39593 .38489 L
s
.27441 .39498 m
.39214 .38521 L
s
.27421 .39499 m
.27441 .39498 L
s
.28149 .39013 m
.39418 .37547 L
s
1 0 0 r
.003 w
.39896 .37485 m
.40279 .36564 L
s
0 g
.006 w
.80943 .38957 m
.81876 .41051 L
s
.84359 .52583 m
.84435 .5488 L
s
.25 g
.5 Mabswid
.35259 .8889 m
.35384 .88674 L
s
.35384 .88674 m
.41425 .7832 L
s
0 g
.006 w
.81876 .41051 m
.82662 .43258 L
s
1 0 0 r
.003 w
.39593 .38489 m
.39896 .37485 L
s
0 g
.006 w
.84147 .5024 m
.84359 .52583 L
s
.82662 .43258 m
.83302 .45546 L
s
.83796 .47884 m
.84147 .5024 L
s
.33721 .88282 m
.35259 .8889 L
s
.83302 .45546 m
.83796 .47884 L
s
.26733 .39969 m .39169 .40733 L .26479 .40408 L .665 .398 .507 r
F
.26733 .39969 m .39355 .39573 L .39169 .40733 L F
0 g
.26733 .39969 m
.27228 .39516 L
s
.25 g
.5 Mabswid
.26733 .39969 m
.39355 .39573 L
s
1 0 0 r
.003 w
.39355 .39573 m
.39593 .38489 L
s
.25 g
.5 Mabswid
.36926 .89276 m
.3702 .89048 L
s
.41616 .77855 m
.4166 .77747 L
s
0 g
.006 w
.35259 .8889 m
.36926 .89276 L
s
.26479 .40408 m .39169 .40733 L .39018 .41961 L .701 .437 .522 r
F
1 0 0 r
.003 w
.39169 .40733 m
.39355 .39573 L
s
.40522 .89326 m .41848 .76928 L .41772 .77308 L 0 0 0 r
F
.25 g
.5 Mabswid
.4174 .77432 m
.41772 .77308 L
s
.3702 .89048 m
.41616 .77855 L
s
.26479 .40408 m .39018 .41961 L .26477 .40847 L .701 .437 .522 r
F
0 g
.006 w
.26479 .40408 m
.26733 .39969 L
s
.25 g
.5 Mabswid
.26479 .40408 m
.39169 .40733 L
s
.26477 .40847 m .39018 .41961 L .38892 .4325 L .735 .472 .532 r
F
1 0 0 r
.003 w
.39018 .41961 m
.39169 .40733 L
s
0 g
.006 w
.36926 .89276 m
.38692 .89425 L
s
.42382 .88972 m .41848 .76928 L .40522 .89326 L 0 0 .138 r
F
.25 g
.5 Mabswid
.40522 .89326 m
.41842 .76991 L
s
.38692 .89425 m
.38752 .89189 L
s
.38752 .89189 m
.4174 .77432 L
s
.42382 .88972 m .41927 .76534 L .41848 .76928 L 0 0 .138 r
F
1 0 0 r
.003 w
.41772 .77308 m
.41848 .76928 L
s
.25 g
.5 Mabswid
.41842 .76991 m
.41848 .76928 L
s
.26733 .41299 m .38892 .4325 L .38781 .44588 L .769 .506 .536 r
F
.26477 .40847 m .38892 .4325 L .26733 .41299 L .735 .472 .532 r
F
.25 g
.26477 .40847 m
.39018 .41961 L
s
1 0 0 r
.003 w
.38892 .4325 m
.39018 .41961 L
s
0 g
.006 w
.26477 .40847 m
.26479 .40408 L
s
.2725 .41781 m .38781 .44588 L .3868 .45964 L .804 .538 .537 r
F
.31488 .42597 m .38781 .44588 L .32394 .43033 L .769 .506 .536 r
F
.28026 .4231 m .3868 .45964 L .38588 .47367 L .84 .571 .531 r
F
.2725 .41781 m .33586 .441 L .28026 .4231 L .804 .538 .537 r
F
.33586 .441 m .3868 .45964 L .34278 .44455 L F
.33586 .441 m .34278 .44455 L .28026 .4231 L F
.29052 .42906 m .38588 .47367 L .3851 .48785 L .879 .605 .519 r
F
.28026 .4231 m .36055 .46154 L .29052 .42906 L .84 .571 .531 r
F
.36055 .46154 m .38588 .47367 L .36441 .46362 L F
.36055 .46154 m .36441 .46362 L .29052 .42906 L F
.33326 .40777 m .39714 .47616 L .39613 .48947 L .965 .683 .449 r
F
.37379 .46044 m .38464 .47454 L .37948 .46336 L F
.38464 .47454 m .39527 .48835 L .38765 .47617 L F
.38464 .47454 m .38765 .47617 L .37948 .46336 L F
.37379 .46044 m .37948 .46336 L .3737 .45429 L F
.39527 .48835 m .39613 .48947 L .39489 .48753 L F
.39527 .48835 m .39489 .48753 L .38765 .47617 L F
.36632 .45074 m .37379 .46044 L .3737 .45429 L F
.36632 .45074 m .3737 .45429 L .34922 .41588 L F
.34922 .41588 m .39613 .48947 L .39552 .50275 L .987 .713 .379 r
F
.34922 .41588 m .39476 .50132 L .36668 .42551 L F
.39476 .50132 m .39552 .50275 L .39461 .50031 L F
.39476 .50132 m .39461 .50031 L .36668 .42551 L F
.36698 .42648 m .39552 .50275 L .39541 .51595 L .953 .705 .248 r
F
.36728 .42713 m .39552 .50275 L .36698 .42648 L F
.36668 .42551 m .36728 .42713 L .36698 .42648 L F
.36668 .42551 m .39541 .51595 L .38527 .43676 L F
.38538 .43777 m .39541 .51595 L .3959 .52909 L .79 .603 .039 r
F
.38527 .43676 m .38548 .43844 L .38538 .43777 L F
.38548 .43844 m .39541 .51595 L .38538 .43777 L F
.33326 .40777 m .36632 .45074 L .34922 .41588 L .965 .683 .449 r
F
.26733 .41299 m .31488 .42597 L .2725 .41781 L .769 .506 .536 r
F
.31488 .42597 m .32394 .43033 L .2725 .41781 L F
.25 g
.5 Mabswid
.26964 .41336 m
.30702 .41935 L
s
.30702 .41935 m
.34712 .42579 L
s
.38848 .43242 m
.38892 .4325 L
s
.3874 .43225 m
.38848 .43242 L
s
.37436 .43016 m
.3874 .43225 L
s
1 0 0 r
.003 w
.38781 .44588 m
.38892 .4325 L
s
.25 g
.5 Mabswid
.2725 .41781 m
.27473 .41835 L
s
.32394 .43033 m
.35677 .43832 L
s
.38738 .44577 m
.38781 .44588 L
s
.38652 .44556 m
.38738 .44577 L
s
.38639 .44553 m
.38652 .44556 L
s
0 g
.006 w
.26477 .40847 m
.26733 .41299 L
s
.25 g
.5 Mabswid
.26733 .41299 m
.26964 .41336 L
s
1 0 0 r
.003 w
.38731 .45271 m
.38781 .44588 L
s
0 g
.006 w
.38692 .89425 m
.40522 .89326 L
s
.44234 .88362 m .41927 .76534 L .42382 .88972 L 0 0 .31 r
F
.44234 .88362 m .42014 .76121 L .41927 .76534 L F
1 0 0 r
.003 w
.41848 .76928 m
.41927 .76534 L
s
.25 g
.5 Mabswid
.28026 .4231 m
.2823 .42381 L
s
.2823 .42381 m
.28235 .42382 L
s
.46043 .87499 m .42014 .76121 L .44234 .88362 L 0 0 .472 r
F
.25 g
.42373 .88735 m
.42382 .88972 L
s
.46043 .87499 m .42116 .75677 L .42014 .76121 L 0 0 .472 r
F
.25 g
.41927 .76534 m
.4193 .76627 L
s
1 0 0 r
.003 w
.41927 .76534 m
.42014 .76121 L
s
.38525 .48513 m
.38531 .48415 L
s
0 g
.006 w
.40522 .89326 m
.42382 .88972 L
s
.26733 .41299 m
.2725 .41781 L
s
.29052 .42906 m .3851 .48785 L .30313 .43586 L .879 .605 .519 r
F
.25 g
.5 Mabswid
.36608 .47579 m
.3851 .48785 L
s
.3048 .43691 m
.36608 .47579 L
s
.30478 .4369 m
.3048 .43691 L
s
.30419 .43653 m
.30478 .4369 L
s
.30313 .43586 m
.30419 .43653 L
s
1 0 0 r
.003 w
.3851 .48785 m
.38525 .48513 L
s
.25 g
.5 Mabswid
.36441 .46362 m
.37807 .47002 L
s
.3462 .45511 m
.36441 .46362 L
s
.29242 .42995 m
.3462 .45511 L
s
.29239 .42994 m
.29242 .42995 L
s
.29171 .42962 m
.29239 .42994 L
s
.29052 .42906 m
.29171 .42962 L
s
.34278 .44455 m
.36829 .45329 L
s
.28235 .42382 m
.34278 .44455 L
s
.27473 .41835 m
.32394 .43033 L
s
.39576 .47468 m
.39714 .47616 L
s
.39473 .47358 m
.39576 .47468 L
s
.39341 .47217 m
.39473 .47358 L
s
.38923 .46769 m
.39341 .47217 L
s
1 0 0 r
.003 w
.39613 .48947 m
.39714 .47616 L
s
.47776 .86392 m .42116 .75677 L .46043 .87499 L 0 .052 .612 r
F
.25 g
.5 Mabswid
.44192 .88131 m
.44234 .88362 L
s
.47776 .86392 m .42233 .75191 L .42116 .75677 L 0 .052 .612 r
F
.25 g
.41936 .768 m
.42373 .88735 L
s
.4193 .76627 m
.41936 .768 L
s
.42014 .76121 m
.4204 .76261 L
s
1 0 0 r
.003 w
.42014 .76121 m
.42116 .75677 L
s
0 g
.006 w
.42382 .88972 m
.44234 .88362 L
s
.25 g
.5 Mabswid
.39489 .48753 m
.39613 .48947 L
s
.39399 .48612 m
.39489 .48753 L
s
.39098 .4814 m
.39399 .48612 L
s
1 0 0 r
.003 w
.39552 .50275 m
.39613 .48947 L
s
0 g
.006 w
.2725 .41781 m
.28026 .4231 L
s
.49398 .85053 m .42233 .75191 L .47776 .86392 L 0 .205 .721 r
F
.25 g
.5 Mabswid
.45971 .8728 m
.46043 .87499 L
s
.49398 .85053 m .42363 .74647 L .42233 .75191 L 0 .205 .721 r
F
.25 g
.42082 .76495 m
.44192 .88131 L
s
.4204 .76261 m
.42082 .76495 L
s
.42116 .75677 m
.42179 .75867 L
s
1 0 0 r
.003 w
.42116 .75677 m
.42233 .75191 L
s
0 g
.006 w
.44234 .88362 m
.46043 .87499 L
s
.25 g
.5 Mabswid
.39461 .50031 m
.39552 .50275 L
s
.39278 .49542 m
.39461 .50031 L
s
1 0 0 r
.003 w
.39541 .51595 m
.39552 .50275 L
s
.50879 .83495 m .42363 .74647 L .49398 .85053 L .132 .332 .797 r
F
.25 g
.5 Mabswid
.47675 .86188 m
.47776 .86392 L
s
.50879 .83495 m .42499 .74034 L .42363 .74647 L .132 .332 .797 r
F
.25 g
.42278 .76165 m
.45971 .8728 L
s
.42179 .75867 m
.42278 .76165 L
s
.42233 .75191 m
.42352 .75431 L
s
1 0 0 r
.003 w
.42233 .75191 m
.42363 .74647 L
s
0 g
.006 w
.28026 .4231 m
.29052 .42906 L
s
.46043 .87499 m
.47776 .86392 L
s
.52193 .81739 m .42499 .74034 L .50879 .83495 L .257 .43 .842 r
F
.25 g
.5 Mabswid
.49272 .84867 m
.49398 .85053 L
s
.52193 .81739 m .42632 .73341 L .42499 .74034 L .257 .43 .842 r
F
.25 g
.42533 .75796 m
.47675 .86188 L
s
.42352 .75431 m
.42533 .75796 L
s
.42363 .74647 m
.4256 .74939 L
s
1 0 0 r
.003 w
.42363 .74647 m
.42499 .74034 L
s
.40459 .44972 m .3959 .52909 L .39706 .54219 L 0 0 .2 r
F
.38527 .43676 m .3959 .52909 L .40459 .44972 L .79 .603 .039 r
F
0 g
.006 w
.47776 .86392 m
.49398 .85053 L
s
.53314 .79804 m .42632 .73341 L .52193 .81739 L .36 .498 .862 r
F
.25 g
.5 Mabswid
.50734 .83331 m
.50879 .83495 L
s
.53314 .79804 m .42748 .7256 L .42632 .73341 L .36 .498 .862 r
F
.25 g
.4256 .74939 m
.42856 .75376 L
s
.42499 .74034 m
.42804 .74378 L
s
1 0 0 r
.003 w
.42499 .74034 m
.42632 .73341 L
s
.42422 .4644 m .39706 .54219 L .39888 .55528 L 0 0 .382 r
F
.25 g
.5 Mabswid
.3959 .52909 m
.39628 .52568 L
s
.40459 .44972 m .39706 .54219 L .42422 .4644 L 0 0 .2 r
F
1 0 0 r
.003 w
.3959 .52909 m
.39706 .54219 L
s
0 g
.006 w
.29052 .42906 m
.30313 .43586 L
s
.54221 .77714 m .42748 .7256 L .53314 .79804 L .44 .541 .863 r
F
.25 g
.5 Mabswid
.52034 .81599 m
.52193 .81739 L
s
.54221 .77714 m .42834 .71686 L .42748 .7256 L .44 .541 .863 r
F
.25 g
.43288 .76016 m
.49272 .84867 L
s
.42856 .75376 m
.43288 .76016 L
s
.42804 .74378 m
.43263 .74897 L
s
.42632 .73341 m
.43087 .73741 L
s
1 0 0 r
.003 w
.42632 .73341 m
.42748 .7256 L
s
.44372 .48079 m .39888 .55528 L .40133 .5684 L .064 .021 .492 r
F
.25 g
.5 Mabswid
.39706 .54219 m
.39841 .53831 L
s
.39628 .52568 m
.39654 .52326 L
s
.42422 .4644 m .39888 .55528 L .44372 .48079 L 0 0 .382 r
F
1 0 0 r
.003 w
.39706 .54219 m
.39888 .55528 L
s
.25 g
.5 Mabswid
.42363 .46609 m
.42422 .4644 L
s
0 g
.006 w
.49398 .85053 m
.50879 .83495 L
s
.46267 .49884 m .40133 .5684 L .40432 .58158 L .227 .151 .557 r
F
.25 g
.5 Mabswid
.39888 .55528 m
.40148 .55096 L
s
.39841 .53831 m
.39938 .53553 L
s
.39654 .52326 m
.39688 .52018 L
s
.44372 .48079 m .40133 .5684 L .46267 .49884 L .064 .021 .492 r
F
1 0 0 r
.003 w
.39888 .55528 m
.40133 .5684 L
s
.25 g
.5 Mabswid
.44271 .48247 m
.44372 .48079 L
s
.54898 .75493 m .42834 .71686 L .54221 .77714 L .5 .564 .852 r
F
.25 g
.53148 .79691 m
.53314 .79804 L
s
.54898 .75493 m .42877 .70722 L .42834 .71686 L .5 .564 .852 r
F
.25 g
.43953 .75676 m
.50734 .83331 L
s
.43263 .74897 m
.43953 .75676 L
s
.43087 .73741 m
.43794 .74362 L
s
.42748 .7256 m
.43428 .73026 L
s
1 0 0 r
.003 w
.42748 .7256 m
.42834 .71686 L
s
0 g
.006 w
.50879 .83495 m
.52193 .81739 L
s
.48066 .51842 m .40432 .58158 L .40772 .59484 L .34 .246 .6 r
F
.25 g
.5 Mabswid
.40133 .5684 m
.4055 .56368 L
s
.40148 .55096 m
.40337 .54782 L
s
.39938 .53553 m
.40063 .53196 L
s
.39688 .52018 m
.39731 .51622 L
s
.46267 .49884 m .40432 .58158 L .48066 .51842 L .227 .151 .557 r
F
.25 g
.39731 .51622 m
.40459 .44972 L
s
1 0 0 r
.003 w
.40133 .5684 m
.40432 .58158 L
s
.25 g
.5 Mabswid
.46169 .49994 m
.46267 .49884 L
s
.46127 .50042 m
.46169 .49994 L
s
0 g
.006 w
.33326 .40777 m
.34922 .41588 L
s
.55329 .73167 m .42877 .70722 L .54898 .75493 L .541 .57 .833 r
F
.25 g
.5 Mabswid
.54059 .77629 m
.54221 .77714 L
s
.43794 .74362 m
.52034 .81599 L
s
.55329 .73167 m .42865 .6967 L .42877 .70722 L .541 .57 .833 r
F
.25 g
.44559 .73801 m
.53148 .79691 L
s
.43428 .73026 m
.44559 .73801 L
s
.42834 .71686 m
.43894 .72247 L
s
1 0 0 r
.003 w
.42834 .71686 m
.42877 .70722 L
s
.49733 .5394 m .40772 .59484 L .41135 .60817 L .419 .317 .633 r
F
.25 g
.5 Mabswid
.4055 .56368 m
.40859 .56016 L
s
.40337 .54782 m
.40584 .54372 L
s
.48066 .51842 m .40772 .59484 L .49733 .5394 L .34 .246 .6 r
F
.25 g
.40432 .58158 m
.41047 .5765 L
s
1 0 0 r
.003 w
.40432 .58158 m
.40772 .59484 L
s
.25 g
.5 Mabswid
.48056 .5185 m
.48066 .51842 L
s
.47941 .51945 m
.48056 .5185 L
s
.47888 .51989 m
.47941 .51945 L
s
.40063 .53196 m
.42363 .46609 L
s
.55507 .70761 m .42865 .6967 L .55329 .73167 L .566 .564 .81 r
F
.25 g
.54759 .75438 m
.54898 .75493 L
s
.43894 .72247 m
.54059 .77629 L
s
.55507 .70761 m .4279 .6854 L .42865 .6967 L .566 .564 .81 r
F
.25 g
.44769 .71473 m
.54759 .75438 L
s
.42877 .70722 m
.44769 .71473 L
s
1 0 0 r
.003 w
.42865 .6967 m
.42877 .70722 L
s
0 g
.006 w
.52193 .81739 m
.53314 .79804 L
s
.51234 .5616 m .41135 .60817 L .41502 .62152 L .477 .375 .66 r
F
.49733 .5394 m .41135 .60817 L .51234 .5616 L .419 .317 .633 r
F
.25 g
.5 Mabswid
.41047 .5765 m
.41519 .57259 L
s
.40772 .59484 m
.41644 .58945 L
s
1 0 0 r
.003 w
.40772 .59484 m
.41135 .60817 L
s
.25 g
.5 Mabswid
.49717 .5395 m
.49733 .5394 L
s
.49581 .54034 m
.49717 .5395 L
s
.49519 .54073 m
.49581 .54034 L
s
.40859 .56016 m
.46127 .50042 L
s
.40584 .54372 m
.44271 .48247 L
s
.55424 .68302 m .4279 .6854 L .55507 .70761 L .578 .549 .785 r
F
.25 g
.55272 .73151 m
.55329 .73167 L
s
.42865 .6967 m
.55272 .73151 L
s
.55424 .68302 m .42647 .67343 L .4279 .6854 L .578 .549 .785 r
F
1 0 0 r
.003 w
.4279 .6854 m
.42865 .6967 L
s
.25 g
.5 Mabswid
.4279 .6854 m
.55507 .70761 L
s
.5254 .58482 m .41502 .62152 L .41853 .63484 L .519 .423 .685 r
F
.51234 .5616 m .41502 .62152 L .5254 .58482 L .477 .375 .66 r
F
1 0 0 r
.003 w
.41135 .60817 m
.41502 .62152 L
s
.25 g
.5 Mabswid
.51055 .56243 m
.51234 .5616 L
s
.50985 .56275 m
.51055 .56243 L
s
.41519 .57259 m
.47888 .51989 L
s
.55081 .65819 m .42647 .67343 L .55424 .68302 L .579 .526 .76 r
F
.55081 .65819 m .42439 .66092 L .42647 .67343 L F
1 0 0 r
.003 w
.42647 .67343 m
.4279 .6854 L
s
.25 g
.5 Mabswid
.42647 .67343 m
.55424 .68302 L
s
0 g
.006 w
.34922 .41588 m
.36668 .42551 L
s
.53628 .60882 m .41853 .63484 L .4217 .64801 L .55 .463 .71 r
F
.5254 .58482 m .41853 .63484 L .53628 .60882 L .519 .423 .685 r
F
1 0 0 r
.003 w
.41502 .62152 m
.41853 .63484 L
s
.25 g
.5 Mabswid
.52257 .58576 m
.5254 .58482 L
s
.42361 .60251 m
.50985 .56275 L
s
.41135 .60817 m
.42361 .60251 L
s
.42347 .5851 m
.49519 .54073 L
s
.41644 .58945 m
.42347 .5851 L
s
.54479 .63336 m .42439 .66092 L .55081 .65819 L .569 .497 .735 r
F
.54479 .63336 m .4217 .64801 L .42439 .66092 L F
1 0 0 r
.003 w
.42439 .66092 m
.42647 .67343 L
s
.25 g
.5 Mabswid
.42439 .66092 m
.55081 .65819 L
s
.53628 .60882 m .4217 .64801 L .54479 .63336 L .55 .463 .71 r
F
.25 g
.5414 .63377 m
.54479 .63336 L
s
.4217 .64801 m
.5414 .63377 L
s
1 0 0 r
.003 w
.4217 .64801 m
.42439 .66092 L
s
.41853 .63484 m
.4217 .64801 L
s
.25 g
.5 Mabswid
.41853 .63484 m
.4458 .62881 L
s
.4458 .62881 m
.53327 .60949 L
s
.53327 .60949 m
.53628 .60882 L
s
.43265 .61566 m
.52257 .58576 L
s
.41502 .62152 m
.43265 .61566 L
s
0 g
.006 w
.53314 .79804 m
.54221 .77714 L
s
.36668 .42551 m
.38527 .43676 L
s
.54221 .77714 m
.54898 .75493 L
s
.54898 .75493 m
.55329 .73167 L
s
.38527 .43676 m
.40459 .44972 L
s
.55329 .73167 m
.55507 .70761 L
s
.40459 .44972 m
.42422 .4644 L
s
.55424 .68302 m
.55507 .70761 L
s
.42422 .4644 m
.44372 .48079 L
s
.55081 .65819 m
.55424 .68302 L
s
.54479 .63336 m
.55081 .65819 L
s
.44372 .48079 m
.46267 .49884 L
s
.53628 .60882 m
.54479 .63336 L
s
.46267 .49884 m
.48066 .51842 L
s
.5254 .58482 m
.53628 .60882 L
s
.48066 .51842 m
.49733 .5394 L
s
.51234 .5616 m
.5254 .58482 L
s
.49733 .5394 m
.51234 .5616 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000181000`40O003h00Oogoo2Woo002`Ool2
001GOol00:ioo`800003Ool0000005Ioo`00Zgoo0`000goo0P00EWoo002YOol20006Ool00`00Ool0
001EOol00:Moo`8000Qoo`03001oo`0005Eoo`00Y7oo0`002Woo00@007ooOol005Aoo`00XWoo0P00
3Goo00D007ooOomoo`0005=oo`00Wgoo0`003goo00D007ooOomoo`0005=oo`00WGoo0P004Woo00<0
07ooOol00Woo00<007ooOol0D7oo002KOol2000EOol00`00Oomoo`02Ool00`00Oomoo`1?Ool009Qo
o`<001Moo`03001oogoo009oo`03001oogoo04moo`00UWoo0P006Woo00<007ooOol00goo00<007oo
Ool0CWoo002COol3000LOol00`00Oomoo`03Ool00`00Oomoo`1>Ool0095oo`8001moo`03001oogoo
00Aoo`03001oogoo04eoo`00Sgoo0P008Goo00<007ooOol01Goo00<007ooOol0C7oo002<Ool3000S
Ool00`00Oomoo`05Ool00`00Oomoo`1<Ool008Yoo`8002Ioo`03001oogoo00Ioo`03001oogoo04]o
o`00Qgoo0`00:7oo00<007ooOol01goo00<007ooOol0BWoo0025Ool2000[Ool00`00Oomoo`07Ool0
0`00Oomoo`1:Ool008=oo`8002eoo`03001oogoo00Qoo`03001oogoo04Uoo`00P7oo0`00;goo00<0
07ooOol027oo00<007ooOol0BGoo001nOol2000bOol00`00Oomoo`09Ool00`00Oomoo`18Ool007]o
o`<003Aoo`03001oogoo00Yoo`03001oogoo04Moo`00NGoo0P00=goo00<007ooOol02Woo00<007oo
Ool0Agoo001gOol2000iOol00`00Oomoo`0;Ool00`00Oomoo`16Ool007Aoo`<003]oo`03001oogoo
00aoo`03001oogoo04Eoo`00LWoo0P00?goo00<007ooOol02goo00<007ooOol0AGoo001_Ool30011
Ool00`00Oomoo`0<Ool00`00Oomoo`14Ool006eoo`8004Aoo`03001oogoo00aoo`03001oogoo04Ao
o`00Jgoo0P00AWoo00<007ooOol03Goo00<007ooOol0@goo001XOol30018Ool00`00Oomoo`0>Ool0
0`00Oomoo`12Ool006Ioo`8004]oo`03001oogoo00ioo`03001oogoo049oo`00Hgoo0`00CGoo00<0
07ooOol03goo00<007ooOol0@Goo001QOol2001@Ool00`00Oomoo`0@Ool00`00Oomoo`10Ool005io
o`<0059oo`03001oogoo011oo`03001oogoo041oo`00G7oo0P00EGoo00<007ooOol04Goo00<007oo
Ool0?goo001JOol2001GOol00`00Oomoo`0AOol00`00Oomoo`0oOol005Moo`<005Uoo`03001oogoo
019oo`03001oogoo03ioo`00EGoo0P00G7oo00<007ooOol04goo00<007ooOol0?Goo001BOol3001N
Ool00`00Oomoo`0COol00`00Oomoo`0mOol0051oo`80065oo`03001oogoo01Aoo`03001oogoo03ao
o`00CWoo0P00Hgoo00<007ooOol05Goo00<007ooOol0>goo001;Ool3001UOol00`00Oomoo`0EOol0
0`00Oomoo`0kOol004Uoo`8006Uoo`03001oogoo01Eoo`03001oogoo03Yoo`00AWoo0`00Jgoo00<0
07ooOol05Goo00<007ooOol0>Woo0014Ool2001^Ool00`00Oomoo`0FOol00`00Oomoo`0iOol0049o
o`80071oo`03001oogoo01Moo`03001oogoo03Qoo`00?goo0`00LWoo00<007ooOol05goo00<007oo
Ool0>7oo000mOol2001eOol00`00Oomoo`0HOol00`00Oomoo`0gOol003Yoo`<007Moo`03001oogoo
01Uoo`03001oogoo03Ioo`00>7oo0P00NWoo00<007ooOol06Goo00<007ooOol0=Woo000fOol2001l
Ool00`00Oomoo`0JOol00`00Oomoo`0eOol003=oo`<007ioo`03001oogoo01Yoo`03001oogoo03Eo
o`00<Goo0P00PGoo00<007ooOol06goo00<007ooOol0=7oo000^Ool30023Ool00`00Oomoo`0LOol0
0`00Oomoo`0cOol002aoo`8008Ioo`03001oogoo01aoo`03001oogoo03=oo`00:Woo0P00R7oo00<0
07ooOol07Goo00<007ooOol0<Woo000WOol3002:Ool00`00Oomoo`0NOol00`00Oomoo`0aOol002Eo
o`8008eoo`03001oogoo01ioo`03001oogoo035oo`008Woo0`00Sgoo00<007ooOol07goo00<007oo
Ool0<7oo000POol2002COol00`00Oomoo`0NOol00`00Oomoo`0`Ool001ioo`8009Eoo`03001oogoo
01moo`03001oogoo02moo`006goo0`00Ugoo00<007ooOol087oo00<007ooOol0;Woo000IOol2002J
Ool00`00Oomoo`0POol00`00Oomoo`0^Ool001Moo`8009aoo`03001oogoo025oo`03001oogoo02eo
o`005goo0P00W7oo00<007ooOol08Woo00<007ooOol0;7oo000GOol00`00Ool0002KOol00`00Oomo
o`0ROol00`00Oomoo`0/Ool001Moo`04001oogoo002JOol00`00Oomoo`0SOol00`00Oomoo`0[Ool0
01Ioo`03001oogoo009oo`03001oogoo09Moo`03001oogoo02=oo`03001oogoo02]oo`005Woo00<0
07ooOol00goo00<007ooOol0UWoo00<007ooOol097oo00<007ooOol0:Woo000FOol00`00Oomoo`04
Ool00`00Oomoo`2EOol00`00Oomoo`0UOol00`00Oomoo`0YOol001Ioo`03001oogoo00Eoo`03001o
ogoo09Aoo`03001oogoo02Eoo`03001oogoo02Uoo`005Woo00<007ooOol01Woo00<007ooOol0Tgoo
00<007ooOol09Woo00<007ooOol0:7oo000FOol00`00Oomoo`07Ool00`00Oomoo`2BOol00`00Oomo
o`0WOol00`00Oomoo`0WOol001Eoo`03001oogoo00Uoo`03001oogoo07Qoo`P000037>L0000000<0
00037>L0000000D000=oo`03001oogoo02Moo`03001oogoo02Moo`005Goo00<007ooOol02Woo00<0
07ooOol0LGoo1P000V7>00hLif8@HO1R467`HQ0Lif8bHQ9R<UhA7>MN<f8c0ehc00<LieiDGU@01@00
:Goo00<007ooOol09Woo000EOol00`00Oomoo`0;Ool00`00Oomoo`1[Ool500006F6;GHXLieg=HLiM
cF7>GNlLieg`HQ1Mkf8@7>MR<UhAHS9N4F8b7>MR<ehcHS=N<acW00=NE005HUENE1cW001NEP02000W
Ool00`00Oomoo`0VOol001Eoo`03001oogoo00aoo`03001oogoo06Moo`<00003FBLLief;009MR`03
GHYQcQcW00AQcP0=7>MQl68@HO1R467`7>MR4V8bGQ5R<QcWHS<00ehc00=R<acWGU@00eiD00@LieiE
GUD0009NE@03000Li`0002Eoo`03001oogoo02Eoo`005Goo00<007ooOol03Goo00<007ooOol0HWoo
1000021I9eTVGBMI9QcWGHYQRef:HH/Lif7>GLeQcUg=HLhLif8@GNmR45g`7>MN4F8bGQ5R<UhA7>MN
<f8cGS=R<acW0UiD00aREEiDGU@LieiFFUD005YEGUHLieifFUH2000TOol00`00Oomoo`0TOol001Eo
o`03001oogoo00ioo`03001oogoo05aoo`D0009@P@097>MI9eTVFBMI9UTW7>MMRef:009MR`037>MQ
cV7>009QcP0<7>MR467`HQ1Ql68@7>MR<UhAHS9R4QcW0ehc00=R<ehc7>L015iD00DLieiEGUENE@00
009NE@037>MJMUYf009JMP80029oo`03001oogoo02Aoo`005Goo00<007ooOol03goo00<007ooOol0
F7oo0`0000Dl01cWD85@PDb1009@P@0S7>MI9UdWFBII9eTV7>MMRV6;GHYQRacWHLiMcF7>GLdLieg_
HQ1Ml68@7>MR<UhAHS9N4F8b7>MR<ehcHS=N<acWGUARE@03GU@03QcWFUENEEYE001JEAcWFUINMUYF
GWIJEQcWFWH2000QOol00`00Oomoo`0SOol001Aoo`03001oogoo015oo`03001oogoo05Aoo`03000L
i`0000E000037>M@PE21009@P@077>MI9eTVFBMI9UTW7>L00ef;00=QcQcWHLh00f7>00/Lif8@HO1R
467`7>MN4F8bHQ9R<QcW009N<`04HS=N<ehc7>L4GU@00acWGUENE@02GUD00`007>MJMP05FWH011cW
FWMJMeYg0P0087oo00<007ooOol08Woo000DOol00`00Oomoo`0BOol00`00Oomoo`1@Ool300002BP0
;00Lid00?01003`0@00Li`03D8408Tb17>MI9UTWFBIM9acWHH]MRV6;GHXLieg=HLiMcF7>7>MR45g`
HQ1Mkf8b7>MR<UhAHS9N4AcWGS=R<ehcHS<Lif9E0eiD01EREAcWGUEJEEiFFUD001cWGWIJEUifFUIN
MQcWFWMFMUYgFWIJN1cW00007goo00<007ooOol08Woo000DOol00`00Oomoo`0COol00`00Oomoo`1<
Ool00`007>LLi`06:0027>L4@0000acWD85@P@02D8401AcWFBII9eTV7>L00Uf;00=MRUf;7>L0167>
00dLif7`HQ1Ql68@7>MR<V8BHS9N4AcWGS=R<`03GS<00acWGUANE002GU@00acWGUENE@03GUD00`00
FWIJMP03FWH00acWFWMJM`03FWL00acWEWQFM`02000NOol00`00Oomoo`0QOol001Aoo`03001oogoo
01Aoo`03001oogoo04Qoo`<00003300@010000@Li`8X0008;00X01cW?01003`07>M<P@=@P@0N7>MM
9eTVFBLLif6;GHYQRef:7>MMcF7>GLeQcQcWHQ1Mkf8@GO0LiehAHS9N4F8b7>MR<ehcHS=N<acW0eiD
01YREEiD7>MJEEiFFUENEEYE001JEUifFUINMUYF7>MFMUYgFWIJMeIg7>MFMeYhEWMJN0007Goo00<0
07ooOol08Goo000DOol00`00Oomoo`0EOol00`00Oomoo`14Ool200067>L=O0000d007>M@P@02D840
1QcWFBII9eTV7>MMRP9MR`037>MQcV7>009QcP0<7>MR467`HQ1Ql1cWHQ9R<UhAHS8Lif8c0ehc00=R
<acWGU@00eiD00<LieiEGUD00eiE00<Li`00FWH00eYf00<LieYgFWL00UYg00=FMacWEWL00UIg00AF
N5Ig7>L001eoo`03001oogoo021oo`0057oo00<007ooOol05Woo00<007ooOol0@Goo0`0000<Lig`0
O00017`03Goo0g`001m<PE217>MI9eTVGBLLif6;GHYQRacWHLiMcF7>GLdLieg_HQ1Ml68@7>MR<UhA
HS9N4AcWGS=R<ehcHS<Li`02GU@07V9EGUANE1cWGUIJEEiEFUDLieYF001JEUifFUHLieIfFWMJMUYg
EWHLieIgFWQFMeYhEWLLie9hEWP001eoo`03001oogoo01moo`004goo00<007ooOol05goo00<007oo
Ool0?Woo00<001cW7>L00QcW0W`000<LigooOol04goo17`000=I9eTV7>L00Uf;00=MRQcWHLh00V7>
00/Lif7`HQ1Ql68@HQ8LiehAHS9R4QcW00=N<`03HS<LieiD00ANE0037>MNEEiE00=NE@037>MJMP00
00=JMP037>MJMeYg009JM`077>MFMeIgEWMFN5Ig7>L015Ih0P006goo00<007ooOol07goo000COol0
0`00Oomoo`0HOol00`00Oomoo`0jOol200057>L00g`0Oomoo`0JOol3O0006F6;GHYQRacWHLiMcF7>
7>MR45g`HQ1MkacWGQ5R<UhAHS8Lif8cGS=R<ehc7>MNE69E009NE00P7>MNEUYEGUEJEEiF7>MNMUYF
001JEUif7>MJMeYfFWMFMUYh7>MJN5IgFWQFMeYh7>MFN59hEWQBN5IhDWP001]oo`03001oogoo01io
o`004goo00<007ooOol06Goo00<007ooOol0=Woo0P001AcW00<001cWO00087oo0W`000<Lif7>HLh0
0V7>00XLif7`HQ1Ql68b7>MR<V8BHS8Li`9N<`03HS=N<acW00ENE0037>MNEEiE009NE@077>MJMUYf
FWH005Yf7>L01EYg00@LieIgEWMFN09FM`037>MFN5Ih00AFN08Li`03001oogoo01Uoo`03001oogoo
01eoo`004goo00<007ooOol06Woo00<007ooOol0<goo00<001cW7>L01QcW0W`08goo01El05g=HLiM
cAcWGO1R45g_HQ0Lif8bGQ5R<UhA7>MN<f8cGS=R<acWHUD00eiD028LieYEGUEJEEiFFUDLieYFGWIJ
EP00FUHLieYfFWMFMUYg7>MJN5IgFWQFMeYh7>MFN59hEWQBN5IhDWPLie9hDWT001]oo`03001oogoo
01eoo`004goo00<007ooOol06goo00<007ooOol0;goo0P002AcW00=l07ooOol097oo0W`000eQcQcW
HQ1Ql68@GQ4Lif8BHS9N4AcWGS=R<`02GS<00acWGUANE003GU@00acWGUENE@02GUD00acWFWIJMP02
FWH00`007>MJM`03FWL015Ig7>MFMeIh0UIg00<LieIhEWP015Ih00HLie9iDWUBN59i000KOol00`00
Oomoo`0LOol001=oo`03001oogoo01aoo`03001oogoo02aoo`8000XLi`03O01oogoo02Moo`9l000>
GNmR45g`7>MN4F8bGQ5R<QcWHS=N<f8cGS<Li`=NE00UHUDLieiEFUENEUYE7>MJEUifFUINMUYF001J
MUYgEWIJMeYf7>MFMeYhEWMJN5Ig7>MBN5IhDWQFN59hEWPLie9iDWQBNE9h00006goo00<007ooOol0
77oo000BOol00`00Oomoo`0NOol00`00Oomoo`0XOol2000<7>L00g`0Oomoo`0ZOol2O0001f8b7>MR
<UhAHS8Lif8c00=N<`037>MNE5iD00=NE0037>MNEEiE009NE@037>MJMUYf009JMP037>L005Yg00=J
M`037>MFMeIh00=FM`037>MFN5Ih00AFN0037>MBNE9h00=BN@03DWP007oo01Yoo`03001oogoo01]o
o`004Woo00<007ooOol07goo00<007ooOol09Goo00<001cW7>L031cW00=l07ooOol0;Goo00]l068b
GQ5R<UhA7>MN<f8cGS=R<acW009NE00YHUENE1cWFUENEUYEGUDLieifFUINMUYFGWHLi`00EWIJMeYf
7>MFMeYhEWMJN5Ig7>MBN5IhDWQFN59hEWPLie9iDWQBNE9hDWUBN1cWCWT0000KOol00`00Oomoo`0J
Ool0019oo`03001oogoo021oo`03001oogoo029oo`03000LiacW00DLi`03;0H/1acW00<Li`03>8Th
RW`0035oo`9l0003HQ8Liehc009N<`03HS<LieiD00=NE003GUDLieiE009NE@037>MJMUYf00=JMP04
7>MJMeYg0002FWL00acWEWQFM`02EWL00acWEWQFN004EWP00acWDWUBN003DWT00e9h7>M>N@02CWT0
0`00Oomoo`0HOol00`00Oomoo`0JOol0019oo`03001oogoo025oo`03001oogoo01eoo`037>MooacW
00DLi`03<0L/1QcW00<Li`07>8XdRCR:>8ThRQcWO000<goo0W`000MR<ehcHS=N<acWGUARE@02GU@0
9QcWGUIJEEiEFUDLieYFGWIJEUif7>MJMeIfFWL005Yg7>MJN5IgFWQFMeYh7>MFN59hEWQBN5Ih7>MB
NE9hDWUBN59iDWPLidiiDWX3CWT00`00Oomoo`0HOol00`00Oomoo`0IOol0019oo`03001oogoo029o
o`03001oogoo01]oo`03000LiacW008Li`03;0HLiacW00<Li`8hRP03>8TLiacW00@Li`03@>al07oo
03Aoo`9l0003GS<LieiD00=NE003GUDLieiE009NE@037>MJMUYf00=JMP077>MJMeYgFWL001cWEWP0
0eIg00=FN1cWEWP015Ih00<Lie9iDWP00e9i00=BN1cWCWT01Dii00<Li`00Ool06Goo00<007ooOol0
67oo000BOol00`00Oomoo`0SOol00`00Oomoo`0GOol00`007>LLi`067>L00cB9>8XLi`057>L01cc;
@>a0c43/?<]0k7`003Qoo`9l000YHUENE5iDGU@LieYEGUEJEEiF7>MNMUYFGWIJEQcWEWIJMeYfFWL0
05YhEWMJN5IgFWPLieIhDWQFN59hEWQBN1cWDWQBNE9hDWUBN1cWCWUBNP03CWT0159jCWTLi`006Woo
00<007ooOol067oo000BOol00`00Oomoo`0TOol00`00Oomoo`0DOol2000;7>L8@>`47>L00g`0Oomo
o`0hOol01G`0GUANE5iE7>L00eiE00<LieYfFWH00UYf00<LieYgFWL00eYg00H005IgEWMFMeIh7>L6
EWP00acWDWQBN@02DWT00e9hDWTLi`06CWT011cWBWY:NP006Woo00<007ooOol05goo000AOol00`00
Oomoo`0VOol00`00Oomoo`0AOol00`007>LLi`057>L01d3/@<a0k3c;@>a0c43/00PLi`04ABe9;TD]
O00lOol09W`0HUDLieiEFUENEQcWGWIJEUifFUINMQcWFWMJMUYgEWHLi`00FWQFMeYhEWLLie9hEWQB
N5IhDWPLie9hDWUBN59iDWQBNAcWDWX3CWT01e9jCWTLidYiCWY:N@0001Yoo`03001oogoo01Moo`00
4Goo00<007ooOol09goo00<007ooOol03Woo00@001cW7>LLi`I0k0LLi`05BBi5;DT]ABe9;P067>L0
0g`0Oomoo`0kOol00g`0GUENE@02GUD00acWFWIJMP02FWH00acWFWMJM`02FWL01acWEWL005IgEWQF
MacW00EFN0037>MBN59i009BN@03DWQBNAcW00I>N@037>M:NTYj009:NP03001oogoo01Uoo`03001o
ogoo01Ioo`004Goo00<007ooOol0:7oo00<007ooOol02goo0P0000=0k43<7>L01acW00=9;TD]7>L0
2AcW00M=Kde>CFm=CTe_CDil000nOol2O00085YE7>MJEUifFUINMQcWFWMJMUYgEWIJMacWFWP005Yh
EWLLie9hEWQBN5IhDWPLie9hDWUBN59iDWQBNAcWDWX3CWT02U9jCWTLidYiCWY:NDYjBWU>NP006goo
00<007ooOol05Goo000AOol00`00Oomoo`0YOol00`00Oomoo`09Ool00`007>LLi`0<7>L04De>CFm=
CTe_CDi=Kde>CFm=CTe_CDi=Kde>CFm=CTe_O000@7oo0W`015Yf00<LieYgFWL00UYg00HLieIgEWL0
05Ig7>L5EWP00acWDWQBN@02DWT00e9hDWTLi`06CWT00acWBWY:NP05BWX00`00Oomoo`0IOol00`00
Oomoo`0EOol0015oo`03001oogoo02Yoo`03001oogoo00Ioo`03000LiacW00@Li`0:CFm=CTe_CDi=
Kde>CFm=CTe_CDh@7>L00g`0Oomoo`10Ool077`0GWIJEQcWFWIJMeIfFWLLieYhEWMJN000FWPLieIh
DWQFN59hEWPLie9iDWQBNE9hDWTLie9j0dii00eBNTii7>M:NDijBWU:NTYiCWY:NAcW@UX0000KOol0
0`00Oomoo`0DOol0015oo`03001oogoo02]oo`03001oogoo00Aoo`03000LiacW00lLia1AS`03O01o
ogoo045oo`03O00LieYg00=JM`077>MFMeIgEWQFM`007>L01EIh00LLie9iDWUBNE9hDWTLi`06CWT0
0acWBWY:NP05BWX011cWAUY6FP0077oo00<007ooOol04goo000@Ool00`00Oomoo`0]Ool00`00Oomo
o`02Ool00`007>LLi`0>7>L04UF?DHmET56?EHmASeF@DHmESe6?EI1ASeF?DHmET56?EHml04Eoo`0H
O01JMeIfFWMJMQcWEWMJN5IgFWP005IhDWQFN59hEWPLie9iDWQBNE9hDWTLie9j0dii00UBNTii7>M:
NDijBWU:NTYiCWX00QcW00E2FTIkAUY6NP0001]oo`03001oogoo01=oo`0047oo00<007ooOol0;Woo
00P007ooOomoo`00EK1I/5F_0UF`00II/5F_EK1E/5V`EJl2EK000eV`EJmE/0027>L00`007>LLi`0<
7>L00g`0Oomoo`14Ool2O00015Yg7>MFMeIh0UIg00<Li`00EWP00eIh00LLie9iDWUBNE9hDWTLi`06
CWT00acWBWY:NP04BWX00acWAUY6FP04AUX00`00Oomoo`0JOol00`00Oomoo`0BOol0011oo`03001o
ogoo02moo`04001oogoo00087>L02eV`EJmI/5F_FK1E[eV`EJmI/5F_FK000P0000eE[eV`EJmI/5F_
FK1E[eV`EJmI/5F_FK1l0018Ool2O0004EYhEWMJN5Ig7>L005IhDWQFN1cWDWUBN59iDWQBNAcWDWX0
0dii01=BNTii7>M:NDijBWU:NTYiCWXLidIj@UY6NdIJAWY2FTIkAUX0000KOol00`00Oomoo`0BOol0
011oo`03001oogoo031oo`04001oogoo00057>L00eW@GM0Li`0:7>L2NZd200027>L2EK001eV`EJmE
/5F`FK1E[g`004Yoo`9l0004EWLLieIh0002EWP021cWDWUBNE9iDWQBNDii7>L5CWT00acWBWY:NP04
BWX00acWAUY6FP05AUX27>L00`00Oomoo`0IOol2000COol0011oo`03001oogoo035oo`03001oogoo
0080008Li`03FM0LiacW00HLi`0;GM1Id5g@FM1Md5W@NZif[GZ^001Md0087>L00g`0Oomoo`1:Ool0
3G`0DWQFN000EWQBN1cWDWQBNE9hDWUBN1cW00=>N@0FDWY>NAcWBWU>NTYiBWY:NDij7>M6NT9JAW]6
FTIj@UY6NacW@U/n>T9K000GOol300000goo001oo`0BOol0011oo`03001oogoo039oo`04001oogoo
Ool200047>L01F7`FM1Md5W@GM001AcW00EMd5W@NZej[Gk;00800008FM1Md5W@GM1Id5g@FM1l04eo
o`05O01FN000EWPLi`02DWT0159hDWUBNAcW1Dii00<LidYjBWX00dYj0QcW1dIJ00HLid9J?UY2FSiJ
000DOol30004Ool00`00Oomoo`0AOol0011oo`03001oogoo03=oo`09001oogooOolLi`00IS1R46Ha
00@Li`06GO1R45g`HQ5Id5g@0acW00]j[WJ]O/ajb`00FM1Md5W@GM1Id7`004moo`9l0007001BN59i
DWQBNE9h7>L00dii011BNTii7>M:NDijBWU:NTYi7>M6FTIj@UY6NdIJAWY2FP8Li`06@U/n>T9K?SY2
F`004Goo0`001goo00<007ooOol04Goo000?Ool00`00Oomoo`0eOol00`00Oomoo`02Ool00`007>LL
i`03IQ000f8@7>LLi`037>L015g`HO1Ml67`0WZ]00=jbgk;M/L00P0000@LieW@GM1l055oo`03001B
NE9h009BN@037>M>NDii00=>N@037>M:NTYj00=:NP037>M6FTIJ00E6FP0:7>LnFT9J?UY2FSiJ@UXn
FT9J000=Ool3000;Ool00`00Oomoo`0@Ool000moo`03001oogoo03Ioo`03001oogoo009oo`8000<L
i`06IS1R46HaHQ1V<68@11cW00MR4GZ]NZijbgk<M/Mja`0200000acWO01oo`1@Ool01@00O01l059h
7>L00dii00mBNTii7>M:NDijBWU:NTYi7>M6FTIj@UY6NdIJAWX00QcW00Xn>T9K?SY2Fchj@U/n>T9K
?SX000Yoo`<000ioo`03001oogoo011oo`003goo00<007ooOol0=goo00<007ooOol00goo0P001AcW
0VH@00AR46H@IQ1V40<Li`08O/]jbgK7M/MjagK7001l055oo`04001oogooO005CWT00acWBWY:NP03
BWX00acWAUY6FP04AUX02QcW@UXnFT9J?UY2FSiJ@UXnFT9J0QcW00<007ooOol01Goo0`004Goo00<0
07ooOol047oo000?Ool00`00Oomoo`0hOol00`00Oomoo`04Ool37>L00fY@IRlLi`027>L03F8@IS5R
46H`HQ1j[WZ]O/]faW[7M/Mjaf910080051oo`0=001oogooOoml04iiDWY>NAcWBWU>NTYiBWX00QcW
00E6FTIj@UY6NdIJ008Li`08@U/n>T9K?SY2Fchj@U/n>P8Li`04>S/f6SXk0002Ool4000DOol00`00
Oomoo`0@Ool000moo`03001oogoo03Uoo`03001oogoo00Aoo`07KTlLiacW7>MZ<6Y@JS000acW0VH@
00AR47Z]N/]nb`=fa`03HV5R@F9Q008004ioo`03001oogoo009oo`03O01>NAcW00A:NP037>M6FTIJ
00A6FP097>LnFT9J?UY2FSiJ@UXnFT9J008Li`<j>P03>S/j>P00008001Qoo`03001oogoo011oo`00
3goo00<007ooOol0>Woo00<007ooOol01Goo11cW00AZD6X`JU1V;`@Li`0;NZijbg[7M/Ijaf91IV5R
@FIQHT40001=Ool00`00Oomoo`03Ool057`0BWU>NTYiBWXLidIkAUY6NT9JAW]6FQcW?SY2Fchj@U/n
>T9K?SX27>L023Xk=QXj>cHJ>S/f6SXk000JOol00`00Oomoo`0@Ool000ioo`03001oogoo03aoo`03
001oogoo00Ioo`@Li`06JS1ZD6X`JU1Z<6H@0QcW00Ufag[7M/Mfaf91HV5R@F9Q7>L00P00Bgoo00<0
07ooOol017oo0W`000=:NQcWAUX014IJ0QcW00XnFT9J?UY2FSiJ@UXnFQcW>SXj>`<j>P06>S/j>SXj
>SXj>`006Goo00<007ooOol047oo000>Ool00`00Oomoo`0mOol00`00Oomoo`06Ool00fi?7>M^C`03
7>L04FH_JU1Z<6Y@MZenc7K7N/MfaVIQHT5VHF917>L01@060000BWoo00<007ooOol01Woo00il04Ik
AUY6NT9JAW/Lid9K?SY2Fchj@U/n>T9K0QcW00Tf6SXk=QXj>cHJ>S/f6SXk=QX00QcW00<007ooOol0
5goo00<007ooOol047oo000>Ool00`00Oomoo`0nOol00`00Oomoo`07Ool27>L026i`JS0LiacWJU1Z
<6Y@N//2M/L01W[7HT5RHF91HV4Li`801@0300H0000004Qoo`03001oogoo00Moo`03O016FTIJ008L
i`06@UXnFT9J?UY2FSiJ0QcW0SXj00Dj>cXj>SXj>SXk008j>P8Li`8anP03001oogoo01Qoo`03001o
ogoo00moo`003Woo00<007ooOol0?goo00<007ooOol027oo00@Lig9`KTmoo`8Li`0@JS1ZD7K6N/Mf
afIQHT5VHF917>L01@0600D01P050017Ool00`00Oomoo`08Ool027`07>Ln>T9K?SY2Fchj@U/27>L0
2CHJ>S/f6SXk=QXj>cHJ>S/f6P027>L01C7j;OXanRgj00006Woo00<007ooOol03goo000>Ool00`00
Oomoo`10Ool00`00Oomoo`08Ool27>L00fi?KW1oo`027>L02Gk;M/Mfaf91HV5R@F9Q7>L01P0300D0
0acW00/00016Ool00`00Oomoo`09Ool01G`0@UXnFT9J?UX00QcW00Dj>cXj>SXj>SXk00<j>P<Li`La
nP03001oogoo01Moo`03001oogoo00moo`003Woo00<007ooOol0@Goo00<007ooOol02Goo0QcW011^
L6i?OolLig[7M/IVHF91IV401AcW00D01P0500HLi`802`03001oogoo04=oo`03001oogoo00Yoo`0<
O012FacW7>Lf6SXk=QXj>cHJ>S/f6SXk0QcW00/]nS7j;OXanRgj<OX]nS7j;OXanP0001Uoo`03001o
ogoo00moo`003Woo00<007ooOol0@Woo00<007ooOol02Woo00/Lifi`KTm^L7K7N/MR@F9QHT401QcW
00801@0300HLi`0;00<02`03001oogoo049oo`03001oogoo00Qoo`<000047>Lj>SXj>S/3>SX013Xk
7>LLiacW337j00<007ooOol05goo00<007ooOol03goo000=Ool00`00Oomoo`14Ool00`00Oomoo`0:
Ool27>L03Vi?LW1fafIQHT5VH@057>L01@0600DLi`0;00`300/00`00Oomoo`11Ool00`00Oomoo`05
Ool30004Ool01G`0>S/f6SXk=QX00QcW00danRgj<OX]nS7j;OXanRgj<OX]nS7j;OXanP027>L00`00
Oomoo`0GOol00`00Oomoo`0?Ool000eoo`03001oogoo04Eoo`03001oogoo00]oo`8Li`9fa`05HV5R
@AcW00D01P0200D00acW00/02`0400/00`00Oomoo`10Ool00`00Oomoo`02Ool30007Ool00g`0>SXj
>P027>L:<OX57>L00bWJ:KT0000IOol00`00Oomoo`0?Ool000eoo`03001oogoo04Ioo`03001oogoo
00aoo`0:O01jaf91IV4Li`0600D01QcW00`300/01@0<00/Li`@>0000@Goo00<007oo00000P002goo
0QcW00PanRgj<OX]nS7j;OXanRgj11cW00PYfRFi:MXU^BWJ9KTYfP006Woo00<007ooOol03Woo000=
Ool00`00Oomoo`17Ool00`00Oomoo`0<Ool017K7HV5R@AcW0`0500<Li`0;00/0100;00<Li`@?10h0
0P00?Woo0`003goo00Al037j<OXanPDLi`0=:KTYfBVi:MXY^BWI:KTYfRVi:MTY^BWJ00006Goo00<0
07ooOol03Woo000=Ool00`00Oomoo`18Ool00`00Oomoo`0;Ool027[7HT5VHAcW00H01@067>L200/0
2P0<00/02acW10l43P@?10h43`00>Woo0`000Woo00<007ooOol03Woo01El01cW7>LU^BWJ9KTYfRFi
:MXU^BWJ9KTYfRFi:MXU^BWJ9KTYfRFi00006Goo00<007ooOol03Woo000=Ool00`00Oomoo`18Ool0
0`00Oomoo`0;Ool01gK7HV5R@AcW00D01QcW00D02`037>L43`@>00<43`0310h43`0003Eoo`@000Eo
o`03001oogoo00moo`0DO00Y^BWI:KTYfRVi:MTY^BWJ:KTYfBVi:MXY^BWI:KTYfRVi:MT001Uoo`03
001oogoo00ioo`0037oo00<007ooOol0BWoo00<007ooOol02goo00QR@FIQ7>L01P057>L02`0<0`0;
00LLi`@>10l43P@?10h43`027>L00`00Oomoo`0_Ool30009Ool00`00Oomoo`0?Ool02g`0:MXU^BWJ
9KTYfRFi:MXU^BWJ9KT021cW00<007ooOol05goo00<007ooOol03Woo000<Ool00`00Oomoo`1;Ool0
0`00Oomoo`0:Ool01F9QHT4Li`057>L01@0;00<Li`@>10l00P@?00<43P@?7>L00aRA00<007ooOol0
:goo0`0037oo00<007ooOol047oo2QcW0b6H00HQVB6H8IPQV26I000IOol00`00Oomoo`0>Ool000ao
o`03001oogoo04aoo`03001oogoo00Uoo`06HT401QcW00HLi`0<0`0;00h031cW10l43P@?10h43acW
794HT1bA690LT@00:Goo0`003goo00<007ooOol047oo01=l025h8ITQN2FI8GPQVB5h9ITQN26I8GPU
VB5h8ITQN2FI8GP0000IOol00`00Oomoo`0>Ool000aoo`03001oogoo04eoo`03001oogoo00Uoo`04
00DLi`057>L400/01acW10l43`@?10h43acW00HHT@03001oogoo02Aoo`<0019oo`03001oogoo015o
o`03O00QV26I00<QV0058ITQV26H8IPQV@038IP0126I8IPQV0006Woo00<007ooOol03Goo000<Ool0
0`00Oomoo`1>Ool00`00Oomoo`08Ool00`067>LLi`0300/04P0<7>L43`@>10l43P@?7>LLTAR@794H
T1bA690LTAR@000Lib5oo`<001Eoo`03001oogoo015oo`HLi`0<8GPQVB5h9ITQN26I8GPUVB5h8ITQ
N0006Woo00<007ooOol03Goo000<Ool00`00Oomoo`1?Ool00`00Oomoo`07Ool00acW00HLi`0400/0
11cW10l43`@>0P@?00<LiaRA69401QRA00<Li`00Ool07Goo0`0067oo00<007ooOol04Goo00Il01eG
7ELQV26I8IP87>L28IP00b6I001oo`0IOol00`00Oomoo`0=Ool000]oo`03001oogoo055oo`03001o
ogoo00Ioo`0I7>L01AcW00/0300;7>L43P@?10h43`@>7>LHT1bA690LTAR@794HT1bA7>LXlRCb0000
6Woo0`006goo00<007ooOol04Goo00@LiaeG7ELMF0<ME`077EPMEb6I8GPUVB5h8IT00acW00<007oo
Ool067oo00<007ooOol03Goo000;Ool00`00Oomoo`1BOol00`00Oomoo`05Ool00g`07>L02`0200/0
11cW10l43`@>0P@?00<LiaRA69401ARA0QcW12Sb00<007ooOol057oo0`007Woo00<007ooOol04Goo
00=l01cW7>L03QeG00<007ooOol067oo00<007ooOol03Goo000;Ool00`00Oomoo`1COol00`00Oomo
o`04Ool00g`07>L0300200/03QcW10l43P@?10hLiaR@794HT1bA690LTAR@7>L2:?801BCb:?<XlRSb
00004goo0`008Goo00<007ooOol04Woo00El01df7>LLiaeH00<ME`057EPMEaeG7ELMF0037EL00`00
Oomoo`0HOol00`00Oomoo`0=Ool000]oo`03001oogoo05Aoo`03001oogoo00=oo`07O00Li`0;00/L
i`@?10h00P@?00<LiaRA69401ARA00<LibSb:?801RSb00<007ooOol03Goo0`0097oo00<007ooOol0
4Woo00@Liadf7CHM=P<Li`TME`03001oogoo01Qoo`03001oogoo00eoo`002goo00<007ooOol0EGoo
00<007ooOol00Woo015l01cW00/02acW10h43`@>7>LHT1bA690LTAR@794HT1cW008XlP099?8XlbSb
:?8TlRSc:?8Li`0000]oo`<002Moo`03001oogoo019oo`03O00LiacW008M=P036CHM=QcW008Li`05
7EPMEaeG7ELMF0027EL00`00Oomoo`0GOol00`00Oomoo`0=Ool000]oo`03001oogoo05Ioo`05001o
ogooOoml000200/01AcW10h43`@?7>L01aRA00<LibSb:?801RSb0QcW00<a<cDc00001goo0`00:Woo
00<007ooOol04Woo00=l024E7AD00QcW1Adf0acW11eG00<007ooOol067oo00<007ooOol037oo000;
Ool00`00Oomoo`1GOol04000Oomoog`000/Li`@>10l43QcW690LTAR@794HT1bA0QcW0RSb00`TlRSc
:?8XlRCb:?<LicED<C<eE34c0004Ool3000]Ool00`00Oomoo`0BOol01AcW7ADQ5AdE8AH00QcW00HI
=Qdf7CHM=QTf7CH37>L00aeH001oo`0IOol00`00Oomoo`0<Ool000Yoo`03001oogoo05Uoo`05001o
ogooO00Li`0310l00acW694HT@0369400acW:?8XlP06:?827>L2<C<013Dc<C<a<c4c1000<7oo00<0
07ooOol04Goo00Il02DD7>LLib4E7AD28AD00acW7CHM=P067CH00acW001oo`0IOol00`00Oomoo`0<
Ool000Yoo`03001oogoo05Yoo`0>001oog`010l43P@?7>LLTAR@794HT1bA7>LXl`8XlP049?8XlbSb
:?827>L02S4c=E@a<cED<C<eE34c=E@a<`00<goo00<007ooOol047oo00TLibDe9A@U=AcW8ADM5B4F
7AD00QcW0adf00DI=Qdf7CHM=P0001Yoo`03001oogoo00aoo`002Woo00<007ooOol0Fgoo00D007`0
10l43acW00DHT@037>LXlRSb00DXlP037>Le<c4c008a<`05=C<a<c4c<C<e<`02<C<00`00Oomoo`0a
Ool00`00Oomoo`0@Ool027`07>LU=BDD9CDLib4E7AD38AD00acW7CHM=P047CH00`00Oomoo`0HOol0
0`00Oomoo`0<Ool000Yoo`03001oogoo05aoo`0:001l01cW794HT1bA690LTAcW:?<2:?800bCb:?<X
lP027>L02cED<C<eE34c=E@a<cED<C<eE34c=E@00QcW00<007ooOol0<7oo00<007ooOol03goo00Ml
02Td;CDLibDe9A@U=@027>L011dE8AHM5B4E0QcW0Qdf00<I=Qdf00006Woo00<007ooOol037oo000:
Ool00`00Oomoo`1MOol00g`07>LHT@0269427>L6:?800acW<C<e<`03<C<01SDc<C<a<c4c=C<a<`8L
i`<iM003001oogoo02moo`03001oogoo00moo`0;7>L]=2dd;C@LibDe9A@U=BDD7>LM5@038AD00adE
7>LLi`027CH00`00Oomoo`0HOol00`00Oomoo`0<Ool000Yoo`03001oogoo05eoo`07O00HT1bA690L
ibCb:?<00RSb00hTlRSc7>LLic4c=E@a<cED<C<eE34c=E@a<cED0QcW00HiM3ed>G@mM3Ud000aOol0
0`00Oomoo`0>Ool04W`0=EDLibdd:C@]=AcW9CDU52De9A@LiadE8AHM5B4E7ADQ5P8Li`03001oogoo
01Uoo`03001oogoo00]oo`002Goo00<007ooOol0GWoo00Al01RA694Li`DXlP8Li`8a<`05=C<a<c4c
<C<e<`03<C<27>L8>G@00`00Oomoo`0^Ool00`00Oomoo`0>Ool011cW<E@aE1cW0bdd00DLibDe9A@U
=BDD008Li`<Q5@047ADQ5B4E000KOol00`00Oomoo`0;Ool000Uoo`03001oogoo05ioo`05O00XlQcW
9?8Xl`02:?8032Cb7>La<cED<C<eE34c=E@a<cED<C<eE08Li`0;>G@mM3Ud?G@iM3ed>G@mM3Ud?G@0
000`Ool00`00Oomoo`0=Ool05W`0>G@Lic5D=EDLibdd:C@]=AcW9CDU52De9A@U=AcW8AHM5B4E7ADQ
5P006goo00<007ooOol02goo0009Ool00`00Oomoo`1NOol00g`07>LXlP03:?827>L3<C<01SDc<C<a
<c4c=C<a<`8Li`diM003001oogoo02eoo`03001oogoo00aoo`05O00iM3Ud>G@Li`02<E@02acW;C@]
=2dd7>LU=BDD9CDU52De7>L00b4E00<007ooOol06Woo00<007ooOol02goo0009Ool00`00Oomoo`1N
Ool00g`09?8Xl`02:?802QcW=E@a<cED<C<eE34c=E@a<cED0QcW010iM3ed>G@mM3Ud?G@iM3ed>G@m
M3Ud?G@iM3ed7>L002ioo`8000eoo`0=O00mU1cW>G@iMAcW=E@aE3EE7>L]=2Td;CD00QcW00@U52De
9A@U=@8Li`037AD007oo01]oo`03001oogoo00]oo`002Goo00<007ooOol0Ggoo00El02Sb:?8LicDc
00<a<`04=C<a<c4c<C<27>L=>G@37>L00d6e?KD0000ZOol30002Ool00`00Oomoo`09Ool01G`0?IDm
UAcW>GD00SUd00DLicED<E@aE1cW00@]=0087>LU52De9A@U=BDD7>L001aoo`03001oogoo00]oo`00
2Goo00<007ooOol0Ggoo00Yl01cW7>LeE34c=E@a<cED<C<eE08Li`0<>G@mM3Ud?G@iM3ed>G@mM3Ud
?G@iM3ed0acW00I1]Cfe@KDm]46e000VOol40006Ool00`00Oomoo`06Ool2O000646e7>LmU46e7>Li
MCUd>GDLicED<E@eEAcW;C@Y=2de:C@LibDD9CDU52De7>L001aoo`03001oogoo00]oo`002Goo00<0
07ooOol0Ggoo00=l034c=C<00c4c00@e<c4c7>LLi`/iM0<Li`0:@KDm]D6e?KE1]Cfe@KDm]D6e000R
Ool3000:Ool00`00Oomoo`05Ool02W`0AME1]DGE7>M1UCfE7>LiM3Ue0SUd00DLicED<E@aE1cW00@]
=0067>LU52De9A@U=@0077oo00<007ooOol02goo0008Ool00`00Oomoo`1POol01W`0=E@a<cED<C<e
E08Li`0:>G@mM3Ud?G@iM3ed>G@mM3Ud?G@37>L03D6e?KE1]Cfd@KDm]D6e?KA1]Cfe@KDm]00001mo
o`<000ioo`03001oogoo009oo`9l000KBOHLidGE@KE5eQcW@KDmU1cW>G@iMCUd7>LaE3ED<E@]=AcW
;C@Y=2de:C@LibDD9CDU500001eoo`03001oogoo00Yoo`0027oo00<007ooOol0HGoo00=l034c7>L0
0QcW2CUd0acW0151]Cfe@KDm]D6e?KE1]Cfe@KDm]D6e?KE1]Cfe@KDm]@0001]oo`<0019oo`0I001o
ogooO015eDWfAMDLid6eAME1]AcW?IE1UCfE7>LiM3Ue>G@Lic5D=E@aE2dd7>L012dd00<LibDD0000
7Woo00<007ooOol02Woo0008Ool00`00Oomoo`1QOol27>L02Ced>G@mM3Ud?G@iM3ed>G@mM0037>L0
546e?KE1]Cfd@KDm]D6e?KA1]Cfe@KDm]46e?KE1]Cfd@KDm]D6e000HOol3000FOol07`00O019mQcW
AME9mTGE7>M1]DGE@KDLicfD@KDLicUe>G@iMCUd7>LaE3ED<E@]=AcW;C@Y=2de:C@Li`0001ioo`03
001oogoo00Yoo`0027oo00<007ooOol0HGoo00=l03Ud>G@01CUd0acW01=1]Cfe@KDm]D6e?KE1]Cfe
@KDm]D6e?KE1]Cfe@KDm]D6e?KE1]@037>L00`00Oomoo`0BOol4000GOol2O00034XF001:5TGE7>M5
eDWfAMDLid6eAMDLi`8mU@0<@IDLicUd>G@iMCUd7>LaE3ED<E@]=1cW12dd00<007ooOol077oo00<0
07ooOol02Woo0008Ool00`00Oomoo`1ROol017`0?G@iM3ed0acW0191]Cfe@KDm]46e?KE1]Cfd@KDm
]D6e?KA1]Cfe@KDm]46e?KD47>L01DGF@ME5eT7E000047oo0`006Goo0W`0025>5Thg7>M>5`00CQI5
eAcWAME9mQcWAMI1]DGE7>M1]CfD@KDLicUe>G@iMAcW=EDaE3ED<E@LibTd;C@Y=2de00007Woo00<0
07ooOol02Woo0008Ool00`00Oomoo`1ROol057`0>G@LiacW@KDm]D6e?KE1]Cfe@KDm]D6e?KE1]Cfe
@KDm]D6e?KD57>L02D7FAMI1eDGF@MI5eT7EAMH0000=Ool3000JOol2O0001e9G7>M>=dhg7>M:5P00
009:5P097>M5mTGEBOHLidGE@KE5eAcW008mU@06@IDLicUd>G@iMAcW0S5D00<eE35D7>L00bdd00<0
07ooOol077oo00<007ooOol02Woo0007Ool00`00Oomoo`1SOol27>L03Cfe@KDm]46e?KE1]Cfd@KDm
]D6e?KA1]Cfe00DLi`0>@ME5eT7EAMI1eDGF@ME5eT7EAMI1eDGF@MD000Yoo`<001]oo`9l000:CSMB
F4hg7>M>5ThgCQHLidWf0002BOH061cWBOI5eDWf7>M5eT6e7>LmU46e?IA1]AcW>GDiM3Ue7>LeEC5D
=E@aE1cW:C@001moo`03001oogoo00Yoo`001goo00<007ooOol0Hgoo00]l03fe@KDm]D6e?KE1]Cfe
@KDm]D6e00@Li`0C@MI5eT7EAMI1eTGF@ME5eT7FAMI1eDGF@MI5eT7EAMI1eTGF00001goo0`0077oo
0W`000QBN1cWDUM>=e9GDSLLidhf0Thg00LLidXF001:5QcWAME5mP02AMD011cWAME1]AcW0cfE00HL
icUd>G@iM3Ue7>L2<E@013ED<E@Li`0087oo00<007ooOol02Goo0007Ool00`00Oomoo`1TOol017`0
?KA1]Cfe1QcW01Q5eT7EAMI1eDGF@ME5eT7EAMI1eDGF@ME5eT7EAMI1eDGF@ME5eT7EAMI1eDGF0002
Ool4000NOol0:G`0DUQFN59G7>M>=e9HCSMBF4hg7>M>5Thg7>M>5TWf0019mQcWAME9mTGE7>M1]DGF
@KDLicfD@KDmU1cW>G@iMCUd>GDLicEE<E@eE35D000087oo00<007ooOol02Goo0007Ool00`00Oomo
o`1SOol00`007>LLi`027>L06T7FAMI1eDGF@MI5eT7EAMI1eTGF@ME5eT7FAMI1eDGF@MI5eT7EAMI1
eTGF@ME5eT7FAMH37>L3000POol2O0000acWDWQBN002DWP02QcWDSMBEdhgDULLidhgCSI>=acW0TXF
00/001cWBOI5eDGfAMDLid6eAME1]AcW00<mU@057>LiM3Ud>G@Li`03<E@00cED001oo`0OOol00`00
Oomoo`09Ool000Moo`03001oogoo06=oo`0G001l047EAMI1eDGF@ME5eT7EAMI1eDGF@ME5eT7EAMI1
eDGF@ME5eT7EAMI1e@087>L4000POol2O000:eJIEYQFVAcWEWQBF5IhDULLidhgDUQ>=e9H7>M>=dhF
CSLLidhF001>5acWBOI5eDWf7>M5eD6eAMHLid6e?IA1]CfD7>LiM3Ue>G@Lic5D=EDaE000021oo`03
001oogoo00Uoo`001goo00<007ooOol0Hgoo00l007ooO011eTGF@ME5eT7FAMI1eDGF@MI5eT7EAMH0
21cW00E5mTGgAOI5mdGf00<00005AOI5mdGfAOL0000MOol2O0001eJi7>MFV5JIEYQFVAcW00=BN006
7>MBEe8gDUM>=acW0Thg011>=QcWBQI:5P00BQHLidWfAME5mQcWAME1]DGE7>M1U@<mU@077>LiM3Ud
>G@Lic5D00008Goo00<007ooOol02Goo0007Ool00`00Oomoo`1SOol01`00Ooml04GF@ME5eT7E00PL
i`0:BOM5mTGgAOI9mdGfAOM5mTWgAOH3000024GfAOM5mTWgAOI5mdGf000KOol2O000;UZjE[UJ^UJi
7>MBV5JIEYPLie9GEWQBF5Ih7>MBF4hgDUQ>=acWCQI>=dhF7>M9mThF000LidGEBOI5eDWf7>M5eD6e
AMHLid6e?IA1]AcW>GDiM3Ue>G@Li`008Goo00<007ooOol02Goo0006Ool00`00Oomoo`1TOol00`00
Ooml00047>L03TGfAOM5mTGgAOI5mdGfAOM5mTGgAOI5mdGfAOL400002dGfAOM5mTGgAOI5mdGfAOM5
mTGg00006Goo0W`000AJfQcWE[UJ^@9F^@067>MFVEJHEYUFV1cW159h00HLie9GDSMBEdhg7>L2CSL0
44hf7>M:5TXF000LidGEBOI5eAcW@KE5eD6eAMDLid6E0SfE00HLicUe>G@iM1cW000QOol00`00Oomo
o`09Ool000Ioo`03001oogoo06Aoo`0B001oog`0AOM5mTWgAOI5mdGfBOM5mTGgAOI9mdGfAOM5mTWg
0`0000m9mdGfAOM5mTWgAOI5mdGfBOM5mTGgAOI9mdGf00005goo0W`0035Jfe[JF]YJfQcWE[UJ^UJi
F[XLieJIDYQFVEJH7>MBEeIhDUQFN1cWDUQ>=e9H7>M>=dhFCSLLidhGBOI>5P007>M5eDWfAMDLid6e
AME1]AcW?IA1]CfD@KDLicUe>G@0000ROol00`00Oomoo`09Ool000Ioo`03001oogoo06Aoo`0?001o
ogooO015mdGfAOM5mTGgAOI5mdGfAOM5mTGg00<0000CAOM5mTGgAOI5mdGfAOM5mTGgAOI5mdGfAOM5
mTGgAOI5mdGf000057oo0W`000=K6acWF]X015[J00<LieJiF[T00UJi00HLieJIEYQFVEJH7>L3DWP0
1QcWCSMBEe8gDULLi`=>=`0E7>M:5TXF000LidGfAME9mTGE7>M1]DGE@KDLicfE@IDmUAcW>G@iM@00
02=oo`03001oogoo00Qoo`001Woo00<007ooOol0I7oo00@007ooOoml00PLi`<001DLi`03001oogoo
011oo`9l0007Ga]K6elLFa/Lie[JF]/00U[J02]F^AcWE[UJ^UJiF[XLieJIDYQFVAcWEWQBEeIhDUPL
idhgDUQ>=e9H7>M>=dhFCSLLidhGBOH001cWBOI5eDWf@KDLid6eAME1]AcW?IA1]CfD7>L0000TOol0
0`00Oomoo`08Ool000Ioo`03001oogoo06Aoo`09001oogooO01:5dHGBQM65dXG00<0000IBQM65dXG
AQM:5dHGBQM65dXGAQM:5dHGBQM65dXGAQM:5dHGBQM65dXGAQM:5dHG000047oo0W`000QOG5lK7>MO
6e/KGa]K6acW15[J00]F^AcWE[UJ^EJi7>MFV5JIEYQFVAcW00ABN0067>M>=e9GDSLLidhf0Thg01<L
idXFBQI:5P007>M5mTGEBOHLidGE@KE5eD6e7>LmUD6E?ID0000TOol00`00Oomoo`08Ool000Ioo`03
001oogoo06Aoo`05001oogooO0165`04000074XHAQM:64HGBQQ65dXHAQM:64HGBQQ65dXHAQM:64HG
BQQ65dXHAQM:64HGBQQ65dXHAQM:60003goo00il05mMGcaOG5/lGa`LielKFa]O75/K7>MJfU[K0U[J
02PLieZjE[UJ^UJi7>MFV5JIDYQFVAcWEWQBEeIh7>MBF4hgDUQ>=acWCQI>=dhF7>M9mThGBOH004GE
BOI5eDWf7>M5eT6eAMDLid6e?I@002Eoo`03001oogoo00Qoo`001Goo00<007ooOol0IGoo00<007oo
00000P0002565dXGAQM:5dHGBQM65dXGAQM:5dHGBQM65dXGAQM:5dHGBQM65dXGAQM:5dHGBQM65dXG
AQM:5dHGBQM65dXG000037oo0W`000=OWAcWGe`00emL00MO6acWGa]K6elKFa/Li`04F]X02acWE[UF
^EZiE[TLieJHEYUFV5JI7>L00e9h00LLie9GCSMBEe8g7>M>=P02CSL01acWBQI:5TXF0015eDGf0095
e@077>M5eD6eAMDLicfE00009Goo00<007ooOol027oo0005Ool00`00Oomoo`1TOol400000g`07>LL
i`067>L06THGBQQ65dXHAQM:64HGBQQ65dXHAQM:64HGBQQ65dXHAQM:64HGBQQ65dXHAQM:64HG000:
Ool2O00015nMGiiOWEnM0QcW00aO?5mLFcaOGAcWGa]K6elLFa/Lie[JF]/2F]X07QcWF[YF^EZjE[TL
ieJHEYUBV1cWDUQFN59GEWPLie9HCSMBF1cWCSM>5Thg7>M>5TWfCQM9mP00AME9mP95e@057>M5eT6e
AMD0000VOol00`00Oomoo`08Ool000Eoo`03001oogoo065oo`D00003DFmASg`00096>006BSQ6>4Hh
ASQ:>4Hh4AcW00Q65dXGAQM:5dHGBQM65dXG0`001Woo0W`000=KgAcW7>L01EnM00<LiemLGe`00UmL
00HLielKFa]O6e/K7>L4F]X02QcWE[UF^EZi7>MFVEJHEYUFV1cW0e9h00XLie8gDUM>=e9G7>M>=dhf
CSLLi`=:5P090019mTGEAOI5eAcW@KE5e@0002Moo`03001oogoo00Qoo`001Goo00<007ooOol0GWoo
1000021ET1cWDI1=Ke6@CFmAT7`0BSQ6>4XhASQ:>4HhBSQ6>4XhASQ:>4HhBSQ6>4XhASQ:>4HhBSQ6
>4XhASQ:>4Hh21cW1@0000TLigooO01l05_MFmiKgE_NFmd00QcW03AOWUnMGieOWAcWGcaOG5/lGedL
ielKFa]O75/K7>MJfU[KF]YJ^QcWF[YF^EZj7>MFVEJHEYUBV1cWDUQFN59G7>M>=e9HCSMBF1cWCSM>
5Thg7>M>5TWfCQL004WfAME9mT6e7>L002Uoo`03001oogoo00Moo`001Goo00<007ooOol0FWoo1000
00@Li`00DHmET09AS`067>MASde_DHmAKg`00QcW00=6>4XhASP00THh00E:>4HhASQ6>4Xh00=6>005
BSQ6>4HhASQ:>003ASP01DXhASQ6>4HhBSP00dHh00=:>00000000P0000DLig`0O01;fd^j00<Li`AK
g@037>MOWEnM009OW@037>MOG5mL009OG0057>MO6e/KGa/Li`04F]X02eZi7>MF^EJiF[TLieJIEYQF
VEJH7>L00e9h00DLie8gDUM>=acW009>=`03CSHLidXF00=:5P050019mTGEAOH0000ZOol00`00Oomo
o`07Ool000Eoo`03001oogoo05Moo`<0000B7>L00000EHmE/1cWEI1ASeF@DHlLide_DI1=Ke6@O016
>DHh1QcW01Q:>4HhBSQ6>4XhASQ:>4HhBSQ6>4XhASQ:>4HhBSQ6>4XhASQ:>4HhBSQ6>4XhASP20002
7>L00g`07>LLi`087>L015_MFmhLiacW0enM00XLiellGeaK?5mM7>MO6e/KGa`Li`9JfP0MF]]JfUZj
7>MJ^UJiF[XLieJIEYQFVAcWEWQBF5IhDULLidhgDUQ>=acWCQI>=dhF7>M9mThFBOHLi`03000[Ool0
0`00Oomoo`07Ool000Eoo`03001oogoo05Aoo`D0009I[`037>ME[eF_009E[`0:7>MASe6?EI1ASacW
DFmASde_O008AST57>L01DXhASQ6>4HhBSP00dHh00E:>4HhASQ6>4Xh00=6>005BSQ6>4Hh000Li`02
O00:Ool00`007>LLi`0200027>L2Gid27>L3Ge`01AcWGa]K6elK7>L015[J00YJ^AcWE[UF^AcWEYQF
VEJHEYTLi`=BN0057>MBEe8gDULLi`03CSL00dhf7>M:5P02BQH2000/Ool00`00Oomoo`07Ool000Ao
o`03001oogoo059oo`<0000GOol00000EJiI[eF^FJmE[QcWEHmI/5F?EK0LieF@DHmET56?7>M=Ke6@
O00Li`02AST01DHhASU6>DHiASP00dHi00=6>4Hi7>L01AcW00m6>4XhASQ:>4HhBSQ6>4XhASQ:>4Hh
BSQ6>000O0004Goo0P0000dLi`00001OWQcWGeaK?5mM7>MO6e/KGa`Li`02F]X06E[KF]XLieJiF[YF
^AcWDYQFVEJHEYTLieIhDUQFN1cWDUQ>=e9H7>M>=dhFCSLLidhG00800003Ool007oo02]oo`03001o
ogoo00Moo`0017oo00<007ooOol0CWoo10000goo00<005V^7>L00eV_00=E[UV_7>L015F_00XLie6?
DHmASeF@DHlLie5_O012>@@Li`i6>@DLi`=6>006BSQ6>4HhASQ:>0005goo0P0000TLi`00000001cW
Ga]K6elK7>L015[J00XLieJiE[UF^AcWEYQFVEJHEYTLi`=BN0057>MBEe8gDULLi`03CSL00`00Oomo
o`02Ool00`00Oomoo`0YOol00`00Oomoo`07Ool000Aoo`03001oogoo04]oo`<000Eoo`800003FJiI
SEV^008Li`0FEJiI[eF^FJlLieF`EHmI/5F?7>MASeF@DHmET1cWDI1l01cW@SU6FT8iAUX47>L01DHh
ASU6>DHiASP00dHi00E6>4HiASU6>DHh0096>@HLi`03BSQ6>00001eoo`03000Li`000080008Li`0E
F]YJfeJi7>MF^EZjE[TLie:HEYUFV1cWDUMFN59H7>M>=e9HCSLLidhF008000Ioo`03001oogoo02Qo
o`03001oogoo00Moo`0017oo00<007ooOol0B7oo0`001goo00T001cWFJiISUV^FHiI[UF^7>L00UV_
00=E[UV_7>L015F_00PLie6?DHmASeF@7>Ml03hj0QcW0d8j00=2>D8j@SX00acW4THi0QcW00<007oo
Ool087oo00L001cW000005[JE[TLi`02E[T01QcWEYUFV5JIEYPLi`=BN0037>L00000008000Uoo`03
001oogoo02Qoo`03001oogoo00Ioo`0017oo00<007ooOol0AGoo0`0027oo0P0001aIS5V^7>MI[UV=
FJiISEV^FHdLieF^FJmE[UV_7>ME/5F?FK1ESacWDHmET56?EI1l03hk?SXn>`<Li`06AUY2>DIJ@SU6
FT8i11cW0dHi00E6>4HiASU6>DHh00=6>@06ASQ6>DHiASU6>0009Woo1P0000DLi`00000001cW00<0
00moo`03001oogoo02Moo`03001oogoo00Ioo`0017oo00<007ooOol0@Woo0`002Woo00<005V<FH`0
0eV<0QcW00IISUV^FHiI[UV>7>L2FJl00eF^FJlLi`04EJl01QcWDHmASe6?O00Li`Dn>P8Li`05@SU2
>T8j@SY2>@03@SX47>L<AST00`00Oomoo`11Ool00`00Oomoo`0WOol00`00Oomoo`06Ool000=oo`03
001oogoo03moo`@000aoo`0N001IJQcWGHeIS5f<FHaMSEV=7>MISEV^FHeI[UV=7>ME[UV_EJiI[acW
EK1ESeV`EHlLie6?O00f6Shk0QcW00Dn>Shk>SXn>chj008Li`0:AUY2>DIJ@SU6FT8iAUY2>DIJ@ST3
7>L2AST01DHhASU6>DHiASP00THi00<007ooOol0@Woo00<007ooOol09Woo00<007ooOol01Woo0003
Ool00`00Oomoo`0lOol3000?Ool01000FDYIBUU:0QcW15V<00MISQcWFHiI[UV>FJiISP027>L015V_
EJiI[acW0eF_00MASacWO00f>cHJ=S/n>P027>L5?SX37>L00d8j@SU2>P02@SX01D8i@SY2>T8j@ST0
11cW1DHi00<007ooOol0@goo00<007ooOol09Goo00<007ooOol01Woo0003Ool00`00Oomoo`0iOol3
000AOol03@00FFYIBUUZFDYIJUU:7>MIS5f<FHaMSEV<008Li`0EFJiISEV^FHeI[acWFJmE[UV_7>ME
/5F?FK0Lig`07>Lf>cHJ=S/f6Shk008Li`06>SXn>chj?S/j>Shk0QcW00a2>DIJ@SU6FT8iAUY2>DIJ
@SU6FT8iAUX47>L00dHh001oo`15Ool00`00Oomoo`0TOol00`00Oomoo`06Ool000=oo`03001oogoo
03Ioo`<001=oo`03001E1acW00IIBP8Li`AIS00<FJhLieV^FHiI[UV>FJhLieV_EJiI[acW0eF_00Ul
02gk7>Lf>cHJ=S/f6SHk?SX00QcW1Shj0QcW0d8j00E2>D8j@SY2>T8i00=2>P05@SU2>T8j7>L00017
Ool00`00Oomoo`0SOol00`00Oomoo`06Ool000=oo`03001oogoo03=oo`<001Eoo`04001I1eD7F@L2
7>L075U:FFYIBUUZFDYIJQcWGHaIS5f=FHaI[QcWFJiISEV^FHeI[QcWFJmE[UV_7>ME/5F?O00Libgk
0QcW00hf6SHk=QXf>cHJ?S/Lichk?SXn>cXj?S/n>Shk0acW00e6FT8iAUY2>DIJ@SU6FT8iAUY2>DIJ
@ST00018Ool00`00Oomoo`0ROol00`00Oomoo`06Ool000=oo`03001oogoo02moo`@001Qoo`03001E
1eD700=E1`8Li`EIBP8Li`AIS08Li`0FFHiI[UV>FJhLieV_EJiI[acWEJml01fj7>L]nbWj7>Lf6SHk
=QXf>cHJ=S/27>L8?SX27>L01D8i@SY2>T8j@ST00d8j00=2>D8j0000B7oo00<007ooOol08goo00<0
07ooOol01Goo0002Ool00`00Oomoo`0]Ool3000KOol02@007>LLiacWF@ME1eT7E@MI1`027>L01EU:
FFYIBUUZFDX00QcW01AMSEV<GHaISAcWFHeI[UV=FJhLieV_EJiI[g`03ETLib6j7>L]nbWj0QcW00Hf
>cHJ=S/f6SHk=QX27>L023hk>SXn>chj?S/j>Shk?SX37>L01d8iAUY2>DIJ@SU6FP0004Yoo`03001o
ogoo029oo`03001oogoo00Eoo`000Woo00<007ooOol0:Woo0`007Goo00<004bSD:<00UD70QcW1ED7
0QcW1EU:00<LieV<FH`00UV<01XLieV>FJiISUV^7>MI[eF^O00=F0eI7>LM^QcW;O/YnRgk7>Lf>cHJ
=S/f6SHk=QXf>acW2Shj0QcW00E2>T8i@SY2>P0004]oo`03001oogoo025oo`03001oogoo00Eoo`00
0Woo00<007ooOol09goo0`0087oo00L0052SC:=@XdbSD:=E1`027>L01ET7E@MI1eD7F@L00QcW00AI
BUUZFDYIJP8Li`03FHaMS5V<008Li`03FJiISEV^008Li`0:O00Li`eH7>LM^B6j7>L]nbWj;O/27>L0
1SHJ=S/f6SHk=QXf>`8Li`0:>SXn>chj?S/j>Shk?SXn>cXj?S/27>L00d8iAUX0001<Ool00`00Oomo
o`0POol00`00Oomoo`05Ool0009oo`03001oogoo02Aoo`<0029oo`0:000LidbSD:=<Xe2SC:=@XdbS
E@L37>L4E@L27>L4FDX03acWFHaIS5V<FJhLieV^FHiI[UV>7>L=F1cW3EPLi`027KX27>L02bWj;O/Y
nQcW=QXf>cHJ=S/f6SHk=QX00QcW2Shj0QcW00<007ooOol0Bgoo00<007ooOol07goo00<007ooOol0
1Goo0002Ool00`00Oomoo`0POol4000TOol00`00A01000037>L024bSD:=<Xe2SC:=@XdbSF@L27>L0
15D7F@ME1eT70QcW00=IBUUZFDX00QcW00MMS5V<GHdLieV^FHeI[P027>L02`eH7>L=F1cW7KTQ^Qfj
7>LYnRgk:OX00QcW00Lf>cHJ=S/f6SHk=QXf>`027>L02chj?S/j>Shk?SXn>cXj?S/n>Shk0000CGoo
00<007ooOol07goo00<007ooOol01Goo0002Ool00`00Oomoo`0MOol3000XOol00`00@0140002A000
0d007>LLi`027>L01U2SC:=@XdbSD:=<X`8Li`AE1`8Li`=IBP8Li`9IS08Li`08FHhLi`0b7>L=F1cW
3EPLi`<M^P0?7>LYnRgk:OX]nacW=S/f6SHk=QXf>cHJ=S/f6QcW00Pn>P03001oogoo04eoo`03001o
ogoo01ioo`03001oogoo00Eoo`000Woo00<007ooOol06Woo0`00:Woo00/00400A01004@0@0140400
A01004@000<Li`05D:=<Xe2SC:=@X`037>L00eT7E@MI1`027>L01eU:FFYIBQcWFHaMSEV=008Li`0?
03<Li`3F7>LAF@eH7>LM^B6j7KXLibWj;O/YnRgk008Li`07=QXf>cHJ=S/f6SHk=QX00QcW00Ln>cXj
?S/n>Shk>SX0001@Ool00`00Oomoo`0NOol00`00Oomoo`04Ool00003Ool007oo01Uoo`<002eoo`05
000LiacWA0100003A0001T00A01404@0@01400<Li`05D:=<Xe2SC:=@X`037>L2E@L27>L2FDX27>L0
2eV<7>LLiacW03<Li`eI7>L=F@eH7>L00afj00HLibWj;O/YnRgk:OX27>L01cHk=QXf>cHJ=S/f6SHk
008Li`@n>P03001oogoo04moo`03001oogoo01eoo`03001oogoo00Aoo`0000=oo`00Ool05Woo0`00
<7oo00<00300=0001QcW00Q004@0@0140400A01004@011cW00A<Xe2SC:=@X`<Li`06F@LLiacWFDYI
JW`00acW01/0<QcW0=H=FAcW4ET=F1cW7KTQ^Qfj7>LYnRgk:OX]nbWj;O/LicHk=QXf>cHJ=S/f6SHk
=QX00QcW00<n>`00Ool0DWoo00<007ooOol077oo00<007ooOol017oo00000goo001oo`0BOol4000b
Ool00`00<00d0003<00013@0<00`03001AcW00E004@0A0140400009400<Li`04C:=@XdbSE@L27>L0
0eD77>Ml00027>L02`097>L0<`0b7>L0eQcW3EP=F@eH7>L00afj00LLibWj;O/YnRgk:OX]n`027>L0
2SHJ=S/f6SHk=QXf>cHJ=S/Li`00Dgoo00<007ooOol077oo00<007ooOol017oo00000goo001oo`0?
Ool3000fOol03`00=00`03@0<00d0300=00`03@0<00d0300=00`00057>L01D00A01004@0@00011cW
00E@XdbS7>Ml0000008Li`0?00PLiacW03<Li`3F3EPLi`eH4ETLiafj7KTQ^Qfj008Li`0?;O/YnRgk
:OX]nbWj7>Lf6SHk=QXf>cHJ=S/f6P0005Eoo`03001oogoo01]oo`03001oogoo00Aoo`0000=oo`00
Ool037oo0`00>Goo00<001cW7>L01AcW00Dd0300<00`03@000<`0004=00`0300<0067>L3A0027>L0
0g`0OolLi`027>L030097>LLi`0b03<Li`3F3EPLi`eH3ETLi`@M^P08;O/Libgk:OX]nbWj;O/YnP8L
i`06=S/f6SHk=QXf>`00EWoo00<007ooOol06Woo00<007ooOol017oo00000goo001oo`09Ool3000l
Ool02000700H01`0600L01P0700@7>L01300=00`03@00acW00=l07oo7>L00QcW00H02AcW7>L0<`0b
7>L20=H05acW3ET=F15I7>LM^Qfi8KXM^Rgk7>L]nbWj;O/YnRgk:OX]nacW=S/f6SHk0000F7oo00<0
07ooOol06Goo00<007ooOol017oo00000`00Oomoo`06Ool3000oOol00`00700L000E70077>L00g`0
7>LLi`027>L03P097>L03QcW03<0<QcW0=H=FAcW3ET=F0eI7>L47KX02Bgk7>L]nbWj;O/YnRgk:OX]
n`027>L00cHJ001oo`1HOol00`00Oomoo`0HOol00`00Oomoo`04Ool00003001oogoo009oo`@0049o
o`08000L01P0700H01`0600L01@Li`8000HLi`0700PLi`0>7>L0<P0c7>L00P3F01DAFAcW3ET=F15I
7>LM^Qfi8KXM^Rgk7>L]nbWj;O/YnRgk:OX]nbWj0000Fgoo00<007ooOol067oo00<007ooOol00goo
00000`00Ool000020016Ool00`007>LLi`057>L810067>L400000b<D7>LLi`077>L200T27>L0100c
0380<acW0P3F00HLi`eH3ET=F0eI7>L57KX021cW;O/YnRgk:OX]nbWj001LOol00`00Oomoo`0HOol0
0`00Oomoo`03Ool0008004Uoo`03000400@000L400HLi`L000TLi`04E/DLiacW7>L200T01QcW00hL
i`0c038Li`<0eP097>L=F0eI3EPAFAcW7KXM^B6j008M^P8Li`05:OX]nbWj;O/0001MOol00`00Oomo
o`0GOol00`00Oomoo`03Ool00003Ool0000004Qoo`04000400@010067>L900067>L013=E7>LLie>@
0acW00AFaAcW7>LLi`802@077>L03QcW0380<`0b7>L00P3F00L=F1cW3EP=F@eH3ETLi`057KX01BWj
7>LYnRgk0000Ggoo00<007ooOol05Woo00<007ooOol00goo0003Ool00`00Oomoo`15Ool010007>LL
iacW2`0011cW00DS5B<D7>LLicME00DLi`05FbXLie[57>L000027>L02@0800TLi`0>7>L0<`0b03<L
i`030=H02QcW4ET=F0eI3EPAFAcW7KXM^B6j0Qfj00@YnQcW:OX0061oo`03001oogoo01Eoo`03001o
ogoo00=oo`0017oo00<007ooOol0A7oo2`0011cW0b<D0acW0S=E0QcW00A;TQcW7>MKK@8Li`03E/DL
i`00008Li`802@087>L03P0>7>L0<`0b03<Li`<0eP077>L=F@eH3ET=F0eI7>L01Afj00<YnP00Ool0
HGoo00<007ooOol057oo00<007ooOol00goo0005Ool20015Ool600047>L01BLE8a@S5B<D9aD00QcW
00<cE3ME<e@00acW00E;TQcWDi0Lie/Y008Li`03F/DLi`00008Li`802@087>L03P0>7>L0<P0c038L
i`<0eP073ETLia5I3EP=F@eH7>L00Qfj00DM^B6j7KXM^P00069oo`03001oogoo01Aoo`03001oogoo
00=oo`001goo00<007ooOol0@Woo0P0011cW1R<D0acW0S=E00<gEAcW7>L00QcW00E;TQcWDi0LieM]
008Li`04F/EFaAcW00027>L300T021cW00h0<QcW0380<`0b7>L30=H01acW3EP=F@eH3ET=F1cW00@M
^P03001oogoo069oo`03001oogoo01Aoo`03001oogoo009oo`0027oo0P00@Woo00X001cW8aDS52LE
8a@S5B<D9aDS508Li`04=eDcE3ME<e@27>L03D>D7>M?Td^B7>MCT1cWEddLieLY7>MFaAcW0080008L
i`0400P02@097>L200h01AcW03<0<P0c7>L0103F00LLi`eH4ET=F0eI3EPLi`027KX00`00Oomoo`1T
Ool00`00Oomoo`0COol00`00Oomoo`02Ool000Yoo`03001oogoo03moo`03000S52<D00DS508Li`04
<eDgEC=E<eD27>L024=d@i@LidnCBi8Lie>@7>L2Efd27>L2E/D01QcW000001cW00<Li`802@097>L0
3P0>7>L0<P0c0380<acW00<0eP0:3EPLi`eH3ET=F0eI3EPLiafj001WOol00`00Oomoo`0BOol00`00
Oomoo`02Ool000]oo`80041oo`04000W5B<D8aD37>L023ME<e@gEC=D@i@Lid>D?g@27>L05DnCBi8L
ie>@7>MGCE]]7>MK:QcWF/EFa1cW000Li`0300@Li`0900PLi`0200h01P0b7>L0<P0c038Li`@0eP08
7>L=F@eH4ET=F0eI3EP006Uoo`03001oogoo015oo`03001oogoo009oo`003Goo00<007ooOol0?Goo
00D002<D7>LLicME00<cE@0;=eDcEAcW7>M3U4=d7>M;TTnCBi8Li`02Di003QcWEfeK:AcWFbTLieK5
F/DLi`007>L010037>L200T02QcW00h03P0>7>L0<`0b03<0<QcW103F00HLi`eI3EP=F@eH001ZOol0
0`00Oomoo`0AOol00`00Oomoo`02Ool000ioo`03001oogoo03aoo`08000Lic=D=eDcE3ME<e@gE@8L
i`0C?gA3U3md7>M;TTnCBi8Lie>@Ei4Lie]]EddLie/Y7>MFa5[57>L00P0000@Li`0300@Li`802@0:
7>L03P0>00hLi`0b03<0<P0c7>L50=H011cW3ET=F000K7oo00<007ooOol047oo00<007ooOol00Woo
000?Ool2000mOol00`00=eDcE@02<eD27>L00d>D@gA3U0027>L014^BCi=;TQcW0U>@00XLieM]EfeK
:QcWFbTLie[5E/DLi`8000047>L00`037>L200T02`0>7>L03P0>038Li`0b03<0<P0c7>L0103F00<L
i`eH0000KWoo00<007ooOol03goo00<007ooOol00Woo000AOol00`00Oomoo`0jOol00`00<e@gE@02
7>L05cmd@i@oM4>D7>M?Td^BCi=;TQcWDi1GTAcWFfeGCE]^7>MK:QcWF/EFaE[57>L00P0000PLi`03
00@Li`0900P02AcW0`0>00HLi`0c0380<`0b7>L50=H00`00Oomoo`1^Ool00`00Oomoo`0>Ool00`00
Oomoo`02Ool0019oo`8003]oo`0;000Lid>D@gA3U4=d@i@Lid^CBi9?T`027>L3Di0011cWEfeKKAcW
0U/Y00DLieK5E/EFaAcW008000047>L010037>L300T02acW00h03P0>7>L0<P0c0380<`0b7>L00`3F
00<007ooOol0L7oo00<007ooOol03Woo00<007ooOol00Goo000DOol00`00Oomoo`0iOol01000?gA3
U3md0QcW01=?Td^BCi<LieN@Di1GTE>@7>MGCE]^EddLieLYFbXLie[5E/@Li`03000011cW00<011cW
0`0900/Li`0>00h03P0b7>L0<P0c0380<acW0080eP03001oogoo079oo`03001oogoo00eoo`03001o
ogoo005oo`005Goo00<007ooOol0>Goo00P004=d7>M;TT^CBi9?TacW15>@00PLieM]FfeGKAcWFbUK
:QcW0UK500=JaAcW00000P0000@Li`0300<Li`<02@037>L03P0>00803P087>L0<`0b03<0<P0c7>L0
07Eoo`03001oogoo00eoo`03001oogoo005oo`005Woo0P00>Woo01L004^BCi=;TTnC7>MGT5>@Ei5C
T1cWEdeKKUM=FbXLie/ZFbTLieK4F/EFaAcW00<000087>L00`047>L02@0800TLi`@03P077>L0<P0c
0380<`0b0000Mgoo00<007ooOol037oo00<007ooOol00Goo000HOol00`00Oomoo`0hOol01000Bi9?
TacW15>@00<LieM]Ffd00UM]00HLie/ZFbTLieK5F/D2E/D021cW000000007>L010037>L300T00`0>
7>L03P0200h0100b7>L0<P0c0P00NGoo00<007ooOol02goo00<007ooOol00Goo000IOol2000iOol0
50007>LLie>@Ei5CT5N@7>MKKUM=FfdLie/ZFbUK:QcWF/EFaE[57>L4000011cW00<011cW0`0900<0
21cW00h00`0>00<Li`000000O7oo00<007ooOol02Woo00<007ooOol00Goo000KOol00`00Oomoo`0g
Ool00`00Di1CT002Di000acWFfeGK@02Efd01AcWFbUK:E/Y7>L00eK500DLi`00000001cW00<00`03
7>L02@0900802@047>L03P0>00h2001oOol00`00Oomoo`09Ool00`00Oomoo`01Ool001aoo`8003Qo
o`80000@Ei0Lie]^EdeKKEM=7>MK:E/ZEbTLieK5F/EFa5[57>L300001acW00@00`047>L02@080080
2@047>L03P000021Ool00`00Oomoo`0:Ool10001Ool1Ool001ioo`03001oogoo03Moo`<0009GK@06
FfdLie/YFbUK:QcW0UK500=JaEK57>L00`0000DLi`0300@00acW00@02@8008Aoo`03001oogoo00Uo
o`40005oo`5oo`007goo00<007ooOol0>Goo0`0000UK:ULYFbXLie[5E/AJaEK57>L0100000DLi`04
00<011cW00802@8008Moo`03001oogoo00Qoo`40005oo`5oo`0087oo0P00?7oo0P0000AK:AcWE/EJ
a@9Fa@037>L00000008000037>L00`0300@008Yoo`03001oogoo00Moo`40005oo`5oo`008Woo00<0
07ooOol0>goo3P00Sgoo00<007ooOol01Woo0@000Goo0Goo000SOol20016Ool00`00Oomoo`2?Ool0
0`00Oomoo`06Ool10001Ool1Ool002Eoo`03001oogoo04=oo`03001oogoo091oo`03001oogoo00Eo
o`40005oo`5oo`009Woo0P00@goo00<007ooOol0TGoo00<007ooOol01Goo0@000Goo000XOol00`00
Oomoo`10Ool00`00Oomoo`2BOol00`00Oomoo`04Ool10001Ool002Uoo`03001oogoo03moo`03001o
ogoo09=oo`03001oogoo00=oo`40005oo`00:Woo0P00?goo00<007ooOol0U7oo00<007ooOol00Woo
0@000Goo000/Ool00`00Oomoo`0lOol00`00Oomoo`2DOol00`00Oomoo`02Ool10001Ool002eoo`80
03aoo`03001oogoo09Eoo`05001oogooOol00001Ool002moo`03001oogoo03Uoo`03001oogoo09Io
o`04001oogoo0001Ool0031oo`03001oogoo03Qoo`03001oogoo09Moo`03001oo`00005oo`00<Goo
0P00=goo00<007ooOol0VGoo0@000Goo0@00000cOol00`00Oomoo`0dOol00`00Oomoo`2IOol10001
Ool1000003Aoo`8003Aoo`03001oogoo09Yoo`800000=Woo00<007ooOol0<Goo00<007ooOol0VGoo
0`00000gOol2000aOol00`00Oomoo`2EOol40003Ool003Uoo`03001oogoo02ioo`03001oogoo091o
o`D000Moo`00>Woo00<007ooOol0;Goo00<007ooOol0S7oo100037oo000kOol2000]Ool00`00Oomo
o`28Ool4000@Ool003eoo`03001oogoo02Yoo`03001oogoo08=oo`D001Aoo`00?Woo0P00:Woo00<0
07ooOol0Ogoo10006Goo0010Ool00`00Oomoo`0WOol00`00Oomoo`1jOol5000MOol0045oo`03001o
ogoo02Ioo`03001oogoo07Ioo`@0029oo`00@Woo0P009Woo00<007ooOol0LWoo10009Woo0014Ool0
0`00Oomoo`0SOol00`00Oomoo`1]Ool5000ZOol004Eoo`8002=oo`03001oogoo06Uoo`@002moo`00
Agoo00<007ooOol087oo00<007ooOol0I7oo1@00<goo0018Ool2000POol00`00Oomoo`1POol4000h
Ool004Yoo`03001oogoo01eoo`03001oogoo05]oo`D003aoo`00Bgoo00<007ooOol077oo00<007oo
Ool0Egoo1000@Goo001<Ool2000LOol00`00Oomoo`1COol40015Ool004ioo`03001oogoo01Uoo`03
001oogoo04ioo`D004Uoo`00Cgoo0P006Goo00<007ooOol0BWoo1000CWoo001AOol00`00Oomoo`0F
Ool00`00Oomoo`15Ool5001BOol0059oo`8001Ioo`03001oogoo045oo`@005Moo`00E7oo00<007oo
Ool04goo00<007ooOol0?Goo1000Fgoo001EOol00`00Oomoo`0BOol00`00Oomoo`0hOol5001OOol0
05Ioo`80015oo`03001oogoo03Eoo`@006Aoo`00F7oo00<007ooOol03Woo00<007ooOol0<7oo1@00
J7oo001IOol2000>Ool00`00Oomoo`0/Ool4001]Ool005]oo`03001oogoo00]oo`03001oogoo02Mo
o`D0075oo`00G7oo00<007ooOol02Woo00<007ooOol08goo1000MWoo001MOol2000:Ool00`00Oomo
o`0OOol4001jOol005moo`03001oogoo00Moo`03001oogoo01Yoo`D007ioo`00H7oo0P001goo00<0
07ooOol05Woo1000Pgoo001ROol00`00Oomoo`04Ool00`00Oomoo`0AOol50027Ool006=oo`8000Ao
o`03001oogoo00eoo`@008aoo`00IGoo00D007ooOomoo`0000]oo`@0091oo`00IWoo00@007ooOol0
00Ioo`D009Aoo`00Igoo0`000Woo1000VGoo001YOol3002MOol00001
\>"],
  ImageRangeCache->{{{0, 264.313}, {287, 0}} -> {0.0486402, -0.000148683, 
  0.00324458, 0.00324458}}]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell["And if Kappa is not 1, it doesn't come out even either.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 125; kappa[s_] = 2; tau[s_] := Sin[s]; width = .3; 
    ds = .1; \), 
    \(pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.11022e-016 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.63068 .68773 m .68261 .61817 L .59957 .66639 L .453 .404 .712 r
F
.63068 .68773 m .69395 .63511 L .68261 .61817 L F
.66496 .70596 m .69395 .63511 L .63068 .68773 L .35 .356 .725 r
F
.59957 .66639 m .67209 .6003 L .57287 .642 L .525 .44 .702 r
F
.59957 .66639 m .68261 .61817 L .67209 .6003 L F
0 g
.006 w
.59957 .66639 m
.63068 .68773 L
s
.25 g
.5 Mabswid
.59957 .66639 m
.60467 .66343 L
s
.66496 .70596 m .70569 .65107 L .69395 .63511 L .35 .356 .725 r
F
.25 g
.69135 .63727 m
.69395 .63511 L
s
.70109 .72111 m .70569 .65107 L .66496 .70596 L .186 .284 .732 r
F
0 g
.006 w
.63068 .68773 m
.66496 .70596 L
s
.25 g
.5 Mabswid
.63068 .68773 m
.63451 .68455 L
s
.60537 .53295 m .60821 .53219 L .60566 .53179 L .703 .564 .695 r
F
.60821 .53219 m .61788 .52158 L .53008 .51987 L F
.63035 .51744 m .62145 .51883 L .6016 .54666 L .968 .879 .494 r
F
.65709 .48707 m .63979 .49192 L .63035 .51744 L .98 .852 .642 r
F
.61158 .50713 m .61006 .52143 L .62248 .5091 L .739 .599 .701 r
F
.61158 .50713 m .62248 .5091 L .62323 .50531 L F
.60819 .52139 m .61006 .52143 L .61158 .50713 L F
.63035 .51744 m .62248 .5091 L .62053 .51897 L .968 .879 .494 r
F
.63979 .49192 m .62688 .50474 L .63035 .51744 L .98 .852 .642 r
F
.62688 .50474 m .62248 .5091 L .62293 .50957 L F
.62688 .50474 m .62293 .50957 L .63035 .51744 L F
.53008 .51987 m .62688 .50474 L .53845 .48597 L .739 .599 .701 r
F
.62688 .50474 m .63093 .49977 L .53845 .48597 L F
.62323 .50531 m .62248 .5091 L .62688 .50474 L F
.63979 .49192 m .63895 .49215 L .62248 .5091 L .98 .852 .642 r
F
.53845 .48597 m .63093 .49977 L .63922 .49053 L .774 .639 .711 r
F
.65709 .48707 m .64041 .48341 L .63895 .49215 L .98 .852 .642 r
F
.68055 .45601 m .66509 .46135 L .65709 .48707 L .925 .79 .693 r
F
.64061 .48218 m .64041 .48341 L .64183 .48213 L .774 .639 .711 r
F
.53845 .48597 m .63922 .49053 L .64061 .48218 L F
.55456 .45234 m .64293 .48066 L .65148 .46267 L .809 .684 .726 r
F
.64183 .48213 m .63978 .48327 L .64041 .48341 L .925 .79 .693 r
F
.65091 .47402 m .64293 .48066 L .64183 .48213 L F
.53845 .48597 m .64183 .48213 L .55456 .45234 L .774 .639 .711 r
F
.64183 .48213 m .64293 .48066 L .55456 .45234 L F
.64293 .48066 m .63978 .48327 L .64183 .48213 L .925 .79 .693 r
F
.66509 .46135 m .64041 .48341 L .65709 .48707 L F
.64183 .48213 m .64693 .48194 L .64293 .48066 L .774 .639 .711 r
F
.64293 .48066 m .64693 .48194 L .64829 .4762 L .809 .684 .726 r
F
.64293 .48066 m .64829 .4762 L .65148 .46267 L F
.66509 .46135 m .61649 .47815 L .63978 .48327 L .925 .79 .693 r
F
.66509 .46135 m .63978 .48327 L .65091 .47402 L F
.64183 .48213 m .63922 .49053 L .64693 .48194 L .774 .639 .711 r
F
.64041 .48341 m .63922 .49053 L .64183 .48213 L F
.63093 .49977 m .64667 .48482 L .64693 .48194 L F
.63895 .49215 m .61649 .47815 L .61328 .49934 L .98 .852 .642 r
F
.64041 .48341 m .61649 .47815 L .63895 .49215 L F
.63895 .49215 m .61328 .49934 L .62183 .50841 L F
.63895 .49215 m .62183 .50841 L .62248 .5091 L F
.63093 .49977 m .6451 .50189 L .64667 .48482 L .774 .639 .711 r
F
.62688 .50474 m .6451 .50189 L .63093 .49977 L .739 .599 .701 r
F
.62688 .50474 m .61788 .52158 L .63651 .50323 L F
.61006 .52143 m .61788 .52158 L .62688 .50474 L F
.62053 .51897 m .61328 .49934 L .60897 .52077 L .968 .879 .494 r
F
.62248 .5091 m .61328 .49934 L .62053 .51897 L F
.53008 .51987 m .60819 .52139 L .61158 .50713 L .739 .599 .701 r
F
.60537 .53295 m .6071 .53332 L .60821 .53219 L .703 .564 .695 r
F
.62145 .51883 m .618 .5223 L .6016 .54666 L .968 .879 .494 r
F
.618 .5223 m .6142 .52615 L .6016 .54666 L F
.60471 .53573 m .6071 .53332 L .60537 .53295 L .703 .564 .695 r
F
.6184 .5193 m .60553 .53363 L .60497 .53546 L .968 .879 .494 r
F
.6142 .52615 m .60497 .53546 L .6016 .54666 L F
.6184 .5193 m .60497 .53546 L .6142 .52615 L F
.52967 .55313 m .59315 .54741 L .60537 .53295 L .703 .564 .695 r
F
.60241 .54511 m .60307 .54265 L .60255 .54482 L 0 0 0 r
F
.60942 .5207 m .60868 .52178 L .6016 .54666 L .968 .879 .494 r
F
.6016 .54666 m .60459 .53617 L .60241 .54511 L 0 0 0 r
F
.60255 .54482 m .6071 .53332 L .60471 .53573 L .703 .564 .695 r
F
.60213 .5466 m .60293 .54447 L .60255 .54482 L F
.60293 .54447 m .6071 .53332 L .60255 .54482 L F
.60942 .5207 m .60897 .52077 L .60868 .52178 L .968 .879 .494 r
F
.60459 .53617 m .60897 .52077 L .60241 .54511 L 0 0 0 r
F
.6016 .54666 m .60238 .54515 L .57216 .57437 L F
.60238 .54515 m .59552 .55166 L .57216 .57437 L F
.60255 .54482 m .60052 .54674 L .57216 .57437 L F
.58323 .56057 m .60052 .54674 L .59315 .54741 L .666 .532 .692 r
F
.57599 .57019 m .58133 .56508 L .58323 .56057 L F
.58133 .56508 m .60052 .54674 L .58323 .56057 L F
.60052 .54674 m .58429 .56208 L .58133 .56508 L 0 0 0 r
F
.60052 .54674 m .58133 .56508 L .57216 .57437 L F
.57298 .57403 m .58058 .56622 L .57853 .57172 L 0 0 .222 r
F
.58058 .56622 m .58106 .56572 L .57979 .56875 L F
.58058 .56622 m .57979 .56875 L .57853 .57172 L F
.57216 .57437 m .57891 .57157 L .54339 .60026 L F
.58434 .56702 m .65509 .56224 L .64937 .54233 L .666 .532 .692 r
F
.58256 .56851 m .65509 .56224 L .58434 .56702 L F
.57945 .56984 m .65509 .56224 L .57979 .56875 L F
.57891 .57157 m .57062 .5785 L .54339 .60026 L 0 0 .222 r
F
.54428 .59969 m .57062 .5785 L .54424 .59959 L .626 .502 .692 r
F
.5517 .61475 m .56756 .58438 L .54428 .59969 L F
.56756 .58438 m .57062 .5785 L .54428 .59969 L F
.5517 .61475 m .65509 .56224 L .57062 .5785 L F
.54337 .60029 m .59301 .58422 L .51666 .6241 L .16 0 .393 r
F
.54339 .60026 m .54341 .60026 L .54337 .60029 L F
.54341 .60026 m .59301 .58422 L .54337 .60029 L F
.57062 .5785 m .54958 .59613 L .54342 .60025 L 0 0 .222 r
F
.57062 .5785 m .54342 .60025 L .54339 .60026 L F
.54424 .59959 m .57062 .5785 L .53704 .58497 L .626 .502 .692 r
F
.57216 .57437 m .57407 .57244 L .57298 .57403 L 0 0 .222 r
F
.60238 .54515 m .60255 .54482 L .59552 .55166 L 0 0 0 r
F
.58133 .56508 m .64937 .54233 L .60052 .54674 L .666 .532 .692 r
F
.57407 .57244 m .58133 .56508 L .57298 .57403 L 0 0 .222 r
F
.58133 .56508 m .58106 .56572 L .57298 .57403 L F
.57599 .57019 m .57979 .56875 L .58133 .56508 L .666 .532 .692 r
F
.57979 .56875 m .64937 .54233 L .58133 .56508 L F
.59315 .54741 m .60213 .5466 L .60471 .53573 L .703 .564 .695 r
F
.60213 .5466 m .64937 .54233 L .6071 .53332 L F
.6056 .53355 m .60594 .53225 L .60553 .53363 L .968 .879 .494 r
F
.6184 .5193 m .60594 .53225 L .6056 .53355 L F
.6184 .5193 m .60942 .5207 L .60594 .53225 L F
.6027 .54455 m .60897 .52077 L .60391 .5422 L 0 0 0 r
F
.60255 .54482 m .60326 .54218 L .6027 .54455 L F
.60326 .54218 m .60897 .52077 L .6027 .54455 L F
.60307 .54265 m .60897 .52077 L .60255 .54482 L F
.60255 .54482 m .60391 .5422 L .58429 .56208 L F
.58133 .56508 m .60391 .5422 L .58106 .56572 L 0 0 .222 r
F
.56636 .57932 m .57714 .57725 L .57599 .57019 L .666 .532 .692 r
F
.57714 .57725 m .65509 .56224 L .57945 .56984 L F
.57853 .57172 m .57904 .57113 L .57891 .57157 L 0 0 .222 r
F
.57979 .56875 m .58256 .56851 L .58434 .56702 L .666 .532 .692 r
F
.58106 .56572 m .60391 .5422 L .57853 .57172 L 0 0 .222 r
F
.57714 .57725 m .57945 .56984 L .57599 .57019 L .666 .532 .692 r
F
.57891 .57157 m .60391 .5422 L .59846 .56342 L 0 0 .222 r
F
.57904 .57113 m .60391 .5422 L .57891 .57157 L F
.57891 .57157 m .59846 .56342 L .54958 .59613 L F
.57599 .57019 m .57945 .56984 L .57979 .56875 L .666 .532 .692 r
F
.57096 .5721 m .57599 .57019 L .59315 .54741 L F
.53704 .58497 m .56636 .57932 L .57599 .57019 L F
.59315 .54741 m .60471 .53573 L .60537 .53295 L .703 .564 .695 r
F
.62022 .51902 m .61518 .52454 L .6142 .52615 L .968 .879 .494 r
F
.62022 .51902 m .6142 .52615 L .618 .5223 L F
.63651 .50323 m .64596 .52213 L .6451 .50189 L .739 .599 .701 r
F
.62145 .51883 m .62053 .51897 L .618 .5223 L .968 .879 .494 r
F
.62053 .51897 m .61969 .5198 L .618 .5223 L F
.61788 .52158 m .64596 .52213 L .63651 .50323 L .739 .599 .701 r
F
.62053 .51897 m .62022 .51902 L .61969 .5198 L .968 .879 .494 r
F
.60821 .53219 m .64937 .54233 L .64596 .52213 L .703 .564 .695 r
F
.6071 .53332 m .64937 .54233 L .60821 .53219 L F
.52967 .55313 m .60537 .53295 L .53008 .51987 L F
.60537 .53295 m .60566 .53179 L .53008 .51987 L F
.60821 .53219 m .64596 .52213 L .61788 .52158 L F
.62022 .51902 m .6184 .5193 L .61518 .52454 L .968 .879 .494 r
F
.53704 .58497 m .57096 .5721 L .52967 .55313 L .666 .532 .692 r
F
.57096 .5721 m .59315 .54741 L .52967 .55313 L F
.25 g
.61328 .49934 m
.62183 .50841 L
s
.62183 .50841 m
.62248 .5091 L
s
0 g
.006 w
.64522 .50055 m
.65709 .48707 L
s
.25 g
.5 Mabswid
.60518 .5341 m
.60897 .52077 L
s
.60471 .53573 m
.60518 .5341 L
s
.57287 .642 m .66278 .58161 L .5517 .61475 L .58 .472 .696 r
F
.57287 .642 m .67209 .6003 L .66278 .58161 L F
0 g
.006 w
.57287 .642 m
.59957 .66639 L
s
.25 g
.5 Mabswid
.68914 .63911 m
.69135 .63727 L
s
.63451 .68455 m
.68914 .63911 L
s
.67887 .62034 m
.68261 .61817 L
s
.60467 .66343 m
.67887 .62034 L
s
.57287 .642 m
.57905 .6394 L
s
.63542 .48231 m
.64041 .48341 L
s
.64667 .48478 m
.65709 .48707 L
s
.58429 .56208 m
.60391 .5422 L
s
.70109 .72111 m .71742 .66596 L .70569 .65107 L .186 .284 .732 r
F
.25 g
.70285 .6549 m
.70419 .65309 L
s
.70419 .65309 m
.70569 .65107 L
s
.73772 .73328 m .71742 .66596 L .70109 .72111 L 0 .16 .696 r
F
.25 g
.66496 .70596 m
.66739 .70269 L
s
.66739 .70269 m
.70285 .6549 L
s
0 g
.006 w
.66496 .70596 m
.70109 .72111 L
s
.25 g
.5 Mabswid
.70109 .72111 m
.71689 .66774 L
s
.81517 .3036 m .74215 .37987 L .83888 .30797 L .777 .892 .926 r
F
.81517 .3036 m .73091 .38054 L .74215 .37987 L F
.5517 .61475 m .66278 .58161 L .65509 .56224 L .626 .502 .692 r
F
.25 g
.6569 .58337 m
.66278 .58161 L
s
.5517 .61475 m
.55874 .61265 L
s
.58319 .5632 m
.58429 .56208 L
s
0 g
.006 w
.5517 .61475 m
.57287 .642 L
s
.25 g
.5 Mabswid
.66722 .60235 m
.67209 .6003 L
s
0 g
.006 w
.54819 .60763 m
.5517 .61475 L
s
.57776 .41999 m .65148 .46267 L .65861 .44449 L .842 .736 .746 r
F
.55456 .45234 m .65148 .46267 L .57776 .41999 L .809 .684 .726 r
F
.68055 .45601 m .61829 .45745 L .61649 .47815 L .925 .79 .693 r
F
.25 g
.5 Mabswid
.61649 .47815 m
.63542 .48231 L
s
.60701 .38997 m .65861 .44449 L .66803 .42783 L .87 .793 .773 r
F
.57776 .41999 m .65861 .44449 L .60701 .38997 L .842 .736 .746 r
F
.69955 .42477 m .61829 .45745 L .68055 .45601 L .871 .742 .717 r
F
0 g
.006 w
.65709 .48707 m
.68055 .45601 L
s
.78576 .30453 m .73091 .38054 L .81517 .3036 L .798 .922 .92 r
F
.25 g
.5 Mabswid
.82397 .31905 m
.83888 .30797 L
s
.78576 .30453 m .71837 .38428 L .73091 .38054 L .798 .922 .92 r
F
1 0 0 r
.003 w
.73091 .38054 m
.74215 .37987 L
s
.54339 .60026 m .59846 .56342 L .59301 .58422 L .16 0 .393 r
F
.25 g
.5 Mabswid
.54339 .60026 m
.54342 .60025 L
s
.54342 .60025 m
.54675 .59802 L
s
.54675 .59802 m
.54958 .59613 L
s
0 g
.006 w
.53704 .58497 m
.54407 .59926 L
s
.54407 .59926 m
.54424 .59959 L
s
.25 g
.5 Mabswid
.58133 .56508 m
.58319 .5632 L
s
0 g
.006 w
.54339 .60026 m
.54421 .59953 L
s
.73772 .73328 m .72872 .67974 L .71742 .66596 L 0 .16 .696 r
F
.25 g
.5 Mabswid
.71689 .66774 m
.71742 .66596 L
s
.77344 .74267 m .72872 .67974 L .73772 .73328 L 0 0 .521 r
F
0 g
.006 w
.70109 .72111 m
.73772 .73328 L
s
.75191 .31106 m .71837 .38428 L .78576 .30453 L .829 .936 .899 r
F
.25 g
.5 Mabswid
.80656 .31146 m
.81517 .3036 L
s
.75191 .31106 m .70515 .39107 L .71837 .38428 L .829 .936 .899 r
F
1 0 0 r
.003 w
.71837 .38428 m
.73091 .38054 L
s
.25 g
.5 Mabswid
.56636 .57932 m
.57062 .5785 L
s
.59578 .57366 m
.65509 .56224 L
s
.53704 .58497 m
.54466 .5835 L
s
.54466 .5835 m
.55585 .58135 L
s
.55585 .58135 m
.56636 .57932 L
s
.71855 .32211 m .70515 .39107 L .75191 .31106 L .861 .929 .87 r
F
.71518 .32357 m .70515 .39107 L .71855 .32211 L F
.70864 .36756 m .6919 .40076 L .70515 .39107 L F
.70033 .37282 m .6919 .40076 L .70864 .36756 L F
.71186 .31153 m .66057 .34728 L .7156 .32339 L .738 .669 .783 r
F
.67804 .34274 m .6919 .40076 L .71508 .32373 L .883 .899 .837 r
F
.71508 .32373 m .71185 .33446 L .71518 .32357 L .861 .929 .87 r
F
.71185 .33446 m .7119 .33441 L .71518 .32357 L F
.70603 .35379 m .70608 .35375 L .71518 .32357 L F
.71518 .32357 m .70033 .37282 L .70864 .36756 L F
.66057 .34728 m .64169 .36044 L .66607 .35137 L .738 .669 .783 r
F
.64169 .36044 m .60618 .38519 L .64257 .36464 L F
.64169 .36044 m .64257 .36464 L .66607 .35137 L F
.60701 .38997 m .66803 .42783 L .64343 .36939 L .87 .793 .773 r
F
.60701 .38997 m .64343 .36939 L .61644 .38252 L F
.6422 .37167 m .60618 .38519 L .63299 .38873 L .762 .673 .764 r
F
.64889 .37368 m .66803 .42783 L .67931 .41312 L .885 .85 .804 r
F
.64432 .36775 m .64744 .37568 L .64889 .37368 L F
.64744 .37568 m .66803 .42783 L .64889 .37368 L F
.64391 .3685 m .66803 .42783 L .64432 .36775 L F
.64373 .3701 m .66803 .42783 L .64391 .3685 L F
.64354 .3692 m .64391 .3685 L .64282 .36582 L F
.64373 .3701 m .64391 .3685 L .64354 .3692 L F
.64282 .36582 m .67931 .41312 L .67765 .34417 L F
.68559 .37436 m .67931 .41312 L .6919 .40076 L .883 .899 .837 r
F
.67947 .37921 m .67931 .41312 L .68559 .37436 L F
.67819 .35113 m .67931 .41312 L .6796 .3493 L F
.67765 .34417 m .67783 .3516 L .67804 .34274 L F
.67783 .3516 m .67931 .41312 L .67819 .35113 L F
.67783 .3516 m .67819 .35113 L .67804 .34274 L F
.64354 .3692 m .60618 .38519 L .6422 .37167 L .762 .673 .764 r
F
.6796 .3493 m .67947 .37921 L .68559 .37436 L .883 .899 .837 r
F
.67804 .34274 m .67819 .35113 L .6796 .3493 L F
.71508 .32373 m .64258 .36465 L .70172 .34429 L .738 .669 .783 r
F
.64258 .36465 m .60618 .38519 L .64354 .3692 L F
.64282 .36582 m .64391 .3685 L .64432 .36775 L .885 .85 .804 r
F
.64258 .36465 m .64354 .3692 L .70172 .34429 L .738 .669 .783 r
F
.71419 .32419 m .60618 .38519 L .71508 .32373 L F
.64085 .36326 m .64373 .3701 L .64282 .36582 L .885 .85 .804 r
F
.64354 .3692 m .6422 .37167 L .67052 .36103 L .762 .673 .764 r
F
.67147 .35982 m .67052 .36103 L .69324 .35251 L F
.64354 .3692 m .67052 .36103 L .67147 .35982 L F
.70603 .35379 m .6919 .40076 L .70608 .35375 L .861 .929 .87 r
F
.71299 .39398 m .63593 .41364 L .61839 .43749 L .827 .708 .733 r
F
.63593 .41364 m .63575 .41369 L .63559 .41391 L F
.63593 .41364 m .63559 .41391 L .61839 .43749 L F
.70172 .34429 m .67445 .35596 L .69324 .35251 L .762 .673 .764 r
F
.67445 .35596 m .64354 .3692 L .67147 .35982 L F
.67445 .35596 m .67147 .35982 L .69324 .35251 L F
.6732 .3803 m .63447 .39354 L .64297 .40472 L .791 .686 .748 r
F
.63447 .39354 m .61252 .40104 L .62769 .40288 L F
.63447 .39354 m .62769 .40288 L .64297 .40472 L F
.61644 .38252 m .64343 .36939 L .64085 .36326 L .87 .793 .773 r
F
.63299 .38873 m .60994 .38569 L .61252 .40104 L .762 .673 .764 r
F
.60994 .38569 m .60618 .38519 L .60696 .38714 L F
.60994 .38569 m .60696 .38714 L .61252 .40104 L F
.69324 .35251 m .6422 .37167 L .63299 .38873 L F
.66057 .34728 m .66607 .35137 L .6761 .34513 L .738 .669 .783 r
F
.66057 .34728 m .67744 .34495 L .67897 .33929 L F
.64085 .36326 m .64282 .36582 L .67757 .34077 L .885 .85 .804 r
F
.64282 .36582 m .67765 .34417 L .67757 .34077 L F
.6761 .34513 m .66607 .35137 L .67744 .34495 L .738 .669 .783 r
F
.67897 .33929 m .67744 .34495 L .7156 .32339 L F
.67757 .34077 m .67765 .34417 L .67804 .34274 L .883 .899 .837 r
F
.67757 .34077 m .67804 .34274 L .71523 .32321 L F
.71513 .32366 m .71419 .32419 L .71508 .32373 L .738 .669 .783 r
F
.67804 .34274 m .71508 .32373 L .71523 .32321 L .883 .899 .837 r
F
.71185 .33446 m .70603 .35379 L .7119 .33441 L .861 .929 .87 r
F
.71974 .33657 m .70172 .34429 L .69324 .35251 L .762 .673 .764 r
F
.64297 .40472 m .61252 .40104 L .61654 .41859 L .791 .686 .748 r
F
.71996 .36432 m .6732 .3803 L .64297 .40472 L F
.63575 .41369 m .61654 .41859 L .61721 .42542 L .827 .708 .733 r
F
.63575 .41369 m .61721 .42542 L .61839 .43749 L F
.71523 .32321 m .71508 .32373 L .71518 .32357 L .861 .929 .87 r
F
.7156 .32339 m .71513 .32366 L .71974 .33657 L .738 .669 .783 r
F
.71513 .32366 m .70172 .34429 L .71974 .33657 L F
.71523 .32321 m .71518 .32357 L .71855 .32211 L .861 .929 .87 r
F
.25 g
.7313 .34631 m
.75191 .31106 L
s
.70515 .39107 m
.71594 .3726 L
s
1 0 0 r
.003 w
.70515 .39107 m
.71837 .38428 L
s
.25 g
.5 Mabswid
.77978 .31161 m
.78576 .30453 L
s
.74666 .35081 m
.77978 .31161 L
s
.71837 .38428 m
.74666 .35081 L
s
.80612 .31186 m
.80656 .31146 L
s
.73091 .38054 m
.80612 .31186 L
s
.74215 .37987 m
.82397 .31905 L
s
.69955 .42477 m .61839 .43749 L .61829 .45745 L .871 .742 .717 r
F
.25 g
.66734 .45631 m
.68055 .45601 L
s
.6509 .45669 m
.66193 .45644 L
s
.66193 .45644 m
.66734 .45631 L
s
.61829 .45745 m
.6509 .45669 L
s
.71299 .39398 m .61839 .43749 L .69955 .42477 L .827 .708 .733 r
F
0 g
.006 w
.68055 .45601 m
.69955 .42477 L
s
.25 g
.5 Mabswid
.61839 .43749 m
.67082 .42927 L
s
.67082 .42927 m
.69955 .42477 L
s
1 0 0 r
.003 w
.69484 .39861 m
.70515 .39107 L
s
.25 g
.5 Mabswid
.69236 .39924 m
.69575 .38798 L
s
.71508 .32373 m
.71523 .32321 L
s
.51666 .6241 m .52312 .62231 L .50443 .64084 L .337 .142 .462 r
F
.52312 .62231 m .588 .60439 L .52433 .63216 L F
.52312 .62231 m .52433 .63216 L .50443 .64084 L F
.51666 .6241 m .50443 .64084 L .50153 .63809 L F
.50555 .64272 m .52667 .63761 L .51104 .64581 L .444 .227 .489 r
F
.50857 .64602 m .51104 .64581 L .50925 .64675 L F
.50555 .64272 m .51104 .64581 L .50857 .64602 L F
.51182 .65668 m .50857 .64602 L .4921 .64738 L 0 0 .481 r
F
.49332 .64569 m .50555 .64272 L .47468 .66491 L .444 .227 .489 r
F
.4921 .64738 m .49277 .5941 L .47681 .64017 L 0 0 .481 r
F
.51182 .65668 m .50972 .64727 L .50857 .64602 L F
.50555 .64272 m .50925 .64675 L .47468 .66491 L .444 .227 .489 r
F
.50153 .63809 m .50443 .64084 L .49332 .64569 L .337 .142 .462 r
F
.5438 .63346 m .588 .60439 L .58388 .62375 L .444 .227 .489 r
F
.49332 .64569 m .54089 .62494 L .5438 .63346 L F
.54089 .62494 m .588 .60439 L .5438 .63346 L F
.52667 .63761 m .58388 .62375 L .52793 .64484 L F
.52667 .63761 m .52793 .64484 L .52122 .64737 L F
.52612 .6487 m .50972 .64727 L .51182 .65668 L .804 .381 0 r
F
.53012 .64979 m .58388 .62375 L .5368 .6516 L .516 .28 .496 r
F
.52122 .64737 m .52793 .64484 L .53012 .64979 L F
.52793 .64484 m .58388 .62375 L .53012 .64979 L F
.54569 .67097 m .53111 .65114 L .51182 .65668 L .804 .381 0 r
F
.53111 .65114 m .52839 .64743 L .52295 .65047 L F
.53111 .65114 m .52295 .65047 L .51182 .65668 L F
.54398 .6688 m .53248 .65513 L .53143 .65275 L F
.53111 .65114 m .53143 .65275 L .53012 .64979 L F
.54569 .67097 m .53143 .65275 L .53111 .65114 L F
.47468 .66491 m .52125 .65493 L .46198 .6817 L .516 .28 .496 r
F
.57698 .68328 m .55033 .66125 L .54569 .67097 L .892 .471 .169 r
F
.55033 .66125 m .54487 .66007 L .54569 .67097 L F
.54569 .67097 m .5435 .66836 L .54398 .6688 L .804 .381 0 r
F
.5435 .66836 m .53248 .65513 L .54398 .6688 L F
.52785 .65352 m .53143 .65275 L .52906 .65374 L .516 .28 .496 r
F
.53143 .65275 m .53161 .65369 L .52546 .65617 L F
.52415 .65579 m .52546 .65617 L .46198 .6817 L F
.53143 .65275 m .52546 .65617 L .52415 .65579 L F
.53248 .65513 m .53172 .65421 L .53193 .6539 L .804 .381 0 r
F
.55945 .66323 m .5811 .64211 L .58014 .65932 L .569 .313 .488 r
F
.54468 .65749 m .53172 .65421 L .54569 .67097 L .892 .471 .169 r
F
.54014 .65572 m .53172 .65421 L .54468 .65749 L F
.54675 .65829 m .5811 .64211 L .55945 .66323 L .569 .313 .488 r
F
.54014 .65572 m .54516 .65406 L .54675 .65829 L F
.54516 .65406 m .5811 .64211 L .54675 .65829 L F
.54675 .65829 m .54461 .65652 L .54487 .66007 L .892 .471 .169 r
F
.55033 .66125 m .54675 .65829 L .54487 .66007 L F
.54461 .65652 m .54014 .65572 L .54468 .65749 L F
.5368 .6516 m .54943 .65264 L .54014 .65572 L .516 .28 .496 r
F
.5368 .6516 m .54014 .65572 L .53477 .65476 L F
.53172 .65421 m .53161 .65369 L .53193 .6539 L .804 .381 0 r
F
.52122 .64737 m .50972 .64727 L .52612 .6487 L F
.47468 .66491 m .52122 .64737 L .53012 .64979 L .516 .28 .496 r
F
.53143 .65275 m .53012 .64979 L .5368 .6516 L F
.47468 .66491 m .53012 .64979 L .53143 .65275 L F
.53088 .65321 m .529 .65096 L .53193 .6539 L .804 .381 0 r
F
.53193 .6539 m .529 .65096 L .53012 .64979 L F
.5368 .6516 m .53251 .65826 L .53161 .65369 L .516 .28 .496 r
F
.53161 .65369 m .53251 .65826 L .46198 .6817 L F
.53172 .65421 m .53088 .65321 L .53161 .65369 L .804 .381 0 r
F
.53143 .65275 m .5368 .6516 L .53161 .65369 L .516 .28 .496 r
F
.54554 .65232 m .5811 .64211 L .54943 .65264 L F
.5368 .6516 m .54615 .6496 L .54554 .65232 L F
.54615 .6496 m .5811 .64211 L .54554 .65232 L F
.53012 .64979 m .529 .65096 L .52839 .64743 L .804 .381 0 r
F
.52839 .64743 m .52122 .64737 L .52612 .6487 L F
.529 .65096 m .52621 .64761 L .52839 .64743 L F
.54461 .65652 m .52687 .6484 L .53172 .65421 L .892 .471 .169 r
F
.5368 .6516 m .58388 .62375 L .5811 .64211 L .516 .28 .496 r
F
.52667 .63761 m .52122 .64737 L .5083 .64725 L .444 .227 .489 r
F
.52839 .64743 m .50163 .61102 L .50972 .64727 L .804 .381 0 r
F
.52839 .64743 m .52621 .64761 L .52575 .64384 L F
.52575 .64384 m .50936 .6274 L .50163 .61102 L F
.52621 .64761 m .50936 .6274 L .52575 .64384 L F
.54461 .65652 m .51559 .64324 L .50936 .6274 L .892 .471 .169 r
F
.54675 .65829 m .54446 .65719 L .54461 .65652 L F
.54446 .65719 m .51559 .64324 L .54461 .65652 L F
.57698 .68328 m .55621 .66973 L .55448 .66469 L F
.54932 .66515 m .5493 .66523 L .5492 .66519 L .569 .313 .488 r
F
.54916 .66518 m .54932 .66515 L .5492 .66519 L F
.54916 .66518 m .54014 .65572 L .54675 .65829 L F
.54937 .66527 m .54775 .66098 L .55448 .66469 L .892 .471 .169 r
F
.55033 .66125 m .54775 .66098 L .54675 .65829 L F
.55448 .66469 m .55007 .66225 L .55033 .66125 L F
.55007 .66225 m .54775 .66098 L .55033 .66125 L F
.54932 .66515 m .54675 .65829 L .55945 .66323 L .569 .313 .488 r
F
.54916 .66518 m .54675 .65829 L .54932 .66515 L F
.55621 .66973 m .54937 .66527 L .55448 .66469 L .892 .471 .169 r
F
.53256 .65824 m .54014 .65572 L .54916 .66518 L .569 .313 .488 r
F
.53477 .65476 m .54014 .65572 L .53251 .65826 L .516 .28 .496 r
F
.54937 .66527 m .51559 .64324 L .54775 .66098 L .892 .471 .169 r
F
.54964 .66538 m .54937 .66527 L .57698 .68328 L .857 .466 .303 r
F
.60427 .69386 m .56962 .67408 L .57698 .68328 L F
.56962 .67408 m .56436 .67237 L .57698 .68328 L F
.56467 .67126 m .58014 .65932 L .57591 .67613 L .611 .332 .469 r
F
.5546 .66689 m .56245 .66456 L .56467 .67126 L F
.56245 .66456 m .58014 .65932 L .56467 .67126 L F
.55997 .66858 m .55636 .66744 L .557 .66793 L .857 .466 .303 r
F
.56147 .66987 m .557 .66793 L .57698 .68328 L F
.55997 .66858 m .557 .66793 L .56147 .66987 L F
.54932 .66515 m .55945 .66323 L .55126 .66584 L .569 .313 .488 r
F
.54932 .66515 m .55126 .66584 L .5493 .66523 L F
.55166 .66383 m .54372 .66151 L .54949 .66529 L .857 .466 .303 r
F
.55636 .66744 m .54949 .66529 L .57698 .68328 L F
.55945 .66323 m .56376 .66417 L .5546 .66689 L .569 .313 .488 r
F
.55945 .66323 m .5546 .66689 L .55126 .66584 L F
.55166 .66383 m .54949 .66529 L .55636 .66744 L .857 .466 .303 r
F
.55126 .66584 m .5546 .66689 L .4563 .69604 L .569 .313 .488 r
F
.60427 .69386 m .56697 .67823 L .56678 .67765 L .857 .466 .303 r
F
.56962 .67408 m .55997 .66858 L .56436 .67237 L F
.56962 .67408 m .56678 .67765 L .56467 .67126 L F
.60427 .69386 m .56678 .67765 L .56962 .67408 L F
.64147 .71119 m .63862 .71029 L .62619 .70306 L .749 .395 .382 r
F
.4585 .70798 m .55896 .6812 L .58308 .69001 L .645 .337 .435 r
F
.4563 .69604 m .55564 .6795 L .4585 .70798 L .611 .332 .469 r
F
.55564 .6795 m .56592 .67779 L .55713 .68026 L F
.55564 .6795 m .55713 .68026 L .4585 .70798 L F
.46914 .71765 m .58523 .6897 L .59185 .70266 L .672 .327 .381 r
F
.64901 .71864 m .59654 .70574 L .64147 .71119 L .696 .347 .381 r
F
.4585 .70798 m .57235 .69155 L .46914 .71765 L .645 .337 .435 r
F
.57235 .69155 m .57362 .6923 L .46914 .71765 L F
.58308 .69001 m .58335 .69015 L .46914 .71765 L F
.56592 .67779 m .56606 .67785 L .4585 .70798 L .611 .332 .469 r
F
.56606 .67785 m .56581 .67887 L .4585 .70798 L F
.56678 .67765 m .56648 .67803 L .56606 .67785 L F
.56648 .67803 m .56581 .67887 L .56606 .67785 L F
.56592 .67779 m .5546 .66689 L .57591 .67613 L F
.4563 .69604 m .546 .66944 L .56592 .67779 L F
.546 .66944 m .5546 .66689 L .56592 .67779 L F
.56424 .67709 m .55668 .67392 L .56648 .67803 L .803 .436 .361 r
F
.5727 .68064 m .56648 .67803 L .60427 .69386 L F
.56592 .67779 m .56678 .67765 L .56606 .67785 L .611 .332 .469 r
F
.5492 .66519 m .54896 .66657 L .54338 .66834 L .569 .313 .488 r
F
.54176 .66766 m .54338 .66834 L .4563 .69604 L F
.5492 .66519 m .54338 .66834 L .54176 .66766 L F
.46198 .6817 m .54916 .66518 L .4563 .69604 L F
.54916 .66518 m .5492 .66519 L .4563 .69604 L F
.46198 .6817 m .53256 .65824 L .54916 .66518 L F
.56697 .67823 m .51996 .65853 L .56467 .67126 L .857 .466 .303 r
F
.56678 .67765 m .57591 .67613 L .56581 .67887 L .611 .332 .469 r
F
.57591 .67613 m .57684 .67643 L .4585 .70798 L F
.56424 .67709 m .56648 .67803 L .5727 .68064 L .803 .436 .361 r
F
.48839 .72523 m .59185 .70266 L .60133 .71407 L .687 .294 .296 r
F
.46914 .71765 m .59185 .70266 L .48839 .72523 L .672 .327 .381 r
F
.59654 .70574 m .52197 .68742 L .58754 .70046 L .696 .347 .381 r
F
.59654 .70574 m .58754 .70046 L .64147 .71119 L F
.57235 .69155 m .58308 .69001 L .57362 .6923 L .645 .337 .435 r
F
.58308 .69001 m .58523 .6897 L .58335 .69015 L F
.63862 .71029 m .5964 .69686 L .592 .69326 L .749 .395 .382 r
F
.5964 .69686 m .57858 .6912 L .5883 .69269 L F
.5964 .69686 m .5883 .69269 L .592 .69326 L F
.57858 .6912 m .52218 .67327 L .57061 .68714 L F
.57858 .6912 m .57061 .68714 L .592 .69326 L F
.63862 .71029 m .592 .69326 L .62619 .70306 L F
.58308 .69001 m .56818 .67874 L .58523 .6897 L .645 .337 .435 r
F
.55896 .6812 m .56818 .67874 L .58308 .69001 L F
.59067 .68817 m .58166 .68439 L .60427 .69386 L .803 .436 .361 r
F
.57656 .68226 m .5727 .68064 L .60427 .69386 L F
.56818 .67874 m .5814 .67522 L .58409 .68541 L .645 .337 .435 r
F
.56818 .67874 m .58409 .68541 L .58523 .6897 L F
.62619 .70306 m .59067 .68817 L .60427 .69386 L .803 .436 .361 r
F
.59067 .68817 m .57656 .68226 L .58166 .68439 L F
.57656 .68226 m .56424 .67709 L .5727 .68064 L F
.55997 .66858 m .55166 .66383 L .55636 .66744 L .857 .466 .303 r
F
.54949 .66529 m .54937 .66527 L .54964 .66538 L F
.54931 .66523 m .54937 .66527 L .54949 .66529 L F
.54931 .66523 m .5493 .66523 L .54937 .66527 L F
.5493 .66523 m .55126 .66584 L .54896 .66657 L .569 .313 .488 r
F
.5493 .66523 m .54896 .66657 L .5492 .66519 L F
.54372 .66151 m .54931 .66523 L .54949 .66529 L .857 .466 .303 r
F
.54372 .66151 m .5435 .66144 L .5493 .66523 L F
.54372 .66151 m .5493 .66523 L .54931 .66523 L F
.51728 .64421 m .5178 .64468 L .5435 .66144 L F
.51728 .64421 m .5435 .66144 L .54372 .66151 L F
.52125 .65493 m .52785 .65352 L .52415 .65579 L .516 .28 .496 r
F
.52785 .65352 m .52906 .65374 L .52415 .65579 L F
.52125 .65493 m .52415 .65579 L .46198 .6817 L F
.55166 .66383 m .51728 .64421 L .54372 .66151 L .857 .466 .303 r
F
.51728 .64421 m .51559 .64324 L .5178 .64468 L F
.5083 .64725 m .52122 .64737 L .47468 .66491 L .444 .227 .489 r
F
.56467 .67126 m .51996 .65853 L .51559 .64324 L .857 .466 .303 r
F
.57591 .67613 m .58014 .65932 L .5814 .67522 L .611 .332 .469 r
F
.57591 .67613 m .5814 .67522 L .57684 .67643 L F
.56424 .67709 m .51996 .65853 L .55668 .67392 L .803 .436 .361 r
F
.54775 .66098 m .51559 .64324 L .54675 .65829 L .892 .471 .169 r
F
.55945 .66323 m .58014 .65932 L .56376 .66417 L .569 .313 .488 r
F
.50857 .64602 m .49277 .5941 L .4921 .64738 L 0 0 .481 r
F
.50857 .64602 m .50931 .64545 L .50803 .64424 L F
.50972 .64727 m .50931 .64545 L .50857 .64602 L F
.50803 .64424 m .50163 .61102 L .49277 .5941 L F
.50931 .64545 m .50163 .61102 L .50803 .64424 L F
0 g
.006 w
.52256 .61883 m
.54339 .60026 L
s
.51666 .6241 m .59301 .58422 L .588 .60439 L .337 .142 .462 r
F
.25 g
.5 Mabswid
.58168 .63829 m
.66722 .60235 L
s
.58813 .60388 m
.6569 .58337 L
s
0 g
.006 w
.51666 .6241 m
.52256 .61883 L
s
.25 g
.5 Mabswid
.51666 .6241 m
.52138 .62163 L
s
.52138 .62163 m
.52259 .621 L
s
.52259 .621 m
.58909 .58627 L
s
.58909 .58627 m
.59301 .58422 L
s
0 g
.006 w
.52967 .55313 m
.53582 .57971 L
s
.53582 .57971 m
.53704 .58497 L
s
.25 g
.5 Mabswid
.59585 .56517 m
.59846 .56342 L
s
.54958 .59613 m
.59585 .56517 L
s
0 g
.006 w
.51343 .62708 m
.51666 .6241 L
s
.77344 .74267 m .73917 .69237 L .72872 .67974 L 0 0 .521 r
F
.25 g
.5 Mabswid
.72872 .67974 m
.73772 .73328 L
s
.80687 .7495 m .73917 .69237 L .77344 .74267 L .705 .186 0 r
F
0 g
.006 w
.73772 .73328 m
.77344 .74267 L
s
.25 g
.5 Mabswid
.59315 .54741 m
.59933 .54685 L
s
.6028 .54654 m
.64937 .54233 L
s
.52967 .55313 m
.58861 .54782 L
s
.58861 .54782 m
.59315 .54741 L
s
0 g
.006 w
.52967 .55313 m
.53008 .51987 L
s
.25 g
.5 Mabswid
.63093 .49977 m
.6451 .50189 L
s
.53845 .48597 m
.6136 .49719 L
s
1 0 0 r
.003 w
.6451 .50189 m
.64667 .48482 L
s
.64667 .48482 m
.64693 .48194 L
s
.6451 .50189 m
.64596 .52213 L
s
.25 g
.5 Mabswid
.64293 .48066 m
.64693 .48194 L
s
.55456 .45234 m
.61699 .47235 L
s
1 0 0 r
.003 w
.64693 .48194 m
.64829 .4762 L
s
.25 g
.5 Mabswid
.60701 .38997 m
.60888 .39195 L
s
.57776 .41999 m
.583 .42303 L
s
.583 .42303 m
.61836 .4435 L
s
.62001 .52162 m
.64596 .52213 L
s
.61788 .52158 m
.62001 .52162 L
s
.53008 .51987 m
.60819 .52139 L
s
.60819 .52139 m
.60879 .5214 L
s
1 0 0 r
.003 w
.64596 .52213 m
.64937 .54233 L
s
.64937 .54233 m
.65509 .56224 L
s
.65509 .56224 m
.66278 .58161 L
s
0 g
.006 w
.81517 .3036 m
.83888 .30797 L
s
1 0 0 r
.003 w
.66278 .58161 m
.67209 .6003 L
s
.397 .634 m .36822 .62555 L .36741 .6643 L .994 .871 .549 r
F
.397 .634 m .37265 .60327 L .36822 .62555 L F
.40908 .59989 m .41807 .59007 L .37912 .57603 L .42 .385 .714 r
F
.41974 .60679 m .41988 .60625 L .40908 .59989 L .276 .299 .705 r
F
.42589 .57924 m .42351 .58851 L .42397 .6019 L .914 .745 .658 r
F
.4265 .572 m .4245 .58303 L .42589 .57924 L F
.4245 .58303 m .42351 .58851 L .42589 .57924 L F
.44703 .56847 m .4265 .572 L .42397 .6019 L F
.41807 .59007 m .41552 .58165 L .37912 .57603 L .42 .385 .714 r
F
.42868 .57163 m .42597 .57094 L .4265 .572 L .914 .745 .658 r
F
.44703 .56847 m .42804 .56574 L .42868 .57163 L F
.42804 .56574 m .42306 .56503 L .42868 .57163 L F
.42271 .57232 m .41995 .55873 L .37912 .57603 L .42 .385 .714 r
F
.4265 .572 m .42306 .56503 L .42271 .57232 L F
.42306 .56503 m .41995 .55873 L .42271 .57232 L F
.46497 .53427 m .42879 .54413 L .44703 .56847 L .862 .694 .673 r
F
.41906 .54712 m .42879 .54413 L .42833 .5404 L .511 .443 .716 r
F
.37912 .57603 m .41929 .55022 L .41906 .54712 L F
.41929 .55022 m .42879 .54413 L .41906 .54712 L F
.42306 .56503 m .4204 .56464 L .42597 .57094 L .914 .745 .658 r
F
.41929 .55022 m .42342 .55725 L .42879 .54413 L .511 .443 .716 r
F
.37912 .57603 m .41995 .55873 L .41929 .55022 L F
.41995 .55873 m .42342 .55725 L .41929 .55022 L F
.4245 .58303 m .4265 .572 L .37912 .57603 L .42 .385 .714 r
F
.37912 .57603 m .42833 .5404 L .3535 .54979 L .511 .443 .716 r
F
.46497 .53427 m .42769 .53511 L .42833 .5404 L .862 .694 .673 r
F
.42478 .54085 m .42172 .53057 L .3535 .54979 L .511 .443 .716 r
F
.42833 .5404 m .42482 .53518 L .42478 .54085 L F
.42482 .53518 m .42172 .53057 L .42478 .54085 L F
.47674 .49993 m .43113 .51634 L .46497 .53427 L .817 .657 .684 r
F
.42769 .53511 m .42224 .53523 L .42879 .54413 L .862 .694 .673 r
F
.3535 .54979 m .42062 .52086 L .42004 .5158 L .576 .488 .719 r
F
.42062 .52086 m .42485 .52969 L .43113 .51634 L F
.3535 .54979 m .42172 .53057 L .42062 .52086 L F
.42172 .53057 m .42485 .52969 L .42062 .52086 L F
.3535 .54979 m .43029 .51056 L .3334 .52138 L F
.47674 .49993 m .42973 .50668 L .43029 .51056 L .817 .657 .684 r
F
.42713 .51092 m .42562 .50564 L .3334 .52138 L .576 .488 .719 r
F
.43029 .51056 m .42698 .50707 L .42713 .51092 L F
.42698 .50707 m .42562 .50564 L .42713 .51092 L F
.48148 .4662 m .43819 .48554 L .47674 .49993 L .778 .629 .695 r
F
.43819 .48554 m .43437 .49228 L .47674 .49993 L F
.3334 .52138 m .42692 .50542 L .43819 .48554 L .625 .528 .723 r
F
.48148 .4662 m .43662 .47728 L .43783 .48368 L .778 .629 .695 r
F
.43964 .48489 m .43783 .48368 L .43819 .48554 L F
.48148 .4662 m .43783 .48368 L .43964 .48489 L F
.31375 .45966 m .4376 .46292 L .43661 .44362 L .7 .6 .741 r
F
.47855 .43387 m .42874 .46095 L .48148 .4662 L .744 .608 .707 r
F
.3334 .52138 m .43125 .48606 L .31987 .49117 L .625 .528 .723 r
F
.43125 .48606 m .43106 .48411 L .31987 .49117 L F
.43783 .48368 m .43651 .48279 L .31987 .49117 L F
.31987 .49117 m .4376 .46292 L .31375 .45966 L .666 .564 .731 r
F
.43125 .48606 m .43783 .48368 L .43106 .48411 L .625 .528 .723 r
F
.3334 .52138 m .43819 .48554 L .43783 .48368 L F
.43662 .47728 m .43503 .47768 L .43819 .48554 L .778 .629 .695 r
F
.31987 .49117 m .43097 .48319 L .43397 .47402 L .666 .564 .731 r
F
.43503 .47768 m .43733 .48565 L .43819 .48554 L .778 .629 .695 r
F
.44607 .46268 m .43503 .47768 L .48148 .4662 L .744 .608 .707 r
F
.43097 .48319 m .44124 .48245 L .43928 .4719 L .666 .564 .731 r
F
.43097 .48319 m .43928 .4719 L .4376 .46292 L F
.43503 .47768 m .36717 .49444 L .43733 .48565 L .778 .629 .695 r
F
.43121 .46445 m .43397 .47402 L .4376 .46292 L .666 .564 .731 r
F
.31987 .49117 m .43397 .47402 L .43121 .46445 L F
.42874 .46095 m .43053 .47879 L .43503 .47768 L .744 .608 .707 r
F
.42874 .46095 m .43503 .47768 L .44607 .46268 L F
.42874 .46095 m .36717 .49444 L .43053 .47879 L F
.43783 .48368 m .44124 .48245 L .43651 .48279 L .625 .528 .723 r
F
.43783 .48368 m .43819 .48554 L .43961 .48304 L F
.43819 .48554 m .36717 .49444 L .37252 .51489 L .778 .629 .695 r
F
.42635 .49083 m .42698 .50707 L .47674 .49993 L F
.43961 .48304 m .44712 .50197 L .44124 .48245 L .625 .528 .723 r
F
.42692 .50542 m .44712 .50197 L .43961 .48304 L F
.43819 .48554 m .42635 .49083 L .43437 .49228 L .778 .629 .695 r
F
.42004 .5158 m .43113 .51634 L .43029 .51056 L .576 .488 .719 r
F
.42062 .52086 m .43113 .51634 L .42004 .5158 L F
.43029 .51056 m .37252 .51489 L .43113 .51634 L .817 .657 .684 r
F
.42973 .50668 m .42698 .50707 L .43029 .51056 L F
.42698 .50707 m .37252 .51489 L .43029 .51056 L F
.43029 .51056 m .44712 .50197 L .42562 .50564 L .576 .488 .719 r
F
.42635 .49083 m .37252 .51489 L .42698 .50707 L .778 .629 .695 r
F
.43459 .51509 m .43029 .51056 L .43113 .51634 L .817 .657 .684 r
F
.47674 .49993 m .43029 .51056 L .43459 .51509 L F
.42342 .54559 m .37563 .53629 L .37659 .55835 L .862 .694 .673 r
F
.42879 .54413 m .42316 .5433 L .42342 .54559 L F
.42316 .5433 m .37563 .53629 L .42342 .54559 L F
.42224 .53523 m .37563 .53629 L .42316 .5433 L F
.42224 .53523 m .42316 .5433 L .42879 .54413 L F
.43113 .51634 m .37252 .51489 L .37563 .53629 L .817 .657 .684 r
F
.43029 .51056 m .43113 .51634 L .43497 .50818 L .576 .488 .719 r
F
.43497 .50818 m .45478 .52126 L .44712 .50197 L F
.43113 .51634 m .42928 .52027 L .46497 .53427 L .817 .657 .684 r
F
.42492 .51857 m .42482 .53518 L .46497 .53427 L F
.42485 .52969 m .45478 .52126 L .43497 .50818 L .576 .488 .719 r
F
.43113 .51634 m .42492 .51857 L .42928 .52027 L .817 .657 .684 r
F
.42833 .5404 m .45478 .52126 L .42172 .53057 L .511 .443 .716 r
F
.42492 .51857 m .37563 .53629 L .42482 .53518 L .817 .657 .684 r
F
.43052 .54365 m .42833 .5404 L .42879 .54413 L .862 .694 .673 r
F
.46497 .53427 m .42833 .5404 L .43052 .54365 L F
.42104 .57294 m .37659 .55835 L .37553 .58078 L .914 .745 .658 r
F
.4265 .572 m .42085 .57046 L .42104 .57294 L F
.42085 .57046 m .37659 .55835 L .42104 .57294 L F
.4204 .56464 m .37659 .55835 L .42078 .56962 L F
.4204 .56464 m .42078 .56962 L .42597 .57094 L F
.42833 .5404 m .42879 .54413 L .43114 .53837 L .511 .443 .716 r
F
.43114 .53837 m .46368 .54019 L .45478 .52126 L F
.42879 .54413 m .42701 .54847 L .44703 .56847 L .862 .694 .673 r
F
.42398 .54544 m .42306 .56503 L .44703 .56847 L F
.42342 .55725 m .46368 .54019 L .43114 .53837 L .511 .443 .716 r
F
.42879 .54413 m .42398 .54544 L .42701 .54847 L .862 .694 .673 r
F
.42306 .56503 m .42597 .57094 L .42868 .57163 L .914 .745 .658 r
F
.4265 .572 m .42965 .55461 L .41995 .55873 L .42 .385 .714 r
F
.42398 .54544 m .37659 .55835 L .42306 .56503 L .862 .694 .673 r
F
.4265 .572 m .46368 .54019 L .42965 .55461 L .42 .385 .714 r
F
.4245 .58303 m .42933 .57775 L .4265 .572 L F
.42933 .57775 m .46368 .54019 L .4265 .572 L F
.42597 .57094 m .37659 .55835 L .4265 .572 L .914 .745 .658 r
F
.42933 .57775 m .47333 .55867 L .46368 .54019 L .42 .385 .714 r
F
.4245 .58303 m .42963 .58048 L .42933 .57775 L F
.42963 .58048 m .47333 .55867 L .42933 .57775 L F
.40908 .59989 m .41824 .59402 L .41807 .59007 L F
.41988 .60625 m .42042 .60035 L .40908 .59989 L .276 .299 .705 r
F
.42042 .60035 m .42117 .59214 L .41824 .59402 L F
.42042 .60035 m .41824 .59402 L .40908 .59989 L F
.42129 .60073 m .42042 .60035 L .42167 .60196 L .97 .809 .628 r
F
.41988 .60625 m .42098 .60198 L .42042 .60035 L .276 .299 .705 r
F
.42042 .60035 m .37553 .58078 L .42084 .60158 L .97 .809 .628 r
F
.42042 .60035 m .42084 .60158 L .42167 .60196 L F
.41858 .60204 m .37553 .58078 L .37265 .60327 L F
.42098 .60198 m .41853 .60084 L .41858 .60204 L F
.41853 .60084 m .37553 .58078 L .41858 .60204 L F
.41807 .59007 m .42117 .59214 L .4245 .58303 L .42 .385 .714 r
F
.41824 .59402 m .42117 .59214 L .41807 .59007 L F
.41807 .59007 m .4245 .58303 L .41552 .58165 L F
.4265 .572 m .42296 .57261 L .42351 .58851 L .914 .745 .658 r
F
.42296 .57261 m .42042 .60035 L .42397 .6019 L F
.42117 .59214 m .47333 .55867 L .4245 .58303 L .42 .385 .714 r
F
.42042 .60035 m .42399 .59033 L .42117 .59214 L .276 .299 .705 r
F
.42167 .60196 m .42084 .60158 L .42098 .60198 L .97 .809 .628 r
F
.42397 .6019 m .42129 .60073 L .42167 .60196 L F
.42098 .60198 m .42399 .59033 L .42042 .60035 L .276 .299 .705 r
F
.42084 .60158 m .37553 .58078 L .42098 .60198 L .97 .809 .628 r
F
.42296 .57261 m .37553 .58078 L .42042 .60035 L .914 .745 .658 r
F
.4421 .62127 m .47333 .55867 L .42399 .59033 L .276 .299 .705 r
F
.42397 .6019 m .42098 .60198 L .41968 .60701 L .97 .809 .628 r
F
.4421 .62127 m .42399 .59033 L .41974 .60679 L .276 .299 .705 r
F
.41968 .60701 m .37265 .60327 L .397 .634 L .97 .809 .628 r
F
.42098 .60198 m .37265 .60327 L .41968 .60701 L F
.25 g
.5 Mabswid
.37265 .60327 m
.397 .634 L
s
0 g
.006 w
.397 .634 m
.41968 .60701 L
s
.41968 .60701 m
.41982 .60684 L
s
.25 g
.5 Mabswid
.42117 .59214 m
.43026 .5863 L
s
0 g
.006 w
.41974 .60679 m
.41982 .60684 L
s
.25 g
.5 Mabswid
.37553 .58078 m
.41847 .5995 L
s
.41847 .5995 m
.42042 .60035 L
s
.4421 .62127 m .48318 .57665 L .47333 .55867 L .276 .299 .705 r
F
.47681 .64017 m .48318 .57665 L .4421 .62127 L .021 .15 .66 r
F
.25 g
.43026 .5863 m
.47333 .55867 L
s
0 g
.006 w
.41982 .60684 m
.4421 .62127 L
s
.25 g
.5 Mabswid
.4421 .62127 m
.44464 .61852 L
s
.71996 .36432 m .61654 .41859 L .71299 .39398 L .791 .686 .748 r
F
.25 g
.70288 .39656 m
.71299 .39398 L
s
.61654 .41859 m
.63575 .41369 L
s
.63575 .41369 m
.63593 .41364 L
s
0 g
.006 w
.69955 .42477 m
.71299 .39398 L
s
.25 g
.5 Mabswid
.71942 .36665 m
.7313 .34631 L
s
.36741 .6643 m .36272 .64788 L .33655 .69239 L .844 .817 .335 r
F
.36272 .64788 m .36099 .65003 L .33655 .69239 L F
.36272 .64788 m .36255 .64732 L .36099 .65003 L F
.33655 .69239 m .36255 .64732 L .35608 .6683 L 0 0 0 r
F
.33655 .69239 m .35608 .6683 L .30584 .71796 L F
.3073 .71696 m .35608 .6683 L .34927 .68821 L 0 0 .216 r
F
.30584 .71796 m .30902 .71481 L .3073 .71696 L F
.30902 .71481 m .35608 .6683 L .3073 .71696 L F
.36741 .6643 m .36822 .62555 L .36255 .64732 L .844 .817 .335 r
F
0 g
.006 w
.36741 .6643 m
.397 .634 L
s
.25 g
.5 Mabswid
.36741 .6643 m
.36822 .62555 L
s
0 g
.006 w
.35295 .67746 m
.36741 .6643 L
s
1 0 0 r
.003 w
.67209 .6003 m
.68261 .61817 L
s
.25 g
.5 Mabswid
.43005 .55444 m
.46368 .54019 L
s
.42965 .55461 m
.43005 .55444 L
s
.42342 .55725 m
.42965 .55461 L
s
0 g
.006 w
.3535 .54979 m
.37591 .57274 L
s
.25 g
.5 Mabswid
.37659 .55835 m
.4204 .56464 L
s
.4204 .56464 m
.42306 .56503 L
s
0 g
.006 w
.46282 .53836 m
.46497 .53427 L
s
.47681 .64017 m .49277 .5941 L .48318 .57665 L .021 .15 .66 r
F
.25 g
.5 Mabswid
.47681 .64017 m
.49198 .59637 L
s
.49198 .59637 m
.49277 .5941 L
s
0 g
.006 w
.4421 .62127 m
.47681 .64017 L
s
.25 g
.5 Mabswid
.44464 .61852 m
.48098 .57904 L
s
.48098 .57904 m
.48318 .57665 L
s
0 g
.006 w
.47681 .64017 m
.4921 .64738 L
s
.53008 .51987 m
.53845 .48597 L
s
1 0 0 r
.003 w
.68261 .61817 m
.69395 .63511 L
s
.25 g
.5 Mabswid
.58275 .60668 m
.588 .60439 L
s
.54089 .62494 m
.58275 .60668 L
s
.52433 .63216 m
.54089 .62494 L
s
.51891 .63453 m
.52433 .63216 L
s
0 g
.006 w
.47468 .66491 m
.49164 .64742 L
s
.49164 .64742 m
.49181 .64724 L
s
.25 g
.5 Mabswid
.36099 .65003 m
.36255 .64732 L
s
.34298 .68125 m
.36099 .65003 L
s
.44796 .52318 m
.45478 .52126 L
s
.43241 .52756 m
.44796 .52318 L
s
.42485 .52969 m
.43241 .52756 L
s
.3535 .54979 m
.37594 .54347 L
s
0 g
.006 w
.3334 .52138 m
.3535 .54979 L
s
.75655 .71439 m .75576 .714 L .74833 .7038 L .752 .238 0 r
F
.7563 .71422 m .75576 .714 L .75655 .71439 L .721 .228 .069 r
F
.7563 .71422 m .76104 .72297 L .75576 .714 L F
.80448 .74749 m .74897 .7043 L .74181 .69459 L .705 .186 0 r
F
.80492 .74786 m .80434 .74741 L .80448 .74749 L F
.80434 .74741 m .74897 .7043 L .80448 .74749 L F
.80354 .7469 m .74833 .7038 L .80492 .74786 L F
.74897 .7043 m .74833 .7038 L .74181 .69459 L F
.80687 .7495 m .80354 .7469 L .80492 .74786 L F
.8366 .75405 m .74833 .7038 L .80687 .7495 L .752 .238 0 r
F
.8366 .75405 m .75655 .71439 L .74833 .7038 L F
.8613 .75664 m .7563 .71422 L .8366 .75405 L .721 .228 .069 r
F
.7563 .71422 m .75655 .71439 L .8366 .75405 L F
.8613 .75664 m .76332 .72373 L .7563 .71422 L F
.76332 .72373 m .76104 .72297 L .7563 .71422 L F
.87969 .75758 m .76297 .72353 L .8613 .75664 L .667 .185 .097 r
F
.76297 .72353 m .76104 .72297 L .76332 .72373 L F
.76297 .72353 m .76332 .72373 L .8613 .75664 L F
.74181 .69459 m .74833 .7038 L .74003 .69309 L .705 .186 0 r
F
.74003 .69309 m .74833 .7038 L .73917 .69237 L F
.25 g
.5 Mabswid
.80374 .74706 m
.80687 .7495 L
s
.80354 .7469 m
.80374 .74706 L
s
.78182 .72994 m
.80354 .7469 L
s
0 g
.006 w
.77344 .74267 m
.80687 .7495 L
s
.25 g
.5 Mabswid
.73917 .69237 m
.73939 .69269 L
s
.77235 .74107 m
.77344 .74267 L
s
.77157 .73992 m
.77235 .74107 L
s
.73939 .69269 m
.74011 .69375 L
s
.77147 .73978 m
.77157 .73992 L
s
.74011 .69375 m
.77147 .73978 L
s
0 g
.006 w
.80687 .7495 m
.8366 .75405 L
s
1 0 0 r
.003 w
.69395 .63511 m
.70569 .65107 L
s
.25 g
.5 Mabswid
.37563 .53629 m
.42224 .53523 L
s
.42224 .53523 m
.42482 .53518 L
s
.46094 .53436 m
.46497 .53427 L
s
0 g
.006 w
.46497 .53427 m
.47674 .49993 L
s
.78576 .30453 m
.81517 .3036 L
s
.25 g
.5 Mabswid
.50163 .61102 m
.50931 .64545 L
s
.50931 .64545 m
.50972 .64727 L
s
0 g
.006 w
.53845 .48597 m
.55456 .45234 L
s
.71974 .33657 m .61252 .40104 L .71996 .36432 L .762 .673 .764 r
F
.25 g
.5 Mabswid
.71397 .36637 m
.71996 .36432 L
s
.71239 .36691 m
.71397 .36637 L
s
.61252 .40104 m
.63447 .39354 L
s
.63447 .39354 m
.67337 .38025 L
s
.67337 .38025 m
.71239 .36691 L
s
0 g
.006 w
.71299 .39398 m
.71996 .36432 L
s
.25 g
.5 Mabswid
.64295 .36824 m
.64343 .36939 L
s
.63593 .41364 m
.70288 .39656 L
s
0 g
.006 w
.71979 .34327 m
.71996 .36432 L
s
.71977 .34055 m
.71979 .34327 L
s
.71974 .33657 m
.71977 .34055 L
s
1 0 0 r
.003 w
.70569 .65107 m
.71742 .66596 L
s
.25 g
.5 Mabswid
.44148 .50293 m
.44712 .50197 L
s
.43519 .504 m
.44148 .50293 L
s
.42692 .50542 m
.43519 .504 L
s
.3334 .52138 m
.37247 .51471 L
s
0 g
.006 w
.31987 .49117 m
.3334 .52138 L
s
.30584 .71796 m .34927 .68821 L .27669 .74073 L 0 0 .216 r
F
.25 g
.5 Mabswid
.30584 .71796 m
.30902 .71481 L
s
.37252 .51489 m
.42589 .50723 L
s
.42589 .50723 m
.42698 .50707 L
s
.44796 .50406 m
.47674 .49993 L
s
0 g
.006 w
.47674 .49993 m
.48148 .4662 L
s
.25 g
.5 Mabswid
.47468 .66491 m
.48171 .66226 L
s
.48171 .66226 m
.51146 .65105 L
s
.51146 .65105 m
.5172 .64888 L
s
.57737 .62621 m
.58388 .62375 L
s
.54241 .63938 m
.57737 .62621 L
s
.52967 .64418 m
.54241 .63938 L
s
0 g
.006 w
.46198 .6817 m
.47468 .66491 L
s
1 0 0 r
.003 w
.71742 .66596 m
.72872 .67974 L
s
0 g
.006 w
.75191 .31106 m
.78576 .30453 L
s
.55456 .45234 m
.57776 .41999 L
s
.25 g
.5 Mabswid
.83206 .75181 m
.8366 .75405 L
s
.80082 .73632 m
.83206 .75181 L
s
0 g
.006 w
.8366 .75405 m
.8613 .75664 L
s
1 0 0 r
.003 w
.60897 .52077 m
.61328 .49934 L
s
.61328 .49934 m
.61649 .47815 L
s
.61649 .47815 m
.61829 .45745 L
s
.25 g
.5 Mabswid
.4396 .48257 m
.44124 .48245 L
s
.43651 .48279 m
.4396 .48257 L
s
.31987 .49117 m
.38128 .48676 L
s
1 0 0 r
.003 w
.60391 .5422 m
.60897 .52077 L
s
.61829 .45745 m
.61839 .43749 L
s
.59846 .56342 m
.60391 .5422 L
s
.25 g
.5 Mabswid
.70172 .34429 m
.71974 .33657 L
s
.67445 .35596 m
.70172 .34429 L
s
.64603 .36813 m
.67445 .35596 L
s
.64354 .3692 m
.64603 .36813 L
s
0 g
.006 w
.7156 .32339 m
.71974 .33657 L
s
.7155 .32309 m
.71551 .32312 L
s
.71509 .3218 m
.7155 .32309 L
s
1 0 0 r
.003 w
.61654 .41859 m
.61839 .43749 L
s
.72872 .67974 m
.73917 .69237 L
s
.27669 .74073 m .34268 .70679 L .25054 .76049 L .205 0 .316 r
F
.27669 .74073 m .34927 .68821 L .34268 .70679 L F
.25 g
.5 Mabswid
.35282 .67153 m
.35608 .6683 L
s
0 g
.006 w
.27669 .74073 m
.30584 .71796 L
s
.25 g
.5 Mabswid
.27669 .74073 m
.28143 .7373 L
s
.43053 .47879 m
.43503 .47768 L
s
.44012 .47642 m
.44946 .47411 L
s
.44946 .47411 m
.48148 .4662 L
s
0 g
.006 w
.57776 .41999 m
.60701 .38997 L
s
.71523 .32321 m
.71855 .32211 L
s
.71855 .32211 m
.75191 .31106 L
s
1 0 0 r
.003 w
.59301 .58422 m
.59846 .56342 L
s
.61252 .40104 m
.61654 .41859 L
s
.60696 .38714 m
.61252 .40104 L
s
.60673 .38657 m
.60696 .38714 L
s
.588 .60439 m
.59301 .58422 L
s
0 g
.006 w
.60701 .38997 m
.60783 .38932 L
s
.58428 .68611 m
.60416 .69382 L
s
1 0 0 r
.003 w
.73917 .69237 m
.74833 .7038 L
s
.14685 .34179 m .2142 .40917 L .22736 .40345 L .638 .73 .914 r
F
.71186 .31153 m .59747 .37137 L .60618 .38519 L .738 .669 .783 r
F
0 g
.006 w
.67757 .34077 m
.71523 .32321 L
s
.61644 .38252 m
.64085 .36326 L
s
1 0 0 r
.003 w
.60618 .38519 m
.60673 .38657 L
s
.25 g
.5 Mabswid
.60618 .38519 m
.62122 .37875 L
s
.67757 .34077 m
.67765 .34417 L
s
.64085 .36326 m
.64295 .36824 L
s
.31375 .45966 m .43661 .44362 L .31564 .4275 L .7 .6 .741 r
F
.25 g
.31375 .45966 m
.42571 .46261 L
s
0 g
.006 w
.31375 .45966 m
.31987 .49117 L
s
1 0 0 r
.003 w
.43928 .4719 m
.44124 .48245 L
s
.44124 .48245 m
.44712 .50197 L
s
0 g
.006 w
.64085 .36326 m
.67757 .34077 L
s
1 0 0 r
.003 w
.44712 .50197 m
.45478 .52126 L
s
.45478 .52126 m
.46368 .54019 L
s
.58388 .62375 m
.588 .60439 L
s
.25 g
.5 Mabswid
.51646 .66359 m
.52515 .66071 L
s
.46198 .6817 m
.51646 .66359 L
s
.5593 .64936 m
.56228 .64837 L
s
.54516 .65406 m
.5593 .64936 L
s
.54264 .6549 m
.54516 .65406 L
s
.56228 .64837 m
.5811 .64211 L
s
0 g
.006 w
.4563 .69604 m
.46198 .6817 L
s
.47855 .43387 m .35958 .47524 L .36717 .49444 L .744 .608 .707 r
F
.25 g
.5 Mabswid
.36717 .49444 m
.43053 .47879 L
s
.31564 .4275 m .43661 .44362 L .43853 .4249 L .729 .637 .756 r
F
.34404 .39728 m .43853 .4249 L .44352 .40712 L .753 .674 .774 r
F
.31564 .4275 m .43853 .4249 L .33278 .3973 L .729 .637 .756 r
F
.31564 .4275 m .33278 .3973 L .32064 .41173 L F
.33231 .39352 m .30899 .41712 L .3156 .41614 L .629 .585 .785 r
F
.33264 .39615 m .3156 .41614 L .33478 .41331 L F
.33231 .39352 m .3156 .41614 L .33264 .39615 L F
.35105 .37457 m .44352 .40712 L .35547 .36938 L .753 .674 .774 r
F
.33264 .39615 m .34107 .39699 L .35105 .37457 L F
.34107 .39699 m .44352 .40712 L .35105 .37457 L F
.33264 .39615 m .34361 .40013 L .34404 .39728 L F
.33278 .3973 m .34361 .40013 L .33264 .39615 L F
.34361 .40013 m .43853 .4249 L .34404 .39728 L F
.35394 .38615 m .33231 .39352 L .33478 .41331 L .629 .585 .785 r
F
.39688 .37737 m .44352 .40712 L .45155 .3907 L .771 .711 .796 r
F
.39385 .3818 m .44352 .40712 L .39688 .37737 L F
.37323 .37528 m .44352 .40712 L .37443 .3719 L F
.35558 .36821 m .44352 .40712 L .35566 .36732 L F
.3537 .36862 m .44352 .40712 L .35103 .36619 L F
.42481 .35958 m .45155 .3907 L .46242 .37608 L .78 .746 .821 r
F
.36687 .41174 m .36557 .39696 L .35654 .4225 L .655 .581 .76 r
F
.40128 .34927 m .41765 .36777 L .42481 .35958 L .78 .746 .821 r
F
.3983 .35469 m .41765 .36777 L .40128 .34927 L F
.37443 .3719 m .39385 .3818 L .39688 .37737 L .771 .711 .796 r
F
.35153 .32252 m .33744 .35385 L .35103 .36619 L .607 .596 .814 r
F
.35153 .32252 m .35103 .36619 L .35113 .36605 L F
.33744 .35385 m .30899 .41712 L .35112 .36628 L F
.35103 .36619 m .45155 .3907 L .37161 .33664 L .771 .711 .796 r
F
.37665 .33031 m .46242 .37608 L .40261 .30968 L .78 .746 .821 r
F
.37123 .32924 m .36982 .33241 L .37416 .33309 L .607 .596 .814 r
F
.37123 .32924 m .37416 .33309 L .37611 .33091 L F
.35566 .36732 m .37323 .37528 L .37443 .3719 L .771 .711 .796 r
F
.35103 .36619 m .35558 .36821 L .35566 .36732 L F
.3554 .37016 m .33231 .39352 L .35394 .38615 L .629 .585 .785 r
F
.35112 .36628 m .30899 .41712 L .35105 .37457 L .607 .596 .814 r
F
.35153 .32252 m .35105 .37457 L .37123 .32924 L F
.33264 .39615 m .35547 .36938 L .3441 .3645 L .753 .674 .774 r
F
.36982 .33241 m .35105 .37457 L .3767 .34861 L .607 .596 .814 r
F
.37142 .33617 m .46242 .37608 L .37665 .33031 L .78 .746 .821 r
F
.37933 .33964 m .3983 .35469 L .40128 .34927 L F
.37142 .33617 m .37884 .34129 L .37933 .33964 L F
.37884 .34129 m .3983 .35469 L .37933 .33964 L F
.37408 .35759 m .3554 .37016 L .35394 .38615 L .629 .585 .785 r
F
.37161 .33664 m .3983 .35469 L .37142 .33617 L .78 .746 .821 r
F
.38964 .33553 m .3767 .34861 L .37408 .35759 L .629 .585 .785 r
F
.3767 .34861 m .3554 .37016 L .37408 .35759 L F
.36982 .33241 m .3767 .34861 L .38964 .33553 L .607 .596 .814 r
F
.37003 .33557 m .37142 .33617 L .37665 .33031 L .78 .746 .821 r
F
.37611 .33091 m .37416 .33309 L .38964 .33553 L .607 .596 .814 r
F
.37003 .33557 m .37161 .33664 L .37142 .33617 L .78 .746 .821 r
F
.3441 .3645 m .35103 .36619 L .37003 .33557 L .771 .711 .796 r
F
.35103 .36619 m .37161 .33664 L .37003 .33557 L F
.35113 .36605 m .35103 .36619 L .35112 .36628 L .607 .596 .814 r
F
.4225 .35383 m .38178 .38468 L .36687 .41174 L .655 .581 .76 r
F
.38178 .38468 m .36557 .39696 L .36687 .41174 L F
.41765 .36777 m .45155 .3907 L .42481 .35958 L .78 .746 .821 r
F
.4488 .37684 m .36867 .42384 L .3498 .45762 L .683 .584 .739 r
F
.36867 .42384 m .36257 .42741 L .35978 .43401 L F
.36867 .42384 m .35978 .43401 L .3498 .45762 L F
.36257 .42741 m .33794 .44186 L .34565 .4521 L F
.36257 .42741 m .34565 .4521 L .3498 .45762 L F
.35654 .4225 m .34126 .41537 L .33794 .44186 L .655 .581 .76 r
F
.36557 .39696 m .34126 .41537 L .35654 .4225 L F
.3441 .3645 m .3537 .36862 L .35103 .36619 L .771 .711 .796 r
F
.32579 .39548 m .33264 .39615 L .3441 .3645 L .753 .674 .774 r
F
.32064 .41173 m .33278 .3973 L .32579 .39548 L .729 .637 .756 r
F
.33478 .41331 m .31711 .41592 L .32423 .42827 L .629 .585 .785 r
F
.31711 .41592 m .30899 .41712 L .31339 .42034 L F
.31711 .41592 m .31339 .42034 L .32423 .42827 L F
.32579 .39548 m .33278 .3973 L .33264 .39615 L .753 .674 .774 r
F
.34126 .41537 m .32423 .42827 L .33728 .44121 L .655 .581 .76 r
F
.34126 .41537 m .33728 .44121 L .33794 .44186 L F
.46764 .4038 m .35958 .47524 L .47855 .43387 L .712 .594 .722 r
F
0 g
.006 w
.47855 .43387 m
.48148 .4662 L
s
.25 g
.5 Mabswid
.36022 .47502 m
.4647 .43869 L
s
.4647 .43869 m
.46751 .43771 L
s
.46751 .43771 m
.47855 .43387 L
s
.69622 .29003 m .59747 .37137 L .71186 .31153 L .719 .672 .803 r
F
0 g
.006 w
.71186 .31153 m
.71509 .3218 L
s
.69622 .29003 m .58644 .35992 L .59747 .37137 L .719 .672 .803 r
F
1 0 0 r
.003 w
.59747 .37137 m
.60618 .38519 L
s
.25 g
.5 Mabswid
.59747 .37137 m
.71186 .31153 L
s
.31564 .4275 m
.32466 .4287 L
s
.34764 .43177 m
.35376 .43258 L
s
.37673 .43564 m
.4123 .44038 L
s
0 g
.006 w
.31375 .45966 m
.31564 .4275 L
s
.18308 .32746 m .22736 .40345 L .2424 .40041 L .61 .708 .914 r
F
.14685 .34179 m .22736 .40345 L .18308 .32746 L .638 .73 .914 r
F
1 0 0 r
.003 w
.2142 .40917 m
.22736 .40345 L
s
.46368 .54019 m
.47333 .55867 L
s
.25 g
.5 Mabswid
.42619 .42168 m
.43652 .42437 L
s
.40168 .41528 m
.42619 .42168 L
s
1 0 0 r
.003 w
.43917 .42262 m
.44352 .40712 L
s
.67305 .27286 m .58644 .35992 L .69622 .29003 L .705 .683 .826 r
F
0 g
.006 w
.69622 .29003 m
.71186 .31153 L
s
.67305 .27286 m .57328 .35115 L .58644 .35992 L .705 .683 .826 r
F
1 0 0 r
.003 w
.58644 .35992 m
.59747 .37137 L
s
.25054 .76049 m .33687 .72378 L .22878 .77709 L .34 .072 .354 r
F
.25054 .76049 m .34268 .70679 L .33687 .72378 L F
.25 g
.5 Mabswid
.34418 .6919 m
.34927 .68821 L
s
0 g
.006 w
.25054 .76049 m
.27669 .74073 L
s
.25 g
.5 Mabswid
.25054 .76049 m
.2567 .7569 L
s
.3503 .67402 m
.35282 .67153 L
s
.30902 .71481 m
.3503 .67402 L
s
.22358 .3179 m .2424 .40041 L .25872 .40022 L .591 .677 .9 r
F
.18308 .32746 m .2424 .40041 L .22358 .3179 L .61 .708 .914 r
F
1 0 0 r
.003 w
.22736 .40345 m
.2424 .40041 L
s
.25 g
.5 Mabswid
.14685 .34179 m
.2142 .40917 L
s
1 0 0 r
.003 w
.74833 .7038 m
.75576 .714 L
s
.25 g
.5 Mabswid
.42265 .39817 m
.44352 .40712 L
s
1 0 0 r
.003 w
.44352 .40712 m
.45155 .3907 L
s
.47333 .55867 m
.48318 .57665 L
s
.5811 .64211 m
.58388 .62375 L
s
.64304 .26075 m .57328 .35115 L .67305 .27286 L .699 .702 .85 r
F
.25 g
.5 Mabswid
.69069 .29355 m
.69622 .29003 L
s
.64304 .26075 m .5583 .34532 L .57328 .35115 L .699 .702 .85 r
F
.25 g
.58644 .35992 m
.59215 .35628 L
s
1 0 0 r
.003 w
.57328 .35115 m
.58644 .35992 L
s
.26651 .31368 m .25872 .40022 L .27568 .40296 L .585 .644 .876 r
F
.22358 .3179 m .25872 .40022 L .26651 .31368 L .591 .677 .9 r
F
1 0 0 r
.2424 .40041 m
.25872 .40022 L
s
.25 g
.5 Mabswid
.22358 .3179 m
.22422 .32072 L
s
.22422 .32072 m
.23937 .38714 L
s
.23937 .38714 m
.2424 .40041 L
s
.18308 .32746 m
.22736 .40345 L
s
0 g
.006 w
.31564 .4275 m
.31706 .42303 L
s
1 0 0 r
.003 w
.37563 .53629 m
.37659 .55835 L
s
.37252 .51489 m
.37563 .53629 L
s
.60728 .25424 m .5583 .34532 L .64304 .26075 L .7 .727 .871 r
F
.25 g
.5 Mabswid
.66849 .27644 m
.67305 .27286 L
s
.60728 .25424 m .54196 .34263 L .5583 .34532 L .7 .727 .871 r
F
.25 g
.59215 .35628 m
.60338 .34913 L
s
.57328 .35115 m
.5811 .34501 L
s
1 0 0 r
.003 w
.5583 .34532 m
.57328 .35115 L
s
.37553 .58078 m
.37659 .55835 L
s
.36717 .49444 m
.37252 .51489 L
s
.48318 .57665 m
.49277 .5941 L
s
.40261 .30968 m .46242 .37608 L .47576 .36367 L .78 .773 .847 r
F
1 0 0 r
.45155 .3907 m
.46242 .37608 L
s
.30984 .31518 m .27568 .40296 L .29263 .40862 L .591 .616 .845 r
F
.26651 .31368 m .27568 .40296 L .30984 .31518 L .585 .644 .876 r
F
1 0 0 r
.25872 .40022 m
.27568 .40296 L
s
.25 g
.5 Mabswid
.25872 .40022 m
.26651 .31368 L
s
1 0 0 r
.003 w
.37265 .60327 m
.37553 .58078 L
s
.46764 .4038 m .3498 .45762 L .35958 .47524 L .712 .594 .722 r
F
1 0 0 r
.35958 .47524 m
.36717 .49444 L
s
.25 g
.5 Mabswid
.35958 .47524 m
.36022 .47502 L
s
.35153 .32252 m .29263 .40862 L .30899 .41712 L .607 .596 .814 r
F
.30984 .31518 m .29263 .40862 L .35153 .32252 L .591 .616 .845 r
F
.25 g
.27568 .40296 m
.30984 .31518 L
s
1 0 0 r
.003 w
.27568 .40296 m
.29263 .40862 L
s
.25 g
.5 Mabswid
.29263 .40862 m
.3159 .3746 L
s
1 0 0 r
.003 w
.29263 .40862 m
.30899 .41712 L
s
.56726 .25372 m .54196 .34263 L .60728 .25424 L .709 .754 .887 r
F
.25 g
.5 Mabswid
.63996 .26382 m
.64304 .26075 L
s
.5811 .34501 m
.66849 .27644 L
s
.60338 .34913 m
.69069 .29355 L
s
.56726 .25372 m .52486 .34317 L .54196 .34263 L .709 .754 .887 r
F
.25 g
.5703 .33334 m
.63996 .26382 L
s
1 0 0 r
.003 w
.54196 .34263 m
.5583 .34532 L
s
.44044 .2878 m .47576 .36367 L .49105 .35386 L .768 .789 .87 r
F
.40261 .30968 m .47576 .36367 L .44044 .2878 L .78 .773 .847 r
F
.25 g
.5 Mabswid
.44952 .36175 m
.46242 .37608 L
s
1 0 0 r
.003 w
.46242 .37608 m
.47576 .36367 L
s
.25 g
.5 Mabswid
.40261 .30968 m
.40777 .31541 L
s
.40777 .31541 m
.42392 .33333 L
s
.4488 .37684 m .3498 .45762 L .46764 .4038 L .683 .584 .739 r
F
.25 g
.35382 .45578 m
.46764 .4038 L
s
.3498 .45762 m
.35382 .45578 L
s
1 0 0 r
.003 w
.3498 .45762 m
.35958 .47524 L
s
0 g
.006 w
.46764 .4038 m
.47855 .43387 L
s
.25 g
.5 Mabswid
.58409 .68541 m
.59926 .69177 L
s
.59926 .69177 m
.60427 .69386 L
s
1 0 0 r
.003 w
.36822 .62555 m
.37265 .60327 L
s
.4225 .35383 m .33794 .44186 L .4488 .37684 L .655 .581 .76 r
F
.25 g
.5 Mabswid
.33794 .44186 m
.33952 .44093 L
s
0 g
.006 w
.4488 .37684 m
.46764 .4038 L
s
1 0 0 r
.003 w
.33794 .44186 m
.3498 .45762 L
s
.25 g
.5 Mabswid
.30899 .41712 m
.31122 .41486 L
s
.31122 .41486 m
.32363 .40231 L
s
1 0 0 r
.003 w
.30899 .41712 m
.31339 .42034 L
s
.58014 .65932 m
.5811 .64211 L
s
.38964 .33553 m .32423 .42827 L .4225 .35383 L .629 .585 .785 r
F
.25 g
.5 Mabswid
.32423 .42827 m
.32462 .42798 L
s
.32621 .42677 m
.34126 .41537 L
s
.32462 .42798 m
.32621 .42677 L
s
.34126 .41537 m
.36557 .39696 L
s
.36557 .39696 m
.38178 .38468 L
s
.38178 .38468 m
.38846 .37962 L
s
.38846 .37962 m
.4225 .35383 L
s
1 0 0 r
.003 w
.31339 .42034 m
.32423 .42827 L
s
.25 g
.5 Mabswid
.35105 .37457 m
.3554 .37016 L
s
.3554 .37016 m
.3767 .34861 L
s
.3767 .34861 m
.38964 .33553 L
s
1 0 0 r
.003 w
.32423 .42827 m
.33794 .44186 L
s
.25 g
.5 Mabswid
.35154 .36769 m
.3537 .36862 L
s
.3441 .3645 m
.35154 .36769 L
s
.36867 .42384 m
.44232 .38064 L
s
.44232 .38064 m
.4488 .37684 L
s
.36257 .42741 m
.36867 .42384 L
s
.33952 .44093 m
.36257 .42741 L
s
.3159 .3746 m
.33612 .34505 L
s
.33612 .34505 m
.35153 .32252 L
s
0 g
.006 w
.32064 .41173 m
.32579 .39548 L
s
.25 g
.5 Mabswid
.32579 .39548 m
.33278 .3973 L
s
.37003 .33557 m
.37161 .33664 L
s
.52478 .25928 m .52486 .34317 L .56726 .25372 L .727 .777 .893 r
F
.25 g
.54196 .34263 m
.60664 .25512 L
s
.60664 .25512 m
.60728 .25424 L
s
.5583 .34532 m
.5703 .33334 L
s
.52478 .25928 m .50765 .34696 L .52486 .34317 L .727 .777 .893 r
F
1 0 0 r
.003 w
.52486 .34317 m
.54196 .34263 L
s
.25 g
.5 Mabswid
.52486 .34317 m
.56726 .25372 L
s
.48182 .27078 m .49105 .35386 L .50765 .34696 L .749 .791 .887 r
F
.44044 .2878 m .49105 .35386 L .48182 .27078 L .768 .789 .87 r
F
1 0 0 r
.003 w
.47576 .36367 m
.49105 .35386 L
s
.25 g
.5 Mabswid
.42392 .33333 m
.44952 .36175 L
s
.44678 .30142 m
.47576 .36367 L
s
.44374 .29488 m
.44678 .30142 L
s
.44044 .2878 m
.44374 .29488 L
s
.48182 .27078 m .50765 .34696 L .52478 .25928 L .749 .791 .887 r
F
.25 g
.50765 .34696 m
.52478 .25928 L
s
1 0 0 r
.003 w
.49105 .35386 m
.50765 .34696 L
s
.25 g
.5 Mabswid
.48182 .27078 m
.49105 .35386 L
s
1 0 0 r
.003 w
.50765 .34696 m
.52486 .34317 L
s
.36255 .64732 m
.36822 .62555 L
s
.49277 .5941 m
.50163 .61102 L
s
0 g
.006 w
.67305 .27286 m
.69622 .29003 L
s
1 0 0 r
.003 w
.35608 .6683 m
.36255 .64732 L
s
.25 g
.5 Mabswid
.56245 .66456 m
.58014 .65932 L
s
.55619 .66642 m
.56245 .66456 L
s
.53645 .67227 m
.54599 .66944 L
s
.52408 .67594 m
.52745 .67494 L
s
.52773 .67486 m
.53645 .67227 L
s
.4563 .69604 m
.52408 .67594 L
s
0 g
.006 w
.4563 .69604 m
.4585 .70798 L
s
1 0 0 r
.003 w
.58014 .65932 m
.5814 .67522 L
s
0 g
.006 w
.32579 .39548 m
.3441 .3645 L
s
.22878 .77709 m .33246 .73897 L .21273 .79041 L .424 .129 .358 r
F
.22878 .77709 m .33687 .72378 L .33246 .73897 L F
.25 g
.5 Mabswid
.33567 .71087 m
.34268 .70679 L
s
.2567 .7569 m
.33567 .71087 L
s
0 g
.006 w
.22878 .77709 m
.25054 .76049 L
s
.25 g
.5 Mabswid
.22878 .77709 m
.2362 .77343 L
s
.2362 .77343 m
.33687 .72378 L
s
.34025 .69474 m
.34418 .6919 L
s
.28143 .7373 m
.34025 .69474 L
s
1 0 0 r
.003 w
.34927 .68821 m
.35608 .6683 L
s
.50163 .61102 m
.50936 .6274 L
s
.87969 .75758 m .76377 .73068 L .76104 .72297 L .667 .185 .097 r
F
1 0 0 r
.75576 .714 m
.76104 .72297 L
s
.25 g
.5 Mabswid
.82928 .74588 m
.8613 .75664 L
s
.89065 .75724 m .76377 .73068 L .87969 .75758 L .602 .116 .073 r
F
0 g
.006 w
.8613 .75664 m
.87969 .75758 L
s
.4225 .35383 m
.4488 .37684 L
s
1 0 0 r
.003 w
.34268 .70679 m
.34927 .68821 L
s
.25 g
.5 Mabswid
.56818 .67874 m
.5814 .67522 L
s
.55896 .6812 m
.56818 .67874 L
s
0 g
.006 w
.64304 .26075 m
.67305 .27286 L
s
1 0 0 r
.003 w
.50936 .6274 m
.51559 .64324 L
s
.62619 .70306 m .52218 .67327 L .51996 .65853 L .803 .436 .361 r
F
.25 g
.5 Mabswid
.62004 .70129 m
.62619 .70306 L
s
.592 .69326 m
.62004 .70129 L
s
.58615 .69159 m
.592 .69326 L
s
.57061 .68714 m
.58615 .69159 L
s
1 0 0 r
.003 w
.5814 .67522 m
.58409 .68541 L
s
.25 g
.5 Mabswid
.5298 .68897 m
.54723 .68433 L
s
.4585 .70798 m
.52908 .68916 L
s
.54723 .68433 m
.55253 .68291 L
s
0 g
.006 w
.60427 .69386 m
.62619 .70306 L
s
.25 g
.5 Mabswid
.51996 .65853 m
.52259 .65963 L
s
.52259 .65963 m
.56648 .67803 L
s
.89065 .75724 m .76361 .73714 L .76377 .73068 L .602 .116 .073 r
F
1 0 0 r
.003 w
.76104 .72297 m
.76377 .73068 L
s
.25 g
.5 Mabswid
.85159 .75106 m
.87969 .75758 L
s
0 g
.006 w
.3441 .3645 m
.37003 .33557 L
s
.39782 .34009 m
.4225 .35383 L
s
.38964 .33553 m
.39782 .34009 L
s
1 0 0 r
.003 w
.33687 .72378 m
.34268 .70679 L
s
0 g
.006 w
.14685 .34179 m
.18308 .32746 L
s
.25 g
.5 Mabswid
.46914 .71765 m
.47725 .71569 L
s
.57385 .69243 m
.57876 .69125 L
s
.56179 .69534 m
.57385 .69243 L
s
1 0 0 r
.003 w
.58743 .69401 m
.58862 .69635 L
s
.58862 .69635 m
.59108 .70117 L
s
.51559 .64324 m
.51996 .65853 L
s
0 g
.006 w
.60728 .25424 m
.64304 .26075 L
s
.4585 .70798 m
.46914 .71765 L
s
.21273 .79041 m .33 .75216 L .20359 .80044 L .477 .153 .338 r
F
.21273 .79041 m .33246 .73897 L .33 .75216 L F
0 g
.21273 .79041 m
.22878 .77709 L
s
.25 g
.5 Mabswid
.21273 .79041 m
.33246 .73897 L
s
1 0 0 r
.003 w
.33246 .73897 m
.33687 .72378 L
s
.89328 .75596 m .76361 .73714 L .89065 .75724 L .521 .017 0 r
F
0 g
.006 w
.87969 .75758 m
.89065 .75724 L
s
.89328 .75596 m .76032 .74236 L .76361 .73714 L .521 .017 0 r
F
1 0 0 r
.003 w
.76361 .73714 m
.76377 .73068 L
s
.25 g
.5 Mabswid
.86296 .75286 m
.89065 .75724 L
s
0 g
.006 w
.37611 .33091 m
.38964 .33553 L
s
.35153 .32252 m
.37596 .33086 L
s
.37003 .33557 m
.37665 .33031 L
s
.37665 .33031 m
.40261 .30968 L
s
.18308 .32746 m
.22358 .3179 L
s
.30984 .31518 m
.35153 .32252 L
s
.56726 .25372 m
.60728 .25424 L
s
.22358 .3179 m
.26651 .31368 L
s
.88698 .75408 m .76032 .74236 L .89328 .75596 L .414 0 0 r
F
0 g
.89065 .75724 m
.89328 .75596 L
s
.88698 .75408 m .75381 .74635 L .76032 .74236 L .414 0 0 r
F
1 0 0 r
.003 w
.76032 .74236 m
.76361 .73714 L
s
.64147 .71119 m .52197 .68742 L .52218 .67327 L .749 .395 .382 r
F
.25 g
.5 Mabswid
.61244 .70542 m
.64147 .71119 L
s
.58754 .70046 m
.61244 .70542 L
s
1 0 0 r
.003 w
.51996 .65853 m
.52218 .67327 L
s
0 g
.006 w
.62619 .70306 m
.64147 .71119 L
s
.25 g
.5 Mabswid
.52489 .67404 m
.57061 .68714 L
s
.52218 .67327 m
.52489 .67404 L
s
0 g
.006 w
.40261 .30968 m
.44044 .2878 L
s
.26651 .31368 m
.30984 .31518 L
s
.52046 .73065 m .60133 .71407 L .61357 .72387 L .68 .223 .16 r
F
.52008 .73016 m .60133 .71407 L .52046 .73065 L F
.48839 .72523 m .60133 .71407 L .51593 .73098 L .687 .294 .296 r
F
.51592 .73098 m .49383 .73737 L .50152 .72956 L .5 .119 .25 r
F
.51593 .73098 m .61357 .72387 L .55374 .7347 L .68 .223 .16 r
F
.55415 .7351 m .51839 .7379 L .51634 .73214 L .5 .119 .25 r
F
.59577 .73959 m .55784 .73876 L .55415 .7351 L F
.55784 .73876 m .51839 .7379 L .55415 .7351 L F
.55413 .73508 m .62826 .73209 L .59296 .7381 L .622 .089 0 r
F
.5648 .73465 m .61357 .72387 L .62826 .73209 L F
.55413 .73508 m .56304 .7334 L .5648 .73465 L F
.56304 .7334 m .61357 .72387 L .5648 .73465 L F
.54151 .7181 m .51733 .72662 L .5135 .71383 L .576 .215 .319 r
F
.55374 .7347 m .61357 .72387 L .55413 .73508 L .622 .089 0 r
F
.60444 .73839 m .62826 .73209 L .64491 .73875 L .474 0 0 r
F
.61843 .74009 m .59577 .73959 L .59575 .73959 L .5 .119 .25 r
F
.60777 .73906 m .64491 .73875 L .63726 .74052 L .474 0 0 r
F
.60777 .73906 m .63726 .74052 L .62884 .74011 L F
.59331 .73828 m .64491 .73875 L .60777 .73906 L F
.59331 .73828 m .60087 .73675 L .60444 .73839 L F
.59296 .7381 m .60087 .73675 L .59331 .73828 L F
.60087 .73675 m .62826 .73209 L .60444 .73839 L F
.61956 .73966 m .50504 .72599 L .63779 .73279 L .5 .119 .25 r
F
.61843 .74009 m .61202 .73929 L .61956 .73966 L F
.61202 .73929 m .50504 .72599 L .61956 .73966 L F
.62884 .74011 m .63726 .74052 L .63723 .74053 L .474 0 0 r
F
.59331 .73828 m .59575 .73959 L .58357 .73776 L .5 .119 .25 r
F
.61843 .74009 m .59575 .73959 L .59008 .73656 L F
.59195 .73827 m .59331 .73828 L .60777 .73906 L .474 0 0 r
F
.59008 .73656 m .59331 .73828 L .50504 .72599 L .5 .119 .25 r
F
.59331 .73828 m .58357 .73776 L .50504 .72599 L F
.59195 .73827 m .59296 .7381 L .59331 .73828 L .474 0 0 r
F
.56927 .72234 m .55631 .72862 L .54151 .7181 L .576 .215 .319 r
F
.63779 .73279 m .58641 .73016 L .56927 .72234 L F
.58641 .73016 m .55631 .72862 L .56927 .72234 L F
.55631 .72862 m .51733 .72662 L .54151 .7181 L F
.51593 .73098 m .52008 .73016 L .52046 .73065 L .68 .223 .16 r
F
.51593 .73098 m .52008 .73016 L .51593 .73098 L F
.48839 .72523 m .51593 .73098 L .51589 .73097 L .687 .294 .296 r
F
.59577 .73959 m .50165 .72944 L .50504 .72599 L .5 .119 .25 r
F
.5509 .73521 m .55413 .73508 L .59195 .73827 L .622 .089 0 r
F
.55413 .73508 m .59296 .7381 L .59195 .73827 L F
.55352 .73503 m .51634 .73214 L .51593 .73098 L .5 .119 .25 r
F
.55415 .7351 m .51634 .73214 L .55352 .73503 L F
.5509 .73521 m .55374 .7347 L .55413 .73508 L .622 .089 0 r
F
.51839 .7379 m .49383 .73737 L .51593 .73098 L .5 .119 .25 r
F
.51592 .73098 m .51593 .73098 L .5509 .73521 L .68 .223 .16 r
F
.51593 .73098 m .55374 .7347 L .5509 .73521 L F
.51593 .73098 m .51592 .73098 L .50165 .72944 L .5 .119 .25 r
F
.51592 .73098 m .50152 .72956 L .50165 .72944 L F
.51592 .73098 m .51593 .73098 L .51593 .73098 L .68 .223 .16 r
F
.51589 .73097 m .51593 .73098 L .51592 .73098 L .687 .294 .296 r
F
.51733 .72662 m .50504 .72599 L .51061 .71799 L .576 .215 .319 r
F
.51733 .72662 m .51061 .71799 L .5135 .71383 L F
.25 g
.5 Mabswid
.47725 .71569 m
.55796 .69626 L
s
.58256 .70469 m
.5877 .70357 L
s
.4958 .72361 m
.50865 .72081 L
s
1 0 0 r
.003 w
.59385 .70508 m
.60133 .71407 L
s
.25 g
.5 Mabswid
.48839 .72523 m
.4958 .72361 L
s
1 0 0 r
.003 w
.60133 .71407 m
.61357 .72387 L
s
0 g
.006 w
.52478 .25928 m
.56726 .25372 L
s
.44044 .2878 m
.48182 .27078 L
s
.20359 .80044 m .33 .75216 L .33 .76321 L .508 .151 .296 r
F
1 0 0 r
.003 w
.33 .75216 m
.33246 .73897 L
s
.87153 .7519 m .75381 .74635 L .88698 .75408 L .272 0 0 r
F
.25 g
.5 Mabswid
.88682 .7553 m
.89328 .75596 L
s
.85901 .75246 m
.88682 .7553 L
s
.87153 .7519 m .74413 .74911 L .75381 .74635 L .272 0 0 r
F
1 0 0 r
.003 w
.75381 .74635 m
.76032 .74236 L
s
0 g
.006 w
.48182 .27078 m
.52478 .25928 L
s
.25 g
.5 Mabswid
.5509 .73521 m
.55374 .7347 L
s
1 0 0 r
.003 w
.61357 .72387 m
.62641 .73105 L
s
0 g
.006 w
.46914 .71765 m
.48839 .72523 L
s
.20359 .80044 m .33 .76321 L .20234 .80718 L .508 .151 .296 r
F
0 g
.20359 .80044 m
.21273 .79041 L
s
.25 g
.5 Mabswid
.20359 .80044 m
.33 .75216 L
s
0 g
.006 w
.88698 .75408 m
.89328 .75596 L
s
.8472 .74967 m .74413 .74911 L .87153 .7519 L .105 0 0 r
F
.25 g
.5 Mabswid
.8813 .75375 m
.88698 .75408 L
s
.83601 .75112 m
.8813 .75375 L
s
.8472 .74967 m .73152 .75064 L .74413 .74911 L .105 0 0 r
F
1 0 0 r
.003 w
.74413 .74911 m
.75381 .74635 L
s
.64901 .71864 m .51913 .70095 L .52197 .68742 L .696 .347 .381 r
F
1 0 0 r
.52197 .68742 m
.52218 .67327 L
s
.25 g
.5 Mabswid
.52948 .71627 m
.56874 .70771 L
s
.52197 .68742 m
.58754 .70046 L
s
.20234 .80718 m .33 .76321 L .33284 .77202 L .518 .121 .227 r
F
1 0 0 r
.003 w
.33 .76321 m
.33 .75216 L
s
.81478 .74756 m .73152 .75064 L .8472 .74967 L .038 .608 .728 r
F
.25 g
.5 Mabswid
.86782 .75182 m
.87153 .7519 L
s
.81478 .74756 m .71642 .75092 L .73152 .75064 L .038 .608 .728 r
F
1 0 0 r
.003 w
.73418 .75031 m
.74413 .74911 L
s
.63723 .74053 m .64491 .73875 L .66285 .7439 L .251 0 0 r
F
.25 g
.5 Mabswid
.63726 .74052 m
.64491 .73875 L
s
1 0 0 r
.003 w
.63378 .7343 m
.64491 .73875 L
s
.64796 .72573 m .51913 .70095 L .64901 .71864 L .64 .289 .36 r
F
.25 g
.5 Mabswid
.61201 .7136 m
.64901 .71864 L
s
0 g
.006 w
.64147 .71119 m
.64901 .71864 L
s
.25 g
.5 Mabswid
.56379 .7215 m
.59443 .71543 L
s
.59791 .72671 m
.61357 .72387 L
s
.77559 .74567 m .71642 .75092 L .81478 .74756 L .105 .652 .828 r
F
.25 g
.79115 .75014 m
.86782 .75182 L
s
.77559 .74567 m .69943 .74992 L .71642 .75092 L .105 .652 .828 r
F
1 0 0 r
.003 w
.71642 .75092 m
.73152 .75064 L
s
.64796 .72573 m .5135 .71383 L .51913 .70095 L .64 .289 .36 r
F
1 0 0 r
.51913 .70095 m
.52197 .68742 L
s
.25 g
.5 Mabswid
.51913 .70095 m
.61201 .7136 L
s
.68453 .74233 m .66285 .7439 L .6813 .7476 L 0 .523 .784 r
F
.63723 .74053 m .66285 .7439 L .68453 .74233 L .251 0 0 r
F
1 0 0 r
.003 w
.64491 .73875 m
.65322 .74114 L
s
.25 g
.5 Mabswid
.63723 .74053 m
.63726 .74052 L
s
.2097 .81076 m .33284 .77202 L .33877 .77853 L .5 .053 .12 r
F
.25 g
.31506 .76836 m
.33 .76321 L
s
.20234 .80718 m .33284 .77202 L .2097 .81076 L .518 .121 .227 r
F
.25 g
.20234 .80718 m
.31506 .76836 L
s
1 0 0 r
.003 w
.33 .76321 m
.33284 .77202 L
s
0 g
.006 w
.20234 .80718 m
.20359 .80044 L
s
.73145 .74397 m .69943 .74992 L .77559 .74567 L .077 .621 .846 r
F
.25 g
.5 Mabswid
.7863 .74854 m
.81478 .74756 L
s
.73152 .75064 m
.8472 .74967 L
s
.73145 .74397 m .6813 .7476 L .69943 .74992 L .077 .621 .846 r
F
.25 g
.71642 .75092 m
.7863 .74854 L
s
1 0 0 r
.003 w
.69943 .74992 m
.71642 .75092 L
s
.68453 .74233 m .6813 .7476 L .73145 .74397 L 0 .523 .784 r
F
.25 g
.5 Mabswid
.6813 .7476 m
.7146 .74519 L
s
.7146 .74519 m
.73145 .74397 L
s
1 0 0 r
.003 w
.6813 .7476 m
.69943 .74992 L
s
.66285 .7439 m
.6813 .7476 L
s
.25 g
.5 Mabswid
.69943 .74992 m
.76668 .74617 L
s
.76668 .74617 m
.77559 .74567 L
s
.66285 .7439 m
.68453 .74233 L
s
0 g
.006 w
.48839 .72523 m
.50282 .72824 L
s
.87153 .7519 m
.88698 .75408 L
s
.63779 .73279 m .5135 .71383 L .64796 .72573 L .576 .215 .319 r
F
.25 g
.5 Mabswid
.5135 .71383 m
.54534 .71665 L
s
.54534 .71665 m
.64796 .72573 L
s
0 g
.006 w
.51589 .73097 m
.51592 .73098 L
s
1 0 0 r
.003 w
.5135 .71383 m
.51913 .70095 L
s
0 g
.006 w
.64796 .72573 m
.64901 .71864 L
s
.25 g
.5 Mabswid
.51592 .73098 m
.51593 .73098 L
s
1 0 0 r
.003 w
.50504 .72599 m
.5135 .71383 L
s
.22596 .81138 m .33877 .77853 L .34784 .78276 L .44 0 0 r
F
.25 g
.5 Mabswid
.31567 .77742 m
.33284 .77202 L
s
.2097 .81076 m .33877 .77853 L .22596 .81138 L .5 .053 .12 r
F
1 0 0 r
.003 w
.33284 .77202 m
.33877 .77853 L
s
0 g
.006 w
.20234 .80718 m
.2097 .81076 L
s
.25 g
.5 Mabswid
.2097 .81076 m
.21903 .80783 L
s
.58641 .73016 m
.63779 .73279 L
s
.55631 .72862 m
.58641 .73016 L
s
.51733 .72662 m
.55631 .72862 L
s
.50504 .72599 m
.51733 .72662 L
s
1 0 0 r
.003 w
.50165 .72944 m
.50504 .72599 L
s
.25099 .80931 m .34784 .78276 L .35988 .78475 L .323 0 0 r
F
.25 g
.5 Mabswid
.31876 .78436 m
.33877 .77853 L
s
.29961 .78247 m
.31567 .77742 L
s
.22596 .81138 m .34784 .78276 L .25099 .80931 L .44 0 0 r
F
1 0 0 r
.003 w
.33877 .77853 m
.34784 .78276 L
s
.25 g
.5 Mabswid
.22596 .81138 m
.23491 .80877 L
s
0 g
.006 w
.63779 .73279 m
.64796 .72573 L
s
.59029 .7478 m .49383 .73737 L .61843 .74009 L .401 0 .142 r
F
.25 g
.5 Mabswid
.59576 .73959 m
.61843 .74009 L
s
.59195 .73827 m
.59296 .7381 L
s
.59029 .7478 m .48007 .74787 L .49383 .73737 L .401 0 .142 r
F
1 0 0 r
.003 w
.49383 .73737 m
.50165 .72944 L
s
.25 g
.5 Mabswid
.49383 .73737 m
.59576 .73959 L
s
0 g
.006 w
.51592 .73098 m
.5509 .73521 L
s
.8472 .74967 m
.87153 .7519 L
s
.28411 .80493 m .35988 .78475 L .37453 .7846 L .158 0 0 r
F
.25 g
.5 Mabswid
.29671 .79078 m
.31876 .78436 L
s
.27242 .79103 m
.29961 .78247 L
s
.25099 .80931 m .35988 .78475 L .28411 .80493 L .323 0 0 r
F
.25 g
.21903 .80783 m
.27242 .79103 L
s
.32297 .78957 m
.34784 .78276 L
s
1 0 0 r
.003 w
.34784 .78276 m
.35988 .78475 L
s
.25 g
.5 Mabswid
.25099 .80931 m
.25965 .80694 L
s
0 g
.006 w
.2097 .81076 m
.22596 .81138 L
s
.55435 .75601 m .48007 .74787 L .59029 .7478 L .272 0 0 r
F
.55435 .75601 m .46415 .75738 L .48007 .74787 L F
1 0 0 r
.003 w
.48007 .74787 m
.49383 .73737 L
s
.25 g
.5 Mabswid
.48007 .74787 m
.59029 .7478 L
s
.32407 .79868 m .37453 .7846 L .39126 .78245 L 0 0 0 r
F
.28411 .80493 m .37453 .7846 L .32407 .79868 L .158 0 0 r
F
.25 g
.29157 .80294 m
.31949 .7955 L
s
1 0 0 r
.003 w
.35988 .78475 m
.37453 .7846 L
s
.25 g
.5 Mabswid
.28971 .80344 m
.29157 .80294 L
s
.28411 .80493 m
.28971 .80344 L
s
.25965 .80694 m
.32297 .78957 L
s
.23491 .80877 m
.29671 .79078 L
s
.51212 .76467 m .46415 .75738 L .55435 .75601 L .118 0 0 r
F
.51212 .76467 m .4466 .76576 L .46415 .75738 L F
1 0 0 r
.003 w
.46415 .75738 m
.48007 .74787 L
s
.25 g
.5 Mabswid
.46415 .75738 m
.55435 .75601 L
s
.36912 .79105 m .39126 .78245 L .40938 .77847 L 0 0 0 r
F
.32407 .79868 m .39126 .78245 L .36912 .79105 L F
1 0 0 r
.003 w
.37453 .7846 m
.39126 .78245 L
s
.25 g
.5 Mabswid
.32848 .79745 m
.32992 .79705 L
s
.32407 .79868 m
.32848 .79745 L
s
.31949 .7955 m
.35988 .78475 L
s
.4656 .77362 m .4466 .76576 L .51212 .76467 L 0 0 0 r
F
.4656 .77362 m .42809 .77285 L .4466 .76576 L F
1 0 0 r
.003 w
.4466 .76576 m
.46415 .75738 L
s
.25 g
.5 Mabswid
.4466 .76576 m
.51212 .76467 L
s
.41711 .78254 m .40938 .77847 L .42809 .77285 L 0 0 0 r
F
.36912 .79105 m .40938 .77847 L .41711 .78254 L F
1 0 0 r
.003 w
.39126 .78245 m
.40938 .77847 L
s
.25 g
.5 Mabswid
.37376 .78925 m
.39126 .78245 L
s
.36912 .79105 m
.37376 .78925 L
s
.32992 .79705 m
.37453 .7846 L
s
.41711 .78254 m .42809 .77285 L .4656 .77362 L 0 0 0 r
F
.25 g
.42809 .77285 m
.4656 .77362 L
s
1 0 0 r
.003 w
.40938 .77847 m
.42809 .77285 L
s
.25 g
.5 Mabswid
.40938 .77847 m
.41711 .78254 L
s
1 0 0 r
.003 w
.42809 .77285 m
.4466 .76576 L
s
0 g
.006 w
.62667 .73698 m
.63779 .73279 L
s
.61956 .73966 m
.62667 .73698 L
s
.61844 .74008 m
.61956 .73966 L
s
.61843 .74009 m
.61844 .74008 L
s
.5509 .73521 m
.59195 .73827 L
s
.81478 .74756 m
.8472 .74967 L
s
.22596 .81138 m
.25099 .80931 L
s
.59195 .73827 m
.60777 .73906 L
s
.62884 .74011 m
.63723 .74053 L
s
.61958 .73965 m
.62884 .74011 L
s
.77559 .74567 m
.81478 .74756 L
s
.59029 .7478 m
.61843 .74009 L
s
.63723 .74053 m
.68453 .74233 L
s
.73145 .74397 m
.77559 .74567 L
s
.68453 .74233 m
.73145 .74397 L
s
.25099 .80931 m
.28411 .80493 L
s
.55435 .75601 m
.59029 .7478 L
s
.28411 .80493 m
.32407 .79868 L
s
.51212 .76467 m
.55435 .75601 L
s
.32407 .79868 m
.36912 .79105 L
s
.4656 .77362 m
.51212 .76467 L
s
.36912 .79105 m
.41711 .78254 L
s
.41711 .78254 m
.4656 .77362 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000181000`40O003h00Oogoo2Woo002`Ool2
001GOol00:ioo`800003Ool0000005Ioo`00Zgoo0`000goo0P00EWoo002YOol20006Ool00`00Ool0
001EOol00:Moo`8000Qoo`03001oo`0005Eoo`00Y7oo0`002Woo00@007ooOol005Aoo`00XWoo0P00
3Goo00D007ooOomoo`0005=oo`00Wgoo0`003goo00D007ooOomoo`0005=oo`00WGoo0P004Woo00<0
07ooOol00Woo00<007ooOol0D7oo002KOol2000EOol00`00Oomoo`02Ool00`00Oomoo`1?Ool009Qo
o`<001Moo`03001oogoo009oo`03001oogoo04moo`00UWoo0P006Woo00<007ooOol00goo00<007oo
Ool0CWoo002COol3000LOol00`00Oomoo`03Ool00`00Oomoo`1>Ool0095oo`8001moo`03001oogoo
00Aoo`03001oogoo04eoo`00Sgoo0P008Goo00<007ooOol01Goo00<007ooOol0C7oo002<Ool3000S
Ool00`00Oomoo`05Ool00`00Oomoo`1<Ool008Yoo`8002Ioo`03001oogoo00Ioo`03001oogoo04]o
o`00Qgoo0`00:7oo00<007ooOol01goo00<007ooOol0BWoo0025Ool2000[Ool00`00Oomoo`07Ool0
0`00Oomoo`1:Ool008=oo`8002eoo`03001oogoo00Qoo`03001oogoo04Uoo`00P7oo0`00;goo00<0
07ooOol027oo00<007ooOol0BGoo001nOol2000bOol00`00Oomoo`09Ool00`00Oomoo`18Ool007]o
o`<003Aoo`03001oogoo00Yoo`03001oogoo04Moo`00NGoo0P00=goo00<007ooOol02Woo00<007oo
Ool0Agoo001gOol2000iOol00`00Oomoo`0;Ool00`00Oomoo`16Ool007Aoo`<003]oo`03001oogoo
00aoo`03001oogoo04Eoo`00LWoo0P00?goo00<007ooOol02goo00<007ooOol0AGoo001_Ool30011
Ool00`00Oomoo`0<Ool00`00Oomoo`14Ool006eoo`8004Aoo`03001oogoo00aoo`03001oogoo04Ao
o`00Jgoo0P00AWoo00<007ooOol03Goo00<007ooOol0@goo001XOol30018Ool00`00Oomoo`0>Ool0
0`00Oomoo`12Ool006Ioo`8004]oo`03001oogoo00ioo`03001oogoo049oo`00Hgoo0`00CGoo00<0
07ooOol03goo00<007ooOol0@Goo001QOol2001@Ool00`00Oomoo`0@Ool00`00Oomoo`10Ool005io
o`<0059oo`03001oogoo011oo`03001oogoo041oo`00G7oo0P00EGoo00<007ooOol04Goo00<007oo
Ool0?goo001JOol2001GOol00`00Oomoo`0AOol00`00Oomoo`0oOol005Moo`<005Uoo`03001oogoo
019oo`03001oogoo03ioo`00EGoo0P00G7oo00<007ooOol04goo00<007ooOol0?Goo001BOol3001N
Ool00`00Oomoo`0COol00`00Oomoo`0mOol0051oo`80065oo`03001oogoo01Aoo`03001oogoo03ao
o`00CWoo0P00Hgoo00<007ooOol05Goo00<007ooOol0>goo001;Ool3001UOol00`00Oomoo`0EOol0
0`00Oomoo`0kOol004Uoo`8006Uoo`03001oogoo01Eoo`03001oogoo03Yoo`00AWoo0`00Jgoo00<0
07ooOol05Goo00<007ooOol0>Woo0014Ool2001^Ool00`00Oomoo`0FOol00`00Oomoo`0iOol0049o
o`80071oo`03001oogoo01Moo`03001oogoo03Qoo`00?goo0`00LWoo00<007ooOol05goo00<007oo
Ool0>7oo000mOol2001eOol00`00Oomoo`0HOol00`00Oomoo`0gOol003Yoo`<007Moo`03001oogoo
01Uoo`03001oogoo03Ioo`00>7oo0P00NWoo00<007ooOol06Goo00<007ooOol0=Woo000fOol2001l
Ool00`00Oomoo`0JOol00`00Oomoo`0eOol003=oo`<007ioo`03001oogoo01Yoo`03001oogoo03Eo
o`00<Goo0P00PGoo00<007ooOol06goo00<007ooOol0=7oo000^Ool30023Ool00`00Oomoo`0LOol0
0`00Oomoo`0cOol002aoo`8008Ioo`03001oogoo01aoo`03001oogoo03=oo`00:Woo0P00R7oo00<0
07ooOol07Goo00<007ooOol0<Woo000WOol3002:Ool00`00Oomoo`0NOol00`00Oomoo`0aOol002Eo
o`8008eoo`03001oogoo01ioo`03001oogoo035oo`008Woo0`00Sgoo00<007ooOol07goo00<007oo
Ool0<7oo000POol2002COol00`00Oomoo`0NOol00`00Oomoo`0`Ool001ioo`8009Eoo`03001oogoo
01moo`03001oogoo02moo`006goo0`00Ugoo00<007ooOol087oo00<007ooOol0;Woo000IOol2002J
Ool00`00Oomoo`0POol00`00Oomoo`0^Ool001Moo`8009aoo`03001oogoo025oo`03001oogoo02eo
o`005goo0P00W7oo00<007ooOol08Woo00<007ooOol0;7oo000GOol00`00Ool0002KOol00`00Oomo
o`0ROol00`00Oomoo`0/Ool001Moo`04001oogoo001eOolE000@Ool00`00Oomoo`0SOol00`00Oomo
o`0[Ool001Ioo`03001oogoo009oo`03001oogoo06]oo`L0000EGaaK6elLFa]O71cWFaaFne/LE_]K
75KkFaaFne/L7>MJneKJF_]FfU[k00D000]oo`03001oogoo02=oo`03001oogoo02]oo`005Woo00<0
07ooOol00goo00<007ooOol0IWoo100000iO?1cWFaaK6e/LFa]K75/KFaaK6e/L7>MJo5Kk0U[k015J
o5KkF_]Jne[lE_/LieKKF_]FfeKkE]]JneKKE_]FfQcW008000Uoo`03001oogoo02Aoo`03001oogoo
02Yoo`005Woo00<007ooOol017oo00<007ooOol0HGoo100002MO6ellFa]O?5lK7>MK6elLFa]O75/K
GaaK6elLFa/LieKkFaaFne/LE_]K75KkFaaFnacWE]YJneKJF_]FfU[kE]YJneJj7>MF^U[JE[X00P00
1goo00<007ooOol09Goo00<007ooOol0:Goo000FOol00`00Oomoo`05Ool00`00Oomoo`1MOol30000
55lkGa]O?5lKGc]O6ellGa/Lie/KFaaK6e/LFa]K75/KFaaK6acWE_/2F_/04E[lE_]Jne[kF_aFnacW
E]]JneKKE_]Ffe[kE]]FneKJ7>L01UKJ0P001Goo00<007ooOol09Goo00<007ooOol0:Goo000FOol0
0`00Oomoo`06Ool00`00Oomoo`1JOol20000<V<k7>MO?5/KGcaO6ellFa]O?5lKGc`LielLFa]O75/K
GaaK6elLFa]O71cWFaaFne/LE_]K75KkFaaFnacWE]YJneKJF_]FfU[kE]YJneJj7>MF^U[JE[YJfeJj
F]YF^U[KE[X20003Ool00`00Oomoo`0VOol00`00Oomoo`0XOol001Ioo`03001oogoo00Moo`03001o
ogoo05Moo`80000GGa]S6elK7>MO6ellGa]O>elKGcaO6elkGa/Lie/KFaaK6e/LFa]K75/KFa`Li`02
F_/04E[lE_]Jne[kF_aFne[k7>MJneKKE_]Ffe[kE]]FneKJ7>L02UKJ00HLieZj000007oo000YOol0
0`00Oomoo`0WOol001Eoo`03001oogoo00Uoo`03001oogoo05Aoo`80000jHc]O6V<kGaYS>acWGcaO
6ellFa]O?5lKGcaK6ell7>MO75/KGaaK6elLFa]O75/K7>MFne/LE_]K75KkFaaFne/L7>MJneKJF_]F
fU[kE]YJneJj7>MF^U[JE[YJfeJjF]YF^U[KE[YJfQcWF[YF^EZjE[T2000YOol00`00Oomoo`0WOol0
01Eoo`03001oogoo00Yoo`03001oogoo055oo`80000MGa]S6elKHa]O6f<KGa/LielKGc]O6ellGa]O
>elKGcaO6acWFa]K75/KFaaK6e/LFa/Lie[kF_aFn`02F_/03E[lE_]JnacWF_]FfeKkE]]JneKKE_]F
fQcW00UFfP8Li`06F[YF^EZiE[UJ^UJi0`00:7oo00<007ooOol09Woo000EOol00`00Oomoo`0;Ool0
0`00Oomoo`1>Ool20000@f<kGaYS>elJHc]O6V<kGaYS>acWGcaK6ellGa]O?5/KGcaO6ell7>MO75/K
GaaK6elLFa]O71cWFaaFne/LE_]K75KkFa`Lie[kE]YJneKJF_]FfU[kE[XLieJjF]YF^U[KE[YJfUJj
F]]F^QcWE[UJ^UJiF[YF^EZjE[UJ^P00F[YF^@0002Moo`03001oogoo02Ioo`005Goo00<007ooOol0
37oo00<007ooOol0Bgoo0P0001mO6acWGa]S6elKHa]O6f<KGa]S6elKHa/LiellGa]O>elKGcaO6elk
7>MK75/KFaaK6e/LFa]K71cWF_aFn`02F_/03E[lE_]Jne[k7>MFfeKkE]]JneKKE_]FfQcW00UFfP0?
7>MF^EZjE[UJ^EJiF[YF^EZiE[UJ^P007>MJ^@0002Moo`03001oogoo02Eoo`005Goo00<007ooOol0
3Goo00<007ooOol0B7oo0P0003MS6UlJHaYO6QcWGaYS>elJHc]O6V<kGaYS>elJ7>MO6ellFa]O?5lK
GcaK6acWFa]O75/KGaaK6elLFa/LieKkFaaFne/LE_]K75Kk7>MFfU[kE]YJneKJF_]F^QcWE[YJfUJj
F]]F^U[JE[YJf`027>L02EJiF[YF^EZjE[UJ^UJiF[YF^@027>L01000F[QJ^@00:7oo00<007ooOol0
97oo000EOol00`00Oomoo`0>Ool00`00Oomoo`15Ool20005HaX076<K7>MS6elKHa]O6f<KGa]S6elK
Ha/LielkGa]O?5lKGc]O6ell7>MK75/KFaaK6e/LFa/LieKk0U[k00eJo5KkF_]JnacWE]]FneKKF_]F
feKkE]XLi`08E]X04acWF[UF^EZjE[UJ^EJiF[YF^EZiE[TLieZhF[T005ZiF[QJ^@0002Moo`03001o
ogoo02Aoo`005Goo00<007ooOol03goo00<007ooOol0@Woo0P000f<J041O6V<JHaYS6UlJ7>MO6V<k
GaYS>elJHc]O6V<kGaXLie/KGcaO6ellFa]O?5lK7>MK6elLFa]O75/KGa`Lie/LE_]K75KkFaaFnacW
E]YJneKJF_]FfU[kE]XLieJjF]YF^U[KE[YJfUJjF]/LieZjE[UJ^UJiF[YF^EZjE[UJ^P8Li`09F[QJ
^EZh001J^5ZiF[QJ^@00015oo`d000Uoo`03001oogoo02=oo`0057oo00<007ooOol04Goo00<007oo
Ool0?goo0P002V<J01UO6acWGa]S6elKHa]O6f<KGa]S6acWGcaO6elkGa]O?5lKGc/Lie/LFa]K75/K
Fa`Li`02F_/03E[lE_]Jne[kF_`LieKkE]]JneKKE_]FfacW00MFfP0>F[XLieZiE[UJ^UJiF[UF^EZj
E[UJ^AcWF[UJ^0=J^@06001J^EZiF[UJ^0003Goo100000Y[_1cWIkaS_6NmHkaW_6>lIkdLi`=SW@@0
00Ioo`03001oogoo029oo`0057oo00<007ooOol04Woo00<007ooOol067oo20007Goo00<006;j7>L0
0f<J00EO6V<JHaYS6UlJ00=S6P0]7>MS>elJHc]O6V<kGaYS>elJ7>MO6ellFa]O?5lKGcaK6acWFa]O
75/KGaaK6acWE_]K75KkFaaFne/L7>MJneKJF_]FfU[kE]XLieJjF]YF^U[KE[YJfUJj008Li`08F[YF
^EZjE[UJ^UJiF[YF^@8Li`0=F[UJ^5ZiF[QJ^EZh001J^5ZiF[QJ^EZh000027oo100001AW^f^lIk][
_6>l7>MS_6NmHkaW_F>lIkdLif>MGiaSWEnLHieOW1cW1goo00<007ooOol08Woo000DOol00`00Oomo
o`0COol00`00Oomoo`0AOol60002B[`00acWBY]6V`03BY/8000DOol01000H_URnAcW2f<J01YS6acW
Ha]O6f<KGa]S6elKHa/LielkGa]O?5lKGc]O6acWFa]K75/KFaaK6acWF_]Jo5Kk0U[k00UJo1cWE_]F
fe[kE]]FneKK7>L01eKJ00/LieJiF[UF^EZjE[UJ^EJiF[YF^AcW009J^@0:F[QJ^EZiF[UJ^5Zi001J
^EZhF[T27>L00`00Oomoo`03Ool3000041cWIka[_6NlJkaW_6^lHk`Lif>lIkeS_6NlHkaW_AcW0f>M
00ASW6>M7>LLi`Uoo`03001oogoo025oo`0057oo00<007ooOol057oo00<007ooOol02goo1@0001A:
_4ZkB[a6^dZlB[]:_4Jk7>M6VdZKAY]:VdJKBY]6VdZKAY]:VacW0TYj1P0037oo0P0000IRnUkiH_YR
nAcWGaX3HaX01ElJHaYS6V<JGaX00V<J03<LielJHc]O6V<kGaYS>elJ7>MK6ellGa]O?5/KGc`LielL
Fa]O75/KGa`Lie/LE_]K75KkFa`Lie[kE]YJneKJF_]FfQcWE[YJfUJjF]]F^U[JE[XLieJiF[YF^EZj
E[UJ^UJiF[X00QcW00]J^5ZiF[QJ^EZhF[UJ^5ZiF[P005Zh008Li`05G[QJV000001oo`03000066nk
JkY_^acWJkaW^f^lIk][_6Nk7>MS_6NmHkaW_F>lIkdLif>MGiaSWEnLHidLi`]oo`03001oogoo025o
o`0057oo00<007ooOol05Goo00<007ooOol017oo1P0000=>g4[L7>L02TZl00DLidZKBY]:VdJK00=:
V`03AY]:VacW00U:NP@000Moo`03001RnF;i00ERn@037>MS6V<J00QS6P0G7>MS6elKHa]O6f<KGa]S
6acWGcaO6elkGa]O?5lK7>MK6e/LFa]K71cWF_aFn`02F_/02E[lE_/LieKKF_]FfeKkE]/Li`06E]X0
2EJi7>MF^EZiE[UJ^UJiF[UF^@027>L3F[T01EZhF[UJ^EZiF[P00eZi00L001cWF[QN^5ZhG[QJ^002
000056nkJk]_^f^kKk/Lif^lIka[_6NlJkaW_1cWHkaW_F>lIkaS_6Nm7>L3Hid00f>LHidLi`0=Ool0
0`00Oomoo`0POol001Aoo`03001oogoo01Ioo`03001oo`0000<0000NB]a>gD[LC]a:g4kMB]a>g1cW
B[a:^dZlA[]:_4ZkB[a6^dZlB[/LidJKBY]6VdZKAY]:VdJKBY]6VacW0TYj00E6NTYjBWY:NTIj00=:
NP037>M>FDYI00@0009oo`0<001RnF;jG_URnV;iH_YNnF;jH_TLielJ0f<J02aO6V<JHaYS6UlJHaXL
if<kGaYS>elJHc]O6QcWGa]O?5/KGcaO6ell7>MO75/KGaaK6acWE_]K75KkFaaFnacWE]YJneKJF_]F
fQcWE[YJfUJjF]]F^U[J0QcW01=F^EZjE[UJ^UJiF[YF^AcWF[QJ^EZhF[UJ^5ZiF[QJ^EZhF[UJ^002
7>L01@00FYQN^5ZHG[P00`0001Q_^f^jKk][^VnkJkXLifNkJkaW^f^lIk/Lif>lIkeS_6NmHkaSWAcW
HieOW6>MGi`27>L?Ool00`00Oomoo`0OOol001=oo`03001oogoo01Moo`80000>D_a>g1cWB]a>g4[L
C]a:g4kLB]a>g4[LC]`Li`U:_0037>M:VdJK00=:V`04AY]:VdZK7>L;BWX01AcWBUU:FDYICUT00TYI
0`002V;i00<Lif<JHaX01f<J01@LielKHa]O6f<KGa]S6acWGc]O6ellGa]O>elK7>MK6e/LFa/LieKk
0U[k00UJo5Kk7>MFfe[kE]]FneKK7>L01UKJ00PLieZjE[UJ^EJiF[YF^EZi0QcW00EJ^5ZiF[UJ^EZh
00=J^@09F[QJ^AcW7>MJ^5jh001N^5Zh0080000DG[QJ^5jh001_^f^kKk][^acWIka[_6NlJkaW_1cW
HkaW_F>lIkaS_08Li`=SW@03Hi`Ligoo011oo`03001oogoo01moo`004goo00<007ooOol057oo0`00
02E>g5;mC]aBo1cWC]e:g4kLB]a>gD[LC]a:g4kMB]`LidJkB[a:^dZlA[]:_4ZkB[`LidZKAY]:VdJK
BY]6VdZKAY]:VacWBWY6NP03BWX034IjBWY:NTYjAWXLidYICUU:FDiIBUU>F@800003BUU>F@000080
000:H_YNnF;jH_URnUkiH_YRnAcWGaX3HaX0>elJHaYS6V<JGaXLielJHc]O6V<kGaYS>acWGcaO6ell
Fa]O?1cWGaaK6elL7>MK75KkFaaFnacWE]YJneKJF_]FfQcWE[YJfUJjF]]F^UZj7>MJ^UJiF[YF^EZj
E[UJ^QcWF[UJ^5ZiF[QJ^EZhF[UJ^5ZiF[P00QcW00AN^5ZHG[QJV0<0000LFYQN^5ZHG[QJV000JkY_
^f^jKk/Lif^lIk][_6NkIkdLifNmHkaW_F>l7>MOW6>MGiaSWEnL7>LCOol00`00Oomoo`0NOol001=o
o`03001oogoo019oo`80000CC]a>o4kLD_a>g4klC]aBo1cWC]a:g4kLB]a>g4[LC]a:g4kL7>L024Zl
00<LidJKBY/00TZK00I6VdZKBY]:VdJK7>L9BWX01AcWOom:FDYICUT00TYI00<006;I7>L00TYI00<L
idiHH_T00P001f;i00<Lif<JHaX01V<J014Lif<KGa]S6elKHa]O6acWGa]O>elKGc`Lie/LFa]K71cW
009Jn`09F_aFne[k7>MJneKKE_]FfacW00EFfP8Li`06F[YF^EZiE[UJ^UJi0QcW00=J^EZhF[T00UZi
00AJ^5ZiF[UJ^@8Li`05F[QN^5ZhG[QJ^00200003ejhF[QN^5ZhG[QJ^1cW001_^f^kKk/Lif^lIka[
_002Ik`01acWIkeS_6NlHk`Lif>L00=SW@8LiaEoo`03001oogoo01eoo`004goo00<007ooOol047oo
0P0002QBoDkLD_a>g5;mC]aBo4kLD_e>g1cWB]a>gD[LC]a:g4kMB]a>g4[L7>M:^dZlA[]:_4ZkB[a6
^dZl7>M:VdJKBY]6VdZKAY]:VdJK7>M6NP=:NP0BAWY:NTYjBWY6NTYj7>M>FDYICUU:FDiI001RfDYI
CUU:FAcW0diH00aBF6;i000006;jH_URnUkiH_YRnAcWGaX3HaX04UlJHaYS6V<k7>MS>elJHc]O6V<k
7>MO?5/KGcaO6acWFa]O70Ql000KE]YJneKJ7>MF^U[JE[YJfeJj7>MF^EZjE[UJ^UJiF[YF^AcWF[QJ
^EZhF[UJ^5ZiF[QJ^EZh008Li`05G[QJV5jhFYQN^00200001UZH001JV5jhFYQN^08Li`0EG[L006^j
Kk]W^acWIk][_6NkIkdLifNmHkaW_F>l7>MOW6>MGiaSWAcW01Moo`03001oogoo01eoo`004goo00<0
07ooOol04Goo01LLidkLC_a>g5;lC]a>o4kLD_a>g4klC]`Lid[LC]a:g4kLB]a>g4[LC]a:g1cW00M:
_0047>M:VdZKAY/3BY/00dJKBY/Li`09BWX011cWOom:FDiI0TYI00<006;IBUT00TYI00=>FAcWCUP0
1DiH00=Rn@00H_T01F;i00<Lif<JHaX01F<J00XLielKHa]O6f<KGa/LielKGcaO6`Al00Qoo`9l0003
7>Ml05KJ009FfP08E[TLieJiF[YF^EZiE[UJ^P8Li`9J^@06F[QJ^EZiF[UJ^5Zi0QcW00EJ^5jhF[QN
^5Zh008000057>MJ^5jh001N^0037>L04V:hG[MN]`00Kk][^acWIka[_6NlJk`LifNmHkaW_6>l7>MS
W0=SW@037>Moogoo01Moo`03001oogoo01aoo`004goo00<007ooOol04Woo02HLidkLD_e>g5;lC]aB
oDkLD_a>g5;mC]`Lid[LC]e:g4kLB]a>gD[LC]`LidZlB[]:_4JkB[a:^dZl7>M:VdJKBY]6VdZKAY]:
VacW0dYj01=6NTYjBWY:NTIjBWXLidiIBUU>FDYICUT006;IBUU>FDYICUTLi`02CUP01E9HCUQ>F4iH
DUP00TiH0P0000MRnF;jG_URnQcWHaYO6P03HaX02UlJHaXLif<kGaYS>elJHc/Liell0W`047oo0g`0
010LieJiF[YF^EZjE[UJ^QcWF[UJ^5ZiF[QJ^EZhF[UJ^08Li`05G[QJV5jhFYQN^00200007EZHG[QJ
V5jhFYP001cWH[QN]f:hG[MR^5jg001[^QcWIk][_6NkJk`LifNmHkaW_F>l7>MOW6>MGi`00QcW6Woo
00<007ooOol077oo000BOol00`00Oomoo`0DOol05AcWC]a>o4kLD_a>g4klC]aBo4kLC_`LidkLB]a>
g4[LC]a:g4kLB]`Li`07B[`00acWAY]:V`02BY/014JKBY]:VacW2DYj00<LigooCUT00dYI00H005kH
BUU:FDiI7>L<CUP00`00H_URn@02H_T00acWHaYS6P05HaX01acWHa]O6f<KGa/Lig`001Eoo`05O01J
^UJiF[UF^@027>L3F[T015ZhF[UJ^EZi0QcW00aJ^5jhF[QN^5ZhG[P005jhF[QN^5ZhG[P27>L01000
KiYN]f:h0ejg00iR^000Kk/Lif^lIka[_1cWIkeS_6NlHk`Lif>L0V>M00<LigooOol06goo00<007oo
Ool06goo000BOol00`00Oomoo`0EOol09QcWC]aBoDkLD_a>g5;mC]aBo4kLD_dLidkLB]a>gD[LC]a:
g4kM7>M:_4JkB[a:^dZlA[]:_1cWBY]6VdZKAY]:VdJKBY/LidYjAWX3BWX03dIjBWY:NQcWBUUoodYI
CUU:F@00G]Q>FDYICUTLi`02CUP01E9HCUQ>F4iHDUP00diH00aBF4iH7>M>E`00H_URnUkiH_XLif<J
GaX3HaX01UlJ7>MO6V<kGaYl01Qoo`9l0009E[TLieZhF[UJ^5ZiF[QJ^EZh008Li`06G[QJV5jhFYQN
^5ZH0P0000=N^5ZHG[P00acW01UR^5jg001N]f:hG[MR^5jgH[QN]`007>M[_6NkJk`LifNmHkaW_F>l
7>MOW6>MGi`Li`0OOol00`00Oomoo`0JOol0019oo`03001oogoo01Ioo`0C7>M>g4klC]aBo4kLC_a>
g5;lC]`Lid[LC]a:g4kLB]a>g4[L7>L01dZl00@LidZKBY]6V`=:V`037>M:NTYj00I:NP037>M:FDiI
00=:F@04001Nf4YIBUT27>L;CUP27>L3DUL00`00H_URn@02H_T00acWHaYS6P04HaX00acWO01l000K
Ool00g`0F[QJ^@02F[T02UZhF[TLiacWF[QN^5ZhG[QJ^5jh0P0000=J^5jhF[P00QcW00=_FEjgH[P0
0ejg00D005jgG[MN]f:h009N]`0<000LifNlJk`LifNmHkaW_6>l7>MSW6>M0QcW87oo00<007ooOol0
6Woo000BOol00`00Oomoo`0GOol08QcWC]aBoDkLD_a>g5;mC]aBo4kL7>M:g4kLB]a>gD[LC]a:g1cW
B[]:_4JkB[a:^dZl7>M:VdJKBY]6VdZKAY/LidIj0dYj00i6NTYjBWY:NQcWCUUoodiIBUT005kHCUU:
FAcW0diH00EBF4iHCUQ>F59H00=>F008DUPLie9HCUMBF59GDUQ>E`800006H_YNnF;j7>MS6UlJ0f<J
00<LigooOol077oo00Al05ZhF[UJ^08Li`0:G[QJV5jhFYQN^5ZHG[P005jhFYP37>L03EjgH[QN]f:h
G[MR^5jgH[P006:hG[MR^5jg008Li`07001W^f^l7>MW_F>lIkd00QcW00=OW6>M7>L08goo00<007oo
Ool06Goo000BOol00`00Oomoo`0HOol04QcWC]a>o4kLD_a>g4klC]aBo4kL7>M:g4kLB]a>g4[LC]`L
i`I:_0037>M6VdZK009:V`03AY]:VacW00M:NP037>M>FDYI009:F@03001N^1cW008Li`a>F0037>MB
Ee9G00MBE`05001RnF;iH_TLi`03HaX00g`0Oomoo`0MOol02g`0F[TLiacWF[QN^5ZhG[QJ^5jhF[P0
0P000acW00I_FF:hG[MN]fmIH[P3G[L01V:hG[L005jgH[QN]`8Li`0<H[L006^lHk`Lif>lIk`Lif>M
HiaSWAcW9Goo00<007ooOol067oo000BOol00`00Oomoo`0IOol07QcWC]aBoDkLD_a>g5;mC]aBo1cW
C]e:g4kLB]a>gD[L7>M6^dZlB[]:_4JkB[`LidZKAY]:VdJKBY/Li`=:NP0>AWY:NTYjBWY6NQcWBUUo
odYICUT005jhG[LLi`=>F005DUQ>F4iHCUQBF003CUP27>L04U9HCUMBF59GDUQ>Ee9HDUMBF4iGDUP0
06;jG_URnQcWHaYl025oo`0KO01N^5ZHG[QJV5jhFYQN^5ZH001[5f:hG[MR^5jgH[QN]g=iG[MR^5jg
H[QN]f:hG[MR^00000<Li`0;H[IV]`00JkaW^acWHkaW_AcWHieOW0027>LVOol00`00Oomoo`0HOol0
019oo`03001oogoo01Yoo`0@7>M>g4klC]aBo4kLC_a>g5;l7>M>g4[LC]a:g4kL7>L6B[`011cWBY]:
VdJK0TZK00<LidYjBWX01DYj00HLidYIBUU:FDiI0002G[P00diI7>M>F009CUP00acWDUMBE`0<DUL0
1@00H_URnF;iO0008goo00Yl05jhF[QN^5ZhG[QJ^000G[MR^0=N]`05H[QN]ejgG[MR^003G[L47>L0
0`00H[MR]`03H[L02@00Ik`Lif>lIk`Lif>MHi`Li`0YOol00`00Oomoo`0GOol0015oo`03001oogoo
01aoo`0K7>M>g5;mC]aBo4kLD_e>g1cWB]a>gD[LC]a:g4kM7>M:_4JkB[a:^acWAY]:VdJKBY]6VacW
009:NP0>AWY:NTYjBWY6NQcWBUU>FGooCUU:F@00G[M>F@=>F005DUQ>F4iHCUQBF003CUP03QcWDUMB
F4iGDUQBEe9HCUMBF59GDUQ>Ee9HDUL27>L015IG001RnW`09Goo00Al05jhFYQN^08Li`0;G[MR^5jg
H[QN]f:hKeQR^5jgH[QN]`037>L03f:gI[MR]VJg001V]f:fI[MR]fJg000Lif>lO00Li`02O0000acW
Oomoo`0XOol00`00Oomoo`0GOol0015oo`03001oogoo01eoo`0?7>M>g4klC]aBo4kLC_a>g1cWB]a>
g4[LC]a:g1cW00A:_0037>M:VdJK00=:V`037>M:NTYj00E:NP067>M:FDYICUU:F@000Ujh2TiH0QcW
359G0QcW0UIG00=FEP00O0009goo00=l01cW7>L00Ujg00ER^5jgG[MN]flh00=N]`03H[PLiacW00MR
]`03001R]f:g00=R]`03001l07`0031oo`03001oogoo01Ioo`004Goo00<007ooOol07Woo01XLidkL
D_e>g5;lC]aBoDkL7>M:g4kMB]a>g1cWB[a:^dZlA[/LidJKBY]6VdZKAY/LidIj0dYj00Y6NTYj7>M>
FDYICUU:FDiI001N^0=>F005DUQ>F4iHCUQBF002CUP05QcWDUQBEe9HCUMBF59GDUQ>Ee9HDUMBF4iG
DUPLieIGDUIFEe9FEUMBEP009goo00]l05jgH[QN]f:hG[MR^6/GH[QN]f:h00<Li`0?I[MR]VJgH[MV
]f:fI[MR]fJg001V]f:gI[MR]P0003Aoo`03001oogoo01Eoo`004Goo00<007ooOol07goo00dLidkL
C_a>g5;lC]a>o1cWC]a:g4kLB]`Li`04B[`01QcWBY]:VdZKAY/Li`I:NP047>M:FDYICUT2BUT00`00
G[Q>F008CUP27>L<DUL27>L3EUL01UIFEUMFEeIGEUH002Ioo`04001N]ejgH[P3G[L016:hG[LLiacW
36:g00<006:gH[L00V:g00<007ooOol0<Woo00<007ooOol05Goo000AOol00`00Oomoo`0POol05QcW
C]aBoDkLD_a>g5;m7>M>g4[LC]e:g1cWA[]:_4Zk7>M6VdZKAY]:VacW0dYj00Y6NTYjBWXLidYICUU:
FDiIBUT000=>F00CDUQ>F4iHCUQBF4iH7>M>Ee9HDUMBF4iGDUQBEe9HCUMBF59GDUP00QcW00aBEUIG
DUIFEe9FEUMBEUIGDUIFEe9F000TOol01`00J_Ml06:hG[M_>5jg00<Li`0?H[IV]f:gI[MR]VJgH[MV
]f:fI[MR]fJgH[IV]`0000@Li`03001oogoo03=oo`03001oogoo01Aoo`004Goo00<007ooOol08Goo
00`LidkLC_a>g5;lC]`Lid[LC]a:g7`07>L3O0001AcWO016VdZK7>L01TYj00<LidYICUT00dYI00<0
05ZG7>L01diH00DLie9GDUMBEejh00QBE`037>MFEeIF00=FE`05EUIFEeIGEUMFEP03EUL00`00Oomo
o`0QOol01@00J_MZmg`0G[L00acW3V:g0acW00D006:gJ]MVeP0003Moo`03001oogoo01=oo`0047oo
00<007ooOol08goo00LLidkLD_e>g5;lC]`Li`02O0000goo001oo`04Ool4O00034YjAWY:NTYj7>M:
FDiIBUU>FDYICUT0009>F00BDUQ>F4iHCUQBF4iH7>M>Ee9HDUMoodiGDUQBEe9HCUMBF59G0QcW011F
Ee9FEUMBEUIGDUIFEe9FEUMBEUIGDUIFEe9F7>L0025oo`0D001ZmfKfJ_Ml01cWH[IV]f:gI[MR]VJg
H[MV]f:fI[MR]fJgH[IV]`<Li`08I[MVeV[G001ZefKFJ]L003Moo`03001oogoo01=oo`0047oo00<0
07ooOol097oo00<LidkLC_`00W`01Goo00<007ooOol01Woo0W`00TYj00<LidiIBUT00TYI00=>F@00
CUP01TiH0QcW0e9G00=N^59GDUL01E9G00@LieIGEUMFEP=FE`05EUIFEeIGEUMFEP03EUL27>L00eYF
001oo`0OOol00`00J_MZm`02J_L00g`0H[MR]`0:H[L37>L2I]H01F[GI]IVeVKF00000VKF00<007oo
Ool0=goo00<007ooOol04Woo000@Ool00`00Oomoo`0UOol00acWO01oo`07Ool00`00Oomoo`07Ool2
O0002DiIBUU>FDYICUTLi`00CUQBF003CUP03E9H7>MBF4iGDUQBEejGCUMBF59GDUQ>Ee9H008Li`0=
DUIFEe9FEUMBEUIGDUIFEe9FEUMBEUIGDUH00QcW00EJEUIFFUIFEP0001ioo`0?001ZmfKfJ_MZmV[g
I_Il06:gI[MR]VJgH[MV]f:f00@Li`0=J]MVeV[GI]IZefKFJ]MVeV[G001ZefKF0000>Goo00<007oo
Ool04Woo000@Ool00`00Oomoo`0`Ool00`00Oomoo`08Ool2O0000dYICUTLi`07CUP00acWDUMBE`02
DUL00eZGDUMBE`03DUL27>L3EUL01EIFEUMFEeIGEUH00eIG00AFEUIG7>LLi`IJEP03001oogoo01]o
o`03001Zmf[g00EZm`04O01R]f:gH[L47>L3I]H01F[GI]IVeVKFJ]L00fKF00EZefKF001VeP0003Yo
o`8001=oo`0047oo00<007ooOol0<Goo00<007ooOol02Goo0W`00TiH01iBF4iHCUQ>F59H7>MBF4iG
DUQBEe9HCUMBF59GDUQ>EacWDUIFEe9FEUMBEUIGDUIFEe9FEUMBEUIGDUH27>L02UYFEUIJEUIFFUIF
EUYFEUIJEP006goo00X006[gI_IZmf[fJ_MVmV[gJ_Il00<Li`0DJ]MVeV[GI]IZefKFJ]MVeV[GI]IZ
efKFJ]MVeV[GI]IZe`00J]L003Moo`<00003Ool007oo019oo`0047oo00<007ooOol0<Woo00<007oo
Ool02Woo00=l0000CUP00TiH0QcW2E9G0QcW00EFEUIGEUMFEeIF00=FE`04EUIFEeIGEUL27>L2FUH0
0g`0FUIJEP06FUH00`00Oomoo`0HOol00`007>LLi`07J_L00g`0J]MVeP02I]H01F[GI]IVeVKFJ]L0
0fKF00EZefKFI]IVeV[G00=VeP8003Eoo`<000Aoo`03001oogoo015oo`0047oo00<007ooOol0<goo
00<007ooOol02Woo0W`001U>F1cWDUMBF4iGDUQBEe9HCUMBF59GGYLLieIGDUIFEe9FEUMBEUIGDUIF
Ee9FEUMBEP027>L03UYFEUHLiacWFUIFEUYFEUIJEUIFFUIFEUYF000IOol01000I[IVmV[g0QcW01QV
mV[gJ_IZmfKfO01VeV[GI]IZefKFJ]MVeV[GI]IZefKFJ]MVeV[GI]IZefKFJ]L37>L00`00Oomoo`0`
Ool30007Ool00`00Oomoo`0AOol000moo`03001oogoo03Eoo`03001oogoo00Uoo`03000Lig`000QB
E`05FYLLiacWEUMFEP03EUL01EIFEUMFEeIGEUH00acW45YF00<007ooOol05Goo00<006JfI[H00VJf
0V[g00<Lif[gJ_L00f[g00=l06KFJ]L00fKF00EZefKFI]IVeV[G00LLi`9^mP8002moo`<000]oo`03
001oogoo011oo`003goo00<007ooOol0=Woo00<007ooOol027oo00X005YgEUIl04iGDUQBEe9HCUMB
F08Li`0:DUIFEe9FEUMBEUIGDUIFEe9FEUL27>L055IFFUIFEUYFEUIJEUIFFUIFEUYFEUIJEUIFFUIF
EUYFEUIJEQcW000GOol00`00H[IV]`02I[H00f:fI[MZmP027>L01f[gJ_IZmg`0J]MVeV[G00LLi`09
K_IZmFkfJ_I^mV[eK_IZmVkf008002aoo`<000ioo`03001oogoo011oo`003goo00<007ooOol0=goo
00<007ooOol01goo00@005IFEUMFE`9l009BE`8Li`=FE`05EUIFEeIGEUMFEP02EUL27>L@FUH47>L0
0eif001oo`0EOol00`00I[IV]P07I[H01F[g7>MZmf[gO0000acW3fkf00<007oo0000:Goo0`004Goo
00<007ooOol047oo000?Ool00`00Oomoo`0hOol00`00Oomoo`06Ool01P00FWMFEUYgEUIJM`8Li`0:
DUIFEe9FEUMBEUIGDUIFEe9FEUL27>L03eIFFUIFEUYFEUHLieIFFUIFEUYFEUIJEUIFFUIFEP037>L0
1UYEGWIJEEifFUD001Eoo`03001R]VJg009V]P06H[IV]fJfI[IR]VJg0VJf0QcW01=l06kfJ_E^mV[f
K_IZmFkfJ_I^mV[eK_IZmVkfJ_E^mV[fK_H00002Ool00`00Oomoo`0SOol4000DOol00`00Oomoo`0@
Ool000moo`03001oogoo03Uoo`03001oogoo00Aoo`05001FEeIGFUMFEP02EUL01UYGO01FEeIGFUMF
EP=FE`03EUHLiacW00mJEP8Li`09GWENMUieGWINMEifGWENMP0001Aoo`03001V]VJf00eV]P03O01^
mVkf00m^mP04001oogoo000ROol3000HOol00`00Oomoo`0@Ool000moo`03001oogoo03Yoo`03001o
ogoo00=oo`0?001FEUYgEUIJMeIFFWMFEUIGO01FEe9FEUMBEUIG008Li`0>EUIJEUIFFUIFEUYFEUIJ
EUIFFUIFEUYFEUIJEP<Li`0;GWIJEEifFUENMUYEGWIJEEifFUD0000DOol01P00I[MV]VJfH[IV]`9V
]P06H[IV]fJfI[IR]VJg0VJf019l06kfJ_I^mV[eK_IZmVkfJ_E^mV[fK_IZmFkfJ_I^mV[e0003Ool0
0`00Oomoo`0MOol3000KOol00`00Oomoo`0@Ool000ioo`03001oogoo03aoo`03001oogoo009oo`03
001JEeIF009FE`06FUMFEUIGEUMl05IF0UIG0QcW3EYF0acW00mNMUieGWINMEifGWENMUieGWINMEif
GWENMUie00004Woo00<001cWI[H03VJf00=l06kfK_H03Vkf00D007ooOomoo`0001aoo`<001ioo`03
001oogoo011oo`003Woo00<007ooOol0?Goo00l007ooOomoo`00EUIJMeIFFWMFEUYgEUIJMeIFO000
0QcW00eFEUYFEUIJEUIFFUIFEUYFEUIJEUIFFUIFEP027>L04UifFUENMUYEGWIJEEifFUENMUYEGWIJ
EEifFUENMUYEGWH0019oo`03001NMAcW00<Li`03I[IR]VJg009V]P07H[IV]fJfI[IR]VJgO0003acW
00<007ooOol00Woo00<007ooOol05goo0`008Goo00<007ooOol047oo000>Ool00`00Oomoo`0nOol0
1000Oomoo`002QcW00=l05YFFUH02EYF0acW01ANMEifGWENMUieGWINMEifGWENMUieGWINMEifGWEN
MUieGWINM@004Goo00<006:FHYH00f:F00AV]QcW7>LLi`QV]P0@O01c5GLeLaEg=G<EMcEc5GLeLaEg
=G<EMcEc5GLe0005Ool00`00Oomoo`0DOol3000UOol00`00Oomoo`0?Ool000ioo`03001oogoo03mo
o`0F001oo`00DSIF=e8fESMB=UHgDSIF=e8fESMl05YFEUIJEUIFFUIFEUYFEUH37>L05eYEGWIJEEif
FUENMUYE7>MJEEifFUENMUYEGWIJEEifFUENMUYEGWIJEEif00004Goo00X006:FGWERUUieHYINMF:F
GWEV]P<Li`03I[IR]VJg009V]P0?O01g=W<EMcEc5GLfLaEg=G<EMcIc5GLeLaEg=P0000Ioo`03001o
ogoo015oo`<002Qoo`03001oogoo00moo`003Woo00<007ooOol0@7oo00<007oo00000e8f00EB=e8f
DSIB=U8g009B=P03O01JEUYF00=JEP8Li`0GGWENMUieGWINMEifGWENMUieGWINMEifGWENMUieGWIN
MEifGWENMUieGWINM@027>L00`00Oomoo`0>Ool00`00HYIRUP0:HYH00fJf7>LLi`027>L047`0McEc
5GLeLaEg=G<EMcEc5GLeLaEg=G<EMcEc5@001Woo00<007ooOol03Woo0`00:goo00<007ooOol03goo
000>Ool00`00Oomoo`11Ool200003EHgDSIF=e8fESMB=UHgDSIF=e8fO01FEUYF00<Li`0EGWIJEEif
FUENMUYEGWIJEEifFUENMUYEGWIJEEifFUEl05YEGWIJEEif00@Li`03GWERUP00011oo`0?001NMF:F
GWERUUieHYINMF:FGWERUUieHYINMF:F009V]P0@H[Il01cWMcEc5GLfLaEg=G<EMcIc5GLeLaEg=W<E
0007Ool00`00Oomoo`0;Ool3000^Ool00`00Oomoo`0?Ool000ioo`03001oogoo049oo`03001B=U8g
00=B=P0LDSMB=U8fDSIB=e8fO00LieifGWENMUieGWINMEifGWENMUieGWINMEifGWENMUieGWINME8f
O0047>L6HWD00`00Oomoo`0=Ool00`00HYIRUP0@HYH03W`0McEc5GLeLaEg=G<EMcEc5G`0LaEg=G<E
0008Ool00`00Oomoo`08Ool3000aOol00`00Oomoo`0?Ool000eoo`03001oogoo04=oo`0M001F=e8f
ESMB=UHgDSIF=e8fESMB=UHgO01NMUYEGWIJEEifFUENMUYEGWIJEEifFUENMUYEGWIJE@037>L03E8f
O01RMF:EGWERUV9eHYENMF:FHWERU@0000moo`0D001RUUieHYINMF:FGWERUUieHYINMF:FGWERUUie
HYINMF:FGWEl008Li`0:LaEg=G<EMcIc5G`0LaEg=W<E0009Ool00`00Oomoo`05Ool3000dOol00`00
Oomoo`0?Ool000eoo`03001oogoo04Aoo`04001B=U8fDSL3DSH04E8gDSIB=U8fDSMl05ifGWENMUie
GWINMEifGWENMUieGWH011cW0f9e00<Lig`0HWD02F9e00<007ooOol037oo00<006:FHYH04F:F00=l
07]dNe<01AcW00El07LeLaEg=@0000Uoo`03001oogoo009oo`<003Moo`03001oogoo00moo`003Goo
00<007ooOol0A7oo00T0058fESMB=UHgDSIF=e8fESL00acW00Ql05YEGWIJEEifFUENMUYE11cW01=R
UEieHYIRMF:EGWERUThFO01NMF:FHWERUEieHYIRMF:EGWD0000?Ool07@007>LLiacWHYINMF:FGWER
UUieHYINMF:FGWERUUieHYINMF:FGWEl07]COgAkDgmdNe=oM5ieO0000QcW00<007ooOol027oo00<0
07oo00000P00>goo00<007ooOol03Woo000=Ool00`00Oomoo`14Ool00`007>LLi`067>L4CQH00g`0
GWENMP047>L;HWD2CQH00g`0HWERM@06HWD00`00Oomoo`0=Ool01000GUENEEiF1QcW2V:F00Il07]d
Ne=kM7]CNg@2HYH00g`0Ng@0000:Ool3000nOol00`00Oomoo`0>Ool000eoo`03001oogoo04Eoo`04
001>5TXFCQL2CQH01dXFCQM>5ThFBQI>5g`0008Li`0KHYIRMF:EGWERUV9eHYENMF:FHWERUEieHYIR
MDhFBQI>5g`0HYENMF:FHWERUEieHYIRM@0000moo`0:001JEEifFUENMUYEGWIJEEifFUD77>L03Eie
HYINMG`0Ne=oM7]COgAkDf:FGWEl000000Qoo`<0009oo`03001oogoo03aoo`03001oogoo00ioo`00
3Goo00<007ooOol0AGoo00<004hFCQH02DhF00=l069eHWD03F9e1DhF00=l069eHWD01F9e00<007oo
Ool037oo00@005iEGUIJE@9NE@06GUIJEEiEGUENEUYE0UiE00ANEUYEGUERUP<Li`05O01kM7]CNgAk
D`03HYH00g`0001oo`03Ool40005Ool00`00Oomoo`0lOol00`00Oomoo`0>Ool000aoo`03001oogoo
04Moo`05001>5ThFBQI>5`02CQH05dXFCQM>5ThFO01RUV9eHYENMF:FHWERUEieHYIRMF:EGWERUV9e
HYE:5ThGCQH00QcW00El069eHYENMF:F00<Li`03001oogoo00aoo`0I001NMUYEGWIJEEifFUENMUYE
GWIJEEifFUENMUYEGWIJEEifFUENMUYEO01kDgmdNe<011cW00=l07ooOol00`002Goo00<007ooOol0
?7oo00<007ooOol03Woo000<Ool00`00Oomoo`17Ool00`00CQI>5P09CQH00g`0HWERM@0;HWD47>L0
0dGfBOIl00047>L3IYD00`00Oomoo`0<Ool01P00FUENEEiEGUIJE@9NE@06GUIJEEiEGUENEUYE0UiE
00iNEUYEGUENEEiFO00Lig]CNgAkDg]dGUENEW`00P0037oo00<007ooOol0?7oo00<007ooOol03Woo
000<Ool00`00Oomoo`18Ool01P00CQM>5ThFBQI>5`9>5P0>BQI>5dhFO01NMF:FHWERUEieHYIRMF:E
GWERUP@Li`08IYE9mTGfBOI5mTWfO01ZU@9VU@03IYAZU@0000moo`0N001NMUYEGWIJEEifFUENMUYE
GWIJEEifFUENMUYEGWIJEEifFUENMW`0NhmgKQcWFUENMUYEGWIJEG`03Woo00<007ooOol0?7oo00<0
07ooOol03Woo000<Ool00`00Oomoo`18Ool00`00CQI>5P08CQH017`0HWERMF9e1acW16JE0TGf00E9
mTGfAOI5mW`000EVU@03001oogoo00aoo`05001NEEiEGUIJE@02GUD01UiFFUENEEiEGUIJE@9NE@9o
o`9NE@03GUIJEG`0009kK`07FUENEEiEGUIJEEiEO0003Woo00<007ooOol0?Goo00<007ooOol03Goo
000<Ool00`00Oomoo`19Ool00`00BQI>5`02CQH00dXF7>LLi`027>L01G`07>LLiacWJYD00VJE00IV
U6ZEIYEVUFJDJYD2IYD034GfBOI5mTWfAOI9mTGfO01VU6ZEIYD000moo`0O001JEEifFUENMUYEGWIJ
EEifOomNMUYEGWIJEEifFUENMUYEGWIJEG`0MfikSg]^GWIJEEifFUENMUYEO0003Woo00<007ooOol0
?Goo00<007ooOol03Goo000<Ool00`00Oomoo`19Ool00`007>LLi`037>L3AOH00dWfO01VU@0;IYD0
0dGfIYE9mP03AOH014WfAOI5mW`00fJE00<007ooOol03Goo00<001cW7>L04AcW00=l07]_Nfl011cW
0UiE00=NEW`0Ool03Goo00<007ooOol0?Goo00<007ooOol03Goo000;Ool00`00Oomoo`1;Ool03000
BOI5mTWfAOI9mTGfBOI5mW`0IYAZU@9VU@0>IYAZUFJEIYEVU4WfAOIVUFJDJYE5mTWfAOI9mP<Li`04
O01VUFJE000@Ool06`00ESEJ=EHeFSIF=EXeESEJ=UHeFSEF=EXfESEJ=EHeFSIF=EXeESEl07]^FSEF
=EXfESEJ=@037>L00g`0Oomoo`0<Ool00`00Oomoo`0mOol00`00Oomoo`0=Ool000]oo`03001oogoo
04]oo`030015mTWf00=5mP05BOI5mTGfAOIl0005IYD2AOH5IYD2AOH37>L4?KH00g`0IYD0000@Ool0
1000ESEF=EXe0eHe00EJ=EHeESEF=EXe00=F=@06FSEF=EHeESDLig`00UHe00EJ=EHeESEF=EXe009F
=@03O01oogoo00aoo`03001oogoo03eoo`03001oogoo00eoo`002goo00<007ooOol0C7oo00d004Gf
BOI5mTWfAOI9mTGfBOIl06JEIYAZU@02IYD01fJDJYEVUFJEIYAZUFJE008Li`09@MHm]T7F?KE1eSff
@MIl0000015oo`0O001F=EXfESEJ=EHeFSIF=EXeESEJ=UHeFSEF=EXfESEJ=EHeFSIl05XeESEJ=UHe
FSEF=EXfESEJ=EHeO0003Woo00<007ooOol0?Goo00<007ooOol03Goo000;Ool00`00Oomoo`1=Ool0
0`00AOI9mP03AOH00dWfAOIl000=7>L8?KH00acWO01oo`0@Ool00`00FSEF=@02ESD01EXeESEF=EHe
FSD00eHe00UJ=EHeESEF=EXeESEl05HeFSD00eHe00MJ=EHeESEF=EXeESEl000=Ool00`00Oomoo`0m
Ool00`00Oomoo`0=Ool000]oo`03001oogoo04eoo`0P0019mTGfBOI5mTWfAOI9mW`0K]EZ]6kEJ[A^
eFZdK]EZ]6kEJ[A^eFZdK]Dm]T7F?KE1eSff@MHm]D7F7>Ml015oo`0P001F=EXeESEJ=UHeFSEF=EXf
ESEJ=EHeFSIF=EXeESEJ=UHeFSEl05XfESEJ=EHeFSIF=EXeESEJ=UHeFSEl00eoo`03001oogoo03eo
o`03001oogoo00eoo`002goo00<007ooOol0CWoo00@004GfAOI9mP95mP0?7>Ml06ZdK[EZ]6jeJ[A^
]FZdK[EZ]6jeJ[A^]FZd00Hm]P8Li`03<IHaMW`0011oo`04001F=EHeFSD3ESD01EXeESEF=EHeFSD0
0eHe00EJ=EHeESEF=G`000=F=@03FSEF=EHe00DLi`03O01oogoo00]oo`03001oogoo03ioo`03001o
ogoo00aoo`002goo00<007ooOol0CWoo00<004GfBOH00acW01=1eW`0K]EZ]6kEJ[A^eFZdK]EZ]6kE
J[A^eCffK]Dm]D7F?KI1eP027>L01C5e=IHaMCFFO0003Goo100000]F=EXfESEJ=EHeFSIF=EXeESEJ
=UHe00LLi`03O00LiacW00@Li`06EQIB5EHEDQEF5W`03Goo00<007ooOol0?Woo00<007ooOol037oo
000:Ool00`00Oomoo`1@Ool00`007>Lm]P03?KH03G`0J[A^]FZdK[EZ]6jeJ[A^]CffK[EZ]6je00<m
]P8Li`08=IHaMS6F<GHeUS5f<IIl00Uoo`<000=oo`04001J=EHeESD87>L3DQD01GooDQDLi`06O000
358E00=l07ooOol02Woo00<007ooOol0?Woo00<007ooOol037oo000:Ool00`00Oomoo`1AOol04`00
?KE1eSff@MIl06kEJ[A^eFZd@MIZ]6kEJ[A^eFZdK]EZ]47F008Li`0:<GDeUS5e=IHaMCFF<GDeUS5e
O005Ool40006Ool08@007>LLiacWEQIB5EHEDQEF5U8EEQEB5EHFDQEF5E8E7>L01W`0DQEF5U8EEQEB
5EHFDQEF5E8EEQIB5EHEDQEl000=Ool00`00Oomoo`0mOol00`00Oomoo`0<Ool000Yoo`03001oogoo
059oo`05000m]Sff?KIl00027>L02FZdK[EZ]6jeJ[A^]FZdK[EZ]0027>L03S6F<GHeUS5f<IHaMSFF
<GHaUS5f=IHaMW`0Ool3000:Ool00`00DQEB5@0;DQD01Goo7>L01P06O0003U8E00=l07ooOol02Woo
00<007ooOol0?Goo00<007ooOol037oo000:Ool00`00Oomoo`1COol01000?KE1eW`00W;d1QcW00m^
eFZdK]DaMCFF<GDeUS5e=IHaMCFF<GDeUS5e=IH00QcW00=l0000Ool037oo00l0058EEQIB5EHEDQEF
5U8EEQEB5EHFDQEF5Goo7>L00`0600el058EEQEB5EHFDQEF5E8EEQIB5EHEDQEF5P027>L00g`0Oomo
o`0:Ool00`00Oomoo`0mOol00`00Oomoo`0<Ool000Yoo`03001oogoo05Aoo`03000m]W`000Qbm0@L
i`0?<GHeUS5f<IHaMSFF<GHaUS5f000Lib4f8CDQ=W`000eoo`03001B5E8E00YB5@067>L01P0600HL
ig`01e8E1AcW0Tge00=l07ooOol02Woo00<007ooOol0?Goo00<007ooOol037oo000:Ool00`00Oomo
o`1EOol00`00O01fm003L_@01GKdL_Abm7;dM_@00g;d00PeUS5e=IHaMCFF<GDeUP000QcW00DQ=Qde
8CHM=G`000ioo`0<001F5E8EEQIB5EHEDQEF5U8EEQEB5EHF0P060QcW00=l05HEDQD01QcW0Tge00M=
mTgeCOE=mDgfCOEl000;Ool00`00Oomoo`0nOol00`00Oomoo`0;Ool000Uoo`03001oogoo05Moo`03
O01bm7;d00Ybm00@<GHaUS5f=IHaMP00<GHLib4e8CHQ=B4f8CDQ=R4eO00=Ool00`00DQEB5@09DQD0
1@067>L@310;O0000QcW3Tge00=l07ooOol02Goo00<007ooOol0?Woo00<007ooOol02goo0009Ool0
0`00Oomoo`1GOol017`0L_Abm7Kd0g;d00]fm7;dL_Abm7KdL_@eUS5e=IIbm3FF008Li`097CDQ=Qde
8CHM=B4f7CDQ=W`000eoo`0;001F5U8EEQEB5EHFDQEF5E8E7>MB5@027>L01A0<40/@37`0COH00dge
00E=mTgeCOE=mDgf00==m@06COI=mDgeCOE=mW`02Woo00<007ooOol0?Woo00<007ooOol02goo0009
Ool00`00Oomoo`1GOol00g`07>Mbm00:L_@04C5fL_@aMS6F7>LQ=R4e8CHQ=B4f8CDQ=R4e8CH0U1cW
O00037oo00@0058EDQEB5@DLi`0700HLia0;40`@2a0<O0004Tge00=l07ooOol027oo00<007ooOol0
?Woo00<007ooOol02goo0009Ool00`00Oomoo`1GOol01W`0Nc<LiacWL_Afm0=bm006M_Abm7;d000e
US5e0QcW00dQ=Qde8CHM=B4f7CDQ=Qde8CH0U1cW09Al000<Ool010007>LLiacW0dge00U=mQcW7>L@
2a0<40/@310;O0000dge00E=mTgeCOE=mDgf00==m@04COI=mDgeCOD37>L00g`0Oomoo`07Ool20010
Ool00`00Oomoo`0;Ool000Uoo`03001oogoo05Moo`04O01k<g/cNc<27>L7L_@03S5f7>LQ=B4f8CDQ
=R4e8CHQ=B4f8CDQ=P2D7>L219@00`2DO01oo`0;Ool00`00COE=m@03COD02AcW40`@2a0<40/@32R>
7>Ml000;COD47>L01DGEBME5eDWEO0001Goo0`000Woo00<007ooOol0?Goo00<007ooOol02goo0009
Ool00`00Oomoo`1FOol00g`0Nc=k<`04Nc<27>L3L_@057Kd7>LLiade8CHM=B4f7CDQ=Qde8CHM=B4f
09@Li`2D19@0U0BDO00<Ool01000COE=m@060QcW00D@310;40`@2bR>008Li`0498el04geCOH3COD0
0dgfCOE=m@037>L02TWFAME9eTGEBMI5eDWFAMEl07oo10001Woo00<007ooOol0?7oo00<007ooOol0
2goo0009Ool00`00Oomoo`1FOol00g`0Nc=k<`06Nc<27>L2L_@03B4f8CDQ=R4e8CHQ=B4f8CDQ=R4e
8CH0U1cW0084U00509@4U0BD19Al000<Ool0200000HLia0;40`@2a0<:8h27>L2:8h00g`0COE=m@03
COD47>L02TWEAME9eDGEBME5eDWEAME9eDGE0`002Woo00<007ooOol0?7oo00<007ooOol02goo0008
Ool00`00Oomoo`1GOol00g`0Nc=k<`08Nc<37>L0524f7CDQ=Qde8CHM=B4f7CDQ=Qde7>L0U0BD09@4
U02D19@0U1cWO00;Ool01P007>L@2a0<40/XSP8Li`0698dXSRB=:8il04gf11cW00]5eDWFAME9eTGE
BMI5eDWFAME9eTGE00<00003AME9eW`000]oo`03001oogoo03aoo`03001oogoo00Yoo`0027oo00<0
07ooOol0Egoo00=l07/cNc<02W/c00/Q=R4e8CHQ=B4f8CDQ=R4e8CHQ=AcW0084U00809@4U0BD19@0
U1cW00il00Yoo`05000@310;40`XSP027>L6:8h03W`07>M9eDGEBME5eDWEAME9eDGEBME5eDWEAMD3
00000dGEBME5e@027>L00`00O01oo`0:Ool00`00Oomoo`0kOol00`00Oomoo`0:Ool000Qoo`03001o
ogoo05Moo`03O00Lig/c00Uk<`0G000M=B4f7CDQ=Qde8CHM=B4f7CDLi`2D19@0U0BD09@4U02D19@L
i`0?00il0008Ool0100040`@2bR>0QcW00HTSBR>98dXSRB=:8h27>L02g`0BMI5eDWFAME9eTGEBMI5
eDWFAMD00`0000A5eDWFAME9eP8Li`<00003O01oogoo00Yoo`03001oogoo03Yoo`03001oogoo00Yo
o`0027oo00<007ooOol0Egoo00=l07ma7>L027/c100000LQ=R4e8CHQ=B4f8CDLi`0219@01@2D19@4
U0BD09@00PBD00@Li`0>00il00Moo`03000@32R>008Li`HXSP8Li`09=>ldcW`0AME9eDGEBME5eDWE
00@00004AME9eDGEBMD37>L00d6f0000000300000g`0Oomoo`0:Ool00`00Oomoo`0iOol00`00Oomo
o`0:Ool000Qoo`03001oogoo05Ioo`04O01oLG]`7>L7Nc<00`00Ool00002Ool05@008CHM=B4f7CDL
i`2D19@0U0BD09@4U02D19@0U1cW00h03`0>7>Ml0004Ool00a0<000XSP027>L01RB=:8h002R>98dX
SP8Li`08=<hhkcC>O015eDWFAME9eP<00006BMI5eDWFAME9eTGE0QcW00=1]Sfe@KH01P0000=l07oo
Ool02goo00<007ooOol0>7oo00<007ooOol02Woo0008Ool00`00Oomoo`1FOol01G`0Og1oLGm`7>L0
1G/c00@007ooOol000=oo`8000058CDLi`BD19@0U00319@01@2D19@4U0BD7>L00P0>00<03acWO000
0goo00@@30007>LLi`9oo`<XSP<Li`07=>ldccC_=<hdkg`0BMD00`0000I9eDGEBME5eDWEAMD37>L3
@KD00d6f0000000600000g`0Oomoo`0:Ool00`00Oomoo`0hOol00`00Oomoo`0:Ool000Moo`03001o
ogoo05Moo`06O01oLG]`Og5kL1cW17/c00@007ooOol000Eoo`0E0000U0BD09@4U02D19@0U0BD09@4
U02D7>L03P0?00h03acWO01oo`00008Li`0598dXSRB=:8hTS@027>L01cS_=<hdkcC>>>ldcSC_00<0
0006BMI5eDWFAME9eTGE0acW00Hm]D6f?KE1]Sfe@KH800000acW>IIl000<Ool00`00Oomoo`0gOol0
0`00Oomoo`0:Ool000Moo`03001oogoo05Moo`07O01oL7maOg1oLGm`7>L00W/c00D007ooOomoo`00
00Ioo`8000<4U00809@4U0BD19@0U1cW00h03`<03P037>Ml000000HXSP8Li`06=<ldkcC>=>ldccC_
0`0000LLig`0BME5eDWEAME9e@027>L3@KD01D6f@KE1]D6e@KH01`000QcW0SFF00<iUW`0Ool02goo
00<007ooOol0=goo00<007ooOol02Goo0007Ool00`00Oomoo`1GOol02G`0Og5kL7maNg1oLAcWNc<0
0004Ool00`00Oomoo`06Ool200004`2D19@0U0BD09@4U1cW00l03P0?00h03acWO01QH2R>98dXSRB=
008Li`04=>ldcSS_=<h400001acW?@i13cd>O015eDWF00<Li`09@KHm]D6f?KE1]Sfe@KHm]D6f00H0
008Li`06=IDiUSFE>IHeUG`03Goo00<007ooOol0=Woo00<007ooOol02Goo0007Ool00`00Oomoo`1F
Ool02G`07>MoL7maOg1oLGm`Og400004Ool00`00Oomoo`09Ool200001@BD09@4U0BD7>L00`0>00H0
3`0>7>MUH7`0:8h37>L00cC>=>ldc`0300002CC?7>LLid4??@m13cd?O015e@027>L2@KD01D6f@KE1
]D6e@KH00d6e00=1]P0000000`000QcW00DiUSFF=IHeUSVF00<eUP03O01oogoo00]oo`03001oogoo
03Eoo`03001oogoo00Uoo`001goo00<007ooOol0EWoo00Ql01cWOg5kL7maNg1oL@001Goo00<007oo
Ool02goo0P0000l0U1cW00h03`0>00l03P0?00hLig`0LLDdcSS_=<h00`0001LdcSC_7>LLicd>@@lm
3T4??@i13g`07>Lm]D6f?KE1]Sfe@KHm]D6f?KE1]Sfe00D0008Li`0<=IDiUSFE>IHeUCVF=IDiUSFE
7>LYEW`037oo00<007ooOol0=Goo00<007ooOol02Goo0007Ool00`00Oomoo`1FOol01g`07>MoL7ma
Og1oL@0000Ioo`03001oogoo00eoo`8000803P0800l03P0>00h03acWIF1l00<00003=<ldkacW008L
i`09@@lm3d4??@m13cd?@@lLig`000=1]@05@KI1]D6e@KE1]P03@KD5000011cW=IHeUSVF0cFF00Di
USFF=IHeUQcW008YMP03O01oogoo00]oo`03001oogoo03Aoo`03001oogoo00Uoo`001goo00<007oo
Ool0EGoo00Ml06]:7>MoLG]`Og400007Ool00`00Oomoo`0?Ool200001@0>00l03P0?00h00`0000=]
a775KL@00QcW00Q13cd>@@lm3T4??@i13cd>0QcW00a9;g`0@KHm]D6f?KE1]Sfe@KHm]D6f?KD40002
7>L02CVF=IDiUSFE>IHeUCVF=IDiUP027>L01BUF:GHYERegO0003Goo00<007ooOol0<goo00<007oo
Ool02Goo0006Ool00`00Oomoo`1FOol01W`0JbTLigm`Og4000Qoo`03001oogoo015oo`D0000<7>MU
H7`0LLA]a775KLA13cd?@@lm3d4?11cW00I5;TD_ABil046e@KH3@KD0146f@KE1]D6e0`000QcW0cFF
00DiUSFF=IHeUSVF008eUP037>LYMRUf00@YMP03O01oogoo00aoo`03001oogoo039oo`03001oogoo
00Uoo`001Woo00<007ooOol0EGoo00LLig`0JdXLigmaNg000008Ool00`00Oomoo`0?Ool3000013S_
OoldkcC>0QcW00Q13g`0KLU]a775KLA13cd>0QcW0119;dD^ABm5;TT_ABi5;g`0000m]D6f?KE1]Sfe
@KHm]@80008Li`0E>IHeUCVF=IDiUSFE>IHeUCVF=IDiUQcW;GLYERUf:EH]MbUF:GHYEW`000ioo`03
001oogoo035oo`03001oogoo00Uoo`001Woo00<007ooOol0EGoo00HLig`0JbXLigm`0009Ool00`00
Oomoo`0<Ool4000013C?OoldcSC_0QcW00Dm3d4??@ml06W8009Yb@0ALLE5;QcWABi5;dD^ABm5;TD_
ABi5;dD^O01oo`00@KE1]P03@KD01@007>LLicFF>IH00cFF00DiUSFF=IHeUSVF008eUP037>LYMRUf
00HYMP037>LE5W`000eoo`03001oogoo039oo`03001oogoo00Qoo`001Woo00<007ooOol0E7oo00HL
ig`0JbU[BQcW000:Ool00`00Oomoo`09Ool30002Ool00`00Oolhk`037>L01Woo?@i13cd>@@ml008L
i`0;KLUYb6g9KLA9;dD^ABm5;TT_ABi5;`027>L01g`0Oomoo`00?KE1]Sfe008Li`0<>IHeUCVF=IDi
USFE>IHeUCVF=IDiUSFE0QcW00d]MbUF:GHYEReg:EHYMRUF7>LE5QDG4AIl000=Ool00`00Oomoo`0a
Ool00`00Oomoo`08Ool000Ioo`03001oogoo05Aoo`057>Ml06/ZJbT0000;Ool00`00Oomoo`06Ool3
0004Ool02P007>LLiacW@@lm3d4??@m13cd?0QcW00=l06FZKLT00QcW00IYbFg9JLQ5;dD^ABl37>L0
0de>BDil0003Ool00`00@KDLi`03=IH01CVF=IHeUSFF>IH00cFF00<iUSFF7>L02BUf00HLiaDF5AHE
5QDGO00>Ool00`00Oomoo`0`Ool00`00Oomoo`08Ool000Ioo`03001oogoo05=oo`057>L007`0JbT0
000<Ool00`00Oomoo`02Ool40006Ool02000?@i13cd>@@lm3T4??@h37>L01dD^ABm5;W`0HJYUZfW8
00<Li`09JLQ]bAcWCDi9CTe>BDi=CW`000Aoo`0P000eUCVF=IDiUSFE>IHeUCVF=IDiUSFE>IHeUAcW
:EH]MbUF:GHYEReg:EHYMRUF;GLLiaDG4AHE5aDF5AMl00ioo`03001oogoo02moo`03001oogoo00Qo
o`001Goo00<007ooOol0E7oo0QcW00=l0000Ool037oo00<007oo00000P002Woo00H0044??@m13cd?
@@l27>L034D^ABm5;TD_ABi5;g`0IJ]UZVF[HJYUZ`8Li`08JLQYbFW9CDi9CTe>BDil00Eoo`800005
>IHeUSFF=IHiUP03=IH00cVF=IHLi`0::GH011cW5AHE5QDG0aDF00<0UG`0Ool03Goo00<007ooOol0
;Woo00<007ooOol027oo0005Ool00`00Oomoo`1COol27>L00g`0001oo`0<Ool3000<Ool01000@@lm
3T4?0acW0115;dD^BBm5;TD_ABi9;acWO00LifF[HJYUZf6ZIJ]QZP8Li`06KLU9CTe>BDhLig`01goo
00P003VF=IDiUSFE>IHeUCVF0QcW01DYEReg:EHYMRUF;GLYERUf:EH]MacW5ALA5QDG5AHE5a4F7>L0
U@2FO0003Woo00<007ooOol0;Goo00<007ooOol027oo0005Ool00`00Oomoo`1BOol010007>L01W`0
2goo0`0000=oo`00Ool037oo00/001cW7>LLidD_ABi5;dD^ABm5;TD_00<Li`03O01MRef;00@Li`04
HJYUZfFZIJ/47>L00de=O01oo`07Ool20003=IH00cVF7>LYMP0::GH011cW5AHE5QDG0aDF00<E5acW
09D00P2E00=l07ooOol02goo00<007ooOol0;Goo00<007ooOol027oo0005Ool00`00Oomoo`1BOol0
0acW00Il0009Ool30004Ool00`00Oomoo`0:Ool02@007>M5;dD^BBm5;TD_ABi9;`037>L01De>BDi=
CW`0GH`00Uf;00=IRef<GH/011cW00MUZf6ZIJ]QZU5=CDal0009Ool2000073VF7>LYMRUF;GLYERUf
:EH]MbUF:GHYEReg:EHLia4F5ALE5QDG4AHE5aDF7>L0U@2F09DLig`03Goo00<007ooOol0;Goo00<0
07ooOol01goo0005Ool00`00Oomoo`1AOol011cW00H01W`01Goo10001goo00<007ooOol02Goo00L0
04D^ABm5;TD_ABi5;`037>L01de>BDi=CTU>CDi9CW`0008Li`QMR`@Li`04IJYUZg`07>L:Ool00acW
:GHYMP0::GH00acW5AHE5`035AH011DG5AHE5QcW0`2E00<Li`0@O0003Goo00<007ooOol0;7oo00<0
07ooOol01goo0005Ool00`00Oomoo`1@Ool01AcW00HLiacWO0000Woo0`002goo00<007ooOol02Goo
00@004D_ABi9;`<Li`0<CDi9CTe>BDi=CTU>CDi9CTe>O01IBeE;11cW00EMS5f;GH]IRef<009MR`06
CD`LiacW7>MQZVF[0QcW27oo0P0001XYERUf:EH]MbUF:GHYEReg:EHLia4F5ALE5QDG4AHE5aDF5ALL
i`2F09D0UP2E7>L03g`03Woo00<007ooOol0:goo00<007ooOol01goo0005Ool00`00Oomoo`1>Ool2
7>L010067>LD2G`00`003Woo00<007ooOol027oo00<004D_7>L00QcW00U=CTU>CDi9CTe>BDi=CTU>
CDh00acW00=l05E;ED/015E;1AcW1Uf;00Al01cW7>MUZP8000Qoo`8000HYMP037>LE5QDG00<E5P05
5ALE5QDF5AHLi`0509D00acW011l000>Ool00`00Oomoo`0ZOol00`00Oomoo`07Ool000Aoo`03001o
ogoo04ioo`047>L01QcW7>L3000AOol00`00Oomoo`08Ool02`007>M=CTU>CDi9CTe>BDi=CTU>CDh0
0acW00mACDe=DDel05U<ED]IBeE;FDaEBeU;ED]IC5E;FD/011cW00EIRef<GH]MReV;00<Li`<000Mo
o`80000H:EH]MbUF:GHLiaDG5AHE5a4F5ALE5QDG4AHE5acW09H0U@2F09D0UQcW01003g`03Goo00<0
07ooOol0:Woo00<007ooOol01goo0004Ool00`00Oomoo`1=Ool00acW0000000200000aP9O01oo`0A
Ool00`00Oomoo`08Ool01`00CDi9CTe>BDi=CTU>00@Li`=AC@04CDeACE5=O0037>L<ED/57>L4GH/2
7>L20007Ool200000bUf7>LE5`035AH01QDG5AHE5QDF5ALLi`H0U@057>L03`0@O01HX00=Ool00`00
Oomoo`0YOol00`00Oomoo`07Ool000Aoo`03001oogoo04]oo`<000067>LH2A@960TD2G`04Woo00<0
07ooOol02Goo00<004e>7>L00acW00i=C55=CDeACDe<DDe=CE5=CDal04d:DB]=2U4[21cW00UEBeU;
ED]IC5E;FD]EBeU<ED/01AcW00AIRef<GH/000Qoo`80000F5AHE5a4F5ALE5QDG4AHE5aDF7>L0U@2F
09D0UP2E09HLi`0@00l047`0F:0=Ool00`00Oomoo`0XOol00`00Oomoo`07Ool000Aoo`03001oogoo
04Qoo`<000<Li`0360TD2AP9008Li`03O01oogoo011oo`03001oogoo00Uoo`04000Lie5=CDd3DDd0
1De=DDeACE5=CDd00acW00el04d;C@YA2dd:C@]=2U4;C@Y=2dd:D@]=2P087>L6ED/47>L20008Ool2
00001ADG5AHE5QDF5AL00QDF00<Li`2E09D0102E00PLi`0@01003`0@O01HX5BP37oo00<007ooOol0
:7oo00<007ooOol01Woo0004Ool00`00Oomoo`15Ool30002Ool27>L00a@960TD2@027>L00bQ;92Yl
000BOol00`00Oomoo`0:Ool200001E5=CDaACDe=DDd011cW00=A:eE<O00011cW015A:dd:DB]=2U4[
C@YA:dd:DB]=2U4[C@YA:dd:DB]=2U4[00TLi`04FD`LiacW0009Ool3000051DG5AHE5a4F7>L0U@2F
09D0UP2E09HLi`0@00l0400?7>Ml05RPE:0<Ool00`00Oomoo`0WOol00`00Oomoo`06Ool000Aoo`03
001oogoo049oo`<000Aoo`04000Lia@960T27>L012PZ:4XX:W`04goo00<007ooOol037oo0P000acW
00IEBe5;ED]ABeE;O002A<T00dS9A<U4b@0;7>L03dd;C@YA2dd:C@]=2QcWC@Y=2dd:D@]=2Td;C@YA
2`047>L2000:Ool200000aDF7>L0U@0609D00acW00l0400201001@0?7>Ml05cPE:002goo00<007oo
Ool09goo00<007ooOol01Woo0003Ool00`00Oomoo`0oOol40006Ool27>L02A@960TLibQ;:2XXBb@Z
:4]l000COol00`00Oomoo`0>Ool200005eE<DB]EBe4[ED`Lig`0A<U8bTC9B<U4bDS:A<U8bDC9B<Y4
bDS9A<U8bTC9B<T03QcW00M=2U4[C@YA:dd:DB/0000<Ool300004@2E09H0U@2F09D0UP2E7>L03`0@
00l0400?O01H`ESQG>002goo00<007ooOol09Woo00<007ooOol01Woo0003Ool00`00Oomoo`0lOol3
0009Ool00acW60TD2@027>L01bQ::2XXBRPZ:4XLig`001=oo`03001oogoo011oo`<0008Li`03O00L
idS900=4b@05B<U4bDC9A<U8b@03A<T01DS9A<U4bDC9B<T00dC900E8bDC9A<U4bDS900=4b@03B<U4
bAcW00DLi`03001oogoo00eoo`<000@0U@037>L0400?00<040067>Ml05S1F>5H`EcP2Woo00<007oo
Ool09Goo00<007ooOol01Woo0003Ool00`00Oomoo`0iOol3000:Ool02P007>LH2A@97>LT:RQ;:2XX
Bb@Z0QcW00=l07ooOol04Woo00<007ooOol04goo00@007`0>6HlIa0Li`0BA<U8bDC9B<Y4bDS9A<TL
idC9B<U4bDS:A<U8bDC9B<Y4bDS90P004goo0`0000l0UAcW00l0400?01003`0@O01DXUS1F>5H`AcW
F<402Goo00<007ooOol097oo00<007ooOol01Woo0003Ool00`00Oomoo`0fOol3000<Ool27>L01aP9
7>LLibPZ:4XX:RQ:008Li`03<6XdJW`001=oo`03001oogoo01Aoo`03O00lIcaW008lI`D000XlIa0L
i`8001Qoo`<00080400400l0400@O005D:800acWF<5Hh@08Ool00`00Oomoo`0SOol00`00Oomoo`06
Ool000=oo`03001oogoo03=oo`<000ioo`087>LD2AcW7>LXBb@Z:4/X:P8Li`04=8/`JSB;O00DOol0
0`00Oomoo`0COol00g`07>LLi`087>L:00001CQV?6LlIcaW>6H00caW00HhISaW?6LlI`00?6L20002
O00KOol300003@0?011l04aRB65DXU2RE:9@XUBRD:9HhAcW00Moo`03001oogoo029oo`03001oogoo
00Ioo`000goo00<007ooOol0;goo100047oo00L001@97>LX:RQ::2XXBP027>L01S1Z=6/`JSAZ7>Ml
01Aoo`03001oogoo019oo`0?O00`0c04<0<`1303<0@`0c04<0<`1303<0@`0c0400LLi`X000037>L0
000000X001Uoo`03001l040000900003?018HDQQ0098H@E@XP03F<5oogoo009oo`03001oogoo02=o
o`03001oogoo00Eoo`000Woo00<007ooOol0;Goo0`004goo00H001cW7>LX:RQ;92X27>L013B;<6Xd
Rc1Z0QcW00<lRW`0Ool04goo00<007ooOol047oo0W`001d/0c04;0<`12`3<0@/0c04;0<`12`3<0@/
0c04;0<`12`3<0@/0c04;0<`12`3<0@/0c04;0<`12`300@000aooaT0000BOoml03`0@00l0400?010
03`0@00l0400?01<HTQQE:9@XUBR0goo00<007ooOol08Woo00<007ooOol01Goo0002Ool00`00Oomo
o`0ZOol3000EOol01@007>LXBRPZ:4X00QcW00@`JSAZ<6XdJ`8Li`<hRP03O01oogoo019oo`03001o
ogoo00moo`03O00LiacW01TLi`@001Aoo`Al00TLi`86NP032WXLiacW00<Lia@0008Li`03001oogoo
025oo`03001oogoo00Eoo`000Woo00<007ooOol09goo0`005Woo00D001cW7>LXBbPZ008Li`03=8/`
JSB;00<Li`06?8XhRCb:>8TLig`057oo00<007ooOol03Woo01Ql0200700P01`0800L0200700P01`0
800L0200700P01`0800L0200700P01`08005000LOol2O00S7>L=000IOol00`00Oomoo`05Ool0009o
o`03001oogoo02Aoo`<001Qoo`8Li`07:2XXBQcW7>L`JSA[<6X00QcW1CR:0QcW00<lR7`0Ool04goo
00<007ooOol037oo0W`00b0000DL0200800P01`0008P00XLi`@004Aoo`<000047>L0000000087>L5
000DOol00`00Oomoo`05Ool0009oo`03001oogoo021oo`@001Yoo`037>LXBb@Z008Li`03=8/`JQcW
008Li`04>8TlRSR9?8X37>L01429?8Q0RG`057oo00<007ooOol02goo00=l01cW7>L02QcW00H800`0
200<00P03004001>Ool300000acW0000000200047>L00`00Oomoo`0COol00`00Oomoo`05Ool0009o
o`03001oogoo01eoo`<001eoo`06000XBQcW7>L`JSAZ0QcW13R:0acW00LlRCb8?8PlR3b9?8Ql000D
Ool00`00Oomoo`09Ool2O00?3004001COol00`00Oomoo`0NOol00`00Oomoo`05Ool0009oo`03001o
ogoo01Yoo`<001ioo`80008Li`08=8/`JQcW7>LlRSR9?8XhR@8Li`07@8TlR429?8Q0RCb8@8T00QcW
00=l07ooOol04Woo00<007ooOol01Woo0W`03QcW1000F7oo00<007ooOol07Woo00<007ooOol017oo
00000goo001oo`0IOol3000POol010007>LLic1Z0acW0cR:0acW0cb800<lRCb8?8P00acW00=0ISaV
O00057oo00<007ooOol017oo0W`04000GGoo00<007ooOol07Goo00<007ooOol017oo00000goo001o
o`0FOol3000QOol010007>LLicB;0QcW00@hRCb:>8TlRP8Li`06?8Q0RCb8@8TlR4290acW00I0IcaV
@6LlIQcWO00DOol00`00Oomoo`04O0057>L7001TOol00`00Oomoo`0LOol00`00Oomoo`04Ool00003
Ool007oo019oo`@002=oo`03000LiacW008Li`<hRP<Li`8lR003?8TlR3b800<Li`03@6HlIT1V00@L
i`8l8`037>Ml07oo00moo`9l00037>Ml07`000T006]oo`03001oogoo01aoo`03001oogoo00Aoo`00
00=oo`00Ool03goo0`009Woo00H001cW7>LlRSR9?8X37>L01D29?8Q0RCb8@8T00acW00=0IcaV7>L0
0acW00@l8cPR?2<l8P8Li`8d00037>Ml07`000Qoo`03O00LiacW009l00P0079oo`03001oogoo01]o
o`03001oogoo00Aoo`0000=oo`00Ool037oo0`009goo00<001cW7>L00cR:0QcW0Sb800<lRCb8?8P0
0acW00=0ISaV@6H00QcW1C`S0acW00@d01cW7>LLi`<T0004O00LiacWO0027>L00g`07>LLi`07001h
Ool00`00Oomoo`0JOol00`00Oomoo`04Ool00003Ool007oo00Uoo`<002Uoo`04000Licb:>8T37>L0
13b8@8TlR4290acW00A0IcaV@6LlIP8Li`04?2<h8S`S?2837>L01c@07>LLiacW900X02@000LLi`03
000LiacW00@000Aoo`03001oogoo07Moo`03001oogoo01Uoo`03001oogoo00Aoo`0000<007ooOol0
1Woo0`00:goo00<003R:7>L00QcW00@lR3b9?8PlR0<Li`04@6HlIT1V?6H37>L3?2<77>L290077>L7
0008Ool00`00Oomoo`1hOol00`00Oomoo`0HOol00`00Oomoo`04Ool00003001oogoo009oo`@002eo
o`07000LiacW?8Q0RCb8@8T00acW00=0IcaV@6L011cW00<h8S`S7>L01QcW00<X02@0:0001QcW1P00
3Goo00<007ooOol0NGoo00<007ooOol067oo00<007ooOol00goo00000`00Ool00002000`Ool00`00
7>LlR@02?8P37>L00d1V?6HLi`037>L2?2<47>L013@07>LLiacW0R@00QcW20004goo00<007ooOol0
NGoo00<007ooOol067oo00<007ooOol00goo0002000cOol00`00@8TLi`027>L00d1W7>LLi`027>L0
0c`R?2<Li`037>L00c@07>L00009000KOol00`00Oomoo`1jOol00`00Oomoo`0GOol00`00Oomoo`03
Ool00003Ool00000039oo`04000Lid1V?6H27>L2?2<27>L8000UOol00`00Oomoo`1kOol00`00Oomo
o`0FOol00`00Oomoo`03Ool000=oo`03001oogoo031oo`T002eoo`03001oogoo07aoo`03001oogoo
01Eoo`03001oogoo00=oo`0017oo00<007ooOol0IGoo00<007ooOol0OGoo00<007ooOol057oo00<0
07ooOol00goo0005Ool2001UOol00`00Oomoo`1mOol00`00Oomoo`0DOol00`00Oomoo`03Ool000Mo
o`03001oogoo069oo`03001oogoo07ioo`03001oogoo01Aoo`03001oogoo009oo`0027oo0P00HWoo
00<007ooOol0Ogoo00<007ooOol04goo00<007ooOol00Woo000:Ool00`00Oomoo`1OOol00`00Oomo
o`20Ool00`00Oomoo`0BOol00`00Oomoo`02Ool000]oo`8005ioo`03001oogoo089oo`03001oogoo
015oo`03001oogoo009oo`003Goo00<007ooOol0Fgoo00<007ooOol0PWoo00<007ooOol04Goo00<0
07ooOol00Woo000>Ool00`00Oomoo`1JOol00`00Oomoo`23Ool00`00Oomoo`0@Ool00`00Oomoo`02
Ool000moo`8005Yoo`03001oogoo08Aoo`03001oogoo00moo`03001oogoo009oo`004Goo00<007oo
Ool0Egoo00<007ooOol0QGoo00<007ooOol03Woo00<007ooOol00Woo000BOol2001GOol00`00Oomo
o`26Ool00`00Oomoo`0>Ool00`00Oomoo`01Ool001Aoo`03001oogoo05Aoo`03001oogoo08Moo`03
001oogoo00eoo`03001oogoo005oo`005Goo00<007ooOol0Dgoo00<007ooOol0Qgoo00<007ooOol0
3Goo00<007ooOol00Goo000FOol2001COol00`00Oomoo`28Ool00`00Oomoo`0<Ool00`00Oomoo`01
Ool001Qoo`03001oogoo051oo`03001oogoo08Uoo`03001oogoo00]oo`03001oogoo005oo`006Goo
0P00D7oo00<007ooOol0RWoo00<007ooOol02Woo00<007ooOol00Goo000KOol00`00Oomoo`1=Ool0
0`00Oomoo`2;Ool00`00Oomoo`09Ool00`00Oomoo`01Ool001aoo`8004eoo`03001oogoo08]oo`03
001oogoo00Yoo`40005oo`5oo`007Woo00<007ooOol0BWoo00<007ooOol0S7oo00<007ooOol02Goo
0@000Goo0Goo000OOol00`00Oomoo`19Ool00`00Oomoo`2=Ool00`00Oomoo`08Ool10001Ool1Ool0
021oo`8004Uoo`03001oogoo08ioo`03001oogoo00Moo`40005oo`5oo`008Woo00<007ooOol0AWoo
00<007ooOol0Sgoo00<007ooOol01Woo0@000Goo0Goo000SOol20016Ool00`00Oomoo`2?Ool00`00
Oomoo`06Ool10001Ool1Ool002Eoo`03001oogoo04=oo`03001oogoo091oo`03001oogoo00Eoo`40
005oo`5oo`009Woo0P00@goo00<007ooOol0TGoo00<007ooOol01Goo0@000Goo000XOol00`00Oomo
o`10Ool00`00Oomoo`2BOol00`00Oomoo`04Ool10001Ool002Uoo`03001oogoo03moo`03001oogoo
09=oo`03001oogoo00=oo`40005oo`00:Woo0P00?goo00<007ooOol0U7oo00<007ooOol00Woo0@00
0Goo000/Ool00`00Oomoo`0lOol00`00Oomoo`2DOol00`00Oomoo`02Ool10001Ool002eoo`8003ao
o`03001oogoo09Eoo`05001oogooOol00001Ool002moo`03001oogoo03Uoo`03001oogoo09Ioo`04
001oogoo0001Ool0031oo`03001oogoo03Qoo`03001oogoo09Moo`03001oo`00005oo`00<Goo0P00
=goo00<007ooOol0VGoo0@000Goo0@00000cOol00`00Oomoo`0dOol00`00Oomoo`2IOol10001Ool1
000003Aoo`8003Aoo`03001oogoo09Yoo`800000=Woo00<007ooOol0<Goo00<007ooOol0VGoo0`00
000gOol2000aOol00`00Oomoo`2EOol40003Ool003Uoo`03001oogoo02ioo`03001oogoo091oo`D0
00Moo`00>Woo00<007ooOol0;Goo00<007ooOol0S7oo100037oo000kOol2000]Ool00`00Oomoo`28
Ool4000@Ool003eoo`03001oogoo02Yoo`03001oogoo08=oo`D001Aoo`00?Woo0P00:Woo00<007oo
Ool0Ogoo10006Goo0010Ool00`00Oomoo`0WOol00`00Oomoo`1jOol5000MOol0045oo`03001oogoo
02Ioo`03001oogoo07Ioo`@0029oo`00@Woo0P009Woo00<007ooOol0LWoo10009Woo0014Ool00`00
Oomoo`0SOol00`00Oomoo`1]Ool5000ZOol004Eoo`8002=oo`03001oogoo06Uoo`@002moo`00Agoo
00<007ooOol087oo00<007ooOol0I7oo1@00<goo0018Ool2000POol00`00Oomoo`1POol4000hOol0
04Yoo`03001oogoo01eoo`03001oogoo05]oo`D003aoo`00Bgoo00<007ooOol077oo00<007ooOol0
Egoo1000@Goo001<Ool2000LOol00`00Oomoo`1COol40015Ool004ioo`03001oogoo01Uoo`03001o
ogoo04ioo`D004Uoo`00Cgoo0P006Goo00<007ooOol0BWoo1000CWoo001AOol00`00Oomoo`0FOol0
0`00Oomoo`15Ool5001BOol0059oo`8001Ioo`03001oogoo045oo`@005Moo`00E7oo00<007ooOol0
4goo00<007ooOol0?Goo1000Fgoo001EOol00`00Oomoo`0BOol00`00Oomoo`0hOol5001OOol005Io
o`80015oo`03001oogoo03Eoo`@006Aoo`00F7oo00<007ooOol03Woo00<007ooOol0<7oo1@00J7oo
001IOol2000>Ool00`00Oomoo`0/Ool4001]Ool005]oo`03001oogoo00]oo`03001oogoo02Moo`D0
075oo`00G7oo00<007ooOol02Woo00<007ooOol08goo1000MWoo001MOol2000:Ool00`00Oomoo`0O
Ool4001jOol005moo`03001oogoo00Moo`03001oogoo01Yoo`D007ioo`00H7oo0P001goo00<007oo
Ool05Woo1000Pgoo001ROol00`00Oomoo`04Ool00`00Oomoo`0AOol50027Ool006=oo`8000Aoo`03
001oogoo00eoo`@008aoo`00IGoo00D007ooOomoo`0000]oo`@0091oo`00IWoo00@007ooOol000Io
o`D009Aoo`00Igoo0`000Woo1000VGoo001YOol3002MOol00001
\>"],
  ImageRangeCache->{{{0, 264.313}, {287, 0}} -> {0.0486402, -0.000148683, 
  0.00324458, 0.00324458}}]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell["Reversing Helix: Kappa periodic, Tau constant.", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(clear; top = 180; kappa[s_] := 10\ Sin[s]; tau[s_] := 3.0; ds := 0.1; \n
    \(width = .5; pribbonfrenet\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 0 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.78852 .39007 m .82845 .44879 L .78841 .46253 L .704 .74 .879 r
F
.78852 .39007 m .78841 .46253 L .78917 .39735 L F
.78917 .39735 m .78841 .46253 L .74917 .46699 L .677 .746 .903 r
F
.78917 .39735 m .74917 .46699 L .79065 .40582 L F
.79065 .40582 m .74917 .46699 L .71492 .46156 L .643 .738 .918 r
F
.79065 .40582 m .71492 .46156 L .79207 .41678 L F
.79207 .41678 m .71492 .46156 L .69138 .44668 L .607 .719 .924 r
F
.79207 .41678 m .69138 .44668 L .79098 .43086 L F
.79098 .43086 m .69138 .44668 L .6854 .42572 L .575 .692 .921 r
F
.79098 .43086 m .6854 .42572 L .78418 .44719 L F
.78418 .44719 m .6854 .42572 L .70155 .40657 L .548 .661 .911 r
F
.78418 .44719 m .70441 .40798 L .76938 .4631 L F
.70441 .40798 m .70461 .40826 L .76938 .4631 L F
.70408 .40781 m .70449 .40902 L .76938 .4631 L F
.76938 .4631 m .70601 .41028 L .73634 .4007 L .53 .627 .893 r
F
.70441 .40798 m .70408 .40781 L .70461 .40826 L .548 .661 .911 r
F
.70408 .40781 m .70155 .40657 L .70449 .40902 L F
.70601 .41028 m .70155 .40657 L .73634 .4007 L .53 .627 .893 r
F
.76938 .4631 m .73999 .4076 L .74701 .47463 L F
.73999 .4076 m .73919 .40608 L .73948 .40863 L F
.73999 .4076 m .73948 .40863 L .74701 .47463 L F
.73919 .40608 m .73634 .4007 L .73799 .41215 L F
.73919 .40608 m .73799 .41215 L .74701 .47463 L F
.74842 .47161 m .73634 .4007 L .77375 .41734 L .525 .597 .869 r
F
.74701 .47463 m .74608 .46823 L .74842 .47161 L F
.74608 .46823 m .73634 .4007 L .74842 .47161 L F
.74701 .47463 m .769 .42751 L .72122 .47825 L F
.769 .42751 m .77375 .41734 L .76169 .43133 L F
.769 .42751 m .76169 .43133 L .72122 .47825 L F
.7273 .47616 m .77375 .41734 L .78992 .45466 L .538 .581 .846 r
F
.72526 .47686 m .72687 .4749 L .7273 .47616 L F
.72687 .4749 m .77375 .41734 L .7273 .47616 L F
.72122 .47825 m .7261 .47259 L .72526 .47686 L F
.7261 .47259 m .77375 .41734 L .72526 .47686 L F
.70761 .47497 m .76132 .46171 L .69907 .4729 L F
.72122 .47825 m .76132 .46171 L .70761 .47497 L F
.72122 .47825 m .77821 .45868 L .76132 .46171 L F
.77821 .45868 m .78992 .45466 L .76452 .45976 L F
.77821 .45868 m .76452 .45976 L .69907 .4729 L F
.70618 .47532 m .78992 .45466 L .76864 .49653 L .564 .585 .833 r
F
.69907 .4729 m .70832 .47105 L .70618 .47532 L F
.70832 .47105 m .78992 .45466 L .70618 .47532 L F
.68988 .45171 m .69063 .4514 L .69024 .45014 L .589 .605 .836 r
F
.68766 .46141 m .69063 .4514 L .68988 .45171 L F
.69907 .4729 m .74986 .49015 L .68766 .46141 L .564 .585 .833 r
F
.74986 .49015 m .74734 .48849 L .68766 .46141 L F
.75442 .4917 m .75023 .48855 L .74206 .485 L F
.74734 .48849 m .74206 .485 L .68766 .46141 L F
.75442 .4917 m .74206 .485 L .74734 .48849 L F
.74986 .49015 m .75442 .4917 L .74734 .48849 L F
.75442 .4917 m .76864 .49653 L .75023 .48855 L F
.69082 .46836 m .76864 .49653 L .71491 .52143 L .589 .605 .836 r
F
.68959 .46567 m .69324 .4671 L .69082 .46836 L F
.69324 .4671 m .76864 .49653 L .69082 .46836 L F
.68766 .46141 m .69627 .46515 L .68959 .46567 L F
.69627 .46515 m .76864 .49653 L .68959 .46567 L F
.68766 .46141 m .70675 .50345 L .69063 .4514 L F
.70675 .50345 m .70652 .50083 L .69024 .45014 L F
.70843 .50677 m .70642 .49691 L .69024 .45014 L F
.70885 .50809 m .70844 .50618 L .70843 .50677 L F
.70844 .50618 m .70642 .49691 L .70843 .50677 L F
.70675 .50345 m .70885 .50809 L .70652 .50083 L F
.70885 .50809 m .71491 .52143 L .70642 .49691 L F
.69024 .45014 m .71491 .52143 L .65312 .51604 L .607 .63 .848 r
F
.69024 .45014 m .66515 .49468 L .70307 .44631 L F
.66515 .49468 m .65312 .51604 L .6721 .48954 L F
.66515 .49468 m .6721 .48954 L .70307 .44631 L F
.69677 .4551 m .65312 .51604 L .69359 .45301 L .611 .652 .866 r
F
.69095 .45127 m .65312 .51604 L .61374 .48285 L F
.69359 .45301 m .65312 .51604 L .69095 .45127 L F
.69721 .4545 m .69677 .4551 L .69605 .44918 L F
.69677 .4551 m .69359 .45301 L .69605 .44918 L F
.70307 .44631 m .69721 .4545 L .69605 .44918 L F
.69605 .44918 m .69359 .45301 L .69095 .45127 L F
.70307 .44631 m .64474 .47017 L .71598 .45354 L F
.64474 .47017 m .63994 .47213 L .64712 .47038 L F
.64474 .47017 m .64712 .47038 L .71598 .45354 L F
.63994 .47213 m .64199 .47269 L .71598 .45354 L F
.6327 .4751 m .63391 .47707 L .71598 .45354 L F
.7028 .45732 m .6549 .47105 L .70157 .45194 L .6 .665 .884 r
F
.6327 .4751 m .61374 .48285 L .63391 .47707 L .611 .652 .866 r
F
.6549 .47105 m .61374 .48285 L .65404 .46867 L .6 .665 .884 r
F
.6549 .47105 m .65404 .46867 L .70157 .45194 L F
.63994 .47213 m .6327 .4751 L .64199 .47269 L .611 .652 .866 r
F
.70232 .45168 m .61374 .48285 L .61809 .44019 L .6 .665 .884 r
F
.7024 .45257 m .70157 .45194 L .70232 .45168 L F
.7028 .45732 m .70157 .45194 L .7024 .45257 L F
.71598 .45354 m .7028 .45732 L .70232 .45168 L F
.71598 .45354 m .65426 .44513 L .71797 .46875 L F
.65426 .44513 m .61809 .44019 L .66054 .45233 L F
.65426 .44513 m .66054 .45233 L .71797 .46875 L F
.70928 .46204 m .66199 .45071 L .70932 .46013 L .574 .658 .894 r
F
.66199 .45071 m .61809 .44019 L .66268 .44994 L F
.66199 .45071 m .66268 .44994 L .70932 .46013 L F
.7092 .46624 m .70516 .46509 L .70928 .46204 L F
.70516 .46509 m .61809 .44019 L .70928 .46204 L F
.70932 .46013 m .61809 .44019 L .66408 .41507 L F
.71797 .46875 m .7092 .46624 L .70932 .46013 L F
.71797 .46875 m .68507 .43598 L .7047 .48358 L F
.68507 .43598 m .66408 .41507 L .68213 .44551 L F
.68507 .43598 m .68213 .44551 L .7047 .48358 L F
.70696 .47556 m .68399 .44315 L .72075 .42665 L .543 .629 .887 r
F
.68399 .44315 m .66408 .41507 L .72075 .42665 L F
.69957 .47492 m .66408 .41507 L .70696 .47556 L F
.7047 .48358 m .69957 .47492 L .70696 .47556 L F
.7047 .48358 m .72075 .42665 L .68147 .48991 L F
.68963 .48567 m .72075 .42665 L .69233 .48641 L .533 .593 .86 r
F
.6849 .48439 m .6864 .48197 L .68963 .48567 L F
.6864 .48197 m .72075 .42665 L .68963 .48567 L F
.69233 .48641 m .72075 .42665 L .74667 .46889 L F
.68147 .48991 m .6849 .48439 L .69233 .48641 L F
.68147 .48991 m .72687 .47527 L .65952 .48503 L F
.72687 .47527 m .74667 .46889 L .70864 .47593 L F
.72687 .47527 m .70864 .47593 L .65952 .48503 L F
.66866 .48919 m .74667 .46889 L .72329 .51405 L .555 .583 .837 r
F
.65952 .48503 m .67058 .48298 L .66866 .48919 L F
.67058 .48298 m .74667 .46889 L .66866 .48919 L F
.65952 .48503 m .69756 .50234 L .64905 .47294 L F
.69756 .50234 m .72329 .51405 L .68981 .49551 L F
.69756 .50234 m .68981 .49551 L .64905 .47294 L F
.65043 .47804 m .72329 .51405 L .66608 .53599 L .587 .602 .834 r
F
.64905 .47294 m .65777 .47777 L .65043 .47804 L F
.65777 .47777 m .72329 .51405 L .65043 .47804 L F
.64905 .47294 m .65933 .511 L .65334 .4619 L F
.65933 .511 m .66304 .52477 L .66009 .50565 L F
.65933 .511 m .66009 .50565 L .65334 .4619 L F
.66304 .52477 m .66458 .52727 L .66102 .50662 L F
.66048 .50813 m .66102 .50662 L .65334 .4619 L F
.66304 .52477 m .66102 .50662 L .66048 .50813 L F
.59819 .48485 m .60676 .52638 L .57241 .49438 L .615 .66 .87 r
F
.66304 .52477 m .66608 .53599 L .66458 .52727 L .587 .602 .834 r
F
.65334 .4619 m .66608 .53599 L .60676 .52638 L .609 .632 .848 r
F
.65334 .4619 m .62547 .50047 L .66683 .45947 L F
.62547 .50047 m .62574 .50042 L .66683 .45947 L F
.62492 .50124 m .63294 .49722 L .66683 .45947 L F
.6542 .46414 m .62983 .49611 L .59819 .48485 L .615 .66 .87 r
F
.62547 .50047 m .62492 .50124 L .62574 .50042 L .609 .632 .848 r
F
.62492 .50124 m .60676 .52638 L .63294 .49722 L F
.62983 .49611 m .60676 .52638 L .59819 .48485 L .615 .66 .87 r
F
.66683 .45947 m .65891 .46829 L .6542 .46414 L F
.65891 .46829 m .60676 .52638 L .6542 .46414 L F
.66683 .45947 m .61163 .47988 L .67861 .468 L F
.61163 .47988 m .6122 .48028 L .67861 .468 L F
.60891 .48088 m .6185 .48293 L .67861 .468 L F
.60216 .46114 m .57241 .49438 L .57423 .45864 L .602 .678 .894 r
F
.66564 .46684 m .61717 .48116 L .60216 .46114 L F
.61163 .47988 m .60891 .48088 L .6122 .48028 L .615 .66 .87 r
F
.60891 .48088 m .57241 .49438 L .6185 .48293 L F
.61717 .48116 m .57241 .49438 L .60216 .46114 L .602 .678 .894 r
F
.66499 .47139 m .57241 .49438 L .66564 .46684 L F
.67861 .468 m .66499 .47139 L .66564 .46684 L F
.67861 .468 m .61963 .46271 L .67928 .48347 L F
.61963 .46271 m .61969 .46393 L .67928 .48347 L F
.61459 .46226 m .62002 .46946 L .67928 .48347 L F
.61963 .46271 m .61459 .46226 L .61969 .46393 L F
.61459 .46226 m .57423 .45864 L .62002 .46946 L F
.67078 .47825 m .6151 .46694 L .60456 .43762 L .566 .674 .912 r
F
.67053 .47837 m .57423 .45864 L .67078 .47825 L F
.67019 .48132 m .57423 .45864 L .6712 .47851 L F
.6712 .47851 m .67053 .47837 L .67078 .47825 L F
.67928 .48347 m .67019 .48132 L .6712 .47851 L F
.67928 .48347 m .63882 .45864 L .66617 .49867 L F
.63882 .45864 m .63732 .46037 L .66617 .49867 L F
.63362 .45545 m .63164 .46445 L .66617 .49867 L F
.64852 .45524 m .60456 .43762 L .64244 .44028 L .503 .634 .911 r
F
.66371 .4926 m .63277 .46384 L .64852 .45524 L F
.63882 .45864 m .63362 .45545 L .63732 .46037 L .566 .674 .912 r
F
.63362 .45545 m .60456 .43762 L .63164 .46445 L F
.63277 .46384 m .60456 .43762 L .64852 .45524 L .503 .634 .911 r
F
.66328 .49251 m .60456 .43762 L .66371 .4926 L F
.6611 .49364 m .60456 .43762 L .66391 .49309 L F
.66391 .49309 m .66328 .49251 L .66371 .4926 L F
.66617 .49867 m .6611 .49364 L .66391 .49309 L F
.66617 .49867 m .65173 .46314 L .64337 .50772 L F
.65173 .46314 m .64244 .44028 L .64285 .47016 L F
.65173 .46314 m .64285 .47016 L .64337 .50772 L F
.6456 .50341 m .64372 .4659 L .66676 .46253 L .439 .547 .869 r
F
.64533 .50305 m .64244 .44028 L .6456 .50341 L F
.6433 .50238 m .64244 .44028 L .64537 .50386 L F
.64537 .50386 m .64533 .50305 L .6456 .50341 L F
.64337 .50772 m .6433 .50238 L .64537 .50386 L F
.64337 .50772 m .65756 .48031 L .61793 .50854 L F
.65756 .48031 m .65113 .48171 L .61793 .50854 L F
.66093 .47379 m .64854 .4797 L .61793 .50854 L F
.65756 .48031 m .66093 .47379 L .65113 .48171 L F
.62229 .50714 m .6492 .48015 L .66762 .49264 L .438 .466 .791 r
F
.66093 .47379 m .66676 .46253 L .64854 .4797 L .439 .547 .869 r
F
.6492 .48015 m .66676 .46253 L .66762 .49264 L .438 .466 .791 r
F
.62238 .50671 m .66676 .46253 L .62229 .50714 L F
.62168 .505 m .66676 .46253 L .62179 .5073 L F
.62179 .5073 m .62238 .50671 L .62229 .50714 L F
.61793 .50854 m .62168 .505 L .62179 .5073 L F
.61793 .50854 m .66762 .49264 L .59596 .5026 L F
.60086 .50243 m .66762 .49264 L .59964 .50384 L .508 .462 .74 r
F
.6001 .50399 m .66762 .49264 L .64726 .51979 L F
.59964 .50384 m .60046 .5037 L .6001 .50399 L F
.60046 .5037 m .66762 .49264 L .6001 .50399 L F
.59596 .5026 m .60137 .50185 L .59964 .50384 L F
.60137 .50185 m .60238 .50171 L .60086 .50243 L F
.60238 .50171 m .66762 .49264 L .60086 .50243 L F
.59596 .5026 m .64726 .51979 L .58055 .49321 L F
.58298 .49656 m .64726 .51979 L .61363 .53863 L .588 .515 .739 r
F
.58055 .49321 m .58684 .49572 L .58298 .49656 L F
.58684 .49572 m .64726 .51979 L .58298 .49656 L F
.64372 .4659 m .64244 .44028 L .66676 .46253 L .439 .547 .869 r
F
.6151 .46694 m .57423 .45864 L .60456 .43762 L .566 .674 .912 r
F
.25 g
.5 Mabswid
.67912 .47974 m
.69187 .46194 L
s
1 0 0 r
.003 w
.70606 .52066 m
.71491 .52143 L
s
.59693 .51723 m
.60038 .52045 L
s
.57515 .49693 m
.59693 .51723 L
s
.57241 .49438 m
.57515 .49693 L
s
.62905 .52999 m
.66608 .53599 L
s
.78576 .46283 m
.78841 .46253 L
s
.25 g
.5 Mabswid
.78841 .46253 m
.78847 .45751 L
s
.78854 .45148 m
.78872 .43629 L
s
1 0 0 r
.003 w
.78841 .46253 m
.82845 .44879 L
s
.25 g
.5 Mabswid
.73501 .4499 m
.74279 .44538 L
s
.6749 .46532 m
.69041 .46087 L
s
.66403 .52409 m
.66458 .52727 L
s
.66077 .50515 m
.66403 .52409 L
s
.66044 .50322 m
.66077 .50515 L
s
.6603 .5024 m
.66044 .50322 L
s
.66458 .52727 m
.66608 .53599 L
s
1 0 0 r
.003 w
.66608 .53599 m
.70579 .52077 L
s
.70579 .52077 m
.72329 .51405 L
s
.25 g
.5 Mabswid
.71364 .51775 m
.71491 .52143 L
s
1 0 0 r
.003 w
.71491 .52143 m
.76864 .49653 L
s
.25 g
.5 Mabswid
.78852 .39007 m
.82845 .44879 L
s
.57605 .49347 m
.61479 .48385 L
s
.61479 .48385 m
.6185 .48293 L
s
.6185 .48293 m
.64294 .47686 L
s
.57241 .49438 m
.57605 .49347 L
s
.72934 .44065 m
.74034 .4389 L
s
.76169 .43133 m
.77375 .41734 L
s
.73945 .45712 m
.76169 .43133 L
s
.76452 .45976 m
.78992 .45466 L
s
.76376 .45991 m
.76452 .45976 L
s
.74364 .46395 m
.76376 .45991 L
s
.70285 .45548 m
.7036 .45428 L
s
.71908 .42935 m
.72075 .42665 L
s
.56514 .4714 m .53361 .55113 L .49423 .54737 L .716 .701 .835 r
F
.56739 .47619 m .53361 .55113 L .56514 .4714 L .692 .645 .798 r
F
.56739 .47619 m .57422 .54859 L .53361 .55113 L F
.25 g
.73634 .4007 m
.73799 .41215 L
s
.73799 .41215 m
.74376 .45212 L
s
0 g
.006 w
.66179 .5004 m
.66617 .49867 L
s
.57169 .48368 m .57422 .54859 L .56739 .47619 L .65 .581 .764 r
F
1 0 0 r
.003 w
.57416 .45998 m
.57423 .45864 L
s
.57169 .48368 m .61363 .53863 L .57422 .54859 L .65 .581 .764 r
F
1 0 0 r
.53361 .55113 m
.57422 .54859 L
s
.25 g
.5 Mabswid
.60201 .50176 m
.60311 .50161 L
s
.74296 .48539 m
.76787 .4962 L
s
.74206 .485 m
.74296 .48539 L
s
.73901 .48368 m
.74206 .485 L
s
.76787 .4962 m
.76864 .49653 L
s
.56308 .46868 m .49423 .54737 L .4586 .53679 L .726 .748 .87 r
F
.56514 .4714 m .49423 .54737 L .56308 .46868 L .716 .701 .835 r
F
.25 g
.53361 .55113 m
.544 .52486 L
s
1 0 0 r
.003 w
.49423 .54737 m
.53361 .55113 L
s
.58055 .49321 m .61363 .53863 L .57169 .48368 L .588 .515 .739 r
F
.25 g
.5 Mabswid
.58055 .49321 m
.58551 .49519 L
s
.58551 .49519 m
.58684 .49572 L
s
.58684 .49572 m
.62339 .51028 L
s
1 0 0 r
.003 w
.57422 .54859 m
.61363 .53863 L
s
.5731 .48088 m
.57416 .45998 L
s
.57289 .48498 m
.5731 .48088 L
s
0 g
.006 w
.57169 .48368 m
.58055 .49321 L
s
.25 g
.5 Mabswid
.72553 .43444 m
.73834 .43723 L
s
1 0 0 r
.003 w
.68992 .42035 m
.70155 .40657 L
s
.25 g
.5 Mabswid
.69152 .49646 m
.71248 .50807 L
s
.68981 .49551 m
.69152 .49646 L
s
.67565 .48767 m
.68981 .49551 L
s
.71248 .50807 m
.72329 .51405 L
s
.67154 .42764 m
.68142 .44431 L
s
.66408 .41507 m
.67154 .42764 L
s
1 0 0 r
.003 w
.76933 .49516 m
.78992 .45466 L
s
.76864 .49653 m
.76933 .49516 L
s
.25 g
.5 Mabswid
.57535 .48848 m
.61363 .53863 L
s
.57169 .48368 m
.57535 .48848 L
s
.60456 .43762 m
.62853 .46137 L
s
0 g
.006 w
.66617 .49867 m
.67928 .48347 L
s
.25 g
.5 Mabswid
.70155 .40657 m
.70601 .41028 L
s
.70601 .41028 m
.74206 .44033 L
s
.65337 .45028 m
.65892 .45187 L
s
.65892 .45187 m
.66054 .45233 L
s
.66054 .45233 m
.69141 .46116 L
s
1 0 0 r
.003 w
.62073 .43875 m
.66408 .41507 L
s
.25 g
.5 Mabswid
.57423 .45864 m
.61564 .46842 L
s
.61564 .46842 m
.61996 .46945 L
s
.61996 .46945 m
.64192 .47464 L
s
1 0 0 r
.003 w
.57423 .45864 m
.60456 .43762 L
s
.56072 .46661 m .4586 .53679 L .43187 .5173 L .721 .78 .899 r
F
.25 g
.5 Mabswid
.49423 .54737 m
.51493 .52371 L
s
.544 .52486 m
.54578 .52036 L
s
.56308 .46868 m .4586 .53679 L .56072 .46661 L .726 .748 .87 r
F
1 0 0 r
.003 w
.4586 .53679 m
.49423 .54737 L
s
.25 g
.5 Mabswid
.56111 .47093 m
.56308 .46868 L
s
0 g
.006 w
.66398 .45999 m
.66683 .45947 L
s
.78541 .44425 m
.79092 .43098 L
s
.79092 .43098 m
.79098 .43086 L
s
.64744 .47843 m .60383 .54649 L .49796 .54159 L .685 .786 .927 r
F
0 g
.56739 .47619 m
.57169 .48368 L
s
.25 g
.5 Mabswid
.56781 .48068 m
.57066 .51087 L
s
.57389 .5451 m
.57422 .54859 L
s
.56739 .47619 m
.56781 .48068 L
s
.67 .46413 m .60383 .54649 L .64744 .47843 L .693 .787 .923 r
F
.67 .46413 m .72694 .5051 L .60383 .54649 L F
.25 g
.65493 .47368 m
.66676 .46253 L
s
.64244 .44028 m
.64279 .46604 L
s
.62853 .46137 m
.63164 .46445 L
s
.63164 .46445 m
.64293 .47563 L
s
.64279 .46604 m
.64299 .48031 L
s
0 g
.006 w
.67861 .468 m
.67871 .4704 L
s
.25 g
.5 Mabswid
.68142 .44431 m
.69528 .46768 L
s
.689 .47779 m
.70285 .45548 L
s
.69096 .47921 m
.70864 .47593 L
s
.70864 .47593 m
.73206 .4716 L
s
0 g
.006 w
.78852 .39007 m
.78917 .39735 L
s
.56514 .4714 m
.56739 .47619 L
s
.66683 .45947 m
.67861 .468 L
s
.79098 .43086 m
.79207 .41678 L
s
.65748 .49488 m .59932 .56237 L .49979 .55059 L .679 .788 .932 r
F
1 0 0 r
.003 w
.52019 .54262 m
.52209 .54271 L
s
.25 g
.5 Mabswid
.54578 .52036 m
.56514 .4714 L
s
.63568 .52644 m .59932 .56237 L .62817 .52889 L .689 .794 .929 r
F
.68144 .48124 m .72992 .52391 L .59932 .56237 L F
.66556 .54018 m .62015 .58731 L .56147 .5911 L .647 .827 .969 r
F
.67469 .53572 m .67121 .53901 L .66556 .54018 L F
.67121 .53901 m .62015 .58731 L .66556 .54018 L F
.65126 .54691 m .56147 .5911 L .52106 .58425 L .62 .804 .971 r
F
.67469 .53572 m .56147 .5911 L .65552 .54569 L .647 .827 .969 r
F
.65552 .54569 m .6539 .54647 L .65126 .54691 L .62 .804 .971 r
F
.6539 .54647 m .56147 .5911 L .65126 .54691 L F
.65552 .54569 m .52106 .58425 L .63866 .55359 L F
.63866 .55359 m .52106 .58425 L .49886 .57029 L .598 .765 .959 r
F
.50205 .56991 m .5015 .57009 L .51998 .56866 L F
.52127 .56845 m .51998 .56866 L .62342 .56071 L F
.50205 .56991 m .51998 .56866 L .52127 .56845 L F
.63866 .55359 m .55065 .5641 L .62342 .56071 L F
.55065 .5641 m .50205 .56991 L .53462 .56744 L F
.55065 .5641 m .53462 .56744 L .62342 .56071 L F
.50205 .56991 m .49886 .57029 L .5015 .57009 L F
.68144 .48124 m .63568 .52644 L .65748 .49488 L .689 .794 .929 r
F
.63568 .52644 m .62817 .52889 L .65748 .49488 L F
.25 g
.60324 .55782 m
.61473 .54449 L
s
1 0 0 r
.003 w
.50753 .5515 m
.51947 .55292 L
s
.51947 .55292 m
.5712 .55905 L
s
.5712 .55905 m
.58215 .56034 L
s
0 g
.006 w
.78917 .39735 m
.79065 .40582 L
s
.69465 .52267 m .62015 .58731 L .67469 .53572 L .675 .834 .96 r
F
.69465 .52267 m .69382 .56891 L .62015 .58731 L F
.25 g
.5 Mabswid
.67121 .53901 m
.67469 .53572 L
s
1 0 0 r
.003 w
.56147 .5911 m
.62015 .58731 L
s
.70155 .40657 m
.73634 .4007 L
s
0 g
.006 w
.79065 .40582 m
.79207 .41678 L
s
.25 g
.5 Mabswid
.56147 .5911 m
.58009 .58211 L
s
1 0 0 r
.003 w
.52106 .58425 m
.56147 .5911 L
s
0 g
.006 w
.56308 .46868 m
.56514 .4714 L
s
.67808 .44698 m .72694 .5051 L .67 .46413 L .698 .778 .914 r
F
.68957 .46443 m .72992 .52391 L .68144 .48124 L .697 .787 .92 r
F
.7114 .50661 m .69382 .56891 L .69465 .52267 L .696 .826 .945 r
F
.67808 .44698 m .80815 .43755 L .72694 .5051 L .698 .778 .914 r
F
.68957 .46443 m .82058 .45159 L .72992 .52391 L .697 .787 .92 r
F
.7114 .50661 m .77216 .53327 L .69382 .56891 L .696 .826 .945 r
F
1 0 0 r
.003 w
.62015 .58731 m
.69382 .56891 L
s
.25 g
.5 Mabswid
.69382 .56891 m
.69465 .52267 L
s
.55916 .46357 m .43187 .5173 L .42344 .48636 L .708 .794 .918 r
F
.25 g
.4586 .53679 m
.48428 .51915 L
s
.51493 .52371 m
.51638 .52205 L
s
.56072 .46661 m .43187 .5173 L .55916 .46357 L .721 .78 .899 r
F
.25 g
.55765 .46872 m
.56072 .46661 L
s
1 0 0 r
.003 w
.43187 .5173 m
.4586 .53679 L
s
.62271 .48369 m .49796 .54159 L .46815 .48958 L .678 .776 .925 r
F
.25 g
.5 Mabswid
.43187 .5173 m
.47387 .49957 L
s
.48428 .51915 m
.48487 .51874 L
s
.64744 .47843 m .49796 .54159 L .62271 .48369 L .685 .786 .927 r
F
1 0 0 r
.003 w
.49796 .54159 m
.52019 .54262 L
s
.25 g
.5 Mabswid
.54743 .48656 m
.56111 .47093 L
s
.53077 .48719 m
.55765 .46872 L
s
.50044 .48835 m
.55802 .46405 L
s
.49796 .54159 m
.53099 .52626 L
s
1 0 0 r
.003 w
.77375 .41734 m
.78329 .43936 L
s
.7893 .45324 m
.78989 .4546 L
s
.60456 .43762 m
.64244 .44028 L
s
.66676 .46253 m
.66687 .46611 L
s
.25 g
.5 Mabswid
.67 .46413 m
.68463 .47465 L
s
.70955 .4447 m
.71363 .43813 L
s
.71363 .43813 m
.71908 .42935 L
s
1 0 0 r
.003 w
.78737 .45484 m
.79856 .44553 L
s
.79856 .44553 m
.80643 .43899 L
s
.72075 .42665 m
.73088 .44315 L
s
0 g
.006 w
.56072 .46661 m
.56308 .46868 L
s
.25 g
.5 Mabswid
.52106 .58425 m
.54253 .57866 L
s
1 0 0 r
.003 w
.66408 .41507 m
.72075 .42665 L
s
.25 g
.5 Mabswid
.68144 .48124 m
.71085 .50713 L
s
1 0 0 r
.003 w
.73634 .4007 m
.77375 .41734 L
s
.6332 .49865 m .49979 .55059 L .48264 .49632 L .673 .774 .926 r
F
1 0 0 r
.48999 .52769 m
.4957 .53765 L
s
.65748 .49488 m .49979 .55059 L .6332 .49865 L .679 .788 .932 r
F
1 0 0 r
.49979 .55059 m
.50753 .5515 L
s
.25 g
.5 Mabswid
.61473 .54449 m
.62817 .52889 L
s
.62817 .52889 m
.65748 .49488 L
s
.63462 .49843 m
.64744 .47843 L
s
.53353 .53745 m
.55117 .53059 L
s
.49979 .55059 m
.53353 .53745 L
s
.6539 .54647 m
.65552 .54569 L
s
1 0 0 r
.003 w
.64244 .44028 m
.66676 .46253 L
s
.71919 .48938 m .77216 .53327 L .7114 .50661 L .706 .808 .928 r
F
.71919 .48938 m .83501 .4822 L .77216 .53327 L F
1 0 0 r
.69382 .56891 m
.77216 .53327 L
s
.25 g
.5 Mabswid
.7114 .50661 m
.77216 .53327 L
s
.62342 .56071 m .49886 .57029 L .4943 .55199 L .587 .713 .93 r
F
.25 g
.49886 .57029 m
.5015 .57009 L
s
.5015 .57009 m
.51998 .56866 L
s
.51998 .56866 m
.53386 .5676 L
s
.53386 .5676 m
.54247 .56694 L
s
1 0 0 r
.003 w
.49886 .57029 m
.52106 .58425 L
s
.55916 .46357 m .42344 .48636 L .56092 .45823 L .708 .794 .918 r
F
0 g
.006 w
.55916 .46357 m
.56072 .46661 L
s
.25 g
.5 Mabswid
.55802 .46405 m
.55916 .46357 L
s
.56092 .45823 m .42344 .48636 L .44626 .44372 L .692 .792 .926 r
F
1 0 0 r
.003 w
.42344 .48636 m
.43187 .5173 L
s
.56092 .45823 m .44626 .44372 L .56918 .45022 L .692 .792 .926 r
F
0 g
.006 w
.55916 .46357 m
.56092 .45823 L
s
.25 g
.5 Mabswid
.42344 .48636 m
.56092 .45823 L
s
.62342 .56071 m .4943 .55199 L .60771 .56797 L .587 .713 .93 r
F
.60771 .56797 m .4943 .55199 L .5073 .53214 L .585 .655 .886 r
F
.25 g
.4943 .55199 m
.51201 .55449 L
s
.51201 .55449 m
.5241 .55619 L
s
.5241 .55619 m
.53216 .55732 L
s
1 0 0 r
.003 w
.4943 .55199 m
.49886 .57029 L
s
.25 g
.5 Mabswid
.54253 .57866 m
.59201 .56575 L
s
.58009 .58211 m
.6539 .54647 L
s
.54247 .56694 m
.57994 .56405 L
s
1 0 0 r
.003 w
.48738 .51133 m
.4983 .54588 L
s
.25 g
.5 Mabswid
.62015 .58731 m
.67121 .53901 L
s
0 g
.006 w
.64744 .47843 m
.67 .46413 L
s
.62271 .48369 m .46815 .48958 L .61039 .47795 L .678 .776 .925 r
F
0 g
.62271 .48369 m
.64744 .47843 L
s
.25 g
.5 Mabswid
.59184 .49801 m
.62271 .48369 L
s
.56918 .45022 m .51131 .39517 L .5864 .44062 L .682 .78 .925 r
F
.56918 .45022 m .44626 .44372 L .51131 .39517 L F
0 g
.006 w
.56092 .45823 m
.56918 .45022 L
s
1 0 0 r
.003 w
.42344 .48636 m
.44626 .44372 L
s
0 g
.006 w
.65748 .49488 m
.68144 .48124 L
s
.63866 .55359 m
.65552 .54569 L
s
.65552 .54569 m
.67469 .53572 L
s
.67469 .53572 m
.69465 .52267 L
s
.6332 .49865 m .48264 .49632 L .62341 .49181 L .673 .774 .926 r
F
0 g
.6332 .49865 m
.65748 .49488 L
s
.25 g
.5 Mabswid
.55117 .53059 m
.6332 .49865 L
s
.66735 .43388 m .80815 .43755 L .67808 .44698 L .695 .766 .906 r
F
.66735 .43388 m .80919 .37477 L .80815 .43755 L F
1 0 0 r
.003 w
.80643 .43899 m
.80815 .43755 L
s
.61039 .47795 m .46815 .48958 L .54445 .41619 L .677 .764 .916 r
F
1 0 0 r
.46815 .48958 m
.48999 .52769 L
s
0 g
.006 w
.62342 .56071 m
.63866 .55359 L
s
.61039 .47795 m .54445 .41619 L .61929 .46534 L .677 .764 .916 r
F
0 g
.61039 .47795 m
.62271 .48369 L
s
.25 g
.5 Mabswid
.46815 .48958 m
.61039 .47795 L
s
.71286 .47469 m .83501 .4822 L .71919 .48938 L .707 .786 .913 r
F
.67521 .45361 m .82058 .45159 L .68957 .46443 L .697 .773 .91 r
F
.67521 .45361 m .809 .38502 L .82058 .45159 L F
.71286 .47469 m .85388 .42614 L .83501 .4822 L .707 .786 .913 r
F
1 0 0 r
.003 w
.77216 .53327 m
.83501 .4822 L
s
.25 g
.5 Mabswid
.71919 .48938 m
.83501 .4822 L
s
.67808 .44698 m
.6898 .44613 L
s
0 g
.006 w
.69465 .52267 m
.7114 .50661 L
s
.60771 .56797 m .5073 .53214 L .5891 .57542 L .585 .655 .886 r
F
.5891 .57542 m .5073 .53214 L .53697 .51472 L .59 .606 .837 r
F
.25 g
.5 Mabswid
.5073 .53214 m
.58721 .57442 L
s
1 0 0 r
.003 w
.4943 .55199 m
.5073 .53214 L
s
.25 g
.5 Mabswid
.53216 .55732 m
.56315 .56169 L
s
0 g
.006 w
.60771 .56797 m
.62342 .56071 L
s
.5864 .44062 m .61591 .35538 L .61233 .43225 L .679 .767 .918 r
F
.5864 .44062 m .51131 .39517 L .61591 .35538 L F
0 g
.58383 .44205 m
.5864 .44062 L
s
.5891 .57542 m .53697 .51472 L .56604 .58203 L .59 .606 .837 r
F
0 g
.5891 .57542 m
.60771 .56797 L
s
.67 .46413 m
.67808 .44698 L
s
.56604 .58203 m .53697 .51472 L .57813 .50548 L .599 .573 .795 r
F
.56604 .58203 m .57813 .50548 L .53911 .58577 L F
0 g
.56604 .58203 m
.5891 .57542 L
s
.53911 .58577 m .57813 .50548 L .61808 .51059 L .611 .554 .765 r
F
.53911 .58577 m .61808 .51059 L .51192 .58423 L F
0 g
.53911 .58577 m
.56604 .58203 L
s
.62341 .49181 m .55938 .42842 L .63438 .47939 L .674 .76 .916 r
F
.62341 .49181 m .48264 .49632 L .55938 .42842 L F
0 g
.62341 .49181 m
.6332 .49865 L
s
.25 g
.5 Mabswid
.48264 .49632 m
.62341 .49181 L
s
.44626 .44372 m
.51221 .44721 L
s
1 0 0 r
.003 w
.48264 .49632 m
.48738 .51133 L
s
0 g
.006 w
.7114 .50661 m
.71919 .48938 L
s
.51192 .58423 m .61808 .51059 L .63748 .53264 L .625 .547 .746 r
F
.51192 .58423 m .63174 .535 L .49081 .57583 L F
.63174 .535 m .63131 .53504 L .49081 .57583 L F
.63131 .53504 m .62817 .53538 L .6254 .5362 L F
.63131 .53504 m .6254 .5362 L .49081 .57583 L F
.63174 .535 m .63748 .53264 L .62817 .53538 L F
.49081 .57583 m .63748 .53264 L .61895 .56619 L .641 .552 .738 r
F
.49081 .57583 m .60338 .56736 L .48279 .56124 L F
.60338 .56736 m .61895 .56619 L .597 .56539 L F
.60338 .56736 m .597 .56539 L .48279 .56124 L F
.48709 .56323 m .61895 .56619 L .56018 .597 L .658 .569 .743 r
F
.48279 .56124 m .49498 .56168 L .48709 .56323 L F
.49498 .56168 m .61895 .56619 L .48709 .56323 L F
.48279 .56124 m .54608 .59048 L .4919 .54418 L F
.54608 .59048 m .56018 .597 L .54428 .5847 L F
.54608 .59048 m .54428 .5847 L .4919 .54418 L F
.49091 .55019 m .54311 .58547 L .4814 .60812 L .673 .595 .76 r
F
.54311 .58547 m .56018 .597 L .4814 .60812 L F
.4919 .54418 m .49859 .54936 L .49091 .55019 L F
.49859 .54936 m .56018 .597 L .49091 .55019 L F
.4919 .54418 m .48382 .59335 L .51542 .53076 L F
.48382 .59335 m .4814 .60812 L .49115 .58595 L F
.48382 .59335 m .49115 .58595 L .51542 .53076 L F
.50516 .53704 m .4814 .60812 L .41916 .58966 L .68 .623 .784 r
F
.51542 .53076 m .51176 .53908 L .50516 .53704 L F
.51176 .53908 m .4814 .60812 L .50516 .53704 L F
.51542 .53076 m .43909 .57747 L .54268 .52678 L F
.43909 .57747 m .44456 .57601 L .54268 .52678 L F
.42743 .5846 m .43055 .58386 L .4377 .58022 L F
.43596 .58032 m .4377 .58022 L .54268 .52678 L F
.42743 .5846 m .4377 .58022 L .43596 .58032 L F
.52698 .52909 m .45638 .56875 L .40849 .54652 L .678 .642 .807 r
F
.43909 .57747 m .42743 .5846 L .44456 .57601 L .68 .623 .784 r
F
.42743 .5846 m .41916 .58966 L .43055 .58386 L F
.45638 .56875 m .41916 .58966 L .40849 .54652 L .678 .642 .807 r
F
.54268 .52678 m .52851 .534 L .52698 .52909 L F
.52851 .534 m .41916 .58966 L .52698 .52909 L F
.54268 .52678 m .44955 .54048 L .55904 .53399 L F
.44955 .54048 m .40849 .54652 L .46337 .54195 L F
.44955 .54048 m .46337 .54195 L .55904 .53399 L F
.54683 .52965 m .4298 .54392 L .46136 .49925 L .667 .647 .82 r
F
.55904 .53399 m .54106 .53549 L .54683 .52965 L F
.54106 .53549 m .40849 .54652 L .54683 .52965 L F
.55904 .53399 m .49423 .51094 L .55429 .54792 L F
.49423 .51094 m .49521 .51286 L .55429 .54792 L F
.48858 .50893 m .48929 .51387 L .49805 .51847 L F
.49521 .51286 m .49805 .51847 L .55429 .54792 L F
.48858 .50893 m .49805 .51847 L .49521 .51286 L F
.55429 .54792 m .54967 .5455 L .55411 .54227 L .653 .635 .819 r
F
.48858 .50893 m .46136 .49925 L .48929 .51387 L .667 .647 .82 r
F
.54967 .5455 m .46136 .49925 L .55411 .54227 L .653 .635 .819 r
F
.49423 .51094 m .48858 .50893 L .49521 .51286 L .667 .647 .82 r
F
.55411 .54227 m .46136 .49925 L .55194 .47534 L .653 .635 .819 r
F
.55429 .54792 m .55279 .50161 L .53008 .55975 L F
.55279 .50161 m .54914 .50494 L .53008 .55975 L F
.55258 .49503 m .54312 .50941 L .53008 .55975 L F
.55258 .49503 m .55194 .47534 L .54312 .50941 L F
.54119 .55025 m .55194 .47534 L .54427 .54943 L .641 .61 .803 r
F
.5319 .55273 m .53277 .54935 L .54119 .55025 L F
.53277 .54935 m .55194 .47534 L .54119 .55025 L F
.55279 .50161 m .55258 .49503 L .54914 .50494 L .653 .635 .819 r
F
.54427 .54943 m .55194 .47534 L .62434 .4912 L .641 .61 .803 r
F
.53008 .55975 m .5319 .55273 L .54427 .54943 L F
.53008 .55975 m .5141 .5535 L .49992 .56151 L F
.53008 .55975 m .58845 .5173 L .5141 .5535 L F
.58845 .5173 m .57015 .52183 L .5141 .5535 L F
.5141 .5535 m .51545 .55273 L .51009 .55959 L .637 .582 .776 r
F
.51545 .55273 m .51687 .55553 L .51009 .55959 L F
.51009 .55959 m .51687 .55553 L .51816 .55807 L F
.58845 .5173 m .62434 .4912 L .57015 .52183 L .641 .61 .803 r
F
.51545 .55273 m .62434 .4912 L .51687 .55553 L .637 .582 .776 r
F
.51816 .55807 m .62434 .4912 L .62958 .53706 L F
.51687 .55553 m .62434 .4912 L .51816 .55807 L F
.49992 .56151 m .5141 .5535 L .51009 .55959 L F
.49992 .56151 m .57877 .54664 L .48136 .55115 L F
.57877 .54664 m .62546 .53783 L .56448 .54347 L F
.57877 .54664 m .56448 .54347 L .48136 .55115 L F
.49536 .55641 m .56622 .54619 L .56401 .58219 L .646 .57 .754 r
F
.62546 .53783 m .62958 .53706 L .62819 .53719 L .637 .582 .776 r
F
.62546 .53783 m .62819 .53719 L .59637 .54022 L F
.59656 .54051 m .59637 .54022 L .48136 .55115 L F
.62546 .53783 m .59637 .54022 L .59656 .54051 L F
.50024 .54936 m .62958 .53706 L .49332 .55564 L .646 .57 .754 r
F
.49332 .55564 m .49522 .55539 L .49536 .55641 L F
.49522 .55539 m .62958 .53706 L .49536 .55641 L F
.48136 .55115 m .50024 .54936 L .49332 .55564 L F
.48136 .55115 m .53122 .56988 L .48527 .53399 L F
.53122 .56988 m .53005 .5653 L .48527 .53399 L F
.48306 .54335 m .52627 .56409 L .47021 .59777 L .665 .586 .756 r
F
.53122 .56988 m .54286 .57425 L .53005 .5653 L .646 .57 .754 r
F
.54286 .57425 m .56401 .58219 L .55034 .57382 L F
.54286 .57425 m .55034 .57382 L .48527 .53399 L F
.52627 .56409 m .56401 .58219 L .47021 .59777 L .665 .586 .756 r
F
.48527 .53399 m .49553 .54027 L .48306 .54335 L F
.49553 .54027 m .56401 .58219 L .48306 .54335 L F
.48527 .53399 m .4762 .57239 L .50888 .51968 L F
.4762 .57239 m .47021 .59777 L .48745 .56296 L F
.4762 .57239 m .48745 .56296 L .50888 .51968 L F
.49363 .52776 m .48107 .56532 L .40426 .5751 L .679 .619 .781 r
F
.50888 .51968 m .50377 .53 L .49363 .52776 L F
.50377 .53 m .47021 .59777 L .49363 .52776 L F
.4298 .54392 m .40849 .54652 L .42891 .52826 L .667 .647 .82 r
F
.4298 .54392 m .42891 .52826 L .46136 .49925 L F
.50888 .51968 m .44592 .55303 L .53706 .51623 L .679 .619 .781 r
F
.44592 .55303 m .44695 .55279 L .53706 .51623 L F
.44452 .55378 m .45609 .55212 L .53706 .51623 L F
.51795 .51788 m .4565 .54881 L .4019 .52788 L .679 .646 .809 r
F
.44592 .55303 m .44452 .55378 L .44695 .55279 L .679 .619 .781 r
F
.44452 .55378 m .40426 .5751 L .45609 .55212 L F
.4565 .54881 m .40426 .5751 L .4019 .52788 L .679 .646 .809 r
F
.53706 .51623 m .51951 .52401 L .51795 .51788 L F
.51951 .52401 m .40426 .5751 L .51795 .51788 L F
.53706 .51623 m .45579 .52323 L .55185 .52486 L F
.45579 .52323 m .4019 .52788 L .46883 .52653 L F
.45579 .52323 m .46883 .52653 L .55185 .52486 L F
.53965 .51917 m .4019 .52788 L .46115 .48257 L .667 .653 .827 r
F
.55185 .52486 m .5324 .52525 L .53965 .51917 L F
.5324 .52525 m .4019 .52788 L .53965 .51917 L F
.55185 .52486 m .49869 .50007 L .54403 .53934 L F
.49869 .50007 m .49736 .49945 L .49851 .50044 L F
.49869 .50007 m .49851 .50044 L .54403 .53934 L F
.49736 .49945 m .49772 .50297 L .54403 .53934 L F
.48722 .49472 m .49569 .50623 L .54403 .53934 L F
.54422 .52968 m .49852 .50376 L .54551 .46297 L .648 .639 .827 r
F
.49736 .49945 m .48722 .49472 L .49772 .50297 L .667 .653 .827 r
F
.48722 .49472 m .46115 .48257 L .49569 .50623 L F
.49852 .50376 m .46115 .48257 L .54551 .46297 L .648 .639 .827 r
F
.5336 .5322 m .46115 .48257 L .54422 .52968 L F
.54403 .53934 m .5336 .5322 L .54422 .52968 L F
.54403 .53934 m .54487 .49587 L .51806 .55044 L F
.54487 .49587 m .54347 .49648 L .51806 .55044 L F
.54492 .49341 m .53392 .50157 L .51806 .55044 L F
.54492 .49341 m .54545 .46607 L .53392 .50157 L F
.54545 .46607 m .54551 .46297 L .54482 .46516 L F
.54545 .46607 m .54482 .46516 L .53323 .50209 L F
.53392 .50157 m .53323 .50209 L .51806 .55044 L F
.54545 .46607 m .53323 .50209 L .53392 .50157 L F
.52626 .52963 m .54551 .46297 L .53134 .52858 L .631 .606 .807 r
F
.52626 .52963 m .53134 .52858 L .52848 .5418 L F
.52249 .54265 m .52626 .52963 L .52848 .5418 L F
.52041 .54295 m .5211 .54076 L .52249 .54265 L F
.5211 .54076 m .54551 .46297 L .52249 .54265 L F
.54487 .49587 m .54492 .49341 L .54347 .49648 L .648 .639 .827 r
F
.52867 .54165 m .54551 .46297 L .60752 .47627 L .631 .606 .807 r
F
.52853 .54161 m .54551 .46297 L .52867 .54165 L F
.52848 .5418 m .52853 .54161 L .52867 .54165 L F
.51806 .55044 m .52041 .54295 L .52848 .5418 L F
.51806 .55044 m .56746 .50949 L .48771 .55157 L F
.56746 .50949 m .56486 .50957 L .48771 .55157 L F
.57211 .50562 m .55428 .50973 L .48771 .55157 L F
.56746 .50949 m .57211 .50562 L .56486 .50957 L F
.57211 .50562 m .60752 .47627 L .55428 .50973 L F
.50227 .54702 m .60752 .47627 L .58429 .52136 L .621 .562 .767 r
F
.48771 .55157 m .50183 .5427 L .50227 .54702 L F
.50183 .5427 m .60752 .47627 L .50227 .54702 L F
.48771 .55157 m .55784 .52963 L .46721 .54179 L F
.55784 .52963 m .55549 .52843 L .46721 .54179 L F
.56747 .52662 m .56031 .52554 L .46721 .54179 L F
.58429 .52136 m .56 .52268 L .55209 .52431 L F
.56031 .52554 m .55209 .52431 L .46721 .54179 L F
.58429 .52136 m .55209 .52431 L .56031 .52554 L F
.47961 .53924 m .4846 .53821 L .47818 .54217 L .627 .526 .72 r
F
.58429 .52136 m .60752 .47627 L .61882 .51056 L .621 .562 .767 r
F
.58429 .52136 m .61882 .51056 L .56 .52268 L F
.4846 .53821 m .61882 .51056 L .47974 .54182 L .627 .526 .72 r
F
.4846 .53821 m .47974 .54182 L .47818 .54217 L F
.55784 .52963 m .56747 .52662 L .55549 .52843 L .621 .562 .767 r
F
.56747 .52662 m .58429 .52136 L .56031 .52554 L F
.47922 .54221 m .61882 .51056 L .53793 .54424 L .627 .526 .72 r
F
.56622 .54619 m .62958 .53706 L .56401 .58219 L .646 .57 .754 r
F
.53793 .54424 m .61882 .51056 L .58277 .54579 L .627 .526 .72 r
F
.47818 .54217 m .47974 .54182 L .47922 .54221 L F
.47974 .54182 m .61882 .51056 L .47922 .54221 L F
.46721 .54179 m .47961 .53924 L .47818 .54217 L F
.46721 .54179 m .53793 .54424 L .46435 .5251 L F
.53793 .54424 m .53457 .54057 L .46435 .5251 L F
.55364 .54478 m .53849 .53805 L .53105 .53675 L F
.53457 .54057 m .53105 .53675 L .46435 .5251 L F
.55364 .54478 m .53105 .53675 L .53457 .54057 L F
.4724 .52742 m .47536 .52791 L .46944 .52871 L .655 .529 .698 r
F
.55364 .54478 m .58277 .54579 L .53849 .53805 L .627 .526 .72 r
F
.47536 .52791 m .58277 .54579 L .47093 .52893 L .655 .529 .698 r
F
.47536 .52791 m .47093 .52893 L .46944 .52871 L F
.4739 .52677 m .47641 .5272 L .4724 .52742 L F
.47641 .5272 m .58277 .54579 L .4724 .52742 L F
.53793 .54424 m .55364 .54478 L .53457 .54057 L .627 .526 .72 r
F
.46944 .52871 m .58277 .54579 L .52324 .56689 L .655 .529 .698 r
F
.46435 .5251 m .4739 .52677 L .46944 .52871 L F
.46435 .5251 m .50898 .55677 L .47847 .50755 L F
.50898 .55677 m .50703 .54541 L .47847 .50755 L F
.48285 .51334 m .48329 .51394 L .48053 .51232 L .695 .578 .72 r
F
.50898 .55677 m .52324 .56689 L .50703 .54541 L .655 .529 .698 r
F
.48329 .51394 m .52324 .56689 L .4816 .51368 L .695 .578 .72 r
F
.48329 .51394 m .4816 .51368 L .48053 .51232 L F
.48053 .51232 m .4816 .51368 L .47747 .51242 L F
.4816 .51368 m .52324 .56689 L .47809 .51315 L F
.4816 .51368 m .47809 .51315 L .47747 .51242 L F
.48203 .51227 m .48285 .51334 L .48053 .51232 L F
.48107 .56532 m .47021 .59777 L .40426 .5751 L .679 .619 .781 r
F
.47747 .51242 m .52324 .56689 L .46573 .56918 L .695 .578 .72 r
F
.47847 .50755 m .48203 .51227 L .47747 .51242 L F
.47847 .50755 m .46873 .55468 L .49945 .50111 L F
.46873 .55468 m .47889 .54262 L .49945 .50111 L F
.47847 .50755 m .49945 .50111 L .50285 .49423 L F
.49945 .50111 m .49905 .50191 L .49921 .4997 L .726 .653 .776 r
F
.46873 .55468 m .46573 .56918 L .47889 .54262 L .695 .578 .72 r
F
.49905 .50191 m .46573 .56918 L .49845 .50126 L .726 .653 .776 r
F
.49905 .50191 m .49845 .50126 L .49921 .4997 L F
.49921 .4997 m .49845 .50126 L .49728 .49872 L F
.49845 .50126 m .46573 .56918 L .4969 .49957 L F
.49845 .50126 m .4969 .49957 L .49728 .49872 L F
.49996 .50008 m .49945 .50111 L .49921 .4997 L F
.49728 .49872 m .46573 .56918 L .42596 .55605 L F
.50285 .49423 m .49996 .50008 L .49728 .49872 L F
.50285 .49423 m .44373 .54177 L .52905 .48756 L F
.44373 .54177 m .42596 .55605 L .46217 .532 L F
.44373 .54177 m .46217 .532 L .52905 .48756 L F
.52344 .48972 m .42596 .55605 L .40833 .53416 L .732 .722 .841 r
F
.52905 .48756 m .52045 .49327 L .52344 .48972 L F
.52045 .49327 m .42596 .55605 L .52344 .48972 L F
.52905 .48756 m .40833 .53416 L .55066 .48715 L F
.5451 .48803 m .40833 .53416 L .41009 .50956 L .712 .77 .898 r
F
.55066 .48715 m .54035 .49055 L .5451 .48803 L F
.54035 .49055 m .40833 .53416 L .5451 .48803 L F
1 0 0 r
.003 w
.44626 .44372 m
.51131 .39517 L
s
.61233 .43225 m .73165 .34445 L .64227 .42897 L .682 .758 .909 r
F
.61233 .43225 m .61591 .35538 L .73165 .34445 L F
.64227 .42897 m .80919 .37477 L .66735 .43388 L .688 .758 .905 r
F
.64227 .42897 m .73165 .34445 L .80919 .37477 L F
.61929 .46534 m .69077 .36934 L .64597 .45452 L .683 .757 .908 r
F
.61929 .46534 m .54445 .41619 L .69077 .36934 L F
0 g
.006 w
.68144 .48124 m
.68957 .46443 L
s
.25 g
.5 Mabswid
.68957 .46443 m
.76381 .45715 L
s
0 g
.006 w
.66735 .43388 m
.67808 .44698 L
s
.61748 .4679 m
.61929 .46534 L
s
1 0 0 r
.003 w
.48 .47819 m
.54445 .41619 L
s
.25 g
.5 Mabswid
.51131 .39517 m
.54549 .41586 L
s
.62934 .53504 m
.63748 .53264 L
s
1 0 0 r
.003 w
.80902 .38516 m
.80919 .37477 L
s
0 g
.006 w
.65781 .43201 m
.66735 .43388 L
s
.25 g
.5 Mabswid
.4814 .60812 m
.48719 .59495 L
s
1 0 0 r
.003 w
.41916 .58966 m
.4814 .60812 L
s
.4814 .60812 m
.56018 .597 L
s
.25 g
.5 Mabswid
.42142 .58851 m
.43023 .58403 L
s
.41916 .58966 m
.42142 .58851 L
s
1 0 0 r
.003 w
.41661 .57935 m
.41916 .58966 L
s
.25 g
.5 Mabswid
.59649 .56537 m
.61895 .56619 L
s
.58885 .56509 m
.59649 .56537 L
s
.64597 .45452 m .809 .38502 L .67521 .45361 L .691 .761 .905 r
F
.64597 .45452 m .69077 .36934 L .809 .38502 L F
.63438 .47939 m .68974 .38426 L .6612 .4691 L .681 .753 .906 r
F
.25 g
.70354 .37104 m
.73165 .34445 L
s
.79048 .38257 m
.80434 .37679 L
s
.63438 .47939 m .55938 .42842 L .68974 .38426 L .681 .753 .906 r
F
0 g
.006 w
.62401 .49113 m
.63438 .47939 L
s
.67521 .45361 m
.68957 .46443 L
s
.25 g
.5 Mabswid
.55938 .42842 m
.63438 .47939 L
s
.61412 .39388 m
.61591 .35538 L
s
1 0 0 r
.003 w
.51137 .4709 m
.55938 .42842 L
s
.25 g
.5 Mabswid
.54445 .41619 m
.56182 .4276 L
s
.80434 .37679 m
.80919 .37477 L
s
0 g
.006 w
.66632 .45389 m
.67521 .45361 L
s
.25 g
.5 Mabswid
.5451 .58533 m
.56018 .597 L
s
1 0 0 r
.003 w
.56018 .597 m
.61895 .56619 L
s
.69147 .46703 m .85388 .42614 L .71286 .47469 L .7 .767 .904 r
F
0 g
.006 w
.71286 .47469 m
.71919 .48938 L
s
.6612 .4691 m .80417 .38576 L .69147 .46703 L .691 .755 .901 r
F
.6612 .4691 m .68974 .38426 L .80417 .38576 L F
0 g
.63438 .47939 m
.6612 .4691 L
s
.25 g
.5 Mabswid
.68144 .38707 m
.69077 .36934 L
s
.6612 .4691 m
.68974 .38426 L
s
.69147 .46703 m .80417 .38576 L .85388 .42614 L .7 .767 .904 r
F
.25 g
.69147 .46703 m
.80417 .38576 L
s
0 g
.006 w
.6612 .4691 m
.69147 .46703 L
s
.69147 .46703 m
.71286 .47469 L
s
.25 g
.5 Mabswid
.80787 .44198 m
.85388 .42614 L
s
.71286 .47469 m
.80787 .44198 L
s
.80549 .38682 m
.809 .38502 L
s
1 0 0 r
.003 w
.83501 .4822 m
.85388 .42614 L
s
.809 .38502 m
.80994 .39044 L
s
.43741 .65475 m .39674 .68453 L .33409 .65095 L .444 .681 .965 r
F
.5437 .60203 m .49121 .64569 L .41181 .59802 L .523 .692 .945 r
F
.50179 .62325 m .45508 .66499 L .37187 .6122 L .505 .686 .948 r
F
.46764 .65311 m .39674 .68453 L .43741 .65475 L .492 .709 .967 r
F
.5735 .59894 m .49121 .64569 L .5437 .60203 L .545 .701 .942 r
F
.52947 .61952 m .45508 .66499 L .50179 .62325 L .529 .702 .949 r
F
.5735 .59894 m .59767 .66169 L .49121 .64569 L .545 .701 .942 r
F
.52947 .61952 m .57352 .68001 L .45508 .66499 L .529 .702 .949 r
F
.46764 .65311 m .48346 .70368 L .39674 .68453 L .492 .709 .967 r
F
.4931 .64449 m .48346 .70368 L .46764 .65311 L .533 .719 .959 r
F
.4931 .64449 m .57474 .69723 L .48346 .70368 L F
1 0 0 r
.39674 .68453 m
.48346 .70368 L
s
.54188 .676 m
.56083 .6784 L
s
.25 g
.5 Mabswid
.46764 .65311 m
.48346 .70368 L
s
1 0 0 r
.003 w
.61895 .56619 m
.63748 .53264 L
s
.25 g
.5 Mabswid
.47634 .58539 m
.48474 .56842 L
s
.50287 .53183 m
.50314 .53127 L
s
.47021 .59777 m
.47634 .58539 L
s
1 0 0 r
.003 w
.40426 .5751 m
.47021 .59777 L
s
.47021 .59777 m
.52719 .58831 L
s
.52719 .58831 m
.56401 .58219 L
s
.25 g
.5 Mabswid
.42275 .5669 m
.43815 .56008 L
s
.50216 .5317 m
.51597 .52558 L
s
.40426 .5751 m
.42275 .5669 L
s
1 0 0 r
.003 w
.4019 .52788 m
.40426 .5751 L
s
.25 g
.5 Mabswid
.61431 .49687 m
.62434 .4912 L
s
1 0 0 r
.003 w
.62782 .52166 m
.63748 .53264 L
s
.80417 .38576 m
.85388 .42614 L
s
.25 g
.5 Mabswid
.58762 .54105 m
.62819 .53719 L
s
.62819 .53719 m
.62958 .53706 L
s
.51362 .52662 m
.52114 .53056 L
s
1 0 0 r
.003 w
.73165 .34445 m
.80919 .37477 L
s
.51131 .39517 m
.61591 .35538 L
s
.59691 .58742 m .59767 .66169 L .5735 .59894 L .56 .698 .932 r
F
.59691 .58742 m .69068 .64167 L .59767 .66169 L F
1 0 0 r
.55557 .65536 m
.59767 .66169 L
s
.40914 .65121 m .33409 .65095 L .30268 .61393 L .407 .639 .951 r
F
.43741 .65475 m .33409 .65095 L .40914 .65121 L .444 .681 .965 r
F
1 0 0 r
.33409 .65095 m
.39674 .68453 L
s
.25 g
.5 Mabswid
.39674 .68453 m
.43741 .65475 L
s
.53323 .56335 m
.56401 .58219 L
s
1 0 0 r
.003 w
.56401 .58219 m
.61267 .5487 L
s
.61267 .5487 m
.62958 .53706 L
s
.54445 .41619 m
.57004 .408 L
s
.57004 .408 m
.69077 .36934 L
s
.54493 .60629 m .57352 .68001 L .52947 .61952 L .553 .704 .941 r
F
.54493 .60629 m .66567 .64545 L .57352 .68001 L F
1 0 0 r
.56083 .6784 m
.57352 .68001 L
s
.25 g
.5 Mabswid
.5735 .59894 m
.58081 .61793 L
s
.49243 .52605 m
.52371 .52543 L
s
.4019 .52788 m
.40879 .52774 L
s
1 0 0 r
.003 w
.45295 .48883 m
.46115 .48257 L
s
.43 .50639 m
.45295 .48883 L
s
.4019 .52788 m
.40918 .52231 L
s
.69077 .36934 m
.809 .38502 L
s
.51693 .59654 m .41181 .59802 L .39897 .53819 L .512 .675 .938 r
F
.5437 .60203 m .41181 .59802 L .51693 .59654 L .523 .692 .945 r
F
1 0 0 r
.41181 .59802 m
.44593 .6185 L
s
.25 g
.5 Mabswid
.52136 .62061 m
.5437 .60203 L
s
1 0 0 r
.003 w
.55938 .42842 m
.68974 .38426 L
s
.25 g
.5 Mabswid
.55946 .50647 m
.60752 .47627 L
s
.55428 .50973 m
.55946 .50647 L
s
.55397 .50993 m
.55428 .50973 L
s
.52085 .53074 m
.55397 .50993 L
s
.53423 .49892 m
.53645 .49184 L
s
.54308 .4707 m
.54482 .46516 L
s
.53785 .48739 m
.54308 .4707 L
s
.53323 .50209 m
.53423 .49892 L
s
.52507 .52809 m
.53323 .50209 L
s
.54482 .46516 m
.54551 .46297 L
s
.56 .52268 m
.61882 .51056 L
s
.55209 .52431 m
.56 .52268 L
s
.54865 .52501 m
.55209 .52431 L
s
.50975 .53303 m
.54865 .52501 L
s
.47566 .61708 m .37187 .6122 L .36757 .55115 L .5 .665 .936 r
F
.50179 .62325 m .37187 .6122 L .47566 .61708 L .505 .686 .948 r
F
1 0 0 r
.003 w
.37187 .6122 m
.43881 .65468 L
s
.25 g
.5 Mabswid
.46115 .48257 m
.46597 .48587 L
s
.46597 .48587 m
.46834 .48749 L
s
.46834 .48749 m
.4722 .49014 L
s
.4722 .49014 m
.48347 .49786 L
s
.49828 .508 m
.52552 .52666 L
s
.50628 .62973 m .57474 .69723 L .4931 .64449 L .559 .714 .944 r
F
.25 g
.46882 .65271 m
.50179 .62325 L
s
.50628 .62973 m .63847 .65908 L .57474 .69723 L .559 .714 .944 r
F
1 0 0 r
.003 w
.48346 .70368 m
.57474 .69723 L
s
.25 g
.5 Mabswid
.52947 .61952 m
.54282 .63784 L
s
.4931 .64449 m
.57474 .69723 L
s
1 0 0 r
.003 w
.62434 .4912 m
.62958 .53706 L
s
.61152 .4884 m
.62434 .4912 L
s
.25 g
.5 Mabswid
.53849 .53805 m
.58277 .54579 L
s
.53105 .53675 m
.53849 .53805 L
s
.52614 .53589 m
.53105 .53675 L
s
.52211 .53519 m
.52614 .53589 L
s
.49586 .5306 m
.52211 .53519 L
s
1 0 0 r
.003 w
.61591 .35538 m
.73165 .34445 L
s
.46115 .48257 m
.54551 .46297 L
s
.68974 .38426 m
.80417 .38576 L
s
.25 g
.5 Mabswid
.46573 .56918 m
.47889 .54262 L
s
.47889 .54262 m
.48202 .5363 L
s
.48202 .5363 m
.49493 .51022 L
s
1 0 0 r
.003 w
.45339 .56511 m
.46573 .56918 L
s
.46573 .56918 m
.52324 .56689 L
s
.40914 .65121 m .30268 .61393 L .38661 .64538 L .407 .639 .951 r
F
.37911 .63983 m .30268 .61393 L .30039 .58154 L .401 .595 .923 r
F
.38213 .6437 m .30268 .61393 L .37911 .63983 L F
.38661 .64538 m .38213 .6437 L .37911 .63983 L F
.38661 .64538 m .30039 .58154 L .37038 .63983 L F
.36704 .63442 m .30039 .58154 L .31986 .55805 L .433 .565 .887 r
F
.36699 .63475 m .30039 .58154 L .36704 .63442 L F
.36807 .63791 m .30039 .58154 L .36749 .63515 L F
.36749 .63515 m .36699 .63475 L .36704 .63442 L F
.37038 .63983 m .36807 .63791 L .36749 .63515 L F
.37038 .63983 m .3369 .58564 L .35885 .63603 L F
.3369 .58564 m .32783 .57399 L .35885 .63603 L F
.3369 .58564 m .31986 .55805 L .32783 .57399 L F
.35882 .63559 m .31986 .55805 L .35257 .54452 L .489 .557 .852 r
F
.35885 .63603 m .35871 .63576 L .35882 .63559 L F
.35871 .63576 m .31986 .55805 L .35882 .63559 L F
.35493 .63523 m .35457 .57367 L .34962 .63416 L F
.35885 .63603 m .35882 .63559 L .35493 .63523 L F
.35882 .63559 m .35457 .57367 L .35493 .63523 L F
.35457 .57367 m .35201 .56149 L .34962 .63416 L F
.35457 .57367 m .35257 .54452 L .35201 .56149 L F
.47566 .61708 m .36757 .55115 L .46356 .60642 L .5 .665 .936 r
F
.51693 .59654 m .39897 .53819 L .50304 .58635 L .512 .675 .938 r
F
.55066 .48715 m .41384 .50897 L .56503 .49102 L .712 .77 .898 r
F
.41384 .50897 m .41009 .50956 L .41415 .50908 L F
.41384 .50897 m .41415 .50908 L .56503 .49102 L F
.50304 .58635 m .48292 .53374 L .50691 .57834 L .519 .663 .926 r
F
.56503 .49102 m .41009 .50956 L .42671 .4862 L .669 .792 .94 r
F
.48292 .53374 m .46989 .49966 L .48653 .53503 L .519 .663 .926 r
F
.48292 .53374 m .48653 .53503 L .50691 .57834 L F
.50304 .58635 m .39897 .53819 L .46989 .49966 L F
.46356 .60642 m .36757 .55115 L .44721 .51892 L .517 .656 .922 r
F
.34962 .63416 m .35257 .54452 L .39117 .54052 L .551 .571 .828 r
F
.34962 .63416 m .37533 .57621 L .3408 .63328 L F
.37533 .57621 m .37659 .56736 L .3408 .63328 L F
.37533 .57621 m .39117 .54052 L .37659 .56736 L F
.3408 .63328 m .39117 .54052 L .42938 .54576 L .607 .601 .819 r
F
.3408 .63328 m .39794 .57683 L .33187 .63181 L F
.39794 .57683 m .42938 .54576 L .4033 .56878 L F
.39794 .57683 m .4033 .56878 L .33187 .63181 L F
.25 g
.5 Mabswid
.30268 .61393 m
.33739 .62693 L
s
1 0 0 r
.003 w
.37123 .60321 m
.37137 .60521 L
s
.37137 .60521 m
.37187 .6122 L
s
.25 g
.5 Mabswid
.43155 .61501 m
.47566 .61708 L
s
.38305 .61273 m
.43155 .61501 L
s
.37187 .6122 m
.38305 .61273 L
s
1 0 0 r
.003 w
.30268 .61393 m
.33409 .65095 L
s
.25 g
.5 Mabswid
.33409 .65095 m
.40914 .65121 L
s
1 0 0 r
.003 w
.30039 .58154 m
.30268 .61393 L
s
.25 g
.5 Mabswid
.50703 .54541 m
.52324 .56689 L
s
.50371 .54101 m
.50703 .54541 L
s
.50112 .53758 m
.50371 .54101 L
s
.48921 .52178 m
.50112 .53758 L
s
1 0 0 r
.003 w
.52324 .56689 m
.58277 .54579 L
s
.25 g
.5 Mabswid
.47964 .52038 m
.5089 .50094 L
s
1 0 0 r
.003 w
.58277 .54579 m
.61882 .51056 L
s
.60876 .57063 m .69068 .64167 L .59691 .58742 L .564 .686 .922 r
F
.60876 .57063 m .74014 .59424 L .69068 .64167 L F
1 0 0 r
.65567 .6492 m
.69068 .64167 L
s
0 g
.006 w
.40914 .65121 m
.43741 .65475 L
s
.43741 .65475 m
.46764 .65311 L
s
.52142 .4895 m
.52905 .48756 L
s
.38661 .64538 m
.40914 .65121 L
s
1 0 0 r
.003 w
.54551 .46297 m
.60752 .47627 L
s
0 g
.006 w
.46764 .65311 m
.4931 .64449 L
s
.25 g
.5 Mabswid
.47566 .51192 m
.52412 .49591 L
s
1 0 0 r
.003 w
.40841 .53306 m
.41009 .50956 L
s
0 g
.006 w
.51693 .59654 m
.5437 .60203 L
s
.5437 .60203 m
.5735 .59894 L
s
.47566 .61708 m
.50179 .62325 L
s
.50179 .62325 m
.52947 .61952 L
s
1 0 0 r
.003 w
.60752 .47627 m
.61882 .51056 L
s
0 g
.006 w
.37038 .63983 m
.38661 .64538 L
s
.25 g
.5 Mabswid
.46186 .59731 m
.51693 .59654 L
s
1 0 0 r
.003 w
.39897 .53819 m
.39902 .53842 L
s
0 g
.006 w
.50304 .58635 m
.51693 .59654 L
s
.52905 .48756 m
.55066 .48715 L
s
.25 g
.5 Mabswid
.30039 .58154 m
.34589 .61943 L
s
0 g
.006 w
.35885 .63603 m
.37038 .63983 L
s
.25 g
.5 Mabswid
.39897 .53819 m
.39926 .53832 L
s
.40318 .57165 m
.4174 .57984 L
s
.46356 .60642 m .44721 .51892 L .46958 .59924 L .517 .656 .922 r
F
.25 g
.4174 .57984 m
.46356 .60642 L
s
.46051 .56667 m
.50304 .58635 L
s
0 g
.006 w
.46356 .60642 m
.47566 .61708 L
s
.54139 .58993 m .66567 .64545 L .54493 .60629 L .563 .693 .928 r
F
.60921 .55283 m .74014 .59424 L .60876 .57063 L .554 .671 .915 r
F
.54139 .58993 m .67466 .57579 L .66567 .64545 L .563 .693 .928 r
F
1 0 0 r
.003 w
.63273 .65781 m
.66567 .64545 L
s
.25 g
.5 Mabswid
.66786 .62846 m
.69068 .64167 L
s
.41009 .50956 m
.41415 .50908 L
s
.41415 .50908 m
.4634 .50318 L
s
1 0 0 r
.003 w
.30039 .58154 m
.31986 .55805 L
s
.56503 .49102 m .45534 .4872 L .57287 .49691 L .669 .792 .94 r
F
.45534 .4872 m .47545 .48977 L .57287 .49691 L F
.45534 .4872 m .42671 .4862 L .47545 .48977 L F
.57287 .49691 m .42671 .4862 L .45553 .46638 L .611 .788 .966 r
F
.57287 .49691 m .4768 .47191 L .57685 .50327 L F
.4768 .47191 m .45553 .46638 L .49245 .47761 L F
.4768 .47191 m .49245 .47761 L .57685 .50327 L F
.57584 .50262 m .45553 .46638 L .49686 .45231 L .55 .76 .975 r
F
.57685 .50327 m .57392 .50238 L .57584 .50262 L F
.57392 .50238 m .45553 .46638 L .57584 .50262 L F
.57685 .50327 m .49686 .45231 L .58013 .50963 L F
.58006 .50947 m .49686 .45231 L .55205 .44769 L .507 .718 .967 r
F
.58013 .50963 m .57973 .50935 L .58006 .50947 L F
.57973 .50935 m .49686 .45231 L .58006 .50947 L F
1 0 0 r
.41009 .50956 m
.42671 .4862 L
s
.25 g
.5 Mabswid
.47111 .50226 m
.47555 .50173 L
s
.47555 .50173 m
.47986 .50121 L
s
.47986 .50121 m
.53747 .49432 L
s
0 g
.006 w
.59949 .58377 m
.60876 .57063 L
s
.25 g
.5 Mabswid
.31986 .55805 m
.34912 .61658 L
s
0 g
.006 w
.34962 .63416 m
.35885 .63603 L
s
.50311 .6132 m .63847 .65908 L .50628 .62973 L .568 .699 .929 r
F
.50311 .6132 m .63866 .59686 L .63847 .65908 L F
1 0 0 r
.003 w
.57474 .69723 m
.63847 .65908 L
s
0 g
.006 w
.4931 .64449 m
.50628 .62973 L
s
.54239 .60847 m
.54493 .60629 L
s
.25 g
.5 Mabswid
.54493 .60629 m
.54913 .60765 L
s
.63854 .63666 m
.66567 .64545 L
s
.50628 .62973 m
.63847 .65908 L
s
.42671 .4862 m
.47545 .48977 L
s
.47545 .48977 m
.48306 .49033 L
s
.48306 .49033 m
.55056 .49528 L
s
.58013 .50963 m .55205 .44769 L .58523 .51656 L .507 .718 .967 r
F
.58523 .51656 m .61906 .45795 L .59306 .52534 L .496 .681 .949 r
F
.58523 .51656 m .55205 .44769 L .61906 .45795 L F
.50691 .57834 m .58928 .51326 L .52407 .57896 L .539 .664 .918 r
F
.50691 .57834 m .46989 .49966 L .58928 .51326 L F
0 g
.006 w
.50304 .58635 m
.50691 .57834 L
s
.46958 .59924 m .56205 .53828 L .48712 .6014 L .543 .663 .915 r
F
.46958 .59924 m .44721 .51892 L .56205 .53828 L F
0 g
.46356 .60642 m
.46958 .59924 L
s
.25 g
.5 Mabswid
.46989 .49966 m
.48169 .52473 L
s
1 0 0 r
.003 w
.39897 .53819 m
.46989 .49966 L
s
.4232 .52864 m
.44721 .51892 L
s
.39316 .54079 m
.4232 .52864 L
s
.25 g
.5 Mabswid
.45553 .46638 m
.49245 .47761 L
s
.49245 .47761 m
.49413 .47812 L
s
.49413 .47812 m
.56619 .50003 L
s
0 g
.006 w
.3408 .63328 m
.34962 .63416 L
s
.48712 .6014 m .63866 .59686 L .50311 .6132 L .562 .68 .918 r
F
.25 g
.5 Mabswid
.50311 .6132 m
.58694 .60309 L
s
0 g
.006 w
.50311 .6132 m
.50628 .62973 L
s
.52407 .57896 m .67466 .57579 L .54139 .58993 L .557 .677 .919 r
F
0 g
.54139 .58993 m
.5435 .59971 L
s
.60921 .55283 m .73527 .53691 L .74014 .59424 L .554 .671 .915 r
F
.60229 .53729 m .73527 .53691 L .60921 .55283 L .534 .66 .917 r
F
.59306 .52534 m .68713 .48795 L .60229 .53729 L .511 .662 .929 r
F
.59306 .52534 m .61906 .45795 L .68713 .48795 L F
.60229 .53729 m .68713 .48795 L .73527 .53691 L .534 .66 .917 r
F
.52407 .57896 m .58928 .51326 L .67466 .57579 L .557 .677 .919 r
F
0 g
.52407 .57896 m
.54139 .58993 L
s
1 0 0 r
.003 w
.66567 .64545 m
.67466 .57579 L
s
0 g
.006 w
.51418 .5786 m
.52407 .57896 L
s
.48712 .6014 m .56205 .53828 L .63866 .59686 L .562 .68 .918 r
F
.25 g
.5 Mabswid
.54344 .55395 m
.56205 .53828 L
s
.48712 .6014 m
.54344 .55395 L
s
.62851 .58069 m
.67466 .57579 L
s
.56341 .53932 m
.58928 .51326 L
s
.61885 .58171 m
.62851 .58069 L
s
0 g
.006 w
.48712 .6014 m
.50311 .6132 L
s
1 0 0 r
.003 w
.63847 .65908 m
.63866 .59686 L
s
0 g
.006 w
.46958 .59924 m
.48712 .6014 L
s
.25 g
.5 Mabswid
.58694 .60309 m
.63866 .59686 L
s
.49686 .45231 m
.5178 .46672 L
s
.5178 .46672 m
.57973 .50935 L
s
.57973 .50935 m
.58013 .50963 L
s
0 g
.006 w
.58013 .50963 m
.58222 .51246 L
s
1 0 0 r
.003 w
.42671 .4862 m
.45553 .46638 L
s
.25 g
.5 Mabswid
.6383 .54916 m
.73527 .53691 L
s
.67381 .58232 m
.74014 .59424 L
s
1 0 0 r
.003 w
.69068 .64167 m
.74014 .59424 L
s
.25 g
.5 Mabswid
.55205 .44769 m
.58331 .51258 L
s
1 0 0 r
.003 w
.73527 .53691 m
.74014 .59424 L
s
.25 g
.5 Mabswid
.61824 .46009 m
.61906 .45795 L
s
.59586 .51808 m
.61824 .46009 L
s
.61333 .53088 m
.68713 .48795 L
s
.33187 .63181 m .42938 .54576 L .46041 .56059 L .653 .639 .824 r
F
.33187 .63181 m .46041 .56059 L .32418 .62791 L F
0 g
.006 w
.33187 .63181 m
.3408 .63328 L
s
.25 g
.5 Mabswid
.46835 .59484 m
.46958 .59924 L
s
.45618 .55114 m
.45857 .55971 L
s
.45903 .56136 m
.46835 .59484 L
s
1 0 0 r
.003 w
.31986 .55805 m
.35257 .54452 L
s
.25 g
.5 Mabswid
.44721 .51892 m
.45618 .55114 L
s
.32418 .62791 m .46041 .56059 L .47587 .58492 L .687 .679 .837 r
F
.32418 .62791 m .47587 .58492 L .32088 .62021 L F
.32088 .62021 m .47587 .58492 L .46748 .61605 L .71 .715 .853 r
F
.32088 .62021 m .46748 .61605 L .32616 .60855 L F
.32616 .60855 m .46748 .61605 L .43173 .64712 L .724 .747 .87 r
F
.32616 .60855 m .43173 .64712 L .34332 .5948 L F
.34332 .5948 m .43173 .64712 L .37523 .66763 L .731 .775 .888 r
F
.34332 .5948 m .37344 .66354 L .3721 .58305 L F
.37344 .66354 m .37362 .66325 L .3721 .58305 L F
.37363 .66399 m .37494 .65985 L .3721 .58305 L F
.37344 .66354 m .37363 .66399 L .37362 .66325 L F
.37363 .66399 m .37523 .66763 L .37494 .65985 L F
.3721 .58305 m .37523 .66763 L .31713 .66699 L .73 .798 .906 r
F
.3721 .58305 m .3241 .65634 L .40645 .57845 L F
.3241 .65634 m .32932 .6536 L .40645 .57845 L F
.31986 .66282 m .32245 .66172 L .40645 .57845 L F
.30256 .63166 m .31713 .66699 L .28576 .64026 L .721 .815 .924 r
F
.39948 .58202 m .33177 .65189 L .30256 .63166 L F
.3241 .65634 m .31986 .66282 L .32932 .6536 L .73 .798 .906 r
F
.31986 .66282 m .31713 .66699 L .32245 .66172 L F
.33177 .65189 m .31713 .66699 L .30256 .63166 L .721 .815 .924 r
F
.39795 .58688 m .31713 .66699 L .39948 .58202 L F
.40645 .57845 m .39795 .58688 L .39948 .58202 L F
.40645 .57845 m .30846 .62863 L .43519 .58449 L F
.30846 .62863 m .28576 .64026 L .32179 .62682 L F
.30846 .62863 m .32179 .62682 L .43519 .58449 L F
.32999 .59289 m .28576 .64026 L .30705 .59472 L .703 .82 .937 r
F
.4231 .58546 m .32204 .62579 L .32999 .59289 L F
.32204 .62579 m .28576 .64026 L .32999 .59289 L F
.43519 .58449 m .42014 .59011 L .4231 .58546 L F
.42014 .59011 m .28576 .64026 L .4231 .58546 L F
.43519 .58449 m .33808 .59224 L .447 .60012 L F
.33808 .59224 m .34185 .59362 L .447 .60012 L F
.32999 .59289 m .34797 .5963 L .447 .60012 L F
.4405 .59521 m .34915 .59487 L .38423 .55269 L .685 .81 .942 r
F
.33808 .59224 m .32999 .59289 L .34185 .59362 L .703 .82 .937 r
F
.32999 .59289 m .30705 .59472 L .34797 .5963 L F
.34915 .59487 m .30705 .59472 L .38423 .55269 L .685 .81 .942 r
F
.43223 .59955 m .30705 .59472 L .4405 .59521 L F
.447 .60012 m .43223 .59955 L .4405 .59521 L F
.447 .60012 m .40231 .56635 L .43732 .6191 L F
.40231 .56635 m .40268 .57346 L .43732 .6191 L F
.39051 .55744 m .38997 .55987 L .39289 .56352 L F
.39396 .56198 m .39289 .56352 L .43732 .6191 L F
.39051 .55744 m .39289 .56352 L .39396 .56198 L F
.40231 .56635 m .39051 .55744 L .40268 .57346 L F
.39051 .55744 m .38423 .55269 L .38997 .55987 L F
.43691 .61316 m .38423 .55269 L .442 .611 L .673 .79 .937 r
F
.43367 .61453 m .4318 .61219 L .43691 .61316 L F
.4318 .61219 m .38423 .55269 L .43691 .61316 L F
.44237 .61036 m .38423 .55269 L .48195 .5418 L F
.442 .611 m .44149 .61048 L .44237 .61036 L F
.44149 .61048 m .38423 .55269 L .44237 .61036 L F
.43732 .6191 m .43367 .61453 L .442 .611 L F
.43732 .6191 m .46754 .56676 L .4123 .63271 L F
.46754 .56676 m .46412 .56951 L .4123 .63271 L F
.4703 .56198 m .4621 .56772 L .4123 .63271 L F
.46754 .56676 m .4703 .56198 L .46412 .56951 L F
.4703 .56198 m .48195 .5418 L .4621 .56772 L F
.42834 .62532 m .4729 .5559 L .54204 .57291 L .672 .769 .923 r
F
.4123 .63271 m .42024 .62235 L .42834 .62532 L F
.42024 .62235 m .48195 .5418 L .42834 .62532 L F
.4123 .63271 m .49713 .59361 L .38677 .63435 L F
.49713 .59361 m .54204 .57291 L .47941 .59769 L F
.49713 .59361 m .47941 .59769 L .38677 .63435 L F
.49006 .62998 m .54204 .57291 L .52816 .62836 L .682 .755 .907 r
F
.40579 .63354 m .4803 .60039 L .49006 .62998 L F
.4803 .60039 m .54204 .57291 L .49006 .62998 L F
.38677 .63435 m .40545 .62696 L .40579 .63354 L F
.40545 .62696 m .54204 .57291 L .40579 .63354 L F
.38677 .63435 m .47724 .63052 L .37704 .62351 L F
.47724 .63052 m .52816 .62836 L .46563 .62636 L F
.47724 .63052 m .46563 .62636 L .37704 .62351 L F
.43128 .66105 m .52816 .62836 L .45199 .67538 L .698 .756 .897 r
F
.3878 .63096 m .46244 .62958 L .43128 .66105 L F
.46244 .62958 m .52816 .62836 L .43128 .66105 L F
.37704 .62351 m .39628 .62413 L .3878 .63096 L F
.39628 .62413 m .52816 .62836 L .3878 .63096 L F
.37704 .62351 m .42426 .65619 L .39141 .60704 L F
.42426 .65619 m .42541 .65121 L .39141 .60704 L F
.43494 .66358 m .43931 .66108 L .43157 .65234 L F
.42924 .65618 m .43157 .65234 L .39141 .60704 L F
.43494 .66358 m .43157 .65234 L .42924 .65618 L F
.38969 .61836 m .42208 .64801 L .38614 .62084 L .714 .774 .899 r
F
.42426 .65619 m .43494 .66358 L .42541 .65121 L .698 .756 .897 r
F
.43494 .66358 m .45199 .67538 L .43931 .66108 L F
.42208 .64801 m .45199 .67538 L .41981 .64873 L .714 .774 .899 r
F
.42208 .64801 m .41981 .64873 L .38614 .62084 L F
.39695 .61328 m .39945 .61611 L .38969 .61836 L F
.39945 .61611 m .45199 .67538 L .38969 .61836 L F
.38614 .62084 m .45199 .67538 L .36054 .6878 L F
.39141 .60704 m .39695 .61328 L .38614 .62084 L F
.39141 .60704 m .37227 .65711 L .42361 .59588 L F
.37227 .65711 m .36232 .68314 L .38626 .64906 L F
.37227 .65711 m .38626 .64906 L .42361 .59588 L F
.34222 .64042 m .36054 .6878 L .3087 .65876 L .72 .801 .915 r
F
.40661 .60518 m .38304 .64744 L .34222 .64042 L F
.36232 .68314 m .36054 .6878 L .36163 .6862 L .714 .774 .899 r
F
.36232 .68314 m .36163 .6862 L .37405 .6681 L F
.37274 .6683 m .37405 .6681 L .42361 .59588 L F
.36232 .68314 m .37405 .6681 L .37274 .6683 L F
.4729 .5559 m .50671 .55462 L .54204 .57291 L .672 .769 .923 r
F
.38304 .64744 m .36054 .6878 L .34222 .64042 L .72 .801 .915 r
F
.42361 .59588 m .41513 .60824 L .40661 .60518 L F
.41513 .60824 m .36054 .6878 L .40661 .60518 L F
.42361 .59588 m .35373 .63412 L .45523 .5981 L F
.35373 .63412 m .33727 .64313 L .36381 .633 L F
.35373 .63412 m .36381 .633 L .45523 .5981 L F
.33727 .64313 m .3087 .65876 L .33353 .64848 L F
.33727 .64313 m .33353 .64848 L .45523 .5981 L F
.43747 .59909 m .3087 .65876 L .38161 .60221 L .708 .82 .934 r
F
.38161 .60221 m .3087 .65876 L .33176 .60499 L F
.45523 .5981 m .43584 .60613 L .43747 .59909 L F
.43584 .60613 m .3087 .65876 L .43747 .59909 L F
.4478 .59851 m .38161 .60221 L .45745 .61173 L F
.4478 .59851 m .45745 .61173 L .46803 .61306 L F
.45523 .5981 m .4478 .59851 L .46803 .61306 L F
.38161 .60221 m .39376 .60866 L .46803 .61306 L F
.45798 .61246 m .45579 .61233 L .45674 .61076 L .685 .815 .945 r
F
.45798 .61246 m .45674 .61076 L .4604 .60471 L F
.46803 .61306 m .45798 .61246 L .4604 .60471 L F
.38161 .60221 m .33176 .60499 L .39376 .60866 L .708 .82 .934 r
F
.45887 .60724 m .33176 .60499 L .4604 .60471 L .685 .815 .945 r
F
.45579 .61233 m .45057 .61202 L .45887 .60724 L F
.45057 .61202 m .33176 .60499 L .45887 .60724 L F
.4604 .60471 m .33176 .60499 L .42018 .56066 L F
.46803 .61306 m .43986 .58221 L .45635 .63206 L F
.43986 .58221 m .42018 .56066 L .43689 .59363 L F
.43986 .58221 m .43689 .59363 L .45635 .63206 L F
.45635 .63206 m .45185 .62317 L .46474 .62173 L .668 .793 .941 r
F
.46474 .62173 m .42018 .56066 L .51878 .5552 L F
.45185 .62317 m .42018 .56066 L .46474 .62173 L F
.45635 .63206 m .49313 .58678 L .42963 .64456 L F
.49313 .58678 m .48692 .59063 L .42963 .64456 L F
.50001 .57831 m .48023 .59384 L .42963 .64456 L F
.49313 .58678 m .50001 .57831 L .48692 .59063 L F
.50001 .57831 m .51878 .5552 L .48023 .59384 L F
.44786 .6374 m .51878 .5552 L .56848 .58999 L .667 .766 .924 r
F
.42963 .64456 m .44062 .63355 L .44786 .6374 L F
.44062 .63355 m .51878 .5552 L .44786 .6374 L F
.43133 .64389 m .51006 .61295 L .49459 .6176 L F
.43133 .64389 m .49459 .6176 L .40519 .64447 L F
.42963 .64456 m .43133 .64389 L .40519 .64447 L F
.51006 .61295 m .51249 .612 L .50933 .61296 L F
.51006 .61295 m .50933 .61296 L .40519 .64447 L F
.51249 .612 m .55264 .59622 L .4981 .61407 L F
.51249 .612 m .4981 .61407 L .40519 .64447 L F
.55264 .59622 m .56848 .58999 L .55659 .59396 L F
.55264 .59622 m .55659 .59396 L .40519 .64447 L F
.42378 .64406 m .56848 .58999 L .55036 .64129 L .678 .748 .903 r
F
.40519 .64447 m .42543 .63771 L .42378 .64406 L F
.42543 .63771 m .56848 .58999 L .42378 .64406 L F
.40519 .64447 m .48834 .64265 L .39807 .63286 L F
.48834 .64265 m .48797 .64198 L .39807 .63286 L F
.49346 .64253 m .48403 .63775 L .39807 .63286 L F
.48834 .64265 m .49346 .64253 L .48797 .64198 L F
.49346 .64253 m .54738 .64136 L .48403 .63775 L F
.54738 .64136 m .55036 .64129 L .54847 .64119 L F
.54738 .64136 m .54847 .64119 L .48373 .6376 L F
.48403 .63775 m .48373 .6376 L .39807 .63286 L F
.54738 .64136 m .48373 .6376 L .48403 .63775 L F
.40899 .63894 m .41399 .63902 L .41405 .64175 L .699 .747 .889 r
F
.41399 .63902 m .55036 .64129 L .41405 .64175 L F
.41405 .64175 m .55036 .64129 L .48671 .6822 L F
.39807 .63286 m .4171 .63391 L .40899 .63894 L F
.4171 .63391 m .55036 .64129 L .40899 .63894 L F
.39807 .63286 m .44798 .66065 L .41355 .61677 L F
.44798 .66065 m .44941 .65927 L .41355 .61677 L F
.45287 .66337 m .45544 .65424 L .41355 .61677 L F
.41477 .67765 m .48671 .6822 L .41517 .69791 L .724 .768 .888 r
F
.41373 .62619 m .45249 .65594 L .41477 .67765 L F
.44798 .66065 m .45287 .66337 L .44941 .65927 L .699 .747 .889 r
F
.45287 .66337 m .48671 .6822 L .45544 .65424 L F
.45249 .65594 m .48671 .6822 L .41477 .67765 L .724 .768 .888 r
F
.41426 .65219 m .41477 .67765 L .43069 .63975 L F
.42265 .62491 m .48671 .6822 L .41373 .62619 L F
.41426 .65219 m .43069 .63975 L .44528 .60501 L F
.41355 .61677 m .42265 .62491 L .41373 .62619 L F
.41355 .61677 m .41426 .65219 L .44528 .60501 L F
.41477 .67765 m .42632 .66352 L .42792 .65858 L F
.42292 .65824 m .42868 .65624 L .44528 .60501 L F
.42081 .66326 m .42792 .65858 L .42868 .65624 L F
.42081 .66326 m .42868 .65624 L .42292 .65824 L F
.41477 .67765 m .42792 .65858 L .42081 .66326 L F
.41477 .67765 m .41517 .69791 L .42632 .66352 L F
.44164 .61625 m .41517 .69791 L .43741 .61411 L .743 .81 .905 r
F
.43693 .61387 m .42381 .66455 L .36716 .68784 L F
.42381 .66455 m .41517 .69791 L .36716 .68784 L F
.43741 .61411 m .41517 .69791 L .43693 .61387 L F
.44267 .61306 m .44164 .61625 L .43768 .61307 L F
.44164 .61625 m .43741 .61411 L .43768 .61307 L F
.43768 .61307 m .43741 .61411 L .43693 .61387 L F
.44528 .60501 m .44267 .61306 L .43768 .61307 L F
.44528 .60501 m .40417 .6486 L .48002 .60348 L F
.40417 .6486 m .40944 .64844 L .48002 .60348 L F
.39661 .65661 m .41531 .65185 L .48002 .60348 L F
.39661 .65661 m .36716 .68784 L .41531 .65185 L F
.46738 .61198 m .36716 .68784 L .46805 .60959 L .737 .86 .938 r
F
.46818 .61233 m .36716 .68784 L .47022 .60983 L F
.40417 .6486 m .39661 .65661 L .40944 .64844 L .743 .81 .905 r
F
.46947 .60849 m .36716 .68784 L .35772 .66157 L .737 .86 .938 r
F
.47022 .60983 m .46738 .61198 L .46947 .60849 L F
.46738 .61198 m .46805 .60959 L .46947 .60849 L F
.47059 .61052 m .46818 .61233 L .47022 .60983 L F
.48002 .60348 m .47059 .61052 L .46947 .60849 L F
.48002 .60348 m .41824 .63282 L .50548 .61273 L F
.41824 .63282 m .42292 .63449 L .50548 .61273 L F
.40453 .63933 m .4221 .64029 L .50548 .61273 L F
.41824 .63282 m .40453 .63933 L .42292 .63449 L F
.40453 .63933 m .35772 .66157 L .4221 .64029 L F
.49499 .61445 m .41 .64362 L .38422 .63254 L .69 .886 .97 r
F
.49431 .61489 m .35772 .66157 L .49499 .61445 L F
.49373 .61662 m .35772 .66157 L .49618 .61425 L F
.49618 .61425 m .49431 .61489 L .49499 .61445 L F
.50548 .61273 m .49373 .61662 L .49618 .61425 L F
.50548 .61273 m .43148 .62482 L .51588 .6292 L F
.43148 .62482 m .38422 .63254 L .44305 .63105 L F
.43148 .62482 m .44305 .63105 L .51588 .6292 L F
.45205 .61596 m .38422 .63254 L .43215 .61183 L .616 .869 .99 r
F
.50943 .62786 m .44348 .63033 L .45205 .61596 L F
.44348 .63033 m .38422 .63254 L .45205 .61596 L F
.50868 .62805 m .38422 .63254 L .50943 .62786 L F
.50593 .62945 m .38422 .63254 L .51011 .628 L F
.51011 .628 m .50868 .62805 L .50943 .62786 L F
.51588 .6292 m .50593 .62945 L .51011 .628 L F
.51588 .6292 m .46497 .61864 L .51228 .64805 L F
.46497 .61864 m .43215 .61183 L .46856 .62829 L F
.46497 .61864 m .46856 .62829 L .51228 .64805 L F
.51041 .64509 m .46185 .62446 L .48481 .60467 L .549 .816 .996 r
F
.51055 .64533 m .50995 .64507 L .51041 .64509 L F
.50995 .64507 m .43215 .61183 L .51041 .64509 L F
.51228 .64805 m .50652 .64545 L .51055 .64533 L F
.50652 .64545 m .43215 .61183 L .51055 .64533 L F
.51228 .64805 m .48481 .60467 L .49954 .66567 L F
.50138 .66242 m .48481 .60467 L .53039 .61114 L .51 .736 .976 r
F
.50133 .6625 m .5013 .66237 L .50138 .66242 L F
.5013 .66237 m .48481 .60467 L .50138 .66242 L F
.49954 .66567 m .49853 .6615 L .50133 .6625 L F
.49853 .6615 m .48481 .60467 L .50133 .6625 L F
.49954 .66567 m .53039 .61114 L .48295 .68046 L F
.48703 .67786 m .53039 .61114 L .56309 .62922 L .499 .644 .921 r
F
.48295 .68046 m .48622 .67569 L .48703 .67786 L F
.48622 .67569 m .53039 .61114 L .48703 .67786 L F
.46185 .62446 m .43215 .61183 L .48481 .60467 L .549 .816 .996 r
F
.41 .64362 m .35772 .66157 L .38422 .63254 L .69 .886 .97 r
F
.4729 .5559 m .48195 .5418 L .50671 .55462 L .672 .769 .923 r
F
.25 g
.35172 .5704 m
.35201 .56149 L
s
1 0 0 r
.003 w
.31713 .66699 m
.32352 .66706 L
s
.45553 .46638 m
.49686 .45231 L
s
.25 g
.5 Mabswid
.35201 .56149 m
.35257 .54452 L
s
.38458 .55266 m
.39117 .54052 L
s
.42692 .54793 m
.42938 .54576 L
s
.31713 .66699 m
.31939 .66475 L
s
1 0 0 r
.003 w
.28576 .64026 m
.31713 .66699 L
s
.29821 .7543 m .19023 .83002 L .1299 .78328 L .614 .61 .824 r
F
.33141 .75477 m .19023 .83002 L .29821 .7543 L .624 .61 .816 r
F
.33141 .75477 m .29091 .84223 L .19023 .83002 L F
.25 g
.5 Mabswid
.41819 .61344 m
.42199 .61364 L
s
.40525 .62264 m
.40577 .62323 L
s
1 0 0 r
.003 w
.36054 .6878 m
.36684 .68694 L
s
.27317 .74513 m .1299 .78328 L .13957 .71141 L .602 .597 .819 r
F
.29821 .7543 m .1299 .78328 L .27317 .74513 L .614 .61 .824 r
F
1 0 0 r
.1299 .78328 m
.19023 .83002 L
s
.35257 .54452 m
.39117 .54052 L
s
.25 g
.5 Mabswid
.40445 .6238 m
.40893 .61727 L
s
.36054 .6878 m
.36487 .68148 L
s
1 0 0 r
.003 w
.3087 .65876 m
.36054 .6878 L
s
.56205 .53828 m
.62478 .58625 L
s
.62478 .58625 m
.63866 .59686 L
s
.58928 .51326 m
.64441 .55364 L
s
.64441 .55364 m
.67466 .57579 L
s
.54575 .5083 m
.58928 .51326 L
s
.46989 .49966 m
.54575 .5083 L
s
.36498 .74811 m .29091 .84223 L .33141 .75477 L .626 .594 .798 r
F
.36498 .74811 m .39893 .82338 L .29091 .84223 L F
1 0 0 r
.19023 .83002 m
.29091 .84223 L
s
.49686 .45231 m
.55205 .44769 L
s
.44721 .51892 m
.56205 .53828 L
s
.39117 .54052 m
.42938 .54576 L
s
.25 g
.5 Mabswid
.45867 .65713 m
.48364 .67946 L
s
.48401 .67979 m
.48671 .6822 L
s
.45544 .65424 m
.45867 .65713 L
s
.45503 .65387 m
.45544 .65424 L
s
.43571 .63659 m
.45503 .65387 L
s
1 0 0 r
.003 w
.41517 .69791 m
.48671 .6822 L
s
.50759 .66878 m
.5078 .66865 L
s
.48671 .6822 m
.50759 .66878 L
s
.53442 .65154 m
.55036 .64129 L
s
.5078 .66865 m
.53442 .65154 L
s
.68713 .48795 m
.73527 .53691 L
s
.25 g
.5 Mabswid
.41517 .69791 m
.42632 .66352 L
s
.42632 .66352 m
.42792 .65858 L
s
.42792 .65858 m
.42889 .65558 L
s
.42889 .65558 m
.43483 .63725 L
s
1 0 0 r
.003 w
.36716 .68784 m
.41517 .69791 L
s
.25 g
.5 Mabswid
.4696 .55792 m
.4787 .54605 L
s
.42886 .61109 m
.42912 .61075 L
s
.4787 .54605 m
.48195 .5418 L
s
1 0 0 r
.003 w
.42938 .54576 m
.4326 .5473 L
s
.27317 .74513 m .13957 .71141 L .26395 .7288 L .602 .597 .819 r
F
.25295 .73668 m .12072 .7953 L .10683 .71502 L .593 .589 .817 r
F
.28517 .73815 m .12072 .7953 L .25295 .73668 L .606 .609 .828 r
F
.28517 .73815 m .23452 .82842 L .12072 .7953 L F
.25 g
.5 Mabswid
.19023 .83002 m
.20484 .81978 L
s
.28576 .64026 m
.321 .62711 L
s
.321 .62711 m
.32179 .62682 L
s
.32179 .62682 m
.32252 .62654 L
s
1 0 0 r
.003 w
.28576 .64026 m
.30705 .59472 L
s
.25 g
.5 Mabswid
.38423 .55269 m
.39906 .57124 L
s
.26395 .7288 m .13957 .71141 L .22892 .63968 L .594 .577 .804 r
F
1 0 0 r
.003 w
.13845 .71971 m
.13957 .71141 L
s
.55205 .44769 m
.61906 .45795 L
s
.25 g
.5 Mabswid
.48023 .59384 m
.50853 .56547 L
s
.47019 .60391 m
.48023 .59384 L
s
.50853 .56547 m
.51878 .5552 L
s
.31676 .72656 m .23452 .82842 L .28517 .73815 L .619 .615 .825 r
F
.39388 .73737 m .39893 .82338 L .36498 .74811 L .617 .567 .776 r
F
.31676 .72656 m .38695 .79551 L .23452 .82842 L .619 .615 .825 r
F
.25 g
.29091 .84223 m
.30428 .81336 L
s
1 0 0 r
.003 w
.12072 .7953 m
.23452 .82842 L
s
.25 g
.5 Mabswid
.30705 .59472 m
.34797 .5963 L
s
.34797 .5963 m
.34901 .59634 L
s
.33353 .64848 m
.37072 .63309 L
s
.37072 .63309 m
.37357 .63191 L
s
.37357 .63191 m
.42522 .61052 L
s
.3087 .65876 m
.33353 .64848 L
s
.36498 .74811 m
.3859 .79448 L
s
.39388 .73737 m .48897 .78451 L .39893 .82338 L .617 .567 .776 r
F
.25 g
.38642 .79562 m
.39893 .82338 L
s
1 0 0 r
.003 w
.29091 .84223 m
.39893 .82338 L
s
.25 g
.5 Mabswid
.5447 .64098 m
.54847 .64119 L
s
.48938 .63791 m
.48992 .63794 L
s
.48373 .6376 m
.48938 .63791 L
s
.54847 .64119 m
.55036 .64129 L
s
1 0 0 r
.003 w
.55036 .64129 m
.55215 .63621 L
s
.55601 .6253 m
.56848 .58999 L
s
.25 g
.5 Mabswid
.42537 .5709 m
.43601 .59191 L
s
.43601 .59191 m
.43689 .59363 L
s
.43689 .59363 m
.44307 .60583 L
s
.42018 .56066 m
.42537 .5709 L
s
.36716 .68784 m
.40807 .65726 L
s
.40807 .65726 m
.42031 .6481 L
s
.42031 .6481 m
.43764 .63516 L
s
1 0 0 r
.003 w
.35772 .66157 m
.36716 .68784 L
s
.25295 .73668 m .10683 .71502 L .23736 .72246 L .593 .589 .817 r
F
.25218 .73323 m .10066 .80165 L .21868 .73234 L .602 .617 .839 r
F
1 0 0 r
.12028 .79279 m
.12072 .7953 L
s
.25218 .73323 m .20888 .82532 L .10066 .80165 L .602 .617 .839 r
F
.25 g
.5 Mabswid
.54716 .59711 m
.55659 .59396 L
s
.51265 .60862 m
.54716 .59711 L
s
.55659 .59396 m
.56848 .58999 L
s
1 0 0 r
.003 w
.61906 .45795 m
.68713 .48795 L
s
.23736 .72246 m .10683 .71502 L .20286 .63185 L .588 .565 .796 r
F
1 0 0 r
.10683 .71502 m
.11986 .79037 L
s
.10683 .71502 m
.19833 .63578 L
s
0 g
.006 w
.34311 .75245 m
.36498 .74811 L
s
.25 g
.5 Mabswid
.39082 .60849 m
.39376 .60866 L
s
.39376 .60866 m
.42969 .61079 L
s
.48295 .68046 m .56309 .62922 L .46612 .69262 L .499 .644 .921 r
F
.46612 .69262 m .57994 .65721 L .45031 .70334 L .509 .564 .847 r
F
.46612 .69262 m .56309 .62922 L .57994 .65721 L F
.25 g
.48295 .68046 m
.48405 .67885 L
s
.51342 .63593 m
.53039 .61114 L
s
0 g
.006 w
.46612 .69262 m
.48295 .68046 L
s
.25 g
.5 Mabswid
.43791 .63506 m
.48373 .6376 L
s
.48481 .60467 m
.49017 .62685 L
s
.49017 .62685 m
.49146 .63221 L
s
.45031 .70334 m .57707 .69415 L .43459 .714 L .534 .519 .785 r
F
.45031 .70334 m .57994 .65721 L .57707 .69415 L F
0 g
.006 w
.45031 .70334 m
.46612 .69262 L
s
.25 g
.5 Mabswid
.49146 .63221 m
.4922 .63526 L
s
.4922 .63526 m
.49785 .65868 L
s
.46612 .69262 m
.46953 .69039 L
s
.46953 .69039 m
.4719 .68884 L
s
.5302 .65073 m
.56309 .62922 L
s
.50992 .64105 m
.51342 .63593 L
s
.48601 .67599 m
.48622 .67569 L
s
.48405 .67885 m
.48601 .67599 L
s
.43459 .714 m .54858 .73824 L .41664 .72543 L .566 .514 .757 r
F
.43459 .714 m .57707 .69415 L .54858 .73824 L F
0 g
.006 w
.43459 .714 m
.45031 .70334 L
s
.25 g
.5 Mabswid
.43459 .714 m
.43481 .71397 L
s
.45031 .70334 m
.45715 .70091 L
s
.54075 .67115 m
.57994 .65721 L
s
.41664 .72543 m .48897 .78451 L .39388 .73737 L .596 .536 .758 r
F
0 g
.006 w
.36498 .74811 m
.39388 .73737 L
s
.28488 .72227 m .20888 .82532 L .25218 .73323 L .618 .624 .835 r
F
.28488 .72227 m .35004 .796 L .20888 .82532 L F
.25 g
.5 Mabswid
.23452 .82842 m
.23987 .81888 L
s
.14162 .7776 m
.21868 .73234 L
s
.10066 .80165 m
.14162 .7776 L
s
1 0 0 r
.003 w
.10066 .80165 m
.20888 .82532 L
s
.25 g
.5 Mabswid
.20888 .82532 m
.25218 .73323 L
s
0 g
.006 w
.40843 .62208 m
.41355 .61677 L
s
.41664 .72543 m .54858 .73824 L .48897 .78451 L .596 .536 .758 r
F
.25 g
.5 Mabswid
.52961 .7364 m
.54858 .73824 L
s
0 g
.006 w
.39388 .73737 m
.41664 .72543 L
s
1 0 0 r
.003 w
.39893 .82338 m
.48897 .78451 L
s
0 g
.006 w
.41664 .72543 m
.43459 .714 L
s
.25 g
.5 Mabswid
.39388 .73737 m
.48897 .78451 L
s
.26395 .7288 m .22892 .63968 L .27374 .7106 L .594 .577 .804 r
F
0 g
.006 w
.26395 .7288 m
.26418 .72921 L
s
.25 g
.5 Mabswid
.24076 .72556 m
.26395 .7288 L
s
1 0 0 r
.003 w
.30705 .59472 m
.38423 .55269 L
s
.48195 .5418 m
.50889 .55575 L
s
.25 g
.5 Mabswid
.45897 .63064 m
.47298 .63029 L
s
.41088 .644 m
.4221 .64029 L
s
.4221 .64029 m
.45065 .63085 L
s
.27374 .7106 m .36747 .60464 L .29749 .69815 L .596 .562 .787 r
F
.27374 .7106 m .22892 .63968 L .36747 .60464 L F
1 0 0 r
.003 w
.32758 .61473 m
.33176 .60499 L
s
.25 g
.5 Mabswid
.3657 .607 m
.39082 .60849 L
s
.35364 .60628 m
.35959 .60664 L
s
.33176 .60499 m
.35364 .60628 L
s
0 g
.006 w
.26395 .7288 m
.27374 .7106 L
s
.25 g
.5 Mabswid
.35772 .66157 m
.41088 .644 L
s
.22892 .63968 m
.27374 .7106 L
s
1 0 0 r
.003 w
.21124 .65387 m
.22892 .63968 L
s
0 g
.006 w
.4308 .61038 m
.44528 .60501 L
s
.41355 .61677 m
.4308 .61038 L
s
1 0 0 r
.003 w
.51878 .5552 m
.56848 .58999 L
s
.22892 .63968 m
.24172 .63644 L
s
0 g
.006 w
.48002 .60348 m
.48371 .60482 L
s
.33093 .7095 m .38695 .79551 L .31676 .72656 L .625 .605 .81 r
F
.33093 .7095 m .4904 .7137 L .38695 .79551 L F
1 0 0 r
.003 w
.23452 .82842 m
.38695 .79551 L
s
.25 g
.5 Mabswid
.31676 .72656 m
.38695 .79551 L
s
1 0 0 r
.003 w
.48897 .78451 m
.54858 .73824 L
s
.25 g
.5 Mabswid
.46912 .73053 m
.52961 .7364 L
s
1 0 0 r
.003 w
.39787 .57184 m
.42018 .56066 L
s
0 g
.006 w
.44528 .60501 m
.48002 .60348 L
s
.29555 .73434 m
.31676 .72656 L
s
.23736 .72246 m .20286 .63185 L .24578 .7035 L .588 .565 .796 r
F
0 g
.23736 .72246 m
.24907 .73314 L
s
.25 g
.5 Mabswid
.10683 .71502 m
.23736 .72246 L
s
.29749 .69815 m .48019 .63323 L .3218 .69767 L .607 .565 .781 r
F
.25 g
.47983 .63338 m
.4932 .63943 L
s
.29749 .69815 m .36747 .60464 L .48019 .63323 L .607 .565 .781 r
F
.25 g
.47376 .63064 m
.4786 .63283 L
s
0 g
.006 w
.27374 .7106 m
.29749 .69815 L
s
.25 g
.5 Mabswid
.46856 .62829 m
.47376 .63064 L
s
.46124 .62498 m
.46856 .62829 L
s
1 0 0 r
.003 w
.38423 .55269 m
.48195 .5418 L
s
.54858 .73824 m
.57707 .69415 L
s
.3218 .69767 m .4904 .7137 L .33093 .7095 L .62 .584 .792 r
F
.25 g
.5 Mabswid
.29749 .69815 m
.30964 .68191 L
s
.3218 .69767 m .48019 .63323 L .4904 .7137 L .62 .584 .792 r
F
.25 g
.48741 .69014 m
.54075 .67115 L
s
.48947 .70635 m
.57707 .69415 L
s
0 g
.006 w
.29749 .69815 m
.3218 .69767 L
s
.25 g
.5 Mabswid
.48607 .67958 m
.5302 .65073 L
s
.48622 .67569 m
.50992 .64105 L
s
.24578 .7035 m .35458 .59694 L .27106 .69084 L .595 .555 .779 r
F
.24578 .7035 m .20286 .63185 L .35458 .59694 L F
0 g
.006 w
.23736 .72246 m
.24578 .7035 L
s
1 0 0 r
.003 w
.34208 .59981 m
.39787 .57184 L
s
.25 g
.5 Mabswid
.20286 .63185 m
.24578 .7035 L
s
1 0 0 r
.003 w
.19833 .63578 m
.20286 .63185 L
s
.30197 .70511 m .35004 .796 L .28488 .72227 L .627 .615 .819 r
F
.30197 .70511 m .45775 .71965 L .35004 .796 L F
1 0 0 r
.20888 .82532 m
.35004 .796 L
s
0 g
.006 w
.3218 .69767 m
.32953 .70768 L
s
.25 g
.5 Mabswid
.28488 .72227 m
.35004 .796 L
s
1 0 0 r
.003 w
.38695 .79551 m
.4314 .76036 L
s
.25 g
.5 Mabswid
.35613 .71017 m
.4493 .71262 L
s
0 g
.006 w
.21868 .73234 m
.25218 .73323 L
s
1 0 0 r
.003 w
.42018 .56066 m
.51878 .5552 L
s
0 g
.006 w
.25218 .73323 m
.28488 .72227 L
s
.27106 .69084 m .46333 .63498 L .29549 .69177 L .611 .567 .78 r
F
.27106 .69084 m .35458 .59694 L .46333 .63498 L F
.25 g
.5 Mabswid
.3218 .69767 m
.3727 .67697 L
s
0 g
.006 w
.24578 .7035 m
.27106 .69084 L
s
1 0 0 r
.003 w
.20286 .63185 m
.35458 .59694 L
s
.41871 .61764 m
.43215 .61183 L
s
.25 g
.5 Mabswid
.43215 .61183 m
.46124 .62498 L
s
1 0 0 r
.003 w
.57707 .69415 m
.57994 .65721 L
s
.43215 .61183 m
.48481 .60467 L
s
.29549 .69177 m .45775 .71965 L .30197 .70511 L .624 .592 .797 r
F
.29549 .69177 m .46333 .63498 L .45775 .71965 L F
1 0 0 r
.4314 .76036 m
.4904 .7137 L
s
.35004 .796 m
.45775 .71965 L
s
.25 g
.5 Mabswid
.4582 .71286 m
.4904 .7137 L
s
0 g
.006 w
.27106 .69084 m
.29549 .69177 L
s
.28488 .72227 m
.30197 .70511 L
s
.25 g
.5 Mabswid
.29549 .69177 m
.396 .65776 L
s
.42138 .64917 m
.46333 .63498 L
s
.396 .65776 m
.42138 .64917 L
s
.27106 .69084 m
.35458 .59694 L
s
.46298 .64024 m
.48019 .63323 L
s
0 g
.006 w
.29549 .69177 m
.30197 .70511 L
s
.25 g
.5 Mabswid
.30197 .70511 m
.37759 .71217 L
s
.37759 .71217 m
.45775 .71965 L
s
1 0 0 r
.003 w
.56309 .62922 m
.57994 .65721 L
s
.40071 .61307 m
.48019 .63323 L
s
.48207 .64803 m
.4867 .68456 L
s
.4867 .68456 m
.4904 .7137 L
s
.48019 .63323 m
.48207 .64803 L
s
.53039 .61114 m
.56309 .62922 L
s
.48481 .60467 m
.53039 .61114 L
s
.4593 .6962 m
.46333 .63498 L
s
.45775 .71965 m
.4593 .6962 L
s
.35458 .59694 m
.46333 .63498 L
s
0 g
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000181000`40O003h00Oogoo2Woo002`Ool2
001GOol00:ioo`800003Ool0000005Ioo`00Zgoo0`000goo0P00EWoo002YOol20006Ool00`00Ool0
001EOol00:Moo`8000Qoo`03001oo`0005Eoo`00Y7oo0`002Woo00@007ooOol005Aoo`00XWoo0P00
3Goo00D007ooOomoo`0005=oo`00Wgoo0`003goo00D007ooOomoo`0005=oo`00WGoo0P004Woo00<0
07ooOol00Woo00<007ooOol0D7oo002KOol2000EOol00`00Oomoo`02Ool00`00Oomoo`1?Ool009Qo
o`<001Moo`03001oogoo009oo`03001oogoo04moo`00UWoo0P006Woo00<007ooOol00goo00<007oo
Ool0CWoo002COol3000LOol00`00Oomoo`03Ool00`00Oomoo`1>Ool0095oo`8001moo`03001oogoo
00Aoo`03001oogoo04eoo`00Sgoo0P008Goo00<007ooOol01Goo00<007ooOol0C7oo002<Ool3000S
Ool00`00Oomoo`05Ool00`00Oomoo`1<Ool008Yoo`8002Ioo`03001oogoo00Ioo`03001oogoo04]o
o`00Qgoo0`00:7oo00<007ooOol01goo00<007ooOol0BWoo0025Ool2000[Ool00`00Oomoo`07Ool0
0`00Oomoo`1:Ool008=oo`8002eoo`03001oogoo00Qoo`03001oogoo04Uoo`00P7oo0`00;goo00<0
07ooOol027oo00<007ooOol0BGoo001nOol2000bOol00`00Oomoo`09Ool00`00Oomoo`18Ool007]o
o`<003Aoo`03001oogoo00Yoo`03001oogoo04Moo`00NGoo0P00=goo00<007ooOol02Woo00<007oo
Ool0Agoo001gOol2000iOol00`00Oomoo`0;Ool00`00Oomoo`16Ool007Aoo`<003]oo`03001oogoo
00aoo`03001oogoo04Eoo`00LWoo0P00?goo00<007ooOol02goo00<007ooOol0AGoo001_Ool30011
Ool00`00Oomoo`0<Ool00`00Oomoo`14Ool006eoo`8004Aoo`03001oogoo00aoo`03001oogoo04Ao
o`00Jgoo0P00AWoo00<007ooOol03Goo00<007ooOol0@goo001XOol30018Ool00`00Oomoo`0>Ool0
0`00Oomoo`12Ool006Ioo`8004]oo`03001oogoo00ioo`03001oogoo049oo`00Hgoo0`00CGoo00<0
07ooOol03goo00<007ooOol0@Goo001QOol2001@Ool00`00Oomoo`0@Ool00`00Oomoo`10Ool005io
o`<0059oo`03001oogoo011oo`03001oogoo041oo`00G7oo0P00EGoo00<007ooOol04Goo00<007oo
Ool0?goo001JOol2001GOol00`00Oomoo`0AOol00`00Oomoo`0oOol005Moo`<005Uoo`03001oogoo
019oo`03001oogoo03ioo`00EGoo0P00G7oo00<007ooOol04goo00<007ooOol0?Goo001BOol3001N
Ool00`00Oomoo`0COol00`00Oomoo`0mOol0051oo`80065oo`03001oogoo01Aoo`03001oogoo03ao
o`00CWoo0P00Hgoo00<007ooOol05Goo00<007ooOol0>goo001;Ool3001UOol00`00Oomoo`0EOol0
0`00Oomoo`0kOol004Uoo`8006Uoo`03001oogoo01Eoo`03001oogoo03Yoo`00AWoo0`00Jgoo00<0
07ooOol05Goo00<007ooOol0>Woo0014Ool2001^Ool00`00Oomoo`0FOol00`00Oomoo`0iOol0049o
o`80071oo`03001oogoo01Moo`03001oogoo03Qoo`00?goo0`00LWoo00<007ooOol05goo00<007oo
Ool0>7oo000mOol2001eOol00`00Oomoo`0HOol00`00Oomoo`0gOol003Yoo`<007Moo`03001oogoo
01Uoo`03001oogoo03Ioo`00>7oo0P00NWoo00<007ooOol06Goo00<007ooOol0=Woo000fOol2001l
Ool00`00Oomoo`0JOol00`00Oomoo`0eOol003=oo`<007ioo`03001oogoo01Yoo`03001oogoo03Eo
o`00<Goo0P00PGoo00<007ooOol06goo00<007ooOol0=7oo000^Ool30023Ool00`00Oomoo`0LOol0
0`00Oomoo`0cOol002aoo`8008Ioo`03001oogoo01aoo`03001oogoo03=oo`00:Woo0P00R7oo00<0
07ooOol07Goo00<007ooOol0<Woo000WOol3002:Ool00`00Oomoo`0NOol00`00Oomoo`0aOol002Eo
o`8008eoo`03001oogoo01ioo`03001oogoo035oo`008Woo0`00Sgoo00<007ooOol07goo00<007oo
Ool0<7oo000POol2002COol00`00Oomoo`0NOol00`00Oomoo`0`Ool001ioo`8009Eoo`03001oogoo
01moo`03001oogoo02moo`006goo0`00Ugoo00<007ooOol087oo00<007ooOol0;Woo000IOol2002J
Ool00`00Oomoo`0POol00`00Oomoo`0^Ool001Moo`8009aoo`03001oogoo025oo`03001oogoo02eo
o`005goo0P00W7oo00<007ooOol08Woo00<007ooOol0;7oo000GOol00`00Ool0002KOol00`00Oomo
o`0ROol00`00Oomoo`0/Ool001Moo`04001oogoo002JOol00`00Oomoo`0SOol00`00Oomoo`0[Ool0
01Ioo`03001oogoo009oo`03001oogoo09Moo`03001oogoo02=oo`03001oogoo02]oo`005Woo00<0
07ooOol00goo00<007ooOol0UWoo00<007ooOol097oo00<007ooOol0:Woo000FOol00`00Oomoo`04
Ool00`00Oomoo`2EOol00`00Oomoo`0UOol00`00Oomoo`0YOol001Ioo`03001oogoo00Eoo`03001o
ogoo09Aoo`03001oogoo02Eoo`03001oogoo02Uoo`005Woo00<007ooOol01Woo00<007ooOol0Tgoo
00<007ooOol09Woo00<007ooOol0:7oo000FOol00`00Oomoo`07Ool00`00Oomoo`2BOol00`00Oomo
o`0WOol00`00Oomoo`0WOol001Eoo`03001oogoo00Uoo`03001oogoo095oo`03001oogoo02Moo`03
001oogoo02Moo`005Goo00<007ooOol02Woo00<007ooOol0T7oo00<007ooOol0:7oo00<007ooOol0
9Woo000EOol00`00Oomoo`0;Ool00`00Oomoo`2?Ool00`00Oomoo`0XOol00`00Oomoo`0VOol001Eo
o`03001oogoo00aoo`03001oogoo08moo`03001oogoo02Qoo`03001oogoo02Eoo`005Goo00<007oo
Ool03Goo00<007ooOol0SWoo00<007ooOol0:Goo00<007ooOol097oo000EOol00`00Oomoo`0>Ool0
0`00Oomoo`2=Ool00`00Oomoo`0YOol00`00Oomoo`0TOol001Eoo`03001oogoo00moo`03001oogoo
08aoo`03001oogoo02Yoo`03001oogoo02=oo`0057oo00<007ooOol04Goo00<007ooOol0Rgoo00<0
07ooOol0:goo00<007ooOol08Woo000DOol00`00Oomoo`0BOol00`00Oomoo`2:Ool00`00Oomoo`0[
Ool00`00Oomoo`0ROol001Aoo`03001oogoo01=oo`03001oogoo08Uoo`03001oogoo02aoo`03001o
ogoo025oo`0057oo00<007ooOol057oo00<007ooOol0R7oo00<007ooOol0;7oo00<007ooOol08Goo
000DOol00`00Oomoo`0EOol00`00Oomoo`27Ool00`00Oomoo`0]Ool00`00Oomoo`0POol001Aoo`03
001oogoo01Ioo`03001oogoo08Ioo`03001oogoo02ioo`03001oogoo01moo`004goo00<007ooOol0
5goo00<007ooOol0QWoo00<007ooOol0;Woo00<007ooOol07goo000COol00`00Oomoo`0HOol00`00
Oomoo`25Ool00`00Oomoo`0_Ool00`00Oomoo`0NOol001=oo`03001oogoo01Uoo`03001oogoo08Ao
o`03001oogoo031oo`03001oogoo01eoo`004goo00<007ooOol06Woo00<007ooOol0Pgoo00<007oo
Ool0<7oo00<007ooOol07Goo000COol00`00Oomoo`0KOol00`00Oomoo`22Ool01000Oomoogoo2G`0
9goo00<007ooOol077oo000COol00`00Oomoo`0LOol00`00Oomoo`1eOol<O0003@00O01l07`0EaaB
o5LLD_aG75;l7>MFneLL009l02Eoo`03001oogoo01aoo`004Woo00<007ooOol07Woo00<007ooOol0
Jgoo2G`001]Fo5LLE_aG75KlEaaFo5LLE_aG75KlEa`005LLE_aG75KlEaaFo5LLE_`LieKlEaaFo5LL
E_`00g`08goo00<007ooOol06goo000BOol00`00Oomoo`0OOol00`00Oomoo`1XOol2O0009e<L7>MB
o5LLD_aG75;lEaaBo5LLD_aG75;lEaaBo5LLD_aG75;lEaaBo000D_aG75;lEaaBo5LLD_`LieKkEaaF
o5LLE_]G75KlEaaFn`02O00ROol00`00Oomoo`0JOol0019oo`03001oogoo021oo`03001oogoo06Ao
o`=l000MEaeC75LL7>MG75KlEaaFo5LLE_aG75KlEaaFo5LLE_aG75KlEaaFo5LLE_aG75Kl001Fo5LL
E_aG70027>L035KlEaaFo5LLE_aG75KlEaaFo5LLE_aG70=l01moo`03001oogoo01Yoo`004Woo00<0
07ooOol08Goo00<007ooOol0HGoo0W`0035G7E<LEaeC75LMDa`Lie;lEaaBo5LLD_aG75;lEaaBo5LL
D_aG75;lEaaBo5LLD_aG75;lEa`005LLD_aG71cWEaaFneLLE_aG75KkEaaFo5LLE_]G75KlEaaFneLL
E_aG7002O00NOol00`00Oomoo`0IOol0019oo`03001oogoo029oo`03001oogoo05eoo`=l0005DaaG
75LLEaeC7002Ea`055LM7>MG75KlEaaFo5LLE_aG75KlEaaFo5LLE_aG75KlEaaFo5LLE_`2O0006000
O01l01cWEaaFo5LLE_aG75KlEaaFo5LLE_aG75KlEaaFo5LLE_aG75KlEaaFo0=l01aoo`03001oogoo
01Qoo`004Woo00<007ooOol08goo00<007ooOol0FWoo0W`001]C75LMDaaG7E<LEaeC75LMDaaG7E<L
7>MBo5LLD_aG75;lEaaBo5LLD_aG75;lEaaBo5LLD_`00g`000EFo1cW001G71cW00Ql000@EaaFneLL
E_aG75KkEaaFo5LLE_]G75KlEaaFneLLE_`2O00JOol00`00Oomoo`0HOol0019oo`03001oogoo02Ao
o`03001oogoo05Moo`9l009G7006EaeC75LLEaaG7E<L0ULL011G7E<LEa`LieLLE_aG75KlEaaFo5LL
E_aG75KlEaaFo0=l00=Fo00=7>MFo000E_aG75KlEaaFo5LLE_aG75KlEa`027`000YFo5LLE_aG75Kl
EaaFo5LLE_aG709l01Uoo`03001oogoo01Moo`004Goo00<007ooOol09Woo00<007ooOol0Dgoo0g`0
01QC75LMDaaG7E<LEaeC75LMDaaG7E<LEaeC75LMDa`Lie;lEaaBo5LLD_aG75;lEa`4O0006e;lEaaB
o5LLD_aG71cWEa`005LLE_]G75KlEaaFneLLE_aG75KkEaaFo5LLE_]G75KlEaaFn`08O0027>L00eLL
O01oo`0HOol00`00Oomoo`0GOol0015oo`03001oogoo02Moo`03001oogoo051oo`9l0003EaaG7E<L
009G7006EaeC75LLEaaG7E<L0ULL00]G7E<LEaaG75LM7>MG75KlEaaFo5LL00=l00UFo0047>Ml07`0
000=O0002eLLE_aG75KlEaaFo5LLE_aG75KlEa`00QcW17`06Woo00<007ooOol05Woo000AOol00`00
Oomoo`0XOol00`00Oomoo`1<Ool3O0005eLMDaaG7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG7E<LEaeC
75LMDa`Lie;lEa`00g`000YG75;lEaaBo5LLD_aG75;lEaaBo0=l000@D_`Li`00EaaFneLLE_]G75Kk
EaaFneLLE_]G75KkEa`@O0000gooO01oo`0IOol00`00Oomoo`0EOol0015oo`03001oogoo02Uoo`03
001oogoo04Uoo`9l0006EaeC75LLEaaG7E<L0ULL00IG7E<LEaaG75LMDa`2Ea`01eLMDaaG75LLEaeC
75LL00=l00YFo0=l00=Fo0037>MFo00001YFo08Li`03Eaal07`001Yoo`03001oogoo01Eoo`004Goo
00<007ooOol0:Woo00<007ooOol0AWoo0W`001IC75LMDaaG7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG
7E<LEaeC75LMDaaG7@=l000:7>MBo5LLD_aG75;lEaaBo5LLD_`3O0009e;lE_aBneKlD_aFo1cWEa`0
05LLE_]G75KkEaaFneLLE_]G75KkEaaFneLLE_]G75KkEaaFneLLE_]G75KkEaaFneLL7>MK75LLFaaG
6`02O00JOol00`00Oomoo`0DOol0015oo`03001oogoo02]oo`03001oogoo04=oo`9l0004EadLiacW
Da`2Ea`01ULMDaaG75LLEaeC709G7006EaeC75LLEaaG7E<L17`02UKl0g`02EKl00<LieKl000065Kl
00<Lie/LEa`00ULL00AK75LLEaal01Yoo`03001oogoo01=oo`0047oo00<007ooOol0;Goo00<007oo
Ool0@Goo00Il05<LEaeC75LMDa`27>L035LMDaaG7E<LEaeC75LMDaaG7E<LEaeC70=l000;DaaG75;l
EaaBo5LLD_aG75;lEaaBo003O0009E;lE_aBneKlD_aFo5;kE_aBo5KlD_/LieKkEa`005LLE_]G75Kk
EaaFneLLE_]G75KkEaaFneLLE_]G75KkEaaFneLLE_]G75Kk008Li`0:FaaG75/LEa]K75LLFaaG6e/L
O00IOol00`00Oomoo`0COol0011oo`03001oogoo02ioo`03001oogoo03moo`09O01G75LMEaaG7ELL
EaeG75LM008Li`03EaaG7E<L009G7003EaeC77`0009l0003DaaFo5Kl00UFo09l00iFo0047>MFo5Kl
000EE_`00acWEaaK7003Ea`01E/LEaaG75LLFa`00ULL0W`067oo00<007ooOol04Woo000@Ool00`00
Oomoo`0_Ool00`00Oomoo`0lOol2O0002e<LEaeC75LMDaaG7E<LEaeC75LMDa`00QcW00=G7E<LEad0
0W`000aC75LLD_aG75;lEaaBo5LLD_aG75;lEa`3O0009eKlD_]Fo5;lE_aBneKlD_aFo5;kE_aBo5Kl
D_]Fo5;l7>MFneLL001G75KkEaaFneLLE_]G75KkEaaFneLLE_]G75KkEaaFneLLE_]G70027>L045LK
FaaG75/LEa]K75LLFaaG6e/LEaaK75LKFaaG77`05goo00<007ooOol04Woo000@Ool00`00Oomoo`0`
Ool00`00Oomoo`0jOol03W`0EaeG75LMEaaG7ELLEaeG75LMEaaG7ELLEad2Ea`00acWO01l000;E_`3
O00BE_`01AcWE_aFo5Kl00004UKl00@LieLLEaaK70=G7005FaaG75LLEaaK7003Ea`01E/LEaaG75LL
O0005Woo0P004goo000@Ool00`00Oomoo`0aOol00`00Oomoo`0hOol047`0EaeC75LMDaaG7E<LEaeC
75LMDaaG7E<LEaeC75LM0W`000YBo5LLD_aG75;lEaaBo5LLD_aG70=l000ZE_aBneKlD_aFo5;kE_aB
o5KlD_]Fo5;lE_aBneKlD_aFo5;kE_aBo5Kl7>MG75KkEa`005LLE_]G75KkEaaFneLLE_]G75KkEaaF
neLLE_]G75Kk0QcW01AK75LKFaaG75/LEa]K75LLFaaG6e/LEaaK75LKFaaG75/LEa]K75LL0W`04Goo
0`0000=oo`00Ool04Woo000@Ool00`00Oomoo`0bOol00`00Oomoo`0eOol2O0004ELMEaaG7ELLEaeG
75LMEaaG7ELLEaeG75LMEaaG7G`0Ea`00QcW1UKl0g`065Kl00DLieKlE_aFo00000mFo0057>MG75LL
EaaK7003Ea`01E/LEaaG75LLFa`00eLL00EK75LLEaaG75/L00=G7003Faal07oo00aoo`<000Aoo`03
001oogoo015oo`0047oo00<007ooOol0<goo00<007ooOol0<goo01Il05<LEaeC75LMDaaG7E<LEaeC
75LMDaaG7E<LEaeC75LMO01G7E;lEaeBo08Li`1>Eaal07`0O01Fo5;kE_aBo5KlD_]Fo5;lE_aBneKl
D_aFo5;kE_aBo5KlD_]Fo5;lE_aBneKlD_aFo5;k7>MFneLLE_]G75Kk001FneLLE_]G75KkEaaFneLL
E_]G75KkEaaFnacWEaaK75LKFaaG75/LEa]K75LLFaaG6e/LEaaK75LKFaaG75/LEa]K75LLFaaG6e/L
Ea`Lig`02Goo0`001goo00<007ooOol04Goo000?Ool00`00Oomoo`0eOol00`00Oomoo`0`Ool2O000
4eLLEaeG75LMEaaG7ELLEaeG75LMEaaG7ELLEaeG75LMO01G75<L00=G7003Daal07`001eFo0037>MF
o5Kl00=Fo003001Fo5Kl00UFo08Li`=G7005FaaG75LLEaaK7003Ea`01E/LEaaG75LLFa`00eLL00AK
75LLEaaG70<Li`03Eaal07oo00Eoo`<000]oo`03001oogoo011oo`003goo00<007ooOol0=Woo00<0
07ooOol0;Woo01]l05LMDaaG7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG7E<LEael05LMD_aG7E;lEaeB
o7`0D_`00QcW04AFo5;kE_aBo5KlD_]Fo5;lE_aBneKlD_aFo5;kE_aBo5KlD_]Fo5;lE_aBneKlD_aF
o5;kE_`LieLLE_]G75KkEaaFn`00E_]G75KkEaaFneLLE_]G75KkEa`Lie/LEaaK75LKFaaG75/LEa]K
75LLFaaG6e/LEaaK75LKFaaG75/LEa]K75LL0acW00AG75/lEaal00Aoo`<000ioo`03001oogoo011o
o`003goo00<007ooOol0=goo00<007ooOol0;7oo01El05LMEaaG7ELLEaeG75LMEaaG7ELLEaeG75LM
EaaG7ELLEael05LLDa`00eLL00MC77`0D_aG75;lEa`Li`0JE_`00acWE_aFo004E_`00`00E_aFo006
E_`27>L01E/LEaaG75LLFa`00eLL00EK75LLEaaG75/L00=G7004FaaG75LLEa`37>L025LLFaaG75/L
EaaK77`0Ool3000AOol00`00Oomoo`0@Ool000moo`03001oogoo03Qoo`03001oogoo02Uoo`9l000O
EaeC75LMDaaG7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG7G`0EaeBo5LMD_aG7E;lO01Bo5LMD_aG7E;l
Ead00QcW03]BneKlD_aFo5;kE_aBo5KlD_]Fo5;lE_aBneKlD_aFo5;kE_aBo5KlD_]Fo5;lE_`LieLL
E_]G75KkEaaFn`00E_]G75KkEaaFneLLE_/LieLKFaaG75/LEa]K75LLFaaG6e/LEaaK75LKFaaG75/L
Ea]K75LL00<Li`0;EaaK?5LLFceG75/lEaaK?ELLO000000DOol00`00Oomoo`0@Ool000moo`03001o
ogoo03Uoo`03001oogoo02Moo`03O00LiacW00HLi`0=EaaG7ELLEaeG75LMEaaG7ELLEael05LLDa`0
0eLL00aC77`0D_aG75;lEaaBo5LLD_aG75;l7>LFE_`00acWE_aFo005E_`00`00E_aFo003E_`27>L0
0eLLFaaG7002Ea`01E/LEaaG75LLFa`00eLL00AK75LLEaaG70<Li`0<EaaK75LLFaaG75/LEaaK75LL
FaaG77`05Woo00<007ooOol047oo000?Ool00`00Oomoo`0jOol00`00Oomoo`0UOol02W`0EaaG?ELL
FceG75LmEaaK?ELL21cW0W`000=G7E;lEad02G`000IG7E;lEaeBo5LMD_`27>L0<eKlD_aFo5;kE_aB
o5KlD_]Fo5;lE_aBneKlD_aFo5;kE_aBo5KlD_/LieKkEaaFneLLE_]G75Kk001FneLLE_]G71cWFaaG
6e/LEaaK75LKFaaG75/LEa]K75LLFaaG6e/LEaaK70027>L03eLLFcaG75/mEaaK?5LLFceG75/lEaaK
?ELLFcal000FOol00`00Oomoo`0@Ool000ioo`03001oogoo03aoo`03001oogoo02Aoo`0>O01G?ELM
EceG75LmEaeG?ELLEceG7ELmEaaG?@Ul00LngP037>Ln_G`000El0003D_aG71cW01=Fo0037>MFo5Kl
00EFo005001Fo5KlE_`Li`02Ea`01E/LEaaG75LLFa`00eLL00EK75LLEaaG75/L00<Li`0AFaaG75/L
EaaK75LLFaaG75/LEaaK75LLFaaG75/LEaal000FOol00`00Oomoo`0@Ool000ioo`03001oogoo03eo
o`03001oogoo029oo`0<O01G?ELLFceG75LmEaaK?ELLEceG75/m0g`000E77d;n7>LngD;N008ngP06
?]e2gSkN?]hngD;N0SkN00TngAcW>[dn_SZm?[hj_Cjn>[d01W`001YFo5;kE_aBo5KlD_]Fo5;lE_aB
neKlD_aFo5;kE_`LieLLE_]G75KkEaaFneLLE_/005Kk0QcW00eK75LKFaaG75/LEa]K75LLFaaG6e/L
EaaK70037>L04e/lEaaK?ELLFcaG75/mEaaK?5LLFceG75/lEaaK?ELLFcaG77`001Moo`03001oogoo
011oo`003Woo00<007ooOol0?Woo00<007ooOol08Goo00Yl05LMEceG75LmEaeG?ELLEceG7@9l0006
Aai2oTLN@_i77T;n0QcW33kN00<Licjm?[d02Sjm1G`02UKl00<LieKlE_`01UKl00<001cWEa`00ULL
00EK75LLEaaG75/L00=G700JFa`LiacW7>MK75LLFaaG75/LEaaK75LLFaaG75/LEaaK75LLFaaG75/L
EaaK75LLFaal01Qoo`03001oogoo00moo`003Woo00<007ooOol0?goo00<007ooOol07goo00Ql05LL
FceG75LmEaaK?ELL0g`000a2oTLN@_i77d;nAai2oTLO@_i77QcW@]h2?]h01SkM@]hngSkN?]e2gP8n
gP0B7>Ln_SZm?[hj_Cjn>[dn_SZm?[hj_Cjn>[dn_SZm?[hLid:m0W`001aBneKlD_aFo5;kE_aBo5Kl
7>MG75KkEaaFneLLE_]G71cW001G75/LEa]K75LLFaaG6e/LEaaK70<Li`0IFcaG75/mEaaK?5LLFceG
75/lEaaK?ELLFcaG75/mEaaK?5LLFceG75/lEaaK?ELLO00067oo00<007ooOol03goo000>Ool00`00
Oomoo`10Ool00`00Oomoo`0NOol01W`0EceG75LmEaeG?@9l000?@_i77T;nAai2oTLN@_i77T;nAai2
oTLN@_i77QcW00/ngP037>Ln_Cjm00/n_@037>LnWCjL008nW@9l00EFo0037>MFo5Kl009Fo0H0009G
7006FaaG75LLEaaK75LL0QcW01]K75LLFaaG75/LEaaK75LLFaaG75/LEaaK75LLFaaG75/LEaaK75LL
FaaG75/LEaaK75LLO0006Goo00<007ooOol03goo000>Ool00`00Oomoo`11Ool00`00Oomoo`0LOol0
1G`0FceG75LmEa`00W`000=??T/M7>L00QcW00a2oTLO@_i77T;nAam2oTLN@_i77d;nAah27>L2?]h0
73kM@]hngSkN?]e2gSkN7>Lj_Cjn>[dn_SZm?[hj_Cjn>[dn_SZm?[hj_AcW?Ya2_CjL@[dnW4:m0W`0
00=Bo5Kl00001@0000DLie/L001K?ELL00<00003EaaK75LK00<Li`0MEaaK?ELLFcaG75/mEaaK?5LL
FceG75/lEaaK?ELLFcaG75/mEaaK?5LLFceG75/lEaaK?ELLFcal000IOol00`00Oomoo`0?Ool000io
o`03001oogoo049oo`03001oogoo01]oo`0<O01G75LmEael04/NCai;7TlNBai?7T/N11cW00]77T;n
Aai2oTLN@_i77T;nAai2oQcW00TngP037>Ln_Cjm00Tn_@037>LnW3jM008nW@05?Y`nWCjM?YdnW003
O00025LLEaeG75LMEaaG7AcW0002Ea`01000EaeG70000QcW021G75/LEaaK75LLFaaG75/LEaaK75LL
FaaG75/LEaaK75LLFaaG75/LEaaK75LLFaaG75/LEaaK75LLFaaG77`06Goo00<007ooOol03goo000=
Ool00`00Oomoo`14Ool00`00Oomoo`0IOol00g`0EaaG?@02O00034/NCci;7DlnBai??T/MCci;7Tln
Bae??P<Li`08Aam2oTLN@_i77d;nAai2oP8Li`03?]hngD;N008ngP0K?]e2gQcW?[hj_Cjn>[dn_SZm
?[hj_Cjn>[dn_QcW@[dnW4:m?Ya2_CjL@[dnW4:m?Ya2_CjL009l000]FceG75LmEa`005LLFceG7000
EaaK?ELLFcd005/lEaaK?ELLFcaG75/mEaaK?5LLFceG75/lEaaK?ELLFcaG75/mEaaK?5LLFceG75/l
EaaK?ELLFcaG77`001Yoo`03001oogoo00moo`003Goo00<007ooOol0AGoo00<007ooOol067oo0g`0
015?7T/NCai;7TlNBai?7T/NCai;7TlNBai?7T/NCai;7TlN00<Li`08Aai2oTLN@_i77T;nAahLi`Ln
gP037>Ln_Cjm00Pn_@047>LnWCjM?Y`3?Yd01CjL?YdnWCjM?Y`00cjM0W`000=G700000000ULL01iG
7@00EaaG75LMEa`005LLFaaG75/LEaaK75LLFaaG75/LEaaK75LLFaaG75/LEaaK75LLFaaG75/LEa`7
7>L00g`0Oomoo`0HOol00`00Oomoo`0?Ool000eoo`03001oogoo04Ioo`03001oogoo01Ioo`9l00HL
i`0@Bai??T/MCci;7TlnBae??T/NCci;7DlnBai??T/MCch37>L01DLO@_i77T;nAal00QcW024ngD;N
?]hngSkM7>Lj_Cjn>[dn_SZm?[hj_Cjn>[dLicjL@[dnW4:m?Ya2_CjL@[dnW4:m?Ya2_CjL@[dnW4:m
?Y`00W`0019G?AcWFceG7000EaaK?ELLFceG7000EaaK?5LLFceG75/lEa`?7>L01eLlFceG?5/mEcaK
?G`001aoo`03001oogoo00ioo`003Goo00<007ooOol0Agoo00<007ooOol05Goo00Ql05<MEceC7E<m
DaeG?E<M4AcW00=;7TlN7>L00acW00=2oTLN@_h00QcW13kN00<Licjm?[d01Sjm00<LicjM?Y`00cjM
00DnW3jM?YdnWCjL00<nW@06?Y`nWCjM?YdnW3jM0W`000@LieLLEa`000=G7003Ead001cW00HLi`0C
EcaK?ELmFceG?5/mEceK?ELlFceG?E/mEcaK?ELmFceG?5/mEcd00W`07Goo00<007ooOol03Woo000=
Ool00`00Oomoo`18Ool00`00Oomoo`0DOol06G`0EceC7ELmDaeG?E<MEceC7ELmDaeG?E<MEceC7ELm
DaeG?E<MEceC7DlnBai??T/M00XLi`03AahLid;N008ngP0L7>Ln_SZm?[hj_Cjn>[dn_QcW@[dnW4:m
?Ya2_CjL@[dnW4:m?Ya2_CjL@[dnW4:m?Ya2_CjL@[d27>L094:LO00Lie/m001K?ELLFcd005/mEcaK
?ELlFceG?5/mEcaK?ELlFceG?5/mEcaK?ELlFceG?5/mEcaK?ELlFceG?5/mEcal01moo`03001oogoo
00ioo`003Goo00<007ooOol0B7oo00<007ooOol04goo01El05LmDaeC?E<MEceC7E<mDaeG?E<MDceC
7ELmDaeC?E<MEceC7E<mDad021cW00=BVTjI7>L00dii1AcW0SkN00<Licjm?[d013jm00<LicjL?Yd0
0SjM00DnW3jM?YdnWCjL00<nW@05?Y`nWCjM?YdnW0027>L4@Y`08G`07>L005LLEaeG7000EceK?ELl
FceG?E/mEcaK?ELmFceG?5/mEceK?ELlFceG?E/mEcaK?ELmFceG?5/mEcel000POol00`00Oomoo`0>
Ool000aoo`03001oogoo04Yoo`03001oogoo015oo`0?O01G?E<MEceC7ELmDaeG?E<MEceC7ELmDaeG
?E<M00El008Li`03Ea]K75LK00<Li`0;CWUBVTii7>M>F59iCUQ>NDiHDWU>F0037>L063kN7>Lj_Cjn
>[dn_SZm@[dLid:m?Ya2_CjL@[dnW4:m?Ya2_CjL@[dnW4:m?Ya2_@8Li`0V@Ya2WD:L@Ye2W4:M@Yal
0000FceG7000EcaK?ELlFceG?5/mEcaK?ELlFceG?5/mEcaK?ELlFceG?5/mEcaK?ELlFceG?5/mEcal
025oo`03001oogoo00ioo`0037oo00<007ooOol0Bgoo00<007ooOol047oo00Ml05<MDceC7ELmDaeC
?@067>L2O0000d:L7>M2W002@Y`:O0000e:I7>M>N@05CWT011cWCSM>>4hg0acW13jm00DLicjM?Ydn
WCjL00<nW@05?Y`nWCjM?YdnW003?Yd00acW@Ya2W008@Y`07@007>MG70007>MG?5/mEceK?ELlFceG
?E/mEcaK?ELmFceG?5/mEceK?ELlFceG?E/mEcaK?ELmO0008Woo00<007ooOol03Woo000<Ool00`00
Oomoo`1<Ool00`00Oomoo`0>Ool00g`07>LLi`057>L015/LEa]K75LK0W`00152_CjL@[dLid:m@Ya6
_D:L@[e2W4Jm@Ya2_D:LA[e2W4:m00]l000FCSQ:=dhh7>Ln_SZm?[hj_AcW?Ya2_CjL@[dnW4:m?Ya2
_CjL@[dnW4:m?Y`27>L044:M@Ya2WD:L@Ye2W4:M@Ya2WD:L@Yd007`0001KGULm0QcW01=K?ELlFceG
?5/mEcaK?ELlFceG?5/mEcaK?ELlFceG?5/mEcaK?@02O00SOol00`00Oomoo`0>Ool000aoo`03001o
ogoo04eoo`03001oogoo00eoo`05O01K75/LFaaK6`03Fa`035/KFaal07`0?Ya2WCjM@YdnW4:L7>M2
W@=2W005@Ye2W4:L@Ya2W@03@Y`01D:M@Ya2W4:L@Yd00d:L00=2WD:L@Y`01W`000Dn_AcW?YdnWCjL
00<nW@06?Y`nWCjM?YdnW3jM0QcW3D:L00@004:LO01l00=GG@8Li`0AEceK?ELlFceG?E/mEcaK?ELm
FceG?5/mEceK?ELlFcel000VOol00`00Oomoo`0=Ool000aoo`03001oogoo04ioo`03001oogoo00ao
o`08O01G6e/LEa]K75LKFaaG6`9l000V@[dnW4:m?Ya2_CjL@[dnW1cW@Ya2_D:LA[e2W4:m@Ya6_D:L
@[e2W4Jm@Ya2_D:LA[e2W4:m@Ya6_D:L@[e2W4Jm@Ya2_D:L7>M2_09l000T@[dnW4:m?Ya2_CjL@[dn
W4:m?Ya2_AcW@Ye2W4:M@Ya2WD:L@Ye2W4:M@Ya2WD:L@Ye2W4:M0012WD:L@Yel05]NEceKGELm0QcW
00iK?ELlFceG?5/mEcaK?ELlFceG?5/mEcaK?G`09goo00<007ooOol03Goo000<Ool00`00Oomoo`1?
Ool00`00Oomoo`0:Ool017`0FaaK75/K0e/L0W`000<nWG`0O0000W`000U2WCjL@YdnWD:M@Y`Lid:L
@Yd00d:L00E2WD:L@Ya2W4:M00=2W005@Ye2W4:L@Ya2W@03@Y`01D:M@Ya2W4:L7>L00dJl00=6_G`0
?Yd00SjM00DnW3jM?YdnWCjL008Lia12W0030012W4:L0092W003O01GGEMM00=GG@<Li`0:FceG?E/m
EcaK?ELmFceG?5/mO00XOol00`00Oomoo`0=Ool000]oo`03001oogoo055oo`03001oogoo00Uoo`9l
0003Ea]K75LK00El0004?Y`Lid:LA[d6O0009QcWA[e2W4:m@Ya6_D:L@[e2W4Jm@Ya2_D:LA[e2W4:m
@Ya6_D:L@[e2W4Jm@Ya2_D:L7>M2_4Jm@[a6_D:lA[el04:m?Ya2_CjL@[d27>L084:L@Ye2W4:M@Ya2
WD:L@Ye2W4:M@Ya2WD:L@Ye2W4:M@Ya2W@00@Ye2W4:M@Ya2WG`0FeiG?E]MEceKGULmFed27>L01ELl
FceG?5/mEc`00W`0:Goo00<007ooOol03Goo000;Ool00`00Oomoo`1BOol00`00Oomoo`07Ool2O000
0acWFaal0002O0001d:M?Ya2WCjL@YdnW1cW00=2W004AYa2W4:L@Y`6O002@Y`01D:M@Ya2W4:L@Yd0
0d:L00E2WD:L@Ya2W4:M00=2W0057>M6_4JlA[a6_@03A[`014JmO01l03jM0QcW54:L00<004:L@Y`0
14:L00=l05MMEed01UMM0QcW00=K?ELlO000:goo00<007ooOol03Goo000;Ool00`00Oomoo`1COol0
0`00Oomoo`06Ool4O0005d:m?Ya2WCjL@YdnW4:M?Ya2WAcWA[e2W4Jm@Ya6_D:LA[e2W4Jm@Ya6_D:L
A[d01W`00492W4:m@Ya6_D:L@[e2W4Jm@Ya2_D:L7>M2_4Jm@[a6_D:lA[e2_4Jm@[a6_D:lO012W4:M
@Ya2WD:L@Ye2W4:M@Ya2WD:L@Ye2W4:M@Ya2WD:L@Ye2W4:M@Ya2W@00@Ye2W4:M@Ya2WD:L@Yel05]N
EceKGELmFeiG?E]MEceKGQcWO00/Ool00`00Oomoo`0=Ool000]oo`03001oogoo05Aoo`03001oogoo
00Aoo`=l000>?Ya2WCjL@YdnW4:M?Ya2WCjL@YdnW1cW@Ya6W0=2W005AYa2W4:L@Ya6W003@Y`01TJL
@Ya2W4:LAYa2W0Il0005@Ye2W4:L@Y`Li`03A[`01DJmA[a6_4JlA[d00dJl00=6_DJlO0005D:L00<0
04:L@Y`00d:L0acW00=l05MMEed015MM0W`0;Woo00<007ooOol03Goo000;Ool00`00Oomoo`1EOol7
O0009d:M?Ya2WCjL@YdnW4:M?Ya2WCjL@YdnW4:M7>M6_D:LA[e2W4Jm@Ya6_D:LA[e2W4Jm@Ya6_D:L
A[e2W4Jm@Ya6_D:LA[e2W4Jm@Ya6_@04O0003d:lA[e2_4Jm@[a6_D:lA[e2_4Jm@[a6_D:lA[e2_002
O00054:M@Ya2WD:L@Ye2W4:M@Ya2WD:L@Ye2W4:M@Ya2WD:L@Ye2W4:M00057>L024:LA[e2W7`0EceK
GULmFed2O00`Ool00`00Oomoo`0=Ool000]oo`03001oogoo04ioo`Ml0005AUY2>DII7>M>F@02BUT5
O0002T:M?Ya2WCjL@YdnW4:M?Ya2WAcW0T:L1W`00T:L00E6W4:L@Ya2W4JL00=2W005AYa2W4:L@Ya6
W003@Y`01AcWA[al07`0A[d00dJl00E6_DJlA[a6_4Jm00=6_004A[e6_4JlO00;@Y`77>L01000A[a6
_4:l0dJl00=2_4JlO0000UMM0W`0<goo00<007ooOol037oo000;Ool00`00Oomoo`1<Ool2O0004chk
7>M6FT8iAUY2>DIJ@SU6FT8i7>M:FDiiBUU>NTYICWU:FDij00al0006DaeG?E<L7>MC75LM0W`000i2
W4Jm@Ya6_D:LA[e2W4Jm@Ya6_D:LA[e2W4Jm0QcW01U6_4Jm@[a6_G`0A[e2_4Jm@[a6_D:lA[e2_4Jm
@[a6_D:lA[e2_4JmO012WD:L@Ye2W0067>L044Jm@Ya6_D:LA[e2W4Jm0016_D:LA[e2W4Jm@Ya6_D:L
0g`0=Goo00<007ooOol037oo000:Ool00`00Oomoo`1;Ool2O00033Xj?SXn>QcW@SU6FDHiAUY2>DII
ASTLi`=:F@03CUUl07`000Ml000@EceC7ELmDaeG?E<MEceC7ELmDadLie<LEaeC75LMDa`2O0001DJL
@Ya2W4:LAY`00d:L00E6W4:L@Y`LidJm00=6_005A[e6_4JlO016_@03A[`01DJmA[a6_4JlA[d00dJl
00=6_DJlA[`00W`00QcW0TJl00E2_4JlA[a6_4:l00=6_005@[a6_4Jl0012_003A[`01D:lA[a6_4Jl
O000=goo00<007ooOol037oo000:Ool00`00Oomoo`19Ool2O0003Chk>SXn>cXj?S/LidIJ@SU6FT8i
AUY2>DIJ00El000IEceC75LmDaeG?E<LEceC7ELmDaaG?E<MEceC75LmDaeG?E<LEadLieLMDaaG7E<L
Ead01g`000m6_D:LA[e2W4Jm7>M6_DJlA[e2_4JmA[a6_D:lA[d00W`002Q2_4Jm@[a6_D:lA[e2_4Jm
@[a6_D:lA[e2_4Jm@[al04:LA[e2W4Jm@Ya6_D:LA[e2W4Jm@Ya6_D:LA[e2W000@Ya6_D:LA[e2W4Jm
@Yal03Moo`03001oogoo00aoo`002Woo00<007ooOol0Agoo0W`00Shj00/j>Shj?SXn>SXj7>M6>DIJ
@SU6FDHi009l000AEcdLieLmDaeG?E<MEceC7ELmDaeG?E<MEceC7ELmDaeG?@0=O0001eLmDceC?E<m
EcdLie<M009l0092W0037>M6_DJl0096_005A[e6_4JlA[a6_@03A[`01G`0A[a6_4JlA[d00dJl00E6
_DJlA[a6_4Jm00=6_003O012_4Jl0096_005@[a6_4JlA[a2_003A[`01D:lA[`004Jl@[`00dJl00=2
_4JlO000=goo00<007ooOol037oo000:Ool00`00Oomoo`16Ool03W`0?S/Lichk>SXn>cXj?S/j>Shk
7>M6FT8iAUX2O002Ecd02U<mEchLieLmDaaG?E<MEceC75Lm1g`002IG?E<MEceC7ELmDaeG?E<MEceC
7ELmDaeG?E<MEceC7ELm7>MG7E<LEaeC77`07>M6_DJlA[e2_4JmA[a6_D:lA[e6_4Jm@[a6_DJl0W`0
00i6_D:lA[e2_4Jm@[a6_D:lA[e2_4Jm@[a6_D:l0W`001E6_D:LA[e2W4Jm@Ya6_D:LA[e2W4Jm@Y`0
04:LA[e2W4Jm@Ya6_D:LO000=goo00<007ooOol037oo000:Ool00`00Oomoo`15Ool01G`0=S/f>acW
>SX00chj00Dj>Shj7>M6FT8i009l00IG?@067>MC7ELmDaeG?E<M0W`000=G?AcWEcd00e<m00EG?E<m
DceC?ELm00=C?@05EceC?E<mDceG?@03Dcd025Lm7>MC7E<LDaeC75<MDa`2O002A[`01DJmA[a6_4Jl
A[d00dJl00I6_DJlA[a6_4JmO002A[`01DJmA[a6_4JlA[d00dJl00I6_DJlA[a6_4JmO003A[`01D:l
A[a6_4Jl@[`00dJl00D004JlA[a6_4:l00=6_003@[al07oo03Eoo`03001oogoo00aoo`002Woo00<0
07ooOol0A7oo00al03Hl<S/f?3Xj7>Lj>Shk>SXn>cXj7>L2O0001U<mEciG?ELmDceG?P9G?@04DcdL
ie<MEcd2O002Ecd0<5<m7>MC7ELmDaeG?E<MEceC7ELmDaeG?E<MEceC7ELmDaeG?E<MEceC7ELm7>MG
7E<LEaeC75LMDaaG7E<LEael04JmA[a6_D:lA[e6_4Jm@[a6_DJlA[e2_4JmA[a6_@9l000S@[a6_D:l
A[e2_4Jm@[a6_D:lA[e2_4Jm@[a6_G`0A[e2W4Jm@Ya6_D:LA[e2W4Jm@Y`004:LA[e2W4Jm@Ya6_D:L
A[el000gOol00`00Oomoo`0;Ool000Uoo`03001oogoo04Eoo`03O00f>cHl008f>`037>Ln>SXj00<n
>P03O01G?ELm00UG?@=l00IG?@037>MC?ELm00=C?@05EceC?E<mDceG?@03Dcd04ULmDceC?E<mEcdL
ie<MDaaC7E<LDaeC75<MDaaC7E<LDael0096_005A[e6_4JlA[a6_@03A[`02DJmA[a6_4JlA[e6_7`0
A[a6_@03A[`01DJmA[a6_4JlA[d00dJl00=6_G`0O0000TJl00U2_4JlA[a6_4:lA[`004Jl@[`00dJl
00A2_4JlA[al03Moo`03001oogoo00]oo`002Goo00<007ooOol0A7oo00Yl038k=S`b>cHl<S/n>acW
?S/j>P9l0003EceC?ELn009G?@05DceG?ULmEceC?@02O0000eLmDceG?P02Ecd095<mEciG?ELm7>MG
?E<MEceC7ELmDaeG?E<MEceC7ELmDaeG?E<MEceC7ELm7>MG7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG
7@9l000JA[a6_D:lA[e6_4Jm@[a6_DJlA[e2_4JmA[a6_D:lO012_4Jm@[a6_D:lA[e2_4Jm@[a6_@DL
i`0BO012W4Jm@Ya6_D:LA[e2W000@Ya6_D:LA[e2W4Jm@Ya6_G`0=goo00<007ooOol02goo0009Ool0
0`00Oomoo`13Ool00g`0=S/f?003=S/00cHl=S/Li`02O00:Ecd2O00<Ecd011cWDceC?ELm0e<m00EG
?E<mDceC?ELm00=C?@0EEcdLie<MDaaC7E<LDaeC75<MDaaC7E<LDaeC75<MDaaC7E<LO016_4Jm00=6
_005A[e6_4JlA[a6_@03A[`014JmA[al07`021cW00=6_DJlA[d00TJm0acW00=6_4:lA[`00TJl00D0
04JlA[a6_4:l00=6_003@[al07oo03Ioo`03001oogoo00]oo`002Goo00<007ooOol0@goo00Ml01cW
<S/f?38k=S`b>`02O0001ELnEceG?E<mEch00ULm00=C?ELnEcd00W`000EG?ULmEceC?ELn009G?@0Y
DceG?ULmEceC?ELnEcdLie<MEceC7ELmDaeG?E<MEceC7ELmDaeG?E<MEcdLieLMDaaG7E<LEaeC75LM
DaaG7E<LEaeC75LMDaaG7E<LEaeC7002O0007dJm@[a6_DJlA[e2_4JmA[a6_D:lA[e6_4Jm@[a6gG`0
A]e6_4KMA[a6gDJlA]e6_4KMA[a6gDJlO012W4Jm00@Li`800009@Ya6_D:LA[e2W4Jm@Ya6_G`003Mo
o`03001oogoo00]oo`002Goo00<007ooOol0@goo00El039L7>Lf>cHl009l00YG?@9l015G?@057>MC
?E<mDceG?@03Dcd07ELmDceC?E<mEcdLie<MDaaC7E<LDaeC75<MDaaC7E<LDaeC75<MDaaC7E<LDaeC
75<MDaaC7G`0A[d00dJl00E6_DJlA[a6_4Jm00=6_006A[e6_4JmO016_DJl0dJm00Y6_4JmA[e6_DJl
O016_4JmA[a6_@<0008Li`03000LidJl0096_004@[a6_4JlO00gOol00`00Oomoo`0;Ool000Uoo`03
001oogoo04=oo`03O00bGBiL009l0003EceC?ELn009G?@05DceG?ULmEceC?@02O0000eLmDceG?P02
Ecd01U<mEciG?ELmDceG?P9G?@0WDceG?ULmEceC?ELn7>MG?E<MEceC7ELmDaeG?E<MEceC7ELm7>MG
7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG7E<LEaeC75LMDaaG7E<L008Li`0LO016_4Jm@[a6_DJlA[e2
_4JmA[a6_D:lA[e6_4Jm@[a6_G`0A]e6_4KMA[a6gDJlA]e6_4KMO00400001dJmA[a6_DJlA[e6_000
00@Li`03@Ya6_G`003Moo`03001oogoo00]oo`002Goo00<007ooOol0@goo00=l039LO0002QcW0g`0
5ELm00<LieLmDcd00U<m01IG?E<mDceC?ELm7>MC7E<LDaeC75<MDaaC7E<LDaeC75<MDaaC7E<LDaeC
70DLi`03E_al04Jl0096_005A[e6_4JlA[a6_@03A[`014JmA[a6_4Jl0acW00=l04JmA[`00dJm01=6
_000000004JlA[e6_4JmA[a6_DJlA[e6_4Jm0016_DJlA[e6_0027>L00g`0Oomoo`0eOol00`00Oomo
o`0;Ool000Qoo`03001oogoo04Eoo`08O01G?E]MEcaKGELmFeeG?0Al00037>M:>4iH00=l0003EceC
?ELn009G?@06DceG?ULmEceC?ELn0ULm01eC?ELnEceG?E<m7>MC7ELmDaeG?E<MEceC7ELm7>MG7E<L
EaeC75LMDaaG7E<LEaeC75LMDaaG7E<L00<Li`0@D_]Fo5;lE_aBneKlO016_D:lA[e6_4Jm@[a6_DJl
A[d67>L01dJlA]e6_7`0A[a6gDJl00<0000DA[a6gG`0A[e6_4JmA[a6_DJlA[e6_4JmA[a6_@00A[e6
_4JmA[al03Uoo`03001oogoo00Yoo`0027oo00<007ooOol0AGoo00Al05LmEceK?@Al00=:>0077>M:
>4hhBSQ>>4XhCSP00g`045Lm20001W`000IC7E<LDaeC75<MDa`37>L01E;lE_aFo5KlD_`00eKl00Al
04JlA[a6_@LLi`0:A]e6_4KMA[e6gDJlA]e6_DKMO00300005TJlA[e6_DJmA[al04JlA[e6_4JmA[a6
_DJlA[e6_4JmA[a6_@00A[e6_7`0>Woo00<007ooOol02Woo0008Ool00`00Oomoo`14Ool5O0000dXh
BSM:>002BSP034Xg7>M:>4iHBSM>F4XhCUQ:=diHBSQ>F0=l00DLi`06DceG?ULmEceC?ELn0P0000<L
ig`0O0001G`000I3?TLo@chLickn@_l6O00035;kE_aBo5KlD_]Fo5;lE_aBneKlD_al00<Li`0>A]e6
_4[MA[a6gDJlB]e6_4KMA[a:gDJlA]e6_0<0000HA[a6gDJlA]e6_4KMA[a6gG`0A[e6_4JmA[a6_DJl
A[e6_4JmA[a6_DJlA[d007`0>goo00<007ooOol02Woo0008Ool00`00Oomoo`11Ool4O009BSP03acW
BSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>003O002Fcd47>L00`00O01l0002O0002d<oAcm3?dLo
@cm7?d<oAcm3?dLo7>L023kn17`000=Fo5;lE_`00UKl011Bo5KlO016gDJlA]e6_DKMA[a6gDJmA]e6
_4KMA[e6g@@00005A[a6gG`0A[e6_003A[d04dJlA[el04JmA[a6_DJlA[e6_4JmA[a6_DJlA[e6_4Jm
A[al000003]oo`03001oogoo00Yoo`0027oo00<007ooOol0?Goo17`00dXh00E:=dXhBSQ:>4Xg00=:
>00BBSM:>1cWCUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diH17`00QcW00@007`0O01?O`8Li`0H
@ci7?d<nAcm3?TLo@ci7?d<nAcm3?TLo7>M2oSkn@_lnoT;n?_i2ockn@_hLicjM0W`0011BneKlD_aF
o7`0B]e6_4KMA[a:gDJlA]e6_4[MA[a6g@<0000MA]e6_4[MA[a6gDJlO016_4KMA[a6gDJlA]e6_7`0
A[a6_DJlA[e6_4JmA[a6_DJlA[e6_4JmA[al0002Ool00`00Oomoo`0hOol00`00Oomoo`0:Ool000Qo
o`03001oogoo03Uoo`Al011:>00D7>M>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>
>0Al0005Bgi?OdmoCgm;OP027>L02dLo@cm7?d<oAcm3?dLo@cm7?d<o7>L02Ckn00HLicjL?Y`nW7`0
D_`2E_`02G`0A[a6gDJmA]e6_4KMA[e6g@0300002TKMA[a6gDJmA]e6_4KMA[e6gG`00dJm0116_4Jm
A[e6_G`0A[e6_4JmA[a6_DJlA[e6_4JmA[a6_@9l00=oo`03001oogoo03Qoo`03001oogoo00Yoo`00
1goo00<007ooOol0=Woo17`000=:>4XgBSP00TXh00E:=dXhBSQ:>4Xg00=:>00OBSM:>4XhBSQ:=dXh
7>M>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSP017`000=?Od]n
Cgl00QcW01M3?TLo@ci7?d<nAcm3?TLo7>M2ockn@_hnoT;o?_i2oSkn7>LnW3jM>Y`nWCjL00=l0006
A[a6gDJlB]e6_4KM0`000216gDJlB]e6_4KMA[a:gDJlA]e6_4[MA[al04JlA]e6_4KMA[a6gDJlO016
_4JmA[a6_DJlA[e6_4JmA[a6_G`01Woo00<007ooOol0=goo00<007ooOol02Woo0007Ool00`00Oomo
o`0bOol4O00FBSP07AcWCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>
>4XhCSQ:>4hhBSP01G`000Y?OacW@cm7?d<oAcm3?dLo@clLi`LnoP057>LnW3jL?Y`nW@03?Y`01CjM
O01l04JmA]d00`000196gDJlA]e6_DKMA[a6gDJmA]e6_4KMA[e6gDJlA]el04JmA[`3A[d03DJlA[el
04JmA[a6_DJlA[e6_4JmA[a6_G`000Qoo`03001oogoo03Moo`03001oogoo00Uoo`001goo00<007oo
Ool0;Woo17`00dXh00E:=dXhBSQ:>4Xg00=:>005BSM:>4XhBSQ:=`03BSP09dXgBSQ:>4XhBSM:>1cW
CUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4Xg
CUQ:>006O0027>L054Lo@ci7?acW@_hnoT;o?_i2oSkn7>LnW3jM>Y`nWCjL?YdjW3jM?Y`4000094KM
A[a:gDJlA]e6_4[MA[a6gDJlB]e6_4KMA[a:gDJlA]e6_7`0A[a6gDJlA]e6_4KMA[al04JlA[e6_4Jm
A[a6_DJlA[el00Yoo`03001oogoo03Ioo`03001oogoo00Uoo`001goo00<007ooOol0:goo0g`074Xh
02DLidhhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4Xh
CSQ:>4hhBSQ>>4XhCSQ:>002O0001ThhO01l07`0Acm3?`8Li`DnoP047>LnW3jL?Yd3?Y`300005cjL
7>Ln>W`0A[e6gDJlA]e6_DKMA[a6gDJmA]e6_4KMA[e6gDJlA]e6_DKMO0000dJm00E6_4JmA[el04Jm
008Li`06A[e6_4JmA[a6_G`037oo00<007ooOol0=Goo00<007ooOol02Goo0007Ool00`00Oomoo`0Z
Ool00g`0ASPLi`02BSP01DXgBSQ:>4XhBSL00dXh00E:=dXhBSQ:>4Xg00=:>005BSM:>4XhBSQ:=`03
BSP09DXgBSPLidiHBSM>F4XhCUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4XgCUQ:>4iH
BSM>F4XhCUQ:=diHBSQ>F4Xg00<Li`03BUQl04Xh008Li`03O00LiacW008Li`09?_i2oSkn@_lLicjM
>Y`nWCjL00<0000T?Y`nWAcW7>Ln>T8jO01:gDJlA]e6_4[MA[a6gDJlB]e6_4KMA[a:gDJlA]e6_4[M
A[al01cWA]e6_4KMA[a6gG`0A]e2_4KM0QcW00=6_4JmO0003Goo00<007ooOol0=Goo00<007ooOol0
2Goo0007Ool00`00Oomoo`0YOol017`0BSQ:>AcW6dXh028LidhhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:
>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>08Li`06CUQ>FDiHCUUl01cW
0TiH00=Fng`0E_/00QcW0ckn00<LicjL?Y`00`0000DnW3jM?Y`nW1cW00Dn>P0DO016gDJmA]e6_4KM
A[e6gDJlA]e6_DKMA[a6gDJmA]e6_4KMO016g@@Li`09A[al04JmA]e6_DKMO00Lig`000moo`03001o
ogoo03Aoo`03001oogoo00Uoo`001goo00<007ooOol0:7oo00Il04HhBSU6>4Xi7>L3BSP01DXgBSQ:
>4XhBSL00dXh00E:=dXhBSQ:>4Xg00=:>005BSM:>4XhBSQ:=`02BSP07acWBSM>F4XhCUQ:=diHBSQ>
F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diH00<Li`0BCUU>F4iIBUQ>
FDiHO01:F4iIBUQJo7`0F_aFnacW?_i2oacW0`0002HnW3jM>Y`nWCjL@SXLid8j?SY2>Shj@SXn>T8j
O00LidJlA]e6_4[MA[a6gDJlB]e6_4KMA[a:gDJlA]e6_7`0@]e6gD;MA]e2gAcW1G`04goo00<007oo
Ool0<goo00<007ooOol02Goo0006Ool00`00Oomoo`0XOol00g`0BSQ:>@03BSP00acWBSQ:>00GBSP0
7AcWBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSP0
0acW00Y>FDiHCUU>F4iICUQ>FDiHCUUl00A>F003O01FneKk00@00003?Y`nWCjL008nW004?YdnW1cW
7>L9?SX00g`07>LLi`037>L02dJmA]e6_4KMA[e6gDJlA]e6_DKMO0000dKM17`067oo00<007ooOol0
<Woo00<007ooOol02Goo0006Ool00`00Oomoo`0VOol2O0002DHhBSU6>4XiASQ:>DHh7>M:=`03BSP0
1DXgBSQ:>4XhBSL00dXh00E:=dXhBSQ:>4Xg00=:>00MBSM:>4Xh7>M:=diHBSQ>F4XgCUQ:>4iHBSM>
F4XhCUQ:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=`047>L04DiICUQ>FDYHCUU>F4iIBUQ>FDiHCUU:
F7`0BUQ>FDYHCUT00`0001UJo1cW7>LjW3jM?Y`nWCZL?Ydn>QcW?SY2>Shj@SXn>T8j?SY2>Shj@SXn
>W`0@]e6gP02A]d00d;M7>LLi`027>L01T[MA[a6gDJlB]e6_0Al01eoo`03001oogoo035oo`03001o
ogoo00Uoo`001Woo00<007ooOol09Goo00Al04XhBSQ:>@=:>005BSU:>4XhBSPLi`0EBSP061cWBSQ>
>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>0<Li`0>CUQ>FDiHCUU>F4iI
CUQ>FDiHCUU>F4iICUQ>F@9>F003O01>F00000800007O01FneKlE_/LicjL?Yd00cjL00<nWAcW7>L0
33hj00<Lig`0A]d01dKM11cW00=6_4KMO00087oo00<007ooOol0<Woo00<007ooOol027oo0006Ool0
0`00Oomoo`0TOol03g`0BSU6>4XiASQ:>DHhBSU6>4XiASQ:>AcWBSQ:=`03BSP01DXgBSQ:>4XhBSL0
0dXh00E:=dXhBSQ:>4Xg009:>00F7>M:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4XgCUQ:
>4iHBSL37>L04TYHCUU>F4iIBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>F@<0000<CUU:F4iIO01J
o5KkF_`LicjM?Y`nWCZL0QcW00]2>Shj@SXn>T8j?SY2>Shj@SXn>T8j00<Li`05@QQl04KM@]e6gP02
A]d01d;MA]i6gDKM@]e6gTKM008Li`03O01oogoo01moo`03001oogoo035oo`03001oogoo00Qoo`00
1Woo00<007ooOol08goo00Al04XhBSQ:>@=:>005BSU:>4XhBSQ:>@02BSP00acWBSQ:>00@BSP051cW
BSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hhBSP37>L04TiHCUU>F4iICUQ>FDiHCUU>
F4iICUQ>FDiHCUU>F4iICUQ>F@<00003CUQl04iH00=>F005O01FneKk7>LnW@03?Y`00acW?SXn>P09
?SX27>L4@QP00g`0A]e6g@0:A]d2O00SOol00`00Oomoo`0`Ool00`00Oomoo`08Ool000Ioo`03001o
ogoo029oo`0CO01:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSTLidXhBSL00dXh00E:=dXhBSQ:
>4Xg00=:>00EBSM:>4Xh7>M:=diHBSQ>F4XgCUQ:>4iHBSM>F4XhCUQ:=diHBSQ>F4Xg00<Li`0ABUQ>
FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FDiHCUU:F00400003diICUQ>FG`0CUU:F4iIBUQ>FEKkO00L
icjM?Y`nW@027>L02Chj@SXn>T8j?SY2>Shj@SXn>P037>L6@QP01W`0A]i6gDKM@]e6gP96g@03@]e6
gTKM009l02Ioo`03001oogoo02moo`03001oogoo00Qoo`001Goo00<007ooOol08Woo00Al04XhBSQ:
>@=:>005BSU:>4XhBSQ:>@03BSP00dXiBSPLi`0?BSP04AcWBSQ>>4XhCSQ:>4hhBSQ>>4XhCSQ:>4hh
BSQ>>4XhCSP00QcW015>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiH00<00008CUQ>FDiH
CUU>F4iICUQl00E>F004E_]l01cW?Y`27>L8?SX37>L9@QP00g`0A]e6g@07A]d00g`0Oomoo`0WOol0
0`00Oomoo`0^Ool00`00Oomoo`08Ool000Eoo`03001oogoo025oo`0DO01:>DHhBSU6>4XiASQ:>DHh
BSU6>4XiASQ:>DHhBSU6>4XiASPLi`9:>005BSM:>4XhBSQ:=`03BSP04TXgBSQ:>4Xh7>M>F4XhCUQ:
=diHBSQ>F4XgCUQ:>4iHBSM>F0<Li`0@CUU>F4iIBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUP30000
4TYHCUU>F4iIBUQ>FDiHCUU:F4iIO01>FDYHCUU:F4iIBUQl008Li`07?SY2>Shj@SXn>T8j?SX00acW
2d8H00El04KMA]e2gDKN0096g@04@]e6gW`0O00[Ool00`00Oomoo`0]Ool00`00Oomoo`08Ool000Eo
o`03001oogoo01moo`9l009:>005BSU:>4XhBSQ:>@03BSP01DXiBSQ:>4XhBST00dXh00=:>AcWBSP0
34Xh00`LidhhBSQ>>4XhCSQ:>4hhBSQ>>4XhCSP37>L044iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iI
CUQ>FDiH0`0000i>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F7`01TiH00=l03hj?SX01Chj0QcW3T8H
00=l04KMA]d014KM0W`0;Goo00<007ooOol0;Goo00<007ooOol027oo0005Ool00`00Oomoo`0NOol0
67`0ASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSTLi`=:>005BSM:>4Xh
BSQ:=`03BSP02QcWCUQ:>4iHBSM>F4XhCUQ:=diH0acW011>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>
FDiHCUU:F0<0000LBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FDiHCUUl04iIBUQ>FDYHCUU:F7`0
?SY2>Shj@SX37>L@@QP00g`0@]e6gP02A]d2O00`Ool00`00Oomoo`0]Ool00`00Oomoo`07Ool000Eo
o`03001oogoo01eoo`05O01:>4XhBSQ:>@03BSP01DXiBSQ:>4XhBST00dXh00E:>DXhBSQ:>4Xi00=:
>003BSTLidXh00Q:>0087>M>>4XhCSQ:>4hhBSQ>>0<Li`0?CUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiH
CUU>F4iI00@0000DCUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQl00I>F003O00n
>QcW008Lia=26005O016gDKMA]el000cOol00`00Oomoo`0/Ool00`00Oomoo`07Ool000Eoo`03001o
ogoo01aoo`0LO016>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6
>1cWBSL3BSP01DXgBSQ:>0007>L01`00010LidiICUQ>FDYHCUU>F4iIBUQ>FDiHCUU:F4iICUQ>F@<0
000PCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FG`0CUU:F4iIBUQ>
FDYHO00LiaI26004O016gG`0O00eOol00`00Oomoo`0[Ool00`00Oomoo`07Ool000Eoo`03001oogoo
01]oo`05O01:>4XhBSQ:>@03BSP01DXiBSQ:>4XhBST00dXh00E:>DXhBSQ:>4Xi00=:>005BSU:>4Xh
BSPLi`04BSP20008BSP03P00CUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUT300006diICUQ>FDiHCUU>
F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQl0006CUP00g`0@QQ2600B@QP3
7>L2O00hOol00`00Oomoo`0ZOol00`00Oomoo`07Ool000Aoo`03001oogoo01]oo`0PO016>4XiASQ:
>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>AcWBSQ:=`800003
BUU:>1cW00=:>004BSU:>4XhBSP200002DiIBUQ>FDiHCUU:F4iICUQ>F@0300009TiIBUQ>FDiHCUU:
F4iICUQ>FDYHCUU>F4iIBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FDiHCUUl04iIBUQ>FDYHCUU:
F48HO00;@QP87>L00dGgAQQl000jOol00`00Oomoo`0ZOol00`00Oomoo`07Ool000Aoo`03001oogoo
01Yoo`05O01:>4XhBSQ:>@03BSP01DXiBSQ:>4XhBST00dXh00E:>DXhBSQ:>4Xi00=:>005BSU:>4Xh
BSQ:>@02BSP200001TYHBUU:FDYIBUPLi`A:>0800007Ool004iHCUU>F4iICUP01000025>FDiHCUU>
F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHO000
1diH00Al048H@QQ260PLi`Y65`03O01oogoo03Uoo`03001oogoo02Uoo`03001oogoo00Moo`0017oo
00<007ooOol067oo0W`002U6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:
>DHhBSU6>4XiASQ:>DHhBSU6>000BSQ:FDXhBUU:>4YI7>M:>DXh008000=oo`<Li`<0000]CUQ>FDYH
CUU>F4iIBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FDiHCUU:F4iICUQ>FDYHCUU>F4iIBUQ>FDiH
CUU:F4iIO01>FDYHCUU:F4iIBUQ>FG`000<Li`0BAOM65dGgAQQ5mdHGAOM664GgAQM5mdHHAOM65dGg
AQQ5mg`0?Goo00<007ooOol0:7oo00<007ooOol01goo0004Ool00`00Oomoo`0GOol00g`0BSU:>002
BSP01DXiBSQ:>4XhBST00dXh00E:>DXhBSQ:>4Xi00=:>005BSU:>4XhBSQ:>@03BSP01TXiBSQ:>4Xh
001:F0=:F@04BUQ:FDYIBUT20004Ool40002CWT:7>L06diHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiH
CUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUUl0008CUP00g`0AQM65`0AAQL00g`0Oomoo`0mOol00`00
Oomoo`0XOol00`00Oomoo`06Ool000Aoo`03001oogoo01Ioo`0[O01:>DHhBSU6>4XiASQ:>DHhBSU6
>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBSU6>4XiASQ:>DHhBST004YIBSQ:FDXhBUU:
>4YI000017oo0`000dii00E>NTiiCWU>NDij00=>N@04CWY>NDiiCWT;7>L044YHCUU>F4iIBUQ>FDiH
CUU:F4iICUQ>FDYHCUU>F7`021cW01El04HHAOM65dGgAQQ5mdHGAOM664GgAQM5mdHHAOM65dGgAQQ5
mdHGO000@7oo00<007ooOol09goo00<007ooOol01Woo0004Ool00`00Oomoo`0EOolA7>L01DXiBSQ:
>4XhBST00dXh00E:>DXhBSQ:>4Xi00=:>003BST004YI009:F@07BUQ:FDYIBUU:F000Ool0100074ii
2QcW00i>FDiHCUU>F4iIO01>NDiICWU>FDiiCUU>NG`04dHG00=l07ooOol0?goo00<007ooOol09goo
00<007ooOol01Woo0003Ool00`00Oomoo`0FOol01G`0BUU:FDIIBUX00TYI00I6FDYJBUU:FDIIBUX2
BUT00dIIBUXLi`0@7>L01`00BSQ:FDXhBUU:>4YI00@00004Ool00000CWX3CWT01DijCWU>NDiiCWX0
0dii00E>NTiiCWU>NDij00=>N@05CWY>NDiiCWU>NP03CWT01DijCWU>NDiiCWX00dii00=>NTiiCWT0
1AcW01al04iICWU:F4iiCUU>NG`0AQQ5mdHGAOM664GgAQM5mdHHAOM65dGgAQQ5mdHGAOM664GgAQMl
04=oo`03001oogoo02Ioo`03001oogoo00Ioo`000goo00<007ooOol05Woo00=l04YIBUT084YI00<0
01cW7>L00`0000=:F@0000000P000Tij00<LidiiCWT09dii0W`000E>FDiiCUU>NDiI009l01A65`03
O01oogoo049oo`03001oogoo02Eoo`03001oogoo00Ioo`000goo00<007ooOol05Woo00=l04IIBUX0
0TYI00I6FDYJBUU:FDIIBUX2BUT01TIIBUY:FDYIAUU:FP9:F@06AUU:FTYIBUU6FDYJ0TYI00I6FDYJ
BUU:FDIIBUX300027>L3000024YiCWY:NDijBWU>NQcWCWX3CWT01DijCWU>NDiiCWX00dii00E>NTii
CWU>NDij00=>N@05CWY>NDiiCWU>NP03CWT01DijCWU>NDiiCWX00dii025>NTiiCWUl04iiCUU>NDYH
CWU>FG`0AOM664GgAQM5mdHHAOM65dGgAQQ5mdHGAOM664GgAQM5mdHHAOM65dGgO000AWoo00<007oo
Ool097oo00<007ooOol01Woo0003Ool00`00Oomoo`0GOol00g`0BUU:F@0IBUT;0002CWX01DiiCWY>
NTijCWT00dij00<LidiiCWT08dii00Ql04iiCUU>NDiICWU>FG`01acW3THG00=l07ooOol0AWoo00<0
07ooOol08goo00<007ooOol01Woo0003Ool00`00Oomoo`0GOol017`0BUU6FDYJ0TYI00I6FDYJBUU:
FDIIBUX2BUT01TIIBUY:FDYIAUU:FP9:F@04AUU:FTYIBUT27>L300005DijBWU>NTYiCWY:NAcWBWU>
NTYiCWY:NDijBWU>NTYiCWY:NAcWCWU>NP03CWT01DijCWU>NDiiCWX00dii00E>NTiiCWU>NDij00=>
N@05CWY>NDiiCWU>NP03CWT01TijCWU>NDiiCWY>N@9l000?CWU>FDiiBUQ>NDiIO01:5dXhBQM:>4XG
BSQ:5dXh00/Li`04AQM5mdHHO019Ool00`00Oomoo`0ROol00`00Oomoo`06Ool000=oo`03001oogoo
01Moo`03O01:FDYI01E:F@@000Q:NP047>M>NTijCWT3CWX01DiiCWY>NTijCWT00Tij00<LidiiCWT0
7dii00Ul04iICWU>FDiiCUU>NDiIO00054XG0QcW00=l07ooOol0B7oo00<007ooOol08goo00<007oo
Ool01Goo0002Ool00`00Oomoo`0HOol01W`0BUY:FDYIAUU:FP9:F@06AUU:FTYIBUU6FDYJ0TYI00E6
FDYJBUU:FDII00<0000NBWU>NTYiCWY:NDijBWU>NTYiCWY:NDij7>M>NTYiCWY:NDijBWU>NTYiCWY:
NDijBWU>NTYi7>M>NDij0dii00E>NTiiCWU>NDij00=>N@05CWY>NDiiCWU>NP03CWT01DijCWU>NDii
CWX00dii029>NW`0O01:F4iiCUU>NDYHCWU:5g`0BQM:>4XGBSQ:5dXhBQM:>4XGBSQ:5dXhBQM:>4XG
BSQ:5dXhBQM:>4XGBSQl04aoo`03001oogoo029oo`03001oogoo00Eoo`000Woo00<007ooOol067oo
00=l04YIBUT03dYI0`000QcW34Yj00<LidijCWT00dij00E>NDijCWY>NTii00=>NP04CWU>NTij7>LL
CWT02W`0CWU>FDiiCUU>NDiICWU:5g`05DXG0W`0CWoo00<007ooOol08Goo00<007ooOol01Goo0002
Ool00`00Oomoo`0HOol017`0BUU6FDYJ0TYI00I6FDYJBUU:FDIIBUX2BUT01DII00000000AUT00QcW
02=>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYi7>M:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDij
BWU>NTYi7>M>NDij00=>N@05CWY>NDiiCWU>NP03CWT01DijCWU>NDiiCWX00dii00e>NTiiCWU>NDij
O01>NDYHCWU>FDiiBUQ>N@02O0005TXGBSQ:5dXhBQM:>4XGBSQ:5dXhBQM:>4XGBSQ:5dXhBQM:>4XG
BSQ:5g`0DGoo00<007ooOol087oo00<007ooOol01Goo0002Ool00`00Oomoo`0HOol00dYIO01:F@09
BUT30003BUT00acWBWY:NP0=BWX00acWCWU>NP02CWX01DiiCWY>NTijCWT00dij00E>NDijCWY>NTii
009>NP037>M>NDii01E>N@9l0008CWU>FDiiCUU>NDiICWUl01I:5`03O01oogoo055oo`03001oogoo
01moo`03001oogoo00Eoo`000Woo00<007ooOol06Goo00El04YIBUU6FDYJ009:F@@00004AUU:FTYI
BUT27>L0:4YiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDij7>M>NTYiCWY:NDijBWU>NTYiCWY:
NDijBWU>NTYiCWY:NDijBWU>NTYi7>M>NDij0dii00E>NTiiCWU>NDij00=>N@05CWY>NDiiCWU>NP03
CWT08G`0CUU>NDYHCWU>FDiiBUQ>F7`07>M:5dXhBQM:>4XGBSQ:5dXhBQM:>4XGBSQ:5dXhBQM:>4XG
BSQ:5dXhBQMl001DOol00`00Oomoo`0OOol00`00Oomoo`05Ool0009oo`03001oogoo01Uoo`04O01:
FDYIBUT30006BUT27>LABWX01AcWCWY>NTijCWT00dij00E>NDijCWY>NTii00=>NP07CWU>NTijCWY>
NDij7>L04dii0W`000U>FDiiCUU>NDiICWU>FDhhO0000Thh0QcW4DXG0W`0EWoo00<007ooOol07Woo
00<007ooOol01Goo0002Ool00`00Oomoo`0IOol01g`000000000BUU6FDYJ009:F@0_AUU:FTYI7>M:
NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NAcWBWU>NTYiCWY:NDijBWU>NTYiCWY:
NDijBWU>NTYiCWY:NDijBWU>NTYiCWXLi`02CWT01DijCWU>NDiiCWX00dii00E>NTiiCWU>NDij009>
N@0@O01>NDiICWU:F4iiCUU>NDYHCUQl04iHBSM>F4XgCUP27>L03dXGBSQ:5dXhBQM:>4XGBSQ:5dXh
BQM:>4XGBSQl001IOol00`00Oomoo`0NOol00`00Oomoo`04Ool00003Ool007oo01Uoo`<000U:F@8L
iaA:NP037>M>NTii00=>NP05CWU>NTijCWY>N@03CWX01DiiCWY>NTijCWT00dij00=>NDij7>L03dii
00Ul04iiCUU>NDiICWU>FDiiCUT00W`00dhh00E:>4hhCSQ>>4Xh008Li`]:5`03O01oogoo05Uoo`03
001oogoo01eoo`03001oogoo00Aoo`0000=oo`00Ool05Woo0`000Woo00El04YIBUU6FDYJ009:F@0c
AUTLiacWCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDij7>M>NTYiCWY:NDij
BWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NQcW009>N@05CWY>NDiiCWU>NP03
CWT06DijCWUl07`0CWU>FDiiBUQ>NDiICWU:=g`0BSM>F4XgCUQ:=diHBSM>F4XgCUQ:=diH008Li`09
BQM:>4XGBSQ:5dXhBQM:>7`005eoo`03001oogoo01aoo`03001oogoo00Aoo`0000=oo`00Ool04Woo
10001Goo00=:FG`0BUT014YI00<LidYjBWX05DYj00<LidiiCWX00Tij00E>NDijCWY>NTii00=>NP05
CWU>NTijCWY>N@03CWX01diiCWY>NTijCWU>NQcW00Y>N@0<O01>FDiiCUU>NDiICWU>FDiiCSQl04Xh
0dhh00E:>4hhCSQ>>4Xh00=>>003BSQ>>4hh008Li`A:5`9l05ioo`03001oogoo01aoo`03001oogoo
00Aoo`0000=oo`00Ool03goo0`002Goo00=:FG`0BUX00TYI0QcW03E:NDijBWU>NTYiCWY:NDijBWU>
NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYi7>M:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>
NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NQcW009>N@05CWY>NDiiCWU>NP02O00024YHCWU>FDiiBUQ>
NDiICWT2O0004TXgCUQ:=diHBSM>F4XgCUQ:=diHBSM>F4XgCUQ:=diHBSM>F08Li`03BQMl07oo061o
o`03001oogoo01]oo`03001oogoo00Aoo`0000=oo`00Ool037oo0`003Goo00Al04YI7>LLiaU:NP05
7>M>NTijCWY>N@03CWX01DiiCWY>NTijCWT00dij00E>NDijCWY>NTii00=>NP06CWU>NTijCWY>NAcW
1Tii00el04iiCWTLidiICWU>FDiiCUU>NG`0CSQ:>003CSP01DXhCSQ>>4hhBSP00dhh00E:>4hhCSQ>
>4Xh00=>>09l06=oo`03001oogoo01Yoo`03001oogoo00Aoo`0000=oo`00Ool02Goo0`0047oo0QcW
03Y:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDij7>M>NTYi
CWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWTLi`=>
N@0PCWYl04ijBWU>NTYi7>M:F4iiCUU>NG`0CUQ:=diHBSM>F4XgCUQ:=diHBSM>F4XgCUQ:=diHBSM>
F4XgCUQ:=`9l06Ioo`03001oogoo01Uoo`03001oogoo00Aoo`0000<007ooOol01Woo0`004Goo0QcW
74Yj00@LidijCWY>N@=>NP05CWU>NTijCWY>N@03CWX01DiiCWY>NTijCWT00dij00E>NDijCWY>NTii
00=>NP03CWTLidii009l009>N@06CWY>NDiiCWTLidiI0W`000=>>4XhCSP00Thh00E:>4hhCSQ>>4Xh
00=>>006BSQ>>4hhCSQ:>4hh0W`0JGoo00<007ooOol067oo00<007ooOol017oo00000`00Oomoo`02
Ool4000BOol27>L0?DYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>
NTYiCWY:NDijBWU>NQcWCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>
NTYiCWY:NDijBWU>NTYi00=l0007BWU>NTYiCWY:NDijBWT00g`0019:=diHBSM>F4XgCUQ:=diHBSM>
F4XgCUQ:=diHBSM>F4XgCUP3O01/Ool00`00Oomoo`0HOol00`00Oomoo`03Ool00003001oo`000080
01Eoo`=l01e:NP037>M>NTii00=>NP05CWU>NTijCWY>N@03CWX01DiiCWY>NTijCWT00dij00I>NDij
CWY>NTiiCWX4O0000diiCWY>N@02CWT00dijO01l0002O0001DiHCUTLidhhBSP00dhh00E:>4hhCSQ>
>4Xh00=>>003BSQ>>4hh009l06moo`03001oogoo01Qoo`03001oogoo00=oo`000P006goo17`0031:
NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NAcWBWU>NTYiCWY:
NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NTYiCWX5O0001DijBWU>NTYiCWX01G`001A>FDiH
CUU>F4iICUQ>FAcWCUQ:=diHBSM>F4XgCUQ:=diHBSM>F4Xg0g`0LWoo00<007ooOol05goo00<007oo
Ool00goo00000goo0000000NOol4O00DBWX00acWCWU>NP02CWX01DiiCWY>NTijCWT00dij00I>NDij
CWY>NTiiCWX5O0001TijCWU>NDiiCWY>N@Al000=CUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiH7>L00Thh
00E:>4hhCSQ>>4Xh00=>>09l07Ioo`03001oogoo01Ioo`03001oogoo00=oo`000goo00<007ooOol0
7goo17`001m:NDijBWU>NTYiCWY:NDijBWU>NTYiCWY:NDijBWU>NQcWCWY:NDijBWU>NTYiCWY:NDij
BWU>NTYiCWY:N@04O0001TijBWU>NTYiCWY:N@El000ICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>
FDiHCUU>F1cWBSM>F4XgCUQ:=diHBSL00W`0NGoo00<007ooOol05Goo00<007ooOol00goo0004Ool0
0`00Oomoo`0ROol4O00;BWX01AcWCWY>NTijCWT00dij00=>NDijCWX01G`00dii00=>NTiiO00017`0
01M>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FAcW00=>>004BSQl07`0
O01lOol00`00Oomoo`0DOol00`00Oomoo`03Ool000Eoo`8002Ioo`Al000=BWU>NTYiCWY:NDijBWTL
idYiCWY:NDijBWT01G`000I:NDijBWU>NTYiCWX4O0007TYiCWTLidiICUQ>FDiHCUU>F4iICUQ>FDiH
CUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iI7>M>F09l07moo`03001oogoo01Aoo`03001oogoo
00=oo`001goo00<007ooOol09Goo00=l04iiO0000g`00TYj00<LidijCWX017`000@LidiiCWU>NP9>
N@El00E>N@0ICUPLidiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUQ>FDiHCUU>F4iICUP0
17`000=oo`00Ool0Ogoo00<007ooOol057oo00<007ooOol00Woo0008Ool2000VOol2O0000dij7>LL
i`07O00014ijBUTLidYi17`00dii00E:NDiiCWU>NDYi009>N@0C7>M>F4iICUQ>FDiHCUU>F4iICUQ>
FDiHCUU>F4iICUQ>FDiHCUT01W`01Goo00<007ooOol0Ogoo00<007ooOol04goo00<007ooOol00Woo
000:Ool00`00Oomoo`0UOol00acWO01l0002O005CWT4O00=CWT03TiI7>M>FDiHCUU>F4iICUQ>FDiH
CUU>F4iICUP6O00;Ool00`00Oomoo`20Ool00`00Oomoo`0BOol00`00Oomoo`02Ool000]oo`8002Yo
o`Ql009>N@05BWU>NDiiCWU:N@03CWT034YiCWU>NDii7>M>FDiHCUU>F4iICUQ>F@Il011oo`03001o
ogoo089oo`03001oogoo015oo`03001oogoo009oo`003Goo00<007ooOol0;goo2G`014ii00=>F1cW
CUP01W`05Woo00<007ooOol0PWoo00<007ooOol04Goo00<007ooOol00Woo000>Ool00`00Oomoo`0g
Ool7O00LOol00`00Oomoo`23Ool00`00Oomoo`0@Ool00`00Oomoo`02Ool000moo`8005Yoo`03001o
ogoo08Aoo`03001oogoo00moo`03001oogoo009oo`004Goo00<007ooOol0Egoo00<007ooOol0QGoo
00<007ooOol03Woo00<007ooOol00Woo000BOol2001GOol00`00Oomoo`26Ool00`00Oomoo`0>Ool0
0`00Oomoo`01Ool001Aoo`03001oogoo05Aoo`03001oogoo08Moo`03001oogoo00eoo`03001oogoo
005oo`005Goo00<007ooOol0Dgoo00<007ooOol0Qgoo00<007ooOol03Goo00<007ooOol00Goo000F
Ool2001COol00`00Oomoo`28Ool00`00Oomoo`0<Ool00`00Oomoo`01Ool001Qoo`03001oogoo051o
o`03001oogoo08Uoo`03001oogoo00]oo`03001oogoo005oo`006Goo0P00D7oo00<007ooOol0RWoo
00<007ooOol02Woo00<007ooOol00Goo000KOol00`00Oomoo`1=Ool00`00Oomoo`2;Ool00`00Oomo
o`09Ool00`00Oomoo`01Ool001aoo`8004eoo`03001oogoo08]oo`03001oogoo00Yoo`40005oo`5o
o`007Woo00<007ooOol0BWoo00<007ooOol0S7oo00<007ooOol02Goo0@000Goo0Goo000OOol00`00
Oomoo`19Ool00`00Oomoo`2=Ool00`00Oomoo`08Ool10001Ool1Ool0021oo`8004Uoo`03001oogoo
08ioo`03001oogoo00Moo`40005oo`5oo`008Woo00<007ooOol0AWoo00<007ooOol0Sgoo00<007oo
Ool01Woo0@000Goo0Goo000SOol20016Ool00`00Oomoo`2?Ool00`00Oomoo`06Ool10001Ool1Ool0
02Eoo`03001oogoo04=oo`03001oogoo091oo`03001oogoo00Eoo`40005oo`5oo`009Woo0P00@goo
00<007ooOol0TGoo00<007ooOol01Goo0@000Goo000XOol00`00Oomoo`10Ool00`00Oomoo`2BOol0
0`00Oomoo`04Ool10001Ool002Uoo`03001oogoo03moo`03001oogoo09=oo`03001oogoo00=oo`40
005oo`00:Woo0P00?goo00<007ooOol0U7oo00<007ooOol00Woo0@000Goo000/Ool00`00Oomoo`0l
Ool00`00Oomoo`2DOol00`00Oomoo`02Ool10001Ool002eoo`8003aoo`03001oogoo09Eoo`05001o
ogooOol00001Ool002moo`03001oogoo03Uoo`03001oogoo09Ioo`04001oogoo0001Ool0031oo`03
001oogoo03Qoo`03001oogoo09Moo`03001oo`00005oo`00<Goo0P00=goo00<007ooOol0VGoo0@00
0Goo0@00000cOol00`00Oomoo`0dOol00`00Oomoo`2IOol10001Ool1000003Aoo`8003Aoo`03001o
ogoo09Yoo`800000=Woo00<007ooOol0<Goo00<007ooOol0VGoo0`00000gOol2000aOol00`00Oomo
o`2EOol40003Ool003Uoo`03001oogoo02ioo`03001oogoo091oo`D000Moo`00>Woo00<007ooOol0
;Goo00<007ooOol0S7oo100037oo000kOol2000]Ool00`00Oomoo`28Ool4000@Ool003eoo`03001o
ogoo02Yoo`03001oogoo08=oo`D001Aoo`00?Woo0P00:Woo00<007ooOol0Ogoo10006Goo0010Ool0
0`00Oomoo`0WOol00`00Oomoo`1jOol5000MOol0045oo`03001oogoo02Ioo`03001oogoo07Ioo`@0
029oo`00@Woo0P009Woo00<007ooOol0LWoo10009Woo0014Ool00`00Oomoo`0SOol00`00Oomoo`1]
Ool5000ZOol004Eoo`8002=oo`03001oogoo06Uoo`@002moo`00Agoo00<007ooOol087oo00<007oo
Ool0I7oo1@00<goo0018Ool2000POol00`00Oomoo`1POol4000hOol004Yoo`03001oogoo01eoo`03
001oogoo05]oo`D003aoo`00Bgoo00<007ooOol077oo00<007ooOol0Egoo1000@Goo001<Ool2000L
Ool00`00Oomoo`1COol40015Ool004ioo`03001oogoo01Uoo`03001oogoo04ioo`D004Uoo`00Cgoo
0P006Goo00<007ooOol0BWoo1000CWoo001AOol00`00Oomoo`0FOol00`00Oomoo`15Ool5001BOol0
059oo`8001Ioo`03001oogoo045oo`@005Moo`00E7oo00<007ooOol04goo00<007ooOol0?Goo1000
Fgoo001EOol00`00Oomoo`0BOol00`00Oomoo`0hOol5001OOol005Ioo`80015oo`03001oogoo03Eo
o`@006Aoo`00F7oo00<007ooOol03Woo00<007ooOol0<7oo1@00J7oo001IOol2000>Ool00`00Oomo
o`0/Ool4001]Ool005]oo`03001oogoo00]oo`03001oogoo02Moo`D0075oo`00G7oo00<007ooOol0
2Woo00<007ooOol08goo1000MWoo001MOol2000:Ool00`00Oomoo`0OOol4001jOol005moo`03001o
ogoo00Moo`03001oogoo01Yoo`D007ioo`00H7oo0P001goo00<007ooOol05Woo1000Pgoo001ROol0
0`00Oomoo`04Ool00`00Oomoo`0AOol50027Ool006=oo`8000Aoo`03001oogoo00eoo`@008aoo`00
IGoo00D007ooOomoo`0000]oo`@0091oo`00IWoo00@007ooOol000Ioo`D009Aoo`00Igoo0`000Woo
1000VGoo001YOol3002MOol00001
\>"],
  ImageRangeCache->{{{0, 264.313}, {287, 0}} -> {0.0486402, -0.000148683, 
  0.00324458, 0.00324458}}]
}, Open]]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[%, BoxRatios \[Rule] {1, 1, 6}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Show::"gtype"\( : \ \)"\!\(Show\) is not a type of graphics."\)], 
  "Message"]
}, Open]],

Cell[BoxData[
    RowBox[{"Show", "[", 
      RowBox[{
        RowBox[{"Show", "[", 
          RowBox[{
            RowBox[{"ViewPoint", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["0.0429999999999999893`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->2], ",", 
                  StyleBox["0.210000000000000008`",
                    StyleBoxAutoDelete->True,
                    PrintPrecision->3], ",", 
                  RowBox[{"-", 
                    StyleBox["1.22100000000000008`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->4]}]}], "}"}]}], ",", 
            \(BoxRatios \[Rule] {1, 1, 6}\)}], "]"}], ",", 
        \(BoxRatios \[Rule] {1, 1, 6}\)}], "]"}]], "Output"],

Cell[BoxData[
    \(ViewPoint -> {0.043, \ 0.210, \ \(-1.221\)}\)], "Input"],

Cell[BoxData[
    RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
        RowBox[{
          StyleBox["0.0429999999999999893`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], ",", 
          StyleBox["0.210000000000000008`",
            StyleBoxAutoDelete->True,
            PrintPrecision->3], ",", 
          RowBox[{"-", 
            StyleBox["1.22100000000000008`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}]}], "}"}]}]], "Output"],

Cell[CellGroupData[{

Cell["Ruffle: Kappa periodic, Tau periodic; out of phase.", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Multiply Cos and Sin by 0.6 as otherwise it looks too bunchy.  Bigger width
 than 1.5 makes nice conical overlaps.  Swapping Cos and Sin gives a curve
 that looks the same.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 100; kappa[s_] := 0.6\ Cos[s]; tau[s_] := 0.6\ Sin[s]; \), 
  
    \(ds := N[\(12\ \[Pi]\)\/top]; width = 1.5; pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 0 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.53885 .50661 m .57891 .56312 L .55244 .57761 L .785 .76 .83 r
F
.55095 .49614 m .57891 .56312 L .53885 .50661 L .744 .746 .853 r
F
.55095 .49614 m .60275 .54679 L .57891 .56312 L F
.52411 .51397 m .55244 .57761 L .52608 .58894 L .823 .769 .802 r
F
.53885 .50661 m .55244 .57761 L .52411 .51397 L .785 .76 .83 r
F
1 0 0 r
.003 w
.55244 .57761 m
.57891 .56312 L
s
.5602 .48302 m .60275 .54679 L .55095 .49614 L .695 .725 .873 r
F
.25 g
.5 Mabswid
.55095 .49614 m
.55395 .49907 L
s
.53993 .54951 m
.55244 .57761 L
s
.5602 .48302 m .62175 .52998 L .60275 .54679 L .695 .725 .873 r
F
1 0 0 r
.003 w
.57891 .56312 m
.60275 .54679 L
s
.50745 .51803 m .52608 .58894 L .50244 .59603 L .859 .775 .767 r
F
.52411 .51397 m .52608 .58894 L .50745 .51803 L .823 .769 .802 r
F
1 0 0 r
.52608 .58894 m
.55244 .57761 L
s
.25 g
.5 Mabswid
.52496 .51587 m
.53993 .54951 L
s
.52411 .51397 m
.52496 .51587 L
s
.56711 .46797 m .62175 .52998 L .5602 .48302 L .628 .694 .891 r
F
.25 g
.5602 .48302 m
.56334 .48541 L
s
.56711 .46797 m .63469 .51397 L .62175 .52998 L .628 .694 .891 r
F
1 0 0 r
.003 w
.60275 .54679 m
.62175 .52998 L
s
.48965 .51907 m .50244 .59603 L .48326 .59842 L .896 .775 .72 r
F
.50745 .51803 m .50244 .59603 L .48965 .51907 L .859 .775 .767 r
F
1 0 0 r
.50244 .59603 m
.52608 .58894 L
s
.25 g
.5 Mabswid
.50745 .51803 m
.52608 .58894 L
s
.57287 .45192 m .63469 .51397 L .56711 .46797 L .527 .642 .906 r
F
.25 g
.56711 .46797 m
.57271 .47179 L
s
.57287 .45192 m .6415 .49996 L .63469 .51397 L .527 .642 .906 r
F
.25 g
.53885 .50661 m
.57891 .56312 L
s
.55395 .49907 m
.60275 .54679 L
s
.57352 .49318 m
.62175 .52998 L
s
1 0 0 r
.003 w
.62175 .52998 m
.63469 .51397 L
s
.25 g
.5 Mabswid
.60045 .49067 m
.63469 .51397 L
s
.47126 .5179 m .48326 .59842 L .46911 .59665 L .932 .767 .655 r
F
.48965 .51907 m .48326 .59842 L .47126 .5179 L .896 .775 .72 r
F
1 0 0 r
.003 w
.48326 .59842 m
.50244 .59603 L
s
.25 g
.5 Mabswid
.48965 .51907 m
.50244 .59603 L
s
0 g
.006 w
.50745 .51803 m
.52411 .51397 L
s
.52411 .51397 m
.53885 .50661 L
s
.53885 .50661 m
.55095 .49614 L
s
.48965 .51907 m
.50745 .51803 L
s
.55095 .49614 m
.5602 .48302 L
s
.57892 .43592 m .6415 .49996 L .57287 .45192 L .342 .539 .902 r
F
.25 g
.5 Mabswid
.57287 .45192 m
.57705 .45484 L
s
.56334 .48541 m
.57352 .49318 L
s
.57892 .43592 m .64321 .48889 L .6415 .49996 L .342 .539 .902 r
F
.25 g
.5806 .47716 m
.60045 .49067 L
s
.57271 .47179 m
.5806 .47716 L
s
1 0 0 r
.003 w
.63469 .51397 m
.6415 .49996 L
s
.25 g
.5 Mabswid
.61613 .4822 m
.6415 .49996 L
s
.60252 .47267 m
.61613 .4822 L
s
.57705 .45484 m
.60252 .47267 L
s
0 g
.006 w
.5602 .48302 m
.56711 .46797 L
s
.45262 .51588 m .46911 .59665 L .45953 .59228 L .962 .741 .556 r
F
.47126 .5179 m .46911 .59665 L .45262 .51588 L .932 .767 .655 r
F
1 0 0 r
.003 w
.46911 .59665 m
.48326 .59842 L
s
0 g
.006 w
.47126 .5179 m
.48965 .51907 L
s
.25 g
.5 Mabswid
.47126 .5179 m
.48326 .59842 L
s
0 g
.006 w
.56711 .46797 m
.57287 .45192 L
s
.35488 .58956 m .41871 .63694 L .40315 .65965 L .818 .736 .774 r
F
.35923 .57237 m .41871 .63694 L .35488 .58956 L .772 .712 .796 r
F
.35923 .57237 m .43047 .61697 L .41871 .63694 L F
.35025 .60669 m .40315 .65965 L .38445 .68311 L .859 .758 .751 r
F
.35488 .58956 m .40315 .65965 L .35025 .60669 L .818 .736 .774 r
F
.25 g
.5 Mabswid
.39298 .61784 m
.41871 .63694 L
s
1 0 0 r
.003 w
.40315 .65965 m
.41871 .63694 L
s
.45262 .51588 m .45953 .59228 L .43399 .51472 L .962 .741 .556 r
F
0 g
.006 w
.45262 .51588 m
.47126 .5179 L
s
.25 g
.5 Mabswid
.45262 .51588 m
.46911 .59665 L
s
.36488 .55605 m .43047 .61697 L .35923 .57237 L .715 .682 .817 r
F
.25 g
.35923 .57237 m
.35949 .57253 L
s
.35488 .58956 m
.35598 .59038 L
s
.36488 .55605 m .43852 .60124 L .43047 .61697 L .715 .682 .817 r
F
1 0 0 r
.003 w
.41871 .63694 m
.43047 .61697 L
s
.25 g
.5 Mabswid
.40869 .60334 m
.43047 .61697 L
s
.58638 .42116 m .64321 .48889 L .57892 .43592 L 0 .291 .79 r
F
0 g
.006 w
.57287 .45192 m
.57892 .43592 L
s
.58638 .42116 m .64163 .4813 L .64321 .48889 L 0 .291 .79 r
F
1 0 0 r
.003 w
.6415 .49996 m
.64321 .48889 L
s
.25 g
.5 Mabswid
.57892 .43592 m
.64321 .48889 L
s
.34401 .62268 m .38445 .68311 L .36411 .70506 L .896 .778 .723 r
F
.35025 .60669 m .38445 .68311 L .34401 .62268 L .859 .758 .751 r
F
1 0 0 r
.003 w
.38445 .68311 m
.40315 .65965 L
s
.25 g
.5 Mabswid
.37282 .62929 m
.40315 .65965 L
s
.35598 .59038 m
.35647 .59074 L
s
.35025 .60669 m
.35124 .60768 L
s
.43399 .51472 m .45345 .58751 L .41586 .51603 L .97 .675 .407 r
F
.43399 .51472 m .45953 .59228 L .45345 .58751 L F
0 g
.006 w
.43399 .51472 m
.45262 .51588 L
s
.25 g
.5 Mabswid
.43399 .51472 m
.45953 .59228 L
s
1 0 0 r
.003 w
.45953 .59228 m
.46911 .59665 L
s
.37312 .54146 m .43852 .60124 L .36488 .55605 L .642 .64 .833 r
F
.25 g
.5 Mabswid
.35647 .59074 m
.3568 .59099 L
s
.35949 .57253 m
.36135 .5737 L
s
.37312 .54146 m .44358 .5906 L .43852 .60124 L .642 .64 .833 r
F
1 0 0 r
.003 w
.43047 .61697 m
.43852 .60124 L
s
.25 g
.5 Mabswid
.3568 .59099 m
.39298 .61784 L
s
.42145 .59077 m
.43852 .60124 L
s
.41586 .51603 m .44965 .58456 L .39907 .52086 L .936 .588 .34 r
F
.41586 .51603 m .45345 .58751 L .44965 .58456 L F
0 g
.006 w
.41586 .51603 m
.43399 .51472 L
s
1 0 0 r
.003 w
.45345 .58751 m
.45953 .59228 L
s
.38457 .52947 m .44358 .5906 L .37312 .54146 L .559 .578 .83 r
F
.25 g
.5 Mabswid
.36488 .55605 m
.36717 .55745 L
s
.38457 .52947 m .44682 .58521 L .44358 .5906 L .559 .578 .83 r
F
1 0 0 r
.003 w
.43852 .60124 m
.44358 .5906 L
s
.25 g
.5 Mabswid
.41586 .51603 m
.44442 .57035 L
s
.44442 .57035 m
.45345 .58751 L
s
1 0 0 r
.003 w
.44358 .5906 m
.44609 .58642 L
s
.39907 .52086 m .44682 .58521 L .38457 .52947 L .624 .547 .747 r
F
.25 g
.5 Mabswid
.37312 .54146 m
.37415 .54217 L
s
.39907 .52086 m .44965 .58456 L .44682 .58521 L .624 .547 .747 r
F
0 g
.006 w
.39907 .52086 m
.41586 .51603 L
s
.25 g
.5 Mabswid
.36717 .55745 m
.41158 .58471 L
s
.36135 .5737 m
.40869 .60334 L
s
.41158 .58471 m
.42145 .59077 L
s
.43244 .58282 m
.4359 .58524 L
s
.4359 .58524 m
.44358 .5906 L
s
.42421 .57709 m
.43244 .58282 L
s
.41523 .57082 m
.42421 .57709 L
s
.37415 .54217 m
.41523 .57082 L
s
1 0 0 r
.003 w
.44609 .58642 m
.44682 .58521 L
s
.25 g
.5 Mabswid
.44204 .57498 m
.44754 .58191 L
s
.43531 .5665 m
.44204 .57498 L
s
.39907 .52086 m
.43531 .5665 L
s
.44754 .58191 m
.44965 .58456 L
s
1 0 0 r
.003 w
.44965 .58456 m
.45345 .58751 L
s
0 g
.006 w
.38457 .52947 m
.39907 .52086 L
s
.59579 .40889 m .64163 .4813 L .58638 .42116 L .602 .183 0 r
F
0 g
.57892 .43592 m
.58638 .42116 L
s
.67931 .41131 m .7005 .48405 L .6774 .48486 L .74 .73 .843 r
F
.69429 .41614 m .7005 .48405 L .67931 .41131 L .689 .728 .88 r
F
.69429 .41614 m .72663 .48109 L .7005 .48405 L F
.33553 .63637 m .36411 .70506 L .34431 .72317 L .933 .794 .684 r
F
.34401 .62268 m .36411 .70506 L .33553 .63637 L .896 .778 .723 r
F
.25 g
.5 Mabswid
.34401 .62268 m
.34621 .62598 L
s
.34621 .62598 m
.38445 .68311 L
s
1 0 0 r
.003 w
.36411 .70506 m
.38445 .68311 L
s
.25 g
.5 Mabswid
.35251 .60895 m
.37282 .62929 L
s
.35124 .60768 m
.35251 .60895 L
s
.70786 .41891 m .72663 .48109 L .69429 .41614 L .621 .716 .914 r
F
.70786 .41891 m .75295 .47666 L .72663 .48109 L F
1 0 0 r
.003 w
.7005 .48405 m
.72663 .48109 L
s
.59579 .40889 m .63904 .47726 L .64163 .4813 L .602 .183 0 r
F
1 0 0 r
.64163 .4813 m
.64321 .48889 L
s
.25 g
.5 Mabswid
.58638 .42116 m
.64163 .4813 L
s
.44228 .58114 m
.44682 .58521 L
s
.43609 .5756 m
.44228 .58114 L
s
.42866 .56895 m
.43609 .5756 L
s
.38457 .52947 m
.42866 .56895 L
s
1 0 0 r
.003 w
.44682 .58521 m
.44965 .58456 L
s
.66388 .40535 m .6774 .48486 L .6592 .4835 L .779 .726 .803 r
F
.67931 .41131 m .6774 .48486 L .66388 .40535 L .74 .73 .843 r
F
1 0 0 r
.6774 .48486 m
.7005 .48405 L
s
.25 g
.5 Mabswid
.67931 .41131 m
.7005 .48405 L
s
0 g
.006 w
.37312 .54146 m
.38457 .52947 L
s
.60712 .40025 m .63904 .47726 L .59579 .40889 L .858 .495 0 r
F
0 g
.58638 .42116 m
.59579 .40889 L
s
.71891 .41906 m .75295 .47666 L .70786 .41891 L .526 .69 .943 r
F
.71891 .41906 m .77614 .47163 L .75295 .47666 L F
.25 g
.5 Mabswid
.71423 .45619 m
.72663 .48109 L
s
.69429 .41614 m
.71423 .45619 L
s
1 0 0 r
.003 w
.72663 .48109 m
.75295 .47666 L
s
.64864 .3997 m .6592 .4835 L .64673 .48076 L .81 .715 .761 r
F
.66388 .40535 m .6592 .4835 L .64864 .3997 L .779 .726 .803 r
F
1 0 0 r
.6592 .4835 m
.6774 .48486 L
s
.25 g
.5 Mabswid
.66388 .40535 m
.6774 .48486 L
s
0 g
.006 w
.36488 .55605 m
.37312 .54146 L
s
.60712 .40025 m .63779 .4764 L .63904 .47726 L .858 .495 0 r
F
1 0 0 r
.003 w
.63904 .47726 m
.64163 .4813 L
s
.25 g
.5 Mabswid
.59579 .40889 m
.63654 .4733 L
s
.61997 .39597 m .63779 .4764 L .60712 .40025 L .546 .481 .734 r
F
0 g
.006 w
.59579 .40889 m
.60712 .40025 L
s
.63393 .39607 m .64673 .48076 L .63986 .47794 L .818 .686 .719 r
F
.64864 .3997 m .64673 .48076 L .63393 .39607 L .81 .715 .761 r
F
1 0 0 r
.003 w
.64673 .48076 m
.6592 .4835 L
s
.25 g
.5 Mabswid
.60712 .40025 m
.61135 .41075 L
s
1 0 0 r
.003 w
.63895 .4772 m
.63904 .47726 L
s
.25 g
.5 Mabswid
.64864 .3997 m
.6592 .4835 L
s
0 g
.006 w
.35923 .57237 m
.36488 .55605 L
s
.61997 .39597 m .63986 .47794 L .63779 .4764 L .546 .481 .734 r
F
.25 g
.5 Mabswid
.61135 .41075 m
.63779 .4764 L
s
.63393 .39607 m .63986 .47794 L .61997 .39597 L .818 .686 .719 r
F
.25 g
.61997 .39597 m
.62142 .40192 L
s
.62142 .40192 m
.63986 .47794 L
s
1 0 0 r
.003 w
.63779 .4764 m
.63986 .47794 L
s
0 g
.006 w
.60712 .40025 m
.61997 .39597 L
s
.25 g
.5 Mabswid
.63393 .39607 m
.64673 .48076 L
s
1 0 0 r
.003 w
.63986 .47794 m
.64673 .48076 L
s
.32494 .64668 m .34431 .72317 L .32742 .73545 L .968 .803 .624 r
F
.33553 .63637 m .34431 .72317 L .32494 .64668 L .933 .794 .684 r
F
.25 g
.5 Mabswid
.33595 .63739 m
.36411 .70506 L
s
1 0 0 r
.003 w
.34431 .72317 m
.36411 .70506 L
s
.25 g
.5 Mabswid
.33553 .63637 m
.33595 .63739 L
s
0 g
.006 w
.35488 .58956 m
.35923 .57237 L
s
.61997 .39597 m
.63393 .39607 L
s
.72655 .41632 m .77614 .47163 L .71891 .41906 L .382 .634 .954 r
F
.25 g
.5 Mabswid
.71891 .41906 m
.72184 .42176 L
s
.72655 .41632 m .79317 .46669 L .77614 .47163 L .382 .634 .954 r
F
.25 g
.72016 .43466 m
.75295 .47666 L
s
.70786 .41891 m
.72016 .43466 L
s
1 0 0 r
.003 w
.75295 .47666 m
.77614 .47163 L
s
0 g
.006 w
.35025 .60669 m
.35488 .58956 L
s
.63393 .39607 m
.64864 .3997 L
s
.34401 .62268 m
.35025 .60669 L
s
.64864 .3997 m
.66388 .40535 L
s
.33553 .63637 m
.34401 .62268 L
s
.66388 .40535 m
.67931 .41131 L
s
.31279 .65293 m .32742 .73545 L .31525 .74059 L .996 .794 .515 r
F
.32494 .64668 m .32742 .73545 L .31279 .65293 L .968 .803 .624 r
F
.25 g
.5 Mabswid
.32494 .64668 m
.34431 .72317 L
s
1 0 0 r
.003 w
.32742 .73545 m
.34431 .72317 L
s
0 g
.006 w
.32494 .64668 m
.33553 .63637 L
s
.67931 .41131 m
.69429 .41614 L
s
.73052 .41059 m .79317 .46669 L .72655 .41632 L .152 .514 .914 r
F
.25 g
.5 Mabswid
.72184 .42176 m
.726 .42558 L
s
.73052 .41059 m .80197 .46214 L .79317 .46669 L .152 .514 .914 r
F
.25 g
.726 .42558 m
.77614 .47163 L
s
1 0 0 r
.003 w
.77614 .47163 m
.79317 .46669 L
s
0 g
.006 w
.69429 .41614 m
.70786 .41891 L
s
.70786 .41891 m
.71891 .41906 L
s
.31279 .65293 m .31525 .74059 L .29963 .65504 L .996 .794 .515 r
F
0 g
.31279 .65293 m
.32494 .64668 L
s
.25 g
.5 Mabswid
.31279 .65293 m
.32742 .73545 L
s
0 g
.006 w
.71891 .41906 m
.72655 .41632 L
s
.29963 .65504 m .31525 .74059 L .30831 .73852 L .971 .72 .294 r
F
1 0 0 r
.003 w
.31525 .74059 m
.32742 .73545 L
s
.73135 .40205 m .80197 .46214 L .73052 .41059 L 0 .262 .735 r
F
.73135 .40205 m .80201 .45802 L .80197 .46214 L F
.25 g
.5 Mabswid
.72655 .41632 m
.73705 .42426 L
s
.73705 .42426 m
.79317 .46669 L
s
1 0 0 r
.003 w
.79317 .46669 m
.80197 .46214 L
s
.25 g
.5 Mabswid
.73451 .41347 m
.80197 .46214 L
s
.73052 .41059 m
.73451 .41347 L
s
.29963 .65504 m .30831 .73852 L .28577 .65367 L .971 .72 .294 r
F
0 g
.006 w
.29963 .65504 m
.31279 .65293 L
s
.25 g
.5 Mabswid
.29963 .65504 m
.31525 .74059 L
s
0 g
.006 w
.72655 .41632 m
.73052 .41059 L
s
.28577 .65367 m .30563 .73061 L .27131 .65017 L .727 .446 0 r
F
.28591 .65421 m .30831 .73852 L .30563 .73061 L F
.28585 .65398 m .30831 .73852 L .28591 .65421 L F
.27131 .65017 m .30563 .73061 L .30532 .71954 L 0 .026 .593 r
F
.27131 .65017 m .29889 .70642 L .25648 .6463 L F
.29889 .70642 m .30532 .71954 L .30026 .71196 L F
.29889 .70642 m .30026 .71196 L .25648 .6463 L F
.28577 .65367 m .28585 .65398 L .28591 .65421 L .727 .446 0 r
F
0 g
.28577 .65367 m
.29963 .65504 L
s
.25 g
.5 Mabswid
.28577 .65367 m
.28585 .65398 L
s
.28585 .65398 m
.30084 .71039 L
s
.30557 .7282 m
.30831 .73852 L
s
1 0 0 r
.003 w
.30831 .73852 m
.31525 .74059 L
s
0 g
.006 w
.27131 .65017 m
.28577 .65367 L
s
1 0 0 r
.003 w
.30563 .73061 m
.30831 .73852 L
s
.73026 .39136 m .80201 .45802 L .73135 .40205 L .655 .137 0 r
F
.73026 .39136 m .79436 .45439 L .80201 .45802 L F
1 0 0 r
.80197 .46214 m
.80201 .45802 L
s
0 g
.006 w
.73052 .41059 m
.73135 .40205 L
s
.25 g
.5 Mabswid
.73135 .40205 m
.78163 .44188 L
s
.29307 .70117 m
.30563 .73061 L
s
.25648 .6463 m .30532 .71954 L .30543 .70852 L .216 .355 .79 r
F
.25648 .6463 m .30543 .70852 L .242 .64378 L F
.25 g
.28209 .6847 m
.30532 .71954 L
s
0 g
.006 w
.25648 .6463 m
.27131 .65017 L
s
1 0 0 r
.003 w
.30532 .71954 m
.30563 .73061 L
s
.72859 .37967 m .79436 .45439 L .73026 .39136 L .888 .461 .148 r
F
.72859 .37967 m .78139 .45142 L .79436 .45439 L F
1 0 0 r
.79436 .45439 m
.80201 .45802 L
s
0 g
.006 w
.73026 .39136 m
.73135 .40205 L
s
.25 g
.5 Mabswid
.73026 .39136 m
.75533 .416 L
s
.242 .64378 m .30543 .70852 L .30467 .70054 L .414 .516 .853 r
F
1 0 0 r
.003 w
.30532 .71954 m
.30543 .70852 L
s
.242 .64378 m .30467 .70054 L .22914 .64391 L .414 .516 .853 r
F
0 g
.006 w
.242 .64378 m
.25648 .6463 L
s
.25 g
.5 Mabswid
.27807 .68059 m
.30543 .70852 L
s
.72729 .36858 m .78139 .45142 L .72859 .37967 L .925 .613 .433 r
F
0 g
.006 w
.72859 .37967 m
.73026 .39136 L
s
.22914 .64391 m .30467 .70054 L .3024 .69776 L .136 .478 .898 r
F
1 0 0 r
.003 w
.30467 .70054 m
.30543 .70852 L
s
.72729 .36858 m .76625 .44937 L .78139 .45142 L .925 .613 .433 r
F
1 0 0 r
.78139 .45142 m
.79436 .45439 L
s
.25 g
.5 Mabswid
.72859 .37967 m
.74034 .39563 L
s
.21944 .64727 m .3024 .69776 L .29841 .7014 L .797 .633 .679 r
F
.25 g
.30175 .69835 m
.30467 .70054 L
s
.22914 .64391 m .3024 .69776 L .21944 .64727 L .136 .478 .898 r
F
1 0 0 r
.003 w
.3024 .69776 m
.30467 .70054 L
s
0 g
.006 w
.22914 .64391 m
.242 .64378 L
s
1 0 0 r
.003 w
.30049 .6995 m
.3024 .69776 L
s
.21405 .65381 m .29841 .7014 L .29269 .71173 L .821 .678 .705 r
F
.25 g
.5 Mabswid
.30231 .6977 m
.3024 .69776 L
s
.21944 .64727 m .29841 .7014 L .21405 .65381 L .797 .633 .679 r
F
1 0 0 r
.003 w
.29841 .7014 m
.30049 .6995 L
s
.2133 .66313 m .29269 .71173 L .28554 .7282 L .864 .704 .682 r
F
.25 g
.5 Mabswid
.29507 .6933 m
.30231 .6977 L
s
.21405 .65381 m .29269 .71173 L .2133 .66313 L .821 .678 .705 r
F
.25 g
.28984 .69656 m
.29841 .7014 L
s
1 0 0 r
.003 w
.29269 .71173 m
.29841 .7014 L
s
.25 g
.5 Mabswid
.29118 .71081 m
.29269 .71173 L
s
.21944 .64727 m
.23322 .65566 L
s
0 g
.006 w
.21944 .64727 m
.22914 .64391 L
s
.21653 .67467 m .28554 .7282 L .27757 .74936 L .91 .725 .639 r
F
.25 g
.5 Mabswid
.28583 .68767 m
.29507 .6933 L
s
.2133 .66313 m .28554 .7282 L .21653 .67467 L .864 .704 .682 r
F
.25 g
.28106 .69161 m
.28984 .69656 L
s
.27836 .70296 m
.29118 .71081 L
s
1 0 0 r
.003 w
.28554 .7282 m
.29269 .71173 L
s
.25 g
.5 Mabswid
.2133 .66313 m
.21518 .66427 L
s
.72673 .35986 m .76625 .44937 L .72729 .36858 L .9 .675 .589 r
F
0 g
.006 w
.72729 .36858 m
.72859 .37967 L
s
.72673 .35986 m .75225 .44849 L .76625 .44937 L .9 .675 .589 r
F
1 0 0 r
.003 w
.76625 .44937 m
.78139 .45142 L
s
.25 g
.5 Mabswid
.72729 .36858 m
.73212 .3786 L
s
.22229 .68782 m .27757 .74936 L .26977 .77304 L .955 .74 .573 r
F
.25 g
.27086 .68586 m
.28106 .69161 L
s
.21653 .67467 m .27757 .74936 L .22229 .68782 L .91 .725 .639 r
F
.25 g
.21405 .65381 m
.27086 .68586 L
s
.26876 .69708 m
.27836 .70296 L
s
.26812 .71469 m
.28554 .7282 L
s
1 0 0 r
.003 w
.27757 .74936 m
.28554 .7282 L
s
.25 g
.5 Mabswid
.21789 .67572 m
.21878 .67642 L
s
.21653 .67467 m
.21789 .67572 L
s
.23322 .65566 m
.28583 .68767 L
s
0 g
.006 w
.21405 .65381 m
.21944 .64727 L
s
.72685 .35515 m .75225 .44849 L .72673 .35986 L .87 .708 .679 r
F
0 g
.72673 .35986 m
.72729 .36858 L
s
.72685 .35515 m .74219 .44897 L .75129 .44497 L .87 .708 .679 r
F
.72757 .35555 m .74219 .44897 L .72685 .35515 L .882 .758 .721 r
F
.72757 .35555 m .73805 .45079 L .74219 .44897 L F
.73805 .45079 m .73807 .45089 L .74219 .44897 L F
.75129 .44497 m .74219 .44897 L .75225 .44849 L .87 .708 .679 r
F
0 g
.72673 .35986 m
.72685 .35515 L
s
1 0 0 r
.003 w
.75225 .44849 m
.76625 .44937 L
s
.25 g
.5 Mabswid
.72673 .35986 m
.72731 .36189 L
s
.72731 .36189 m
.7288 .36708 L
s
1 0 0 r
.003 w
.74219 .44897 m
.75225 .44849 L
s
.22889 .70172 m .26977 .77304 L .26344 .79637 L .989 .743 .463 r
F
.25 g
.5 Mabswid
.25841 .70715 m
.26812 .71469 L
s
.22229 .68782 m .26977 .77304 L .22889 .70172 L .955 .74 .573 r
F
.25 g
.25925 .72896 m
.27757 .74936 L
s
1 0 0 r
.003 w
.26977 .77304 m
.27757 .74936 L
s
.25 g
.5 Mabswid
.22284 .68843 m
.224 .68972 L
s
.22229 .68782 m
.22284 .68843 L
s
.21518 .66427 m
.26876 .69708 L
s
.72901 .36134 m .73807 .45089 L .72757 .35555 L .423 .461 .795 r
F
.25 g
.72685 .35515 m
.72892 .36779 L
s
.72901 .36134 m .74081 .4542 L .73807 .45089 L .423 .461 .795 r
F
1 0 0 r
.003 w
.74026 .44987 m
.74219 .44897 L
s
.25 g
.5 Mabswid
.73805 .45079 m
.73807 .45089 L
s
.73147 .37182 m .74081 .4542 L .72901 .36134 L .568 .618 .862 r
F
.25 g
.72757 .35555 m
.72932 .37139 L
s
.73147 .37182 m .75038 .45863 L .74081 .4542 L .568 .618 .862 r
F
1 0 0 r
.003 w
.73807 .45089 m
.74081 .4542 L
s
0 g
.006 w
.2133 .66313 m
.21405 .65381 L
s
.73515 .38553 m .76567 .46389 L .75038 .45863 L .5 .62 .901 r
F
.73971 .40073 m .75269 .43231 L .73515 .38553 L .359 .582 .927 r
F
.75269 .43231 m .7573 .44351 L .75258 .43028 L F
.7573 .44351 m .75829 .44492 L .75258 .43028 L F
.7573 .44351 m .76567 .46389 L .75829 .44492 L F
.75269 .43231 m .75258 .43028 L .73515 .38553 L F
.73971 .40073 m .78447 .46994 L .76567 .46389 L F
.74411 .41589 m .77277 .45427 L .73971 .40073 L .104 .471 .893 r
F
.77277 .45427 m .78447 .46994 L .77682 .45812 L F
.77277 .45427 m .77682 .45812 L .73971 .40073 L F
.74411 .41589 m .80344 .47724 L .78447 .46994 L F
.74679 .42992 m .80344 .47724 L .74411 .41589 L 0 .216 .677 r
F
.74933 .43204 m .81856 .48647 L .80344 .47724 L F
.74913 .43187 m .74927 .43198 L .74933 .43204 L F
.74927 .43198 m .81856 .48647 L .74933 .43204 L F
.74679 .42992 m .74896 .43163 L .74913 .43187 L F
.74896 .43163 m .81856 .48647 L .74913 .43187 L F
.75346 .44645 m .82593 .498 L .81856 .48647 L .664 .12 0 r
F
.75086 .44486 m .75348 .44671 L .75346 .44645 L F
.75348 .44671 m .82593 .498 L .75346 .44645 L F
.74296 .42303 m .75038 .45863 L .74212 .42069 L .5 .62 .901 r
F
.74618 .44198 m .75106 .44541 L .75086 .44486 L .664 .12 0 r
F
.75106 .44541 m .82593 .498 L .75086 .44486 L F
.73515 .38553 m .74296 .42303 L .73147 .37182 L .5 .62 .901 r
F
.74296 .42303 m .74212 .42069 L .73147 .37182 L F
.25 g
.5 Mabswid
.74948 .45448 m
.75038 .45863 L
s
.74784 .44697 m
.74948 .45448 L
s
.74593 .4382 m
.74684 .44238 L
s
.74686 .44245 m
.74784 .44697 L
s
.73147 .37182 m
.73189 .37374 L
s
.73189 .37374 m
.74593 .4382 L
s
1 0 0 r
.003 w
.74081 .4542 m
.75038 .45863 L
s
.25 g
.5 Mabswid
.74076 .45383 m
.74081 .4542 L
s
.74024 .4497 m
.74076 .45383 L
s
.72968 .3666 m
.74024 .4497 L
s
.72901 .36134 m
.72968 .3666 L
s
.72932 .37139 m
.73805 .45079 L
s
1 0 0 r
.003 w
.75038 .45863 m
.76567 .46389 L
s
.25 g
.5 Mabswid
.73515 .38553 m
.74314 .40603 L
s
1 0 0 r
.003 w
.76567 .46389 m
.78447 .46994 L
s
0 g
.006 w
.72685 .35515 m
.72757 .35555 L
s
1 0 0 r
.003 w
.78447 .46994 m
.78782 .47123 L
s
.22889 .70172 m .26344 .79637 L .23495 .7151 L .989 .743 .463 r
F
.23495 .7151 m .26344 .79637 L .26012 .81611 L .966 .695 .268 r
F
1 0 0 r
.26344 .79637 m
.26977 .77304 L
s
.25 g
.5 Mabswid
.25149 .74114 m
.26977 .77304 L
s
.2494 .718 m
.25925 .72896 L
s
.224 .68972 m
.2494 .718 L
s
.22889 .70172 m
.23002 .7037 L
s
.21878 .67642 m
.25841 .70715 L
s
0 g
.006 w
.2133 .66313 m
.21653 .67467 L
s
.72757 .35555 m
.72901 .36134 L
s
.25 g
.5 Mabswid
.7871 .46034 m
.79252 .46595 L
s
.74411 .41589 m
.74432 .41612 L
s
0 g
.006 w
.21653 .67467 m
.22229 .68782 L
s
.22229 .68782 m
.22889 .70172 L
s
.72901 .36134 m
.73147 .37182 L
s
.23495 .7151 m .26012 .81611 L .23976 .72633 L .966 .695 .268 r
F
.23976 .72633 m .26012 .81611 L .26135 .82911 L .769 .51 0 r
F
1 0 0 r
.003 w
.26012 .81611 m
.26344 .79637 L
s
.25 g
.5 Mabswid
.24106 .72295 m
.25149 .74114 L
s
.23002 .7037 m
.23017 .70396 L
s
.23017 .70396 m
.24106 .72295 L
s
.24452 .74238 m
.26344 .79637 L
s
.24137 .7334 m
.24452 .74238 L
s
.74618 .44198 m .81856 .48647 L .74679 .42992 L .664 .12 0 r
F
.25 g
.74697 .43007 m
.74896 .43163 L
s
.74679 .42992 m
.74697 .43007 L
s
.73971 .40073 m
.76043 .43278 L
s
0 g
.006 w
.22889 .70172 m
.23495 .7151 L
s
.73147 .37182 m
.73515 .38553 L
s
.73515 .38553 m
.73971 .40073 L
s
.24324 .73374 m .26135 .82911 L .26815 .83298 L 0 0 .433 r
F
.23976 .72633 m .26135 .82911 L .24324 .73374 L .769 .51 0 r
F
0 g
.23495 .7151 m
.23976 .72633 L
s
.73971 .40073 m
.74411 .41589 L
s
.74119 .4513 m .82593 .498 L .74618 .44198 L .821 .351 .093 r
F
.25 g
.5 Mabswid
.74618 .44198 m
.75262 .4465 L
s
.74119 .4513 m .82274 .51135 L .82593 .498 L .821 .351 .093 r
F
.25 g
.74896 .43163 m
.78543 .46036 L
s
.78543 .46036 m
.81856 .48647 L
s
.74432 .41612 m
.76773 .44032 L
s
.76773 .44032 m
.7871 .46034 L
s
1 0 0 r
.003 w
.81856 .48647 m
.82593 .498 L
s
0 g
.006 w
.74411 .41589 m
.74679 .42992 L
s
.24324 .73374 m .26815 .83298 L .24556 .7361 L 0 0 .433 r
F
0 g
.23976 .72633 m
.24324 .73374 L
s
.25 g
.5 Mabswid
.24324 .73374 m
.26135 .82911 L
s
0 g
.006 w
.74618 .44198 m
.74679 .42992 L
s
.24556 .7361 m .26815 .83298 L .28028 .82682 L .084 .162 .648 r
F
1 0 0 r
.003 w
.26135 .82911 m
.26815 .83298 L
s
.24556 .7361 m .28028 .82682 L .24685 .73304 L .084 .162 .648 r
F
0 g
.006 w
.24324 .73374 m
.24556 .7361 L
s
.25 g
.5 Mabswid
.24556 .7361 m
.26815 .83298 L
s
.73161 .45716 m .82274 .51135 L .74119 .4513 L .859 .475 .315 r
F
.25 g
.74119 .4513 m
.74555 .45451 L
s
.73161 .45716 m .80817 .52508 L .82274 .51135 L .859 .475 .315 r
F
.25 g
.75262 .4465 m
.82593 .498 L
s
1 0 0 r
.003 w
.82274 .51135 m
.82593 .498 L
s
.25 g
.5 Mabswid
.74555 .45451 m
.82274 .51135 L
s
0 g
.006 w
.74119 .4513 m
.74618 .44198 L
s
.24685 .73304 m .29583 .81173 L .24701 .72513 L .357 .361 .727 r
F
.24685 .73304 m .28028 .82682 L .29583 .81173 L F
0 g
.24556 .7361 m
.24685 .73304 L
s
.25 g
.5 Mabswid
.24685 .73304 m
.28028 .82682 L
s
1 0 0 r
.003 w
.26815 .83298 m
.28028 .82682 L
s
.71817 .45915 m .80817 .52508 L .73161 .45716 L .858 .545 .458 r
F
0 g
.006 w
.73161 .45716 m
.74119 .4513 L
s
.71817 .45915 m .78369 .53728 L .80817 .52508 L .858 .545 .458 r
F
1 0 0 r
.003 w
.80817 .52508 m
.82274 .51135 L
s
.25 g
.5 Mabswid
.73161 .45716 m
.80817 .52508 L
s
.24701 .72513 m .31171 .79071 L .24595 .71372 L .522 .478 .748 r
F
.24701 .72513 m .29583 .81173 L .31171 .79071 L F
0 g
.006 w
.24685 .73304 m
.24701 .72513 L
s
.25 g
.5 Mabswid
.24701 .72513 m
.29583 .81173 L
s
1 0 0 r
.003 w
.28028 .82682 m
.29583 .81173 L
s
.24595 .71372 m .32485 .76773 L .244 .70055 L .63 .551 .747 r
F
.24595 .71372 m .31171 .79071 L .32485 .76773 L F
0 g
.006 w
.24595 .71372 m
.24701 .72513 L
s
.25 g
.5 Mabswid
.24595 .71372 m
.31171 .79071 L
s
1 0 0 r
.003 w
.29583 .81173 m
.31171 .79071 L
s
.7022 .45754 m .78369 .53728 L .71817 .45915 L .84 .59 .56 r
F
0 g
.006 w
.71817 .45915 m
.73161 .45716 L
s
.7022 .45754 m .75267 .54635 L .78369 .53728 L .84 .59 .56 r
F
1 0 0 r
.003 w
.78369 .53728 m
.80817 .52508 L
s
.25 g
.5 Mabswid
.71817 .45915 m
.78369 .53728 L
s
.244 .70055 m .32485 .76773 L .33346 .74671 L .706 .603 .739 r
F
1 0 0 r
.003 w
.31171 .79071 m
.32485 .76773 L
s
.24225 .6874 m .33346 .74671 L .33747 .73064 L .764 .644 .73 r
F
.244 .70055 m .33346 .74671 L .24225 .6874 L .706 .603 .739 r
F
1 0 0 r
.32485 .76773 m
.33346 .74671 L
s
.24247 .67568 m .33747 .73064 L .33807 .72129 L .803 .689 .739 r
F
.25 g
.5 Mabswid
.33238 .74601 m
.33346 .74671 L
s
.24225 .6874 m .33747 .73064 L .24247 .67568 L .764 .644 .73 r
F
1 0 0 r
.003 w
.33346 .74671 m
.33747 .73064 L
s
.25 g
.5 Mabswid
.33433 .72883 m
.33747 .73064 L
s
.24655 .66641 m .33807 .72129 L .33706 .71929 L .451 .714 .98 r
F
.24247 .67568 m .33807 .72129 L .24655 .66641 L .803 .689 .739 r
F
1 0 0 r
.003 w
.33747 .73064 m
.33807 .72129 L
s
.25 g
.5 Mabswid
.33611 .72011 m
.33807 .72129 L
s
.24291 .67594 m
.24551 .67745 L
s
.24247 .67568 m
.24291 .67594 L
s
.24225 .6874 m
.24261 .68763 L
s
0 g
.006 w
.244 .70055 m
.24595 .71372 L
s
.24655 .66641 m .33706 .71929 L .25572 .66014 L .451 .714 .98 r
F
.25 g
.5 Mabswid
.25808 .66185 m
.26735 .66859 L
s
.25572 .66014 m
.25808 .66185 L
s
1 0 0 r
.003 w
.33706 .71929 m
.33807 .72129 L
s
.25 g
.5 Mabswid
.25041 .66873 m
.25338 .67051 L
s
.24655 .66641 m
.25041 .66873 L
s
.24551 .67745 m
.33433 .72883 L
s
.24261 .68763 m
.33238 .74601 L
s
.244 .70055 m
.32485 .76773 L
s
0 g
.006 w
.24225 .6874 m
.244 .70055 L
s
.68499 .45352 m .75267 .54635 L .7022 .45754 L .812 .619 .641 r
F
0 g
.7022 .45754 m
.71817 .45915 L
s
.68499 .45352 m .71951 .55159 L .75267 .54635 L .812 .619 .641 r
F
1 0 0 r
.003 w
.75267 .54635 m
.78369 .53728 L
s
.25 g
.5 Mabswid
.7022 .45754 m
.75267 .54635 L
s
0 g
.006 w
.24225 .6874 m
.24247 .67568 L
s
.66736 .44905 m .71951 .55159 L .68499 .45352 L .774 .635 .708 r
F
0 g
.68499 .45352 m
.7022 .45754 L
s
.66736 .44905 m .68847 .55338 L .71951 .55159 L .774 .635 .708 r
F
1 0 0 r
.003 w
.71951 .55159 m
.75267 .54635 L
s
.25 g
.5 Mabswid
.68499 .45352 m
.71951 .55159 L
s
.59792 .46536 m .63157 .55422 L .63455 .55169 L .716 .758 .886 r
F
.58396 .48198 m .63157 .55422 L .59792 .46536 L .851 .467 0 r
F
.58396 .48198 m .63419 .56045 L .63157 .55422 L F
.61419 .45368 m .63455 .55169 L .64477 .55175 L .605 .647 .865 r
F
.59792 .46536 m .63455 .55169 L .61419 .45368 L .716 .758 .886 r
F
1 0 0 r
.003 w
.63157 .55422 m
.63455 .55169 L
s
.57287 .50231 m .63419 .56045 L .58396 .48198 L .838 .392 0 r
F
.25 g
.5 Mabswid
.59792 .46536 m
.60139 .47451 L
s
.57287 .50231 m .63997 .57109 L .63419 .56045 L .838 .392 0 r
F
1 0 0 r
.003 w
.63157 .55422 m
.63419 .56045 L
s
.64956 .44637 m .68847 .55338 L .66736 .44905 L .725 .641 .765 r
F
.64956 .44637 m .66291 .55289 L .68847 .55338 L F
0 g
.006 w
.66736 .44905 m
.68499 .45352 L
s
1 0 0 r
.003 w
.68847 .55338 m
.71951 .55159 L
s
.25 g
.5 Mabswid
.66736 .44905 m
.68847 .55338 L
s
.6317 .44748 m .64477 .55175 L .66291 .55289 L .664 .641 .817 r
F
.61419 .45368 m .64477 .55175 L .6317 .44748 L .605 .647 .865 r
F
1 0 0 r
.003 w
.63455 .55169 m
.64477 .55175 L
s
.25 g
.5 Mabswid
.61419 .45368 m
.62101 .48654 L
s
.6317 .44748 m .66291 .55289 L .64956 .44637 L .664 .641 .817 r
F
.25 g
.64956 .44637 m
.66291 .55289 L
s
1 0 0 r
.003 w
.64477 .55175 m
.66291 .55289 L
s
.25 g
.5 Mabswid
.6317 .44748 m
.63189 .44902 L
s
.63311 .54474 m
.63455 .55169 L
s
1 0 0 r
.003 w
.66291 .55289 m
.68847 .55338 L
s
.56423 .52482 m .63997 .57109 L .57287 .50231 L .898 .486 .196 r
F
.25 g
.5 Mabswid
.58396 .48198 m
.58618 .48544 L
s
.56423 .52482 m .64559 .58657 L .63997 .57109 L .898 .486 .196 r
F
1 0 0 r
.003 w
.63419 .56045 m
.63997 .57109 L
s
.25 g
.5 Mabswid
.63328 .55903 m
.63419 .56045 L
s
.63409 .56507 m
.63997 .57109 L
s
.64336 .54053 m
.64477 .55175 L
s
0 g
.006 w
.24247 .67568 m
.24655 .66641 L
s
.64956 .44637 m
.66736 .44905 L
s
.31732 .63071 m .38882 .69737 L .39019 .70128 L .805 .336 0 r
F
.55655 .54804 m .64559 .58657 L .56423 .52482 L .891 .538 .37 r
F
.25 g
.5 Mabswid
.56423 .52482 m
.57363 .53195 L
s
.57287 .50231 m
.57373 .50319 L
s
.57373 .50319 m
.60099 .53114 L
s
.62101 .48654 m
.63311 .54474 L
s
.63189 .44902 m
.64336 .54053 L
s
.55655 .54804 m .64713 .60702 L .64559 .58657 L .891 .538 .37 r
F
.25 g
.6299 .54981 m
.63157 .55422 L
s
.63045 .55461 m
.63328 .55903 L
s
1 0 0 r
.003 w
.63997 .57109 m
.64559 .58657 L
s
.25 g
.5 Mabswid
.64085 .58297 m
.64559 .58657 L
s
.31732 .63071 m .39019 .70128 L .33602 .62465 L .805 .336 0 r
F
.33602 .62465 m .39019 .70128 L .39548 .71004 L .652 .216 0 r
F
1 0 0 r
.003 w
.38882 .69737 m
.39019 .70128 L
s
.25 g
.5 Mabswid
.25338 .67051 m
.33611 .72011 L
s
.38611 .69484 m
.38882 .69737 L
s
.38471 .69353 m
.38611 .69484 L
s
0 g
.006 w
.24655 .66641 m
.25572 .66014 L
s
.6317 .44748 m
.64956 .44637 L
s
.35824 .62232 m .39548 .71004 L .40667 .72126 L 0 .131 .679 r
F
.25 g
.5 Mabswid
.38328 .69151 m
.39019 .70128 L
s
.33602 .62465 m .39548 .71004 L .35824 .62232 L .652 .216 0 r
F
.25 g
.26735 .66859 m
.33706 .71929 L
s
.54785 .57065 m .64713 .60702 L .55655 .54804 L .859 .56 .481 r
F
.25 g
.55655 .54804 m
.56152 .55128 L
s
.60099 .53114 m
.63409 .56507 L
s
.58618 .48544 m
.63045 .55461 L
s
.60139 .47451 m
.6299 .54981 L
s
.54785 .57065 m .64083 .63203 L .64713 .60702 L .859 .56 .481 r
F
.25 g
.63574 .57909 m
.64085 .58297 L
s
1 0 0 r
.003 w
.64559 .58657 m
.64713 .60702 L
s
0 g
.006 w
.61419 .45368 m
.6317 .44748 L
s
.38247 .6233 m .40667 .72126 L .42523 .73196 L .236 .375 .801 r
F
.35824 .62232 m .40667 .72126 L .38247 .6233 L 0 .131 .679 r
F
.25 g
.5 Mabswid
.38788 .69215 m
.39548 .71004 L
s
1 0 0 r
.003 w
.39548 .71004 m
.40667 .72126 L
s
.25 g
.5 Mabswid
.35824 .62232 m
.35932 .62486 L
s
.53638 .59135 m .64083 .63203 L .54785 .57065 L .82 .567 .556 r
F
.25 g
.54785 .57065 m
.54886 .57131 L
s
.56152 .55128 m
.60488 .57951 L
s
.57363 .53195 m
.63574 .57909 L
s
.53638 .59135 m .62423 .66008 L .64083 .63203 L .82 .567 .556 r
F
.25 g
.60488 .57951 m
.6288 .59508 L
s
.6288 .59508 m
.64713 .60702 L
s
1 0 0 r
.003 w
.64083 .63203 m
.64713 .60702 L
s
0 g
.006 w
.59792 .46536 m
.61419 .45368 L
s
.40745 .62646 m .42523 .73196 L .45167 .73888 L .455 .48 .796 r
F
.38247 .6233 m .42523 .73196 L .40745 .62646 L .236 .375 .801 r
F
1 0 0 r
.003 w
.40667 .72126 m
.42523 .73196 L
s
.25 g
.5 Mabswid
.38247 .6233 m
.38308 .62576 L
s
.38308 .62576 m
.38324 .62642 L
s
.38324 .62642 m
.40667 .72126 L
s
.35932 .62486 m
.38788 .69215 L
s
0 g
.006 w
.58396 .48198 m
.59792 .46536 L
s
.52121 .60879 m .62423 .66008 L .53638 .59135 L .78 .566 .61 r
F
.25 g
.5 Mabswid
.53638 .59135 m
.53908 .59346 L
s
.52121 .60879 m .59719 .68827 L .62423 .66008 L .78 .566 .61 r
F
.25 g
.54886 .57131 m
.61037 .61192 L
s
.61037 .61192 m
.64083 .63203 L
s
1 0 0 r
.003 w
.62423 .66008 m
.64083 .63203 L
s
.25 g
.5 Mabswid
.53908 .59346 m
.62423 .66008 L
s
.43245 .62997 m .45167 .73888 L .48515 .73903 L .572 .524 .763 r
F
.40745 .62646 m .45167 .73888 L .43245 .62997 L .455 .48 .796 r
F
1 0 0 r
.003 w
.42523 .73196 m
.45167 .73888 L
s
.25 g
.5 Mabswid
.40745 .62646 m
.42523 .73196 L
s
0 g
.006 w
.57287 .50231 m
.58396 .48198 L
s
.56423 .52482 m
.57287 .50231 L
s
.55655 .54804 m
.56423 .52482 L
s
.54785 .57065 m
.55655 .54804 L
s
.53638 .59135 m
.54785 .57065 L
s
.50236 .62168 m .59719 .68827 L .52121 .60879 L .739 .561 .653 r
F
0 g
.52121 .60879 m
.53638 .59135 L
s
.45703 .63158 m .48515 .73903 L .52325 .73041 L .644 .544 .727 r
F
.43245 .62997 m .48515 .73903 L .45703 .63158 L .572 .524 .763 r
F
1 0 0 r
.003 w
.45167 .73888 m
.48515 .73903 L
s
.25 g
.5 Mabswid
.43245 .62997 m
.45167 .73888 L
s
.50236 .62168 m .56214 .71286 L .59719 .68827 L .739 .561 .653 r
F
1 0 0 r
.003 w
.59719 .68827 m
.62423 .66008 L
s
.48062 .62923 m .56214 .71286 L .50236 .62168 L .696 .554 .69 r
F
0 g
.006 w
.50236 .62168 m
.52121 .60879 L
s
.25 g
.5 Mabswid
.52121 .60879 m
.52342 .61111 L
s
.52342 .61111 m
.59719 .68827 L
s
0 g
.006 w
.31732 .63071 m
.33602 .62465 L
s
.48062 .62923 m .52325 .73041 L .56214 .71286 L .696 .554 .69 r
F
1 0 0 r
.003 w
.56214 .71286 m
.59719 .68827 L
s
.45703 .63158 m .52325 .73041 L .48062 .62923 L .644 .544 .727 r
F
1 0 0 r
.48515 .73903 m
.52325 .73041 L
s
.25 g
.5 Mabswid
.50236 .62168 m
.56214 .71286 L
s
.463 .65439 m
.48515 .73903 L
s
.45843 .63694 m
.463 .65439 L
s
0 g
.006 w
.48062 .62923 m
.50236 .62168 L
s
.25 g
.5 Mabswid
.48062 .62923 m
.52325 .73041 L
s
.45703 .63158 m
.45843 .63694 L
s
0 g
.006 w
.45703 .63158 m
.48062 .62923 L
s
.43245 .62997 m
.45703 .63158 L
s
.40745 .62646 m
.43245 .62997 L
s
.38247 .6233 m
.40745 .62646 L
s
.33602 .62465 m
.35824 .62232 L
s
1 0 0 r
.003 w
.52325 .73041 m
.56214 .71286 L
s
0 g
.006 w
.35824 .62232 m
.38247 .6233 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000181000`40O003h00Oogoo2Woo002`Ool2
001GOol00:ioo`800003Ool0000005Ioo`00Zgoo0`000goo0P00EWoo002YOol20006Ool00`00Ool0
001EOol00:Moo`8000Qoo`03001oo`0005Eoo`00Y7oo0`002Woo00@007ooOol005Aoo`00XWoo0P00
3Goo00D007ooOomoo`0005=oo`00Wgoo0`003goo00D007ooOomoo`0005=oo`00WGoo0P004Woo00<0
07ooOol00Woo00<007ooOol0D7oo002KOol2000EOol00`00Oomoo`02Ool00`00Oomoo`1?Ool009Qo
o`<001Moo`03001oogoo009oo`03001oogoo04moo`00UWoo0P006Woo00<007ooOol00goo00<007oo
Ool0CWoo002COol3000LOol00`00Oomoo`03Ool00`00Oomoo`1>Ool0095oo`8001moo`03001oogoo
00Aoo`03001oogoo04eoo`00Sgoo0P008Goo00<007ooOol01Goo00<007ooOol0C7oo002<Ool3000S
Ool00`00Oomoo`05Ool00`00Oomoo`1<Ool008Yoo`8002Ioo`03001oogoo00Ioo`03001oogoo04]o
o`00Qgoo0`00:7oo00<007ooOol01goo00<007ooOol0BWoo0025Ool2000[Ool00`00Oomoo`07Ool0
0`00Oomoo`1:Ool008=oo`8002eoo`03001oogoo00Qoo`03001oogoo04Uoo`00P7oo0`00;goo00<0
07ooOol027oo00<007ooOol0BGoo001nOol2000bOol00`00Oomoo`09Ool00`00Oomoo`18Ool007]o
o`<003Aoo`03001oogoo00Yoo`03001oogoo04Moo`00NGoo0P00=goo00<007ooOol02Woo00<007oo
Ool0Agoo001gOol2000iOol00`00Oomoo`0;Ool00`00Oomoo`16Ool007Aoo`<003]oo`03001oogoo
00aoo`03001oogoo04Eoo`00LWoo0P00?goo00<007ooOol02goo00<007ooOol0AGoo001_Ool30011
Ool00`00Oomoo`0<Ool00`00Oomoo`14Ool006eoo`8004Aoo`03001oogoo00aoo`03001oogoo04Ao
o`00Jgoo0P00AWoo00<007ooOol03Goo00<007ooOol0@goo001XOol30018Ool00`00Oomoo`0>Ool0
0`00Oomoo`12Ool006Ioo`8004]oo`03001oogoo00ioo`03001oogoo049oo`00Hgoo0`00CGoo00<0
07ooOol03goo00<007ooOol0@Goo001QOol2001@Ool00`00Oomoo`0@Ool00`00Oomoo`10Ool005io
o`<0059oo`03001oogoo011oo`03001oogoo041oo`00G7oo0P00EGoo00<007ooOol04Goo00<007oo
Ool0?goo001JOol2001GOol00`00Oomoo`0AOol00`00Oomoo`0oOol005Moo`<005Uoo`03001oogoo
019oo`03001oogoo03ioo`00EGoo0P00G7oo00<007ooOol04goo00<007ooOol0?Goo001BOol3001N
Ool00`00Oomoo`0COol00`00Oomoo`0mOol0051oo`80065oo`03001oogoo01Aoo`03001oogoo03ao
o`00CWoo0P00Hgoo00<007ooOol05Goo00<007ooOol0>goo001;Ool3001UOol00`00Oomoo`0EOol0
0`00Oomoo`0kOol004Uoo`8006Uoo`03001oogoo01Eoo`03001oogoo03Yoo`00AWoo0`00Jgoo00<0
07ooOol05Goo00<007ooOol0>Woo0014Ool2001^Ool00`00Oomoo`0FOol00`00Oomoo`0iOol0049o
o`80071oo`03001oogoo01Moo`03001oogoo03Qoo`00?goo0`00LWoo00<007ooOol05goo00<007oo
Ool0>7oo000mOol2001eOol00`00Oomoo`0HOol00`00Oomoo`0gOol003Yoo`<007Moo`03001oogoo
01Uoo`03001oogoo03Ioo`00>7oo0P00NWoo00<007ooOol06Goo00<007ooOol0=Woo000fOol2001l
Ool00`00Oomoo`0JOol00`00Oomoo`0eOol003=oo`<007ioo`03001oogoo01Yoo`03001oogoo03Eo
o`00<Goo0P00PGoo00<007ooOol06goo00<007ooOol0=7oo000^Ool30023Ool00`00Oomoo`0LOol0
0`00Oomoo`0cOol002aoo`8008Ioo`03001oogoo01aoo`03001oogoo03=oo`00:Woo0P00R7oo00<0
07ooOol07Goo00<007ooOol0<Woo000WOol3002:Ool00`00Oomoo`0NOol00`00Oomoo`0aOol002Eo
o`8008eoo`03001oogoo01ioo`03001oogoo035oo`008Woo0`00Sgoo00<007ooOol07goo00<007oo
Ool0<7oo000POol2002COol00`00Oomoo`0NOol00`00Oomoo`0`Ool001ioo`8009Eoo`03001oogoo
01moo`03001oogoo02moo`006goo0`00Ugoo00<007ooOol087oo00<007ooOol0;Woo000IOol2002J
Ool00`00Oomoo`0POol00`00Oomoo`0^Ool001Moo`8009aoo`03001oogoo025oo`03001oogoo02eo
o`005goo0P00W7oo00<007ooOol08Woo00<007ooOol0;7oo000GOol00`00Ool0002KOol00`00Oomo
o`0ROol00`00Oomoo`0/Ool001Moo`04001oogoo002JOol00`00Oomoo`0SOol00`00Oomoo`0[Ool0
01Ioo`03001oogoo009oo`03001oogoo09Moo`03001oogoo02=oo`03001oogoo02]oo`005Woo00<0
07ooOol00goo00<007ooOol0UWoo00<007ooOol097oo00<007ooOol0:Woo000FOol00`00Oomoo`04
Ool00`00Oomoo`2EOol00`00Oomoo`0UOol00`00Oomoo`0YOol001Ioo`03001oogoo00Eoo`03001o
ogoo09Aoo`03001oogoo02Eoo`03001oogoo02Uoo`005Woo00<007ooOol01Woo00<007ooOol0Tgoo
00<007ooOol09Woo00<007ooOol0:7oo000FOol00`00Oomoo`07Ool00`00Oomoo`2BOol00`00Oomo
o`0WOol00`00Oomoo`0WOol001Eoo`03001oogoo00Uoo`03001oogoo095oo`03001oogoo02Moo`03
001oogoo02Moo`005Goo00<007ooOol02Woo00<007ooOol0T7oo00<007ooOol0:7oo00<007ooOol0
9Woo000EOol00`00Oomoo`0;Ool00`00Oomoo`2?Ool00`00Oomoo`0XOol00`00Oomoo`0VOol001Eo
o`03001oogoo00aoo`03001oogoo08moo`03001oogoo02Qoo`03001oogoo02Eoo`005Goo00<007oo
Ool03Goo00<007ooOol0SWoo00<007ooOol0:Goo00<007ooOol097oo000EOol00`00Oomoo`0>Ool0
0`00Oomoo`2=Ool00`00Oomoo`0YOol00`00Oomoo`0TOol001Eoo`03001oogoo00moo`03001oogoo
08aoo`03001oogoo02Yoo`03001oogoo02=oo`0057oo00<007ooOol04Goo00<007ooOol0Rgoo00<0
07ooOol0:goo00<007ooOol08Woo000DOol00`00Oomoo`0BOol00`00Oomoo`2:Ool00`00Oomoo`0[
Ool00`00Oomoo`0ROol001Aoo`03001oogoo01=oo`03001oogoo08Uoo`03001oogoo02aoo`03001o
ogoo025oo`0057oo00<007ooOol057oo00<007ooOol0R7oo00<007ooOol0;7oo00<007ooOol08Goo
000DOol00`00Oomoo`0EOol00`00Oomoo`27Ool00`00Oomoo`0]Ool00`00Oomoo`0POol001Aoo`03
001oogoo01Ioo`03001oogoo08Ioo`03001oogoo02ioo`03001oogoo01moo`004goo00<007ooOol0
5goo00<007ooOol0QWoo00<007ooOol0;Woo00<007ooOol07goo000COol00`00Oomoo`0HOol00`00
Oomoo`25Ool00`00Oomoo`0_Ool00`00Oomoo`0NOol001=oo`03001oogoo01Uoo`03001oogoo08Ao
o`03001oogoo031oo`03001oogoo01eoo`004goo00<007ooOol06Woo00<007ooOol0Pgoo00<007oo
Ool0<7oo00<007ooOol07Goo000COol00`00Oomoo`0KOol00`00Oomoo`22Ool00`00Oomoo`0aOol0
0`00Oomoo`0LOol001=oo`03001oogoo01aoo`03001oogoo085oo`03001oogoo035oo`03001oogoo
01aoo`004Woo00<007ooOol07Woo00<007ooOol0P7oo00<007ooOol01goo00<007ooOol0:7oo00<0
07ooOol06goo000BOol00`00Oomoo`0OOol00`00Oomoo`1oOol00`00Oomoo`07Ool00`00Oomoo`0Y
Ool00`00Oomoo`0JOol0019oo`03001oogoo021oo`03001oogoo07moo`03001oogoo00Ioo`03001o
ogoo02Uoo`03001oogoo01Yoo`004Woo00<007ooOol08Goo00<007ooOol0OWoo00<007ooOol01Woo
00<007ooOol0:Woo00<007ooOol06Goo000BOol00`00Oomoo`0ROol00`00Oomoo`1mOol00`00Oomo
o`06Ool00acW001oo`0[Ool00`00Oomoo`0HOol0019oo`03001oogoo02=oo`03001oogoo07aoo`03
001oogoo00Ioo`037>L007oo02]oo`03001oogoo01Qoo`004Woo00<007ooOol097oo00<007ooOol0
Ngoo00<007ooOol01Woo00<Li`00Ool0;7oo00<007ooOol05goo000AOol00`00Oomoo`0VOol00`00
Oomoo`1jOol00`00Oomoo`06Ool27>L00`00Oomoo`0ZOol00`00Oomoo`0GOol0015oo`03001oogoo
02Moo`03001oogoo07Uoo`03001oogoo00Ioo`8Li`03001oogoo02]oo`03001oogoo01Ioo`004Goo
00<007ooOol0:7oo00<007ooOol0N7oo00<007ooOol01goo00<Li`00Ool0;Goo00<007ooOol05Goo
000AOol00`00Oomoo`0YOol00`00Oomoo`1gOol00`00Oomoo`07Ool27>L00`00Oomoo`0[Ool00`00
Oomoo`0EOol0015oo`03001oogoo02Yoo`03001oogoo065oo`L000ioo`03001oogoo00Moo`8Li`03
001oogoo02aoo`03001oogoo01Aoo`004Goo00<007ooOol0:goo00<007ooOol0GWoo0P0000=1mVJf
7>L00VJf00<LifKG00000P002goo00<007ooOol01goo00@LidIj001bKBioo`03001oogoo01=oo`00
47oo00<007ooOol0;Goo00<007ooOol0G7oo00H001cW@MI5md7F7>L2I[H01AcWI]QVefKH7>L00P00
2Goo00<007ooOol01goo00DLidIk000Lig9/02eoo`03001oogoo01=oo`0047oo00<007ooOol0;Woo
00<007ooOol0FWoo00L006gPJN0Lid7fAOLLi`02I[H01acWI]MVefKG7>MRf6;I00<000Ioo`03001o
ogoo00Moo`<Li`03001fKGoo02eoo`03001oogoo019oo`0047oo00<007ooOol0;goo00<007ooOol0
F7oo01@006gPJN1]h1cWAOM1eVJf7>MZ]VJf7>MRefKH7>MRnEkHH_TLiekj0`000goo00<007ooOol0
1goo0acW00<001cWMVd0;Goo00<007ooOol04Woo000@Ool00`00Oomoo`0`Ool00`00Oomoo`1FOol0
0`00B:0Li`02JN001AcW@OI1mVJf7>L00VJf00`LifKGI]MVeacWH]URf1cWG]YNnU[J7>L200000goo
001oo`07Ool020004Q`LifkE000Lig9]MVd/Ool2000COol0011oo`03001oogoo035oo`03001oogoo
05Aoo`0;001<X4RP7>MYh6gPJN0Lid7FAOLLi`02I[H03QcWI]MVf6;G7>MRf6;iG]PLie[JG_YJfAcW
E]/;000020gl7>M6NP002M/Lig9/LL@XOol300000goo001oo`0BOol0011oo`03001oogoo039oo`03
001oogoo059oo`030018X4RP0098X0077>MYh6WP7>M5md7f7>L00VJf00DLifKGI]MVeacW00=Rf@09
7>MNnUkJG_XLieKkE]/001cW00=>g0057>M2_AcW;Yh^O@027>L01TIk7>L001cWMVebKBEoo`<000Ao
o`03001oogoo015oo`0047oo00<007ooOol0<goo00<007ooOol0DGoo02`001cWC:18X4bPJN0LifWP
KN0LidGgI[HLifJf7>MRefKHI]LLiekHH_URf1cWF]UNnU[J7>MFfeKlE]/004[LC]e:g4kL7>M2_QcW
;Yh^OAcWAWXLi`000QcW00=fKG9/Ool087oo0`001goo00<007ooOol04Goo000?Ool00`00Oomoo`0e
Ool00`00Oomoo`1?Ool010000AP1>1cW0dRP00TLifgPJN0Lid7fI[HLifJf7>L00fKG00hLif;IH]QR
fAcWG_YJfUkjG]XLieKKE_/001cW0dkL00hLid:m@[dLibjN7>M6Ncil0000e1cWLVefKFg37Goo0`00
2goo00<007ooOol047oo000?Ool00`00Oomoo`0fOol00`00Oomoo`1>Ool0:0000CT1604i7>M<X4RP
C:0LifgP7>M5md7F7>MV]QcWI]MVf6;G7>MRf6;iG]PLie[JG_YJfEkj7>MFneKK000LidkLB]a>gD[L
7>Ln_D:n0QcW00Y6NVkE0000e@3D7>MbK7I]KL<LiaQoo`<000ioo`03001oogoo011oo`003goo00<0
07ooOol0=goo00<007ooOol0CGoo00H0004H0CP1604h7>L2B:0026WP7>M]h1cW@OHLifJf7>L3I]L0
3acWH]URfF;IH]PLiekJG_YJfQcWE]]Fn`00E_/Li`04C]`00acW@[e2_@027>L02TIj000LiacW0=@L
ig9]LLA]`acW57oo0`004Goo00<007ooOol047oo000?Ool00`00Oomoo`0hOol00`00Oomoo`1;Ool0
=`009Q/Li`4H0CT1604i7>M<X4RP7>MYh1cW@MIZ]QcWI[HLifKHI]MVf1cWH_URf6;i7>MNnU[JG_YJ
fAcWE]/005KK7>M:g4kLB]a>gD[L7>Ln_D:n7>M6N`00E61@H1cW0=@Lig9/LLA]`acW00moo`@001Ao
o`03001oogoo011oo`003goo00<007ooOol0>Goo00<007ooOol0BWoo00<002XL:Q`00QcW00@1>04H
0CPLi`98X0077>MYh1cW@OHLifJf7>L00fKG00lLif;HH]URfAcWF]YNnUkJG_XLieKk001FneKK7>L0
14kL00LLid:m@[dLi`00ID8Li`02D6001QcW0=@Lig9]LLA@P0aoo`<001Qoo`03001oogoo011oo`00
3goo00<007ooOol0>Woo00<007ooOol0B7oo00h002Xl:Q/Z?2HK:S`Li`4i0AP1>AcWC:0LifgP3P00
01MJfEkjF]XLieKK001FfeKk7>M>gD[LC]a:g4kM7>M2_AcW001U@QcWID5DH51P00<Li`03KL=aa4aP
00Qoo`<001]oo`03001oogoo011oo`003Woo00<007ooOol0?7oo00<007ooOol0Agoo00<002XL:Q`0
12XL00@Li`4h0AP1>0<00003BY]BVAcW00=BV@087>MJUeZGFYMJV1cWHYIRMP@00006E_/005KkE]]F
nacW1DkL00<Li`00ID800VE20QcW0e1P0acW00=l0520Ool00goo0`007Woo00<007ooOol047oo000>
Ool00`00Oomoo`0mOol00`00Oomoo`15Ool04P00?Y`LibHK:S`Z6bXl9Q/Z?1cW0CT001cWBYY>VdZJ
EYXLi`9BV@0=EYXLieZHFYMNV5ZG7>MNMF:FGWERUQcWIW@0100000EFfacWB]a>gD[L00<00008JLTL
iacWJF9U@VUR7>L^G@9@H0<Li`9l00<0025oo`03001oogoo011oo`003Woo00<007ooOol0?Woo00<0
07ooOol0A7oo00<004:L@Y`00QcW1BXL00<005/K7>L00dZK00=BVAcWDYT00U:I00<LieZGFYP00eZG
00XLif9eHYIRMV:F7>MVM000IW@Li`D00003JRi^;QcW009Yb@03KLTLifE2009U@P8Li`03:Ue@H51P
008Li`034Qal07`002=oo`03001oogoo00moo`003Woo00<007ooOol0?goo00<007ooOol0@Woo00H0
04:L?Y]2W3jL@Y`27>L032XK:S`005/LF_]K71cWCY]:VTjKDYTLi`=BV@0@7>MJUeZHFYMNV1cWHYIN
MF:FGWDLif9c001VLacWIU02JU402AcWJPe^;VX=KRhLifgYJLU]j@027>L01FE2JF9U@AcW:U`00U1P
0QcW00<B77`0Ool08Woo00<007ooOol03goo000>Ool00`00Oomoo`10Ool00`00Oomoo`11Ool00`00
@Ya2W004@Y`02BXL7>L005/KF_]K6e[k7>M:VP02BY/00e:I7>MBV@02DYT041cWFYMJUeZHFYLLif9f
HYIRMF:F7>MVM000IWAVLacW0fYA00HLifX]JRiZ;Vh^7>L2JLT00fg9ID8Li`03ID827>L010WLD60L
iacW97oo00<007ooOol03goo000>Ool00`00Oomoo`11Ool00`00Oomoo`10Ool0:@007>LLid:L?Y]2
W3jL@Y`001cWF_]K75KkFa`LidjKBYY>Ve:I7>MBVEJJDYTLieZGGYQJUeZH7>MRUUieHYINMF:F7>L0
069cIW@LifYAIU000VYA01@LifX=KRiZ3Fh^7>M]jFW9KNUYbAcWID9YHVE1JF8Lig`0D61DH1cW8goo
00<007ooOol03goo000>Ool00`00Oomoo`12Ool00`00Oomoo`0nOol01@00C[a>^djl7>L00d:L00P0
06W07>MK6e[kFa]JnacW0TZK00=:VU:I7>L00e:I00<LieZHFYL00UZG00`Lif9eHYIRMV:FHWDLi`00
IWAVLfId7>L3JU400acWKRiZ;@02JRh01Vh^7>LLifW9KLUYb@8Li`=U@P8Li`9@H0037>Moogoo021o
o`03001oogoo00moo`003Goo00<007ooOol0A7oo00<007ooOol0?Goo01D004jkC]a>^dkL7>M2W000
KL1Y`1cWE_]K75[kFaa:VQcWBYY>Ve:I7>L00e:I014LieZGFYQJUejH7>MRUUieHYINMF:F7>L006Ic
IWARLacW009ZD@0CIU1ZDAcWKRiZ3Fh^JPe^;VX=7>MYbFgYJLUYHQcWJF9U@FURID800QcW00<0eAcW
7>L087oo00<007ooOol03goo000=Ool00`00Oomoo`15Ool00`00Oomoo`0lOol01`00C[a>^djlC[]>
_00000AY`0067>MJne/KF_]K6acW0TZK00=BVAcWDYT00U:I00@LieZGFYMJV09JU`0<7>MRUV9eHYIR
MV:F001VM6IcIWAVLacW16YA00<Lifh^JRd00VX^00E^;VX]7>MYbFg9009Yb@037>MU@VE200=U@P04
7>M@H51P7>LOOol00`00Oomoo`0?Ool000eoo`03001oogoo04Ioo`03001oogoo03Yoo`08000Lidjk
C]a>^dkL000Li`=Y`00PKL0Lie/LE_]K75[k7>M:VTjKDYTLie:IEYYBVAcWFYMNV5ZGFYQJUacWGWER
UUieHYINM@00HW=VM6IcIW@Li`=ZD@0>IU1ZDAcWKRiZ3Fh^JPe^;VX=7>MYbFgYJLU]j@8Li`04ID5Y
HVE2JF827>L00e1PO01oo`0NOol00`00Oomoo`0>Ool000eoo`03001oogoo04Moo`03001oogoo03Qo
o`03001FfeKK008Li`05C[a>^`00JH0Li`04JL002AcWFa]Jne/K7>M:VdZJBY/Li`04DYT04QcWFYMJ
UeZGFYPLif:FHWIRUV9eHYHLi`00IW=VM6IcIW@Li`EZD@037>M^;VX]009Z;P05KRiZ;AcWJLU]b@03
JLT00acWID9U@P03ID800acWD61l000NOol00`00Oomoo`0>Ool000eoo`03001oogoo04Qoo`03001o
ogoo03Moo`0;001FfU[kE]]FnacW001UP6V07>M]`003JL002QcWF_]K75Kk7>M:VTjKBYYFVQcW0U:I
01AFVQcWFYQJUejHFYLLieieHYINMF:FGWERUP00IWARLfIdIW<LifI@0fYA01EVD6YA7>M^;VX=KRiZ
3Fh^JPdLifW9KNUYbFgYJLTLifE1JF9U@VURID400QcW7Woo00<007ooOol03Woo000=Ool00`00Oomo
o`18Ool00`00Oomoo`0fOol00`007>MFf`04E]/01@00JH1YP6V07>L00fW000HLie/KF_]K6dZJ7>L2
BY/00e:I7>MBV@02DYT00acWFYMJV002FYL03QcWHYIRMF:FHWIRUV9e001VLfIdIW=VM6Ic7>L6JU40
0acWKRiZ;@02JRh01Fh^JRdLifW9KLT00fW90QcW1FE200=l07ooOol06goo00<007ooOol03Woo000<
Ool00`00Oomoo`1:Ool00`00Oomoo`0cOol200003U[jF_/LieKkE]YJn`00JH1UP6V0IH1YP1cWKL02
JL002QcWFaaJne/L7>M>VdZJDYTLieJJ0U:I01DLiejHFYMJV5ZGGYPLif:FGWERUUieHYH001cWIW=V
M69cIWAVLacWIU000fYA01IVD1cWJPe^;VX=KRiZ3Fh^JPdLifW9KNUYbFgYJLU]jAcWJF9U@VURID5l
01eoo`03001oogoo00ioo`0037oo00<007ooOol0Bgoo00<007ooOol0<Goo00<005kjG_X00Ukj00EF
facWE]]Ff`0000EYP00=7>MY`6W0JL0Lie[kFa]JnacWBYY:Ve:I7>L00e:I01@LieZGFYMJUeZHFYLL
if9fHYIRMF:FHWH001cWIWAVLfIdIW=VM1cW1VYA00@LifX^KRiZ;@9Z;P05KRiZ;AcWJLU]b@03JLT0
1Fg97>MU@VE2O0007Woo00<007ooOol03Woo000<Ool00`00Oomoo`1<Ool00`00Oomoo`0^Ool20000
76<J7>MNne[jG_]JnU[k7>L006gU7>MUP6V0IH1YP6F07>MY`6g0JL0LieKkFa`LidjKBYYFVQcW0U:I
01QFVQcWFYQJUejHFYMJV1cWHYINMF:FGWERUP007>MRLfIdIW=VM69cIW@LifYAIU03JU402FI@7>MZ
3Fh^JPe^;VX=KRiZ3@027>L01FgYJLU]jFW9KNT00QcW00=l07ooOol077oo00<007ooOol03Woo000<
Ool00`00Oomoo`1=Ool00`00Oomoo`0ZOol3000016;iHaYRnAcW1Ekj00EFf`00LNE]iAcW00EYP007
7>MY`6W07>MK6e[k7>L00TZK00=:VQcWDYT00U:I00<LieZGFYP00eZG00lLif9eHYIRMV:FHWD0069f
7>MVLfIdIW=VM6Ic7>L01fYA00@LifX^KRiZ;@9Z;P05KRiZ;FX^7>M]b@03JLT00fg9JLUl000OOol0
0`00Oomoo`0=Ool000aoo`03001oogoo04ioo`03001oogoo00aooa<000Eoo`D0000GIaPLif;iHaYR
nF<JH_TLie[jG_]JnUkkF_X006gULNI]iAcWIH1YP6F0JH0Li`02JL002AcWF_]K74ZJ7>M:VTjK7>MF
VP03DYT05AcWFYMJV5ZGGYPLif:FGWERUUieHYH006:F7>MVM69cIWAVLfIdHW<Li`02JU4056I@JU5Z
DFYAIU0LifX=KRiZ3Fh^JPe^;VX=KRhLifgYJLU]jFW9O00POol00`00Oomoo`0=Ool000aoo`03001o
ogoo04moo`03001oogoo00Qoo`<0009fBP057>Mj[7Z/NZ`Li`04N_400acWMaAg5002Ma@00acWLaI_
5P0500000f/GKaPLi`03IaT021cWHaYRnF<JH_US6V;i7>L3G_X00`00KNEai@02LND00fgU7>MYP003
JH001acWJL1Y`1cWF_]:VacW009:V`037>MBVE:I009BV@0E7>MJUeZGFYQJUacWHWIRUV9eHYIRMP00
HWDLifIcIWAVLfIdIW=VM1cW00QZD@047>MZ;Vh^JRd2JRh01Fh^JReZ;QcWKLT00W`08Goo00<007oo
Ool03Goo000;Ool00`00Oomoo`1AOol00`00Oomoo`05Ool200000dhg7>MbB@02MTX00acWNZaj[002
NZ`0DAcWN_5fl7[a7>Mg57<DMaAc4acWKaIc5VlFLaHLiflHJaM_66/GKaPLif/IIaQ[6AcWHaYRnF<J
H_US6V;i7>MJnUkk001aiVgULNI]iG7VKNDLifF0JH1UP6V07>MY`1cWFaaJnacWBYY>Ve:I7>MBVEJJ
DYTLieZGGYQJUeZHFYLLieieHYINMF:F001RUUie7>MVLfIdHW=VM6IcIW@Li`03JU403fI@JU5ZDFYA
IU0LifX=KRiZ3Fh^JPe^;VX=KRil000SOol00`00Oomoo`0=Ool000]oo`03001oogoo059oo`03001o
ogoo009oo`8000A>=`057>MfBWI:MTXLi`03NZ`00acWN_5jl@02N_401AcWMaAg57LD7>L00g<F00U_
5QcWJaM_66/GJaQ[5acWIaP00VLI00PLif;iHaYRnF<JH_US6QcW0Ukj00@001cWLNE]i@=ai@03KNDL
ifV0009YP00:7>MY`6W07>MK6acWBY]:VU:I7>L3DYT00acWFYQJU`02FYL04EZH7>MRUV9fHYIRM@00
HWIRUQcWIWAVLfIdIW=VM6Ic7>L026YA00DLifX^JRi^;VX]009Z;P9l02Aoo`03001oogoo00eoo`00
2goo00<007ooOol0Dgoo00H007ooOol0048i7>L2CSL01dXfCSMfBQcWLTUfBQcW00=j[00h7>MjlGK`
N_5fl1cWLa=g57<DMa@Lig<FKaIc5QcWKaQ[5flHJaM_61cWJaUW66/IIaPLif;iHaYRnF<JH_US6QcW
001^2W8[7>MaiVgULNI]iG7VKNDLifF0JH1UP1cWJL0LieKk7>M:VTjKDYTLi`=BV@0H7>MJUeZHFYMN
V5ZG7>MNMF:FGWERUP00HYINMAcWHW=VM6IcIWARLfIdIW<LifI@0fYA00YVD6YAJU5ZDAcWKRiZ3Fh^
JPel02Ioo`03001oogoo00eoo`002goo00<007ooOol0E7oo0P0000A6FDIJAUTLi`A>=`057>MfBWI:
MTXLi`03NZ`01AcWN_5jlG[a7>L017LD00<LiflFLaH00W<F00HLif/HJaM_66/G7>L2IaT04FLHIaTL
if<JH_US6V;iHaYRnF<J001b2fh;LP/Lig7UKND00g7U00=]iAcWJH000VV00QcW00IK6acWBY]:Ve:I
7>L3DYT011cWFYMJUeZH0UZG014Lif:FHWERUV9f001RMF:FHWHLifIcIWAVLfIdIW=VM1cW00UZD@04
7>MZ;W`0O00WOol00`00Oomoo`0=Ool000]oo`03001oogoo05Eoo`060016FTHiAUY2>AcW0Thg00I:
=Thg7>MfBW997>L3NZ`09AcWM_1jlGK`7>Mc57LDLa=g51cWLaI_5W<FKaHLif/GKaQ[5flHJaLLifLH
JaUW66/I7>MS6V;iHaYRnF<JH_T006h:LR]^2W8[008Li`0]KNEaiVgULNI]iAcWIH1YP1cWKL0LidjK
7>M>VdZJ7>MBVEJJDYTLieZGGYQJUeZHFYLLieieHYINMF:F001RUUieHYHLifIdHW=VM6IcIWARLfId
7>MZDFI@00=ZD@03IU1ZDG`0009l02Uoo`03001oogoo00eoo`002goo00<007ooOol0E7oo00P004IJ
AUU6FTIIAUY6FAcW14hg00@LigI:MTXLi`9j[0057>MjlG[aN_4Li`04Ma@031cWLaIc5VlFLaHLiflH
JaM[66/GKaPLi`=W6@0AIaPLif;iHaYRnF<JH_T006h;LP]^2g8;KP]b2fh;7>M]i@03LND016gU7>MY
P6V00QcW00EJnacWBYY:VacW00ABV@0G7>MJUeZGFYMJV1cWHYIRMV:FHWD0069fHYIRMAcWIW=VM6Ic
IWAVLfIdIW<Li`03JU44O00]Ool00`00Oomoo`0<Ool000]oo`03001oogoo05=oo`0:001BVQcW7>M2
>DIJASU6FT8i7>L2CSL01TXfMTXLigI:NZ`Li`9j[00`7>MjlGK`N_4LigLDLaAg51cWLaI_5W<FKaHL
if/GKaQ[5flHJaLLifLHJaUW66/IIaPLif;iHaYRnF<J001b:fh:LR]^2W8[KPYb:fh:7>M]iG7VKNEa
iVgU7>MUP6V00acW00=>VdZJ7>L00e:I01EFVQcWFYQJUejHFYMJV1cWHYINMF:F001RUUieHYINMAcW
IW=VM69cIW@01W`0<Goo00<007ooOol037oo000:Ool00`00Oomoo`1DOol02P00CYUBVTjJ7>M6FDIJ
AUU6FTII0QcW0Thg00AfBQcWMTXLi`9j[0057>MjlG[aN_4Li`03Ma@00acWKaIc5P02LaH02AcWJaQ[
5flHJaM[61cWIaUW6003IaT03acWHaYRnF<J001Z;QcWLP]^2g8;KP]b2fh;LP]^2`027>L3LND00fgU
7>MYP0037>L2O0000acWO01l0002DYT00acWFYMJV003FYL01AcWHWERUV9f00002G`0=goo00<007oo
Ool037oo000:Ool00`00Oomoo`1COol01P00CWUBVTiiDYY>N@8Li`0<AUY6>DIJ@SU6FQcWCSM:=WI:
7>Mj[1cW0WZ/01lLigK`N_4LigLDLa=g51cWLaI_5W<FKaHLif/GKaQ[5flHJaM_61cWJaUW66/IIaQ[
6AcWHaYRn@00JRi^;`027>L046h:LR]^2W8[KPYb:fh:LR/Lig7VKNEaiVgU7>MUP1cW1Woo3G`000<0
07ooOol0?Goo00<007ooOol037oo000:Ool00`00Oomoo`1COol020007>M>VU:JCYUBVTjJDYX27>L0
1DIIAUY6FDIJ7>L00Thg00<LigI:7>L00WZ/00@Lig[aN_4Li`Ag50037>Mc5VlF009c5P077>M[5f/H
JaM_66/G7>L00VLI00QW66LIIaTLif;i001Z;Vh_0fX^00XLifh;LP]^2g8;KP]b2fh;LP/Li`=ai@04
KNDLifW07>LBOol00`00Oomoo`0mOol00`00Oomoo`0<Ool000Yoo`03001oogoo059oo`03001J^Dii
008Li`0mDYY>NE:JCWUBVT8i7>M6>DIJ@SU6FQcWCSMbBAcWNZ`LigZ/7>Mfl7[a7>Mg57<DMaAc4acW
KaIc5VlFLaHLiflHJaM_66/GKaPLif/IIaQ[6FLHJaUW61cW001^;fX^KRmZ;Vh_JRhLifh:LR]^2W8[
KPYb:fh:LR/00QcW00=]iG7VKND00QcW4Woo00<007ooOol0?Goo00<007ooOol037oo000:Ool00`00
Oomoo`1BOol03000F[UJ^EZiDYXLie:JCYUBVTjJDYY>V@8Li`06AUY6FDIJ7>M>=gI:0QcW0WZ/00<L
ig[a7>L017LD00dLig<FLaIc5VlF7>M[5flHJaM[66/G7>MW6003IaT016LHIaT006h_0fX^00A^;fX^
JRiZ;P8Li`09LP]^2g8;KP]b2fh;LP]]iAcW009ai@03KNDLig`0015oo`03001oogoo03eoo`03001o
ogoo00aoo`002Woo00<007ooOol0DGoo00<005JiF[X00UZi04MF^EZj7>LLidiiDYY>NE:JCWU6FQcW
AUY2>DIJ7>M>=acWNZ`LigZ/7>MjlGK`7>Mc4gLDLa@LiflFLaI_5W<F7>M_66/GKaQ[5flHJaLLifLH
JaUW66/IIaP006X^KRmZ;Vh_JRi^;fX^KRmZ;Vh_7>Mb:fh:LR]^2W8[KPYb:fh:7>M]iG7VKNDLig`0
011oo`03001oogoo03ioo`03001oogoo00]oo`002Goo00<007ooOol0DWoo00<001cWF[T01UZi0QcW
00EBVTjJDYY>VDIJ008Li`04AUU6FQcWCSL27>L01GZ/7>MjlG[a7>L00gLD00<Lig<FKaH00W<F00XL
if/GJaQ[5flHJaM[61cWIaUW609W6@05001V<AcWJRi^;`03JRh03Vh_JRiZ;VX^KRlLig8;KP]b2fh;
LP]^2g8;KP/27>L00g7UKNEl000@Ool00`00Oomoo`0nOol00`00Oomoo`0;Ool000Uoo`03001oogoo
059oo`05001J^AcW7>MJ^P02F[T03UJiF[YJ^E:J7>MBVTiiDYY>NE:JASTLid8iAUX27>L07GZ/7>Mj
[1cWM_0Lig<DMaAc4acWKaIc5VlFLaHLiflHJaM_66/GKaQ[5acWIaQ[6FLHJaT006IAIS000QcW00U^
;fX^KRmZ;Vh_JRi^;fX^KRl00QcW00]^2W8[KPYb:fh:LR]^2W7V7>MaiW`0011oo`03001oogoo03io
o`03001oogoo00]oo`002Goo00<007ooOol0DGoo00D005kHH]QRf5Zi008Li`IJ^@8Li`08CYYBVTjI
DYY6FAcWAUU6FP<Li`04NZ`Lig[a7>L3Ma@03AcWLaIc5W<FKaHLif/GKaQ[5f/HJaM_61cW00=W6@03
001V<FHa00=V<@037>M^;fX^009Z;P0BKRmZ;VX^JRi^;fX^7>M^2g8;KP]b2fh;LP]^2g7U7>MaiG`0
3goo00<007ooOol0?Woo00<007ooOol02goo0009Ool00`00Oomoo`1AOol02000H]UNf6;IG]QJ^EJi
7>L2F[T02eJiF[YJ^EZiE[TLidiiDYY>NE:JCWT00QcW00=6FQcWO0000QcW01afl1cWLa=g57<D7>M_
5W<FKaIc5VlF7>M[5flHJaM_66/GKaPLif/IO00006H`JU5V<6IAIS1ZD@8Li`09JRi^;fX^KRmZ;Vh_
JRi^;fX^008Li`09LR]^2W8[KPYb:fh:LR/Lig`000ioo`80041oo`03001oogoo00]oo`002Goo00<0
07ooOol0DGoo00@006;HH]UNf09Rf004H]UJ^AcW7>L6F[T27>L03E:JCYUBVTjJAUXLig`0Ooml07Z/
7>MjlAcW00=g50037>M_5W<F009c5P0:7>M[66/GKaQ[5f/HO00Lig`00009IS427>L2JRh01Fh_JRiZ
;VX^KRl00VX^0QcW00M^2g8;KP]b2fh;LP]l000;Ool30002Ool00`00Oomoo`0mOol00`00Oomoo`0;
Ool000Uoo`03001oogoo055oo`0>000LiekHH]UNf6;IG]QRfEkHF[XLieZiE[UJ^P9J^@09E[UJ^QcW
DYY>NE:JCWUBVQcW009oo`9l000<N_4LigLDLa=g51cWLaI_5W<FKaHLif/G17`00goo01L001cWIS1V
DFH`JU5V<6IAIS1ZDFH`IU4Lifh_JRi^;fX^KRmZ;Vh_JRi^;fX^008Li`05LR]^2W8[KPYl0007Ool4
0006Ool00`00Oomoo`0lOol00`00Oomoo`0;Ool000Uoo`03001oogoo055oo`06001Vn1cWH]QRfEkH
0V;H00=RfEkHF[T00QcW1UZi0QcW00=>VE:JO0001Goo0g`00WLD00<Lig<FLaH00W`000<Lig`0Ool0
1Goo00@0068cIS4Li`YV<@8Li`03JRi^;fX^009Z;P0:KRmZ;VX^JRi^;acWLP]^2g8;O004Ool3000:
Ool00`00Oomoo`0lOol00`00Oomoo`0;Ool000Qoo`03001oogoo055oo`04001VmfKhI_L27>L026;I
G]QRfEkHH]UNf6;IF[T27>L025ZjF[UJ^EJiF[YJ^AcWO009Ool2O0000acWO01l0009Ool01@00HS=R
<V8cIS000QcW01EVDFH`JU5V<6IAIS1ZDFH`IU5V<1cWJRi^;fX^KRmZ;Vh_JRi^;fX^KRl00QcW00=^
2W8[O0000`003Woo00<007ooOol0?7oo00<007ooOol02Woo0008Ool00`00Oomoo`1AOol00`00I_QV
n003I_P00acWH]UNf002H]P00f;IG]QRf002F[T00acWF[UJ^@04F[T00g`0Oomoo`0DOol02@00HS=R
<V8cHS9R<f8bIS4Li`0:IS427>L01Fh_JRiZ;VX^KRl00fX^00=^;fX^00000P004Woo00<007ooOol0
>goo00<007ooOol02Woo0008Ool00`00Oomoo`1AOol04`007>MZn6KgI_QVmf[h7>MRfEkHH]UNf6;I
G]QRfEkHF[TLieZj009J^@03E[Ul07oo01Eoo`0F7>MR<f8bHS=N<V8cHS9R<ehbJU4LifIAIS1ZDFH`
IU5V<6YAIS1VDFH`KRl27>L01FX^KRmZ;Vh_JRh00`0000=Z;Vh_O0004goo00<007ooOol0>Woo00<0
07ooOol02Woo0008Ool00`00Oomoo`1@Ool01000J_MVn1cW1FKh0QcW00ENf6;HH]QRfEkH009Rf003
H]TLiacW009J^@03O01oogoo01=oo`0=001N=1cWHS=R<V8cHS9R<f8bHS=R<VHa7>L02fHa00=Z;QcW
00000`000fX^00=^;fX^O00057oo00<007ooOol0>Goo00<007ooOol02Woo0008Ool00`00Oomoo`1@
Ool05`00KaMZmfKh7>MZn6KgI_QVmf[hI_LLiekHH]UNf6;IG]QRfEkHH]UF^AcWO00057oo0P0001MN
=5XdGS@Lif8cHS9R<ehbHS=R<V8cGS9R<acWIU5V<6YAIS1VDFH`JU5V<6IA00<000097>MZ;Vh_JRi^
;fX^KRmZ;W`001Ioo`03001oogoo03Qoo`03001oogoo00Yoo`0027oo00<007ooOol0Cgoo00L006lG
J_M[5f[gI_PLi`06I_P01QcWG]QRf6;HH]UNf09Rf003H]UNf7`001=oo`04001N=5hdFS@3GS@02QcW
HS=R<V8cHS9R<f8bHS=R<V8c0QcW16Ha0`0016Ha0QcW0VX^00A^;fX^JRil01Ioo`03001oogoo03Qo
o`03001oogoo00Yoo`001goo00<007ooOol0D7oo00<006[g00002`000QcW00MRfEkHH]UNf6;IG]Ql
000BOol2000055XcGSAJ=5hdFS=N=5XdGS@Lif8cHS9R<ehbHS=R<V8cGS9R<fH`7>L300003fIAIS1Z
DFH`IU5V<6YAIS1^;acWKRmZ;Vh_JRil000GOol00`00Oomoo`0gOol00`00Oomoo`0:Ool000Moo`03
001oogoo04aoo`H0009@`0057>L0M@1e07D0M00207D00acW6GPMN@0700000f;HO01oo`0?Ool20002
ESD00acWFSAN=002GS@035XdGSAN=5hd7>MR<f8bHS=R<V8cHS9R<`<000037>MV<FHa00YV<@057>MZ
;VX^KRml000HOol00`00Oomoo`0gOol00`00Oomoo`09Ool000Moo`03001oogoo04Uoo`<0000IID1Q
@6E0C<1@`4c0D<1<`1cW07@0U@1d09D0M02E7>LMNAUh7GTIN1ei7>LinCGH>OT04P00015F=EXeESEJ
=AcWGSAJ<ehdFSAN=5XcGSAJ=5hd7>MR<f8b00@0000AHS=N<V8cHS8LifH`JU5V<6IAIS1ZDFH`IU5V
<6YAIS1VD@027>L00g`0Oomoo`0HOol00`00Oomoo`0fOol00`00Oomoo`09Ool000Moo`03001oogoo
04Yoo`EU@0I@`0037>L0M01e0080M@0@07@LiaUi7GTIN1ei6GTLicGH>OPef3Wi=MPin1cWAQP3AQL0
2DHHCSHLidhfDSI>=U8fCSHLi`06ESD00acWGSAJ=003GS@00eXdGSAN=00300002F8bHS=R<V8cHS9R
<f8bHS=R<P027>L<IS400g`0Oomoo`0IOol00`00Oomoo`0eOol00`00Oomoo`09Ool000Moo`03001o
ogoo04]oo`0gHD1U@650ID1Q@530C<1@`4c0D<0Li`2E07@0U@1d09D0M1cW6GPMNAUh7GTIN1cW=MPi
nCGH>OTef1cWAQM:64HGBQQ65dXH7>MB=dhFDSM>5U8gCQHLieHeFSEF=EXeESEJ=AcWGSAJ<ehdFS@0
0`0001YJ=5hd7>MR<f8bHS=N<V8cHS9R<ehbHS=R<VIA7>MZDFH`IU5V<6YAIS1VDFH`JU5V<7`077oo
00<007ooOol0=Goo00<007ooOol02Goo0007Ool00`00Oomoo`1<Ool5ID05D<000acW07D0M00307D0
41cW7GTINAei6GPMNAcW>OTef3Wh=MPinCGH7>M65dHH0dHG00PLidhfDSI>=U8fCSIB=QcW1UHe00<L
iehd00000P000Uhd015J=5hdGSAN=1cWHS=R<V8cHS9R<f8bHS=R<V8cHS9V<AcW00UV<@03O01oogoo
01]oo`03001oogoo03Aoo`03001oogoo00Uoo`001goo00<007ooOol0<Woo2@0047oo034007LeHD1U
@650ID1Q@530C<1@`4c07>L0M02E07@0U@1d7>LIN1ei6GPMNAUh7>Lef3Wi=MPinCGH>OTLidXHAQM:
64HGBQPLie8gCQIB=dhFDSM>5U8g7>MJ=EHeFSEF=@0300007eXdGSAJ<ehdFSAN=5XcGSAJ=5hd7>MR
<f8bHS=N<V8cHS9R<ehbHS=R<V8c7>MZDFH`IU5V<6YAIS1VDG`001moo`03001oogoo03=oo`03001o
ogoo00Uoo`001Woo00<007ooOol0<Goo0P0000T=fc8J<QXb6QUH6GPIF1Uh018010002Woo0P0000<L
igLeMcD016E01E3001<Li`1e07D0M01e7>LMNAUh7GTINAei7>Lin3GH>OTef3Wh=MPLi`03AQL02dHH
AQMB=QcWDSI>=U8fCSIB=Thf7>L010000eHe00@LiehdGSAJ=0=N=00AFSAN=5hdHS<Lif8cHS9R<f8b
HS=R<V8cHS9R<f8bHS<Li`05IS400g`0Oomoo`0OOol00`00Oomoo`0bOol00`00Oomoo`09Ool000Io
o`03001oogoo02moo`80000<IYDLiacW3M/Ao38J<Q/EF1Ui6EPIN@0A0P0B00=M`00000000P0017oo
0P000W/c02Yg<QcWLaEg=F50ID1Q@6E0C<1@`4c0D<0Li`2E07@0U@1d09DLiaei6GPMNAUh7>Lef3Wi
=MPinCGH>OTLidXHAQM:64HGBQQ65acWCQIB=dhFDSL300007eXeESEJ=EHeFSEF=EXe7>MN=5XdGSAJ
<ehdFSAN=5XcGSAJ=1cWGS9R<f8bHS=N<V8cHS9R<ehbHS=R<V8c008Li`03IS1VDG`002=oo`03001o
ogoo035oo`03001oogoo00Uoo`001Woo00<007ooOol0;goo00P001cW7>MVUF9e7>L=f`gl0S8J00<I
F1Uh6EP00`0B00EIX5W0FJ0Lig[800@00003Oc0Lig/c009k<`047>Mg=GLeMcD4ID04D<0051cW07D0
M@1e07@LiaUi7GTIN1ei7>LinCGH>OPef3Wi=MPLidHGAQP3AQL00dHH7>MB=P030000158fCSIB=QcW
1eHe00DLiehdGSAN=5Xd00=N=00DFSAN=5hd7>MR<V8cHS9R<f8bHS=R<V8cHS9R<f8bHS=R<QcWIS5l
02=oo`03001oogoo039oo`03001oogoo00Qoo`001Woo00<007ooOol0;goo00<006JeJ[H00QcW01MR
M1cW7>LAo38J<Q/001cW6EP04P0A019IX5g0FJ0Lig[8N/TLigl`N`lLigLb009k<`0S7>Mc57LeLaEg
=F50ID1Q@6E0C<1@`4c07>L0M02E07@0UAcW7GTIN1ei6GPMNAcW>OTef3Wi=MPinAcWBQQ65dXHAQM:
60030000:E8gCQIB=dhFDSM>5QcWESEJ=EHeFSEF=EXeESEJ=AcWGSAJ=5hdFS=N=5XdGSAJ<ehdFS@L
iehbHS=R<V8cGS9R<f8bHS=N<V8cHS9R<ehbO0009Goo00<007ooOol0<Goo00<007ooOol027oo0006
Ool00`00Oomoo`0_Ool02000I[IV]FJfI[DLif9eIYD27>L01@00>]hb6QcW6EP00P0B00AI`5VPFL0L
i`9jb0057>Mo;gl_OblLi`02Nc<00acWMcEg=@02McD011cWID1U@6E0153001<Li`1d07D0MAcW6GPM
NAUi7GTIN1cW=MPinCGH>OPef3Wi7>M65`0300002dHGCSHLidhfDSI>=U8fCSIB=Thf7>L01eHe00<L
ieXdGS@00Uhd00EJ=5hdGSAN=5Xd009N=00=7>MR<V8cHS9R<f8bHS=R<V8cHS9R<f8bO0009goo00<0
07ooOol0<7oo00<007ooOol027oo0006Ool00`00Oomoo`0_Ool01P007>LLifJeJ[IV]@8Li`0bIYD0
01cW=]hjgcKN7>LIF00B015M`5VP7>Mjb7[9N/PLig/?Oc0Lig/cMc9k<acWMcEc57LeLaDLiflFID1Q
@530C<1@`1cW09D0M02E07@LiaUh7GTIN1ei7>LinCGH>OTef0@0000]BQQ65dXHAQM:61cWDSM>5U8g
CQIB=dhFDSLLieXeESEJ=EHeFSEF=EXeESDLieXcGSAJ=5hdFS=N=5XdGSAJ<ehdFS@LiehbHS=R<V8c
GS9R<f8bHS=N<W`002Uoo`03001oogoo02moo`03001oogoo00Qoo`001Goo00<007ooOol0<Goo00X0
06[E7>LLifJfI[EV]P00I[LLi`8fgP09>]hfgQcW7>L04UVPFL0Lig[9009jb0047>Mo<7l_7>L3Nc<0
0acWMcEg=@02McD00acWLaI_5P02ID03D<002acW07D0M01e7>LMNAUh7GTINAcW=MP00`0000@ef3Wh
7>M660=65`0;AQQ65acWCSIB=ThfDSI>=U8fCSHLi`09ESD00acWFSAN=002GS@01EXdGSAN=5hdFS@0
0Uhd00TLif8bHS=R<V8cHS9R<f8bO000:goo00<007ooOol0;Woo00<007ooOol027oo0005Ool00`00
Oomoo`0aOol02P00K]EZe6kE7>MZ]VJe001R]VJg0QcW00lfgS[O=]hINAcW019IX5g07>MjbG[87>Mk
3gl`7>L00g/c01DLigLeLaEg=G<D7>M_5W<FKaIU@4c0D<1<`1cW07@0U@1d7>LIN1ei6GP00`00038e
f3Wi=MPinCGH7>M65dXHAQM:64HGBQPLie8gCQIB=dhFDSM>5U8gCQHLieHeFSEF=EXeESEJ=EHeFSDL
iehdFS=N=5XdGSAJ<ehdFSAN=5XcGSAJ=1cWGS9R<f8bHS=N<W`0;Goo00<007ooOol0;Goo00<007oo
Ool027oo0005Ool00`00Oomoo`0aOol01@007>LLif[EK]D00QcW00D006JgI[MV]f:f008Li`0:>]hf
gSKN7>MI`5VP7>Mjb7[97>L2Obl00acWNc=k<`02Nc<00acWMcEg=@02McD01AcWLaIc5VlFID000e30
00@Li`1e07DLi`<000096GPMNAcW>OTef3Wh=MPinAcW00965`0>AQQ65dHGAQM661cWDSI>=U8fCSIB
=ThfDSHLi`UF=@037>MN=5Xd00=N=005FSAN=5hdGSAJ=002GS@01AcWHS9R<f8bO000;Woo00<007oo
Ool0;Goo00<007ooOol027oo0005Ool00`00Oomoo`0bOol01`00J]@Lif[DK]EZe000008Li`08H[IV
]f:fI[LLic[O=]hjg`<Li`08N/Ujb1cWN`mo<1cWNc=g<P9k<`0>7>Mc57LeLaEg=AcWLaM_5W<FKaIU
@4c0D<0Li`<0000f7>LMNAUh7GTIN1cW=MPinCGH>OTef1cWAQM:64HGBQQ65dXHAQLLidhFDSM>5U8g
CQIB=dhFDSLLieXeESEJ=EHeFSEF=EXeESEJ=AcWGSAJ<ehdFSAN=5XcGSAJ=5hdFS=N=5Xd7>MN<W`0
<7oo00<007ooOol0;Goo00<007ooOol01goo0005Ool00`00Oomoo`0bOol02@00L]=bdacWJ]E^e@00
HYINUP027>L00fJgH[IV]`027>L2=]h01UVP7>Mjb7[87>Mo<09o;`057>Mk<g/cNc<Li`05McD011cW
LaIc5W<F1000010Li`1e07DLiaUh7GTINAei7>Lin3GH>OTef3Wh=MPLi`=65`0=AQQ65dHG7>MB=Thf
DSI>=U8fCSIB=Thf7>L02EHe00@LiehdGSAJ=0=N=005FSAN=5hdGSAJ=002GS@00g`0Oomoo`0`Ool0
0`00Oomoo`0/Ool00`00Oomoo`07Ool000Eoo`03001oogoo039oo`047>L007;dL]<27>L01@007>LL
iejFHYL00QcW00=R]VJgH[H00QcW00TjgcKN7>Mjb7[97>Mo<7/?7>L00W/c00Qg<QcWLaEg=G<DMcEc
5AcW0`0003]c5W`0D<1<`1cW07@0UAcW7GTIN1ei6GPLicGH>OTef3Wi=MPinAcWBQQ65dXHAQM:64HG
7>M>5U8gCQIB=dhFDSM>5U8gCQHLieHeFSEF=EXeESEJ=EHeFSEF=AcWFSAN=5XcGSAJ=5hdFS=N=5Xd
GSAJ<g`003Aoo`03001oogoo02]oo`03001oogoo00Moo`001Goo00<007ooOol0<goo00T001cWL]=b
dfkE001JMeIG7>L00ejF0QcW0fJg00<LicKN=]h00acW00=o;gl`7>L017/c00<LigLeMcD00`0000@L
iflFLaIl009oo`0CD<0Li`1e07@LiaUi7GTIN1ei7>LinCGH>OPef3Wi=MPLidHGAQP00dHG00a664HG
7>M>=U8fCSIB=ThfDSI>=U8f7>L:ESD011cWGSAN=5Xd0ehd00AJ=5hdO01l03Ioo`03001oogoo02Yo
o`03001oogoo00Moo`0017oo00<007ooOol0=Goo00P001cWL_Abd`00EUIJMeIF0QcW00=RUejFHYL0
0QcW00]R]VJg7>LLicKN>]lLigl`N`lLigLb00=k<`<00007McEc57Le7>Mc5VlFO0000goo03A@`1cW
09D0M1cW6GPMNAUh7>Lef3Wi=MPinCGH>OTLidXHAQM:64HGBQQ65dXH7>MB=dhFDSM>5U8gCQIB=dhF
7>MF=EXeESEJ=EHeFSEF=EXeESEJ=AcWGSAJ=5hdFS=N=5XdGSAl03Qoo`03001oogoo02Yoo`03001o
ogoo00Moo`0017oo00<007ooOol0=Goo00/007[a7>Mbd`00FWMFEUYgEUMJMacW009NUP03HYINUQcW
009V]`07H[HLiacW>]hLigl_7>L0100000<LigLeMcD017Le00<Lig`0Ool017oo00lLi`1e07DLiaei
6GTMNAUh7>Lef3Wi=MPin3GH7>L00dHG00m664HGAQM65acWCSIB=ThfDSI>=U8fCSIB=Thf7>L02UHe
00LLiehdGSAN=5XdGSAl000jOol00`00Oomoo`0YOol00`00Oomoo`07Ool000Aoo`03001oogoo03Eo
o`0@7>L001cWL]<001cWFWMFEUYgEUIJMacWHYMNUV:GGYH27>L016JgH[IV]acW0`0000<Lig/cMc80
0W/c00LLig<DMcEc5GLeLaAl0006Ool0;dc07>L0M1cW6GPMNAUh7GTLicWi=MPinCGH>OTLidXHAQM:
64HGBQQ65dXHAQLLidhFDSM>5U8gCQIB=dhFDSLLieXeESEJ=EHeFSEF=EXeESEJ=EHeFSDLiehdFS@0
0W`0?7oo00<007ooOol0:7oo00<007ooOol01goo0004Ool00`00Oomoo`0fOol01@00M_4Lig;C0000
0QcW00AFEUYgEUMJM`8Li`05GYIRUUjFGYHLi`03000016Jg7>LfgQcW17/c00<LigLeMcD00WLe00=l
07ooOol01Woo011l001e7>LMNAUh7GTINAcW=MPin3GH>OTef3Wh7>M660=65`0>AQQ65dHG7>MB=Thf
DSI>=U8fCSIB=ThfDSHLi`YF=@037>MJ=7`003moo`03001oogoo02Qoo`03001oogoo00Ioo`0017oo
00<007ooOol0=Woo00lLi`00M_4Li`00DSM>=acWEUIJMeIFFWMFEQcWGYH00`0000ENUQcW7>MV]f:f
00<Li`9k<`06Mc8Lig<EMcEc57`02Woo02al002E7>LMNAUh7GTLicWi=MPinCGH>OTef1cWAQM:64HG
BQQ65dXHAQLLidhFDSM>5U8gCQIB=dhFDSM>5QcWESEJ=EHeFSEF=EXeESEJ=EHeFSEF=G`0@Goo00<0
07ooOol09goo00<007ooOol01Woo0004Ool00`00Oomoo`0fOol01Wk^001jlGKa000Li`9>=`047>MF
EUYgEUL300000acWHYINUP02GYH00f:F7>LLi`02I[L37>L01G/c7>Mg=GLeO00037oo00el01cW6GTM
NAUh7>Lef3Wi=MPin3GH>OTLi`02AQL044HHAQM65dHGAQPLie8fCSIB=ThfDSI>=U8fCSIB=QcW2EHe
0W`0@Woo00<007ooOol09goo00<007ooOol01Woo0003Ool00`00Oomoo`0hOol01`00M_5jlP00@OLL
ie8g00@0000;EUIJMeIFFWLLif:GGYIRUejFHYMNUP027>L01fJgH[HLiacWNc<Lig`000ioo`0U7>LM
NAUh7GTLicWi=MPinCGH>OTef1cWAQM:64HGBQQ65dXHAQM:61cWDSM>5U8gCQIB=dhFDSM>5U8g7>MJ
=EHeFSEF=EXeESD00W`0AGoo00<007ooOol09Woo00<007ooOol01Woo0003Ool00`00Oomoo`0hOol0
0gZW001fl@040002CSL27>L01EYgEUMJMeIFFWL00QcW0ejF00=RUUjFI[L00QcW00AR]W`0Nc=l011o
o`9l000:6GTMNAcW>OPef3Wi=MPin1cWAQP3AQL03dHHAQM65dHG7>M>=U8fCSIB=ThfDSI>=U8fCSHL
i`04ESD2O018Ool00`00Oomoo`0UOol00`00Oomoo`06Ool000=oo`03001oogoo03Uoo`<000057>Lm
eacWCSIB=`02CSL041cWFWMFEUYgEUIJMeIF7>MNUV:GGYIRUejFHYMR]QcW0W`04Woo01l007`0O00L
icGH>OTef3Wi=MPLidHGBQQ65dXHAQM:64HGBQPLie8gCQIB=dhFDSM>5U8gCQIB=dhF7>MF=@02O01;
Ool00`00Oomoo`0TOol00`00Oomoo`06Ool000=oo`03001oogoo03Ioo`<00007HP0000007>M1md7G
7>L014hg00PLieYgEUMJMeIFFWMFEacW0ejF00ERUUjFGYINUW`0019oo`0>001oogooOolLig`0=MPi
n3GH>OTef1cWAQM660=65`0;AQQ65acWCSIB=ThfDSI>=U8fCSIB=P04O01>Ool00`00Oomoo`0SOol0
0`00Oomoo`06Ool000=oo`03001oogoo03=oo`<000=oo`0:GN0001cW;GLLid7g?MLLidhfDSL2CSL0
1acWFWMFEUYgEUIJMeIF008Li`06HYMNUV:GGYIRUg`04Woo00<007ooOol00goo17`000dinAcWBQQ6
5dXHAQM:64HGBQQ65acWCQIB=`05O01COol00`00Oomoo`0ROol00`00Oomoo`06Ool000=oo`03001o
ogoo02moo`@000Ioo`03NZPLi`RD008Li`04?MM1md7G7>L4CSL02AcWFWMFEeYgEUIJMeIGFWLLi`02
GYH00f:FO01oo`0BOol00`00Oomoo`07Ool00g`07>Ml0007O0000acWO01l001HOol00`00Oomoo`0S
Ool00`00Oomoo`05Ool0009oo`03001oogoo02eoo`<000]oo`0;7>L4TacW:GHLicgF@OLLidhgCSIB
=`02CSL27>L01UIFFWMFEUYgEUIJM`8Li`03GYIl07oo019oo`03001oogoo06eoo`03001oogoo029o
o`03001oogoo00Eoo`000Woo00<007ooOol0:Woo0`003Woo00UMh1cW7>LYMQcW@OLmed7g7>L01Thg
00XLieIGFWMFEUYgEUMJMeIF7>Ml01=oo`03001oogoo06ioo`03001oogoo025oo`03001oogoo00Eo
o`000Woo00<007ooOol09goo0`004Goo00eR01cW2;@Libeg7>M1mcgF@OLLidhgCSIB=`02CSL02Dhf
7>MFEUYgEUIJMeIFFWMl000DOol00`00Oomoo`1_Ool00`00Oomoo`0POol00`00Oomoo`05Ool0009o
o`03001oogoo02Aoo`<001Aoo`04NZLLi`RD7>L2:GH01AcW@OLmed7g7>L01Thg00LLieIGFWMFEUYg
EUMl000DOol00`00Oomoo`1`Ool00`00Oomoo`0OOol00`00Oomoo`05Ool0009oo`03001oogoo021o
o`@001Qoo`0>7>L8]0BC7>LYMQcW?MM1mcgF@OLLidhgCSIB=`9>=`06CSHLiacWFWMFEW`05Goo00<0
07ooOol0L7oo00<007ooOol07goo00<007ooOol01Goo0002Ool00`00Oomoo`0MOol3000LOol03680
7>L8U1cW;GHYMQcW@MM1mcgG@OLLi`M>=`037>MJMg`001Eoo`03001oogoo075oo`03001oogoo01io
o`03001oogoo00Eoo`000Woo00<007ooOol06Woo0`007goo00aMh1cW19<LibUf;GLLid7g?MM1mcgF
7>L2CSL01dhfDSM>=dhgCSIB=acW01Ioo`03001oogoo079oo`03001oogoo01ioo`03001oogoo00Ao
o`0000=oo`00Ool06Goo0`008Woo00eR01cW29@4TacW:GH]MQcW@OM1ed7g?MLLi`07CSL00g`0Oomo
o`0DOol00`00Oomoo`1cOol00`00Oomoo`0MOol00`00Oomoo`04Ool00003Ool007oo01Ioo`<002Eo
o`0>MZLLi`BC2;@Libeg:GHLicgF@OLmed7g?MHLi`9>=`04CSIB=dhgO00GOol00`00Oomoo`1dOol0
0`00Oomoo`0LOol00`00Oomoo`04Ool00003Ool007oo019oo`@002Uoo`8Li`0329@LibUf008YMP07
7>Lmed7g@MM1mcgG7>L014hg00=l07ooOol05Goo00<007ooOol0M7oo00<007ooOol077oo00<007oo
Ool017oo00000goo001oo`0?Ool3000]Ool03f807>L8]0BC7>LYMReg7>M1mcgF@OLmed7g?MHLi`02
CSL00g`0Oomoo`0FOol00`00Oomoo`1eOol00`00Oomoo`0KOol00`00Oomoo`04Ool00003Ool007oo
00aoo`<0031oo`06GN0Li`BC29@Libef0RUf00LLid7g?MM1md7G@OLLi`02CSL00g`0Oomoo`0FOol0
0`00Oomoo`1fOol00`00Oomoo`0JOol00`00Oomoo`04Ool00003Ool007oo00Uoo`<003=oo`0AHP0L
i`Rd19<LibUf;GLYMReg7>M1mcgF@OLmed7g7>Ml000IOol00`00Oomoo`1gOol00`00Oomoo`0IOol0
0`00Oomoo`04Ool00003001oogoo00Ioo`<003Moo`0@7>L8U0RD19<LibUf;GHYMQcW@MM1mcgG@OM1
ed7gO00IOol00`00Oomoo`1hOol00`00Oomoo`0HOol00`00Oomoo`04Ool00003001oogoo009oo`@0
03Yoo`8Li`0=19<8]1cW;GLYMReg:GHLicgG@OLmeT7gO0006Woo00<007ooOol0NGoo00<007ooOol0
67oo00<007ooOol00goo00000`00Ool00002000nOol27>L229@02QcW:GHYMRUf;GHLid7g@MM1mg`0
6goo00<007ooOol0NGoo00<007ooOol067oo00<007ooOol00goo00020011Ool03UgP7>L4T`Rd19<L
ibUf;GLYMReg7>M1mcgGO00KOol00`00Oomoo`1jOol00`00Oomoo`0GOol00`00Oomoo`03Ool00003
Ool00000045oo`067>L8U0BC29@Libef0bUf00<LicgGO00077oo00<007ooOol0Ngoo00<007ooOol0
5Woo00<007ooOol00goo0003Ool00`00Oomoo`0nOol27>L02@Rd19<8]1cW;GLYMReg:GIl000MOol0
0`00Oomoo`1lOol00`00Oomoo`0EOol00`00Oomoo`03Ool000Aoo`03001oogoo03eoo`8Li`88U006
19<LibUf;GHYMW`07Woo00<007ooOol0OGoo00<007ooOol057oo00<007ooOol00goo0005Ool2000m
Ool27>L01`Rd19<8]1cW;GLYMW`001moo`03001oogoo07eoo`03001oogoo01Aoo`03001oogoo00=o
o`001goo00<007ooOol0>goo00<Li`BC29@00PRD00<Lig`0Ool07goo00<007ooOol0OWoo00<007oo
Ool057oo00<007ooOol00Woo0008Ool2000kOol27>L010BC2;@4Tg`08Goo00<007ooOol0Ogoo00<0
07ooOol04goo00<007ooOol00Woo000:Ool00`00Oomoo`0hOol00g`07>L8U002O00ROol00`00Oomo
o`20Ool00`00Oomoo`0BOol00`00Oomoo`02Ool000]oo`8003Uoo`9l02=oo`03001oogoo089oo`03
001oogoo015oo`03001oogoo009oo`003Goo00<007ooOol0Fgoo00<007ooOol0PWoo00<007ooOol0
4Goo00<007ooOol00Woo000>Ool00`00Oomoo`1JOol00`00Oomoo`23Ool00`00Oomoo`0@Ool00`00
Oomoo`02Ool000moo`8005Yoo`03001oogoo08Aoo`03001oogoo00moo`03001oogoo009oo`004Goo
00<007ooOol0Egoo00<007ooOol0QGoo00<007ooOol03Woo00<007ooOol00Woo000BOol2001GOol0
0`00Oomoo`26Ool00`00Oomoo`0>Ool00`00Oomoo`01Ool001Aoo`03001oogoo05Aoo`03001oogoo
08Moo`03001oogoo00eoo`03001oogoo005oo`005Goo00<007ooOol0Dgoo00<007ooOol0Qgoo00<0
07ooOol03Goo00<007ooOol00Goo000FOol2001COol00`00Oomoo`28Ool00`00Oomoo`0<Ool00`00
Oomoo`01Ool001Qoo`03001oogoo051oo`03001oogoo08Uoo`03001oogoo00]oo`03001oogoo005o
o`006Goo0P00D7oo00<007ooOol0RWoo00<007ooOol02Woo00<007ooOol00Goo000KOol00`00Oomo
o`1=Ool00`00Oomoo`2;Ool00`00Oomoo`09Ool00`00Oomoo`01Ool001aoo`8004eoo`03001oogoo
08]oo`03001oogoo00Yoo`40005oo`5oo`007Woo00<007ooOol0BWoo00<007ooOol0S7oo00<007oo
Ool02Goo0@000Goo0Goo000OOol00`00Oomoo`19Ool00`00Oomoo`2=Ool00`00Oomoo`08Ool10001
Ool1Ool0021oo`8004Uoo`03001oogoo08ioo`03001oogoo00Moo`40005oo`5oo`008Woo00<007oo
Ool0AWoo00<007ooOol0Sgoo00<007ooOol01Woo0@000Goo0Goo000SOol20016Ool00`00Oomoo`2?
Ool00`00Oomoo`06Ool10001Ool1Ool002Eoo`03001oogoo04=oo`03001oogoo091oo`03001oogoo
00Eoo`40005oo`5oo`009Woo0P00@goo00<007ooOol0TGoo00<007ooOol01Goo0@000Goo000XOol0
0`00Oomoo`10Ool00`00Oomoo`2BOol00`00Oomoo`04Ool10001Ool002Uoo`03001oogoo03moo`03
001oogoo09=oo`03001oogoo00=oo`40005oo`00:Woo0P00?goo00<007ooOol0U7oo00<007ooOol0
0Woo0@000Goo000/Ool00`00Oomoo`0lOol00`00Oomoo`2DOol00`00Oomoo`02Ool10001Ool002eo
o`8003aoo`03001oogoo09Eoo`05001oogooOol00001Ool002moo`03001oogoo03Uoo`03001oogoo
09Ioo`04001oogoo0001Ool0031oo`03001oogoo03Qoo`03001oogoo09Moo`03001oo`00005oo`00
<Goo0P00=goo00<007ooOol0VGoo0@000Goo0@00000cOol00`00Oomoo`0dOol00`00Oomoo`2IOol1
0001Ool1000003Aoo`8003Aoo`03001oogoo09Yoo`800000=Woo00<007ooOol0<Goo00<007ooOol0
VGoo0`00000gOol2000aOol00`00Oomoo`2EOol40003Ool003Uoo`03001oogoo02ioo`03001oogoo
091oo`D000Moo`00>Woo00<007ooOol0;Goo00<007ooOol0S7oo100037oo000kOol2000]Ool00`00
Oomoo`28Ool4000@Ool003eoo`03001oogoo02Yoo`03001oogoo08=oo`D001Aoo`00?Woo0P00:Woo
00<007ooOol0Ogoo10006Goo0010Ool00`00Oomoo`0WOol00`00Oomoo`1jOol5000MOol0045oo`03
001oogoo02Ioo`03001oogoo07Ioo`@0029oo`00@Woo0P009Woo00<007ooOol0LWoo10009Woo0014
Ool00`00Oomoo`0SOol00`00Oomoo`1]Ool5000ZOol004Eoo`8002=oo`03001oogoo06Uoo`@002mo
o`00Agoo00<007ooOol087oo00<007ooOol0I7oo1@00<goo0018Ool2000POol00`00Oomoo`1POol4
000hOol004Yoo`03001oogoo01eoo`03001oogoo05]oo`D003aoo`00Bgoo00<007ooOol077oo00<0
07ooOol0Egoo1000@Goo001<Ool2000LOol00`00Oomoo`1COol40015Ool004ioo`03001oogoo01Uo
o`03001oogoo04ioo`D004Uoo`00Cgoo0P006Goo00<007ooOol0BWoo1000CWoo001AOol00`00Oomo
o`0FOol00`00Oomoo`15Ool5001BOol0059oo`8001Ioo`03001oogoo045oo`@005Moo`00E7oo00<0
07ooOol04goo00<007ooOol0?Goo1000Fgoo001EOol00`00Oomoo`0BOol00`00Oomoo`0hOol5001O
Ool005Ioo`80015oo`03001oogoo03Eoo`@006Aoo`00F7oo00<007ooOol03Woo00<007ooOol0<7oo
1@00J7oo001IOol2000>Ool00`00Oomoo`0/Ool4001]Ool005]oo`03001oogoo00]oo`03001oogoo
02Moo`D0075oo`00G7oo00<007ooOol02Woo00<007ooOol08goo1000MWoo001MOol2000:Ool00`00
Oomoo`0OOol4001jOol005moo`03001oogoo00Moo`03001oogoo01Yoo`D007ioo`00H7oo0P001goo
00<007ooOol05Woo1000Pgoo001ROol00`00Oomoo`04Ool00`00Oomoo`0AOol50027Ool006=oo`80
00Aoo`03001oogoo00eoo`@008aoo`00IGoo00D007ooOomoo`0000]oo`@0091oo`00IWoo00@007oo
Ool000Ioo`D009Aoo`00Igoo0`000Woo1000VGoo001YOol3002MOol00001
\>"],
  ImageRangeCache->{{{0, 264.313}, {287, 0}} -> {0.0486402, -0.000148683, 
  0.00324458, 0.00324458}}]
}, Open]]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[%, ViewPoint \[Rule] {2, 1, 1.7}]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07132 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.044277 1.15958 -3.33067e-016 1.15958 [
[ 0 0 0 0 ]
[ 1 1.07132 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.42151 .58385 m
.39881 1.07132 L
s
.39881 1.07132 m
1 .9491 L
s
1 .9491 m
.91454 .43136 L
s
.91454 .43136 m
.42151 .58385 L
s
.11048 .24185 m
.69676 0 L
s
.69676 0 m
.74624 .57229 L
s
.74624 .57229 m
0 .7895 L
s
0 .7895 m
.11048 .24185 L
s
.42151 .58385 m
.39881 1.07132 L
s
.39881 1.07132 m
0 .7895 L
s
0 .7895 m
.11048 .24185 L
s
.11048 .24185 m
.42151 .58385 L
s
.91454 .43136 m
.69676 0 L
s
.69676 0 m
.74624 .57229 L
s
.74624 .57229 m
1 .9491 L
s
1 .9491 m
.91454 .43136 L
s
0 0 m
1 0 L
1 1.07132 L
0 1.07132 L
closepath
clip
newpath
.69391 .51989 m .7474 .51712 L .69399 .5377 L .262 .674 .967 r
F
.69391 .51989 m .7391 .5144 L .7474 .51712 L F
.6961 .50221 m .7391 .5144 L .69391 .51989 L .079 .428 .871 r
F
.69399 .5377 m .76122 .52317 L .69619 .55498 L .485 .687 .957 r
F
.69399 .5377 m .7474 .51712 L .76122 .52317 L F
0 g
.006 w
.69391 .51989 m
.69399 .5377 L
s
.25 g
.5 Mabswid
.69399 .5377 m
.69474 .53741 L
s
.69391 .51989 m
.73568 .51481 L
s
.6961 .50221 m .73799 .51274 L .7391 .5144 L .079 .428 .871 r
F
.25 g
.73568 .51481 m
.7391 .5144 L
s
.70068 .48533 m .73799 .51274 L .6961 .50221 L .464 .178 .394 r
F
0 g
.006 w
.69391 .51989 m
.6961 .50221 L
s
.69619 .55498 m .77798 .53456 L .70024 .57149 L .561 .63 .877 r
F
.69619 .55498 m .76122 .52317 L .77798 .53456 L F
.25 g
.5 Mabswid
.73861 .5205 m
.7474 .51712 L
s
0 g
.006 w
.69399 .5377 m
.69619 .55498 L
s
.25 g
.5 Mabswid
.69619 .55498 m
.69812 .55404 L
s
.70024 .57149 m .79442 .55259 L .70543 .58755 L .592 .581 .81 r
F
.70024 .57149 m .77798 .53456 L .79442 .55259 L F
.25 g
.74555 .53084 m
.76122 .52317 L
s
0 g
.006 w
.69619 .55498 m
.70024 .57149 L
s
.25 g
.5 Mabswid
.70024 .57149 m
.70236 .57049 L
s
.70236 .57049 m
.70244 .57044 L
s
.73221 .52297 m
.73861 .5205 L
s
.69474 .53741 m
.73221 .52297 L
s
.70068 .48533 m .74466 .50984 L .73799 .51274 L .464 .178 .394 r
F
.70764 .46955 m .74466 .50984 L .70068 .48533 L .551 .291 .475 r
F
.25 g
.6961 .50221 m
.70012 .50322 L
s
0 g
.006 w
.6961 .50221 m
.70068 .48533 L
s
.70543 .58755 m .80699 .57756 L .71037 .60385 L .609 .545 .758 r
F
.70543 .58755 m .79442 .55259 L .80699 .57756 L F
0 g
.70024 .57149 m
.70543 .58755 L
s
.25 g
.5 Mabswid
.70543 .58755 m
.70797 .58655 L
s
.75333 .54627 m
.77798 .53456 L
s
.70244 .57044 m
.75333 .54627 L
s
.73667 .53518 m
.74555 .53084 L
s
.69812 .55404 m
.73667 .53518 L
s
.70764 .46955 m .75864 .50345 L .74466 .50984 L .551 .291 .475 r
F
.71657 .45457 m .75864 .50345 L .70764 .46955 L .589 .377 .561 r
F
.25 g
.70068 .48533 m
.70248 .48634 L
s
0 g
.006 w
.70068 .48533 m
.70764 .46955 L
s
.71037 .60385 m .81247 .60852 L .71323 .62102 L .622 .519 .716 r
F
.71037 .60385 m .80699 .57756 L .81247 .60852 L F
0 g
.70543 .58755 m
.71037 .60385 L
s
.25 g
.5 Mabswid
.71037 .60385 m
.80699 .57756 L
s
.75739 .56713 m
.79442 .55259 L
s
.70797 .58655 m
.75739 .56713 L
s
.60205 .74709 m .63167 .75597 L .58452 .76181 L .231 0 0 r
F
.60205 .74709 m .64286 .75761 L .63167 .75597 L F
.62113 .73314 m .64286 .75761 L .60205 .74709 L .539 .019 0 r
F
.71323 .62102 m .80863 .64318 L .71216 .6391 L .632 .497 .68 r
F
.71323 .62102 m .81247 .60852 L .80863 .64318 L F
0 g
.006 w
.71037 .60385 m
.71323 .62102 L
s
.25 g
.5 Mabswid
.71323 .62102 m
.81247 .60852 L
s
.58452 .76181 m .62673 .75686 L .56916 .77681 L 0 0 0 r
F
.58452 .76181 m .63167 .75597 L .62673 .75686 L F
0 g
.006 w
.58452 .76181 m
.60205 .74709 L
s
.25 g
.5 Mabswid
.58452 .76181 m
.58704 .76149 L
s
.62113 .73314 m .66073 .7593 L .64286 .75761 L .539 .019 0 r
F
.64104 .71977 m .66073 .7593 L .62113 .73314 L .626 .223 .26 r
F
0 g
.006 w
.60205 .74709 m
.62113 .73314 L
s
.25 g
.5 Mabswid
.60289 .7473 m
.63272 .75499 L
s
.60205 .74709 m
.60289 .7473 L
s
.63148 .75599 m
.63167 .75597 L
s
.71657 .45457 m .77824 .49153 L .75864 .50345 L .589 .377 .561 r
F
.25 g
.75387 .50028 m
.75864 .50345 L
s
.7438 .50936 m
.74466 .50984 L
s
.70012 .50322 m
.73799 .51274 L
s
.72638 .43972 m .77824 .49153 L .71657 .45457 L .611 .441 .627 r
F
.25 g
.70764 .46955 m
.70825 .46995 L
s
0 g
.006 w
.70764 .46955 m
.71657 .45457 L
s
.64104 .71977 m .68482 .75794 L .66073 .7593 L .626 .223 .26 r
F
.25 g
.5 Mabswid
.63272 .75499 m
.64077 .75707 L
s
.66083 .70621 m .68482 .75794 L .64104 .71977 L .647 .324 .411 r
F
.25 g
.64077 .75707 m
.64286 .75761 L
s
.62113 .73314 m
.64921 .75168 L
s
.64921 .75168 m
.66073 .7593 L
s
0 g
.006 w
.62113 .73314 m
.64104 .71977 L
s
.56916 .77681 m .62681 .76207 L .55655 .79126 L .417 .358 .685 r
F
.56916 .77681 m .62673 .75686 L .62681 .76207 L F
0 g
.56916 .77681 m
.58452 .76181 L
s
.25 g
.5 Mabswid
.58704 .76149 m
.63148 .75599 L
s
.71216 .6391 m .79482 .67818 L .70603 .6575 L .639 .476 .646 r
F
.71216 .6391 m .80863 .64318 L .79482 .67818 L F
0 g
.006 w
.71216 .6391 m
.71323 .62102 L
s
.25 g
.5 Mabswid
.71216 .6391 m
.80863 .64318 L
s
.66083 .70621 m .71351 .75035 L .68482 .75794 L .647 .324 .411 r
F
.67924 .69154 m .71351 .75035 L .66083 .70621 L .65 .382 .5 r
F
0 g
.006 w
.64104 .71977 m
.66083 .70621 L
s
.70603 .6575 m .77228 .70969 L .69477 .67524 L .645 .452 .608 r
F
.70603 .6575 m .79482 .67818 L .77228 .70969 L F
0 g
.70603 .6575 m
.71216 .6391 L
s
.67924 .69154 m .74391 .73436 L .71351 .75035 L .65 .382 .5 r
F
.25 g
.5 Mabswid
.67689 .75102 m
.68482 .75794 L
s
.64104 .71977 m
.67689 .75102 L
s
.69477 .67524 m .74391 .73436 L .67924 .69154 L .649 .422 .561 r
F
0 g
.006 w
.66083 .70621 m
.67924 .69154 L
s
.25 g
.5 Mabswid
.66083 .70621 m
.68099 .72311 L
s
.67924 .69154 m
.68076 .69255 L
s
.70603 .6575 m
.71066 .65857 L
s
.69477 .67524 m .77228 .70969 L .74391 .73436 L .649 .422 .561 r
F
.25 g
.69793 .67664 m
.77228 .70969 L
s
.69477 .67524 m
.69793 .67664 L
s
0 g
.006 w
.67924 .69154 m
.69477 .67524 L
s
.25 g
.5 Mabswid
.71066 .65857 m
.79482 .67818 L
s
0 g
.006 w
.69477 .67524 m
.70603 .6575 L
s
.25 g
.5 Mabswid
.68076 .69255 m
.7132 .71403 L
s
.7132 .71403 m
.74391 .73436 L
s
.69831 .73762 m
.71351 .75035 L
s
.68099 .72311 m
.69831 .73762 L
s
.55655 .79126 m .63002 .77278 L .5471 .80452 L .505 .429 .704 r
F
.55655 .79126 m .62681 .76207 L .63002 .77278 L F
.25 g
.62666 .75689 m
.62673 .75686 L
s
.56916 .77681 m
.57832 .77363 L
s
0 g
.006 w
.55655 .79126 m
.56916 .77681 L
s
.72638 .43972 m .80059 .47267 L .77824 .49153 L .611 .441 .627 r
F
.25 g
.5 Mabswid
.77443 .48925 m
.77824 .49153 L
s
.74114 .50788 m
.7438 .50936 L
s
.70248 .48634 m
.74114 .50788 L
s
.73544 .42443 m .80059 .47267 L .72638 .43972 L .625 .492 .68 r
F
0 g
.006 w
.71657 .45457 m
.72638 .43972 L
s
.5471 .80452 m .63391 .78954 L .54078 .81646 L .546 .422 .662 r
F
.5471 .80452 m .63002 .77278 L .63391 .78954 L F
.25 g
.5 Mabswid
.61931 .76519 m
.62681 .76207 L
s
0 g
.006 w
.5471 .80452 m
.55655 .79126 L
s
.25 g
.5 Mabswid
.5471 .80452 m
.54895 .80381 L
s
.62835 .77342 m
.63002 .77278 L
s
.6214 .75871 m
.62666 .75689 L
s
.57832 .77363 m
.6214 .75871 L
s
.73544 .42443 m .82189 .4468 L .80059 .47267 L .625 .492 .68 r
F
.25 g
.77036 .48681 m
.77443 .48925 L
s
.71657 .45457 m
.77036 .48681 L
s
.74965 .49747 m
.75387 .50028 L
s
.70825 .46995 m
.74965 .49747 L
s
.74179 .40861 m .82189 .4468 L .73544 .42443 L .635 .537 .726 r
F
0 g
.006 w
.72638 .43972 m
.73544 .42443 L
s
.25 g
.5 Mabswid
.73544 .42443 m
.73634 .42466 L
s
1 0 0 r
.003 w
.80699 .57756 m
.81247 .60852 L
s
.79442 .55259 m
.80699 .57756 L
s
.80863 .64318 m
.81247 .60852 L
s
.77798 .53456 m
.79442 .55259 L
s
.79482 .67818 m
.80863 .64318 L
s
.76122 .52317 m
.77798 .53456 L
s
.7474 .51712 m
.76122 .52317 L
s
.77228 .70969 m
.79482 .67818 L
s
.54078 .81646 m .63577 .81204 L .53688 .82757 L .574 .405 .615 r
F
.54078 .81646 m .63391 .78954 L .63577 .81204 L F
0 g
.006 w
.54078 .81646 m
.5471 .80452 L
s
.25 g
.5 Mabswid
.54078 .81646 m
.54251 .81596 L
s
.54251 .81596 m
.54365 .81563 L
s
.61433 .77879 m
.62835 .77342 L
s
.54895 .80381 m
.61433 .77879 L
s
.61171 .76834 m
.61931 .76519 L
s
.55655 .79126 m
.61171 .76834 L
s
.74179 .40861 m .83806 .41563 L .82189 .4468 L .635 .537 .726 r
F
.25 g
.73634 .42466 m
.82189 .4468 L
s
.78499 .46574 m
.80059 .47267 L
s
.72638 .43972 m
.78499 .46574 L
s
.74371 .39279 m .83806 .41563 L .74179 .40861 L .643 .579 .768 r
F
0 g
.006 w
.73544 .42443 m
.74179 .40861 L
s
1 0 0 r
.003 w
.7391 .5144 m
.7474 .51712 L
s
.73799 .51274 m
.7391 .5144 L
s
.74391 .73436 m
.77228 .70969 L
s
.73799 .51274 m
.74466 .50984 L
s
.74466 .50984 m
.75864 .50345 L
s
.74371 .39279 m .84558 .38246 L .83806 .41563 L .643 .579 .768 r
F
.25 g
.5 Mabswid
.74179 .40861 m
.83806 .41563 L
s
.74017 .37785 m .84558 .38246 L .74371 .39279 L .648 .62 .808 r
F
0 g
.006 w
.74179 .40861 m
.74371 .39279 L
s
1 0 0 r
.003 w
.75864 .50345 m
.77824 .49153 L
s
.77824 .49153 m
.80059 .47267 L
s
.71351 .75035 m
.74391 .73436 L
s
.80059 .47267 m
.82189 .4468 L
s
.53688 .82757 m .63298 .83896 L .5339 .83858 L .597 .389 .57 r
F
.53688 .82757 m .63577 .81204 L .63298 .83896 L F
0 g
.006 w
.53688 .82757 m
.54078 .81646 L
s
.25 g
.5 Mabswid
.53688 .82757 m
.53941 .82717 L
s
.53941 .82717 m
.63577 .81204 L
s
.60939 .79663 m
.63391 .78954 L
s
.54365 .81563 m
.60939 .79663 L
s
.74017 .37785 m .84237 .3513 L .84558 .38246 L .648 .62 .808 r
F
.25 g
.74371 .39279 m
.84558 .38246 L
s
.73115 .36453 m .84237 .3513 L .74017 .37785 L .65 .663 .849 r
F
0 g
.006 w
.74017 .37785 m
.74371 .39279 L
s
1 0 0 r
.003 w
.82189 .4468 m
.83806 .41563 L
s
.68482 .75794 m
.71351 .75035 L
s
.73115 .36453 m .82819 .32579 L .84237 .3513 L .65 .663 .849 r
F
.71766 .35302 m .82819 .32579 L .73115 .36453 L .647 .711 .894 r
F
0 g
.006 w
.73115 .36453 m
.74017 .37785 L
s
1 0 0 r
.003 w
.83806 .41563 m
.84558 .38246 L
s
.71766 .35302 m .80481 .30831 L .82819 .32579 L .647 .711 .894 r
F
.70137 .34285 m .80481 .30831 L .71766 .35302 L .633 .772 .947 r
F
.25 g
.5 Mabswid
.74017 .37785 m
.84237 .3513 L
s
0 g
.006 w
.71766 .35302 m
.73115 .36453 L
s
.25 g
.5 Mabswid
.72189 .35085 m
.73573 .34375 L
s
.71766 .35302 m
.72189 .35085 L
s
1 0 0 r
.003 w
.66073 .7593 m
.68482 .75794 L
s
.5339 .83858 m .62342 .86799 L .52982 .84993 L .62 .377 .528 r
F
.5339 .83858 m .63298 .83896 L .62342 .86799 L F
0 g
.006 w
.5339 .83858 m
.53688 .82757 L
s
.25 g
.5 Mabswid
.5339 .83858 m
.63298 .83896 L
s
.70137 .34285 m .77556 .29954 L .80481 .30831 L .633 .772 .947 r
F
.68398 .33322 m .77556 .29954 L .70137 .34285 L .583 .845 .994 r
F
0 g
.006 w
.70137 .34285 m
.71766 .35302 L
s
.25 g
.5 Mabswid
.70137 .34285 m
.71557 .33456 L
s
.68398 .33322 m .74457 .29853 L .77556 .29954 L .583 .845 .994 r
F
.66674 .32352 m .74457 .29853 L .68398 .33322 L .393 .845 .913 r
F
.25 g
.73115 .36453 m
.73321 .36371 L
s
.73321 .36371 m
.82819 .32579 L
s
0 g
.006 w
.68398 .33322 m
.70137 .34285 L
s
.25 g
.5 Mabswid
.68398 .33322 m
.69548 .32664 L
s
1 0 0 r
.003 w
.62681 .76207 m
.63002 .77278 L
s
.62673 .75686 m
.62677 .75935 L
s
.62677 .75935 m
.62681 .76207 L
s
.6313 .75604 m
.63167 .75597 L
s
.62673 .75686 m
.6313 .75604 L
s
.66674 .32352 m .71585 .30315 L .74457 .29853 L .393 .845 .913 r
F
.25 g
.5 Mabswid
.72146 .31176 m
.74457 .29853 L
s
.73699 .32206 m
.77556 .29954 L
s
.73573 .34375 m
.80481 .30831 L
s
.65038 .31368 m .71585 .30315 L .66674 .32352 L .042 0 0 r
F
.25 g
.71557 .33456 m
.73699 .32206 L
s
.69548 .32664 m
.70941 .31866 L
s
0 g
.006 w
.66674 .32352 m
.68398 .33322 L
s
.25 g
.5 Mabswid
.66674 .32352 m
.66766 .32313 L
s
1 0 0 r
.003 w
.64286 .75761 m
.66073 .7593 L
s
.63002 .77278 m
.63391 .78954 L
s
.63167 .75597 m
.64286 .75761 L
s
.65117 .31355 m .69261 .31058 L .71585 .30315 L .042 0 0 r
F
.65152 .3136 m .69261 .31058 L .65117 .31355 L F
.65038 .31368 m .65152 .3136 L .65117 .31355 L F
.6354 .30423 m .69261 .31058 L .65038 .31368 L .354 0 .102 r
F
.6354 .30423 m .67686 .31789 L .69261 .31058 L F
.62238 .29586 m .6727 .31621 L .6354 .30423 L .497 .164 .332 r
F
.6727 .31621 m .67686 .31789 L .67119 .31602 L F
.6727 .31621 m .67119 .31602 L .6354 .30423 L F
.25 g
.5 Mabswid
.65038 .31368 m
.65152 .3136 L
s
0 g
.006 w
.65038 .31368 m
.66674 .32352 L
s
.25 g
.5 Mabswid
.66766 .32313 m
.66789 .32304 L
s
.66789 .32304 m
.6682 .32291 L
s
.69393 .31224 m
.70147 .30911 L
s
.70147 .30911 m
.71585 .30315 L
s
.70941 .31866 m
.72146 .31176 L
s
0 g
.006 w
.6354 .30423 m
.65038 .31368 L
s
1 0 0 r
.003 w
.84237 .3513 m
.84558 .38246 L
s
.63391 .78954 m
.63577 .81204 L
s
.52982 .84993 m .60604 .89586 L .5227 .86138 L .643 .368 .487 r
F
.52982 .84993 m .62342 .86799 L .60604 .89586 L F
0 g
.006 w
.52982 .84993 m
.5339 .83858 L
s
1 0 0 r
.003 w
.63298 .83896 m
.63577 .81204 L
s
.62238 .29586 m .66931 .32254 L .67686 .31789 L .497 .164 .332 r
F
.25 g
.5 Mabswid
.6354 .30423 m
.63944 .30556 L
s
.6682 .32291 m
.66922 .32249 L
s
.66974 .32227 m
.69393 .31224 L
s
.65152 .3136 m
.65335 .31346 L
s
.61206 .28904 m .66931 .32254 L .62238 .29586 L 0 .238 .661 r
F
0 g
.006 w
.62238 .29586 m
.6354 .30423 L
s
1 0 0 r
.003 w
.82819 .32579 m
.84237 .3513 L
s
.62342 .86799 m
.63298 .83896 L
s
.5227 .86138 m .5813 .91878 L .51136 .87199 L .667 .359 .441 r
F
.25 g
.5 Mabswid
.52982 .84993 m
.53405 .85075 L
s
.5227 .86138 m .60604 .89586 L .5813 .91878 L .667 .359 .441 r
F
.25 g
.56033 .85582 m
.62342 .86799 L
s
.53405 .85075 m
.56033 .85582 L
s
0 g
.006 w
.5227 .86138 m
.52982 .84993 L
s
.61206 .28904 m .66951 .32255 L .66931 .32254 L 0 .238 .661 r
F
.60501 .28367 m .66951 .32255 L .61206 .28904 L .519 .451 .72 r
F
0 g
.61206 .28904 m
.62238 .29586 L
s
1 0 0 r
.003 w
.80481 .30831 m
.82819 .32579 L
s
.51136 .87199 m .55142 .93326 L .49569 .88064 L .692 .344 .383 r
F
.25 g
.5 Mabswid
.5227 .86138 m
.52721 .86324 L
s
.51136 .87199 m .5813 .91878 L .55142 .93326 L .692 .344 .383 r
F
0 g
.006 w
.51136 .87199 m
.5227 .86138 L
s
1 0 0 r
.003 w
.60604 .89586 m
.62342 .86799 L
s
.60501 .28367 m .67599 .31665 L .66951 .32255 L .519 .451 .72 r
F
.25 g
.5 Mabswid
.66739 .32145 m
.66931 .32254 L
s
.60121 .27915 m .67599 .31665 L .60501 .28367 L .569 .52 .76 r
F
.25 g
.62238 .29586 m
.62867 .29944 L
s
.61206 .28904 m
.61611 .2914 L
s
0 g
.006 w
.60501 .28367 m
.61206 .28904 L
s
1 0 0 r
.003 w
.77556 .29954 m
.80481 .30831 L
s
.49569 .88064 m .51988 .93717 L .47645 .88661 L .716 .318 .293 r
F
.25 g
.5 Mabswid
.51136 .87199 m
.51522 .87457 L
s
.49569 .88064 m .55142 .93326 L .51988 .93717 L .716 .318 .293 r
F
0 g
.006 w
.49569 .88064 m
.51136 .87199 L
s
.25 g
.5 Mabswid
.49569 .88064 m
.50225 .88683 L
s
.52721 .86324 m
.60604 .89586 L
s
1 0 0 r
.003 w
.74457 .29853 m
.77556 .29954 L
s
.47645 .88661 m .49044 .9307 L .45479 .89 L .733 .264 .134 r
F
.47645 .88661 m .51988 .93717 L .49044 .9307 L F
0 g
.006 w
.47645 .88661 m
.49569 .88064 L
s
.25 g
.5 Mabswid
.47645 .88661 m
.47841 .88889 L
s
.50225 .88683 m
.55142 .93326 L
s
.51522 .87457 m
.5813 .91878 L
s
1 0 0 r
.003 w
.5813 .91878 m
.60604 .89586 L
s
.60121 .27915 m .68626 .3043 L .67599 .31665 L .569 .52 .76 r
F
.25 g
.5 Mabswid
.66509 .31159 m
.67599 .31665 L
s
.65635 .31488 m
.66951 .32255 L
s
.6573 .31571 m
.66739 .32145 L
s
.59962 .27479 m .68626 .3043 L .60121 .27915 L .6 .586 .809 r
F
.25 g
.62867 .29944 m
.6573 .31571 L
s
.61611 .2914 m
.65635 .31488 L
s
.60501 .28367 m
.60719 .28468 L
s
0 g
.006 w
.60121 .27915 m
.60501 .28367 L
s
.25 g
.5 Mabswid
.60121 .27915 m
.60505 .28029 L
s
.45479 .89 m .46588 .91656 L .43176 .89161 L .68 .133 0 r
F
.45479 .89 m .49044 .9307 L .46588 .91656 L F
0 g
.006 w
.45479 .89 m
.47645 .88661 L
s
.25 g
.5 Mabswid
.47841 .88889 m
.48773 .89974 L
s
.48773 .89974 m
.51988 .93717 L
s
1 0 0 r
.003 w
.71585 .30315 m
.74457 .29853 L
s
.43176 .89161 m .46588 .91656 L .4473 .89909 L 0 .129 .632 r
F
.43176 .89161 m .4473 .89909 L .40812 .89253 L F
0 g
.006 w
.43176 .89161 m
.45479 .89 L
s
.25 g
.5 Mabswid
.45479 .89 m
.49044 .9307 L
s
.40812 .89253 m .43425 .88276 L .38453 .89353 L .083 .319 .797 r
F
.40812 .89253 m .4473 .89909 L .43425 .88276 L F
.25 g
.44042 .89794 m
.46588 .91656 L
s
1 0 0 r
.003 w
.69261 .31058 m
.71585 .30315 L
s
.38453 .89353 m .42552 .87085 L .36184 .89469 L .318 .385 .774 r
F
.38453 .89353 m .43425 .88276 L .42552 .87085 L F
0 g
.006 w
.38453 .89353 m
.40812 .89253 L
s
.25 g
.5 Mabswid
.38453 .89353 m
.38472 .89349 L
s
.42994 .8837 m
.43425 .88276 L
s
1 0 0 r
.003 w
.67686 .31789 m
.69261 .31058 L
s
.36184 .89469 m .41976 .86505 L .34123 .89542 L .45 .442 .758 r
F
.36184 .89469 m .42552 .87085 L .41976 .86505 L F
0 g
.006 w
.36184 .89469 m
.38453 .89353 L
s
.25 g
.5 Mabswid
.36212 .89459 m
.36377 .89397 L
s
.36184 .89469 m
.36212 .89459 L
s
.42329 .87168 m
.42552 .87085 L
s
1 0 0 r
.003 w
.66998 .32212 m
.67686 .31789 L
s
.59962 .27479 m .69687 .28599 L .68626 .3043 L .6 .586 .809 r
F
.25 g
.5 Mabswid
.68521 .30399 m
.68626 .3043 L
s
.66321 .29748 m
.68521 .30399 L
s
.59837 .27032 m .69687 .28599 L .59962 .27479 L .626 .652 .856 r
F
.25 g
.60719 .28468 m
.66509 .31159 L
s
.60505 .28029 m
.66321 .29748 L
s
0 g
.006 w
.59962 .27479 m
.60121 .27915 L
s
1 0 0 r
.003 w
.66931 .32254 m
.66951 .32255 L
s
.55142 .93326 m
.5813 .91878 L
s
.66951 .32255 m
.67599 .31665 L
s
.34123 .89542 m .41566 .86574 L .32403 .89494 L .546 .879 .99 r
F
.34123 .89542 m .41976 .86505 L .41566 .86574 L F
.25 g
.5 Mabswid
.40812 .89253 m
.4473 .89909 L
s
.38472 .89349 m
.42994 .8837 L
s
.36377 .89397 m
.42329 .87168 L
s
0 g
.006 w
.34123 .89542 m
.36184 .89469 L
s
.25 g
.5 Mabswid
.34123 .89542 m
.34435 .89421 L
s
.34435 .89421 m
.34676 .89328 L
s
.34676 .89328 m
.41796 .86574 L
s
.41796 .86574 m
.41976 .86505 L
s
0 g
.006 w
.32403 .89494 m
.34123 .89542 L
s
1 0 0 r
.003 w
.67599 .31665 m
.68626 .3043 L
s
.25 g
.5 Mabswid
.32403 .89494 m
.32653 .89415 L
s
.32653 .89415 m
.33643 .89099 L
s
.33643 .89099 m
.41566 .86574 L
s
.59837 .27032 m .70381 .26374 L .69687 .28599 L .626 .652 .856 r
F
1 0 0 r
.003 w
.68626 .3043 m
.69687 .28599 L
s
.25 g
.5 Mabswid
.59962 .27479 m
.69687 .28599 L
s
.59523 .26618 m .70381 .26374 L .59837 .27032 L .647 .72 .901 r
F
0 g
.006 w
.59837 .27032 m
.59962 .27479 L
s
1 0 0 r
.003 w
.51988 .93717 m
.55142 .93326 L
s
.59523 .26618 m .70334 .2411 L .70381 .26374 L .647 .72 .901 r
F
.58828 .26336 m .70334 .2411 L .59523 .26618 L .664 .791 .942 r
F
.25 g
.5 Mabswid
.59837 .27032 m
.70381 .26374 L
s
0 g
.006 w
.59523 .26618 m
.59837 .27032 L
s
1 0 0 r
.003 w
.69687 .28599 m
.70381 .26374 L
s
.49044 .9307 m
.51988 .93717 L
s
.58828 .26336 m .69289 .22256 L .70334 .2411 L .664 .791 .942 r
F
1 0 0 r
.70334 .2411 m
.70381 .26374 L
s
.57644 .26288 m .69289 .22256 L .58828 .26336 L .671 .863 .972 r
F
0 g
.006 w
.58828 .26336 m
.59523 .26618 L
s
1 0 0 r
.003 w
.46588 .91656 m
.49044 .9307 L
s
.41566 .86574 m
.41976 .86505 L
s
.41976 .86505 m
.42552 .87085 L
s
.42552 .87085 m
.43425 .88276 L
s
.57644 .26288 m .67183 .21232 L .69289 .22256 L .671 .863 .972 r
F
.25 g
.5 Mabswid
.59523 .26618 m
.66057 .25102 L
s
.55963 .26524 m .67183 .21232 L .57644 .26288 L .655 .925 .974 r
F
.25 g
.66057 .25102 m
.70334 .2411 L
s
0 g
.006 w
.57644 .26288 m
.58828 .26336 L
s
.25 g
.5 Mabswid
.57644 .26288 m
.58106 .26043 L
s
.26305 .87513 m .36216 .84994 L .35748 .85519 L .38 0 .178 r
F
.26305 .87513 m .35032 .85671 L .25281 .86718 L F
.35032 .85671 m .34341 .8568 L .25281 .86718 L F
.35032 .85671 m .35748 .85519 L .34341 .8568 L F
.25281 .86718 m .35748 .85519 L .35121 .86379 L .469 .068 .196 r
F
.25281 .86718 m .3389 .86422 L .2477 .85797 L F
.3389 .86422 m .35121 .86379 L .32917 .86255 L F
.3389 .86422 m .32917 .86255 L .2477 .85797 L F
.24886 .85816 m .35121 .86379 L .34255 .87315 L .514 .057 .105 r
F
.25055 .85813 m .35121 .86379 L .24886 .85816 L F
.2477 .85797 m .25055 .85813 L .24886 .85816 L F
.2477 .85797 m .32603 .8705 L .24686 .84824 L F
.32603 .8705 m .34255 .87315 L .315 .86598 L F
.32603 .8705 m .315 .86598 L .24686 .84824 L F
.24811 .84872 m .34255 .87315 L .33115 .88012 L .55 .027 0 r
F
.24977 .849 m .34255 .87315 L .24811 .84872 L F
.24686 .84824 m .24977 .849 L .24811 .84872 L F
.24686 .84824 m .24926 .84915 L .24849 .83851 L F
.24926 .84915 m .31131 .87262 L .24991 .83922 L F
.31131 .87262 m .29996 .86442 L .24991 .83922 L F
.31131 .87262 m .33115 .88012 L .29996 .86442 L F
.24926 .84915 m .24991 .83922 L .24849 .83851 L F
.24927 .83899 m .33115 .88012 L .31725 .88136 L .573 0 0 r
F
.25027 .8394 m .33115 .88012 L .24927 .83899 L F
.24849 .83851 m .25027 .8394 L .24927 .83899 L F
.24849 .83851 m .31725 .88136 L .2505 .82868 L F
.25061 .82878 m .31725 .88136 L .3019 .87381 L .557 0 0 r
F
.2505 .82868 m .25075 .82888 L .25061 .82878 L F
.25075 .82888 m .31725 .88136 L .25061 .82878 L F
.2505 .82868 m .25061 .82878 L .2511 .81797 L F
.25061 .82878 m .3019 .87381 L .25131 .8182 L F
.25061 .82878 m .25131 .8182 L .2511 .81797 L F
.25 g
.34874 .85335 m
.36216 .84994 L
s
.33705 .85632 m
.34874 .85335 L
s
.32838 .85853 m
.33705 .85632 L
s
0 g
.006 w
.25281 .86718 m
.26305 .87513 L
s
1 0 0 r
.003 w
.4473 .89909 m
.46588 .91656 L
s
.69289 .22256 m
.70334 .2411 L
s
.43425 .88276 m
.4473 .89909 L
s
.55963 .26524 m .64159 .21298 L .67183 .21232 L .655 .925 .974 r
F
.25 g
.5 Mabswid
.58828 .26336 m
.61569 .25267 L
s
.53866 .27008 m .64159 .21298 L .55963 .26524 L .58 .942 .903 r
F
.25 g
.58106 .26043 m
.58767 .25693 L
s
0 g
.006 w
.55963 .26524 m
.57644 .26288 L
s
.25 g
.5 Mabswid
.55963 .26524 m
.5641 .26238 L
s
.34341 .8568 m
.35748 .85519 L
s
.33158 .85816 m
.34341 .8568 L
s
.31843 .85967 m
.33158 .85816 L
s
.30504 .8612 m
.31843 .85967 L
s
0 g
.006 w
.2477 .85797 m
.25281 .86718 L
s
.53866 .27008 m .60532 .2247 L .64159 .21298 L .58 .942 .903 r
F
.25 g
.5 Mabswid
.61569 .25267 m
.69289 .22256 L
s
.51484 .27641 m .60532 .2247 L .53866 .27008 L .386 .82 .665 r
F
0 g
.006 w
.53866 .27008 m
.55963 .26524 L
s
.51484 .27641 m .5672 .24531 L .60532 .2247 L .386 .82 .665 r
F
.25 g
.5 Mabswid
.58767 .25693 m
.67183 .21232 L
s
.4895 .28318 m .5672 .24531 L .51484 .27641 L 0 0 0 r
F
0 g
.006 w
.51484 .27641 m
.53866 .27008 L
s
1 0 0 r
.003 w
.67183 .21232 m
.69289 .22256 L
s
.4895 .28318 m .53139 .27107 L .5672 .24531 L 0 0 0 r
F
.25 g
.5 Mabswid
.55624 .25811 m
.60532 .2247 L
s
.53866 .27008 m
.55624 .25811 L
s
.5641 .26238 m
.64159 .21298 L
s
.46369 .2899 m .53139 .27107 L .4895 .28318 L .165 0 .133 r
F
.25 g
.51484 .27641 m
.51667 .27532 L
s
0 g
.006 w
.4895 .28318 m
.51484 .27641 L
s
.25 g
.5 Mabswid
.32917 .86255 m
.35121 .86379 L
s
.31576 .8618 m
.32917 .86255 L
s
.30155 .861 m
.31576 .8618 L
s
.29433 .8606 m
.30155 .861 L
s
0 g
.006 w
.24686 .84824 m
.2477 .85797 L
s
.46369 .2899 m .50124 .29783 L .53139 .27107 L .165 0 .133 r
F
.43823 .29688 m .50124 .29783 L .46369 .2899 L .32 .083 .39 r
F
.43823 .29688 m .47866 .32202 L .50124 .29783 L F
.414 .30499 m .47866 .32202 L .43823 .29688 L .412 .253 .554 r
F
.25 g
.5 Mabswid
.46463 .29009 m
.50124 .29783 L
s
.46369 .2899 m
.46463 .29009 L
s
0 g
.006 w
.43823 .29688 m
.46369 .2899 L
s
.414 .30499 m .46405 .34111 L .47866 .32202 L .412 .253 .554 r
F
.25 g
.5 Mabswid
.46786 .3153 m
.47866 .32202 L
s
.39214 .31501 m .46405 .34111 L .414 .30499 L .479 .377 .661 r
F
.25 g
.43823 .29688 m
.43946 .29764 L
s
0 g
.006 w
.414 .30499 m
.43823 .29688 L
s
1 0 0 r
.003 w
.35748 .85519 m
.36216 .84994 L
s
.39214 .31501 m .45659 .35385 L .46405 .34111 L .479 .377 .661 r
F
.37392 .32712 m .45659 .35385 L .39214 .31501 L .553 .455 .697 r
F
.25 g
.5 Mabswid
.43946 .29764 m
.46786 .3153 L
s
.414 .30499 m
.41511 .30579 L
s
0 g
.006 w
.39214 .31501 m
.414 .30499 L
s
.25 g
.5 Mabswid
.315 .86598 m
.34255 .87315 L
s
.30039 .86217 m
.315 .86598 L
s
.29027 .85954 m
.30039 .86217 L
s
0 g
.006 w
.24686 .84824 m
.24849 .83851 L
s
1 0 0 r
.003 w
.35121 .86379 m
.35748 .85519 L
s
.37392 .32712 m .45458 .36011 L .45659 .35385 L .553 .455 .697 r
F
.25 g
.5 Mabswid
.46304 .34038 m
.46405 .34111 L
s
.36034 .34074 m .45458 .36011 L .37392 .32712 L .246 0 0 r
F
.25 g
.41511 .30579 m
.45452 .33423 L
s
.45452 .33423 m
.46304 .34038 L
s
0 g
.006 w
.37392 .32712 m
.39214 .31501 L
s
1 0 0 r
.003 w
.64159 .21298 m
.67183 .21232 L
s
.34255 .87315 m
.35121 .86379 L
s
.25 g
.5 Mabswid
.28842 .85861 m
.29996 .86442 L
s
0 g
.006 w
.24849 .83851 m
.2505 .82868 L
s
.35152 .35491 m .45585 .36062 L .36034 .34074 L .434 .757 .995 r
F
.36457 .34161 m .45545 .36053 L .45458 .36011 L .246 0 0 r
F
.45545 .36053 m .45585 .36062 L .45575 .36058 L F
.45545 .36053 m .45575 .36058 L .45458 .36011 L F
.36554 .34183 m .45585 .36062 L .36457 .34161 L F
.455 .36057 m .45777 .35684 L .45585 .36062 L .434 .757 .995 r
F
.35152 .35491 m .45777 .35684 L .455 .36057 L F
.44179 .35856 m .45777 .35684 L .43182 .35637 L .496 .837 .997 r
F
.44179 .35856 m .45737 .35114 L .45777 .35684 L F
.34642 .3688 m .44179 .35856 L .35152 .35491 L F
.44179 .35856 m .43182 .35637 L .35152 .35491 L F
.34642 .3688 m .42553 .35621 L .44179 .35856 L F
.42553 .35621 m .45737 .35114 L .44179 .35856 L F
.36034 .34074 m .36554 .34183 L .36457 .34161 L .246 0 0 r
F
.25 g
.5 Mabswid
.36034 .34074 m
.36554 .34183 L
s
.36554 .34183 m
.43071 .35539 L
s
0 g
.006 w
.36034 .34074 m
.37392 .32712 L
s
.25 g
.5 Mabswid
.37392 .32712 m
.38075 .32991 L
s
.38075 .32991 m
.3869 .33243 L
s
.3869 .33243 m
.43959 .35397 L
s
.39214 .31501 m
.44277 .34553 L
s
0 g
.006 w
.35152 .35491 m
.36034 .34074 L
s
1 0 0 r
.003 w
.60532 .2247 m
.64159 .21298 L
s
.33115 .88012 m
.34255 .87315 L
s
.34309 .38234 m .43581 .35703 L .34642 .3688 L .506 .893 .957 r
F
.43581 .35703 m .44573 .353 L .34642 .3688 L F
.43581 .35703 m .45737 .35114 L .44573 .353 L F
.34309 .38234 m .45172 .34695 L .45737 .35114 L F
.33935 .39628 m .41779 .36185 L .34309 .38234 L .474 .895 .843 r
F
.41779 .36185 m .45172 .34695 L .43223 .3533 L F
.41779 .36185 m .43223 .3533 L .34309 .38234 L F
.34014 .39594 m .43885 .34851 L .45172 .34695 L F
.33935 .39628 m .3397 .39612 L .34014 .39594 L F
.3397 .39612 m .43885 .34851 L .34014 .39594 L F
.33355 .41174 m .3921 .37658 L .33935 .39628 L .4 .822 .648 r
F
.3921 .37658 m .43885 .34851 L .41017 .36228 L F
.3921 .37658 m .41017 .36228 L .33935 .39628 L F
.33799 .40908 m .41855 .3598 L .43885 .34851 L F
.33089 .42504 m .3927 .38297 L .41855 .3598 L 0 0 0 r
F
.32488 .42951 m .32758 .42766 L .33089 .42504 L F
.32758 .42766 m .3927 .38297 L .33089 .42504 L F
.33355 .41174 m .33554 .41053 L .33799 .40908 L .4 .822 .648 r
F
.33554 .41053 m .41855 .3598 L .33799 .40908 L F
.25 g
.5 Mabswid
.34642 .3688 m
.40828 .35895 L
s
.40828 .35895 m
.42118 .3569 L
s
0 g
.006 w
.34642 .3688 m
.35152 .35491 L
s
.25 g
.5 Mabswid
.35152 .35491 m
.35376 .35495 L
s
.35376 .35495 m
.42282 .35621 L
s
.44277 .34553 m
.44624 .34762 L
s
0 g
.006 w
.34309 .38234 m
.34642 .3688 L
s
1 0 0 r
.003 w
.45745 .35237 m
.46405 .34111 L
s
.2511 .81797 m .28705 .85545 L .24934 .80533 L 0 0 .514 r
F
.2511 .81797 m .3019 .87381 L .28705 .85545 L F
0 g
.006 w
.2505 .82868 m
.2511 .81797 L
s
.25 g
.5 Mabswid
.2511 .81797 m
.25131 .8182 L
s
.29169 .86119 m
.31725 .88136 L
s
.29996 .86442 m
.33115 .88012 L
s
1 0 0 r
.003 w
.5672 .24531 m
.60532 .2247 L
s
.45585 .36062 m
.45777 .35684 L
s
.46405 .34111 m
.47866 .32202 L
s
.31725 .88136 m
.33115 .88012 L
s
.25 g
.5 Mabswid
.34309 .38234 m
.40812 .36116 L
s
0 g
.006 w
.33935 .39628 m
.34309 .38234 L
s
1 0 0 r
.003 w
.47866 .32202 m
.50124 .29783 L
s
.45737 .35114 m
.45777 .35684 L
s
.53139 .27107 m
.5672 .24531 L
s
.24934 .80533 m .27529 .82623 L .24515 .7901 L 0 0 .541 r
F
.25 g
.5 Mabswid
.25131 .8182 m
.25355 .82067 L
s
.24934 .80533 m .28705 .85545 L .27529 .82623 L 0 0 .541 r
F
.25 g
.25355 .82067 m
.26159 .8295 L
s
.26159 .8295 m
.3019 .87381 L
s
0 g
.006 w
.24934 .80533 m
.2511 .81797 L
s
1 0 0 r
.003 w
.50124 .29783 m
.53139 .27107 L
s
.18439 .63544 m .2903 .62806 L .18784 .61339 L .586 .695 .917 r
F
.18439 .63544 m .29325 .63045 L .2903 .62806 L F
.18668 .65674 m .29325 .63045 L .18439 .63544 L .46 .117 .296 r
F
.18668 .65674 m .29463 .6339 L .29325 .63045 L F
.19348 .67679 m .29463 .6339 L .18668 .65674 L .303 0 .159 r
F
0 g
.006 w
.18439 .63544 m
.18668 .65674 L
s
.18784 .61339 m .28701 .62394 L .19712 .59151 L .343 .693 .982 r
F
.18784 .61339 m .2903 .62806 L .28701 .62394 L F
0 g
.18439 .63544 m
.18784 .61339 L
s
.19348 .67679 m .2934 .64117 L .29463 .6339 L .303 0 .159 r
F
.25 g
.5 Mabswid
.19505 .63495 m
.29325 .63045 L
s
.18439 .63544 m
.19505 .63495 L
s
.20288 .69584 m .2934 .64117 L .19348 .67679 L .224 0 .19 r
F
.25 g
.18668 .65674 m
.19117 .65579 L
s
0 g
.006 w
.18668 .65674 m
.19348 .67679 L
s
.25 g
.5 Mabswid
.33935 .39628 m
.3397 .39612 L
s
.19712 .59151 m .28475 .61535 L .21122 .57063 L .281 .571 .937 r
F
.19712 .59151 m .28701 .62394 L .28475 .61535 L F
.25 g
.28269 .62697 m
.2903 .62806 L
s
0 g
.006 w
.18784 .61339 m
.19712 .59151 L
s
.25 g
.5 Mabswid
.19712 .59151 m
.1984 .59197 L
s
.20288 .69584 m .28898 .65498 L .2934 .64117 L .224 0 .19 r
F
.25 g
.2841 .64448 m
.2934 .64117 L
s
.29255 .63434 m
.29463 .6339 L
s
.21304 .71462 m .28898 .65498 L .20288 .69584 L .16 0 .253 r
F
.25 g
.19348 .67679 m
.19468 .67637 L
s
0 g
.006 w
.19348 .67679 m
.20288 .69584 L
s
.24515 .7901 m .26896 .78871 L .23902 .77244 L 0 0 .513 r
F
.24515 .7901 m .27529 .82623 L .26896 .78871 L F
0 g
.24515 .7901 m
.24934 .80533 L
s
.25 g
.5 Mabswid
.24515 .7901 m
.27529 .82623 L
s
.24934 .80533 m
.28705 .85545 L
s
1 0 0 r
.003 w
.45172 .34695 m
.45737 .35114 L
s
.21304 .71462 m .2819 .67748 L .28898 .65498 L .16 0 .253 r
F
.25 g
.5 Mabswid
.28363 .65752 m
.28898 .65498 L
s
.19468 .67637 m
.2841 .64448 L
s
.19117 .65579 m
.28611 .6357 L
s
.28611 .6357 m
.29255 .63434 L
s
.22274 .73375 m .2819 .67748 L .21304 .71462 L .092 0 .323 r
F
0 g
.006 w
.20288 .69584 m
.21304 .71462 L
s
.21122 .57063 m .28507 .59983 L .22845 .55095 L .259 .435 .846 r
F
.21122 .57063 m .28475 .61535 L .28507 .59983 L F
.25 g
.5 Mabswid
.27244 .61868 m
.28701 .62394 L
s
0 g
.006 w
.19712 .59151 m
.21122 .57063 L
s
.25 g
.5 Mabswid
.21202 .57112 m
.21341 .57196 L
s
.21122 .57063 m
.21202 .57112 L
s
.18784 .61339 m
.27235 .62549 L
s
.27235 .62549 m
.28269 .62697 L
s
.23902 .77244 m .26897 .74775 L .23145 .75328 L 0 0 .459 r
F
.23902 .77244 m .26896 .78871 L .26897 .74775 L F
0 g
.006 w
.23902 .77244 m
.24515 .7901 L
s
.25 g
.5 Mabswid
.23902 .77244 m
.26896 .78871 L
s
1 0 0 r
.003 w
.3019 .87381 m
.31725 .88136 L
s
.22274 .73375 m .2742 .70912 L .2819 .67748 L .092 0 .323 r
F
.25 g
.5 Mabswid
.20288 .69584 m
.27791 .66024 L
s
.27791 .66024 m
.28363 .65752 L
s
.23145 .75328 m .2742 .70912 L .22274 .73375 L .011 0 .393 r
F
0 g
.006 w
.21304 .71462 m
.22274 .73375 L
s
.25 g
.5 Mabswid
.22274 .73375 m
.22326 .7335 L
s
.23145 .75328 m .26897 .74775 L .2742 .70912 L .011 0 .393 r
F
.25 g
.23145 .75328 m
.26897 .74775 L
s
0 g
.006 w
.22274 .73375 m
.23145 .75328 L
s
.23145 .75328 m
.23902 .77244 L
s
.25 g
.5 Mabswid
.22326 .7335 m
.2742 .70912 L
s
.21304 .71462 m
.26721 .6854 L
s
.26721 .6854 m
.2819 .67748 L
s
.22845 .55095 m .28958 .5757 L .24705 .53194 L .228 .295 .725 r
F
.22845 .55095 m .28507 .59983 L .28958 .5757 L F
.25 g
.26715 .60465 m
.28475 .61535 L
s
0 g
.006 w
.21122 .57063 m
.22845 .55095 L
s
.25 g
.5 Mabswid
.22999 .55228 m
.23005 .55233 L
s
.22845 .55095 m
.22999 .55228 L
s
.1984 .59197 m
.26177 .61483 L
s
.26177 .61483 m
.27244 .61868 L
s
.32488 .42951 m .41855 .3598 L .33355 .41174 L 0 0 0 r
F
.25 g
.33355 .41174 m
.33554 .41053 L
s
0 g
.006 w
.33355 .41174 m
.33935 .39628 L
s
.25 g
.5 Mabswid
.41017 .36228 m
.43885 .34851 L
s
.40812 .36116 m
.42178 .35671 L
s
.24705 .53194 m .29961 .54271 L .2656 .5126 L .176 .15 .588 r
F
.24705 .53194 m .28958 .5757 L .29961 .54271 L F
0 g
.006 w
.22845 .55095 m
.24705 .53194 L
s
.25 g
.5 Mabswid
.24705 .53194 m
.24825 .53317 L
s
.23005 .55233 m
.26708 .5843 L
s
.26708 .5843 m
.28507 .59983 L
s
.21341 .57196 m
.25713 .59855 L
s
.25713 .59855 m
.26715 .60465 L
s
.31331 .44953 m .3927 .38297 L .32488 .42951 L 0 0 0 r
F
.25 g
.32488 .42951 m
.32758 .42766 L
s
0 g
.006 w
.32488 .42951 m
.33355 .41174 L
s
1 0 0 r
.003 w
.43885 .34851 m
.45172 .34695 L
s
.2656 .5126 m .31586 .50251 L .28319 .49222 L .104 0 .434 r
F
.2656 .5126 m .29961 .54271 L .31586 .50251 L F
0 g
.006 w
.24705 .53194 m
.2656 .5126 L
s
.25 g
.5 Mabswid
.2656 .5126 m
.29961 .54271 L
s
.24825 .53317 m
.27173 .55733 L
s
.27173 .55733 m
.28958 .5757 L
s
1 0 0 r
.003 w
.2903 .62806 m
.29325 .63045 L
s
.29325 .63045 m
.29463 .6339 L
s
.28701 .62394 m
.2903 .62806 L
s
.31331 .44953 m .36465 .41725 L .3927 .38297 L 0 0 0 r
F
.25 g
.5 Mabswid
.33554 .41053 m
.37795 .38461 L
s
.37795 .38461 m
.41855 .3598 L
s
.3397 .39612 m
.37747 .37798 L
s
.37747 .37798 m
.41017 .36228 L
s
.29924 .47087 m .36465 .41725 L .31331 .44953 L 0 0 .063 r
F
0 g
.006 w
.31331 .44953 m
.32488 .42951 L
s
.28319 .49222 m .33807 .45891 L .29924 .47087 L .015 0 .26 r
F
.28319 .49222 m .31586 .50251 L .33807 .45891 L F
0 g
.2656 .5126 m
.28319 .49222 L
s
.25 g
.5 Mabswid
.28319 .49222 m
.31586 .50251 L
s
1 0 0 r
.003 w
.2934 .64117 m
.29463 .6339 L
s
.29924 .47087 m .33807 .45891 L .36465 .41725 L 0 0 .063 r
F
.25 g
.5 Mabswid
.29924 .47087 m
.33807 .45891 L
s
0 g
.006 w
.28319 .49222 m
.29924 .47087 L
s
.29924 .47087 m
.31331 .44953 L
s
.25 g
.5 Mabswid
.31331 .44953 m
.3159 .4479 L
s
.3159 .4479 m
.36465 .41725 L
s
.32758 .42766 m
.3927 .38297 L
s
1 0 0 r
.003 w
.28705 .85545 m
.3019 .87381 L
s
.28475 .61535 m
.28701 .62394 L
s
.28898 .65498 m
.2934 .64117 L
s
.41855 .3598 m
.43885 .34851 L
s
.28475 .61535 m
.28507 .59983 L
s
.2819 .67748 m
.28898 .65498 L
s
.27529 .82623 m
.28705 .85545 L
s
.28507 .59983 m
.28958 .5757 L
s
.2742 .70912 m
.2819 .67748 L
s
.3927 .38297 m
.41855 .3598 L
s
.26896 .78871 m
.27529 .82623 L
s
.26897 .74775 m
.2742 .70912 L
s
.28958 .5757 m
.29961 .54271 L
s
.26896 .78871 m
.26897 .74775 L
s
.36465 .41725 m
.3927 .38297 L
s
.29961 .54271 m
.31586 .50251 L
s
.33807 .45891 m
.36465 .41725 L
s
.31586 .50251 m
.33807 .45891 L
s
0 g
.25 Mabswid
.11048 .24185 m
.69676 0 L
s
.69676 0 m
.74624 .57229 L
s
.74624 .57229 m
0 .7895 L
s
0 .7895 m
.11048 .24185 L
s
.91454 .43136 m
.69676 0 L
s
.69676 0 m
.74624 .57229 L
s
.74624 .57229 m
1 .9491 L
s
1 .9491 m
.91454 .43136 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{268.813, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000181000`40O003h00Oogoo3Goo002iOol2
001AOol00;Moo`800003Ool00000051oo`00]7oo0`000goo0P00D7oo002bOol20006Ool00`00Ool0
001?Ool00:moo`<000Qoo`03001oo`0004moo`00[Goo0P002goo00@007ooOol004ioo`00Zgoo0P00
3Woo00<007oo0000CWoo002XOol3000@Ool01000Oomoo`00CGoo002VOol2000COol01000Oomoo`00
CGoo002SOol3000EOol01@00Oomoogoo0000C7oo002QOol2000HOol01@00Oomoogoo0000C7oo002N
Ool3000JOol00`00Oomoo`02Ool00`00Oomoo`19Ool009aoo`8001eoo`03001oogoo009oo`03001o
ogoo04Uoo`00VGoo0`007goo00<007ooOol00goo00<007ooOol0B7oo002GOol2000ROol00`00Oomo
o`03Ool00`00Oomoo`18Ool009Aoo`<002Aoo`03001oogoo00Aoo`03001oogoo04Moo`00TWoo0P00
9goo00<007ooOol017oo00<007ooOol0Agoo002@Ool2000YOol00`00Oomoo`05Ool00`00Oomoo`16
Ool008eoo`<002aoo`03001oogoo00Aoo`03001oogoo04Ioo`00Rgoo0P00;goo00<007ooOol01Goo
00<007ooOol0AGoo0028Ool3000aOol00`00Oomoo`05Ool00`00Oomoo`15Ool008Ioo`8003Aoo`03
001oogoo00Ioo`03001oogoo04Aoo`00Pgoo0`00=Woo00<007ooOol01Woo00<007ooOol0A7oo0021
Ool2000iOol00`00Oomoo`07Ool00`00Oomoo`13Ool007ioo`<003]oo`03001oogoo00Moo`03001o
ogoo04=oo`00O7oo0P00?Woo00<007ooOol027oo00<007ooOol0@Woo001iOol30010Ool00`00Oomo
o`08Ool00`00Oomoo`12Ool007Moo`8004=oo`03001oogoo00Uoo`03001oogoo045oo`00MGoo0P00
AGoo00<007ooOol02Goo00<007ooOol0@Goo001bOol30017Ool00`00Oomoo`0:Ool00`00Oomoo`10
Ool0071oo`8004]oo`03001oogoo00Uoo`03001oogoo041oo`00KGoo0`00CGoo00<007ooOol02Woo
00<007ooOol0?goo001[Ool2001@Ool00`00Oomoo`0:Ool00`00Oomoo`0oOol006Qoo`<0059oo`03
001oogoo00]oo`03001oogoo03ioo`00IWoo0P00EGoo00<007ooOol02goo00<007ooOol0?Woo001S
Ool3001GOol00`00Oomoo`0<Ool00`00Oomoo`0mOol0065oo`8005Yoo`03001oogoo00aoo`03001o
ogoo03eoo`00Ggoo0P00G7oo00<007ooOol03Goo00<007ooOol0?7oo001LOol3001NOol00`00Oomo
o`0=Ool00`00Oomoo`0lOol005Yoo`80065oo`03001oogoo00ioo`03001oogoo03]oo`00Egoo0`00
Hgoo00<007ooOol03Woo00<007ooOol0>goo001EOol2001VOol00`00Oomoo`0?Ool00`00Oomoo`0j
Ool0059oo`<006Uoo`03001oogoo00ioo`03001oogoo03Yoo`00D7oo0P00K7oo00<007ooOol03goo
00<007ooOol0>Goo001=Ool3001^Ool00`00Oomoo`0?Ool00`00Oomoo`0iOol004]oo`80075oo`03
001oogoo011oo`03001oogoo03Qoo`00B7oo0`00Lgoo00<007ooOol047oo00<007ooOol0>7oo0016
Ool2001fOol00`00Oomoo`0AOol00`00Oomoo`0gOol004Aoo`8007Qoo`03001oogoo015oo`03001o
ogoo03Moo`00@Goo0`00NWoo00<007ooOol04Woo00<007ooOol0=Woo000oOol2001mOol00`00Oomo
o`0BOol00`00Oomoo`0fOol003aoo`<007moo`03001oogoo01=oo`03001oogoo03Eoo`00>Woo0P00
PWoo00<007ooOol04goo00<007ooOol0=Goo000gOol30025Ool00`00Oomoo`0COol00`00Oomoo`0d
Ool003Eoo`8008Qoo`03001oogoo01=oo`03001oogoo03Aoo`00<Woo0`00RWoo00<007ooOol057oo
00<007ooOol0<goo000`Ool2001nOol4O00;Ool00`00Oomoo`0DOol00`00Oomoo`0cOol002eoo`<0
07Yoo`Il0004DkhLiacWDgh2O009Ool00`00Oomoo`0EOol00`00Oomoo`0bOol002]oo`8007Yoo`=l
00037>M?_U>o009C_P8Li`05DgiGOU=nEgiCOP02O007Ool00`00Oomoo`0EOol00`00Oomoo`0bOol0
02Uoo`8007Uoo`=l0003Bk`Lie>n00=C_P8Li`05EgiCOU=nDgiGOP03Dgh00eMnO01l0005Ool00`00
Oomoo`0FOol00`00Oomoo`0aOol002Ioo`<007Qoo`=l0007Bma7^acW7>MC_TnnDkl00QcW00UCOUMn
DgiGOU=nEgiCOUMnDgh00QcW00=C?E<MO00017oo00<007ooOol05Woo00<007ooOol0<Goo000TOol2
001iOol2O0001AcWAka;_4Nl7>L00e>n0QcW0U=n00IGOU=nDgiCOUMnDgh37>L01E<MDceC7E<mO000
17oo00<007ooOol05goo00<007ooOol0<7oo000QOol3001iOol2O00011cWBma7_4_L0QcW0U>n00U?
_QcWDgiGOU=nEgiCOUMnDgh00acW00UC7ELnDaeC?E<MEciC7E<mO0000goo00<007ooOol05goo00<0
07ooOol0<7oo000OOol2001jOol2O0027>L014^lAka;_1cW0e>n0QcW0e=n00=GOU=nDgh00QcW00aC
7E<mDaeC?E<MDceC7E<mDaeC?E<MO003Ool00`00Oomoo`0HOol00`00Oomoo`0_Ool001eoo`8007Yo
o`9l0005;c@LidNkBma7_0027>L02E>oDkhLiacWEgiCOUMnDgiGOP037>L03eLnDaeC?E<MEciC7E<m
DaeG?U<MDceC7ELn7>Ml0002Ool00`00Oomoo`0HOol00`00Oomoo`0_Ool001eoo`8007Qoo`9l0005
;c@LiacWAka;_0027>L2Dkh27>L015=nEgiCOU=n0acW00aC?E<MDceC7E<mDaeC?E<MDceC7E<mDad4
7>L00e;LO01oo`02Ool00`00Oomoo`0HOol00`00Oomoo`0^Ool001eoo`03001oo`0007Eoo`03001l
02ld008Li`06Bma7^d_L7>MC_Tnn0QcW00AGOU=nEgiCOP8Li`0;EciC7E<mDaeG?U<MDceC7ELnDaeC
?@047>L01TkKD]a>fe;LC]]l00=oo`03001oogoo01Qoo`03001oogoo02ioo`0077oo00D007ooOomo
o`00079oo`08001l07`0;c@LidNlBka7_08Li`03DkhLiacW00=COP<Li`08DaeC?E<MDceC7E<mDaeC
?@DLi`03D]a>g5;L009Bg005C]aBg5;LD]al0003Ool00`00Oomoo`0IOol00`00Oomoo`0]Ool001ao
o`03001oogoo009oo`03001oogoo06eoo`800008O00cEAcW7>M7_4_LAk/Li`9C_P047>MGOU=nEgh2
7>L01e<MDceC7ELnDaeC?E<M00@Li`0?D]a>fe;LC]]Bg4kKD]a>fe;LC]]Bg4kKD]a>fg`000=oo`03
001oogoo01Uoo`03001oogoo02eoo`0077oo00<007ooOol00goo00<007ooOol0JWoo0`0000Il02ld
7>M;_4NlBk`27>L01E>n7>LLieMnDgh00QcW00EC?E<MDceC7E<m00@Li`05C]aBg5;LD]a>g003D]`0
1DkLD]aBg5;LC]`00e;L00=>g5;LO0000goo00<007ooOol06Woo00<007ooOol0;7oo000LOol00`00
Oomoo`03Ool00`00Oomoo`1XOol30002O0001S=E7>M;g4NlBm`Li`D0008Li`03DaeG?U<M00@Li`0@
D]a>fe;LC]]Bg4kKD]a>fe;LC]]Bg4kKD]a>fe;LC]/67>L01G`0Oomoogoo000077oo00<007ooOol0
;7oo000LOol00`00Oomoo`04Ool00`00Oomoo`1UOol4000017`0;c@LiacW0`0000<Li`00Ool01Goo
00@001cW7>LLi`9Bg004C]aBg5;LD]`>7>L00djJCY]>VP02CYX00djKO01oo`02Ool00`00Oomoo`0K
Ool00`00Oomoo`0[Ool001]oo`03001oogoo00Ioo`03001oogoo069oo`D00003O00001cW008000eo
o`03000LiacW00DLi`0DCY]>VTjKCYY>VdjJCY]>VTjKCYY>VdjJCY]>VTjKCYY>VdjJCY]l00Aoo`03
001oogoo01]oo`03001oogoo02]oo`006goo00<007ooOol01goo00<007ooOol0Ggoo0`0000DLi`00
40=l0000015oo`03000LiacW008Li`05CY]>VTjJCYY>V`03CYX01DjKCYY>VTjJCY/00djJ00M>VdjJ
CYY>VTjKCYYl0004Ool00`00Oomoo`0LOol00`00Oomoo`0ZOol001]oo`03001oogoo00Qoo`03001o
ogoo05aoo`<0000550@@0a@440=l000DOol01000BUU:F4iI21cW00m>VTjKCYY>VdjJCY]>VTjKCYY>
VdjJCY]>VTjKO00017oo00<007ooOol077oo00<007ooOol0:Woo000KOol00`00Oomoo`09Ool00`00
Oomoo`1IOol00`0040<@0`0540<00g`0Oomoo`0DOol27>L9BUT97>L01DjJCY]>VTjJO0001Goo00<0
07ooOol07Goo00<007ooOol0:Goo000KOol00`00Oomoo`0:Ool00`00Oomoo`1FOol0210350@@0a@4
40<D110350@2O00GOol67>L00dYIBUQ>F@02BUT01TYHCUU:FDYIBUQ>F@9:F@03BUPLiacW008Li`03
O01oogoo00=oo`03001oogoo01eoo`03001oogoo02Uoo`006Woo00<007ooOol037oo00<007ooOol0
Cgoo0P000QcW2A0300=l07ooOol067oo00<001cW7>L00THG11cW3DYI00=l07ooOol01Goo00<007oo
Ool07Goo00<007ooOol0:7oo000JOol00`00Oomoo`0=Ool00`00Oomoo`1:Ool4000012A;:4`TBbA<
1AcW00@D110350Al01aoo`@Li`04BQQ65dHHAQL47>L01DiIBUU:FDYHCUT00TYI00=:F4iIO0001goo
00<007ooOol07Goo00<007ooOol0:7oo000JOol00`00Oomoo`0>Ool00`00Oomoo`16Ool010007>L0
02A<0bA;00DTC2A;94/TBbA<00<TB`0494`LiacWO00OOol47>L6AQL37>L5BUT00g`0Oomoo`06Ool0
0`00Oomoo`02Ool5O00GOol00`00Oomoo`0WOol001Yoo`03001oogoo00ioo`03001oogoo049oo`@0
000B<?4`l1cW7>LTC2A;:4`TBbA<94/XC2A;94`TBbQ<94/TC7`08Goo1QcW00I65dXHAQM664HGBQP3
7>L00diIBUUl0008Ool00`00O01l0002O0001AcWAei;GdMNBel01W`04Goo00<007ooOol09goo000J
Ool00`00Oomoo`0?Ool00`00Oomoo`0oOol01@007>L`lC3a<?000c3a00@`l33a7>LTC0<TB`0594`T
BbA;94/TC00294/00g`0Oomoo`0ROol27>L0147F?MHLiacW1dHG00<Lig`0Ool01Goo0g`000H002mL
<e`Lid]OAel3Bel00dMOBem;G`027>L2Cad4O00>Ool00`00Oomoo`0VOol001Uoo`03001oogoo015o
o`03001oogoo03aoo`80000;?G@`l1cW<?0`lC3`=?4`l33a<?0dl@027>L02BA;:4`TBbA<94/XC2A;
94al000WOol27>L02Sff@MHLiacWAQM664HGBQQ65g`017oo0g`000@cG2mL<ed0008Li`07Bem7GT]O
Aei;GdMNBel00QcW00Q?7E<NCaeC7TlMDai?7E<N0g`02goo00<007ooOol09Woo000IOol00`00Oomo
o`0BOol00`00Oomoo`0iOol20005>G@27>L00c3a<?0`l@02<?400c3`<?4`l@027>L294/01BA<94/T
BbA;O000:7oo00D001cW7>M1eSgF00<Li`965`03O00X0RP2009l0007<e`_G3=L;e`cG2mL00000T]O
00M7Gd]OBem;GdMOBelLi`0:Cad27>L00e;LO01oo`0:Ool00`00Oomoo`0UOol001Uoo`03001oogoo
01=oo`03001oogoo03Moo`0J7>LmMCUd?G@iM3ee>G@mM3Ud=?4Lic3a<?0dlC3`<?4`l3Ca<?0`lAcW
:4`TBbA<94]l02]oo`<Li`06?KI1eSff7>Ml02`30W`000H_G3=M;e`cG2mL<ed27>L01`00Bem7GT]O
Aei;GdMN008Li`09Dai?7E<NCaeC7TlMDai?7E<N008Li`05C]]Bg4kKD]al000:Ool00`00Oomoo`0U
Ool001Uoo`03001oogoo01Aoo`03001oogoo03Aoo`800003AMDLiacW00LiM004<?4Lic3a<?03<?40
133`<?4`lC3a0QcW00<TBg`0Ool0;7oo00D001cW7>LmeT7F00=l0006<e`_G3=L;e`cG2mL0QcW0T]O
00<004MOBel00T]O0QcW2DlM0QcW00MBg5;KD]a>fe;LD]]Bg002O009Ool00`00Oomoo`0TOol001Uo
o`03001oogoo01Eoo`03001oogoo035oo`800005@ME5eT7EAMI1e@027>L04ced>G@mMCUd?G@iM3ee
7>L`lC3`=?4`l33a<?0dlC3`<?4`l7`0031oo`0:000Lig`0O00_G3=L;e`cGBmL<e`27>L04TMNBem7
GT]O001;GdMNDahLie<NCaeC7TlMDai?7E<NCaeC7P8Li`0<C]]Bg4kKD]a>fe;LC]]Bg4kKD]a>fg`0
27oo00<007ooOol097oo000HOol00`00Oomoo`0GOol00`00Oomoo`0_Ool01AcWAME5eDGE@MD00dGE
00=1eDGE7>L01cUd0QcW00D`l33a<?4`lC3`008`l@03O01oogoo035oo`800008<e`_G3=L;e`cG1cW
Bem7G`=;G`03Ael004]O008Li`U?7@0@7>MBg4kKD]aBfe;LC]]Bg5;KD]a>fe;LD]]Bg1cWO008Ool0
0`00Oomoo`0SOol001Qoo`03001oogoo01Qoo`03001oogoo02eoo`0<000L01cWAMI1eDGF@ME5eT7E
AMI1eDGF0QcW00hiM3ee>G@mM3Ud?GDiM1cW<?0dlC3`<?4`l7`0=Woo0P0001D_G1cW7>M;GdMNBem7
GT]OAei;G`007>M?7E<NCaeC7TlMDai?7E<NCad00QcW00aBg4kKD]a>fe;LC]]Bg4kKD]a>fe;LC]/2
7>L00e:jCYYl0007Ool00`00Oomoo`0SOol001Qoo`03001oogoo01Uoo`03001oogoo02]oo`04000L
01`070037>L00dGE@ME5e@02AMD0147EAME5eAcW1cUd00<Lic3`<?400S3a00=l07ooOol0=Woo00@0
04]OBem7G`=;G`05AelLiacWCad00007Cad27>L02e;KD]a>fe;LD]]Bg4kKD]aBfe;LC]/00acW15:J
00=l07ooOol01Woo00<007ooOol08Woo000HOol00`00Oomoo`0IOol00`00Oomoo`0ZOol02000700H
01`0600L01P070037>L01TGF@ME5eT7EAMI1e@8Li`06?GDiM3ed>G@mMCUd0QcW00<dlG`0Ool0>Goo
0P0000=;GdMNBel00QcW00U?7E<NCad004lMDai?7E<NCad00QcW00]Bg4kKD]a>fe;LC]]Bg4kKD]a>
fe;L008Li`09CYYB^djJD[Y>VU:kCYYB^W`000Moo`03001oogoo029oo`0067oo00<007ooOol06Woo
00<007ooOol0:7oo00@001cW7>LLi`PL008Li`95e@04@ME5eDGEAMD27>L6>G@00g`0Oomoo`0kOol2
00000acWCae?7@03Cad01000Cae?7DlM0QcW00Y>fe;LD]]Bg4kKD]aBfe;LC]]Bg0<Li`YBVP03O01o
ogoo00Ioo`03001oogoo025oo`005goo00<007ooOol077oo00<007ooOol09Woo00D003LO<_hg7aP0
00@Li`06700H01`0600L01P00acW00I1eDGF@ME5eT7E7>L2O0000cUd?GEl0010Ool200004U<NCaeC
7TlM001?7E;L7>MBg4kKD]a>fe;LC]]Bg4kKD]a>f`8Li`0?D[]>VU:jCYYB^djJD[Y>VU:kCYYB^TjJ
D[]>VW`000Moo`03001oogoo025oo`005goo00<007ooOol07Goo00<007ooOol09Goo00<003Ko=_l0
1SKo1AcW11`00acW00Q5eG`0O00LicnMO00iM7`0@Woo0P000TlM00/001cW7>MBg4kKD]aBfe;LC]]B
g5;K00<Lia1BVP03O01oogoo00Ioo`03001oogoo021oo`005goo00<007ooOol07Woo00<007ooOol0
8goo00l003;n=alfoSLO<_hg7cKn=alboSLO=_hg7c;n=al011cW00XH01`0O01l03nM?ihoWD>N?iel
04Eoo`0;000Li`00C]]Bg4kKD]a>fe;LC]]Bg0027>L05DjJD[Y>VU:kCYYB^TjJD[]>VU:jCYYB^djJ
D[Y>VU:kCYYB^TjJ7>Ml0007Ool00`00Oomoo`0POol001Moo`03001oogoo01moo`03001oogoo029o
oa<Li`9l0005?ihoWCnN?idoWP02?el00g`0Oomoo`14Ool200001E;LC]]Bg5;KD]`00acW4E:J11cW
00=>NG`0Ool01goo00<007ooOol07goo000GOol00`00Oomoo`0POol00`00Oomoo`0POol03000?elk
GcmO>eloGc]O?elkGcmO>eloG`LLi`06O00oWD>N?idoGc]O0goo00<boW`0Ool0AWoo00@004kKD]a>
f`8Li`0@D[Y>VU:kCYYB^TjJD[]>VU:jCYYB^djJD[Y>VU:kCYX47>L01U9iCWQBNDihDWUl00Qoo`03
001oogoo01moo`005Woo00<007ooOol08Woo00<007ooOol07goo00@003mO?eloG`/Li`04>iXLiacW
O01BOol010007>LLiacW3U:J11cW0U9i00E>NE9iDWUBNDii009BN@03O01oogoo00Moo`03001oogoo
01ioo`005Woo00<007ooOol08goo00<007ooOol07Goo00<001cW7>L00QcW00DoWCnN?ie3WSnM00<L
i`8kVP<Li`03O01oogoo055oo`0>001oo`00CYYB^TjJD[]>VU:jCYYB^djJD[Y>VP@Li`0?DWU>N59i
CWQBNDihDWU>N59iCWQBNDihDWU>N7`000Qoo`03001oogoo01ioo`005Woo00<007ooOol097oo00<0
07ooOol077oo00L003nN?idoWSnM?ihoW@037>L3>iX37>L2O01DOol01000Oomoo`001U:J11cW00E>
NE9iDWUBNDii00=BN@05CWUBNE9iDWU>N@03DWT00diiDWUl0009Ool00`00Oomoo`0MOol001Ioo`03
001oogoo02Aoo`03001oogoo01]oo`05000oWSnM@ihoW@037>L2>iX00c^I?iXLi`037>L00g`0Oomo
o`1DOol01P00Oomoo`00D[]>VP@Li`0GDWU>N59iCWQBNDihDWU>N59iCWQBNDihDWU>N59iCWQBNDih
DWU>N59iCWQl0009Ool00`00Oomoo`0MOol001Ioo`03001oogoo02Eoo`03001oogoo01Yoo`03000o
WAcW008Li`@kVP<Li`04<e@Li`00O01HOol00`00Oomoo`027>L2DWT01DiiDWUBNE9iCWT00e9i00E>
NE9iDWUBNDii00=BN@05CWUBNE9iDWU>N@03DWT00g`0Oomoo`08Ool00`00Oomoo`0LOol001Ioo`03
001oogoo02Ioo`03001oogoo01Uoo`07000Lic^J>iXkVCnJ>iX00QcW00HcE2lc7>LLi`00O01IOol0
6`00Oomoo`00CWQBNDihDWU>N59iCWQBNDihDWU>N59iCWQBNDihDWU>N59iCWQBNDihDWU>N0047>L0
0g`0Oomoo`08Ool00`00Oomoo`0LOol001Eoo`03001oogoo02Qoo`03001oogoo01Qoo`03000kVS^J
008kVP8Li`07<c@cE7oo7>L001cWO000FWoo00H007ooOomoo`00CWT3DWT01DiiDWUBNE9iCWT00e9i
00=>NAcW7>L01acW00E>Ee9HCUMBF7`000]oo`03001oogoo01]oo`005Goo00<007ooOol0:Goo00<0
07ooOol05Woo00@003^J>iXkV@8Li`03<e@_<c=D008Li`03000Lig`005]oo`09001oogooOol0059i
CWQBNDih00TLi`0>CUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMl00]oo`03001oogoo01]oo`005Goo
00<007ooOol0:Woo00<007ooOol05Goo00L003^J7>LLic<c<e@c=0027>L010007>LLig`0G7oo00D0
07ooOomoo`0000@Li`0FCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGO00=
Ool00`00Oomoo`0JOol001Eoo`03001oogoo02]oo`03001oogoo01Aoo`8Li`03<e@_<c=D008Li`80
00037>L007`005eoo`0O001oogooOol0059HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>
Ee9HCUMBF4iGDUQ>Ee9HO0003Goo00<007ooOol06Woo000EOol00`00Oomoo`0/Ool00`00Oomoo`0C
Ool00`00<e@c<`027>L200027>L200000g`0Oomoo`1KOol07`00Oomoo`00DUQ>Ee9HCUMBF4iGDUQ>
Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Eg`000ioo`03001oogoo01Uoo`0057oo
00<007ooOol0;Woo00<007ooOol04Goo00@003=D7>LLi`<000057>L00000001l001NOol07`00Oomo
o`00CUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF7`000io
o`03001oogoo01Uoo`0057oo00<007ooOol0;goo00<007ooOol047oo0QcW0`000QcW0`0000=l07oo
Ool0GGoo00@007ooOol000HLi`0DDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQ>Ee9HCUMBF4iGDUQl
011oo`03001oogoo01Qoo`0057oo00<007ooOol0<7oo00<007ooOol03goo100000<Li`0000000P00
00=l07ooOol0GWoo00X007oo001B=ThFDSM>5U8fCQIB=`dLi`07DUQ>Ee9HCUMBF4iGO00047oo00<0
07ooOol067oo000DOol00`00Oomoo`0`Ool00`00Oomoo`0?Ool200027>L400000g`0Oomoo`1OOol0
0`00Ool0000DCQH67>L00g`0Oomoo`0?Ool00`00Oomoo`0GOol001Aoo`03001oogoo035oo`03001o
ogoo00eoo`8000037>L00000008000037>Ml07oo069oo`0L001>5U8gCQIB=ThFDSM>5U8fCQIB=dhF
DSI>5U8gCQIB=ThFDSM>5U8fCQIB=dhFDSI>5U8gO00BOol00`00Oomoo`0GOol001=oo`03001oogoo
03=oo`03001oogoo00aoo`8Li`<0008Li`03005l07oo069oo`03000LiacW01Q>5P03O01oogoo015o
o`03001oogoo01Ioo`004goo00<007ooOol0=7oo00<007ooOol02Woo00<Ligoo00000P0000@Li`01
005l06=oo`800003COA=mAcW00<Li`0DCQIB=dhFDSI>5U8gCQIB=ThFDSM>5U8fCQIB=dhFDSI>5U8g
CQIl01Aoo`03001oogoo01Ioo`004goo00<007ooOol0=Goo00<007ooOol02Goo0`000QcW0P0100=l
07ooOol0HWoo0P001Tge11cW3dhF00=l07ooOol04Woo0P005goo000COol00`00Oomoo`0fOol00`00
Oomoo`07Ool300000acW00400@0200400g`0Oomoo`1QOol03@00CO@004WdCOE=m4geBOA=mDgdCOE9
m4ge00@Li`0;CQIB=ThFDSM>5U8fCQIB=dhFDSIl000BOol300000goo001oo`0FOol001=oo`03001o
ogoo03Moo`03001oogoo00Eoo`80008Li`@00@03O01oogoo069oo`8Li`03001=mDge00a=m@@Li`I>
5P03O01oogoo00aoo`@000Aoo`03001oogoo01Eoo`004Woo00<007ooOol0>Goo00<007ooOol017oo
0QcW1P0100=l07ooOol0HGoo01H004fcBK<001cWCOE9m4geCOA=mDWdCOE=m4geBOA=mDgdCOE9m4ge
COA=m@@Li`03CQIl07oo00]oo`<000Qoo`03001oogoo01Eoo`004Woo00<007ooOol0>Woo00<007oo
Ool00Woo00<Li`0100401@0100=l07ooOol0HGoo00H004fcBK==/`00CK<27>LCCOD00acWO01oo`08
Ool3000<Ool00`00Oomoo`0DOol0019oo`03001oogoo03]oo`04001oogoo7>L700400g`0Oomoo`1R
Ool02000BK==/dVc0019/dfcBK<27>L04TgeCOA=mDWdCOE=m4geBOA=mDgdCOE9m4geCOA=mDWdCOEl
00Moo`<000moo`03001oogoo01Aoo`004Woo00<007ooOol0>goo00<007oo0000200100=l07ooOol0
HGoo00/LidVcCK=9/dfc001=/dVcCK=9/dfc00<Li`e=m@03O01oogoo00=oo`<0019oo`03001oogoo
01Aoo`004Woo00<007ooOol0?7oo0P001P0100<Lig`0Ool0HWoo00l004E`7>LLidfcBK<004VcCK=9
/dfcBK==/dVcCK<00QcW00]9m4geCOA=mDWdCOE=m4geBOA=mG`0009oo`@001Eoo`03001oogoo01Ao
o`004Goo00<007ooOol0?Goo00<0000100400`010QcW00=l07ooOol0HWoo00@004UaBG59L@8Li`0;
001=/dVcCK=9/dfcBK==/dVcCK=9/`027>L8COD00g`00000000IOol00`00Oomoo`0DOol0015oo`03
001oogoo03eoo`0300000@0100<Li`0300L427`006=oo`0D0019LDEaBG55L4UaAG4Li`00CK=9/dfc
BK==/dVcCK=9/dfcBK==/`8Li`06COA=mDWdCOE=m7`077oo00<007ooOol057oo000AOol00`00Oomo
o`0lOol01P00004LiacW00L41`801`03O01oogoo069oo`037>M9LDUa00E9L@0>000LidfcBK==/dVc
CK=9/dfcBK==/dVcCK=9/`8Li`9=m@03O01oogoo01aoo`03001oogoo01=oo`004Goo00<007ooOol0
?7oo00T001cW10P01`@800L42007O000I7oo00X001cW7>M9LDEaBG55L4Ua0019L@8Li`0>BK==/dVc
CK=9/dfcBK==/dVcCK=9/dfc7>Ml01moo`03001oogoo01=oo`004Goo00<007ooOol0>goo00D00007
00L01`@700<01`03O01oogoo069oo`050015;TD>ABhLi`04BG404@00BG59LDUa7>M9/dfcBK==/dVc
CK=9/dfcBK==/dVcO00087oo00<007ooOol04goo000@Ool00`00Oomoo`0kOol02P0000L4200710P0
1`@800L427`0I7oo00h0044>ABm13TD^7>M9LDEaBG4004UaAG59LDE`0QcW00U=/dVcCK=9/dfcBK==
/dVcO0008Goo00<007ooOol04goo000@Ool00`00Oomoo`0jOol01@0000L01`0710L00`0700@41g`0
Ool0069oo`0700153TD^@@i5;TD>ABh00QcW00=9L@00BG401DUa0QcW00A9/dfcBK==/`9l029oo`03
001oogoo01=oo`0047oo00<007ooOol0>Goo00/0000710P01`@800L4200710P01g`0009oo`03001o
ogoo05moo`0G000Lid4>ABi13TD_@@i5;T4>7>L004UaAG19LDEaBG55L4UaAG4LidVcCK=l000TOol0
0`00Oomoo`0COol0011oo`03001oogoo03Qoo`05000Li`0700L41`0300L00`@700Ml0003Ool00`00
Oomoo`1OOol02`00>:/LiacWABi13TD^A@i5;T4>00002DUa00<Lig`0Ool09Goo00<007ooOol04Woo
000@Ool00`00Oomoo`0gOol00`0020d<3@037>L01P@800L4200710Ql00Aoo`03001oogoo05eoo`05
000dZcR/=:/h[0027>L01D4>ABm13TD^00000QcW00I9LDE`BG55LDUaAG02O00WOol00`00Oomoo`0B
Ool000moo`03001oogoo03Qoo`0300083@P=00<83@<Li`0300Ml07oo00Eoo`03001oogoo05]oo`80
000>>:`hZcR/>:/h[3R[7>M13TD^A@h0044>ABhLi`=9L@9l02Uoo`03001oogoo019oo`003goo00<0
07ooOol0=goo00`000`=20`<3@P=30d830`=20d<3AcWO007Ool00`00Oomoo`1GOol300002Goo000L
iacW=:/h[3B[>:`dZ`027>L01DD_0015;T4>ABl00QcW00=l07ooOol0:Goo00<007ooOol04Woo000?
Ool00`00Oomoo`0fOol00`0020d83@0920d00g`0Oomoo`06Ool00`00Oomoo`1COol30004Ool00`00
2K/hZ`037>L02CR[>:`hZcR/7>L004D>ABi13P02O00/Ool00`00Oomoo`0BOol000moo`03001oogoo
03Ioo`0<000830`=20d<3@P<30d83@`=20`<3G`02Woo00<007ooOol0CWoo10001goo00H000Fj2K/5
^PVk1KX47>L00cR/=:/00002O00^Ool00`00Oomoo`0BOol000moo`03001oogoo03Eoo`0300083@P=
00T83@03O01oogoo00Uoo`03001oogoo04Yoo`<000Yoo`0:0005^`Vk1K/9^`Fk2K/5^`Vk1K/27>L0
0g`0001oo`0`Ool00`00Oomoo`0AOol000ioo`03001oogoo03Eoo`0>000@TAcW20d<3@P<30d83@`=
20`<3@P=30el00aoo`03001oogoo04Ioo`<000eoo`040009^`Fj2K/67>L011jm8[hN_P000W`0;goo
00<007ooOol04Goo000>Ool00`00Oomoo`0dOol01@00598DTQ2B7>L020P=00=l07ooOol037oo00<0
07ooOol0@Woo0`0047oo00@001cW7>LLi`8N_P0:8[hN_Qjn7[hR_Qjn7>L003jn>[d2O00]Ool00`00
Oomoo`0AOol000ioo`03001oogoo03=oo`0?000@TABB494DTQ2A7>L83@`=20`<3@P=30d837`000mo
o`03001oogoo03eoo`@001=oo`0:000R_Qjn8[hN_B:n7[hR_Qjm8[h27>L01cZm000j_Cjn>[dn_W`0
02aoo`03001oogoo015oo`003Woo00<007ooOol0<Woo00@001BB598@TP<DTP03498LiacW00@83@03
O01oogoo00ioo`03001oogoo03Yoo`<001Moo`05000N_Qjn7[hR_P027[h37>L01Sjn>[dn_P00?[hj
_@8Li`03AW]l07`002Yoo`03001oogoo015oo`003Woo00<007ooOol0<Goo010Lia2A598@TABB494D
TQ2A598@TABB7>L<3@P<30el015oo`03001oogoo03Ioo`<001Yoo`03000R_Qjm00@Li`07?[hj_Cjn
>[dn_SZm00000QcW00E6NdJK@W]6VdIk009l02Qoo`03001oogoo015oo`003Goo00<007ooOol0<Goo
00@001Tf7>L@TP<DTP07498DTQBB598@TQBB7>L00PP=00=l07ooOol047oo00<007ooOol0<Woo0`00
7Goo00/001cW7>Lj_Cjn>[dn_SZm?[hj_Cjn008Li`030016NdIk00I6N`037>Ml07oo02Moo`03001o
ogoo011oo`003Goo00<007ooOol0<7oo014001TF7CLI5QcW494DTQ2A598@TABB494DTQ2A598Lig`0
01Aoo`03001oogoo02ioo`<0021oo`09000n_SZm?[hj_Cjn>[dn_SZm008Li`09AY]2N`00AW]6Vd9k
AY]6NdJK008Li`9:F@03O01oogoo02Eoo`03001oogoo011oo`003Goo00<007ooOol0;goo00<001Tf
6CH00aTf00<Lia2B59800QBB00L@TQBB598DTQ2B599l000EOol00`00Oomoo`0YOol4000SOol01`00
>[dn_SZm?[hj_Cjn008Li`A6N`030016NdIk0096N`8Li`E:F@03O01oogoo02Aoo`03001oogoo011o
o`003Goo00<007ooOol0;Woo01<001TF7CLI5Qdf6AHM=acW598@TABB494DTQ2A598@TABB495l000F
Ool00`00Oomoo`0UOol3000XOol01000>[dn_SZm0QcW00Q6VdIkAY]2NdJKAW/0049k0acW00E6F4YI
BUU:FDIH009:F@03O01oogoo02Aoo`03001oogoo011oo`003Goo00<007ooOol0;Goo00<LiaTf6CH0
1QTf00<LiaBB49800aBB00@@TQBB599l01Qoo`03001oogoo025oo`<002]oo`04000n_QcW7>L8AW/0
0`007>M:F@0:BUT00g`0Oomoo`0SOol00`00Oomoo`0@Ool000aoo`03001oogoo02eoo`0D000M^QcW
6AHM=QTF7CLI5Qdf6AHM=acW598@TABB494DTQ2A599l01Uoo`03001oogoo01eoo`<002ioo`8Li`08
AY]2NdJKAW]6Vd9kAY]6N`8Li`04BUT004YIAUP3BUT024IHBUU:FDYIAUQ:FAcWO00TOol00`00Oomo
o`0@Ool000aoo`03001oogoo02aoo`05000M^Qfj7KXLi`086CH00acW598@TP0359800a2BO01oo`0I
Ool00`00Oomoo`0HOol4000aOol00`00AW]6N`05AW/27>L3BUT00`00BUU:F@06BUT37>L2BSL00g`0
Oomoo`0ROol00`00Oomoo`0?Ool000aoo`03001oogoo02]oo`0E000M^R6j7KXQ^Qfj7>LI5Qdf6AHM
=aTF7CHI5Qdg7>LDTQ2A598@TG`001aoo`03001oogoo01Aoo`<003Eoo`060012NdJKAW]6Vd9k0QcW
00=:FDIHBUT00TYI00D004YIBUU:FDIH00@Li`06CSQ:5dhhBQM>>7`097oo00<007ooOol03goo000<
Ool00`00Oomoo`0ZOol00`007KXM^P057KX00acW6CHI=P066CH01AcW598@TQBBO00077oo00<007oo
Ool04Goo0`00>Goo00<004IkAW/00QcW1dYI00<004YI7>L00QcW00A:FDXgBSM>=`=:=`04CSM:=dXg
O00SOol00`00Oomoo`0?Ool000aoo`03001oogoo02Uoo`0:000M^R6j7KXQ^Qfj8KXM^R6j7KX27>L0
2adf6AHM=aTF7CHI5Qdg7>LDTQ2AO0007Goo00<007ooOol03Goo0`00?7oo00<001cW7>L00dYI01M6
F4YIBUU:FDIHBUT001cWAUQ>>4XGCSQ:5dhhBQM>>4XGCSQ:5dhhBQM>>7`0029oo`03001oogoo00mo
o`002goo00<007ooOol0:Goo00<0028m7>L02Qfj00<LiaTf6CH01ATf00<Lig`0Ool07Woo00<007oo
Ool02Goo0`00?goo00<004YIBUT01dYI00DLi`00001:=dhg00=:=`05CSM:=dXgBSM>=`03BSL00dhg
BSMl000ROol00`00Oomoo`0?Ool000]oo`03001oogoo02Uoo`03000RGB8m008Li`0B8KXM^R6j7KXQ
^Qfj8KXM^R6j7>LM=QTF7CLI5Qdf6AHM=g`087oo00<007ooOol017oo1000@Woo00D004YIBUU:FDIH
009:F@@0000CCSQ:5`00BQM>>4XGCSQ:5dhhBQM>>4XGCSQ:5dhhBQM>>1cWO0008Goo00<007ooOol0
3goo000;Ool00`00Oomoo`0XOol01`008UdR?B9M8SdRGAcW00TM^P037>LI=QTf00@I=P03O01oogoo
01moo`03001oogoo00<004Moo`03001:FDYI00<000037>M>=dXg009:=`05CSL004XgBSM>=`03BSL0
14hgBSM:=dXg11cW00=>5W`0Ool08Goo00<007ooOol03Woo000;Ool00`00Oomoo`0WOol020008UdR
?B9M7S`RGB8m8Ud27>L03afj8KXM^R6j7KXQ^Qfj8KXLiadf6AHM=aTF7CIl000ROol20019Ool40002
7>L03TXGCSQ:5dhhBQM>>4XGCSP004hhBQM>>4XGCSP47>L2CQH014XECQI>5W`08Woo00<007ooOol0
3Woo000;Ool00`00Oomoo`0WOol02P008SdRGB8m8UdR?B9M8SdRGB8m0QcW1afj00DLiaTf6CHI=W`0
02=oo`03001oogoo04Eoo`<00004Ool001cW7>L2BSL01DhgBSM:=dXgCSL00dXg00=>=`00BSL00acW
2DhF00=l07ooOol087oo00<007ooOol03Woo000:Ool00`00Oomoo`0WOol05@007>LLiahl8UdR?B9M
7S`RGB8m8UdN?29M7>LQ^Qfj8KXM^R6j7KXQ^P027>L00aTFO01oo`0ROol00`00Oomoo`12Ool30005
Ool02`00CSQ:5dhhBQM>>4XGCSQ:5dhhBQL00QcW00<001cWCQH00ThF00E:5DhFCQI>5TXE00=>5P03
BQEl07oo025oo`03001oogoo00ioo`002Woo00<007ooOol09goo00<002Zn8Sd00acW00PR?B9M8SdR
GB8m8UdR?B9M0QcW1afj00<Lig`0Ool08Woo00<007ooOol0?Woo100027oo00<004XgCSL00dXg00=>
=acW7>L00QcW0dhF00<004hFCQH02dhF00=l07ooOol07goo00<007ooOol03Woo000:Ool00`00Oomo
o`0VOol01`00:]lV_R[O:[hZgahl00<Li`077S`RGB8m8UdN?29M8Sd00QcW00LQ^Qfj8KXM^R6j7KYl
000SOol00`00Oomoo`0kOol3000=Ool00`00BQLLi`037>L00dhFBQE>5P02CQH01DXECQI>5P00BQD0
0dhF00E:5DhFCQI>5TXE00=>5P03O01oogoo01moo`03001oogoo00ioo`002Woo00<007ooOol09Woo
00<002Zn:[l00bZn00@Z_bZn8UdR?@8Li`078UdR?B9M8SdRGB8m8Ud00QcW11fj00=l07ooOol08Goo
00<007ooOol0=goo100047oo00<001cWCQH02dhF00<004hFCQH02ThF00=l07ooOol087oo00<007oo
Ool03Goo000:Ool00`00Oomoo`0VOol03000:]lZ_R[O9[hZgbZn:]lV_R[O:[hRG@<Li`068UdN?29M
8SdRGAhl0QcW00<Q^QfjO0008goo00<007ooOol0=7oo0`0057oo00<004XECQH00ThF00E:5DhFCQI>
5TXE00=>5P05BQE>5P00CQI:5@03CQH01dXECQI>5ThFBQE>5W`0029oo`03001oogoo00eoo`002Goo
00<007ooOol09Woo00<002Zo:[h00RZn00DZ_bZn:[hZ_RZo00<Z_P03:[lZ_R9M00<Li`058UdR?B9M
8SdRG@027>L00g`0Oomoo`0QOol00`00Oomoo`0`Ool4000GOol00`00CQI>5P0=CQH00`00CQI>5P04
CQH47>L00g`0Oomoo`0POol00`00Oomoo`0=Ool000Uoo`03001oogoo02Ioo`@Li`0?:]lZ_R[O9[hZ
gbZn:]lV_R[O:[hZgbJn:]lR?B9M008Li`068SdRGAhl8UdR?G`08goo00<007ooOol0;Goo0`0077oo
00<004hFBQD00dhF00E:5DhFCQI>5TXE00=>5P037>L001cW00DLi`05COAAmDgdCOEl000ROol00`00
Oomoo`0=Ool000Uoo`03001oogoo02Ioo`04001:_4ZlB[`77>L01BZo:[hZ_RZn:[l00bZn00PZ_b8m
7>LLib9M8SdRGG`08goo00<007ooOol0:Woo0`007goo00<004hFCQH00ThF2AcW0Tge00<004geCOD0
1dge00=l07ooOol087oo00<007ooOol03Goo0009Ool00`00Oomoo`0VOol02`00A[a:gDJlB]e6_4[M
A[a:gDJlB]d021cW00@Z_R[O9[hZg`8Li`037Sal07oo029oo`03001oogoo02Ioo`@0029oo`03000L
iacW008Li`0FDOE=m4geCOAAmDgdCOE=m57eCOA=mDgd001=m4geCOAAmDgdCOE=m57eO00ROol00`00
Oomoo`0=Ool000Uoo`03001oogoo02Eoo`03001:_4Zl00m:_003:[lZ_QcW00HLi`03O01oogoo021o
o`03001oogoo02Aoo`<002Ioo`03001=mDge00i=m@03001=mDge00I=m@03O01oogoo025oo`03001o
ogoo00aoo`0027oo00<007ooOol09Woo01L004[MA[a:gDJlB]e6_4[MA[a:gDJlB]e6_4[MA[a:gDJl
B]e6_4[MA[a:gDJl00DLi`9l021oo`03001oogoo021oo`@002Uoo`0J001=mDgdDOE=m4geCOAAmDgd
COE=m57eCOA=mDgdDOE=m4ge001AmDgdCOE=m57eCOAl02Aoo`03001oogoo00aoo`0027oo00<007oo
Ool09Woo00<004ZlB[`01dZl3AcW00<hJ3QY=6P00SQX00<hJG`0Ool07goo00<007ooOol07Goo0`00
;7oo00<004geCOD04Dge00<004geCOD00dge00=l07ooOol08Woo00<007ooOol037oo0008Ool00`00
Oomoo`0VOol:7>L03cAX>6TdJ3QY=6PhJCAX>6TdJ3QY=6PhJCAX>6TdJ0047>L00g`0Oomoo`0NOol0
0`00Oomoo`0IOol4000_Ool06`00COAAmDgdCOE=m57eCOA=mDgdDOE=m4geCOAAmDgdCOE=m57eCO@0
04gdDOE=m4geCOAl000TOol00`00Oomoo`0<Ool000Qoo`03001oogoo02Ioo`04000hJ3QY=6P2>6P0
1SQY=6PhJ3QX>6TdJ08hJ006>6TdJ3QX>6PhJCAX1AcW0R@400<P12@4O00087oo00<007ooOol05Woo
0`00<goo00<001cW7>L02QcW24ge00<004geCOD00Tge00=l07ooOol08Woo00<007ooOol037oo0008
Ool00`00Oomoo`0VOol03`00>6TdJ3QY=6PhJCAX>6TdJ3QY=6PhJCAX>6TdJ0057>L01R0490@P12@4
80@T10<Li`03O01oogoo01ioo`03001oogoo01=oo`<003Ioo`0=001=de7dCM=Am4gCDOA=de7dCM=A
m4gCDO@02AcW00D001cW7>LLig`002Aoo`03001oogoo00aoo`001goo00<007ooOol09goo00H003AX
>6PhJ3QY=6P2>6P00cQY=6PLi`047>L290@01B0490@T12@480@00R@40QcW0QP500=l07ooOol07goo
00<007ooOol03goo1000>Goo00D004gDCMAAe4gC009=e006DMA=ddgDCMAAe4gC0TgD00aAe4gCCMA=
e57DCM==e000DMA=ddgDO00UOol00`00Oomoo`0;Ool000Moo`03001oogoo02Moo`05000hJCAX>6Td
J0057>L02b0490@P12@480@T120490@P12@480@00acW0aP500<L1G`0Ool087oo00<007ooOol037oo
0`00?7oo01/0057dCM=Am4gCDOA=de7dCM=Am4gCDOA=de7dCM=Am4gCDOA=de7dCM=Am4gCDO@0057d
O0009Woo00<007ooOol02goo0007Ool00`00Oomoo`0WOol00`007>LLi`027>L290@01B0490@T12@4
80@00b@400<P12@490@00acW1aP500=l07ooOol07goo00<007ooOol027oo1000?goo00@004gDDMA=
d`9=e006DMA=ddgDCMAAe4gC0TgD00IAe4gCCMA=e57DCM<2CM@01E7DCM==e000O0009Woo00<007oo
Ool02goo0007Ool00`00Oomoo`0WOol0400090@P12@480@T120490@P12@480@T120490@P12@40QcW
0aP500@L1AP560DH1@<Li`03O01oogoo01moo`03001oogoo00Eoo`<004=oo`0J000LiacW7>M=de7d
CM=Am4gCDOA=de7dCM=Am4gCDOA=de7dCM=Am4gCDOA=de7dCM<002Moo`03001oogoo00]oo`001goo
00<007ooOol0:7oo00D002@490@T120400<T100480@T12@490@37>L760D27>L240L00g`0Oomoo`0P
Ool01000Oomoogoo1000AGoo00D0057CCM9AdTgD00@Li`06DMA=ddgDCMAAe4gC0TgD00IAe4gCCMA=
e57DCM<2CM@00e7DO000000VOol00`00Oomoo`0;Ool000Moo`03001oogoo02Qoo`09000P12@480@T
120490@P12@400<Li`8H1@0670DH1AP560DL1AP50QcW110700=l07ooOol087oo1000B7oo00X0057C
CK9AddfbDM==/U7CCK9Am0@Li`0=CM=Am4gCDOA=de7dCM=Am4gCDOA=de7dO0000Woo00<007ooOol0
8goo00<007ooOol02goo0006Ool00`00Oomoo`0YOol00`0090@P100390@00b047>LLi`0960D27>L6
40L00g`0Oomoo`0NOol3001;Ool01P00CM9AdU7BDM==dP9AdP06DM==dU7BDM9AddgB1AcW00==e57D
CM<00TgD00=Ae4gCO0000goo00<007ooOol08goo00<007ooOol02Woo0006Ool00`00Oomoo`0ZOol0
0`0090@P10037>L00aP570DH1@0260D011`560DH1AP50QcW1a0700=l07ooOol06goo10000Woo00<0
07ooOol0B7oo01@004fbDM==/U7CCK9AddfbDM==/U7CCK9AddfbDM==/U7CCK9Addfb11cW00=Am4gC
O00017oo00<007ooOol08goo00<007ooOol02Woo0006Ool00`00Oomoo`0ZOol00`007>LLi`0:60D2
7>L940L00g`0Oomoo`0HOol30006Ool00`00Oomoo`17Ool01P007>LLie7BDM==dP9AdP06DM==dU7B
DM9AddgB0U7B00IAddgBDM9AdU7CCM82DM80157C7>LLig`01Goo00<007ooOol08Woo00<007ooOol0
2Woo0006Ool00`00Oomoo`0[Ool01@0060DH1AP570D00aP500@L1AP57>LLi`T@1`8Li`03O01oogoo
01Aoo`@000Uoo`03001oogoo04Ioo`04001=/E6aCK027>L05U7CCK9AddfbDM==/U7CCK9AddfbDM==
/U7CCK9AddfbDM==/U7CCK9Adg`01goo00<007ooOol08Goo00<007ooOol02Woo0006Ool00`00Oomo
o`0[Ool00`0060DH1@0560D27>L940L27>L00`P9O01oo`0COol3000=Ool00`00Oomoo`15Ool00`00
DK5A/@04DK427>L01DgBDM9AdU7CCM800U7B00IAddgBDM9AdU7CCM82DM801E7CCM9AdU7BO0001goo
00<007ooOol08Goo00<007ooOol02Woo0005Ool00`00Oomoo`0]Ool00`0070DH1@0260D27>L940L2
7>L010P920X42G`047oo100047oo00<007ooOol0A7oo00X004faDK5=/56aCK5A/Df`DK5=/@8Li`0A
DM==/U7CCK9AddfbDM==/U7CCK9AddfbDM==/U7CCK9l0009Ool00`00Oomoo`0POol00`00Oomoo`0:
Ool000Eoo`03001oogoo02eoo`03000H1AP5008Li`T@1`8Li`D82@03O01oogoo00]oo`<001Aoo`03
001oogoo04=oo`03000Lie6a00YA/@8Li`03DM9AddgB009AdP06DM==dU7BDM9AddgB0U7B00=l07oo
Ool02Goo00<007ooOol087oo00<007ooOol02Goo0005Ool00`00Oomoo`0^Ool27>L940L27>L020@9
20X82@P:10T82PP9O00:Ool3000GOol00`00Oomoo`12Ool00`00CFmA/@027>L02dfaDK5=/56aCK5A
/Df`DK5=/E6aCK000acW00]=/U7CCK9AddfbDM==/U7CCK9Adg`000]oo`03001oogoo021oo`03001o
ogoo00Uoo`001Goo00<007ooOol0;goo00<0010740L01Q0700<Li`P920T01PP900=l07ooOol01Goo
10006Woo00<007ooOol0@7oo0P00155_00=A/AcWDK40356a0QcW0U7B00IAddgBDM9AdU7CO00=Ool0
0`00Oomoo`0OOol00`00Oomoo`09Ool000Eoo`03001oogoo02moo`03000@1a0700@@1`8Li`0:20X4
2@P:20T82P@920X82@P:O004Ool3000NOol00`00Oomoo`0oOol02@00DHm=Ke6?CFiASde_DHm=KP02
7>L03E6aCK1A/DfaDK5=/56aCK5A/Df`DK5=/E6a008Li`05CK9AddfbDM=l000?Ool00`00Oomoo`0N
Ool00`00Oomoo`09Ool000Aoo`03001oogoo035oo`04000@1a0740L27>L;20T00g`000000002000P
Ool00`00Oomoo`0oOol00acWDFmAK`08DFl00e6a7>MA/@0=DK427>L00e7CCM9l000?Ool00`00Oomo
o`0NOol00`00Oomoo`09Ool000Aoo`03001oogoo035oo`0?000@1acW7>L82PP920X42@P:20T82P@9
20X82@P:00<002Aoo`03001oogoo03eoo`80000=DDdLiacWCFiASde_DHm=KU6?CFmASde^DHl00QcW
011=/56aCK5A/Df`DK5=/E6aCK1A/DfaDK5=/56a7>Ml015oo`03001oogoo01eoo`03001oogoo00Uo
o`0017oo00<007ooOol0<Woo00<Li`P920T01`P9100000<0300;O00097oo00<007ooOol0>goo0P00
00IA;55<CBaAC54/7>L;DFl00acWDK5A/@0;DK400g`0Oomoo`0AOol00`00Oomoo`0MOol00`00Oomo
o`08Ool000Aoo`03001oogoo039oo`0700082PP920X42@P:20T00`000QcW00D02`@<00/437`002Ao
o`03001oogoo03Yoo`097>MAC4d/DDe=;55<CBaACDd/008Li`0:DHm=Ke6?CFiASde_DHm=KU6?CFl2
7>L02e6aCK5A/Df`DK5=/E6aCK1A/DfaO00057oo00<007ooOol07Goo00<007ooOol027oo0004Ool0
0`00Oomoo`0cOol00`0020T82@0300002PP97>LLi`0<00/0300;00`02g`097oo00<007ooOol0>Goo
00d004c77>MAC4d/DDaA;55<CBaAC54/DFlLi`0;DFl00acWDK5A/@05DK42O00FOol00`00Oomoo`0L
Ool00`00Oomoo`08Ool000=oo`03001oogoo03=oo`@0000=20T82QcW7>L02`@<00/4300;10`02`@<
O00097oo00<007ooOol0=goo0P0001U<j4c7C>PLie5<CBaACDd/DDa=;55=CBaAC1cWDHm=Ke6?CFiA
Sde_DHm=KU6?CFmAS`027>L01DfaDK5=/56aO0006Goo00<007ooOol06goo00<007ooOol027oo0003
Ool00`00Oomoo`0`Ool30002Ool03P0020TLiacW00`02`0<00/0300;00`02`0<O00UOol00`00Oomo
o`0fOol00`00C<M<a`04C<L02QcWDDa=;55<DBaAC4d/DDaA;55<0QcW2e5_0QcW00=A/G`0Ool06Goo
00<007ooOol06goo00<007ooOol027oo0003Ool00`00Oomoo`0/Ool40005Ool27>L0300;10`02`@<
00/4300;10`02`@<00]l02Eoo`03001oogoo03Eoo`0R001<adcXC<M<j4c7C>Q<adcX7>MAC4d/DDe=
;55<CBaACDd/DDa=KQcWCFmASde^DHm=Ke6?CFiASde_DHm=KU6?O00LOol00`00Oomoo`0JOol00`00
Oomoo`08Ool000=oo`03001oogoo02Uoo`<000Uoo`0>00002`0<00/0300;00`02`0<00/0300;00al
02Eoo`03001oogoo03Aoo`04001001cW7>L7C<L27>L02Td/DDaA;55<CBaAC54/DDa=;1cW2E5_0W`0
7Woo00<007ooOol06Woo00<007ooOol01goo0003Ool00`00Oomoo`0UOol4000=Ool03@0000/4300;
10`02`@<00/4300;10`02g`002Eoo`03001oogoo039oo`8000=0000KA00LidcXC<M<j4c7C>Q<adcX
C<LLidd/DDe=;55<CBaACDd/DDa=;1cWCFmASde^DHm=Ke6?009l021oo`03001oogoo01Yoo`03001o
ogoo00Moo`000Woo00<007ooOol08goo0`004Goo00d0000<00/0300;00`02`0<00/0300;00al000U
Ool00`00Oomoo`0aOol00`00@0100005@0000acWC<M<a`06C<L02QcWCBaAC54/DDa=;55<DBaAC4d/
0QcW0U5_0W`08goo00<007ooOol06Goo00<007ooOol01goo0002Ool00`00Oomoo`0POol3000EOol0
1P0010`02`@<00/430DLi`03O01oogoo02=oo`03001oogoo031oo`8Li`=00005A0100400@0140002
7>L04Dc7C>Q<adcXC<M<j4c77>M=;55=CBaAC4d/DDe=;55<CB`00g`09Woo00<007ooOol067oo00<0
07ooOol01goo0002Ool00`00Oomoo`0LOol4000HOol00`007>LLi`037>L300h00`0=00il000UOol0
0`00Oomoo`0_Ool00`00700H00047>L6@0000acWC<M<a`05C<L01acWCBaAC54/DDa=;55<009l02Uo
o`03001oogoo01Qoo`03001oogoo00Moo`000Woo00<007ooOol06Goo0`007Goo00/0000=00h03@0>
00d03P0=00h03G`002Eoo`03001oogoo02eoo`800004700H01`060037>L7O0027>L02DcXC<M<j4c7
C>Q<aacWCBaAC@03O00/Ool00`00Oomoo`0GOol00`00Oomoo`07Ool0009oo`03001oogoo01Eoo`@0
021oo`0300003P0=00<03P0500d03P0>00il000UOol00`00Oomoo`0/Ool77>L010007>LLig`01Woo
2g`0<7oo00<007ooOol05goo00<007ooOol01Woo00000goo001oo`0DOol3000UOol02P0000h03@0>
00d03P0=00h03G`09Goo00<007ooOol0:goo1P001AcW00=l07ooOol0?goo00<007ooOol05goo00<0
07ooOol01Woo00000goo001oo`0@Ool4000XOol0100000h03P0=0`0>00<03@0>O0009Goo00<007oo
Ool0:Woo10001QcW00<m]SfeO000@Woo00<007ooOol05Woo00<007ooOol01Woo00000goo001oo`0=
Ool3000]Ool02@0000d03P0=00h03@0>00el000UOol00`00Oomoo`0YOol200037>L02S5D7>LLicEe
?KE1]Sfe?KHm]G`0@Woo00<007ooOol05Goo00<007ooOol01Woo00000goo001oo`0:Ool3000`Ool0
1@007>LLi`0>00d00`0>00=l07ooOol08goo00<007ooOol0:7oo00<001cW7>L00S5e0QcW00Tm]Cff
?KDm]Sfe?KHm]AcWO000@Woo00<007ooOol05Goo00<007ooOol01Woo00000goo001oo`06Ool4000c
Ool02@0000l041cW00h03@0>00el000UOol00`00Oomoo`0WOol00`007>LeM@037>L01D6f?KDm]Sfe
@KH011cW00=1]7`0Ool0@Woo00<007ooOol057oo00<007ooOol01Woo00000`00Oomoo`03Ool3000h
Ool00`0000l03`027>L00`0=00il000UOol00`00Oomoo`0VOol02P00<GDLiacW?KHm]Cff?KDm]Sfe
0QcW0T6d00E5]46d@KA1]7`004=oo`03001oogoo01Aoo`03001oogoo00Eoo`0000<007oo00000`00
>goo00D0000@00l0400?008Li`03O01oogoo02=oo`03001oogoo02Eoo`08000LiacW?KDm]Sfe@KHm
]@<Li`09@KA5]46dAKE1]4Fd@KA5]G`004=oo`03001oogoo01Aoo`03001oogoo00Eoo`000P00?goo
00<0000?01000`0?00<047`0Ool08goo00<007ooOol09Goo0QcW00Dm]Sfe?KHm]Cff008Li`03@KA5
]46d0091]007AKA1]46d@KA5]1cWO000A7oo00<007ooOol04goo00<007ooOol01Goo00000goo0000
000nOol00`007>L0000400000g`0Oomoo`0ROol00`00Oomoo`0TOol01P00?KE1]Sfe?KHm]@8Li`09
AKA1]4Fe@KA5]46dAKE1]4Fd00<Li`03BI=l07oo04Aoo`03001oogoo019oo`03001oogoo00Eoo`00
0goo00<007ooOol0?7oo00<001cW00000`0000=l07ooOol08Woo00<007ooOol08goo00@003fe?KHm
]@<Li`=1]005AKA1]46d@KA5]0037>L01DFCAI95TdFCO000AGoo00<007ooOol04Woo00<007ooOol0
1Goo0004Ool00`00Oomoo`0kOol00`007>L0000300000g`0Oomoo`0ROol00`00Oomoo`0SOol02`00
@KHLiacW@KA5]D6dAKA1]4Fe@K@011cW00U9TdFBBI=5TTVCAI99TdFBO000AGoo00<007ooOol04Goo
00<007ooOol01Goo0005Ool2000kOol00acW010Li`0300000g`0Oomoo`0ROol00`00Oomoo`0ROol0
0`007>LLi`02@K@014Fd@KA1]46d0acW0TFC00E5TTFCAI=5TdFB00=5T`03AI95Tg`004Ioo`03001o
ogoo015oo`03001oogoo00Aoo`001goo00<007ooOol0>7oo00@001cW014Li`<00003O01oogoo025o
o`03001oogoo025oo`060015]D6dAKA1]4Fe11cW0115TTVCAI99TdFBBI=5TTVCAI99TdFBBI=5TTVC
AI9l04Ioo`03001oogoo015oo`03001oogoo00Aoo`0027oo0P00>Goo00@Li`0@010Li`800003O01o
ogoo025oo`03001oogoo025oo`030011]1cW00<Li`=5T`05AI95TdFCAI=5TP03AI<01DFBAI=5TdFC
AI800acW00=l07ooOol0AGoo00<007ooOol047oo00<007ooOol017oo000:Ool00`00Oomoo`0fOol0
1`007>L0400A7>L007`002=oo`03001oogoo021oo`0A000LiacWAI99TdFBBI=5TTVCAI99TdFBBI=5
TTVCAI99T`067>L014UaBI99LG`0B7oo00<007ooOol03goo00<007ooOol017oo000;Ool2000fOol0
1`0000lLi`0@7>L007`002=oo`03001oogoo021oo`050015TdFCAI=5TP03AI<00dFBAI<Li`067>L9
BI400g`0Oomoo`16Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool000eoo`03001oogoo03=oo`07000L
i`0?7>L041cWO0008goo00<007ooOol07goo00D004VCAI99TdFB00HLi`0ABI99LDVABG59TTUaBI59
LDVBBG59TDUaBI99LDVABG5l0019Ool00`00Oomoo`0>Ool00`00Oomoo`04Ool000ioo`03001oogoo
039oo`04001401cW7>L201000g`0Oomoo`0QOol00`00Oomoo`0OOol00`007>LLi`027>LEBI400g`0
Oomoo`19Ool00`00Oomoo`0>Ool00`00Oomoo`03Ool000moo`80039oo`0300140400008Li`03015l
07oo029oo`03001oogoo01moo`0K0019TTUaBI59LDVBBG59TDUaBI99LDVABG59TTUaBI59LDVBBG59
TDUaBI99LDVABG59TW`004]oo`03001oogoo00ioo`03001oogoo00=oo`004Goo00<007ooOol0;Woo
00D004@0A014000?008Li`03011l07oo025oo`03001oogoo01ioo`030019TDVA01Q9T@03O01oogoo
04Yoo`03001oogoo00eoo`03001oogoo00=oo`004Woo0P00;Woo00T004@0B01004@000lLi`0@O000
8Woo00<007ooOol07Woo00<001cW7>L061cW00=l07ooOol0Bgoo00<007ooOol037oo00<007ooOol0
0goo000DOol00`00Oomoo`0[Ool00`00A0140003A000100?7>L047`08Goo00<007ooOol07Woo00<0
04e`CG0064e`00=l07ooOol0Bgoo00<007ooOol037oo00<007ooOol00goo000EOol00`00Oomoo`0Z
Ool01@00@01404@0B0000T@00QcW00=l07ooOol07goo00<007ooOol07Goo01`004e`BFm=L4U`CG19
Kde`BG1=L4U_CG19L4e`BFm=L4U`CG19Kde`BG1=L4U_CG19L4e`BFml04moo`03001oogoo00]oo`03
001oogoo00=oo`005Woo0P00:Woo00<004@0@0001D@000<Lig`0Ool04Woo00<Lig`0Ool02goo00<0
07ooOol07Goo00@001cW7>LLiaM=L003O01oogoo04ioo`03001oogoo00]oo`03001oogoo009oo`00
67oo00<007ooOol09goo00L003`RA01004@0@0180002A0000acWO01oo`0>Ool37>L00g`0Oomoo`0;
Ool00`00Oomoo`0LOol01@00CFiAKde^CG0011cW01=9Kde`BG1=L4U_CG19L4e`BFm=L4U`CG19Kde`
BG1=L4U_CG1l001AOol00`00Oomoo`0;Ool00`00Oomoo`02Ool001Uoo`8002Moo`07000l8S`R@28l
8T@0@0000d@000=l01cWOol027oo21cW00=l07ooOol02goo00<007ooOol077oo00T0055_CFiAKde^
DFm=KU5_CFh011cW3Te`00=l07ooOol0D7oo00<007ooOol02Woo00<007ooOol00Woo000KOol00`00
Oomoo`0TOol02000>2DhAS`R@2<l8T0S@003A0000g`07>LLi`077>L022`4<0D/13Q6>2DhASPUO00>
Ool00`00Oomoo`0KOol03P00DFm=KU5_CFiAKde^DFm=KU5_CFiAKde^DFl57>L02Te`BFm=L4U`CG19
Kde`BG1=L7`0Dgoo00<007ooOol02Goo00<007ooOol00Woo000LOol00`00Oomoo`0TOol00`00>2Dh
9@04>2D01C`R@294000?O0000QcW00<l8QcW7>L02QcW00=l07ooOol037oo00@001cWO01l01Uoo`03
001AKAcW008Li`0?DFm=KU5_CFiAKde^DFm=KU5_CFiAKde^DFm=KU5_00HLi`9=L003O01oogoo05=o
o`03001oogoo00Qoo`03001oogoo009oo`007Goo0P0097oo00d002`5;0@`1B`4;0D/1305;0@/1B`4
O01400037>L00d00A00l8P047>L0140S?29l07`03Goo0acW00@if3Fg>MQl01Moo`06001EKE5=EFeA
CEE]0QcW01==KU5_CFiAKde^DFm=KU5_CFiAKde^DFm=KU5_CFiAKde^DFm=KP027>L00g`0Oomoo`1C
Ool00`00Oomoo`08Ool00`00Oomoo`02Ool001moo`03001oogoo029oo`800005;0@/1B`5;0D/1002
;0D2Ool017`0A00Lid@00QcW00M40400A01004@07>Ml000<Ool47>L01SFg>KLe]cFg7>Ml01Ioo`03
001AKE5]00IAK@<Li`0BCFiAKde^DFm=KU5_CFiAKde^DFm=KU5_CFiAKde^DFm=KW`0Egoo00<007oo
Ool027oo00<007ooOol00Goo000POol2000TOol00`00Oomoo`07Ool01G`0@00Lid@0B0000QcW00A0
04@0O01l00Yoo`DLi`04>MPe]cWH=KL27>L00bVH9GMl000COol2000035U<7>MEKE5=EFeACEE]DDeE
KE5=EFeAC@<Li`0?CFiAKde^DFm=KU5_CFiAKde^DFm=KU5_CFiAKg`005Qoo`03001oogoo00Moo`03
001oogoo005oo`008Woo00<007ooOol0;7oo0W`000@Lid@0A014009l00Uoo`DLi`04>KLe]cFg=KL3
7>L01REh9IPUN2FH9GQl00moo`<000AEB`8Li`]AK@8Li`0<DFm=KU5_CFiAKde^DFm=KU5_CFiAKg`0
FGoo00<007ooOol01goo00<007ooOol00Goo000SOol2000^Ool4O008Ool67>L00cFg>MPe]`037>L0
1bEg9IPUMbVH9GLUV2Eg008Li`03O01oogoo00Yoo`80000FFBQIBAcWFDaEBeE<ED]IC5E;7>MACEE]
DDeEKE5=EFeACEE]DDeEKE5=EFd37>L02E5_CFiAKde^DFm=KU5_CFil001JOol00`00Oomoo`06Ool0
0`00Oomoo`01Ool002Eoo`03001oogoo03Aoo`<Li`03@glLiacW00<e]`09>KLLiacW9GPUV2Eh9IPU
N2FH00@Li`041CP9>@ThO007Ool400001UTYFBQI:5TXFBTLi`IEB`8Li`eAK@<Li`05DFm=KU5_CFil
001LOol00`00Oomoo`05Ool00`00Oomoo`01Ool002Ioo`03001oogoo031oo`<Li`07Aim3OQcW7>Li
f3Fg>MP00acW00@UV2Eg:IPUM`@Li`092ET5>0UI1CP9F@Dh2ET5>7`00080000V7>L00000001Hhed4
F><LieTXFDUE:5U9FBQIBAcWFDaEBeE<ED]IC5E;ED`LieE]DDeEKE5=EFeACEE]DDeEKE5=EFeACEE]
DDeEK@8Li`03CFiAKg`005aoo`03001oogoo00Eoo`03001oogoo005oo`009goo0P00;Goo0acW0`00
0QcW0`000QcW10000acW0`001AcW00X9>0Ti1CP9>G`0E81DH5B07>MM0`=I0`05G@=I0acWFBQI:@03
FBP00eTY7>MEB`06ED/27>L?DFd00acWO01oo`1MOol00`00Oomoo`05Ool10001Ool1Ool002Uoo`03
001oogoo041oo`03001oogoo00=oo`DLi`0[O01DP51PE80Lied4F>=M15SSG@@LieU9FBQIBEDXFDUI
:5U97>MIC5E;EDaEBeU<ED]EC5E;7>MACEE]DDeEKE5=EFeACEE]DDeEKE5=EFeACEE]O000H7oo00<0
07ooOol017oo0@000Goo0Goo000ZOol20010Ool00`00Oomoo`07Ool27>L01W`0E81DH5B07>MM0`=I
0`05G@<LieTXFBQI:@03FBP00eTY7>MEB`07ED/27>L;DFd00g`0Oomoo`1OOol00`00Oomoo`04Ool1
0001Ool1Ool002aoo`03001oogoo03eoo`03001oogoo00Uoo`0X7>Ml05B0D61DP1cWG@AHhed4F>=M
11cWFDUI:5U9EBQIBETXFDTLieU<ED]EC5E;FDaEBeE<ED]IC1cWEFeACEE]DDeEKE5=EFeACEE]O01S
Ool00`00Oomoo`03Ool10001Ool1Ool002eoo`03001oogoo03aoo`03001oogoo00Yoo`077>Ml05B0
E61DP1cWG@<00eT300EM0acWFBQI:5TY00=I:003FBTLiacW00QEB`8Li`IAK@03O01oogoo06=oo`03
001oogoo009oo`40005oo`5oo`00;Woo0P00?7oo00<007ooOol02goo02@Lig`0E81@H1cWF>=M15SS
G@AHhed47>MIBETXFDUE:5U9FBQIBEDX7>MEBeE<ED]IC5E;EDaEBeU<ED/Lie5=EFeACEE]O01VOol0
0`00Oomoo`02Ool10001Ool1Ool0031oo`03001oogoo03Uoo`03001oogoo00eoo`06O01DP5AP7>MI
0ed30eT300EM0acWFBQI:5TY00=I:003FBUI:1cW00UEB`8Li`03DFel07oo06Moo`03001oogoo009o
o`40005oo`00<Goo0P00>Goo00<007ooOol03Woo0W`001]@H1cWF>=M15SSG@AHhed47>MIBETXFDUE
:5U9FBQIBEDX7>MEBeE<ED]IC5E;EDaEBeU<ED/00W`0JWoo00D007ooOomoo`00005oo`00<goo00<0
07ooOol0=Woo00<007ooOol047oo0W`000<LieT3G@<00eT300DLieTXFBQI:5TY00=I:003FBUI:1cW
00IEB`9l06aoo`05001oogooOol00001Ool003Aoo`03001oogoo03Eoo`03001oogoo019oo`9l000B
F>=M15SSG@AHhacWEBQIBETXFDUE:5U9FBQIBEDX7>MEBeE<0g`0Kgoo00@007ooOol0005oo`00=Goo
0P00=Goo00<007ooOol057oo0W`000EM0eT3F@=I0acW00=I:005FBUI:5TXFBQI:@03O01cOol00`00
Ool00001Ool003Moo`03001oogoo039oo`03001oogoo01Ioo`Al0005F><LieDXFDUI:004O01fOol0
0`00Ool00001Ool003Qoo`80039oo`03001oogoo01Yoo`El07]oo`40005oo`400000>Woo00<007oo
Ool0;goo00<007ooOol0Vgoo0P00000kOol2000_Ool00`00Oomoo`2KOol2000003eoo`03001oogoo
02]oo`03001oogoo09]oo`<00000?Woo00<007ooOol0:Woo00<007ooOol0UWoo1@000goo000oOol2
000ZOol00`00Oomoo`2AOol50008Ool0045oo`03001oogoo02Moo`03001oogoo08aoo`D000eoo`00
@Woo0P009goo00<007ooOol0Qgoo1@004Woo0014Ool00`00Oomoo`0TOol00`00Oomoo`22Ool5000G
Ool004Eoo`03001oogoo02=oo`03001oogoo07eoo`D001aoo`00AWoo0P008goo00<007ooOol0N7oo
1@008Goo0018Ool00`00Oomoo`0POol00`00Oomoo`1cOol5000VOol004Uoo`80021oo`03001oogoo
06ioo`D002]oo`00Bgoo00<007ooOol07Goo00<007ooOol0JGoo1@00<7oo001<Ool2000MOol00`00
Oomoo`1TOol5000eOol004ioo`03001oogoo01Yoo`03001oogoo05moo`D003Yoo`00Cgoo00<007oo
Ool06Goo00<007ooOol0FWoo1@00?goo001@Ool2000IOol00`00Oomoo`1EOol50014Ool0059oo`03
001oogoo01Ioo`03001oogoo051oo`D004Uoo`00Dgoo0P005Woo00<007ooOol0BWoo1P00CWoo001E
Ool00`00Oomoo`0COol00`00Oomoo`15Ool5001DOol005Ioo`03001oogoo019oo`03001oogoo041o
o`D005Uoo`00Egoo0P004Woo00<007ooOol0>goo1@00GWoo001IOol00`00Oomoo`0?Ool00`00Oomo
o`0fOol5001SOol005Yoo`8000moo`03001oogoo035oo`D006Qoo`00G7oo00<007ooOol02goo00<0
07ooOol0;Goo1@00KGoo001MOol00`00Oomoo`0:Ool00`00Oomoo`0XOol5001bOol005ioo`8000Yo
o`03001oogoo02=oo`D007Moo`00H7oo00<007ooOol01goo00<007ooOol07Woo1@00O7oo001QOol2
0007Ool00`00Oomoo`0IOol50021Ool006=oo`03001oogoo00Aoo`03001oogoo01Aoo`D008Ioo`00
I7oo0P0017oo00<007ooOol03goo1@00Rgoo001VOol01@00Oomoogoo000037oo1@00T7oo001WOol0
1000Oomoo`001goo1@00UGoo001XOol30002Ool5002JOol006Yoo`<009moo`00
\>"],
  ImageRangeCache->{{{0, 267.813}, {287, 0}} -> {0.0381793, -0.000144876, 
  0.00322013, 0.00322013}}]
}, Open]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator] Graphics3D \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(clear; top = 100; kappa[s_] := 0.6\ Cos[s]; tau[s_] := 0.6\ Sin[s]; \), 
  
    \(ds := N[\(12\ \[Pi]\)\/top]; width = 5.5; pribbonfrenet\)}], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 -1.11022e-016 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.34433 .44409 m .36135 .45572 L .3378 .45553 L .423 0 0 r
F
.48434 .44897 m .57465 .56092 L .53046 .58806 L .802 .764 .818 r
F
.33322 .46822 m .42695 .54864 L .3296 .48153 L .659 .721 .895 r
F
.48146 .55369 m .53046 .58806 L .49073 .61388 L .864 .785 .771 r
F
.4426 .61646 m .45123 .57357 L .45662 .63319 L .757 .744 .841 r
F
.44094 .50988 m .44964 .54636 L .43924 .52737 L .998 .821 .541 r
F
.44267 .49199 m .44533 .51275 L .44094 .50988 L F
.44533 .51275 m .44964 .54636 L .44094 .50988 L F
.44965 .45374 m .47596 .54817 L .45702 .57155 L .932 .81 .701 r
F
.44769 .42243 m .45321 .44696 L .44965 .45374 L F
.45321 .44696 m .47596 .54817 L .44965 .45374 L F
.41979 .4233 m .42749 .49352 L .40553 .42225 L .745 .546 0 r
F
.42749 .49352 m .42953 .51218 L .41615 .48405 L F
.42953 .51218 m .42004 .50665 L .41615 .48405 L F
.42749 .49352 m .41615 .48405 L .40553 .42225 L F
.41986 .49574 m .42558 .49965 L .42032 .49813 L .423 0 0 r
F
.41986 .49574 m .42032 .49813 L .41928 .49782 L F
.41862 .49489 m .41986 .49574 L .41928 .49782 L F
.43925 .52979 m .43185 .52977 L .43097 .52201 L .998 .821 .541 r
F
.43872 .52688 m .43097 .52201 L .41979 .4233 L F
.43911 .52713 m .43895 .52704 L .41979 .4233 L F
.43727 .52598 m .43911 .52713 L .43924 .52737 L .428 .652 .953 r
F
.43727 .52598 m .43924 .52737 L .43917 .52818 L F
.43917 .52818 m .43889 .52786 L .43872 .52688 L .998 .821 .541 r
F
.43895 .52704 m .43872 .52688 L .41979 .4233 L F
.43917 .52818 m .43872 .52688 L .43895 .52704 L F
.43391 .42371 m .43911 .52713 L .41979 .4233 L F
.43583 .46192 m .44267 .49199 L .43917 .52818 L F
.43391 .42371 m .4372 .44931 L .43583 .46192 L F
.4372 .44931 m .44267 .49199 L .43583 .46192 L F
.41562 .51064 m .42966 .51304 L .43087 .52135 L .428 .652 .953 r
F
.42837 .50154 m .43083 .52091 L .42849 .50271 L .745 .546 0 r
F
.43083 .52091 m .43097 .52201 L .43084 .52097 L F
.43083 .52091 m .43084 .52097 L .42849 .50271 L F
.3378 .45553 m .43089 .52146 L .33322 .46822 L .428 .652 .953 r
F
.42847 .50155 m .43097 .52201 L .42837 .50154 L .745 .546 0 r
F
.42587 .47833 m .43097 .52201 L .42749 .49352 L F
.42351 .45615 m .42544 .47315 L .42587 .47833 L F
.42544 .47315 m .43097 .52201 L .42587 .47833 L F
.42558 .49965 m .42834 .50154 L .42208 .50632 L .423 0 0 r
F
.43097 .52201 m .43042 .51828 L .42849 .50271 L .745 .546 0 r
F
.42849 .50271 m .42978 .51391 L .42953 .51218 L F
.43089 .52146 m .431 .5225 L .33322 .46822 L .428 .652 .953 r
F
.41562 .51064 m .43087 .52135 L .43089 .52146 L F
.42695 .54864 m .43516 .55568 L .41707 .54772 L .659 .721 .895 r
F
.43516 .55568 m .45155 .56974 L .43558 .55955 L F
.43516 .55568 m .43558 .55955 L .41707 .54772 L F
.45155 .56974 m .45148 .5705 L .43563 .56001 L F
.43558 .55955 m .43563 .56001 L .41707 .54772 L F
.45155 .56974 m .43563 .56001 L .43558 .55955 L F
.42953 .51218 m .42966 .51304 L .41562 .51064 L .428 .652 .953 r
F
.431 .5225 m .43176 .52954 L .33322 .46822 L F
.36992 .52967 m .43584 .56193 L .4426 .61646 L .757 .744 .841 r
F
.39327 .52971 m .43584 .56193 L .36992 .52967 L F
.45155 .56974 m .4548 .58663 L .45125 .57334 L .998 .821 .541 r
F
.45197 .56457 m .45324 .57446 L .45155 .56974 L F
.45324 .57446 m .4548 .58663 L .45155 .56974 L F
.45702 .57155 m .49073 .61388 L .48038 .62113 L .932 .81 .701 r
F
.46002 .58174 m .48038 .62113 L .47313 .62621 L F
.45702 .57155 m .48038 .62113 L .46002 .58174 L F
.45702 .57155 m .47313 .62621 L .45795 .58639 L F
.47596 .54817 m .49073 .61388 L .45702 .57155 L F
.4607 .41884 m .49073 .61388 L .44769 .42243 L .864 .785 .771 r
F
.45702 .57155 m .45733 .57653 L .45644 .57075 L .932 .81 .701 r
F
.45733 .57653 m .45795 .58639 L .45324 .57446 L F
.45795 .58639 m .4548 .58663 L .45324 .57446 L F
.43925 .52979 m .43958 .53648 L .43185 .52977 L .998 .821 .541 r
F
.43516 .55568 m .43828 .53593 L .45155 .56974 L .659 .721 .895 r
F
.43828 .53593 m .43958 .53648 L .45155 .56974 L F
.41305 .53672 m .43176 .52954 L .43516 .55568 L F
.33322 .46822 m .4176 .52073 L .41305 .53672 L F
.4176 .52073 m .43176 .52954 L .41305 .53672 L F
.43958 .53648 m .43225 .53335 L .43185 .52977 L .998 .821 .541 r
F
.43185 .52977 m .43225 .53335 L .42978 .51391 L .745 .546 0 r
F
.43563 .56001 m .43584 .56193 L .41707 .54772 L .659 .721 .895 r
F
.37241 .5824 m .45662 .63319 L .41748 .66705 L .822 .762 .796 r
F
.38055 .55413 m .45662 .63319 L .37241 .5824 L F
.33025 .49952 m .45662 .63319 L .32865 .50018 L F
.3296 .48153 m .45662 .63319 L .32578 .49479 L .757 .744 .841 r
F
.43225 .53335 m .44515 .64718 L .43021 .51765 L .745 .546 0 r
F
.43225 .53335 m .43021 .51765 L .42978 .51391 L F
.43185 .52977 m .42978 .51391 L .43042 .51828 L F
.43097 .52201 m .43185 .52977 L .43042 .51828 L F
.43176 .52954 m .43862 .53381 L .43516 .55568 L .659 .721 .895 r
F
.43584 .56193 m .45123 .57357 L .4426 .61646 L .757 .744 .841 r
F
.44233 .59117 m .44515 .6472 L .43668 .57242 L .998 .821 .541 r
F
.45145 .57086 m .45123 .57357 L .43584 .56193 L .659 .721 .895 r
F
.45733 .57653 m .45324 .57446 L .43391 .42371 L .932 .81 .701 r
F
.45148 .5705 m .43584 .56193 L .43563 .56001 L .659 .721 .895 r
F
.45564 .57325 m .45145 .57086 L .45148 .5705 L F
.45145 .57086 m .43584 .56193 L .45148 .5705 L F
.44515 .64718 m .46097 .63472 L .44515 .6472 L .998 .821 .541 r
F
.43925 .52979 m .4504 .58365 L .44515 .64718 L F
.4538 .57552 m .4712 .62116 L .46553 .62584 L .757 .744 .841 r
F
.45424 .58458 m .46553 .62584 L .45662 .63319 L F
.45125 .57334 m .4548 .58663 L .45123 .57357 L .998 .821 .541 r
F
.4538 .57552 m .46553 .62584 L .45424 .58458 L .757 .744 .841 r
F
.45123 .57357 m .45424 .58458 L .45662 .63319 L F
.4504 .58365 m .46097 .63472 L .44515 .64718 L .998 .821 .541 r
F
.43917 .52818 m .45125 .57334 L .43925 .52979 L F
.45125 .57334 m .45123 .57357 L .43925 .52979 L F
.45564 .57325 m .4538 .57552 L .45123 .57357 L .659 .721 .895 r
F
.45564 .57325 m .45123 .57357 L .45145 .57086 L F
.44233 .59117 m .43668 .57242 L .43225 .53335 L .998 .821 .541 r
F
.43958 .53648 m .44233 .59117 L .43225 .53335 L F
.43021 .51765 m .44515 .64718 L .42974 .51401 L .745 .546 0 r
F
.42953 .51218 m .43473 .55717 L .44455 .64922 L F
.43473 .55717 m .44515 .64718 L .44462 .64897 L F
.43473 .55717 m .44462 .64897 L .44455 .64922 L F
.44515 .64718 m .44515 .6472 L .44515 .6472 L F
.44515 .64718 m .44515 .6472 L .44455 .64922 L F
.44515 .64718 m .44515 .6472 L .44515 .64718 L F
.44515 .64718 m .44515 .64718 L .42978 .51391 L F
.42004 .50665 m .42953 .51218 L .41562 .51064 L .428 .652 .953 r
F
.43042 .51828 m .42978 .51391 L .42849 .50271 L .745 .546 0 r
F
.41862 .49489 m .42004 .50665 L .42108 .50572 L .162 .196 .649 r
F
.41615 .48405 m .41793 .49441 L .41862 .49489 L F
.41793 .49441 m .42004 .50665 L .41862 .49489 L F
.43059 .51277 m .43158 .51337 L .43061 .51281 L .428 .652 .953 r
F
.43059 .51277 m .43061 .51281 L .42004 .50665 L F
.43059 .51277 m .42004 .50665 L .42005 .50664 L F
.40348 .49613 m .43059 .51277 L .40176 .49601 L F
.34488 .45989 m .40365 .49615 L .34113 .45788 L F
.40365 .49615 m .43158 .51337 L .40348 .49613 L F
.40365 .49615 m .40348 .49613 L .34113 .45788 L F
.42835 .5016 m .43134 .50359 L .42864 .50439 L .423 0 0 r
F
.42834 .50154 m .42864 .50439 L .42208 .50632 L F
.42558 .49965 m .42208 .50632 L .39743 .49147 L F
.41862 .49489 m .42357 .49842 L .43134 .50359 L F
.42357 .49842 m .42512 .49952 L .42643 .50038 L F
.42357 .49842 m .42643 .50038 L .43134 .50359 L F
.41615 .48405 m .41693 .48747 L .41714 .48782 L .162 .196 .649 r
F
.41693 .48747 m .42108 .50572 L .41714 .48782 L F
.41714 .48782 m .42108 .50572 L .42169 .50516 L F
.40735 .4316 m .41615 .48405 L .42169 .50516 L F
.40553 .42225 m .40672 .42921 L .40735 .4316 L F
.40672 .42921 m .41615 .48405 L .40735 .4316 L F
.42018 .48409 m .42169 .50516 L .42456 .50258 L F
.40553 .42225 m .41604 .47618 L .42018 .48409 L F
.41604 .47618 m .42169 .50516 L .42018 .48409 L F
.42018 .48409 m .42357 .49842 L .41062 .47708 L F
.42357 .49842 m .42456 .50258 L .42137 .49691 L F
.40603 .48628 m .41862 .49489 L .39743 .49147 L .423 0 0 r
F
.41862 .49489 m .41928 .49782 L .39743 .49147 L F
.36135 .45572 m .40603 .48628 L .34007 .45689 L F
.40603 .48628 m .39743 .49147 L .34007 .45689 L F
.40194 .48348 m .41844 .4949 L .41862 .49489 L F
.42456 .50258 m .41197 .49046 L .42137 .49691 L .162 .196 .649 r
F
.41844 .4949 m .42512 .49952 L .42357 .49842 L .423 0 0 r
F
.41844 .4949 m .42357 .49842 L .41862 .49489 L F
.42456 .50258 m .4139 .49687 L .41197 .49046 L .162 .196 .649 r
F
.41557 .49297 m .42512 .49952 L .40194 .48348 L .423 0 0 r
F
.42137 .49691 m .41197 .49046 L .40527 .46826 L .162 .196 .649 r
F
.42357 .49842 m .42137 .49691 L .40527 .46826 L F
.40527 .46826 m .40717 .47454 L .41025 .47813 L .536 .461 .718 r
F
.40717 .47454 m .41197 .49046 L .4103 .47852 L F
.40717 .47454 m .4103 .47852 L .41025 .47813 L F
.41139 .48125 m .42205 .48768 L .41159 .48181 L .846 .471 .34 r
F
.41197 .49046 m .4112 .48074 L .41025 .47813 L .536 .461 .718 r
F
.36481 .44347 m .41047 .47873 L .34626 .44203 L .846 .471 .34 r
F
.41047 .47873 m .42205 .48768 L .41139 .48125 L F
.41197 .49046 m .41294 .49114 L .4112 .48074 L .536 .461 .718 r
F
.44769 .42243 m .45702 .57155 L .43391 .42371 L .932 .81 .701 r
F
.45702 .57155 m .45644 .57075 L .43391 .42371 L F
.43134 .50359 m .47647 .53446 L .43057 .51071 L .423 0 0 r
F
.43134 .50359 m .43057 .51071 L .42208 .50632 L F
.46556 .4504 m .51576 .55686 L .48146 .55369 L .864 .785 .771 r
F
.51576 .55686 m .53046 .58806 L .48146 .55369 L F
.47209 .44647 m .53046 .58806 L .46556 .4504 L F
.47234 .41278 m .53046 .58806 L .4607 .41884 L .802 .764 .818 r
F
.4305 .51139 m .53364 .57356 L .44035 .52792 L .428 .652 .953 r
F
.47647 .53446 m .53364 .57356 L .49639 .55111 L .423 0 0 r
F
.47647 .53446 m .49639 .55111 L .42208 .50632 L F
.43924 .52737 m .53364 .57356 L .51854 .58354 L .428 .652 .953 r
F
.42819 .50153 m .45288 .5185 L .43134 .50359 L .423 0 0 r
F
.45288 .5185 m .53524 .57509 L .46579 .5273 L F
.45288 .5185 m .46579 .5273 L .43134 .50359 L F
.42508 .4995 m .42802 .50152 L .42819 .50153 L F
.42802 .50152 m .53524 .57509 L .42819 .50153 L F
.42749 .49352 m .42847 .50155 L .42837 .50154 L .745 .546 0 r
F
.42045 .42928 m .42351 .45615 L .42749 .49352 L F
.41979 .4233 m .42017 .42665 L .42045 .42928 L F
.42017 .42665 m .42351 .45615 L .42045 .42928 L F
.42205 .48768 m .42697 .49147 L .42517 .49956 L .846 .471 .34 r
F
.43134 .50359 m .53524 .57509 L .53364 .57356 L .423 0 0 r
F
.42697 .49147 m .53524 .57509 L .42802 .50152 L .846 .471 .34 r
F
.42697 .49147 m .42802 .50152 L .42517 .49956 L F
.41557 .49297 m .42508 .4995 L .42512 .49952 L .423 0 0 r
F
.41568 .49305 m .42508 .4995 L .41557 .49297 L F
.42205 .48768 m .42517 .49956 L .41568 .49305 L .846 .471 .34 r
F
.42205 .48768 m .41568 .49305 L .41159 .48181 L F
.41047 .47873 m .42753 .49815 L .42205 .48768 L F
.4112 .48074 m .41793 .49715 L .41417 .48342 L .536 .461 .718 r
F
.42194 .49327 m .42753 .49815 L .41047 .47873 L .846 .471 .34 r
F
.41543 .46403 m .42018 .48409 L .40527 .46826 L .162 .196 .649 r
F
.42018 .48409 m .41062 .47708 L .40527 .46826 L F
.41543 .46403 m .40527 .46826 L .39128 .42186 L F
.41097 .47937 m .41417 .48342 L .4077 .45983 L .536 .461 .718 r
F
.4112 .48074 m .41417 .48342 L .41097 .47937 L F
.4139 .49687 m .41716 .4971 L .4112 .48074 L F
.41716 .4971 m .41793 .49715 L .4112 .48074 L F
.41197 .49046 m .4139 .49687 L .41294 .49114 L F
.36135 .45572 m .34007 .45689 L .3378 .45553 L .423 0 0 r
F
.37462 .4648 m .41557 .49297 L .40194 .48348 L F
.34433 .44409 m .39198 .47678 L .37462 .4648 L F
.39198 .47678 m .41557 .49297 L .37462 .4648 L F
.45795 .58639 m .49173 .60422 L .4712 .62116 L .757 .744 .841 r
F
.4538 .57552 m .46723 .58568 L .45795 .58639 L F
.46723 .58568 m .49173 .60422 L .45795 .58639 L F
.45564 .57325 m .46251 .57916 L .4538 .57552 L .659 .721 .895 r
F
.46251 .57916 m .49173 .60422 L .46723 .58568 L F
.46251 .57916 m .46723 .58568 L .4538 .57552 L F
.45564 .57325 m .51854 .58354 L .49977 .59802 L F
.46251 .57916 m .49977 .59802 L .49173 .60422 L F
.45564 .57325 m .49977 .59802 L .46251 .57916 L F
.45409 .57027 m .51854 .58354 L .45564 .57325 L F
.43924 .52737 m .45197 .56457 L .43917 .52818 L .998 .821 .541 r
F
.44964 .54636 m .45197 .56457 L .43924 .52737 L F
.45197 .56457 m .45125 .57334 L .43917 .52818 L F
.4548 .58663 m .46097 .63472 L .43925 .52979 L F
.43862 .53381 m .51854 .58354 L .45155 .56974 L .659 .721 .895 r
F
.43925 .52979 m .43097 .52201 L .43872 .52688 L .998 .821 .541 r
F
.43917 .52818 m .43925 .52979 L .43889 .52786 L F
.43727 .52598 m .45024 .54104 L .43176 .52954 L .428 .652 .953 r
F
.42776 .50094 m .524 .5867 L .42697 .49147 L .846 .471 .34 r
F
.43917 .52818 m .51854 .58354 L .45024 .54104 L .428 .652 .953 r
F
.43924 .52737 m .51854 .58354 L .43917 .52818 L F
.34433 .44409 m .41568 .49305 L .41557 .49297 L .423 0 0 r
F
.41159 .48181 m .41568 .49305 L .34433 .44409 L .846 .471 .34 r
F
.41047 .47873 m .41139 .48125 L .34626 .44203 L F
.41025 .47813 m .4112 .48074 L .4077 .45983 L .536 .461 .718 r
F
.42243 .4939 m .41793 .49715 L .42403 .49759 L F
.42194 .49327 m .42243 .4939 L .42753 .49815 L .846 .471 .34 r
F
.42243 .4939 m .42774 .50063 L .42754 .49823 L F
.42243 .4939 m .42754 .49823 L .42753 .49815 L F
.40839 .46141 m .41417 .48342 L .42243 .4939 L .536 .461 .718 r
F
.4077 .45983 m .40787 .46046 L .40839 .46141 L F
.40787 .46046 m .41417 .48342 L .40839 .46141 L F
.40589 .46614 m .41025 .47813 L .4077 .45983 L F
.39128 .42186 m .40527 .46826 L .4077 .45983 L F
.39128 .42186 m .40839 .46141 L .37739 .42336 L F
.40527 .46826 m .41025 .47813 L .40589 .46614 L F
.40839 .46141 m .42243 .4939 L .39593 .45238 L F
.40839 .46141 m .39593 .45238 L .37739 .42336 L F
.41417 .48342 m .41793 .49715 L .42243 .4939 L F
.4203 .50642 m .4305 .51139 L .43158 .51337 L .428 .652 .953 r
F
.42108 .50572 m .4305 .51139 L .4203 .50642 L F
.42953 .51218 m .44455 .64922 L .42004 .50665 L .745 .546 0 r
F
.42169 .50516 m .45252 .64402 L .45732 .64088 L .162 .196 .649 r
F
.42108 .50572 m .45252 .64402 L .42169 .50516 L F
.42005 .50664 m .42004 .50665 L .40176 .49601 L .428 .652 .953 r
F
.42143 .50727 m .42659 .53897 L .4349 .56652 L .162 .196 .649 r
F
.42659 .53897 m .44455 .64922 L .4349 .56652 L F
.4349 .56652 m .44455 .64922 L .45252 .64402 L F
.42108 .50572 m .42137 .50749 L .42143 .50727 L F
.42137 .50749 m .44455 .64922 L .42143 .50727 L F
.42004 .50665 m .44455 .64922 L .42108 .50572 L F
.36357 .47377 m .42004 .50665 L .41562 .51064 L .428 .652 .953 r
F
.42456 .50258 m .42169 .50516 L .45732 .64088 L .162 .196 .649 r
F
.37443 .47812 m .42108 .50572 L .4203 .50642 L .428 .652 .953 r
F
.3378 .45553 m .37657 .47889 L .37443 .47812 L F
.37657 .47889 m .42108 .50572 L .37443 .47812 L F
.42456 .50258 m .45732 .64088 L .4139 .49687 L .162 .196 .649 r
F
.4139 .49687 m .45732 .64088 L .41793 .49715 L .536 .461 .718 r
F
.43828 .53593 m .43862 .53381 L .43958 .53648 L .659 .721 .895 r
F
.42978 .51391 m .43021 .51765 L .42953 .51218 L .745 .546 0 r
F
.43021 .51765 m .42974 .51401 L .42953 .51218 L F
.45795 .58639 m .46097 .63472 L .4548 .58663 L .932 .81 .701 r
F
.45155 .56974 m .45409 .57027 L .45564 .57325 L .659 .721 .895 r
F
.43727 .52598 m .43176 .52954 L .431 .5225 L .428 .652 .953 r
F
.42953 .51218 m .43158 .51337 L .42966 .51304 L F
.43089 .52146 m .43727 .52598 L .431 .5225 L F
.43089 .52146 m .43911 .52713 L .43727 .52598 L F
.43087 .52135 m .43911 .52713 L .43089 .52146 L F
.43087 .52135 m .43158 .51337 L .43911 .52713 L F
.42966 .51304 m .43158 .51337 L .43087 .52135 L F
.45155 .56974 m .45564 .57325 L .45148 .5705 L .659 .721 .895 r
F
.45123 .57357 m .4538 .57552 L .45424 .58458 L .757 .744 .841 r
F
.45795 .58639 m .47313 .62621 L .46097 .63472 L .932 .81 .701 r
F
.42481 .4994 m .45732 .64088 L .47897 .62466 L .536 .461 .718 r
F
.42403 .49759 m .42438 .4991 L .42481 .4994 L F
.42438 .4991 m .45732 .64088 L .42481 .4994 L F
.41793 .49715 m .45732 .64088 L .42403 .49759 L F
.42243 .4939 m .47897 .62466 L .40592 .47989 L F
.34626 .44203 m .41139 .48125 L .34433 .44409 L .846 .471 .34 r
F
.41139 .48125 m .41159 .48181 L .34433 .44409 L F
.40193 .47583 m .40534 .47929 L .42194 .49327 L F
.40592 .47989 m .41096 .48988 L .41853 .49271 L .691 .543 .68 r
F
.40592 .47989 m .42774 .50063 L .42243 .4939 L .846 .471 .34 r
F
.39047 .46677 m .41442 .48854 L .40592 .47989 L F
.41442 .48854 m .42774 .50063 L .40592 .47989 L F
.39047 .46677 m .42243 .4939 L .42194 .49327 L F
.38682 .46047 m .42194 .49327 L .41047 .47873 L F
.40193 .47583 m .42194 .49327 L .38682 .46047 L F
.42243 .4939 m .41603 .48847 L .3807 .42853 L .536 .461 .718 r
F
.416 .48844 m .40592 .47989 L .37739 .42336 L F
.36481 .44347 m .42776 .50094 L .42774 .50063 L .846 .471 .34 r
F
.41853 .49271 m .42093 .49676 L .41856 .49274 L .691 .543 .68 r
F
.41853 .49271 m .41096 .48988 L .42093 .49676 L F
.35326 .43455 m .36481 .44347 L .34626 .44203 L .846 .471 .34 r
F
.3561 .43708 m .42776 .50094 L .36481 .44347 L F
.40185 .4646 m .41853 .49271 L .40241 .46536 L .691 .543 .68 r
F
.41853 .49271 m .41856 .49274 L .37908 .42578 L F
.42205 .48768 m .42753 .49815 L .42697 .49147 L .846 .471 .34 r
F
.42697 .49147 m .524 .5867 L .53524 .57509 L F
.41988 .48281 m .524 .5867 L .43132 .50411 L .788 .557 .587 r
F
.40245 .46542 m .43132 .50411 L .41856 .49274 L F
.40245 .46542 m .43381 .50874 L .41988 .48281 L F
.43381 .50874 m .50338 .60487 L .41988 .48281 L F
.37908 .42578 m .40245 .46542 L .43516 .50658 L .691 .543 .68 r
F
.40245 .46542 m .41856 .49274 L .4278 .50044 L F
.40245 .46542 m .4278 .50044 L .43516 .50658 L F
.43216 .50451 m .47897 .62466 L .43516 .50658 L F
.43516 .50658 m .47897 .62466 L .50338 .60487 L F
.44628 .53197 m .50338 .60487 L .43381 .50874 L .788 .557 .587 r
F
.41856 .49274 m .42093 .49676 L .42586 .50016 L .691 .543 .68 r
F
.41856 .49274 m .42586 .50016 L .43516 .50658 L F
.43911 .52713 m .44035 .52792 L .43924 .52737 L .428 .652 .953 r
F
.4305 .51139 m .44035 .52792 L .43911 .52713 L F
.43911 .52713 m .43917 .52818 L .43895 .52704 L .998 .821 .541 r
F
.41516 .49278 m .47897 .62466 L .43216 .50451 L .691 .543 .68 r
F
.37739 .42336 m .40592 .47989 L .41853 .49271 L F
.36448 .42753 m .40245 .46542 L .35326 .43455 L .788 .557 .587 r
F
.36481 .44347 m .39047 .46677 L .40534 .47929 L .846 .471 .34 r
F
.36481 .44347 m .40534 .47929 L .40193 .47583 L F
.36481 .44347 m .40193 .47583 L .38682 .46047 L F
.35326 .43455 m .3561 .43708 L .36481 .44347 L F
.40245 .46542 m .41856 .49274 L .35326 .43455 L .788 .557 .587 r
F
.372 .43504 m .44628 .53197 L .43381 .50874 L F
.372 .43504 m .43381 .50874 L .40245 .46542 L F
.37739 .42336 m .40185 .4646 L .37908 .42578 L .691 .543 .68 r
F
.40185 .4646 m .40241 .46536 L .37908 .42578 L F
.41096 .48988 m .41182 .49158 L .41516 .49278 L F
.41182 .49158 m .47897 .62466 L .41516 .49278 L F
.36448 .42753 m .3682 .43228 L .372 .43504 L .788 .557 .587 r
F
.3682 .43228 m .44628 .53197 L .372 .43504 L F
.41988 .48281 m .50338 .60487 L .524 .5867 L F
.34113 .45788 m .40348 .49613 L .36357 .47377 L .428 .652 .953 r
F
.40348 .49613 m .40176 .49601 L .36357 .47377 L F
.3378 .45553 m .34488 .45989 L .34113 .45788 L F
.32865 .50018 m .38055 .55413 L .37241 .5824 L .822 .762 .796 r
F
.32578 .49479 m .33025 .49952 L .32865 .50018 L F
.40553 .42225 m .41543 .46403 L .39128 .42186 L .162 .196 .649 r
F
.3296 .48153 m .39327 .52971 L .36992 .52967 L .757 .744 .841 r
F
.42695 .54864 m .41707 .54772 L .3296 .48153 L .659 .721 .895 r
F
.4607 .41884 m .47209 .44647 L .46556 .4504 L .864 .785 .771 r
F
.47234 .41278 m .49686 .44829 L .48434 .44897 L .802 .764 .818 r
F
.49686 .44829 m .57465 .56092 L .48434 .44897 L F
.48202 .40438 m .57465 .56092 L .47234 .41278 L .735 .744 .859 r
F
.25 g
.5 Mabswid
.47234 .41278 m
.474 .41518 L
s
.48202 .40438 m .6174 .53575 L .57465 .56092 L .735 .744 .859 r
F
1 0 0 r
.003 w
.54432 .57955 m
.57465 .56092 L
s
.53046 .58806 m
.54432 .57955 L
s
.25 g
.5 Mabswid
.4607 .41884 m
.47209 .44647 L
s
.51768 .55704 m
.52023 .56324 L
s
.52023 .56324 m
.52039 .56362 L
s
.52814 .58242 m
.53046 .58806 L
s
1 0 0 r
.003 w
.49844 .60887 m
.53046 .58806 L
s
.48956 .39404 m .6174 .53575 L .48202 .40438 L .648 .719 .9 r
F
.25 g
.5 Mabswid
.47209 .44647 m
.48947 .48862 L
s
.56673 .47958 m .65332 .51529 L .6174 .53575 L .648 .719 .9 r
F
.57016 .45372 m .65332 .51529 L .56673 .47958 L F
.49533 .38231 m .65332 .51529 L .48956 .39404 L .493 .669 .942 r
F
.60502 .34245 m .67087 .4908 L .59473 .34051 L .716 .748 .877 r
F
.66861 .49675 m .67797 .50176 L .66373 .50958 L .493 .669 .942 r
F
.57921 .43717 m .61616 .46134 L .56617 .44194 L F
.61616 .46134 m .62058 .46899 L .56617 .44194 L F
.65094 .48408 m .6549 .48942 L .56617 .44194 L F
.56617 .44194 m .66861 .49675 L .65332 .51529 L F
.50387 .38951 m .57921 .43717 L .56617 .44194 L F
.49533 .38231 m .5063 .38949 L .50387 .38951 L F
.5063 .38949 m .57921 .43717 L .50387 .38951 L F
.57164 .33279 m .57447 .38912 L .56004 .32874 L .962 .828 .665 r
F
.50022 .36986 m .67797 .50176 L .49533 .38231 L .093 .483 .896 r
F
.52988 .39187 m .575 .42121 L .57798 .42756 L F
.53944 .3968 m .59944 .43709 L .52988 .39187 L F
.51182 .37769 m .59885 .43642 L .50857 .37606 L F
.59885 .43642 m .59944 .43709 L .50857 .37606 L F
.57798 .42756 m .59944 .43709 L .61524 .45522 L F
.575 .42121 m .59944 .43709 L .57798 .42756 L F
.59523 .42593 m .61763 .44298 L .59877 .43124 L .697 .161 0 r
F
.67087 .4908 m .67047 .49184 L .59473 .34051 L .716 .748 .877 r
F
.61763 .44298 m .62897 .45161 L .61745 .44897 L .697 .161 0 r
F
.62739 .45568 m .6282 .45642 L .61817 .44968 L .093 .483 .896 r
F
.62897 .45161 m .67304 .49697 L .62739 .45568 L .798 .772 .829 r
F
.6383 .42758 m .6603 .47152 L .62897 .45161 L F
.6603 .47152 m .67304 .49697 L .62897 .45161 L F
.61763 .44298 m .61745 .44897 L .50022 .36986 L .697 .161 0 r
F
.61182 .4396 m .61329 .44491 L .60972 .43837 L .875 .798 .771 r
F
.50531 .35748 m .59523 .42593 L .50022 .36986 L .697 .161 0 r
F
.59523 .42593 m .59877 .43124 L .50022 .36986 L F
.57259 .40935 m .58622 .42264 L .59514 .42673 L F
.51409 .36424 m .57077 .4102 L .57259 .40935 L F
.5189 .36842 m .57077 .4102 L .51409 .36424 L F
.57084 .41016 m .58622 .42264 L .57259 .40935 L F
.57077 .4102 m .57295 .41195 L .57084 .41016 L F
.57295 .41195 m .58622 .42264 L .57084 .41016 L F
.58622 .42264 m .59539 .43002 L .59514 .42673 L F
.57591 .4179 m .6029 .54408 L .58283 .55576 L .962 .828 .665 r
F
.57313 .4091 m .596 .42713 L .59523 .42593 L .697 .161 0 r
F
.57259 .40935 m .59514 .42673 L .57313 .4091 L F
.59514 .42673 m .61182 .4396 L .596 .42713 L F
.59514 .42673 m .596 .42713 L .57313 .4091 L F
.596 .42713 m .61182 .4396 L .59755 .42784 L F
.596 .42713 m .59755 .42784 L .59523 .42593 L F
.50531 .35748 m .57259 .40935 L .57313 .4091 L F
.50531 .35748 m .5189 .36842 L .51409 .36424 L F
.59514 .42673 m .59539 .43002 L .61182 .4396 L F
.59523 .42593 m .61182 .4396 L .61763 .44298 L F
.61524 .45522 m .63577 .4669 L .65083 .48162 L .093 .483 .896 r
F
.61745 .44897 m .62739 .45568 L .61817 .44968 L F
.62897 .45161 m .62739 .45568 L .61745 .44897 L .697 .161 0 r
F
.61779 .44451 m .61847 .44761 L .61333 .44084 L .798 .772 .829 r
F
.60499 .44056 m .61745 .44897 L .60358 .43982 L .093 .483 .896 r
F
.61745 .44897 m .61817 .44968 L .60324 .43964 L F
.60358 .43982 m .60324 .43964 L .59944 .43709 L F
.61745 .44897 m .60324 .43964 L .60358 .43982 L F
.59944 .43709 m .6282 .45642 L .61524 .45522 L F
.51146 .34604 m .59119 .41786 L .50531 .35748 L .855 .506 .39 r
F
.65407 .44671 m .72343 .48866 L .68283 .50516 L .716 .748 .877 r
F
.65083 .48162 m .65964 .48518 L .67212 .49647 L .093 .483 .896 r
F
.66737 .49389 m .67212 .49647 L .67797 .50176 L F
.65083 .48162 m .67212 .49647 L .66737 .49389 L F
.67087 .4908 m .67379 .49738 L .67047 .49184 L .716 .748 .877 r
F
.67379 .49738 m .67304 .49697 L .67047 .49184 L F
.65964 .48518 m .67855 .50148 L .67797 .50176 L .093 .483 .896 r
F
.65094 .48408 m .67797 .50176 L .6549 .48942 L .493 .669 .942 r
F
.67379 .49738 m .6781 .50708 L .67304 .49697 L .716 .748 .877 r
F
.67379 .49738 m .68283 .50516 L .6781 .50708 L F
.6258 .38926 m .68283 .50516 L .67379 .49738 L F
.65964 .48518 m .68825 .49675 L .67855 .50148 L .093 .483 .896 r
F
.6282 .45642 m .68825 .49675 L .6466 .47305 L F
.6282 .45642 m .6466 .47305 L .61524 .45522 L F
.61329 .44491 m .60123 .43311 L .59722 .42231 L .875 .798 .771 r
F
.61329 .44491 m .59722 .42231 L .59814 .42241 L F
.61329 .44491 m .59618 .4195 L .59657 .41436 L F
.59119 .41786 m .59598 .42217 L .58581 .4223 L .855 .506 .39 r
F
.59119 .41786 m .59441 .422 L .59598 .42217 L F
.59598 .42217 m .59581 .42438 L .58581 .4223 L F
.59581 .42438 m .59539 .43002 L .58581 .4223 L F
.59119 .41786 m .58581 .4223 L .50531 .35748 L F
.56834 .41132 m .58283 .55576 L .56684 .41202 L .938 .739 .265 r
F
.57591 .4179 m .58283 .55576 L .56834 .41132 L .962 .828 .665 r
F
.48956 .39404 m .57016 .45372 L .56673 .47958 L .648 .719 .9 r
F
.5666 .41367 m .58283 .55576 L .57787 .55973 L .938 .739 .265 r
F
.54779 .38062 m .56767 .40707 L .58295 .41408 L .855 .506 .39 r
F
.55167 .3897 m .56767 .40707 L .54779 .38062 L F
.51146 .34604 m .58295 .41408 L .58362 .41378 L F
.56091 .39058 m .58362 .41378 L .58566 .41288 L F
.51146 .34604 m .58362 .41378 L .56091 .39058 L F
.59152 .42361 m .58454 .42002 L .58362 .41378 L .875 .798 .771 r
F
.59152 .42361 m .58362 .41378 L .59103 .42135 L F
.58362 .41378 m .58454 .42002 L .58265 .41421 L .962 .828 .665 r
F
.58983 .42012 m .59441 .422 L .59119 .41786 L .855 .506 .39 r
F
.59134 .42167 m .59152 .42361 L .59103 .42135 L .875 .798 .771 r
F
.58905 .42142 m .59134 .42167 L .58983 .42012 L .855 .506 .39 r
F
.59134 .42167 m .59441 .422 L .58983 .42012 L F
.58295 .41408 m .58905 .42142 L .59119 .41786 L F
.58566 .41288 m .58362 .41378 L .59119 .41786 L F
.58362 .41378 m .58295 .41408 L .5847 .41488 L F
.58362 .41378 m .5847 .41488 L .59119 .41786 L F
.58335 .33707 m .59134 .42167 L .57164 .33279 L .875 .798 .771 r
F
.59134 .42167 m .59103 .42135 L .57164 .33279 L F
.58942 .4013 m .59618 .4195 L .59346 .4219 L F
.59134 .42167 m .59346 .4219 L .59152 .42361 L F
.58942 .4013 m .59346 .4219 L .59134 .42167 L F
.59618 .4195 m .60123 .43311 L .59557 .42757 L F
.59618 .4195 m .59557 .42757 L .59152 .42361 L F
.61513 .44587 m .61329 .44491 L .61182 .4396 L .798 .772 .829 r
F
.61513 .44587 m .61182 .4396 L .61333 .44084 L F
.59885 .43642 m .60499 .44056 L .59944 .43709 L .093 .483 .896 r
F
.60499 .44056 m .60358 .43982 L .59944 .43709 L F
.61616 .46134 m .65094 .48408 L .62058 .46899 L .493 .669 .942 r
F
.61329 .44491 m .63603 .52677 L .60138 .43351 L .875 .798 .771 r
F
.60204 .43389 m .60138 .43351 L .60123 .43311 L F
.61329 .44491 m .60138 .43351 L .60204 .43389 L F
.60123 .43311 m .63603 .52677 L .59152 .42361 L F
.59539 .43002 m .59695 .43127 L .6122 .43991 L .697 .161 0 r
F
.61182 .4396 m .6122 .43991 L .61763 .44298 L F
.59539 .43002 m .6122 .43991 L .61182 .4396 L F
.61763 .44298 m .6122 .43991 L .62897 .45161 L F
.61847 .44761 m .61513 .44587 L .61333 .44084 L .798 .772 .829 r
F
.6122 .43991 m .59695 .43127 L .61779 .44451 L .697 .161 0 r
F
.6122 .43991 m .61779 .44451 L .62897 .45161 L F
.61333 .44084 m .61182 .4396 L .6082 .42658 L .798 .772 .829 r
F
.59921 .42508 m .59695 .43127 L .59539 .43002 L .855 .506 .39 r
F
.59921 .42508 m .59539 .43002 L .59581 .42438 L F
.59585 .42386 m .59634 .42449 L .59581 .42438 L F
.59598 .42217 m .59634 .42449 L .59585 .42386 L F
.59598 .42217 m .59921 .42508 L .59634 .42449 L F
.61019 .39503 m .6383 .42758 L .63471 .43682 L .798 .772 .829 r
F
.62073 .4322 m .63471 .43682 L .62739 .45568 L F
.61019 .39503 m .63471 .43682 L .62073 .4322 L F
.61847 .44761 m .62739 .45568 L .62285 .46735 L F
.59473 .34051 m .62739 .45568 L .61847 .44761 L F
.62285 .46735 m .61329 .44491 L .61513 .44587 L F
.61847 .44761 m .62285 .46735 L .61513 .44587 L F
.63577 .4669 m .68825 .49675 L .65083 .48162 L .093 .483 .896 r
F
.66861 .49675 m .66373 .50958 L .65332 .51529 L .493 .669 .942 r
F
.62739 .45568 m .6781 .50708 L .62285 .46735 L .798 .772 .829 r
F
.67304 .49697 m .6781 .50708 L .62739 .45568 L F
.62739 .45568 m .68825 .49675 L .6282 .45642 L .093 .483 .896 r
F
.62897 .45161 m .68825 .49675 L .62739 .45568 L .697 .161 0 r
F
.59695 .43127 m .68314 .50069 L .62897 .45161 L F
.59921 .42508 m .61435 .44529 L .59695 .43127 L .855 .506 .39 r
F
.61002 .42591 m .61779 .44451 L .6082 .42658 L .798 .772 .829 r
F
.61339 .42468 m .61461 .43017 L .61002 .42591 L F
.61461 .43017 m .61779 .44451 L .61002 .42591 L F
.61779 .44451 m .61333 .44084 L .6082 .42658 L F
.6082 .42658 m .61182 .4396 L .58942 .4013 L .875 .798 .771 r
F
.61182 .4396 m .60972 .43837 L .58942 .4013 L F
.62285 .46735 m .6781 .50708 L .63603 .52677 L .798 .772 .829 r
F
.59921 .42508 m .66453 .51223 L .68314 .50069 L .855 .506 .39 r
F
.59598 .42217 m .59785 .42463 L .59921 .42508 L F
.62285 .46735 m .61716 .45881 L .61329 .44491 L .798 .772 .829 r
F
.59785 .42463 m .66453 .51223 L .59921 .42508 L .855 .506 .39 r
F
.59152 .42361 m .59194 .42801 L .58454 .42002 L .875 .798 .771 r
F
.59152 .42361 m .61647 .48145 L .6029 .54408 L F
.58905 .42142 m .66453 .51223 L .59441 .422 L .855 .506 .39 r
F
.56819 .40731 m .57668 .41685 L .58295 .41408 L F
.56767 .40707 m .56815 .40759 L .56819 .40731 L F
.56815 .40759 m .57668 .41685 L .56819 .40731 L F
.57934 .41568 m .5801 .41982 L .57841 .41609 L .962 .828 .665 r
F
.5801 .41982 m .6029 .54408 L .57731 .41854 L F
.51905 .33651 m .57647 .40587 L .51146 .34604 L .794 .565 .591 r
F
.5801 .41982 m .57731 .41854 L .57665 .4153 L .962 .828 .665 r
F
.5801 .41982 m .57665 .4153 L .57659 .41206 L F
.51146 .34604 m .55167 .3897 L .54779 .38062 L .855 .506 .39 r
F
.57647 .40587 m .57668 .41685 L .51146 .34604 L .794 .565 .591 r
F
.5755 .40964 m .57731 .41854 L .57591 .4179 L .962 .828 .665 r
F
.59194 .42801 m .6029 .54408 L .58484 .422 L .875 .798 .771 r
F
.59194 .42801 m .58484 .422 L .58454 .42002 L F
.58454 .42002 m .58484 .422 L .57896 .41361 L .962 .828 .665 r
F
.58484 .422 m .6029 .54408 L .5801 .41982 L F
.58484 .422 m .5801 .41982 L .57896 .41361 L F
.62285 .46735 m .63603 .52677 L .61716 .45881 L .798 .772 .829 r
F
.58454 .42002 m .57896 .41361 L .57447 .38912 L .962 .828 .665 r
F
.57668 .41685 m .66453 .51223 L .58295 .41408 L .855 .506 .39 r
F
.58362 .41378 m .58265 .41421 L .57863 .4019 L .962 .828 .665 r
F
.57896 .41361 m .57934 .41568 L .5755 .40964 L F
.57934 .41568 m .57841 .41609 L .5755 .40964 L F
.5755 .40964 m .56778 .40577 L .56689 .39693 L F
.5755 .40964 m .56689 .39693 L .57362 .40554 L F
.56694 .39435 m .57123 .40248 L .57647 .40587 L .794 .565 .591 r
F
.5754 .40783 m .5755 .40964 L .57362 .40554 L .962 .828 .665 r
F
.57123 .40248 m .57472 .40909 L .5754 .40783 L .794 .565 .591 r
F
.57123 .40248 m .5754 .40783 L .57647 .40587 L F
.57447 .38912 m .5754 .40783 L .56611 .38917 L .962 .828 .665 r
F
.5754 .40783 m .57362 .40554 L .56611 .38917 L F
.57447 .38912 m .57896 .41361 L .5755 .40964 L F
.57647 .40587 m .66453 .51223 L .57668 .41685 L .794 .565 .591 r
F
.57659 .41206 m .57665 .4153 L .5755 .40964 L .962 .828 .665 r
F
.55052 .37452 m .55179 .3776 L .56694 .39435 L .794 .565 .591 r
F
.55179 .3776 m .5666 .41341 L .56689 .39693 L F
.55179 .3776 m .56689 .39693 L .56694 .39435 L F
.56778 .40577 m .56804 .40834 L .56568 .40132 L .938 .739 .265 r
F
.51905 .33651 m .55771 .39903 L .55052 .37452 L .794 .565 .591 r
F
.55771 .39903 m .5666 .41341 L .55052 .37452 L F
.56538 .39742 m .5666 .41341 L .51905 .33651 L .699 .55 .681 r
F
.56567 .40128 m .56568 .40132 L .56564 .4012 L .938 .739 .265 r
F
.56778 .40577 m .56568 .40132 L .56567 .40128 L F
.52802 .32975 m .56538 .39742 L .51905 .33651 L .699 .55 .681 r
F
.57731 .41854 m .6029 .54408 L .57591 .4179 L .962 .828 .665 r
F
.5755 .40964 m .57591 .4179 L .56778 .40577 L F
.61647 .48145 m .63603 .52677 L .61478 .53787 L .875 .798 .771 r
F
.61647 .48145 m .61478 .53787 L .6029 .54408 L F
.56541 .3982 m .56778 .40577 L .56564 .4012 L .938 .739 .265 r
F
.55517 .37892 m .55562 .38097 L .56538 .39742 L .699 .55 .681 r
F
.56541 .3982 m .57787 .55973 L .55562 .38097 L .938 .739 .265 r
F
.55562 .38097 m .56644 .43009 L .56541 .3982 L .699 .55 .681 r
F
.55562 .38097 m .56541 .3982 L .56538 .39742 L F
.56541 .3982 m .55562 .38097 L .5488 .32619 L .938 .739 .265 r
F
.56481 .42045 m .57787 .55973 L .56644 .43009 L .065 .119 .609 r
F
.56661 .41325 m .58283 .55576 L .5666 .41367 L .938 .739 .265 r
F
.56684 .41202 m .58283 .55576 L .56649 .41218 L F
.56644 .43009 m .57787 .55973 L .58773 .55539 L .065 .119 .609 r
F
.55878 .40634 m .57787 .55973 L .56481 .42045 L F
.56644 .43009 m .58773 .55539 L .55308 .39565 L F
.55562 .38097 m .55798 .39994 L .56337 .41612 L F
.55798 .39994 m .55878 .40634 L .56224 .41443 L F
.55798 .39994 m .56224 .41443 L .56481 .42045 L F
.52802 .32975 m .56652 .43043 L .55517 .37892 L .699 .55 .681 r
F
.5488 .32619 m .55562 .38097 L .56481 .42045 L .065 .119 .609 r
F
.55562 .38097 m .56337 .41612 L .56481 .42045 L F
.5488 .32619 m .56644 .43009 L .53805 .32631 L F
.52802 .32975 m .56654 .43103 L .56652 .43043 L .699 .55 .681 r
F
.56644 .43009 m .55308 .39565 L .53805 .32631 L .065 .119 .609 r
F
.56644 .43009 m .56652 .43043 L .56651 .43027 L .699 .55 .681 r
F
.56644 .43009 m .56651 .43027 L .56541 .3982 L F
.56004 .32874 m .56541 .3982 L .5488 .32619 L .938 .739 .265 r
F
.56004 .32874 m .56456 .37371 L .56541 .3982 L F
.56456 .37371 m .56778 .40577 L .56541 .3982 L F
.56804 .40834 m .56834 .41132 L .56786 .40953 L F
.56804 .40834 m .56786 .40953 L .56564 .4012 L F
.56834 .41132 m .56684 .41202 L .56564 .4012 L F
.57591 .4179 m .56834 .41132 L .56778 .40577 L .962 .828 .665 r
F
.56564 .4012 m .56684 .41202 L .56649 .41218 L .938 .739 .265 r
F
.56538 .39742 m .63753 .52811 L .5666 .41341 L .699 .55 .681 r
F
.56538 .39742 m .60947 .54389 L .63753 .52811 L F
.56649 .41218 m .56661 .41325 L .5666 .41367 L .938 .739 .265 r
F
.56654 .43103 m .60947 .54389 L .56538 .39742 L .699 .55 .681 r
F
.56684 .40006 m .63753 .52811 L .56694 .39435 L .794 .565 .591 r
F
.57362 .40554 m .56689 .39693 L .56611 .38917 L .962 .828 .665 r
F
.58187 .40195 m .58362 .41378 L .57863 .4019 L F
.58019 .39904 m .57863 .4019 L .57447 .38912 L F
.58187 .40195 m .57863 .4019 L .58019 .39904 L F
.57647 .40587 m .63753 .52811 L .66453 .51223 L .794 .565 .591 r
F
.57472 .40909 m .63753 .52811 L .57647 .40587 L F
.59103 .42135 m .58362 .41378 L .57164 .33279 L .875 .798 .771 r
F
.59441 .422 m .66453 .51223 L .59598 .42217 L .855 .506 .39 r
F
.59814 .42241 m .59722 .42231 L .59618 .4195 L .875 .798 .771 r
F
.59657 .41436 m .59618 .4195 L .58942 .4013 L F
.59473 .34051 m .61518 .38137 L .61019 .39503 L .798 .772 .829 r
F
.61518 .38137 m .6383 .42758 L .61019 .39503 L F
.6258 .38926 m .70533 .47023 L .65407 .44671 L .716 .748 .877 r
F
.70533 .47023 m .72343 .48866 L .65407 .44671 L F
.60502 .34245 m .63606 .38078 L .6258 .38926 L F
.63606 .38078 m .72343 .48866 L .6258 .38926 L F
.62897 .45161 m .63978 .46141 L .68825 .49675 L .697 .161 0 r
F
.63978 .46141 m .68314 .50069 L .68825 .49675 L F
.50857 .37606 m .53944 .3968 L .52988 .39187 L .093 .483 .896 r
F
.50022 .36986 m .51182 .37769 L .50857 .37606 L F
.57447 .38912 m .56611 .38917 L .56004 .32874 L .962 .828 .665 r
F
.57164 .33279 m .58187 .40195 L .57447 .38912 L F
.58335 .33707 m .6082 .42658 L .58942 .4013 L .875 .798 .771 r
F
.59473 .34051 m .61339 .42468 L .58491 .34269 L .798 .772 .829 r
F
.61339 .42468 m .6082 .42658 L .58491 .34269 L F
.58557 .33774 m .58491 .34269 L .58335 .33707 L F
.59473 .34051 m .58491 .34269 L .58557 .33774 L F
.25 g
.474 .41518 m
.49686 .44829 L
s
.49686 .44829 m
.53644 .5056 L
s
.53644 .5056 m
.57465 .56092 L
s
1 0 0 r
.003 w
.60163 .54503 m
.60605 .54243 L
s
.57465 .56092 m
.57779 .55907 L
s
.58739 .55342 m
.60163 .54503 L
s
.25 g
.5 Mabswid
.48947 .48862 m
.51768 .55704 L
s
.48202 .40438 m
.48991 .41204 L
s
.48991 .41204 m
.53626 .45701 L
s
.53626 .45701 m
.56894 .48872 L
s
.56894 .48872 m
.56905 .48883 L
s
.45861 .47098 m
.46069 .48025 L
s
.46069 .48025 m
.47083 .52534 L
s
.44769 .42243 m
.45861 .47098 L
s
.50554 .40587 m
.53598 .42841 L
s
.53598 .42841 m
.56412 .44924 L
s
.49193 .3958 m
.50554 .40587 L
s
.49001 .39437 m
.49193 .3958 L
s
.48956 .39404 m
.49001 .39437 L
s
.42373 .59841 m
.4385 .61402 L
s
.32079 .50719 m .41748 .66705 L .3792 .7019 L .879 .781 .749 r
F
.32578 .49479 m .41748 .66705 L .32079 .50719 L .822 .762 .796 r
F
.25 g
.41192 .58591 m
.42373 .59841 L
s
1 0 0 r
.003 w
.41748 .66705 m
.44371 .64435 L
s
.25 g
.5 Mabswid
.32578 .49479 m
.32647 .49553 L
s
.41707 .54772 m
.4286 .55645 L
s
.3296 .48153 m
.33099 .48258 L
s
.33099 .48258 m
.35447 .50035 L
s
.38758 .52541 m
.38871 .52626 L
s
.38871 .52626 m
.41707 .54772 L
s
.35447 .50035 m
.35647 .50187 L
s
.35647 .50187 m
.35916 .5039 L
s
.43391 .42371 m
.43424 .42628 L
s
.43424 .42628 m
.43513 .4332 L
s
.43513 .4332 m
.44057 .47561 L
s
.44057 .47561 m
.44267 .49199 L
s
.44267 .49199 m
.44432 .50487 L
s
.67685 .50459 m
.6781 .50708 L
s
1 0 0 r
.003 w
.65452 .51812 m
.6781 .50708 L
s
.6781 .50708 m
.68283 .50516 L
s
.68283 .50516 m
.69983 .49825 L
s
.25 g
.5 Mabswid
.54528 .41498 m
.55926 .42412 L
s
.51009 .39197 m
.54528 .41498 L
s
.49957 .38509 m
.51009 .39197 L
s
.49787 .38398 m
.49957 .38509 L
s
.49533 .38231 m
.49787 .38398 L
s
.61339 .34251 m .72343 .48866 L .60502 .34245 L .606 .717 .923 r
F
.61339 .34251 m .76552 .47477 L .72343 .48866 L F
.25 g
.6603 .47152 m
.66349 .4779 L
s
1 0 0 r
.003 w
.69983 .49825 m
.72343 .48866 L
s
.25 g
.5 Mabswid
.71039 .47255 m
.72343 .48866 L
s
.6082 .42658 m
.61065 .43539 L
s
.59833 .39101 m
.60097 .40051 L
s
.60097 .40051 m
.60733 .42341 L
s
.60733 .42341 m
.6082 .42658 L
s
1 0 0 r
.003 w
.6029 .54408 m
.60844 .54118 L
s
.31424 .51784 m .3792 .7019 L .34712 .7335 L .938 .802 .683 r
F
.25 g
.5 Mabswid
.32647 .49553 m
.32884 .49803 L
s
.32079 .50719 m .3792 .7019 L .31424 .51784 L .879 .781 .749 r
F
.25 g
.3733 .54506 m
.41192 .58591 L
s
.32167 .50864 m
.3223 .50968 L
s
.37258 .59282 m
.41748 .66705 L
s
1 0 0 r
.003 w
.3792 .7019 m
.41748 .66705 L
s
.25 g
.5 Mabswid
.32079 .50719 m
.32167 .50864 L
s
.41303 .51788 m
.4176 .52073 L
s
.4176 .52073 m
.4219 .5234 L
s
.33322 .46822 m
.33478 .46919 L
s
.38622 .5012 m
.41303 .51788 L
s
.59868 .51552 m
.6029 .54408 L
s
.58187 .40195 m
.58362 .41378 L
s
.58117 .39724 m
.58187 .40195 L
s
1 0 0 r
.003 w
.58734 .55314 m
.6029 .54408 L
s
.61916 .34051 m .76552 .47477 L .61339 .34251 L .412 .649 .955 r
F
.25 g
.5 Mabswid
.61561 .34444 m
.6183 .34678 L
s
.61339 .34251 m
.61561 .34444 L
s
.61916 .34051 m .798 .46772 L .76552 .47477 L .412 .649 .955 r
F
.25 g
.6383 .42758 m
.64456 .44007 L
s
.64456 .44007 m
.6603 .47152 L
s
.67056 .42337 m
.71039 .47255 L
s
1 0 0 r
.003 w
.72343 .48866 m
.76552 .47477 L
s
.25 g
.5 Mabswid
.72278 .43762 m
.76552 .47477 L
s
.41979 .4233 m
.42096 .43362 L
s
.42096 .43362 m
.42351 .45615 L
s
.42351 .45615 m
.42544 .47315 L
s
.42544 .47315 m
.42738 .49029 L
s
.4054 .49627 m
.41556 .50239 L
s
.3378 .45553 m
.34007 .45689 L
s
1 0 0 r
.003 w
.53364 .57356 m
.53524 .57509 L
s
.25 g
.5 Mabswid
.54057 .39709 m
.54314 .39883 L
s
.54314 .39883 m
.5556 .40723 L
s
.51417 .37928 m
.54057 .39709 L
s
.50564 .37352 m
.51417 .37928 L
s
.50391 .37235 m
.50564 .37352 L
s
.50022 .36986 m
.50391 .37235 L
s
1 0 0 r
.003 w
.68314 .50069 m
.68825 .49675 L
s
.22883 .53932 m .26203 .56829 L .23157 .5477 L .732 .752 .868 r
F
.23157 .5477 m .25761 .5811 L .23606 .55721 L .827 .768 .796 r
F
.31864 .64325 m .34712 .7335 L .33176 .75138 L .994 .813 .553 r
F
.32802 .65279 m .34712 .7335 L .31864 .64325 L F
.31116 .58161 m .33176 .75138 L .32434 .73191 L F
.31758 .58335 m .34712 .7335 L .31116 .58161 L F
.31424 .51784 m .34712 .7335 L .30628 .5259 L .938 .802 .683 r
F
.31916 .72986 m .32658 .75742 L .32336 .76523 L .898 .681 .17 r
F
.30792 .63518 m .32398 .74038 L .31916 .72986 L F
.32398 .74038 m .32658 .75742 L .31916 .72986 L F
.30792 .63518 m .32336 .76523 L .31766 .73124 L F
.31064 .63384 m .32658 .75742 L .30792 .63518 L F
.32434 .73191 m .33176 .75138 L .32658 .75742 L .994 .813 .553 r
F
.30628 .5259 m .32658 .75742 L .29735 .53084 L F
.32029 .7314 m .36216 .71524 L .33043 .75238 L .897 .783 .728 r
F
.31766 .73124 m .32336 .76523 L .32155 .76964 L .898 .681 .17 r
F
.29735 .53084 m .32155 .76964 L .28788 .53261 L F
.31636 .72367 m .32155 .76964 L .32318 .76939 L 0 0 .508 r
F
.30175 .62765 m .3145 .71999 L .31552 .722 L F
.29965 .61331 m .30121 .62649 L .30175 .62765 L F
.29384 .57348 m .29947 .61395 L .29965 .61331 L F
.29947 .61395 m .30121 .62649 L .29965 .61331 L F
.31116 .58161 m .32802 .65279 L .31864 .64325 L .994 .813 .553 r
F
.29214 .56185 m .29361 .57293 L .29384 .57348 L 0 0 .508 r
F
.28788 .53261 m .29202 .56176 L .29214 .56185 L F
.29202 .56176 m .29361 .57293 L .29214 .56185 L F
.33859 .60134 m .44029 .65348 L .42943 .65878 L .513 .704 .957 r
F
.29361 .57293 m .30121 .62649 L .29384 .57348 L 0 0 .508 r
F
.30741 .6636 m .31552 .722 L .31532 .71667 L F
.28939 .54272 m .30732 .66586 L .30741 .6636 L F
.28934 .54261 m .30732 .66586 L .28939 .54272 L F
.28788 .53261 m .28934 .54261 L .28939 .54272 L F
.30121 .62649 m .3145 .71999 L .30175 .62765 L F
.32029 .7314 m .33043 .75238 L .32074 .73229 L .897 .783 .728 r
F
.30832 .6394 m .31531 .71643 L .31346 .66621 L 0 0 .508 r
F
.28842 .53542 m .30742 .66332 L .30832 .6394 L F
.30742 .66332 m .31531 .71643 L .30832 .6394 L F
.28813 .5343 m .32318 .76939 L .28842 .53542 L F
.31346 .66621 m .32318 .76939 L .31925 .71779 L F
.31454 .67186 m .31925 .71779 L .31656 .6824 L F
.31346 .66621 m .31925 .71779 L .31454 .67186 L F
.31531 .71643 m .32318 .76939 L .31346 .66621 L F
.30732 .66586 m .31552 .722 L .30741 .6636 L F
.31532 .71667 m .31552 .722 L .31636 .72367 L F
.31184 .71393 m .31656 .6824 L .32029 .7314 L .897 .783 .728 r
F
.28901 .66672 m .31253 .68011 L .31184 .71393 L F
.31253 .68011 m .31656 .6824 L .31184 .71393 L F
.31223 .63293 m .39445 .68387 L .31261 .64333 L .827 .768 .796 r
F
.28788 .53261 m .28813 .5343 L .28842 .53542 L 0 0 .508 r
F
.28788 .53261 m .29874 .58934 L .27806 .53174 L F
.31005 .6484 m .31656 .6824 L .30927 .6539 L F
.31656 .6824 m .31253 .68011 L .27806 .53174 L F
.30175 .63372 m .3082 .66148 L .31005 .64838 L .384 .356 .704 r
F
.30202 .63808 m .31005 .64838 L .30099 .63858 L .827 .768 .796 r
F
.31005 .64838 m .31293 .65208 L .31074 .6496 L F
.31447 .61701 m .39445 .68387 L .31223 .63293 L F
.29735 .53084 m .31064 .63384 L .30792 .63518 L .898 .681 .17 r
F
.27821 .53216 m .30175 .63372 L .31284 .62861 L .384 .356 .704 r
F
.27806 .53174 m .27811 .53197 L .27821 .53216 L F
.27811 .53197 m .30175 .63372 L .27821 .53216 L F
.27557 .5419 m .28408 .56463 L .27324 .54103 L F
.28265 .54454 m .28408 .56463 L .27557 .5419 L F
.28265 .54454 m .31062 .62243 L .28408 .56463 L F
.31062 .62243 m .31136 .62535 L .27324 .54103 L F
.28265 .54454 m .27324 .54103 L .26792 .52926 L F
.31284 .62861 m .30556 .62327 L .26792 .52926 L F
.30175 .63372 m .31005 .64838 L .31284 .62861 L F
.31062 .62243 m .31284 .62861 L .31136 .62535 L F
.31155 .61456 m .31261 .64333 L .30202 .63808 L .827 .768 .796 r
F
.30944 .60968 m .42204 .66238 L .39445 .68387 L .732 .752 .868 r
F
.30979 .60063 m .31872 .60555 L .30944 .60968 L F
.31872 .60555 m .35519 .63109 L .30944 .60968 L F
.31275 .59812 m .42204 .66238 L .30979 .60063 L F
.26792 .52926 m .2902 .58491 L .31065 .5999 L .595 .493 .708 r
F
.2902 .58491 m .29987 .60906 L .30436 .60524 L F
.2902 .58491 m .30436 .60524 L .31065 .5999 L F
.26203 .56829 m .30436 .60524 L .25341 .56596 L .732 .752 .868 r
F
.30436 .60524 m .30944 .60968 L .30508 .60627 L F
.30663 .59708 m .30056 .59282 L .25758 .52651 L .595 .493 .708 r
F
.31872 .60555 m .42204 .66238 L .35519 .63109 L .732 .752 .868 r
F
.31015 .59111 m .42204 .66238 L .30994 .59647 L F
.30775 .58554 m .42204 .66238 L .31015 .59111 L .513 .704 .957 r
F
.30856 .58278 m .44029 .65348 L .30775 .58554 L F
.32307 .5864 m .44029 .65348 L .30856 .58278 L F
.26792 .52926 m .28285 .55395 L .25758 .52651 L .595 .493 .708 r
F
.30567 .59166 m .31065 .5999 L .30484 .59185 L F
.31065 .5999 m .30663 .59708 L .25758 .52651 L F
.30078 .58085 m .30056 .59282 L .30961 .59077 L .707 .546 .668 r
F
.27137 .54778 m .29126 .57848 L .30078 .58085 L F
.29126 .57848 m .30056 .59282 L .30078 .58085 L F
.30078 .58085 m .30856 .58278 L .30775 .58554 L .513 .704 .957 r
F
.25758 .52651 m .27137 .54778 L .31554 .58942 L .707 .546 .668 r
F
.30078 .58085 m .30775 .58554 L .3019 .58211 L .513 .704 .957 r
F
.30775 .58554 m .31015 .59111 L .30961 .59077 L F
.3019 .58211 m .30961 .59077 L .22883 .53932 L F
.30775 .58554 m .30961 .59077 L .3019 .58211 L F
.29883 .59322 m .29967 .59302 L .30979 .60063 L .732 .752 .868 r
F
.28388 .58114 m .30994 .59647 L .30984 .59932 L F
.28388 .58114 m .30984 .59932 L .30979 .60063 L F
.30436 .60524 m .30979 .60063 L .30944 .60968 L F
.26203 .56829 m .30979 .60063 L .30436 .60524 L F
.29987 .60906 m .30556 .62327 L .30827 .61085 L .595 .493 .708 r
F
.30944 .60968 m .30988 .61317 L .30508 .60627 L .732 .752 .868 r
F
.30436 .60524 m .30827 .61085 L .31065 .5999 L .595 .493 .708 r
F
.29987 .60906 m .30827 .61085 L .30436 .60524 L F
.30944 .60968 m .31155 .61456 L .30988 .61317 L .732 .752 .868 r
F
.31065 .5999 m .30827 .61085 L .31353 .60464 L .595 .493 .708 r
F
.30827 .61085 m .30556 .62327 L .30988 .61317 L F
.30944 .60968 m .39445 .68387 L .31155 .61456 L .732 .752 .868 r
F
.30827 .61085 m .30988 .61317 L .31353 .60464 L .595 .493 .708 r
F
.30508 .60627 m .30988 .61317 L .25341 .56596 L .732 .752 .868 r
F
.31293 .65208 m .36216 .71524 L .31451 .65552 L .827 .768 .796 r
F
.31293 .65208 m .38094 .6786 L .36216 .71524 L F
.38094 .6786 m .39172 .68652 L .36216 .71524 L F
.31261 .64333 m .39445 .68387 L .31293 .65208 L F
.31451 .65552 m .36216 .71524 L .32029 .7314 L .897 .783 .728 r
F
.31353 .60464 m .35734 .75259 L .38803 .7278 L .595 .493 .708 r
F
.3115 .63809 m .31276 .64125 L .31284 .62861 L .384 .356 .704 r
F
.31293 .65208 m .31451 .65552 L .31307 .65372 L .827 .768 .796 r
F
.3082 .66148 m .31084 .64978 L .31005 .64838 L .384 .356 .704 r
F
.31293 .65208 m .31307 .65372 L .31074 .6496 L .827 .768 .796 r
F
.30202 .63808 m .31261 .64333 L .31293 .65208 L F
.3082 .66148 m .31253 .68011 L .31276 .64125 L .384 .356 .704 r
F
.31284 .62861 m .31253 .68011 L .31354 .63056 L F
.31074 .6496 m .31307 .65372 L .30099 .63858 L .827 .768 .796 r
F
.31005 .64838 m .31276 .64125 L .3115 .63809 L .384 .356 .704 r
F
.31084 .64978 m .31276 .64125 L .31005 .64838 L F
.31155 .61456 m .31447 .61701 L .31223 .63293 L .827 .768 .796 r
F
.31354 .63056 m .33291 .76784 L .35734 .75259 L .384 .356 .704 r
F
.32074 .73229 m .33043 .75238 L .32379 .76206 L .961 .799 .636 r
F
.31656 .6824 m .32318 .76939 L .33291 .76784 L 0 0 .508 r
F
.31656 .6824 m .33291 .76784 L .31253 .68011 L F
.23606 .55721 m .31451 .65552 L .31656 .6824 L .897 .783 .728 r
F
.23606 .55721 m .31656 .6824 L .28901 .66672 L F
.31253 .68011 m .33291 .76784 L .31354 .63056 L .384 .356 .704 r
F
.29587 .60145 m .31155 .61456 L .30202 .63808 L .827 .768 .796 r
F
.31284 .62861 m .35734 .75259 L .30556 .62327 L .384 .356 .704 r
F
.30556 .62327 m .35734 .75259 L .31353 .60464 L .595 .493 .708 r
F
.3245 .62278 m .34134 .65575 L .30056 .59282 L F
.3245 .62278 m .30056 .59282 L .30663 .59708 L F
.30994 .59647 m .31275 .59812 L .30979 .60063 L .732 .752 .868 r
F
.31065 .5999 m .3245 .62278 L .30663 .59708 L .595 .493 .708 r
F
.3245 .62278 m .38803 .7278 L .34134 .65575 L F
.30056 .59282 m .38803 .7278 L .32575 .60891 L .707 .546 .668 r
F
.31015 .59111 m .30994 .59647 L .28388 .58114 L .732 .752 .868 r
F
.31015 .59111 m .28388 .58114 L .27289 .57344 L F
.25809 .55796 m .31015 .59111 L .26203 .56829 L F
.30775 .58554 m .33859 .60134 L .42204 .66238 L .513 .704 .957 r
F
.30961 .59077 m .32575 .60891 L .31554 .58942 L .707 .546 .668 r
F
.30056 .59282 m .32575 .60891 L .30961 .59077 L F
.27137 .54778 m .30961 .59077 L .31554 .58942 L F
.29102 .56281 m .30968 .58306 L .28292 .55797 L F
.30968 .58306 m .2951 .57385 L .24754 .5248 L F
.33859 .60134 m .42943 .65878 L .42204 .66238 L .513 .704 .957 r
F
.30628 .5259 m .31758 .58335 L .31116 .58161 L .994 .813 .553 r
F
.29789 .56735 m .44029 .65348 L .31484 .58169 L .431 0 0 r
F
.25758 .52651 m .29102 .56281 L .24754 .5248 L .707 .546 .668 r
F
.29102 .56281 m .28292 .55797 L .24754 .5248 L F
.31489 .57782 m .2951 .57385 L .32486 .58567 L .786 .554 .584 r
F
.29789 .56735 m .30797 .57355 L .30711 .57292 L .431 0 0 r
F
.30711 .57292 m .33764 .59163 L .44029 .65348 L F
.33764 .59163 m .4459 .65797 L .44259 .65532 L F
.33764 .59163 m .44259 .65532 L .44029 .65348 L F
.27529 .55341 m .2951 .57385 L .31489 .57782 L .786 .554 .584 r
F
.23224 .52763 m .29789 .56735 L .22887 .5325 L .431 0 0 r
F
.29789 .56735 m .31484 .58169 L .22887 .5325 L F
.32486 .58567 m .33643 .59997 L .4377 .67451 L .786 .554 .584 r
F
.29319 .57309 m .3095 .57957 L .30856 .58278 L .513 .704 .957 r
F
.22887 .5325 m .30856 .58278 L .30078 .58085 L F
.30973 .57877 m .32307 .5864 L .30856 .58278 L F
.38094 .6786 m .39445 .68387 L .39172 .68652 L .827 .768 .796 r
F
.31554 .58942 m .38803 .7278 L .41704 .6996 L .707 .546 .668 r
F
.30968 .58306 m .41704 .6996 L .2951 .57385 L F
.2951 .57385 m .41704 .6996 L .32486 .58567 L .786 .554 .584 r
F
.31489 .57782 m .4377 .67451 L .2842 .55919 L F
.3092 .57447 m .4459 .65797 L .30711 .57292 L .431 0 0 r
F
.2842 .55919 m .4377 .67451 L .4459 .65797 L .838 .475 .366 r
F
.31006 .5751 m .4459 .65797 L .3092 .57447 L .431 0 0 r
F
.24754 .5248 m .27529 .55341 L .31489 .57782 L .786 .554 .584 r
F
.24754 .5248 m .31489 .57782 L .23873 .52504 L F
.24097 .53291 m .31006 .5751 L .30797 .57355 L .431 0 0 r
F
.24097 .53291 m .30797 .57355 L .29789 .56735 L F
.31489 .57782 m .2842 .55919 L .23873 .52504 L .786 .554 .584 r
F
.23873 .52504 m .2842 .55919 L .33667 .59125 L .838 .475 .366 r
F
.31824 .57605 m .33667 .59125 L .4459 .65797 L F
.23873 .52504 m .33667 .59125 L .31824 .57605 L F
.33643 .59997 m .41704 .6996 L .43227 .68111 L .786 .554 .584 r
F
.33643 .59997 m .43227 .68111 L .4377 .67451 L F
.22887 .5325 m .30973 .57877 L .3095 .57957 L .513 .704 .957 r
F
.22887 .5325 m .3095 .57957 L .29319 .57309 L F
.22887 .5325 m .30078 .58085 L .22883 .53932 L F
.30078 .58085 m .3019 .58211 L .22883 .53932 L F
.26203 .56829 m .28388 .58114 L .29967 .59302 L .732 .752 .868 r
F
.26203 .56829 m .29967 .59302 L .29883 .59322 L F
.30436 .60524 m .30508 .60627 L .25341 .56596 L F
.27289 .57344 m .28388 .58114 L .26203 .56829 L F
.31005 .64838 m .31074 .6496 L .30099 .63858 L .827 .768 .796 r
F
.3145 .71999 m .32155 .76964 L .31636 .72367 L 0 0 .508 r
F
.3123 .71488 m .32029 .7314 L .31154 .71322 L .897 .783 .728 r
F
.32029 .7314 m .32074 .73229 L .31154 .71322 L F
.23606 .55721 m .2401 .56556 L .24111 .56724 L F
.2401 .56556 m .3123 .71488 L .24315 .57146 L F
.2401 .56556 m .24315 .57146 L .24111 .56724 L F
.3123 .71488 m .31154 .71322 L .24111 .56724 L F
.24111 .56724 m .32074 .73229 L .30449 .79021 L .961 .799 .636 r
F
.24111 .56724 m .30449 .79021 L .24581 .57686 L F
.24581 .57686 m .30449 .79021 L .2893 .82312 L .999 .786 .457 r
F
.24581 .57686 m .2893 .82312 L .24971 .58485 L F
.24971 .58485 m .2893 .82312 L .2891 .84541 L .805 .576 .015 r
F
.24971 .58485 m .2891 .84541 L .25287 .59029 L F
.252 .58862 m .25287 .59029 L .25282 .58996 L F
.24971 .58485 m .25287 .59029 L .252 .58862 L F
.32074 .73229 m .32379 .76206 L .30449 .79021 L .961 .799 .636 r
F
.27806 .53174 m .28265 .54454 L .26792 .52926 L .384 .356 .704 r
F
.23224 .52763 m .23745 .53081 L .24097 .53291 L .431 0 0 r
F
.23745 .53081 m .31006 .5751 L .24097 .53291 L F
.23157 .5477 m .29587 .60145 L .30202 .63808 L .827 .768 .796 r
F
.25761 .5811 m .30202 .63808 L .24437 .56762 L F
.30202 .63808 m .30099 .63858 L .24437 .56762 L F
.25761 .5811 m .24437 .56762 L .23606 .55721 L F
.22883 .53932 m .25809 .55796 L .26203 .56829 L .732 .752 .868 r
F
.26203 .56829 m .25341 .56596 L .23157 .5477 L F
.25 g
.5 Mabswid
.30725 .53083 m
.30731 .53116 L
s
.30731 .53116 m
.30743 .53175 L
s
.30743 .53175 m
.30774 .53336 L
s
.30774 .53336 m
.30831 .53625 L
s
.30831 .53625 m
.30847 .53703 L
s
.30847 .53703 m
.30872 .53831 L
s
.30872 .53831 m
.31041 .5469 L
s
.31041 .5469 m
.31584 .57452 L
s
.30628 .5259 m
.30725 .53083 L
s
.31565 .52183 m
.3175 .52707 L
s
.3175 .52707 m
.32603 .55124 L
s
.32603 .55124 m
.3391 .58827 L
s
.3391 .58827 m
.33963 .58978 L
s
.33703 .53403 m
.33862 .53667 L
s
.33862 .53667 m
.35438 .56272 L
s
.35438 .56272 m
.37258 .59282 L
s
.3223 .50968 m
.33703 .53403 L
s
.32884 .49803 m
.33288 .50231 L
s
.33288 .50231 m
.35586 .52661 L
s
.31451 .51861 m
.31565 .52183 L
s
.31424 .51784 m
.31451 .51861 L
s
.57167 .4445 m
.57568 .48444 L
s
0 g
.006 w
.44769 .42243 m
.4607 .41884 L
s
.4607 .41884 m
.47234 .41278 L
s
.47234 .41278 m
.48202 .40438 L
s
.43391 .42371 m
.44769 .42243 L
s
.48202 .40438 m
.48956 .39404 L
s
.62212 .33638 m .798 .46772 L .61916 .34051 L 0 .425 .853 r
F
.25 g
.5 Mabswid
.6183 .34678 m
.61877 .34718 L
s
.62212 .33638 m .81564 .46855 L .798 .46772 L 0 .425 .853 r
F
.25 g
.61518 .38137 m
.62819 .40737 L
s
.62882 .40862 m
.6383 .42758 L
s
.62819 .40737 m
.62882 .40862 L
s
.63363 .37778 m
.66821 .42047 L
s
.66821 .42047 m
.67056 .42337 L
s
.6638 .38634 m
.72278 .43762 L
s
1 0 0 r
.003 w
.76552 .47477 m
.798 .46772 L
s
0 g
.006 w
.41979 .4233 m
.43391 .42371 L
s
.25 g
.5 Mabswid
.42427 .53126 m
.42733 .54906 L
s
.42733 .54906 m
.43624 .60088 L
s
.43624 .60088 m
.43672 .60371 L
s
.43672 .60371 m
.44455 .64922 L
s
1 0 0 r
.003 w
.44455 .64922 m
.45732 .64088 L
s
.25 g
.5 Mabswid
.34433 .44409 m
.3451 .44461 L
s
1 0 0 r
.003 w
.524 .5867 m
.53524 .57509 L
s
0 g
.006 w
.48956 .39404 m
.49533 .38231 L
s
.40553 .42225 m
.41979 .4233 L
s
.49533 .38231 m
.50022 .36986 L
s
.39128 .42186 m
.40553 .42225 L
s
.25 g
.5 Mabswid
.50531 .35748 m
.50682 .35869 L
s
.50682 .35869 m
.5189 .36842 L
s
.5189 .36842 m
.54703 .39107 L
s
.54703 .39107 m
.55316 .39601 L
s
1 0 0 r
.003 w
.66453 .51223 m
.68314 .50069 L
s
0 g
.006 w
.50022 .36986 m
.50531 .35748 L
s
.25 g
.5 Mabswid
.45368 .6288 m
.45557 .63507 L
s
.45557 .63507 m
.45732 .64088 L
s
.37739 .42336 m .50338 .60487 L .36448 .42753 L .691 .543 .68 r
F
.25 g
.40738 .48277 m
.40989 .48775 L
s
.44401 .55537 m
.47897 .62466 L
s
.41096 .48988 m
.44401 .55537 L
s
.40989 .48775 m
.41096 .48988 L
s
0 g
.006 w
.37739 .42336 m
.39128 .42186 L
s
.25 g
.5 Mabswid
.41302 .49396 m
.41361 .49589 L
s
.41361 .49589 m
.4139 .49687 L
s
.43751 .57519 m
.45368 .6288 L
s
.4139 .49687 m
.43751 .57519 L
s
.3451 .44461 m
.38683 .47325 L
s
.39216 .47691 m
.40272 .48415 L
s
.40272 .48415 m
.41091 .48977 L
s
.38683 .47325 m
.39216 .47691 L
s
.37657 .47889 m
.38606 .48461 L
s
.34007 .45689 m
.37657 .47889 L
s
.38606 .48461 m
.4054 .49627 L
s
.37024 .49125 m
.38622 .5012 L
s
.33478 .46919 m
.37024 .49125 L
s
.35916 .5039 m
.38758 .52541 L
s
.35586 .52661 m
.3733 .54506 L
s
0 g
.006 w
.36448 .42753 m
.37739 .42336 L
s
.50531 .35748 m
.51146 .34604 L
s
.25 g
.5 Mabswid
.56828 .48271 m
.57787 .55973 L
s
.56333 .44288 m
.5668 .4708 L
s
.5668 .4708 m
.56828 .48271 L
s
.40926 .48471 m
.41615 .4935 L
s
.41615 .4935 m
.44628 .53197 L
s
.44628 .53197 m
.50338 .60487 L
s
.40218 .47567 m
.40926 .48471 L
s
.3682 .43228 m
.40218 .47567 L
s
.36448 .42753 m
.3682 .43228 L
s
0 g
.006 w
.35326 .43455 m
.36448 .42753 L
s
.25 g
.5 Mabswid
.29735 .53084 m
.29769 .53349 L
s
.29769 .53349 m
.29784 .53467 L
s
.29784 .53467 m
.29799 .53579 L
s
.29829 .53814 m
.29911 .54448 L
s
.29911 .54448 m
.30182 .56552 L
s
.29799 .53579 m
.298 .53589 L
s
.298 .53589 m
.29809 .53658 L
s
.29809 .53658 m
.29829 .53814 L
s
.51146 .34604 m
.51262 .3473 L
s
.51262 .3473 m
.54872 .3865 L
s
.54872 .3865 m
.55022 .38813 L
s
0 g
.006 w
.51146 .34604 m
.51905 .33651 L
s
.25 g
.5 Mabswid
.40132 .47738 m
.4086 .48387 L
s
.36853 .44815 m
.40132 .47738 L
s
.35326 .43455 m
.36853 .44815 L
s
0 g
.006 w
.34433 .44409 m
.35326 .43455 L
s
1 0 0 r
.003 w
.50338 .60487 m
.524 .5867 L
s
.45732 .64088 m
.47897 .62466 L
s
0 g
.006 w
.3378 .45553 m
.34433 .44409 L
s
.53805 .32631 m .60947 .54389 L .52802 .32975 L .538 .463 .72 r
F
.25 g
.5 Mabswid
.52802 .32975 m
.52863 .33135 L
s
.52863 .33135 m
.53105 .33771 L
s
0 g
.006 w
.51905 .33651 m
.52802 .32975 L
s
.25 g
.5 Mabswid
.51905 .33651 m
.54903 .38498 L
s
.56456 .37371 m
.56611 .38917 L
s
.56611 .38917 m
.56689 .39693 L
s
0 g
.006 w
.33322 .46822 m
.3378 .45553 L
s
.3296 .48153 m
.33322 .46822 L
s
1 0 0 r
.003 w
.63753 .52811 m
.66453 .51223 L
s
.53805 .32631 m .58773 .55539 L .60947 .54389 L .538 .463 .72 r
F
.25 g
.5 Mabswid
.53805 .32631 m
.5386 .32886 L
s
.55561 .40731 m
.56903 .46919 L
s
.55308 .39565 m
.55561 .40731 L
s
.5386 .32886 m
.53903 .33083 L
s
.53903 .33083 m
.55308 .39565 L
s
.56903 .46919 m
.58773 .55539 L
s
0 g
.006 w
.52802 .32975 m
.53805 .32631 L
s
.25 g
.5 Mabswid
.60502 .34245 m
.60629 .34402 L
s
.58491 .34269 m
.59833 .39101 L
s
.58335 .33707 m
.58491 .34269 L
s
.57164 .33279 m
.5756 .35959 L
s
.5756 .35959 m
.58117 .39724 L
s
.60629 .34402 m
.6159 .35588 L
s
.59473 .34051 m
.61518 .38137 L
s
.56004 .32874 m
.56034 .3317 L
s
.56034 .3317 m
.56456 .37371 L
s
.56654 .43103 m
.5668 .43172 L
s
.5668 .43172 m
.60947 .54389 L
s
.55308 .39565 m
.56285 .42132 L
s
.53105 .33771 m
.55308 .39565 L
s
.56285 .42132 m
.56654 .43103 L
s
1 0 0 r
.003 w
.57787 .55973 m
.58773 .55539 L
s
0 g
.006 w
.53805 .32631 m
.5488 .32619 L
s
1 0 0 r
.003 w
.47897 .62466 m
.50338 .60487 L
s
0 g
.006 w
.32578 .49479 m
.3296 .48153 L
s
1 0 0 r
.003 w
.58773 .55539 m
.60947 .54389 L
s
0 g
.006 w
.5488 .32619 m
.56004 .32874 L
s
.62274 .33026 m .81564 .46855 L .62212 .33638 L .656 .11 0 r
F
.25 g
.5 Mabswid
.6159 .35588 m
.62252 .36405 L
s
.64177 .3439 m .74166 .42093 L .79324 .45249 L .656 .11 0 r
F
.62524 .33205 m .64159 .34463 L .64177 .3439 L F
.62527 .33219 m .64159 .34463 L .62524 .33205 L F
.62274 .33026 m .62527 .33219 L .62524 .33205 L F
.64159 .34463 m .74166 .42093 L .64177 .3439 L F
.74166 .42093 m .81527 .47705 L .79324 .45249 L F
.62192 .3226 m .81527 .47705 L .62274 .33026 L .855 .451 .271 r
F
.68432 .37245 m .78064 .47475 L .81527 .47705 L F
.78064 .47475 m .80163 .48791 L .81527 .47705 L F
.63601 .33385 m .67351 .37255 L .68432 .37245 L F
.62192 .3226 m .6355 .33575 L .63601 .33385 L F
.6355 .33575 m .67351 .37255 L .63601 .33385 L F
.62997 .40193 m .64663 .54232 L .64191 .54983 L .938 .746 .273 r
F
.67842 .3725 m .6738 .37255 L .62192 .3226 L .834 .552 .512 r
F
.62068 .31426 m .67842 .3725 L .62192 .3226 L F
.77216 .48261 m .80768 .4917 L .78208 .49228 L .328 .626 .959 r
F
.62625 .32677 m .62625 .3268 L .62192 .3226 L .834 .552 .512 r
F
.67351 .37255 m .77621 .47197 L .68432 .37245 L .855 .451 .271 r
F
.77621 .47197 m .78064 .47475 L .68432 .37245 L F
.75896 .45454 m .67378 .37255 L .6738 .37255 L .834 .552 .512 r
F
.77648 .47141 m .75895 .45454 L .75896 .45454 L F
.75895 .45454 m .67378 .37255 L .75896 .45454 L F
.67378 .37255 m .62625 .3268 L .6738 .37255 L F
.6738 .37255 m .62625 .3268 L .62625 .32677 L F
.77648 .47141 m .77621 .47197 L .62625 .3268 L F
.67842 .3725 m .77648 .47141 L .6738 .37255 L F
.62145 .31515 m .70424 .42893 L .72868 .44024 L F
.62068 .31426 m .62168 .31563 L .62145 .31515 L F
.62168 .31563 m .70424 .42893 L .62145 .31515 L F
.62068 .31426 m .72868 .44024 L .71619 .4106 L F
.61972 .30642 m .69392 .41162 L .62068 .31426 L .771 .572 .629 r
F
.69392 .41162 m .70286 .42429 L .69042 .40997 L F
.70286 .42429 m .72868 .44024 L .70329 .42574 L .59 .724 .936 r
F
.69899 .41131 m .71688 .42875 L .70286 .42429 L F
.71688 .42875 m .72868 .44024 L .70286 .42429 L F
.72868 .44024 m .78208 .49228 L .70511 .43186 L F
.70424 .42893 m .70511 .43186 L .69728 .42571 L F
.72868 .44024 m .70511 .43186 L .70424 .42893 L F
.73087 .44544 m .78208 .49228 L .72868 .44024 L .328 .626 .959 r
F
.70424 .42893 m .70591 .43122 L .7599 .45469 L .834 .552 .512 r
F
.73087 .44544 m .77621 .47197 L .77126 .48238 L .328 .626 .959 r
F
.7638 .46419 m .77621 .47197 L .73087 .44544 L F
.70415 .42863 m .70424 .42893 L .69042 .40997 L .771 .572 .629 r
F
.70286 .42429 m .70415 .42863 L .69042 .40997 L F
.69392 .41162 m .69042 .40997 L .62068 .31426 L F
.6202 .30727 m .66651 .40742 L .67788 .40804 L F
.62024 .30756 m .66651 .40742 L .6202 .30727 L F
.61972 .30642 m .67788 .40804 L .6596 .36297 L F
.61972 .30642 m .62024 .30756 L .6202 .30727 L F
.61926 .3004 m .65936 .38891 L .61972 .30642 L .684 .549 .696 r
F
.65936 .38891 m .65893 .38883 L .61972 .30642 L F
.67049 .39708 m .67788 .40804 L .66609 .40601 L .728 .763 .881 r
F
.67049 .39708 m .66609 .40601 L .66439 .40036 L F
.67788 .40804 m .74074 .5013 L .67027 .41992 L F
.66651 .40742 m .67027 .41992 L .6591 .40702 L F
.67788 .40804 m .67027 .41992 L .66651 .40742 L F
.68175 .41758 m .74074 .5013 L .67788 .40804 L .59 .724 .936 r
F
.69193 .4088 m .66756 .40968 L .70286 .42429 L .771 .572 .629 r
F
.66651 .40742 m .66756 .40968 L .69193 .4088 L F
.66756 .40968 m .6694 .41365 L .68635 .41904 L F
.66756 .40968 m .68635 .41904 L .70286 .42429 L F
.68175 .41758 m .78208 .49228 L .74074 .5013 L .59 .724 .936 r
F
.66435 .40021 m .6653 .40339 L .61972 .30642 L .684 .549 .696 r
F
.66641 .40708 m .66651 .40742 L .66536 .40494 L F
.67788 .40804 m .66651 .40742 L .66609 .40601 L .728 .763 .881 r
F
.69044 .42034 m .78208 .49228 L .68175 .41758 L .59 .724 .936 r
F
.69899 .41131 m .70329 .42574 L .68138 .41323 L F
.72868 .44024 m .69728 .42571 L .68138 .41323 L F
.6653 .40339 m .66536 .40494 L .61972 .30642 L .684 .549 .696 r
F
.65101 .38959 m .7004 .51503 L .64796 .39317 L .832 .795 .816 r
F
.6943 .49987 m .7004 .51503 L .69443 .49987 L .728 .763 .881 r
F
.6943 .49987 m .69443 .49987 L .65101 .38959 L F
.65511 .40242 m .6943 .49987 L .65101 .38959 L F
.67027 .41992 m .74074 .5013 L .6943 .49987 L F
.6943 .49987 m .74074 .5013 L .7004 .51503 L F
.6694 .41365 m .72261 .52849 L .70286 .42429 L .771 .572 .629 r
F
.68252 .44001 m .66967 .41374 L .67026 .41393 L .684 .549 .696 r
F
.66967 .41374 m .66641 .40708 L .67026 .41393 L F
.67026 .41393 m .66641 .40708 L .6653 .40339 L F
.66641 .40708 m .66536 .40494 L .6653 .40339 L F
.65511 .40242 m .67027 .41992 L .6943 .49987 L .728 .763 .881 r
F
.66609 .40601 m .6591 .40702 L .65684 .40442 L F
.66651 .40742 m .6591 .40702 L .66609 .40601 L F
.65936 .38891 m .66407 .3993 L .65893 .38883 L .684 .549 .696 r
F
.66407 .3993 m .66435 .40021 L .65893 .38883 L F
.67049 .39708 m .65684 .40442 L .65594 .40213 L .728 .763 .881 r
F
.66407 .3993 m .66722 .40625 L .66435 .40021 L .684 .549 .696 r
F
.61926 .3004 m .64482 .39687 L .65101 .38959 L F
.61926 .3004 m .65101 .38959 L .63016 .32446 L F
.61924 .29739 m .63049 .34036 L .61926 .3004 L .534 .468 .728 r
F
.63049 .34036 m .64213 .38482 L .62904 .33652 L F
.63049 .34036 m .62904 .33652 L .61926 .3004 L F
.64923 .38509 m .65101 .38959 L .64803 .38423 L .832 .795 .816 r
F
.64213 .38482 m .64482 .39687 L .61926 .3004 L .534 .468 .728 r
F
.62108 .30441 m .63112 .34515 L .64213 .38482 L F
.64923 .38509 m .64803 .38423 L .64447 .37783 L .832 .795 .816 r
F
.62065 .30743 m .63533 .376 L .63645 .36435 L .534 .468 .728 r
F
.61924 .29739 m .63112 .34515 L .62108 .30441 L F
.61924 .29739 m .62065 .30743 L .63112 .34515 L F
.63533 .376 m .66733 .5298 L .63362 .39383 L .942 .834 .708 r
F
.63362 .39383 m .66733 .5298 L .63687 .4243 L F
.63328 .39739 m .63687 .4243 L .63224 .40826 L F
.63362 .39383 m .63687 .4243 L .63328 .39739 L F
.63913 .39377 m .66733 .5298 L .63533 .376 L .832 .795 .816 r
F
.63533 .376 m .63465 .40716 L .63913 .39377 L .534 .468 .728 r
F
.63328 .39739 m .63465 .40716 L .63533 .376 L F
.63224 .40826 m .66733 .5298 L .64663 .54232 L .942 .834 .708 r
F
.64077 .40164 m .64967 .41857 L .66733 .5298 L .832 .795 .816 r
F
.63913 .39377 m .64224 .39991 L .64077 .40164 L F
.64224 .39991 m .7004 .51503 L .64077 .40164 L F
.64311 .38189 m .7004 .51503 L .63913 .39377 L F
.63465 .40716 m .65474 .55027 L .64213 .38482 L .534 .468 .728 r
F
.63684 .42195 m .63342 .3984 L .63328 .39739 L .106 .157 .633 r
F
.62065 .30743 m .63328 .39739 L .63533 .376 L .534 .468 .728 r
F
.63178 .38617 m .63328 .39739 L .61924 .29739 L .106 .157 .633 r
F
.63092 .39596 m .63362 .39383 L .63224 .40826 L .942 .834 .708 r
F
.61956 .29816 m .63042 .376 L .61924 .29739 L .106 .157 .633 r
F
.63042 .376 m .63178 .38617 L .61924 .29739 L F
.61956 .29816 m .6206 .30977 L .62439 .33274 L F
.6206 .30977 m .63194 .43756 L .62597 .35462 L F
.6206 .30977 m .62597 .35462 L .62439 .33274 L F
.63194 .43756 m .63154 .42137 L .62439 .33274 L F
.63092 .39596 m .64663 .54232 L .62655 .35947 L .942 .834 .708 r
F
.62655 .35947 m .6273 .36633 L .62715 .3669 L .938 .746 .273 r
F
.6273 .36633 m .64663 .54232 L .62623 .37034 L F
.62439 .33274 m .63154 .42137 L .63042 .376 L .106 .157 .633 r
F
.62179 .31092 m .63092 .39596 L .62033 .30286 L .942 .834 .708 r
F
.63092 .39596 m .62655 .35947 L .62033 .30286 L F
.62179 .31092 m .62976 .34926 L .62845 .37298 L F
.62976 .34926 m .63469 .37292 L .63035 .37296 L F
.62976 .34926 m .63035 .37296 L .62845 .37298 L F
.63194 .43756 m .64191 .54983 L .63154 .42137 L .106 .157 .633 r
F
.62051 .30495 m .62655 .35947 L .62623 .37034 L .938 .746 .273 r
F
.62033 .30286 m .62655 .35947 L .62051 .30495 L F
.62655 .35947 m .62715 .3669 L .62623 .37034 L F
.62845 .37298 m .63056 .38149 L .63092 .39596 L .942 .834 .708 r
F
.63056 .38149 m .63362 .39383 L .63092 .39596 L F
.63533 .376 m .63362 .39383 L .62845 .37298 L F
.63684 .42195 m .63328 .39739 L .63178 .38617 L .106 .157 .633 r
F
.63042 .376 m .63684 .42195 L .63178 .38617 L F
.63684 .42195 m .65474 .55027 L .63342 .3984 L F
.63042 .376 m .64191 .54983 L .65474 .55027 L F
.63154 .42137 m .64191 .54983 L .63042 .376 L F
.63469 .37292 m .63533 .376 L .63012 .37371 L .942 .834 .708 r
F
.63002 .37296 m .63012 .37371 L .62845 .37298 L F
.63469 .37292 m .63012 .37371 L .63002 .37296 L F
.63645 .36435 m .63887 .39253 L .64213 .38482 L .534 .468 .728 r
F
.63533 .376 m .63887 .39253 L .63645 .36435 L F
.63887 .39253 m .63913 .39377 L .63951 .39264 L F
.63887 .39253 m .63951 .39264 L .64213 .38482 L F
.71619 .4106 m .72868 .44024 L .7599 .45469 L .834 .552 .512 r
F
.69306 .40246 m .81194 .4916 L .79561 .48231 L .328 .626 .959 r
F
.64468 .37721 m .64447 .37783 L .63069 .35302 L .832 .795 .816 r
F
.63849 .3578 m .64923 .38509 L .63069 .35302 L F
.64923 .38509 m .64447 .37783 L .64468 .37721 L F
.65101 .38959 m .64796 .39317 L .63069 .35302 L F
.66439 .40036 m .66609 .40601 L .65684 .40442 L .728 .763 .881 r
F
.65594 .40213 m .65684 .40442 L .65511 .40242 L F
.64967 .41857 m .7004 .51503 L .67387 .52688 L .832 .795 .816 r
F
.64482 .39687 m .68348 .54281 L .65666 .38294 L .684 .549 .696 r
F
.638 .35986 m .65423 .40022 L .63849 .3578 L .728 .763 .881 r
F
.65423 .40022 m .65511 .40242 L .65453 .40085 L F
.65423 .40022 m .65453 .40085 L .63849 .3578 L F
.65453 .40085 m .65101 .38959 L .63849 .3578 L F
.65511 .40242 m .65478 .40137 L .65453 .40085 L F
.65478 .40137 m .65101 .38959 L .65453 .40085 L F
.63016 .32446 m .65101 .38959 L .65666 .38294 L .684 .549 .696 r
F
.6241 .32126 m .63849 .3578 L .63069 .35302 L .832 .795 .816 r
F
.62704 .33262 m .638 .35986 L .6241 .32126 L .728 .763 .881 r
F
.638 .35986 m .63849 .3578 L .6241 .32126 L F
.62704 .33262 m .65351 .37188 L .6388 .36045 L F
.65351 .37188 m .67049 .39708 L .6388 .36045 L F
.68252 .44001 m .72261 .52849 L .66651 .40742 L .684 .549 .696 r
F
.68252 .44001 m .66651 .40742 L .66641 .40708 L F
.66722 .40625 m .66738 .4078 L .6653 .40339 L F
.66722 .40625 m .6653 .40339 L .66435 .40021 L F
.66722 .40625 m .68252 .44001 L .66738 .4078 L F
.65666 .38294 m .68348 .54281 L .72261 .52849 L F
.6388 .36045 m .67049 .39708 L .65634 .40199 L .728 .763 .881 r
F
.62704 .33262 m .65634 .40199 L .65423 .40022 L F
.62985 .34393 m .66093 .38804 L .62704 .33262 L .59 .724 .936 r
F
.66093 .38804 m .66479 .39124 L .62704 .33262 L F
.6596 .36297 m .67788 .40804 L .69193 .4088 L .771 .572 .629 r
F
.62623 .37034 m .62997 .40193 L .64191 .54983 L .938 .746 .273 r
F
.63069 .35302 m .63913 .39377 L .62999 .35035 L .832 .795 .816 r
F
.63913 .39377 m .63533 .376 L .62999 .35035 L F
.63069 .35302 m .64311 .38189 L .63913 .39377 L F
.62033 .30286 m .64191 .54983 L .61956 .29816 L .938 .746 .273 r
F
.61904 .3756 m .63992 .38937 L .62642 .37081 L .846 .473 .344 r
F
.68003 .4149 m .67788 .40804 L .62772 .33363 L .59 .724 .936 r
F
.68003 .4149 m .62772 .33363 L .62774 .3337 L F
.68175 .41758 m .68133 .41654 L .68003 .4149 L F
.68133 .41654 m .67788 .40804 L .68003 .4149 L F
.66093 .38804 m .68175 .41758 L .66479 .39124 L F
.67535 .4085 m .69044 .42034 L .68175 .41758 L F
.70591 .43122 m .76344 .51018 L .76038 .46224 L .834 .552 .512 r
F
.70591 .43122 m .76038 .46224 L .7599 .45469 L F
.70654 .42318 m .73087 .44544 L .70268 .41711 L .328 .626 .959 r
F
.69834 .41068 m .69899 .41131 L .68138 .41323 L .59 .724 .936 r
F
.69834 .41068 m .68138 .41323 L .67838 .40878 L F
.62985 .34393 m .69834 .41068 L .67535 .4085 L F
.73087 .44544 m .72868 .44024 L .62985 .34393 L .328 .626 .959 r
F
.79552 .48225 m .80768 .4917 L .7638 .46419 L F
.77621 .47197 m .80768 .4917 L .77126 .48238 L F
.77621 .47197 m .79671 .49182 L .78064 .47475 L .855 .451 .271 r
F
.77126 .48238 m .77216 .48261 L .78208 .49228 L .328 .626 .959 r
F
.77648 .47141 m .79671 .49182 L .77621 .47197 L .834 .552 .512 r
F
.77648 .47141 m .76344 .51018 L .79671 .49182 L F
.7599 .45469 m .76038 .46224 L .77648 .47141 L F
.76038 .46224 m .76344 .51018 L .77648 .47141 L F
.63139 .35444 m .70654 .42318 L .62985 .34393 L .328 .626 .959 r
F
.70654 .42318 m .70268 .41711 L .62985 .34393 L F
.63338 .35626 m .79552 .48225 L .72429 .43942 L F
.79552 .48225 m .7638 .46419 L .72429 .43942 L F
.72429 .43942 m .7638 .46419 L .73087 .44544 L F
.74722 .48718 m .75088 .49295 L .70424 .42893 L .771 .572 .629 r
F
.74722 .48718 m .70424 .42893 L .70415 .42863 L F
.70286 .42429 m .74722 .48718 L .70415 .42863 L F
.74722 .48718 m .76344 .51018 L .75088 .49295 L F
.70286 .42429 m .72261 .52849 L .76344 .51018 L F
.67838 .40878 m .68138 .41323 L .67535 .4085 L .59 .724 .936 r
F
.64213 .38482 m .68348 .54281 L .64482 .39687 L .534 .468 .728 r
F
.64967 .41857 m .67387 .52688 L .66733 .5298 L .832 .795 .816 r
F
.64213 .38482 m .65474 .55027 L .68348 .54281 L .534 .468 .728 r
F
.63992 .38937 m .76624 .47266 L .63758 .37867 L .846 .473 .344 r
F
.78064 .47475 m .79671 .49182 L .80163 .48791 L .855 .451 .271 r
F
.76624 .47266 m .84083 .52185 L .7602 .46505 L .846 .473 .344 r
F
.76624 .47266 m .7602 .46505 L .63758 .37867 L F
.63992 .38937 m .63758 .37867 L .62642 .37081 L F
.62774 .3337 m .62772 .33363 L .62704 .33262 L .59 .724 .936 r
F
.63322 .35611 m .63333 .3562 L .63338 .35626 L .328 .626 .959 r
F
.63333 .3562 m .80768 .4917 L .63338 .35626 L F
.63139 .35444 m .63303 .35572 L .63322 .35611 L F
.63303 .35572 m .80768 .4917 L .63322 .35611 L F
.63303 .35572 m .69509 .40283 L .69306 .40246 L F
.63139 .35444 m .633 .35567 L .63303 .35572 L F
.633 .35567 m .69509 .40283 L .63303 .35572 L F
.65423 .40022 m .65634 .40199 L .65511 .40242 L .728 .763 .881 r
F
.69509 .40283 m .81194 .4916 L .69306 .40246 L .328 .626 .959 r
F
.7737 .46255 m .81717 .49148 L .81194 .4916 L F
.6646 .37967 m .78617 .46876 L .7737 .46255 L F
.78617 .46876 m .81717 .49148 L .7737 .46255 L F
.66452 .37888 m .81717 .49148 L .6646 .37967 L F
.63139 .35444 m .66452 .37888 L .6646 .37967 L F
.6305 .36358 m .81717 .49148 L .63139 .35444 L 0 .276 .709 r
F
.71528 .42167 m .82436 .49179 L .7844 .46903 L F
.79561 .48231 m .81194 .4916 L .80768 .4917 L .328 .626 .959 r
F
.7844 .46903 m .83871 .50127 L .81717 .49148 L 0 .276 .709 r
F
.82436 .49179 m .83871 .50127 L .7844 .46903 L F
.6466 .38321 m .84083 .52185 L .83871 .50127 L .762 .25 0 r
F
.62642 .37081 m .64752 .38568 L .6466 .38321 L F
.64752 .38568 m .84083 .52185 L .6466 .38321 L F
.63598 .36734 m .67262 .39144 L .67059 .39105 L 0 .276 .709 r
F
.6305 .36358 m .63521 .36669 L .63598 .36734 L F
.63521 .36669 m .67262 .39144 L .63598 .36734 L F
.67059 .39105 m .72257 .4251 L .71528 .42167 L F
.72257 .4251 m .82436 .49179 L .71528 .42167 L F
.67262 .39144 m .82436 .49179 L .67059 .39105 L F
.6241 .32126 m .63069 .35302 L .62179 .31092 L .832 .795 .816 r
F
.63069 .35302 m .62999 .35035 L .62179 .31092 L F
.79324 .45249 m .81527 .47705 L .81564 .46855 L .656 .11 0 r
F
.25 g
.62252 .36405 m
.62577 .36807 L
s
.61877 .34718 m
.6208 .34896 L
s
.6208 .34896 m
.6213 .34939 L
s
.6213 .34939 m
.623 .35087 L
s
.623 .35087 m
.62435 .35204 L
s
.61916 .34051 m
.61939 .34068 L
s
.61939 .34068 m
.62049 .34146 L
s
.62049 .34146 m
.62099 .34182 L
s
.62099 .34182 m
.6232 .34339 L
s
.6232 .34339 m
.62361 .34368 L
s
.62212 .33638 m
.62301 .33699 L
s
1 0 0 r
.003 w
.81527 .47705 m
.81564 .46855 L
s
0 g
.006 w
.32079 .50719 m
.32578 .49479 L
s
.56004 .32874 m
.57164 .33279 L
s
.31424 .51784 m
.32079 .50719 L
s
1 0 0 r
.003 w
.60947 .54389 m
.63753 .52811 L
s
0 g
.006 w
.57164 .33279 m
.58335 .33707 L
s
.30628 .5259 m
.31424 .51784 L
s
.25 g
.5 Mabswid
.22883 .53932 m
.23013 .54015 L
s
0 g
.006 w
.58335 .33707 m
.59473 .34051 L
s
.29826 .53034 m
.30628 .5259 L
s
.29751 .53075 m
.29826 .53034 L
s
.29735 .53084 m
.29751 .53075 L
s
.59473 .34051 m
.60502 .34245 L
s
.25 g
.5 Mabswid
.32104 .76607 m
.32155 .76964 L
s
1 0 0 r
.003 w
.32452 .76917 m
.33291 .76784 L
s
.32155 .76964 m
.32452 .76917 L
s
.25 g
.5 Mabswid
.31154 .71322 m
.31331 .71689 L
s
.31331 .71689 m
.32074 .73229 L
s
.28606 .66041 m
.29612 .68126 L
s
.29612 .68126 m
.30084 .69105 L
s
.30084 .69105 m
.31154 .71322 L
s
1 0 0 r
.003 w
.31895 .76913 m
.32379 .76206 L
s
.30449 .79021 m
.31895 .76913 L
s
0 g
.006 w
.60502 .34245 m
.61339 .34251 L
s
.28788 .53261 m
.29735 .53084 L
s
.25 g
.5 Mabswid
.6241 .32126 m
.63072 .33808 L
s
.62704 .33262 m
.64389 .35761 L
s
0 g
.006 w
.61339 .34251 m
.61916 .34051 L
s
.28653 .53249 m
.28788 .53261 L
s
.27806 .53174 m
.28653 .53249 L
s
.25 g
.5 Mabswid
.62179 .31092 m
.62207 .3123 L
s
.62207 .3123 m
.62976 .34926 L
s
.62976 .34926 m
.62999 .35035 L
s
.62999 .35035 m
.63121 .35623 L
s
.63468 .37287 m
.63533 .376 L
s
0 g
.006 w
.61916 .34051 m
.61993 .33944 L
s
.61993 .33944 m
.62038 .33881 L
s
.62038 .33881 m
.62085 .33816 L
s
.62085 .33816 m
.62212 .33638 L
s
1 0 0 r
.003 w
.80928 .48182 m
.81527 .47705 L
s
.25 g
.5 Mabswid
.63001 .34409 m
.63021 .34428 L
s
.62985 .34393 m
.63001 .34409 L
s
.31253 .68011 m
.33291 .76784 L
s
0 g
.006 w
.62212 .33638 m
.62257 .33197 L
s
.23873 .52504 m .4459 .65797 L .23224 .52763 L .838 .475 .366 r
F
.25 g
.5 Mabswid
.23224 .52763 m
.24211 .53365 L
s
.24211 .53365 m
.28779 .56152 L
s
.28779 .56152 m
.30065 .56937 L
s
.30065 .56937 m
.31034 .57527 L
s
.31034 .57527 m
.31698 .57933 L
s
.31698 .57933 m
.31967 .58096 L
s
.35063 .59985 m
.4459 .65797 L
s
.3412 .5941 m
.35063 .59985 L
s
.33353 .58942 m
.3412 .5941 L
s
.31967 .58096 m
.33353 .58942 L
s
0 g
.006 w
.26792 .52926 m
.27806 .53174 L
s
1 0 0 r
.003 w
.44029 .65348 m
.4459 .65797 L
s
.25 g
.5 Mabswid
.22887 .5325 m
.23766 .53752 L
s
.28092 .56228 m
.28679 .56564 L
s
.28679 .56564 m
.30178 .57422 L
s
.23766 .53752 m
.28092 .56228 L
s
.30178 .57422 m
.31192 .58002 L
s
.25313 .59215 m
.25333 .59257 L
s
.25333 .59257 m
.27002 .62716 L
s
.27002 .62716 m
.28606 .66041 L
s
.2576 .55764 m
.28664 .57614 L
s
.28664 .57614 m
.29303 .58021 L
s
.23013 .54015 m
.2576 .55764 L
s
.29451 .58115 m
.30415 .58729 L
s
.29303 .58021 m
.29451 .58115 L
s
.30415 .58729 m
.30961 .59077 L
s
.23704 .55844 m
.24437 .56762 L
s
.29171 .62696 m
.30099 .63858 L
s
.27392 .60465 m
.28865 .62311 L
s
.28865 .62311 m
.29171 .62696 L
s
.25073 .57559 m
.25154 .5766 L
s
.25154 .5766 m
.26902 .59852 L
s
.26902 .59852 m
.27392 .60465 L
s
.24437 .56762 m
.25073 .57559 L
s
.30467 .64319 m
.31307 .65372 L
s
.30099 .63858 m
.30467 .64319 L
s
.23606 .55721 m
.23704 .55844 L
s
.2331 .54898 m
.25341 .56596 L
s
.23157 .5477 m
.2331 .54898 L
s
.28186 .58974 m
.28721 .59422 L
s
.28721 .59422 m
.29587 .60145 L
s
.25341 .56596 m
.26869 .57873 L
s
.26869 .57873 m
.28186 .58974 L
s
.29941 .60442 m
.30805 .61164 L
s
.29587 .60145 m
.29941 .60442 L
s
.30805 .61164 m
.30988 .61317 L
s
1 0 0 r
.003 w
.4377 .67451 m
.4459 .65797 L
s
.25 g
.5 Mabswid
.25646 .61559 m
.26225 .63666 L
s
.26225 .63666 m
.28279 .71131 L
s
.28279 .71131 m
.30449 .79021 L
s
1 0 0 r
.003 w
.2893 .82312 m
.30449 .79021 L
s
.33291 .76784 m
.35734 .75259 L
s
.25 g
.5 Mabswid
.30725 .62748 m
.33136 .68769 L
s
.33136 .68769 m
.35734 .75259 L
s
.30556 .62327 m
.30725 .62748 L
s
0 g
.006 w
.25758 .52651 m
.26792 .52926 L
s
.25 g
.5 Mabswid
.62033 .30286 m
.62053 .30469 L
s
.62075 .30668 m
.62655 .35947 L
s
.62053 .30469 m
.62075 .30668 L
s
.30477 .59933 m
.34134 .65575 L
s
.30402 .59817 m
.30477 .59933 L
s
.30056 .59282 m
.30402 .59817 L
s
.34134 .65575 m
.3735 .70537 L
s
.3735 .70537 m
.38803 .7278 L
s
0 g
.006 w
.24754 .5248 m
.25758 .52651 L
s
.62068 .31426 m
.62146 .31947 L
s
.25 g
.5 Mabswid
.30856 .5775 m
.34501 .60488 L
s
.34501 .60488 m
.36771 .62193 L
s
.36771 .62193 m
.4377 .67451 L
s
.30371 .57386 m
.30856 .5775 L
s
.30071 .5716 m
.30371 .57386 L
s
.28977 .56338 m
.30071 .5716 L
s
.28513 .55989 m
.28977 .56338 L
s
1 0 0 r
.003 w
.41704 .6996 m
.4377 .67451 L
s
.25 g
.5 Mabswid
.63139 .35444 m
.63298 .35561 L
s
.30333 .58234 m
.36053 .64132 L
s
.36053 .64132 m
.41704 .6996 L
s
.30186 .58082 m
.30333 .58234 L
s
.2951 .57385 m
.30186 .58082 L
s
0 g
.006 w
.23873 .52504 m
.24754 .5248 L
s
1 0 0 r
.003 w
.76344 .51018 m
.79594 .49224 L
s
.35734 .75259 m
.38803 .7278 L
s
.25 g
.5 Mabswid
.63194 .43756 m
.64191 .54983 L
s
.63096 .42644 m
.63194 .43756 L
s
.6206 .30977 m
.62604 .37105 L
s
.6269 .38078 m
.62773 .3901 L
s
.61956 .29816 m
.6206 .30977 L
s
.62773 .3901 m
.62842 .39792 L
s
.63015 .41741 m
.63096 .42644 L
s
.62913 .40584 m
.63015 .41741 L
s
.62842 .39792 m
.62913 .40584 L
s
1 0 0 r
.003 w
.64191 .54983 m
.65474 .55027 L
s
.25 g
.5 Mabswid
.62068 .31426 m
.62104 .31475 L
s
0 g
.006 w
.61972 .30642 m
.62068 .31426 L
s
1 0 0 r
.003 w
.38803 .7278 m
.41704 .6996 L
s
0 g
.006 w
.23224 .52763 m
.23873 .52504 L
s
.25 g
.5 Mabswid
.26612 .68362 m
.2893 .82312 L
s
.61972 .30642 m
.62024 .30756 L
s
.62024 .30756 m
.62043 .30797 L
s
0 g
.006 w
.61926 .3004 m
.61972 .30642 L
s
.22887 .5325 m
.23224 .52763 L
s
.25 g
.5 Mabswid
.61924 .29739 m
.61993 .30234 L
s
1 0 0 r
.003 w
.65474 .55027 m
.68348 .54281 L
s
.25 g
.5 Mabswid
.61926 .3004 m
.61966 .30191 L
s
.61966 .30191 m
.62002 .30325 L
s
0 g
.006 w
.61924 .29739 m
.61926 .3004 L
s
1 0 0 r
.003 w
.72261 .52849 m
.76344 .51018 L
s
0 g
.006 w
.22883 .53932 m
.22887 .5325 L
s
.62642 .37081 m .83871 .50127 L .6305 .36358 L .762 .25 0 r
F
.25 g
.5 Mabswid
.7289 .42866 m
.83871 .50127 L
s
.6305 .36358 m
.6432 .37198 L
s
.74066 .43505 m
.75884 .44846 L
s
.70752 .4106 m
.74066 .43505 L
s
.69431 .40086 m
.70752 .4106 L
s
.66452 .37888 m
.69431 .40086 L
s
.66326 .37649 m
.66943 .3825 L
s
0 g
.006 w
.61924 .29739 m
.61956 .29816 L
s
1 0 0 r
.003 w
.68348 .54281 m
.72261 .52849 L
s
0 g
.006 w
.22883 .53932 m
.23157 .5477 L
s
.61956 .29816 m
.62033 .30286 L
s
.26375 .53858 m .39011 .62939 L .27118 .53371 L .489 .715 .971 r
F
.39011 .62939 m .43296 .66018 L .38943 .62615 L F
.39011 .62939 m .38943 .62615 L .27118 .53371 L F
.43296 .66018 m .43128 .65752 L .35574 .5991 L F
.35546 .5996 m .35574 .5991 L .27118 .53371 L F
.43296 .66018 m .35574 .5991 L .35546 .5996 L F
.43296 .66018 m .45782 .67805 L .43128 .65752 L F
.26375 .53858 m .44636 .65174 L .45782 .67805 L F
.44636 .65174 m .4804 .67283 L .46834 .67562 L F
.44636 .65174 m .46834 .67562 L .45782 .67805 L F
.25976 .54556 m .4804 .67283 L .26375 .53858 L .466 0 0 r
F
.39566 .65347 m .44931 .69275 L .42473 .72024 L .93 .812 .708 r
F
.40573 .64573 m .44931 .69275 L .40635 .6613 L F
.39969 .65037 m .40635 .6613 L .39566 .65347 L F
.40573 .64573 m .40635 .6613 L .39969 .65037 L F
.25849 .56406 m .39247 .64597 L .25843 .55428 L .811 .539 .527 r
F
.39247 .64597 m .39236 .64539 L .25843 .55428 L F
.39969 .65037 m .3959 .64416 L .39153 .64131 L F
.39236 .64539 m .39153 .64131 L .25843 .55428 L F
.39969 .65037 m .39153 .64131 L .39236 .64539 L F
.38797 .62055 m .40663 .63168 L .40826 .63242 L .466 0 0 r
F
.38795 .62077 m .41236 .63509 L .38797 .62055 L F
.40826 .63242 m .41236 .63509 L .42141 .64011 L F
.38805 .61956 m .42141 .64011 L .44911 .65479 L F
.25976 .54556 m .38797 .62055 L .38805 .61956 L F
.38797 .62055 m .42141 .64011 L .38805 .61956 L F
.31786 .51092 m .38539 .57856 L .39664 .60948 L .822 .794 .826 r
F
.25976 .54556 m .38795 .62077 L .38797 .62055 L .466 0 0 r
F
.39247 .64597 m .39969 .65037 L .39236 .64539 L .811 .539 .527 r
F
.25849 .56406 m .37993 .66556 L .39401 .65474 L F
.39247 .64597 m .39401 .65474 L .39969 .65037 L F
.25849 .56406 m .39401 .65474 L .39247 .64597 L F
.35927 .60933 m .40894 .63645 L .3604 .60687 L .837 .442 .298 r
F
.40894 .63645 m .41799 .64139 L .40621 .63149 L F
.41236 .63509 m .42091 .63985 L .42236 .64255 L .822 .794 .826 r
F
.41799 .64139 m .42236 .64255 L .42738 .6519 L F
.41236 .63509 m .42236 .64255 L .41799 .64139 L F
.44911 .65479 m .42141 .64011 L .4804 .67283 L .466 0 0 r
F
.42141 .64011 m .48084 .67318 L .4804 .67283 L F
.41236 .63509 m .42091 .63985 L .42141 .64011 L F
.42091 .63985 m .48084 .67318 L .42141 .64011 L F
.39104 .58422 m .47869 .67201 L .45825 .68644 L .822 .794 .826 r
F
.42738 .6519 m .45825 .68644 L .44931 .69275 L F
.39104 .58422 m .45825 .68644 L .42738 .6519 L F
.41799 .64139 m .41236 .63509 L .40621 .63149 L .837 .442 .298 r
F
.40894 .63645 m .40621 .63149 L .36121 .60508 L F
.3604 .60687 m .36121 .60508 L .25976 .54556 L F
.40894 .63645 m .36121 .60508 L .3604 .60687 L F
.38689 .54338 m .38742 .54769 L .38903 .53956 L .037 .128 .631 r
F
.40663 .63168 m .41236 .63509 L .40826 .63242 L .466 0 0 r
F
.3694 .58221 m .42091 .63985 L .40445 .63069 L .822 .794 .826 r
F
.31786 .51092 m .36933 .57531 L .3694 .58221 L F
.36933 .57531 m .42091 .63985 L .3694 .58221 L F
.41799 .64139 m .4404 .65363 L .41236 .63509 L .837 .442 .298 r
F
.4404 .65363 m .4332 .64732 L .41236 .63509 L F
.25843 .55428 m .32887 .60034 L .36295 .61604 L F
.35927 .60933 m .36295 .61604 L .38937 .62821 L F
.38902 .62607 m .38937 .62821 L .40847 .63701 L F
.35927 .60933 m .38937 .62821 L .38902 .62607 L F
.38893 .62553 m .40847 .63701 L .40894 .63645 L F
.35927 .60933 m .38902 .62607 L .38893 .62553 L F
.38902 .62607 m .40847 .63701 L .38893 .62553 L F
.32887 .60034 m .37368 .62963 L .4072 .63853 L F
.40766 .63798 m .4072 .63853 L .41081 .63949 L F
.32887 .60034 m .4072 .63853 L .40766 .63798 L F
.32887 .60034 m .41081 .63949 L .41799 .64139 L F
.40894 .63645 m .40847 .63701 L .41799 .64139 L F
.40445 .63069 m .41236 .63509 L .44931 .69275 L .822 .794 .826 r
F
.41236 .63509 m .42738 .6519 L .44931 .69275 L F
.41081 .63949 m .44931 .69275 L .4178 .64283 L F
.37368 .62963 m .3959 .64416 L .41799 .64139 L .837 .442 .298 r
F
.4178 .64283 m .44931 .69275 L .41528 .64298 L .93 .812 .708 r
F
.39172 .64442 m .40573 .64573 L .39566 .65347 L F
.3959 .64416 m .41947 .64273 L .41799 .64139 L .837 .442 .298 r
F
.38039 .61838 m .40383 .64368 L .39172 .64442 L .93 .812 .708 r
F
.40383 .64368 m .40573 .64573 L .39172 .64442 L F
.39969 .65037 m .39915 .6549 L .40265 .65219 L .811 .539 .527 r
F
.39915 .6549 m .40163 .65591 L .40265 .65219 L F
.39566 .65347 m .42473 .72024 L .40176 .65597 L .93 .812 .708 r
F
.39708 .67233 m .39743 .6743 L .40265 .65219 L .811 .539 .527 r
F
.38756 .60734 m .41081 .63949 L .40509 .6227 L .822 .794 .826 r
F
.41081 .63949 m .4178 .64283 L .41341 .63588 L F
.41236 .63509 m .4332 .64732 L .48084 .67318 L .466 0 0 r
F
.40864 .63312 m .41341 .63588 L .40509 .6227 L .822 .794 .826 r
F
.41081 .63949 m .41341 .63588 L .40864 .63312 L F
.4332 .64732 m .49155 .68155 L .48914 .67967 L .466 0 0 r
F
.4332 .64732 m .48914 .67967 L .48084 .67318 L F
.40873 .63339 m .44931 .69275 L .38039 .61838 L .93 .812 .708 r
F
.39969 .65037 m .4873 .70393 L .3959 .64416 L .811 .539 .527 r
F
.37993 .66556 m .39627 .67921 L .39708 .67233 L F
.39401 .65474 m .39708 .67233 L .39969 .65037 L F
.37993 .66556 m .39708 .67233 L .39401 .65474 L F
.39566 .65347 m .40176 .65597 L .39903 .64832 L .93 .812 .708 r
F
.39566 .65347 m .39903 .64832 L .39295 .64508 L F
.39534 .65274 m .39566 .65347 L .3954 .65266 L F
.31786 .51092 m .38756 .60734 L .33154 .50616 L .822 .794 .826 r
F
.39664 .60948 m .39104 .58422 L .42091 .63985 L F
.38539 .57856 m .39104 .58422 L .39664 .60948 L F
.38756 .60734 m .40509 .6227 L .33154 .50616 L F
.37335 .5724 m .41341 .63588 L .34872 .54564 L .93 .812 .708 r
F
.41341 .63588 m .40873 .63339 L .34872 .54564 L F
.34872 .54564 m .40873 .63339 L .38039 .61838 L F
.33154 .50616 m .37335 .5724 L .34872 .54564 L F
.39534 .65274 m .3954 .65266 L .34747 .50401 L F
.33154 .50616 m .39534 .65274 L .34747 .50401 L F
.39915 .6549 m .39708 .67233 L .40163 .65591 L .811 .539 .527 r
F
.39708 .67233 m .39627 .67921 L .39743 .6743 L F
.40044 .6557 m .42473 .72024 L .3989 .67588 L .999 .797 .489 r
F
.25871 .5739 m .35107 .68368 L .39828 .68404 L .752 .551 .623 r
F
.35107 .68368 m .39437 .73514 L .39742 .6952 L F
.35107 .68368 m .39742 .6952 L .39828 .68404 L F
.25871 .5739 m .39828 .68404 L .25849 .56406 L F
.39759 .67363 m .42473 .72024 L .40254 .6943 L .999 .797 .489 r
F
.39759 .67363 m .40254 .6943 L .39627 .67921 L F
.39828 .68404 m .39938 .68492 L .39627 .67921 L .752 .551 .623 r
F
.39903 .64832 m .42473 .72024 L .39809 .64944 L .999 .797 .489 r
F
.39938 .68492 m .41931 .70065 L .39869 .68146 L .752 .551 .623 r
F
.39938 .68492 m .39869 .68146 L .39627 .67921 L F
.41931 .70065 m .41478 .69469 L .39627 .67921 L F
.39828 .68404 m .39627 .67921 L .25849 .56406 L F
.39627 .67921 m .40254 .6943 L .39483 .68529 L .999 .797 .489 r
F
.39828 .68404 m .40013 .68957 L .39921 .68479 L .752 .551 .623 r
F
.40013 .68957 m .40031 .69011 L .39921 .68479 L F
.39921 .68479 m .40031 .69011 L .39938 .68492 L F
.39483 .68529 m .42473 .72024 L .41159 .74944 L .999 .797 .489 r
F
.39742 .6952 m .41159 .74944 L .4014 .69619 L F
.4014 .69619 m .41159 .74944 L .40181 .69847 L .724 .488 0 r
F
.39437 .73514 m .41213 .75625 L .39828 .68404 L .752 .551 .623 r
F
.40181 .69847 m .41159 .74944 L .40223 .70087 L .724 .488 0 r
F
.41213 .75625 m .40031 .69011 L .39828 .68404 L .752 .551 .623 r
F
.40044 .6557 m .3989 .67588 L .3895 .65973 L .999 .797 .489 r
F
.39742 .6952 m .4014 .69619 L .39975 .68761 L F
.39743 .6743 m .41478 .69469 L .40265 .65219 L .811 .539 .527 r
F
.39627 .67921 m .39863 .68119 L .39743 .6743 L F
.39863 .68119 m .41478 .69469 L .39743 .6743 L F
.38706 .65555 m .39759 .67363 L .39483 .68529 L .999 .797 .489 r
F
.39709 .68636 m .39975 .68761 L .39651 .67064 L F
.39742 .6952 m .39975 .68761 L .39709 .68636 L F
.39809 .64944 m .40044 .6557 L .3895 .65973 L F
.3959 .64416 m .41656 .65768 L .41947 .64273 L .837 .442 .298 r
F
.39295 .64508 m .39903 .64832 L .34747 .50401 L .93 .812 .708 r
F
.37837 .59704 m .39809 .64944 L .38706 .65555 L .999 .797 .489 r
F
.39809 .64944 m .3895 .65973 L .38706 .65555 L F
.36841 .56264 m .39044 .62428 L .35938 .54618 L F
.39044 .62428 m .38825 .62328 L .35677 .53962 L F
.39224 .66504 m .39651 .67064 L .36464 .50418 L F
.39742 .6952 m .39651 .67064 L .39224 .66504 L F
.39569 .66658 m .39987 .68827 L .39573 .66682 L .724 .488 0 r
F
.39987 .68827 m .4014 .69619 L .39989 .68837 L F
.39987 .68827 m .39989 .68837 L .39573 .66682 L F
.41478 .69469 m .46594 .73745 L .44464 .70875 L .811 .539 .527 r
F
.41478 .69469 m .44464 .70875 L .40265 .65219 L F
.4005 .69188 m .41159 .74944 L .40164 .69837 L .724 .488 0 r
F
.25834 .58254 m .38417 .81418 L .41762 .78653 L .676 .528 .677 r
F
.41195 .75517 m .41159 .74944 L .41428 .76697 L .724 .488 0 r
F
.25834 .58254 m .41762 .78653 L .41236 .75744 L .676 .528 .677 r
F
.25834 .58254 m .41236 .75744 L .25871 .5739 L F
.41236 .75744 m .41213 .75625 L .25871 .5739 L F
.41014 .74632 m .41428 .76697 L .41542 .77442 L .724 .488 0 r
F
.40846 .73739 m .41428 .76697 L .41014 .74632 L F
.41236 .75744 m .41762 .78653 L .42941 .77679 L .676 .528 .677 r
F
.40846 .73739 m .40939 .74096 L .41195 .75517 L .724 .488 0 r
F
.40939 .74096 m .41159 .74944 L .41195 .75517 L F
.40164 .69837 m .41159 .74944 L .40846 .73739 L F
.41213 .75625 m .42608 .77284 L .40031 .69011 L .752 .551 .623 r
F
.42608 .77284 m .42941 .77679 L .42828 .77343 L F
.42608 .77284 m .42828 .77343 L .40031 .69011 L F
.41236 .75744 m .42642 .77339 L .41213 .75625 L .676 .528 .677 r
F
.42642 .77339 m .42608 .77284 L .41213 .75625 L F
.41014 .74632 m .41453 .76971 L .41241 .75011 L .724 .488 0 r
F
.41453 .76971 m .41542 .77442 L .41485 .7698 L F
.41453 .76971 m .41485 .7698 L .41241 .75011 L F
.40011 .68967 m .40181 .69847 L .4005 .69188 L F
.40181 .69847 m .40223 .70087 L .4005 .69188 L F
.39544 .66506 m .39651 .67064 L .39569 .66658 L F
.39651 .67064 m .4014 .69619 L .39569 .66658 L F
.4014 .69619 m .40181 .69847 L .39573 .66682 L F
.39938 .68492 m .42941 .77679 L .46594 .73745 L .752 .551 .623 r
F
.40031 .69011 m .42941 .77679 L .39938 .68492 L F
.39573 .66682 m .40011 .68967 L .39605 .66876 L .724 .488 0 r
F
.40011 .68967 m .4005 .69188 L .39605 .66876 L F
.37872 .57825 m .39573 .66682 L .37652 .56743 L F
.39573 .66682 m .39605 .66876 L .37652 .56743 L F
.38766 .62443 m .39544 .66506 L .38764 .6247 L F
.39544 .66506 m .39573 .66682 L .38764 .6247 L F
.39044 .62428 m .39903 .64832 L .38825 .62328 L .999 .797 .489 r
F
.39903 .64832 m .39809 .64944 L .38825 .62328 L F
.38761 .625 m .4005 .69188 L .38753 .62603 L .724 .488 0 r
F
.4005 .69188 m .40164 .69837 L .38753 .62603 L F
.38753 .62603 m .40164 .69837 L .40846 .73739 L F
.37652 .56743 m .38761 .625 L .38753 .62603 L F
.38043 .58665 m .38766 .62443 L .37872 .57825 L F
.38766 .62443 m .38764 .6247 L .37872 .57825 L F
.37247 .54507 m .38043 .58665 L .37104 .53828 L F
.38043 .58665 m .37872 .57825 L .37104 .53828 L F
.37104 .53828 m .37872 .57825 L .37652 .56743 L F
.36464 .50418 m .37247 .54507 L .37104 .53828 L F
.36464 .50418 m .41014 .74632 L .38226 .5059 L F
.41014 .74632 m .41241 .75011 L .38226 .5059 L F
.42642 .77339 m .42941 .77679 L .42608 .77284 L .676 .528 .677 r
F
.41931 .70065 m .46594 .73745 L .41478 .69469 L .752 .551 .623 r
F
.36464 .55207 m .36841 .56264 L .35677 .53962 L .999 .797 .489 r
F
.36841 .56264 m .35938 .54618 L .35677 .53962 L F
.35677 .53962 m .37837 .59704 L .38706 .65555 L F
.34747 .50401 m .36464 .55207 L .35677 .53962 L F
.34747 .50401 m .39742 .6952 L .36464 .50418 L F
.41656 .65768 m .4873 .70393 L .46424 .68313 L .837 .442 .298 r
F
.41656 .65768 m .46424 .68313 L .41947 .64273 L F
.41341 .63588 m .4178 .64283 L .40873 .63339 L .93 .812 .708 r
F
.4178 .64283 m .41528 .64298 L .40873 .63339 L F
.25843 .55428 m .36295 .61604 L .35927 .60933 L .837 .442 .298 r
F
.38742 .54769 m .40541 .69337 L .38944 .54327 L .037 .128 .631 r
F
.40541 .69337 m .41542 .77442 L .40654 .69543 L F
.40541 .69337 m .40654 .69543 L .38944 .54327 L F
.38742 .54769 m .38944 .54327 L .38903 .53956 L F
.4404 .65363 m .49155 .68155 L .4332 .64732 L .837 .442 .298 r
F
.41799 .64139 m .4873 .70393 L .49155 .68155 L F
.40265 .65219 m .46594 .73745 L .4873 .70393 L .811 .539 .527 r
F
.38967 .54277 m .41542 .77442 L .43919 .78916 L .037 .128 .631 r
F
.38903 .53956 m .38944 .54327 L .38967 .54277 L F
.38944 .54327 m .41542 .77442 L .38967 .54277 L F
.25843 .55428 m .35927 .60933 L .25976 .54556 L .837 .442 .298 r
F
.35927 .60933 m .3604 .60687 L .25976 .54556 L F
.38226 .5059 m .38689 .54338 L .38903 .53956 L .037 .128 .631 r
F
.25 g
.5 Mabswid
.27118 .53371 m
.27274 .53491 L
s
.27274 .53491 m
.27886 .53965 L
s
.27886 .53965 m
.33285 .5814 L
s
0 g
.006 w
.23157 .5477 m
.23606 .55721 L
s
.23606 .55721 m
.24111 .56724 L
s
.25282 .58996 m .2891 .84541 L .30636 .85228 L 0 0 .537 r
F
.25 g
.5 Mabswid
.25287 .59029 m
.25421 .59973 L
s
.25421 .59973 m
.25461 .6026 L
s
.25461 .6026 m
.25621 .61385 L
s
.25621 .61385 m
.2891 .84541 L
s
0 g
.006 w
.62033 .30286 m
.62179 .31092 L
s
.51105 .39891 m .59784 .60131 L .52136 .38664 L .818 .801 .836 r
F
.5242 .39851 m .55764 .4906 L .53547 .44556 L .947 .836 .701 r
F
.55764 .4906 m .55602 .48954 L .53547 .44556 L F
.56157 .50142 m .5591 .49853 L .53547 .44556 L F
.56674 .51565 m .55597 .49676 L .54822 .47738 L F
.54977 .4776 m .54822 .47738 L .53547 .44556 L F
.56674 .51565 m .54822 .47738 L .54977 .4776 L F
.52363 .393 m .54804 .46152 L .5242 .39851 L F
.54804 .46152 m .59784 .60131 L .54721 .46187 L F
.54804 .46152 m .54721 .46187 L .5242 .39851 L F
.52136 .38664 m .52363 .393 L .5242 .39851 L F
.52136 .38664 m .53547 .44556 L .53324 .37775 L F
.51306 .40329 m .53547 .44556 L .5551 .49457 L .818 .801 .836 r
F
.51105 .39891 m .5551 .49457 L .55813 .50869 L F
.55813 .50869 m .5551 .49457 L .59784 .60131 L F
.53547 .44556 m .59784 .60131 L .57706 .61924 L .947 .836 .701 r
F
.55764 .4906 m .56157 .50142 L .55602 .48954 L F
.56157 .50142 m .56674 .51565 L .5591 .49853 L F
.56674 .51565 m .59784 .60131 L .55597 .49676 L F
.53547 .44556 m .55078 .47445 L .53324 .37775 L F
.53743 .40087 m .55078 .47445 L .54678 .45578 L .949 .74 .277 r
F
.55311 .48961 m .62849 .58582 L .59784 .60131 L .818 .801 .836 r
F
.55291 .47101 m .62849 .58582 L .55311 .48961 L F
.55286 .46545 m .55388 .46707 L .55291 .47101 L F
.55388 .46707 m .62849 .58582 L .55291 .47101 L F
.52688 .4241 m .55286 .46545 L .55311 .48961 L F
.54957 .47216 m .552 .48115 L .55078 .47445 L .947 .836 .701 r
F
.53547 .44556 m .552 .48115 L .54957 .47216 L F
.53547 .44556 m .57706 .61924 L .552 .48115 L F
.54696 .47425 m .55083 .47954 L .52688 .4241 L .66 .759 .923 r
F
.55083 .47954 m .54678 .45578 L .52688 .4241 L F
.55078 .47445 m .55317 .48762 L .54829 .46752 L .949 .74 .277 r
F
.55317 .48762 m .55337 .48869 L .5531 .48757 L F
.55317 .48762 m .5531 .48757 L .54829 .46752 L F
.51105 .39891 m .52688 .4241 L .53547 .44556 L .818 .801 .836 r
F
.51105 .39891 m .53547 .44556 L .51306 .40329 L F
.52964 .45055 m .54696 .47425 L .52688 .4241 L .66 .759 .923 r
F
.52964 .45055 m .54745 .46741 L .55083 .47954 L F
.55298 .48749 m .55193 .48673 L .55076 .48054 L .949 .74 .277 r
F
.55099 .48012 m .55076 .48054 L .55002 .47664 L F
.55337 .48869 m .55076 .48054 L .55099 .48012 L F
.55337 .48869 m .55002 .47664 L .54829 .46752 L F
.54869 .46467 m .54829 .46752 L .5406 .42694 L F
.55078 .47445 m .54829 .46752 L .54869 .46467 L F
.55083 .47954 m .62849 .58582 L .54678 .45578 L .66 .759 .923 r
F
.55083 .47954 m .55432 .48141 L .55141 .48034 L F
.55469 .4816 m .57019 .48989 L .55464 .48199 L F
.57019 .48989 m .57254 .49114 L .57027 .48998 L F
.57019 .48989 m .57027 .48998 L .55464 .48199 L F
.53324 .37775 m .53743 .40087 L .5406 .42694 L .949 .74 .277 r
F
.53743 .40087 m .54678 .45578 L .5406 .42694 L F
.54908 .48365 m .57706 .61924 L .57181 .63551 L F
.54757 .46784 m .55076 .48054 L .54999 .48198 L F
.5406 .42694 m .55002 .47664 L .54757 .46784 L F
.55002 .47664 m .55076 .48054 L .54757 .46784 L F
.50271 .4137 m .52964 .45055 L .51105 .39891 L .66 .759 .923 r
F
.52964 .45055 m .52688 .4241 L .51105 .39891 L F
.51682 .42806 m .54428 .45599 L .52964 .45055 L F
.54428 .45599 m .54745 .46741 L .52964 .45055 L F
.5406 .42694 m .54999 .48198 L .5482 .47777 L .949 .74 .277 r
F
.54322 .37376 m .54572 .46115 L .54594 .37267 L F
.53324 .37775 m .53578 .39477 L .54322 .37376 L F
.53578 .39477 m .54572 .46115 L .54322 .37376 L F
.49607 .42997 m .51687 .44825 L .50271 .4137 L .356 .651 .967 r
F
.54572 .46115 m .55582 .47301 L .54594 .37267 L .949 .74 .277 r
F
.55643 .46835 m .56126 .47327 L .55607 .47106 L .66 .759 .923 r
F
.56126 .47327 m .66265 .5764 L .55786 .47726 L F
.55259 .44022 m .55582 .47301 L .55437 .44952 L 0 .034 .571 r
F
.55582 .47301 m .55675 .46592 L .55233 .41623 L F
.56126 .47327 m .55786 .47726 L .54745 .46741 L .66 .759 .923 r
F
.54745 .46741 m .57254 .49114 L .55083 .47954 L F
.57254 .49114 m .66265 .5764 L .55141 .48034 L F
.5582 .48458 m .66265 .5764 L .55643 .46835 L .356 .651 .967 r
F
.55433 .48433 m .66265 .5764 L .62849 .58582 L .66 .759 .923 r
F
.55141 .48034 m .5545 .48301 L .55433 .48433 L F
.5545 .48301 m .66265 .5764 L .55433 .48433 L F
.55582 .47301 m .55711 .48616 L .55675 .46592 L 0 .034 .571 r
F
.54594 .37267 m .56163 .47961 L .55886 .37117 L F
.56146 .48745 m .60395 .51603 L .66265 .5764 L .356 .651 .967 r
F
.56237 .48741 m .6935 .57627 L .56146 .48745 L F
.55918 .48316 m .56515 .4873 L .5582 .48458 L F
.56515 .4873 m .6935 .57627 L .56237 .48741 L F
.56515 .4873 m .56237 .48741 L .5582 .48458 L F
.57161 .46113 m .57363 .48695 L .5774 .45433 L .429 .407 .732 r
F
.56163 .47961 m .57033 .48709 L .55886 .37117 L 0 .034 .571 r
F
.55711 .48616 m .55838 .48432 L .55675 .46592 L F
.54428 .45599 m .55643 .46835 L .54745 .46741 L .66 .759 .923 r
F
.55643 .46835 m .55607 .47106 L .54745 .46741 L F
.5482 .47777 m .54999 .48198 L .54908 .48365 L .949 .74 .277 r
F
.55076 .48054 m .57706 .61924 L .54908 .48365 L F
.55432 .48141 m .55469 .4816 L .55407 .4817 L .66 .759 .923 r
F
.55469 .4816 m .55464 .48199 L .55407 .4817 L F
.55432 .48141 m .55407 .4817 L .55141 .48034 L F
.55337 .48869 m .57706 .61924 L .55193 .48673 L .949 .74 .277 r
F
.55337 .48869 m .55193 .48673 L .55298 .48749 L F
.54572 .46115 m .5482 .47777 L .55582 .47301 L F
.5482 .47777 m .57181 .63551 L .55711 .48616 L F
.5482 .47777 m .55711 .48616 L .55582 .47301 L F
.50271 .4137 m .51682 .42806 L .52964 .45055 L .66 .759 .923 r
F
.51767 .44598 m .54551 .46661 L .52211 .43343 L .356 .651 .967 r
F
.51687 .44825 m .54551 .46661 L .51767 .44598 L F
.51687 .44825 m .5582 .48458 L .54551 .46661 L F
.5582 .48458 m .55643 .46835 L .52211 .43343 L F
.51687 .44825 m .52211 .43343 L .50271 .4137 L F
.57301 .48698 m .6935 .57627 L .57084 .48707 L F
.56816 .46518 m .57033 .48709 L .57141 .46523 L .429 .407 .732 r
F
.57033 .48709 m .57363 .48695 L .57161 .46113 L F
.55811 .45557 m .56011 .48182 L .56163 .47961 L 0 .034 .571 r
F
.55675 .46592 m .55838 .48432 L .55811 .45557 L F
.5701 .4878 m .6935 .57627 L .56364 .48625 L .356 .651 .967 r
F
.56446 .48243 m .6935 .57627 L .56065 .48103 L F
.60395 .51603 m .6935 .57627 L .67403 .57635 L F
.60395 .51603 m .67403 .57635 L .66265 .5764 L F
.57397 .50014 m .6935 .57627 L .57301 .48698 L 0 .212 .632 r
F
.64637 .57166 m .6202 .64631 L .65494 .63854 L .611 .516 .722 r
F
.64637 .57166 m .65494 .63854 L .65083 .58358 L F
.64283 .56772 m .6202 .64631 L .64637 .57166 L F
.61964 .54314 m .6202 .64631 L .64373 .56461 L F
.60206 .51745 m .71388 .58809 L .59963 .51595 L 0 .212 .632 r
F
.71388 .58809 m .7139 .58811 L .71388 .58809 L F
.71388 .58809 m .71388 .58809 L .59963 .51595 L F
.57174 .37238 m .63326 .53665 L .58455 .3749 L .611 .516 .722 r
F
.57515 .50088 m .7139 .58811 L .6935 .57627 L 0 .212 .632 r
F
.56065 .48103 m .5701 .4878 L .55918 .48316 L .356 .651 .967 r
F
.5701 .4878 m .56364 .48625 L .55918 .48316 L F
.5582 .48458 m .56237 .48741 L .56146 .48745 L F
.55838 .48432 m .55897 .49094 L .56011 .48182 L 0 .034 .571 r
F
.58943 .50967 m .60751 .52106 L .57515 .50088 L 0 .212 .632 r
F
.60751 .52106 m .7139 .58811 L .62125 .52987 L F
.60751 .52106 m .62125 .52987 L .57515 .50088 L F
.55886 .37117 m .58974 .50969 L .57174 .37238 L .429 .407 .732 r
F
.59259 .52244 m .6202 .64631 L .60171 .54178 L F
.59334 .52269 m .60171 .54178 L .59864 .52442 L F
.59259 .52244 m .60171 .54178 L .59334 .52269 L F
.55897 .49094 m .57181 .63551 L .5609 .49231 L 0 .034 .571 r
F
.57163 .50028 m .58602 .64578 L .57494 .50378 L .429 .407 .732 r
F
.59864 .52442 m .6202 .64631 L .61964 .54314 L .611 .516 .722 r
F
.57363 .48695 m .57469 .50057 L .57886 .48674 L .429 .407 .732 r
F
.57397 .50014 m .58943 .50967 L .57515 .50088 L 0 .212 .632 r
F
.58026 .50395 m .58943 .50967 L .57397 .50014 L F
.57494 .50378 m .58602 .64578 L .57986 .50898 L .429 .407 .732 r
F
.56369 .49362 m .57181 .63551 L .58602 .64578 L 0 .034 .571 r
F
.56128 .48012 m .56446 .48243 L .56065 .48103 L .356 .651 .967 r
F
.56211 .47891 m .57301 .48698 L .56128 .48012 L F
.57301 .48698 m .57084 .48707 L .56128 .48012 L F
.56163 .47961 m .5625 .49295 L .56369 .49362 L 0 .034 .571 r
F
.5625 .49295 m .57181 .63551 L .56369 .49362 L F
.55897 .49094 m .56088 .49203 L .56011 .48182 L F
.57033 .48709 m .57147 .49862 L .57363 .48695 L .429 .407 .732 r
F
.57147 .49862 m .57163 .50028 L .57185 .49885 L F
.57147 .49862 m .57185 .49885 L .57363 .48695 L F
.57163 .50028 m .57494 .50378 L .57469 .50057 L F
.57185 .49885 m .57469 .50057 L .57363 .48695 L F
.57163 .50028 m .57469 .50057 L .57185 .49885 L F
.56011 .48182 m .56088 .49203 L .56163 .47961 L 0 .034 .571 r
F
.56088 .49203 m .57181 .63551 L .5625 .49295 L F
.56088 .49203 m .5625 .49295 L .56163 .47961 L F
.56163 .47961 m .56369 .49362 L .57033 .48709 L F
.56369 .49362 m .57085 .49822 L .57033 .48709 L F
.57389 .56308 m .5808 .593 L .57033 .48709 L F
.55711 .48616 m .57181 .63551 L .55838 .48432 L F
.5568 .4892 m .57397 .50014 L .55548 .48348 L 0 .212 .632 r
F
.5568 .4892 m .56635 .49513 L .56421 .49392 L F
.4901 .44671 m .5568 .4892 L .49607 .42997 L F
.54443 .48132 m .54985 .48473 L .5568 .4892 L F
.5568 .4892 m .55548 .48348 L .49607 .42997 L F
.54985 .48473 m .56635 .49513 L .5568 .4892 L F
.56369 .49362 m .57389 .56308 L .57085 .49822 L 0 .034 .571 r
F
.57389 .56308 m .58602 .64578 L .5808 .593 L F
.57305 .4993 m .57323 .49947 L .56635 .49513 L 0 .212 .632 r
F
.57469 .50057 m .57962 .50356 L .57886 .48674 L .429 .407 .732 r
F
.55838 .48432 m .56011 .48182 L .55811 .45557 L 0 .034 .571 r
F
.54381 .46742 m .56128 .48012 L .54687 .47463 L .356 .651 .967 r
F
.56128 .48012 m .55918 .48316 L .54687 .47463 L F
.50827 .43901 m .56211 .47891 L .51487 .44637 L F
.56211 .47891 m .56128 .48012 L .51487 .44637 L F
.51327 .44486 m .51487 .44637 L .51405 .44577 L F
.50827 .43901 m .51487 .44637 L .51327 .44486 L F
.54687 .47463 m .55918 .48316 L .5582 .48458 L F
.51405 .44577 m .54381 .46742 L .54687 .47463 L F
.49607 .42997 m .50827 .43901 L .51405 .44577 L F
.57397 .50014 m .57301 .48698 L .49607 .42997 L 0 .212 .632 r
F
.58974 .50969 m .59684 .51423 L .57174 .37238 L .429 .407 .732 r
F
.59314 .49333 m .59684 .51423 L .60216 .51079 L .611 .516 .722 r
F
.59684 .51423 m .61955 .52821 L .6194 .49964 L F
.58429 .50639 m .7139 .58811 L .58229 .50517 L 0 .212 .632 r
F
.58903 .50926 m .59496 .513 L .58429 .50639 L F
.59496 .513 m .7139 .58811 L .58429 .50639 L F
.64373 .56461 m .65083 .58358 L .64734 .56582 L .611 .516 .722 r
F
.65083 .58358 m .67014 .63514 L .65623 .59284 L F
.65083 .58358 m .65623 .59284 L .64734 .56582 L F
.58229 .50517 m .58943 .50967 L .58026 .50395 L 0 .212 .632 r
F
.58457 .48651 m .58476 .50667 L .58974 .50969 L .429 .407 .732 r
F
.60206 .51745 m .59963 .51595 L .58903 .50926 L 0 .212 .632 r
F
.57886 .48674 m .57962 .50356 L .58457 .48651 L .429 .407 .732 r
F
.57962 .50356 m .58084 .5043 L .58457 .48651 L F
.57986 .50898 m .58483 .51424 L .58457 .48651 L F
.59025 .51 m .58903 .50926 L .54196 .47954 L 0 .212 .632 r
F
.60206 .51745 m .58903 .50926 L .59025 .51 L F
.57962 .50356 m .57986 .50898 L .58084 .5043 L .429 .407 .732 r
F
.57986 .50898 m .58602 .64578 L .58483 .51424 L F
.59227 .52211 m .59259 .52244 L .593