//------------------------COMPLEX.HPP-------------------------
#ifndef COMPLEX_HPP
#define COMPLEX_HPP
#include "types.h"
#include "display.hpp"
#include <iostream.h> //Use this and *not* "stream.h"
#include <math.h> //for atan

class Complex
{
private:
	Real re,im;
public:
	Complex(){re=im=0.0;} //Default constructor iniializes to 0.
	Complex(Real ire, Real iim){re =ire; im = iim;} // params constructor
	Complex(Real ire){re = ire; im = 0.0;}
	void Set(Real x, Real y){re = x; im = y;} //Access.
	Real get_re(){return re;}
	Real get_im(){return im;}
	Complex operator=(Complex &u){re = u.re; im = u.im; return *this;}
	Complex operator+=(Complex &u){re += u.re; im += u.im; return *this;}
	Complex operator-=(Complex &u){re -= u.re; im -= u.im; return *this;}
	Complex operator*=(Real u){re *= u; im *= u; return *this;}
	Complex operator/=(Real u){re /= u; im /= u; return *this;}
	Complex operator-(){return Complex(-re, -im);}
	Complex operator~(){return Complex(re, -im);} //Conjugate
	Real Magnitude(); //Return the complex's length.
	void Show(Display& disp, int color);
	unsigned char Look(Display& disp);
	friend Complex Sqrt(Complex &u);
	friend Complex Square(Complex &u){return u*u;}
	friend Complex Conjugate(Complex &u);
	friend Complex Cube(Complex &u){return u*u*u;}
	friend void Cuberoot(Complex &u, Complex &root0, Complex &root1,
		Complex &root2);
	friend Complex Sqrt(Complex &u);
	friend Complex Sqrt(Complex &u);
	friend void CubicSolve(Complex b, Complex c, Complex d, Complex *image);
	friend void CubicSolveLeadZero(Complex b, Complex c, Complex d, Complex *image);
		//Use CubicSolveLeadZero if you know b is 0.0.
	friend void CubicSolveOne(Complex b, Complex c, Complex d, Complex &answer);
		//CubicSolveOne is just a helper used by QuarticSolve
	friend void QuarticSolve(Complex a, Complex b, Complex c, Complex d,
		Complex *image);
	friend Complex operator+(Complex &u, Complex &v); //Complex sum
	friend int operator==(Complex &u, Complex &v) //Complex equals
		{if (u.re==v.re && u.im==v.im) return 1; return 0;}
	friend int operator!=(Complex &u, Complex &v) //Complex equals
		{if (u.re!=v.re || u.im!=v.im) return 1; return 0;}
	friend Complex operator-(Complex u, Complex v); //Complex difference
	friend Complex operator*(Complex &u, Complex &v); //Complex prod
	friend Complex operator+(Real f, Complex &v); //Real-Complex sum
	friend Complex operator-(Real f, Complex &v); //Real-Complex difference
	friend Complex operator*(Real f, Complex &v); //Real-Complex prod
	friend Complex operator/(Complex &v, Real f); //Complex-Real quotient
	friend Complex operator/(Complex &u, Complex &v); //Complex-Complex quotient
	friend Complex operator/(Real f, Complex &v); //Real-Complex quotient
	friend ostream& operator<< (ostream& s, Complex &u);
	friend istream& operator>> (istream& s, Complex &u);
};

#endif //COMPLEX_HPP
