#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "julia.hpp"

void inform(char far * filename)
{
	FILE *fp;
	char c;
	int col = 0, row = 0;
	int newline = 0;
	int key;

	clrscr();
	if ( (fp = fopen(filename, "r") ) == NULL )
	{
		printf("Can't find file %s.  Press ENTER to continue.\n",
			filename);
		while ( !kbhit() );
		getch();
		return;
	}
	while ( (c = getc(fp) ) != EOF )
	{
		if (newline)
		{
			if (c != ' ')
				putchar(c);
			newline = 0;
		}
		else
			putchar(c);
		col++;
		if ( c == '\n' )
		{
			col = 0;
			row++;
		}
		if (col >= 80)
		{
			putchar('\n');
			col = 0;
			row++;
			newline = 1;
		}
		if (row == 23 )
		{
			printf("\n-----------------------------------------\n");
			printf(" Press ENTER for more.  Press Q to quit reading.");
			while( !kbhit() );
			key = getch();
			if (key == 'q' || key == 'Q' || key == 27)
			{
				fclose(fp);
				return;
			}
			row = 0;
			col = 0;
			clrscr();
		}
	}
	printf("\n----------------------------------------\n");
	printf("       Press ENTER to continue.");
	while( !kbhit() );
	getch();
	fclose(fp);
}

unsigned char JuliaArray::Pickaname(char far *title)
{
	char command[20] = "DIR *";

	strcat(command, ext);
	strcat(command, "/on/w|more"); /* /on means alphabetic, /w means
		wide display, |more means stop after a screen */
	system(command);
	printf("\n%s\n",title);
	printf("\nType . to escape, or");
	printf("\nType the name of the file.");
	printf("\nThe name can have up to eight characters.");
	printf("\nDo not use a file extension.");
	printf("\nPress ENTER when you are done.\n\n");
	scanf("%s", filename);
	if (filename[0] == '.')
		return 0;
	strcat(filename, ext);
	return 1;
}

