//-------------------------DISPLAY.CPP--------------------
#include "display.hpp"
#include <graphics.h>

void BGIdisplay::open()
{
	int errorflag;

	strcpy(name,"BGI");
	errorflag = registerbgidriver(EGAVGA_driver); // This is a BGI call.
	//It looks for a linked in EGAVGA.OBJ or a EGAVGA.BGI on disk.
	if (errorflag < 0) //negative return means error.
	{
		cout << "EGAVGA.OBJ was not linked and EGVGA.BGI is not found.\n";
		cout << "Press any key to exit the program\n";
		while (!kbhit())
			;
		exit(EXIT_FAILURE); //exit is a DOS function to terminate.
	}
	initgraph(&gdriver, &gmode, ""); //initgraph is a BGI function.
	errorflag = graphresult(); //graphresult is a BGI function.
	if (errorflag) //nonzero is error
	{
		cout << "This machine doesn't support EGA or VGA graphics.\n";
		cout << "Press any key to exit the program\n";
		while (!kbhit())
			;
		exit(EXIT_FAILURE);
	}
	minx = 100;
	miny = 0 + 1;  //put the edges one in so I can draw a frame.
	maxx = getmaxx() - 1 ; //getmaxx and getmaxy are BGI functions.
	maxy = getmaxy() - 1;
	midx = (minx + maxx)/2;
	midy = (miny + maxy)/2;
	maxcolor = 15;
}

void BGIdisplay::clear()
{
	cleardevice(); //BGI
}

void BGIdisplay::pixel(int x, int y, unsigned char color)
{
	putpixel(x, y, color); //BGI
}

unsigned char BGIdisplay::readpixel(int x, int y)
{
	return getpixel(x, y); //BGI
}

void BGIdisplay::box(int left, int top, int right, int bottom, int color)
{
	int temp;

	setcolor(color); //BGI
	if (right < left) //In case the numbers are in wrong order.
		{temp = right; right = left; left = temp;}
	if (bottom < top) //Y pixel count goes *up* as you move down screen.
		{temp = top; top = bottom; bottom = temp;}
	rectangle(left,top,right,bottom); //BGI
}

void BGIdisplay::textmode()
{
	restorecrtmode(); //BGI
}

void BGIdisplay::graphicsmode()
{
	setgraphmode(getgraphmode()); //BGI
}

void BGIdisplay::close()
{
	closegraph(); //BGI
}

void V13display::setmode(int mode)
{
	regs.r_ax = mode; //regs acts like the registers.
	regs.r_bx = regs.r_cx = regs.r_dx = 0;
	intr(0x10, &regs); //Calls assembly language interrupt.
}

void V13display::open()
{
	strcpy(name,"V13");
	setmode(0x13);
	regs.r_ax = 0x0F00; //Get mode function of interrupt 0x10.
	intr(0x10, &regs); //Returns the mode in the al register.
	if ((regs.r_ax & 0x00FF) != 0x13) //You're not in mode 0x13
	{
		cout << "This machine doesn't support VGA mode 0x13.\n";
		cout << "Press any key to exit the program\n";
		while (!kbhit())
			;
		exit(EXIT_FAILURE);
	}
	baseptr = (unsigned char far *)MK_FP(0xA000,0);
	// Create a far pointer to where mode 0x13 pixels are stored.
	// This happens to be segment 0xA000, offset 0000.
	screencount = (unsigned int)320 * 200;
	minx = miny = 1; //put the edge one in so I can draw a box.
	maxx = 319 - 1 ;
	maxy = 199 - 1;
	midx = (minx + maxx)/2;
	midy = (miny + maxy)/2;
	maxcolor = 255;
}

void V13display::clear()
{
	for (unsigned int i=0; i<screencount; i++)
		baseptr[i] = 0;
}

void V13display::pixel(int x, int y, unsigned char color)
{
	baseptr[(unsigned int)x + (unsigned int)y * 320] = color;
	//This is a direct poke into the RAM memory where screenimage is.
}

unsigned char V13display::readpixel(int x, int y)
{
	return baseptr[(unsigned int)x + (unsigned int)y * 320];
	//This is a direct peek into the RAM memory where screenimage is.
}

void V13display::box(int left, int top, int right, int bottom, int color)
{
	int temp,x,y;

	if (right < left)
		{temp = right; right = left; left = temp;}
	if (bottom < top)
		{temp = top; top = bottom; bottom = temp;}
	y = top;
	for (x = left; x <= right; x++)
		pixel(x,y,color);
	x = right;
	for (y = top+1; y <= bottom; y++)
		pixel(x,y,color);
	y = bottom;
	for (x = right-1; x >= left; x--)
		pixel(x,y,color);
	x = left;
	for (y = bottom; y>top; y--)
		pixel(x,y,color);
}

void V13display::textmode()
{
	setmode(3); //3 is ordinary textmode.
}

void V13display::graphicsmode()
{
	setmode(0x13);
}

void V13display::close()
{
	setmode(3);
}
