#include "button.hpp"
#include "keycode.hpp"

//---------------Button methods---------

Button::Button(int ix, int iy, char *ilabel, int iedgecolor,
	int ibackgroundcolor)
{ //Call after display has been opened.
	left = ix;
	top = iy;
	label = new char[strlen(ilabel) + 1]; // +1 for 0 terminator.
	strcpy(label, ilabel); //Copies the 0 terminator too.
	edgecolor = iedgecolor;
	backgroundcolor = ibackgroundcolor;
	right = left + textwidth(label) + 2*LABELFRAME; //These are based on the currently
	bottom = top + TEXTHEIGHT + 2*LABELFRAME; //active font and text.
	labelx = left + LABELFRAME;
	labely = top + LABELFRAME;
}

void Button::Show()
{
	settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	setfillstyle(SOLID_FILL, backgroundcolor);
	bar(left-2, top-2, right+2, bottom+2);
	setcolor(edgecolor);
	rectangle(left-2, top-2, right+2, bottom+2);
	outtextxy(labelx, labely, label);
}

int Button::Hit(Cursor &cur)
{
	if(left < cur.Getx() && cur.Getx() < right &&
		top < cur.Gety() && cur.Gety() < bottom)
		return 1;
	else
		return 0;
}
//--------------------Button_with_value Methods---------------------

Button_with_value::Button_with_value(int ix, int iy, char *ilabel,int iedgecolor,
	int ibackgroundcolor):
	Button(ix, iy, ilabel, iedgecolor, ibackgroundcolor) //Call base class initializer
{ //Call after display has been opened.

	valuelabel = new char[strlen(label) + 1]; /* Width
		of button is based on label, which should be as long as
		any value you plan to show.  If not, pad ilabel with spaces.*/
	bottom = top + 2*TEXTHEIGHT + 3*LABELFRAME;
	 //Bottom is different from plain Button, twice as high.
	valuelabelx = labelx;
	valuelabely = labely + TEXTHEIGHT + LABELFRAME;
	real_val = 0.0;
	int_val = 0;
}

void Button_with_value::Show(int ival)
{
	settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	sprintf(valuelabel, "%d", ival);
	setfillstyle(SOLID_FILL, backgroundcolor);
	bar(left, top, right, bottom);
	setcolor(edgecolor);
	rectangle(left, top, right, bottom);
	outtextxy(labelx, labely, label);
	outtextxy(valuelabelx, valuelabely, valuelabel);
}

void Button_with_value::Show()
{
	settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	sprintf(valuelabel, "%.6lf", real_val);
	setfillstyle(SOLID_FILL, backgroundcolor);
	bar(left, top, right, bottom);
	setcolor(edgecolor);
	rectangle(left, top, right, bottom);
	outtextxy(labelx, labely, label);
	outtextxy(valuelabelx, valuelabely, valuelabel);
}


void Button_with_value::Show(char *stringval)
{
	settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	sprintf(valuelabel, "%s", stringval);
	setfillstyle(SOLID_FILL, backgroundcolor);
	bar(left, top, right, bottom);
	setcolor(edgecolor);
	rectangle(left, top, right, bottom);
	outtextxy(labelx, labely, label);
	outtextxy(valuelabelx, valuelabely, valuelabel);
}

ButtonBox::ButtonBox(BGIdisplay disp)
{
	left=0;
	top=1;
	right=disp.readminx()-1;
	bottom=disp.readmaxy()-2;
	midx=(left+right)/2;
	oneflag = FALSE;
	ButtonArray[QUIT] = new Button(56,90, "Quit");
	ButtonArray[HELP] = new Button(9,90,"Help");
	ButtonArray[RANDOM] = new Button(midx-(10*4),40,"  Random  ");
	ButtonArray[LOAD] = new Button(9,65,"Load");
	ButtonArray[SAVE] = new Button(56,65,"Save");
	ButtonArray[ALL] = new Button(midx-(10*4),15," Show All ");
	ButtonArray[ONE] = new Button(midx-(10*4),15," Show One ");
	ValButtonArray[DEGREE] = new Button_with_value(midx-(10*4),120,"  Degree  ");
	ValButtonArray[FLOCKCOUNT] = new Button_with_value(midx-(10*4),150,"Flockcount");
	ValButtonArray[STEPSIZE] = new Button_with_value(midx-(10*4),180,"Step Size ");
	ValButtonArray[CRE] = new Button_with_value(midx-(10*4),210,"   c.re   ");
	ValButtonArray[CIM] = new Button_with_value(midx-(10*4),240,"   c.im   ");
	ValButtonArray[KRE] = new Button_with_value(midx-(10*4),270,"   k.re   ");
	ValButtonArray[KIM] = new Button_with_value(midx-(10*4),300,"   k.im   ");
	ValButtonArray[QRE] = new Button_with_value(midx-(10*4),330,"   q.re   ");
	ValButtonArray[QIM] = new Button_with_value(midx-(10*4),360,"   q.im   ");

}

ButtonBox::~ButtonBox()
{
	delete[] ButtonArray;
	delete[] ValButtonArray;
}

void ButtonBox::Show()
{
	setcolor(11);
	setfillstyle(1,RED);
	bar(left,top,right,bottom);
	for(int i=0;i<REGBUTTONS;i++)
	  ButtonArray[i]->Show();
	if(oneflag)
	  ButtonArray[ALL]->Show();
	setcolor(BLUE);
	setlinestyle(0,0,3); //Thick line
	line(0,112,99,112);
	setlinestyle(0,0,1); // Normal
	ShowValButtons();
	setcolor(YELLOW);
	outtextxy(midx-(8*4),410,"Julgnarl");
	outtextxy(midx-(2*4),420,"by");
	outtextxy(midx-(11*4),430,"Rudy Rucker");
	outtextxy(midx-(3*4),440,"and");
	outtextxy(midx-(9*4),450,"Mark Jahn");
}

void ButtonBox::ShowCKQButtons(Real cre,Real cim,Real kre,Real kim,Real qre,
										 Real qim)
{
	ValButtonArray[CRE]->Set_realval(cre);
	ValButtonArray[CIM]->Set_realval(cim);
	ValButtonArray[KRE]->Set_realval(kre);
	ValButtonArray[KIM]->Set_realval(kim);
	ValButtonArray[QRE]->Set_realval(qre);
	ValButtonArray[QIM]->Set_realval(qim);
	for(int i=CRE;i<=QIM;i++)
	  ValButtonArray[i]->Show();
}

void ButtonBox::ShowValButtons()
{
	ValButtonArray[DEGREE]->Show(ValButtonArray[DEGREE]->Get_intval());
	ValButtonArray[FLOCKCOUNT]->Show(ValButtonArray[FLOCKCOUNT]->Get_intval());
	ValButtonArray[STEPSIZE]->Show();
	for(int i=CRE;i<=QIM;i++)
	  ValButtonArray[i]->Show();
}

int ButtonBox::Hit(int cursorcode,Cursor *cur)
{  int j;
	if (cursorcode == LEFT_BUTTON)
	{
	  for(j=0;j<REGBUTTONS;j++)
		 if (ButtonArray[j]->Hit(*cur))
			return j;
	  for(j=0;j<VALBUTTONS;j++)
		 if(ValButtonArray[j]->Hit(*cur))
			return j + REGBUTTONS;
	}
	else if (cursorcode == RIGHT_BUTTON)
	{
	  for(j=0;j<VALBUTTONS;j++)
		 if(ValButtonArray[j]->Hit(*cur))
			return j + NUMBUTTONS;
	}
	return -1; // not clicked on a button
}
