#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrsstop
#include "world.h"


extern HDC hdcBugLand;
extern HWND hwnd;
extern unsigned char foodglobflag, poisonglobflag, mazeflag,
	wrapflag, editcolony, erasetrailflag, colony_erasetrailflag[], CAflag,
	livebugcount, three_d_flag;
extern struct bug *Bug[];
extern unsigned char bugnum[];
extern struct colony Colony[];
extern unsigned char editcolony;
extern unsigned short traillength, colony_traillength[];
extern void label( HWND, int, char *, short );
extern void ulabel( HWND, int, char *, unsigned short );
extern unsigned short huge *zbuffer;
extern COLORREF blankcolor;
extern unsigned char worldclearflag, stereoflag;
extern HWND hwnd, hDlgShape;

extern void makepoisonglob(void);
extern void makefoodglob(void);
extern void makemaze(void);
extern void drawfoodglob(HDC hdc);
extern void drawmaze(HDC hdc);
extern void drawpoisonglob(HDC hdc);
extern void drawedge(HDC hdc);
extern void cornerbugs(HWND);
extern void randomizepositions(HWND);
extern void installdirectiontype(struct bug *);
extern void DNA_to_RNA(struct bug *);
extern void installmotiontype(struct bug *);
extern void putbugsincolonies(unsigned char *);
//extern void adjusttraillength_2D(HDC, unsigned short, unsigned short,
//	unsigned char);
//extern void adjusttraillength_3D(HDC, unsigned short, unsigned short);

#ifdef CYBER
extern "C" BOOL FAR PASCAL WorldProc( HWND hDlg, WORD message, WORD wParam, LONG lParam )
#else
BOOL FAR PASCAL WorldProc( HWND hDlg, WORD message, WORD wParam, LONG lParam )
#endif // CYBER
{
	HDC hdc;
	// Make working copies of the params.
	static unsigned char newwrapflag, newfoodglobflag, newpoisonglobflag,
		newCAflag, newthree_d_flag,
		newmazeflag, randposflag = 0,
		newlivebugcount,
		newerasetrailflag, colony_newerasetrailflag[MAXCOLONIES],
		newcolpop[MAXCOLONIES];
	static unsigned short newtraillength,
		colony_newtraillength[MAXCOLONIES];
	unsigned short i, j;

	switch( message )
	{
		case WM_DESTROY:
			EndDialog(hDlg, TRUE);
			return TRUE;

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			EndDialog(hDlg, TRUE);
//			DestroyWindow(hDlg);
			return TRUE;

		case WM_INITDIALOG:
			worldclearflag = 0;
			newwrapflag = wrapflag;
			newfoodglobflag = foodglobflag;
			newpoisonglobflag = poisonglobflag;
			newmazeflag = mazeflag;
			newtraillength = traillength;
			newerasetrailflag = erasetrailflag;
			newCAflag = CAflag;
			newthree_d_flag = three_d_flag;
			for (i=0; i<MAXCOLONIES; i++)
			{
				newcolpop[i] = Colony[i].pop;
				colony_newerasetrailflag[i] =
					colony_erasetrailflag[i];
				colony_newtraillength[i] =
					colony_traillength[i];
			}
			newlivebugcount = livebugcount;
			CheckDlgButton( hDlg, ID_FOODPATCH,
				newfoodglobflag?MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, ID_POISONPATCH,
				newpoisonglobflag?MF_CHECKED:MF_UNCHECKED);
			CheckDlgButton( hDlg, ID_MAZE,
				newmazeflag?MF_CHECKED:MF_UNCHECKED);
			CheckRadioButton( hDlg, ID_WRAPON, ID_WRAPOFF,
				newwrapflag ? ID_WRAPON : ID_WRAPOFF );
			CheckRadioButton( hDlg, ID_THREEDOFF, ID_THREEDON,
				newthree_d_flag ? ID_THREEDON: ID_THREEDOFF );
			CheckRadioButton( hDlg, ID_BUGS_ONLY,
				ID_BUG_AND_CA, ID_BUGS_ONLY + newCAflag );
			if (newthree_d_flag)
			{
				if (newtraillength>MAXTRAILLENGTH || !newerasetrailflag)
					SetWindowText( GetDlgItem( hDlg,
						ID_TRAILLENGTH0) , (LPSTR)
						"Permanent Trail");
				else
					ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
						(unsigned short)(newtraillength /
						(newlivebugcount) ) );
				if (newtraillength>MAXTRAILLENGTH || !newerasetrailflag)
					SetWindowText( GetDlgItem( hDlg,
						ID_TRAILLENGTH1) , (LPSTR)
						"Permanent Trail");
				else
					ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
						(unsigned short)(newtraillength /
						(newlivebugcount) ) );
				if (newtraillength>MAXTRAILLENGTH || !newerasetrailflag)
					SetWindowText( GetDlgItem( hDlg,
						ID_TRAILLENGTH2) , (LPSTR)
						"Permanent Trail");
				else
					ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
						(unsigned short)(newtraillength /
						(newlivebugcount) ) );
			}
			else //2D
			{
				if (colony_newtraillength[0]>COLONY_MAXTRAILLENGTH ||
					!colony_newerasetrailflag[0])
					SetWindowText( GetDlgItem( hDlg,
						ID_TRAILLENGTH0) , (LPSTR)
						"Permanent Trail");
				else
				{
					if (newcolpop[0])
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)
							(colony_newtraillength[0] /
							(newcolpop[0]) ) );
					else
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)
							colony_newtraillength[0] );
				}
				if (colony_newtraillength[1]>COLONY_MAXTRAILLENGTH ||
					!colony_newerasetrailflag[1])
					SetWindowText( GetDlgItem( hDlg,
						ID_TRAILLENGTH1) , (LPSTR)
						"Permanent Trail");
				else
				{
					if (newcolpop[1])
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)
							(colony_newtraillength[1] /
							(newcolpop[1]) ) );
					else
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)
							colony_newtraillength[1] );
				}
				if (colony_newtraillength[2]>COLONY_MAXTRAILLENGTH ||
					!colony_newerasetrailflag[2])
					SetWindowText( GetDlgItem( hDlg,
						ID_TRAILLENGTH2) , (LPSTR)
						"Permanent Trail");
				else
				{
					if (newcolpop[2])
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)
							(colony_newtraillength[2] /
							(newcolpop[2]) ) );
					else
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)
							colony_newtraillength[2] );
				}
			}
			label( hDlg, ID_COL0COUNT, NAME0,
				(short)(newcolpop[0]) );
			label( hDlg, ID_COL1COUNT, NAME1,
				(short)(newcolpop[1]) );
			label( hDlg, ID_COL2COUNT, NAME2,
				(short)(newcolpop[2]) );
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case ID_FOODPATCH:
					if (newthree_d_flag)
						break;
					newfoodglobflag ^= 1;
					CheckDlgButton( hDlg, ID_FOODPATCH,
						newfoodglobflag?MF_CHECKED:MF_UNCHECKED);
					break;

				case ID_POISONPATCH:
					if (newthree_d_flag)
						break;
					newpoisonglobflag ^= 1;
					CheckDlgButton( hDlg, ID_POISONPATCH,
						newpoisonglobflag?MF_CHECKED:MF_UNCHECKED);
					break;

				case ID_MAZE:
					if (newthree_d_flag)
					{
						newmazeflag = 0;
						CheckDlgButton( hDlg, ID_MAZE,
							newmazeflag?MF_CHECKED:MF_UNCHECKED);
						break;
					}
					newmazeflag ^= 1;
					CheckDlgButton( hDlg, ID_MAZE,
						newmazeflag?MF_CHECKED:MF_UNCHECKED);
					break;

				case ID_BUGS_ONLY:
					newCAflag = BUGS_ONLY; // 0
					CheckRadioButton( hDlg, ID_BUGS_ONLY,
						ID_BUG_AND_CA, ID_BUGS_ONLY + newCAflag );
					newthree_d_flag = three_d_flag;
					CheckRadioButton( hDlg, ID_THREEDOFF, ID_THREEDON,
						newthree_d_flag ?
						ID_THREEDON: ID_THREEDOFF );
					break;

				case ID_CA_ONLY:
					newCAflag = CA_ONLY; // 1
					CheckRadioButton( hDlg, ID_BUGS_ONLY,
						ID_BUG_AND_CA, ID_BUGS_ONLY + newCAflag );
					newthree_d_flag = 0;
					CheckRadioButton( hDlg, ID_THREEDOFF, ID_THREEDON,
						newthree_d_flag ?
						ID_THREEDON: ID_THREEDOFF );
					break;

				case ID_BUG_AND_CA:
					newCAflag = BUGS_AND_CA; // 2
					CheckRadioButton( hDlg, ID_BUGS_ONLY,
						ID_BUG_AND_CA, ID_BUGS_ONLY + newCAflag );
					newthree_d_flag = 0;
					CheckRadioButton( hDlg, ID_THREEDOFF, ID_THREEDON,
						newthree_d_flag ?
						ID_THREEDON: ID_THREEDOFF );
					break;

				case ID_WRAPON:
					newwrapflag = 1;
					CheckRadioButton( hDlg, ID_WRAPON, ID_WRAPOFF,
						newwrapflag ? ID_WRAPON : ID_WRAPOFF );
					break;

				case ID_WRAPOFF:
					newwrapflag = 0;
					CheckRadioButton( hDlg, ID_WRAPON, ID_WRAPOFF,
						newwrapflag ? ID_WRAPON : ID_WRAPOFF );
					break;

				case ID_THREEDOFF:
					newthree_d_flag = 0;
					CheckRadioButton( hDlg, ID_THREEDOFF, ID_THREEDON,
						newthree_d_flag ?
						ID_THREEDON: ID_THREEDOFF );
					newCAflag = CAflag; // 0
					CheckRadioButton( hDlg, ID_BUGS_ONLY,
					ID_BUG_AND_CA, ID_BUGS_ONLY + newCAflag );
					EnableWindow( ID_BUG_AND_CA, FALSE);
					if (newcolpop[0])
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)
							(colony_newtraillength[0] /
							(newcolpop[0]) ) );
					else
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)
							colony_newtraillength[0] );
					if (newcolpop[1])
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)
							(colony_newtraillength[1] /
							(newcolpop[1]) ) );
					else
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)
							colony_newtraillength[1] );
					if (newcolpop[2])
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)
							(colony_newtraillength[2] /
							(newcolpop[2]) ) );
					else
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)
							colony_newtraillength[2] );
					break;

				case ID_THREEDON:
					newthree_d_flag = 1;
					newfoodglobflag = 0;
					newpoisonglobflag = 0;
					newmazeflag = 0;
					CheckRadioButton( hDlg, ID_THREEDOFF, ID_THREEDON,
						newthree_d_flag ?
						ID_THREEDON: ID_THREEDOFF );
					CheckDlgButton( hDlg, ID_FOODPATCH,
						newfoodglobflag?MF_CHECKED:MF_UNCHECKED);
					CheckDlgButton( hDlg, ID_POISONPATCH,
						newpoisonglobflag?MF_CHECKED:MF_UNCHECKED);
					CheckDlgButton( hDlg, ID_MAZE,
						newmazeflag?MF_CHECKED:MF_UNCHECKED);
					newCAflag = BUGS_ONLY; // 0
					EnableWindow( ID_BUG_AND_CA, TRUE);
					CheckRadioButton( hDlg, ID_BUGS_ONLY,
						ID_BUG_AND_CA, ID_BUGS_ONLY + newCAflag );
					ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
						(unsigned short)( newtraillength /
						(newlivebugcount) ) );
					ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
						(unsigned short)( newtraillength /
						(newlivebugcount) ) );
					ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
						(unsigned short)( newtraillength /
						(newlivebugcount) ) );
					break;

				case ID_TRAILLENGTHMINUS0:
					if (newthree_d_flag)
					{
						if (newtraillength > MAXTRAILLENGTH)
						{
							newtraillength = MAXTRAILLENGTH;
							newerasetrailflag = 1;
						}
						else
							newtraillength *= DECREMENT_MULTIPLIER;
						if (newtraillength <= (unsigned short)
							(newlivebugcount * 2 ))
							newtraillength = newlivebugcount * 2;
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
					}
					else //2D
					{
						if (!newcolpop[0])
							break;
						if (colony_newtraillength[0] >
							COLONY_MAXTRAILLENGTH)
						{
							colony_newtraillength[0] =
								COLONY_MAXTRAILLENGTH;
							colony_newerasetrailflag[0] = 1;
						}
						else
							colony_newtraillength[0] *=
								DECREMENT_MULTIPLIER;
						if (colony_newtraillength[0] <= (unsigned short)
							(newcolpop[0] * 2 ))
							colony_newtraillength[0] = newcolpop[0] * 2;
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)( colony_newtraillength[0] /
							(newcolpop[0]) ) );
					}
					break;

				case ID_TRAILLENGTHPLUS0:
					if (newthree_d_flag)
					{
						if (newtraillength >= MAXTRAILLENGTH)
						{
							newtraillength = MAXTRAILLENGTH + 1;
							newerasetrailflag = 0;
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH0) , (LPSTR)
								"Permanent Trail");
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH1) , (LPSTR)
								"Permanent Trail");
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH2) , (LPSTR)
								"Permanent Trail");
						}
						else
						{
							if (newtraillength < 10)
								newtraillength++;
							if ( (long)newtraillength *
								INCREMENT_MULTIPLIER >
								MAXTRAILLENGTH)
								newtraillength = MAXTRAILLENGTH;
							else
								newtraillength *=
									INCREMENT_MULTIPLIER;
							ulabel( hDlg, ID_TRAILLENGTH0,
								NAME0,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1,
								NAME1,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2,
								NAME2,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
						}
					}
					else //2D
					{
						if (!newcolpop[0])
							break;
						if (colony_newtraillength[0] >=
							COLONY_MAXTRAILLENGTH)
						{
							colony_newtraillength[0] =
								COLONY_MAXTRAILLENGTH + 1;
							colony_newerasetrailflag[0] = 0;
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH0) , (LPSTR)
								"Permanent Trail");
						}
						else
						{
							if (colony_newtraillength[0] < 10)
								colony_newtraillength[0]++;
							else if ((long)colony_newtraillength[0]*
								INCREMENT_MULTIPLIER >
								COLONY_MAXTRAILLENGTH)
								colony_newtraillength[0] =
									COLONY_MAXTRAILLENGTH;
							else
								colony_newtraillength[0] *=
									INCREMENT_MULTIPLIER;
							ulabel( hDlg, ID_TRAILLENGTH0,
								NAME0,
								(unsigned short)(
									colony_newtraillength[0] /
									(newcolpop[0]) ) );
						}
					}
					break;

				case ID_TRAILLENGTHMINUS1:
					if (newthree_d_flag)
					{
						if (newtraillength > MAXTRAILLENGTH)
						{
							newtraillength = MAXTRAILLENGTH;
							newerasetrailflag = 1;
						}
						else
							newtraillength *= DECREMENT_MULTIPLIER;
						if (newtraillength <= (unsigned short)
							(newlivebugcount * 2 ))
							newtraillength = newlivebugcount * 2;
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
					}
					else //2D
					{
						if (!newcolpop[1])
							break;
						if (colony_newtraillength[1] >
							COLONY_MAXTRAILLENGTH)
						{
							colony_newtraillength[1] =
								COLONY_MAXTRAILLENGTH;
							colony_newerasetrailflag[1] = 1;
						}
						else
							colony_newtraillength[1] *=
								DECREMENT_MULTIPLIER;
						if (colony_newtraillength[1] <= (unsigned short)
							(newcolpop[1] * 2 ))
							colony_newtraillength[1] = newcolpop[1] * 2;
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)( colony_newtraillength[1] /
							(newcolpop[1]) ) );
					}
					break;

				case ID_TRAILLENGTHPLUS1:
					if (newthree_d_flag)
					{
						if (newtraillength >= MAXTRAILLENGTH)
						{
							newtraillength = MAXTRAILLENGTH + 1;
							newerasetrailflag = 0;
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH0) , (LPSTR)
								"Permanent Trail");
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH1) , (LPSTR)
								"Permanent Trail");
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH2) , (LPSTR)
								"Permanent Trail");
						}
						else
						{
							if (newtraillength < 10)
								newtraillength++;
							if ( (long)newtraillength *
								INCREMENT_MULTIPLIER >
								MAXTRAILLENGTH)
								newtraillength = MAXTRAILLENGTH;
							else
								newtraillength *=
									INCREMENT_MULTIPLIER;
							ulabel( hDlg, ID_TRAILLENGTH0,
								NAME0,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1,
								NAME1,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2,
								NAME2,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
						}
					}
					else //2D
					{
						if (!newcolpop[1])
							break;
						if (colony_newtraillength[1] >=
							COLONY_MAXTRAILLENGTH)
						{
							colony_newtraillength[1] =
								COLONY_MAXTRAILLENGTH + 1;
							colony_newerasetrailflag[1] = 0;
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH1) , (LPSTR)
								"Permanent Trail");
						}
						else
						{
							if (colony_newtraillength[1] < 10)
								colony_newtraillength[1]++;
							else if ( (long)colony_newtraillength[1] *
								INCREMENT_MULTIPLIER >
								COLONY_MAXTRAILLENGTH)
								colony_newtraillength[1] =
									COLONY_MAXTRAILLENGTH;
							else
								colony_newtraillength[1] *=
									INCREMENT_MULTIPLIER;
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)(
									colony_newtraillength[1] /
									(newcolpop[1]) ) );
						}
					}
					break;

				case ID_TRAILLENGTHMINUS2:
					if (newthree_d_flag)
					{
						if (newtraillength > MAXTRAILLENGTH)
						{
							newtraillength = MAXTRAILLENGTH;
							newerasetrailflag = 1;
						}
						else
							newtraillength *= DECREMENT_MULTIPLIER;
						if (newtraillength <= (unsigned short)
							(newlivebugcount * 2 ))
							newtraillength = newlivebugcount * 2;
						ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
						ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)( newtraillength /
							(newlivebugcount) ) );
					}
					else //2D
					{
						if (!newcolpop[2])
							break;
						if (colony_newtraillength[2] >
							COLONY_MAXTRAILLENGTH)
						{
							colony_newtraillength[2] =
								COLONY_MAXTRAILLENGTH;
							colony_newerasetrailflag[2] = 1;
						}
						else
							colony_newtraillength[2] *=
								DECREMENT_MULTIPLIER;
						if (colony_newtraillength[2] <= (unsigned short)
							(newcolpop[2] * 2 ))
							colony_newtraillength[2] = newcolpop[2] * 2;
						ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
							(unsigned short)( colony_newtraillength[2] /
							(newcolpop[2]) ) );
					}
					break;

				case ID_TRAILLENGTHPLUS2:
					if (newthree_d_flag)
					{
						if (newtraillength >= MAXTRAILLENGTH)
						{
							newtraillength = MAXTRAILLENGTH + 1;
							newerasetrailflag = 0;
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH0) , (LPSTR)
								"Permanent Trail");
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH1) , (LPSTR)
								"Permanent Trail");
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH2) , (LPSTR)
								"Permanent Trail");
						}
						else
						{
							if (newtraillength < 10)
								newtraillength++;
							if ( (long)newtraillength *
								INCREMENT_MULTIPLIER >
								MAXTRAILLENGTH)
								newtraillength = MAXTRAILLENGTH;
							else
								newtraillength *=
									INCREMENT_MULTIPLIER;
							ulabel( hDlg, ID_TRAILLENGTH0,
								NAME0,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1,
								NAME1,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2,
								NAME2,
								(unsigned short)(newtraillength /
								(newlivebugcount) ) );
						}
					}
					else //2D
					{
						if (!newcolpop[2])
							break;
						if (colony_newtraillength[2] >=
							COLONY_MAXTRAILLENGTH)
						{
							colony_newtraillength[2] =
								COLONY_MAXTRAILLENGTH + 1;
							colony_newerasetrailflag[2] = 0;
							SetWindowText( GetDlgItem( hDlg,
								ID_TRAILLENGTH2) , (LPSTR)
								"Permanent Trail");
						}
						else
						{
							if (colony_newtraillength[2] < 10)
								colony_newtraillength[2]++;
							else if ( (long)colony_newtraillength[2] *
								INCREMENT_MULTIPLIER >
								COLONY_MAXTRAILLENGTH)
								colony_newtraillength[2] =
									COLONY_MAXTRAILLENGTH;
							else
								colony_newtraillength[2] *=
									INCREMENT_MULTIPLIER;
							ulabel( hDlg, ID_TRAILLENGTH2,
								NAME2,
								(unsigned short)(
									colony_newtraillength[2] /
									(newcolpop[2]) ) );
						}
					}
					break;

				case ID_COL0COUNTMINUS:
					if (newcolpop[0] > 0 && newlivebugcount > 1)
					{
						if (newthree_d_flag)
						{
							newtraillength -= newtraillength /
								newlivebugcount;
							if (newtraillength <
								newlivebugcount * 2)
								newtraillength =
									newlivebugcount * 2;
						}
						else if (newcolpop[0] > 1)
						{
							colony_newtraillength[0] -=
								colony_newtraillength[0] /
									newcolpop[0];
							if (colony_newtraillength[0] < 
								newcolpop[0] * 2)
								colony_newtraillength[0] = 
									newcolpop[0] * 2;
						}
						newcolpop[0]--;
						newlivebugcount--;
						label( hDlg, ID_COL0COUNT,
							NAME0, (short)(newcolpop[0]) );
						if (newthree_d_flag)
						{
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
						}
						else if (newcolpop[0])
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)(
								colony_newtraillength[0] /
								(newcolpop[0]) ) );
					}
					break;

				case ID_COL0COUNTPLUS:
					if ( newlivebugcount + 1 <= MAXBUGS)
					{
						if (newthree_d_flag)
						{
							newtraillength += newtraillength /
								newlivebugcount;
							if (newtraillength > MAXTRAILLENGTH)
								newtraillength = MAXTRAILLENGTH;
						}
						else if (newcolpop[0])
						{
							colony_newtraillength[0] +=
								colony_newtraillength[0] /
								newcolpop[0];
							if (colony_newtraillength[0] > 
								COLONY_MAXTRAILLENGTH)
								colony_newtraillength[0] = 
									COLONY_MAXTRAILLENGTH;
						}
						newcolpop[0]++;
						newlivebugcount++;
						label( hDlg, ID_COL0COUNT,
							NAME0, (short)(newcolpop[0]) );
						if (newthree_d_flag)
						{
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
						}
						else
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)(
								colony_newtraillength[0] /
								(newcolpop[0]) ) );
						}
					break;

				case ID_COL1COUNTMINUS:
					if (newcolpop[1] > 0 && newlivebugcount > 1)
					{
						if (newthree_d_flag)
						{
							newtraillength -= newtraillength /
								newlivebugcount;
							if (newtraillength <
								newlivebugcount * 2)
								newtraillength =
									newlivebugcount * 2;
						}
						else if (newcolpop[1] > 1)
						{
							colony_newtraillength[1] -=
								colony_newtraillength[1] /
									newcolpop[1];
							if (colony_newtraillength[1] < 
								newcolpop[1] * 2)
								colony_newtraillength[1] = 
									newcolpop[1] * 2;
						}
						newcolpop[1]--;
						newlivebugcount--;
						label( hDlg, ID_COL1COUNT,
							NAME1, (short)(newcolpop[1]) );
						if (newthree_d_flag)
						{
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
						}
						else if (newcolpop[1])
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)(
								colony_newtraillength[1] /
								(newcolpop[1]) ) );
					}
					break;

				case ID_COL1COUNTPLUS:
					if ( newlivebugcount + 1 <= MAXBUGS)
					{
						if (newthree_d_flag)
						{
							newtraillength += newtraillength /
								newlivebugcount;
							if (newtraillength > MAXTRAILLENGTH)
								newtraillength = MAXTRAILLENGTH;
						}
						else if (newcolpop[1])
						{
							colony_newtraillength[1] +=
								colony_newtraillength[1] /
								newcolpop[1];
							if (colony_newtraillength[1] > 
								COLONY_MAXTRAILLENGTH)
								colony_newtraillength[1] = 
									COLONY_MAXTRAILLENGTH;
						}
						newcolpop[1]++;
						newlivebugcount++;
						label( hDlg, ID_COL1COUNT,
							NAME1, (short)(newcolpop[1]) );
						if (newthree_d_flag)
						{
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
						}
						else
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)(
								colony_newtraillength[1] /
								(newcolpop[1]) ) );
						}
					break;

				case ID_COL2COUNTMINUS:
					if (newcolpop[2] > 0 && newlivebugcount > 1)
					{
						if (newthree_d_flag)
						{
							newtraillength -= newtraillength /
								newlivebugcount;
							if (newtraillength <
								newlivebugcount * 2)
								newtraillength =
									newlivebugcount * 2;
						}
						else if (newcolpop[2] > 1)
						{
							colony_newtraillength[2] -=
								colony_newtraillength[2] /
									newcolpop[2];
							if (colony_newtraillength[2] < 
								newcolpop[2] * 2)
								colony_newtraillength[2] = 
									newcolpop[2] * 2;
						}
						newcolpop[2]--;
						newlivebugcount--;
						label( hDlg, ID_COL2COUNT,
							NAME2, (short)(newcolpop[2]) );
						if (newthree_d_flag)
						{
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
						}
						else if (newcolpop[2])
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)(
								colony_newtraillength[2] /
								(newcolpop[2]) ) );
					}
					break;

				case ID_COL2COUNTPLUS:
					if ( newlivebugcount + 1 <= MAXBUGS)
					{
						if (newthree_d_flag)
						{
							newtraillength += newtraillength /
								newlivebugcount;
							if (newtraillength > MAXTRAILLENGTH)
								newtraillength = MAXTRAILLENGTH;
						}
						else if (newcolpop[2])
						{
							colony_newtraillength[2] +=
								colony_newtraillength[2] /
								newcolpop[2];
							if (colony_newtraillength[2] > 
								COLONY_MAXTRAILLENGTH)
								colony_newtraillength[2] = 
									COLONY_MAXTRAILLENGTH;
						}
						newcolpop[2]++;
						newlivebugcount++;
						label( hDlg, ID_COL2COUNT,
							NAME2, (short)(newcolpop[2]) );
						if (newthree_d_flag)
						{
							ulabel( hDlg, ID_TRAILLENGTH0, NAME0,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH1, NAME1,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)( newtraillength /
								(newlivebugcount) ) );
						}
						else
							ulabel( hDlg, ID_TRAILLENGTH2, NAME2,
								(unsigned short)(
								colony_newtraillength[2] /
								(newcolpop[2]) ) );
						}
					break;

				case ID_OK:
					if (newcolpop[0] != Colony[0].pop ||
						newcolpop[1] != Colony[1].pop ||
						newcolpop[2] != Colony[2].pop)
					{
						putbugsincolonies(newcolpop);
						for (i=0; i < livebugcount; i++)
						{
							installdirectiontype(Bug[bugnum[i]]);
							installmotiontype(Bug[bugnum[i]]);
							DNA_to_RNA(Bug[bugnum[i]]);
						}
						worldclearflag = 1;
					}
					if (wrapflag != newwrapflag)
					{
						wrapflag = newwrapflag;
						worldclearflag = 1;
					}
					if (randposflag)
						randomizepositions(
						GetParent(hDlg) );
					if (foodglobflag != newfoodglobflag)
					{
						foodglobflag = newfoodglobflag;
						if (foodglobflag)
						{
							hdc = GetDC(hwnd);
							makefoodglob();
							drawfoodglob(hdc);
							ReleaseDC(hwnd, hdc);
						}
						worldclearflag = 1;
					}
					if (poisonglobflag != newpoisonglobflag)
					{
						poisonglobflag = newpoisonglobflag;
						if (poisonglobflag)
						{
							hdc = GetDC(hwnd);
							makepoisonglob();
							drawpoisonglob(hdc);
							ReleaseDC(hwnd, hdc);
						}
						worldclearflag = 1;
					}
					if (mazeflag != newmazeflag)
					{
						mazeflag = newmazeflag;
						if (mazeflag)
						{
							makemaze();
							cornerbugs(hwnd);
						}
						worldclearflag = 1;
					}
					if (newthree_d_flag != three_d_flag)
					{
						three_d_flag = newthree_d_flag;
						if (!three_d_flag)
							stereoflag = 0;
						for (i=0; i < livebugcount; i++)
						{ 
							installdirectiontype(Bug[bugnum[i]]);
							installmotiontype(Bug[bugnum[i]]);
							DNA_to_RNA(Bug[bugnum[i]]);
						}
						if (hDlgShape)
						{  // Shape is different in 2D and 3D
							DestroyWindow(hDlgShape);
							SendMessage(hwnd, WM_COMMAND, IDM_SHAPE,
								0L);
						}
						worldclearflag = 1;
					}
					if (CAflag != newCAflag)
						CAflag = newCAflag;
					if (three_d_flag)
					{ 
						if (traillength != newtraillength ||
							erasetrailflag != newerasetrailflag)
						{
							worldclearflag = 1;
							traillength = newtraillength;
							erasetrailflag = newerasetrailflag;
						}
					}
					else
						for (i=0; i<MAXCOLONIES; i++)
							if (colony_traillength[i] !=
								colony_newtraillength[i] ||
								colony_erasetrailflag[i] !=
								colony_newerasetrailflag[i])
							{
								hdc = GetDC(hwnd);
								if (colony_newerasetrailflag[i]&&
									!colony_erasetrailflag[i])
									worldclearflag = 1;
								for (j=0; j<Colony[i].pop; j++)
								{
									if (Bug[Colony[i].rank[j]]->
										bugbodyflag == 2)
									{
										worldclearflag = 1;
										break;
									}
								}
								colony_erasetrailflag[i] =
									colony_newerasetrailflag[i];
								if (colony_traillength[i] !=
									colony_newtraillength[i])
									worldclearflag = 1;
								colony_traillength[i] =
									colony_newtraillength[i];
								ReleaseDC(hwnd, hdc);
							}
//					DestroyWindow( hDlg );
			EndDialog(hDlg, TRUE);
					break;

				case ID_CANCEL:
//					DestroyWindow(hDlg);
			EndDialog(hDlg, TRUE);
					break;
			}
			return TRUE; // End of WM_COMMAND case in main switch.

		default:
			return FALSE; // Case where message means nothing to me.
	}
}

