#include "bug.h"
#include "bugmenu.h"
#include "sound.h"
#include <windows.h>
#include <dos.h>
#include <string.h>
#include <mmsystem.h>
//#define VOICE 1
#define SND 1
//#define MIDI 1
//#define WAVE 1
#ifndef CYBER
	#include "commdlg.h"
#else //CYBER
	#include "commdlg.hpp"
#endif //CYBER

//----Sound Function Data
extern unsigned char editbugid, soundflag;
#ifdef MIDI
LPHMIDIOUT lphMidiOut = NULL;
unsigned char firsttime = 1;
MIDIHDR MidiOutHdr;
#endif //MIDI

void sound (unsigned char);
void windelay(int);
void beep(int);
//-----Dialog Function Data
extern HWND hwnd, hDlgSound;
extern char szAppName[]; //For Profile
char sound_file_name[SOUND_INDEX_RANGE][MAXFILENAME];
/* = {
"SystemExclamation","SystemAsterisk","SystemStart","SystemExit",
"SystemDefault","SystemExclamation","SystemAsterisk","SystemStart",
"SystemExit"};
*/
static unsigned char sound_file_index = 0;
//----------------Dialog Function---------

#ifdef CYBER
extern "C" BOOL FAR PASCAL SoundProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#else
BOOL FAR PASCAL SoundProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#endif //CYBER
{
	RECT rect;
	char buf[16]; // Used by WriteProfileString
	OPENFILENAME ofn;
	char szFilterSpecBL [128] =
		"Sound Files (*.WAV)\0All Files (*.*)\0*.*\0";
		/* file type filters */
	char szFileName[MAXFILENAME];
	char szFileTitle[MAXFILENAME];

	switch (message)
	{
		case WM_INITDIALOG:
		// Eat and Breed buttons.
			CheckRadioButton( hDlg, SND_PREY, SND_SEX,
				SND_PREY + sound_file_index);
		// Sound types buttons
			CheckDlgButton( hDlg, SND_NONE, (soundflag & SOUNDFLAG_MASK)?
				MF_UNCHECKED:MF_CHECKED);
			CheckDlgButton( hDlg, SND_EAT,
				(soundflag & SOUNDFLAG_EAT) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_BREED,
				(soundflag & SOUNDFLAG_BREED) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_STATE,
				(soundflag & SOUNDFLAG_STATE) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_DIR,
				(soundflag & SOUNDFLAG_DIR) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_STUTTER,
				(soundflag & SOUNDFLAG_STUTTER) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckMenuItem( GetMenu(hwnd),IDM_SOUND,MF_BYCOMMAND |
				MF_CHECKED);
			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"SoundX",
				(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"SoundY",
				(LPSTR)buf);
	CheckDlgButton( hDlg, SND_NONE, (soundflag & SOUNDFLAG_MASK)?
						MF_UNCHECKED:MF_CHECKED);
					CheckDlgButton( hDlg, SND_EAT,
						(soundflag & SOUNDFLAG_EAT) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_BREED,
						(soundflag & SOUNDFLAG_BREED) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_STATE,
						(soundflag & SOUNDFLAG_STATE) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_DIR,
						(soundflag & SOUNDFLAG_DIR) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_STUTTER,
						(soundflag & SOUNDFLAG_STUTTER) ?
						MF_CHECKED : MF_UNCHECKED);
			return TRUE;

		case WM_LBUTTONDOWN:
			return TRUE;

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			DestroyWindow(hDlg);
			return TRUE;

		case WM_DESTROY:
			hDlgSound = 0; // Turn off modeless handle
			CheckMenuItem( GetMenu(hwnd),IDM_SOUND,MF_BYCOMMAND |
				MF_UNCHECKED);
			InvalidateRect (hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case SND_PREY:
				case SND_PRED:
				case SND_FOOD:
				case SND_POISON:
				case SND_WALL:
				case SND_OTHER:
				case SND_DEATH:
				case SND_SEX:
					CheckRadioButton( hDlg, SND_PREY, SND_SEX,
						wParam );
					sound_file_index = wParam - SND_PREY;
			//Do the following, otherwise the buttons get turned off
			CheckDlgButton( hDlg, SND_NONE, (soundflag & SOUNDFLAG_MASK)?
				MF_UNCHECKED:MF_CHECKED);
			CheckDlgButton( hDlg, SND_EAT,
				(soundflag & SOUNDFLAG_EAT) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_BREED,
				(soundflag & SOUNDFLAG_BREED) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_STATE,
				(soundflag & SOUNDFLAG_STATE) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_DIR,
				(soundflag & SOUNDFLAG_DIR) ?
				MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_STUTTER,
				(soundflag & SOUNDFLAG_STUTTER) ?
				MF_CHECKED : MF_UNCHECKED);
					break;

				case SND_LOAD:
					strcpy(szFileName,"*.wav");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hDlg;
					ofn.lpstrFilter	  = szFilterSpecBL;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "WAV";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						strcpy(sound_file_name[sound_file_index],
							szFileName);
						switch (sound_file_index)
						{
							case PREY_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Prey Sound",
								(LPSTR)szFileName);
								break;
							case PRED_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Predator Sound",
								(LPSTR)szFileName);
								break;
							case FOOD_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Food Sound",
								(LPSTR)szFileName);
								break;
							case POISON_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Poison Sound",
								(LPSTR)szFileName);
								break;
							case WALL_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Wall Sound",
								(LPSTR)szFileName);
								break;
							case OTHER_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Other Sound",
								(LPSTR)szFileName);
								break;
							case DEATH_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Death Sound",
								(LPSTR)szFileName);
								break;
							case SEX_SOUND_INDEX:
								WriteProfileString((LPSTR)szAppName,
								(LPSTR)"Rebirth Sound",
								(LPSTR)szFileName);
								break;
						}
					}
					// You have to fix these buttons each time
					// as they are not auto radio.
					CheckDlgButton( hDlg, SND_NONE, (soundflag & SOUNDFLAG_MASK)?
						MF_UNCHECKED:MF_CHECKED);
					CheckDlgButton( hDlg, SND_EAT,
						(soundflag & SOUNDFLAG_EAT) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_BREED,
						(soundflag & SOUNDFLAG_BREED) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_STATE,
						(soundflag & SOUNDFLAG_STATE) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_DIR,
						(soundflag & SOUNDFLAG_DIR) ?
						MF_CHECKED : MF_UNCHECKED);
			CheckDlgButton( hDlg, SND_STUTTER,
				(soundflag & SOUNDFLAG_STUTTER) ?
				MF_CHECKED : MF_UNCHECKED);
					break;

				case SND_NONE:
				case SND_EAT:
				case SND_BREED:
				case SND_STATE:
				case SND_DIR:
				case SND_STUTTER:
					switch (wParam)
					{
						case SND_NONE:
							soundflag &= ~SOUNDFLAG_MASK;
							break;

						case SND_EAT:
							soundflag ^= SOUNDFLAG_EAT;
							break;

						case SND_BREED:
							soundflag ^= SOUNDFLAG_BREED;
							break;

						case SND_STATE:
							soundflag ^= SOUNDFLAG_STATE;
							// Can't have state and dir together.
							if (soundflag & SOUNDFLAG_STATE)
								soundflag &= ~SOUNDFLAG_DIR;
							break;
	
						case SND_DIR:
							soundflag ^= SOUNDFLAG_DIR;
							// Can't have state and dir together.
							if (soundflag & SOUNDFLAG_DIR)
								soundflag &= ~SOUNDFLAG_STATE;
							break;

						case SND_STUTTER:
							soundflag ^= SOUNDFLAG_STUTTER;
							break;

						default:
							return FALSE;
					}
					CheckDlgButton( hDlg, SND_NONE, (soundflag & SOUNDFLAG_MASK)?
						MF_UNCHECKED:MF_CHECKED);
					CheckDlgButton( hDlg, SND_EAT,
						(soundflag & SOUNDFLAG_EAT) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_BREED,
						(soundflag & SOUNDFLAG_BREED) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_STATE,
						(soundflag & SOUNDFLAG_STATE) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_DIR,
						(soundflag & SOUNDFLAG_DIR) ?
						MF_CHECKED : MF_UNCHECKED);
					CheckDlgButton( hDlg, SND_STUTTER,
						(soundflag & SOUNDFLAG_STUTTER) ?
						MF_CHECKED : MF_UNCHECKED);

					wsprintf((LPSTR)buf,"%u",soundflag);
					WriteProfileString((LPSTR)szAppName,
						(LPSTR)"Sound Flag",
						(LPSTR)buf);

					break;

				case SND_OK:
					DestroyWindow(hDlg);
					break;

				default:
					return FALSE;
			}
			return TRUE;
	}
	return FALSE;
}

//--------------------Sound Functions
/*		case BLANKSOUND:
			beep(MOD(bug->state,10));
			break;
		case SELFSOUND:
			beep(MOD(bug->state,10) + 10);
			break;
*/
void beep(int pitch)
{
	if (OpenSound())
	{
//		StopSound();
		SetVoiceQueueSize (1,30);
//		SetVoiceAccent(1, 120, 128, S_NORMAL, 0);
		SetVoiceNote(1, pitch, 32, 0);
		StartSound();
//		windelay(1);
//		StopSound();
//		CloseSound();
	}
}

void sound(unsigned char soundtype)
{

#ifdef SND
	if (soundflag & SOUNDFLAG_STUTTER)
		sndPlaySound(sound_file_name[soundtype],SND_ASYNC);
	else
		sndPlaySound(sound_file_name[soundtype],SND_ASYNC | SND_NOSTOP);
	// the NOSTOP flag says don't start the sound if someone else
	// is playing.  This eliminates stutter.
#endif //SND
#ifdef MIDI
	if (firstime)
        {
        	if (midiOutGetNumDevs())
			midiOutOpen(lphMidiOut,MIDI_MAPPER,NULL,0,0);
                firsttime = 0;

	 }
	 midiOutLongMsg(lphMidiOut, lpMidiOutHdr, wSize);
#endif //MIDI
}

void windelay(int hundredth_secs)
{
// Since Windows doesn't support the Boralnd delay() function we
// have to write our own delay routine.  Borland struct time has
// ti_sec and ti_hund fields which are unsigned chars.  We have
// to be careful of the possibility ti_hund wraps to 0 (every sec) or that
// ti_sec wraps to 0 (every minute).  You can safely assume that the
// loop will execute faster than in a hundredth of a second, so that
// ti_hund won't sneak from 99 to 1.
// I should just use a Timer here.

	struct time timestart, timenow;
	unsigned int starthund, nowhund, nowsec,
		hundoffset = 0, secoffset = 0;
	
	if (hundredth_secs)
	{
		gettime(&timestart);
		nowhund = starthund = 100 *
			(unsigned int)timestart.ti_sec +
			(unsigned int)timestart.ti_hund;
		nowsec = timestart.ti_sec;
		do
		{
			gettime(&timenow);
			if (nowhund && !timenow.ti_hund)
				hundoffset += 100;	//wrap hunds.
			if (nowsec && !timenow.ti_sec)
				secoffset++;		// wrap secs.
			nowsec = (unsigned int) timenow.ti_sec;
			nowhund = (unsigned int) timenow.ti_hund;
		}
		while ( 100 * (nowsec + secoffset) + nowhund + hundoffset -
			starthund < hundredth_secs);
	}
}

	