#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrstop
#include "score.h"

extern char szAppName[];
extern unsigned char editbugid, livebugcount;
extern struct colony Colony[];
extern struct bug *Bug[];
extern HWND hDlgScore, hwnd;
extern HBITMAP hBitmapBugBody_2D[];
extern HDC     hdcBugBody_2D[];
extern short	BugBody_2D_CX[],BugBody_2D_CY[];
extern unsigned short score_history_index;

void numlabel( HWND , int , short );


#ifdef CYBER
extern "C" BOOL FAR PASCAL ScoreProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#else
BOOL FAR PASCAL ScoreProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#endif //CYBER
{
	unsigned char i,j;
	long sum;
	RECT rect, hwndrect;
	char buf[32];
	PAINTSTRUCT ps;
	HDC hdc;
	static unsigned char bodynumber = -1;
	static int icon_x = 0;

	switch( message )
	{
		case WM_INITDIALOG:
			numlabel( hDlg, SC_COLONY0, (int)Colony[0].fitness );
			numlabel( hDlg, SC_COLONY1, (int)Colony[1].fitness );
			numlabel( hDlg, SC_COLONY2, (int)Colony[2].fitness );
			numlabel( hDlg, SC_COLONY0_OLD, (int)Colony[0].oldfitness );
			numlabel( hDlg, SC_COLONY1_OLD, (int)Colony[1].oldfitness );
			numlabel( hDlg, SC_COLONY2_OLD, (int)Colony[2].oldfitness );
			numlabel( hDlg, SC_EDITBUG, (int)Bug[editbugid]->energy );
			CheckMenuItem( GetMenu(hwnd),IDM_SCORE,
				MF_BYCOMMAND | MF_CHECKED);
			return TRUE;

		case WM_DESTROY:
			CheckMenuItem( GetMenu(hwnd),IDM_SCORE,
				MF_BYCOMMAND | MF_UNCHECKED);
			hDlgScore = 0; // Turn off modeless handle
			InvalidateRect (hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			icon_x = (int)((rect.right - rect.left)*0.8);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"ScoreX",
				(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"ScoreY",
				(LPSTR)buf);
			return TRUE;

		case WM_PAINT:
			hdc = BeginPaint( hDlg, &ps );
			bodynumber=Bug[editbugid]->bodyid;
//Draw 32x32 white space --- don't need if you invalidate a largish rectf
//			StretchBlt(hdc, icon_x, 4,
//				32,32,hdcBugBody_2D[1], 1,1,2,2, SRCCOPY);
// Draw the body
			StretchBlt(hdc, icon_x, 4, 2 * BugBody_2D_CX[bodynumber],
				2 * BugBody_2D_CY[bodynumber],
				hdcBugBody_2D[bodynumber], 0, 0,
				BugBody_2D_CX[bodynumber],
				BugBody_2D_CY[bodynumber] , SRCCOPY);
			EndPaint( hDlg, &ps );
			return TRUE;

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			DestroyWindow( hDlg );
			return TRUE;

		case WM_COMMAND:
			switch ( wParam )
			{
				case SC_UPDATE:
					for (j=0; j<MAXCOLONIES; j++)
					{
						if (!(Colony[j].pop))
					{
							Colony[j].fitness = 0;
							continue; // skip the loop body for empty cols.
						}
						sum = 0;
						for (i=0; i < Colony[j].pop; i++)
							sum +=  Bug[Colony[j].rank[i]]->
								energy;
						Colony[j].fitness =
							(short)(sum / (long)(Colony[j].pop));
					}
					if (Bug[editbugid]->bodyid!=bodynumber)
					{
						bodynumber=Bug[editbugid]->bodyid;
	//This erases the old icon so that WM_PAINT can put in new one.
						rect.left = icon_x;
						rect.right = rect.left + BODYPATCH_X;
						rect.top = 4;
						rect.bottom = rect.top + BODYPATCH_Y;
						InvalidateRect(hDlg,&rect,TRUE);
					}
					numlabel( hDlg, SC_COLONY0,
						(int)Colony[0].fitness );
					numlabel( hDlg, SC_COLONY1,
						(int)Colony[1].fitness );
					numlabel( hDlg, SC_COLONY2,
						(int)Colony[2].fitness );
					numlabel( hDlg, SC_EDITBUG,
						(int)Bug[editbugid]->energy );
					break;

				case SC_BREED_UPDATE + 0:
					numlabel( hDlg, SC_COLONY0_OLD,
						(int)Colony[0].fitness );
					break;

				case SC_BREED_UPDATE + 1:
					numlabel( hDlg, SC_COLONY1_OLD,
						(int)Colony[1].fitness );
					break;

				case SC_BREED_UPDATE + 2:
					numlabel( hDlg, SC_COLONY2_OLD,
						(int)Colony[2].fitness );
					break;

				default:
					break;
			}
			return TRUE; // End of WM_COMMAND case in main switch.

		default:
			return FALSE; // Case where message means nothing to me.
	}
}

