//----------------Loadsave.cpp------
#define BLIND 1
//-----------Includes and defines-----------------
#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#pragma hdrstop
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "random.h"
//----- Load/save these---------------------------------
extern void filecaption(HWND, char *);
extern short bugeatvalue[MAXCOLONIES][MAXCOLONIES];
extern COLORREF blankcolor;
extern unsigned char isolatedflag, editbugid;

extern unsigned char bugnum[];
extern unsigned char livebugcount;
extern unsigned char colonycount;
extern unsigned char bugspercolony;
extern unsigned char wrapflag;
extern unsigned char Zwrapflag;
extern unsigned char ecology;
extern unsigned char three_d_flag;
extern unsigned char erasetrailflag;
extern unsigned char colony_erasetrailflag[MAXCOLONIES];
extern unsigned char mazeflag;
extern unsigned char foodglobflag;
extern unsigned char poisonglobflag;
extern unsigned char CAwrapflag;
extern unsigned char CAstretchflag;
extern unsigned char CAtype;
extern unsigned char CApalette_type;
extern unsigned char CAflag,CAwaitcounter,CAwaitalarm, lambdalevel;

// 13 ushort
extern unsigned short seed, lambdaseed;
extern unsigned short day[];
extern unsigned short traillength;
extern unsigned short colony_traillength[MAXCOLONIES];
extern unsigned short mazex, mazey, mazer;
extern unsigned short foodglobx, foodgloby, foodglobxr, foodglobyr;
extern unsigned short poisonglobx, poisongloby, poisonglobxr, poisonglobyr;

// 3 short
extern short mesh_size;
extern short CALand_CX,  CALand_CY; 

// 27 of these each with 9 uchar
extern struct bug *Bug[];

// 3 of these each with 1 uchar 10 short
extern struct colony Colony[];
//-----------non Load/Save Extern Data-------
extern HWND hwnd;
extern short BugLand_CX, BugLand_CY;
extern unsigned int randomizermask;
//------------Own Functions-------------
int writeparams(char *);
int readparams(char *);
void installparams(HWND);
void randomizeparams(HWND, unsigned int);

int writebugparams(struct bug *, char *);
int readbugparams(struct bug *, char *);
void installbugparams(struct bug *);

int writeworld( char *);
int readworld( char *);
int findfile( char *);
void installworld(HWND);
void near fixbugnum(void);

//------------New Own Functions-------------
int newwriteparams(char *);
int newreadparams(char *);
void newinstallparams(HWND);

int newwritebugparams(struct bug *, char *);
int newreadbugparams(struct bug *, char *);
void newinstallbugparams(struct bug *);

int newwriteworld( char *);
int newreadworld( char *);
void newinstallworld(HWND);

//------------External Functions-------------
extern void installmotiontype(struct bug *);
extern void installdirectiontype(struct bug *);
extern void DNA_to_RNA(struct bug *);
extern void putbugsincolonies(unsigned char *);
extern void installbugeatvalue(void);
extern void DNA_to_RNA(struct bug*);
extern void dressbugforcolony(struct bug *);
extern void randomizegenes(struct bug *);

extern void randomizepositions(HWND);
extern void adjustwrapparms(void);
extern void makefoodglob(void);
extern void makepoisonglob(void);

extern void FillCApalette(HDC);
extern void resizeCA(HDC, float);
extern void installCAtype(void);
extern void fillCA(unsigned char);
extern void newday(void);
//------------Code-----------------------


//----------------World Randomize-----------------
void randomizeparams(HWND hwnd, unsigned int wParam)
{
	//wParam is RAN_BIOSPHERE, RAN_ECOLOGY, RAN_COLONIES,
	// RAN_BUGS, RAN_WORLD

	unsigned char i,j, newpopcount[MAXCOLONIES];

#ifndef REGRESS
	// Seed the randomizer and save the seed for use in
	// world saves.  This so randomize sequence is different each time.
	seed = Randomize();
	//churn it a little too, so that the clock time template doesn't
	// dominate.
	for (i=0; i<46; i++)
		j = Randombyte(); // j is a dummy.
#endif //REGRESS
	if (wParam == RAN_BIOSPHERE || wParam == RAN_WORLD)
	{
	// world params
		for (i=0; i<MAXCOLONIES; i++)
			newpopcount[i] = Random(MAXBUGS/MAXCOLONIES);
		// Do a putbugs in colonies right away so that livebugcount
		// is up to date, along with bugnum up to date.
		putbugsincolonies(newpopcount);
		if (randomizermask & RAN_WALL)
		{
			wrapflag = Random(6)?1:0;
			Zwrapflag = wrapflag?1:0;
		}
		mazeflag = 0;
		foodglobflag = Random(2);
		poisonglobflag = Random(2);
		if (randomizermask & RAN_DIM)
			three_d_flag = Random(4)?0:1;
		if (!three_d_flag && (randomizermask & RAN_CA))
			CAflag = 2 * (Random(4)?0:1); // usually 0, else 2
		 // 0 is bugs only, 2 bugs & ca.
		else
		{
			CAflag = 0;
			foodglobflag = 0;
			poisonglobflag = 0;
			mazeflag = 0;
		}
		if (CAflag)
		{
			CAwrapflag = Random(2);
			CAstretchflag = 0;
			CAtype = Random(CATYPE_COUNT);
		}
		if (Random(8))//usually
		{
			erasetrailflag = 1;
			traillength = Random(MAXTRAILLENGTH);
		}
		else
		{
			erasetrailflag = 0;
			traillength = MAXTRAILLENGTH+1;
		}
		for (i=0; i<MAXCOLONIES; i++)
		{
			if (Random(16)) //usually
			{
				colony_erasetrailflag[i] = 1;
				colony_traillength[i] =  Random(COLONY_MAXTRAILLENGTH);
			}
			else
			{
				colony_erasetrailflag[i] = 0;
				colony_traillength[i] =  COLONY_MAXTRAILLENGTH + 1;
			}
		}
		if (CAflag)
		{
			CALand_CX = Random(BugLand_CX / 3);
			CALand_CY = Random(BugLand_CY / 3);
		}
		if (wParam == RAN_WORLD)
		// Do the install because of possible 3D switch
		// Also because some of the enzymes can get changed
		// in putbugsincolonies().
		// you don't do this for RAN_BIOSPHERE case, because
		// install gets done down in RAN_BUG section.
			for (i=0; i<MAXBUGS; i++)
			{
				installmotiontype(Bug[i]);
				installdirectiontype(Bug[i]);
				DNA_to_RNA(Bug[i]);
			}
		adjustwrapparms();
		if (foodglobflag)
			makefoodglob();
		if (poisonglobflag)
			makepoisonglob();
	}

	if (wParam == RAN_BIOSPHERE || wParam == RAN_ECOLOGY)
	{
	// ecology params
		for (i=0; i<MAXCOLONIES; i++)
		{
			for (j=0; j<MAXCOLONIES; j++)
				bugeatvalue[i][j] = -2 + Random(5);
			if (Random(9))
				bugeatvalue[i][i] = 0; // Want selfvalue usually 0.
				// Expect one nonzero every three times.
			Colony[i].foodvalue = 1 + Random(3);
			Colony[i].poisonvalue = -1 - Random(3);
			Colony[i].othervalue = -1 + Random(3);
			Colony[i].wallvalue = -1 + Random(3);
		}
		ecology = USER; // Cause you don't have standard settings now.
		installbugeatvalue();
	}

	if (wParam == RAN_BIOSPHERE || wParam == RAN_COLONIES)
	//colonies params
		for (i=0; i<MAXCOLONIES; i++)
		{
			Colony[i].deathlevel = 1 + Random(DEATH_LEVELS);
			Colony[i].sexlevel = Random(SEX_LEVELS);
			Colony[i].mutationlevel = Random(MUTATION_LEVELS);
			Colony[i].zaplevel = Random(ZAP_LEVELS);
			Colony[i].transpositionlevel = Random(TRANSPOSITION_LEVELS);
			Colony[i].metazapcode = Random(METAZAP_RANGE);
			Colony[i].hitradius =  1 + Random(3);
			Colony[i].breedtime = 200 + Random(2000);
			Colony[i].exogamyflag = Random(4)?0:1;
			Colony[i].endogamyflag = Random(4)?0:1;
			Colony[i].exogamyflag = Random(4)?0:1;
			Colony[i].recruitpreyflag = Random(9)?0:1;
			Colony[i].targetentropy = Random(100);
			Colony[i].goodentropyvalue = Random(200);
			Colony[i].mintotalmotion  = 20 + Random(200);
			Colony[i].lowmotionvalue  = -1 - Random(100);
			day[i] = 0;
			if (Colony[i].breedtime >= MAXBREEDTIME)
				Colony[i].breedflag = 0;
			else
				Colony[i].breedflag = 1;
//#ifdef REGRESS	
//			Colony[i].breedflag = 0;
//			// So it doesn't breed and change the randomizer during
//			// repeated calls to randomize world.
//#endif // REGRESS
		}

	if (wParam == RAN_BIOSPHERE || wParam == RAN_BUGS)
	// bug params
		for (i=0; i<livebugcount; i++)
		{
			if (wParam == RAN_BIOSPHERE)
				randomizegenes(Bug[bugnum[i]]);
			Bug[bugnum[i]]->directiontype =
				three_d_flag?Random(2):Random(5);
			if (randomizermask & RAN_TURM_BOID)
				Bug[bugnum[i]]->motiontype = Random(MOTION_COUNT);
			Bug[bugnum[i]]->states = Random(MAXSTATES) + 1;
			Bug[bugnum[i]]->basespeed = Random(4)+1;
			Bug[bugnum[i]]->radius = Random(4)?0:Random(3)+1;
			Bug[bugnum[i]]->lineflag = Random(LINES_COUNT);
			if (randomizermask & RAN_BODY)
				Bug[bugnum[i]]->bugbodyflag = Random(3);
			installmotiontype(Bug[bugnum[i]]);
			installdirectiontype(Bug[bugnum[i]]);
			DNA_to_RNA(Bug[bugnum[i]]);
		}

	if (wParam == RAN_BIOSPHERE)
		randomizepositions(hwnd);
}
// ---Param Write Read Install---------------------------------

int writeparams(char *filename)
{
	OFSTRUCT filestruct;
	FILE *fp;
	unsigned char i,j;

	if ( (fp = fdopen(OpenFile( (LPSTR)filename, &filestruct,
		OF_CREATE | OF_WRITE), "wt") ) == NULL )
	{
		return 0;
	}
	//else say you did it and do it.
	filecaption(hwnd, filename);

	// World
	fprintf(fp, "%u\n",(unsigned int)seed);
	fprintf(fp, "%u\n",(unsigned int)traillength);
	fprintf(fp, "%u\n",(unsigned int)wrapflag);
	fprintf(fp, "%u\n",(unsigned int)three_d_flag);
	fprintf(fp, "%u\n",(unsigned int)mazeflag);
	fprintf(fp, "%u\n",(unsigned int)foodglobflag);
	fprintf(fp, "%u\n",(unsigned int)poisonglobflag);
	fprintf(fp, "%u\n",(unsigned int)livebugcount);
	for (i=0; i<livebugcount; i++)
		fprintf(fp, "%u\n",(unsigned int)bugnum[i]);

	//Ecology
	fprintf(fp, "%u\n",(unsigned int)ecology);
	for (i=0; i<MAXCOLONIES; i++)
	{
		for (j=0; j<MAXCOLONIES; j++)
			fprintf(fp, "%i\n",(int)bugeatvalue[i][j]);
		fprintf(fp, "%i\n",(int)Colony[i].foodvalue);
		fprintf(fp, "%i\n",(int)Colony[i].poisonvalue);
		fprintf(fp, "%i\n",(int)Colony[i].wallvalue);
		fprintf(fp, "%i\n",(int)Colony[i].hitpreyvalue);
		fprintf(fp, "%i\n",(int)Colony[i].othervalue);
	}

	// Colonies
	for (i=0; i<MAXCOLONIES; i++)
	{
		fprintf(fp, "%u\n",(unsigned int)Colony[i].pop);
		fprintf(fp, "%u\n",(unsigned int)colony_traillength[i]);
		fprintf(fp, "%i\n",(int)Colony[i].breedtime);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].deathlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].sexlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].mutationlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].zaplevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].transpositionlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].metazapcode);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].exogamyflag);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].endogamyflag);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].recruitpreyflag);
		fprintf(fp, "%i\n",(int)Colony[i].hitradius);
		fprintf(fp, "%i\n",(int)Colony[i].lowmotionvalue);
		fprintf(fp, "%i\n",(int)Colony[i].mintotalmotion);
		fprintf(fp, "%i\n",(int)Colony[i].targetentropy);
		fprintf(fp, "%i\n",(int)Colony[i].goodentropyvalue);
		for (j=0; j<Colony[i].pop; j++)
			fprintf(fp, "%u\n",(unsigned int)Colony[i].rank[j]);
	}

	// Bugs Enzymes
	for (i=0; i<livebugcount; i++)
	{
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->colonyid);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->bugbodyflag);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->radius);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->lineflag);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->basespeed);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->motiontype);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->directiontype);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->states);
	}

	// Furniture
	fprintf(fp, "%u\n",(unsigned int)mazex);
	fprintf(fp, "%u\n",(unsigned int)mazey);
	fprintf(fp, "%u\n",(unsigned int)mazer);
	fprintf(fp, "%u\n",(unsigned int)foodglobx);
	fprintf(fp, "%u\n",(unsigned int)foodgloby);
	fprintf(fp, "%u\n",(unsigned int)foodglobxr);
	fprintf(fp, "%u\n",(unsigned int)foodglobyr);
	fprintf(fp, "%u\n",(unsigned int)poisonglobx);
	fprintf(fp, "%u\n",(unsigned int)poisongloby);
	fprintf(fp, "%u\n",(unsigned int)poisonglobxr);
	fprintf(fp, "%u\n",(unsigned int)poisonglobyr);

	// CA
	fprintf(fp, "%u\n",(unsigned int)CAwrapflag);
	fprintf(fp, "%u\n",(unsigned int)CAstretchflag);
	fprintf(fp, "%u\n",(unsigned int)CAtype);
	fprintf(fp, "%u\n",(unsigned int)CAflag);
	fprintf(fp, "%u\n",(unsigned int)lambdalevel);
	fprintf(fp, "%u\n",(unsigned int)lambdaseed);
	fprintf(fp, "%u\n",(unsigned int)CAwaitcounter);
	fprintf(fp, "%i\n",(int)CALand_CX);
	fprintf(fp, "%i\n",(int)CALand_CY);

	fclose(fp);
	return 1;
}

int readparams(char * filename)
{
	OFSTRUCT filestruct;
	FILE *fp;
	unsigned char i,j;
	unsigned int uiread;
	int iread;

	if ( (fp = fdopen( OpenFile((LPSTR)filename, &filestruct,
		OF_READ), "rt") ) == NULL )
	{
		return 0;
	}
	//else say you did it and do it.
	filecaption(hwnd, filename);

	fseek(fp, 0L, SEEK_SET);

	// World
	fscanf(fp,"%u\n",&uiread);
	seed = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	traillength = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	wrapflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	three_d_flag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	mazeflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	livebugcount = (unsigned char)uiread;
	for (i=0; i<livebugcount; i++)
	{
		fscanf(fp, "%u\n",&uiread);
		bugnum[i] = (unsigned char)uiread;
	}

	//Ecology
	fscanf(fp,"%u\n",&uiread);
	ecology = (unsigned char)uiread;
	for (i=0; i<MAXCOLONIES; i++)
	{
		for (j=0; j<MAXCOLONIES; j++)
		{
			fscanf(fp,"%i\n",&iread);
			bugeatvalue[i][j] = (short)iread;
		}
		fscanf(fp,"%i\n",&iread);
		Colony[i].foodvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].poisonvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].wallvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].hitpreyvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].othervalue = (short)iread;
	}

	// Colonies
	for (i=0; i<MAXCOLONIES; i++)
	{
		fscanf(fp,"%u\n",&uiread);
		Colony[i].pop = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		colony_traillength[i] = (unsigned short)uiread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].breedtime = (short)iread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].deathlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].sexlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].mutationlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].zaplevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].transpositionlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].metazapcode = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].endogamyflag= (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].exogamyflag= (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].recruitpreyflag= (unsigned char)uiread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].hitradius = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].lowmotionvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].mintotalmotion = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].targetentropy = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].goodentropyvalue = (short)iread;
		for (j=0; j<Colony[i].pop; j++)
		{
			fscanf(fp, "%u\n",&uiread);
			Colony[i].rank[j] = (unsigned char)uiread;
		}
	}


	// Bugs Enzymes
	for (i=0; i<livebugcount; i++)
	{
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->colonyid = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->bugbodyflag = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->radius = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->lineflag = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->basespeed = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->motiontype = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->directiontype = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->states = (unsigned char)uiread;
	}

	// Furniture
	fscanf(fp,"%u\n",&uiread);
	mazex = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	mazey = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	mazer = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobx = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodgloby = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobxr = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobyr = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobx = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisongloby = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobxr = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobyr = (unsigned short)uiread;

	// CA
	fscanf(fp,"%u\n",&uiread);
  	CAwrapflag = uiread?1:0;
	fscanf(fp,"%u\n",&uiread);
	CAstretchflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	CAtype = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	CAflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	lambdalevel = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	lambdaseed = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	CAwaitcounter = (unsigned char)uiread;
	fscanf(fp,"%i\n",&iread);
	CALand_CX = (short)iread;
	fscanf(fp,"%i\n",&iread);
	CALand_CY = (short)iread;

	fclose(fp);
	return 1;
}

void installparams(HWND hwnd)
{
	unsigned char i;
	HDC hdc;

	hdc = GetDC(hwnd);
	rseed(seed);

	fixbugnum(); //You loaded part of bugnum, call this to
		// make sure its a permutation of 0...MAXBUGS-1

	if (isolatedflag)
		isolatedflag = 0;

	if (three_d_flag)
		CAflag = 0; // To be safe.

//	CAstretchflag = 0; // for resize safety.

	if (traillength > MAXTRAILLENGTH)
	{
		traillength = MAXTRAILLENGTH + 1;
		erasetrailflag = 0;
	}
	else
		erasetrailflag = 1;

	for (i=0; i<MAXCOLONIES; i++)
	{
		if (Colony[i].breedtime >= MAXBREEDTIME)
			Colony[i].breedflag = 0;
		else
			Colony[i].breedflag = 1;
	
		if (colony_traillength[i] > COLONY_MAXTRAILLENGTH)
		{
			colony_traillength[i] = COLONY_MAXTRAILLENGTH + 1;
			colony_erasetrailflag[i] = 0;
		}
		else
			colony_erasetrailflag[i] = 1;

		Colony[i].fitness = 0;
	}

	for (i=0; i<livebugcount; i++)
	{
		if(Bug[bugnum[i]]->state > Bug[bugnum[i]]->states)
			Bug[bugnum[i]]->state = 0;
		dressbugforcolony(Bug[bugnum[i]]);
		installmotiontype(Bug[bugnum[i]]);
		installdirectiontype(Bug[bugnum[i]]);
		DNA_to_RNA(Bug[bugnum[i]]);
		Bug[bugnum[i]]->energy = 0; // Give bugs fresh start
	}
	for (i=livebugcount; i<MAXBUGS; i++)
	{
		if(Bug[bugnum[i]]->state > Bug[bugnum[i]]->states)
			Bug[bugnum[i]]->state = 0;
		Bug[bugnum[i]]->colonyid = MAXCOLONIES; // means no colony
	}

	installbugeatvalue();
	newday(); // to give the bugs a fresh start.
	editbugid = bugnum[0];
	ReleaseDC(hwnd, hdc);
}

//-------------------- World-write read install-----------------

int writeworld( char *filename)
{
//First copy the writeparams
	OFSTRUCT filestruct;
	FILE *fp;
	unsigned char i;
	int j;

	if ( (fp = fdopen(OpenFile( (LPSTR)filename, &filestruct,
		OF_CREATE | OF_WRITE), "wt") ) == NULL )
	{
		return 0;
	}
	//else say you did it and do it.
	filecaption(hwnd, filename);

	// World
	fprintf(fp, "%u\n",(unsigned int)seed);
	fprintf(fp, "%u\n",(unsigned int)traillength);
	fprintf(fp, "%u\n",(unsigned int)wrapflag);
	fprintf(fp, "%u\n",(unsigned int)three_d_flag);
	fprintf(fp, "%u\n",(unsigned int)mazeflag);
	fprintf(fp, "%u\n",(unsigned int)foodglobflag);
	fprintf(fp, "%u\n",(unsigned int)poisonglobflag);
	fprintf(fp, "%u\n",(unsigned int)livebugcount);
	for (i=0; i<livebugcount; i++)
		fprintf(fp, "%u\n",(unsigned int)bugnum[i]);

	//Ecology
	fprintf(fp, "%u\n",(unsigned int)ecology);
	for (i=0; i<MAXCOLONIES; i++)
	{
		for (j=0; j<MAXCOLONIES; j++)
			fprintf(fp, "%i\n",(int)bugeatvalue[i][j]);
		fprintf(fp, "%i\n",(int)Colony[i].foodvalue);
		fprintf(fp, "%i\n",(int)Colony[i].poisonvalue);
		fprintf(fp, "%i\n",(int)Colony[i].wallvalue);
		fprintf(fp, "%i\n",(int)Colony[i].hitpreyvalue);
		fprintf(fp, "%i\n",(int)Colony[i].othervalue);
	}

	// Colonies
	for (i=0; i<MAXCOLONIES; i++)
	{
		fprintf(fp, "%u\n",(unsigned int)Colony[i].pop);
		fprintf(fp, "%u\n",(unsigned int)colony_traillength[i]);
		fprintf(fp, "%i\n",(int)Colony[i].breedtime);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].deathlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].sexlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].mutationlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].zaplevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].transpositionlevel);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].metazapcode);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].exogamyflag);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].endogamyflag);
		fprintf(fp, "%u\n",(unsigned int)Colony[i].recruitpreyflag);
		fprintf(fp, "%i\n",(int)Colony[i].hitradius);
		fprintf(fp, "%i\n",(int)Colony[i].lowmotionvalue);
		fprintf(fp, "%i\n",(int)Colony[i].mintotalmotion);
		fprintf(fp, "%i\n",(int)Colony[i].targetentropy);
		fprintf(fp, "%i\n",(int)Colony[i].goodentropyvalue);
		for (j=0; j<Colony[i].pop; j++)
			fprintf(fp, "%u\n",(unsigned int)Colony[i].rank[j]);
	}

	// Bugs Enzymes
	for (i=0; i<livebugcount; i++)
	{
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->colonyid);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->bugbodyflag);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->radius);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->lineflag);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->basespeed);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->motiontype);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->directiontype);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->states);
	}

	// Furniture
	fprintf(fp, "%u\n",(unsigned int)mazex);
	fprintf(fp, "%u\n",(unsigned int)mazey);
	fprintf(fp, "%u\n",(unsigned int)mazer);
	fprintf(fp, "%u\n",(unsigned int)foodglobx);
	fprintf(fp, "%u\n",(unsigned int)foodgloby);
	fprintf(fp, "%u\n",(unsigned int)foodglobxr);
	fprintf(fp, "%u\n",(unsigned int)foodglobyr);
	fprintf(fp, "%u\n",(unsigned int)poisonglobx);
	fprintf(fp, "%u\n",(unsigned int)poisongloby);
	fprintf(fp, "%u\n",(unsigned int)poisonglobxr);
	fprintf(fp, "%u\n",(unsigned int)poisonglobyr);

	// CA
	fprintf(fp, "%u\n",(unsigned int)CAwrapflag);
	fprintf(fp, "%u\n",(unsigned int)CAstretchflag);
	fprintf(fp, "%u\n",(unsigned int)CAtype);
	fprintf(fp, "%u\n",(unsigned int)CAflag);
	fprintf(fp, "%u\n",(unsigned int)lambdalevel);
	fprintf(fp, "%u\n",(unsigned int)lambdaseed);
	fprintf(fp, "%u\n",(unsigned int)CAwaitcounter);
	fprintf(fp, "%i\n",(int)CALand_CX);
	fprintf(fp, "%i\n",(int)CALand_CY);


	// DNA
	for (i=0; i<livebugcount; i++)
	{
		//Location
		fprintf(fp, "%i\n",(int)Bug[bugnum[i]]->x);
		fprintf(fp, "%i\n",(int)Bug[bugnum[i]]->y);
		fprintf(fp, "%i\n",(int)Bug[bugnum[i]]->z);
		fprintf(fp, "%i\n",(int)Bug[bugnum[i]]->oldx);
		fprintf(fp, "%i\n",(int)Bug[bugnum[i]]->oldy);
		fprintf(fp, "%i\n",(int)Bug[bugnum[i]]->oldz);

		//State
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->dir);
		fprintf(fp, "%u\n",(unsigned int)Bug[bugnum[i]]->state);
		fprintf(fp, "%u\n",(int)Bug[bugnum[i]]->energy);

		//DNA
		fprintf(fp, "%i\n",Bug[bugnum[i]]->DNA_length);
		for (j=0; j< Bug[bugnum[i]]->DNA_length; j++)
			fprintf(fp, "%u\n",(unsigned char)Bug[bugnum[i]]->DNA[j]);
	}

	fclose(fp);
	return 1;
}

int readworld( char *filename)
{
//First copy the readparams
	OFSTRUCT filestruct;
	FILE *fp;
	unsigned char i;
	int j;
	unsigned int uiread;
	int iread;

	if ( (fp = fdopen( OpenFile((LPSTR)filename, &filestruct,
		OF_READ), "rt") ) == NULL )
	{
		return 0;
	}
	//else say you did it and do it.
	filecaption(hwnd, filename);

	fseek(fp, 0L, SEEK_SET);

	// World
	fscanf(fp,"%u\n",&uiread);
	seed = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	traillength = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	wrapflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	three_d_flag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	mazeflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	livebugcount = (unsigned char)uiread;
	for (i=0; i<livebugcount; i++)
	{
		fscanf(fp, "%u\n",&uiread);
		bugnum[i] = (unsigned char)uiread;
	}

	//Ecology
	fscanf(fp,"%u\n",&uiread);
	ecology = (unsigned char)uiread;
	for (i=0; i<MAXCOLONIES; i++)
	{
		for (j=0; j<MAXCOLONIES; j++)
		{
			fscanf(fp,"%i\n",&iread);
			bugeatvalue[i][j] = (short)iread;
		}
		fscanf(fp,"%i\n",&iread);
		Colony[i].foodvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].poisonvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].wallvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].hitpreyvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].othervalue = (short)iread;
	}

	// Colonies
	for (i=0; i<MAXCOLONIES; i++)
	{
		fscanf(fp,"%u\n",&uiread);
		Colony[i].pop = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		colony_traillength[i] = (unsigned short)uiread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].breedtime = (short)iread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].deathlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].sexlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].mutationlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].zaplevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].transpositionlevel = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].metazapcode = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].endogamyflag= (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].exogamyflag= (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Colony[i].recruitpreyflag= (unsigned char)uiread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].hitradius = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].lowmotionvalue = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].mintotalmotion = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].targetentropy = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Colony[i].goodentropyvalue = (short)iread;
		for (j=0; j<Colony[i].pop; j++)
		{
			fscanf(fp, "%u\n",&uiread);
			Colony[i].rank[j] = (unsigned char)uiread;
		}
	}


	// Bugs Enzymes
	for (i=0; i<livebugcount; i++)
	{
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->colonyid = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->bugbodyflag = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->radius = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->lineflag = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->basespeed = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->motiontype = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->directiontype = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->states = (unsigned char)uiread;
	}

	// Furniture
	fscanf(fp,"%u\n",&uiread);
	mazex = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	mazey = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	mazer = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobx = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodgloby = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobxr = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	foodglobyr = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobx = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisongloby = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobxr = (unsigned short)uiread;
	fscanf(fp,"%u\n",&uiread);
	poisonglobyr = (unsigned short)uiread;

	// CA
	fscanf(fp,"%u\n",&uiread);
  	CAwrapflag = uiread?1:0;
	fscanf(fp,"%u\n",&uiread);
	CAstretchflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	CAtype = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	CAflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	lambdalevel = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	lambdaseed = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	CAwaitcounter = (unsigned char)uiread;
	fscanf(fp,"%i\n",&iread);
	CALand_CX = (short)iread;
	fscanf(fp,"%i\n",&iread);
	CALand_CY = (short)iread;



	// DNA
	for (i=0; i<livebugcount; i++)
	{
		//Location
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->x = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->y = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->z = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->oldx = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->oldy = (short)iread;
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->oldz = (short)iread;

		// State
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->dir = (unsigned char)uiread;
		fscanf(fp,"%u\n",&uiread);
		Bug[bugnum[i]]->state = (unsigned char)uiread;
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->energy = (short)iread;

		//DNA
		fscanf(fp,"%i\n",&iread);
		Bug[bugnum[i]]->DNA_length = iread;
		for (j=0; j< Bug[bugnum[i]]->DNA_length; j++)
		{
			fscanf(fp,"%u\n",&uiread);
			Bug[bugnum[i]]->DNA[j] = (unsigned char)uiread;
		}
	}

	fclose(fp);
	return 1;
}

void installworld(HWND hwnd)
{
	installparams(hwnd);
}

// --- Bug Write Read Install---------------------------------

int writebugparams(struct bug *bug, char *filename)
{
	OFSTRUCT filestruct;
	FILE *fp;
	int i;

	if ( (fp = fdopen(OpenFile( (LPSTR)filename, &filestruct,
		OF_CREATE | OF_WRITE), "wt") ) == NULL )
	{
		return 0;
	}

	// Enzymes
	fprintf(fp, "%u\n",(unsigned int)bug->bugbodyflag);
	fprintf(fp, "%u\n",(unsigned int)bug->radius);
	fprintf(fp, "%u\n",(unsigned int)bug->lineflag);
	fprintf(fp, "%u\n",(unsigned int)bug->basespeed);
	fprintf(fp, "%u\n",(unsigned int)bug->motiontype);
	fprintf(fp, "%u\n",(unsigned int)bug->directiontype);
	fprintf(fp, "%u\n",(unsigned int)bug->states);

	//State
	fprintf(fp, "%u\n",(unsigned int)bug->dir);
	fprintf(fp, "%u\n",(unsigned int)bug->state);

	//DNA
	fprintf(fp, "%u\n",bug->DNA_length);
	for (i=0; i< bug->DNA_length; i++)
		fprintf(fp, "%u\n",(unsigned int)bug->DNA[i]);

	fclose(fp);
	return 1;
}

int readbugparams(struct bug *bug, char *filename)
{
	OFSTRUCT filestruct;
	FILE *fp;
	int i;
	unsigned int uiread;

	if ( (fp = fdopen( OpenFile((LPSTR)filename, &filestruct,
		OF_READ), "rt") ) == NULL )
	{
		return 0;
	}
	fseek(fp, 0L, SEEK_SET);

	// Enzymes
	fscanf(fp,"%u\n",&uiread);
	bug->bugbodyflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->radius = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->lineflag = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->basespeed = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->motiontype = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->directiontype = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->states = (unsigned char)uiread;

	// State
	fscanf(fp,"%u\n",&uiread);
	bug->dir = (unsigned char)uiread;
	fscanf(fp,"%u\n",&uiread);
	bug->state = (unsigned char)uiread;

	//DNA
	fscanf(fp,"%u\n",&uiread);
	bug->DNA_length = uiread;
	for (i=0; i< bug->DNA_length; i++)
	{
		fscanf(fp,"%u\n",&uiread);
		bug->DNA[i] = (unsigned char)uiread;
	}

	fclose(fp);
	return 1;
}

void installbugparams(struct bug *bug)
{
	if (bug->states > MAXSTATES)
		bug->states = MAXSTATES;
	if (bug->state > bug->states)
		bug->state = 0;
	installmotiontype(bug);
	installdirectiontype(bug);
	DNA_to_RNA(bug);
}
//-----------------------NEW FUNCTIONS--------

// ---NEW Param Write Read Install---------------------------------

int newwriteparams(char *filename)
{
	return 1;
}

int newreadparams(char * filename)
{
	return 1;
}

void newinstallparams(HWND hwnd)
{
}
//--------------------New World-write read install-----------------
int newwriteworld( char *filename)
{
	return 1;
}

int newreadworld( char *filename)
{
	return 1;
}

void newinstallworld(HWND hwnd)
{
}
// ---New Bug Write Read Install---------------------------------

int newwritebugparams(struct bug *bug, char *filename)
{
	return 1;

}

int newreadbugparams(struct bug *bug, char *filename)
{
	return 1;
}

void newinstallbugparams(struct bug *bug)
{
}



//-------------------------EXTRA--------------------
void near fixbugnum(void)
{ // The idea is that you have filled in bugnum up to livebugcount,
	// and need for the remaining numbers less than MAXBUGS to
	// appear in the rest of the bugnum array.
	unsigned char listed[MAXBUGS], i, j=0;

	// Initialize so that the listed array has 1s at the indices
	// already listed by bugnum, and 0s at the unlisted indices
	for (i=0; i<MAXBUGS; i++)
		listed[i] = 0;
	for (i=0; i<livebugcount; i++)
		listed[bugnum[i]] = 1;
	for (i=livebugcount; i<MAXBUGS; i++)
	{
		//Find the first j with listed[j] = 0
		while(listed[j])
			j++;
		//And list that j next.
		bugnum[i] = j;
		listed[j] = 1;
	}
	for (i=0; i<MAXBUGS; i++)
		Bug[bugnum[i]]->bugnumid = i;
}
	

int findfile(char *filename)
{
	OFSTRUCT filestruct;
	FILE *fp;

	if ( (fp = fdopen( OpenFile((LPSTR)filename, &filestruct,
		OF_READ), "rt") ) == NULL )
		return 0;
	//else
	fclose(fp);
	return 1;
}

