#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#include "graph.h"
#include "random.h"
#define GRAPHCORNER_X 0
#define GRAPHCORNER_Y 0
#define GRAPH_SCALE(y) (short)(((double)y)* (scale_multiplier) + scale_offset)
#define MAX_GRAPH_SCALE 640 // True range is 64,000, so this scales to 100
#define START_GRAPH_SCALE 32 // Starting vertical size of 2000

#define GHSCROLLSTEP 50
#define GHSCROLLPAGESTEP 200
#define GVSCROLLSTEP 1
#define GVSCROLLPAGESTEP 10
#define SCROLL_GRAPH 1
//------------------------------Score Maintenance Header---------
extern short score_history_index;
extern short score_history_rollover;
extern struct score_record FAR *score_history;
extern struct colony Colony[];
void score_history_record(void);
extern struct score_record FAR *score_history;
//----Graph header-------------------
extern HDC hdcBugLand;
void drawgraph(HDC);
void updategraph(HDC hdc);
void near set_scale_multiplier(void);
extern void graphcaption(HWND, short, short, short);
extern COLORREF bugpalette[];
extern unsigned char strong_pal_index[], colonycount;
double scale_multiplier, scale_offset;
short dot_width = 3, dot_height = 3;
short graphimage_CX, graphimage_CY, graph_CX = SCORE_HISTORY_LENGTH,
	graph_CY, graph_winorgX =0, graph_winCX;
short graph_scale = START_GRAPH_SCALE;
 // 1 works fine with MAX_ENERGY 1000, MIN_ENERGY -1000.  So I guess
// 32 should work with 10,000 and -10,000
short nHscrollPos = 0, nVscrollPos;
//---------------------Dialog Header-------
extern HWND hwnd, hDlgGraph;
extern char szAppName[]; //For Profile
void near set_scale_multiplier(void);

//---------------------Dialog Function-------
#ifdef CYBER
 extern "C" BOOL FAR PASCAL GraphProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#else
BOOL FAR PASCAL GraphProc( HWND hDlg, WORD message, WORD wParam,
	LONG lParam )
#endif //CYBER
{
	RECT rect;
	PAINTSTRUCT ps;
	char buf[16]; // Used by WriteProfileString
	HDC hdc;
	static HDC hdcGraph; //This is the preimage
	static HBITMAP hBitmapGraph, hBitmapGraphOld;
	HPEN hPenOld, hPenCol0, hPenCol1, hPenCol2;

	switch (message)
	{
		case WM_INITDIALOG:
			CheckMenuItem( GetMenu(hwnd),IDM_GRAPH,MF_BYCOMMAND |
				MF_CHECKED);
			hPenCol0 = CreatePen(PS_SOLID, 1,
				bugpalette[strong_pal_index[0]]);
			hPenCol1 = CreatePen(PS_SOLID, 1,
				bugpalette[strong_pal_index[1]]);
			hPenCol2 = CreatePen(PS_SOLID, 1,
				bugpalette[strong_pal_index[2]]);
			hPenOld = SelectObject(hDlg,hPenCol0);
			GetClientRect(hDlg, &rect);
		// Size of the image on screen
			graphimage_CX = rect.right;
			graphimage_CY = rect.bottom;
		//Size of bitmap preimage (we'll stretch it)
		// Try a smaller graph_CX.
			graph_winCX = graphimage_CX / dot_width;
			graph_CY = graphimage_CY / dot_height;
		// Now make sure that the stretch will be integral.
			graphimage_CX = dot_width * graph_winCX;
			graphimage_CY = dot_height * graph_CY;
			scale_offset = (double)graph_CY/2; // y=0 position
			set_scale_multiplier();
			hdcGraph = CreateCompatibleDC(hdcBugLand);
			hBitmapGraph = CreateCompatibleBitmap(hdcBugLand,
				graph_CX, graph_CY);
			hBitmapGraphOld = SelectObject(hdcGraph,
				hBitmapGraph);
			SelectObject(hdcGraph, GetStockObject(WHITE_BRUSH));
			PatBlt(hdcGraph, 0, 0, graph_CX, graph_CY, PATCOPY);
			drawgraph(hdcGraph);

		// Get Scroll stuff ready.

			SetScrollRange(hDlg, SB_HORZ, 0, SCORE_HISTORY_LENGTH -
				graph_winCX, FALSE);
			SetScrollPos(hDlg, SB_HORZ, nHscrollPos, TRUE);
			SetScrollRange(hDlg, SB_VERT, 1, MAX_GRAPH_SCALE, FALSE);
			nVscrollPos = MAX_GRAPH_SCALE + 1 - graph_scale;
			SetScrollPos(hDlg, SB_VERT, nVscrollPos , TRUE);
			graphcaption(hDlg, graph_scale, graph_winorgX,
				graph_winCX);
			return TRUE;

		case WM_PAINT:
			hdc = BeginPaint( hDlg, &ps );
	// Display the graph
			StretchBlt(hdc, GRAPHCORNER_X, GRAPHCORNER_Y,
				graphimage_CX, graphimage_CY, hdcGraph,
				graph_winorgX, 0, graph_winCX, graph_CY, SRCCOPY);
			EndPaint( hDlg, &ps );
			return TRUE;

		case WM_MOVE:
			GetWindowRect(hDlg, &rect);
			wsprintf((LPSTR)buf,"%i",rect.left);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"GraphX",
				(LPSTR)buf);
			wsprintf((LPSTR)buf,"%i",rect.top);
			WriteProfileString((LPSTR)szAppName,(LPSTR)"GraphY",
				(LPSTR)buf);
			return TRUE;

		case WM_DESTROY:
			CheckMenuItem( GetMenu(hwnd),IDM_GRAPH,MF_BYCOMMAND |
				MF_UNCHECKED);
			SelectObject(hdcGraph, hBitmapGraphOld);
			SelectObject(hdcGraph, hPenOld);
			DeleteDC(hdcGraph);
			DeleteObject(hBitmapGraph);
			DeleteObject(hPenCol0);
			DeleteObject(hPenCol1);
			DeleteObject(hPenCol2);
			InvalidateRect(hwnd, NULL, TRUE); // Clear whole screen
				// else see persistence of old crud from underneath
			hDlgGraph = 0; // Turn off modeless handle
			return TRUE;

		case WM_RBUTTONDOWN:
		case WM_CLOSE:
			DestroyWindow(hDlg);
			return TRUE;

		case WM_HSCROLL:
			switch (wParam)
			{
				case SB_LINEUP:
					nHscrollPos -= GHSCROLLSTEP;
					break;
				case SB_LINEDOWN:
					nHscrollPos += GHSCROLLSTEP;
					break;
				case SB_PAGEUP:
					nHscrollPos -= GHSCROLLPAGESTEP;
					break;
				case SB_PAGEDOWN:
					nHscrollPos += GHSCROLLPAGESTEP;
					break;
				case SB_THUMBPOSITION:
					nHscrollPos = LOWORD (lParam);
					break;
				default:
					return 0;
			}
			if (nHscrollPos > SCORE_HISTORY_LENGTH -
				graph_winCX )
				nHscrollPos = SCORE_HISTORY_LENGTH - graph_winCX;
			if (nHscrollPos < 0)
				nHscrollPos = 0;
			graph_winorgX = nHscrollPos;
			SetScrollPos(hDlg, SB_HORZ, nHscrollPos,
				TRUE);
			graphcaption(hDlg, graph_scale, graph_winorgX,
				graph_winCX);
			// Erase the old graph
			InvalidateRect (hDlg, NULL, TRUE) ;
			return 0;

		case WM_VSCROLL:
			switch (wParam)
			{
				case SB_LINEUP:
					nVscrollPos -= GVSCROLLSTEP;
					break;
				case SB_LINEDOWN:
					nVscrollPos += GVSCROLLSTEP;
					break;
				case SB_PAGEUP:
					nVscrollPos -= GVSCROLLPAGESTEP;
					break;
				case SB_PAGEDOWN:
					nVscrollPos += GVSCROLLPAGESTEP;
					break;
				case SB_THUMBPOSITION:
					nVscrollPos = LOWORD (lParam);
					break;
				default:
					return 0;
			}
			SetScrollPos(hDlg, SB_VERT, nVscrollPos,
				TRUE);
			if (nVscrollPos > MAX_GRAPH_SCALE)
				nVscrollPos = MAX_GRAPH_SCALE;
			if (nVscrollPos < 1)
				nVscrollPos = 1;
			graph_scale = MAX_GRAPH_SCALE + 1 - nVscrollPos;
			graphcaption(hDlg, graph_scale, graph_winorgX,
				graph_winCX);
			set_scale_multiplier();
		//erase existing graph and replace it
			SelectObject(hdcGraph, GetStockObject(WHITE_BRUSH));
			PatBlt(hdcGraph, 0, 0, graph_CX, graph_CY, PATCOPY);
			drawgraph(hdcGraph);
		// Erase the screen graph for WM_PAINT to refill
			InvalidateRect (hDlg, NULL, TRUE) ;
			return 0;

		case WM_COMMAND:
			switch (wParam)
			{
				case GRAPH_UPDATE:
#ifdef BAR
				// This really only matters when score_history_rollover
				// Draw the indicator bar, erasing old data.
					SelectObject(hdcGraph,
						GetStockObject(BLACK_BRUSH));
					PatBlt(hdcGraph, score_history_index, 0,
						score_history_index+1, graph_CY, PATCOPY);
				// Change the old black bar to white.
					SelectObject(hdcGraph,
						GetStockObject(WHITE_BRUSH));
					PatBlt(hdcGraph, score_history_index - 1, 0,
						score_history_index, graph_CY, PATCOPY);
#endif //BAR
					updategraph(hdcGraph);
					rect.left = GRAPHCORNER_X +
						dot_width * (score_history_index -
						graph_winorgX - 1);
#ifdef BAR
					rect.right = rect.left + (2 * dot_width);
						// 2 so there's room for the black bar.
#else
					rect.right = rect.left + dot_width;
#endif //BAR
					
					rect.top =  GRAPHCORNER_Y;
					rect.bottom = GRAPHCORNER_Y + graphimage_CY;
					InvalidateRect(hDlg, &rect, TRUE);
					break;
			}
			return TRUE;
	}
	return FALSE;
}
//-------------------Graph Maintenance--------------------

void score_history_record(void)
{
	struct score_record scorepack;
	unsigned char i;

	for (i=0; i < MAXCOLONIES; i++)
		if (i >= colonycount || !Colony[i].pop)
			Colony[i].fitness = INACTIVE_FITNESS;
	// INACTIVE_FITNESS is off the scale low, MIN_ENERGY-1

	scorepack.col0 = Colony[0].fitness;
	scorepack.col1 = Colony[1].fitness;
	scorepack.col2 = Colony[2].fitness;
	score_history[score_history_index] = scorepack;
	score_history_index++;
	if (score_history_index >= SCORE_HISTORY_LENGTH)
	{
		score_history_rollover++;
		score_history_index = 0;
		graph_winorgX = 0;
		nHscrollPos = graph_winorgX;
		SetScrollPos(hDlgGraph, SB_HORZ, nHscrollPos,
			TRUE);
	}
}

void drawgraph(HDC hdc)
{
	short n;

#ifdef BAR
	// In the non BAR case, I just don't draw the pixels to the
	// right of score_history_index;I essentially reset the
	// graph to blank each time that score_history_rollover is
	// incremented.  In the BAR case I try to keep the old data.
	short upper_bound;

	if(!score_history_rollover)
		upper_bound = score_history_index;
	else
		upper_bound = SCORE_HISTORY_LENGTH;
	for (n=0; n<upper_bound; n++)
#else
	for (n=0; n<score_history_index; n++)
#endif //BAR
	{
		SetPixel(hdc, n,
			GRAPH_SCALE(score_history[n].col0),
			bugpalette[strong_pal_index[0]]);
		SetPixel(hdc, n,
			GRAPH_SCALE(score_history[n].col1),
			bugpalette[strong_pal_index[1]]);
		SetPixel(hdc,n,
			GRAPH_SCALE(score_history[n].col2),
			bugpalette[strong_pal_index[2]]);
	}
#ifdef BAR
	// This really only matters when score_history_rollover
	// Draw the indicator bar.
	SelectObject(hdc,
		GetStockObject(BLACK_BRUSH));
	PatBlt(hdc, score_history_index, 0,
		score_history_index+1, graph_CY, PATCOPY);
#endif //BAR
}

void updategraph(HDC hdc)
{	// this is called after score_history_record, so the value
	// one less than score_history_index is where the new info is.

	if (!score_history_index)
		return;

	SetPixel(hdc, score_history_index - 1,
		GRAPH_SCALE(score_history[score_history_index - 1].col0),
		bugpalette[strong_pal_index[0]]);
	SetPixel(hdc, score_history_index - 1,
		GRAPH_SCALE(score_history[score_history_index - 1].col1),
		bugpalette[strong_pal_index[1]]);
	SetPixel(hdc, score_history_index - 1,
		GRAPH_SCALE(score_history[score_history_index - 1].col2),
		bugpalette[strong_pal_index[2]]);
	graphcaption(hDlgGraph, graph_scale, graph_winorgX,
		graph_winCX);
}

void near set_scale_multiplier(void)
{
			//scale is negative as otherwise it's upside down.
			scale_multiplier = graph_scale * (-1.0) * 
				(double)(graph_CY) /
					( (double)MAX_ENERGY - (double)MIN_ENERGY);
			//Shrink the source range to the target range
}
