#include "bug.h"
#include <windows.h>
#include <dos.h>
#include <malloc.h>
#include "random.h"
extern COLORREF wallcolor;
extern short BugLand_CX, BugLand_CY, BugLand_MAXX, BugLand_MAXY,
	wrapminx, wrapminy, wrapmaxx, wrapmaxy;
extern HDC hdcBugLand;
extern COLORREF wallcolor, foodcolor, poisoncolor, blankcolor;
extern unsigned char foodglobflag, poisonglobflag, mazeflag,
	wrapflag, three_d_flag, stereoflag;
extern unsigned short mazex, mazey, mazer;
extern unsigned short foodglobx, foodgloby, foodglobxr, foodglobyr;
extern unsigned short poisonglobx, poisongloby, poisonglobxr, poisonglobyr;
extern RECT foodrect;
extern long int foodsupply; // L means long
extern long int minfoodsupply;
	//  if foodglobflag is on and foodsupply < minfoodsupply
	// you draw a new foodglob.  Drawfoodglob adds to foodsupply the
	// number of food pixels inside the foodglob.
extern RECT poisonrect;
extern long int poisonsupply; // L means long
extern long int minpoisonsupply;
	//  if poisonglobflag is on and poisonsupply < minpoisonsupply 
	// you make & drawpoisonglob.  Drawpoisonglob adds to poisonsupply the
	// number of poison pixels inside the poisonglob.

extern RECT lensrect;
extern short WinOrgX, WinOrgY;
extern unsigned char lensflag;


void furnish_putpixel(HDC, short, short, COLORREF);

void makefoodglob(void);
void makemaze(void);
void makepoisonglob(void);

void drawfoodglob(HDC hdc);
void drawmaze(HDC hdc);
void drawpoisonglob(HDC hdc);
void drawedge(HDC hdc);
extern void adjustwrapparms(void);


void makemaze(void)

{
	mazex = BugLand_CX/5 + 3 * Random(BugLand_CX/5);
	mazey = BugLand_CY/5 + 3 * Random(BugLand_CY/5);
	mazer = BugLand_CY/16 + Random(BugLand_CY/16);
}

void makefoodglob(void)
{
	foodglobx =  BugLand_CX/5 + 3 * Random(BugLand_CX/5);
	foodgloby =  BugLand_CY/5 + 3 * Random(BugLand_CY/5);
	foodglobxr = BugLand_CX/32 + Random(BugLand_CX/16);
	foodglobyr = BugLand_CY/32 + Random(BugLand_CY/16);
}

void makepoisonglob(void)

{
	poisonglobx =  BugLand_CX/5 + 3 * Random(BugLand_CX/5);
	poisongloby =  BugLand_CY/5 + 3 * Random(BugLand_CY/5);
	poisonglobxr = BugLand_CX/32 + Random(BugLand_CX/16);
	poisonglobyr = BugLand_CY/32 + Random(BugLand_CY/16);
}

void  drawfoodglob(HDC hdc)
{
	short i,j;
	COLORREF getpixel;
	
	if (three_d_flag)
		return;

	for (j = foodgloby - foodglobyr; j < foodgloby + foodglobyr; j++)
		for (i = foodglobx - foodglobxr; i < foodglobx + foodglobxr; i++)
		{
			getpixel =  GetPixel(hdcBugLand, i, j);
			if ( getpixel == blankcolor || getpixel == wallcolor )
			{
				furnish_putpixel(hdc, i, j, foodcolor);
				foodsupply++;
			}
		}
	foodrect.left = foodglobx - foodglobxr;
	foodrect.right = foodglobx + foodglobxr + 1;
	foodrect.top =  (foodgloby + foodglobyr);
	foodrect.bottom =  (foodgloby - foodglobyr - 1);
}

void  drawpoisonglob(HDC hdc)
{
	short i,j;

	
	if (three_d_flag)
		return;

	for (j = poisongloby - poisonglobyr; j <= poisongloby + poisonglobyr; j++)
		for (i = poisonglobx - poisonglobxr; i <= poisonglobx + poisonglobxr; i++)
		{
			if ( GetPixel(hdcBugLand, i,j) == blankcolor )
			{
				furnish_putpixel(hdc, i, j, poisoncolor);
				poisonsupply++;
			}
		}
	poisonrect.left = poisonglobx - poisonglobxr;
	poisonrect.right = poisonglobx + poisonglobxr +1;
	poisonrect.top =  (poisongloby + poisonglobyr);
	poisonrect.bottom =  (poisongloby - poisonglobyr - 1);
}

void  drawmaze(HDC hdc)
{
	short x, y,xstep, xedge, ystep, yedge;
	short wallwidth;
	unsigned char bail = 0;

	
	if (three_d_flag)
		return;

	wallwidth = 2;
	x = mazex;
	y = mazey;
	xedge = xstep = mazer;
	yedge = ystep = mazer;
	x += xstep / 2;
	y -= ystep / 2;
	SelectObject(hdcBugLand, CreatePen(PS_SOLID, wallwidth, wallcolor) );
	while (!bail)
	{
		MoveTo(hdcBugLand, x, y);
		x -= xedge;
		if (x < 0)
		{
			bail = 1;
			continue;
		}
		LineTo(hdcBugLand, x, y);
		LineTo(hdc, x, y);
		y += yedge;
		if (y > BugLand_MAXY)
		{
			bail = 1;
			continue;
		}
		LineTo(hdcBugLand, x, y);
		xedge += xstep;
		yedge += ystep;
		x += xedge;
		if (x > BugLand_MAXX)
		{
			bail = 1;
			continue;
		}
		LineTo(hdcBugLand, x, y);
		y -= yedge;
		if (y < 0)
		{
			bail = 1;
			continue;
		}
		LineTo(hdcBugLand, x, y);
		xedge += xstep;
		yedge += ystep;
	}
	DeleteObject(SelectObject( hdcBugLand, GetStockObject (BLACK_PEN) ) );

// draw food at the center.
	foodglobx = mazex;
	foodgloby = mazey;
	foodglobyr = foodglobxr = mazer;
	foodsupply = 0;
	drawfoodglob(hdc);
}

void drawedge(HDC hdc)
{
	HPEN wallpen, oldpen;
	short x0, xw, y0, yw;

	adjustwrapparms();

	if (wrapflag)
		return; 

	if (stereoflag)
		return;

	x0 = wrapminx - 5;
	xw = wrapmaxx + 5;
	y0 = wrapminy - 5;
	yw = wrapmaxy + 5;

	wallpen = CreatePen(PS_SOLID, 1, wallcolor);
	oldpen = SelectObject(hdc, wallpen);

	MoveTo(hdc, x0, y0);
	LineTo(hdc, xw, y0);
	LineTo(hdc, xw, yw);
	LineTo(hdc, x0, yw);
	LineTo(hdc, x0, y0);

	DeleteObject(SelectObject(hdc,oldpen));

	// Assume there's room for a double line, and draw it.
	x0--;
	xw++;
	y0--;
	yw++;

	MoveTo(hdc, x0, y0);
	LineTo(hdc, xw, y0);
	LineTo(hdc, xw, yw);
	LineTo(hdc, x0, yw);
	LineTo(hdc, x0, y0);
}

// copy this from bug.c so I can have it stay "near" in bug.c.
void furnish_putpixel(HDC hdc, short x, short y, COLORREF color)
{	SetPixel(hdcBugLand, x, y, color); // Put it in BugLand, then in hdc.
	 // Mark the screen position represented by this bugland position.
	// The Window is the viewport into this world.
	if (hdc == hdcBugLand)
		return;
	if (lensflag) // clip by hand since ExcludeClipRect is slower.
	{
		x = XWRAP(x - WinOrgX);
		y = YWRAP(y - WinOrgY);
		if (!(lensrect.left<x && x<lensrect.right &&
			lensrect.top<y && y<lensrect.bottom) )
			SetPixel(hdc, x, y, color);
	}
	else
		SetPixel(hdc, XWRAP(x - WinOrgX), YWRAP(y - WinOrgY), color);

}
