#include "bug.h"
#include <windows.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>

//ENT_FIT(e,e0) measures the fitness given to entropy e with target
//e0.  The first version runs from 1.0 at match to 0.0 if ENT_FIT_MULT
//is -1.0.  The second version gives 1.0 within ENT_FIT_WIDTH match
//and 0.0 at all others.  The first could go to -1.0 if I took
// ENT_FIT_MULT -2.0.  But what's the diff?  Scores are all relative,
// so why make the dudes look bad?  Though with negs, the net overall
// colony score average might be around the same.

#define TENT 1 //or do SLOT
#define ENT_FIT_MULT -1.0 
#define ENT_FIT_WIDTH 0.1
#ifdef TENT
	#define ENT_FIT(e,e0) (1.0+(ENT_FIT_MULT*fabs((e)-(e0))))
#else // not TENT, do SLOT
	#define ENT_FIT(e,e0) (fabs((e)-(e0))<ENT_FIT_WIDTH?1.0:0.0)
#endif //TENT

extern struct bug *Bug[];

void set_dir_entropy(struct bug *);
void set_entropy(struct bug *);
void checkentropy(struct colony *);

void set_dir_entropy(struct bug *bug)
{
// This is based on the definition of entropy as the negtative sum over
// the cases of the probability of each case times the log base two
// of that probability.  Use negative because the log of a probability,
// which is less than 1, is less than 1.  See next comment for why
// we don't have to divide each term by LOG2.

	unsigned char i;
	double sum = 0.0, probability;
	unsigned short total = 0;

	for (i=0; i<bug->directions; i++)
		total += bug->dirfreq[i];
	if (!total)
	{
		bug->dir_entropy = 0.0;
		return;
	}
	for (i=0; i<bug->directions; i++)
	{
		probability = (double)(bug->dirfreq[i]) / (double)(total);
		// Stay away from log(0.0).
		if (probability >= 0.0001)
			sum -= probability * log(probability);
	}
	// Note that I give the colony's target entropy as a percent between
	// 0 and 1.  The max actual entropy per bug action is
	// log-base-two of the number of possible outcomes, so the
	// percent entropy is actual entropy value of the sum
	// over the max possible entropy per bug action.  The
	// divisions by LOG2 (to scale to base two logarithm) cancel
	// each other out. 
	
	if (bug->directions <= 1)
		bug->dir_entropy = 0.0;
	else
		bug->dir_entropy = sum / log(bug->directions);
}

#ifdef STATE_ENTROPY

void set_state_entropy(struct bug *bug)
{
	unsigned char i;
	double sum = 0.0, probability;
	unsigned short total;

	for (i=0; i<bug->states; i++)
		total += bug->statefreq[i];
	if (!total)
	{
		bug->state_entropy = 0.0;
		return;
	}
	for (i=0; i<bug->states; i++)
	{
		probability = (double)(bug->statefreq[i]) / (double)(total);
		// Stay away from log(0.0).
		if (probability >= 0.0001)
			sum -= probability * log(probability);
	}
	// Note that I give the colony's target entropy as a percent between
	// 0 and 1.  The max actual entropy per bug action is
	// log-base-two of the number of possible outcomes, so the
	// percent entropy is actual entropy value of the sum
	// over the max possible entropy per bug action.  The
	// divisions by LOG2 (to scale to base two logarithm) cancel
	// each other out. 
	
	if (bug->states <= 1)
		bug->state_entropy = 0.0;
	else
		bug->state_entropy = sum / log(bug->states);
}
#endif //STATE_FREQ

void set_entropy(struct bug *bug)
{
#ifdef STATE_FREQ
	if (bug->motiontype == MOTION_BOID)
	{
		bug->entropy = bug->state_entropy = bug->dir_entropy = 0.0;
		return;
	}
	set_dir_entropy(bug);
	set_state_entropy(bug);
	bug->entropy = (bug->state_entropy + bug->dir_entropy) / 2.0;
#else
	if (bug->motiontype == MOTION_BOID)
	{
		bug->entropy = bug->dir_entropy = 0.0;
		return;
	}
	set_dir_entropy(bug);
	bug->entropy = bug->dir_entropy;
#endif //STATE_FREQ
}


void checkentropy(struct colony *C)
{
	unsigned char i, j;
	struct bug *bug;
	double realtargetentropy;

	if (!C->goodentropyvalue)
		return;
	realtargetentropy =(double)(C->targetentropy) / 100.0;
	// Make it into a number  between 0 and 1.
	for (i=0; i < C->pop; i++)
	{
		bug = Bug[C->rank[i]];
		if (bug->motiontype != MOTION_BOID)
		{
			set_entropy(bug);
			// Reinitialize the info you're done using.
#ifdef STATE_ENTROPY
			for (j=0; j<MAXSTATES; j++)
				bug->statefreq[j] = 0;
#endif //STATE_ENTROPY
			for (j=0; j<MAXDIRS; j++)
				bug->dirfreq[j] = 0;
			// Award points on entropy behavior.  Imagine a tent or slot
			// reward function with peak at target entropy, and
			// with negative that amount reward if you differ by 1 for tent,
			// or zero reward for slot if you differ by ENT_FIT_WIDTH.
			bug->energy += C->goodentropyvalue *
				ENT_FIT(bug->dir_entropy, realtargetentropy);
			// Clamp the energy value.
			if (bug->energy > MAX_ENERGY)
				bug->energy = MAX_ENERGY;
			if (bug->energy < MIN_ENERGY)
				bug->energy = MIN_ENERGY;
		}
	}
}

