// part of the bug.exe build
//#define DEBUG
// #define BAR //For graph.cpp and label.cpp. Doesn't work right.
#define NEWBOID 1
#define CAPTION "BOPPERS!"
// "BOPPERS!     Beta 5. July 8, 1993."
//need to recompile label.cpp for this to take effect.
#define GRAPH_CAPTION "Graph Dialog.  "
#ifndef BUG_H
#define BUG_H 1
#include <windows.h>
#include "bugmenu.h"
//----------CDK things----------
#define CYBER 1 // This switch makes the export functions be
	// given in C++ form instead of in C form.
#include "linalg.hpp"
//---------------------------Compile Flags-------------
//#define FORWARD_VISION 1
//#define REAL_POS 1
//#define MOSS 1
//#define GROWBUGS_STEPS
//#define NEWDNA // switches between state-ordered DNA to case-ordered
//#define NEWDNA_STATE_CORRECT //To make behavior stay same when
	// numnber of states changed in NEWDNA regime.
//#define MONOMEET 1
#define BRIGHTMEET 1
#define STEREO  //in bug.cpp and hotkey.cpp
#define SMOOTH_VISION_ANGLE 1
#define MWC 1
// MWC stands for More Write Color genes, and it means that
// you look up the writecolor for every readcolor, and not just
// for the SELF and BLNAK readcolors.
//#define REGRESS 1 
// Use in bug.cpp to turn off seeding randomizer with time
//-----------------CA Things-------------------------
#define SMALL_CA 1
#define DIBROUND 4 // DIBS must have width and height a multiple
// of this, and if you try not to, they do anyway and you aren't
// accessing the DIB[i,j] you think you are.
#define BUGS_ONLY 0
#define CA_ONLY 1
#define BUGS_AND_CA 2
//-------------------Malloc sizes-------------------------
#define MAXBUGS (unsigned char)27 //18	// max number of bugs
#define MAXCOLONIES (unsigned char)3	// max number of colonies
#ifndef MWC
#define MAXSTATES (unsigned char)128 // number of states a bug can be in 
#else
#define MAXSTATES (unsigned char)100 // number of states a bug can be in 
#endif //MWC
#define MAXDIRS (unsigned char)128 // For use in bug->dircount.  Must
	// be kept current with the status of bugdir.h
#define CASECOUNT 8 
// Cases of the what the bug sees:
// blank, strong self trail, jabber trail, wocky trail, food, wall, poison,
// other.

#define MAXTRAILLENGTH 64000U // U means unsigned
#define NONINDEX 0xFFFFU
// If you go larger, you need trail_loop_z to be shorts not chars.
// If I keep MAXTRAILLENGTH under 64K, then I can use unsigned shorts
// to index it, so the zbuffer needs only 16bits per cell instead of
// 32.  If I go big, need to change NONINDEX.

#define COLONY_MAXTRAILLENGTH (2 * (MAXTRAILLENGTH / 3))
	// Trailrecord_2D is half as big as trailrecord_3D,
	// and each half as long, so they are 1/4 as big,
	// but we have 3 of them, which makes 3/4 as much.
	// To use the same memory, we have 2 * MAXTRAILLENGTH / 3.

#define MAXPAIRS (MAXBUGS*MAXBUGS)

#ifndef MWC
#define DNALENGTH ( (2 * MAXSTATES * CASECOUNT) + (2 * MAXSTATES) )
// Or 2 * MAXSTATES * (CASECOUNT + 1), or (18 * MAXSTATES) with CASECOUNT=8.
// The total memory used is the
//Size of the bugs plus the zbuffer plus the trail.  The DNA
// of each bug is stored twice, once as DNA, once as RNA.
// So MAXCOLONIES * MAXBUGS * (2 * DNALENGTH) for the bugs, plus
// MAXTRAILLENGTH * sizeof (struct livepoint) for the trail, plus
// 2 * BUGLAND_CX * BUGLAND_CY for the zbuffer and the bitmap ( I
// assume that a device dependent bitmap uses one byte per pixel?)
// 3 * 9 * 2 * ( ( 2 * 128 * 7) + ( 2 * 128 ) ) + 64000 * 8 + 2 * 640 * 480
// = 110,592 + 512,000 + 614,400 = 1,236,992
#else
#define DNALENGTH ( (3 * MAXSTATES * CASECOUNT) )
#endif //MWC

// Number of bodies in 2D and 3D, and the number of bodies per 2d colony
#define BODY_COUNT_2D 28
#define BODIES_PER_COLONY 9
#define BODY_COUNT_3D 8
// On menus I put twofold=sized copies of the body icons.  I assume
// for now that the icons range up to 16 by 16 maxinum size.  So
// the size of the bodypatch on a menu is 32 by 32.  This is used
// in score.cpp, gene.cpp.
#define BODYPATCH_X 40 //This are the largest sizes of a bodyicon
#define BODYPATCH_Y 32 //patch which is twofold the size of max
	// body .bmp used. At present the largest is 20 x 16.

#define SCORE_HISTORY_LENGTH 1000 // this is the size of
	// the score history which is kept.  Size is 6 bytes * this.

//--------------------Commdlg things---
#define MAXFILESIZE 1000000
	/* maximum file size (in bytes) that can be loaded */
#define MAXFILENAME 256
	/* maximum length of file pathname      */
#define MAXCUSTFILTER 40
	/* maximum size of custom filter buffer */

//--------------------------Range sizes------------------
#define MUTATIONRATEINCFACTOR 1.1
#define MAXMUTATIONRATE 0.1
#define MINMUTATIONRATE 0.000001
#define FINDRAD  50 // Use for mouse pick disk size.
#define MAXBREEDTIME 0x3fff // Big positive int that "COULD" grow.
#define MINBREEDTIME 32
#define HITBREEDTIME 1000 //score and graph update time if no timed breeds
#define MAXWAIT 512 // hundredths of seconds between cycles.
#define MAX_RIBBON_WIDTH 8
#define MAX_SPEED 16
#define MAX_ENERGY 32000
#define MIN_ENERGY -32000
 //col sum can be this times MAX_BUGS ~ 200,000 for 1000, and 
// ~2,000,000 for 10,000. Intially I used 1,000, then went to 10,000
// If I use +- 32K, the sum can go to like 8 million.  In breed.cpp,
// sum in census() and usum in scale_fitness() can reach this value.
// sum is a long and usum is a double, so this should not be a problem.
//This cannot be a float!
#define INACTIVE_FITNESS (MIN_ENERGY-1)
	// Use this to signal graph.cpp if a colony is turned off.
#define DEATH_LEVELS 5
#define DEATHLEVELLOOKUP {1.0, 1.1, 1.33, 1.66, 2.0}
	// fmultiple is used in DNAbreed in breed.cpp to call scale_fitness
	// the idea is that an average cybug gets one copy and a better one
	// gets fmultiple copies in the next generation. The index into this
	// array is C.deathlevel which is alwasy 1,2,or3, so the 0th entry
	// is dummy.
#define SEX_LEVELS 5
#define SEXLEVELLOOKUP {0.0, 0.25, 0.5, 0.75, 1.0}
#define MUTATION_LEVELS 5
#define MUTATIONLEVELLOOKUP {0.0, 0.0005, 0.001, 0.005, 0.01}
//DNA_length is 16 * states, say 16 states, so its 256 bytes for 16 states.
//This is about 2K bits.  In case where there are 128 states, its like 2K
// bytes, or 16 K bits.  I'd like fairly linear values of bits mutated,
// So I try a lookup of 0.0, 0.0005, 0.001, 0.005, 0.01 to get
// 0, 1, 2, 10, 20 bits in the 16 state case 
// 0, 8, 16, 80, 160 bits in the 128 state case
#define ZAP_LEVELS 4
#define TRANSPOSITION_LEVELS 4

//things  needed before bugdir.h 
#define DIRECTIONTYPES_2D 9
#define DIRECTIONTYPES_3D 3

//--------------------------------Names-------------------
#define NAME0 "Green"
#define NAME1 "Red"
#define NAME2 "Blue"
//--------------------------Code numbers----------------
#define NON_SMEAR_DING 0x7FFF
#define SMEAR_DING 0x8000
// The PAL_INDEX numbers are for looking up colors for the DDB BugLand and
// for using as entries in the DIB buffers.  Actually I only use
// the weak_pal_index and strong_pal_index.
#define BLANK_PAL_INDEX         0
#define FOOD_PAL_INDEX          1
#define POISON_PAL_INDEX        2
#define WEAK_PAL_INDEX         {4,6,8} // fill two arrays in bug.c by
#define STRONG_PAL_INDEX       {3,5,7} // equating to these two arrays.
	// Note that the weak pal indices are even & strongs are odd.
#define WALL_PAL_INDEX          9
#define HEAD_PAL_INDEX          10
#define BUG_PAL_COUNT           11
// The *_CASE numbers are for the bugs to use in looking up their 
// responses.  We use eight cases. These are for readcolor.
//also use as codes for nearcolonycode
#define BLANK_CASE 0
#define SELF_CASE 1
#define JABBER_CASE 2
#define WOCKY_CASE 3
#define FOOD_CASE 4
#define POISON_CASE 5
#define WALL_CASE 6
#define OTHER_CASE 7

#ifdef BRIGHTMEET
#define JABBERMEET 1
#define WOCKYMEET 2
#endif //BRIGHTMEET

// The bugmemory(*) function triggers on an integer input to
// allocate, lock, unlock, or free.
#define ALLOCATE 0
#define LOCK 1
#define UNLOCK 2
#define FREE 3
#define SWAP 4
// For global ecology
#define FREE_FOR_ALL 0
#define PREDATION_LOOP 1
#define PREDATION_CHAIN 2
#define MELLOW 3
#define TWO_PREY 4
#define TWO_PRED 5
#define NO_EAT 6
#define USER 7

// For colony breedtype
#define BREED_ZAP 1
#define BREED_DNASEX 2
#define BREED_MUTATE 4
#define BREED_METAZAP 8
#define BREED_TRANSPOSE 16
#define BREED_RANGE 32 // range of breed values
// Switch bits for use in the metazapcode of zap_enzymes
#define MZ_DIRECTIONS 1
#define MZ_STATES 2
#define MZ_BASESPEED 4
#define MZ_RADIUS 8
#define MZ_LINES 16
#define MZ_MOTION 32
#define MZ_TURMITE 64
//#define MZ_BOID 128
#define METAZAP_RANGE 128 // range of currently valid metazap code values
// For bug motiontype
#define MOTION_TURMITE 0
#define MOTION_BOID 1
#define MOTION_WOLF 2
#define MOTION_BEAVER 3
#define MOTION_DOG 4
#define MOTION_OWL 5
#define MOTION_COUNT 6// Number of kinds of motion, for use in randomize
// For switch constants in BugBodyBlt
#define CURRPOS 0
#define OLDPOS 1
// For bug to use to signal there is no pred or no prey
#define NONCOLONY MAXCOLONIES
// For CAs.
#define CATYPE_COUNT 5
#define CAPALETTE_COUNT 4
// For 3d
#define LINES_COUNT 5
#define IGNORE_MASK 0x80
//getcolor_3d ignores colors with this bit set; this is so
// widening trail doesn't change turing in 3d.

//#define EDGE_MASK               (unsigned char)128
// To mark the edge colors

// To flag things that get randomized, but can be turned off
#define RAN_BODY 1
#define RAN_DIM 2
#define RAN_TURM_BOID 4
#define RAN_CA 8
#define RAN_WALL 16
#define START_RANDOMIZERMASK 31 // All of the above
//for the Colony Breed Method combo boxes and for Lambda
#define NONE 0
#define LOW 1
#define MEDIUM 2
#define HIGH 3
#define VERY_HIGH 4
//Lambda
#define LAMBDA_LOW 0.25
#define LAMBDA_MEDIUM 0.33
#define LAMBDA_HIGH 0.5
#define START_LAMBDA LAMBDA_MEDIUM
#define START_LAMBDALEVEL MEDIUM
#define START_GROWBUGS_STEPS 3
//For CA rule types
// This ordering *Must* be same as in bugmenu.h
#define RUG_TYPE 0
#define LIFE_TYPE 1
#define BRAIN_TYPE 2
#define FADERS_TYPE 3
#define HODGE_TYPE 4
#define DIFFUSE_TYPE 5
#define VOTE_TYPE 6
#define LAMBDA_TYPE 7
#define RANCH_TYPE 8
//-------------------------------Tweak Sizes-------------------
#define HSCROLLSTEP (BugLand_CX / 16)
#define HSCROLLPAGESTEP (BugLand_CX / 4)
#define VSCROLLSTEP (BugLand_CY / 16)
#define VSCROLLPAGESTEP (BugLand_CY / 4)
#define INCREMENT_MULTIPLIER 1.5
#define DECREMENT_MULTIPLIER 0.66
#define START_CA_SHRINK ( (CALand_CX>200)?(1.0 / sqrt(2.0)):(1.0/2.0) )
//#define START_CA_SHRINK (1.0 / sqrt(2.0)
#define SPEED_INC 4
#define PULSETICK_INC 2
#define NON_WRAP_OFFSET 10 // make room for trails not to hit walls.
#define START_MESH_SIZE 24 // >= 1, this specifies the parity
	// of the start cells.  LIke 1 is any, 2 is only even,
	// n is multiples of n. 60 is 3 * 4 * 5.
#define START_WALLBOUNCEFLAG  1 // Turn 180 when hit a wall.
#define START_MINFOODSUPPLY   350L // L means long
#define START_MINPOISONSUPPLY 350L 
//-------------------Constants & Macros-------------------
#define RANDOMCOLOR RGB(Random(256), Random(256), Random(256))
#define EDITCOLONY (editcolony + 1) // To avoid showing 0 number in menus.
#define EDITBUG (editbug + 1) // To avoid showing 0 number in menus.
#define BUGLANDINDEX(x,y) ( ( (long)BugLand_CX * (long)(y) ) + (long)(x) )
	// I need long indices because BugLand is bigger than 64K.
//#define MOD(x,y) ((y)>1)?(((unsigned char)((x)%(y))>=y)?((y)-1):(unsigned //char)((x)%(y))):0
#define MOD(x,y) (x)%(y)
// This avoids some of the pitfalls of % on unsigned chars by making sure
// that x%1 is 0, x%y is unsigned char, and x%y is not greater than y.
#define CHOOSE(x,n) (unsigned char)(((short)(n)*(short)(x))/(short)256)
	// This takes an unsigned byte x and uses it to choose among
	// the numbers 0 through n-1.
#define REAL(x,n) ( (Real)(n) * ( (Real)(x)/256.0 ) )
	// This takes an unsigned byte x and uses it to make a Real 
	// between 0.0 and n.
#define DREAL(x, y, n) ((Real)(n)*((256.0*(Real)(x)+(Real)(y))/65535.0))
	// This takes an two unsigned bytes x y and uses them to make a Real
	// between 0.0 and n.  Note 65535.0 is (Real)(unsigned short)0xFFFF.
#define MAX(x,y) (((x)>=(y))?(x):(y))
#define MIN(x,y) (((x)<=(y))?(x):(y))
#define ABS(x) (((x)>=0)?(x):-(x))
#define XWRAP(x) (((x)>=0)?(((x)>BugLand_MAXX)?((x)-BugLand_CX):(x)):(BugLand_CX+(x)))
#define YWRAP(y) (((y)>=0)?(((y)>BugLand_MAXY)?((y)-BugLand_CY):(y)):(BugLand_CY+(y)))
#define ZWRAP(z) (((z)>=0)?(((z)>BugLand_MAXZ)?((z)-BugLand_CZ):(z)):(BugLand_CZ+(z)))
#define MAX_TRANSPOSON_RATIO  8
	// so a transposon should be at most 1/8 the length of the DNA
#define MIN_TRANSPOSON_LENGTH  4
#define MIN_LENSEDGE 140
#define LENS_STEP 60
#define START_LENSEDGE (MIN_LENSEDGE + LENS_STEP)
//--------------------------------Start up Values-----------
// System: Cursor, Timesharing & Palette
#define START_CUR CUR_PICK
#define CARRYSTEP_Z 20 // Step that carry cursor moves
	// bug in 3d by left click in right click out.
#define START_CAWAITALARM 16
#define START_BLANKCOLOR RGB(0,0,0)
#define START_HEADCOLOR   RGB(255,255,255)
#define START_WALLCOLOR   RGB(128,128,128  )
#define START_FOODCOLOR   RGB(120, 120, 0 )
#define START_POISONCOLOR RGB(120, 0, 120)
#define START_TRAILCOLOR0 RGB(0,255,0)  // The green plants
#define START_TRAILCOLOR1 RGB(255,0,0)  // The red cows
#define START_TRAILCOLOR2 RGB(0,0,255)  // The blue saucers
#define START_FAINTTRAILCOLOR0 RGB(0,128,0)
#define START_FAINTTRAILCOLOR1 RGB(128,0,0)
#define START_FAINTTRAILCOLOR2 RGB(0,0,128)
#ifdef MONOMEET
#define START_MEETCOLOR RGB(255,255,0)
#endif //MONOMEET
#ifdef BRIGHTMEET
//MEETCOLORij is color of colony i with colony j, bright.
//recall that the colonies are green, red, blue, rather than R, G, B
#define START_MEETCOLOR01 RGB(255,255,0)
#define START_MEETCOLOR02 RGB(0,255,255)
#define START_MEETCOLOR12 RGB(255,0,255)
#endif //BRIGHTMEET
#ifdef STEREO
#define START_REDCOLOR  RGB(255,0,0)
#define START_BLUECOLOR  RGB(0,0,255)
	// Assume your screen is STEREO_SCREEN_WIDTH inches across so are
	// BugLand_CX/STEREO_SCREEN_WIDTH pixels per inch.
#define STEREO_SCREEN_WIDTH 11.0
	// Next is half the distance between eyes.
	// 1.5" is what I measure, but this works better.
#define STEREO_EYE_DIST 0.5
	// Next is distance of the center point between your eyes
	// from the screen. I suggest two to three feet, so about 30.0
	// is correct, but this works better.
#define STEREO_NOSE_DIST 15.0
#define STEREO_ADJUST 1.2
//  These are used as follows:
//	EyePix = ((float)BugLand_CX / STEREO_SCREEN_WIDTH) * STEREO_EYE_DIST;
//	NosePix = ((float)BugLand_CX / STEREO_SCREEN_WIDTH)*STEREO_NOSE_DIST;
// Get the next formula by putting a space of depth BugLand_CZ in front
// of the screen.  Say Nose is distance to front of this.  You draw a
// line from each eye to the virtual point that is z behind the 
// space in front of the screen, and continue it to the screen.
// Reverse parallax puts right eye seing blue to the left and
// left eye seing red to the right.
// In stereo, shift red image stereoshift to right, shift blue image
// stereoshift to left.



#endif //STEREO

//World
#define START_CAFLAG          0
#define START_TRAILLENGTH     (MAXTRAILLENGTH / 2)
#define START_COLONY_TRAILLENGTH     (COLONY_MAXTRAILLENGTH / 5)
#define START_ERASETRAILFLAG  1
#define START_THREE_D_FLAG    0
#define START_BUGSPERCOLONY   6
#define START_COLONYCOUNT     MAXCOLONIES
#define START_ZWRAPFLAG       1
#define START_WRAPFLAG        1 //Off/On is 0/1.
#define START_RECRUITFLAG        0
#define START_ADJUSTMUTATIONRATEFLAG 1
#define START_FOODGLOBFLAG    0
#define START_POISONGLOBFLAG  0

// Ecology
#define START_ECOLOGY         FREE_FOR_ALL
#define START_BUGEATVALUE {{0,1,1},{1,0,1},{1,1,0}}
// Match with start_ecology

// Colony Stuff
#define START_BREEDTIME       800
#define START_DEATHLEVEL HIGH // Means VERY HIGH, deathlevel gets one added.
#define START_SEXLEVEL LOW
#define START_MUTATIONLEVEL MEDIUM
#define START_ZAPLEVEL MEDIUM
#define START_TRANSPOSITIONLEVEL NONE
#define START_MUTATIONRATE   .0001 // Make it match START_MUTATIONLEVEL
	// Mutation probability per bit in DNAmutate.  DNA_length is
	// about 2K bytes or 16K bits, so .001 is change 10 or 20 bits
	// in each DNA string.
#define START_EXOGAMYFLAG 0
#define START_ENDOGAMYFLAG 0
#define START_RECRUITPREYFLAG 0
#define START_METAZAPCODE (MZ_TURMITE)
// leave out MZ_MOTIONTYPE and MZ_RADIUS for now.
#define START_FOODVALUE       3
#define START_POISONVALUE      -2
#define START_WALLVALUE       -1
#define START_BLANKVALUE       0
#define START_OTHERVALUE       0
#define START_MINTOTALMOTION  100 
#define START_LOWMOTIONVALUE    -20
#define START_HITRADIUS         1
#define MAX_HITRADIUS         10
#define START_HITPREYVALUE 100
#define START_TARGETENTROPY 20
#define START_GOODENTROPYVALUE 0

// Bug Stuff
#define START_SPEED           1
#define START_2DLINEFLAG      0
#define START_BUGBODYFLAG     0
#define START_MOTIONTYPE      0
#define START_3DLINEFLAG      2
#define START_RADIUS          0
#define START_SHAPE           SHAPE_DOT
#define START_DIRECTIONTYPE   3
#define START_MOSSFLAG   0
#define START_STATECOUNT      (MAXSTATES<64)?MAXSTATES:64
	//min(64,MAXSTATES)

// Bug Flocking Stuff
#define START_WATCH_TWO 1
//#define START_NEAR_PREY 50.0
//#define START_NEAR_PRED 200.0
#define START_NEAR_WALL 40
#define MIN_NEAR_WALL 30
#define MAX_NEAR_WALL 60
#define MAX_WEIGHT 0.5 //Largest value that one of the other
	// weight can have.  Should be well less than the virtual
	// persistweight of 1.0 so that trails aren't jagged.
#define START_COPYWEIGHT 0.4
#define START_CENTERWEIGHT 0.2
#define START_ATTACKWEIGHT 0.5
#define START_FLEEWEIGHT 0.4
#define MIN_VEERWEIGHT  0.4
#define START_VEERWEIGHT 0.5
#define MAX_VEERWEIGHT 0.8

#define START_VISIONANGLECOSINE cos((M_PI) * 0.9) // Angles range from 0 to M_PI
// If the angle is 0.9 PI or above, you get the "fasces" pattern of
// a pursuer helically winding around the trail of a prey.  Below
// 0.5 you don't get this pattern.
#define MIN_VISIONANGLE (M_PI/180)
#define MINSPEED 3 // minimum speed multiplier for boids.
	// 3 seems like a lot, and 2 isn't bad, but 3 gives more flash.
	// On the other hand a turmite only gets 3 when windrose
	// is 24.  But a boid should be faster than turmite.
#define START_MAXSPEED (MINSPEED + 3)
#define MAX_MAXSPEED (MINSPEED + 5)
#define START_CRUISEDISTANCE 30 // Preferred boid separation in pixels
#define MIN_CRUISEDISTANCE 10 // about the width of a character on screen
#define MAX_CRUISEDISTANCE 80

// Flockers try to achieve Separation = CRUISEDISTANCE from own colony
// members.  Low value helps helix
#define MIN_ACCELERATION 1.01
#define START_ACCELERATION 1.1
#define MAX_ACCELERATION_DIFF 0.3 // Max amount over MIN_ACCELERATION
// Automatics
#define START_DIMENSION (START_THREE_D_FLAG)?3:2
#define START_DIRECTIONTYPES START_THREE_D_FLAG?DIRECTIONTYPES_3D:DIRECTIONTYPES_2D

//----------------------Data Structures-----------------
struct trailrecord_3D //8 bytes each
{
	unsigned short loy_x, hiy_z, behindindex;
	unsigned char smearflag, colorindex;
};
//use smearflag to remember if a body is on.
// Store hiy_z loy_x 32 bits as 5 bits y, 11 bits z, 5 bits y, 11 bits x.
#define LMK 0x07FF // low mask eleven bits
#define HMK ~0x07FF // high mask five bits
#define MMK 0x03E0 // mid mask five bits
#define TR_SET_XYZ(t,x,y,z) (t).loy_x=(x)|((y)<<11);(t).hiy_z=(z)|(((y)&MMK)<<6)
#define TR_GET_X(t) ((t).loy_x & LMK)
#define TR_GET_Y(t) ((((t).loy_x & HMK)>>11)|(((t).hiy_z & HMK)>>6))
#define TR_GET_Z(t) ((t).hiy_z & LMK)
#define TR_GET_BEHIND(t) ((long)((t).behindindex)|((long)((t).hibehindindex)<<16))

struct trailrecord_2D //4 bytes each
{
	unsigned short x, y;
};

struct bug
{
// BEGIN Load/save params
	unsigned char bugbodyflag; // Body Icon
	unsigned char radius; // Trail Nodes
	unsigned char shape; // REMOVE 
	unsigned char mossflag; // REMOVE 
	unsigned char lineflag; // Trail Lines
	unsigned char basespeed; // Speed
	unsigned char motiontype; // Turmite/Boid
	unsigned char directiontype; // Turmite Windrose
	unsigned char states; //Turmite IQ
//END Load/save params
// Auxilliary params
// Bopper ID params
	unsigned char bugid, bodyid, colonyid, jabberid, wockyid, bugnumid;
// Bopper current situation params
	unsigned char dir;
	unsigned char state;
	unsigned char boidstate;
	COLORREF getcolor;
	unsigned char readcolorcode;
	unsigned char nearcolonycode; // For beaver usage.  Can be
		//NEAR_SELF_CASE, etc.
	unsigned char writecolorindex;
	unsigned char meetflag;
	short x, y, z;
	long energy;
		// I will clamp energy to be between MAX and MIN_ENERGY
		// of +- 32K, but to prevent it from possibly wrapping
		// before a clamp, I need to use a long rather than a short.
		// startx, starty keep track of position at beginning of
		// breedcycle so I can reward guys who move a lot
// Bopper situation memory params
	unsigned char olddir; //use olddir to erase turning icons
	short oldx, oldy, oldz, oldoldx, oldoldy, oldoldz;
	short nonwrapx, nonwrapy, nonwrapz;
#ifdef REAL_POS
	Real real_dx, real_dy, real_dz;
	short int_dx, int_dy, int_dz;
#endif //REAL_POS
	long oldenergy;
	unsigned char oldmeetflag;
	unsigned char oldwritecolorindex;
	unsigned char oldbodyid, body_on;
		// body-on tells if there a body of me onscreen to erase
		// oldbodyid may be equal to the editbug bodyid.
	COLORREF oldcolor;
#ifdef BRIGHTMEET
	COLORREF jabbermeet, wockymeet;
#endif //BRIGHTMEET
// Breeding params
	double scaled_fitness; // This is a scaled quantity based on energy
		// and the rest of the colony during breeding.  It can be
		// as large as the highest DEATHLEVELLOOKUP times MAX_ENERGY -
		// MIN_ENERGY.  If I use +-32 K for this a max fmultiple of
		// 2.5, this can be about 200K.  No problem for a double.
		// see note below on colony scaled_fitness, cannot be a float.
	Real bits_to_mutate; // Builds up slowly, gets reduced by 1.0s.
// Low motion tracking
	short startx, starty, startz;
	unsigned char lowmotionflag;
//Entropy tracking
	unsigned short FAR *dirfreq; //[MAXDIRS]; // Divide by breedtime to 
		// get probabilities for computing entropies.
	float dir_entropy, entropy;
// Boid current params.
	CyVector3 tan;
	CyVector3 tocentroid;
	CyVector3 *to;  // length MAXBUGS. This can't be FAR or C++ complains.
		// So LocalAlloc this one.
	Real realspeed;
	struct bug *nearest_bug, *second_nearest_bug;
	Real nearest_distance, second_nearest_distance;
// Boid memory params.
	CyVector3 oldtan;
	unsigned char metric_flag; // If you need to know distance info.
	Real FAR *metric; // length MAXBUGS
	Real FAR *metricsquared; // length MAXBUGS
// Turmite RNA params.
	unsigned char directions;
	short *bugmovex, *bugmovey, *bugmovez;
#ifndef MWC
	unsigned char FAR *writecolorgene0;
		// [MAXSTATES]. use on blank and on own faint trail.
		// 0 faint, 1 my color */
	unsigned char FAR *writecolorgene1;
		//[MAXSTATES]. use only on own dark trail.  0 my faint trail,
		// 1 my dark trail
#else
	unsigned char FAR *writecolorgene;
#endif //MWC
	unsigned char FAR *dirgene; /* [InputCode(MAXSTATES,CASECOUNT)]; */
		// This is always the amount to turn.  To make the bugs
		// wiggle, I avoid having zeroes here.
	unsigned char FAR *stategene; /* [InputCode(MAXSTATES,CASECOUNT)]; */
		// These wbug to be twofold arrays, but its more efficent
		// to keep them as single arrays, especially since I keep
		// locking and unlocking them.
// Boid RNA params.
	unsigned char watch_two;
	unsigned short near_wall;
	unsigned short cruisedistance;
	unsigned char maxspeed;
	Real visionanglecosine;
	Real copyweight;
	Real centerweight;
	Real attackweight;
	Real fleeweight;
	Real veerweight;
	Real acceleration;
#ifdef NEWBOID
	unsigned char FAR *nearpreygene; //beaver and dog use this
	unsigned short FAR *nearpredgene; //beaver and dog use this
#endif //NEWBOID
// The DNA
	int DNA_length; // 2 * MAXSTATES  * (CASECOUNT + 1)
		// 2 for newstate and turn ,+ 1 for the writegene
	int boid_DNA_length; // BOIDDNA + MAXSTATES * (4 + 2)
		// BOIDDNA for the fixed genes, 
		// 4 for the four higher boid cases self, jabber, wocky, other
		// and 2 for the nearpreygene and nearpredgene arrays.
	unsigned char FAR *DNA; // The bitstring code used to make the RNA
// Function pointers
	void near (*move) ( struct bug *);
	void near (*wrap) ( struct bug *);
	void near (*eat) (struct bug *);
};

struct colony // about ninety bytes
{
// BEGIN Load/save params for struct colony.
// Membership parameters
	unsigned char pop; // The colony's population count.
	unsigned char rank[MAXBUGS]; // Lists index numbers of the
		// member bug pointers that live in the master Bug array.
		// This list is in descending order of energy.
// The Timed Breeding parameters
	unsigned short breedtime;
	unsigned char breedcode;	// REMOVE breedcode from final version
	unsigned char deathlevel; //ADD to loadsave for final version.
	unsigned char sexlevel; //ADD to loadsave for final version.
	unsigned char mutationlevel; //ADD to loadsave for final version.
	double mutationrate; //REMOVE mutationrate from final version
	unsigned char zaplevel; //ADD to loadsave for final version.
	unsigned char transpositionlevel; //ADD to loadsave for final version.
	unsigned short metazapcode;
		// metazapcode's flag bits choose which Things to Zap.
// The Hit Breeding parameters
	short hitradius; // boid within this distance scores a hit
	unsigned char exogamyflag, endogamyflag, recruitpreyflag;
		// flags say if these Hit Breeding methods are on.
		// ADD to loadsave for final version.
// Ecology parameters
	short foodvalue;
	short poisonvalue;
	short wallvalue;
	short hitpreyvalue;
	short othervalue;
// Additional Fitness Function parameters
	short lowmotionvalue;
	short mintotalmotion;
	// If you never get farther than mintototalmotoin from your start you
	// get lowmotionvalue added in to your energy at breedtime.
	short targetentropy;
	short goodentropyvalue;
//END Load/save params for struct colony.
//BEGIN Auxilliary params for struct colony.
// Auxiliary Timed Breeding parameters 
	unsigned char breedflag; // 0 if breedtime>MAX_BREEDTIME, else 0
	short fitness, oldfitness;	// average energy of colony bugs
	double total_scaled_fitness; // sum of scaled_fitness of bugs
	// According to the comments on scaled_fitness above, this could
	// be as large as MAXBUGS times that, or about 6 Meg.  A double
	// has 15 digits of precision.  Writing 6 Meg uses up 7 digits, which
	// seems to leave nine digits to the right of the decimal,
	// which ought to be ample.  If I get paranoid I could use long
	// double, which has 19 digits of precision.  Float only has
	// 7, which wouldn't do at all!
//Auxilliary Ecology parameters
	short selfvalue; // = bugeatvalue [colonyindex][colonyindex]
	short jabbervalue; // = bugeatvalue [colonyindex][colonyindex - 1]
	short wockyvalue; // = bugeatvalue [colonyindex][colonyindex + 1]
//Auxilliary Function pointer
	void (*breed) (struct colony  *);
//END Auxilliary params for struct colony.
};

struct score_record
{
	short col0, col1, col2;
};
#endif //BUG_H
