/*********************************************************************
*  (C) Copyright 1992 by Rudy Rucker for Autodesk, Inc.              *
*  Licensed by Autodesk for use by Rudy Rucker.                      *
**********************************************************************
* Material added after October 19, 1992 is copyright (C) by Rudy     *
* Rucker alone.                                                      *
**********************************************************************/

//---------------------------Bugs!-------------
//	Bug.cpp
//	This Windows program shows Turing machine bugs and flocking.
// Need to cut out some code in case it gets over 64K.
// Actually if it gets over 0xD6AD  , about 55K, the optimization
// won't work.

//-----------------Compile Switches---------

#define TURMITE_TAN 1
#define TIMER 1
#define MESH_WRAP 1
#define LEAKER 1
//#define NEWFILE 1
//#define LOADBITMAP 1
//#define BODY_JAM 1

//---Includes-----------------------------------

#include "bug.h"
#include "bugmenu.h"
#include <windows.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#pragma hdrstop
#include "random.h"
#include "score.h"
#include "help.h"
#include "sound.h"
#include "graph.h"
#include "commdlg.hpp"

//------------------- Motion params

//----Own data to Load/Save configuration----------------
	unsigned char colonycount = START_COLONYCOUNT;
	unsigned char bugspercolony = START_BUGSPERCOLONY;
	unsigned char wrapflag = START_WRAPFLAG;
	unsigned char startlineflag = 0; // used in trailline, bugSetPixel_?D.
	unsigned char Zwrapflag = START_ZWRAPFLAG;
	unsigned char ecology = START_ECOLOGY;
	short bugeatvalue[MAXCOLONIES][MAXCOLONIES] = START_BUGEATVALUE;
	unsigned char hitflag = 0;
	unsigned char recruitflag = 0;
	unsigned char hittable[MAXBUGS][MAXBUGS];
	unsigned int randomizermask = START_RANDOMIZERMASK; 
		//The RAN_? bits pick out flags for things to include in
		// randomization.  If a bit is set to 0, then you don't
		// randomize that bit, and you check that EX_? label on
		// the Randomize Exclude popup.  STart with nothing excluded.
	unsigned char three_d_flag = START_THREE_D_FLAG;
	unsigned char mazeflag = 0;
	unsigned char foodglobflag = START_FOODGLOBFLAG;
	unsigned char poisonglobflag = START_POISONGLOBFLAG;
	unsigned char globalmetricflag;
		// use globalmetricflag to signal if anyone is using the
		// metric.

	unsigned short seed = 1946; // Happens to be the default value
		// in the randomizer.  If I call Randomize(), then
		// this gets set to the start time.

	unsigned short day[MAXCOLONIES] = {0,0,0};
		// If MAXCOLONIES is changed, this initialization must change.
	unsigned char did_breed = 0; //if a colony breeds or a hitbreed comes.

	short score_history_index = 0;
	short score_history_rollover = 0;
	struct score_record FAR *score_history;

	unsigned short mazex, mazey, mazer;
	unsigned short foodglobx, foodgloby, foodglobxr, foodglobyr;
	unsigned short poisonglobx, poisongloby, poisonglobxr, poisonglobyr;

	short mesh_size = START_MESH_SIZE;
//------Own Tweak and Support Data--------------------
#ifdef DEBUG
	unsigned char error = 0;
#endif // DEBUG

// Support params

	HANDLE hInst;

	short Pair[MAXSTATES][CASECOUNT];
		// Pair[i][j] is i*CASECOUNT + j.
		// Use this to make a double array be flat.

	short Screen_CX, Screen_CY, BugLand_CX, BugLand_CY,
		BugLand_MAXX, BugLand_MAXY, BugLand_MIDX, BugLand_MIDY;
	short BugLand_CZ, BugLand_MAXZ, BugLand_MIDZ;
#ifdef STEREO
	unsigned char stereoflag = 0;
	short stereoshift; // This is used by ipixel_3D, edgeipixel_3D,
		// and blankipixel_3D.  To avoid slowing these calls down,
		// I put the data up here instead of inside those functions.
	float EyePix, NosePix;
	// These are half the distances between eyes in pixels and the
	// distance of your nose (actually eyes) from the screen in pixels.
	float LeftEye, RightEye;

#endif //STEREO

	long BugLand_SIZEOF;

	unsigned char background_color; //0 is black, 1 is white.
	unsigned char weak_pal_index[MAXCOLONIES] = WEAK_PAL_INDEX;
	unsigned char strong_pal_index[MAXCOLONIES] = STRONG_PAL_INDEX;
	COLORREF blankcolor, wallcolor, foodcolor, poisoncolor, headcolor;
#ifdef MONOMEET
	COLORREF meetcolor;
#endif //MONOMEET
#ifdef BRIGHTMEET
	COLORREF meetcolor01, meetcolor02, meetcolor12;
#endif //BRIGHTMEET
#ifdef STEREO
	COLORREF redcolor, bluecolor;
	unsigned char redindex, blueindex;
#endif //STEREO
	COLORREF bugpalette[16];
	// We store first the faint trail colors, then the strong trail
	// colors, and then the blank, food, poison, wall, and bug colors.
	// BUG_PAL_COUNT of these matter, but we want 16 colors for other
	// things like CAs and the genemaps.

	unsigned char soundflag = 0; //0 is no sound, and it can
		// be masked with sound.h flags for *.wav and PC speaker.

	unsigned short note_smearbody_flag = 0; // Use this to ding the
	// trailpacks in ipixel_?D in the high bit of the y coord,
	// so that you know to erase a body at this spot, in case
	// you are doing smear trail.  It's always either 0 or
	// SMEAR_DING.  This can't be a char, as SMEAR_DING is 16 bits.

	unsigned char erasetrailflag = 1;
	unsigned short traillength=START_TRAILLENGTH;
	unsigned short trailindex = 0;
	unsigned char trailfull = 0;
	struct trailrecord_3D huge *trail_loop; // 8 * 64K = 512K
	unsigned short huge *zbuffer;


	unsigned char colony_erasetrailflag[MAXCOLONIES] = {1,1,1};
	unsigned short colony_traillength[MAXCOLONIES]=
		{START_COLONY_TRAILLENGTH,START_COLONY_TRAILLENGTH,
			START_COLONY_TRAILLENGTH};
	unsigned short colony_trailindex[MAXCOLONIES] = {0,0,0};
	unsigned char colony_trailfull[MAXCOLONIES] = {0,0,0};
	struct trailrecord_2D huge *colony_trail_loop[MAXCOLONIES];
		// 4 * 32K = 128K each
	

	struct bug *Bug[MAXBUGS];
	unsigned char bugnum[MAXBUGS];
	unsigned char startcolpop[MAXCOLONIES] =
	{START_BUGSPERCOLONY,START_BUGSPERCOLONY,START_BUGSPERCOLONY};
	unsigned char livebugcount = 0;
	// These are for use by the CUR_ISOLATE code.
	unsigned char oldlivebugcount, isolatedflag = 0;
	struct bug *pickbug;

	HWND hwnd; // The master window

	HWND hDlgScore=0,hDlgEcology=0,hDlgShape=0,hDlgColony=0,
		hDlgGene=0, hDlgSound=0, hDlgGraph = 0; // Modeless dialog boxes.
	FARPROC lpitProcScore, lpitProcEcology,lpitProcShape,lpitProcColony,
		lpitProcGene, lpitProcSound, lpitProcGraph;

	HBITMAP hBitmapBugLand;
	HDC hdcBugLand;
	HBITMAP hBitmapBugLandOld;

	HBITMAP hBitmapBugBody_2D[BODY_COUNT_2D];
	HDC hdcBugBody_2D[BODY_COUNT_2D];
	HBITMAP hBitmapBodyOld_2D[BODY_COUNT_2D];
	short BugBody_2D_CX[BODY_COUNT_2D];
	short BugBody_2D_CY[BODY_COUNT_2D];
	short MAX_BugBody_2D_CX = 0,  MAX_BugBody_2D_CY = 0;

	HBITMAP hBitmapBugBody_3D[BODY_COUNT_3D];
	HDC hdcBugBody_3D[BODY_COUNT_3D];
	HBITMAP hBitmapBodyOld_3D[BODY_COUNT_3D];
	short BugBody_3D_CX[BODY_COUNT_3D];
	short BugBody_3D_CY[BODY_COUNT_3D];
	short MAX_BugBody_3D_CX = 0,  MAX_BugBody_3D_CY = 0;

	short cxClient, cyClient; // Track size of client window

	short cursormode = START_CUR;
	POINT cursorpos;
	RECT windowrect, lensrect, clientrect;
	short bugscreen_offset_y_top, bugscreen_offset_y_bottom,
		bugscreen_offset_x_right, bugscreen_offset_x_left;
	unsigned char carryflag;
	short carryz;

	short lens_dx = START_LENSEDGE, lens_dy = START_LENSEDGE;
	short old_lens_dx, old_lens_dy;
	short stretchfactor = 4; // ONLY USE POWERS OF TWO HERE, >= 2.
	unsigned char lensflag = 0, fullscreenlensflag = 0;
	short lensx = 0, lensy = 0;
	short prelensx, prelensy;

	short WinOrgX = 0, WinOrgY = 0;
	short bugWinOrgX = 0, bugWinOrgY = 0;
	short WinOrgZ = 0;
	// The coords of of window's left upper corner into BugLand.
	// Always between 0 and BugLand_MAXX, BugLand_MAXY, BugLand_MAXZ
	short wrapminx = 0, wrapminy = 0, wrapmaxx, wrapmaxy;
	short wrapminz = 0, wrapmaxz;
		// Set last three to BugLand_C? vals in create.
	// Use these for wrap.  Idea is to leave one pixel extra
	// to show a wall in the Closed world case.
	unsigned char editmode=2, editcolonyid=0, editbugid=0;
		// editmode 0 is all bugs, 1 is the bugs in editcolony,
		// 2 is the editbug in the editcolony.
	unsigned char oldfirstbugid;
	struct colony Colony[MAXCOLONIES];
	// Static this as it's quite small, like 3 times ninety bytes.


// World Tweak params
	unsigned char wallbounceflag = START_WALLBOUNCEFLAG;
//	unsigned char adjustmutationrateflag = START_ADJUSTMUTATIONRATEFLAG;
	unsigned char worldclearflag = 0;

//Furniture support params and tweaks
	RECT foodrect;
	long int foodsupply = 0L; // L means long
	long int minfoodsupply = START_MINFOODSUPPLY;
	//  if foodglobflag is on and foodsupply < minfoodsupply
	// you draw a new foodglob.  Drawfoodglob adds to foodsupply the
	// number of food pixels inside the foodglob.
	RECT poisonrect;
	long int poisonsupply = 0L; // L means long
	long int minpoisonsupply = START_MINPOISONSUPPLY;
	//  if poisonglobflag is on and poisonsupply < minpoisonsupply 
	// you make & drawpoisonglob.  Drawpoisonglob adds to poisonsupply the
	// number of poison pixels inside the poisonglob.

//Scheduling
	unsigned char CAwaitcounter = 0;
	unsigned char CAwaitalarm = 3;
#ifdef GROWBUGS_STEPS
	unsigned char GrowBugs_steps = START_GROWBUGS_STEPS;
#endif //GROWBUGS_STEPS
#ifdef TIMER
	WORD waitmsecs[2] = {300, 100};
	unsigned char timerflag = 0, stepflag = 0;
#endif //TIMER

// Keyboard
	unsigned char controlkeyflag = 0;

//----------------Extern Data--------
	
	extern COLORREF CApalette[256];
	extern unsigned char CAbltflag;
	extern unsigned char CAstretchflag;
	extern unsigned char CAwrapflag;
	extern unsigned char CAPutMask;
	extern unsigned char CAparity;
#ifdef LEAKER
	unsigned char CAloaded = 0;
#endif //LEAKER
	unsigned char oldCAflag = 2;
	extern unsigned char CAflag;
		// 0 is bugs and 1 is CAs,2 is both
	extern unsigned char CAwaitcounter;
	extern unsigned char CAwaitalarm;
	extern unsigned char slice;
	extern unsigned short CA_Z;

	extern HBITMAP hBitmapCALand;
	extern HDC hdcCALand;
	extern HBITMAP hBitmapCALandOld;
	extern LPBITMAPINFO lpbmiCALand; // need in here for ALLOC call.


	extern short CALand_CX, CALand_MAXX, CALand_CY, CALand_MAXY;
#ifndef SMALL_CA
	extern short MAX_CA_CX, MAX_CA_CY;
	extern long MAX_CALand_SIZEOF;
	extern long CALand_SIZEOF;
	extern unsigned char huge *CAbuffer0;
	extern unsigned char huge *CAbuffer1;
	extern unsigned char huge *Read_buffer;
	extern unsigned char huge *Write_buffer;
#else // SMALL_CA
	extern unsigned short CALand_SIZEOF;
	extern unsigned short MAX_CALand_SIZEOF;
	extern unsigned char FAR *CAbuffer0;
	extern unsigned char FAR *CAbuffer1;
	extern unsigned char FAR *Read_buffer;
	extern unsigned char FAR *Write_buffer;
#endif // SMALL_CA

//-----Function Declarations--------------------------------------
#ifdef CYBER // extern "C" turns off name-mangling, so the
//name matches bug.def EXPORT listing
extern "C" long FAR PASCAL WndProc( HWND, unsigned int , unsigned int, LONG);
#else
long FAR PASCAL WndProc( HWND, WORD, WORD, LONG);
#endif // CYBER

void near GrowBugs(HWND);

void near bugmemory(HWND, unsigned char);
	// The int is "memoryfunction": ALLOCATE, LOCK, UNLOCK, OR FREE.
	// Sends a message box and a WM_DESTROY to hwnd if failure.


void near move( struct bug *);
void near turmite3D( struct bug *);
void near turmite2D( struct bug *);
void near boid3D( struct bug *);
void near boid2D( struct bug *);
void near beaver3D( struct bug *);
void near beaver2D( struct bug *);
void near dog2D( struct bug *);
void near dog3D( struct bug *);
void near owl2D( struct bug *);
void near owl3D( struct bug *);
void near wolf2D( struct bug *);
void near wolf3D( struct bug *);
void near flock( struct bug *, struct bug *);
void near carry3D( struct bug *);
void near carry2D( struct bug *);

void near eat(struct bug *);
void near eatapixel_2D(struct bug *);
void near eatapixel_3D(struct bug *);

void near wrap2D(struct bug *bug);
void near wrap3D(struct bug *bug);

void near BugLandClear(void);
void near BugLandBlt(HDC);
void near BugBodyBlt(HDC, struct bug *, unsigned char);
void near BugBodyErase_near(HDC, short, short);

void cornerbugs(HWND); //Uses BugBodyBlt
void randomizepositions(HWND); //Uses BugBodyBlt

void near putpixel(HDC,short,short,COLORREF);
void near eatgetcolor(struct bug *);
void near justeatgetcolor(struct bug *);

void near trailline(HDC, struct bug*);
void near trailpixel(HDC, struct bug*);
void near headpixel(HDC , struct bug *);
void near trailsquare(HDC, struct bug*);
void near ipixel_2D(HDC, short, short, COLORREF, struct bug*);
void near bugSetPixel_2D(HDC, short, short, COLORREF, struct bug*);
void near bresen_2D(HDC, short, short, short, short, COLORREF, struct bug*,
	void near (*pixel)(HDC, short, short, COLORREF, struct bug*) );
void near isquare_2D(HDC, struct bug*);
void near setgetcolor_3D(short, short, short, struct bug*);
void near ipixel_3D(HDC, short, short, short, COLORREF, struct bug*);
void near edgeipixel_3D(HDC, short, short, short, COLORREF, unsigned char);
void near blankipixel_3D(HDC, short, short, short);
#ifdef STEREO
void near one_ipixel_3D(HDC, short, short, short, COLORREF, struct bug*);
void near one_edgeipixel_3D(HDC, short, short, short, COLORREF, unsigned char);
void near one_blankipixel_3D(HDC, short, short, short);
#endif //STEREO
void near bugSetPixel_3D(HDC, short, short, short, COLORREF, struct bug*);
void near edgeSetPixel_3D(HDC, short, short, short, COLORREF,
	struct bug*, char);
void near bresen_3D(HDC, short, short, short, short, short, short,
	COLORREF, struct bug*,
	void near (*pixel)(HDC, short, short, short, COLORREF, struct bug*) );
void near thick_bresen_3D(HDC, short, short, short, short, short, short,
	COLORREF, COLORREF, struct bug*,
	void near (*cpixel)(HDC, short, short, short, COLORREF, struct bug*),
	void near (*epixel)(HDC, short, short, short, COLORREF, struct bug*,
		char) );
void near isquare_3D(HDC, struct bug*);
void near drawtrailshape(HDC, struct bug *);

void near CAput(short,short,unsigned char);
void near makeCAworld(HWND);
void near storepositions(void);
#ifdef TURMITE_TAN
void near turmitetan2D(struct bug*);
void near turmitetan3D(struct bug*);
#endif TURMITE_TAN

//void adjusttraillength_2D(HDC, unsigned short, unsigned short,
//	unsigned char); // this in bug.cpp cause uses putpixel



//-----External Functions------------------------------
// dib.h
extern HBITMAP FAR PASCAL LoadDIB(HWND, char *, BOOL );
// end dib.h

//furnish.h
extern void drawfoodglob(HDC);
extern void drawpoisonglob(HDC);
extern void drawmaze(HDC);
extern void drawedge(HDC);
extern void makefoodglob(void);
extern void makepoisonglob(void);
extern void makemaze(void);
//end furnish.h

//sound.h
extern char sound_file_name[SOUND_INDEX_RANGE][MAXFILENAME];
extern void sound(unsigned char);
extern void beep(int);
extern void windelay(int);

//entropy.h
extern void checkentropy(struct colony *);
// end entropy.h

//label.h
void filecaption(HWND , char *);
// end label.h

// shape.h
void near testhit(struct bug* bug);
extern struct bug *findbug(short, short, short);
	 // x,y and radius of disk to search for trail.
// end shape.h

//alter.h
extern void installbugeatvalue(void);
extern void putbugsincolonies(unsigned char *);
extern void installdirectiontype(struct bug *);
extern void installmotiontype(struct bug *);
extern void bugswap(struct bug *, struct bug *);
//extern void adjusttraillength_3D(HDC, unsigned short, unsigned short);
// end alter.h

// breed.h 
extern void hatchbugs(void);
extern void hatchcolonies(void);
extern void randomizegenes(struct bug *);
extern void zap_enzymes(struct bug *);
extern void DNA_to_RNA(struct bug*);
extern void DNAcross(struct bug *, struct bug *, struct bug *);
extern void hitbreed(void);
extern void bugclone(struct bug *, struct bug *);
extern void census(struct colony *);
extern void census_and_reset(struct colony *); //use for hitbreeding
extern void checkmotion(struct colony *);
// end breed.h

//gene.h
extern unsigned char mothercolonyid, fathercolonyid, childcolonyid;
//end gene.h

//graph.h
extern void score_history_record(void);
// end graph.h

//hotkey.h
extern void interpretkey(HWND, WORD);
	// The WORD is the ascii code
//end hotkey.h

// metric.h
extern void update_metric(void);
// end metric.h

//ca.h
extern unsigned char CApalette_type;
extern unsigned char newlambda, lambdalevel, speedlevel;
extern float lambda;
extern unsigned char CAtype;
extern void GrowCA(HWND);
extern void bump_CApalette(HDC);
extern void set_CApalette(HDC,unsigned char);
extern void installCAtype(HDC);
extern void resizeCA(HDC, float);
extern void resizeCAxy(HDC, short, short);
extern void fillCA(unsigned char);
extern void set_slice_info(void);
extern void bump_CA_Rop(void);
extern void colorCAedges(unsigned char);
extern void FixCAChecks(void);
extern void FixSpeedChecks(void);
extern void LensBlt(HDC,short); //stretch used by ca.cpp and grow.cpp
// end ca.h

//loadsave.h
extern void randomizeparams(HWND, unsigned int);
extern int writeparams(char *);
extern int readparams(char *);
extern void installparams(HWND);

extern int writebugparams(struct bug *, char *);
extern int readbugparams(struct bug *, char *);
extern void installbugparams(struct bug *);

extern int writeworld( char *);
extern int readworld( char *);
extern int findfile(char *);
extern void installworld(HWND);
//new loadsave
extern void newrandomizeparams(HWND);
extern int newwriteparams(char *);
extern int newreadparams(char *);
extern void newinstallparams(HWND);

extern int newwritebugparams(struct bug *, char *);
extern int newreadbugparams(struct bug *, char *);
extern void newinstallbugparams(struct bug *);

extern int newwriteworld( char *);
extern int newreadworld( char *);
extern void newinstallworld(HWND);


//commdlg
//extern BOOL PASCAL GetOpenFileName(tagOFN far*);
//extern BOOL PASCAL GetSaveFileName(LPOPENFILENAME);
//extern BOOL PASCAL ChooseFont(CHOOSEFONT far*);

#ifdef CYBER
 // extern "C" turns off name-mangling for C++ so the
//name matches bug.def EXPORT listing. This can be scoped
// over the brackets.

extern "C"
{
	BOOL FAR PASCAL WorldProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL EcologyProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL ShapeProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL GeneProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL ColonyProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL AboutProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL ScoreProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL SoundProc( HWND, WORD, WORD, LONG );
	BOOL FAR PASCAL GraphProc( HWND, WORD, WORD, LONG );
};
#else
extern BOOL FAR PASCAL WorldProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL EcologyProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL ShapeProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL GeneProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL ColonyProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL AboutProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL ScoreProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL SoundProc( HWND, WORD, WORD, LONG );
extern BOOL FAR PASCAL GraphProc( HWND, WORD, WORD, LONG );
#endif //CYBER
//---------------------------Win*Main----------

char szAppName[] = "Boppers";

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpszCmdParam, int nCmdShow)
{
	MSG msg;
	WNDCLASS wndclass;
	HDC hdc;

	if (!hPrevInstance)
	{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( hInstance, (LPSTR)"IDI_BUG" );
		wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
		wndclass.hbrBackground = GetStockObject( BLACK_BRUSH );
		wndclass.lpszMenuName = "BugMenu";
		wndclass.lpszClassName = szAppName;
		RegisterClass (&wndclass);
	}

	hInst = hInstance;

	hwnd = CreateWindow(szAppName,		// window class name
			CAPTION,
				// window caption in bug.h
			WS_OVERLAPPEDWINDOW | WS_VSCROLL | WS_HSCROLL,
									// window style
			CW_USEDEFAULT,				// initial x position
			CW_USEDEFAULT,				// initial y position
			CW_USEDEFAULT,				// initial x size
			CW_USEDEFAULT,				// initial y size
			NULL,					// parent window handle
			NULL,					// window menu handle
			hInstance,				// program instance handle
			NULL);					// creation parameters


	ShowWindow(hwnd, nCmdShow);

		bugmemory(hwnd, LOCK);
		
		// Read & install the ongoing biosphere, if there is one.
			if (readworld("ACTIVE.BEX"))
			{
				installworld(hwnd);

	// Copy this buffer-fixer stuff from IDM_OPENPARAMS
				bugmemory(hwnd, UNLOCK);
				bugmemory(hwnd,SWAP);
				bugmemory(hwnd, LOCK);
				if (CAflag)
				{
					hdc = GetDC(hwnd);
					installCAtype(hdc);
//Problem: bugpalette not initialized yet here, so 
// setCApalette won't work right.
					set_CApalette(hdc, CApalette_type);
					resizeCA(hdc, 1.0);
					ReleaseDC(hwnd, hdc);
					fillCA(1);
				}
				BugLandClear(); // paint with blankcolor since
				// didn't do this in wm_init
//				SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);

	//End of bufferfixer stuff from IDM_OPENPARAMS.
			}
			else
				filecaption (hwnd,"START.BL");
		bugmemory(hwnd, UNLOCK);
		// Check the CA Menu stuff from ACTIVE.BEX
		FixCAChecks();
		FixSpeedChecks();

	UpdateWindow(hwnd);


	while (TRUE)
	{
		if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
// NULL HWND value means look at all messages to windows of
// this application, including the modeless boxes
		{
			if (hDlgScore || hDlgEcology || hDlgGene || hDlgGraph ||
				hDlgShape || hDlgColony || hDlgSound) // modeless box on
			{
				bugmemory(hwnd,LOCK); // Be ready for modeless
				if ( ! ( IsDialogMessage(hDlgScore, &msg) ||
					IsDialogMessage(hDlgEcology, &msg) ||
					IsDialogMessage(hDlgColony, &msg) ||
					IsDialogMessage(hDlgShape, &msg)||
					IsDialogMessage(hDlgGene, &msg) ||
					IsDialogMessage(hDlgSound, &msg) ||
					IsDialogMessage(hDlgGraph, &msg) ) )
				// modeless tries to eat message, if not do usual
				{
					bugmemory(hwnd,UNLOCK); // undo the lock 
					if (msg.message == WM_QUIT)
						break;
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
				else
					bugmemory(hwnd,UNLOCK); // undo the lock 
			}
			else //no modeless box
			{
				if (msg.message == WM_QUIT)
					break;
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
#ifdef TIMER
 if (!timerflag)// no message on queue
#endif //TIMER
		{
			bugmemory(hwnd,LOCK);
			if (CAflag == CA_ONLY)
				GrowCA(hwnd);
			else if (CAflag == BUGS_AND_CA)
			{
				if (++CAwaitcounter >= CAwaitalarm)
				{
					GrowCA(hwnd);
					CAwaitcounter = 0;
				}
				GrowBugs(hwnd);

			}
			else //BUGS_ONLY case
				GrowBugs(hwnd);
			bugmemory(hwnd, UNLOCK);
		}
	}

	return msg.wParam;
}

//--------------------WndProc----------------------

long FAR PASCAL WndProc (HWND hwnd, unsigned int message,
	unsigned int wParam, LONG lParam)
{
	char buf[8]; // Used by WriteProfileString
	HDC hdc ;
	PAINTSTRUCT ps ;
	unsigned char i,j ;
	short n;
	FARPROC lpitProc;
	static short nVscrollPos, nHscrollPos;
	short nVscrollInc, nHscrollInc;
	unsigned char oldeditbugid;
 //	short pair;
	BITMAP bm;
// begin COMMDLG vars
//   CHOOSEFONT cf;
//   LOGFONT lf;
//   HFONT hFont;
	OPENFILENAME ofn;
	char szFilterSpecBL [128] =
		"Bug Files (*.BL)\0All Files (*.*)\0*.*\0";
		/* file type filters */
	char szFilterSpecBEX [128] =
		"Bug Files (*.BEX)\0All Files (*.*)\0*.*\0";
		/* file type filters */
	char szFilterSpecBUG [128] =
		"Bug Files (*.BOP)\0All Files (*.*)\0*.*\0";
		/* file type filters */
#ifdef NEWFILE
	char szFilterSpecNL [128] =
		"Bug Files (*.NL)\0*.BEX\0*.BOP\0All Files (*.*)\0*.*\0";
		/* file type filters */
	char szFilterSpecNEX [128] =
		"Bug Files (*.NEX)\0*.BEX\0*.BOP\0All Files (*.*)\0*.*\0";
		/* file type filters */
	char szFilterSpecNOP [128] =
		"Bug Files (*.NOP)\0*.BEX\0*.BOP\0All Files (*.*)\0*.*\0";
		/* file type filters */
#endif //NEWFILE
	char szFileName[MAXFILENAME];
	char szFileTitle[MAXFILENAME];
// end COMMDLG vars
   RECT rect;
  
	switch (message)
	{

		case WM_CREATE:
		// IN alpha 6,  we're reentering this when selecting a minimized
		// icon of the program so heres a brute force fix to prevent that.

		// First find the size of the largest screen and make
		// it one bigger so you don't scroll in any black.
			Screen_CX = 1 + GetSystemMetrics(SM_CXFULLSCREEN) -
				GetSystemMetrics(SM_CXVSCROLL);
			bugscreen_offset_x_right = GetSystemMetrics(SM_CXVSCROLL);
            bugscreen_offset_x_left = 10; // Just so mouse can move past it.
#ifdef MESH_WRAP
			BugLand_CX = START_MESH_SIZE *
				( ( Screen_CX / START_MESH_SIZE) + 1);
			// Make round by inflating so there's no black at edges.
#else // not MESH_WRAP
			BugLand_CX = Screen_CX;
#endif // not MESH_WRAP
			wrapmaxx = BugLand_MAXX = BugLand_CX - 1;
			BugLand_MIDX = BugLand_CX / 2;

			Screen_CY = 1 + GetSystemMetrics(SM_CYFULLSCREEN) -
				GetSystemMetrics(SM_CYHSCROLL) -
				GetSystemMetrics(SM_CYMENU);

			bugscreen_offset_y_top = GetSystemMetrics(SM_CYMENU) + 
				GetSystemMetrics(SM_CYCAPTION);
			bugscreen_offset_y_bottom = GetSystemMetrics(SM_CYHSCROLL);


#ifdef MESH_WRAP
			BugLand_CY = START_MESH_SIZE *
				( ( Screen_CY / START_MESH_SIZE) + 1);
			// Make round by inflating so there's no black at edges.
#else // not MESH_WRAP
			BugLand_CY = Screen_CY;
#endif // not MESH_WRAP
			BugLand_MIDY = BugLand_CY / 2;
			wrapmaxy = BugLand_MAXY = BugLand_CY - 1;
			BugLand_CZ = BugLand_CY;
			BugLand_MIDZ = BugLand_CZ/2;
			wrapmaxz = BugLand_MAXZ = BugLand_CZ - 1;
			BugLand_SIZEOF = (long)BugLand_CX * (long)BugLand_CY;
#ifdef STEREO
			EyePix = ((float)BugLand_CX / STEREO_SCREEN_WIDTH) *
				STEREO_EYE_DIST;
			NosePix = ((float)BugLand_CX / STEREO_SCREEN_WIDTH) *
				STEREO_NOSE_DIST;
			LeftEye = (BugLand_CX / 2) - EyePix;
			RightEye = (BugLand_CX / 2) + EyePix;
#endif //STEREO
#ifndef SMALL_CA
			MAX_CA_CX = ((BugLand_CX / DIBROUND)*DIBROUND);
			MAX_CA_CY = ((BugLand_CY / DIBROUND)*DIBROUND);
			MAX_CALand_SIZEOF = (long)MAX_CA_CX * (long)MAX_CA_CY;
// MAX_CA_CX is BugLand_CX rounded off to the nearest multiple
// of DIBROUND, so we evaluate this AFTER BugLand_CX is set.  Same goes
// for Y.  The reason for DIBROUND is that when you blt a DIB, the
// height and width seem to be rounded up to the nearest multiple of
// some even number I call DIBROUND, which is set in ca.c.

#endif //not SMALL_CA
			set_slice_info(); // For CA
		// Partially initialize clientrect (do rest in WM_SIZE).
			clientrect.left = 0;
			clientrect.top = 0;

		// The first call to LOCK executes a bugmemory(hwnd,ALLOC)
			bugmemory(hwnd, LOCK);

#ifndef REGRESS
		// Seed the randomizer and save the seed for use in
		// world saves.
			seed = Randomize();
#endif //REGRESS

		// Get the device context.
			hdc = GetDC(hwnd);


		//Initialize the Pair table
			for (i=0; i<MAXSTATES; i++)
				for (j=0; j<CASECOUNT; j++)
				{
					Pair[i][j] = i * CASECOUNT + j;
				}


		// Intialize the bugs and colonies
			for (i=0; i<MAXBUGS; i++)
				bugnum[i] = i;
			hatchcolonies();
			installbugeatvalue();
			//set selfvalue, jabbervalue, wockyvalue of colonies
			hatchbugs();
			putbugsincolonies(startcolpop);
			for (i=0; i<MAXBUGS; i++)
				DNA_to_RNA(Bug[i]);

		// Get Scroll stuff ready.
			SetScrollRange(hwnd, SB_HORZ, 0, BugLand_MAXX, FALSE);
			SetScrollRange(hwnd, SB_VERT, 0, BugLand_MAXY, FALSE);
			SetScrollPos(hwnd, SB_HORZ, nHscrollPos, TRUE);
			SetScrollPos(hwnd, SB_VERT, nHscrollPos, TRUE);

		//Make BugLand
			hdcBugLand = CreateCompatibleDC(hdc);
			hBitmapBugLand = CreateCompatibleBitmap(hdc,
				BugLand_CX, BugLand_CY);
			hBitmapBugLandOld = SelectObject(hdcBugLand,
				hBitmapBugLand);

		// Initialize the colors, and put the "real" values in them
			bugpalette[weak_pal_index[0]] =
				GetNearestColor(hdc, START_FAINTTRAILCOLOR0 );
			bugpalette[weak_pal_index[1]] =
				GetNearestColor(hdc, START_FAINTTRAILCOLOR1 );
			bugpalette[weak_pal_index[2]] =
				GetNearestColor(hdc, START_FAINTTRAILCOLOR2 );
			bugpalette[strong_pal_index[0]] =
				GetNearestColor(hdc, START_TRAILCOLOR0 );
			bugpalette[strong_pal_index[1]] =
				GetNearestColor(hdc, START_TRAILCOLOR1 );
			bugpalette[strong_pal_index[2]] =
				GetNearestColor(hdc, START_TRAILCOLOR2 );
			bugpalette[BLANK_PAL_INDEX] = blankcolor =
				GetNearestColor(hdc, START_BLANKCOLOR);
			bugpalette[FOOD_PAL_INDEX] = foodcolor =
				 GetNearestColor(hdc, START_FOODCOLOR );
			bugpalette[POISON_PAL_INDEX] = poisoncolor =
				GetNearestColor(hdc, START_POISONCOLOR );
			bugpalette[WALL_PAL_INDEX] = wallcolor =
				GetNearestColor(hdc, START_WALLCOLOR );
			bugpalette[HEAD_PAL_INDEX] = headcolor =
				GetNearestColor(hdc, START_HEADCOLOR );
#ifdef MONOMEET
		meetcolor = GetNearestColor(hdc, START_MEETCOLOR);
#endif //MONOMEET
#ifdef BRIGHTMEET
		meetcolor01 = GetNearestColor(hdc, START_MEETCOLOR01);
		meetcolor02 = GetNearestColor(hdc, START_MEETCOLOR02);
		meetcolor12 = GetNearestColor(hdc, START_MEETCOLOR12);
#endif //BRIGHTMEET
#ifdef STEREO
			redcolor = GetNearestColor(hdc, START_REDCOLOR );
			bluecolor = GetNearestColor(hdc, START_BLUECOLOR );
			redindex = strong_pal_index[1];
			blueindex = strong_pal_index[2];
#endif //STEREO
			for (i=BUG_PAL_COUNT; i<16; i++)
				bugpalette[i] = GetNearestColor(hdc,
					RGB(Randombyte(), Randombyte(), Randombyte()));

		// Fill CApalette
		set_CApalette(hdc, CApalette_type);


		//Read profile info for background black or white
		background_color= GetProfileInt((LPSTR)szAppName,
			(LPSTR)"White Background", 0); //default black
		if (background_color) //exchange blank and head colors for white.
		{
			bugpalette[BLANK_PAL_INDEX] = blankcolor =
				GetNearestColor(hdc, START_HEADCOLOR);
			bugpalette[HEAD_PAL_INDEX] = headcolor =
					GetNearestColor(hdc, START_BLANKCOLOR );
		}

		// Now that know what "blankcolor" is, clear BugLand.
		// This also initializes zbuffer.
		if (!(findfile("ACTIVE.BEX"))) // You're not going to clear it
			//right after UpdateWindow
			BugLandClear(); // paint with blankcolor


		//Make CALand
#ifndef LEAKER
			hdcCALand = CreateCompatibleDC(hdc);
			hBitmapCALand = CreateCompatibleBitmap(hdc,
				CALand_CX, CALand_CY);
			hBitmapCALandOld = SelectObject(hdcCALand,
				hBitmapCALand);
#else //LEAKER
			hdcCALand = CreateCompatibleDC(hdc);
#endif //LEAKER
	// Now we initialize the lpbmiCALand bitmap info structure.

			// lpbmiCALand sets its bmiColors field entries
			for (n=0; n<256; n++)
			{
				lpbmiCALand->bmiColors[n].rgbBlue =
					GetBValue(CApalette[n]);
				lpbmiCALand->bmiColors[n].rgbGreen =
					GetGValue(CApalette[n]);
				lpbmiCALand->bmiColors[n].rgbRed =
					GetRValue(CApalette[n]);
				lpbmiCALand->bmiColors[n].rgbReserved = 0;
			}
			// Now lpbmiCALand sets its bmiHeader field's subfields
			lpbmiCALand->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
			lpbmiCALand->bmiHeader.biWidth = CALand_CX;
			lpbmiCALand->bmiHeader.biHeight = CALand_CY;
			lpbmiCALand->bmiHeader.biPlanes = 1; // default
			lpbmiCALand->bmiHeader.biBitCount = 8;
			// Eight bits per pixel if 256-col.
			// Set remaining fields all to 0 to get default behavior.
			// (Petzold, p. 612).  Don't really need to do explicitly as
			// we use LPTR = LMEM_FIXED | LMEM_ZEROINIT
			lpbmiCALand->bmiHeader.biCompression = 0;
			lpbmiCALand->bmiHeader.biSizeImage = 0;
			lpbmiCALand->bmiHeader.biXPelsPerMeter = 0;
			lpbmiCALand->bmiHeader.biYPelsPerMeter = 0;
			lpbmiCALand->bmiHeader.biClrUsed = 0;
			lpbmiCALand->bmiHeader.biClrImportant = 0;
			// It would seem I could now make the hBitmapCALand
			// which is used by CALandBlt, but this does not work,
			// always seems to remain empty.  

			if (CAflag)
			{
				fillCA(1); // randomize CALand.
				colorCAedges(0); // make edges be blank.
			}

		// Fix the hBitmapBugBody_2Ds and hdcBugBody_2Ds
			hBitmapBugBody_2D[0] =
#ifdef LOADBITMAP
				LoadDIB(hwnd, "body2g0.bmp", TRUE);
#else
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G0" );
#endif //LOADBITMAP
			hBitmapBugBody_2D[1] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G1" );
			hBitmapBugBody_2D[2] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G2" );
			hBitmapBugBody_2D[3] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G3" );
			hBitmapBugBody_2D[4] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G4" );
			hBitmapBugBody_2D[5] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G5" );
			hBitmapBugBody_2D[6] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G6" );
			hBitmapBugBody_2D[7] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G7" );
			hBitmapBugBody_2D[8] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2G8" );
			hBitmapBugBody_2D[9] =
#ifdef LOADBITMAP
				LoadDIB(hwnd, "body2r0.bmp", TRUE);
#else
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R0" );
#endif //LOADBITMAP
			hBitmapBugBody_2D[10] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R1" );
			hBitmapBugBody_2D[11] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R2" );
			hBitmapBugBody_2D[12] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R3" );
			hBitmapBugBody_2D[13] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R4" );
			hBitmapBugBody_2D[14] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R5" );
			hBitmapBugBody_2D[15] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R6" );
			hBitmapBugBody_2D[16] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R7" );
			hBitmapBugBody_2D[17] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2R8" );

			hBitmapBugBody_2D[18] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B0" );
			hBitmapBugBody_2D[19] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B1" );
			hBitmapBugBody_2D[20] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B2" );
			hBitmapBugBody_2D[21] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B3" );
			hBitmapBugBody_2D[22] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B4" );
			hBitmapBugBody_2D[23] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B5" );
			hBitmapBugBody_2D[24] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B6" );
			hBitmapBugBody_2D[25] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B7" );
			hBitmapBugBody_2D[26] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2B8" );

			hBitmapBugBody_2D[27] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY2E" );

			for (i=0; i < BODY_COUNT_2D; i++)
			{
				hdcBugBody_2D[i] = CreateCompatibleDC(hdc);
				hBitmapBodyOld_2D[i] = SelectObject(hdcBugBody_2D[i],
					hBitmapBugBody_2D[i]);
				GetObject(hBitmapBugBody_2D[i], sizeof(BITMAP), (LPSTR)&bm);
				BugBody_2D_CX[i] = bm.bmWidth;
				BugBody_2D_CY[i] = bm.bmHeight;
				if (BugBody_2D_CX[i] > MAX_BugBody_2D_CX)
					MAX_BugBody_2D_CX = BugBody_2D_CX[i];
				if (BugBody_2D_CY[i] > MAX_BugBody_2D_CY)
					MAX_BugBody_2D_CY = BugBody_2D_CY[i];
			}
			hBitmapBugBody_3D[0] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_0" );
			hBitmapBugBody_3D[1] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_1" );
			hBitmapBugBody_3D[2] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_2" );
			hBitmapBugBody_3D[3] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_3" );
			hBitmapBugBody_3D[4] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_4" );
			hBitmapBugBody_3D[5] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_5" );
			hBitmapBugBody_3D[6] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_6" );
			hBitmapBugBody_3D[7] =
				LoadBitmap( hInst, (LPSTR)"IDB_BODY_3D_7" );
			for (i=0; i < BODY_COUNT_3D; i++)
			{
				hdcBugBody_3D[i] = CreateCompatibleDC(hdc);
				hBitmapBodyOld_3D[i] = SelectObject(hdcBugBody_3D[i],
					hBitmapBugBody_3D[i]);
				GetObject(hBitmapBugBody_3D[i], sizeof(BITMAP), (LPSTR)&bm);
				BugBody_3D_CX[i] = bm.bmWidth;
				BugBody_3D_CY[i] = bm.bmHeight;
				if (BugBody_3D_CX[i] > MAX_BugBody_3D_CX)
					MAX_BugBody_3D_CX = BugBody_3D_CX[i];
				if (BugBody_3D_CY[i] > MAX_BugBody_3D_CY)
					MAX_BugBody_3D_CY = BugBody_3D_CY[i];
			}
		// Initialize food and poison and edge
			makefoodglob(); // Just to have one ready.
			makepoisonglob(); // Just to have one ready.
			if (foodglobflag)
				drawfoodglob(hdcBugLand); // draw in BugLand
			if (poisonglobflag)
				drawpoisonglob(hdcBugLand); // in BugLand
			drawedge(hdcBugLand);

			ReleaseDC(hwnd, hdc);

		// Save the start biosphere to disk.
			writeparams("start.bl");
		// Prepare modeless dialog stuff.
		lpitProcScore = MakeProcInstance( (FARPROC)ScoreProc, hInst );
		lpitProcEcology = MakeProcInstance( (FARPROC)EcologyProc, hInst );
		lpitProcShape = MakeProcInstance( (FARPROC)ShapeProc, hInst );
		lpitProcGene = MakeProcInstance( (FARPROC)GeneProc, hInst );
		lpitProcSound = MakeProcInstance( (FARPROC)SoundProc, hInst );
		lpitProcGraph = MakeProcInstance( (FARPROC)GraphProc, hInst );
		lpitProcColony = MakeProcInstance( (FARPROC)ColonyProc, hInst );

		//Read profile info for randomizer
		randomizermask = (unsigned int)GetProfileInt((LPSTR)szAppName,
			(LPSTR)"Randomizer Mask", START_RANDOMIZERMASK);

	// Use fact that RAN_? is 1<<EX_?-EX_BODY to set the
	// "But Don't Randomize" popup's checkmarks.

		//Read profile info for soundflag
		soundflag = GetProfileInt((LPSTR)szAppName,
			(LPSTR)"Sound Flag", 0);

		//Read profile info for sound effect *.WAV files.
		GetProfileString((LPSTR)szAppName, (LPSTR)"Prey Sound",
			(LPSTR)"SystemExclamation", sound_file_name[PREY_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Predator Sound",
			(LPSTR)"SystemAsterisk", sound_file_name[PRED_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Food Sound",
			(LPSTR)"SystemStart", sound_file_name[FOOD_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Poison Sound",
			(LPSTR)"SystemExit", sound_file_name[POISON_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Wall Sound",
			(LPSTR)"SystemDefault", sound_file_name[WALL_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Other Sound",
			(LPSTR)"SystemExclamation", sound_file_name[OTHER_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Death Sound",
			(LPSTR)"SystemDefault", sound_file_name[DEATH_SOUND_INDEX],
			MAXFILENAME);
		GetProfileString((LPSTR)szAppName, (LPSTR)"Rebirth Sound",
			(LPSTR)"SystemExit", sound_file_name[SEX_SOUND_INDEX],
			MAXFILENAME);

		//Check the menus
		//profile stuff
		CheckMenuItem( GetMenu(hwnd),PAL_STANDARD, MF_BYCOMMAND | 
			(!background_color?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem( GetMenu(hwnd),PAL_WHITE_BACKGROUND, MF_BYCOMMAND | 
			(background_color?MF_CHECKED:MF_UNCHECKED));
		for (n=EX_BODY; n <= EX_WALL; n++)
			CheckMenuItem( GetMenu(hwnd), n,
				MF_BYCOMMAND | (randomizermask & (1<<(n-EX_BODY))) ?
				MF_UNCHECKED : MF_CHECKED);
		// Check the CA Menu stuff
		FixCAChecks();
		// Fix speed checks.
		FixSpeedChecks();

		CheckMenuItem( GetMenu(hwnd),
					LENS_OFF, MF_BYCOMMAND | MF_CHECKED);

		bugmemory(hwnd, UNLOCK);
		return 0;

		case WM_SIZE:
			hdc = GetDC(hwnd) ;
			clientrect.right = cxClient = LOWORD(lParam);
			clientrect.bottom = cyClient = HIWORD(lParam);
			SetMapMode(hdc, MM_ANISOTROPIC);
			SetWindowExt(hdc, cxClient, cyClient );
			SetViewportExt(hdc, cxClient, -cyClient);
			SetViewportOrg(hdc, 0, cyClient);
			if (fullscreenlensflag)
			{
				fullscreenlensflag = 0;
				lens_dx = old_lens_dx;
				lens_dy = old_lens_dy;
				CheckMenuItem( GetMenu(hwnd),
					LENS_FULLSCREEN, MF_BYCOMMAND | MF_UNCHECKED);
			}
			if (lens_dx < START_LENSEDGE)
				lens_dx = lens_dy =  START_LENSEDGE;
			if (lens_dx > cxClient || lens_dy > cyClient)
				lens_dx = lens_dy = (2 * (cxClient < cyClient ?
				cxClient : cyClient)) / 3;
			lensx = cxClient / 2;
			lensy = cyClient / 2;
			if (lensflag)
			{
				lensrect.left = lensx -
					(lens_dx / 2);
				lensrect.right =
					lensx + (lens_dx / 2 );
				lensrect.top =
					lensy - (lens_dy / 2 );
				lensrect.bottom =
					lensy + (lens_dy / 2 );
				prelensx = XWRAP(lensx + WinOrgX);
				prelensy =  YWRAP(lensy + WinOrgY);
				InvalidateRect (hwnd, NULL, TRUE);
			}
			ReleaseDC(hwnd, hdc) ;
			return 0;
#ifdef TIMER
		case WM_TIMER:
			bugmemory(hwnd,LOCK);
			if (CAflag == CA_ONLY)
				GrowCA(hwnd);
			else if (CAflag == BUGS_AND_CA)
			{
				if (++CAwaitcounter >= CAwaitalarm)
				{
					GrowCA(hwnd);
					CAwaitcounter = 0;
				}
				GrowBugs(hwnd);

			}
			else //BUGS_ONLY case
				GrowBugs(hwnd);
			bugmemory(hwnd, UNLOCK);
			return 0;
#endif //TIMER
		case WM_PAINT:
			if (CAstretchflag)
			{
				hdc = BeginPaint (hwnd, &ps) ;
				EndPaint (hwnd, &ps) ;
				return 0;
			}
// In the case where I'm doing CAstretchblt in each cycle of 
// GrowCA, then this repeatedly paints the whole screen
// so I don't need to do anything in wm_paint.
			bugmemory(hwnd,LOCK);
			hdc = BeginPaint (hwnd, &ps) ;
			for (i=0; i < livebugcount; i++) // All bugbodies are erased
				Bug[bugnum[i]]->body_on = 0; // so signal that.
			BugLandBlt(hdc);
			LensBlt(hdc, stretchfactor); // Draw lens if desired.
			for (i=0; i < livebugcount; i++) // Draw desired bodies.
			{
				if (Bug[bugnum[i]]->bugbodyflag == 2) // smear body case
				{
					note_smearbody_flag = SMEAR_DING;
					trailpixel(hdc, Bug[bugnum[i]]); // call this to
                    // store the coords of the body you're about to write.
                }
				BugBodyBlt(hdc, Bug[bugnum[i]], CURRPOS);
            }
			EndPaint (hwnd, &ps) ;
			bugmemory(hwnd,UNLOCK);
			return 0;

		case WM_KEYDOWN :
		//Use this to see when controlkey is pressed, and
		// if the next key pressed is ASCII, try to interpret it.
#ifdef F1_ESCAPE
			if (wParam == VK_ESCAPE)
			{
				controlkeyflag = 0;
				SendMessage( GetFocus(), WM_CLOSE, 0L, 0L);
			}
			else if (!controlkeyflag && wParam == VK_F1)
		// VK_F1 is the same as 'p', so need to not do if controlkeyflag
		// so CTRL+P is still usable.
				WinHelp(hwnd, (LPSTR)"BUG.HLP", HELP_CONTEXT, MAIN);
			else
#endif //F1_ESCAPE
		if (wParam == VK_CONTROL)
				controlkeyflag = 1;
			else if (controlkeyflag)
			{
				if ( (wParam >= 'A' && wParam <= 'Z')  )
				{
					bugmemory( hwnd, LOCK);
					interpretkey(hwnd, wParam);
					bugmemory( hwnd, UNLOCK);
					controlkeyflag = 0;
				}
				else
					controlkeyflag = 0;
			}
			else
				controlkeyflag = 0;
#ifdef TIMER
			if (stepflag)
				SendMessage(hwnd, WM_TIMER, 0, 0L);
#endif //TIMER
			return 0;

		case WM_VSCROLL:
			switch (wParam)
			{
				case SB_LINEUP:
					nVscrollPos -= VSCROLLSTEP;
					break;
				case SB_LINEDOWN:
					nVscrollPos += VSCROLLSTEP;
					break;
				case SB_PAGEUP:
					nVscrollPos -= VSCROLLPAGESTEP;
					break;
				case SB_PAGEDOWN:
					nVscrollPos += VSCROLLPAGESTEP;
					break;
				case SB_THUMBPOSITION:
					nVscrollPos = LOWORD (lParam);
					break;
				default:
					break;
			}
			nVscrollPos = YWRAP(nVscrollPos);
			nVscrollInc = GetScrollPos(hwnd, SB_VERT) -
				nVscrollPos;
			if ( nVscrollInc )
			{
				if (nVscrollInc > BugLand_CY / 2 )
					nVscrollInc -= BugLand_CY;
				if (nVscrollInc < -BugLand_CY / 2 )
					nVscrollInc += BugLand_CY;
				ScrollWindow(hwnd, 0, nVscrollInc, NULL,
					NULL);
				SetScrollPos(hwnd, SB_VERT, nVscrollPos,
					TRUE);
				if (nVscrollPos)
					WinOrgY =  nVscrollPos;
				else
					WinOrgY = 0;
				prelensy =  YWRAP(lensy + WinOrgY);
				if (lensflag)
					InvalidateRect (hwnd, NULL, TRUE);
				UpdateWindow(hwnd);
			}
			if (CAstretchflag)
				InvalidateRect (hwnd, NULL, TRUE) ;

			return 0;


		case WM_HSCROLL:
			switch (wParam)
			{
				case SB_LINEUP:
					nHscrollPos -= HSCROLLSTEP;
					break;
				case SB_LINEDOWN:
					nHscrollPos += HSCROLLSTEP;
					break;
				case SB_PAGEUP:
					nHscrollPos -= HSCROLLPAGESTEP;
					break;
				case SB_PAGEDOWN:
					nHscrollPos += HSCROLLPAGESTEP;
					break;
				case SB_THUMBPOSITION:
					nHscrollPos = LOWORD (lParam);
					break;
				default:
					break;
			}
			nHscrollPos = XWRAP(nHscrollPos);
			nHscrollInc = GetScrollPos(hwnd, SB_HORZ) -
				nHscrollPos;
			if ( nHscrollInc )
			{
				if (nHscrollInc > BugLand_CX / 2 )
					nHscrollInc -= BugLand_CX;
				if (nHscrollInc < -BugLand_CX / 2 )
					nHscrollInc += BugLand_CX;
				ScrollWindow(hwnd, nHscrollInc, 0, NULL,
					NULL);
				SetScrollPos(hwnd, SB_HORZ, nHscrollPos,
					TRUE);
				WinOrgX = nHscrollPos;
				prelensx = XWRAP(lensx + WinOrgX);
				if (lensflag)
					InvalidateRect (hwnd, NULL, TRUE);
				UpdateWindow(hwnd);
			}
			if (CAstretchflag)
				InvalidateRect (hwnd, NULL, TRUE) ;
			return 0;
		
		case WM_LBUTTONDOWN:
			bugmemory( hwnd, LOCK);
			switch(cursormode)
			{
				case CUR_SPAWN:
				case CUR_PICK:
				case CUR_ISOLATE:
				case CUR_ZAP:
				case CUR_CARRY:
					// Pick a bug for later editing
					pickbug = findbug(LOWORD(lParam),
						HIWORD(lParam), FINDRAD);
					if (pickbug)
					{
						editmode = 2;
						if (cursormode == CUR_CARRY)
						{
							if (!carryflag)
							{ //Start dragging new guy
								carryflag = 1;
								editbugid = pickbug->bugid;
								installmotiontype(Bug[editbugid]);
							}
							else if(pickbug->bugid != editbugid)
				// case where carryflag on and pickbug is different
							{ // Stop dragging old guy and
						// start dragging new. installmotionype
						// from alter.cpp does it.
								oldeditbugid = editbugid;
								editbugid = pickbug->bugid;
								installmotiontype(Bug[editbugid]);
								installmotiontype(
									Bug[oldeditbugid]);
							}
						// else carryflag on and pickbug is editbug
						// don't do anything
						}
						else // if not CUR_ZAP
							editbugid = pickbug->bugid;
						editcolonyid = (unsigned char)
							pickbug->colonyid;
						if (cursormode == CUR_SPAWN)
							// copy bug onto all of its colony.
							for (i=0;i<Colony[editcolonyid].pop; i++)
							{
								bugclone(pickbug,Bug[Colony[
									editcolonyid].rank[i]]);
								DNA_to_RNA(Bug[Colony[
									editcolonyid].rank[i]]);
							}
						if (cursormode == CUR_ISOLATE &&
							!isolatedflag)
						{
							oldfirstbugid = bugnum[0];
							bugswap(pickbug, Bug[bugnum[0]]);
							oldlivebugcount = livebugcount;
							for (j=0; j<MAXCOLONIES; j++)
							{
								startcolpop[j] = Colony[j].pop;
								if (editcolonyid == j)
									Colony[j].pop = 1;
								else
									Colony[j].pop = 0;
							}
							livebugcount = 1;
							isolatedflag = 1;
							SendMessage(hwnd,
								WM_COMMAND, IDM_CLEAR, 0L);
						}
						if (cursormode == CUR_ZAP)
						{
							randomizegenes(pickbug);
							DNA_to_RNA(pickbug);
						}
						SetSoundNoise(S_PERIOD512, 15);
						if (hDlgShape)
							SendMessage(hDlgShape,WM_INITDIALOG,0,0L);
						if (hDlgColony)
							SendMessage(hDlgColony,WM_INITDIALOG,0,0L);
					}
					else
					{
						editmode = 0;
						if (cursormode == CUR_CARRY && !carryflag)
							{ //Start dragging guy
								carryflag = 1;
								installmotiontype(Bug[editbugid]);
							}
					}
					break;

				case CUR_LENS:
					if (fullscreenlensflag)
					{
						lensflag = 1;
					}
					else //start not fullscreenlensflag case
					{
					lensx = LOWORD(lParam);
					lensy = HIWORD(lParam);
		// Make sure lens is all onscreen, and scroll towards pick.
					if (lensx < lens_dx/2)
					{
						SendMessage(hwnd, WM_HSCROLL, SB_LINEUP, 0L);
						lensx = lens_dx/2;
					}
					if (lensy < lens_dy/2)
					{
						SendMessage(hwnd, WM_VSCROLL, SB_LINEUP, 0L);
						lensy = lens_dy/2;
					}
					if (lensx > cxClient - (lens_dx/2))
					{
						SendMessage(hwnd, WM_HSCROLL,
							SB_LINEDOWN, 0L);
						lensx = cxClient - (lens_dx/2);
					}
					if (lensy > cyClient - (lens_dy/2))
					{
						SendMessage(hwnd, WM_VSCROLL,
							SB_LINEDOWN, 0L);
						lensy = cyClient - (lens_dy/2);
					}
					lensrect.left = lensx - (lens_dx / 2);
					lensrect.right = lensx + (lens_dx / 2 );
					lensrect.top = lensy - (lens_dy / 2 );
					lensrect.bottom = lensy + (lens_dy / 2 );
					prelensx = XWRAP(lensx + WinOrgX);
					prelensy =  YWRAP(lensy + WinOrgY);
					if (lensflag) // Clear if already was a lens.
						InvalidateRect (hwnd, NULL, TRUE);
					lensflag = 1;
					} // end not fullscreenlensflag case
					CheckMenuItem( GetMenu(hwnd), LENS_OFF,
						MF_BYCOMMAND | MF_UNCHECKED);
					CheckMenuItem( GetMenu(hwnd), LENS_ON,
						MF_BYCOMMAND | MF_CHECKED);
					break;
			}
			bugmemory( hwnd, UNLOCK);
			return 0;

		case WM_RBUTTONDOWN:
			bugmemory( hwnd, LOCK);
			switch(cursormode)
			{
				case CUR_SPAWN:
//				case CUR_PICK:
				case CUR_ZAP:
				case CUR_CARRY:
					if (cursormode == CUR_CARRY)
					{
						// Stop dragging old guy .
						carryflag = 0;
						installmotiontype(Bug[editbugid]);
					}
					// Pick bug and colony but set editmode to
					// colony edit instead of bug edit.
					pickbug = findbug(LOWORD(lParam),
						HIWORD(lParam), FINDRAD);
					if (pickbug)
					{
						editmode = 1;
						editbugid = pickbug->bugid;
						editcolonyid = (unsigned char)
							pickbug->colonyid;
						if (cursormode == CUR_SPAWN)
					// copy editcolonyid onto other put colonies.
							for (i=0; i<livebugcount; i++)
							{
								bugclone(pickbug, Bug[bugnum[i]]);
								DNA_to_RNA(Bug[bugnum[i]]);
							}
						if (cursormode == CUR_ZAP)
						{
							zap_enzymes(pickbug);
							DNA_to_RNA(pickbug);
						}
						SetSoundNoise(S_PERIOD512, 15);
					}
					else
						editmode = 0;
					break;
				case CUR_ISOLATE:
					if (isolatedflag)
					{
						for (j=0; j<MAXCOLONIES; j++)
							Colony[j].pop= startcolpop[j];
						livebugcount = oldlivebugcount;
						for (i=0; i < livebugcount; i++)
						{ // in case world menu has changed dimension.
							installmotiontype(Bug[bugnum[i]]);
							installdirectiontype(Bug[bugnum[i]]);
							DNA_to_RNA(Bug[bugnum[i]]);
						}
						isolatedflag = 0;
						// Don't bother to swap the bugnums back.
					}
					break;
				case CUR_LENS:
					lensflag = 0;
					CheckMenuItem( GetMenu(hwnd), LENS_OFF,
						MF_BYCOMMAND | MF_CHECKED);
					CheckMenuItem( GetMenu(hwnd), LENS_ON,
						MF_BYCOMMAND | MF_UNCHECKED);
					InvalidateRect (hwnd, NULL, TRUE); // Clear screen
					break;
			}
			bugmemory( hwnd, UNLOCK);
			return 0;

		case WM_COMMAND:
			switch(wParam)
			{
				case IDM_OPENPARAMS:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.bl");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecBL;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "BL";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						if (readparams(szFileName))
							installparams(hwnd);

						bugmemory(hwnd, UNLOCK);
						bugmemory(hwnd,SWAP);
						bugmemory(hwnd, LOCK);
						if (CAflag)
						{
							hdc = GetDC(hwnd);
							installCAtype(hdc);
							set_CApalette(hdc, CApalette_type);
							resizeCA(hdc, 1.0);
							ReleaseDC(hwnd, hdc);
							fillCA(1);
						}
					}
					bugmemory(hwnd, UNLOCK);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
					if (hDlgEcology)
					{
						DestroyWindow(hDlgEcology);
						SendMessage(hwnd, WM_COMMAND, IDM_ECOLOGY,
							0L);
					}
					if (hDlgColony)
					{
						DestroyWindow(hDlgColony);
						SendMessage(hwnd, WM_COMMAND, IDM_COLONY,
							0L);
					}
					if (hDlgShape)
					{
						DestroyWindow(hDlgShape);
						SendMessage(hwnd, WM_COMMAND, IDM_SHAPE,
							0L);
					}
					if (hDlgGene)
					{
						DestroyWindow(hDlgGene);
						SendMessage(hwnd, WM_COMMAND, IDM_GENE,
							0L);
					}
		// Check the CA Menu stuff
					FixCAChecks();
					break;

				case IDM_SAVEPARAMS:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.bl");
					/* fill in non-variant fields of OPENFILENAME struct. */
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecBL;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "BL";
					ofn.Flags             = 0;

					if( GetSaveFileName((LPOPENFILENAME)&ofn) )
						writeparams(szFileName);
					bugmemory( hwnd, UNLOCK);
					break;

				case IDM_OPENBIOSPHERE:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.bex");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecBEX;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "BEX";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						if (readworld(szFileName))
							installworld(hwnd);
						bugmemory(hwnd, UNLOCK);
						bugmemory(hwnd,SWAP);
						bugmemory(hwnd, LOCK);
						if (CAflag)
						{
							hdc = GetDC(hwnd);
							installCAtype(hdc);
							set_CApalette(hdc, CApalette_type);
							resizeCA(hdc, 1.0);
							ReleaseDC(hwnd, hdc);
							fillCA(0);
						}
					}
					bugmemory(hwnd, UNLOCK);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
					if (hDlgEcology)
					{
						DestroyWindow(hDlgEcology);
						SendMessage(hwnd, WM_COMMAND, IDM_ECOLOGY,
							0L);
					}
					if (hDlgColony)
					{
						DestroyWindow(hDlgColony);
						SendMessage(hwnd, WM_COMMAND, IDM_COLONY,
							0L);
					}
					if (hDlgShape)
					{
						DestroyWindow(hDlgShape);
						SendMessage(hwnd, WM_COMMAND, IDM_SHAPE,
							0L);
					}
					if (hDlgGene)
					{
						DestroyWindow(hDlgGene);
						SendMessage(hwnd, WM_COMMAND, IDM_GENE,
							0L);
					}
		// Check the CA Menu stuff
					FixCAChecks();
					break;

				case IDM_SAVEBIOSPHERE:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.bex");
					/* fill in non-variant fields of OPENFILENAME struct. */
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecBEX;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "BEX";
					ofn.Flags             = 0;

					if( GetSaveFileName((LPOPENFILENAME)&ofn) )
						writeworld(szFileName);
					bugmemory( hwnd, UNLOCK);
					break;

				case IDM_OPENBUG:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.bop");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecBUG;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "BOP";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						if (readbugparams(Bug[editbugid], szFileName))
							installbugparams(Bug[editbugid]);
					}
					bugmemory(hwnd, UNLOCK);
					if (hDlgShape)
					{
						DestroyWindow(hDlgShape);
						SendMessage(hwnd, WM_COMMAND, IDM_SHAPE,
							0L);
					}
					if (hDlgGene)
					{
						DestroyWindow(hDlgGene);
						SendMessage(hwnd, WM_COMMAND, IDM_GENE,
							0L);
					}
					break;

				case IDM_SAVEBUG:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.bop");
					/* fill in non-variant fields of OPENFILENAME struct. */
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecBUG;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "BOP";
					ofn.Flags             = 0;

					if( GetSaveFileName((LPOPENFILENAME)&ofn) )
					{
						writebugparams(Bug[editbugid], szFileName);
					}
					bugmemory( hwnd, UNLOCK);
					break;
				case RAN_BIOSPHERE:
				case RAN_ECOLOGY:
				case RAN_WORLD:
				case RAN_COLONIES:
				case RAN_BUGS:
					filecaption(hwnd,"RANDOM PARAMETERS");
					bugmemory(hwnd, LOCK);
					randomizeparams(hwnd, wParam);
	//wParam is the variable we're switching on, so it's the case
					bugmemory( hwnd, UNLOCK);
					if (wParam == RAN_BIOSPHERE ||
						wParam == RAN_WORLD) // CA or 2d/3d change?
						{
							bugmemory(hwnd,SWAP);
							bugmemory(hwnd, LOCK);
						if (CAflag)
						{
							hdc = GetDC(hwnd);
							installCAtype(hdc);
							set_CApalette(hdc, CApalette_type);
							resizeCA(hdc, 1.0);
							ReleaseDC(hwnd, hdc);
							fillCA(1);
						}
						bugmemory(hwnd, UNLOCK);
					}
					if (wParam == RAN_BIOSPHERE ||
						wParam == RAN_WORLD || wParam == RAN_BUGS)
						SendMessage(hwnd,
							WM_COMMAND, IDM_CLEAR, 0L);
					// Need to update dialog boxes
					if (hDlgShape && ( wParam == RAN_BUGS ||
						wParam == RAN_BIOSPHERE ||
						wParam == RAN_WORLD))
					{
						DestroyWindow(hDlgShape);
						SendMessage(hwnd, WM_COMMAND, IDM_SHAPE,
							0L);
					}
					if (hDlgGene && ( wParam == RAN_BUGS ||
						wParam == RAN_BIOSPHERE ||
						wParam == RAN_WORLD))
					{
						DestroyWindow(hDlgGene);
						SendMessage(hwnd, WM_COMMAND, IDM_GENE,
							0L);
					}
					if (hDlgColony && ( wParam == RAN_COLONIES ||
						wParam ==RAN_BIOSPHERE))
					{
						DestroyWindow(hDlgColony);
						SendMessage(hwnd, WM_COMMAND, IDM_COLONY,
							0L);
					}
					if (hDlgEcology && ( wParam == RAN_ECOLOGY ||
						wParam ==RAN_BIOSPHERE))
					{
						DestroyWindow(hDlgEcology);
						SendMessage(hwnd, WM_COMMAND, IDM_ECOLOGY,
							0L);
					}
		// Check the CA Menu stuff
					FixCAChecks();
					break;
				case RAN_GENES:
					bugmemory( hwnd, LOCK);
					for (i=0; i< livebugcount; i++)
					{
						randomizegenes(Bug[bugnum[i]]);
						DNA_to_RNA(Bug[bugnum[i]]);
					}
					bugmemory( hwnd, UNLOCK);
					if (hDlgGene)
					{
						DestroyWindow(hDlgGene);
						SendMessage(hwnd, WM_COMMAND, IDM_GENE,
							0L);
					}
					break;
				case RAN_POSITION:
					bugmemory( hwnd, LOCK);
					randomizepositions(hwnd);
					bugmemory( hwnd, UNLOCK);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
					break;

				case EX_BODY:
					randomizermask ^= RAN_BODY;
					CheckMenuItem( GetMenu(hwnd), wParam,
						MF_BYCOMMAND | (randomizermask & 
						RAN_BODY) ?
						MF_UNCHECKED : MF_CHECKED);
					break;

				case EX_DIM:
					randomizermask ^= RAN_DIM;
					CheckMenuItem( GetMenu(hwnd), wParam,
						MF_BYCOMMAND | (randomizermask & 
						RAN_DIM) ?
						MF_UNCHECKED : MF_CHECKED);
					break;

				case EX_TURM_BOID:
					randomizermask ^= RAN_TURM_BOID;
					CheckMenuItem( GetMenu(hwnd), wParam,
						MF_BYCOMMAND | (randomizermask & 
						RAN_TURM_BOID) ?
						MF_UNCHECKED : MF_CHECKED);
					break;

				case EX_CA:
					randomizermask ^= RAN_CA;
					CheckMenuItem( GetMenu(hwnd), wParam,
						MF_BYCOMMAND | (randomizermask & 
						RAN_CA) ?
						MF_UNCHECKED : MF_CHECKED);
					break;

				case EX_WALL:
					randomizermask ^= RAN_WALL;
					CheckMenuItem( GetMenu(hwnd), wParam,
						MF_BYCOMMAND | (randomizermask & 
						RAN_WALL) ?
						MF_UNCHECKED : MF_CHECKED);
					break;
#ifdef TIMER
				case SPEED_STEP:
					if (timerflag)
						KillTimer(hwnd, 1);
					timerflag = 1;
					stepflag = 1;
#ifdef GROWBUGS_STEPS
					GrowBugs_steps = 1;
#endif //GROWBUGS_STEPS
					speedlevel = NONE;
					FixSpeedChecks();
					break;

				case SPEED_SLOW:
					if (timerflag)
						KillTimer(hwnd, 1);
					timerflag = 1;
					stepflag = 0;
					SetTimer(hwnd, 1, waitmsecs[1], NULL);
#ifdef GROWBUGS_STEPS
					GrowBugs_steps = 1;

#endif //GROWBUGS_STEPS
					speedlevel = LOW;
					FixSpeedChecks();
					break;

				case SPEED_FAST:
					if (timerflag)
						KillTimer(hwnd, 1);
					timerflag = 0;
					stepflag = 0;
#ifdef GROWBUGS_STEPS
					GrowBugs_steps = START_GROWBUGS_STEPS;
#endif //GROWBUGS_STEPS
					speedlevel = HIGH;
					FixSpeedChecks();
					break;
#endif //TIMER

#ifdef NEWFILE
				case IDM_NEWOPENPARAMS:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.nl");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecNL;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "NL";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						if (newreadparams(szFileName))
							newinstallparams(hwnd);
						bugmemory(hwnd, UNLOCK);
						bugmemory(hwnd,SWAP);
						bugmemory(hwnd, LOCK);
						if (CAflag)
						{
							hdc = GetDC(hwnd);
							installCAtype(hdc);
							set_CApalette(hdc, CApalette_type);
							resizeCA(hdc, 1.0);
							ReleaseDC(hwnd, hdc);
							fillCA(1);
						}
					}
					bugmemory(hwnd, UNLOCK);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
					break;
				case IDM_NEWSAVEPARAMS:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.nl");
					/* fill in non-variant fields of OPENFILENAME struct. */
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecNL;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "NL";
					ofn.Flags             = 0;

					if( GetSaveFileName((LPOPENFILENAME)&ofn) )
						newwriteparams(szFileName);
					bugmemory( hwnd, UNLOCK);
					break;

				case IDM_NEWOPENBIOSPHERE:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.nex");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecNEX;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "NOR";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						if (newreadworld(szFileName))
							newinstallworld(hwnd);
						bugmemory(hwnd, UNLOCK);
						bugmemory(hwnd,SWAP);
						bugmemory(hwnd, LOCK);
						if (CAflag)
						{
							hdc = GetDC(hwnd);
							installCAtype(hdc);
							set_CApalette(hdc, CApalette_type);
							resizeCA(hdc, 1.0);
							ReleaseDC(hwnd, hdc);
							fillCA(1);
						}
					}
					bugmemory(hwnd, UNLOCK);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
					break;

				case IDM_NEWSAVEBIOSPHERE:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.nex");
					/* fill in non-variant fields of OPENFILENAME struct. */
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecNEX;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "NEX";
					ofn.Flags             = 0;

					if( GetSaveFileName((LPOPENFILENAME)&ofn) )
						newwriteworld(szFileName);
					bugmemory( hwnd, UNLOCK);
					break;

				case IDM_NEWOPENBUG:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.nop");
				// fill in non-variant fields of OPENFILENAME struct.
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecNOP;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "NOP";
					ofn.Flags             = 0;
					if( GetOpenFileName((LPOPENFILENAME)&ofn) )
					{
						if (newreadbugparams(Bug[editbugid], szFileName))
							newinstallbugparams(Bug[editbugid]);
					}
					bugmemory(hwnd, UNLOCK);
					break;

				case IDM_NEWSAVEBUG:
					bugmemory(hwnd, LOCK);
					strcpy(szFileName,"*.nop");
					/* fill in non-variant fields of OPENFILENAME struct. */
					ofn.lStructSize       = sizeof(OPENFILENAME);
					ofn.hwndOwner	  = hwnd;
					ofn.lpstrFilter	  = szFilterSpecNOP;
					ofn.lpstrCustomFilter = NULL;
					ofn.nMaxCustFilter	  = 0;
					ofn.nFilterIndex	  = 1;
					ofn.lpstrFile         = szFileName;
					ofn.nMaxFile	  = MAXFILENAME;
					ofn.lpstrInitialDir   = NULL;
					ofn.lpstrFileTitle    = szFileTitle;
					ofn.nMaxFileTitle     = MAXFILENAME;
					ofn.lpstrTitle        = NULL;
					ofn.lpstrDefExt       = "NOP";
					ofn.Flags             = 0;

					if( GetSaveFileName((LPOPENFILENAME)&ofn) )
					{
						newwritebugparams(Bug[editbugid], szFileName);
					}
					bugmemory( hwnd, UNLOCK);
					break;

#endif //NEWFILE
				case IDM_CLEAR:
					bugmemory(hwnd, LOCK);
					BugLandClear(); // Clear bugland, insert furniture
					if (foodglobflag)
						drawfoodglob(hdcBugLand);
					if (poisonglobflag)
						drawpoisonglob(hdcBugLand);
					if (mazeflag)
						drawmaze(hdcBugLand);
					drawedge(hdcBugLand);
					bugmemory( hwnd, UNLOCK);
					InvalidateRect (hwnd, NULL, TRUE) ;// Clear screen
					break;


				case IDM_CORNERPOSITION:
					bugmemory( hwnd, LOCK);
					cornerbugs(hwnd);
					bugmemory( hwnd, UNLOCK);
					break;


				case IDM_EXIT:
					bugmemory(hwnd, LOCK);
					SendMessage( hwnd, WM_DESTROY, 0, 0L );
					bugmemory(hwnd, UNLOCK);
					break;

				case IDM_WORLD:
					bugmemory( hwnd, LOCK);
					lpitProc = MakeProcInstance(
						(FARPROC)WorldProc, hInst );
					DialogBox(
						hInst, (LPSTR)"WORLD", hwnd, lpitProc );
					FreeProcInstance( (FARPROC)lpitProc );
					bugmemory(hwnd, UNLOCK);
					bugmemory(hwnd,SWAP);
					bugmemory(hwnd, LOCK);
					if (CAflag)
					{
						hdc = GetDC(hwnd);
						installCAtype(hdc);
						set_CApalette(hdc, CApalette_type);
						resizeCA(hdc, 1.0);
						ReleaseDC(hwnd, hdc);
					}
					FixCAChecks();
					bugmemory(hwnd, UNLOCK);
					if (worldclearflag)
						SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
					break;

				case IDM_SHAPE:
					if (!hDlgShape)
					{
						hDlgShape = CreateDialog(hInst,
							(LPSTR)"SHAPE", hwnd, lpitProcShape );
						GetWindowRect(hDlgShape, &rect);
						rect.bottom-=rect.top;
						rect.right-=rect.left;
						rect.left = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"ShapeX",400);
						rect.top = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"ShapeY",200);
						if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
							rect.left=75;
						if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
							rect.top=25;
						MoveWindow(hDlgShape, rect.left, rect.top,
							rect.right, rect.bottom, FALSE);
						ShowWindow(hDlgShape, TRUE);
					}
					else
						DestroyWindow(hDlgShape);
					break;

				case IDM_GENE:
					if (!hDlgGene)
					{
						hDlgGene = CreateDialog(hInst,
							(LPSTR)"GENE", hwnd, lpitProcGene );
						GetWindowRect(hDlgGene, &rect);
						rect.bottom-=rect.top;
						rect.right-=rect.left;
						rect.left = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"GeneX",400);
						rect.top = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"GeneY",200);
						if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
							rect.left=75;
						if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
							rect.top=25;
						MoveWindow(hDlgGene, rect.left, rect.top,
							rect.right, rect.bottom, FALSE);
						ShowWindow(hDlgGene, TRUE);
					}
					else
						DestroyWindow(hDlgGene);
					break;

				case IDM_SOUND:
					if (!hDlgSound)
					{
						hDlgSound = CreateDialog(hInst,
							(LPSTR)"SOUND", hwnd, lpitProcSound );
						GetWindowRect(hDlgSound, &rect);
						rect.bottom-=rect.top;
						rect.right-=rect.left;
						rect.left = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"SoundX",400);
						rect.top = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"SoundY",200);
						if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
							rect.left=75;
						if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
							rect.top=25;
						MoveWindow(hDlgSound, rect.left, rect.top,
							rect.right, rect.bottom, FALSE);
						ShowWindow(hDlgSound, TRUE);
					}
					else
						DestroyWindow(hDlgSound);

					break;

				case PAL_STANDARD:
					background_color = 0;
		CheckMenuItem( GetMenu(hwnd),PAL_STANDARD, MF_BYCOMMAND | 
			(!background_color?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem( GetMenu(hwnd),PAL_WHITE_BACKGROUND, MF_BYCOMMAND | 
			(background_color?MF_CHECKED:MF_UNCHECKED));
					hdc = GetDC(hwnd);
					bugpalette[BLANK_PAL_INDEX] = blankcolor =
						GetNearestColor(hdc, START_BLANKCOLOR);
					bugpalette[HEAD_PAL_INDEX] = headcolor =
						GetNearestColor(hdc, START_HEADCOLOR );
					ReleaseDC(hwnd, hdc);
					SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
					break;

				case PAL_WHITE_BACKGROUND:
					background_color = 1;
		CheckMenuItem( GetMenu(hwnd),PAL_STANDARD, MF_BYCOMMAND | 
			(!background_color?MF_CHECKED:MF_UNCHECKED));
		CheckMenuItem( GetMenu(hwnd),PAL_WHITE_BACKGROUND, MF_BYCOMMAND | 
			(background_color?MF_CHECKED:MF_UNCHECKED));
					hdc = GetDC(hwnd);
					bugpalette[BLANK_PAL_INDEX] = blankcolor =
						GetNearestColor(hdc, START_HEADCOLOR);
					bugpalette[HEAD_PAL_INDEX] = headcolor =
						GetNearestColor(hdc, START_BLANKCOLOR );
					ReleaseDC(hwnd, hdc);
					SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
					break;

				case PAL_RANDOM:
                	break;

				case IDM_GRAPH:
					if (!hDlgGraph)
					{
						hDlgGraph = CreateDialog(hInst,
							(LPSTR)"GRAPH", hwnd, lpitProcGraph );
						GetWindowRect(hDlgGraph, &rect);
						rect.bottom-=rect.top;
						rect.right-=rect.left;
						rect.left = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"GraphX",400);
						rect.top = (int)GetProfileInt((LPSTR)szAppName,
							(LPSTR)"GraphY",200);
						if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
							rect.left=75;
						if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
							rect.top=25;
						MoveWindow(hDlgGraph, rect.left, rect.top,
							rect.right, rect.bottom, FALSE);
						ShowWindow(hDlgGraph, TRUE);
					}
					else
						DestroyWindow(hDlgGraph);

					break;


			
				case IDM_COLONY:
					if (!hDlgColony)
                  {
						hDlgColony = CreateDialog(hInst, (LPSTR)"COLONY", hwnd, lpitProcColony );
                  GetWindowRect(hDlgColony, &rect);
                  rect.bottom-=rect.top;
                  rect.right-=rect.left;
                  rect.left = (int)GetProfileInt((LPSTR)szAppName,(LPSTR)"ColonyX",100);
                  rect.top = (int)GetProfileInt((LPSTR)szAppName,(LPSTR)"ColonyY",100);
                  if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
                     rect.left=75;
                  if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
                     rect.top=25;
                  MoveWindow(hDlgColony, rect.left,rect.top,rect.right,rect.bottom,FALSE);
                  ShowWindow(hDlgColony, TRUE);
                  }
               else
                  DestroyWindow(hDlgColony);
					break;

				case IDM_ECOLOGY:
					if (!hDlgEcology)
                  {
						hDlgEcology = CreateDialog(
							hInst, (LPSTR)"ECOLOGY", hwnd, lpitProcEcology );
                  GetWindowRect(hDlgEcology, &rect);
                  rect.bottom-=rect.top;
                  rect.right-=rect.left;
                  rect.left = (int)GetProfileInt((LPSTR)szAppName,(LPSTR)"EcologyX",100);
                  rect.top = (int)GetProfileInt((LPSTR)szAppName,(LPSTR)"EcologyY",100);
                  if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
                     rect.left=25;
                  if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
                     rect.top=25;
                  MoveWindow(hDlgEcology, rect.left,rect.top,rect.right,rect.bottom,FALSE);
                  ShowWindow(hDlgEcology, TRUE);
                  }
               else
                  DestroyWindow(hDlgEcology);
					break;

				case CA_OFF:
					CAflag = 0;
					bugmemory(hwnd,SWAP);
					if (CAstretchflag)
					{
						WinOrgX = bugWinOrgX;
						WinOrgY = bugWinOrgY;
						CAstretchflag = 0;
						SendMessage(hwnd, WM_HSCROLL,
							SB_THUMBPOSITION, WinOrgX);
						SendMessage(hwnd, WM_VSCROLL,
							SB_THUMBPOSITION, WinOrgY);
						SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
					}
					FixCAChecks();
					break;

				case CA_RULE_RUG:
				case CA_RULE_LIFE:
				case CA_RULE_BRAIN:
				case CA_RULE_FADERS:
				case CA_RULE_HODGE:
				case CA_RULE_MELT:
				case CA_RULE_VOTE:
				case CA_RULE_LAMBDA:
				case CA_RULE_RANCH:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					CAtype = wParam - CA_RULE_RUG;
					installCAtype(hdc);
					slice = 0;
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;

				case CA_LAMBDA_LOW:
				case CA_LAMBDA_MED:
				case CA_LAMBDA_HIGH:
					switch (wParam)
					{
						case CA_LAMBDA_LOW:
							lambda = LAMBDA_LOW;
							lambdalevel = LOW;
							break;
						case CA_LAMBDA_MED:
							lambda = LAMBDA_MEDIUM;
							lambdalevel = MEDIUM;
							break;
						case CA_LAMBDA_HIGH:
							lambda = LAMBDA_HIGH;
							lambdalevel = HIGH;
							break;
					}
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					if (CAtype == RANCH_TYPE)
						set_CApalette(hdc, 0); //boppers palette
					CAtype = CA_RULE_LAMBDA - CA_RULE_RUG;
					hdc = GetDC(hwnd);
					installCAtype(hdc);
					ReleaseDC(hwnd, hdc);
					slice = 0;
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					SendMessage(hwnd, WM_COMMAND, CA_SEED, 0L);
					break;

				case CA_WINDOW:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					hdc = GetDC(hwnd);
					resizeCAxy(hdc, cxClient, cyClient);
					colorCAedges(0);
					ReleaseDC(hwnd, hdc);
					bugmemory( hwnd, UNLOCK);
//unscroll
						bugWinOrgX = WinOrgX;
						bugWinOrgY = WinOrgY;

						WinOrgX = 0;
						WinOrgY = 0;
						SendMessage(hwnd, WM_HSCROLL,
							SB_THUMBPOSITION, 0L);
						SendMessage(hwnd, WM_VSCROLL,
							SB_THUMBPOSITION, 0L);
						InvalidateRect (hwnd, NULL, TRUE) ;
//end unscroll
						SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
					FixCAChecks();
						break;

				case CA_ON:
					makeCAworld(hwnd);
					FixCAChecks();
					break;


				case CA_BIGGER:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					hdc = GetDC(hwnd);
					resizeCA(hdc, 1.0 / START_CA_SHRINK);
					colorCAedges(0);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
	//Because in a stretched window, bigger CA can fit in oddly
	// to leave some ca junk on screen.
					ReleaseDC(hwnd, hdc);
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;

				case CA_SMALLER:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					hdc = GetDC(hwnd);
					resizeCA(hdc, START_CA_SHRINK );
					colorCAedges(0);
					SendMessage(hwnd,
						WM_COMMAND, IDM_CLEAR, 0L);
					ReleaseDC(hwnd, hdc);
					bugmemory( hwnd, UNLOCK);
					InvalidateRect (hwnd, NULL, TRUE) ;
					FixCAChecks();
					break;

				case CA_PALETTE_STANDARD:
				case CA_PALETTE_RANDOM:
				case CA_PALETTE_FADERS:
				case CA_PALETTE_MELT:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					hdc = GetDC(hwnd);
					set_CApalette(hdc, wParam - CA_PALETTE_STANDARD);
					ReleaseDC(hwnd, hdc);
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;

				case CA_TOGGLECAWRAP:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					CAwrapflag ^= 1;
					CheckMenuItem( GetMenu(hwnd),CA_TOGGLECAWRAP,
						MF_BYCOMMAND |
						(CAwrapflag ?MF_CHECKED:MF_UNCHECKED));
					slice = 0;
					if (!CAwrapflag)
						colorCAedges(0);
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;
				
				case CA_SEED:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					fillCA(1);
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;

				case CA_BLANK:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					fillCA(0);
					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;

				case CA_TOGGLEBUGS:
//					if (!CAflag)
//                    	break;
					if (!CAstretchflag)
					{
						makeCAworld(hwnd);
						bugmemory( hwnd, LOCK);
						// CAflag is now 1 or 2.
						CAflag ^= 3; // 1 to 2, 2 to 1.
						InvalidateRect (hwnd, NULL, TRUE) ;
						bugmemory( hwnd, UNLOCK);
						FixCAChecks();
					}
					break;

				case CA_TOGGLEFULL:
					makeCAworld(hwnd);
					bugmemory( hwnd, LOCK);
					if (CAstretchflag)
					{
						WinOrgX = bugWinOrgX;
						WinOrgY = bugWinOrgY;
						CAstretchflag = 0;
						CAflag = oldCAflag;
						SendMessage(hwnd, WM_HSCROLL,
							SB_THUMBPOSITION, WinOrgX);
						SendMessage(hwnd, WM_VSCROLL,
							SB_THUMBPOSITION, WinOrgY);
						SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
					}
					else
					{
						SendMessage(hwnd, WM_COMMAND,
							CUR_PICK, 0L);
						//other cursors no good here
						if (lensflag)
							lensflag = 0;
						// lens not good with fullscreen CA
						bugWinOrgX = WinOrgX;
						bugWinOrgY = WinOrgY;
						WinOrgX = 0;
						WinOrgY = 0;
						CAstretchflag = 1;
						oldCAflag = CAflag;
						CAflag = 1;
						SendMessage(hwnd, WM_HSCROLL,
							SB_THUMBPOSITION, 0L);
						SendMessage(hwnd, WM_VSCROLL,
							SB_THUMBPOSITION, 0L);
						InvalidateRect (hwnd, NULL, TRUE) ;
						lensflag = 0;
					CheckMenuItem( GetMenu(hwnd), LENS_OFF,
						MF_BYCOMMAND | MF_CHECKED);
					CheckMenuItem( GetMenu(hwnd), LENS_ON,
						MF_BYCOMMAND | MF_UNCHECKED);
					}

					bugmemory( hwnd, UNLOCK);
					FixCAChecks();
					break;

				case CUR_PICK:
				case CUR_LENS:
				case CUR_SPAWN:
				case CUR_ISOLATE:
				case CUR_ZAP:
				case CUR_CARRY:
					if (lensflag && fullscreenlensflag)
						break;
					if (CAstretchflag && wParam != CUR_PICK)
						break; // Only allow pick cursor
						// with fullscreen CA.
					SetClassWord(hwnd, GCW_HCURSOR,
						LoadCursor(hInst,MAKEINTRESOURCE(wParam)));
					// if turning CUR_CARRY off and carryflag, need
					// to reset the motiontype of the editbug
					if (cursormode == CUR_CARRY &&
						wParam != CUR_CARRY && carryflag)
					{
						carryflag = 0;
						bugmemory( hwnd, LOCK);
						installmotiontype(Bug[editbugid]);
						bugmemory( hwnd, UNLOCK);
					}
					cursormode = wParam;
					for (n=CUR_PICK; n<= CUR_CARRY; n++)
						CheckMenuItem( GetMenu(hwnd), (WORD)n,
							MF_BYCOMMAND | MF_UNCHECKED);
					CheckMenuItem( GetMenu(hwnd), cursormode,
						MF_BYCOMMAND | MF_CHECKED);
					break;

				case LENS_OFF:
					if (lensflag)
					{
						lensflag = 0;
						InvalidateRect (hwnd, NULL, TRUE);
					}
					CheckMenuItem( GetMenu(hwnd), LENS_OFF,
						MF_BYCOMMAND | MF_CHECKED);
					CheckMenuItem( GetMenu(hwnd), LENS_ON,
						MF_BYCOMMAND | MF_UNCHECKED);
					break;

				case LENS_ON:
					if (CAstretchflag)
						break;
			// Same as LBUTTON in lenscursor case, only here we
			// use whatever is in lensx, lensy

		// Make sure lens is all onscreen, and scroll towards pick.
					if (lensx < lens_dx/2)
					{
						SendMessage(hwnd, WM_HSCROLL, SB_LINEUP, 0L);
						lensx = lens_dx/2;
					}
					if (lensy < lens_dy/2)
					{
						SendMessage(hwnd, WM_VSCROLL, SB_LINEUP, 0L);
						lensy = lens_dy/2;
					}
					if (lensx > cxClient - (lens_dx/2))
					{
						SendMessage(hwnd, WM_HSCROLL,
							SB_LINEDOWN, 0L);
						lensx = cxClient - (lens_dx/2);
					}
					if (lensy > cyClient - (lens_dy/2))
					{
						SendMessage(hwnd, WM_VSCROLL,
							SB_LINEDOWN, 0L);
						lensy = cyClient - (lens_dy/2);
					}
					lensrect.left = lensx - (lens_dx / 2);
					lensrect.right = lensx + (lens_dx / 2 );
					lensrect.top = lensy - (lens_dy / 2 );
					lensrect.bottom = lensy + (lens_dy / 2 );
					prelensx = XWRAP(lensx + WinOrgX);
					prelensy =  YWRAP(lensy + WinOrgY);
					if (lensflag) // Clear if already was a lens.
						InvalidateRect (hwnd, NULL, TRUE);
					lensflag = 1;
					CheckMenuItem( GetMenu(hwnd), LENS_OFF,
						MF_BYCOMMAND | MF_UNCHECKED);
					CheckMenuItem( GetMenu(hwnd), LENS_ON,
						MF_BYCOMMAND | MF_CHECKED);
//make lens cursor
					if (cursormode != CUR_LENS)
					{
					if (cursormode == CUR_CARRY)
					{
						// Stop dragging old guy .
						carryflag = 0;
						bugmemory( hwnd, LOCK);
						installmotiontype(Bug[editbugid]);
						bugmemory( hwnd, UNLOCK);
					}
						SetClassWord(hwnd, GCW_HCURSOR,
						LoadCursor(hInst,MAKEINTRESOURCE(CUR_LENS)));
						cursormode = CUR_LENS;
						for (n=CUR_PICK; n<= CUR_CARRY; n++)
							CheckMenuItem( GetMenu(hwnd), (WORD)n,
								MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem( GetMenu(hwnd), cursormode,
							MF_BYCOMMAND | MF_CHECKED);
					}
					break;

				case LENS_SMALLER:
				case LENS_BIGGER:
				case LENS_FULLSCREEN:
				case LENS_WEAKER:
				case LENS_STRONGER:
					if (CAstretchflag)
						break; // doesn't go
/* Just do this for LENS_FULLSCREEN
					if (cursormode != CUR_LENS)
					{
						SetClassWord(hwnd, GCW_HCURSOR,
						LoadCursor(hInst,MAKEINTRESOURCE(CUR_LENS)));
						cursormode = CUR_LENS;
						for (n=CUR_PICK; n<= CUR_CARRY; n++)
							CheckMenuItem( GetMenu(hwnd), (WORD)n,
								MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem( GetMenu(hwnd), cursormode,
							MF_BYCOMMAND | MF_CHECKED);
					}
*/
					switch (wParam)
					{
						case LENS_SMALLER:
							lens_dx -= LENS_STEP;
							if (lens_dx < MIN_LENSEDGE)
								lens_dx = MIN_LENSEDGE;
							lens_dy -= LENS_STEP;
							if (lens_dy < MIN_LENSEDGE)
								lens_dy = MIN_LENSEDGE;
							// Make it square
							if (lens_dx < lens_dy)
								lens_dy = lens_dx;
							else
								lens_dx = lens_dy;
							lensrect.left = lensx - (lens_dx / 2);
							lensrect.right = lensx + (lens_dx / 2 );
							lensrect.top = lensy - (lens_dy / 2 );
							lensrect.bottom = lensy + (lens_dy / 2 );
							prelensx = XWRAP(lensx + WinOrgX);
							prelensy =  YWRAP(lensy + WinOrgY);
							if (lensflag) // Clear if already a lens.
								InvalidateRect (hwnd, NULL, TRUE);
							break;
						case LENS_BIGGER:
							lens_dx += LENS_STEP;
							if (lens_dx > cxClient)
								lens_dx = cxClient;
							lens_dy += LENS_STEP;
							if (lens_dy > cyClient)
								lens_dy = cyClient;
							lensrect.left = lensx - (lens_dx / 2);
							lensrect.right = lensx + (lens_dx / 2 );
							lensrect.top = lensy - (lens_dy / 2 );
							lensrect.bottom = lensy + (lens_dy / 2 );
							prelensx = XWRAP(lensx + WinOrgX);
							prelensy =  YWRAP(lensy + WinOrgY);
							if (lensflag) // Clear if already a lens.
								InvalidateRect (hwnd, NULL, TRUE);
							break;
						case LENS_FULLSCREEN:
							fullscreenlensflag ^= 1;
							CheckMenuItem( GetMenu(hwnd),
								LENS_FULLSCREEN, MF_BYCOMMAND | 
								(fullscreenlensflag ?
								MF_CHECKED:MF_UNCHECKED));
							if (fullscreenlensflag)
							{
					if (cursormode != CUR_LENS)
					{
					if (cursormode == CUR_CARRY)
					{
						// Stop dragging old guy .
						carryflag = 0;
						bugmemory( hwnd, LOCK);
						installmotiontype(Bug[editbugid]);
						bugmemory( hwnd, UNLOCK);
					}
						SetClassWord(hwnd, GCW_HCURSOR,
						LoadCursor(hInst,MAKEINTRESOURCE(CUR_LENS)));
						cursormode = CUR_LENS;
						for (n=CUR_PICK; n<= CUR_CARRY; n++)
							CheckMenuItem( GetMenu(hwnd), (WORD)n,
								MF_BYCOMMAND | MF_UNCHECKED);
						CheckMenuItem( GetMenu(hwnd), cursormode,
							MF_BYCOMMAND | MF_CHECKED);
					}
								old_lens_dx = lens_dx;
								old_lens_dy = lens_dy;
								lens_dx = cxClient;
								lens_dy = cyClient;
								lensx = cxClient / 2;
								lensy = cyClient / 2;
								lensrect.left = 0;
								lensrect.right = lens_dx;
								lensrect.top = 0;
								lensrect.bottom = lens_dy ;
								prelensx = XWRAP(lensx + WinOrgX);
								prelensy =  YWRAP(lensy + WinOrgY);
								lensflag = 1;
					CheckMenuItem( GetMenu(hwnd), LENS_OFF,
						MF_BYCOMMAND | MF_UNCHECKED);
					CheckMenuItem( GetMenu(hwnd), LENS_ON,
						MF_BYCOMMAND | MF_CHECKED);
							}
							else
							{
								lens_dx = old_lens_dx;
								lens_dy = old_lens_dy;
								lensrect.left = lensx -
									(lens_dx / 2);
								lensrect.right =
									lensx + (lens_dx / 2 );
								lensrect.top =
									lensy - (lens_dy / 2 );
								lensrect.bottom =
									lensy + (lens_dy / 2 );
								prelensx = XWRAP(lensx + WinOrgX);
								prelensy =  YWRAP(lensy + WinOrgY);
								if (lensflag) // Clear.
									InvalidateRect (hwnd,
									NULL, TRUE);
							}
							break;
						case LENS_WEAKER:
							if (stretchfactor == 3)
								stretchfactor = 2;
							else if (stretchfactor == 4)
								stretchfactor = 3;
							else if (stretchfactor > 4) // Minimum is 2
								stretchfactor/= 2;
//							InvalidateRect (hwnd, NULL, TRUE);
							// Clear the screen, but not the bitmap
							break;
						case LENS_STRONGER:
							if (stretchfactor == 3)
								stretchfactor = 4;
							else if (stretchfactor == 2)
								stretchfactor = 3;
							else if (stretchfactor < 16) // Maximum is 16
								stretchfactor *= 2;
//							InvalidateRect (hwnd, NULL, TRUE);
							// Clear the screen, but not the bitmap
							break;
					}
					break;

				case IDM_HELP:
					WinHelp(hwnd, (LPSTR)"BUG.HLP", HELP_CONTEXT,
						MAIN);
					break;

				case IDM_HELPHELP:
					WinHelp(hwnd,"WINHELP.HLP",HELP_INDEX,0L);
					break;

				case IDM_CONTROLS:
					WinHelp(hwnd, (LPSTR)"CONTROLS.HLP", HELP_CONTEXT,
						MAIN);
					break;

				case IDM_PAPER:
					WinHelp(hwnd, (LPSTR)"PAPER.HLP", HELP_CONTEXT,
						MAIN);
					break;

				case IDM_CONTACT:
					WinHelp(hwnd, (LPSTR)"CONTACT.HLP", HELP_CONTEXT,
						MAIN);
					break;

				case IDM_SCORE:
					if (!hDlgScore)
                  {
						hDlgScore = CreateDialog(
							hInst, (LPSTR)"SCORE", hwnd, lpitProcScore );
                  GetWindowRect(hDlgScore, &rect);
                  rect.bottom-=rect.top;
                  rect.right-=rect.left;
                  rect.left = (int)GetProfileInt((LPSTR)szAppName,(LPSTR)"ScoreX",100);
                  rect.top = (int)GetProfileInt((LPSTR)szAppName,(LPSTR)"ScoreY",100);
                  if (GetSystemMetrics(SM_CXSCREEN)<rect.left-10)
                     rect.left=75;
                  if (GetSystemMetrics(SM_CYSCREEN)<rect.top-10)
                     rect.top=25;
                  MoveWindow(hDlgScore, rect.left,rect.top,rect.right,rect.bottom,FALSE);
                  ShowWindow(hDlgScore, TRUE);
                  }
               else
				  DestroyWindow(hDlgScore);
			   CheckMenuItem( GetMenu(hwnd),IDM_SCORE,MF_BYCOMMAND |
			   	  (hDlgScore?MF_CHECKED:MF_UNCHECKED));

					break;

				case IDM_ABOUT:
					bugmemory( hwnd, LOCK);
					lpitProc = MakeProcInstance(
						(FARPROC)AboutProc, hInst );
					DialogBox(
						hInst, (LPSTR)"ABOUT", hwnd, lpitProc );
					FreeProcInstance( (FARPROC)lpitProc );
					bugmemory( hwnd, UNLOCK);
					break;


				default:
//					bugmemory( hwnd, LOCK);
//					MessageBox(
//						hwnd, (LPSTR)"Feature Not Yet Implemented",
//						(LPSTR)"Later!",
//						MB_OK | MB_ICONEXCLAMATION );
//					bugmemory( hwnd, UNLOCK);
					break;
			}
			return 0;

		case WM_CLOSE:
		case WM_DESTROY:
			switch ( MessageBox( hwnd,
				(LPSTR)"Save Current Parameters And Genes?",
				(LPSTR)"Ready To Exit Boppers",
				MB_YESNOCANCEL ) )
			{
				case IDCANCEL:
					return 0;

				case IDYES:
					bugmemory( hwnd, LOCK);
					writeworld("ACTIVE.BEX");
					bugmemory( hwnd, UNLOCK);
					// drop down to IDNO case.

				case IDNO:
				default:
					CloseSound();
					WinHelp(hwnd, (LPSTR)"BUG.HLP", HELP_QUIT, 0);
#ifdef TIMER
					if (timerflag && !stepflag)
						KillTimer(hwnd, 1);
#endif //TIMER
				// You must not delete a device context while any bitmap other
				// than the context's original bitmap is selected.
				// SDK Guide 11-11.
					SelectObject(hdcBugLand, hBitmapBugLandOld);
					DeleteDC(hdcBugLand);
					DeleteObject(hBitmapBugLand);
					if (!CAloaded)
						DeleteDC(hdcCALand);
					else
					{
						SelectObject(hdcCALand, hBitmapCALandOld);
						DeleteDC(hdcCALand);
						DeleteObject(hBitmapCALand);
					}

					for (i=0; i < BODY_COUNT_2D; i++)
					{
						SelectObject(hdcBugBody_2D[i], hBitmapBodyOld_2D[i]);
						DeleteDC(hdcBugBody_2D[i]);
						DeleteObject(hBitmapBugBody_2D[i]);
						DeleteObject(hBitmapBodyOld_2D[i]);
					}
					for (i=0; i < BODY_COUNT_3D; i++)
					{
						SelectObject(hdcBugBody_3D[i], hBitmapBodyOld_3D[i]);
						DeleteDC(hdcBugBody_3D[i]);
						DeleteObject(hBitmapBugBody_3D[i]);
						DeleteObject(hBitmapBodyOld_3D[i]);
					}
					// Write profile strings
					wsprintf((LPSTR)buf,"%u",randomizermask);
					WriteProfileString((LPSTR)szAppName,
						(LPSTR)"Randomizer Mask",(LPSTR)buf);
					wsprintf((LPSTR)buf,"%u",background_color);
					WriteProfileString((LPSTR)szAppName,
						(LPSTR)"White Background",(LPSTR)buf);

					// Kill modeless procedures
					if (hDlgScore)
					{
//						WriteProfileString((LPSTR)szAppName,
//							(LPSTR)"Score",(LPSTR)"Y");
						DestroyWindow( hDlgScore);
						hDlgScore = 0; // Turn off modeless handle
					}
//					else
//						WriteProfileString((LPSTR)szAppName,
//							(LPSTR)"Score",(LPSTR)"N");
					FreeProcInstance( (FARPROC)lpitProcScore );

					if (hDlgShape)
					{
						DestroyWindow( hDlgShape);
						hDlgShape = 0;
					}
					FreeProcInstance( (FARPROC)lpitProcShape );


					if (hDlgGene)
					{
						DestroyWindow( hDlgGene);
						hDlgGene = 0;
					}
					FreeProcInstance( (FARPROC)lpitProcGene );

					if (hDlgGraph)
					{
						DestroyWindow( hDlgGraph);
						hDlgGraph = 0;
					}
					FreeProcInstance( (FARPROC)lpitProcGraph );

					if (hDlgSound)
					{
						DestroyWindow( hDlgSound);
						hDlgSound = 0;
					}
					FreeProcInstance( (FARPROC)lpitProcSound );

					if (hDlgColony)
					{
						DestroyWindow( hDlgColony);
						hDlgColony = 0;
					}
					FreeProcInstance( (FARPROC)lpitProcColony );

					if (hDlgEcology)
					{
						DestroyWindow( hDlgEcology);
						hDlgEcology = 0; // Turn off modeless handle
					}
					FreeProcInstance( (FARPROC)lpitProcEcology );

					bugmemory( hwnd, FREE);
					PostQuitMessage (0) ;
					return 0 ;
					// end WM_DESTROY IDNO case
			}// end WM_DESTROY
	}
	// Default
	return DefWindowProc (hwnd, message, wParam, lParam) ;
	// This is the Default Window message Processor.
}

/*-----------------------------------------Bug Functions---------*/


void near bugmemory(HWND hwnd, unsigned char memoryfunction)
{ //bug.cpp
//leak
	unsigned char i, failure = 0;
		// failure 1 for LocalAlloc, 2 for GlobalAlloc, 3 for
		// LocalLock, 4 for GlobalLock.
	static int count = 1;
		// Count of current bug.  Eventually use this in fail message
		// to say WHICH bug you ran out of memory on.
	static locked = 0;
		// Increment with LOCK, decrement with UNLOCK.
	static int Zbuff_locked = 0, CAbuff_locked = 0;
		// Never lock more than one at once -- to lighten memory demand.
	static int trail_loop_locked = 0, colony_trail_loop_locked = 0;
		// Never lock more than one at once -- to lighten memory demand.
	static unsigned char allocated = 0;
		// Set with ALLOCATE, reset with FREE.
	static unsigned char Zbuff_allocated = 0, CAbuff_allocated = 0,
		trail_loop_allocated = 0, colony_trail_loop_allocated = 0;
		// Use in SWAP 
	static HANDLE TrailLoopHandle, ColonyTrailLoopHandle[MAXCOLONIES],
		ZBufferHandle,
		BugHandle[MAXBUGS],
#ifndef MWC
		Bugcolorgene0Handle[MAXBUGS],
		Bugcolorgene1Handle[MAXBUGS],
#else
		BugcolorgeneHandle[MAXBUGS],
#endif //MWC
		BugdirgeneHandle[MAXBUGS],
		BugstategeneHandle[MAXBUGS],
		BugnearpreygeneHandle[MAXBUGS],
		BugnearpredgeneHandle[MAXBUGS],
		BugDNAHandle[MAXBUGS],
		BugmetricHandle[MAXBUGS],
		BugmetricsquaredHandle[MAXBUGS],
		BugtoHandle[MAXBUGS],
		BugdirfreqHandle[MAXBUGS],
		ScoreHistoryHandle;

	static HANDLE CAbuffer0Handle,
		CAbuffer1Handle;

	switch(memoryfunction)
	{
		case SWAP: //Assume everything is unlocked
			if (three_d_flag)
			{
				if (CAbuff_allocated)
				{
					GlobalFree( CAbuffer0Handle );
					GlobalFree( CAbuffer1Handle );
					CAbuff_allocated = 0;
				}
				if (colony_trail_loop_allocated)
				{
					for (i=0; i<MAXCOLONIES; i++)
						GlobalFree( ColonyTrailLoopHandle[i] );
					colony_trail_loop_allocated = 0;
				}
				if (!Zbuff_allocated)
				{
					if ( !( ZBufferHandle = GlobalAlloc(
						GMEM_MOVEABLE,
						BugLand_SIZEOF * sizeof(short) ) ) )
						{failure = 2; break;}
					Zbuff_allocated = 1;
				}
				if (!trail_loop_allocated)
				{
					if ( !( TrailLoopHandle = GlobalAlloc(
						GMEM_MOVEABLE,(DWORD)(
						MAXTRAILLENGTH * (unsigned long)
						sizeof(struct trailrecord_3D) ) ) ) )
						{failure = 2; break;}
					trail_loop_allocated = 1;
				}
			}
			else //2D case
			{
				if (Zbuff_allocated)
				{
					GlobalFree( ZBufferHandle );
					Zbuff_allocated = 0;
				}
				if (trail_loop_allocated)
				{
					GlobalFree( TrailLoopHandle );
					trail_loop_allocated = 0;
				}
				if (!colony_trail_loop_allocated)
				{
					for (i=0; i<MAXCOLONIES; i++)
						if ( !( ColonyTrailLoopHandle[i] = GlobalAlloc(
							GMEM_MOVEABLE,(DWORD)(
							COLONY_MAXTRAILLENGTH *(unsigned long)
								sizeof(struct trailrecord_2D)) ) ) )
							{failure = 2; break;}
					colony_trail_loop_allocated = 1;
				}
				if (!CAbuff_allocated)
				{
					if ( !( CAbuffer0Handle = GlobalAlloc(
						GMEM_MOVEABLE,
						MAX_CALand_SIZEOF * sizeof(unsigned char) ) ) )
						{failure = 2; break;}
					if ( !( CAbuffer1Handle = GlobalAlloc(
						GMEM_MOVEABLE,
						MAX_CALand_SIZEOF * sizeof(unsigned char) ) ) )
						{failure = 2; break;}
					CAbuff_allocated = 1;
				}
			}
			break;
	
		case ALLOCATE:
			if ( !( ScoreHistoryHandle = GlobalAlloc(
				GMEM_MOVEABLE, SCORE_HISTORY_LENGTH *
				sizeof( struct score_record) ) ) )
				{failure = 2; break;}
			if (three_d_flag)
			{
				if ( !( ZBufferHandle = GlobalAlloc(
					GMEM_MOVEABLE,
					BugLand_SIZEOF * sizeof(short) ) ) )
					{failure = 2; break;}
				Zbuff_allocated = 1;
				if ( !( TrailLoopHandle = GlobalAlloc(
					GMEM_MOVEABLE,(DWORD)(
					MAXTRAILLENGTH * (unsigned long)
					sizeof(struct trailrecord_3D)) ) ) )
					{failure = 2; break;}
				trail_loop_allocated = 1;
			} //end 3D case
			else //2D
			{
				for (i=0; i<MAXCOLONIES; i++)
					if ( !( ColonyTrailLoopHandle[i] = GlobalAlloc(
						GMEM_MOVEABLE,(DWORD)(
						COLONY_MAXTRAILLENGTH *(unsigned long)
							sizeof(struct trailrecord_2D)) ) ) )
						{failure = 2; break;}
				colony_trail_loop_allocated = 1;
	//Go ahead and allocate the CA room in the 2D case.
				if ( !( CAbuffer0Handle = GlobalAlloc(
					GMEM_MOVEABLE,
					MAX_CALand_SIZEOF * sizeof(unsigned char) ) ) )
					{failure = 2; break;}
				if ( !( CAbuffer1Handle = GlobalAlloc(
					GMEM_MOVEABLE,
					MAX_CALand_SIZEOF * sizeof(unsigned char) ) ) )
					{failure = 2; break;}
				CAbuff_allocated = 1;
			} //end 2D case


//Do the following in 3D or in 2D.

			for (i=0; i<MAXBUGS; i++)
			{
				count++;
				if ( !( BugHandle[i] = LocalAlloc(
					LMEM_MOVEABLE,
					sizeof( struct bug ) ) ) )
					{failure = 1; break;}
#ifndef MWC
				if ( !( Bugcolorgene0Handle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * sizeof(char) ) ) )
					{failure = 2; break;}
				if ( !( Bugcolorgene1Handle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * sizeof(char) ) ) )
					{failure = 2; break;}
#else
				if ( !( BugcolorgeneHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * CASECOUNT * sizeof(char) ) ) )
					{failure = 2; break;}
#endif //MWC
				if ( !( BugdirgeneHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * CASECOUNT *
					sizeof(unsigned char) ) ) )
					{failure = 2; break;}
				if ( !(BugstategeneHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * CASECOUNT *
					sizeof(unsigned char) ) ) )
					{failure = 2; break;}
				if ( !(BugnearpreygeneHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * 
					sizeof(unsigned char) ) ) )
					{failure = 2; break;}
				if ( !(BugnearpredgeneHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXSTATES * 
					sizeof(unsigned short) ) ) )
					{failure = 2; break;}
				if ( !(BugDNAHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					DNALENGTH *
					sizeof(unsigned char) ) ) )
					{failure = 2; break;}
				if ( !(BugmetricHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXBUGS *
					sizeof(Real) ) ) )
					{failure = 2; break;}
				if ( !(BugmetricsquaredHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXBUGS *
					sizeof(Real) ) ) )
					{failure = 2; break;}
				if ( !(BugtoHandle[i] = LocalAlloc(
					GMEM_MOVEABLE,
					MAXBUGS *
					sizeof(CyVector3) ) ) )
					{failure = 1; break;}
				if ( !(BugdirfreqHandle[i] = GlobalAlloc(
					GMEM_MOVEABLE,
					MAXDIRS *
					sizeof(unsigned short) ) ) )
					{failure = 2; break;}
			} // End of MAXBUGS loop

			// Now we allocate some local memory as LPTR for the
			// CALand bmapinfoheader.  Note that LPTR is LMEM_FIXED |
			// LMEM_ZEROINIT.  Note also that when memory is allocated
			// this way the handle already IS a pointer, so we don't
			// need to LOCK and UNLOCK this guy.

			// We need to allocate the palette room for by hand as
			// BITMAPINFO only has built-in room for bmiColors[1].
			if ( !(lpbmiCALand = (LPBITMAPINFO)( LocalLock(
				LocalAlloc(LPTR, sizeof(BITMAPINFOHEADER) +
				( 256 * sizeof(RGBQUAD) ) ) ) ) ) )
				{failure = 2; break;}

			allocated = 1;
			break; //End of ALLOCATE

		case LOCK:
			if (locked)
				break;
			if (!allocated)
				bugmemory(hwnd, ALLOCATE);

			if ( !( score_history = (struct score_record FAR *)
				GlobalLock( ScoreHistoryHandle) ) )
				{failure = 4; break;}

			if (trail_loop_allocated)
			{
				if ( !( trail_loop = (struct trailrecord_3D huge *)
					GlobalLock( TrailLoopHandle ) ) )
					{failure = 4; break;}
				trail_loop_locked = 1;
			}

			if (colony_trail_loop_allocated)
			{
				for (i=0; i<MAXCOLONIES; i++)
					if ( !( colony_trail_loop[i] =
						(struct trailrecord_2D huge *)
						GlobalLock( ColonyTrailLoopHandle[i] ) ) )
						{failure = 4; break;}
				colony_trail_loop_locked = 1;
			}

			if (Zbuff_allocated)
			{
				if ( !( zbuffer = (unsigned short huge *)
					GlobalLock( ZBufferHandle ) ) )
					{failure = 4; break;}
				Zbuff_locked = 1;
			}
			if (CAbuff_allocated)
			{
#ifndef SMALL_CA
				if ( !( CAbuffer0 = (unsigned char huge *)
					GlobalLock( CAbuffer0Handle ) ) )
					{failure = 4; break;}
				if ( !( CAbuffer1 = (unsigned char huge *)
					GlobalLock( CAbuffer1Handle ) ) )
					{failure = 4; break;}
#else
				if ( !( CAbuffer0 = (unsigned char FAR *)
					GlobalLock( CAbuffer0Handle ) ) )
					{failure = 4; break;}
				if ( !( CAbuffer1 = (unsigned char FAR *)
					GlobalLock( CAbuffer1Handle ) ) )
					{failure = 4; break;}
#endif //SMALL_CA
		// Set the read and write buffers according to the CAparity
				if (!CAparity)
				{
					Read_buffer = CAbuffer0;
					Write_buffer = CAbuffer1;
				}
				else
				{
					Read_buffer = CAbuffer1;
					Write_buffer = CAbuffer0;
				}
				CAbuff_locked = 1;
			}
			for (i=0; i<MAXBUGS; i++)
			{
				count++;
				if ( !(Bug[i] = (struct bug *)LocalLock(
					BugHandle[i] ) ) )
					{failure = 3; break;};
#ifndef MWC
				if ( !( Bug[i]->writecolorgene0 = (unsigned char FAR *)
					GlobalLock( Bugcolorgene0Handle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->writecolorgene1 = (unsigned char FAR *)
					GlobalLock( Bugcolorgene1Handle[i] ) ) )
					{failure = 4; break;}
#else
				if ( !( Bug[i]->writecolorgene = (unsigned char FAR *)
					GlobalLock( BugcolorgeneHandle[i] ) ) )
					{failure = 4; break;}
#endif //MWC
				if ( !( Bug[i]->dirgene = (unsigned char FAR *)
					GlobalLock( BugdirgeneHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->stategene =
					(unsigned char FAR *)
					GlobalLock( BugstategeneHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->nearpreygene =
					(unsigned char FAR *)
					GlobalLock( BugnearpreygeneHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->nearpredgene =
					(unsigned short FAR *)
					GlobalLock( BugnearpredgeneHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->DNA =
					(unsigned char FAR *)
					GlobalLock( BugDNAHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->metric =
					(Real FAR *)
					GlobalLock( BugmetricHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->metricsquared =
					(Real FAR *)
					GlobalLock( BugmetricsquaredHandle[i] ) ) )
					{failure = 4; break;}
				if ( !( Bug[i]->to =
					(CyVector3 FAR *)
					LocalLock( BugtoHandle[i] ) ) )
					{failure = 3; break;}
				if ( !( Bug[i]->dirfreq =
					(unsigned short FAR *)
					GlobalLock( BugdirfreqHandle[i] ) ) )
					{failure = 4; break;}
			} // End of MAXBUGS loop

			locked++;

			break; // End of LOCK

		case UNLOCK:
			if (!locked)
				break;

			GlobalUnlock( ScoreHistoryHandle);

			if (trail_loop_locked)
			{
				GlobalUnlock( TrailLoopHandle );
				trail_loop_locked = 0;
			}
			if (colony_trail_loop_locked)
			{
				for (i=0; i<MAXCOLONIES; i++)
					GlobalUnlock( ColonyTrailLoopHandle[i] );
				colony_trail_loop_locked = 0;
			}
			if (Zbuff_locked)
			{
				GlobalUnlock( ZBufferHandle );
				Zbuff_locked = 0;
			}
			if (CAbuff_locked)
			{
				GlobalUnlock( CAbuffer0Handle );
				GlobalUnlock( CAbuffer1Handle );
				CAbuff_locked = 0;
			}
			for (i=0; i<MAXBUGS; i++)
			{
				LocalUnlock( BugHandle[i] );
#ifndef MWC
				GlobalUnlock( Bugcolorgene0Handle[i] );
				GlobalUnlock( Bugcolorgene1Handle[i] );
#else
				GlobalUnlock( BugcolorgeneHandle[i] );
#endif //MWC
				GlobalUnlock( BugdirgeneHandle[i] );
				GlobalUnlock( BugstategeneHandle[i] );
				GlobalUnlock( BugnearpreygeneHandle[i] );
				GlobalUnlock( BugnearpredgeneHandle[i] );
				GlobalUnlock( BugDNAHandle[i] );
				GlobalUnlock( BugmetricHandle[i] );
				GlobalUnlock( BugmetricsquaredHandle[i] );
				LocalUnlock( BugtoHandle[i] );
				GlobalUnlock( BugdirfreqHandle[i] );
			} // End of MAXBUGS loop

			locked--;
			break; //End of UNLOCK

		case FREE:
			while (locked)
				bugmemory(hwnd, UNLOCK);
			GlobalFree( ScoreHistoryHandle );
			if (trail_loop_allocated)
				GlobalFree( TrailLoopHandle );
			if (colony_trail_loop_allocated)
				for (i=0; i<MAXCOLONIES; i++)
					GlobalFree( TrailLoopHandle );
			if (Zbuff_allocated)
				GlobalFree( ZBufferHandle );
			if (CAbuff_allocated)
			{
				GlobalFree( CAbuffer0Handle );
				GlobalFree( CAbuffer1Handle );
			}
			for (i=0; i<MAXBUGS; i++)
			{
				LocalFree( BugHandle[i] );
#ifndef MWC
				GlobalFree( Bugcolorgene0Handle[i] );
				GlobalFree( Bugcolorgene1Handle[i] );
#else
				GlobalFree( BugcolorgeneHandle[i] );
#endif //MWC
				GlobalFree( BugdirgeneHandle[i] );
				GlobalFree( BugstategeneHandle[i] );
				GlobalFree( BugnearpreygeneHandle[i] );
				GlobalFree( BugnearpredgeneHandle[i] );
				GlobalFree( BugDNAHandle[i] );
				GlobalFree( BugmetricHandle[i] );
				GlobalFree( BugmetricsquaredHandle[i] );
				LocalFree( BugtoHandle[i] );
				GlobalFree( BugdirfreqHandle[i] );
			} // End of MAXBUGS loop

			// Cast the shortcut allocation guys back to near 
			// and then back to handle.  Petz. p. 300.
			LocalFree((LOCALHANDLE)((char NEAR *)lpbmiCALand));
		
			allocated = 0;
			break; // End of FREE

	} // End of memoryfunction switch

	if ( !failure )
		return;
	else
	{
		switch (failure)
		{
			case 1:
				MessageBox( hwnd,
					(LPSTR)"Failure in LocalAlloc!",
					(LPSTR)"Memory Problems!",
					MB_OK | MB_ICONEXCLAMATION );
				break;

			case 2:
				MessageBox( hwnd,
					(LPSTR)"Failure in GlobalAlloc!",
					(LPSTR)"Memory Problems!",
					MB_OK | MB_ICONEXCLAMATION );
				break;

			case 3:
				MessageBox( hwnd,
					(LPSTR)"Failure in LocalLock!",
					(LPSTR)"Memory Problems!",
					MB_OK | MB_ICONEXCLAMATION );
				break;

			case 4:
				MessageBox( hwnd,
					(LPSTR)"Failure in GlobalLock!",
					(LPSTR)"Memory Problems!",
					MB_OK | MB_ICONEXCLAMATION );
				break;
		}
		SendMessage( hwnd, WM_DESTROY, 0, 0L );
	}
}
//-------------Clear &  Blts----------------------------

void near BugLandClear(void)
{ //bug.cpp
	long i;
	unsigned char k,j;
	HBRUSH blankbrush, oldbrush;

    //blankmark
	blankbrush = CreateSolidBrush(blankcolor);
	oldbrush = SelectObject(hdcBugLand, blankbrush);
	PatBlt(hdcBugLand, 0, 0, BugLand_CX, BugLand_CY, PATCOPY);
	DeleteObject(SelectObject(hdcBugLand, oldbrush));
	foodsupply = 0;
	poisonsupply = 0;
	trailfull = 0; //3D trail, do always to be safe
	trailindex = 0; //3D trail
	for (j=0; j<MAXCOLONIES; j++) //2D trails, do always to be safe
	{
		colony_trailfull[j] = 0;
		colony_trailindex[j] = 0;
	}
	if (three_d_flag) //Only bother doing this if 3D
	{
		for (i=0; i < BugLand_SIZEOF; i++)
			zbuffer[i] = NONINDEX;
	}
	for (j = 0; j<MAXBUGS; j++)
		for (k=0; k<MAXBUGS; k++)
			hittable[k][j] = 0;
}

void near BugLandBlt(HDC hdc)
{ //bug.cpp
	short SourceTX, SourceTY, TargetTX, TargetTY;

	if ( (WinOrgX == 0) && (WinOrgY == 0) )
		BitBlt(hdc, 0, 0, cxClient, cyClient,
			hdcBugLand, 0, 0, SRCCOPY);
	
	else // Break in four and reassemble.
	{

	// (WinOrgX, WinOrgY) is the corner where the window looks into
	// BugLand.

	//  Think of SOURCE		and				TARGET
	//		(1)   |(2) 					(4) |(3)   
	//		      |    					----T------
	//		------T----					(2) |(1)   
	//		(3)   |(4) 					    |      
	//	T at (SourceTX,				T at (TargetTX,
	//		SourceTY)						TargetTY)
	// If Source is (0,0), then there shouldn't even be a target,
	// it's all region (4), so that means target should be
	// BugLand_CX,BugLand_CY in this case.

		SourceTX = WinOrgX;
		SourceTY = WinOrgY;
		TargetTX = BugLand_CX - WinOrgX;
		TargetTY = BugLand_CY - WinOrgY;

		BitBlt(hdc, 0, 0,
			((cxClient<TargetTX)?cxClient:TargetTX),
			((cyClient<TargetTY)?cyClient:TargetTY),
			hdcBugLand, SourceTX, SourceTY, SRCCOPY);	//(4)
		BitBlt(hdc, TargetTX, 0,
			((cxClient>TargetTX)?(cxClient-TargetTX):0),
			((cyClient<TargetTY)?cyClient:TargetTY),
			hdcBugLand, 0, SourceTY, SRCCOPY);			//(3)
		BitBlt(hdc, 0, TargetTY,
			((cxClient<TargetTX)?cxClient:TargetTX),
			((cyClient>TargetTY)?(cyClient-TargetTY):0),
			hdcBugLand, SourceTX, 0, SRCCOPY);			//(2)
		BitBlt(hdc, TargetTX, TargetTY,
			((cxClient>TargetTX)?(cxClient-TargetTX):0),
			((cyClient>TargetTY)?(cyClient-TargetTY):0),
			hdcBugLand, 0, 0, SRCCOPY);		//(1)
	}
}

//-----------Change positions-(with BugBodyBlt maintenance)---
// Note, randomizepositions and cornerbugs need to be in the same module
// as BugBodyBlt so BugBodyBlt can keep being near.

void randomizepositions(HWND hwnd)
{ // bug.cpp and world.cpp
	HDC hdc;
	unsigned char i;

	hdc = GetDC(hwnd);
	storepositions();
	if (!mesh_size)
		mesh_size = START_MESH_SIZE;
	// Just in case an incorrect zero mesh_size was loaded from an
	// old *.bex or *.bl file.
	for (i=0; i<livebugcount; i++)
	{
		BugBodyBlt(hdc, Bug[bugnum[i]], OLDPOS);
			// Erase any old bug bodies not on lens 
		Bug[bugnum[i]]->oldx = Bug[bugnum[i]]->oldoldx =
			Bug[bugnum[i]]->x = ((short)Random(BugLand_CX)/mesh_size)* mesh_size;
		Bug[bugnum[i]]->oldy = Bug[bugnum[i]]->oldoldy =
			Bug[bugnum[i]]->y =((short)Random(BugLand_CY)/mesh_size) * mesh_size;
		Bug[bugnum[i]]->oldz = Bug[bugnum[i]]->oldoldz =
			Bug[bugnum[i]]->z = ((short)Random(BugLand_CZ)/mesh_size) *  mesh_size;
		BugBodyBlt(hdc, Bug[bugnum[i]], CURRPOS);
		Bug[bugnum[i]]->tan = Randomunitvector();
	}
	ReleaseDC(hwnd, hdc);
}

void cornerbugs(HWND hwnd)
{ // bug.cpp and world.cpp.  Uses BugBodyBlt
	HDC hdc;
	unsigned char i;

	hdc = GetDC(hwnd);
	storepositions();
	for (i=0; i<livebugcount; i++)
	{
		BugBodyBlt(hdc, Bug[bugnum[i]], OLDPOS);
			// Erase any old bug bodies not on lens 
		Bug[bugnum[i]]->oldx = Bug[bugnum[i]]->oldoldx = Bug[bugnum[i]]->x = wrapminx;
		Bug[bugnum[i]]->oldy = Bug[bugnum[i]]->oldoldy = Bug[bugnum[i]]->y = wrapmaxy;
		Bug[bugnum[i]]->oldz = Bug[bugnum[i]]->oldoldz = Bug[bugnum[i]]->z =
			(wrapminz + wrapmaxz) / 2;
		BugBodyBlt(hdc, Bug[bugnum[i]], CURRPOS);
	}
	ReleaseDC(hwnd, hdc);
}

void near makeCAworld(HWND hwnd)
{	// To used in the CA_? messages.  Assume you enter this UNLOCKed.
	// Uses bugmemory a lot, so needs to be in bug.cpp
	unsigned char i;
	HDC hdc;

	if (CAflag)
		return;
	if (three_d_flag) // First make the bugs 2D
	{
		bugmemory( hwnd, LOCK);
		three_d_flag = 0;
		for (i=0; i < livebugcount; i++)
		{
			installmotiontype(Bug[bugnum[i]]);
			installdirectiontype(Bug[bugnum[i]]);
			DNA_to_RNA(Bug[bugnum[i]]);
		}
		bugmemory(hwnd, UNLOCK);
	}
	CAflag = 2;
	bugmemory(hwnd,SWAP); // this frees Zbuff (if it was being used)
		// and sets the Read_buffer, etc. for the CA
	bugmemory(hwnd, LOCK);
	hdc = GetDC(hwnd);
	installCAtype(hdc);
	//set_CApalette(hdc, CApalette_type);
	resizeCA(hdc, 1.0);
	ReleaseDC(hwnd, hdc);
	SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
	bugmemory(hwnd, UNLOCK);
}
void near BugBodyErase_near(HDC hdc, short ex, short ey)
{	// Erase a body at ex,ey.
	// Is used in bug.cpp when smear trail is on.
	// A non-near copy of this without the _near is in shape.cpp for
	// shape.cpp and hotkey.cpp
	short x,y,prex,prey,prexplus,preyplus,
		inx,iny,outx,outy,overlap, BugBody_CX, BugBody_CY;

	if (!three_d_flag)
	{
		BugBody_CX = MAX_BugBody_2D_CX;
		BugBody_CY = MAX_BugBody_2D_CY;
	}
	else
	{
		BugBody_CX = MAX_BugBody_3D_CX;
		BugBody_CY = MAX_BugBody_3D_CY;
	}
	prex = XWRAP( ex - (BugBody_CX/2) );
	prey = YWRAP( ey - (BugBody_CY/2) );
	prexplus = prex + BugBody_CX;
	preyplus = prey + BugBody_CY;
	overlap = 0;
	if (prexplus > BugLand_MAXX)
	{
		inx = BugLand_CX - prex;
		outx = prexplus - BugLand_CX;
		overlap = 1;
	}
	if (preyplus > BugLand_MAXY)
	{
		iny = BugLand_CY - prey;
		outy = preyplus - BugLand_CY;
		overlap |= 2;
	}
	x = XWRAP(prex - WinOrgX);
	y = YWRAP(prey - WinOrgY);

	if (!( lensflag &&
		( lensrect.left<(x+BugBody_CX) ) && ( x<lensrect.right ) &&
		( lensrect.top<(y+BugBody_CY) ) && ( y<lensrect.bottom ) ) )
		// You need to check this "again" here since you
		// don't wbug to restore if the lens just got turned on.
		switch (overlap) 	// Restore underbody square
		{
			case 0: // no overlap
				BitBlt(hdc, x, y, BugBody_CX, BugBody_CY,
					hdcBugLand, prex, prey, SRCCOPY);
				break;
			case 1: // x overlap
				BitBlt(hdc, x, y, inx, BugBody_CY,
					hdcBugLand, prex, prey, SRCCOPY);
				BitBlt(hdc, x + inx, y, outx, BugBody_CY,
					hdcBugLand, 0, prey, SRCCOPY);
				break;
			case 2: // y overlap
				BitBlt(hdc, x, y, BugBody_CX, iny,
					hdcBugLand, prex, prey, SRCCOPY);
				BitBlt(hdc, x, y + iny, BugBody_CX, outy,
					hdcBugLand, prex, 0, SRCCOPY);
				break;
			case 3: // x and y overlap
				BitBlt(hdc, x, y, inx, iny,
					hdcBugLand, prex, prey, SRCCOPY);
				BitBlt(hdc, x+inx, y, outx, iny,
					hdcBugLand, 0, prey, SRCCOPY);
				BitBlt(hdc, x, y+iny, inx, outy,
					hdcBugLand, prex, 0, SRCCOPY);
				BitBlt(hdc, x + inx, y + iny, outx, outy,
					hdcBugLand, 0, 0, SRCCOPY);
				break;
		}
	// The lens is fresh from BugLand each update, so we don't 
	// need to erase anything for the on-lens case.
}
//-----------------Could leave-------

void near testhit(struct bug* bug)
{ //bug.cpp
	unsigned char i;

	for (i=0; i<livebugcount; i++)
	{
		if ( bug->bugid != bugnum[i] &&
			bug->x == Bug[bugnum[i]]->x &&
			bug->y == Bug[bugnum[i]]->y &&
			(!three_d_flag || bug->z == Bug[bugnum[i]]->z) )
			{
				hittable[bug->bugid][bugnum[i]] = 1;
				hitflag = 1;
				break;
			}
	}
}

//-------------------GrowBugs------------------

void near GrowBugs(HWND hwnd)
{
	HDC hdc;
	unsigned char i, j;
#ifdef GROWBUGS_STEPS
	unsigned char k;
#endif //GROWBUGS_STEPS

	hdc = GetDC(hwnd);
#ifdef GROWBUGS_STEPS
	for (k=0; k<GrowBugs_steps; k++)
	{ // Start of k loop of GrowBugs_steps
#endif //GROWBUGS_STEPS
		storepositions(); // oldoldx = oldx, oldx = x, etc.
		if (globalmetricflag)
			update_metric();
		LensBlt(hdc, stretchfactor);
			// fresh bodiless lens from BugLand
			// Right now x and oldx are the same.
		for (i=0; i < livebugcount; i++)
		{
			move(Bug[bugnum[i]]); // This doesn't mark BugLand, merely
			// computes and adopts the new position, state, writecolor
			// compute nonwrapx = oldx+move, x = wrap(nonwrapx).
			// also makes sound.  Carries out recruits and resets
			//  hittable.  Now x not the same as oldx.
			eat(Bug[bugnum[i]]); // eats at x
			// I do this here to be parallel.  Note that the furthest 
			// pixel gets looked at first and that at present
			//(in case square and/or line is on) the last nonblank pixel
			// seen will dominate.  Affects readorder.
		}
		if (hDlgScore)
			SendMessage( hDlgScore, WM_COMMAND, SC_UPDATE, 0L );
			//This message updates the score & icon of the editbug
			// Do this here so that the scores have been clamped by eat.
	// heart of the loop
		for (i=0; i < livebugcount; i++)
		{
			drawtrailshape(hdc, Bug[bugnum[i]]);
			// First, if square, draws pixel at oldx, then 
			// eats and draws sqaure around oldoldx. 
			// Square does NOT set readcolorcode, others do.  Next,
			// If line, eats from oldx to x (excluding x & oldx),
			// and draws from oldx up to x (excluding x).
			// If pixel, draws at oldx.
			// Erases the old headpixel.
			// Maintains trail and erases old smearbodies.
#ifdef BODY_JAM
		}
		for (i=0; i < livebugcount; i++)
		{
#endif //BODY_JAM
			headpixel(hdc,Bug[bugnum[i]]); // Draws at x.
			if (Bug[bugnum[i]]->bugbodyflag != 2) // Non smear
				BugBodyBlt(hdc, Bug[bugnum[i]], OLDPOS);
			// erase body at oldoldx. (if not on lens)
			BugBodyBlt(hdc, Bug[bugnum[i]], CURRPOS);
			// Write new bug bodies at oldx, also write 'em on lens
		}
		//colony breeding loop
		for (i=0; i<colonycount; i++)
		{
			day[i]++;
			if ( day[i] >= Colony[i].breedtime && Colony[i].pop &&
				Colony[i].breedflag &&
				!hDlgGene && !hDlgShape && !isolatedflag )
			// don't breed if a bug is isolated.
			//don't breed if you're busy with the Shape or Gene windows
			// as their info is changed by a breed.
			{
				checkmotion(&(Colony[i]));
				checkentropy(&(Colony[i]));
				census(&(Colony[i]));
				(Colony[i].breed)(&(Colony[i]));
				day[i] = 0;
				did_breed = 1; 
			}
		} // end colony breeding loop
		// No timed breeding case
		if (!Colony[0].breedflag && !Colony[1].breedflag &&
			!Colony[2].breedflag && day[0] > HITBREEDTIME)
		{
			for (i=0; i<colonycount; i++)
				census_and_reset(&(Colony[i]));
			day[0] = 0; //Use day[0] for the counter in hitbreeding.
			did_breed = 1;
		}
		// End no timed breeding case.
		if (did_breed) 
		{
			//This message updates the score box
			if (hDlgScore)
				SendMessage( hDlgScore, WM_COMMAND,
					SC_BREED_UPDATE + i, 0L );
			//Update the graph
			score_history_record();
			if (hDlgGraph)
				SendMessage(hDlgGraph, WM_COMMAND, GRAPH_UPDATE,
					0L);
			did_breed = 0; // kill this, esp. in case GrowBugs_steps > 1
		} //end did_breed
		// update the food and poison
		if (!three_d_flag && foodglobflag && 
			(foodsupply < minfoodsupply) )
		{
			makefoodglob(); // move it, in other words.
			drawfoodglob(hdc);
		}
		if (!three_d_flag && poisonglobflag &&
			(poisonsupply < minpoisonsupply) )
		{
			makepoisonglob(); // to move it.
			drawpoisonglob(hdc);
		}
		//end update food and poison
#ifdef GROWBUGS_STEPS
	}// End of k loop of GrowBugs_steps
#endif //GROWBUGS_STEPS
	ReleaseDC(hwnd, hdc);
}

//------------------------------------Special Functions-------------

void near putpixel(HDC hdc, short x, short y, COLORREF color)
{ //grow.cpp
	SetPixel(hdcBugLand, x, y, color);
	// Put it in BugLand, then in hdc.
	// Mark the screen position represented by this bugland position.
	// The Window is the viewport into this world.
	if (lensflag) // clip by hand since ExcludeClipRect is slower.
	{
		x = XWRAP(x - WinOrgX);
		y = YWRAP(y - WinOrgY);
		if (!(lensrect.left<x && x<lensrect.right &&
			lensrect.top<y && y<lensrect.bottom) )
			SetPixel(hdc, x, y, color);
	}
	else
		SetPixel(hdc, XWRAP(x - WinOrgX), YWRAP(y - WinOrgY), color);

}

//-----------------Move---------------

void near move(struct bug *bug)
{ //grow.cpp

	// Check if the bug has moved far.
	// Let's only count x and y motion as z motion is normally
	// invisible.
	if (bug->lowmotionflag)
	{
		if ( MAX( ABS( bug->oldx - bug->startx ),
			ABS( bug->oldy - bug->starty ) ) >
			Colony[bug->colonyid].mintotalmotion )
			bug->lowmotionflag = 0;
	}

	// Use move function to set nonwrap? vars.
	(bug->move)(bug);

	bug->readcolorcode = BLANK_CASE;
	// Set default readcolorcode, which is changed in eatgetcolor(),
	// and can also be changed to WALL_CASE in wrap in case of a wall.

	(bug->wrap)(bug);

	//Now maybe make a sound
	if (bug->bugid == editbugid)
	{
		if (soundflag & SOUNDFLAG_STATE)
			beep(MOD(bug->state,10));
		else if (soundflag & SOUNDFLAG_DIR)
			beep(MOD(bug->dir,10));
	}
	
	// Now do the recriting and exogamy and
	// reset the hittable
	if (hitflag) //find the hits and deal with them.
	{
		hitbreed(); //If endogamous or exogamous breeding happens
		if (recruitflag)
		{
			SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);
		// Clear because if a bopper gets recruited, its trail
		// cells won't all get erased.
			recruitflag = 0;
		}
	}

}

void near turmite3D(struct bug *bug)
{ //grow.cpp
	unsigned char turn;
#ifdef MWC
	short pair;
#endif //MWC

// Compute writecolorindex
#ifndef MWC
	if (bug->readcolorcode == BLANK_CASE) // blank or self faint trail
		bug->writecolorindex = bug->writecolorgene0[bug->state];
	else if (bug->readcolorcode == SELF_CASE)  // own strong trail case
		bug->writecolorindex = bug->writecolorgene1[bug->state];
	else // In all other cases write a strong trail
		bug->writecolorindex = strong_pal_index[bug->colonyid];
		// This is the index of the strong color in bugpalette
#else
	pair = Pair[bug->state][bug->readcolorcode];
	bug->writecolorindex = bug->writecolorgene[ pair ];
#endif //MWC

// Compute new dir and new position.
#ifndef MWC
	turn = bug->dirgene[Pair[bug->state][bug->readcolorcode] ];
#else
	turn = bug->dirgene[pair];
#endif //MWC
	// Record the bug's current state and turn for the entropy
	// calculation
	bug->dirfreq[turn]++;
	bug->dir = MOD(bug->dir + turn, bug->directions);
	// Compute new position
	bug->nonwrapx = bug->oldx +
		(bug->basespeed * bug->bugmovex[bug->dir]);
	bug->nonwrapy = bug->oldy +
		(bug->basespeed * bug->bugmovey[bug->dir]);
	bug->nonwrapz = bug->oldz +
		(bug->basespeed * bug->bugmovez[bug->dir]);

// Compute new state
#ifndef MWC
	bug->state = bug->stategene[ Pair[bug->state][bug->readcolorcode] ];
#else
	bug->state = bug->stategene[ pair ];
#endif //MWC
}

void near turmite2D(struct bug *bug)
{ //grow.cpp
	unsigned char turn;
#ifdef MWC
	short pair;
#endif //MWC

// Compute writecolorindex
#ifndef MWC
	if (bug->readcolorcode == BLANK_CASE) // blank or self faint trail
		bug->writecolorindex = bug->writecolorgene0[bug->state];
	else if (bug->readcolorcode == SELF_CASE)  // own strong trail case
		bug->writecolorindex = bug->writecolorgene1[bug->state];
	else // In all other cases write a strong trail
		bug->writecolorindex = strong_pal_index[bug->colonyid];
		// This is the index of the strong color in bugpalette
#else
	pair = Pair[bug->state][bug->readcolorcode];
	bug->writecolorindex = bug->writecolorgene[ pair ];
#endif //MWC

// Compute new dir and new position.
#ifndef MWC
	turn = bug->dirgene[Pair[bug->state][bug->readcolorcode] ];
#else
	turn = bug->dirgene[pair];
#endif //MWC
	// Record the bug's current state and turn for the entropy
	// calculation
	bug->dirfreq[turn]++;
	bug->dir = MOD(bug->dir + turn, bug->directions);
	// Compute new position
	bug->nonwrapx = bug->oldx +
		(bug->basespeed * bug->bugmovex[bug->dir]);
	bug->nonwrapy = bug->oldy +
		(bug->basespeed * bug->bugmovey[bug->dir]);

// Compute new state
#ifndef MWC
	bug->state = bug->stategene[ Pair[bug->state][bug->readcolorcode] ];
#else
	bug->state = bug->stategene[ pair ];
#endif //MWC
}


void near boid3D(struct bug *bug)
{ //grow.cpp
	unsigned char veerflag = 0;

	if (bug->nearest_distance < Colony[bug->colonyid].hitradius)
		{
			hittable[bug->bugid][bug->nearest_bug->bugid] = 1;
			hitflag = 1;
		}

	// Avoid the walls
	if (!wrapflag)
	{
		if (bug->nonwrapx < wrapminx + bug->near_wall)
		{
			bug->tan[X] += bug->veerweight;
			veerflag = 1;
		}
		else if (bug->nonwrapx > wrapmaxx - bug->near_wall)
		{
			bug->tan[X] -= bug->veerweight;
			veerflag = 1;
		}
		if (bug->nonwrapy < wrapminy + bug->near_wall)
		{
			bug->tan[Y] += bug->veerweight;
			veerflag = 1;
		}
		else if (bug->nonwrapy > wrapmaxy - bug->near_wall)
		{
			bug->tan[Y] -= bug->veerweight;
			veerflag = 1;
		}
		if (bug->nonwrapz < wrapminz + bug->near_wall)
		{
			bug->tan[Z] += bug->veerweight;
			veerflag = 1;
		}
		else if (bug->nonwrapz > wrapmaxz - bug->near_wall)
		{
			bug->tan[Z] -= bug->veerweight;
			veerflag = 1;
		}
	}

	if (veerflag)
	{
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(WALL_SOUND_INDEX);
		bug->energy += Colony[bug->colonyid].wallvalue;
	}

	flock(bug, bug->nearest_bug);
	if (bug->watch_two)
		flock(bug, bug->second_nearest_bug);
		// Do second_nearest_bug last so if you have set
		// nearcolonycode before flock, you don't have to
		// for the first call to flock.
	// Now move in direction of unit vector tocentroid.
	bug->tan += bug->centerweight * bug->tocentroid;

	// Clamp the realspeed as flock can change it or it might be 0.
	// We assume minspeed is 1.
	if (bug->realspeed < (Real)(MINSPEED * bug->basespeed))
		bug->realspeed = (Real)(MINSPEED * bug->basespeed);
	if (bug->realspeed > (Real)(bug->basespeed * bug->maxspeed))
		bug->realspeed = (Real)(bug->basespeed * bug->maxspeed);

	bug->tan.Unify(); //Now normalize tan and apply the realspeed.

#ifndef REAL_POS
	bug->nonwrapx = bug->realspeed * bug->tan[X] + bug->oldx;
	bug->nonwrapy = bug->realspeed * bug->tan[Y] + bug->oldy;
	bug->nonwrapz = bug->realspeed * bug->tan[Z] + bug->oldz;
#else //REAL_POS
	bug->real_dx += bug->realspeed * bug->tan[X];
	bug->int_dx = bug->real_dx;
	bug->real_dx -= bug->int_dx;
	bug->nonwrapx = bug->int_dx + bug->oldx;
	bug->real_dy += bug->realspeed * bug->tan[Y];
	bug->int_dy = bug->real_dy;
	bug->real_dy -= bug->int_dy;
	bug->nonwrapy = bug->int_dy + bug->oldy;
	bug->real_dz += bug->realspeed * bug->tan[Z];
	bug->int_dz = bug->real_dz;
	bug->real_dz -= bug->int_dz;
	bug->nonwrapz = bug->int_dz + bug->oldz;
#endif //REAL_POS

}

void near boid2D(struct bug *bug)
{ //grow.cpp
	unsigned char veerflag = 0;

	if (bug->nearest_distance < Colony[bug->colonyid].hitradius)
		{
			hittable[bug->bugid][bug->nearest_bug->bugid] = 1;
			hitflag = 1;
		}

	// Eliminate z term
	bug->tan[Z]=0.0;

	// Avoid the walls
	if (!wrapflag)
	{
		if (bug->nonwrapx < wrapminx + bug->near_wall)
		{
			bug->tan[X] += bug->veerweight;
			veerflag = 1;
		}
		else if (bug->nonwrapx > wrapmaxx - bug->near_wall)
		{
			bug->tan[X] -= bug->veerweight;
			veerflag = 1;
		}
		if (bug->nonwrapy < wrapminy + bug->near_wall)
		{
			bug->tan[Y] += bug->veerweight;
			veerflag = 1;
		}
		else if (bug->nonwrapy > wrapmaxy - bug->near_wall)
		{
			bug->tan[Y] -= bug->veerweight;
			veerflag = 1;
		}
	}

	if (veerflag)
	{
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(WALL_SOUND_INDEX);
		bug->energy += Colony[bug->colonyid].wallvalue;
	}

	flock(bug, bug->nearest_bug);
	if (bug->watch_two)
		flock(bug, bug->second_nearest_bug);
		// Do second_nearest_bug last so if you have set
		// nearcolonycode before flock, you don't have to
		// for the first call to flock.
	// Now move in direction of unit vector tocentroid.
	bug->tan += bug->centerweight * bug->tocentroid;

	// Clamp the realspeed as flock can change it or it might be 0.
	if (bug->realspeed < (Real)(MINSPEED * bug->basespeed))
		bug->realspeed = (Real)(MINSPEED * bug->basespeed);
	// Old upper clamp was wrong.
//	if (bug->realspeed > (Real)(bug->basespeed * bug->minspeed))
//		bug->realspeed = (Real)(bug->basespeed * bug->minspeed);
	// New upper clamp
	if (bug->realspeed > (Real)(bug->basespeed * bug->maxspeed))
		bug->realspeed = (Real)(bug->basespeed * bug->maxspeed);

	bug->tan.Unify(); //Now normalize tan and apply the realspeed.

#ifndef REAL_POS
	bug->nonwrapx = bug->realspeed * bug->tan[X] + bug->oldx;
	bug->nonwrapy = bug->realspeed * bug->tan[Y] + bug->oldy;
#else //REAL_POS
	bug->real_dx += bug->realspeed * bug->tan[X];
	bug->int_dx = bug->real_dx;
	bug->real_dx -= bug->int_dx;
	bug->nonwrapx = bug->int_dx + bug->oldx;
	bug->real_dy += bug->realspeed * bug->tan[Y];
	bug->int_dy = bug->real_dy;
	bug->real_dy -= bug->int_dy;
	bug->nonwrapy = bug->int_dy + bug->oldy;
#endif //REAL_POS
}

void near wolf3D(struct bug *bug)
{ //grow.cpp
	if (bug->energy - bug->oldenergy <= 0)
		boid3D(bug);
	else 
	{
		turmite3D(bug);
#ifdef TURMITE_TAN
		turmitetan3D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			bug->nonwrapz - bug->oldz); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif
	}
	bug->oldenergy = bug->energy;
}

void near wolf2D(struct bug *bug)
{ //grow.cpp
	if (bug->energy - bug->oldenergy <= 0)
		boid2D(bug);
	else 
	{
		turmite2D(bug);
#ifdef TURMITE_TAN
		turmitetan2D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			0.0); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
	bug->oldenergy = bug->energy;
}

void near beaver3D(struct bug *bug)
{ //grow.cpp

	bug->boidstate = bug->stategene[
		Pair[bug->boidstate][bug->nearcolonycode] ];

	if (bug->colonyid == bug->nearest_bug->colonyid)
	{
		bug->nearcolonycode = SELF_CASE;
		turmite3D(bug);
#ifdef TURMITE_TAN
		turmitetan3D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			bug->nonwrapz - bug->oldz); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] > 0)
	// Desirable near guy 
	{
		bug->nearcolonycode = JABBER_CASE;
		// now decide between boid and turmite.
		if ( bug->nearest_distance > 
			(unsigned short)(bug->nearpreygene[bug->boidstate]))
			boid3D(bug);
		else 
		{
			turmite3D(bug);
#ifdef TURMITE_TAN
			turmitetan3D(bug);
//			bug->tan.Set(bug->nonwrapx - bug->oldx,
//				bug->nonwrapy - bug->oldy, bug->nonwrapz - bug->oldz); 
//			bug->tan.Unify(); //Now normalize tan, as in flock().
#endif //TURMITE_TAN
		}
	}
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] < 0)
		// Undesirable near guy
	{
		bug->nearcolonycode = WOCKY_CASE;
		// now decide between boid and turmite.
		if ( bug->nearest_distance < bug->nearpredgene[bug->boidstate] )
			boid3D(bug);
		else 
		{
			turmite3D(bug);
#ifdef TURMITE_TAN
			turmitetan3D(bug);
//			bug->tan.Set(bug->nonwrapx - bug->oldx,
//				bug->nonwrapy - bug->oldy, bug->nonwrapz - bug->oldz);
//			bug->tan.Unify(); //Now normalize tan, as in flock().
#endif //TURMITE_TAN
		}
	}
	else //neutral near guy
	{
		bug->nearcolonycode = OTHER_CASE;
		turmite3D(bug);
#ifdef TURMITE_TAN
		turmitetan3D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			bug->nonwrapz - bug->oldz); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
}

void near beaver2D(struct bug *bug)
{ //grow.cpp

	bug->boidstate = bug->stategene[
		Pair[bug->boidstate][bug->nearcolonycode] ];

	if (bug->colonyid == bug->nearest_bug->colonyid)
	{
		bug->nearcolonycode = SELF_CASE;
		turmite2D(bug);
#ifdef TURMITE_TAN
		turmitetan2D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			0.0); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] > 0)
	// Desirable near guy 
	{
		bug->nearcolonycode = JABBER_CASE;
		// now decide between boid and turmite.
		if ( bug->nearest_distance >
			(unsigned short)(bug->nearpreygene[bug->boidstate]))
			boid2D(bug);
		else
		{
			turmite2D(bug);
#ifdef TURMITE_TAN
			turmitetan2D(bug);
//			bug->tan.Set(bug->nonwrapx - bug->oldx,
//				bug->nonwrapy - bug->oldy, 0.0); 
//			bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
		}
	}
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] < 0)
		// Undesirable near guy
	{
		bug->nearcolonycode = WOCKY_CASE;
		// now decide between boid and turmite.
		if ( bug->nearest_distance < bug->nearpredgene[bug->boidstate] )
			boid2D(bug);
		else 
		{
			turmite2D(bug);
#ifdef TURMITE_TAN
			turmitetan2D(bug);
//			bug->tan.Set(bug->nonwrapx - bug->oldx,
//				bug->nonwrapy - bug->oldy, 0.0); 
//			bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
		}
	}
	else //neutral near guy
	{
		bug->nearcolonycode = OTHER_CASE;
		turmite2D(bug);
#ifdef TURMITE_TAN
		turmitetan2D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			0.0); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
}

void near dog3D(struct bug *bug)
{ //grow.cpp
	// Like dog2D, but no FOOD or POISON in 3D
	if ( bug->nearest_distance > bug->nearpredgene[bug->boidstate] )
		bug->nearcolonycode = BLANK_CASE;
	else if (bug->colonyid == bug->nearest_bug->colonyid)
		bug->nearcolonycode = SELF_CASE;
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] > 0)
		//Desireable near guy
		bug->nearcolonycode = JABBER_CASE;
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] < 0)
		// Undesirable near guy
		bug->nearcolonycode = WOCKY_CASE;
	else //neutral near guy
		bug->nearcolonycode = OTHER_CASE;
		// now decide between boid and turmite.

	bug->boidstate = bug->stategene[
		Pair[bug->boidstate][bug->nearcolonycode] ];

	if ( (bug->nearpreygene[bug->boidstate]) & 1 )
	//Use nearpreygene as a lookup into turmite or boid.
		boid3D(bug);
	else 
	{
		turmite3D(bug);
#ifdef TURMITE_TAN
		turmitetan3D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			bug->nonwrapz - bug->oldz); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
}

void near dog2D(struct bug *bug)
{ //grow.cpp
	// Like dog3D, with FOOD and POISON
	if (bug->readcolorcode == FOOD_CASE)
		bug->nearcolonycode = FOOD_CASE;
	else if (bug->readcolorcode == POISON_CASE)
		bug->nearcolonycode = POISON_CASE;
	else if ( bug->nearest_distance > bug->nearpredgene[bug->boidstate] )
		bug->nearcolonycode = BLANK_CASE;
	else if (bug->colonyid == bug->nearest_bug->colonyid)
		bug->nearcolonycode = SELF_CASE;
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] > 0)
		//Desireable near guy
		bug->nearcolonycode = JABBER_CASE;
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] < 0)
		// Undesirable near guy
		bug->nearcolonycode = WOCKY_CASE;
	else //neutral near guy
		bug->nearcolonycode = OTHER_CASE;
		// now decide between boid and turmite.

	bug->boidstate = bug->stategene[
		Pair[bug->boidstate][bug->nearcolonycode] ];

	if ( (bug->nearpreygene[bug->boidstate]) & 1 )
	//Use nearpreygene as a lookup into turmite or boid.
		boid2D(bug);
	else 
	{
		turmite2D(bug);
#ifdef TURMITE_TAN
		turmitetan2D(bug);
//		bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
//			0.0); 
//		bug->tan.Unify(); //Now normalize tan, maintain as in flock().
#endif //TURMITE_TAN
	}
}
//owl bookmark

void near owl3D(struct bug *bug)
{ //grow.cpp
	short k;

	// First get a boid read, similar to dog3D but skip BLANK_CASE
	if (bug->colonyid == bug->nearest_bug->colonyid)
		bug->nearcolonycode = SELF_CASE; //Self
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] > 0)
		bug->nearcolonycode = JABBER_CASE; //Prey
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] < 0)
		bug->nearcolonycode = WOCKY_CASE; //Pred
	else
		bug->nearcolonycode = OTHER_CASE; //Neutral

	// Compute the new state
	bug->state = bug->stategene[
		Pair[bug->state][bug->nearcolonycode] ];

	// Use state for an offset into the DNA
	k = 18 * (short)(bug->state);
	// The thing is, the turmite DNA has 18 bytes for each
	// state, stored sequentially.  So what I do is use
	// the state (this is really a pure boid rather than
	// a turboid, so I don't need to use both state and
	// boidstate) to index into the DNA array, pulling
	// off 18 bytes per state!  I could of course precompute
	// these values and store them in gene arrays, but that
	// would involve an awful lot of memory.  The conversion
	// is copied right from DNA_to_RNA in breed.cpp.

	//------------ 2 unsigned char (1 byte each)-------
	bug->watch_two = CHOOSE(bug->DNA[k++], 2);
	bug->maxspeed = MINSPEED + CHOOSE(bug->DNA[k++],
		MAX_MAXSPEED - MINSPEED + 1);
	//------------ 2 unsigned short (1 byte each)-------
	bug->cruisedistance = MIN_CRUISEDISTANCE +
		(unsigned short)(CHOOSE(bug->DNA[k++],
		(MAX_CRUISEDISTANCE - MIN_CRUISEDISTANCE)) );
	bug->near_wall = MIN_NEAR_WALL +
		(unsigned short)CHOOSE(bug->DNA[k++],
		(MAX_NEAR_WALL - MIN_NEAR_WALL) );
	//------------- 7 Real (2 bytes each)-----------------
	bug->visionanglecosine = DREAL(bug->DNA[k++], bug->DNA[k++],
		2.0) - 1.0;
	bug->copyweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->centerweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->attackweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->fleeweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->veerweight = MIN_VEERWEIGHT + DREAL(bug->DNA[k++],
		 bug->DNA[k++], (MAX_VEERWEIGHT - MIN_VEERWEIGHT) );
	bug->acceleration = 1.0 + DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_ACCELERATION_DIFF);

	boid3D(bug);
}

void near owl2D(struct bug *bug)
{ //grow.cpp
	short k;

	// First get a boid read, similar to dog2D but skip BLANK_CASE
	if (bug->readcolorcode == FOOD_CASE)
		bug->nearcolonycode = FOOD_CASE;
	else if (bug->readcolorcode == POISON_CASE)
		bug->nearcolonycode = POISON_CASE;
	else if (bug->colonyid == bug->nearest_bug->colonyid)
		bug->nearcolonycode = SELF_CASE; //Self
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] > 0)
		bug->nearcolonycode = JABBER_CASE; //Prey
	else if (bugeatvalue[bug->colonyid][bug->nearest_bug->colonyid] < 0)
		bug->nearcolonycode = WOCKY_CASE; //Pred
	else
		bug->nearcolonycode = OTHER_CASE; //Neutral

	// Compute the new state
	bug->state = bug->stategene[
		Pair[bug->state][bug->nearcolonycode] ];

	// Now use the new state as an offset into the DNA
	k = 18 * (short)(bug->state);
	// The thing is, the turmite DNA has 18 bytes for each
	// state, stored sequentially.  So what I do is use
	// the state (this is really a pure boid rather than
	// a turboid, so I don't need to use both state and
	// boidstate) to index into the DNA array, pulling
	// off 18 bytes per state!  I could of course precompute
	// these values and store them in gene arrays, but that
	// would involve an awful lot of memory.  The conversion
	// is copied right from DNA_to_RNA in breed.cpp.

	//------------ 2 unsigned char (1 byte each)-------
	bug->watch_two = CHOOSE(bug->DNA[k++], 2);
	bug->maxspeed = MINSPEED + CHOOSE(bug->DNA[k++],
		MAX_MAXSPEED - MINSPEED + 1);
	//------------ 2 unsigned short (1 byte each)-------
	bug->cruisedistance = MIN_CRUISEDISTANCE +
		(unsigned short)(CHOOSE(bug->DNA[k++],
		(MAX_CRUISEDISTANCE - MIN_CRUISEDISTANCE)) );
	bug->near_wall = MIN_NEAR_WALL +
		(unsigned short)CHOOSE(bug->DNA[k++],
		(MAX_NEAR_WALL - MIN_NEAR_WALL) );
	//------------- 7 Real (2 bytes each)-----------------
	bug->visionanglecosine = DREAL(bug->DNA[k++], bug->DNA[k++],
		2.0) - 1.0;
	bug->copyweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->centerweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->attackweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->fleeweight = DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_WEIGHT);
	bug->veerweight = MIN_VEERWEIGHT + DREAL(bug->DNA[k++],
		 bug->DNA[k++], (MAX_VEERWEIGHT - MIN_VEERWEIGHT) );
	bug->acceleration = 1.0 + DREAL(bug->DNA[k++], bug->DNA[k++],
		MAX_ACCELERATION_DIFF);

	boid2D(bug);
}


void near flock(struct bug *bug, struct bug *nearbug)
{ //grow.cpp
	bug->writecolorindex = strong_pal_index[bug->colonyid];
	if (bug->colonyid == nearbug->colonyid)
	{ //use oldtan so order of update doesn't matter
		// tend to fly parallel
		bug->tan += bug->copyweight * (nearbug)->oldtan;
		// Now make an adjustment to realspeed.
		// Adjust realspeed to try and be at a separation of
		// bug->cruisedistance from fellow colony members.
#ifdef FORWARD_VISION // nearbug is in front of you
		if (bug->nearest_distance < bug->cruisedistance)
			bug->realspeed /= bug->acceleration; // back off
		else
			bug->realspeed *= bug->acceleration; // chase it
#else //not FORWARD_VISION // the bug might be behind you
		if (bug->to[nearbug->bugnumid] % bug->oldtan >= 0 )
		{ //nearbug is in front of bug
			if (bug->nearest_distance < bug->cruisedistance)
				bug->realspeed /= bug->acceleration; // back off
			else // too far or just right
				bug->realspeed *= bug->acceleration; // chase it
		}
		else // nearbug *is* behind you
		{
			if (bug->nearest_distance < bug->cruisedistance)
				bug->realspeed *= bug->acceleration; // run away
			else // to far or just right
				bug->realspeed /= bug->acceleration; // wait up
		}
#endif //FORWARD_VISION
	}
	else if (bugeatvalue[bug->colonyid][nearbug->colonyid] > 0)
		// chase prey along connecting line
	{
		bug->realspeed *= bug->acceleration; // hurry!
		bug->tan += bug->attackweight * bug->to[nearbug->bugid];
	}
	else if (bugeatvalue[bug->colonyid][nearbug->colonyid] < 0)
	{ //flee along connnecting line
			
		bug->realspeed /= bug->acceleration; // slow down for the turn.
		bug->tan += bug->fleeweight * nearbug->to[bug->bugid];
	}
	else // else 0 eatvalue for nearbug means just avoid hitting it.
	{
		bug->realspeed /= bug->acceleration; // slow down.
	}
}

void near carry3D(struct bug *bug)
{ //grow.cpp
	short delta;

	GetCursorPos((LPPOINT)(&cursorpos));
	GetWindowRect(hwnd, (LPRECT)(&windowrect));

	if (cursorpos.y <= windowrect.top + bugscreen_offset_y_top)
	{
    	return; // So you can always get to the menu bar.
//		cursorpos.y = windowrect.bottom - bugscreen_offset_y_bottom -
//			( windowrect.top + bugscreen_offset_y_top - cursorpos.y);
//		SetCursorPos(cursorpos.x, cursorpos.y);
	}
    // Do an automatic wrap for the other three sides.
	if (cursorpos.y >= windowrect.bottom - bugscreen_offset_y_bottom)
    {
		cursorpos.y = windowrect.top + bugscreen_offset_y_top +
			cursorpos.y - (windowrect.bottom - bugscreen_offset_y_bottom);
		SetCursorPos(cursorpos.x, cursorpos.y);
	}
	if (cursorpos.x <= windowrect.left + bugscreen_offset_x_left)
	{
		cursorpos.x = windowrect.right - bugscreen_offset_x_right -
        	(windowrect.left + bugscreen_offset_x_left - cursorpos.x);
		SetCursorPos(cursorpos.x, cursorpos.y);
	}
	if (cursorpos.x >= windowrect.right - bugscreen_offset_x_right)
	{
		cursorpos.x = windowrect.left + cursorpos.x -
			(windowrect.right - bugscreen_offset_x_right);
		SetCursorPos(cursorpos.x, cursorpos.y);
	}

			
		bug->nonwrapx = XWRAP(cursorpos.x -
			windowrect.left + WinOrgX);
		bug->nonwrapy = YWRAP(cursorpos.y -
			windowrect.top - bugscreen_offset_y_top + WinOrgY);
		bug->nonwrapz = 
			bug->oldz + (carryz * CARRYSTEP_Z);
		carryz = 0;
		// Now adjust the nonwrap? vars to make sure they are
		// indexed as close as possible to the old? vars.
		// Copy this trick from metric.cpp (where it's explained)

		delta = bug->nonwrapx - bug->oldx;
		if (delta < -BugLand_MIDX)
			bug->nonwrapx = bug->oldx + BugLand_CX + delta;
		if (delta > BugLand_MIDX)
			bug->nonwrapx = bug->oldx + delta - BugLand_CX;

		delta = bug->nonwrapy - bug->oldy;
		if (delta < -BugLand_MIDY)
			bug->nonwrapy = bug->oldy + BugLand_CY + delta;
		if (delta > BugLand_MIDY)
			bug->nonwrapy = bug->oldy + delta - BugLand_CY;

		delta = bug->nonwrapz - bug->oldz;
		if (delta < -BugLand_MIDZ)
			bug->nonwrapz = bug->oldz + BugLand_CZ + delta;
		if (delta > BugLand_MIDZ)
			bug->nonwrapz = bug->oldz + delta - BugLand_CZ;
	
	bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
		bug->nonwrapz - bug->oldz); 
	bug->tan.Unify(); //Now normalize tan, maintain as in flock().
}

void near carry2D(struct bug *bug)
{ //grow.cpp
	short delta;
	
	GetCursorPos((LPPOINT)(&cursorpos));
	GetWindowRect(hwnd, (LPRECT)(&windowrect));
	if (cursorpos.y <= windowrect.top + bugscreen_offset_y_top)
	{
    	return; // So you can always get to the menu bar.
//		cursorpos.y = windowrect.bottom - bugscreen_offset_y_bottom -
//			( windowrect.top + bugscreen_offset_y_top - cursorpos.y);
//		SetCursorPos(cursorpos.x, cursorpos.y);
	}
    // Do an automatic wrap for the other three sides.
	if (cursorpos.y >= windowrect.bottom - bugscreen_offset_y_bottom)
    {
		cursorpos.y = windowrect.top + bugscreen_offset_y_top +
			cursorpos.y - (windowrect.bottom - bugscreen_offset_y_bottom);
		SetCursorPos(cursorpos.x, cursorpos.y);
	}
	if (cursorpos.x <= windowrect.left + bugscreen_offset_x_left)
	{
		cursorpos.x = windowrect.right - bugscreen_offset_x_right -
        	(windowrect.left + bugscreen_offset_x_left - cursorpos.x);
		SetCursorPos(cursorpos.x, cursorpos.y);
	}
	if (cursorpos.x >= windowrect.right - bugscreen_offset_x_right)
	{
		cursorpos.x = windowrect.left + cursorpos.x -
			(windowrect.right - bugscreen_offset_x_right);
		SetCursorPos(cursorpos.x, cursorpos.y);
	}

		bug->nonwrapx = XWRAP(cursorpos.x -
			windowrect.left + WinOrgX);
		bug->nonwrapy = YWRAP(cursorpos.y -
			windowrect.top - bugscreen_offset_y_top + WinOrgY);

		// Now adjust the nonwrap? vars to make sure they are
		// indexed as close as possible to the old? vars.
		// Copy this trick from metric.cpp (where it's explained)
		delta = bug->nonwrapx - bug->oldx;
		if (delta < -BugLand_MIDX)
			bug->nonwrapx = bug->oldx + BugLand_CX + delta;
		if (delta > BugLand_MIDX)
			bug->nonwrapx = bug->oldx + delta - BugLand_CX;

		delta = bug->nonwrapy - bug->oldy;
		if (delta < -BugLand_MIDY)
			bug->nonwrapy = bug->oldy + BugLand_CY + delta;
		if (delta > BugLand_MIDY)
			bug->nonwrapy = bug->oldy + delta - BugLand_CY;

	bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
		0.0); 
	bug->tan.Unify(); //Now normalize tan, maintain as in flock().
}

//-------------------Eat------------------

void near eat(struct bug *bug)
{ //grow.cpp
	(bug->eat)(bug);
	// Clamp the energy value.
	if (bug->energy > MAX_ENERGY)
		bug->energy = MAX_ENERGY;
	if (bug->energy < MIN_ENERGY)
		bug->energy = MIN_ENERGY;
}


void near eatapixel_2D(struct bug *bug)
{ //grow.cpp
	// If a nowrap was detected in turmite2D, WALL_CASE got shoved in
	// as the bug's readcolorcode during the bugwrap.  We effectively
	// act as if nowrap means there is an arbitrarily thick wall.
	// Affects readorder.

	if (bug->readcolorcode == WALL_CASE)
		bug->getcolor = wallcolor;
	else
		bug->getcolor = GetPixel(hdcBugLand, bug->x, bug->y);
	eatgetcolor(bug);
}


void near eatapixel_3D(struct bug *bug)
{ //grow.cpp
	// If a nowrap was detected in bugmove, WALL_CASE got shoved in
	// as the bug's readcolorcode during the bugmove.  We effectively
	// act as if nowrap means there is an arbitrarily thick wall.

	if (bug->readcolorcode == WALL_CASE)
		bug->getcolor = wallcolor;
	else
		setgetcolor_3D(bug->x, bug->y, bug->z, bug);
	eatgetcolor(bug);
}

void near eatgetcolor(struct bug *bug)
{ //grow.cpp
// This adds the value of the bug->x,bug->y pixel to the bug->energy
// and sets bug->readcolorcode to the color_CASE if not blank.
// If this is called repeatedly along a line with a bail at WALL_CASE,
// the effect is to choose (if not wall) the furthest nonblank color
// short of the targetpoint, or the targetpoint if all between are blank.
// Affects readorder.
	bug->meetflag = 0;
	// This is set to 1 iff the getcolor is jabber, wocky, or
	// meet.
	if (bug->getcolor == wallcolor)
	{
		bug->readcolorcode = WALL_CASE;
		bug->energy += Colony[bug->colonyid].wallvalue;
		// Freeze the bug at the last good position.
		//The very first
		// pixel can't be on a wall, so oldx, oldy have good
		// values.
		bug->x = bug->oldx;
		bug->y = bug->oldy;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(WALL_SOUND_INDEX);
	}
// We need a blankcase to avoid going to the end of the switch,
// but the blank case doesn't do anything since I'm always going to assume
//blankvalue is 0.  Also the default set of readcolorcode is BLANK_CASE.
// If on a line we've gotten out of BLANK_CASE, don't go back to it.
	else if ( bug->getcolor == blankcolor )
	{
#ifdef MOSS
		if (bug->mossflag && bug->readcolorcode == BLANK_CASE )
			bug->readcolorcode = OTHER_CASE
#endif //MOSS
		;
	}
// The moss.bop file does a neat thing, if the bopper views
// a blankcolor as "othercolor".  Should I let bugs distinguish?
// It might be good, as moss is one of the most interesting boppers
// I've found.  Of course this breaks all the other bugs I"ve saved...
// So I add a mossflag field and set moss.bop's to 1 and most
// others to 0.  mossflag says treat own weak color like blank
// and treat blank like other color.
	else if ( bug->getcolor ==
		bugpalette[weak_pal_index[bug->colonyid]])
		bug->energy += Colony[bug->colonyid].selfvalue;
		// Own weak color counts as BLANK_CASE for the self
	else if ( bug->getcolor ==
		bugpalette[strong_pal_index[bug->colonyid]] )
		{
			bug->energy += Colony[bug->colonyid].selfvalue;
			bug->readcolorcode = SELF_CASE;
		}
// Treat jabber and wocky dark and faint trails the same.
// Note that if jabberid==colonyid you have already bailed by now,
// in case getcolor would have been jabberid.  This situation 
// can happen if colonycount==1.  Similar below if colonycount == 2.
	else if ( ( bug->getcolor ==
		bugpalette[weak_pal_index[bug->jabberid]] ) ||
		( bug->getcolor ==
		bugpalette[strong_pal_index[bug->jabberid]] ) )
	{
		bug->energy += Colony[bug->colonyid].jabbervalue;
		bug->readcolorcode = JABBER_CASE;
		bug->meetflag = JABBERMEET;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
		{
			if (Colony[bug->colonyid].jabbervalue >= 0)
				sound(PREY_SOUND_INDEX);
			else
				sound(PRED_SOUND_INDEX);
		}
	}
	else if ( ( bug->getcolor ==
		bugpalette[weak_pal_index[bug->wockyid]] ) ||
		(bug->getcolor ==
		bugpalette[strong_pal_index[bug->wockyid]] ) )
	{
		bug->energy += Colony[bug->colonyid].wockyvalue;
		bug->readcolorcode = WOCKY_CASE;
		bug->meetflag = WOCKYMEET;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
		{
			if (Colony[bug->colonyid].wockyvalue >= 0)
				sound(PREY_SOUND_INDEX);
			else
				sound(PRED_SOUND_INDEX);
		}
	}
	else if (bug->getcolor == foodcolor)
	{
		bug->energy += Colony[bug->colonyid].foodvalue;
		bug->readcolorcode = FOOD_CASE;
		if (foodsupply > 0)
			foodsupply--;
		else
			foodsupply = 0;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(FOOD_SOUND_INDEX);
	}
	else if (bug->getcolor == poisoncolor)
	{
		bug->energy += Colony[bug->colonyid].poisonvalue;
		bug->readcolorcode = POISON_CASE;
		if (poisonsupply > 0)
			poisonsupply--;
		else
			poisonsupply = 0;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(POISON_SOUND_INDEX);
	}
	else if (bug->getcolor == headcolor)
	{	//treat head as other case
		bug->readcolorcode = OTHER_CASE;
		// figure out whose head it is, and if different,
		// award score and maybe recruit
		testhit(bug);
	}
	else // other case.  Just put your own color
	//DEBUG : If I am in 256 color mode, I drop into this
	// case when I should be hitting faint self or strong self
	// colors?
	{
		bug->energy += Colony[bug->colonyid].othervalue;
		bug->readcolorcode = OTHER_CASE;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(OTHER_SOUND_INDEX);
	}
}

void near justeatgetcolor(struct bug *bug)
{ //grow.cpp
// This adds the value of the bug->x,bug->y pixel to the bug->energy
// but doesn't set bug->readcolorcode.
// Affects readorder.
	bug->meetflag = 0;
	// This is set to 1 iff the getcolor is jabber, wocky, or
	// meet.
	if (bug->getcolor == wallcolor)
	{
		bug->energy += Colony[bug->colonyid].wallvalue;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(WALL_SOUND_INDEX);
	}
	else if ( bug->getcolor == blankcolor )
		;
	else if ( bug->getcolor ==
		bugpalette[weak_pal_index[bug->colonyid]])
		bug->energy += Colony[bug->colonyid].selfvalue;
	else if ( bug->getcolor ==
		bugpalette[strong_pal_index[bug->colonyid]] )
		bug->energy += Colony[bug->colonyid].selfvalue;
// Treat jabber and wocky dark and faint trails the same.
// Note that if jabberid==colonyid you have already bailed by now,
// in case getcolor would have been jabberid.  This situation 
// can happen if colonycount==1.  Similar below if colonycount == 2.
	else if ( ( bug->getcolor ==
		bugpalette[weak_pal_index[bug->jabberid]] ) ||
		( bug->getcolor ==
		bugpalette[strong_pal_index[bug->jabberid]] ) )
		{
			bug->energy += Colony[bug->colonyid].jabbervalue;
			bug->meetflag = JABBERMEET;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
		{
			if (Colony[bug->colonyid].jabbervalue >= 0)
				sound(PREY_SOUND_INDEX);
			else
				sound(PRED_SOUND_INDEX);
		}
		}
	else if ( ( bug->getcolor ==
		bugpalette[weak_pal_index[bug->wockyid]] ) ||
		(bug->getcolor ==
		bugpalette[strong_pal_index[bug->wockyid]] ) )
		{
			bug->energy += Colony[bug->colonyid].wockyvalue;
			bug->meetflag = WOCKYMEET;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
		{
			if (Colony[bug->colonyid].wockyvalue >= 0)
				sound(PREY_SOUND_INDEX);
			else
				sound(PRED_SOUND_INDEX);
		}
		}
	else if (bug->getcolor == foodcolor)
	{
		bug->energy += Colony[bug->colonyid].foodvalue;
		if (foodsupply > 0)
			foodsupply--;
		else
			foodsupply = 0;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(FOOD_SOUND_INDEX);
	}
	else if (bug->getcolor == poisoncolor)
	{
		bug->energy += Colony[bug->colonyid].poisonvalue;
		if (poisonsupply > 0)
			poisonsupply--;
		else
			poisonsupply = 0;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(POISON_SOUND_INDEX);
	}
	else if (bug->getcolor == headcolor)
	{
		// figure out whose head it is, and if different, 
		// award score and recruit.
		bug->energy += Colony[bug->colonyid].othervalue;
		testhit(bug);
	}
	else // other case. Includes meetcolors.
	{
		bug->energy += Colony[bug->colonyid].othervalue;
		if ((soundflag & SOUNDFLAG_EAT) && bug->bugid == editbugid)
			sound(OTHER_SOUND_INDEX);
	}
}
//-------------------Wrap Things---------------------

void near wrap2D(struct bug *bug)
{ // grow.cpp
// Wrap or prepare to reject the position.
	if (wrapflag) // wrapflag case
	{
		bug->x = XWRAP(bug->nonwrapx);
		bug->y = YWRAP(bug->nonwrapy);
	}
	else // not wrapflag
	{
	// If off the edge use WALL_CASE in the readcolorcode as a signal
	// of no move.
		if ( bug->nonwrapx<wrapminx || bug->nonwrapx>wrapmaxx ||
			bug->nonwrapy<wrapminy || bug->nonwrapy>wrapmaxy )
				bug->readcolorcode = WALL_CASE;
		else
		{
			bug->x = bug->nonwrapx;
			bug->y = bug->nonwrapy;
		}
	}
}


void near wrap3D(struct bug *bug)
{ //grow.cpp
// Wrap or prepare to reject the position.
	if (wrapflag) // wrapflag case
	{
		bug->x = XWRAP(bug->nonwrapx);
		bug->y = YWRAP(bug->nonwrapy);
		if (Zwrapflag)
			bug->z = ZWRAP(bug->nonwrapz);
		else // not Zwrapflag
		{
			if ( bug->nonwrapz<wrapminz || bug->nonwrapz>wrapmaxz )
				bug->readcolorcode = WALL_CASE;
		}
	}
	else // not wrapflag
	{
	// If off the edge use WALL_CASE in the readcolorcode as a signal
	// of no move.
		if ( bug->nonwrapx<wrapminx || bug->nonwrapx>wrapmaxx ||
			bug->nonwrapy<wrapminy || bug->nonwrapy>wrapmaxy ||
			bug->nonwrapz<wrapminz || bug->nonwrapz>wrapmaxz )
			bug->readcolorcode = WALL_CASE;
		else
		{
			bug->x = bug->nonwrapx;
			bug->y = bug->nonwrapy;
			bug->z = bug->nonwrapz;
		}
	}
}
void near BugBodyBlt(HDC hdc, struct bug *bug, unsigned char curr_or_old)
{ //grow.cpp
	short bodynumber, x,y,prex,prey,prexplus,preyplus,
		inx,iny,outx,outy,overlap, BugBody_CX, BugBody_CY;

	if (curr_or_old == CURRPOS)
	{
		if (!bug->bugbodyflag && !(editbugid == bug->bugid))
			return;
		if (bug->body_on && bug->bugbodyflag != 2)
			return; // Don't write it twice! (Paranoid).
			// But do write it if you're a smearbody guy.
		if (!three_d_flag)
		{
			if (editbugid == bug->bugid)
				bodynumber = BODY_COUNT_2D - 1; // Reserve last .bmp for
					// the editbody bmp.
			else
				bodynumber = bug->bodyid;

			BugBody_CX = MAX_BugBody_2D_CX;
			BugBody_CY = MAX_BugBody_2D_CY;
		}
		else
		{
// The smaller z is, the larger the bodynumber, as they are arranged
// in increasing order of size.
			bodynumber = (BODY_COUNT_3D - 1) -
				( (BODY_COUNT_3D * (unsigned short) bug->z) /
				(unsigned short) BugLand_CZ );
				// quotient has range 0 to BODY_COUNT_3D - 1;
				// we "invert" it since bigger bodynumbers are larger,
				// and we think of small z values a closer & larger.
			BugBody_CX = MAX_BugBody_3D_CX;
			BugBody_CY = MAX_BugBody_3D_CY;
		}
		bug->oldbodyid = bodynumber;
		prex = bug->oldx - (BugBody_CX/2); //write at old to match
		prey = bug->oldy - (BugBody_CY/2); // trailpixel for smear
		x = XWRAP(prex - WinOrgX);
		y = YWRAP(prey - WinOrgY);
		// x,y is the upper left hand corner of body onscreen spot.
		// x+BugBody_CX, y+BugBody_CY is lower right hand corner.
		// Overlap occurs if lensleft<bugright && bugleft<lensright
		if ( !( lensflag &&
			( lensrect.left<(x+BugBody_CX) ) && ( x<lensrect.right ) &&
			( lensrect.top<(y+BugBody_CY) ) && ( y<lensrect.bottom ) ) )
			// Don't draw it normal if it overlaps the lens.
		{
			bug->body_on = 1; // Only the off-lens ones count.
			if (!three_d_flag)
				BitBlt(hdc, x, y,			// Draw the body
					BugBody_CX, BugBody_CY,
					hdcBugBody_2D[bodynumber], 0, 0, SRCCOPY);
			else
				BitBlt(hdc, x, y,			// Draw the body
					BugBody_CX, BugBody_CY,
					hdcBugBody_3D[bodynumber], 0, 0, SRCCOPY  );
		}
		else
			// If any of it is in the lens, write it oversized
			// to the lens area, which must be clipped.
		{
			bug->body_on = 0;  // Only the off-lens ones count.
		}
	}
	else		// OLDPOS
	{
		if (!bug->body_on)
			return;
		bug->body_on = 0; // Because I'm erasing it in this proc.
		bodynumber = bug->oldbodyid;
		if (!three_d_flag)
		{
			BugBody_CX = MAX_BugBody_2D_CX;
			BugBody_CY = MAX_BugBody_2D_CY;
		}
		else
		{
			BugBody_CX = MAX_BugBody_3D_CX;
			BugBody_CY = MAX_BugBody_3D_CY;
		}
		prex = XWRAP( bug->oldoldx - (BugBody_CX/2) );// to match
		prey = YWRAP( bug->oldoldy - (BugBody_CY/2) );// smear change 
		prexplus = prex + BugBody_CX;
		preyplus = prey + BugBody_CY;
		overlap = 0;
		if (prexplus > BugLand_MAXX)
		{
			inx = BugLand_CX - prex;
			outx = prexplus - BugLand_CX;
			overlap = 1;
		}
		if (preyplus > BugLand_MAXY)
		{
			iny = BugLand_CY - prey;
			outy = preyplus - BugLand_CY;
			overlap |= 2;
		}
		x = XWRAP(prex - WinOrgX);
		y = YWRAP(prey - WinOrgY);

		if (!( lensflag &&
			( lensrect.left<(x+BugBody_CX) ) && ( x<lensrect.right ) &&
			( lensrect.top<(y+BugBody_CY) ) && ( y<lensrect.bottom ) ) )
			// You need to check this "again" here since you
			// don't want to restore if the lens just got turned on.
			switch (overlap) 	// Restore underbody square
			{
				case 0: // no overlap
					BitBlt(hdc, x, y, BugBody_CX, BugBody_CY,
						hdcBugLand, prex, prey, SRCCOPY);
					break;
				case 1: // x overlap
					BitBlt(hdc, x, y, inx, BugBody_CY,
						hdcBugLand, prex, prey, SRCCOPY);
					BitBlt(hdc, x + inx, y, outx, BugBody_CY,
						hdcBugLand, 0, prey, SRCCOPY);
					break;
				case 2: // y overlap
					BitBlt(hdc, x, y, BugBody_CX, iny,
						hdcBugLand, prex, prey, SRCCOPY);
					BitBlt(hdc, x, y + iny, BugBody_CX, outy,
						hdcBugLand, prex, 0, SRCCOPY);
					break;
				case 3: // x and y overlap
					BitBlt(hdc, x, y, inx, iny,
						hdcBugLand, prex, prey, SRCCOPY);
					BitBlt(hdc, x+inx, y, outx, iny,
						hdcBugLand, 0, prey, SRCCOPY);
					BitBlt(hdc, x, y+iny, inx, outy,
						hdcBugLand, prex, 0, SRCCOPY);
					BitBlt(hdc, x + inx, y + iny, outx, outy,
						hdcBugLand, 0, 0, SRCCOPY);
					break;
			}
	}
}

//--------------------------Code for trails,lines and shapes---

void near drawtrailshape(HDC hdc, struct bug *bug)
{
//grow.cpp.  affects readorder
	// I want everyone to start with a trailpixel, both for smear trail
	// and for erasing the headpixels

	if (bug->bugbodyflag == 2)
		note_smearbody_flag = SMEAR_DING;
	// alert the ipixel_?D called by drawtrailshape
	// that I am going to put a smearbody at oldx,oldy.

	if (bug->radius >= 1) //Draw a square
	{
		trailsquare(hdc, bug);// at oldoldx, oldoldy
		bug->oldcolor = bugpalette[bug->writecolorindex];
		bug->oldwritecolorindex = bug->writecolorindex;
	}
	if (bug->lineflag)
	{
		trailline(hdc, bug);  // 2d Bresen is ((oldx,oldy), (x,y)), a 
			//open interval, which eats and writes pixels.
			//The first pixel is set using oldmeetflag, and then
			//meetflag is copied to oldmeetflag.  The other pixels
			//are set using a  concurrently determined meetflag.
	}
	if (!(bug->lineflag)) //You still need to draw the pixel
		trailpixel(hdc, bug); //At (oldx,oldy), currently a head.
		//Use the oldmeetflag to decide if its meetcolor.
		//And then set oldmeetcolor to meetcolor.
}

void near ipixel_2D(HDC hdc, short x, short y, COLORREF color, struct bug* bug)
{// grow.cpp . affects readorder.  Use this in and in isquare_2d.
	struct trailrecord_2D trailpack;

	if (  GetPixel(hdcBugLand, x, y) == color && !note_smearbody_flag)
		return; // Don't write the same color twice
// In the non-erasetrail mode, we write if the color is new.
// No, always do it in case of headcolor.
	if (!colony_erasetrailflag[bug->colonyid])
	{
//		if (bug->getcolor != color && // Not erasing headpixel
//			!(x == bug->oldx && y == bug->oldy))
		{
			putpixel(hdc, x, y, color);
			if (CAflag == 2)
				CAput(x,y,bug->writecolorindex);
		}
		return;
	}

	// In 2D world, don't bother to overwrite the same color.
	// but we always want to enter if its a case of smearbody.
	// But the getcolor might not be the screen color because
	// of headcolor, so we always have to do this
//	if (bug->getcolor == color && !note_smearbody_flag)
//		return;
//bookmark
	if (colony_trailfull[bug->colonyid]) // erase the old trail pixel
	{
		trailpack = colony_trail_loop[bug->colonyid]
			[colony_trailindex[bug->colonyid]];
		putpixel(hdc, trailpack.x, trailpack.y & NON_SMEAR_DING,
			blankcolor);

		if (trailpack.y & SMEAR_DING) // smear trail case
			BugBodyErase_near(hdc, trailpack.x, trailpack.y & NON_SMEAR_DING);
		// Erase a spot the size of a maximum bugbody at this spot
		// But what if this spot is interior to a line, whre no
		// body was ever drawn?
	}
	// make a copy of the pixel you're going to write
	trailpack.x = x;
	trailpack.y = y | note_smearbody_flag; // 0 or SMEAR_DING
	note_smearbody_flag = 0; // in case it wasn't 0
	colony_trail_loop[bug->colonyid][colony_trailindex[bug->colonyid]] =
		trailpack;
 // bump and wrap the index
	if (++colony_trailindex[bug->colonyid] >=
		colony_traillength[bug->colonyid])
	{
		colony_trailindex[bug->colonyid] = 0;
			// Once you've rolled over it's time to erase.
		colony_trailfull[bug->colonyid] = 1;
	}
	putpixel(hdc, x, y, color);
	if (CAflag == 2)
		CAput(x,y,bug->writecolorindex);

}

#ifdef STEREO

void near ipixel_3D(HDC hdc, short x, short y, short z, COLORREF color, struct bug* bug)

{
	if (!stereoflag)
	{
		one_ipixel_3D(hdc, x, y, z, color,  bug);
		return;
	}
	else
	{
// Get the next formula by drawing a right triangle into the screen
// with long side NosePix + z and short side EyePix.  The line
// from the center between eyes goes in perpendicular and the line from an
// eye slants.  The length between these lines at the screen
// interesection is given by the formula:
//		stereoshift = ((float)(BugLand_CZ - z) * EyePix) / ((float)(z) + NosePix);

		//Left eye image
		bug->writecolorindex = redindex;
		one_ipixel_3D(hdc, XWRAP(x +
			((BugLand_CZ - (float)z)*(x - LeftEye)) /
			((float)(z) + NosePix)
			), y, z, redcolor, bug);
		// Right eye Image
		bug->writecolorindex = blueindex;
		one_ipixel_3D(hdc, XWRAP(x +
			((BugLand_CZ - (float)z)*(x - RightEye)) /
			((float)(z) + NosePix)
			), y, z, bluecolor, bug);
	}


}

void near edgeipixel_3D(HDC hdc, short x, short y, short z, COLORREF color, unsigned char writecolorindex)
{

	if (!stereoflag)
	{
		one_edgeipixel_3D(hdc, x, y, z, color, writecolorindex);
		return;
	}
	else
	{
//		stereoshift = ((float)(BugLand_CZ - z) * EyePix) / ((float)(z) + NosePix);
//		one_edgeipixel_3D(hdc, XWRAP(x + stereoshift), y, z,
//			redcolor, redindex);
//		one_edgeipixel_3D(hdc, XWRAP(x - stereoshift), y, z,
//			bluecolor, blueindex);
		//Left eye image
		one_edgeipixel_3D(hdc, XWRAP(x +
			((BugLand_CZ - (float)z)*(x - LeftEye)) /
			((float)(z) + NosePix)
			), y, z, redcolor, redindex);
		// Right eye Image
		one_edgeipixel_3D(hdc, XWRAP(x +
			((BugLand_CZ - (float)z)*(x - RightEye)) /
			((float)(z) + NosePix)
			), y, z, bluecolor, blueindex);

	}

}

void near blankipixel_3D(HDC hdc, short x, short y, short z)
{

	if (!stereoflag)
	{
		one_blankipixel_3D(hdc, x, y, z);
		return;
	}
	else
	{
//		stereoshift = ((float)(BugLand_CZ - z) * EyePix) / ((float)(z) + NosePix);
//		one_blankipixel_3D(hdc, XWRAP(x + stereoshift), y, z);
//		one_blankipixel_3D(hdc, XWRAP(x - stereoshift), y, z);
		//Left eye image
		one_blankipixel_3D(hdc, XWRAP(x +
			((BugLand_CZ - (float)z)*(x - LeftEye)) /
			((float)(z) + NosePix)
			), y, z);
		// Right eye Image
		one_blankipixel_3D(hdc, XWRAP(x +
			((BugLand_CZ - (float)z)*(x - RightEye)) /
			((float)(z) + NosePix)
			), y, z);
	}

}

void near one_ipixel_3D(HDC hdc, short x, short y, short z, COLORREF color, struct bug* bug)
{ //grow.cpp
	struct trailrecord_3D trailpack;
	short tx, ty;
	long zbufferindex;
	unsigned short frontindex, nextindex;
	unsigned char newcolorindex, frontflag = 1;


// In the non-erasetrail mode, we write if the color is new.
	if (!erasetrailflag)
	{
// drop this condition because of headcolor
//		if (bug->getcolor != color)
		{
			putpixel(hdc, x, y, color);
		}
		return;
	}

// Drop through to this erasetrail 3D mode otherwise.
	if (trailfull)	// erase the old trail pixel
	{
		trailpack = trail_loop[trailindex];
		tx = TR_GET_X(trailpack);
		ty = TR_GET_Y(trailpack);
		if (trailpack.smearflag) // smear trail case
			BugBodyErase_near(hdc, tx, ty);
		// Erase a spot the size of a maximum bugbody at this spot
		zbufferindex = BUGLANDINDEX(tx, ty);
		frontindex = zbuffer[zbufferindex];
		if (frontindex == trailindex)
		{	// Then your pixel is in front.
			if (trailpack.behindindex == NONINDEX)
			{
				// Nobody behind you.
				if (trailpack.colorindex != BLANK_PAL_INDEX)
					putpixel(hdc, tx, ty, blankcolor);
				zbuffer[zbufferindex] = NONINDEX;
			}
			else
			{	//Someone behind you.
				newcolorindex = ~IGNORE_MASK &
					trail_loop[trailpack.behindindex].colorindex;
				putpixel(hdc, tx, ty,
					bugpalette[newcolorindex]);
				zbuffer[zbufferindex] = trailpack.behindindex;
			}
		}
		else // your pixel is not in front
		{
			while (TRUE)
			{
				nextindex = trail_loop[frontindex].behindindex;
				if (nextindex == trailindex)
					break;
				frontindex = nextindex;
			}
			// Now record guy behind your pixel.
			trail_loop[frontindex].behindindex = trailpack.behindindex;
		} // end your pixel not in front case.
	} // done erasing the old trail pixel

// Record info on the pixel you're going to write
	TR_SET_XYZ(trailpack,x,y,z);
	if (note_smearbody_flag)
	{
		trailpack.smearflag = 1;
		note_smearbody_flag = 0;
	}
	else
		trailpack.smearflag = 0;
	trailpack.colorindex = bug->writecolorindex;
// Now you have to work to set trailpack.behindindex
	zbufferindex = BUGLANDINDEX(x, y);
	frontindex = zbuffer[zbufferindex];

	if (frontindex == NONINDEX)
	{	// There is no point here in zubuff
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = NONINDEX;
	}
	else if (TR_GET_Z(trail_loop[frontindex]) >= z)
	{	// There is a zbuff point, it's equal or further than you
		// even if equal z, you go in front of it.
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = frontindex;
	}
	else
	{	// There is a zbuff point closer than you.
		frontflag = 0; // Don't paint this point.
		while (TRUE)
		{
			nextindex = trail_loop[frontindex].behindindex;
			if (nextindex == NONINDEX)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = NONINDEX;
				break;
			}
			// If you're here, then nextindex must be good.
			if ( TR_GET_Z(trail_loop[nextindex]) >= z)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = nextindex;
				break;
			}
			frontindex = nextindex;
		}
	}

	// NOW you can save the trail_loop info about your pixel
	trail_loop[trailindex] = trailpack;
	if (++trailindex >= traillength) // bump and wrap the index
	{
		trailindex = 0;
			// Once you've rolled over it's time to erase.
		trailfull = 1;
	}
// Write the new pixel if the color is different.
	if (frontflag && (GetPixel(hdcBugLand, x, y) != color) )
			putpixel(hdc, x, y, color);
}

void near one_edgeipixel_3D(HDC hdc, short x, short y, short z, COLORREF color, unsigned char writecolorindex)
{ //grow.cpp
// Difference between this and ipixel is that I don't use the bug
// param because I haven't set it's getcolor.  Instead I
// fill the bug slot with just the uchar of the bug's writecolor index.
// Also I OR in the IGNORE_MASK with the writecolorindex.
	struct trailrecord_3D trailpack;
	short tx, ty;
	long zbufferindex;
	unsigned short frontindex, nextindex;
	unsigned char newcolorindex, frontflag = 1;


// In the non-erasetrail mode, we write if the color is new.
	if (!erasetrailflag)
	{
		putpixel(hdc, x, y, color);
		return;
	}

// Drop through to this erasetrail 3D mode otherwise.
	if (trailfull)	// erase the old trail pixel
	{
		trailpack = trail_loop[trailindex];
		tx = TR_GET_X(trailpack);
		ty = TR_GET_Y(trailpack);
		if (trailpack.smearflag) // smear trail case
			BugBodyErase_near(hdc, tx, ty);
		// Erase a spot the size of a maximum bugbody at this spot
		zbufferindex = BUGLANDINDEX(tx, ty);
		frontindex = zbuffer[zbufferindex];
		if (frontindex == trailindex)
		{	// Then your pixel is in front.
			if (trailpack.behindindex == NONINDEX)
			{
				// Nobody behind you.
				if (trailpack.colorindex != BLANK_PAL_INDEX)
					putpixel(hdc, tx, ty, blankcolor);
				zbuffer[zbufferindex] = NONINDEX;
			}
			else
			{	//Someone behind you.
				newcolorindex = ~IGNORE_MASK &
					trail_loop[trailpack.behindindex].colorindex;
				putpixel(hdc, tx, ty,
					bugpalette[newcolorindex]);
				zbuffer[zbufferindex] = trailpack.behindindex;
			}
		}
		else // your pixel is not in front
		{
			while (TRUE)
			{
				nextindex = trail_loop[frontindex].behindindex;
				if (nextindex == trailindex)
					break;
				frontindex = nextindex;
			}
			// Now record guy behind your pixel.
			trail_loop[frontindex].behindindex = trailpack.behindindex;
		} // end your pixel not in front case.
	} // done erasing the old trail pixel

// Record info on the pixel you're going to write
	TR_SET_XYZ(trailpack,x,y,z);
	trailpack.colorindex = IGNORE_MASK | writecolorindex;
// Now you have to work to set trailpack.behindindex
	zbufferindex = BUGLANDINDEX(x, y);
	frontindex = zbuffer[zbufferindex];

	if (frontindex == NONINDEX)
	{	// There is no point here in zubuff
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = NONINDEX;
	}
	else if (TR_GET_Z(trail_loop[frontindex]) >= z)
	{	// There is a zbuff point, it's equal or further than you
		// even if equal z, you go in front of it.
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = frontindex;
	}
	else
	{	// There is a zbuff point closer than you.
		frontflag = 0; // Don't paint this point.
		while (TRUE)
		{
			nextindex = trail_loop[frontindex].behindindex;
			if (nextindex == NONINDEX)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = NONINDEX;
				break;
			}
			// If you're here, then nextindex must be good.
			if ( TR_GET_Z(trail_loop[nextindex]) >= z)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = nextindex;
				break;
			}
			frontindex = nextindex;
		}
	}

	// NOW you can save the trail_loop info about your pixel
	trail_loop[trailindex] = trailpack;
	if (++trailindex >= traillength) // bump and wrap the index
	{
		trailindex = 0;
			// Once you've rolled over it's time to erase.
		trailfull = 1;
	}
// Write the new pixel.
	if (frontflag)
		putpixel(hdc, x, y, color);
}

void near one_blankipixel_3D(HDC hdc, short x, short y, short z)
{ //grow.cpp
// don't need color or bug.

	struct trailrecord_3D trailpack;
	short tx, ty;
	long zbufferindex;
	unsigned short frontindex, nextindex;
	unsigned char newcolorindex, frontflag = 1;


// In the non-erasetrail mode, we always write.
	if (!erasetrailflag)
	{
		putpixel(hdc, x, y, blankcolor);
		return;
	}

// Drop through to this erasetrail 3D mode otherwise.
	if (trailfull)	// erase the old trail pixel
	{
		trailpack = trail_loop[trailindex];
		tx = TR_GET_X(trailpack);
		ty = TR_GET_Y(trailpack);
		if (trailpack.smearflag) // smear trail case
			BugBodyErase_near(hdc, tx, ty);
		// Erase a spot the size of a maximum bugbody at this spot
		zbufferindex = BUGLANDINDEX(tx, ty);
		frontindex = zbuffer[zbufferindex];
		if (frontindex == trailindex)
		{	// Then your pixel is in front.
			if (trailpack.behindindex == NONINDEX)
			{
				// Nobody behind you.
				if (trailpack.colorindex != BLANK_PAL_INDEX)
					putpixel(hdc, tx, ty, blankcolor);
				zbuffer[zbufferindex] = NONINDEX;
			}
			else
			{	//Someone behind you.
				newcolorindex = ~IGNORE_MASK &
					trail_loop[trailpack.behindindex].colorindex;
				putpixel(hdc, tx, ty,
					bugpalette[newcolorindex]);
				zbuffer[zbufferindex] = trailpack.behindindex;
			}
		}
		else // your pixel is not in front
		{
			while (TRUE)
			{
				nextindex = trail_loop[frontindex].behindindex;
				if (nextindex == trailindex)
					break;
				frontindex = nextindex;
			}
			// Now record guy behind your pixel.
			trail_loop[frontindex].behindindex = trailpack.behindindex;
		} // end your pixel not in front case.
	} // done erasing the old trail pixel

// Record info on the pixel you're going to write
	TR_SET_XYZ(trailpack,x,y,z);
	trailpack.colorindex = BLANK_PAL_INDEX;
// Now you have to work to set trailpack.behindindex
	zbufferindex = BUGLANDINDEX(x, y);
	frontindex = zbuffer[zbufferindex];

	if (frontindex == NONINDEX)
	{	// There is no point here in zubuff
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = NONINDEX;
		frontflag = 0;
		// You don't need to write a blank if nothing there.
	}
	else if (TR_GET_Z(trail_loop[frontindex]) >= z)
	{	// There is a zbuff point, it's equal or further than you
		// even if equal z, you go in front of it.
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = frontindex;
	}
	else
	{	// There is a zbuff point closer than you.
		frontflag = 0; // Don't paint this point.
		while (TRUE)
		{
			nextindex = trail_loop[frontindex].behindindex;
			if (nextindex == NONINDEX)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = NONINDEX;
				break;
			}
			// If you're here, then nextindex must be good.
			if ( TR_GET_Z(trail_loop[nextindex]) >= z)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = nextindex;
				break;
			}
			frontindex = nextindex;
		}
	}

	// NOW you can save the trail_loop info about your pixel
	trail_loop[trailindex] = trailpack;
	if (++trailindex >= traillength) // bump and wrap the index
	{
		trailindex = 0;
			// Once you've rolled over it's time to erase.
		trailfull = 1;
	}
	if (frontflag)
		putpixel(hdc, x, y, blankcolor);
}

#else // non STEREO

void near ipixel_3D(HDC hdc, short x, short y, short z, COLORREF color, struct bug* bug)
{ //grow.cpp
	struct trailrecord_3D trailpack;
	short tx, ty;
	long zbufferindex;
	unsigned short frontindex, nextindex;
	unsigned char newcolorindex, frontflag = 1;


// In the non-erasetrail mode, we write if the color is new.
	if (!erasetrailflag)
	{
// drop this condition because of headcolor
//		if (bug->getcolor != color)
		{
			putpixel(hdc, x, y, color);
		}
		return;
	}

// Drop through to this erasetrail 3D mode otherwise.
	if (trailfull)	// erase the old trail pixel
	{
		trailpack = trail_loop[trailindex];
		tx = TR_GET_X(trailpack);
		ty = TR_GET_Y(trailpack);
		if (trailpack.smearflag) // smear trail case
			BugBodyErase_near(hdc, tx, ty);
		// Erase a spot the size of a maximum bugbody at this spot
		zbufferindex = BUGLANDINDEX(tx, ty);
		frontindex = zbuffer[zbufferindex];
		if (frontindex == trailindex)
		{	// Then your pixel is in front.
			if (trailpack.behindindex == NONINDEX)
			{
				// Nobody behind you.
				if (trailpack.colorindex != BLANK_PAL_INDEX)
					putpixel(hdc, tx, ty, blankcolor);
				zbuffer[zbufferindex] = NONINDEX;
			}
			else
			{	//Someone behind you.
				newcolorindex = ~IGNORE_MASK &
					trail_loop[trailpack.behindindex].colorindex;
				putpixel(hdc, tx, ty,
					bugpalette[newcolorindex]);
				zbuffer[zbufferindex] = trailpack.behindindex;
			}
		}
		else // your pixel is not in front
		{
			while (TRUE)
			{
				nextindex = trail_loop[frontindex].behindindex;
				if (nextindex == trailindex)
					break;
				frontindex = nextindex;
			}
			// Now record guy behind your pixel.
			trail_loop[frontindex].behindindex = trailpack.behindindex;
		} // end your pixel not in front case.
	} // done erasing the old trail pixel

// Record info on the pixel you're going to write
	TR_SET_XYZ(trailpack,x,y,z);
	if (note_smearbody_flag)
	{
		trailpack.smearflag = 1;
		note_smearbody_flag = 0;
	}
	else
		trailpack.smearflag = 0;
	trailpack.colorindex = bug->writecolorindex;
// Now you have to work to set trailpack.behindindex
	zbufferindex = BUGLANDINDEX(x, y);
	frontindex = zbuffer[zbufferindex];

	if (frontindex == NONINDEX)
	{	// There is no point here in zubuff
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = NONINDEX;
	}
	else if (TR_GET_Z(trail_loop[frontindex]) >= z)
	{	// There is a zbuff point, it's equal or further than you
		// even if equal z, you go in front of it.
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = frontindex;
	}
	else
	{	// There is a zbuff point closer than you.
		frontflag = 0; // Don't paint this point.
		while (TRUE)
		{
			nextindex = trail_loop[frontindex].behindindex;
			if (nextindex == NONINDEX)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = NONINDEX;
				break;
			}
			// If you're here, then nextindex must be good.
			if ( TR_GET_Z(trail_loop[nextindex]) >= z)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = nextindex;
				break;
			}
			frontindex = nextindex;
		}
	}

	// NOW you can save the trail_loop info about your pixel
	trail_loop[trailindex] = trailpack;
	if (++trailindex >= traillength) // bump and wrap the index
	{
		trailindex = 0;
			// Once you've rolled over it's time to erase.
		trailfull = 1;
	}
// Write the new pixel if the color is different.
	if (frontflag && (GetPixel(hdcBugLand, x, y) != color) )
			putpixel(hdc, x, y, color);
}

void near edgeipixel_3D(HDC hdc, short x, short y, short z, COLORREF color, unsigned char writecolorindex)
{ //grow.cpp
// Difference between this and ipixel is that I don't use the bug
// param because I haven't set it's getcolor.  Instead I
// fill the bug slot with just the uchar of the bug's writecolor index.
// Also I OR in the IGNORE_MASK with the writecolorindex.
	struct trailrecord_3D trailpack;
	short tx, ty;
	long zbufferindex;
	unsigned short frontindex, nextindex;
	unsigned char newcolorindex, frontflag = 1;


// In the non-erasetrail mode, we write if the color is new.
	if (!erasetrailflag)
	{
		putpixel(hdc, x, y, color);
		return;
	}

// Drop through to this erasetrail 3D mode otherwise.
	if (trailfull)	// erase the old trail pixel
	{
		trailpack = trail_loop[trailindex];
		tx = TR_GET_X(trailpack);
		ty = TR_GET_Y(trailpack);
		if (trailpack.smearflag) // smear trail case
			BugBodyErase_near(hdc, tx, ty);
		// Erase a spot the size of a maximum bugbody at this spot
		zbufferindex = BUGLANDINDEX(tx, ty);
		frontindex = zbuffer[zbufferindex];
		if (frontindex == trailindex)
		{	// Then your pixel is in front.
			if (trailpack.behindindex == NONINDEX)
			{
				// Nobody behind you.
				if (trailpack.colorindex != BLANK_PAL_INDEX)
					putpixel(hdc, tx, ty, blankcolor);
				zbuffer[zbufferindex] = NONINDEX;
			}
			else
			{	//Someone behind you.
				newcolorindex = ~IGNORE_MASK &
					trail_loop[trailpack.behindindex].colorindex;
				putpixel(hdc, tx, ty,
					bugpalette[newcolorindex]);
				zbuffer[zbufferindex] = trailpack.behindindex;
			}
		}
		else // your pixel is not in front
		{
			while (TRUE)
			{
				nextindex = trail_loop[frontindex].behindindex;
				if (nextindex == trailindex)
					break;
				frontindex = nextindex;
			}
			// Now record guy behind your pixel.
			trail_loop[frontindex].behindindex = trailpack.behindindex;
		} // end your pixel not in front case.
	} // done erasing the old trail pixel

// Record info on the pixel you're going to write
	TR_SET_XYZ(trailpack,x,y,z);
	trailpack.colorindex = IGNORE_MASK | writecolorindex;
// Now you have to work to set trailpack.behindindex
	zbufferindex = BUGLANDINDEX(x, y);
	frontindex = zbuffer[zbufferindex];

	if (frontindex == NONINDEX)
	{	// There is no point here in zubuff
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = NONINDEX;
	}
	else if (TR_GET_Z(trail_loop[frontindex]) >= z)
	{	// There is a zbuff point, it's equal or further than you
		// even if equal z, you go in front of it.
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = frontindex;
	}
	else
	{	// There is a zbuff point closer than you.
		frontflag = 0; // Don't paint this point.
		while (TRUE)
		{
			nextindex = trail_loop[frontindex].behindindex;
			if (nextindex == NONINDEX)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = NONINDEX;
				break;
			}
			// If you're here, then nextindex must be good.
			if ( TR_GET_Z(trail_loop[nextindex]) >= z)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = nextindex;
				break;
			}
			frontindex = nextindex;
		}
	}

	// NOW you can save the trail_loop info about your pixel
	trail_loop[trailindex] = trailpack;
	if (++trailindex >= traillength) // bump and wrap the index
	{
		trailindex = 0;
			// Once you've rolled over it's time to erase.
		trailfull = 1;
	}
// Write the new pixel.
	if (frontflag)
		putpixel(hdc, x, y, color);
}

void near blankipixel_3D(HDC hdc, short x, short y, short z)
{ //grow.cpp
// don't need color or bug.

	struct trailrecord_3D trailpack;
	short tx, ty;
	long zbufferindex;
	unsigned short frontindex, nextindex;
	unsigned char newcolorindex, frontflag = 1;


// In the non-erasetrail mode, we always write.
	if (!erasetrailflag)
	{
		putpixel(hdc, x, y, blankcolor);
		return;
	}

// Drop through to this erasetrail 3D mode otherwise.
	if (trailfull)	// erase the old trail pixel
	{
		trailpack = trail_loop[trailindex];
		tx = TR_GET_X(trailpack);
		ty = TR_GET_Y(trailpack);
		if (trailpack.smearflag) // smear trail case
			BugBodyErase_near(hdc, tx, ty);
		// Erase a spot the size of a maximum bugbody at this spot
		zbufferindex = BUGLANDINDEX(tx, ty);
		frontindex = zbuffer[zbufferindex];
		if (frontindex == trailindex)
		{	// Then your pixel is in front.
			if (trailpack.behindindex == NONINDEX)
			{
				// Nobody behind you.
				if (trailpack.colorindex != BLANK_PAL_INDEX)
					putpixel(hdc, tx, ty, blankcolor);
				zbuffer[zbufferindex] = NONINDEX;
			}
			else
			{	//Someone behind you.
				newcolorindex = ~IGNORE_MASK &
					trail_loop[trailpack.behindindex].colorindex;
				putpixel(hdc, tx, ty,
					bugpalette[newcolorindex]);
				zbuffer[zbufferindex] = trailpack.behindindex;
			}
		}
		else // your pixel is not in front
		{
			while (TRUE)
			{
				nextindex = trail_loop[frontindex].behindindex;
				if (nextindex == trailindex)
					break;
				frontindex = nextindex;
			}
			// Now record guy behind your pixel.
			trail_loop[frontindex].behindindex = trailpack.behindindex;
		} // end your pixel not in front case.
	} // done erasing the old trail pixel

// Record info on the pixel you're going to write
	TR_SET_XYZ(trailpack,x,y,z);
	trailpack.colorindex = BLANK_PAL_INDEX;
// Now you have to work to set trailpack.behindindex
	zbufferindex = BUGLANDINDEX(x, y);
	frontindex = zbuffer[zbufferindex];

	if (frontindex == NONINDEX)
	{	// There is no point here in zubuff
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = NONINDEX;
		frontflag = 0;
		// You don't need to write a blank if nothing there.
	}
	else if (TR_GET_Z(trail_loop[frontindex]) >= z)
	{	// There is a zbuff point, it's equal or further than you
		// even if equal z, you go in front of it.
		zbuffer[zbufferindex] = trailindex;
		trailpack.behindindex = frontindex;
	}
	else
	{	// There is a zbuff point closer than you.
		frontflag = 0; // Don't paint this point.
		while (TRUE)
		{
			nextindex = trail_loop[frontindex].behindindex;
			if (nextindex == NONINDEX)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = NONINDEX;
				break;
			}
			// If you're here, then nextindex must be good.
			if ( TR_GET_Z(trail_loop[nextindex]) >= z)
			{
				trail_loop[frontindex].behindindex = trailindex;
				trailpack.behindindex = nextindex;
				break;
			}
			frontindex = nextindex;
		}
	}

	// NOW you can save the trail_loop info about your pixel
	trail_loop[trailindex] = trailpack;
	if (++trailindex >= traillength) // bump and wrap the index
	{
		trailindex = 0;
			// Once you've rolled over it's time to erase.
		trailfull = 1;
	}
	if (frontflag)
		putpixel(hdc, x, y, blankcolor);
}

#endif // STEREO

void near setgetcolor_3D(short x, short y, short z, struct bug *bug)
{ //grow.cpp
	unsigned short frontindex;
	struct trailrecord_3D trailpack;

	frontindex = zbuffer[BUGLANDINDEX(x,y)];
	bug->getcolor = blankcolor;
	while (TRUE)
	{
		if (frontindex == NONINDEX)
			break;
		trailpack = trail_loop[frontindex];
		if (TR_GET_Z(trailpack) == z &&
			trailpack.colorindex != BLANK_PAL_INDEX &&
			!(trailpack.colorindex & IGNORE_MASK) )
		{ // Dig under overwritten blank cells and ignore IGNORE_MASK
			//decoration cells (from thick_bresen_3D)
			bug->getcolor =bugpalette[trailpack.colorindex];
			break;
		}
		if (TR_GET_Z(trailpack) > z)
			break;
		frontindex = trailpack.behindindex;
	}
}


void near isquare_2D(HDC hdc, struct bug* bug)
{ //grow.cpp
	short i, lx, rx, ty, by, curx, cury;

	if (!bug->radius)
		return;

	// Eventually I should put in a switch for the first four
	// or five radii and only use algorithm for higher values.

	lx = bug->oldoldx - bug->radius;
	rx = bug->oldoldx + bug->radius;
	ty = bug->oldoldy - bug->radius;
	by = bug->oldoldy + bug->radius;

	for (i = lx; i <= rx; i++)
	{	// Draw top and bottom edges with endpoints
		curx = XWRAP(i);
		cury = YWRAP(ty);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{//broke
			justeatgetcolor(bug);
			if (!bug->meetflag)
				ipixel_2D(hdc, curx, cury, bug->oldcolor, bug);
			else
#ifndef MONOMEET
#ifndef BRIGHTMEET
				ipixel_2D(hdc, curx, cury, bug->getcolor |
					bug->oldcolor, bug);
#else //BRIGHTMEET
				ipixel_2D(hdc, curx, cury,
					bug->meetflag==JABBERMEET?
					bug->jabbermeet:bug->wockymeet, bug);
				
#endif //BRIGHTMEET
#else //MONOMEET
				ipixel_2D(hdc, curx, cury, meetcolor, bug);
#endif //MONOMEET
		}
		cury = YWRAP(by);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			if (!bug->meetflag)
				ipixel_2D(hdc, curx, cury, bug->oldcolor, bug);
			else
#ifndef MONOMEET
#ifndef BRIGHTMEET
				ipixel_2D(hdc, curx, cury, bug->getcolor |
					bug->oldcolor, bug);
#else //BRIGHTMEET
				ipixel_2D(hdc, curx, cury,
					bug->meetflag==JABBERMEET?
					bug->jabbermeet:bug->wockymeet, bug);
				
#endif //BRIGHTMEET
#else //MONOMEET
				ipixel_2D(hdc, curx, cury, meetcolor, bug);
#endif //MONOMEET
		}
	}
	for (i = ty + 1; i < by; i++)
	{	// Draw left and right edges without endpoints
		curx = XWRAP(lx);
		cury = YWRAP(i);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			if (!bug->meetflag)
				ipixel_2D(hdc, curx, cury, bug->oldcolor, bug);
			else
#ifndef MONOMEET
#ifndef BRIGHTMEET
				ipixel_2D(hdc, curx, cury, bug->getcolor |
					bug->oldcolor, bug);
#else //BRIGHTMEET
				ipixel_2D(hdc, curx, cury,
					bug->meetflag==JABBERMEET?
					bug->jabbermeet:bug->wockymeet, bug);
				
#endif //BRIGHTMEET
#else //MONOMEET
				ipixel_2D(hdc, curx, cury, meetcolor, bug);
#endif //MONOMEET
		}
		curx = XWRAP(rx);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			if (!bug->meetflag)
				ipixel_2D(hdc, curx, cury, bug->oldcolor, bug);
			else
#ifndef MONOMEET
#ifndef BRIGHTMEET
				ipixel_2D(hdc, curx, cury, bug->getcolor |
					bug->oldcolor, bug);
#else //BRIGHTMEET
				ipixel_2D(hdc, curx, cury,
					bug->meetflag==JABBERMEET?
					bug->jabbermeet:bug->wockymeet, bug);
				
#endif //BRIGHTMEET
#else //MONOMEET
				ipixel_2D(hdc, curx, cury, meetcolor, bug);
#endif //MONOMEET
		}
		cury = YWRAP(by);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			if (!bug->meetflag)
				ipixel_2D(hdc, curx, cury, bug->oldcolor, bug);
			else
#ifndef MONOMEET
#ifndef BRIGHTMEET
				ipixel_2D(hdc, curx, cury, bug->getcolor |
					bug->oldcolor, bug);
#else //BRIGHTMEET
				ipixel_2D(hdc, curx, cury,
					bug->meetflag==JABBERMEET?
					bug->jabbermeet:bug->wockymeet, bug);
				
#endif //BRIGHTMEET
#else //MONOMEET
				ipixel_2D(hdc, curx, cury, meetcolor, bug);
#endif //MONOMEET
		}
	}
}

void near isquare_3D(HDC hdc, struct bug* bug)
{ //grow.cpp
	short i, lx, rx, ty, by, curx, cury;

	if (!bug->radius)
		return;

	// Eventually I should put in a switch for the first four
	// or five radii and only use algorithm for higher values.

	lx = bug->oldoldx - bug->radius;
	rx = bug->oldoldx + bug->radius;
	ty = bug->oldoldy - bug->radius;
	by = bug->oldoldy + bug->radius;

	for (i = lx; i <= rx; i++)
	{	// Draw top and bottom edges with endpoints
		curx = XWRAP(i);
		cury = YWRAP(ty);
// Write if the visible color is neither the same nor a wall.
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			ipixel_3D(hdc, curx, cury, bug->oldoldz, bug->oldcolor,
				bug);
		}
		cury = YWRAP(by);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			ipixel_3D(hdc, curx, cury, bug->oldoldz, bug->oldcolor,
				bug);
		}
	}
	for (i = ty + 1; i < by; i++)
	{	// Draw left and right edges without endpoints
		curx = XWRAP(lx);
		cury = YWRAP(i);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			ipixel_3D(hdc, curx, cury, bug->oldoldz, bug->oldcolor,
				bug);
		}
		curx = XWRAP(rx);
		bug->getcolor = GetPixel(hdcBugLand, curx, cury);
		if (bug->getcolor != wallcolor)
		{
			justeatgetcolor(bug);
			ipixel_3D(hdc, curx, cury, bug->oldoldz, bug->oldcolor,
				bug);
		}
	}
}


void near bresen_2D(HDC hdc, short xa, short ya, short xb, short yb, COLORREF color,
	struct bug* bug, void near (*pixel)(HDC, short, short, COLORREF, struct bug*))
{ //grow.cpp
// Always draw at least one pixel, the first.  If start and finish
// are not the same, then you don't draw the last point.

	short dx, dy, absdx, absdy, octbug = 0, g, inc1, inc2, i;

	dx = xb - xa;
	dy = yb - ya;
	absdx = ABS(dx);
	absdy = ABS(dy);
	if (dx < 0)
		octbug |= 1;
	if (dy < 0)
		octbug |= 2;
	if (absdx < absdy)
		octbug |= 4;
	switch (octbug)
	{
		case 0: // start=end case, or gentle, pos dy, pos dx
			if (!absdx)
				pixel(hdc, xa, ya, color, bug);
			else
			{
				inc1 = absdy << 1;
				g = inc1 - absdx;
				inc2 = g - absdx;
				for (i=0; i < absdx; i++)
				{
					pixel(hdc, xa, ya, color, bug);
					xa++;
					if (g >= 0) {
						ya++;
						g += inc2;
					}
					else
						g += inc1;
				}
			}
			break;

		case 1: // gentle, pos dy, neg dx
			inc1 = absdy << 1;
			g = inc1 - absdx;
			inc2 = g - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya , color, bug);
				xa--;
				if (g >= 0) {
					ya++;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;

		case 2: // gentle, neg dy, pos dx
			inc1 = absdy << 1;
			g = inc1 - absdx;
			inc2 = g - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya , color, bug);
				xa++;
				if (g >= 0) {
					ya--;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;

		case 3: // gentle, neg dy, neg dx
			inc1 = absdy << 1;
			g = inc1 - absdx;
			inc2 = g - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya , color, bug);
				xa--;
				if (g >= 0) {
					ya--;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;

		case 4: // steep, pos dy, posdx
			inc1 = absdx << 1;
			g = inc1 - absdy;
			inc2 = g - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, color, bug);
				ya++;
				if (g > 0)
				{
					xa++;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;

		case 5: // steep, pos dy, neg dx
			inc1 = absdx << 1;
			g = inc1 - absdy;
			inc2 = g - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, color, bug);
				ya++;
				if (g > 0)
				{
					xa--;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;

		case 6: // steep, neg dy, pos dx
			inc1 = absdx << 1;
			g = inc1 - absdy;
			inc2 = g - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, color, bug);
				ya--;
				if (g > 0)
				{
					xa++;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;

		case 7: // steep, neg dy, neg dx
			inc1 = absdx << 1;
			g = inc1 - absdy;
			inc2 = g - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, color, bug);
				ya--;
				if (g > 0)
				{
					xa--;
					g += inc2;
				}
				else
					g += inc1;
			}
			break;
	}
}

void near bresen_3D(HDC hdc, short xa, short ya, short za, short xb, short yb,
	short zb, COLORREF color, struct bug* bug,
	void near (*pixel)(HDC, short, short, short, COLORREF, struct bug*))
{ //grow.cpp
// Always draw at least one pixel, the first.  If start and finish
// are not the same, then you don't draw the last point.

	short dx, dy, dz, absdx, absdy, absdz, octbug = 0, i,
		gx, inc1x, inc2x, gy, inc1y, inc2y, gz, inc1z, inc2z;

	dx = xb - xa;
	dy = yb - ya;
	dz = zb - za;
	absdx = ABS(dx);
	absdy = ABS(dy);
	absdz = ABS(dz);
	if (dx < 0)
		octbug |= 1;
	if (dy < 0)
		octbug |= 2;
	if (dz < 0)
		octbug |= 4;
	if (absdx < absdy || absdx < absdz) // x not the longest
	{
		octbug += 8;
		if (absdy < absdz) // y not the longest
			octbug += 8;
	}
	// cases 0 thru 7 have absdx longest, 8 - 15 have absdy longest,
	// 16-23 have absdz longest.
	
	switch (octbug)
	{
		case 0: // start=end case, or x-longest, pos dy, pos dx, pos dz
			if (!absdx)
				return;
			else
			{
				inc1y= absdy << 1;
				gy = inc1y - absdx;
				inc2y = gy - absdx;
				inc1z= absdz << 1;
				gz = inc1z - absdx;
				inc2z = gz - absdx;
				for (i=0; i < absdx; i++)
				{
					pixel(hdc, xa, ya, za, color, bug);
					xa++;
					if (gy >= 0) {
						ya++;
						gy += inc2y;
					}
					else
						gy += inc1y;
					if (gz >= 0) {
						za++;
						gz += inc2z;
					}
					else
						gz += inc1z;
				}
			}
			break;

		case 1: // x-longest, pos dy, neg dx, pos dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa--;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 2: // x-longest, neg dy, pos dx, pos dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa++;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 3: // x-longest, neg dy, neg dx, pos dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa--;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 4: // x-longest, pos dy, pos dx, neg dz
			inc1y= absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z= absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa++;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 5: // x-longest, pos dy, neg dx, neg dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa--;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 6: // x-longest, neg dy, pos dx, neg dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa++;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 7: // x-longest, neg dy, neg dx, neg dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				pixel(hdc, xa, ya, za, color, bug);
				xa--;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 8: // y-longest, pos dy, posdx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 9: // y-longest, pos dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 10:// y-longest, neg dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 11:// y-longest, neg dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;
		case 12:// y-longest, pos dy, posdx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 13:// y-longest, pos dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 14:// y-longest, neg dy, pos dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 15:// y-longest, neg dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;

			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				ya--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 16: // z-longest, pos dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;

			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 17:// z-longest, pos dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 18:// z-longest, neg dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 19:// z-longest, neg dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 20:// z-longest, pos dy, posdx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 21:// z-longest, pos dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 22:// z-longest, neg dy, pos dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 23:// z-longest, neg dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				pixel(hdc, xa , ya, za, color, bug);
				za--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;
	}
}

void near thick_bresen_3D(HDC hdc, short xa, short ya, short za, short xb,
	short yb, short zb, COLORREF ccolor, COLORREF ecolor, struct bug* bug,
	void near (*cpixel)(HDC, short, short, short, COLORREF, struct bug*),
	void near (*epixel)(HDC, short, short, short, COLORREF, struct bug*, char))
{ //grow.cpp
// Always draw at least one pixel, the first.  If start and finish
// are not the same, then you don't draw the last point.

	short dx, dy, dz, absdx, absdy, absdz, octbug = 0, i,
		gx, inc1x, inc2x, gy, inc1y, inc2y, gz, inc1z, inc2z;


	dx = xb - xa;
	dy = yb - ya;
	dz = zb - za;
	absdx = ABS(dx);
	absdy = ABS(dy);
	absdz = ABS(dz);
	if (dx < 0)
		octbug |= 1;
	if (dy < 0)
		octbug |= 2;
	if (dz < 0)
		octbug |= 4;
	if (absdx < absdy || absdx < absdz) // x not the longest
	{
		octbug += 8;
		if (absdy < absdz) // y not the longest
		{
			octbug += 8;
		}	
	}
	// cases 0 thru 7 have absdx longest, 8 - 15 have absdy longest,
	// 16-23 have absdz longest and absdx longer than absdy,
	// 24-29 have absdz longest and absdy longer than absdx.
	
	switch (octbug)
	{
		case 0: // start=end case, or x-longest, pos dy, pos dx, pos dz
			if (!absdx && !absdy && !absdz)
				cpixel(hdc, xa, ya, za, ccolor, bug);
			else
			{
				inc1y= absdy << 1;
				gy = inc1y - absdx;
				inc2y = gy - absdx;
				inc1z= absdz << 1;
				gz = inc1z - absdx;
				inc2z = gz - absdx;
				for (i=0; i < absdx; i++)
				{
					cpixel(hdc, xa, ya, za, ccolor, bug);
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa++;
					if (gy >= 0) {
						ya++;
						gy += inc2y;
					}
					else
						gy += inc1y;
					if (gz >= 0) {
						za++;
						gz += inc2z;
					}
					else
						gz += inc1z;
				}
			}
			break;

		case 1: // x-longest, pos dy, neg dx, pos dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa--;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 2: // x-longest, neg dy, pos dx, pos dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa++;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 3: // x-longest, neg dy, neg dx, pos dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa--;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 4: // x-longest, pos dy, pos dx, neg dz
			inc1y= absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z= absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa++;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 5: // x-longest, pos dy, neg dx, neg dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa--;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 6: // x-longest, neg dy, pos dx, neg dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa++;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 7: // x-longest, neg dy, neg dx, neg dz
			inc1y = absdy << 1;
			gy = inc1y - absdx;
			inc2y = gy - absdx;
			inc1z = absdz << 1;
			gz = inc1z - absdx;
			inc2z = gz - absdx;
			for (i=0; i < absdx; i++)
			{
				cpixel(hdc, xa, ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'y');
				xa--;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 8: // y-longest, pos dy, posdx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 9: // y-longest, pos dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 10:// y-longest, neg dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 11:// y-longest, neg dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za++;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;
		case 12:// y-longest, pos dy, posdx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 13:// y-longest, pos dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 14:// y-longest, neg dy, pos dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 15:// y-longest, neg dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdy;
			inc2x = gx - absdy;
			inc1z = absdz << 1;
			gz = inc1z - absdy;
			inc2z = gz - absdy;
			for (i=0; i < absdy; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				epixel(hdc, xa, ya, za, ecolor, bug, 'x');
				ya--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gz >= 0) {
					za--;
					gz += inc2z;
				}
				else
					gz += inc1z;
			}
			break;

		case 16: // z-longest, pos dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 17:// z-longest, pos dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 18:// z-longest, neg dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 19:// z-longest, neg dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 20:// z-longest, pos dy, posdx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 21:// z-longest, pos dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 22:// z-longest, neg dy, pos dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 23:// z-longest, neg dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					epixel(hdc, xa, ya, za, ecolor, bug, 'y');
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 24: // z-longest, pos dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 25:// z-longest, pos dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 26:// z-longest, neg dy, pos dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 27:// z-longest, neg dy, neg dx, posdz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za++;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 28:// z-longest, pos dy, posdx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 29:// z-longest, pos dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya++;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 30:// z-longest, neg dy, pos dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					xa++;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;

		case 31:// z-longest, neg dy, neg dx, neg dz
			inc1x = absdx << 1;
			gx = inc1x - absdz;
			inc2x = gx - absdz;
			inc1y = absdy << 1;
			gy = inc1y - absdz;
			inc2y = gy - absdz;
			for (i=0; i < absdz; i++)
			{
				cpixel(hdc, xa , ya, za, ccolor, bug);
				za--;
				if (gx > 0)
				{
					xa--;
					gx += inc2x;
				}
				else
					gx += inc1x;
				if (gy >= 0) {
					epixel(hdc, xa, ya, za, ecolor, bug, 'x');
					ya--;
					gy += inc2y;
				}
				else
					gy += inc1y;
			}
			break;
	}
}

//--------Code for trailline and its bugSetPixel function---------------

void near bugSetPixel_2D( HDC hdc, short x, short y, COLORREF color,
	struct bug* bug)
{ // grow.cpp Use in trailline.  Affects readorder.
// Check that you're not frozen.
	if (bug->readcolorcode == WALL_CASE)
		return;

	// Read the getcolor.  If the getcolor is -1 you are off the BugLand
	// edge, so you need to wrap and read it again.  I THINK this is
	// faster than always wrapping, given that most pixels
	// aren't wrap ones.
	if( (bug->getcolor = GetPixel(hdcBugLand, x, y)) == -1)
	{
		x = XWRAP(x);
		y = YWRAP(y);
		bug->getcolor = GetPixel(hdcBugLand, x, y);
	}
	if (!startlineflag)
	{
		eatgetcolor(bug); //Eats the value and sets the meetflag.
		if (!bug->meetflag)
			ipixel_2D(hdc,x,y,color,bug);
		else // Special color for overwrite
			ipixel_2D(hdc, x, y, bug->meetflag==JABBERMEET?
				bug->jabbermeet:bug->wockymeet, bug);
	}
	else
	{
		if (!bug->oldmeetflag)
			ipixel_2D(hdc,x,y,color,bug);
		else // Special color for overwrite
			ipixel_2D(hdc, x, y, bug->oldmeetflag==JABBERMEET?
				bug->jabbermeet:bug->wockymeet, bug);
		bug->oldmeetflag = bug->meetflag;
		startlineflag = 0;
	}
}

void near bugSetPixel_3D( HDC hdc, short x, short y, short z, COLORREF color, struct bug* bug)
{ //grow.cpp This gets used in bresen_3d to draw the line


// Check that you're not frozen.
	if (bug->readcolorcode == WALL_CASE)
		return;

	x = XWRAP(x);
	y = YWRAP(y);
	z = ZWRAP(z);

	setgetcolor_3D(x, y, z, bug);
	if (!startlineflag)
	{
		eatgetcolor(bug); //Eats the value and sets the meetflag.
		if (!bug->meetflag)
			ipixel_3D(hdc, x, y, z, color, bug);
		else // Special color for overwrite
			ipixel_3D(hdc, x, y,  z,bug->meetflag==JABBERMEET?
				bug->jabbermeet:bug->wockymeet, bug);
	}
	else
	{
		if (!bug->oldmeetflag)
			ipixel_3D(hdc, x, y, z, color, bug);
		else // Special color for overwrite
			ipixel_3D(hdc, x, y,  z,bug->oldmeetflag==JABBERMEET?
				bug->jabbermeet:bug->wockymeet, bug);
		bug->oldmeetflag = bug->meetflag;
		startlineflag = 0;
	}
}

void near edgeSetPixel_3D( HDC hdc, short x, short y, short z, COLORREF color, struct bug* bug, char axis)
{ // grow.cpp Used in bresen_3d to draw the edge around the line.

	short t, width, i;
//	unsigned char writecolorindex;

// Check that you're not frozen.
	if (bug->readcolorcode == WALL_CASE)
		return;

	switch (bug->lineflag)
	{	// case 0: is NO LINE.  In this case I wouldn't be here.
		case 1: //THIN
			return;
		case 2: //THINBLACK
			switch (axis)
			{
				case 'x':
					t = XWRAP(x-1);
					y = YWRAP(y);
					z = ZWRAP(z);
					blankipixel_3D(hdc, t, y, z);
					t = XWRAP(x+1);
					blankipixel_3D(hdc, t, y, z);
					break;
				case 'y':
					x = XWRAP(x);
					t = YWRAP(y-1);
					z = ZWRAP(z);
					blankipixel_3D(hdc, x, t, z);
					t = YWRAP(y+1);
					blankipixel_3D(hdc, x, t, z);
					break;
			}
			break;
		case 3:  //THICK
			switch (axis)
			{
				case 'x':
					t = XWRAP(x-2);
					y = YWRAP(y);
					z = ZWRAP(z);
					blankipixel_3D(hdc, t, y, z);
					t = XWRAP(x-1);
					edgeipixel_3D(hdc, t, y, z, color,
						bug->writecolorindex);
					t = XWRAP(x+1);
					edgeipixel_3D(hdc, t, y, z, color,
						bug->writecolorindex);
					t = XWRAP(x+2);
					blankipixel_3D(hdc, t, y, z);
					break;
				case 'y':
					x = XWRAP(x);
					t = YWRAP(y-2);
					z = ZWRAP(z);
					blankipixel_3D(hdc, x, t, z);
					t = YWRAP(y-1);
					edgeipixel_3D(hdc, x, t, z, color,
						bug->writecolorindex);
					t = YWRAP(y+1);
					edgeipixel_3D(hdc, x, t, z, color,
						bug->writecolorindex);
					t = YWRAP(y+2);
					blankipixel_3D(hdc, x, t, z);
					break;
			}
			break;
		case 4: //THICKVAR
			width = (MAX_RIBBON_WIDTH - 1) - 
				( ( MAX_RIBBON_WIDTH * (long)z) / (long)BugLand_CZ );
			// as z goes from 0 to BugLand_CZ, width goes from
			// MAX_RIBBON_WIDTH - 1 down to 0
			switch (axis)
			{
				case 'x':
					y = YWRAP(y);
					z = ZWRAP(z);
					t = XWRAP(x-width-1);
					blankipixel_3D(hdc, t, y, z);
					for (i= -width; i<0; i++)
					{
						t = XWRAP(x+i);
						edgeipixel_3D(hdc, t, y, z, color,
							bug->writecolorindex);
					}
					for (i= 1; i<=width; i++)
					{
						t = XWRAP(x+i);
						edgeipixel_3D(hdc, t, y, z, color,
							bug->writecolorindex);
					}
					t = XWRAP(x+width+1);
					blankipixel_3D(hdc, t, y, z);
					break;
				case 'y':
					x = XWRAP(x);
					z = ZWRAP(z);
					t = YWRAP(y-width-1);
					blankipixel_3D(hdc, x, t, z);
					for (i= -width; i<0; i++)
					{
						t = YWRAP(y+i);
						edgeipixel_3D(hdc, x, t, z, color,
							bug->writecolorindex);
					}
					for (i= 1; i<=width; i++)
					{
						t = YWRAP(y+i);
						edgeipixel_3D(hdc, x, t, z, color,
							bug->writecolorindex);
					}
					t = YWRAP(y+width+1);
					blankipixel_3D(hdc, x, t, z);
					break;
			}
			break;
#ifdef OLDSTEREO
		case 5: //STEREO
			y = YWRAP(y);
			z = ZWRAP(z);
// Get the next formula by drawing a right triangle into the screen
// with long side NosePix + z and short side EyePix.  The line
// from the right eye goes in perpendicular and the line from the
// left eye slants.  The length between these lines at the screen
// interesection is given by the formula:
			t = ((float)z * EyePix)/((float)z + NosePix);
// I tried this way first, it's backwards.
//			t = (BugLand_StereoShift * z ) / (float)BugLand_CZ;
			t = XWRAP(x-t);
			edgeipixel_3D(hdc, t, y, z, bluecolor,
				bug->writecolorindex);
			break;
#endif //OLDSTEREO
	}
}

void near trailpixel(HDC hdc, struct bug *bug)
{ //grow.cpp affects readorder  
// Use oldmeetflag because it was set way back in last cycle of eat,
// at the then x,y which is the now oldx oldy that trailpixel writes at.
	if (!three_d_flag)
	{
		if (!bug->oldmeetflag)
			ipixel_2D(hdc, bug->oldx, bug->oldy,
				bugpalette[bug->writecolorindex], bug);
		else
			ipixel_2D(hdc, bug->oldx, bug->oldy,
				bug->oldmeetflag==JABBERMEET?bug->jabbermeet:bug->wockymeet, bug);
	}
	else
	{
		if (!bug->oldmeetflag)
			ipixel_3D(hdc, bug->oldx, bug->oldy, bug->oldz,
				bugpalette[bug->writecolorindex], bug);
		else
			ipixel_3D(hdc, bug->oldx, bug->oldy, bug->oldz,
				bug->oldmeetflag==JABBERMEET?bug->jabbermeet:bug->wockymeet, bug);
	}
	bug->oldmeetflag = bug->meetflag;
}

void near headpixel(HDC hdc, struct bug *bug)
{
	if (!three_d_flag)
		ipixel_2D(hdc, bug->x, bug->y, headcolor, bug);
	else
		ipixel_3D(hdc, bug->x, bug->y, bug->z, headcolor, bug);
}

void near trailline(HDC hdc, struct bug* bug)
{ //grow.cpp
	startlineflag = 1;
	// Use this to signal bugSetPixel_?D not to eat the first
	// pixel, as it was already eaten last time at the end of
	// the line.

	// kill wrap line
	if (ABS(bug->oldx - bug->nonwrapx) > BugLand_MIDX ||
		ABS(bug->oldy - bug->nonwrapy) > BugLand_MIDY)
	{
		startlineflag = 0;
		return;
	}

	if (!three_d_flag)
		bresen_2D(hdc, bug->oldx, bug->oldy, bug->nonwrapx,
		bug->nonwrapy, bugpalette[bug->writecolorindex],
		bug, bugSetPixel_2D);
	else
	{
// kill wrap line
		if (ABS(bug->oldz - bug->nonwrapz) > BugLand_MIDZ)
		{
			startlineflag = 0;
			return;
		}

		if (bug->lineflag == 1)
			bresen_3D(hdc, bug->oldx, bug->oldy, bug->oldz,
				bug->nonwrapx, bug->nonwrapy, bug->nonwrapz,
				bugpalette[bug->writecolorindex], bug, bugSetPixel_3D);
		else
			thick_bresen_3D(hdc, bug->oldx, bug->oldy, bug->oldz,
				bug->nonwrapx, bug->nonwrapy, bug->nonwrapz,
				bugpalette[bug->writecolorindex],
				bugpalette[bug->writecolorindex],
				bug, bugSetPixel_3D, edgeSetPixel_3D );
	}
}

void near trailsquare(HDC hdc, struct bug* bug)
{ //grow.cpp
	if (!three_d_flag)
		isquare_2D(hdc, bug);
	else
		isquare_3D(hdc, bug);
}
//-------------------CA maintenance----------------

void near CAput(short x, short y, unsigned char colorindex)
{	// Used in ipixel, keep in grow.cpp
#ifdef SMALL_CA
	unsigned short CAindex;
#else
	long CAindex;
#endif //SMALL_CA

	if (x < CALand_CX && y < CALand_CY)
	{ //Flip y since DIBs are upside down.
		y = CALand_MAXY - y; 
#ifndef SMALL_CA
		CAindex = CALand_CX * (long) y + x;
#else
		CAindex = CALand_CX * y + x;
#endif //SMALL_CA
		CAbuffer0[CAindex] = CAbuffer1[CAindex] =
			colorindex | CAPutMask;
	}
}


//--------Miscillaneous Utilities.

void near storepositions(void)
{ //With grow.cpp.  Is used by cornerbugs and randomzizepositions
// as well.
	unsigned char i;

	for (i=0; i < livebugcount; i++)
	{
		Bug[bugnum[i]]->olddir = Bug[bugnum[i]]->dir;
		Bug[bugnum[i]]->oldoldx = Bug[bugnum[i]]->oldx;
		Bug[bugnum[i]]->oldoldy = Bug[bugnum[i]]->oldy;
		Bug[bugnum[i]]->oldx = Bug[bugnum[i]]->x;
		Bug[bugnum[i]]->oldy = Bug[bugnum[i]]->y;
		if (three_d_flag)
		{
			Bug[bugnum[i]]->oldoldz = Bug[bugnum[i]]->oldz;
			Bug[bugnum[i]]->oldz = Bug[bugnum[i]]->z;
		}
		Bug[bugnum[i]]->oldtan = Bug[bugnum[i]]->tan;
	}
}

/* Let's not bother with this.
void adjusttraillength_2D(HDC hdc, unsigned short newlength,
	unsigned short oldlength, unsigned char colnumber)
{	// Is used in world.cpp so can't be near.  But must stay
	// with grow.cpp because it calls putpixel which is near in grow.cpp.
	unsigned short i;
	struct trailrecord_2D trailpack;

	if (newlength > oldlength)
	{ // Do fresh nonerase save into the new slots.
		colony_trailindex[colnumber] = oldlength;
		colony_trailfull[colnumber] = 0;
		return;
	}
	// Otherwise we are shrinking the trail
	if (colony_trailindex[colnumber] >= newlength)
	{
		colony_trailfull[colnumber] = 1;
		colony_trailindex[colnumber] = 0;
	}
	for (i=newlength; i<oldlength; i++)
	{
		trailpack = colony_trail_loop[colnumber][i];
		putpixel(hdc, trailpack.x, trailpack.y, blankcolor);
	}
}
*/

#ifdef TURMITE_TAN

void near turmitetan3D(struct bug *bug)
{
	bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,
		bug->nonwrapz - bug->oldz); 
	bug->tan.Unify(); //Now normalize tan, maintain as in flock().
}

void near turmitetan2D(struct bug *bug)
{
	bug->tan.Set(bug->nonwrapx - bug->oldx, bug->nonwrapy - bug->oldy,0.0);
	bug->tan.Unify(); //Now normalize tan, maintain as in flock().
}

#endif //TURMITE_TAN