#include "bug.h"
#include "bugdir.h"
#include <windows.h>
#include <dos.h>
#include <math.h>
#include <malloc.h>

extern HWND hwnd;

#ifdef BRIGHTMEET
extern COLORREF meetcolor01, meetcolor02, meetcolor12;
#endif //BRIGHTMEET

extern short Pair[MAXSTATES][CASECOUNT];// Double arrays need the size.
extern short BugLand_CX, BugLand_CY, Bugland_CZ, BugLand_MAXX,
	BugLand_MAXY, BugLand_MAXZ, Screen_CX, Screen_CY, wrapminx, wrapminy,
	wrapmaxx, wrapmaxy, wrapminz, wrapmaxz;
extern unsigned char colonycount, bugspercolony, livebugcount,
	ecology, three_d_flag, globalmetricflag, wrapflag, editbugid,
	carryflag, isolatedflag;
extern struct bug *Bug[];
extern unsigned char bugnum[];
extern struct colony Colony[];
extern unsigned char weak_pal_index[];
extern unsigned char strong_pal_index[];
extern unsigned char recruitflag;
extern short cursormode;
extern short bugeatvalue[MAXCOLONIES][MAXCOLONIES];
extern short BugLand_CX, BugLand_CY, BugLand_CZ;
extern short mesh_size, wrapminx, wrapminy;
extern unsigned short day[];
//for adjusttraillength_3D
//extern unsigned short trailindex;
//extern unsigned char trailfull, worldclearflag;
//for recruit's trail adjusments
extern unsigned char colony_erasetrailflag[];
extern unsigned short colony_traillength[];

extern void near turmite2D( struct bug *);
extern void near turmite3D( struct bug *);
extern void near boid2D( struct bug *);
extern void near boid3D( struct bug *);
extern void near wolf2D( struct bug *);
extern void near wolf3D( struct bug *);
extern void near beaver2D( struct bug *);
extern void near beaver3D( struct bug *);
extern void near dog2D( struct bug *);
extern void near dog3D( struct bug *);
extern void near owl2D( struct bug *);
extern void near owl3D( struct bug *);
extern void near carry2D( struct bug *);
extern void near carry3D( struct bug *);
extern void near wrap2D(struct bug *bug);
extern void near wrap3D(struct bug *bug);
extern void near eatapixel_2D(struct bug *);
extern void near eatapixel_3D(struct bug *);
extern void near noneat(struct bug *);
extern void DNA_to_RNA(struct bug*);
extern void enzymecopy(struct bug *, struct bug *);

void putbugsincolonies(unsigned char *);
void installbugeatvalue(void);
void changetrailcolors(struct bug *);
void changestates(struct bug *, unsigned char);
void installdirectiontype(struct bug *);
void near updateglobalmetricflag(void);
void adjustwrapparms(void);
void bugswap( struct bug *, struct bug *);
void expunge(struct bug *);
void addbrotherof(struct bug *);
void addbugtocolony(struct bug *, unsigned char);
void dressbugforcolony(struct bug *);
void newday(void);
void recruit(struct bug *, struct bug *);
//void adjusttraillength_3D(HDC, unsigned short, unsigned short);
//---------------------------CODE-------------------
void putbugsincolonies(unsigned char *newcolpop)
{
	//always call DNA_to_RNA for all the bugs after this
	// cause soem get their enzymes changed in enzymecopy.

	// I come in here with livebugcount set to
	// Colony[0].pop + Colony[1].pop + Colony[2].pop.
	//	I want to make:
	//	Colony[0].pop = newcolpop[0];
	//	Colony[1].pop = newcolpop[1];
	//	Colony[2].pop = newcolpop[2];
	// and reset livebugcount

	unsigned char i, j, newlivebugcount, empty = 1, toomany = 1;

	// If you isolated a bug with the cursor, then that isolated
	// mode is now over, as you have overridden it.
	if (isolatedflag)
		isolatedflag = 0;

	// Don't allow a request for too many bugs.
	while (toomany)
	{
		newlivebugcount = 0;
		for (i=0; i<MAXCOLONIES; i++)
			newlivebugcount += newcolpop[i];
		if (newlivebugcount > MAXBUGS)
			for (i=0; i<MAXCOLONIES; i++)
				newcolpop[i]--;
		else
			toomany = 0;
	}

	// Don't allow a request for no bugs.
	for (i=0; i<MAXCOLONIES; i++)
		if (newcolpop[i])
			empty = 0;
	if (empty)
		newcolpop[0] = 1;

	//If any existing pop is too high, expunge some bugs.
	for (j=0; j<MAXCOLONIES; j++)
		while (Colony[j].pop > newcolpop[j])
			expunge(Bug[Colony[j].rank[Colony[j].pop - 1]]);
		// end of the while.

	//If any existing pop is too low, induct some bugs.
	for (j=0; j<MAXCOLONIES; j++)
		while (Colony[j].pop < newcolpop[j])
		{
			if (Colony[j].pop) // Make new bug act like best bug
			{
				enzymecopy(Bug[Colony[j].rank[Colony[j].pop-1]],
				Bug[bugnum[livebugcount]]);
			}
			addbugtocolony(Bug[bugnum[livebugcount]], j);
		}
		// end of the while.

	// At this point we should have livebugcount = 
	// Colony[0].pop + Colony[1].pop + Colony[2].pop again.

	// Tidy up.
	updateglobalmetricflag(); // A crucial motiontype bug may have just
		// been added or deleted from the livebugs.
	//Fix the bugnumids
	for (i=0; i<MAXBUGS; i++)
		Bug[bugnum[i]]->bugnumid = i;
}

// changetrailcolors(bug) is to change the writecolorgene entries
// when bug changes its colonyid.  This is based on the fact that
// the strong_pal_index numbers are odd, and the weak_pal_index
// numbers are even.  If all you have done is change colony allegiance,
// this is faster than calling the full DNA_to_RNA.

void changetrailcolors(struct bug *bug)
{
	unsigned char i, j;

#ifndef MWC
	for (i=0; i<bug->states; i++)
	{
		bug->writecolorgene0[i] =
			( (bug->writecolorgene0[i] & 1) ?
				strong_pal_index[bug->colonyid] :
				weak_pal_index[bug->colonyid] );
		bug->writecolorgene1[i] =
			( (bug->writecolorgene1[i] & 1) ?
				strong_pal_index[bug->colonyid] :
				weak_pal_index[bug->colonyid] );
	}
#else
	for (i=0; i<bug->states; i++)
		for (j=0; j<CASECOUNT; j++)
		{
			bug->writecolorgene[ Pair[i][j] ] =
				( (bug->writecolorgene[ Pair[i][j] ] & 1) ?
					strong_pal_index[bug->colonyid] :
					weak_pal_index[bug->colonyid] );
		}
#endif MWC
	// Important to adjust these next two as well.
	bug->oldwritecolorindex = (bug->oldwritecolorindex & 1) ?
		strong_pal_index[bug->colonyid] :
		weak_pal_index[bug->colonyid];
	bug->writecolorindex = (bug->writecolorindex & 1) ?
		strong_pal_index[bug->colonyid] :
		weak_pal_index[bug->colonyid];
#ifdef BRIGHTMEET
	//Set the meetcolors by hand
	switch(bug->colonyid)
	{
		case 0:
			bug->jabbermeet = meetcolor02;
			bug->wockymeet = meetcolor01;
			break;
		case 1:
			bug->jabbermeet = meetcolor01;
			bug->wockymeet = meetcolor12;
			break;
		case 2:
			bug->jabbermeet = meetcolor12;
			bug->wockymeet = meetcolor02;
			break;
	}
#endif //BRIGHTMEET
}

void installbugeatvalue(void)
// We keep the bug to bug eat values in the global bugeatvalue
// array.  Each colony maintains some variable based on these.
// To make the DNA of differing colonies compatible, we single
// out the self case.  Also we treat jabber as the value 
// cyclically one lower, and wocky as the value one higher.
{
	Colony[0].jabbervalue = bugeatvalue[0][2];
	Colony[0].selfvalue = bugeatvalue[0][0];
	Colony[0].wockyvalue = bugeatvalue[0][1];
	Colony[1].jabbervalue = bugeatvalue[1][0];
	Colony[1].selfvalue = bugeatvalue[1][1];
	Colony[1].wockyvalue = bugeatvalue[1][2];
	Colony[2].jabbervalue = bugeatvalue[2][1];
	Colony[2].selfvalue = bugeatvalue[2][2];
	Colony[2].wockyvalue = bugeatvalue[2][0];
}

void changestates(struct bug *bug, unsigned char newstates)
{
#ifdef NEWDNA_STATE_CORRECT
	unsigned char i, j, k, n;
	HANDLE DNA_copy_handle;
	unsigned char FAR *DNA_copy;
#endif //NEWDNA_STATE_CORRECT

	// This may be called as an "install", even if bug->states is
	// already changed to newstates.

	// First clamp newstates range just to be on the safe side.
	if (newstates > MAXSTATES)
		newstates = MAXSTATES;
	if (newstates < 1)
		newstates = 1;

	if (newstates > bug->states) // Pick a brand new state if possible.
		bug->state = bug->states;
	else if (bug->state > newstates) // Or if old state invalid, retreat.
		bug->state = 0;
	// else don't change bug->state.

	if (newstates > bug->states) // Pick a brand new state if possible.
		bug->boidstate = bug->states;
	else if (bug->state > newstates) // Or if old state invalid, retreat.
		bug->boidstate = 0;
	// else don't change bug->boidstate.

#ifdef NEWDNA_STATE_CORRECT
	//Now make the DNA match
	DNA_copy_handle = GlobalAlloc(GMEM_MOVEABLE,
		bug->DNA_length);
	DNA_copy = (unsigned char FAR *)GlobalLock(
		DNA_copy_handle);
	for (i=0; i<bug->DNA_length; i++)
		DNA_copy[i] = bug->DNA[i];
	k=n=0; //k indexes old dna, n indexes new dna
	// If bug->states = newstates you don't do anything.
	if (bug->states > newstates)
		for (j=0; j<CASECOUNT; j++)
		{
			for (i=0; i<newstates; i++)
			{
				bug->DNA[n++] = DNA_copy[k++]; //dirgene
				bug->DNA[n++] = DNA_copy[k++]; //stategene
				bug->DNA[n++] = DNA_copy[k++]; //writecolorgene
			}
			k += bug->states - newstates; //skip unused old DNA
		}
	if (bug->states < newstates)
		for (j=0; j<CASECOUNT; j++)
		{
			for (i=0; i<bug->states; i++)
			{
				bug->DNA[n++] = DNA_copy[k++]; //dirgene
				bug->DNA[n++] = DNA_copy[k++]; //stategene
				bug->DNA[n++] = DNA_copy[k++]; //writecolorgene
			}
			n += newstates - bug->states; //shift old DNA to new spot.
		}
	GlobalUnlock(DNA_copy_handle);
	GlobalFree(DNA_copy_handle);
#endif //NEWDNA_STATE_CORRECT

	bug->states = newstates;

}

void installdirectiontype(struct bug *bug)
{
	// Always call DNA_to_RNA after this, as this is often used after
	// the states may have been changed.

	unsigned char three_d_directiontype;
	
	if (bug->directiontype >= DIRECTIONTYPES_2D )
		bug->directiontype = 0; // Clamp to be safe.
	if (three_d_flag)
	{
		three_d_directiontype = bug->directiontype;
		if ( three_d_directiontype >= DIRECTIONTYPES_3D )
			three_d_directiontype = 0;
		bug->directions = move3Ddirections[ three_d_directiontype ];
	}
	else
		bug->directions = move2Ddirections[ bug->directiontype ];
	// Make sure dir is valid
	bug->dir = MOD(bug->dir,bug->directions);
	if (!three_d_flag)
		switch (bug->directiontype)
		{
			case 0:
				bug->bugmovex = move2Dx0;
				bug->bugmovey = move2Dy0;
				break;
			case 1:
				bug->bugmovex = move2Dx1;
				bug->bugmovey = move2Dy1;
				break;
			case 2:
				bug->bugmovex = move2Dx2;
				bug->bugmovey = move2Dy2;
				break;
			case 3:
				bug->bugmovex = move2Dx3;
				bug->bugmovey = move2Dy3;
				break;
			case 4:
				bug->bugmovex = move2Dx4;
				bug->bugmovey = move2Dy4;
				break;
			case 5:
				bug->bugmovex = move2Dx5;
				bug->bugmovey = move2Dy5;
				break;
			case 6:
				bug->bugmovex = move2Dx6;
				bug->bugmovey = move2Dy6;
				break;
			case 7:
				bug->bugmovex = move2Dx7;
				bug->bugmovey = move2Dy7;
				break;
			case 8:
				bug->bugmovex = move2Dx8;
				bug->bugmovey = move2Dy8;
				break;
		} // End switch on 2D directiontype.
	else
		switch (three_d_directiontype)
		{
			case 0:
				bug->bugmovex = move3Dx0;
				bug->bugmovey = move3Dy0;
				bug->bugmovez = move3Dz0;
				break;
			case 1:
				bug->bugmovex = move3Dx1;
				bug->bugmovey = move3Dy1;
				bug->bugmovez = move3Dz1;
				break;
			case 2:
				bug->bugmovex = move3Dx2;
				bug->bugmovey = move3Dy2;
				bug->bugmovez = move3Dz2;
				break;
#ifdef MORE3D
			case 3:
				bug->bugmovex = move3Dx3;
				bug->bugmovey = move3Dy3;
				bug->bugmovez = move3Dz3;
				break;
			case 4:
				bug->bugmovex = move3Dx4;
				bug->bugmovey = move3Dy4;
				bug->bugmovez = move3Dz4;
			case 5:
				bug->bugmovex = move3Dx5;
				bug->bugmovey = move3Dy5;
				bug->bugmovez = move3Dz5;
				break;
#endif MORE3D
		} // End switch on 3D directiontype.

		// I could have skipped all this stuff before here in the case
		// (bug->motiontype == MOTION_BOID), by the way. Paranoia says
		// keep it!
}

void installmotiontype(struct bug *bug)
{

	switch (bug->motiontype)
	{
		case MOTION_TURMITE: //turmite
			if ( !three_d_flag )
			{
				bug->move = turmite2D;
				bug->wrap = wrap2D;
				bug->eat = eatapixel_2D;
			}
			else
			{
				bug->move = turmite3D;
				bug->wrap = wrap3D;
				bug->eat = eatapixel_3D;
			}
			bug->metric_flag = 0;
			break;
		case MOTION_BOID: //boid
			if ( !three_d_flag )
			{
				bug->move = boid2D;
				bug->wrap = wrap2D;
				bug->eat = eatapixel_2D;
			}
			else
			{
				bug->move = boid3D;
				bug->wrap = wrap3D;
				bug->eat = eatapixel_3D;
			}
			bug->metric_flag = 1;
			break;
		case MOTION_WOLF:
			if ( !three_d_flag )
			{
				bug->move = wolf2D;
				bug->wrap = wrap2D;
				bug->eat = eatapixel_2D;
			}
			else
			{
				bug->move = wolf3D;
				bug->wrap = wrap3D;
				bug->eat = eatapixel_3D;
			}
			bug->metric_flag = 1;
			break;
		case MOTION_BEAVER: //beaver
			if ( !three_d_flag )
			{
				bug->move = beaver2D;
				bug->wrap = wrap2D;
				bug->eat = eatapixel_2D;
			}
			else
			{
				bug->move = beaver3D;
				bug->wrap = wrap3D;
				bug->eat = eatapixel_3D;
			}
			bug->metric_flag = 1;
			break;
		case MOTION_DOG: //dog
			if ( !three_d_flag )
			{
				bug->move = dog2D;
				bug->wrap = wrap2D;
				bug->eat = eatapixel_2D;
			}
			else
			{
				bug->move = dog3D;
				bug->wrap = wrap3D;
				bug->eat = eatapixel_3D;
			}
			bug->metric_flag = 1;
			break;
		case MOTION_OWL: //owl
			if ( !three_d_flag )
			{
				bug->move = owl2D;
				bug->wrap = wrap2D;
				bug->eat = eatapixel_2D;
			}
			else
			{
				bug->move = owl3D;
				bug->wrap = wrap3D;
				bug->eat = eatapixel_3D;
			}
			bug->metric_flag = 1;
			break;
	}
	// override if bug is being carreid by CUR_CARRY
	if (cursormode == CUR_CARRY && carryflag && bug->bugid == editbugid)
	{
		if (three_d_flag)
			bug->move = carry3D;
		else
			bug->move = carry2D;
	}
	// adust the global signal of metric on or off.
	updateglobalmetricflag();

#ifdef REAL_POS
	// Get rid of any real delta deficits you were hoarding.
	bug->real_dx = bug->real_dy = bug->real_dz = 0.0;
#endif //REAL_POS

}

void adjustwrapparms(void)
{
	unsigned char i;

	if (wrapflag)
	{
		wrapminx = wrapminy = 0;
		wrapmaxx = BugLand_MAXX;
		wrapmaxy = BugLand_MAXY;
		wrapminz = 0;
		wrapmaxz = BugLand_MAXZ;

	}
	else
	{
		wrapminx = wrapminy = NON_WRAP_OFFSET;
		wrapmaxx = Screen_CX - NON_WRAP_OFFSET;
		wrapmaxy = Screen_CY - NON_WRAP_OFFSET;
		wrapminz = NON_WRAP_OFFSET;
#ifdef THIN
		wrapmaxz = 255 - NON_WRAP_OFFSET;
#else //not THIN
		wrapmaxz = Screen_CY - NON_WRAP_OFFSET;
#endif //not THIN
	}

	for (i=0; i<MAXBUGS; i++)
		{
			if (Bug[i]->x < wrapminx)
				Bug[i]->x = wrapminx;
			if (Bug[i]->x > wrapmaxx)
				Bug[i]->x = wrapmaxx;
			if (Bug[i]->y < wrapminy)
				Bug[i]->y = wrapminy;
			if (Bug[i]->y > wrapmaxy)
				Bug[i]->y = wrapmaxy;
			if (Bug[i]->z < wrapminz)
				Bug[i]->z = wrapminz;
			if (Bug[i]->z > wrapmaxz)
				Bug[i]->z = wrapmaxz;
		}
}


void near updateglobalmetricflag(void)
{
	unsigned char i;
	// globalmetricflag is 1 if anyone uses metric, else its 0.
	// Update it each time you change a motiontype of any bug,
	// or anytime you add or take away an active bug.
	globalmetricflag = 0; //assume everyone non-metric
	for (i=0; i<livebugcount; i++)
	{
		if (Bug[bugnum[i]]->metric_flag)
		{
			globalmetricflag = 1;
			break; // bail out of loop, you're done.
		}
	}
}

void bugswap(struct bug *abug, struct bug *bbug)
{
	unsigned char abugnum, bbugnum, i;

	// Get the num numbers
	for (i=0; i<MAXBUGS; i++)
		if (bugnum[i] == abug->bugid)
		{
			abugnum = i;
			break;
		}
	for (i=0; i<MAXBUGS; i++)
		if (bugnum[i] == bbug->bugid)
		{
			bbugnum = i;
			break;
		}
	bugnum[abugnum] = bbug->bugid;
	bugnum[bbugnum] = abug->bugid;
	bbug->bugnumid = abugnum;
	abug->bugnumid = bbugnum;
}

void expunge(struct bug *bug)
{
	unsigned char i, num, ranknum;


	// Get the bugnum number of the bug
	for (i=0; i<MAXBUGS; i++)
		if (bugnum[i] == bug->bugid)
		{
			num = i;
			break;
		}

	// To be cautious, let's include the possibility that this
	// is not a live bug.  In this case there's no expunging to be 
	// done and we should bail.
	if (num >= livebugcount)
		return;

	// Bubble this number out to "last place" livebugcount-1 in bugnum
	for (i=num; i<livebugcount-1; i++)
		bugnum[i] = bugnum[i+1];
	bugnum[livebugcount-1] = bug->bugid;
	// Reduce the livebugcount;
	livebugcount--;

	// If somehow I'm expunging a bug with colonyid >= MAXCOLONIES,
	// the next group of instructions will be disasterous.  So I
	// check that the colonyid is valid before entering.  It seems
	// the bad case could never happen, but in loading some *.BEX
	// files I've seen it happen, possibly only because those *.BEX
	// files were made when the program had a bug.  Or maybe things
	// get expunged twice sometimes.
	if (bug->colonyid < MAXCOLONIES)
	{
		// Alert the bug's colony.  First find the bug in the rank array.
		for (i=0; i<Colony[bug->colonyid].pop; i++)
			if (Colony[bug->colonyid].rank[i] == bug->bugid)
				ranknum = i;
		// Then move the last ranked bug into that slot.
		Colony[bug->colonyid].rank[ranknum] =
			Colony[bug->colonyid].rank[Colony[bug->colonyid].pop - 1];
		// Then reduce the pop.
		Colony[bug->colonyid].pop--;
	}

	if (!Colony[bug->colonyid].pop) // you killed em all
	// so you need to clear the screen to elimate that colony's trails.
		SendMessage(hwnd, WM_COMMAND, IDM_CLEAR, 0L);

	bug->colonyid = MAXCOLONIES; // To show it's a bug without a colony.

	// Correct the editbugid.
	if (bug->bugid == editbugid)
		editbugid = bugnum[0];
}

void addbrotherof(struct bug *bug)
{
	// if it's not an active bug or if no room, bail out.
	if (bug->bugid >= livebugcount || livebugcount == MAXBUGS)
		return;
	// Copy the bug's enzymes.
	enzymecopy(bug, Bug[bugnum[livebugcount]]);
	// Make the copy be in the same colony.
	addbugtocolony(Bug[bugnum[livebugcount]], bug->colonyid);
}

void addbugtocolony(struct bug *bug, unsigned char colonyid)
{
	// Make the copy be in the same colony.
	bug->colonyid = colonyid;
	// Say the new bug is the lowest ranked member of the colony.
	Colony[colonyid].rank[Colony[colonyid].pop] = bug->bugid;
	// Tell the colony it's grown.
	Colony[colonyid].pop++;
	// Give it a body
	bug->bodyid = (BODIES_PER_COLONY * colonyid) +
		Colony[colonyid].pop % (unsigned char)BODIES_PER_COLONY;
	// Adjust the writecolors.
	changetrailcolors(bug);
	// Set jabberid and wockyid
	if (colonyid == 0)
		bug->jabberid = MAXCOLONIES - 1;
	else
		bug->jabberid = colonyid - 1;
	if (colonyid == MAXCOLONIES - 1)
		bug->wockyid = 0;
	else
		bug->wockyid = colonyid + 1;
	livebugcount++;
}

void dressbugforcolony(struct bug *bug)
{
	unsigned char i, ranknum;

	if (bug->colonyid >= MAXCOLONIES)
		return; // bug not in a colony

	for (i=0; i<Colony[bug->colonyid].pop; i++)
		if (Colony[bug->colonyid].rank[i] == bug->bugid)
		{
			ranknum = i;
			break;
		}
	// Give it a body
	bug->bodyid = (BODIES_PER_COLONY * bug->colonyid) +
		ranknum % (unsigned char)BODIES_PER_COLONY;
	// Adjust the writecolors.
	changetrailcolors(bug);
	// Set jabberid and wockyid
	if (bug->colonyid == 0)
		bug->jabberid = MAXCOLONIES - 1;
	else
		bug->jabberid = bug->colonyid - 1;
	if (bug->colonyid == MAXCOLONIES - 1)
		bug->wockyid = 0;
	else
		bug->wockyid = bug->colonyid + 1;
}

void newday(void)
{
	unsigned char i;

	for (i=0; i<MAXCOLONIES; i++)
		day[i] = 0;
}


void recruit(struct bug *winner, struct bug *loser)
{
	unsigned char winid, loseid;

	winid = winner->colonyid;
	loseid = loser->colonyid;

	//adjust traillength of the loser and winner colonies.
	if (!three_d_flag) // Don't change traillengths in three d case
	{	// adjust traillength of loser
		if (colony_erasetrailflag[loseid])
		{
			colony_traillength[loseid] -=
				colony_traillength[loseid] / Colony[loseid].pop;
			if (colony_traillength[loseid] < 2 * Colony[loseid].pop)
				colony_traillength[loseid] = 2 * Colony[loseid].pop;
		}
		//adjust traillength of winner
		if (colony_erasetrailflag[winid])
		{
			colony_traillength[winid] +=
				colony_traillength[winid] / Colony[winid].pop;
			if (colony_traillength[winid] > COLONY_MAXTRAILLENGTH)
				colony_traillength[winid] = COLONY_MAXTRAILLENGTH;
		}
	}

	expunge(loser); //remove from its colony
	enzymecopy(winner, loser);
	//make it act like you.
	addbugtocolony(loser, winid);
	// recruit it to your colony!
	DNA_to_RNA(loser);
	// signal that a recruit happened, to use in move()
	// that you should clear.
	recruitflag = 1;
}

/* 
void adjusttraillength_3D(HDC hdc, unsigned short newlength,
	unsigned short oldlength)
{

	if (newlength > oldlength)
	{ // Do fresh nonerase save into the new slots.
		trailindex = oldlength;
		trailfull = 0;
		return;
	}
	// Otherwise we are shrinking the trail
	if (trailindex >= newlength)
	{
		trailfull = 1;
		trailindex = 0;
	}
		worldclearflag = 1; // For special use in world.c

}
*/
